/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlQueryRequest {
    private static final ObjectParser<SqlQueryRequest, Void> PARSER = SqlQueryRequest.objectParser(SqlQueryRequest::new);
    static final ParseField FIELD_MULTI_VALUE_LENIENCY = new ParseField("field_multi_value_leniency", new String[0]);
    private String cursor = "";
    private boolean fieldMultiValueLeniency = false;

    public SqlQueryRequest() {
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, QueryBuilder filter, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency) {
        super(query, params, filter, zoneId, fetchSize, requestTimeout, pageTimeout, requestInfo);
        this.cursor = cursor;
        this.fieldMultiValueLeniency = fieldMultiValueLeniency;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText(this.query()) && !Strings.hasText(this.cursor)) {
            validationException = ValidateActions.addValidationError("one of [query] or [cursor] is required", validationException);
        }
        return validationException;
    }

    public String cursor() {
        return this.cursor;
    }

    public SqlQueryRequest cursor(String cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor may not be null.");
        }
        this.cursor = cursor;
        return this;
    }

    public SqlQueryRequest fieldMultiValueLeniency(boolean leniency) {
        this.fieldMultiValueLeniency = leniency;
        return this;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public SqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
        this.fieldMultiValueLeniency = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
        out.writeBoolean(this.fieldMultiValueLeniency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.cursor, ((SqlQueryRequest)obj).cursor) && this.fieldMultiValueLeniency == ((SqlQueryRequest)obj).fieldMultiValueLeniency;
    }

    @Override
    public String getDescription() {
        return "SQL [" + this.query() + "][" + this.filter() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return new org.elasticsearch.xpack.sql.proto.SqlQueryRequest(this.query(), this.params(), this.zoneId(), this.fetchSize(), this.requestTimeout(), this.pageTimeout(), this.filter(), this.cursor(), this.requestInfo(), this.fieldMultiValueLeniency()).toXContent(builder, params);
    }

    public static SqlQueryRequest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(SqlQueryRequest::cursor, CURSOR);
        PARSER.declareBoolean(SqlQueryRequest::fieldMultiValueLeniency, FIELD_MULTI_VALUE_LENIENCY);
    }
}

