/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.CustomNormalizerProvider;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.SynonymGraphTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltAnalyzers;

public final class AnalysisRegistry
implements Closeable {
    public static final String INDEX_ANALYSIS_CHAR_FILTER = "index.analysis.char_filter";
    public static final String INDEX_ANALYSIS_FILTER = "index.analysis.filter";
    public static final String INDEX_ANALYSIS_TOKENIZER = "index.analysis.tokenizer";
    private final PrebuiltAnalysis prebuiltAnalysis;
    private final Map<String, Analyzer> cachedAnalyzer = new ConcurrentHashMap<String, Analyzer>();
    private final Environment environment;
    private final Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> charFilters;
    private final Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters;
    private final Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers;
    private final Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzers;
    private final Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> normalizers;

    public AnalysisRegistry(Environment environment, Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> charFilters, Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters, Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers, Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzers, Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> normalizers, Map<String, PreConfiguredCharFilter> preConfiguredCharFilters, Map<String, PreConfiguredTokenFilter> preConfiguredTokenFilters, Map<String, PreConfiguredTokenizer> preConfiguredTokenizers, Map<String, PreBuiltAnalyzerProviderFactory> preConfiguredAnalyzers) {
        this.environment = environment;
        this.charFilters = Collections.unmodifiableMap(charFilters);
        this.tokenFilters = Collections.unmodifiableMap(tokenFilters);
        this.tokenizers = Collections.unmodifiableMap(tokenizers);
        this.analyzers = Collections.unmodifiableMap(analyzers);
        this.normalizers = Collections.unmodifiableMap(normalizers);
        this.prebuiltAnalysis = new PrebuiltAnalysis(preConfiguredCharFilters, preConfiguredTokenFilters, preConfiguredTokenizers, preConfiguredAnalyzers);
    }

    public static Settings getSettingsFromIndexSettings(IndexSettings indexSettings, String groupName) {
        Settings settings = indexSettings.getSettings().getAsSettings(groupName);
        if (settings.isEmpty()) {
            settings = Settings.builder().put("index.version.created", indexSettings.getIndexVersionCreated()).build();
        }
        return settings;
    }

    public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerProvider(String tokenizer) {
        return this.tokenizers.getOrDefault(tokenizer, this.prebuiltAnalysis.getTokenizerFactory(tokenizer));
    }

    public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterProvider(String tokenFilter) {
        return this.tokenFilters.getOrDefault(tokenFilter, this.prebuiltAnalysis.getTokenFilterFactory(tokenFilter));
    }

    public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterProvider(String charFilter) {
        return this.charFilters.getOrDefault(charFilter, this.prebuiltAnalysis.getCharFilterFactory(charFilter));
    }

    public Analyzer getAnalyzer(String analyzer) throws IOException {
        AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> analyzerProvider = this.prebuiltAnalysis.getAnalyzerProvider(analyzer);
        if (analyzerProvider == null) {
            AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> provider = this.analyzers.get(analyzer);
            return provider == null ? null : this.cachedAnalyzer.computeIfAbsent(analyzer, key -> {
                try {
                    return ((AnalyzerProvider)provider.get(this.environment, (String)key)).get();
                }
                catch (IOException ex) {
                    throw new ElasticsearchException("failed to load analyzer for name " + key, (Throwable)ex, new Object[0]);
                }
            });
        }
        if ("standard_html_strip".equals(analyzer)) {
            Logger logger = LogManager.getLogger(this.getClass());
            DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
            deprecationLogger.deprecated("[standard_html_strip] analyzer is deprecated, use a custom analyzer using [standard] tokenizer and [html_strip] char_filter, plus [lowercase] filter", new Object[0]);
        }
        return analyzerProvider.get(this.environment, analyzer).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.prebuiltAnalysis.close();
        }
        finally {
            IOUtils.close(this.cachedAnalyzer.values());
        }
    }

    public IndexAnalyzers build(IndexSettings indexSettings) throws IOException {
        Map<String, CharFilterFactory> charFilterFactories = this.buildCharFilterFactories(indexSettings);
        Map<String, TokenizerFactory> tokenizerFactories = this.buildTokenizerFactories(indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = this.buildTokenFilterFactories(indexSettings);
        Map<String, AnalyzerProvider<?>> analyzierFactories = this.buildAnalyzerFactories(indexSettings);
        Map<String, AnalyzerProvider<?>> normalizerFactories = this.buildNormalizerFactories(indexSettings);
        return this.build(indexSettings, analyzierFactories, normalizerFactories, tokenizerFactories, charFilterFactories, tokenFilterFactories);
    }

    public Map<String, TokenFilterFactory> buildTokenFilterFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> tokenFiltersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_FILTER);
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>(this.tokenFilters);
        tokenFilters.put("synonym", AnalysisRegistry.requiresAnalysisSettings((is, env, name, settings) -> new SynonymTokenFilterFactory(is, env, this, name, settings)));
        tokenFilters.put("synonym_graph", AnalysisRegistry.requiresAnalysisSettings((is, env, name, settings) -> new SynonymGraphTokenFilterFactory(is, env, this, name, settings)));
        return this.buildMapping(Component.FILTER, indexSettings, tokenFiltersSettings, Collections.unmodifiableMap(tokenFilters), this.prebuiltAnalysis.preConfiguredTokenFilters);
    }

    public Map<String, TokenizerFactory> buildTokenizerFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> tokenizersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_TOKENIZER);
        return this.buildMapping(Component.TOKENIZER, indexSettings, tokenizersSettings, this.tokenizers, this.prebuiltAnalysis.preConfiguredTokenizers);
    }

    public Map<String, CharFilterFactory> buildCharFilterFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> charFiltersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_CHAR_FILTER);
        return this.buildMapping(Component.CHAR_FILTER, indexSettings, charFiltersSettings, this.charFilters, this.prebuiltAnalysis.preConfiguredCharFilterFactories);
    }

    public Map<String, AnalyzerProvider<?>> buildAnalyzerFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> analyzersSettings = indexSettings.getSettings().getGroups("index.analysis.analyzer");
        return this.buildMapping(Component.ANALYZER, indexSettings, analyzersSettings, this.analyzers, this.prebuiltAnalysis.analyzerProviderFactories);
    }

    public Map<String, AnalyzerProvider<?>> buildNormalizerFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> noralizersSettings = indexSettings.getSettings().getGroups("index.analysis.normalizer");
        return this.buildMapping(Component.NORMALIZER, indexSettings, noralizersSettings, this.normalizers, Collections.emptyMap());
    }

    public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerProvider(String tokenizer, IndexSettings indexSettings) {
        Map<String, Settings> tokenizerSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_TOKENIZER);
        if (tokenizerSettings.containsKey(tokenizer)) {
            Settings currentSettings = tokenizerSettings.get(tokenizer);
            return this.getAnalysisProvider(Component.TOKENIZER, this.tokenizers, tokenizer, currentSettings.get("type"));
        }
        return this.getTokenizerProvider(tokenizer);
    }

    public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterProvider(String tokenFilter, IndexSettings indexSettings) {
        Map<String, Settings> tokenFilterSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_FILTER);
        if (tokenFilterSettings.containsKey(tokenFilter)) {
            Settings currentSettings = tokenFilterSettings.get(tokenFilter);
            String typeName = currentSettings.get("type");
            if ("synonym".equals(typeName)) {
                return AnalysisRegistry.requiresAnalysisSettings((is, env, name, settings) -> new SynonymTokenFilterFactory(is, env, this, name, settings));
            }
            if ("synonym_graph".equals(typeName)) {
                return AnalysisRegistry.requiresAnalysisSettings((is, env, name, settings) -> new SynonymGraphTokenFilterFactory(is, env, this, name, settings));
            }
            return this.getAnalysisProvider(Component.FILTER, this.tokenFilters, tokenFilter, typeName);
        }
        return this.getTokenFilterProvider(tokenFilter);
    }

    public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterProvider(String charFilter, IndexSettings indexSettings) {
        Map<String, Settings> tokenFilterSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_CHAR_FILTER);
        if (tokenFilterSettings.containsKey(charFilter)) {
            Settings currentSettings = tokenFilterSettings.get(charFilter);
            return this.getAnalysisProvider(Component.CHAR_FILTER, this.charFilters, charFilter, currentSettings.get("type"));
        }
        return this.getCharFilterProvider(charFilter);
    }

    private static <T> AnalysisModule.AnalysisProvider<T> requiresAnalysisSettings(final AnalysisModule.AnalysisProvider<T> provider) {
        return new AnalysisModule.AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> Map<String, T> buildMapping(Component component, IndexSettings settings, Map<String, Settings> settingsMap, Map<String, ? extends AnalysisModule.AnalysisProvider<T>> providerMap, Map<String, ? extends AnalysisModule.AnalysisProvider<T>> defaultInstance) throws IOException {
        AnalysisModule.AnalysisProvider provider;
        String name;
        Settings defaultSettings = Settings.builder().put("index.version.created", settings.getIndexVersionCreated()).build();
        HashMap<String, Object> factories = new HashMap<String, Object>();
        for (Map.Entry<String, Settings> entry : settingsMap.entrySet()) {
            AnalysisModule.AnalysisProvider<T> analysisProvider;
            name = entry.getKey();
            Settings currentSettings = entry.getValue();
            String typeName = currentSettings.get("type");
            if (component == Component.ANALYZER) {
                void var13_21;
                Object var13_18 = null;
                if (typeName == null) {
                    if (currentSettings.get("tokenizer") == null) throw new IllegalArgumentException((Object)((Object)component) + " [" + name + "] must specify either an analyzer type, or a tokenizer");
                    CustomAnalyzerProvider customAnalyzerProvider = new CustomAnalyzerProvider(settings, name, currentSettings, this.environment);
                } else if (typeName.equals("custom")) {
                    CustomAnalyzerProvider customAnalyzerProvider = new CustomAnalyzerProvider(settings, name, currentSettings, this.environment);
                }
                if (var13_21 != null) {
                    factories.put(name, var13_21);
                    continue;
                }
            } else if (component == Component.NORMALIZER && (typeName == null || typeName.equals("custom"))) {
                CustomNormalizerProvider customNormalizerProvider = new CustomNormalizerProvider(settings, name, currentSettings);
                factories.put(name, customNormalizerProvider);
                continue;
            }
            if ((analysisProvider = this.getAnalysisProvider(component, providerMap, name, typeName)) == null) {
                throw new IllegalArgumentException("Unknown " + (Object)((Object)component) + " type [" + typeName + "] for [" + name + "]");
            }
            T factory = analysisProvider.get(settings, this.environment, name, currentSettings);
            factories.put(name, factory);
        }
        for (Map.Entry<String, Object> entry : providerMap.entrySet()) {
            void var13_27;
            name = entry.getKey();
            provider = (AnalysisModule.AnalysisProvider)entry.getValue();
            if (settingsMap.containsKey(name) || provider.requiresAnalysisSettings()) continue;
            AnalysisModule.AnalysisProvider<T> defaultProvider = defaultInstance.get(name);
            if (defaultProvider == null) {
                Object t = provider.get(settings, this.environment, name, defaultSettings);
            } else {
                T t = defaultProvider.get(settings, this.environment, name, defaultSettings);
            }
            factories.put(name, var13_27);
        }
        for (Map.Entry<String, Object> entry : defaultInstance.entrySet()) {
            name = entry.getKey();
            provider = (AnalysisModule.AnalysisProvider)entry.getValue();
            if (factories.containsKey(name)) continue;
            Object instance = provider.get(settings, this.environment, name, defaultSettings);
            if (factories.containsKey(name)) continue;
            factories.put(name, instance);
        }
        return factories;
    }

    private <T> AnalysisModule.AnalysisProvider<T> getAnalysisProvider(Component component, Map<String, ? extends AnalysisModule.AnalysisProvider<T>> providerMap, String name, String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException((Object)((Object)component) + " [" + name + "] must specify either an analyzer type, or a tokenizer");
        }
        AnalysisModule.AnalysisProvider<T> type = providerMap.get(typeName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown " + (Object)((Object)component) + " type [" + typeName + "] for [" + name + "]");
        }
        return type;
    }

    public IndexAnalyzers build(IndexSettings indexSettings, Map<String, AnalyzerProvider<?>> analyzerProviders, Map<String, AnalyzerProvider<?>> normalizerProviders, Map<String, TokenizerFactory> tokenizerFactoryFactories, Map<String, CharFilterFactory> charFilterFactoryFactories, Map<String, TokenFilterFactory> tokenFilterFactoryFactories) {
        NamedAnalyzer defaultAnalyzer;
        Index index = indexSettings.getIndex();
        analyzerProviders = new HashMap(analyzerProviders);
        Logger logger = LogManager.getLogger(this.getClass());
        DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
        HashMap<String, NamedAnalyzer> analyzerAliases = new HashMap<String, NamedAnalyzer>();
        HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
        HashMap<String, NamedAnalyzer> normalizers = new HashMap<String, NamedAnalyzer>();
        HashMap<String, NamedAnalyzer> whitespaceNormalizers = new HashMap<String, NamedAnalyzer>();
        for (Map.Entry<String, AnalyzerProvider<?>> entry : analyzerProviders.entrySet()) {
            this.processAnalyzerFactory(deprecationLogger, indexSettings, entry.getKey(), entry.getValue(), analyzerAliases, analyzers, tokenFilterFactoryFactories, charFilterFactoryFactories, tokenizerFactoryFactories);
        }
        for (Map.Entry<String, AnalyzerProvider<?>> entry : normalizerProviders.entrySet()) {
            this.processNormalizerFactory(entry.getKey(), entry.getValue(), normalizers, "keyword", tokenizerFactoryFactories.get("keyword"), tokenFilterFactoryFactories, charFilterFactoryFactories);
            this.processNormalizerFactory(entry.getKey(), entry.getValue(), whitespaceNormalizers, "whitespace", () -> new WhitespaceTokenizer(), tokenFilterFactoryFactories, charFilterFactoryFactories);
        }
        for (Map.Entry<String, AnalyzerProvider<Object>> entry : analyzerAliases.entrySet()) {
            String key = entry.getKey();
            if (analyzers.containsKey(key) && !("default".equals(key) || "default_search".equals(key) || "default_search_quoted".equals(key))) {
                throw new IllegalStateException("already registered analyzer with name: " + key);
            }
            NamedAnalyzer configured = (NamedAnalyzer)((Object)entry.getValue());
            analyzers.put(key, configured);
        }
        if (!analyzers.containsKey("default")) {
            this.processAnalyzerFactory(deprecationLogger, indexSettings, "default", new StandardAnalyzerProvider(indexSettings, null, "default", Settings.Builder.EMPTY_SETTINGS), analyzerAliases, analyzers, tokenFilterFactoryFactories, charFilterFactoryFactories, tokenizerFactoryFactories);
        }
        if (!analyzers.containsKey("default_search")) {
            analyzers.put("default_search", (NamedAnalyzer)analyzers.get("default"));
        }
        if (!analyzers.containsKey("default_search_quoted")) {
            analyzers.put("default_search_quoted", (NamedAnalyzer)analyzers.get("default_search"));
        }
        if ((defaultAnalyzer = (NamedAnalyzer)analyzers.get("default")) == null) {
            throw new IllegalArgumentException("no default analyzer configured");
        }
        if (analyzers.containsKey("default_index")) {
            Version version = indexSettings.getIndexVersionCreated();
            if (version.onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("setting [index.analysis.analyzer.default_index] is not supported anymore, use [index.analysis.analyzer.default] instead for index [" + index.getName() + "]");
            }
            deprecationLogger.deprecated("setting [index.analysis.analyzer.default_index] is deprecated, use [index.analysis.analyzer.default] instead for index [{}]", index.getName());
        }
        NamedAnalyzer namedAnalyzer = analyzers.containsKey("default_index") ? (NamedAnalyzer)analyzers.get("default_index") : defaultAnalyzer;
        NamedAnalyzer defaultSearchAnalyzer = analyzers.containsKey("default_search") ? (NamedAnalyzer)analyzers.get("default_search") : defaultAnalyzer;
        NamedAnalyzer defaultSearchQuoteAnalyzer = analyzers.containsKey("default_search_quote") ? (NamedAnalyzer)analyzers.get("default_search_quote") : defaultSearchAnalyzer;
        for (Map.Entry analyzer : analyzers.entrySet()) {
            if (!((String)analyzer.getKey()).startsWith("_")) continue;
            throw new IllegalArgumentException("analyzer name must not start with '_'. got \"" + (String)analyzer.getKey() + "\"");
        }
        return new IndexAnalyzers(indexSettings, namedAnalyzer, defaultSearchAnalyzer, defaultSearchQuoteAnalyzer, Collections.unmodifiableMap(analyzers), Collections.unmodifiableMap(normalizers), Collections.unmodifiableMap(whitespaceNormalizers));
    }

    private void processAnalyzerFactory(DeprecationLogger deprecationLogger, IndexSettings indexSettings, String name, AnalyzerProvider<?> analyzerFactory, Map<String, NamedAnalyzer> analyzerAliases, Map<String, NamedAnalyzer> analyzers, Map<String, TokenFilterFactory> tokenFilters, Map<String, CharFilterFactory> charFilters, Map<String, TokenizerFactory> tokenizers) {
        NamedAnalyzer analyzer;
        Object analyzerF;
        int overridePositionIncrementGap = 100;
        if (analyzerFactory instanceof CustomAnalyzerProvider) {
            ((CustomAnalyzerProvider)analyzerFactory).build(tokenizers, charFilters, tokenFilters);
            overridePositionIncrementGap = Integer.MIN_VALUE;
        }
        if ((analyzerF = analyzerFactory.get()) == null) {
            throw new IllegalArgumentException("analyzer [" + analyzerFactory.name() + "] created null analyzer");
        }
        if (analyzerF instanceof NamedAnalyzer) {
            analyzer = (NamedAnalyzer)analyzerF;
            if (overridePositionIncrementGap >= 0 && analyzer.getPositionIncrementGap(analyzer.name()) != overridePositionIncrementGap) {
                analyzer = new NamedAnalyzer(analyzer, overridePositionIncrementGap);
            }
        } else {
            analyzer = new NamedAnalyzer(name, analyzerFactory.scope(), (Analyzer)analyzerF, overridePositionIncrementGap);
        }
        if (analyzers.containsKey(name)) {
            throw new IllegalStateException("already registered analyzer with name: " + name);
        }
        analyzers.put(name, analyzer);
        String analyzerAliasKey = "index.analysis.analyzer." + analyzerFactory.name() + ".alias";
        if (indexSettings.getSettings().get(analyzerAliasKey) != null) {
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_beta1)) {
                throw new IllegalArgumentException("setting [" + analyzerAliasKey + "] is not supported");
            }
            deprecationLogger.deprecated("setting [{}] is only allowed on index [{}] because it was created before 5.x; analyzer aliases can no longer be created on new indices.", analyzerAliasKey, indexSettings.getIndex().getName());
            HashSet<String> aliases = Sets.newHashSet(indexSettings.getSettings().getAsList(analyzerAliasKey));
            for (String alias : aliases) {
                if (analyzerAliases.putIfAbsent(alias, analyzer) == null) continue;
                throw new IllegalStateException("alias [" + alias + "] is already used by [" + analyzerAliases.get(alias).name() + "]");
            }
        }
    }

    private void processNormalizerFactory(String name, AnalyzerProvider<?> normalizerFactory, Map<String, NamedAnalyzer> normalizers, String tokenizerName, TokenizerFactory tokenizerFactory, Map<String, TokenFilterFactory> tokenFilters, Map<String, CharFilterFactory> charFilters) {
        Object normalizerF;
        if (tokenizerFactory == null) {
            throw new IllegalStateException("keyword tokenizer factory is null, normalizers require analysis-common module");
        }
        if (normalizerFactory instanceof CustomNormalizerProvider) {
            ((CustomNormalizerProvider)normalizerFactory).build(tokenizerName, tokenizerFactory, charFilters, tokenFilters);
        }
        if ((normalizerF = normalizerFactory.get()) == null) {
            throw new IllegalArgumentException("normalizer [" + normalizerFactory.name() + "] created null normalizer");
        }
        NamedAnalyzer normalizer = new NamedAnalyzer(name, normalizerFactory.scope(), (Analyzer)normalizerF);
        if (normalizers.containsKey(name)) {
            throw new IllegalStateException("already registered analyzer with name: " + name);
        }
        normalizers.put(name, normalizer);
    }

    private static class PrebuiltAnalysis
    implements Closeable {
        final Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzerProviderFactories;
        final Map<String, ? extends AnalysisModule.AnalysisProvider<TokenFilterFactory>> preConfiguredTokenFilters;
        final Map<String, ? extends AnalysisModule.AnalysisProvider<TokenizerFactory>> preConfiguredTokenizers;
        final Map<String, ? extends AnalysisModule.AnalysisProvider<CharFilterFactory>> preConfiguredCharFilterFactories;

        private PrebuiltAnalysis(Map<String, PreConfiguredCharFilter> preConfiguredCharFilters, Map<String, PreConfiguredTokenFilter> preConfiguredTokenFilters, Map<String, PreConfiguredTokenizer> preConfiguredTokenizers, Map<String, PreBuiltAnalyzerProviderFactory> preConfiguredAnalyzers) {
            HashMap<String, PreBuiltAnalyzerProviderFactory> analyzerProviderFactories = new HashMap<String, PreBuiltAnalyzerProviderFactory>();
            analyzerProviderFactories.putAll(preConfiguredAnalyzers);
            for (PreBuiltAnalyzers preBuiltAnalyzerEnum : PreBuiltAnalyzers.values()) {
                String name = preBuiltAnalyzerEnum.name().toLowerCase(Locale.ROOT);
                analyzerProviderFactories.put(name, new PreBuiltAnalyzerProviderFactory(name, preBuiltAnalyzerEnum));
            }
            this.analyzerProviderFactories = Collections.unmodifiableMap(analyzerProviderFactories);
            this.preConfiguredCharFilterFactories = preConfiguredCharFilters;
            this.preConfiguredTokenFilters = preConfiguredTokenFilters;
            this.preConfiguredTokenizers = preConfiguredTokenizers;
        }

        public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterFactory(String name) {
            return this.preConfiguredCharFilterFactories.get(name);
        }

        public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterFactory(String name) {
            return this.preConfiguredTokenFilters.get(name);
        }

        public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerFactory(String name) {
            return this.preConfiguredTokenizers.get(name);
        }

        public AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> getAnalyzerProvider(String name) {
            return this.analyzerProviderFactories.get(name);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.analyzerProviderFactories.values().stream().map(a -> (PreBuiltAnalyzerProviderFactory)a).collect(Collectors.toList()));
        }
    }

    static enum Component {
        ANALYZER{

            public String toString() {
                return "analyzer";
            }
        }
        ,
        NORMALIZER{

            public String toString() {
                return "normalizer";
            }
        }
        ,
        CHAR_FILTER{

            public String toString() {
                return "char_filter";
            }
        }
        ,
        TOKENIZER{

            public String toString() {
                return "tokenizer";
            }
        }
        ,
        FILTER{

            public String toString() {
                return "filter";
            }
        };

    }
}

