/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DeprecationIssue
implements Writeable,
ToXContentObject {
    private Level level;
    private String message;
    private String url;
    private String details;

    DeprecationIssue() {
    }

    public DeprecationIssue(Level level, String message, String url, @Nullable String details) {
        this.level = level;
        this.message = message;
        this.url = url;
        this.details = details;
    }

    public DeprecationIssue(StreamInput in) throws IOException {
        this.level = Level.readFromStream(in);
        this.message = in.readString();
        this.url = in.readString();
        this.details = in.readOptionalString();
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDetails() {
        return this.details;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.level.writeTo(out);
        out.writeString(this.message);
        out.writeString(this.url);
        out.writeOptionalString(this.details);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("level", (Object)this.level).field("message", this.message).field("url", this.url);
        if (this.details != null) {
            builder.field("details", this.details);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeprecationIssue that = (DeprecationIssue)o;
        return Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.message, that.message) && Objects.equals(this.url, that.url) && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.message, this.url, this.details});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static enum Level implements Writeable
    {
        WARNING,
        CRITICAL;


        public static Level fromString(String value) {
            return Level.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Level readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= Level.values().length) {
                throw new IOException("Unknown Level ordinal [" + ordinal + "]");
            }
            return Level.values()[ordinal];
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

