/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class TransportPersistJobAction
extends TransportJobTaskAction<PersistJobAction.Request, PersistJobAction.Response> {
    @Inject
    public TransportPersistJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager) {
        super(settings, "cluster:admin/xpack/ml/job/persist", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, PersistJobAction.Request::new, PersistJobAction.Response::new, "same", processManager);
    }

    protected PersistJobAction.Response readTaskResponse(StreamInput in) throws IOException {
        PersistJobAction.Response response = new PersistJobAction.Response();
        response.readFrom(in);
        return response;
    }

    protected void taskOperation(PersistJobAction.Request request, TransportOpenJobAction.JobTask task, ActionListener<PersistJobAction.Response> listener) {
        this.processManager.persistJob(task, e -> {
            if (e == null) {
                listener.onResponse((Object)new PersistJobAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        });
    }

    @Override
    protected void doExecute(Task task, PersistJobAction.Request request, ActionListener<PersistJobAction.Response> listener) {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetaData)tasks);
        if (jobTask == null || jobTask.getExecutorNode() == null) {
            this.logger.debug("[{}] Cannot persist the job because the job is not open", (Object)request.getJobId());
            listener.onResponse((Object)new PersistJobAction.Response(false));
            return;
        }
        DiscoveryNode executorNode = nodes.get(jobTask.getExecutorNode());
        if (executorNode == null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot persist job [{}] asexecutor node [{}] cannot be found", (Object[])new Object[]{request.getJobId(), jobTask.getExecutorNode()})));
            return;
        }
        Version nodeVersion = executorNode.getVersion();
        if (nodeVersion.before(Version.V_6_3_0)) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot persist job [" + request.getJobId() + "] on node with version " + nodeVersion, new Object[0]));
            return;
        }
        super.doExecute(task, request, listener);
    }
}

