/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.notifications.AuditMessage;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.ml.InvalidLicenseEnforcer;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.MlInitializationService;
import org.elasticsearch.xpack.ml.MlLifeCycleService;
import org.elasticsearch.xpack.ml.action.TransportCloseJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteFilterAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteForecastAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportFinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.TransportFindFileStructureAction;
import org.elasticsearch.xpack.ml.action.TransportFlushJobAction;
import org.elasticsearch.xpack.ml.action.TransportForecastJobAction;
import org.elasticsearch.xpack.ml.action.TransportGetBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCategoriesAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetFiltersAction;
import org.elasticsearch.xpack.ml.action.TransportGetInfluencersAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.action.TransportGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetRecordsAction;
import org.elasticsearch.xpack.ml.action.TransportIsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportKillProcessAction;
import org.elasticsearch.xpack.ml.action.TransportMlInfoAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportPersistJobAction;
import org.elasticsearch.xpack.ml.action.TransportPostCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportPostDataAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportPutDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutFilterAction;
import org.elasticsearch.xpack.ml.action.TransportPutJobAction;
import org.elasticsearch.xpack.ml.action.TransportRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStopDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateFilterAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportValidateDetectorAction;
import org.elasticsearch.xpack.ml.action.TransportValidateJobConfigAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizer;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizerFactory;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.BlackHoleAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.MultiplyingNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.rest.RestDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.rest.RestFindFileStructureAction;
import org.elasticsearch.xpack.ml.rest.RestMlInfoAction;
import org.elasticsearch.xpack.ml.rest.RestSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPostCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedStatsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPutDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStartDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStopDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.rest.filter.RestDeleteFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestGetFiltersAction;
import org.elasticsearch.xpack.ml.rest.filter.RestPutFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestUpdateFilterAction;
import org.elasticsearch.xpack.ml.rest.job.RestCloseJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteForecastAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestFlushJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestForecastJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobStatsAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobsAction;
import org.elasticsearch.xpack.ml.rest.job.RestOpenJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostDataAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostJobUpdateAction;
import org.elasticsearch.xpack.ml.rest.job.RestPutJobAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetCategoriesAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetInfluencersAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetRecordsAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateDetectorAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateJobConfigAction;

public class MachineLearning
extends Plugin
implements ActionPlugin,
AnalysisPlugin,
PersistentTaskPlugin {
    public static final String NAME = "ml";
    public static final String V7_BASE_PATH = "/_ml/";
    public static final String BASE_PATH = "/_xpack/ml/";
    public static final String DATAFEED_THREAD_POOL_NAME = "ml_datafeed";
    public static final String AUTODETECT_THREAD_POOL_NAME = "ml_autodetect";
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    public static final boolean CATEGORIZATION_TOKENIZATION_IN_JAVA = true;
    public static final Setting<Boolean> ML_ENABLED = Setting.boolSetting((String)"node.ml", (Setting)XPackSettings.MACHINE_LEARNING_ENABLED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String ML_ENABLED_NODE_ATTR = "ml.enabled";
    public static final String MAX_OPEN_JOBS_NODE_ATTR = "ml.max_open_jobs";
    public static final String MACHINE_MEMORY_NODE_ATTR = "ml.machine_memory";
    public static final Setting<Integer> CONCURRENT_JOB_ALLOCATIONS = Setting.intSetting((String)"xpack.ml.node_concurrent_job_allocations", (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> MAX_MACHINE_MEMORY_PERCENT = Setting.intSetting((String)"xpack.ml.max_machine_memory_percent", (int)30, (int)5, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> MAX_LAZY_ML_NODES = Setting.intSetting((String)"xpack.ml.max_lazy_ml_nodes", (int)0, (int)0, (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROCESS_CONNECT_TIMEOUT = Setting.timeSetting((String)"xpack.ml.process_connect_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(XPackPlugin.class);
    private final Settings settings;
    private final Environment env;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final boolean tribeNode;
    private final boolean tribeNodeClient;
    private final SetOnce<AutodetectProcessManager> autodetectProcessManager = new SetOnce();
    private final SetOnce<DatafeedManager> datafeedManager = new SetOnce();
    private final SetOnce<MlMemoryTracker> memoryTracker = new SetOnce();

    public MachineLearning(Settings settings, Path configPath) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
        this.env = this.transportClientMode ? null : new Environment(settings, configPath);
        this.tribeNode = XPackClientActionPlugin.isTribeNode((Settings)settings);
        this.tribeNodeClient = XPackClientActionPlugin.isTribeClientNode((Settings)settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(MachineLearningField.AUTODETECT_PROCESS, PROCESS_CONNECT_TIMEOUT, ML_ENABLED, CONCURRENT_JOB_ALLOCATIONS, MachineLearningField.MAX_MODEL_MEMORY_LIMIT, MAX_LAZY_ML_NODES, MAX_MACHINE_MEMORY_PERCENT, AutodetectBuilder.DONT_PERSIST_MODEL_STATE_SETTING, AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING, AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC, AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE, AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE, AutodetectProcessManager.MIN_DISK_SPACE_OFF_HEAP, MlConfigMigrationEligibilityCheck.ENABLE_CONFIG_MIGRATION));
    }

    public Settings additionalSettings() {
        String mlEnabledNodeAttrName = "node.attr.ml.enabled";
        String maxOpenJobsPerNodeNodeAttrName = "node.attr.ml.max_open_jobs";
        String machineMemoryAttrName = "node.attr.ml.machine_memory";
        if (!this.enabled || this.transportClientMode || this.tribeNode || this.tribeNodeClient) {
            this.disallowMlNodeAttributes(mlEnabledNodeAttrName, maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName);
            return Settings.EMPTY;
        }
        Settings.Builder additionalSettings = Settings.builder();
        Boolean allocationEnabled = (Boolean)ML_ENABLED.get(this.settings);
        if (allocationEnabled != null && allocationEnabled.booleanValue()) {
            this.addMlNodeAttribute(additionalSettings, mlEnabledNodeAttrName, "true");
            this.addMlNodeAttribute(additionalSettings, maxOpenJobsPerNodeNodeAttrName, String.valueOf(AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.get(this.settings)));
            this.addMlNodeAttribute(additionalSettings, machineMemoryAttrName, Long.toString(MachineLearning.machineMemoryFromStats(OsProbe.getInstance().osStats())));
        } else {
            this.disallowMlNodeAttributes(mlEnabledNodeAttrName, maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName);
        }
        return additionalSettings.build();
    }

    private void addMlNodeAttribute(Settings.Builder additionalSettings, String attrName, String value) {
        String oldValue = this.settings.get(attrName);
        if (oldValue == null) {
            additionalSettings.put(attrName, value);
        } else {
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void disallowMlNodeAttributes(String ... mlNodeAttributes) {
        for (String attrName : mlNodeAttributes) {
            if (this.settings.get(attrName) == null) continue;
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void reportClashingNodeAttribute(String attrName) {
        throw new IllegalArgumentException("Directly setting [" + attrName + "] is not permitted - it is reserved for machine learning. If your intention was to customize machine learning, set the [" + attrName.replace("node.attr.", "xpack.") + "] setting instead.");
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        NormalizerProcessFactory normalizerProcessFactory;
        AutodetectProcessFactory autodetectProcessFactory;
        if (!this.enabled || this.transportClientMode || this.tribeNode || this.tribeNodeClient) {
            return Collections.singletonList(new JobManagerHolder());
        }
        Auditor auditor = new Auditor(client, clusterService.getNodeName());
        JobResultsProvider jobResultsProvider = new JobResultsProvider(client, this.settings);
        JobConfigProvider jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        DatafeedConfigProvider datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        UpdateJobProcessNotifier notifier = new UpdateJobProcessNotifier(client, clusterService, threadPool);
        JobManager jobManager = new JobManager(this.env, this.settings, jobResultsProvider, clusterService, auditor, threadPool, client, notifier, xContentRegistry);
        JobManagerHolder jobManagerHolder = new JobManagerHolder(jobManager);
        JobDataCountsPersister jobDataCountsPersister = new JobDataCountsPersister(client);
        JobResultsPersister jobResultsPersister = new JobResultsPersister(client);
        if (((Boolean)MachineLearningField.AUTODETECT_PROCESS.get(this.settings)).booleanValue() && MachineLearningFeatureSet.isRunningOnMlPlatform(true)) {
            try {
                NativeController nativeController = NativeControllerHolder.getNativeController(environment);
                if (nativeController == null) {
                    throw new ElasticsearchException("Failed to create native process controller for Machine Learning", new Object[0]);
                }
                autodetectProcessFactory = new NativeAutodetectProcessFactory(environment, this.settings, nativeController, client, clusterService);
                normalizerProcessFactory = new NativeNormalizerProcessFactory(environment, nativeController, clusterService);
            }
            catch (IOException e) {
                logger.trace("Failed to connect to ML native controller", (Throwable)e);
                throw new ElasticsearchException("Failure running machine learning native code. This could be due to running on an unsupported OS or distribution, missing OS libraries, or a problem with the temp directory. To bypass this problem by running Elasticsearch without machine learning functionality set [" + XPackSettings.MACHINE_LEARNING_ENABLED.getKey() + ": false].", new Object[0]);
            }
        } else {
            autodetectProcessFactory = (job, autodetectParams, executorService, onProcessCrash) -> new BlackHoleAutodetectProcess(job.getId());
            normalizerProcessFactory = (jobId, quantilesState, bucketSpan, executorService) -> new MultiplyingNormalizerProcess(1.0);
        }
        NormalizerFactory normalizerFactory = new NormalizerFactory(normalizerProcessFactory, threadPool.executor(UTILITY_THREAD_POOL_NAME));
        AutodetectProcessManager autodetectProcessManager = new AutodetectProcessManager(this.env, this.settings, client, threadPool, jobManager, jobResultsProvider, jobResultsPersister, jobDataCountsPersister, autodetectProcessFactory, normalizerFactory, xContentRegistry, auditor, clusterService);
        this.autodetectProcessManager.set((Object)autodetectProcessManager);
        DatafeedJobBuilder datafeedJobBuilder = new DatafeedJobBuilder(client, this.settings, xContentRegistry, auditor, System::currentTimeMillis, clusterService.getNodeName());
        DatafeedManager datafeedManager = new DatafeedManager(threadPool, client, clusterService, datafeedJobBuilder, System::currentTimeMillis, auditor, autodetectProcessManager);
        this.datafeedManager.set((Object)datafeedManager);
        MlMemoryTracker memoryTracker = new MlMemoryTracker(this.settings, clusterService, threadPool, jobManager, jobResultsProvider);
        this.memoryTracker.set((Object)memoryTracker);
        MlLifeCycleService mlLifeCycleService = new MlLifeCycleService(environment, clusterService, datafeedManager, autodetectProcessManager, memoryTracker);
        InvalidLicenseEnforcer enforcer = new InvalidLicenseEnforcer(this.getLicenseState(), threadPool, datafeedManager, autodetectProcessManager);
        enforcer.listenForLicenseStateChanges();
        autodetectProcessManager.onNodeStartup();
        return Arrays.asList(new Object[]{mlLifeCycleService, jobResultsProvider, jobConfigProvider, datafeedConfigProvider, jobManager, jobManagerHolder, autodetectProcessManager, new MlInitializationService(this.settings, threadPool, clusterService, client), jobDataCountsPersister, datafeedManager, auditor, new MlAssignmentNotifier(this.settings, auditor, threadPool, client, clusterService), memoryTracker});
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule) {
        if (!this.enabled || this.transportClientMode || this.tribeNode || this.tribeNodeClient) {
            return Collections.emptyList();
        }
        return Arrays.asList(new PersistentTasksExecutor[]{new TransportOpenJobAction.OpenJobPersistentTasksExecutor(this.settings, clusterService, (AutodetectProcessManager)((Object)this.autodetectProcessManager.get()), (MlMemoryTracker)this.memoryTracker.get(), client), new TransportStartDatafeedAction.StartDatafeedPersistentTasksExecutor(this.settings, (DatafeedManager)this.datafeedManager.get())});
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.tribeNodeClient || this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, MachineLearningFeatureSet.class));
        return modules;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled || this.tribeNodeClient || this.tribeNode) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestGetJobsAction(settings, restController), new RestGetJobStatsAction(settings, restController), new RestMlInfoAction(settings, restController), new RestPutJobAction(settings, restController), new RestPostJobUpdateAction(settings, restController), new RestDeleteJobAction(settings, restController), new RestOpenJobAction(settings, restController), new RestGetFiltersAction(settings, restController), new RestPutFilterAction(settings, restController), new RestUpdateFilterAction(settings, restController), new RestDeleteFilterAction(settings, restController), new RestGetInfluencersAction(settings, restController), new RestGetRecordsAction(settings, restController), new RestGetBucketsAction(settings, restController), new RestGetOverallBucketsAction(settings, restController), new RestPostDataAction(settings, restController), new RestCloseJobAction(settings, restController), new RestFlushJobAction(settings, restController), new RestValidateDetectorAction(settings, restController), new RestValidateJobConfigAction(settings, restController), new RestGetCategoriesAction(settings, restController), new RestGetModelSnapshotsAction(settings, restController), new RestRevertModelSnapshotAction(settings, restController), new RestUpdateModelSnapshotAction(settings, restController), new RestGetDatafeedsAction(settings, restController), new RestGetDatafeedStatsAction(settings, restController), new RestPutDatafeedAction(settings, restController), new RestUpdateDatafeedAction(settings, restController), new RestDeleteDatafeedAction(settings, restController), new RestPreviewDatafeedAction(settings, restController), new RestStartDatafeedAction(settings, restController), new RestStopDatafeedAction(settings, restController), new RestDeleteModelSnapshotAction(settings, restController), new RestDeleteExpiredDataAction(settings, restController), new RestForecastJobAction(settings, restController), new RestDeleteForecastAction(settings, restController), new RestGetCalendarsAction(settings, restController), new RestPutCalendarAction(settings, restController), new RestDeleteCalendarAction(settings, restController), new RestDeleteCalendarEventAction(settings, restController), new RestDeleteCalendarJobAction(settings, restController), new RestPutCalendarJobAction(settings, restController), new RestGetCalendarEventsAction(settings, restController), new RestPostCalendarEventAction(settings, restController), new RestFindFileStructureAction(settings, restController), new RestSetUpgradeModeAction(settings, restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled || this.tribeNodeClient || this.tribeNode) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)GetJobsAction.INSTANCE, TransportGetJobsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetJobsStatsAction.INSTANCE, TransportGetJobsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)MlInfoAction.INSTANCE, TransportMlInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutJobAction.INSTANCE, TransportPutJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateJobAction.INSTANCE, TransportUpdateJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteJobAction.INSTANCE, TransportDeleteJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)OpenJobAction.INSTANCE, TransportOpenJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetFiltersAction.INSTANCE, TransportGetFiltersAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutFilterAction.INSTANCE, TransportPutFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateFilterAction.INSTANCE, TransportUpdateFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteFilterAction.INSTANCE, TransportDeleteFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)KillProcessAction.INSTANCE, TransportKillProcessAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetBucketsAction.INSTANCE, TransportGetBucketsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetInfluencersAction.INSTANCE, TransportGetInfluencersAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetOverallBucketsAction.INSTANCE, TransportGetOverallBucketsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetRecordsAction.INSTANCE, TransportGetRecordsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PostDataAction.INSTANCE, TransportPostDataAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)CloseJobAction.INSTANCE, TransportCloseJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)FinalizeJobExecutionAction.INSTANCE, TransportFinalizeJobExecutionAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)FlushJobAction.INSTANCE, TransportFlushJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ValidateDetectorAction.INSTANCE, TransportValidateDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ValidateJobConfigAction.INSTANCE, TransportValidateJobConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetCategoriesAction.INSTANCE, TransportGetCategoriesAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetModelSnapshotsAction.INSTANCE, TransportGetModelSnapshotsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)RevertModelSnapshotAction.INSTANCE, TransportRevertModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateModelSnapshotAction.INSTANCE, TransportUpdateModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetDatafeedsAction.INSTANCE, TransportGetDatafeedsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetDatafeedsStatsAction.INSTANCE, TransportGetDatafeedsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutDatafeedAction.INSTANCE, TransportPutDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateDatafeedAction.INSTANCE, TransportUpdateDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteDatafeedAction.INSTANCE, TransportDeleteDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PreviewDatafeedAction.INSTANCE, TransportPreviewDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)StartDatafeedAction.INSTANCE, TransportStartDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)StopDatafeedAction.INSTANCE, TransportStopDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)IsolateDatafeedAction.INSTANCE, TransportIsolateDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteModelSnapshotAction.INSTANCE, TransportDeleteModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateProcessAction.INSTANCE, TransportUpdateProcessAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteExpiredDataAction.INSTANCE, TransportDeleteExpiredDataAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ForecastJobAction.INSTANCE, TransportForecastJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteForecastAction.INSTANCE, TransportDeleteForecastAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetCalendarsAction.INSTANCE, TransportGetCalendarsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutCalendarAction.INSTANCE, TransportPutCalendarAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteCalendarAction.INSTANCE, TransportDeleteCalendarAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteCalendarEventAction.INSTANCE, TransportDeleteCalendarEventAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateCalendarJobAction.INSTANCE, TransportUpdateCalendarJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetCalendarEventsAction.INSTANCE, TransportGetCalendarEventsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PostCalendarEventsAction.INSTANCE, TransportPostCalendarEventsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PersistJobAction.INSTANCE, TransportPersistJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)FindFileStructureAction.INSTANCE, TransportFindFileStructureAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)SetUpgradeModeAction.INSTANCE, TransportSetUpgradeModeAction.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled || this.tribeNode || this.tribeNodeClient || this.transportClientMode) {
            return Collections.emptyList();
        }
        int maxNumberOfJobs = (Integer)AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.get(settings);
        FixedExecutorBuilder autoDetect = new FixedExecutorBuilder(settings, AUTODETECT_THREAD_POOL_NAME, maxNumberOfJobs * 4, maxNumberOfJobs * 4, "xpack.ml.autodetect_thread_pool");
        FixedExecutorBuilder renormalizer = new FixedExecutorBuilder(settings, UTILITY_THREAD_POOL_NAME, maxNumberOfJobs * 4, 500, "xpack.ml.utility_thread_pool");
        FixedExecutorBuilder datafeed = new FixedExecutorBuilder(settings, DATAFEED_THREAD_POOL_NAME, maxNumberOfJobs, 200, "xpack.ml.datafeed_thread_pool");
        return Arrays.asList(autoDetect, renormalizer, datafeed);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap(MlClassicTokenizer.NAME, MlClassicTokenizerFactory::new);
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            XContentBuilder docMapping;
            TimeValue delayedNodeTimeOutSetting = (Boolean)MachineLearningField.AUTODETECT_PROCESS.get(this.settings) != false ? (TimeValue)UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(this.settings) : TimeValue.timeValueNanos((long)0L);
            try (XContentBuilder auditMapping = ElasticsearchMappings.auditMessageMapping();){
                IndexTemplateMetaData notificationMessageTemplate = IndexTemplateMetaData.builder((String)".ml-notifications").putMapping(AuditMessage.TYPE.getPreferredName(), Strings.toString((XContentBuilder)auditMapping)).patterns(Collections.singletonList(".ml-notifications")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting)).build();
                templates.put(".ml-notifications", notificationMessageTemplate);
            }
            catch (IOException e) {
                logger.warn("Error loading the template for the notification message index", (Throwable)e);
            }
            try {
                docMapping = MlMetaIndex.docMapping();
                try {
                    IndexTemplateMetaData metaTemplate = IndexTemplateMetaData.builder((String)".ml-meta").patterns(Collections.singletonList(".ml-meta")).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting)).version(Integer.valueOf(Version.CURRENT.id)).putMapping("doc", Strings.toString((XContentBuilder)docMapping)).build();
                    templates.put(".ml-meta", metaTemplate);
                }
                finally {
                    if (docMapping != null) {
                        docMapping.close();
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Error loading the template for the .ml-meta index", (Throwable)e);
            }
            try (XContentBuilder configMapping = ElasticsearchMappings.configMapping();){
                IndexTemplateMetaData configTemplate = IndexTemplateMetaData.builder((String)AnomalyDetectorsIndex.configIndexName()).patterns(Collections.singletonList(AnomalyDetectorsIndex.configIndexName())).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting).put(IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey(), 10000)).version(Integer.valueOf(Version.CURRENT.id)).putMapping("doc", Strings.toString((XContentBuilder)configMapping)).build();
                templates.put(AnomalyDetectorsIndex.configIndexName(), configTemplate);
            }
            catch (IOException e) {
                logger.warn("Error loading the template for the " + AnomalyDetectorsIndex.configIndexName() + " index", (Throwable)e);
            }
            try (XContentBuilder stateMapping = ElasticsearchMappings.stateMapping();){
                IndexTemplateMetaData stateTemplate = IndexTemplateMetaData.builder((String)".ml-state").patterns(Collections.singletonList(AnomalyDetectorsIndex.jobStateIndexPattern())).settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting)).putMapping("doc", Strings.toString((XContentBuilder)stateMapping)).version(Integer.valueOf(Version.CURRENT.id)).build();
                templates.put(".ml-state", stateTemplate);
            }
            catch (IOException e) {
                logger.error("Error loading the template for the .ml-state index", (Throwable)e);
            }
            try {
                docMapping = ElasticsearchMappings.resultsMapping();
                try {
                    IndexTemplateMetaData jobResultsTemplate = IndexTemplateMetaData.builder((String)AnomalyDetectorsIndex.jobResultsIndexPrefix()).patterns(Collections.singletonList(AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*")).settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting).put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), "async").put(IndexSettings.DEFAULT_FIELD_SETTING.getKey(), "all_field_values")).putMapping("doc", Strings.toString((XContentBuilder)docMapping)).version(Integer.valueOf(Version.CURRENT.id)).build();
                    templates.put(AnomalyDetectorsIndex.jobResultsIndexPrefix(), jobResultsTemplate);
                }
                finally {
                    if (docMapping != null) {
                        docMapping.close();
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error loading the template for the " + AnomalyDetectorsIndex.jobResultsIndexPrefix() + " indices", (Throwable)e);
            }
            return templates;
        };
    }

    public static boolean allTemplatesInstalled(ClusterState clusterState) {
        boolean allPresent = true;
        List<String> templateNames = Arrays.asList(".ml-notifications", ".ml-meta", ".ml-state", AnomalyDetectorsIndex.jobResultsIndexPrefix(), AnomalyDetectorsIndex.configIndexName());
        for (String templateName : templateNames) {
            allPresent = allPresent && TemplateUtils.checkTemplateExistsAndVersionIsGTECurrentVersion((String)templateName, (ClusterState)clusterState);
        }
        return allPresent;
    }

    static long machineMemoryFromStats(OsStats stats) {
        BigInteger containerLimit;
        String containerLimitStr;
        long mem = stats.getMem().getTotal().getBytes();
        OsStats.Cgroup cgroup = stats.getCgroup();
        if (cgroup != null && (containerLimitStr = cgroup.getMemoryLimitInBytes()) != null && ((containerLimit = new BigInteger(containerLimitStr)).compareTo(BigInteger.valueOf(mem)) < 0 && containerLimit.compareTo(BigInteger.ZERO) > 0 || mem <= 0L && containerLimit.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0)) {
            mem = containerLimit.longValue();
        }
        return mem;
    }
}

