/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;

public class SamlToken
implements AuthenticationToken {
    private byte[] content;
    private final List<String> allowedSamlRequestIds;

    public SamlToken(byte[] content, List<String> allowedSamlRequestIds) {
        this.content = content;
        this.allowedSamlRequestIds = allowedSamlRequestIds;
    }

    public String principal() {
        return "<unauthenticated-saml-user>";
    }

    public Object credentials() {
        return this.content;
    }

    public void clearCredentials() {
        this.content = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public List<String> getAllowedSamlRequestIds() {
        return this.allowedSamlRequestIds;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + Strings.cleanTruncate((String)Hex.encodeHexString((byte[])this.content), (int)128) + "...}";
    }
}

