---
title: Concepts
url: /user-guide/concepts/
---


<!-- sonarqube -->
## Architecture
| Concept  | Definition                                                                            |
| -------- | ------------------------------------------------------------------------------------- |
| Analyzer | A client application that analyzes the source code to compute **snapshots**.          |
| Database | Stores configuration and **snapshots**                                                |
| Server   | Web interface that is used to browse **snapshot** data and make configuration changes | 

See also the [SonarQube Platform Overview](/architecture/architecture-integration/).
<!-- /sonarqube -->

## Quality
| Concept                    | Definition                                                                                                                                                                                                                                                                                                                                                                                                         |
| -------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Bug                        | An issue that represents something wrong in the code. If this has not broken yet, it will, and probably at the worst possible moment. This needs to be fixed. Yesterday.                                                                                                                                                                                                                                           |
| Code Smell                 | A maintainability-related issue in the code. Leaving it as-is means that at best maintainers will have a harder time than they should making changes to the code. At worst, they'll be so confused by the state of the code that they'll introduce additional errors as they make changes.                                                                                                                         |
| Cost                       | See Remediation Cost                                                                                                                                                                                                                                                                                                                                                                                               |
| Debt                       | See Technical Debt                                                                                                                                                                                                                                                                                                                                                                                                 |
| Issue                      | When a piece of code does not comply with a rule, an issue is logged on the **snapshot**. An issue can be logged on a source file or a unit test file. There are 3 types of issue: **Bugs**, **Code Smells** and **Vulnerabilities**                                                                                                                                                                    |
| Measure                    | The value of a **metric** for a given file or project at a given time. For example, 125 lines of code on class MyClass or density of duplicated lines of 30.5% on project myProject                                                                                                                                                                                                                                  |
| Metric                     | A type of measurement. Metrics can have varying values, or **measures**, over time. Examples: number of lines of code, complexity, etc. A metric may be either _qualitative_ (gives a quality indication on the component, E.G. density of duplicated lines, line coverage by tests, etc.) or _quantitative_ (does not give a quality indication on the component, E.G. number of lines of code, complexity, etc.) |
| New Code Period                | The period for which you're keeping a close watch on the introduction of new problems in the code. Ideally this is since the `previous_version`, but if you don't use a Maven-like versioning scheme you may need to set a relatively arbitrary time period such as 21 days or since a specific date.                                                                                                            |
| Quality Profile            | A set of **rules**. Each **snapshot** is based on a single quality profile. See also [Quality Profiles](/instance-administration/quality-profiles/)                                                                                                                                                                                                                                                         | 
| Rule                | A coding standard or practice which should be followed. Not complying with coding rules leads to **Bugs**, **Vulnerabilities**, **Security Hotspots**, and **Code Smells**. Rules can check quality on code files or unit tests.                                                                                                                                                                                                                                 |
| Remediation Cost           | The estimated time required to fix Vulnerability and Reliability Issues.                                                                                                                                                                                                                                                                                                                                           |
| Snapshot                   | A set of **measures** and **issues** on a given project at a given time. A snapshot is generated for each analysis.                                                                                                                                                                                                                                                                                          |
| Security Hotspot           | A security-related issue highlighting a piece of code that uses a security-sensitive API (E.G. use of a weak algorithm, connection to a database, ...). Security Hotspots must be manually reviewed to determine if the APIs are being used in ways that introduce Vulnerabilities.                                                                                               |
| Technical Debt             | The estimated time required to fix all Maintainability Issues / code smells                                                                                                                                                                                                                                                                                                                                        |
| Vulnerability              | A security-related issue which represents a backdoor for attackers. See also [Security-related rules](/user-guide/security-rules/).                                                                                                                                                                                                                                                                                |
