---
title: Documentation
url: /
---

<!-- sonarcloud -->

SonarCloud is the leading product for Continuous Code Quality online, totally free for open-source projects. It supports all major programming languages, including Java, C#, JavaScript, TypeScript, C/C++ and many more. If your code is closed source, SonarCloud also offers [a paid plan](/sonarcloud-pricing/) to run private analyses.

SonarCloud offers end-to-end integrations for teams leveraging the following solutions in their development processes:

* [GitHub.com](/integrations/github/)
* [Bitbucket Cloud](/integrations/bitbucketcloud/)
* [Azure DevOps Services](/integrations/vsts/)

Are you ready to eliminate bugs and vulnerabilities? Will you champion quality code in your projects?

<!-- /sonarcloud -->
<!-- static -->

[[info]]
| **Welcome to the new SonarQube documentation**  
| If you already have a SonarQube instance, you should be aware that we've made this documentation available within SonarQube itself (from v7.4). Just look under the "?" in the top menu to be sure you're always looking at the right documentation for _your_ version!
<!-- /static -->
<!-- sonarqube -->

[SonarQube](http://www.sonarqube.org/)® is an automatic code review tool to detect bugs, vulnerabilities and code smells in your code. It can integrate with your existing workflow to enable continuous code inspection across your project branches and pull requests.

Below are a few key pointers, otherwise head over to the left pane for full documentation content and search capabilities.

### I'm new to SonarQube
* Installing a [quick demo version](/setup/get-started-2-minutes/).
* Installing a [production instance](/setup/install-server/).

### I need to set up analysis
* [Analyzing Source Code](/analysis/overview/)
* [Branches](/branches/overview/)
* [Pull Requests](/analysis/pull-request/)

### I write code
* Why [new code](/user-guide/fixing-the-water-leak/) is the most important
* [Concepts](/user-guide/concepts/)
* [Quality Gates](/user-guide/quality-gates/)
* [Issues](/user-guide/issues/)

### I administer a project
* [Project Existence](/project-administration/project-existence/)
* What's [included, excluded](/project-administration/narrowing-the-focus/) from analysis 
* [Webhooks](/project-administration/webhooks/)
* [Project Settings](/project-administration/project-settings/)

### I administer a SonarQube Instance
* [Security](/instance-administration/security/)
* [Notifications](/instance-administration/notifications/)
* [Housekeeping](/instance-administration/housekeeping/)

### I do DevOps
* Installing a [production instance](/setup/install-server/).
* [Upgrading](/setup/upgrading/)
* [Monitoring](/instance-administration/monitoring/)
* [Running a Cluster](/setup/operate-cluster/)

### Stay in touch!
* [Get help in the community](https://www.sonarqube.org/community/)
* [Source code](https://github.com/SonarSource)
* [Issue tracker](https://jira.sonarsource.com/)

<!-- /sonarqube -->
