---
title: Test Coverage & Execution
url: /analysis/coverage/
---

This page lists analysis parameters related to test coverage and execution reports. For more other parameters, see [Analysis Parameters](/analysis/analysis-parameters/).

SonarSource analyzers do not run your tests or generate reports. They only import pre-generated reports. Below you'll find language- and tool-specific analysis parameters for importing coverage and execution reports.

In the [Guides](https://community.sonarsource.com/c/announce/guides) category of the [SonarSource Community forum](https://community.sonarsource.com/) you might find instructions on generating these reports.

Some properties support the following wildcards in paths. The remarks for properties that support wildcards will mention that fact. If the remarks do not say wildcards are supported, then they are not.:

Symbol|Meaning
---|---
`?`|a single character
`*`|any number of characters
`**`|any number of directories



## Test Coverage
Unless otherwise specified, these properties require values that are relative to project root.

Language|Property|Remarks
----|----|----
**Any**|`sonar.coverageReportPaths`|Path to coverage report in the [Generic Test Data](/analysis/generic-test/) format.
Apex|`sonar.apex.coverage.reportPath`|Path to the `test-result-codecoverage.json` report file generated by the [`apex:test:run`](https://developer.salesforce.com/docs/atlas.en-us.sfdx_cli_reference.meta/sfdx_cli_reference/cli_reference_force_apex.htm?search_text=apex%20test#cli_reference_test_run) command of the [Salesforce CLI](https://developer.salesforce.com/tools/sfdxcli). Note, you must have a [Salesforce DX project](https://developer.salesforce.com/docs/atlas.en-us.sfdx_dev.meta/sfdx_dev/sfdx_dev_workspace_setup.htm) set up and linked to your Org
C / C++ / Objective-C|`sonar.cfamily.gcov.reportsPath`|Path to the directory containing native `*.gcov` reports (not the XML reports generated by gcovr)
C / C++ / Objective-C|`sonar.cfamily.llvm-cov.reportPath`| Path to a llvm-cov report
C / C++ / Objective-C|`sonar.cfamily.vscoveragexml.reportsPath`|Path may be absolute or relative to the solution directory. Path wildcards (see above) are supported. Note that the `.coveragexml` report format offered by Visual Studio is not supported.
C / C++ / Objective-C|`sonar.cfamily.bullseye.reportPath`| Path to the report from Bullseye, version >= 8.9.63 (use [covxml](http://www.bullseye.com/help/ref-covxml.html) tool)
C#|`sonar.cs.vscoveragexml.reportsPaths`|Path to Visual Studio Code Coverage report. Multiple paths may be comma-delimited, or included via wildcards. See _Notes on importing .NET reports_ below.
C#|`sonar.cs.dotcover.reportsPaths`|Path to dotCover coverage report. See _Notes on importing .NET reports_ below.
C#|`sonar.cs.opencover.reportsPaths`|Path to OpenCover coverage report. See _Notes on importing .NET reports_ below.
Flex|`sonar.flex.cobertura.reportPaths`|Path to the Cobertura XML reports. Multiple paths may be comma-delimited. May be absolute or relative to the project base directory.
Go|`sonar.go.coverage.reportPaths`|Comma-delimited list of paths to coverage report files. Path wildcards are supported (see above) since SonarGo 1.1.
Java / Kotlin / Scala / JVM|`sonar.coverage.jacoco.xmlReportPaths`|Path to JaCoCo XML coverage reports.
Java|`sonar.jacoco.reportPaths`![](/images/cross.svg)|**Deprecated. Use `sonar.coverage.jacoco.xmlReportsPath`.** Path to JaCoCo reports in binary format. **Supported only for Java**. 
JavaScript|`sonar.javascript.lcov.reportPaths`|Comma-delimited list of paths to LCOV coverage report files. Paths may be absolute or relative to project root.
PHP|`sonar.php.coverage.reportPaths`|Comma-delimited list of paths to Clover XML-format coverage report files. Paths may be absolute or relative to project root.
Python|`sonar.python.coverage.reportPaths`|Comma-delimited list of paths to coverage reports in the Cobertura XML format. Path wildcards are supported (see above). Leave unset to use the default (`coverage-reports/*coverage-*.xml`).
Ruby|`sonar.ruby.coverage.reportPaths`|Comma-delimited list of paths to SimpleCov `.resultset.json` report files. Paths may be absolute or relative to project-root.
Scala|`sonar.scala.coverage.reportPaths`|Comma-separated list of paths to `scoverage.xml` report files generaged by Scoverage.
Swift, Xcode 9.3+|&nbsp;|You can use the [xccov-to-sonarqube-generic.sh](https://github.com/SonarSource/sonar-scanning-examples/blob/master/swift-coverage/swift-coverage-example/xccov-to-sonarqube-generic.sh) script from the [sonar-scanning-examples/swift-coverage](https://github.com/SonarSource/sonar-scanning-examples/tree/master/swift-coverage) project convert output from Xcode 9.3's xccov tool to the [Generic Test Data](/analysis/generic-test/) format.
Swift, Xcode 7-9.2|`sonar.swift.coverage.reportPath`|Path to the report generated by `llvm-cov show`. Path may be absolute or relative to project root.
TypeScript|`sonar.typescript.lcov.reportPaths`|Comma-delimited list of paths to LCOV coverage reports. Paths may be absolute or relative to project root.
VB.NET|`sonar.vbnet.vscoveragexml.reportsPaths`|Path to Visual Studio Code Coverage report. Multiple paths may be comma-delimited, or included via wildcards. See _Notes on importing .NET reports_ below.
VB.NET|`sonar.vbnet.dotcover.reportsPaths`|Path to dotCover coverage report. See _Notes on importing .NET reports_ below.
VB.NET|`sonar.vbnet.opencover.reportsPaths`|Path to OpenCover coverage report. See _Notes on importing .NET reports_ below.


## Test Execution
Unless otherwise specified, these properties require values that are relative to project root.

Language|Property|Remarks
---|---|---
**All**|`sonar.testExecutionReportPaths`|Comma-delimited list of paths to execution reports in the [Generic Execution Data](/analysis/generic-test/) format.
C / C++ / Objective-C|`sonar.cfamily.cppunit.reportsPath`|Path to the directory holding the [CPPUnit](http://sourceforge.net/projects/cppunit/) reports. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
C#|`sonar.cs.vstest.reportsPaths`|Paths to VSTest reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
C#|`sonar.cs.nunit.reportsPaths`|Paths to NUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
C#|`sonar.cs.xunit.reportsPaths`|Paths to xUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
Go|`sonar.go.tests.reportPaths`|Comma-delimited list of paths to unit test report files. Paths may be absolute or relative to project root.
Java|`sonar.junit.reportPaths`|Comma-delimited list of paths to Surefire XML-format reports.
JavaScript|&nbsp;|You can use [jest-sonar-reporter](https://www.npmjs.com/package/jest-sonar-reporter) or[karma-sonarqube-unit-reporter](https://github.com/tornaia/karma-sonarqube-unit-reporter) to create reports in the [Generic Execution Data](/analysis/generic-test/) format. Both packages are available on npm.
PHP|`sonar.php.tests.reportPath`|Path to the PHPUnit unit test execution report file. Path may be absolute or relative to project root.
Python|`sonar.python.xunit.reportPath`|Path to unit test execution report. Leave unset to use the default (`xunit-reports/xunit-result-*.xml`). Path wildcards (see above) are supported. If any paths in the report are invalid, set `sonar.python.xunit.skipDetails=true` to collect only project-level details.
TypeScript|&nbsp;|You can use [jest-sonar-reporter](https://www.npmjs.com/package/jest-sonar-reporter) or[karma-sonarqube-unit-reporter](https://github.com/tornaia/karma-sonarqube-unit-reporter) to create reports in the [Generic Execution Data](/analysis/generic-test/) format. Both packages are available on npm.
VB.NET|`sonar.vbnet.vstest.reportsPaths`|Paths to VSTest execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
VB.NET|`sonar.vbnet.nunit.reportsPaths`|Paths to NUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.
VB.NET|`sonar.vbnet.xunit.reportsPaths`|Paths to xUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.

**Notes on importing .NET reports**  
.NET reports are imported into SonarQube in 4 steps:

1. Run the SonarScanner.MSBuild.exe `begin` command, specifying the absolute path where the reports _will be_ available using the `/d:propertyKey="path"` syntax ("propertyKey" depends on the tool)
1. Build your project using MSBuild
1. Run your test tool, instructing it to produce a report at the same location specified earlier to the MSBuild SonarQube Runner
1. Run the SonarScanner.MSBuild.exe `end` command
