CREATE TABLE "PROJECT_BRANCHES" (
  "UUID" VARCHAR(50) NOT NULL,
  "PROJECT_UUID" VARCHAR(50) NOT NULL,
  "KEE" VARCHAR(255) NOT NULL,
  "KEY_TYPE" VARCHAR(12) NOT NULL,
  "BRANCH_TYPE" VARCHAR(12),
  "MERGE_BRANCH_UUID" VARCHAR(50),
  "PULL_REQUEST_BINARY" BLOB,
  "MANUAL_BASELINE_ANALYSIS_UUID" VARCHAR(40),
  "CREATED_AT" BIGINT NOT NULL,
  "UPDATED_AT" BIGINT NOT NULL,

  CONSTRAINT "PK_PROJECT_BRANCHES" PRIMARY KEY ("UUID")
);
CREATE UNIQUE INDEX "PROJECT_BRANCHES_KEE_KEY_TYPE" ON "PROJECT_BRANCHES" ("PROJECT_UUID", "KEE", "KEY_TYPE");

CREATE TABLE "NEW_CODE_PERIODS" (
  "UUID" VARCHAR(40) NOT NULL,
  "PROJECT_UUID" VARCHAR(40),
  "BRANCH_UUID" VARCHAR(40),
  "TYPE" VARCHAR(30) NOT NULL,
  "VALUE" VARCHAR(40),
  "UPDATED_AT" BIGINT NOT NULL,
  "CREATED_AT" BIGINT NOT NULL,

  CONSTRAINT "PK_NEW_CODE_PERIOD" PRIMARY KEY ("UUID")
);

CREATE TABLE "PROPERTIES" (
  "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1),
  "PROP_KEY" VARCHAR(512) NOT NULL,
  "RESOURCE_ID" INTEGER,
  "USER_ID" INTEGER,
  "IS_EMPTY" BOOLEAN NOT NULL,
  "TEXT_VALUE" VARCHAR(4000),
  "CLOB_VALUE" CLOB,
  "CREATED_AT" BIGINT
);
CREATE INDEX "PROPERTIES_KEY" ON "PROPERTIES" ("PROP_KEY");

CREATE TABLE "PROJECTS" (
  "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1),
  "KEE" VARCHAR(400),
  "UUID" VARCHAR(50) NOT NULL,
  "ROOT_UUID" VARCHAR(50),
  "PROJECT_UUID" VARCHAR(50) NOT NULL,
  "MODULE_UUID" VARCHAR(50),
  "MODULE_UUID_PATH" VARCHAR(1500),
  "MAIN_BRANCH_PROJECT_UUID" VARCHAR(50),
  "NAME" VARCHAR(2000),
  "TAGS" VARCHAR(500),
  "ENABLED" BOOLEAN NOT NULL DEFAULT TRUE,
  "SCOPE" VARCHAR(3),
  "QUALIFIER" VARCHAR(10)
);
CREATE UNIQUE INDEX "PROJECTS_KEE" ON "PROJECTS" ("KEE");
CREATE INDEX "PROJECTS_ROOT_UUID" ON "PROJECTS" ("ROOT_UUID");
CREATE UNIQUE INDEX "PROJECTS_UUID" ON "PROJECTS" ("UUID");
CREATE INDEX "PROJECTS_PROJECT_UUID" ON "PROJECTS" ("PROJECT_UUID");
CREATE INDEX "PROJECTS_MODULE_UUID" ON "PROJECTS" ("MODULE_UUID");
CREATE INDEX "PROJECTS_QUALIFIER" ON "PROJECTS" ("QUALIFIER");

CREATE TABLE "EVENTS" (
  "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1),
  "NAME" VARCHAR(400),
  "ANALYSIS_UUID" VARCHAR(50) NOT NULL,
  "COMPONENT_UUID" VARCHAR(50) NOT NULL,
  "CATEGORY" VARCHAR(50),
  "CREATED_AT" BIGINT NOT NULL,
  "DESCRIPTION" VARCHAR(4000),
  "EVENT_DATA"  VARCHAR(4000)
);
CREATE INDEX "EVENTS_ANALYSIS" ON "EVENTS" ("ANALYSIS_UUID");
CREATE INDEX "EVENTS_COMPONENT_UUID" ON "EVENTS" ("COMPONENT_UUID");

CREATE TABLE "SNAPSHOTS" (
  "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1),
  "UUID" VARCHAR(50) NOT NULL,
  "CREATED_AT" BIGINT,
  "BUILD_DATE" BIGINT,
  "COMPONENT_UUID" VARCHAR(50) NOT NULL,
  "STATUS" VARCHAR(4) NOT NULL DEFAULT 'U',
  "ISLAST" BOOLEAN NOT NULL DEFAULT FALSE
);
CREATE INDEX "SNAPSHOT_COMPONENT" ON "SNAPSHOTS" ("COMPONENT_UUID");
CREATE UNIQUE INDEX "ANALYSES_UUID" ON "SNAPSHOTS" ("UUID");
