/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.AtomicDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.AtomicLongFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.search.MultiValueMode;

public class SortedNumericDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;

    public SortedNumericDVIndexFieldData(Index index, String fieldNames, IndexNumericFieldData.NumericType numericType) {
        super(index, fieldNames);
        if (numericType == null) {
            throw new IllegalArgumentException("numericType must be non-null");
        }
        this.numericType = numericType;
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        SortedNumericSortField sortField;
        IndexFieldData.XFieldComparatorSource source;
        switch (this.numericType) {
            case HALF_FLOAT: 
            case FLOAT: {
                source = new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DOUBLE: {
                source = new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            default: {
                assert (!this.numericType.isFloatingPoint());
                source = new LongValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        }
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || this.numericType == IndexNumericFieldData.NumericType.HALF_FLOAT) {
            return new SortField(this.fieldName, source, reverse);
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        switch (this.numericType) {
            case FLOAT: {
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.FLOAT, reverse, selectorType);
                break;
            }
            case DOUBLE: {
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.DOUBLE, reverse, selectorType);
                break;
            }
            default: {
                assert (!this.numericType.isFloatingPoint());
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.LONG, reverse, selectorType);
            }
        }
        ((SortField)sortField).setMissingValue(source.missingObject(missingValue, reverse));
        return sortField;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public AtomicNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public AtomicNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        switch (this.numericType) {
            case HALF_FLOAT: {
                return new SortedNumericHalfFloatFieldData(reader, field);
            }
            case FLOAT: {
                return new SortedNumericFloatFieldData(reader, field);
            }
            case DOUBLE: {
                return new SortedNumericDoubleFieldData(reader, field);
            }
        }
        return new SortedNumericLongFieldData(reader, field, this.numericType);
    }

    static final class SortedNumericDoubleFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericDoubleFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                return FieldData.sortableLongBitsToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.nextValue());
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.longValue());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class SortedNumericFloatFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleFloatValues(single));
                }
                return new MultiFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiHalfFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiHalfFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleHalfFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleHalfFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.longValue()));
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class SortedNumericHalfFloatFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericHalfFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleHalfFloatValues(single));
                }
                return new MultiHalfFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericLongFieldData
    extends AtomicLongFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericLongFieldData(LeafReader reader, String field, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

