/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.OperationMode;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleRunner;
import org.elasticsearch.xpack.indexlifecycle.OperationModeUpdateTask;
import org.elasticsearch.xpack.indexlifecycle.PolicyStepsRegistry;
import org.elasticsearch.xpack.indexlifecycle.TimeValueSchedule;

public class IndexLifecycleService
extends AbstractComponent
implements ClusterStateListener,
ClusterStateApplier,
SchedulerEngine.Listener,
Closeable,
LocalNodeMasterListener {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleService.class);
    private static final Set<String> IGNORE_ACTIONS_MAINTENANCE_REQUESTED = Collections.singleton("shrink");
    private volatile boolean isMaster = false;
    private volatile TimeValue pollInterval;
    private final SetOnce<SchedulerEngine> scheduler = new SetOnce();
    private final Clock clock;
    private final PolicyStepsRegistry policyRegistry;
    private final IndexLifecycleRunner lifecycleRunner;
    private final Settings settings;
    private ClusterService clusterService;
    private LongSupplier nowSupplier;
    private SchedulerEngine.Job scheduledJob;

    public IndexLifecycleService(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, Clock clock, LongSupplier nowSupplier, NamedXContentRegistry xContentRegistry) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.clock = clock;
        this.nowSupplier = nowSupplier;
        this.scheduledJob = null;
        this.policyRegistry = new PolicyStepsRegistry(xContentRegistry, client);
        this.lifecycleRunner = new IndexLifecycleRunner(this.policyRegistry, clusterService, threadPool, nowSupplier);
        this.pollInterval = (TimeValue)LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING.get(settings);
        clusterService.addStateApplier((ClusterStateApplier)this);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, this::updatePollInterval);
    }

    public void maybeRunAsyncAction(ClusterState clusterState, IndexMetaData indexMetaData, Step.StepKey nextStepKey) {
        String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetaData.getSettings());
        this.lifecycleRunner.maybeRunAsyncAction(clusterState, indexMetaData, policyName, nextStepKey);
    }

    public ClusterState moveClusterStateToStep(ClusterState currentState, String indexName, Step.StepKey currentStepKey, Step.StepKey nextStepKey) {
        return IndexLifecycleRunner.moveClusterStateToStep(indexName, currentState, currentStepKey, nextStepKey, this.nowSupplier, this.policyRegistry, false);
    }

    public ClusterState moveClusterStateToFailedStep(ClusterState currentState, String[] indices) {
        return this.lifecycleRunner.moveClusterStateToFailedStep(currentState, indices);
    }

    public void onMaster() {
        this.isMaster = true;
        this.maybeScheduleJob();
        ClusterState clusterState = this.clusterService.state();
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)clusterState.metaData().custom("index_lifecycle");
        if (currentMetadata != null) {
            OperationMode currentMode = currentMetadata.getOperationMode();
            if (OperationMode.STOPPED.equals((Object)currentMode)) {
                return;
            }
            boolean safeToStop = true;
            for (ObjectCursor cursor : clusterState.metaData().indices().values()) {
                IndexMetaData idxMeta = (IndexMetaData)cursor.value;
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings());
                if (Strings.isNullOrEmpty((String)policyName)) continue;
                LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMeta);
                Step.StepKey stepKey = IndexLifecycleRunner.getCurrentStepKey(lifecycleState);
                if (OperationMode.STOPPING == currentMode) {
                    if (stepKey != null && IGNORE_ACTIONS_MAINTENANCE_REQUESTED.contains(stepKey.getAction())) {
                        logger.info("waiting to stop ILM because index [{}] with policy [{}] is currently in action [{}]", (Object)idxMeta.getIndex().getName(), (Object)policyName, (Object)stepKey.getAction());
                        this.lifecycleRunner.maybeRunAsyncAction(clusterState, idxMeta, policyName, stepKey);
                        safeToStop = false;
                        continue;
                    }
                    logger.info("skipping policy execution for index [{}] with policy [{}] because ILM is stopping", (Object)idxMeta.getIndex().getName(), (Object)policyName);
                    continue;
                }
                this.lifecycleRunner.maybeRunAsyncAction(clusterState, idxMeta, policyName, stepKey);
            }
            if (safeToStop && OperationMode.STOPPING == currentMode) {
                this.submitOperationModeUpdate(OperationMode.STOPPED);
            }
        }
    }

    public void offMaster() {
        this.isMaster = false;
        this.cancelJob();
    }

    public String executorName() {
        return "management";
    }

    private void updatePollInterval(TimeValue newInterval) {
        this.pollInterval = newInterval;
        this.maybeScheduleJob();
    }

    SchedulerEngine getScheduler() {
        return (SchedulerEngine)this.scheduler.get();
    }

    SchedulerEngine.Job getScheduledJob() {
        return this.scheduledJob;
    }

    private synchronized void maybeScheduleJob() {
        if (this.isMaster) {
            if (this.scheduler.get() == null && !this.isClusterServiceStoppedOrClosed()) {
                this.scheduler.set((Object)new SchedulerEngine(this.settings, this.clock));
                ((SchedulerEngine)this.scheduler.get()).register((SchedulerEngine.Listener)this);
            }
            if (this.scheduler.get() != null) {
                this.scheduledJob = new SchedulerEngine.Job("ilm", (SchedulerEngine.Schedule)new TimeValueSchedule(this.pollInterval));
                ((SchedulerEngine)this.scheduler.get()).add(this.scheduledJob);
            }
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)event.state().metaData().custom("index_lifecycle");
        if (this.isMaster && lifecycleMetadata != null) {
            this.triggerPolicies(event.state(), true);
        }
    }

    public void applyClusterState(ClusterChangedEvent event) {
        if (event.localNodeMaster() && event.state().metaData().custom("index_lifecycle") != null) {
            this.policyRegistry.update(event.state());
        }
    }

    private void cancelJob() {
        if (this.scheduler.get() != null) {
            ((SchedulerEngine)this.scheduler.get()).remove("ilm");
            this.scheduledJob = null;
        }
    }

    public void triggered(SchedulerEngine.Event event) {
        if (event.getJobName().equals("ilm")) {
            logger.trace("job triggered: " + event.getJobName() + ", " + event.getScheduledTime() + ", " + event.getTriggeredTime());
            this.triggerPolicies(this.clusterService.state(), false);
        }
    }

    void triggerPolicies(ClusterState clusterState, boolean fromClusterStateChange) {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)clusterState.metaData().custom("index_lifecycle");
        if (currentMetadata == null) {
            return;
        }
        OperationMode currentMode = currentMetadata.getOperationMode();
        if (OperationMode.STOPPED.equals((Object)currentMode)) {
            return;
        }
        boolean safeToStop = true;
        for (ObjectCursor cursor : clusterState.metaData().indices().values()) {
            IndexMetaData idxMeta = (IndexMetaData)cursor.value;
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings());
            if (Strings.isNullOrEmpty((String)policyName)) continue;
            LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMeta);
            Step.StepKey stepKey = IndexLifecycleRunner.getCurrentStepKey(lifecycleState);
            if (OperationMode.STOPPING == currentMode) {
                if (stepKey != null && IGNORE_ACTIONS_MAINTENANCE_REQUESTED.contains(stepKey.getAction())) {
                    logger.info("waiting to stop ILM because index [{}] with policy [{}] is currently in action [{}]", (Object)idxMeta.getIndex().getName(), (Object)policyName, (Object)stepKey.getAction());
                    if (fromClusterStateChange) {
                        this.lifecycleRunner.runPolicyAfterStateChange(policyName, idxMeta);
                    } else {
                        this.lifecycleRunner.runPeriodicStep(policyName, idxMeta);
                    }
                    safeToStop = false;
                    continue;
                }
                logger.info("skipping policy execution for index [{}] with policy [{}] because ILM is stopping", (Object)idxMeta.getIndex().getName(), (Object)policyName);
                continue;
            }
            if (fromClusterStateChange) {
                this.lifecycleRunner.runPolicyAfterStateChange(policyName, idxMeta);
                continue;
            }
            this.lifecycleRunner.runPeriodicStep(policyName, idxMeta);
        }
        if (safeToStop && OperationMode.STOPPING == currentMode) {
            this.submitOperationModeUpdate(OperationMode.STOPPED);
        }
    }

    @Override
    public synchronized void close() {
        assert (this.isClusterServiceStoppedOrClosed()) : "close is called by closing the plugin, which is expected to happen after the cluster service is stopped";
        SchedulerEngine engine = (SchedulerEngine)this.scheduler.get();
        if (engine != null) {
            engine.stop();
        }
    }

    public void submitOperationModeUpdate(OperationMode mode) {
        this.clusterService.submitStateUpdateTask("ilm_operation_mode_update", (ClusterStateTaskConfig)new OperationModeUpdateTask(mode));
    }

    private boolean isClusterServiceStoppedOrClosed() {
        Lifecycle.State state = this.clusterService.lifecycleState();
        return state == Lifecycle.State.STOPPED || state == Lifecycle.State.CLOSED;
    }
}

