/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.core.ccr.action.ForgetFollowerAction;

public class TransportForgetFollowerAction
extends TransportBroadcastByNodeAction<ForgetFollowerAction.Request, BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    @Inject
    public TransportForgetFollowerAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super(settings, "indices:admin/xpack/ccr/forget_follower", Objects.requireNonNull(threadPool), Objects.requireNonNull(clusterService), Objects.requireNonNull(transportService), Objects.requireNonNull(actionFilters), Objects.requireNonNull(indexNameExpressionResolver), ForgetFollowerAction.Request::new, "management");
        this.clusterService = clusterService;
        this.indicesService = Objects.requireNonNull(indicesService);
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)in);
    }

    protected BroadcastResponse newResponse(ForgetFollowerAction.Request request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new BroadcastResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected ForgetFollowerAction.Request readRequestFrom(StreamInput in) throws IOException {
        return new ForgetFollowerAction.Request(in);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(ForgetFollowerAction.Request request, ShardRouting shardRouting) {
        Index followerIndex = new Index(request.followerIndex(), request.followerIndexUUID());
        Index leaderIndex = this.clusterService.state().metaData().index(request.leaderIndex()).getIndex();
        String id = CcrRetentionLeases.retentionLeaseId(request.followerCluster(), followerIndex, request.leaderRemoteCluster(), leaderIndex);
        IndexShard indexShard = this.indicesService.indexServiceSafe(leaderIndex).getShard(shardRouting.shardId().id());
        PlainActionFuture permit = new PlainActionFuture();
        indexShard.acquirePrimaryOperationPermit((ActionListener)permit, "same", (Object)request);
        try (Releasable ignored = (Releasable)permit.get();){
            PlainActionFuture future = new PlainActionFuture();
            indexShard.removeRetentionLease(id, (ActionListener)future);
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState clusterState, ForgetFollowerAction.Request request, String[] concreteIndices) {
        GroupShardsIterator activePrimaryShards = clusterState.routingTable().activePrimaryShardsGrouped(concreteIndices, false);
        ArrayList<ShardRouting> shardRoutings = new ArrayList<ShardRouting>();
        for (ShardIterator shardIterator : activePrimaryShards) {
            ShardRouting primaryShard = shardIterator.nextOrNull();
            assert (primaryShard != null);
            shardRoutings.add(primaryShard);
            if (!Assertions.ENABLED) continue;
            ShardRouting maybeNextPrimaryShard = shardIterator.nextOrNull();
            assert (maybeNextPrimaryShard == null) : maybeNextPrimaryShard;
        }
        return new PlainShardsIterator(shardRoutings);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, ForgetFollowerAction.Request request) {
        return null;
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, ForgetFollowerAction.Request request, String[] concreteIndices) {
        return null;
    }
}

