/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CombinedRateLimiter;
import org.elasticsearch.xpack.core.XPackSettings;

public final class CcrSettings {
    public static final Setting<Boolean> CCR_FOLLOWING_INDEX_SETTING = Setting.boolSetting((String)"index.xpack.ccr.following_index", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.InternalIndex});
    public static final Setting<TimeValue> CCR_WAIT_FOR_METADATA_TIMEOUT = Setting.timeSetting((String)"ccr.wait_for_metadata_timeout", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final Setting<TimeValue> CCR_AUTO_FOLLOW_WAIT_FOR_METADATA_TIMEOUT = Setting.timeSetting((String)"ccr.auto_follow.wait_for_metadata_timeout", CCR_WAIT_FOR_METADATA_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<ByteSizeValue> RECOVERY_MAX_BYTES_PER_SECOND = Setting.byteSizeSetting((String)"ccr.indices.recovery.max_bytes_per_sec", (ByteSizeValue)new ByteSizeValue(40L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> RECOVERY_CHUNK_SIZE = Setting.byteSizeSetting((String)"ccr.indices.recovery.chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.KB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING = Setting.intSetting((String)"ccr.indices.recovery.max_concurrent_file_chunks", (int)5, (int)1, (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING = Setting.timeSetting((String)"ccr.indices.recovery.recovery_activity_timeout", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> INDICES_RECOVERY_ACTION_TIMEOUT_SETTING = Setting.positiveTimeSetting((String)"ccr.indices.recovery.internal_action_timeout", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final CombinedRateLimiter ccrRateLimiter;
    private volatile TimeValue recoveryActivityTimeout;
    private volatile TimeValue recoveryActionTimeout;
    private volatile ByteSizeValue chunkSize;
    private volatile int maxConcurrentFileChunks;

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(XPackSettings.CCR_ENABLED_SETTING, CCR_FOLLOWING_INDEX_SETTING, RECOVERY_MAX_BYTES_PER_SECOND, INDICES_RECOVERY_ACTION_TIMEOUT_SETTING, INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING, CCR_AUTO_FOLLOW_WAIT_FOR_METADATA_TIMEOUT, RECOVERY_CHUNK_SIZE, INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING, CCR_WAIT_FOR_METADATA_TIMEOUT);
    }

    public CcrSettings(Settings settings, ClusterSettings clusterSettings) {
        this.recoveryActivityTimeout = (TimeValue)INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING.get(settings);
        this.recoveryActionTimeout = (TimeValue)INDICES_RECOVERY_ACTION_TIMEOUT_SETTING.get(settings);
        this.ccrRateLimiter = new CombinedRateLimiter((ByteSizeValue)RECOVERY_MAX_BYTES_PER_SECOND.get(settings));
        this.chunkSize = (ByteSizeValue)RECOVERY_MAX_BYTES_PER_SECOND.get(settings);
        this.maxConcurrentFileChunks = (Integer)INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(RECOVERY_MAX_BYTES_PER_SECOND, this::setMaxBytesPerSec);
        clusterSettings.addSettingsUpdateConsumer(RECOVERY_CHUNK_SIZE, this::setChunkSize);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING, this::setMaxConcurrentFileChunks);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING, this::setRecoveryActivityTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_ACTION_TIMEOUT_SETTING, this::setRecoveryActionTimeout);
    }

    private void setChunkSize(ByteSizeValue chunkSize) {
        this.chunkSize = chunkSize;
    }

    private void setMaxConcurrentFileChunks(int maxConcurrentFileChunks) {
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
    }

    private void setMaxBytesPerSec(ByteSizeValue maxBytesPerSec) {
        this.ccrRateLimiter.setMBPerSec(maxBytesPerSec);
    }

    private void setRecoveryActivityTimeout(TimeValue recoveryActivityTimeout) {
        this.recoveryActivityTimeout = recoveryActivityTimeout;
    }

    private void setRecoveryActionTimeout(TimeValue recoveryActionTimeout) {
        this.recoveryActionTimeout = recoveryActionTimeout;
    }

    public ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    public int getMaxConcurrentFileChunks() {
        return this.maxConcurrentFileChunks;
    }

    public CombinedRateLimiter getRateLimiter() {
        return this.ccrRateLimiter;
    }

    public TimeValue getRecoveryActivityTimeout() {
        return this.recoveryActivityTimeout;
    }

    public TimeValue getRecoveryActionTimeout() {
        return this.recoveryActionTimeout;
    }
}

