/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public final class CcrLicenseChecker {
    private final BooleanSupplier isCcrAllowed;
    private final BooleanSupplier isAuthAllowed;

    CcrLicenseChecker() {
        this(() -> ((XPackLicenseState)XPackPlugin.getSharedLicenseState()).isCcrAllowed(), () -> ((XPackLicenseState)XPackPlugin.getSharedLicenseState()).isAuthAllowed());
    }

    public CcrLicenseChecker(BooleanSupplier isCcrAllowed, BooleanSupplier isAuthAllowed) {
        this.isCcrAllowed = Objects.requireNonNull(isCcrAllowed, "isCcrAllowed");
        this.isAuthAllowed = Objects.requireNonNull(isAuthAllowed, "isAuthAllowed");
    }

    public boolean isCcrAllowed() {
        return this.isCcrAllowed.getAsBoolean();
    }

    public void checkRemoteClusterLicenseAndFetchClusterStateLeaderIndexMetadataAndHistoryUUIDs(Client client, String clusterAlias, boolean fetchNodes, String leaderIndex, Consumer<Exception> onFailure, BiConsumer<String[], Tuple<ClusterState, IndexMetaData>> consumer) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.clear();
        request.metaData(true);
        request.indices(new String[]{leaderIndex});
        request.nodes(fetchNodes);
        this.checkRemoteClusterLicenseAndFetchClusterState(client, clusterAlias, client.getRemoteClusterClient(clusterAlias), request, onFailure, remoteClusterStateResponse -> {
            ClusterState remoteClusterState = remoteClusterStateResponse.getState();
            IndexMetaData leaderIndexMetaData = remoteClusterState.getMetaData().index(leaderIndex);
            if (leaderIndexMetaData == null) {
                onFailure.accept((Exception)new IndexNotFoundException(leaderIndex));
                return;
            }
            Client remoteClient = client.getRemoteClusterClient(clusterAlias);
            this.hasPrivilegesToFollowIndices(remoteClient, new String[]{leaderIndex}, e -> {
                if (e == null) {
                    this.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetaData, onFailure, historyUUIDs -> consumer.accept((String[])historyUUIDs, (Tuple<ClusterState, IndexMetaData>)new Tuple((Object)remoteClusterState, (Object)leaderIndexMetaData)));
                } else {
                    onFailure.accept((Exception)e);
                }
            });
        }, licenseCheck -> CcrLicenseChecker.indexMetadataNonCompliantRemoteLicense(leaderIndex, licenseCheck), e -> CcrLicenseChecker.indexMetadataUnknownRemoteLicense(leaderIndex, clusterAlias, e));
    }

    public void checkRemoteClusterLicenseAndFetchClusterState(Client client, String clusterAlias, ClusterStateRequest request, Consumer<Exception> onFailure, Consumer<ClusterStateResponse> leaderClusterStateConsumer) {
        try {
            Client remoteClient = CcrLicenseChecker.systemClient(client.getRemoteClusterClient(clusterAlias));
            this.checkRemoteClusterLicenseAndFetchClusterState(client, clusterAlias, remoteClient, request, onFailure, leaderClusterStateConsumer, CcrLicenseChecker::clusterStateNonCompliantRemoteLicense, e -> CcrLicenseChecker.clusterStateUnknownRemoteLicense(clusterAlias, e));
        }
        catch (Exception e2) {
            onFailure.accept(e2);
        }
    }

    private void checkRemoteClusterLicenseAndFetchClusterState(Client client, String clusterAlias, final Client remoteClient, final ClusterStateRequest request, final Consumer<Exception> onFailure, final Consumer<ClusterStateResponse> leaderClusterStateConsumer, final Function<RemoteClusterLicenseChecker.LicenseCheck, ElasticsearchStatusException> nonCompliantLicense, final Function<Exception, ElasticsearchStatusException> unknownLicense) {
        new RemoteClusterLicenseChecker(client, XPackLicenseState::isCcrAllowedForOperationMode).checkRemoteClusterLicenses(Collections.singletonList(clusterAlias), (ActionListener)new ActionListener<RemoteClusterLicenseChecker.LicenseCheck>(){

            public void onResponse(RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
                if (licenseCheck.isSuccess()) {
                    ActionListener clusterStateListener = ActionListener.wrap(leaderClusterStateConsumer::accept, (Consumer)onFailure);
                    remoteClient.admin().cluster().state(request, clusterStateListener);
                } else {
                    onFailure.accept((Exception)nonCompliantLicense.apply(licenseCheck));
                }
            }

            public void onFailure(Exception e) {
                onFailure.accept((Exception)unknownLicense.apply(e));
            }
        });
    }

    public void fetchLeaderHistoryUUIDs(Client remoteClient, IndexMetaData leaderIndexMetaData, Consumer<Exception> onFailure, Consumer<String[]> historyUUIDConsumer) {
        String leaderIndex = leaderIndexMetaData.getIndex().getName();
        CheckedConsumer indicesStatsHandler = indicesStatsResponse -> {
            IndexStats indexStats = (IndexStats)indicesStatsResponse.getIndices().get(leaderIndex);
            if (indexStats == null) {
                onFailure.accept(new IllegalArgumentException("no index stats available for the leader index"));
                return;
            }
            String[] historyUUIDs = new String[leaderIndexMetaData.getNumberOfShards()];
            for (IndexShardStats indexShardStats : indexStats) {
                for (ShardStats shardStats : indexShardStats) {
                    if (!shardStats.getShardRouting().primary()) continue;
                    CommitStats commitStats = shardStats.getCommitStats();
                    if (commitStats == null) {
                        onFailure.accept(new IllegalArgumentException("leader index's commit stats are missing"));
                        return;
                    }
                    String historyUUID = (String)commitStats.getUserData().get("history_uuid");
                    ShardId shardId = shardStats.getShardRouting().shardId();
                    historyUUIDs[shardId.id()] = historyUUID;
                }
            }
            for (int i = 0; i < historyUUIDs.length; ++i) {
                if (historyUUIDs[i] != null) continue;
                onFailure.accept(new IllegalArgumentException("no history uuid for [" + leaderIndex + "][" + i + "]"));
                return;
            }
            historyUUIDConsumer.accept(historyUUIDs);
        };
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.clear();
        request.indices(new String[]{leaderIndex});
        remoteClient.admin().indices().stats(request, ActionListener.wrap((CheckedConsumer)indicesStatsHandler, onFailure));
    }

    public void hasPrivilegesToFollowIndices(Client remoteClient, String[] indices, Consumer<Exception> handler) {
        Objects.requireNonNull(remoteClient, "remoteClient");
        Objects.requireNonNull(indices, "indices");
        if (indices.length == 0) {
            throw new IllegalArgumentException("indices must not be empty");
        }
        Objects.requireNonNull(handler, "handler");
        if (!this.isAuthAllowed.getAsBoolean()) {
            handler.accept(null);
            return;
        }
        ThreadContext threadContext = remoteClient.threadPool().getThreadContext();
        SecurityContext securityContext = new SecurityContext(Settings.EMPTY, threadContext);
        String username = securityContext.getUser().principal();
        RoleDescriptor.IndicesPrivileges privileges = RoleDescriptor.IndicesPrivileges.builder().indices(indices).privileges(new String[]{"indices:monitor/stats", "indices:data/read/xpack/ccr/shard_changes"}).build();
        HasPrivilegesRequest request = new HasPrivilegesRequest();
        request.username(username);
        request.clusterPrivileges(Strings.EMPTY_ARRAY);
        request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{privileges});
        request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        CheckedConsumer responseHandler = response -> {
            if (response.isCompleteMatch()) {
                handler.accept(null);
            } else {
                StringBuilder message = new StringBuilder("insufficient privileges to follow");
                message.append(indices.length == 1 ? " index " : " indices ");
                message.append(Arrays.toString(indices));
                ResourcePrivileges resourcePrivileges = (ResourcePrivileges)response.getIndexPrivileges().iterator().next();
                for (Map.Entry entry : resourcePrivileges.getPrivileges().entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    message.append(", privilege for action [");
                    message.append((String)entry.getKey());
                    message.append("] is missing");
                }
                handler.accept((Exception)Exceptions.authorizationError((String)message.toString(), (Object[])new Object[0]));
            }
        };
        remoteClient.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap((CheckedConsumer)responseHandler, handler));
    }

    public static Client wrapClient(Client client, Map<String, String> headers) {
        if (headers.isEmpty()) {
            return client;
        }
        final ThreadContext threadContext = client.threadPool().getThreadContext();
        final Map<String, String> filteredHeaders = headers.entrySet().stream().filter(e -> ShardFollowTask.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new FilterClient(client){

            protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
                Supplier supplier = threadContext.newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = CcrLicenseChecker.stashWithHeaders(threadContext, filteredHeaders);){
                    super.doExecute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
                }
            }
        };
    }

    private static Client systemClient(Client client) {
        final ThreadContext threadContext = client.threadPool().getThreadContext();
        return new FilterClient(client){

            protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
                Supplier supplier = threadContext.newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                    threadContext.markAsSystemContext();
                    super.doExecute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
                }
            }
        };
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }

    private static ElasticsearchStatusException indexMetadataNonCompliantRemoteLicense(String leaderIndex, RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String clusterAlias = licenseCheck.remoteClusterLicenseInfo().clusterAlias();
        String message = String.format(Locale.ROOT, "can not fetch remote index [%s:%s] metadata as the remote cluster [%s] is not licensed for [ccr]; %s", clusterAlias, leaderIndex, clusterAlias, RemoteClusterLicenseChecker.buildErrorMessage((String)"ccr", (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo(), RemoteClusterLicenseChecker::isLicensePlatinumOrTrial));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private static ElasticsearchStatusException clusterStateNonCompliantRemoteLicense(RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String clusterAlias = licenseCheck.remoteClusterLicenseInfo().clusterAlias();
        String message = String.format(Locale.ROOT, "can not fetch remote cluster state as the remote cluster [%s] is not licensed for [ccr]; %s", clusterAlias, RemoteClusterLicenseChecker.buildErrorMessage((String)"ccr", (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo(), RemoteClusterLicenseChecker::isLicensePlatinumOrTrial));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private static ElasticsearchStatusException indexMetadataUnknownRemoteLicense(String leaderIndex, String clusterAlias, Exception cause) {
        String message = String.format(Locale.ROOT, "can not fetch remote index [%s:%s] metadata as the license state of the remote cluster [%s] could not be determined", clusterAlias, leaderIndex, clusterAlias);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }

    private static ElasticsearchStatusException clusterStateUnknownRemoteLicense(String clusterAlias, Exception cause) {
        String message = String.format(Locale.ROOT, "can not fetch remote cluster state as the license state of the remote cluster [%s] could not be determined", clusterAlias);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }
}

