/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.rules.RulePriority;

public final class CheckstyleSeverityUtils {
    private CheckstyleSeverityUtils() {
    }

    public static String toSeverity(RulePriority priority) {
        if (RulePriority.BLOCKER.equals((Object)priority) || RulePriority.CRITICAL.equals((Object)priority)) {
            return "error";
        }
        if (RulePriority.MAJOR.equals((Object)priority)) {
            return "warning";
        }
        if (RulePriority.MINOR.equals((Object)priority) || RulePriority.INFO.equals((Object)priority)) {
            return "info";
        }
        throw new IllegalArgumentException("Priority not supported: " + priority);
    }

    public static RulePriority fromSeverity(String severity) {
        if (StringUtils.equals((String)severity, (String)"error")) {
            return RulePriority.BLOCKER;
        }
        if (StringUtils.equals((String)severity, (String)"warning")) {
            return RulePriority.MAJOR;
        }
        if (StringUtils.equals((String)severity, (String)"info")) {
            return RulePriority.INFO;
        }
        return null;
    }
}

