/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.type.DataType;

public class TopHitsAgg
extends LeafAgg {
    private final String sortField;
    private final SortOrder sortOrder;
    private final DataType fieldDataType;
    private final DataType sortFieldDataType;

    public TopHitsAgg(String id, String fieldName, DataType fieldDataType, String sortField, DataType sortFieldDataType, SortOrder sortOrder) {
        super(id, fieldName);
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.fieldDataType = fieldDataType;
        this.sortFieldDataType = sortFieldDataType;
    }

    @Override
    AggregationBuilder toBuilder() {
        ArrayList<FieldSortBuilder> sortBuilderList = new ArrayList<FieldSortBuilder>(2);
        if (this.sortField != null) {
            sortBuilderList.add(((FieldSortBuilder)new FieldSortBuilder(this.sortField).order(this.sortOrder)).missing((Object)Sort.Missing.LAST.position()).unmappedType(this.sortFieldDataType.esType));
        }
        sortBuilderList.add(((FieldSortBuilder)new FieldSortBuilder(this.fieldName()).order(this.sortOrder)).missing((Object)Sort.Missing.LAST.position()).unmappedType(this.fieldDataType.esType));
        return AggregationBuilders.topHits((String)this.id()).docValueField(this.fieldName(), this.fieldDataType.format()).sorts(sortBuilderList).size(1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopHitsAgg that = (TopHitsAgg)o;
        return Objects.equals(this.sortField, that.sortField) && this.sortOrder == that.sortOrder && this.fieldDataType == that.fieldDataType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sortField, this.sortOrder, this.fieldDataType});
    }
}

