/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class CreateApiKeyRequestBuilder
extends ActionRequestBuilder<CreateApiKeyRequest, CreateApiKeyResponse, CreateApiKeyRequestBuilder> {
    static final ConstructingObjectParser<CreateApiKeyRequest, Void> PARSER = new ConstructingObjectParser("api_key_request", false, (args, v) -> new CreateApiKeyRequest((String)args[0], (List)args[1], TimeValue.parseTimeValue((String)((String)args[2]), null, (String)"expiration")));

    public CreateApiKeyRequestBuilder(ElasticsearchClient client) {
        super(client, (Action)CreateApiKeyAction.INSTANCE, (ActionRequest)new CreateApiKeyRequest());
    }

    public CreateApiKeyRequestBuilder setName(String name) {
        ((CreateApiKeyRequest)this.request).setName(name);
        return this;
    }

    public CreateApiKeyRequestBuilder setExpiration(TimeValue expiration) {
        ((CreateApiKeyRequest)this.request).setExpiration(expiration);
        return this;
    }

    public CreateApiKeyRequestBuilder setRoleDescriptors(List<RoleDescriptor> roleDescriptors) {
        ((CreateApiKeyRequest)this.request).setRoleDescriptors(roleDescriptors);
        return this;
    }

    public CreateApiKeyRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        ((CreateApiKeyRequest)this.request).setRefreshPolicy(refreshPolicy);
        return this;
    }

    public CreateApiKeyRequestBuilder source(BytesReference source, XContentType xContentType) throws IOException {
        NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;
        try (StreamInput stream = source.streamInput();
             XContentParser parser = xContentType.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
            CreateApiKeyRequest createApiKeyRequest = (CreateApiKeyRequest)((Object)PARSER.parse(parser, null));
            this.setName(createApiKeyRequest.getName());
            this.setRoleDescriptors(createApiKeyRequest.getRoleDescriptors());
            this.setExpiration(createApiKeyRequest.getExpiration());
        }
        return this;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            p.nextToken();
            return RoleDescriptor.parse(n, p, false);
        }, new ParseField("role_descriptors", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
    }
}

