/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.BatchedJobsIterator;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

abstract class AbstractExpiredJobDataRemover
implements MlDataRemover {
    private final Client client;
    private final ClusterService clusterService;

    AbstractExpiredJobDataRemover(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    protected Client getClient() {
        return this.client;
    }

    @Override
    public void remove(ActionListener<Boolean> listener) {
        this.removeData(this.newJobIterator(), listener);
    }

    private void removeData(WrappedBatchedJobsIterator jobIterator, ActionListener<Boolean> listener) {
        if (!jobIterator.hasNext()) {
            listener.onResponse((Object)true);
            return;
        }
        Job job = jobIterator.next();
        if (job == null) {
            listener.onResponse((Object)true);
            return;
        }
        Long retentionDays = this.getRetentionDays(job);
        if (retentionDays == null) {
            this.removeData(jobIterator, listener);
            return;
        }
        long cutoffEpochMs = this.calcCutoffEpochMs(retentionDays);
        this.removeDataBefore(job, cutoffEpochMs, (ActionListener<Boolean>)ActionListener.wrap(response -> this.removeData(jobIterator, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private WrappedBatchedJobsIterator newJobIterator() {
        ClusterState clusterState = this.clusterService.state();
        ArrayList jobs = new ArrayList(MlMetadata.getMlMetadata((ClusterState)clusterState).getJobs().values());
        VolatileCursorIterator<Job> clusterStateJobs = new VolatileCursorIterator<Job>(jobs);
        BatchedJobsIterator jobsIterator = new BatchedJobsIterator(this.client, AnomalyDetectorsIndex.configIndexName());
        return new WrappedBatchedJobsIterator(jobsIterator, clusterStateJobs);
    }

    private long calcCutoffEpochMs(long retentionDays) {
        long nowEpochMs = DateTime.now((Chronology)ISOChronology.getInstance()).getMillis();
        return nowEpochMs - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
    }

    protected abstract Long getRetentionDays(Job var1);

    protected abstract void removeDataBefore(Job var1, long var2, ActionListener<Boolean> var4);

    protected static BoolQueryBuilder createQuery(String jobId, long cutoffEpochMs) {
        return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).lt((Object)cutoffEpochMs).format("epoch_millis"));
    }

    private class WrappedBatchedJobsIterator
    implements Iterator<Job> {
        private final BatchedJobsIterator batchedIterator;
        private VolatileCursorIterator<Job> currentBatch;

        WrappedBatchedJobsIterator(BatchedJobsIterator batchedIterator, VolatileCursorIterator<Job> currentBatch) {
            this.batchedIterator = batchedIterator;
            this.currentBatch = currentBatch;
        }

        @Override
        public boolean hasNext() {
            return this.currentBatch != null && this.currentBatch.hasNext() || this.batchedIterator.hasNext();
        }

        @Override
        public Job next() {
            if (this.currentBatch != null && this.currentBatch.hasNext()) {
                return this.currentBatch.next();
            }
            this.currentBatch = this.createBatchIteratorFromBatch(this.batchedIterator.next());
            return this.currentBatch.hasNext() ? this.currentBatch.next() : null;
        }

        private VolatileCursorIterator<Job> createBatchIteratorFromBatch(Deque<Job.Builder> builders) {
            List jobs = builders.stream().map(Job.Builder::build).collect(Collectors.toList());
            return new VolatileCursorIterator<Job>(jobs);
        }
    }
}

