/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.normalizer.Renormalizer;
import org.elasticsearch.xpack.ml.job.process.normalizer.ScoresUpdater;

public class ShortCircuitingRenormalizer
implements Renormalizer {
    private static final Logger LOGGER = LogManager.getLogger(ShortCircuitingRenormalizer.class);
    private final String jobId;
    private final ScoresUpdater scoresUpdater;
    private final ExecutorService executorService;
    private final Deque<QuantilesWithLatch> quantilesDeque = new ConcurrentLinkedDeque<QuantilesWithLatch>();
    private final Deque<CountDownLatch> latchDeque = new ConcurrentLinkedDeque<CountDownLatch>();
    private final Semaphore semaphore = new Semaphore(1);

    public ShortCircuitingRenormalizer(String jobId, ScoresUpdater scoresUpdater, ExecutorService executorService) {
        this.jobId = jobId;
        this.scoresUpdater = scoresUpdater;
        this.executorService = executorService;
    }

    @Override
    public boolean isEnabled() {
        return this.scoresUpdater.getNormalizationWindow() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renormalize(Quantiles quantiles) {
        if (!this.isEnabled()) {
            return;
        }
        QuantilesWithLatch quantilesWithLatch = new QuantilesWithLatch(quantiles, new CountDownLatch(1));
        Deque<QuantilesWithLatch> deque = this.quantilesDeque;
        synchronized (deque) {
            this.latchDeque.addLast(quantilesWithLatch.getLatch());
            this.quantilesDeque.addLast(quantilesWithLatch);
            this.executorService.submit(() -> this.doRenormalizations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilIdle() {
        try {
            Deque<CountDownLatch> deque = this.latchDeque;
            synchronized (deque) {
                CountDownLatch latchToAwait = this.latchDeque.pollFirst();
                while (latchToAwait != null) {
                    latchToAwait.await();
                    latchToAwait = this.latchDeque.pollFirst();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        this.scoresUpdater.shutdown();
        this.waitUntilIdle();
    }

    private Quantiles getEarliestQuantiles() {
        QuantilesWithLatch earliestQuantilesWithLatch = this.quantilesDeque.peekFirst();
        return earliestQuantilesWithLatch != null ? earliestQuantilesWithLatch.getQuantiles() : null;
    }

    private QuantilesWithLatch getLatestQuantilesWithLatchAndClear() {
        QuantilesWithLatch latestQuantilesWithLatch = null;
        QuantilesWithLatch quantilesWithLatch = this.quantilesDeque.pollFirst();
        while (quantilesWithLatch != null) {
            if (latestQuantilesWithLatch != null) {
                latestQuantilesWithLatch.getLatch().countDown();
            }
            latestQuantilesWithLatch = quantilesWithLatch;
            quantilesWithLatch = this.quantilesDeque.pollFirst();
        }
        return latestQuantilesWithLatch;
    }

    private boolean tryStartWork() {
        return this.semaphore.tryAcquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryFinishWork() {
        Deque<QuantilesWithLatch> deque = this.quantilesDeque;
        synchronized (deque) {
            if (!this.quantilesDeque.isEmpty()) {
                return false;
            }
            this.semaphore.release();
            return true;
        }
    }

    private void forceFinishWork() {
        this.semaphore.release();
    }

    private void doRenormalizations() {
        if (!this.tryStartWork()) {
            return;
        }
        CountDownLatch latch = null;
        try {
            do {
                Quantiles earliestQuantiles = this.getEarliestQuantiles();
                QuantilesWithLatch latestQuantilesWithLatch = this.getLatestQuantilesWithLatchAndClear();
                if (latestQuantilesWithLatch == null) continue;
                Quantiles latestQuantiles = latestQuantilesWithLatch.getQuantiles();
                latch = latestQuantilesWithLatch.getLatch();
                if (earliestQuantiles == null) {
                    earliestQuantiles = latestQuantiles;
                }
                long earliestBucketTimeMs = earliestQuantiles.getTimestamp().getTime();
                long latestBucketTimeMs = latestQuantiles.getTimestamp().getTime();
                long windowExtensionMs = latestBucketTimeMs - earliestBucketTimeMs;
                if (windowExtensionMs < 0L) {
                    LOGGER.warn("[{}] Quantiles not supplied in time order - {} after {}", (Object)this.jobId, (Object)latestBucketTimeMs, (Object)earliestBucketTimeMs);
                    windowExtensionMs = 0L;
                }
                this.scoresUpdater.update(latestQuantiles.getQuantileState(), latestBucketTimeMs, windowExtensionMs);
                latch.countDown();
                latch = null;
            } while (!this.tryFinishWork());
        }
        catch (Exception e) {
            LOGGER.error("[" + this.jobId + "] Normalization failed", (Throwable)e);
            if (latch != null) {
                latch.countDown();
            }
            this.forceFinishWork();
        }
    }

    private static class QuantilesWithLatch {
        private final Quantiles quantiles;
        private final CountDownLatch latch;

        QuantilesWithLatch(Quantiles quantiles, CountDownLatch latch) {
            this.quantiles = Objects.requireNonNull(quantiles);
            this.latch = Objects.requireNonNull(latch);
        }

        Quantiles getQuantiles() {
            return this.quantiles;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

