/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.plugins.checkstyle.CheckstyleAuditListener;
import org.sonar.plugins.checkstyle.CheckstyleConfiguration;
import org.sonar.plugins.checkstyle.CheckstyleVersion;

public class CheckstyleExecutor
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CheckstyleExecutor.class);
    private CheckstyleConfiguration configuration;
    private ClassLoader projectClassloader;
    private CheckstyleAuditListener listener;

    public CheckstyleExecutor(CheckstyleConfiguration configuration, CheckstyleAuditListener listener, ProjectClasspath classpath) {
        this.configuration = configuration;
        this.listener = listener;
        this.projectClassloader = classpath.getClassloader();
    }

    CheckstyleExecutor(CheckstyleConfiguration configuration, CheckstyleAuditListener listener, ClassLoader projectClassloader) {
        this.configuration = configuration;
        this.listener = listener;
        this.projectClassloader = projectClassloader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        FileOutputStream xmlOutput;
        ClassLoader initialClassLoader;
        block6: {
            TimeProfiler profiler = new TimeProfiler().start("Execute Checkstyle " + CheckstyleVersion.getVersion());
            initialClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(PackageNamesLoader.class.getClassLoader());
            Checker checker = null;
            xmlOutput = null;
            try {
                checker = new Checker();
                checker.setClassloader(this.projectClassloader);
                checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
                checker.addListener((AuditListener)this.listener);
                File xmlReport = this.configuration.getTargetXMLReport();
                if (xmlReport != null) {
                    LOG.info("Checkstyle output report: " + xmlReport.getAbsolutePath());
                    xmlOutput = FileUtils.openOutputStream((File)xmlReport);
                    checker.addListener((AuditListener)new XMLLogger((OutputStream)xmlOutput, true));
                }
                checker.setCharset(this.configuration.getCharset().name());
                checker.configure(this.configuration.getCheckstyleConfiguration());
                checker.process(this.configuration.getSourceFiles());
                profiler.stop();
                if (checker == null) break block6;
            }
            catch (Exception e) {
                try {
                    throw new SonarException("Can not execute Checkstyle", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (checker != null) {
                        checker.destroy();
                    }
                    IOUtils.closeQuietly(xmlOutput);
                    Thread.currentThread().setContextClassLoader(initialClassLoader);
                    throw throwable;
                }
            }
            checker.destroy();
        }
        IOUtils.closeQuietly((OutputStream)xmlOutput);
        Thread.currentThread().setContextClassLoader(initialClassLoader);
    }
}

