import type { PluginDefinition } from '@yaakapp/api';

export const plugin: PluginDefinition = {
  themes: [
    {
      id: 'high-contrast',
      label: 'High Contrast Light',
      dark: false,
      base: {
        surface: 'white',
        surfaceHighlight: 'hsl(218,24%,93%)',
        text: 'black',
        textSubtle: 'hsl(217,24%,40%)',
        textSubtlest: 'hsl(217,24%,40%)',
        border: 'hsl(217,22%,50%)',
        borderSubtle: 'hsl(217,22%,60%)',
        primary: 'hsl(267,67%,47%)',
        secondary: 'hsl(218,18%,53%)',
        info: 'hsl(206,100%,36%)',
        success: 'hsl(155,100%,26%)',
        notice: 'hsl(45,100%,31%)',
        warning: 'hsl(30,99%,34%)',
        danger: 'hsl(334,100%,35%)',
      },
    },
    {
      id: 'high-contrast-dark',
      label: 'High Contrast Dark',
      dark: true,
      base: {
        surface: 'hsl(0,0%,0%)',
        surfaceHighlight: 'hsl(0,0%,20%)',
        text: 'hsl(0,0%,100%)',
        textSubtle: 'hsl(0,0%,90%)',
        textSubtlest: 'hsl(0,0%,80%)',
        selection: 'hsl(276,100%,30%)',
        surfaceActive: 'hsl(276,100%,30%)',
        border: 'hsl(0,0%,60%)',
        primary: 'hsl(266,100%,85%)',
        secondary: 'hsl(242,20%,72%)',
        info: 'hsl(208,100%,83%)',
        success: 'hsl(150,100%,63%)',
        notice: 'hsl(49,100%,77%)',
        warning: 'hsl(28,100%,73%)',
        danger: 'hsl(343,100%,79%)',
      },
    },
    {
      id: 'catppuccin-frappe',
      label: 'Catppuccin Frappé',
      dark: true,
      base: {
        surface: 'hsl(231,19%,20%)',
        text: 'hsl(227,70%,87%)',
        textSubtle: 'hsl(228,29%,73%)',
        textSubtlest: 'hsl(227,17%,58%)',
        primary: 'hsl(277,59%,76%)',
        secondary: 'hsl(228,39%,80%)',
        info: 'hsl(222,74%,74%)',
        success: 'hsl(96,44%,68%)',
        notice: 'hsl(40,62%,73%)',
        warning: 'hsl(20,79%,70%)',
        danger: 'hsl(359,68%,71%)',
      },
      components: {
        dialog: {
          surface: 'hsl(240,21%,12%)',
        },
        sidebar: {
          surface: 'hsl(229,19%,23%)',
          border: 'hsl(229,19%,27%)',
        },
        appHeader: {
          surface: 'hsl(229,20%,17%)',
          border: 'hsl(229,20%,25%)',
        },
        responsePane: {
          surface: 'hsl(229,19%,23%)',
          border: 'hsl(229,19%,27%)',
        },
        button: {
          primary: 'hsl(277,59%,68%)',
          secondary: 'hsl(228,39%,72%)',
          info: 'hsl(222,74%,67%)',
          success: 'hsl(96,44%,61%)',
          notice: 'hsl(40,62%,66%)',
          warning: 'hsl(20,79%,63%)',
          danger: 'hsl(359,68%,64%)',
        },
      },
    },
    {
      id: 'catppuccin-macchiato',
      label: 'Catppuccin Macchiato',
      dark: true,
      base: {
        surface: 'hsl(233,23%,15%)',
        text: 'hsl(227,68%,88%)',
        textSubtle: 'hsl(227,27%,72%)',
        textSubtlest: 'hsl(228,15%,57%)',
        primary: 'hsl(267,83%,80%)',
        secondary: 'hsl(228,39%,80%)',
        info: 'hsl(220,83%,75%)',
        success: 'hsl(105,48%,72%)',
        notice: 'hsl(40,70%,78%)',
        warning: 'hsl(21,86%,73%)',
        danger: 'hsl(351,74%,73%)',
      },
      components: {
        dialog: {
          surface: 'hsl(240,21%,12%)',
        },
        sidebar: {
          surface: 'hsl(232,23%,18%)',
          border: 'hsl(231,23%,22%)',
        },
        appHeader: {
          surface: 'hsl(236,23%,12%)',
          border: 'hsl(236,23%,21%)',
        },
        responsePane: {
          surface: 'hsl(232,23%,18%)',
          border: 'hsl(231,23%,22%)',
        },
        button: {
          primary: 'hsl(267,82%,72%)',
          secondary: 'hsl(228,39%,72%)',
          info: 'hsl(220,83%,68%)',
          success: 'hsl(105,48%,65%)',
          notice: 'hsl(40,70%,70%)',
          warning: 'hsl(21,86%,66%)',
          danger: 'hsl(351,74%,66%)',
        },
      },
    },
    {
      id: 'catppuccin-mocha',
      label: 'Catppuccin Mocha',
      dark: true,
      base: {
        surface: 'hsl(240,21%,12%)',
        text: 'hsl(226,64%,88%)',
        textSubtle: 'hsl(228,24%,72%)',
        textSubtlest: 'hsl(230,13%,55%)',
        primary: 'hsl(267,83%,80%)',
        secondary: 'hsl(227,35%,80%)',
        info: 'hsl(217,92%,76%)',
        success: 'hsl(115,54%,76%)',
        notice: 'hsl(41,86%,83%)',
        warning: 'hsl(23,92%,75%)',
        danger: 'hsl(343,81%,75%)',
      },
      components: {
        dialog: {
          surface: 'hsl(240,21%,12%)',
        },
        sidebar: {
          surface: 'hsl(240,21%,15%)',
          border: 'hsl(240,21%,19%)',
        },
        appHeader: {
          surface: 'hsl(240,23%,9%)',
          border: 'hsl(240,22%,18%)',
        },
        responsePane: {
          surface: 'hsl(240,21%,15%)',
          border: 'hsl(240,21%,19%)',
        },
        button: {
          primary: 'hsl(267,67%,65%)',
          secondary: 'hsl(227,28%,64%)',
          info: 'hsl(217,74%,61%)',
          success: 'hsl(115,43%,61%)',
          notice: 'hsl(41,69%,66%)',
          warning: 'hsl(23,74%,60%)',
          danger: 'hsl(343,65%,60%)',
        },
      },
    },
    {
      id: 'catppuccin-latte',
      label: 'Catppuccin Latte',
      dark: false,
      base: {
        surface: 'hsl(220,23%,95%)',
        text: 'hsl(234,16%,35%)',
        textSubtle: 'hsl(233,10%,47%)',
        textSubtlest: 'hsl(231,10%,59%)',
        primary: 'hsl(266,85%,58%)',
        secondary: 'hsl(233,10%,47%)',
        info: 'hsl(231,97%,72%)',
        success: 'hsl(183,74%,35%)',
        notice: 'hsl(35,77%,49%)',
        warning: 'hsl(22,99%,52%)',
        danger: 'hsl(355,76%,59%)',
      },
      components: {
        sidebar: {
          surface: 'hsl(220,22%,92%)',
          border: 'hsl(220,22%,87%)',
        },
        appHeader: {
          surface: 'hsl(220,21%,89%)',
          border: 'hsl(220,22%,87%)',
        },
      },
    },
    {
      id: 'dracula',
      label: 'Dracula',
      dark: true,
      base: {
        surface: 'hsl(231,15%,18%)',
        surfaceHighlight: 'hsl(230,15%,24%)',
        text: 'hsl(60,30%,96%)',
        textSubtle: 'hsl(232,14%,65%)',
        textSubtlest: 'hsl(232,14%,50%)',
        primary: 'hsl(265,89%,78%)',
        secondary: 'hsl(225,27%,51%)',
        info: 'hsl(191,97%,77%)',
        success: 'hsl(135,94%,65%)',
        notice: 'hsl(65,92%,76%)',
        warning: 'hsl(31,100%,71%)',
        danger: 'hsl(0,100%,67%)',
      },
      components: {
        sidebar: {
          backdrop: 'hsl(230,15%,24%)',
        },
        appHeader: {
          backdrop: 'hsl(235,14%,15%)',
        },
      },
    },
    {
      id: 'github-dark',
      label: 'GitHub',
      dark: true,
      base: {
        surface: 'hsl(213,30%,7%)',
        surfaceHighlight: 'hsl(213,16%,13%)',
        text: 'hsl(212,27%,89%)',
        textSubtle: 'hsl(212,9%,57%)',
        textSubtlest: 'hsl(217,8%,45%)',
        border: 'hsl(215,21%,11%)',
        primary: 'hsl(262,78%,74%)',
        secondary: 'hsl(217,8%,50%)',
        info: 'hsl(215,84%,64%)',
        success: 'hsl(129,48%,52%)',
        notice: 'hsl(39,71%,58%)',
        warning: 'hsl(22,83%,60%)',
        danger: 'hsl(3,83%,65%)',
      },
      components: {
        button: {
          primary: 'hsl(262,79%,71%)',
          secondary: 'hsl(217,8%,45%)',
          info: 'hsl(215,84%,60%)',
          success: 'hsl(129,48%,47%)',
          notice: 'hsl(39,71%,53%)',
          warning: 'hsl(22,83%,56%)',
          danger: 'hsl(3,83%,61%)',
        },
      },
    },
    {
      id: 'github-light',
      label: 'GitHub',
      dark: false,
      base: {
        surface: 'hsl(0,0%,100%)',
        surfaceHighlight: 'hsl(210,29%,94%)',
        text: 'hsl(213,13%,14%)',
        textSubtle: 'hsl(212,9%,43%)',
        textSubtlest: 'hsl(203,8%,55%)',
        border: 'hsl(210,15%,92%)',
        borderSubtle: 'hsl(210,15%,92%)',
        primary: 'hsl(261,69%,59%)',
        secondary: 'hsl(212,8%,47%)',
        info: 'hsl(212,92%,48%)',
        success: 'hsl(137,66%,32%)',
        notice: 'hsl(40,100%,40%)',
        warning: 'hsl(24,100%,44%)',
        danger: 'hsl(356,71%,48%)',
      },
    },
    {
      id: 'gruvbox',
      label: 'Gruvbox',
      dark: true,
      base: {
        surface: 'hsl(0,0%,16%)',
        surfaceHighlight: 'hsl(20,3%,19%)',
        text: 'hsl(53,74%,91%)',
        textSubtle: 'hsl(39,24%,66%)',
        textSubtlest: 'hsl(30,12%,51%)',
        primary: 'hsl(344,47%,68%)',
        secondary: 'hsl(157,16%,58%)',
        info: 'hsl(104,35%,62%)',
        success: 'hsl(61,66%,44%)',
        notice: 'hsl(42,95%,58%)',
        warning: 'hsl(27,99%,55%)',
        danger: 'hsl(6,96%,59%)',
      },
    },
    {
      id: 'hotdog-stand',
      label: 'Hotdog Stand',
      dark: true,
      base: {
        surface: 'hsl(0,100%,50%)',
        surfaceHighlight: 'hsl(0,0%,0%)',
        text: 'hsl(0,0%,100%)',
        textSubtle: 'hsl(0,0%,100%)',
        textSubtlest: 'hsl(60,100%,50%)',
        border: 'hsl(0,0%,0%)',
        primary: 'hsl(60,100%,50%)',
        secondary: 'hsl(60,100%,50%)',
        info: 'hsl(60,100%,50%)',
        success: 'hsl(60,100%,50%)',
        notice: 'hsl(60,100%,50%)',
        warning: 'hsl(60,100%,50%)',
        danger: 'hsl(60,100%,50%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(0,0%,0%)',
          text: 'hsl(0,0%,100%)',
          textSubtle: 'hsl(60,100%,50%)',
          textSubtlest: 'hsl(0,100%,50%)',
        },
        menu: {
          surface: 'hsl(0,0%,0%)',
          border: 'hsl(0,100%,50%)',
          surfaceHighlight: 'hsl(0,100%,50%)',
          text: 'hsl(0,0%,100%)',
          textSubtle: 'hsl(60,100%,50%)',
          textSubtlest: 'hsl(60,100%,50%)',
        },
        button: {
          surface: 'hsl(0,0%,0%)',
          text: 'hsl(0,0%,100%)',
          primary: 'hsl(0,0%,0%)',
          secondary: 'hsl(0,0%,100%)',
          info: 'hsl(0,0%,0%)',
          success: 'hsl(60,100%,50%)',
          notice: 'hsl(60,100%,50%)',
          warning: 'hsl(0,0%,0%)',
          danger: 'hsl(0,100%,50%)',
        },
        editor: {
          primary: 'hsl(0,0%,100%)',
          secondary: 'hsl(0,0%,100%)',
          info: 'hsl(0,0%,100%)',
          success: 'hsl(0,0%,100%)',
          notice: 'hsl(60,100%,50%)',
          warning: 'hsl(0,0%,100%)',
          danger: 'hsl(0,0%,100%)',
        },
      },
    },
    {
      id: 'monokai-pro',
      label: 'Monokai Pro',
      dark: true,
      base: {
        surface: 'hsl(285,5%,17%)',
        text: 'hsl(60,25%,98%)',
        textSubtle: 'hsl(0,1%,75%)',
        textSubtlest: 'hsl(300,0%,57%)',
        primary: 'hsl(250,77%,78%)',
        secondary: 'hsl(0,1%,75%)',
        info: 'hsl(186,71%,69%)',
        success: 'hsl(90,59%,66%)',
        notice: 'hsl(45,100%,70%)',
        warning: 'hsl(20,96%,70%)',
        danger: 'hsl(345,100%,69%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(300,5%,13%)',
          text: 'hsl(0,1%,75%)',
          textSubtle: 'hsl(300,0%,57%)',
          textSubtlest: 'hsl(300,1%,44%)',
        },
        button: {
          primary: 'hsl(250,77%,70%)',
          secondary: 'hsl(0,1%,68%)',
          info: 'hsl(186,71%,62%)',
          success: 'hsl(90,59%,59%)',
          notice: 'hsl(45,100%,63%)',
          warning: 'hsl(20,96%,63%)',
          danger: 'hsl(345,100%,62%)',
        },
      },
    },
    {
      id: 'monokai-pro-classic',
      label: 'Monokai Pro Classic',
      dark: true,
      base: {
        surface: 'hsl(70,8%,15%)',
        text: 'hsl(69,100%,97%)',
        textSubtle: 'hsl(65,9%,73%)',
        textSubtlest: 'hsl(66,4%,55%)',
        primary: 'hsl(261,100%,75%)',
        secondary: 'hsl(202,8%,72%)',
        info: 'hsl(190,81%,67%)',
        success: 'hsl(80,76%,53%)',
        notice: 'hsl(54,70%,68%)',
        warning: 'hsl(32,98%,56%)',
        danger: 'hsl(338,95%,56%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(72,9%,11%)',
          text: 'hsl(202,8%,72%)',
          textSubtle: 'hsl(213,4%,48%)',
          textSubtlest: 'hsl(223,6%,44%)',
        },
        button: {
          primary: 'hsl(261,100%,68%)',
          secondary: 'hsl(202,8%,65%)',
          info: 'hsl(190,81%,60%)',
          success: 'hsl(80,76%,48%)',
          notice: 'hsl(54,71%,61%)',
          warning: 'hsl(32,98%,50%)',
          danger: 'hsl(338,95%,50%)',
        },
      },
    },
    {
      id: 'monokai-pro-machine',
      label: 'Monokai Pro Machine',
      dark: true,
      base: {
        surface: 'hsl(200,16%,18%)',
        text: 'hsl(173,24%,93%)',
        textSubtle: 'hsl(185,6%,57%)',
        textSubtlest: 'hsl(189,6%,45%)',
        primary: 'hsl(258,86%,80%)',
        secondary: 'hsl(175,9%,75%)',
        info: 'hsl(194,81%,72%)',
        success: 'hsl(98,67%,69%)',
        notice: 'hsl(52,100%,72%)',
        warning: 'hsl(28,100%,72%)',
        danger: 'hsl(353,100%,71%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(196,16%,14%)',
          text: 'hsl(202,8%,72%)',
          textSubtle: 'hsl(213,4%,48%)',
          textSubtlest: 'hsl(223,6%,44%)',
        },
        button: {
          primary: 'hsl(258,86%,72%)',
          secondary: 'hsl(175,9%,68%)',
          info: 'hsl(194,80%,65%)',
          success: 'hsl(98,67%,62%)',
          notice: 'hsl(52,100%,65%)',
          warning: 'hsl(28,100%,65%)',
          danger: 'hsl(353,100%,64%)',
        },
      },
    },
    {
      id: 'monokai-pro-octagon',
      label: 'Monokai Pro Octagon',
      dark: true,
      base: {
        surface: 'hsl(233,18%,19%)',
        text: 'hsl(173,24%,93%)',
        textSubtle: 'hsl(202,8%,72%)',
        textSubtlest: 'hsl(213,4%,48%)',
        primary: 'hsl(292,30%,70%)',
        secondary: 'hsl(202,8%,72%)',
        info: 'hsl(155,37%,72%)',
        success: 'hsl(75,60%,61%)',
        notice: 'hsl(44,100%,71%)',
        warning: 'hsl(23,100%,68%)',
        danger: 'hsl(352,100%,70%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(235,18%,14%)',
          text: 'hsl(202,8%,72%)',
          textSubtle: 'hsl(213,4%,48%)',
          textSubtlest: 'hsl(223,6%,44%)',
        },
        button: {
          primary: 'hsl(292,26%,63%)',
          secondary: 'hsl(201,7%,65%)',
          info: 'hsl(155,33%,65%)',
          success: 'hsl(75,54%,55%)',
          notice: 'hsl(44,90%,64%)',
          warning: 'hsl(23,90%,61%)',
          danger: 'hsl(352,90%,63%)',
        },
      },
    },
    {
      id: 'monokai-pro-ristretto',
      label: 'Monokai Pro Ristretto',
      dark: true,
      base: {
        surface: 'hsl(0,9%,16%)',
        text: 'hsl(351,100%,97%)',
        textSubtle: 'hsl(355,9%,74%)',
        textSubtlest: 'hsl(354,4%,56%)',
        primary: 'hsl(239,63%,79%)',
        secondary: 'hsl(355,9%,74%)',
        info: 'hsl(170,53%,69%)',
        success: 'hsl(88,57%,66%)',
        notice: 'hsl(41,92%,70%)',
        warning: 'hsl(13,85%,70%)',
        danger: 'hsl(349,97%,70%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(0,8%,12%)',
          text: 'hsl(355,9%,74%)',
          textSubtle: 'hsl(354,4%,56%)',
          textSubtlest: 'hsl(353,4%,43%)',
        },
        button: {
          primary: 'hsl(239,63%,71%)',
          secondary: 'hsl(355,9%,67%)',
          info: 'hsl(170,53%,62%)',
          success: 'hsl(88,57%,59%)',
          notice: 'hsl(41,92%,63%)',
          warning: 'hsl(13,86%,63%)',
          danger: 'hsl(349,97%,63%)',
        },
      },
    },
    {
      id: 'monokai-pro-spectrum',
      label: 'Monokai Pro Spectrum',
      dark: true,
      base: {
        surface: 'hsl(0,0%,13%)',
        text: 'hsl(266,100%,97%)',
        textSubtle: 'hsl(264,7%,73%)',
        textSubtlest: 'hsl(266,3%,55%)',
        primary: 'hsl(247,61%,72%)',
        secondary: 'hsl(264,7%,73%)',
        info: 'hsl(188,74%,63%)',
        success: 'hsl(133,54%,66%)',
        notice: 'hsl(51,96%,69%)',
        warning: 'hsl(23,98%,66%)',
        danger: 'hsl(343,96%,68%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(0,0%,10%)',
          text: 'hsl(264,7%,73%)',
          textSubtle: 'hsl(266,3%,55%)',
          textSubtlest: 'hsl(264,2%,41%)',
        },
        button: {
          primary: 'hsl(247,61%,65%)',
          secondary: 'hsl(264,7%,66%)',
          info: 'hsl(188,74%,57%)',
          success: 'hsl(133,54%,59%)',
          notice: 'hsl(51,96%,62%)',
          warning: 'hsl(23,98%,59%)',
          danger: 'hsl(343,96%,61%)',
        },
      },
    },
    {
      id: 'moonlight',
      label: 'Moonlight',
      dark: true,
      base: {
        surface: 'hsl(234,23%,17%)',
        text: 'hsl(225,71%,90%)',
        textSubtle: 'hsl(230,28%,62%)',
        textSubtlest: 'hsl(232,26%,43%)',
        primary: 'hsl(262,100%,82%)',
        secondary: 'hsl(232,18%,65%)',
        info: 'hsl(217,100%,74%)',
        success: 'hsl(174,66%,54%)',
        notice: 'hsl(35,100%,73%)',
        warning: 'hsl(17,100%,71%)',
        danger: 'hsl(356,100%,73%)',
      },
      components: {
        appHeader: {
          surface: 'hsl(233,23%,15%)',
        },
        sidebar: {
          surface: 'hsl(233,23%,15%)',
        },
      },
    },
    {
      id: 'nord',
      label: 'Nord',
      dark: true,
      base: {
        surface: 'hsl(220,16%,22%)',
        surfaceHighlight: 'hsl(220,14%,28%)',
        text: 'hsl(220,28%,93%)',
        textSubtle: 'hsl(220,26%,90%)',
        textSubtlest: 'hsl(220,24%,86%)',
        primary: 'hsl(193,38%,68%)',
        secondary: 'hsl(210,34%,63%)',
        info: 'hsl(174,25%,69%)',
        success: 'hsl(89,26%,66%)',
        notice: 'hsl(40,66%,73%)',
        warning: 'hsl(17,48%,64%)',
        danger: 'hsl(353,43%,56%)',
      },
      components: {
        sidebar: {
          backdrop: 'hsl(220,16%,22%)',
        },
        appHeader: {
          backdrop: 'hsl(220,14%,28%)',
        },
      },
    },
    {
      id: 'relaxing',
      label: 'Relaxing',
      dark: true,
      base: {
        surface: 'hsl(267,33%,17%)',
        text: 'hsl(275,49%,92%)',
        primary: 'hsl(267,84%,81%)',
        secondary: 'hsl(227,35%,80%)',
        info: 'hsl(217,92%,76%)',
        success: 'hsl(115,54%,76%)',
        notice: 'hsl(41,86%,83%)',
        warning: 'hsl(23,92%,75%)',
        danger: 'hsl(343,81%,75%)',
      },
    },
    {
      id: 'rose-pine',
      label: 'Rosé Pine',
      dark: true,
      base: {
        surface: 'hsl(249,22%,12%)',
        text: 'hsl(245,50%,91%)',
        textSubtle: 'hsl(248,15%,61%)',
        textSubtlest: 'hsl(249,12%,47%)',
        primary: 'hsl(267,57%,78%)',
        secondary: 'hsl(249,12%,47%)',
        info: 'hsl(199,49%,60%)',
        success: 'hsl(180,43%,73%)',
        notice: 'hsl(35,88%,72%)',
        warning: 'hsl(1,74%,79%)',
        danger: 'hsl(343,76%,68%)',
      },
      components: {
        responsePane: {
          surface: 'hsl(247,23%,15%)',
        },
        sidebar: {
          surface: 'hsl(247,23%,15%)',
        },
        menu: {
          surface: 'hsl(248,21%,26%)',
          textSubtle: 'hsl(248,15%,66%)',
          textSubtlest: 'hsl(249,12%,52%)',
          border: 'hsl(248,21%,35%)',
          borderSubtle: 'hsl(248,21%,33%)',
        },
      },
    },
    {
      id: 'rose-pine-moon',
      label: 'Rosé Pine Moon',
      dark: true,
      base: {
        surface: 'hsl(246,24%,17%)',
        text: 'hsl(245,50%,91%)',
        textSubtle: 'hsl(248,15%,61%)',
        textSubtlest: 'hsl(249,12%,47%)',
        primary: 'hsl(267,57%,78%)',
        secondary: 'hsl(248,15%,61%)',
        info: 'hsl(197,48%,60%)',
        success: 'hsl(197,48%,60%)',
        notice: 'hsl(35,88%,72%)',
        warning: 'hsl(2,66%,75%)',
        danger: 'hsl(343,76%,68%)',
      },
      components: {
        responsePane: {
          surface: 'hsl(247,24%,20%)',
        },
        sidebar: {
          surface: 'hsl(247,24%,20%)',
        },
        menu: {
          surface: 'hsl(248,21%,26%)',
          textSubtle: 'hsl(248,15%,61%)',
          textSubtlest: 'hsl(249,12%,55%)',
          border: 'hsl(248,21%,35%)',
          borderSubtle: 'hsl(248,21%,31%)',
        },
      },
    },
    {
      id: 'rose-pine-dawn',
      label: 'Rosé Pine Dawn',
      dark: false,
      base: {
        surface: 'hsl(32,57%,95%)',
        border: 'hsl(10,9%,86%)',
        surfaceHighlight: 'hsl(25,35%,93%)',
        text: 'hsl(248,19%,40%)',
        textSubtle: 'hsl(248,12%,52%)',
        textSubtlest: 'hsl(257,9%,61%)',
        primary: 'hsl(271,27%,56%)',
        secondary: 'hsl(249,12%,47%)',
        info: 'hsl(197,52%,36%)',
        success: 'hsl(188,31%,45%)',
        notice: 'hsl(34,64%,49%)',
        warning: 'hsl(2,47%,64%)',
        danger: 'hsl(343,35%,55%)',
      },
      components: {
        responsePane: {
          border: 'hsl(20,12%,90%)',
        },
        sidebar: {
          border: 'hsl(20,12%,90%)',
        },
        appHeader: {
          border: 'hsl(20,12%,90%)',
        },
        input: {
          border: 'hsl(10,9%,86%)',
        },
        dialog: {
          border: 'hsl(20,12%,90%)',
        },
        menu: {
          surface: 'hsl(28,40%,92%)',
          border: 'hsl(10,9%,86%)',
        },
      },
    },
  ],
};
