// Code generated by go generate; DO NOT EDIT.

package template // import "miniflux.app/template"

var templateViewsMap = map[string]string{
	"about": `{{ define "title"}}{{ t "page.about.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.about.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.preferences" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        {{ end }}
    </ul>
</section>

<div class="panel">
    <h3>Miniflux</h3>
    <ul>
        <li><strong>{{ t "page.about.version" }}</strong> {{ .version }}</li>
        <li><strong>{{ t "page.about.build_date" }}</strong> {{ .build_date }}</li>
    </ul>
</div>

<div class="panel">
    <h3>{{ t "page.about.credits" }}</h3>
    <ul>
        <li><strong>{{ t "page.about.author" }}</strong> Frédéric Guillot</li>
        <li><strong>{{ t "page.about.license" }}</strong> Apache 2.0</li>
    </ul>
</div>

{{ end }}
`,
	"add_subscription": `{{ define "title"}}{{ t "page.add_feed.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.add_feed.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "menu.feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "menu.export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "menu.import" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "page.add_feed.no_category" }}</p>
{{ else }}
    <form action="{{ route "submitSubscription" }}" method="post" autocomplete="off">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-url">{{ t "page.add_feed.label.url" }}</label>
        <input type="url" name="url" id="form-url" placeholder="https://domain.tld/" value="{{ .form.URL }}" required autofocus>

        <label for="form-category">{{ t "form.feed.label.category" }}</label>
        <select id="form-category" name="category_id">
            {{ range .categories }}
                <option value="{{ .ID }}">{{ .Title }}</option>
            {{ end }}
        </select>

        <details>
            <summary>{{ t "page.add_feed.legend.advanced_options" }}</summary>
            <div class="details-content">
                <label><input type="checkbox" name="crawler" value="1" {{ if .form.Crawler }}checked{{ end }}> {{ t "form.feed.label.crawler" }}</label>

                <label for="form-user-agent">{{ t "form.feed.label.user_agent" }}</label>
                <input type="text" name="user_agent" id="form-user-agent" placeholder="{{ .defaultUserAgent }}" value="{{ .form.UserAgent }}" autocomplete="off">

                <label for="form-feed-username">{{ t "form.feed.label.feed_username" }}</label>
                <input type="text" name="feed_username" id="form-feed-username" value="{{ .form.Username }}">

                <label for="form-feed-password">{{ t "form.feed.label.feed_password" }}</label>
                <!--
                    We are using the type "text" otherwise Firefox always autocomplete this password:

                    - autocomplete="off" or autocomplete="new-password" doesn't change anything
                    - Changing the input ID doesn't change anything
                    - Using a different input name doesn't change anything
                -->
                <input type="text" name="feed_password" id="form-feed-password" value="{{ .form.Password }}">
            </div>
        </details>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.loading" }}">{{ t "page.add_feed.submit" }}</button>
        </div>
    </form>
{{ end }}

{{ end }}
`,
	"bookmark_entries": `{{ define "title"}}{{ t "page.starred.title" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.starred.title" }} ({{ .total }})</h1>
</section>

{{ if not .entries }}
    <p class="alert alert-info">{{ t "alert.no_bookmark" }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "starredEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"categories": `{{ define "title"}}{{ t "page.categories.title" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.categories.title" }} ({{ .total }})</h1>
    <ul>
        <li>
            <a href="{{ route "createCategory" }}">{{ t "menu.create_category" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "alert.no_category" }}</p>
{{ else }}
    <div class="items">
        {{ range .categories }}
        <article class="item">
            <div class="item-header">
                <span class="item-title">
                    <a href="{{ route "categoryEntries" "categoryID" .ID }}">{{ .Title }}</a>
                </span>
            </div>
            <div class="item-meta">
                <ul>
                    <li>
                        {{ if eq .FeedCount 0 }}
                            {{ t "page.categories.no_feed" }}
                        {{ else }}
                            {{ plural "page.categories.feed_count" .FeedCount .FeedCount }}
                        {{ end }}
                    </li>
                </ul>
                <ul>
                    <li>
                        <a href="{{ route "editCategory" "categoryID" .ID }}">{{ t "menu.edit_category" }}</a>
                    </li>
                    {{ if eq .FeedCount 0 }}
                    <li>
                        <a href="#"
                            data-confirm="true"
                            data-label-question="{{ t "confirm.question" }}"
                            data-label-yes="{{ t "confirm.yes" }}"
                            data-label-no="{{ t "confirm.no" }}"
                            data-label-loading="{{ t "confirm.loading" }}"
                            data-url="{{ route "removeCategory" "categoryID" .ID }}">{{ t "action.remove" }}</a>
                    </li>
                    {{ end }}
                </ul>
            </div>
        </article>
        {{ end }}
    </div>
{{ end }}

{{ end }}
`,
	"category_entries": `{{ define "title"}}{{ .category.Title }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .category.Title }} ({{ .total }})</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert">{{ t "alert.no_category_entry" }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "categoryEntry" "categoryID" .Feed.Category.ID "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry  }}
        </article>
        {{ end }}
    </div>
    <section class="page-footer">
        {{ if .entries }}
        <ul>
            <li>
                <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
            </li>
        </ul>
        {{ end }}
    </section>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"choose_subscription": `{{ define "title"}}{{ t "page.add_feed.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.add_feed.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "menu.feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "menu.export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "menu.import" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "chooseSubscription" }}" method="POST">
    <input type="hidden" name="csrf" value="{{ .csrf }}">
    <input type="hidden" name="category_id" value="{{ .form.CategoryID }}">
    <input type="hidden" name="user_agent" value="{{ .form.UserAgent }}">
    <input type="hidden" name="feed_username" value="{{ .form.Username }}">
    <input type="hidden" name="feed_password" value="{{ .form.Password }}">
    {{ if .form.Crawler }}
        <input type="hidden" name="crawler" value="1">
    {{ end }}

    <h3>{{ t "page.add_feed.choose_feed" }}</h3>

    {{ range .subscriptions }}
        <div class="radio-group">
            <label title="{{ .URL }}"><input type="radio" name="url" value="{{ .URL }}"> {{ .Title }}</label> ({{ .Type }})
            <small title="Type = {{ .Type }}"><a href="{{ .URL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ .URL }}</a></small>
        </div>
    {{ end }}

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.loading" }}">{{ t "action.subscribe" }}</button>
    </div>
</form>
{{ end }}
`,
	"create_category": `{{ define "title"}}{{ t "page.new_category.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.new_category.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "categories" }}">{{ t "menu.categories" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "saveCategory" }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-title">{{ t "form.category.label.title" }}</label>
    <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.save" }}</button> {{ t "action.or" }} <a href="{{ route "categories" }}">{{ t "action.cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"create_user": `{{ define "title"}}{{ t "page.new_user.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.new_user.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "saveUser" }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "form.user.label.username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" autocomplete="new-password" required autofocus>

    <label for="form-password">{{ t "form.user.label.password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}" autocomplete="new-password" required>

    <label for="form-confirmation">{{ t "form.user.label.confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}" required>

    <label><input type="checkbox" name="is_admin" value="1" {{ if .form.IsAdmin }}checked{{ end }}> {{ t "form.user.label.admin" }}</label>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.save" }}</button> {{ t "action.or" }} <a href="{{ route "users" }}">{{ t "action.cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"edit_category": `{{ define "title"}}{{ t "page.edit_category.title" .category.Title }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.edit_category.title" .category.Title }}</h1>
    <ul>
        <li>
            <a href="{{ route "categories" }}">{{ t "menu.categories" }}</a>
        </li>
        <li>
            <a href="{{ route "createCategory" }}">{{ t "menu.create_category" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "updateCategory" "categoryID" .category.ID }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-title">{{ t "form.category.label.title" }}</label>
    <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.update" }}</button> {{ t "action.or" }} <a href="{{ route "categories" }}">{{ t "action.cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"edit_feed": `{{ define "title"}}{{ t "page.edit_feed.title" .feed.Title }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .feed.Title }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "menu.feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "menu.add_feed" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "menu.export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "menu.import" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "page.add_feed.no_category" }}</p>
{{ else }}
    {{ if ne .feed.ParsingErrorCount 0 }}
    <div class="alert alert-error">
        <h3>{{ t "page.edit_feed.last_parsing_error" }}</h3>
        <p>{{ t .feed.ParsingErrorMsg }}</p>
    </div>
    {{ end }}

    <form action="{{ route "updateFeed" "feedID" .feed.ID }}" method="post" autocomplete="off">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-title">{{ t "form.feed.label.title" }}</label>
        <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

        <label for="form-site-url">{{ t "form.feed.label.site_url" }}</label>
        <input type="url" name="site_url" id="form-site-url" placeholder="https://domain.tld/" value="{{ .form.SiteURL }}" required>

        <label for="form-feed-url">{{ t "form.feed.label.feed_url" }}</label>
        <input type="url" name="feed_url" id="form-feed-url" placeholder="https://domain.tld/" value="{{ .form.FeedURL }}" required>

        <label for="form-feed-username">{{ t "form.feed.label.feed_username" }}</label>
        <input type="text" name="feed_username" id="form-feed-username" value="{{ .form.Username }}">

        <label for="form-feed-password">{{ t "form.feed.label.feed_password" }}</label>
        <!--
            We are using the type "text" otherwise Firefox always autocomplete this password:

            - autocomplete="off" or autocomplete="new-password" doesn't change anything
            - Changing the input ID doesn't change anything
            - Using a different input name doesn't change anything
        -->
        <input type="text" name="feed_password" id="form-feed-password" value="{{ .form.Password }}">

	    <label for="form-user-agent">{{ t "form.feed.label.user_agent" }}</label>
	    <input type="text" name="user_agent" id="form-user-agent" placeholder="{{ .defaultUserAgent }}" value="{{ .form.UserAgent }}">

        <label for="form-scraper-rules">{{ t "form.feed.label.scraper_rules" }}</label>
        <input type="text" name="scraper_rules" id="form-scraper-rules" value="{{ .form.ScraperRules }}">

        <label for="form-rewrite-rules">{{ t "form.feed.label.rewrite_rules" }}</label>
        <input type="text" name="rewrite_rules" id="form-rewrite-rules" value="{{ .form.RewriteRules }}">

        <label for="form-category">{{ t "form.feed.label.category" }}</label>
        <select id="form-category" name="category_id">
        {{ range .categories }}
            <option value="{{ .ID }}" {{ if eq .ID $.form.CategoryID }}selected="selected"{{ end }}>{{ .Title }}</option>
        {{ end }}
        </select>

        <label><input type="checkbox" name="crawler" value="1" {{ if .form.Crawler }}checked{{ end }}> {{ t "form.feed.label.crawler" }}</label>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.update" }}</button> {{ t "action.or" }} <a href="{{ route "feeds" }}">{{ t "action.cancel" }}</a>
        </div>
    </form>

    <div class="panel">
        <ul>
            <li><strong>{{ t "page.edit_feed.last_check" }} </strong><time datetime="{{ isodate .feed.CheckedAt }}" title="{{ isodate .feed.CheckedAt }}">{{ elapsed $.user.Timezone .feed.CheckedAt }}</time></li>
            <li><strong>{{ t "page.edit_feed.etag_header" }} </strong>{{ if .feed.EtagHeader }}{{ .feed.EtagHeader }}{{ else }}{{ t "page.edit_feed.no_header" }}{{ end }}</li>
            <li><strong>{{ t "page.edit_feed.last_modified_header" }} </strong>{{ if .feed.LastModifiedHeader }}{{ .feed.LastModifiedHeader }}{{ else }}{{ t "page.edit_feed.no_header" }}{{ end }}</li>
        </ul>
    </div>

    <div class="alert alert-error">
        <a href="#"
            data-confirm="true"
            data-action="remove-feed"
            data-label-question="{{ t "confirm.question" }}"
            data-label-yes="{{ t "confirm.yes" }}"
            data-label-no="{{ t "confirm.no" }}"
            data-label-loading="{{ t "confirm.loading" }}"
            data-url="{{ route "removeFeed" "feedID" .feed.ID }}"
            data-redirect-url="{{ route "feeds" }}">{{ t "action.remove_feed" }}</a>
    </div>
{{ end }}

{{ end }}
`,
	"edit_user": `{{ define "title"}}{{ t "page.edit_user.title" .selected_user.Username }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.edit_user.title" .selected_user.Username }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "menu.add_user" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "updateUser" "userID" .selected_user.ID }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "form.user.label.username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" autocomplete="new-password" required autofocus>

    <label for="form-password">{{ t "form.user.label.password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}" autocomplete="new-password">

    <label for="form-confirmation">{{ t "form.user.label.confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}" autocomplete="new-password">

    <label><input type="checkbox" name="is_admin" value="1" {{ if .form.IsAdmin }}checked{{ end }}> {{ t "form.user.label.admin" }}</label>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.update" }}</button> {{ t "action.or" }} <a href="{{ route "users" }}">{{ t "action.cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"entry": `{{ define "title"}}{{ .entry.Title }}{{ end }}

{{ define "content"}}
<section class="entry" data-id="{{ .entry.ID }}">
    <header class="entry-header">
        <h1>
            <a href="{{ .entry.URL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ .entry.Title }}</a>
        </h1>
        <div class="entry-actions">
            <ul>
                <li>
                    <a href="#"
                        title="{{ t "entry.status.title" }}"
                        data-toggle-status="true"
                        data-label-read="✔&#xfe0e;&nbsp;{{ t "entry.status.read" }}"
                        data-label-unread="✘&nbsp;{{ t "entry.status.unread" }}"
                        data-value="{{ if eq .entry.Status "read" }}read{{ else }}unread{{ end }}"
                        >{{ if eq .entry.Status "read" }}✘&nbsp;{{ t "entry.status.unread" }}{{ else }}✔&#xfe0e;&nbsp;{{ t "entry.status.read" }}{{ end }}</a>
                </li>
                <li>
                    <a href="#"
                        data-toggle-bookmark="true"
                        data-bookmark-url="{{ route "toggleBookmark" "entryID" .entry.ID }}"
                        data-label-loading="{{ t "entry.state.saving" }}"
                        data-label-star="☆&nbsp;{{ t "entry.bookmark.toggle.on" }}"
                        data-label-unstar="★&nbsp;{{ t "entry.bookmark.toggle.off" }}"
                        data-value="{{ if .entry.Starred }}star{{ else }}unstar{{ end }}"
                        >{{ if .entry.Starred }}★&nbsp;{{ t "entry.bookmark.toggle.off" }}{{ else }}☆&nbsp;{{ t "entry.bookmark.toggle.on" }}{{ end }}</a>
                </li>
                {{ if .hasSaveEntry }}
                    <li>
                        <a href="#"
                            title="{{ t "entry.save.title" }}"
                            data-save-entry="true"
                            data-save-url="{{ route "saveEntry" "entryID" .entry.ID }}"
                            data-label-loading="{{ t "entry.state.saving" }}"
                            data-label-done="{{ t "entry.save.completed" }}"
                            >{{ t "entry.save.title" }}</a>
                    </li>
                {{ end }}
                <li>
                    <a href="#"
                        title="{{ t "entry.scraper.title" }}"
                        data-fetch-content-entry="true"
                        data-fetch-content-url="{{ route "fetchContent" "entryID" .entry.ID }}"
                        data-label-loading="{{ t "entry.state.loading" }}"
                        data-label-done="{{ t "entry.scraper.completed" }}"
                        >{{ t "entry.scraper.label" }}</a>
                </li>
                {{ if .entry.CommentsURL }}
                    <li>
                        <a href="{{ .entry.CommentsURL }}" title="{{ t "entry.comments.title" }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ t "entry.comments.label" }}</a>
                    </li>
                {{ end }}
            </ul>
        </div>
        <div class="entry-meta">
            <span class="entry-website">
                {{ if ne .entry.Feed.Icon.IconID 0 }}
                    <img src="{{ route "icon" "iconID" .entry.Feed.Icon.IconID }}" width="16" height="16" alt="{{ .entry.Feed.Title }}">
                {{ end }}
                <a href="{{ route "feedEntries" "feedID" .entry.Feed.ID }}">{{ .entry.Feed.Title }}</a>
            </span>
            {{ if .entry.Author }}
                <span class="entry-author">
                    {{ if isEmail .entry.Author }}
                        - <a href="mailto:{{ .entry.Author }}">{{ .entry.Author }}</a>
                    {{ else }}
                        – <em>{{ .entry.Author }}</em>
                    {{ end }}
                </span>
            {{ end }}
            <span class="category">
                <a href="{{ route "categoryEntries" "categoryID" .entry.Feed.Category.ID }}">{{ .entry.Feed.Category.Title }}</a>
            </span>
        </div>
        <div class="entry-date">
            <time datetime="{{ isodate .entry.Date }}" title="{{ isodate .entry.Date }}">{{ elapsed $.user.Timezone .entry.Date }}</time>
        </div>
    </header>
    {{ if gt (len .entry.Content) 120 }}
    <div class="pagination-top">
        {{ template "entry_pagination" . }}
    </div>
    {{ end }}
    <article class="entry-content">
        {{ noescape (proxyFilter .entry.Content) }}
    </article>
    {{ if .entry.Enclosures }}
    <aside class="entry-enclosures">
        <h3>{{ t "Attachments" }}</h3>
        {{ range .entry.Enclosures }}
            <div class="entry-enclosure">
                {{ if hasPrefix .MimeType "audio/" }}
                    <div class="enclosure-audio">
                        <audio controls preload="metadata">
                            <source src="{{ .URL }}" type="{{ .MimeType }}">
                        </audio>
                    </div>
                {{ else if hasPrefix .MimeType "video/" }}
                    <div class="enclosure-video">
                        <video controls preload="metadata">
                            <source src="{{ .URL }}" type="{{ .MimeType }}">
                        </video>
                    </div>
                {{ else if hasPrefix .MimeType "image/" }}
                    <div class="enclosure-image">
                        <img src="{{ proxyURL .URL }}" title="{{ .URL }} ({{ .MimeType }})" alt="{{ .URL }} ({{ .MimeType }})">
                    </div>
                {{ end }}

                <div class="entry-enclosure-download">
                    <a href="{{ .URL }}" title="{{ .URL }} ({{ .MimeType }})" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ t "action.download" }}</a>
                    <small>({{ .URL }})</small>
                </div>
            </div>
        {{ end }}
    </aside>
    {{ end }}
</section>

<div class="pagination-bottom">
    {{ template "entry_pagination" . }}
</div>
{{ end }}
`,
	"feed_entries": `{{ define "title"}}{{ .feed.Title }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .feed.Title }} ({{ .total }})</h1>
    <ul>
        {{ if .entries }}
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "refreshFeed" "feedID" .feed.ID }}">{{ t "menu.refresh_feed" }}</a>
        </li>
        <li>
            <a href="{{ route "editFeed" "feedID" .feed.ID }}">{{ t "menu.edit_feed" }}</a>
        </li>
        <li>
            <a href="#"
                data-confirm="true"
                data-action="remove-feed"
                data-label-question="{{ t "confirm.question" }}"
                data-label-yes="{{ t "confirm.yes" }}"
                data-label-no="{{ t "confirm.no" }}"
                data-label-loading="{{ t "confirm.loading" }}"
                data-url="{{ route "removeFeed" "feedID" .feed.ID }}"
                data-redirect-url="{{ route "feeds" }}">{{ t "action.remove_feed" }}</a>
        </li>
    </ul>
</section>

{{ if ne .feed.ParsingErrorCount 0 }}
<div class="alert alert-error">
    <h3>{{ t "alert.feed_error" }}</h3>
    <p>{{ t .feed.ParsingErrorMsg }}</p>
</div>
{{ else if not .entries }}
    <p class="alert">{{ t "alert.no_feed_entry" }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "feedEntry" "feedID" .Feed.ID "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry }}
        </article>
        {{ end }}
    </div>
    <section class="page-footer">
        {{ if .entries }}
        <ul>
            <li>
                <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
            </li>
        </ul>
        {{ end }}
    </section>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"feeds": `{{ define "title"}}{{ t "page.feeds.title" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.feeds.title" }} ({{ .total }})</h1>
    <ul>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "menu.add_feed" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "menu.export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "menu.import" }}</a>
        </li>
        <li>
            <a href="{{ route "refreshAllFeeds" }}">{{ t "menu.refresh_all_feeds" }}</a>
        </li>
    </ul>
</section>

{{ if not .feeds }}
    <p class="alert">{{ t "alert.no_feed" }}</p>
{{ else }}
    <div class="items">
        {{ range .feeds }}
        <article class="item {{ if ne .ParsingErrorCount 0 }}feed-parsing-error{{ end }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if .Icon }}
                        <img src="{{ route "icon" "iconID" .Icon.IconID }}" width="16" height="16" alt="{{ .Title }}">
                    {{ end }}
                    <a href="{{ route "feedEntries" "feedID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category">
                    <a href="{{ route "categoryEntries" "categoryID" .Category.ID }}">{{ .Category.Title }}</a>
                </span>
            </div>
            <div class="item-meta">
                <ul>
                    <li>
                        <a href="{{ .SiteURL }}" title="{{ .SiteURL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer" data-original-link="true">{{ domain .SiteURL }}</a>
                    </li>
                    <li>
                        {{ t "page.feeds.last_check" }} <time datetime="{{ isodate .CheckedAt }}" title="{{ isodate .CheckedAt }}">{{ elapsed $.user.Timezone .CheckedAt }}</time>
                    </li>
                </ul>
                <ul>
                    <li>
                        <a href="{{ route "refreshFeed" "feedID" .ID }}">{{ t "menu.refresh_feed" }}</a>
                    </li>
                    <li>
                        <a href="{{ route "editFeed" "feedID" .ID }}">{{ t "menu.edit_feed" }}</a>
                    </li>
                    <li>
                        <a href="#"
                            data-confirm="true"
                            data-label-question="{{ t "confirm.question" }}"
                            data-label-yes="{{ t "confirm.yes" }}"
                            data-label-no="{{ t "confirm.no" }}"
                            data-label-loading="{{ t "confirm.loading" }}"
                            data-url="{{ route "removeFeed" "feedID" .ID }}">{{ t "action.remove" }}</a>
                    </li>
                </ul>
            </div>
            {{ if ne .ParsingErrorCount 0 }}
                <div class="parsing-error">
                    <strong title="{{ .ParsingErrorMsg }}" class="parsing-error-count">{{ plural "page.feeds.error_count" .ParsingErrorCount .ParsingErrorCount }}</strong>
                    - <small class="parsing-error-message">{{ .ParsingErrorMsg }}</small>
                </div>
            {{ end }}
        </article>
        {{ end }}
    </div>
{{ end }}

{{ end }}
`,
	"history_entries": `{{ define "title"}}{{ t "page.history.title" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.history.title" }} ({{ .total }})</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="{{ route "flushHistory" }}">{{ t "menu.flush_history" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert alert-info">{{ t "alert.no_history" }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "readEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry  }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"import": `{{ define "title"}}{{ t "page.import.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.import.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "menu.feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "menu.add_feed" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "menu.export" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "uploadOPML" }}" method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-file">{{ t "form.import.label.file" }}</label>
    <input type="file" name="file" id="form-file">

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.import" }}</button>
    </div>
</form>

{{ end }}
`,
	"integrations": `{{ define "title"}}{{ t "page.integrations.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.integrations.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.settings" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

<form method="post" autocomplete="off" action="{{ route "updateIntegration" }}">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <h3>Fever</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="fever_enabled" value="1" {{ if .form.FeverEnabled }}checked{{ end }}> {{ t "form.integration.fever_activate" }}
        </label>

        <label for="form-fever-username">{{ t "form.integration.fever_username" }}</label>
        <input type="text" name="fever_username" id="form-fever-username" value="{{ .form.FeverUsername }}">

        <label for="form-fever-password">{{ t "form.integration.fever_password" }}</label>
        <input type="password" name="fever_password" id="form-fever-password" value="{{ .form.FeverPassword }}" autocomplete="new-password">

        <p>{{ t "form.integration.fever_endpoint" }} <strong>{{ rootURL }}{{ route "feverEndpoint" }}</strong></p>
    </div>

    <h3>Pinboard</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="pinboard_enabled" value="1" {{ if .form.PinboardEnabled }}checked{{ end }}> {{ t "form.integration.pinboard_activate" }}
        </label>

        <label for="form-pinboard-token">{{ t "form.integration.pinboard_token" }}</label>
        <input type="password" name="pinboard_token" id="form-pinboard-token" value="{{ .form.PinboardToken }}" autocomplete="new-password">

        <label for="form-pinboard-tags">{{ t "form.integration.pinboard_tags" }}</label>
        <input type="text" name="pinboard_tags" id="form-pinboard-tags" value="{{ .form.PinboardTags }}">

        <label>
            <input type="checkbox" name="pinboard_mark_as_unread" value="1" {{ if .form.PinboardMarkAsUnread }}checked{{ end }}> {{ t "form.integration.pinboard_bookmark" }}
        </label>
    </div>

    <h3>Instapaper</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="instapaper_enabled" value="1" {{ if .form.InstapaperEnabled }}checked{{ end }}> {{ t "form.integration.instapaper_activate" }}
        </label>

        <label for="form-instapaper-username">{{ t "form.integration.instapaper_username" }}</label>
        <input type="text" name="instapaper_username" id="form-instapaper-username" value="{{ .form.InstapaperUsername }}">

        <label for="form-instapaper-password">{{ t "form.integration.instapaper_password" }}</label>
        <input type="password" name="instapaper_password" id="form-instapaper-password" value="{{ .form.InstapaperPassword }}" autocomplete="new-password">
    </div>

    <h3>Pocket</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="pocket_enabled" value="1" {{ if .form.PocketEnabled }}checked{{ end }}> {{ t "form.integration.pocket_activate" }}
        </label>

        {{ if not .hasPocketConsumerKeyConfigured }}
            <label for="form-pocket-consumer-key">{{ t "form.integration.pocket_consumer_key" }}</label>
            <input type="text" name="pocket_consumer_key" id="form-pocket-consumer-key" value="{{ .form.PocketConsumerKey }}">
        {{ end }}

        <label for="form-pocket-access-token">{{ t "form.integration.pocket_access_token" }}</label>
        <input type="password" name="pocket_access_token" id="form-pocket-access-token" value="{{ .form.PocketAccessToken }}" autocomplete="new-password">

        {{ if not .form.PocketAccessToken }}
            <p><a href="{{ route "pocketAuthorize" }}">{{ t "form.integration.pocket_connect_link" }}</a></p>
        {{ end }}
    </div>

    <h3>Wallabag</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="wallabag_enabled" value="1" {{ if .form.WallabagEnabled }}checked{{ end }}> {{ t "form.integration.wallabag_activate" }}
        </label>

        <label for="form-wallabag-url">{{ t "form.integration.wallabag_endpoint" }}</label>
        <input type="url" name="wallabag_url" id="form-wallabag-url" value="{{ .form.WallabagURL }}" placeholder="http://v2.wallabag.org/">

        <label for="form-wallabag-client-id">{{ t "form.integration.wallabag_client_id" }}</label>
        <input type="text" name="wallabag_client_id" id="form-wallabag-client-id" value="{{ .form.WallabagClientID }}">

        <label for="form-wallabag-client-secret">{{ t "form.integration.wallabag_client_secret" }}</label>
        <input type="password" name="wallabag_client_secret" id="form-wallabag-client-secret" value="{{ .form.WallabagClientSecret }}" autocomplete="new-password">

        <label for="form-wallabag-username">{{ t "form.integration.wallabag_username" }}</label>
        <input type="text" name="wallabag_username" id="form-wallabag-username" value="{{ .form.WallabagUsername }}">

        <label for="form-wallabag-password">{{ t "form.integration.wallabag_password" }}</label>
        <input type="password" name="wallabag_password" id="form-wallabag-password" value="{{ .form.WallabagPassword }}" autocomplete="new-password">
    </div>

    <h3>Nunux Keeper</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="nunux_keeper_enabled" value="1" {{ if .form.NunuxKeeperEnabled }}checked{{ end }}> {{ t "form.integration.nunux_keeper_activate" }}
        </label>

        <label for="form-nunux-keeper-url">{{ t "form.integration.nunux_keeper_endpoint" }}</label>
        <input type="url" name="nunux_keeper_url" id="form-nunux-keeper-url" value="{{ .form.NunuxKeeperURL }}" placeholder="https://api.nunux.org/keeper">

        <label for="form-nunux-keeper-api-key">{{ t "form.integration.nunux_keeper_api_key" }}</label>
        <input type="text" name="nunux_keeper_api_key" id="form-nunux-keeper-api-key" value="{{ .form.NunuxKeeperAPIKey }}">
    </div>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.update" }}</button>
    </div>
</form>

<h3>{{ t "page.integration.miniflux_api" }}</h3>
<div class="panel">
    <ul>
        <li>
            {{ t "page.integration.miniflux_api_endpoint" }} = <strong>{{ baseURL }}/v1/</strong>
        </li>
        <li>
            {{ t "page.integration.miniflux_api_username" }} = <strong>{{ .user.Username }}</strong>
        </li>
        <li>
            {{ t "page.integration.miniflux_api_password" }} = <strong>{{ t "page.integration.miniflux_api_password_value" }}</strong>
        </li>
    </ul>
</div>

<h3>{{ t "page.integration.bookmarklet" }}</h3>
<div class="panel">
    <p>{{ t "page.integration.bookmarklet.help" }}</p>

    <div class="bookmarklet">
        <a href="javascript:location.href='{{ rootURL }}{{ route "bookmarklet" }}?uri='+encodeURIComponent(window.location.href)">{{ t "page.integration.bookmarklet.name" }}</a>
    </div>

    <p>{{ t "page.integration.bookmarklet.instructions" }}</p>
</div>

{{ end }}
`,
	"login": `{{ define "title"}}{{ t "page.login.title" }}{{ end }}

{{ define "content"}}
<section class="login-form">
    <form action="{{ route "checkLogin" }}" method="post">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-username">{{ t "form.user.label.username" }}</label>
        <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required autofocus>

        <label for="form-password">{{ t "form.user.label.password" }}</label>
        <input type="password" name="password" id="form-password" value="{{ .form.Password }}" required>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.login" }}</button>
        </div>
    </form>
    {{ if hasOAuth2Provider "google" }}
    <div class="oauth2">
        <a href="{{ route "oauth2Redirect" "provider" "google" }}">{{ t "page.login.google_signin" }}</a>
    </div>
    {{ end }}
</section>
{{ end }}
`,
	"search_entries": `{{ define "title"}}{{ t "page.search.title" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.search.title" }} ({{ .total }})</h1>
</section>

{{ if not .entries }}
    <p class="alert alert-info">{{ t "alert.no_search_result" }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "searchEntry" "entryID" .ID }}?q={{ $.searchQuery }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry  }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"sessions": `{{ define "title"}}{{ t "page.sessions.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.sessions.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "menu.add_user" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

<table>
    <tr>
        <th>{{ t "page.sessions.table.date" }}</th>
        <th>{{ t "page.sessions.table.ip" }}</th>
        <th>{{ t "page.sessions.table.user_agent" }}</th>
        <th>{{ t "page.sessions.table.actions" }}</th>
    </tr>
    {{ range .sessions }}
    <tr {{ if eq .Token $.currentSessionToken }}class="row-highlighted"{{ end }}>
        <td class="column-20" title="{{ isodate .CreatedAt }}">{{ elapsed $.user.Timezone .CreatedAt }}</td>
        <td class="column-20" title="{{ .IP }}">{{ .IP }}</td>
        <td title="{{ .UserAgent }}">{{ .UserAgent }}</td>
        <td class="column-20">
            {{ if eq .Token $.currentSessionToken }}
                {{ t "page.sessions.table.current_session" }}
            {{ else }}
                <a href="#"
                    data-confirm="true"
                    data-label-question="{{ t "confirm.question" }}"
                    data-label-yes="{{ t "confirm.yes" }}"
                    data-label-no="{{ t "confirm.no" }}"
                    data-label-loading="{{ t "confirm.loading" }}"
                    data-url="{{ route "removeSession" "sessionID" .ID }}">{{ t "action.remove" }}</a>
            {{ end }}
        </td>
    </tr>
    {{ end }}
</table>

{{ end }}
`,
	"settings": `{{ define "title"}}{{ t "page.settings.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.settings.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "menu.users" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

<form method="post" autocomplete="off" action="{{ route "updateSettings" }}">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "form.user.label.username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required>

    <label for="form-password">{{ t "form.user.label.password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}" autocomplete="new-password">

    <label for="form-confirmation">{{ t "form.user.label.confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}" autocomplete="new-password">

    <label for="form-language">{{ t "form.prefs.label.language" }}</label>
    <select id="form-language" name="language">
    {{ range $key, $value := .languages }}
        <option value="{{ $key }}" {{ if eq $key $.form.Language }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-timezone">{{ t "form.prefs.label.timezone" }}</label>
    <select id="form-timezone" name="timezone">
    {{ range $key, $value := .timezones }}
        <option value="{{ $key }}" {{ if eq $key $.form.Timezone }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-theme">{{ t "form.prefs.label.theme" }}</label>
    <select id="form-theme" name="theme">
    {{ range $key, $value := .themes }}
        <option value="{{ $key }}" {{ if eq $key $.form.Theme }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-entry-direction">{{ t "form.prefs.label.entry_sorting" }}</label>
    <select id="form-entry-direction" name="entry_direction">
        <option value="asc" {{ if eq "asc" $.form.EntryDirection }}selected="selected"{{ end }}>{{ t "form.prefs.select.older_first" }}</option>
        <option value="desc" {{ if eq "desc" $.form.EntryDirection }}selected="selected"{{ end }}>{{ t "form.prefs.select.recent_first" }}</option>
    </select>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "form.submit.saving" }}">{{ t "action.update" }}</button>
    </div>
</form>

{{ if hasOAuth2Provider "google" }}
<div class="panel">
    {{ if hasKey .user.Extra "google_id" }}
        <a href="{{ route "oauth2Unlink" "provider" "google" }}">{{ t "page.settings.unlink_google_account" }}</a>
    {{ else }}
        <a href="{{ route "oauth2Redirect" "provider" "google" }}">{{ t "page.settings.link_google_account" }}</a>
    {{ end }}
</div>
{{ end }}

{{ end }}
`,
	"unread_entries": `{{ define "title"}}{{ t "page.unread.title" }} {{ if gt .countUnread 0 }}({{ .countUnread }}){{ end }} {{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.unread.title" }} (<span class="unread-counter">{{ .countUnread }}</span>)</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
        </li>
        <li>
            <a data-link-state="flip"
               data-label-new-state="{{ t "menu.mark_all_as_read_wip" }}"
               href="{{ route "markAllAsRead" }}">{{ t "menu.mark_all_as_read" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert">{{ t "alert.no_unread_entry" }}</p>
{{ else }}
    <div class="items hide-read-items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16" alt="{{ .Feed.Title }}">
                    {{ end }}
                    <a href="{{ route "unreadEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . "hasSaveEntry" $.hasSaveEntry }}
        </article>
        {{ end }}
    </div>
    <section class="page-footer">
        {{ if .entries }}
        <ul>
            <li>
                <a href="#" data-on-click="markPageAsRead">{{ t "menu.mark_page_as_read" }}</a>
            </li>
        </ul>
        {{ end }}
    </section>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}`,
	"users": `{{ define "title"}}{{ t "page.users.title" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "page.users.title" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "menu.settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "menu.integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "menu.sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "menu.add_user" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "menu.about" }}</a>
        </li>
    </ul>
</section>

{{ if eq (len .users) 1 }}
    <p class="alert">{{ t "alert.no_user" }}</p>
{{ else }}
    <table>
        <tr>
            <th class="column-20">{{ t "page.users.username" }}</th>
            <th>{{ t "page.users.is_admin" }}</th>
            <th>{{ t "page.users.last_login" }}</th>
            <th>{{ t "page.users.actions" }}</th>
        </tr>
        {{ range .users }}
            {{ if ne .ID $.user.ID }}
            <tr>
                <td>{{ .Username }}</td>
                <td>{{ if eq .IsAdmin true }}{{ t "page.users.admin.yes" }}{{ else }}{{ t "page.users.admin.no" }}{{ end }}</td>
                <td>
                    {{ if .LastLoginAt }}
                        <time datetime="{{ isodate .LastLoginAt }}" title="{{ isodate .LastLoginAt }}">{{ elapsed $.user.Timezone .LastLoginAt }}</time>
                    {{ else }}
                        {{ t "page.users.never_logged" }}
                    {{ end }}
                </td>
                <td>
                    <a href="{{ route "editUser" "userID" .ID }}">{{ t "action.edit" }}</a>,
                    <a href="#"
                        data-confirm="true"
                        data-label-question="{{ t "confirm.question" }}"
                        data-label-yes="{{ t "confirm.yes" }}"
                        data-label-no="{{ t "confirm.no" }}"
                        data-label-loading="{{ t "confirm.loading" }}"
                        data-url="{{ route "removeUser" "userID" .ID }}">{{ t "action.remove" }}</a>
                </td>
            </tr>
            {{ end }}
        {{ end }}
    </table>
{{ end }}

{{ end }}
`,
}

var templateViewsMapChecksums = map[string]string{
	"about":               "844e3313c33ae31a74b904f6ef5d60299773620d8450da6f760f9f317217c51e",
	"add_subscription":    "6eb055f887abffe9ddeb8977ae380c2cb1cc61767e85ed2026ef2fb5995e12d3",
	"bookmark_entries":    "609f4b2342152fe495a219a32f17a4528b01807d61f53cee0cbebf728be73c42",
	"categories":          "642ee3cddbd825ee6ab5a77caa0d371096b55de0f1bd4ae3055b8c8a70507d8d",
	"category_entries":    "a803570ba91268646b2c55cffc8a3f2f162388a73bc007dd9ab61e144faa359b",
	"choose_subscription": "33c04843d7c1b608d034e605e52681822fc6d79bc6b900c04915dd9ebae584e2",
	"create_category":     "6b22b5ce51abf4e225e23a79f81be09a7fb90acb265e93a8faf9446dff74018d",
	"create_user":         "1e940be3afefc0a5c6273bbadcddc1e29811e9548e5227ac2adfe697ca5ce081",
	"edit_category":       "daf073d2944a180ce5aaeb80b597eb69597a50dff55a9a1d6cf7938b48d768cb",
	"edit_feed":           "ab30c31a4385a7b16c54baa78bdcb93a57181ed1c5018ce097d7eb50673bb995",
	"edit_user":           "f4f99412ba771cfca2a2a42778b023b413c5494e9a287053ba8cf380c2865c5f",
	"entry":               "2ea9fee1ae5513ef1abb5923221c2ef1212e26d3bb651da66069ce8a336cbb7c",
	"feed_entries":        "0f3d02d820475a3b0e165e10be2bf39fa5ab6a9dc5b0945c9ad886434e64e6ca",
	"feeds":               "31acc253c547a6cce5710d72a6f6b3b396162ecd5e5af295b2cf47c1ff55bd06",
	"history_entries":     "b65ca1d85615caa7c314a33f1cb997aa3477a79e66b9894b2fd387271ad467d2",
	"import":              "8349e47a783bb40d8e9248b4771656e5f006185e11079e1c4680dd52633420ed",
	"integrations":        "f85b4a48ab1fc13b8ca94bfbbc44bd5e8784f35b26a63ec32cbe82b96b45e008",
	"login":               "f9e6714d34fdce82266c8b23b0ff449d05ba71e474d26f711da66f8c4fdc076a",
	"search_entries":      "d71849a4f2b0573c7c76ad0ea941812009e9f022de60895987a781d3e6f08a01",
	"sessions":            "1b3ec0970a4111b81f86d6ed187bb410f88972e2ede6723b9febcc4c7e5fc921",
	"settings":            "bc04faf83dd977306825973375954600bd014619340188e1243fd9e2f5d5e1a9",
	"unread_entries":      "880018cbc59ec09b23dd800c4010fadad944d7023e0d36a3872c09b5d4952799",
	"users":               "4b56cc76fbcc424e7c870d0efca93bb44dbfcc2a08b685cf799c773fbb8dfb2f",
}
