---
id: language-understanding
title: Language Understanding
---

--------------------

Natural Language Understanding (NLU) is a branch of artificial intelligence where computer understands and processes the content gathered from a user. In fact, it transforms a natural dialog into structured information that your chatbot can understand and use to return the best answer possible.

The information generated by NLU tasks is added to the message metadata directly (under `event.nlu`), ready to be used by other modules and components.

:::note
If you want your bot to understand a question and provide an answer automatically, you should do it in the Q&A module instead.
:::

**Advantages:**
- fast speed (both at training and evaluation time);
- tight security (doesn't relay messages to external services);
- predictable (unit tests, and the model resides on your computer or server);
- free!

![nlu-overview](/assets/nlu-overview.png)

## Intent Classification

It’s about recognizing what the user is saying and training the chatbot to understand it. Way more accurate than only using keywords!

## Entity Extraction

Entity extraction involves extracting and normalizing structured information from messages such as dates, time, cities, names, and many more. We generally define entities in the form of patterns or lists.

## Slot Tagging

Slot tagging is needed to identify the necessary parameters to fulfill a given task. Slots are necessary **parameters** to complete the action associated to an intent.

## Language Server

The language server provides additional information about words. You don't have to teach your chatbot to understand synonyms. 

By default, your Botpress server queries one of our language servers, but you can host your server to keep it your premises.

## External NLU Providers

If you want to use an external provider for some reason, you can do so by using hooks and calling the external NLU provider via API.

:::note
We don't support two-way synchronization [(see why)](https://github.com/botpress/botpress/pull/1170). You'll have to maintain this yourself.
:::