import React from 'react'

const getViewBox = name => {
  switch (name) {
    case 'agent':
      return '0 0 512 512'
    case 'user':
      return '0 0 512 512'
    case 'bot':
      return '0 0 512 512'
    default:
      return '0 0 32 32'
  }
}

const getPath = (name, props) => {
  switch (name) {
    case 'bot':
      return (
        <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
          <g id="bot">
            <circle id="Oval" fill={props.fill} cx="244.5" cy="244.5" r="244.5" />
            <path
              d="M176.605444,188 C191.835825,167.277714 216.55902,153.714286 244.5,153.714286 C272.44098,153.714286 297.164175,167.277714 312.394556,188 L329,188 C312.073476,159.357714 280.572691,140 244.5,140 C208.427309,140 176.926524,159.357714 160,188 L176.605444,188"
              id="Fill-7"
              fill="#FFC000"
            />
            <path
              d="M161,105 C157.143,105 154,108.143 154,112 C154,115.857 157.143,119 161,119 C164.857,119 168,115.857 168,112 C168,108.143 164.857,105 161,105 Z M160,132 C148.422,132 139,122.578 139,111 C139,99.422 148.422,90 160,90 C171.578,90 181,99.422 181,111 C181,122.578 171.578,132 160,132 L160,132 Z"
              id="Fill-8"
              fill="#FFC000"
            />
            <path
              d="M194.9993,167 C192.948403,167 190.918504,166.122305 189.532574,164.428626 L161.533973,130.143646 C159.119093,127.181424 159.609069,122.868374 162.625918,120.50271 C165.642767,118.137046 170.052547,118.617036 172.467426,121.572401 L200.466027,155.857381 C202.880907,158.819604 202.390931,163.132654 199.374082,165.498318 C198.079147,166.506296 196.539224,167 194.9993,167"
              id="Fill-9"
              fill="#FFC000"
            />
            <path
              d="M330,105 C326.143,105 323,108.143 323,112 C323,115.857 326.143,119 330,119 C333.857,119 337,115.857 337,112 C337,108.143 333.857,105 330,105 Z M329,132 C317.422,132 308,122.578 308,111 C308,99.422 317.422,90 329,90 C340.578,90 350,99.422 350,111 C350,122.578 340.578,132 329,132 L329,132 Z"
              id="Fill-10"
              fill="#FFC000"
            />
            <path
              d="M294.0007,167 C292.460776,167 290.920853,166.506267 289.625918,165.498228 C286.609069,163.132422 286.119093,158.819113 288.533973,155.856712 L316.532574,121.569674 C318.947453,118.614131 323.364232,118.14097 326.374082,120.499918 C329.390931,122.865724 329.880907,127.179033 327.466027,130.141434 L299.467426,164.428472 C298.081496,166.122252 296.044597,167 294.0007,167"
              id="Fill-11"
              fill="#FFC000"
            />
            <path
              d="M357,224 L357,237.875 C368.578,237.875 378,247.212875 378,258.6875 L378,300.3125 C378,311.787125 368.578,321.125 357,321.125 L357,335 C376.299,335 392,319.439188 392,300.3125 L392,258.6875 C392,239.560812 376.299,224 357,224"
              id="Fill-12"
              fill="#FFC000"
            />
            <path
              d="M111,300.3125 L111,258.6875 C111,247.212875 120.422,237.875 132,237.875 L132,224 C112.701,224 97,239.560812 97,258.6875 L97,300.3125 C97,319.439188 112.701,335 132,335 L132,321.125 C120.422,321.125 111,311.787125 111,300.3125"
              id="Fill-13"
              fill="#FFC000"
            />
            <path
              d="M147.966667,197 C144.128033,197 141,200.12504 141,203.96 L141,336.2 C141,355.38872 156.626233,371 175.833333,371 L315.166667,371 C334.373767,371 350,355.38872 350,336.2 L350,203.96 C350,200.12504 346.871967,197 343.033333,197 L147.966667,197 Z M314.205882,385 L174.794118,385 C147.887647,385 126,363.02 126,336 L126,203 C126,191.422 135.382412,182 146.911765,182 L342.088235,182 C353.617588,182 363,191.422 363,203 L363,336 C363,363.02 341.112353,385 314.205882,385 L314.205882,385 Z"
              id="Fill-14"
              fill="#FFC000"
            />
            <path
              d="M244.5,350 C229.249731,350 214.434197,342.572493 213.813146,342.264472 C210.411163,340.535354 209.031048,336.335067 210.721688,332.883832 C212.41923,329.425596 216.559574,328.011499 219.975359,329.733617 C220.099569,329.796621 232.562006,335.999044 244.5,335.999044 C256.437994,335.999044 268.900431,329.796621 269.024641,329.733617 C272.433525,328.011499 276.57387,329.425596 278.278312,332.883832 C279.968952,336.335067 278.588837,340.535354 275.186854,342.264472 C274.565803,342.572493 259.750269,350 244.5,350"
              id="Fill-15"
              fill="#FFC000"
            />
            <path
              d="M196,239 C180.558,239 168,251.558 168,267 C168,282.442 180.558,295 196,295 C211.442,295 224,282.442 224,267 C224,251.558 211.442,239 196,239 Z M195,308 C171.837,308 153,289.163 153,266 C153,242.837 171.837,224 195,224 C218.163,224 237,242.837 237,266 C237,289.163 218.163,308 195,308 L195,308 Z"
              id="Fill-16"
              fill="#FFC000"
            />
            <path
              d="M195.5,280 C187.50325,280 181,273.49675 181,265.5 C181,257.50325 187.50325,251 195.5,251 C203.49675,251 210,257.50325 210,265.5 C210,273.49675 203.49675,280 195.5,280 L195.5,280 Z"
              id="Fill-17"
              fill="#FFC000"
            />
            <path
              d="M295,239 C279.558,239 267,251.558 267,267 C267,282.442 279.558,295 295,295 C310.442,295 323,282.442 323,267 C323,251.558 310.442,239 295,239 Z M294,308 C270.837,308 252,289.163 252,266 C252,242.837 270.837,224 294,224 C317.163,224 336,242.837 336,266 C336,289.163 317.163,308 294,308 L294,308 Z"
              id="Fill-18"
              fill="#FFC000"
            />
            <path
              d="M293.5,280 C285.50325,280 279,273.49675 279,265.5 C279,257.50325 285.50325,251 293.5,251 C301.49675,251 308,257.50325 308,265.5 C308,273.49675 301.49675,280 293.5,280 L293.5,280 Z"
              id="Fill-19"
              fill="#FFC000"
            />
          </g>
        </g>
      )
    case 'user':
      return (
        <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
          <g id="user">
            <circle id="Oval" fill={props.fill} cx="244.5" cy="244.5" r="244.5" />
            <path
              d="M244.5,139 C182.922658,139 133,181.979092 133,234.997053 C133,253.931196 139.455263,271.533112 150.446816,286.405729 C158.5335,301.549507 153.275395,320.501336 138.381342,329.184397 C156.332842,333.988671 174.571895,328.948605 187.470684,317.382979 C204.172211,325.971723 223.631895,331 244.5,331 C306.077342,331 356,288.020908 356,234.997053 C356,181.979092 306.077342,139 244.5,139 Z"
              id="Path"
              stroke="#FFC000"
              strokeWidth="18"
            />
          </g>
        </g>
      )
    case 'agent':
      return (
        <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
          <g id="agent">
            <circle id="Oval" fill={props.fill} cx="244.5" cy="244.5" r="244.5" />
            <path
              d="M210.924971,179.887419 C210.487689,179.93882 210.062782,180.021852 209.654377,180.128608 C199.081217,182.129284 189.555885,185.10262 181,188.93 L230.025139,188.93 C231.580379,187.467055 232.842723,185.806415 233.721413,183.900633 C236.592626,177.677187 235.132268,169.935441 229.728117,162.620717 C228.342014,160.552825 226.13085,157.678336 224.913884,156.120497 C219.0642,148.61994 212.636973,135.69067 211.473637,123.710339 C210.376305,112.469387 213.008251,102.877214 218.874436,96.7051681 C224.526105,90.7584952 233.313008,87.7456196 245,87.7456196 C256.686992,87.7456196 265.47802,90.7584952 271.129689,96.7051681 C276.991749,102.877214 279.623695,112.469387 278.530489,123.710339 C277.363027,135.69067 270.9358,148.61994 265.086116,156.120497 C263.865025,157.68229 261.653861,160.564686 260.271883,162.620717 C254.867732,169.935441 253.411499,177.677187 256.278587,183.900633 C257.157277,185.806415 258.419621,187.467055 259.974861,188.93 L309,188.93 C300.444115,185.10262 290.922908,182.129284 280.353874,180.128608 C279.941343,180.021852 279.512311,179.93882 279.075029,179.887419 C272.631301,179.171763 271.381333,177.522984 271.373082,177.507169 C271.162692,177.05247 271.579348,174.644542 273.815264,171.659343 C273.90602,171.536772 273.992652,171.414201 274.079283,171.287676 C274.850715,170.11732 276.430708,167.99012 278.299471,165.590099 C285.007219,156.990356 293.393967,141.249861 294.957458,125.181191 C296.487946,109.448604 292.358515,95.5545818 283.32822,86.0533483 C274.417558,76.6825937 261.521851,71.93 245,71.93 C228.478149,71.93 215.582442,76.6825937 206.675906,86.0533483 C197.64561,95.5545818 193.512054,109.448604 195.042542,125.181191 C196.606033,141.249861 204.992781,156.990356 211.700529,165.590099 C213.565167,167.982212 215.145159,170.113367 215.924842,171.287676 C216.007348,171.414201 216.09398,171.536772 216.188862,171.659343 C218.420652,174.644542 218.841434,177.05247 218.626918,177.507169 C218.622792,177.522984 217.368699,179.171763 210.924971,179.887419"
              id="Fill-54"
              fill="#FFC000"
            />
            <path
              d="M350,353 L350,254 C361.074524,271.294125 373,293.6 373,308.077505 C373,328.853561 360.134426,344.163702 350,353 Z M163,359 L338,359 L338,219 L163,219 L163,359 Z M146,353 C135.865574,344.163702 123,328.853561 123,308.077505 C123,293.6 134.925476,271.294125 146,254 L146,353 Z M351.364164,221.022669 L351.364164,211.957336 C351.364164,205.931411 346.415303,201 340.363064,201 L155.641023,201 C149.584697,201 144.635836,205.931411 144.635836,211.957336 L144.635836,221.0186 C136.393184,232.045106 105,275.951755 105,305.263543 C105,349.83748 146.985625,373.359335 148.775552,374.335852 C149.662342,374.820042 150.622691,375.072309 151.595299,375.20658 C152.849882,375.702976 154.210717,376 155.641023,376 L340.363064,376 C341.789283,376 343.150118,375.702976 344.404701,375.202511 C345.377309,375.072309 346.337658,374.820042 347.224448,374.335852 C349.014375,373.359335 391,349.83748 391,305.263543 C391,275.951755 359.610902,232.049175 351.364164,221.022669 L351.364164,221.022669 Z"
              id="Fill-55"
              fill="#FFC000"
            />
            <polygon id="Fill-57" fill="#FFC000" points="198 340.93 292 340.93 292 328.93 198 328.93" />
          </g>
        </g>
      )
    default:
      return <path />
  }
}

const SVGIcon = ({
  name = '',
  style = {},
  fill = '#000',
  viewBox = '',
  width = '50px',
  className = '',
  height = '50px'
}) => (
  <svg
    width={width}
    style={style}
    height={height}
    className={className}
    xmlns="http://www.w3.org/2000/svg"
    viewBox={viewBox || getViewBox(name)}
    xmlnsXlink="http://www.w3.org/1999/xlink"
  >
    {getPath(name, { fill })}
  </svg>
)

export default SVGIcon
