# Roadmap
**Last updated: June 3, 2016**

TensorFlow is a fast moving project. In order for the community to better
understand what the near future will bring, this document shares what we are
working on internally. Many of these features were requested by the community,
and we welcome
[contributions](https://github.com/tensorflow/tensorflow/labels/contributions%20welcome).

The features on this list are targeted for the next few months. At this point,
we do not have timelines for these features.

### Improve non-Python language support
C and C++ APIs for:

* Graph construction
* Gradients
* Shape Inference

### Making TensorFlow easier to use
* Easier setup for distributed training jobs

### Performance
* Speed and memory benchmarks
* Performance and memory usage improvements

### Core Features
* Repeated partial graph evaluation ([#672](https://github.com/tensorflow/tensorflow/issues/672))
* Automatic op placement ([#2126](https://github.com/tensorflow/tensorflow/issues/2126))

### Platforms
* OpenCL support ([#22](https://github.com/tensorflow/tensorflow/issues/22))

### Community
* More educational resources
* Better integration of TensorFlow into the opensource big data ecosystem ([#1996](https://github.com/tensorflow/tensorflow/issues/1996),
[#2218](https://github.com/tensorflow/tensorflow/issues/2218),
[#2655](https://github.com/tensorflow/tensorflow/issues/2655))
* Models benchmarking and comparison tooling
