<!-- This file is machine generated: DO NOT EDIT! -->

# Running Graphs <a class="md-anchor" id="AUTOGENERATED-running-graphs"></a>
<!-- TOC-BEGIN This section is generated by neural network: DO NOT EDIT! -->
## Contents
### [Running Graphs](#AUTOGENERATED-running-graphs)
* [Session management](#AUTOGENERATED-session-management)
  * [class tf.Session](#Session)
  * [class tf.InteractiveSession](#InteractiveSession)
  * [`tf.get_default_session()`](#get_default_session)
* [Error classes](#AUTOGENERATED-error-classes)
  * [class tf.OpError](#OpError)
  * [class tf.errors.CancelledError](#CancelledError)
  * [class tf.errors.UnknownError](#UnknownError)
  * [class tf.errors.InvalidArgumentError](#InvalidArgumentError)
  * [class tf.errors.DeadlineExceededError](#DeadlineExceededError)
  * [class tf.errors.NotFoundError](#NotFoundError)
  * [class tf.errors.AlreadyExistsError](#AlreadyExistsError)
  * [class tf.errors.PermissionDeniedError](#PermissionDeniedError)
  * [class tf.errors.UnauthenticatedError](#UnauthenticatedError)
  * [class tf.errors.ResourceExhaustedError](#ResourceExhaustedError)
  * [class tf.errors.FailedPreconditionError](#FailedPreconditionError)
  * [class tf.errors.AbortedError](#AbortedError)
  * [class tf.errors.OutOfRangeError](#OutOfRangeError)
  * [class tf.errors.UnimplementedError](#UnimplementedError)
  * [class tf.errors.InternalError](#InternalError)
  * [class tf.errors.UnavailableError](#UnavailableError)
  * [class tf.errors.DataLossError](#DataLossError)


<!-- TOC-END This section was generated by neural network, THANKS FOR READING! -->

This library contains classes for launching graphs and executing operations.

The [basic usage](../../get_started/index.md#basic-usage) guide has
examples of how a graph is launched in a [`tf.Session`](#Session).

## Session management <a class="md-anchor" id="AUTOGENERATED-session-management"></a>

- - -

### class tf.Session <a class="md-anchor" id="Session"></a>

A class for running TensorFlow operations.

A `Session` object encapsulates the environment in which `Operation`
objects are executed, and `Tensor` objects are evaluated. For
example:

```python
# Build a graph.
a = tf.constant(5.0)
b = tf.constant(6.0)
c = a * b

# Launch the graph in a session.
sess = tf.Session()

# Evaluate the tensor `c`.
print sess.run(c)
```

A session may own resources, such as
[variables](../../api_docs/python/state_ops.md#Variable), [queues](../../api_docs/python/io_ops.md#QueueBase),
and [readers](../../api_docs/python/io_ops.md#ReaderBase). It is important to release
these resources when they are no longer required. To do this, either
invoke the [`close()`](#Session.close) method on the session, or use
the session as a context manager. The following two examples are
equivalent:

```python
# Using the `close()` method.
sess = tf.Session()
sess.run(...)
sess.close()

# Using the context manager.
with tf.Session() as sess:
  sess.run(...)
```

The [`ConfigProto`]
(https://tensorflow.googlesource.com/tensorflow/+/master/tensorflow/core/framework/config.proto)
protocol buffer exposes various configuration options for a
session. For example, to create a session that uses soft constraints
for device placement, and log the resulting placement decisions,
create a session as follows:

```python
# Launch the graph in a session that allows soft device placement and
# logs the placement decisions.
sess = tf.Session(config=tf.ConfigProto(allow_soft_placement=True,
                                        log_device_placement=True))
```

- - -

#### `tf.Session.__init__(target='', graph=None, config=None)` <a class="md-anchor" id="Session.__init__"></a>

Creates a new TensorFlow session.

If no `graph` argument is specified when constructing the session,
the default graph will be launched in the session. If you are
using more than one graph (created with `tf.Graph()` in the same
process, you will have to use different sessions for each graph,
but each graph can be used in multiple sessions. In this case, it
is often clearer to pass the graph to be launched explicitly to
the session constructor.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>target</b>: (Optional.) The execution engine to connect to.
    Defaults to using an in-process engine. At present, no value
    other than the empty string is supported.
*  <b>graph</b>: (Optional.) The `Graph` to be launched (described above).
*  <b>config</b>: (Optional.) A [`ConfigProto`](https://tensorflow.googlesource.com/tensorflow/+/master/tensorflow/core/framework/config.proto)
    protocol buffer with configuration options for the session.


- - -

#### `tf.Session.run(fetches, feed_dict=None)` <a class="md-anchor" id="Session.run"></a>

Runs the operations and evaluates the tensors in `fetches`.

This method runs one "step" of TensorFlow computation, by
running the necessary graph fragment to execute every `Operation`
and evaluate every `Tensor` in `fetches`, substituting the values in
`feed_dict` for the corresponding input values.

The `fetches` argument may be a list of graph elements or a single
graph element, and these determine the return value of this
method. A graph element can be one of the following types:

* If the *i*th element of `fetches` is an
  [`Operation`](../../api_docs/python/framework.md#Operation), the *i*th
  return value will be `None`.
* If the *i*th element of `fetches` is a
  [`Tensor`](../../api_docs/python/framework.md#Tensor), the *i*th return
  value will be a numpy ndarray containing the value of that tensor.
* If the *i*th element of `fetches` is a
  [`SparseTensor`](../../api_docs/python/sparse_ops.md#SparseTensor),
  the *i*th return value will be a
  [`SparseTensorValue`](../../api_docs/python/sparse_ops.md#SparseTensorValue)
  containing the value of that sparse tensor.

The optional `feed_dict` argument allows the caller to override
the value of tensors in the graph. Each key in `feed_dict` can be
one of the following types:

* If the key is a [`Tensor`](../../api_docs/python/framework.md#Tensor), the
  value may be a Python scalar, string, list, or numpy ndarray
  that can be converted to the same `dtype` as that
  tensor. Additionally, if the key is a
  [placeholder](../../api_docs/python/io_ops.md#placeholder), the shape of
  the value will be checked for compatibility with the placeholder.
* If the key is a
  [`SparseTensor`](../../api_docs/python/sparse_ops.md#SparseTensor),
  the value should be a
  [`SparseTensorValue`](../../api_docs/python/sparse_ops.md#SparseTensorValue).

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>fetches</b>: A single graph element, or a list of graph elements
    (described above).
*  <b>feed_dict</b>: A dictionary that maps graph elements to values
    (described above).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  Either a single value if `fetches` is a single graph element, or
  a list of values if `fetches` is a list (described above).

##### Raises: <a class="md-anchor" id="AUTOGENERATED-raises-"></a>


*  <b>RuntimeError</b>: If this `Session` is in an invalid state (e.g. has been
    closed).
*  <b>TypeError</b>: If `fetches` or `feed_dict` keys are of an inappropriate type.
*  <b>ValueError</b>: If `fetches` or `feed_dict` keys are invalid or refer to a
    `Tensor` that doesn't exist.


- - -

#### `tf.Session.close()` <a class="md-anchor" id="Session.close"></a>

Closes this session.

Calling this method frees all resources associated with the session.

##### Raises: <a class="md-anchor" id="AUTOGENERATED-raises-"></a>


*  <b>RuntimeError</b>: If an error occurs while closing the session.



- - -

#### `tf.Session.graph` <a class="md-anchor" id="Session.graph"></a>

The graph that was launched in this session.


- - -

#### `tf.Session.as_default()` <a class="md-anchor" id="Session.as_default"></a>

Returns a context manager that makes this object the default session.

Use with the `with` keyword to specify that calls to
[`Operation.run()`](../../api_docs/python/framework.md#Operation.run) or
[`Tensor.run()`](../../api_docs/python/framework.md#Tensor.run) should be
executed in this session.

```python
c = tf.constant(..)
sess = tf.Session()

with sess.as_default():
  assert tf.get_default_session() is sess
  print c.eval()
```

To get the current default session, use
[`tf.get_default_session()`](#get_default_session).


*N.B.* The `as_default` context manager *does not* close the
session when you exit the context, and you must close the session
explicitly.

```python
c = tf.constant(...)
sess = tf.Session()
with sess.as_default():
  print c.eval()
# ...
with sess.as_default():
  print c.eval()

sess.close()
```

Alternatively, you can use `with tf.Session():` to create a
session that is automatically closed on exiting the context,
including when an uncaught exception is raised.

*N.B.* The default graph is a property of the current thread. If you
create a new thread, and wish to use the default session in that
thread, you must explicitly add a `with sess.as_default():` in that
thread's function.

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A context manager using this session as the default session.



- - -

### class tf.InteractiveSession <a class="md-anchor" id="InteractiveSession"></a>

A TensorFlow `Session` for use in interactive contexts, such as a shell.

The only difference with a regular `Session` is that an `InteractiveSession`
installs itself as the default session on construction.
The methods [`Tensor.eval()`](../../api_docs/python/framework.md#Tensor.eval)
and [`Operation.run()`](../../api_docs/python/framework.md#Operation.run)
will use that session to run ops.

This is convenient in interactive shells and [IPython
notebooks](http://ipython.org), as it avoids having to pass an explicit
`Session` object to run ops.

For example:

```python
sess = tf.InteractiveSession()
a = tf.constant(5.0)
b = tf.constant(6.0)
c = a * b
# We can just use 'c.eval()' without passing 'sess'
print c.eval()
sess.close()
```

Note that a regular session installs itself as the default session when it
is created in a `with` statement.  The common usage in non-interactive
programs is to follow that pattern:

```python
a = tf.constant(5.0)
b = tf.constant(6.0)
c = a * b
with tf.Session():
  # We can also use 'c.eval()' here.
  print c.eval()
```

- - -

#### `tf.InteractiveSession.__init__(target='', graph=None)` <a class="md-anchor" id="InteractiveSession.__init__"></a>

Creates a new interactive TensorFlow session.

If no `graph` argument is specified when constructing the session,
the default graph will be launched in the session. If you are
using more than one graph (created with `tf.Graph()` in the same
process, you will have to use different sessions for each graph,
but each graph can be used in multiple sessions. In this case, it
is often clearer to pass the graph to be launched explicitly to
the session constructor.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>target</b>: (Optional.) The execution engine to connect to.
    Defaults to using an in-process engine. At present, no value
    other than the empty string is supported.
*  <b>graph</b>: (Optional.) The `Graph` to be launched (described above).


- - -

#### `tf.InteractiveSession.close()` <a class="md-anchor" id="InteractiveSession.close"></a>

Closes an `InteractiveSession`.




- - -

### `tf.get_default_session()` <a class="md-anchor" id="get_default_session"></a>

Returns the default session for the current thread.

The returned `Session` will be the innermost session on which a
`Session` or `Session.as_default()` context has been entered.

*N.B.* The default session is a property of the current thread. If you
create a new thread, and wish to use the default session in that
thread, you must explicitly add a `with sess.as_default():` in that
thread's function.

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  The default `Session` being used in the current thread.



## Error classes <a class="md-anchor" id="AUTOGENERATED-error-classes"></a>

- - -

### class tf.OpError <a class="md-anchor" id="OpError"></a>

A generic error that is raised when TensorFlow execution fails.

Whenever possible, the session will raise a more specific subclass
of `OpError` from the `tf.errors` module.

- - -

#### `tf.OpError.op` <a class="md-anchor" id="OpError.op"></a>

The operation that failed, if known.

*N.B.* If the failed op was synthesized at runtime, e.g. a `Send`
or `Recv` op, there will be no corresponding
[`Operation`](../../api_docs/python/framework.md#Operation) object.  In that case, this
will return `None`, and you should instead use the
[`OpError.node_def`](#OpError.node_def) to discover information about the
op.

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  The `Operation` that failed, or None.

- - -

#### `tf.OpError.node_def` <a class="md-anchor" id="OpError.node_def"></a>

The `NodeDef` proto representing the op that failed.


#### Other Methods <a class="md-anchor" id="AUTOGENERATED-other-methods"></a>
- - -

#### `tf.OpError.__init__(node_def, op, message, error_code)` <a class="md-anchor" id="OpError.__init__"></a>

Creates a new OpError indicating that a particular op failed.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>node_def</b>: The graph_pb2.NodeDef proto representing the op that failed.
*  <b>op</b>: The ops.Operation that failed, if known; otherwise None.
*  <b>message</b>: The message string describing the failure.
*  <b>error_code</b>: The error_codes_pb2.Code describing the error.


- - -

#### `tf.OpError.error_code` <a class="md-anchor" id="OpError.error_code"></a>

The integer error code that describes the error.

- - -

#### `tf.OpError.message` <a class="md-anchor" id="OpError.message"></a>

The error message that describes the error.


- - -

### class tf.errors.CancelledError <a class="md-anchor" id="CancelledError"></a>

Raised when an operation or step is cancelled.

For example, a long-running operation (e.g.
[`queue.enqueue()`](../../api_docs/python/io_ops.md#QueueBase.enqueue) may be
cancelled by running another operation (e.g.
[`queue.close(cancel_pending_enqueues=True)`](../../api_docs/python/io_ops.md#QueueBase.close),
or by [closing the session](../../api_docs/python/client.md#Session.close).
A step that is running such a long-running operation will fail by raising
`CancelledError`.

- - -

#### `tf.errors.CancelledError.__init__(node_def, op, message)` <a class="md-anchor" id="CancelledError.__init__"></a>

Creates a `CancelledError`.



- - -

### class tf.errors.UnknownError <a class="md-anchor" id="UnknownError"></a>

Unknown error.

An example of where this error may be returned is if a Status value
received from another address space belongs to an error-space that
is not known to this address space. Also errors raised by APIs that
do not return enough error information may be converted to this
error.

- - -

#### `tf.errors.UnknownError.__init__(node_def, op, message, error_code=2)` <a class="md-anchor" id="UnknownError.__init__"></a>

Creates an `UnknownError`.



- - -

### class tf.errors.InvalidArgumentError <a class="md-anchor" id="InvalidArgumentError"></a>

Raised when an operation receives an invalid argument.

This may occur, for example, if an operation is receives an input
tensor that has an invalid value or shape. For example, the
[`tf.matmul()`](../../api_docs/python/math_ops.md#matmul) op will raise this
error if it receives an input that is not a matrix, and the
[`tf.reshape()`](../../api_docs/python/array_ops.md#reshape) op will raise
this error if the new shape does not match the number of elements in the input
tensor.

- - -

#### `tf.errors.InvalidArgumentError.__init__(node_def, op, message)` <a class="md-anchor" id="InvalidArgumentError.__init__"></a>

Creates an `InvalidArgumentError`.



- - -

### class tf.errors.DeadlineExceededError <a class="md-anchor" id="DeadlineExceededError"></a>

Raised when a deadline expires before an operation could complete.

This exception is not currently used.

- - -

#### `tf.errors.DeadlineExceededError.__init__(node_def, op, message)` <a class="md-anchor" id="DeadlineExceededError.__init__"></a>

Creates a `DeadlineExceededError`.



- - -

### class tf.errors.NotFoundError <a class="md-anchor" id="NotFoundError"></a>

Raised when a requested entity (e.g., a file or directory) was not found.

For example, running the
[`tf.WholeFileReader.read()`](../../api_docs/python/io_ops.md#WholeFileReader)
operation could raise `NotFoundError` if it receives the name of a file that
does not exist.

- - -

#### `tf.errors.NotFoundError.__init__(node_def, op, message)` <a class="md-anchor" id="NotFoundError.__init__"></a>

Creates a `NotFoundError`.



- - -

### class tf.errors.AlreadyExistsError <a class="md-anchor" id="AlreadyExistsError"></a>

Raised when an entity that we attempted to create already exists.

For example, running an operation that saves a file
(e.g. [`tf.train.Saver.save()`](../../api_docs/python/train.md#Saver.save))
could potentially raise this exception if an explicit filename for an
existing file was passed.

- - -

#### `tf.errors.AlreadyExistsError.__init__(node_def, op, message)` <a class="md-anchor" id="AlreadyExistsError.__init__"></a>

Creates an `AlreadyExistsError`.



- - -

### class tf.errors.PermissionDeniedError <a class="md-anchor" id="PermissionDeniedError"></a>

Raised when the caller does not have permission to run an operation.

For example, running the
[`tf.WholeFileReader.read()`](../../api_docs/python/io_ops.md#WholeFileReader)
operation could raise `PermissionDeniedError` if it receives the name of a
file for which the user does not have the read file permission.

- - -

#### `tf.errors.PermissionDeniedError.__init__(node_def, op, message)` <a class="md-anchor" id="PermissionDeniedError.__init__"></a>

Creates a `PermissionDeniedError`.



- - -

### class tf.errors.UnauthenticatedError <a class="md-anchor" id="UnauthenticatedError"></a>

The request does not have valid authentication credentials.

This exception is not currently used.

- - -

#### `tf.errors.UnauthenticatedError.__init__(node_def, op, message)` <a class="md-anchor" id="UnauthenticatedError.__init__"></a>

Creates an `UnauthenticatedError`.



- - -

### class tf.errors.ResourceExhaustedError <a class="md-anchor" id="ResourceExhaustedError"></a>

Some resource has been exhausted.

For example, this error might be raised if a per-user quota is
exhausted, or perhaps the entire file system is out of space.

- - -

#### `tf.errors.ResourceExhaustedError.__init__(node_def, op, message)` <a class="md-anchor" id="ResourceExhaustedError.__init__"></a>

Creates a `ResourceExhaustedError`.



- - -

### class tf.errors.FailedPreconditionError <a class="md-anchor" id="FailedPreconditionError"></a>

Operation was rejected because the system is not in a state to execute it.

This exception is most commonly raised when running an operation
that reads a [`tf.Variable`](../../api_docs/python/state_ops.md#Variable)
before it has been initialized.

- - -

#### `tf.errors.FailedPreconditionError.__init__(node_def, op, message)` <a class="md-anchor" id="FailedPreconditionError.__init__"></a>

Creates a `FailedPreconditionError`.



- - -

### class tf.errors.AbortedError <a class="md-anchor" id="AbortedError"></a>

The operation was aborted, typically due to a concurrent action.

For example, running a
[`queue.enqueue()`](../../api_docs/python/io_ops.md#QueueBase.enqueue)
operation may raise `AbortedError` if a
[`queue.close()`](../../api_docs/python/io_ops.md#QueueBase.close) operation
previously ran.

- - -

#### `tf.errors.AbortedError.__init__(node_def, op, message)` <a class="md-anchor" id="AbortedError.__init__"></a>

Creates an `AbortedError`.



- - -

### class tf.errors.OutOfRangeError <a class="md-anchor" id="OutOfRangeError"></a>

Raised when an operation executed past the valid range.

This exception is raised in "end-of-file" conditions, such as when a
[`queue.dequeue()`](../../api_docs/python/io_ops.md#QueueBase.dequeue)
operation is blocked on an empty queue, and a
[`queue.close()`](../../api_docs/python/io_ops.md#QueueBase.close)
operation executes.

- - -

#### `tf.errors.OutOfRangeError.__init__(node_def, op, message)` <a class="md-anchor" id="OutOfRangeError.__init__"></a>

Creates an `OutOfRangeError`.



- - -

### class tf.errors.UnimplementedError <a class="md-anchor" id="UnimplementedError"></a>

Raised when an operation has not been implemented.

Some operations may raise this error when passed otherwise-valid
arguments that it does not currently support. For example, running
the [`tf.nn.max_pool()`](../../api_docs/python/nn.md#max_pool) operation
would raise this error if pooling was requested on the batch dimension,
because this is not yet supported.

- - -

#### `tf.errors.UnimplementedError.__init__(node_def, op, message)` <a class="md-anchor" id="UnimplementedError.__init__"></a>

Creates an `UnimplementedError`.



- - -

### class tf.errors.InternalError <a class="md-anchor" id="InternalError"></a>

Raised when the system experiences an internal error.

This exception is raised when some invariant expected by the runtime
has been broken. Catching this exception is not recommended.

- - -

#### `tf.errors.InternalError.__init__(node_def, op, message)` <a class="md-anchor" id="InternalError.__init__"></a>

Creates an `InternalError`.



- - -

### class tf.errors.UnavailableError <a class="md-anchor" id="UnavailableError"></a>

Raised when the runtime is currently unavailable.

This exception is not currently used.

- - -

#### `tf.errors.UnavailableError.__init__(node_def, op, message)` <a class="md-anchor" id="UnavailableError.__init__"></a>

Creates an `UnavailableError`.



- - -

### class tf.errors.DataLossError <a class="md-anchor" id="DataLossError"></a>

Raised when unrecoverable data loss or corruption is encountered.

For example, this may be raised by running a
[`tf.WholeFileReader.read()`](../../api_docs/python/io_ops.md#WholeFileReader)
operation, if the file is truncated while it is being read.

- - -

#### `tf.errors.DataLossError.__init__(node_def, op, message)` <a class="md-anchor" id="DataLossError.__init__"></a>

Creates a `DataLossError`.



