# TensorFlow C++ Session API reference documentation <a class="md-anchor" id="AUTOGENERATED-tensorflow-c---session-api-reference-documentation"></a>

TensorFlow's public C++ API includes only the API for executing graphs, as of
version 0.5. To control the execution of a graph from C++:

1. Build the computation graph using the [Python API](../../api_docs/python/).
1. Use [tf.train.write_graph()](../../api_docs/python/train.md#write_graph) to
write the graph to a file.
1. Load the graph using the C++ Session API. For example:

  ```c++
  // Reads a model graph definition from disk, and creates a session object you
  // can use to run it.
  Status LoadGraph(string graph_file_name, Session** session) {
    GraphDef graph_def;
    TF_RETURN_IF_ERROR(
        ReadBinaryProto(Env::Default(), graph_file_name, &graph_def));
    TF_RETURN_IF_ERROR(NewSession(SessionOptions(), session));
    TF_RETURN_IF_ERROR((*session)->Create(graph_def));
    return Status::OK();
  }
```

1. Run the graph with a call to `session->Run()`


##Classes <a class="md-anchor" id="AUTOGENERATED-classes"></a>

* [tensorflow::Env](../../api_docs/cc/ClassEnv.md)
* [tensorflow::EnvWrapper](../../api_docs/cc/ClassEnvWrapper.md)
* [tensorflow::RandomAccessFile](../../api_docs/cc/ClassRandomAccessFile.md)
* [tensorflow::Session](../../api_docs/cc/ClassSession.md)
* [tensorflow::Status](../../api_docs/cc/ClassStatus.md)
* [tensorflow::Tensor](../../api_docs/cc/ClassTensor.md)
* [tensorflow::TensorBuffer](../../api_docs/cc/ClassTensorBuffer.md)
* [tensorflow::TensorShape](../../api_docs/cc/ClassTensorShape.md)
* [tensorflow::TensorShapeIter](../../api_docs/cc/ClassTensorShapeIter.md)
* [tensorflow::TensorShapeUtils](../../api_docs/cc/ClassTensorShapeUtils.md)
* [tensorflow::Thread](../../api_docs/cc/ClassThread.md)
* [tensorflow::WritableFile](../../api_docs/cc/ClassWritableFile.md)

##Structs <a class="md-anchor" id="AUTOGENERATED-structs"></a>

* [tensorflow::SessionOptions](../../api_docs/cc/StructSessionOptions.md)
* [tensorflow::Status::State](../../api_docs/cc/StructState.md)
* [tensorflow::TensorShapeDim](../../api_docs/cc/StructTensorShapeDim.md)
* [tensorflow::ThreadOptions](../../api_docs/cc/StructThreadOptions.md)


<div class='sections-order' style="display: none;">
<!--
<!-- ClassEnv.md -->
<!-- ClassEnvWrapper.md -->
<!-- ClassRandomAccessFile.md -->
<!-- ClassSession.md -->
<!-- ClassStatus.md -->
<!-- ClassTensor.md -->
<!-- ClassTensorBuffer.md -->
<!-- ClassTensorShape.md -->
<!-- ClassTensorShapeIter.md -->
<!-- ClassTensorShapeUtils.md -->
<!-- ClassThread.md -->
<!-- ClassWritableFile.md -->
<!-- StructSessionOptions.md -->
<!-- StructState.md -->
<!-- StructTensorShapeDim.md -->
<!-- StructThreadOptions.md -->
-->
</div>
