### `tf.truediv(x, y, name=None)` {#truediv}

Divides x / y elementwise, always producing floating point results.

The same as `tf.div` for floating point arguments, but casts integer arguments
to floating point before dividing so that the result is always floating point.
This op is generated by normal `x / y` division in Python 3 and in Python 2.7
with `from __future__ import division`.  If you want integer division that
rounds down, use `x // y` or `tf.floordiv`.

`x` and `y` must have the same numeric type.  If the inputs are floating
point, the output will have the same type.  If the inputs are integral, the
inputs are cast to `float32` for `int8` and `int16` and `float64` for `int32`
and `int64` (matching the behavior of Numpy).

##### Args:


*  <b>`x`</b>: `Tensor` numerator of numeric type.
*  <b>`y`</b>: `Tensor` denominator of numeric type.
*  <b>`name`</b>: A name for the operation (optional).

##### Returns:

  `x / y` evaluated in floating point.

##### Raises:


*  <b>`TypeError`</b>: If `x` and `y` have different dtypes.

