---
title: Resources
permalink: /docs/resources/
---

Jekyll’s growing use is producing a wide variety of tutorials, frameworks, extensions, examples, and other resources that can be very helpful. Below is a collection of links to some of the most popular Jekyll resources.

### Useful Guides

- [Jekyll Tips](http://jekyll.tips) is a set of resources created by [CloudCannon](https://cloudcannon.com) to help folks get up and running with Jekyll. They cover all skill levels, and even include some great video tutorials.
- [Jekyll Cheatsheet](http://jekyll.tips/jekyll-cheat-sheet/) is a single-page resource for Jekyll filters, variables, and the like.
- [“Creating and Hosting a Personal Site on GitHub”](http://jmcglone.com/guides/github-pages/)
- [‘Build A Blog With Jekyll And GitHub Pages’ on Smashing Magazine](https://www.smashingmagazine.com/2014/08/01/build-blog-jekyll-github-pages/)
- Publishing to GitHub Pages? [Check out our documentation page for just that purpose](/docs/github-pages/).
- [Blogging with Git, Emacs and Jekyll](https://metajack.im/2009/01/23/blogging-with-git-emacs-and-jekyll/)
- [Tips for working with GitHub Pages Integration](https://gist.github.com/jedschneider/2890453)

### Integrations

- Use a saas service as a backend for forms (contact forms, hiring forms, etc.)
  - [Formspree (also open source)](https://formspree.io/)
  - [FormKeep](https://formkeep.com/guides/contact-form-jekyll?utm_source=github&utm_medium=jekyll-docs&utm_campaign=contact-form-jekyll)
  - [Simple Form](https://getsimpleform.com/)
  - [Formingo](https://www.formingo.co/guides/jekyll?utm_source=github&utm_medium=jekyll-docs&utm_campaign=Jekyll%20Documentation)
- [Jekyll Bootstrap](http://jekyllbootstrap.com), 0 to Blog in 3 minutes. Provides detailed explanations, examples, and helper-code to make getting started with Jekyll easier.
- [Integrating Twitter with Jekyll](http://www.justkez.com/integrating-twitter-with-jekyll/)
  > “Having migrated Justkez.com to be based on Jekyll, I was pondering how I might include my recent twitterings on the front page of the site. In the WordPress world, this would have been done via a plugin which may or may not have hung the loading of the page, might have employed caching, but would certainly have had some overheads. … Not in Jekyll.”
- [Staticman](https://staticman.net): Add user-generated content to a Jekyll site (free and open source)

### Other commentary

- [‘My Jekyll Fork’, by Mike West](https://mikewest.org/2009/11/my-jekyll-fork)

  > “Jekyll is a well-architected throwback to a time before WordPress, when men were men, and HTML was static. I like the ideas it espouses, and have made a few improvements to it’s core. Here, I’ll point out some highlights of my fork in the hopes that they see usage beyond this site.”

- [‘About this Website’, by Carter Allen](http://cartera.me/2010/08/12/about-this-website/)

  > “Jekyll is everything that I ever wanted in a blogging engine. Really. It isn’t perfect, but what’s excellent about it is that if there’s something wrong, I know exactly how it works and how to fix it. It runs on the your machine only, and is essentially an added”build" step between you and the browser. I coded this entire site in TextMate using standard HTML5 and CSS3, and then at the end I added just a few little variables to the markup. Presto-chango, my site is built and I am at peace with the world.”

- [Generating a Tag Cloud in Jekyll](http://www.justkez.com/generating-a-tag-cloud-in-jekyll/) – A guide to implementing a tag cloud and per-tag content pages using Jekyll.
- A way to [extend Jekyll](https://github.com/rfelix/jekyll_ext) without forking and modifying the Jekyll gem codebase and some [portable Jekyll extensions](https://wiki.github.com/rfelix/jekyll_ext/extensions) that can be reused and shared.
- [Using your Rails layouts in Jekyll](http://numbers.brighterplanet.com/2010/08/09/sharing-rails-views-with-jekyll)
- [Adding Ajax pagination to Jekyll](https://eduardoboucas.com/blog/2014/11/05/adding-ajax-pagination-to-jekyll.html)
