---
title: Configuration
permalink: /docs/configuration/
---

Jekyll allows you to concoct your sites in any way you can dream up, and it’s
thanks to the powerful and flexible configuration options that this is possible.
These options can either be specified in a `_config.yml` file placed in your
site’s root directory, or can be specified as flags for the `jekyll` executable
in the terminal.

## Configuration Settings

### Global Configuration

The table below lists the available settings for Jekyll, and the various <code
class="option">options</code> (specified in the configuration file) and <code
class="flag">flags</code> (specified on the command-line) that control them.

<div class="mobile-side-scroller">
<table>
  <thead>
    <tr>
      <th>Setting</th>
      <th>
        <span class="option">Options</span> and <span class="flag">Flags</span>
      </th>
    </tr>
  </thead>
  <tbody>
    <tr class="setting">
      <td>
        <p class="name"><strong>Site Source</strong></p>
        <p class="description">Change the directory where Jekyll will read files</p>
      </td>
      <td class="align-center">
        <p><code class="option">source: DIR</code></p>
        <p><code class="flag">-s, --source DIR</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Site Destination</strong></p>
        <p class="description">Change the directory where Jekyll will write files</p>
      </td>
      <td class="align-center">
        <p><code class="option">destination: DIR</code></p>
        <p><code class="flag">-d, --destination DIR</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Safe</strong></p>
        <p class="description">Disable <a href="../plugins/">custom plugins, and ignore symbolic links</a>.</p>
      </td>
      <td class="align-center">
        <p><code class="option">safe: BOOL</code></p>
        <p><code class="flag">--safe</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Exclude</strong></p>
        <p class="description">
          Exclude directories and/or files from the
          conversion. These exclusions are relative to the site's
          source directory and cannot be outside the source directory.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">exclude: [DIR, FILE, ...]</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Include</strong></p>
        <p class="description">
          Force inclusion of directories and/or files in the conversion.
          <code>.htaccess</code> is a good example since dotfiles are excluded
          by default.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">include: [DIR, FILE, ...]</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Keep files</strong></p>
        <p class="description">
          When clobbering the site destination, keep the selected files.
          Useful for files that are not generated by jekyll; e.g. files or
          assets that are generated by your build tool.
          The paths are relative to the <code>destination</code>.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">keep_files: [DIR, FILE, ...]</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Time Zone</strong></p>
        <p class="description">
            Set the time zone for site generation. This sets the <code>TZ</code>
            environment variable, which Ruby uses to handle time and date
            creation and manipulation. Any entry from the
            <a href="https://en.wikipedia.org/wiki/Tz_database">IANA Time Zone
            Database</a> is valid, e.g. <code>America/New_York</code>. A list of all
            available values can be found <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">
            here</a>. The default is the local time zone, as set by your operating system.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">timezone: TIMEZONE</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Encoding</strong></p>
        <p class="description">
            Set the encoding of files by name (only available for Ruby
            1.9 or later).
            The default value is <code>utf-8</code> starting in 2.0.0,
            and <code>nil</code> before 2.0.0, which will yield the Ruby
            default of <code>ASCII-8BIT</code>.
            Available encodings can be shown by the
            command <code>ruby -e 'puts Encoding::list.join("\n")'</code>.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">encoding: ENCODING</code></p>
      </td>
    </tr>
    <tr>
      <td>
        <p class='name'><strong>Defaults</strong></p>
        <p class='description'>
            Set defaults for <a href="../frontmatter/" title="YAML Front Matter">YAML Front Matter</a>
            variables.
        </p>
      </td>
      <td class='align-center'>
        <p>see <a href="#front-matter-defaults" title="details">below</a></p>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="note warning">
  <h5>Destination folders are cleaned on site builds</h5>
  <p>
    The contents of <code>&lt;destination&gt;</code> are automatically
    cleaned, by default, when the site is built. Files or folders that are not
    created by your site will be removed. Some files could be retained
    by specifying them within the <code>&lt;keep_files&gt;</code> configuration directive.
  </p>
  <p>
    Do not use an important location for <code>&lt;destination&gt;</code>; instead, use it as
    a staging area and copy files from there to your web server.
  </p>
</div>

### Build Command Options

<div class="mobile-side-scroller">
<table>
  <thead>
    <tr>
      <th>Setting</th>
      <th><span class="option">Options</span> and <span class="flag">Flags</span></th>
    </tr>
  </thead>
  <tbody>
    <tr class="setting">
      <td>
        <p class="name"><strong>Regeneration</strong></p>
        <p class="description">Enable auto-regeneration of the site when files are modified.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">-w, --[no-]watch</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Configuration</strong></p>
        <p class="description">Specify config files instead of using <code>_config.yml</code> automatically. Settings in later files override settings in earlier files.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">--config FILE1[,FILE2,...]</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Drafts</strong></p>
        <p class="description">Process and render draft posts.</p>
      </td>
      <td class="align-center">
        <p><code class="option">show_drafts: BOOL</code></p>
        <p><code class="flag">--drafts</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Environment</strong></p>
        <p class="description">Use a specific environment value in the build.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">JEKYLL_ENV=production</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Future</strong></p>
        <p class="description">Publish posts or collection documents with a future date.</p>
      </td>
      <td class="align-center">
        <p><code class="option">future: BOOL</code></p>
        <p><code class="flag">--future</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Unpublished</strong></p>
        <p class="description">Render posts that were marked as unpublished.</p>
      </td>
      <td class="align-center">
        <p><code class="option">unpublished: BOOL</code></p>
        <p><code class="flag">--unpublished</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>LSI</strong></p>
        <p class="description">Produce an index for related posts. Requires the <a href="http://www.classifier-reborn.com/">classifier-reborn</a> plugin.</p>
      </td>
      <td class="align-center">
        <p><code class="option">lsi: BOOL</code></p>
        <p><code class="flag">--lsi</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Limit Posts</strong></p>
        <p class="description">Limit the number of posts to parse and publish.</p>
      </td>
      <td class="align-center">
        <p><code class="option">limit_posts: NUM</code></p>
        <p><code class="flag">--limit_posts NUM</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Force polling</strong></p>
        <p class="description">Force watch to use polling.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">--force_polling</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Verbose output</strong></p>
        <p class="description">Print verbose output.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">-V, --verbose</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Silence Output</strong></p>
        <p class="description">Silence the normal output from Jekyll
        during a build</p>
      </td>
      <td class="align-center">
        <p><code class="flag">-q, --quiet</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Incremental build</strong></p>
        <p class="description">
            Enable the experimental incremental build feature. Incremental build only
            re-builds posts and pages that have changed, resulting in significant performance
            improvements for large sites, but may also break site generation in certain
            cases.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">incremental: BOOL</code></p>
        <p><code class="flag">-I, --incremental</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Liquid profiler</strong></p>
        <p class="description">
            Generate a Liquid rendering profile to help you identify performance bottlenecks.
        </p>
      </td>
      <td class="align-center">
        <p><code class="option">profile: BOOL</code></p>
        <p><code class="flag">--profile</code></p>
      </td>
    </tr>
  </tbody>
</table>
</div>


### Serve Command Options

In addition to the options below, the `serve` sub-command can accept any of the options
for the `build` sub-command, which are then applied to the site build which occurs right
before your site is served.

<div class="mobile-side-scroller">
<table>
  <thead>
    <tr>
      <th>Setting</th>
      <th><span class="option">Options</span> and <span class="flag">Flags</span></th>
    </tr>
  </thead>
  <tbody>
    <tr class="setting">
      <td>
        <p class="name"><strong>Local Server Port</strong></p>
        <p class="description">Listen on the given port.</p>
      </td>
      <td class="align-center">
        <p><code class="option">port: PORT</code></p>
        <p><code class="flag">--port PORT</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Local Server Hostname</strong></p>
        <p class="description">Listen at the given hostname.</p>
      </td>
      <td class="align-center">
        <p><code class="option">host: HOSTNAME</code></p>
        <p><code class="flag">--host HOSTNAME</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Base URL</strong></p>
        <p class="description">Serve the website from the given base URL</p>
      </td>
      <td class="align-center">
        <p><code class="option">baseurl: URL</code></p>
        <p><code class="flag">--baseurl URL</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Detach</strong></p>
        <p class="description">Detach the server from the terminal</p>
      </td>
      <td class="align-center">
        <p><code class="option">detach: BOOL</code></p>
        <p><code class="flag">-B, --detach</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>Skips the initial site build.</strong></p>
        <p class="description">Skips the initial site build which occurs before the server is started.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">--skip-initial-build</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>X.509 (SSL) Private Key</strong></p>
        <p class="description">SSL Private Key.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">--ssl-key</code></p>
      </td>
    </tr>
    <tr class="setting">
      <td>
        <p class="name"><strong>X.509 (SSL) Certificate</strong></p>
        <p class="description">SSL Public certificate.</p>
      </td>
      <td class="align-center">
        <p><code class="flag">--ssl-cert</code></p>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="note warning">
  <h5>Do not use tabs in configuration files</h5>
  <p>
    This will either lead to parsing errors, or Jekyll will revert to the
    default settings. Use spaces instead.
  </p>
</div>

## Custom WEBrick Headers

You can provide custom headers for your site by adding them to `_config.yml`

```yaml
# File: _config.yml
webrick:
  headers:
    My-Header: My-Value
    My-Other-Header: My-Other-Value
```

### Defaults

We provide by default `Content-Type` and `Cache-Control` response headers: one
dynamic in order to specify the nature of the data being served, the other
static in order to disable caching so that you don't have to fight with Chrome's
aggressive caching when you are in development mode.

## Specifying a Jekyll environment at build time

In the build (or serve) arguments, you can specify a Jekyll environment and value. The build will then apply this value in any conditional statements in your content.

For example, suppose you set this conditional statement in your code:

```liquid
{% raw %}
{% if jekyll.environment == "production" %}
   {% include disqus.html %}
{% endif %}
{% endraw %}
```

When you build your Jekyll site, the content inside the `if` statement won't be run unless you also specify a `production` environment in the build command, like this:

```sh
JEKYLL_ENV=production jekyll build
```

Specifying an environment value allows you to make certain content available only within specific environments.

The default value for `JEKYLL_ENV` is `development`. Therefore if you omit `JEKYLL_ENV` from the build arguments, the default value will be `JEKYLL_ENV=development`. Any content inside `{% raw %}{% if jekyll.environment == "development" %}{% endraw %}` tags will automatically appear in the build.

Your environment values can be anything you want (not just `development` or `production`). Some elements you might want to hide in development environments include Disqus comment forms or Google Analytics. Conversely, you might want to expose an "Edit me in GitHub" button in a development environment but not include it in production environments.

By specifying the option in the build command, you avoid having to change values in your configuration files when moving from one environment to another.

## Front Matter defaults

Using [YAML Front Matter](../frontmatter/) is one way that you can specify configuration in the pages and posts for your site. Setting things like a default layout, or customizing the title, or specifying a more precise date/time for the post can all be added to your page or post front matter.

Often times, you will find that you are repeating a lot of configuration options. Setting the same layout in each file, adding the same category - or categories - to a post, etc. You can even add custom variables like author names, which might be the same for the majority of posts on your blog.

Instead of repeating this configuration each time you create a new post or page, Jekyll provides a way to set these defaults in the site configuration. To do this, you can specify site-wide defaults using the `defaults` key in the `_config.yml` file in your project's root directory.

The `defaults` key holds an array of scope/values pairs that define what defaults should be set for a particular file path, and optionally, a file type in that path.

Let's say that you want to add a default layout to all pages and posts in your site. You would add this to your `_config.yml` file:

```yaml
defaults:
  -
    scope:
      path: "" # an empty string here means all files in the project
    values:
      layout: "default"
```

<div class="note info">
  <h5>Please stop and rerun `jekyll serve` command.</h5>
  <p>
    The <code>_config.yml</code> master configuration file contains global configurations
    and variable definitions that are read once at execution time. Changes made to <code>_config.yml</code>
    during automatic regeneration are not loaded until the next execution.
  </p>
  <p>
    Note <a href="../datafiles">Data Files</a> are included and reloaded during automatic regeneration.
  </p>
</div>

Here, we are scoping the `values` to any file that exists in the path `scope`. Since the path is set as an empty string, it will apply to **all files** in your project. You probably don't want to set a layout on every file in your project - like css files, for example - so you can also specify a `type` value under the `scope` key.

```yaml
defaults:
  -
    scope:
      path: "" # an empty string here means all files in the project
      type: "posts" # previously `post` in Jekyll 2.2.
    values:
      layout: "default"
```

Now, this will only set the layout for files where the type is `posts`.
The different types that are available to you are `pages`, `posts`, `drafts` or any collection in your site. While `type` is optional, you must specify a value for `path` when creating a `scope/values` pair.

As mentioned earlier, you can set multiple scope/values pairs for `defaults`.

```yaml
defaults:
  -
    scope:
      path: ""
      type: "posts"
    values:
      layout: "my-site"
  -
    scope:
      path: "projects"
      type: "pages" # previously `page` in Jekyll 2.2.
    values:
      layout: "project" # overrides previous default layout
      author: "Mr. Hyde"
```

With these defaults, all posts would use the `my-site` layout. Any html files that exist in the `projects/` folder will use the `project` layout, if it exists. Those files will also have the `page.author` [liquid variable](../variables/) set to `Mr. Hyde`.

```yaml
collections:
  my_collection:
    output: true

defaults:
  -
    scope:
      path: ""
      type: "my_collection" # a collection in your site, in plural form
    values:
      layout: "default"
```

In this example, the `layout` is set to `default` inside the
[collection](../collections/) with the name `my_collection`.

### Precedence

Jekyll will apply all of the configuration settings you specify in the `defaults` section of your `_config.yml` file. However, you can choose to override settings from other scope/values pair by specifying a more specific path for the scope.

You can see that in the second to last example above. First, we set the default layout to `my-site`. Then, using a more specific path, we set the default layout for files in the `projects/` path to `project`. This can be done with any value that you would set in the page or post front matter.

Finally, if you set defaults in the site configuration by adding a `defaults` section to your `_config.yml` file, you can override those settings in a post or page file. All you need to do is specify the settings in the post or page front matter. For example:

```yaml
# In _config.yml
...
defaults:
  -
    scope:
      path: "projects"
      type: "pages"
    values:
      layout: "project"
      author: "Mr. Hyde"
      category: "project"
...
```

```yaml
# In projects/foo_project.md
---
author: "John Smith"
layout: "foobar"
---
The post text goes here...
```

The `projects/foo_project.md` would have the `layout` set to `foobar` instead
of `project` and the `author` set to `John Smith` instead of `Mr. Hyde` when
the site is built.

## Default Configuration

Jekyll runs with the following configuration options by default. Alternative
settings for these options can be explicitly specified in the configuration
file or on the command-line.

<div class="note warning">
  <h5>There are two unsupported kramdown options</h5>
  <p>
    Please note that both <code>remove_block_html_tags</code> and
    <code>remove_span_html_tags</code> are currently unsupported in Jekyll due
    to the fact that they are not included within the kramdown HTML converter.
  </p>
</div>

```yaml
# Where things are
source:       .
destination:  ./_site
plugins_dir:  _plugins
layouts_dir:  _layouts
data_dir:     _data
includes_dir: _includes
collections:
  posts:
    output:   true

# Handling Reading
safe:         false
include:      [".htaccess"]
exclude:      ["node_modules", "vendor/bundle/", "vendor/cache/", "vendor/gems/", "vendor/ruby/"]
keep_files:   [".git", ".svn"]
encoding:     "utf-8"
markdown_ext: "markdown,mkdown,mkdn,mkd,md"

# Filtering Content
show_drafts: null
limit_posts: 0
future:      false
unpublished: false

# Plugins
whitelist: []
gems:      []

# Conversion
markdown:    kramdown
highlighter: rouge
lsi:         false
excerpt_separator: "\n\n"
incremental: false

# Serving
detach:  false
port:    4000
host:    127.0.0.1
baseurl: "" # does not include hostname
show_dir_listing: false

# Outputting
permalink:     date
paginate_path: /page:num
timezone:      null

quiet:    false
verbose:  false
defaults: []

liquid:
  error_mode: warn

# Markdown Processors
rdiscount:
  extensions: []

redcarpet:
  extensions: []

kramdown:
  auto_ids:       true
  footnote_nr:    1
  entity_output:  as_char
  toc_levels:     1..6
  smart_quotes:   lsquo,rsquo,ldquo,rdquo
  input:          GFM
  hard_wrap:      false
  footnote_nr:    1
```

## Liquid Options

Liquid's response to errors can be configured by setting `error_mode`. The
options are

- `lax` --- Ignore all errors.
- `warn` --- Output a warning on the console for each error.
- `strict` --- Output an error message and stop the build.

## Markdown Options

The various Markdown renderers supported by Jekyll sometimes have extra options
available.

### Redcarpet

Redcarpet can be configured by providing an `extensions` sub-setting, whose
value should be an array of strings. Each string should be the name of one of
the `Redcarpet::Markdown` class's extensions; if present in the array, it will
set the corresponding extension to `true`.

Jekyll handles two special Redcarpet extensions:

- `no_fenced_code_blocks` --- By default, Jekyll sets the `fenced_code_blocks`
extension (for delimiting code blocks with triple tildes or triple backticks)
to `true`, probably because GitHub's eager adoption of them is starting to make
them inescapable. Redcarpet's normal `fenced_code_blocks` extension is inert
when used with Jekyll; instead, you can use this inverted version of the
extension for disabling fenced code.

Note that you can also specify a language for highlighting after the first
delimiter:

        ```ruby
        # ...ruby code
        ```

With both fenced code blocks and highlighter enabled, this will statically
highlight the code; without any syntax highlighter, it will add a
`class="LANGUAGE"` attribute to the `<code>` element, which can be used as a
hint by various JavaScript code highlighting libraries.

- `smart` --- This pseudo-extension turns on SmartyPants, which converts
  straight quotes to curly quotes and runs of hyphens to em (`---`) and en (`--`) dashes.

All other extensions retain their usual names from Redcarpet, and no renderer
options aside from `smart` can be specified in Jekyll. [A list of available
extensions can be found in the Redcarpet README file.][redcarpet_extensions]
Make sure you're looking at the README for the right version of
Redcarpet: Jekyll currently uses v3.2.x. The most commonly used
extensions are:

- `tables`
- `no_intra_emphasis`
- `autolink`

[redcarpet_extensions]: https://github.com/vmg/redcarpet/blob/v3.2.2/README.markdown#and-its-like-really-simple-to-use

### Custom Markdown Processors

If you're interested in creating a custom markdown processor, you're in luck! Create a new class in the `Jekyll::Converters::Markdown` namespace:

```ruby
class Jekyll::Converters::Markdown::MyCustomProcessor
  def initialize(config)
    require 'funky_markdown'
    @config = config
  rescue LoadError
    STDERR.puts 'You are missing a library required for Markdown. Please run:'
    STDERR.puts '  $ [sudo] gem install funky_markdown'
    raise FatalException.new("Missing dependency: funky_markdown")
  end

  def convert(content)
    ::FunkyMarkdown.new(content).convert
  end
end
```

Once you've created your class and have it properly set up either as a plugin
in the `_plugins` folder or as a gem, specify it in your `_config.yml`:

```yaml
markdown: MyCustomProcessor
```

## Incremental Regeneration
<div class="note warning">
  <h5>Incremental regeneration is still an experimental feature</h5>
  <p>
    While incremental regeneration will work for the most common cases, it will
    not work correctly in every scenario. Please be extremely cautious when
    using the feature, and report any problems not listed below by
    <a href="https://github.com/jekyll/jekyll/issues/new">opening an issue on GitHub</a>.
  </p>
</div>

Incremental regeneration helps shorten build times by only generating documents
and pages that were updated since the previous build. It does this by keeping
track of both file modification times and inter-document dependencies in the
`.jekyll-metadata` file.

Under the current implementation, incremental regeneration will only generate a
document or page if either it, or one of its dependencies, is modified. Currently,
the only types of dependencies tracked are includes (using the
{% raw %}`{% include %}`{% endraw %} tag) and layouts. This means that plain
references to other documents (for example, the common case of iterating over
`site.posts` in a post listings page) will not be detected as a dependency.

To remedy some of these shortfalls, putting `regenerate: true` in the front-matter
of a document will force Jekyll to regenerate it regardless of whether it has been
modified. Note that this will generate the specified document only; references
to other documents' contents will not work since they won't be re-rendered.

Incremental regeneration can be enabled via the `--incremental` flag (`-I` for
short) from the command-line or by setting `incremental: true` in your
configuration file.
