<?php include "./inc/template.php"; 
head(
  $title = 'Learn JavaScript | Mozilla Developer Network',
  $pageid = 'learn-js', 
  $bodyclass = 'section-learning',
  $headerclass = 'compact'
); ?>

<header id="page-head">
  <div class="wrap">
    <nav class="crumb"><a href="learn-landing.php">Back to Home</a></nav>
    <h1 class="page-title">Learn JavaScript</h1>
    <p><strong>JavaScript</strong> (JS for short) is the programming language that enables web pages 
    ​to respond to user interaction beyond the basic level provided by HTML links and forms. ​The links 
    on this page lead to a variety of JavaScript tutorials and JavaScript training materials. Whether 
    you are just starting out, wanting to learn JS basics, or are an old hand, wanting to sharpen your 
    skills, you can find helpful resources here for JS best practices.</p>
  </div>  
</header>
  
<section id="content">
<div class="wrap">

  <section id="content-main" class="full" role="main">
    <div id="intro-level" class="learn-module boxed">
      <h2>Introductory Level</h2>
      <ul class="link-list">
        <li>
          <h3 class="title"><a href="https://developer.mozilla.org/en/JavaScript/Getting_Started">Getting started with JavaScript</a></h3>
          <h4 class="source">MDN</h4>
          <p>What is JavaScript and how can it help you?</p>
        </li>
        <li>
          <h3 class="title"><a href="http://en.wikiversity.org/wiki/Web_Design/An_Introduction_to_Programming_with_Javascript" rel="external">An introduction to programming with JavaScript</a></h3>
          <h4 class="source">Wikiversity</h4>
          <p>Learn the basics of programming with JavaScript</p>
        </li>
        <li>
          <h3 class="title"><a href="http://dev.opera.com/articles/view/programming-the-real-basics/" rel="external">Programming &ndash; the real basics</a></h3>
          <h4 class="source">Dev.Opera Web</h4>
          <p>Basic fundamentals of programming. Following articles introduce what you can do with JavaScript, best practices for using it, and more.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://code.google.com/edu/submissions/html-css-javascript/#javascript" rel="external">JavaScript from the ground up</a></h3>
          <h4 class="source">Google Code University</h4>
          <p>Video tutorial on making pages interactive with JavaScript</p>
        </li>
      </ul>
    </div>
    
    <div id="inter-level" class="learn-module boxed">
      <h2>Intermediate Level</h2>
      <ul class="link-list">
        <li>
          <h3 class="title"><a href="https://developer.mozilla.org/en/A_re-introduction_to_JavaScript">A re-introduction to JavaScript</a></h3>
          <h4 class="source">MDN</h4>
          <p>A recap of the JavaScript programming language aimed at intermediate-level developers.</p>
        </li>
        <li>
          <h3 class="title"><a href="https://developer.mozilla.org/en/JavaScript/Guide">JavaScript Guide</a></h3>
          <h4 class="source">MDN</h4>
          <p>A comprehensive, regularly updated guide to JavaScript for all levels of learning from beginner to advanced.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://eloquentjavascript.net/contents.html" rel="external">Eloquent JavaScript</a></h3>
          <p>A comprehensive guide to intermediate and advanced JavaScript methodologies.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://www.addyosmani.com/resources/essentialjsdesignpatterns/book/" rel="external">Essential JavaScript Design Patterns</a></h3>
          <h4 class="source">Addy Osmani</h4>
          <p>An introduction to essential JavaScript design patterns.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://www.yuiblog.com/blog/2007/01/24/video-crockford-tjpl/" rel="external">The JavaScript Programming Language</a></h3>
          <h4 class="source">YUI Blog</h4>
          <p>Douglas Crockford explores the language as it is today, and how it came to be.</p>
        </li>
        <li>
          <h3 class="title"><a href="https://developer.mozilla.org/en/Introduction_to_Object-Oriented_JavaScript">Introduction to object-oriented JavaScript</a></h3>
          <h4 class="source">MDN</h4>
          <p>Learn about the JavaScript object model.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://dev.opera.com/articles/view/javascript-best-practices/" rel="external">JavaScript best practices</a></h3>
          <h4 class="source">Dev.Opera</h4>
          <p>Learn about some of the obvious and (not so) obvious best practices when writing JavaScript.</p>
        </li>
      </ul>
    </div>

    <div id="adv-level" class="learn-module boxed">
      <h2>Advanced Level</h2>
      <ul class="link-list col1">
        <li>
          <h3 class="title"><a href="http://ejohn.org/apps/learn/" rel="external">Learning Advanced JavaScript</a></h3>
          <p>John Resig’s guide to advanced JavaScript.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://www.elated.com/articles/javascript-dom-intro/" rel="external">Introducing the JavaScript DOM</a>
          <h4 class="source">Elated</h4>
          <p>What is the Document Object Model, and why is it useful? This article gives you a gentle introduction to this powerful JavaScript feature.</p>
        </li>
        <li>  
          <h3 class="title"><a href="http://yuiblog.com/blog/2006/10/20/video-crockford-domtheory/" rel="external">An Inconvenient API: The Theory of the DOM</a></h3>
          <h4 class="source">YUI Blog</h4>
          <p>Douglas Crockford explains the Document Object Model.</p>
        </li>
        <li>  
          <h3 class="title"><a href="http://yuiblog.com/blog/2006/11/27/video-crockford-advjs/" rel="external">Advanced JavaScript</a></h3>
          <h4 class="source">YUI Blog</h4>
          <p>Douglas Crockford looks closely at code patterns from which JavaScript programmers can choose in authoring their applications.</p>
        </li>
      </ul>
      <ul class="link-list col2">
        <li>  
          <h3 class="title"><a href="http://bonsaiden.github.com/JavaScript-Garden/" rel="external">JavaScript Garden</a></h3>
          <p>Documentation of the most quirky parts of JavaScript.</p>
        </li>
        <li>  
          <h3 class="title"><a href="http://stackoverflow.com/questions/394601/which-javascript-framework-jquery-vs-dojo-vs" rel="external">Which JavaScript framework?</a></h3>
          <h4 class="source">StackOverflow</h4>
          <p>Advice on choosing a JavaScript framework.</p>
        </li>
        <li>
          <h3 class="title"><a href="http://yuiblog.com/blog/2008/07/22/non-blocking-scripts/" rel="external">Non-blocking JavaScript downloads</a></h3>
          <h4 class="source">YUI Blog</h4>
          <p>Tips on improving the download performance of pages containing JavaScript.</p>
        </li>
      </ul>
    </div>

  </section><!-- /#content-main -->

  <section id="learn-p2pu">
		<h2>Are you tired of learning JS on your own?<br>Do you want to join a community of people who are learning JavaScript and other open web technologies?</h2>
		<p>Consider signing up for free online peer-led classes through <a href="http://p2pu.org/">Peer-to-Peer University's<span title="Peer-to-Peer University"></span></a> <a href="http://p2pu.org/webcraft/course-listing">School of Webcraft</a>. Think of it as an online study group or book club, where you share your struggles and discoveries with others who are learning the same things.</p>
	</section>

	<footer id="learn-fineprint">
		<p>These resources are created by forward-thinking companies and web developers who have embraced open standards and best practices for web development. If you think we've omitted a great resource, please tell us about it in the <a href="https://developer.mozilla.org/forums/viewforum.php?f=4">Open Web Forum</a>. We want to share these resources with our international community, so we prefer ones that provide or allow translations, through an open content license such as <a href="http://creativecommons.org" rel="external">Creative Commons</a>.</p>
	</footer>


</div>
</section>
<?php foot(); ?>
