<?php include "./inc/template.php"; 
head(
  $title = 'Dev Derby Rules | Mozilla Developer Network',
  $pageid = '', 
  $bodyclass = 'section-demos devderby plain',
  $extra_headers = '
  <link rel="stylesheet" type="text/css" href="./media/css/devderby.css"/>
  <link rel="stylesheet" type="text/css" href="./media/css/demos.css"/>
  '
); ?>


<section id="content">
<div class="wrap">

  <header id="page-head">
    <nav id="nav-derby">
      <ul>
        <li><a href="demo-derby.php">Home</a></li>
        <li><a href="demo-derby.php#upcoming">Challenges</a></li>
        <li><em>Rules</em></li>
        <li><a href="demo-derby.php#tab-judging">Judging</a></li>
        <li><a href="demo-derby.php#challenge-prizes">Prizes</a></li>
        <li><a href="demo-derby.php#resources">Resources</a></li>
      </ul>
    </nav>
  </header>

  <section id="content-main" class="full" role="main">
    <header id="derby-head">
      <p class="presents"><a href="demos-landing.php">Mozilla Demo Studio</a> presents:</p>
      <h1>Dev Derby</h1>
      <h2>Dev Derby Contest Official Rules</h2>
    </header>
    
    <h3>Introduction</h3>
    <p> The objective of this series of contests is to encourage the creation of demos that show what open web technologies can do. A new contest with a different theme will be conducted each month until we decide to stop.</p>
    
    <h3>Sponsor</h3>
    <p>The sponsor of this Contest is Mozilla Corporation, located at 650 Castro Street, Suite 300, Mountain View, CA 94041, USA (“Sponsor”).</p>
    
    <h3>Eligibility</h3> 
    <p>No purchase or fee is necessary to enter or claim any prize.</p>
    
    <p>The Contest is open to individuals who are at least the age of majority in their country of residence. Minors 13 years or older who reside in the U.S. and minors in certain other countries, depending on local laws, are also eligible to participate in the Contest but will be required to submit a signed parental consent form. Email us at ecompton at mozilla dot com for a parental consent form.</p>
    
    <p>The Contest is open only to individuals. It is not open to companies, educational institutions, organizations, etc. or to groups associated with such institutions. Entrants may not enter any demos in which such institution may claim ownership.</p>
    
    <p>The Contest is void in any country subject to a U.S boycott and where prohibited by law or restricted by law or regulations.</p>
    
    <p>Employees of Sponsor and its parent company, subsidiaries, affiliates, suppliers, advertising agencies, and the families and persons living in the same household as such employees, are not eligible to participate.</p>
    
    <p>By entering you agree to be bound by these Official Rules and all decisions of the Sponsor and judges, which are final and binding. The Contest is subject to all applicable laws.</p>
    
    <h3>How to Enter</h3>
    <p> To enter, visit the Mozilla Dev Derby, located at https://developer.mozilla.org/devderby (the “Dev Derby page”), review the contest information, create an account, and follow the instructions to submit your demo (“Entry”). As part of the account registration process you will be required to accept the Terms for Demo Contributors, which specify that the creative elements and source code of your Entry will be licensed under open licenses, among other things. Your Entry must comply with the requirements described for all demos and specifically for Entries to this Contest. Your Entry must be uploaded in one of the identified formats before the end of the Submission Period. You may submit as many Entries as you want.</p>
    
    <p>You must be the named and authorized account holder of the email address submitted in connection with your Entry. The authorized account holder is the natural person who is assigned to the email address by an internet access provider, online service provider, or other organization that is responsible for assigning email addresses or the domain associated with the submitted email address. Entries submitted will not be returned or acknowledged.</p>
    
    <p>Without limiting any other rights, the Sponsor has the right to, in the Sponsor's sole discretion, reject or remove from the Contest any Entry that, in the Sponsor's sole discretion, violates these Rules, any applicable Sponsor policy, any applicable laws, or is in any way harmful or objectionable. Sponsor also reserves the right to disqualify any entrant or Entry at the Sponsor's sole discretion. No correspondence shall be entered into.</p>
    
    <h3>Privacy</h3> 
    <p>Through your account registration you will provide us with your email address. We won’t request any other personal information from entrants. We will ask potential winners for their names and addresses so we can send the prize. All Entries and the information provided by entrants with their entries will be publicly available on the demo site and be posted to other sites as well. Except as otherwise stated herein or as otherwise agreed by you and the Sponsor, all other personal information you provide in connection with the Contest will be used only for purposes relating to this Contest, and will not be communicated to third-parties without prior permission or as otherwise specified in our Privacy Policy located at http://www.mozilla.com/en-US/privacy-policy.html.</p>
    
    <h3>Timing for Entry</h3>
    <p> A new Contest begins each month at 12:00:01 a.m. PT on the first day of the month, and ends at 11:59:59 p.m. PT on the last day of that month (“Contest Period”). Each day/date is calculated based on Pacific Time.  Each month’s Contest is separate, however, if you would like an Entry you submitted in a prior month considered for any particular Contest, just send us an email to speters at mozilla dot com. The winner of each month’s Contest will be announced by the 20th of the following month. Contests will be run for an indefinite number of months at Sponsor’s sole discretion. Sponsor will provide notice prior to the beginning of the final Contest.</p>
    
    <h3>Work Criteria</h3> 
    <p>All Entries must meet specific criteria to be accepted into the Contest.  Without limitation, the following conditions apply: (a) Entry must be compatible with and function properly in a current version of Firefox, Firefox Beta or Firefox Aurora, without requiring plug-ins; (b) the full source code, including that of any binary components, must be made available to Sponsor as part of the submission; (c) the description of the Entry included in your submission must be clear and accurate; (d) The Entry must be primarily your original work and may not include any unauthorized intellectual property of a third party; (e) The name of your Entry may not include any Mozilla trademarks or portions thereof; (f) Your Entry must be built using open technologies for the web, such as HTML5, CSS3, or JavaScript (or others); (g) Libraries and modules that are freely available to the public are allowed, but materials or code you must pay for are not. The Entry must further comply with any additional technical requirements set forth on the Contest web site and entry page. Sponsor reserves the right to modify any technical requirements during the course of the Contest in its reasonable discretion, by posting updated instructions on the Contest web site.</p>
    
    <p>In addition to the foregoing, Entries may not: (i) feature or reference any material that infringes upon the rights of any third party, including trademark, copyright, or rights of publicity; (ii) contain vulgar, offensive, obscene or indecent language, behavior or imagery; (iii) defame, libel or otherwise violate the rights of any third party; (iv) violate any federal, state or local laws or ordinances; or (v) be inappropriate, offensive, disparaging or lewd as determined by the Sponsor in its sole discretion. Entries that are, in Sponsor’s sole opinion, inappropriate, inconsistent with Sponsor’s image, disparaging or otherwise not in compliance with these Official Rules, may be disqualified.</p>
    
    <p>Sponsor reserves the right to review an Entry before posting it online, and to remove an Entry even after it has been posted. No guarantee is made that any particular Entry will or will not be posted or regarding the length of the review period. Sponsor reserves the right, in its absolute discretion, to determine if any particular Entry is appropriate for posting. Rejected Entries will not be acknowledged or returned. All Entries that are uploaded and made available for viewing by the general public will be deemed posted at the direction of the Entrant within the meaning of the Digital Millenium Copyright Act and the Communications Decency Act.</p>
    
    <h3>Selection of Monthly Winner</h3> 
    <p>Entries will be reviewed by a panel of judges appointed by Sponsor in its sole discretion. The judges will rate the demos on the criteria that have been announced on the Dev Derby Page for that month’s Contest. The criteria will change from month to month.  Examples of criteria include “most useful” “most creative,”  “best design,” etc. Visitors to the demo site will have the opportunity to “like” Entries. The judges may take the number of “likes” received by Entries into consideration in their judging. Anyone who has been selected a winner will not be selected again during the same calendar year. The monthly winner will be announced on or about the 20th day of the following month.</p>
    
    <h3>Conditions of Eligibility for Potential Winners</h3> 
    <p>Potential winners may be required to sign and return an Affidavit of Eligibility and Liability/Publicity Release (except where imposing such condition is prohibited by law).  Failure to comply when requested may result in disqualification and selection of an alternate winner.  If any winner is a minor under the laws of his/her place of residence, prize may be awarded to parent or legal guardian who must sign all necessary documents.</p>
    
    <h3>Prize</h3> 
    <p>The monthly grand prize for 1st place is an unlocked Android phone. One (1) prize is available for each monthly Contest. Approximate retail value: $500. All items not specified herein are winner’s responsibility, including but not limited to obtaining a subscription plan with a telecommunications carrier to use the phone. Prize is non-transferable and may not be exchanged for any other prize. Sponsor reserves the right to substitute a prize of comparable value in its sole discretion if the advertised prize becomes unavailable.  Limit one prize per person during any calendar year.</p>
    
    <h3>Winner Notification/Validation</h3> 
    <p>The winner for each month will be notified by email within approximately twenty (20) days after the end of that month. Each potential winner may be required to sign and return to Sponsor an affidavit of eligibility and liability/publicity release, where lawful, within ten (10) days of the date of winning notification; otherwise the prize may be forfeited, and the entrant having the next highest score will be deemed to be the winner.  If any winner is a minor under the laws of his/her place of residence, all documents must be signed by a parent or legal guardian. If a winner cannot be notified within five days after his or her selection, or in the event of non-compliance with any of these requirements, the prize will be forfeited, and the entrant having the next highest score will be deemed the winner.</p>
    
    <h3>Authorization to Use Winner’s Entry Information &amp; Name</h3>
    <p> By entering, you agree that Sponsor and its designees may use your name, user name, screen shot, basic information about your Entry, and your MDN page content in any media now known or hereafter developed for promotional and/or publicity purposes, unless prohibited by law. Each winner also agrees to participate in and cooperate with any promotional activity and/or publicity relating to the Contest as the Sponsor shall reasonably request from time to time.</p>
    
    <h3>Release of Liability</h3> 
    <p>By participating, you release the Sponsor and its subsidiaries, affiliates, partners, employees, directors, agents, advertising agencies, and all others associated with the development and execution of this Contest, from and against any and all injury, loss or damage caused or claimed to be caused by your participation in the Contest and/or the acceptance, awarding, receipt, use and/or misuse of the prize, and you agree that these entities are in no way responsible for any warranty, representation, or guarantee, expressed or implied, in fact or in law, relating to the Contest and/or the awarding of any prize except as may be expressly set forth in these Official Rules.</p>
    
    <p>You also agree to hold harmless Sponsor, its officers, directors, employees, divisions, affiliates, subsidiaries, and advertising and promotional agencies, from any claim by any third party relating to any rights in the Entry you submitted.</p>
    
    <h3>Representations and Warranties</h3> 
    <p>By entering, you warrant and represent that (a) you are the creator of your Entry and the owner of (and free of any adverse claim by any person, firm, or corporation), or have all necessary licenses to, all intellectual property rights in and to the Entry (exclusive of Mozilla’s intellectual property rights); (b) the Entry is original and the use of the Entry as described in these Rules will not infringe the proprietary rights, including without limitation the intellectual property rights, of any third party; (c) the use of the Entry, as described in these Rules, will be in compliance with any third-party licenses pertaining to the Entry; (d) the Entry is not obscene or libelous, or does not violate any rights of any third party, including but not limited to rights of privacy or publicity; (e) the Entry does not target anyone because of his or her membership in a certain social group, including race, gender, color, religion, belief, sexual orientation, disability, ethnicity, nationality, age, gender identity, or political affiliation, and does not contain a symbolic representation of any group that targets anyone because of his or her membership in a certain social group; (f) you have accurately categorized and described the type and nature of the Entry on the Entry Page; (g) the Entry does not contain any virus, spyware, malware, trap door, worm, or any other device, mechanism or code that is injurious or damaging to software or hardware used in conjunction with the Entry; (h) the Entry and its use as described in these Rules will not violate any federal, provincial, state or local laws or ordinances; (i) no employer or educational or other establishment has any rights in the Entry; (j) the Entry is consistent with these Rules; and (k) you have the right to grant to Sponsor and its designees the license granted below. By entering you agree to be bound by these Official Rules, including all eligibility requirements and all decisions of Sponsor, which are final and binding in all matters relating to the Contest.</p>
    
    <h3>Intellectual Property</h3> 
    <p>Any Entry entered in this Contest shall remain the exclusive property of the entrant. All the elements of your demo are yours (or the authors’). By entering, you are making your code available under an open source license (you choose among several options) as described in the Terms for Demo Contributors.</p>
    
    <h3>Mozilla’s Trademarks</h3>
    <p>The names Mozilla, Firefox, Thunderbird, Bugzilla and XUL, as well as the Mozilla logo, Firefox logo, Thunderbird logo and the red lizard logo are all registered trademarks of the Mozilla Foundation in the U.S. and several other countries. Any use of those or any other Sponsor (or Mozilla Foundation) trademark, trade name or logo must comply with the Mozilla Trademark Policies as posted at http://www.mozilla.org/foundation/trademarks/.</p>
    
    <h3>Disclaimers</h3>
    <p> Sponsor is not responsible for: (i) lost, late, misdirected, damaged, garbled or illegible entries; (ii) error, omission, interruption, deletion, defect, delay in operations or transmission, theft or destruction or unauthorized access to or alterations of entry materials, or for technical, network, telephone equipment, electronic, computer, hardware or software malfunctions of any kind, or inaccurate transmission of or failure to receive entry information by Sponsor on account of technical problems or traffic congestion on the Internet or at any web site or any combination thereof; or (iii) any injury or damage to entrant’s or any other person’s computer related to or resulting from participating in the Contest. Sponsor reserves the right to: (i) permanently disqualify from any Contest it sponsors any person it believes has intentionally violated these official rules; and (ii) suspend, modify or terminate the Contest if Sponsor believes, in its sole discretion, that malfunction, error, disruption or damage is impairing or will impair the administration, security, fairness, or integrity of the Contest. If the Contest is terminated before the scheduled end of the Contest Period, the Sponsor will determine winners from all eligible entries received as of the termination date in a fair and equitable manner as determined by Sponsor in its reasonable discretion. Persons found tampering with or abusing any aspect of the Contest, or whom the Sponsor believes to be causing or attempting or intending to cause any malfunction, error, disruption, or damage will be disqualified. The Sponsor reserves the right to disqualify any unauthorized entries or votes, including, without limitation, any entries or votes made through robotic, automatic, mechanical, programmed or similar multiple-entry, or entry/vote duplication, method and to disqualify any person or entity using such a method or who induces or encourages such activity.</p>
    
    <h3>Disputes</h3> 
    <p>These Official Rules and any disputes relating in any way to the Contest shall be governed exclusively by the laws of the State of California, USA, without regard to principles of conflicts of laws. By participating, you further agree that: (i) any and all disputes, claims, and causes of action arising out of or in connection with the Contest,  or any prizes awarded, shall be resolved individually without resort to any form of class action; (ii) any claims, judgments and awards shall be limited to actual out-of-pocket costs incurred, including costs associated with entering the Contest, but in no event attorney’s fees; and (iii) under no circumstances will any entrant be permitted to obtain any award for, and entrant hereby waives all rights to claim, punitive, incidental or consequential damages and any and all rights to have damages multiplied or otherwise increased and any other damages, other than damages for actual out-of-pocket expenses.</p>
    
    <h3>Winner Names</h3> 
    <p>The name of each monthly winner will be posted on the Dev Derby page for approximately 60-90 days after the selection of the winner for that month.</p>

  </section><!-- /#content-main -->


</div>
</section>
<?php foot(); ?>
