/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

/* parser generated by jison 0.4.13 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
var TeXZilla = (function(){
var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"textOptArg":3,"[":4,"TEXTOPTARG":5,"]":6,"textArg":7,"{":8,"TEXTARG":9,"}":10,"lengthOptArg":11,"lengthArg":12,"attrOptArg":13,"attrArg":14,"tokenContent":15,"arrayAlign":16,"columnAlign":17,"collayout":18,"COLLAYOUT":19,"colalign":20,"COLALIGN":21,"rowalign":22,"ROWALIGN":23,"rowspan":24,"ROWSPAN":25,"colspan":26,"COLSPAN":27,"align":28,"ALIGN":29,"eqrows":30,"EQROWS":31,"eqcols":32,"EQCOLS":33,"rowlines":34,"ROWLINES":35,"collines":36,"COLLINES":37,"frame":38,"FRAME":39,"padding":40,"PADDING":41,"cellopt":42,"celloptList":43,"rowopt":44,"arrayopt":45,"arrayoptList":46,"rowoptList":47,"left":48,"LEFT":49,"OPFS":50,".":51,"right":52,"RIGHT":53,"closedTerm":54,"styledExpression":55,"BIG":56,"BBIG":57,"BIGG":58,"BBIGG":59,"BIGL":60,"BBIGL":61,"BIGGL":62,"BBIGGL":63,"TEXATOP":64,"TEXOVER":65,"TEXCHOOSE":66,"NUM":67,"TEXT":68,"A":69,"F":70,"MI":71,"MN":72,"MO":73,"OP":74,"OPS":75,"OPAS":76,"MS":77,"MTEXT":78,"HIGH_SURROGATE":79,"LOW_SURROGATE":80,"BMP_CHARACTER":81,"OPERATORNAME":82,"MATHOP":83,"MATHBIN":84,"MATHREL":85,"FRAC":86,"ROOT":87,"SQRT":88,"UNDERSET":89,"OVERSET":90,"UNDEROVERSET":91,"XARROW":92,"MATHRLAP":93,"MATHLLAP":94,"MATHCLAP":95,"PHANTOM":96,"TFRAC":97,"BINOM":98,"TBINOM":99,"PMOD":100,"UNDERBRACE":101,"UNDERLINE":102,"OVERBRACE":103,"ACCENT":104,"ACCENTNS":105,"BOXED":106,"SLASH":107,"QUAD":108,"QQUAD":109,"NEGSPACE":110,"NEGMEDSPACE":111,"NEGTHICKSPACE":112,"THINSPACE":113,"MEDSPACE":114,"THICKSPACE":115,"SPACE":116,"MATHRAISEBOX":117,"MATHBB":118,"MATHBF":119,"MATHBIT":120,"MATHSCR":121,"MATHBSCR":122,"MATHSF":123,"MATHFRAK":124,"MATHIT":125,"MATHTT":126,"MATHRM":127,"HREF":128,"STATUSLINE":129,"TOOLTIP":130,"TOGGLE":131,"BTOGGLE":132,"closedTermList":133,"ETOGGLE":134,"TENSOR":135,"subsupList":136,"MULTI":137,"BMATRIX":138,"tableRowList":139,"EMATRIX":140,"BGATHERED":141,"EGATHERED":142,"BPMATRIX":143,"EPMATRIX":144,"BBMATRIX":145,"EBMATRIX":146,"BVMATRIX":147,"EVMATRIX":148,"BBBMATRIX":149,"EBBMATRIX":150,"BVVMATRIX":151,"EVVMATRIX":152,"BSMALLMATRIX":153,"ESMALLMATRIX":154,"BCASES":155,"ECASES":156,"BALIGNED":157,"EALIGNED":158,"BARRAY":159,"EARRAY":160,"SUBSTACK":161,"ARRAY":162,"ARRAYOPTS":163,"compoundTerm":164,"_":165,"^":166,"OPP":167,"OOP":168,"opm":169,"OPM":170,"FM":171,"compoundTermList":172,"subsupTermScript":173,"subsupTerm":174,"textstyle":175,"DISPLAYSTYLE":176,"TEXTSTYLE":177,"TEXTSIZE":178,"SCRIPTSIZE":179,"SCRIPTSCRIPTSIZE":180,"COLOR":181,"BGCOLOR":182,"tableCell":183,"CELLOPTS":184,"tableCellList":185,"COLSEP":186,"tableRow":187,"ROWOPTS":188,"ROWSEP":189,"math":190,"EOF":191,"$accept":0,"$end":1},
terminals_: {2:"error",4:"[",5:"TEXTOPTARG",6:"]",8:"{",9:"TEXTARG",10:"}",19:"COLLAYOUT",21:"COLALIGN",23:"ROWALIGN",25:"ROWSPAN",27:"COLSPAN",29:"ALIGN",31:"EQROWS",33:"EQCOLS",35:"ROWLINES",37:"COLLINES",39:"FRAME",41:"PADDING",49:"LEFT",50:"OPFS",51:".",53:"RIGHT",56:"BIG",57:"BBIG",58:"BIGG",59:"BBIGG",60:"BIGL",61:"BBIGL",62:"BIGGL",63:"BBIGGL",64:"TEXATOP",65:"TEXOVER",66:"TEXCHOOSE",67:"NUM",68:"TEXT",69:"A",70:"F",71:"MI",72:"MN",73:"MO",74:"OP",75:"OPS",76:"OPAS",77:"MS",78:"MTEXT",79:"HIGH_SURROGATE",80:"LOW_SURROGATE",81:"BMP_CHARACTER",82:"OPERATORNAME",83:"MATHOP",84:"MATHBIN",85:"MATHREL",86:"FRAC",87:"ROOT",88:"SQRT",89:"UNDERSET",90:"OVERSET",91:"UNDEROVERSET",92:"XARROW",93:"MATHRLAP",94:"MATHLLAP",95:"MATHCLAP",96:"PHANTOM",97:"TFRAC",98:"BINOM",99:"TBINOM",100:"PMOD",101:"UNDERBRACE",102:"UNDERLINE",103:"OVERBRACE",104:"ACCENT",105:"ACCENTNS",106:"BOXED",107:"SLASH",108:"QUAD",109:"QQUAD",110:"NEGSPACE",111:"NEGMEDSPACE",112:"NEGTHICKSPACE",113:"THINSPACE",114:"MEDSPACE",115:"THICKSPACE",116:"SPACE",117:"MATHRAISEBOX",118:"MATHBB",119:"MATHBF",120:"MATHBIT",121:"MATHSCR",122:"MATHBSCR",123:"MATHSF",124:"MATHFRAK",125:"MATHIT",126:"MATHTT",127:"MATHRM",128:"HREF",129:"STATUSLINE",130:"TOOLTIP",131:"TOGGLE",132:"BTOGGLE",134:"ETOGGLE",135:"TENSOR",137:"MULTI",138:"BMATRIX",140:"EMATRIX",141:"BGATHERED",142:"EGATHERED",143:"BPMATRIX",144:"EPMATRIX",145:"BBMATRIX",146:"EBMATRIX",147:"BVMATRIX",148:"EVMATRIX",149:"BBBMATRIX",150:"EBBMATRIX",151:"BVVMATRIX",152:"EVVMATRIX",153:"BSMALLMATRIX",154:"ESMALLMATRIX",155:"BCASES",156:"ECASES",157:"BALIGNED",158:"EALIGNED",159:"BARRAY",160:"EARRAY",161:"SUBSTACK",162:"ARRAY",163:"ARRAYOPTS",165:"_",166:"^",167:"OPP",168:"OOP",170:"OPM",171:"FM",176:"DISPLAYSTYLE",177:"TEXTSTYLE",178:"TEXTSIZE",179:"SCRIPTSIZE",180:"SCRIPTSCRIPTSIZE",181:"COLOR",182:"BGCOLOR",184:"CELLOPTS",186:"COLSEP",188:"ROWOPTS",189:"ROWSEP",191:"EOF"},
productions_: [0,[3,3],[7,3],[11,3],[12,3],[13,1],[14,1],[15,1],[16,1],[17,1],[18,2],[20,2],[22,2],[24,2],[26,2],[28,2],[30,2],[32,2],[34,2],[36,2],[38,2],[40,2],[42,1],[42,1],[42,1],[42,1],[43,1],[43,2],[44,1],[44,1],[45,1],[45,1],[45,1],[45,1],[45,1],[45,1],[45,1],[45,1],[45,1],[45,1],[46,1],[46,2],[47,1],[47,2],[48,2],[48,2],[52,2],[52,2],[54,2],[54,3],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,3],[54,5],[54,5],[54,5],[54,5],[54,5],[54,5],[54,1],[54,1],[54,1],[54,1],[54,2],[54,2],[54,2],[54,1],[54,1],[54,1],[54,1],[54,1],[54,2],[54,4],[54,2],[54,2],[54,1],[54,2],[54,2],[54,2],[54,2],[54,3],[54,3],[54,2],[54,5],[54,3],[54,3],[54,4],[54,5],[54,2],[54,2],[54,2],[54,2],[54,2],[54,3],[54,3],[54,3],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,1],[54,1],[54,1],[54,1],[54,1],[54,1],[54,1],[54,1],[54,4],[54,5],[54,4],[54,3],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,2],[54,3],[54,3],[54,3],[54,3],[54,3],[54,5],[54,8],[54,7],[54,7],[54,3],[54,3],[54,3],[54,3],[54,3],[54,3],[54,3],[54,3],[54,3],[54,3],[54,5],[54,4],[54,4],[54,4],[54,8],[133,1],[133,2],[164,3],[164,5],[164,4],[164,5],[164,3],[164,3],[164,2],[164,1],[164,5],[164,5],[164,3],[164,3],[164,1],[164,1],[169,1],[169,1],[172,1],[172,2],[173,1],[173,1],[174,4],[174,2],[174,2],[174,3],[136,1],[136,2],[175,1],[175,1],[175,1],[175,1],[175,1],[175,2],[175,2],[55,2],[55,1],[183,0],[183,5],[183,1],[185,1],[185,3],[187,5],[187,1],[139,1],[139,3],[190,2],[190,1]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:
    /* Unescape \] and \\. */
    this.$ = $$[$0-1].replace(/\\[\\\]]/g, function(match) { return match.slice(1); });
    /* Escape some XML characters. */
    this.$ = escapeText(this.$);
  
break;
case 2:
    /* Unescape \} and \\. */
    this.$ = $$[$0-1].replace(/\\[\\\}]/g, function(match) { return match.slice(1); });
    /* Escape some XML characters. */
    this.$ = escapeText(this.$);
  
break;
case 3:
    this.$ = parseLength($$[$0-1]);
  
break;
case 4:
    this.$ = parseLength($$[$0-1]);
  
break;
case 5: this.$ = "\"" + escapeQuote($$[$0]) + "\""; 
break;
case 6: this.$ = "\"" + escapeQuote($$[$0]) + "\""; 
break;
case 7:
    /* The MathML specification indicates that trailing/leading whitespaces
       should be removed and that inner whitespace should be collapsed. Let's
       replace trailing/leading whitespace by no-break space so that people can
       write e.g. \text{ if }. We also collapse internal whitespace here.
       See https://github.com/fred-wang/TeXZilla/issues/25. */
    this.$ = $$[$0].replace(/^\s+|\s+$/g, "\u00A0").replace(/\s+/g, " ");
  
break;
case 8:
    $$[$0] = $$[$0].trim();
    if ($$[$0] === "t") {
      this.$ = "axis 1";
    } else if ($$[$0] === "c") {
      this.$ = "center";
    } else if ($$[$0] === "b") {
      this.$ = "axis -1";
    } else {
      throw "Unknown array alignment";
    }
  
break;
case 9:
    this.$ = "";
    $$[$0] = $$[$0].replace(/\s+/g, "");;
    for (var i = 0; i < $$[$0].length; i++) {
      if ($$[$0][i] === "c") {
        this.$ += " center";
      } else if ($$[$0][i] === "l") {
        this.$ += " left";
      } else if ($$[$0][i] === "r") {
        this.$ += " right";
      }
    }
    if (this.$.length) {
        this.$ = this.$.slice(1);
    } else {
        throw "Invalid column alignments";
    }
  
break;
case 10: this.$ = "columnalign=" + $$[$0]; 
break;
case 11: this.$ = "columnalign=" + $$[$0]; 
break;
case 12: this.$ = "rowalign=" + $$[$0]; 
break;
case 13: this.$ = "rowspan=" + $$[$0]; 
break;
case 14: this.$ = "colspan=" + $$[$0]; 
break;
case 15: this.$ = "align=" + $$[$0]; 
break;
case 16: this.$ = "equalrows=" + $$[$0]; 
break;
case 17: this.$ = "equalcolumns=" + $$[$0]; 
break;
case 18: this.$ = "rowlines=" + $$[$0]; 
break;
case 19: this.$ = "columnlines=" + $$[$0]; 
break;
case 20: this.$ = "frame=" + $$[$0]; 
break;
case 21: this.$ = "rowspacing=" + $$[$0] + " columnspacing=" + $$[$0]; 
break;
case 22: this.$ = $$[$0]; 
break;
case 23: this.$ = $$[$0]; 
break;
case 24: this.$ = $$[$0]; 
break;
case 25: this.$ = $$[$0]; 
break;
case 26: this.$ = $$[$0]; 
break;
case 27: this.$ = $$[$0-1] + " " + $$[$0]; 
break;
case 28: this.$ = $$[$0]; 
break;
case 29: this.$ = $$[$0]; 
break;
case 30: this.$ = $$[$0]; 
break;
case 31: this.$ = $$[$0]; 
break;
case 32: this.$ = $$[$0]; 
break;
case 33: this.$ = $$[$0]; 
break;
case 34: this.$ = $$[$0]; 
break;
case 35: this.$ = $$[$0]; 
break;
case 36: this.$ = $$[$0]; 
break;
case 37: this.$ = $$[$0]; 
break;
case 38: this.$ = $$[$0]; 
break;
case 39: this.$ = $$[$0]; 
break;
case 40: this.$ = $$[$0]; 
break;
case 41: this.$ = $$[$0-1] + " " + $$[$0]; 
break;
case 42: this.$ = $$[$0] 
break;
case 43: this.$ = $$[$0-1] + " " + $$[$0]; 
break;
case 44:
    this.$ = newMo($$[$0]);
  
break;
case 45:
    this.$ = "";
  
break;
case 46:
    this.$ = newMo($$[$0]);
  
break;
case 47:
    this.$ = "";
  
break;
case 48: this.$ = "<mrow/>"; 
break;
case 49: this.$ = newMrow($$[$0-1]); 
break;
case 50:
    this.$ = newTag("mo", $$[$0], "maxsize=\"1.2em\" minsize=\"1.2em\"");
  
break;
case 51:
    this.$ = newTag("mo", $$[$0], "maxsize=\"1.8em\" minsize=\"1.8em\"");
  
break;
case 52:
    this.$ = newTag("mo", $$[$0], "maxsize=\"2.4em\" minsize=\"2.4em\"");
  
break;
case 53:
    this.$ = newTag("mo", $$[$0], "maxsize=\"3em\" minsize=\"3em\"");
  
break;
case 54:
    this.$ = newTag("mo", $$[$0], "maxsize=\"1.2em\" minsize=\"1.2em\"");
  
break;
case 55:
    this.$ = newTag("mo", $$[$0], "maxsize=\"1.8em\" minsize=\"1.8em\"");
  
break;
case 56:
    this.$ = newTag("mo", $$[$0], "maxsize=\"2.4em\" minsize=\"2.4em\"");
  
break;
case 57:
    this.$ = newTag("mo", $$[$0], "maxsize=\"3em\" minsize=\"3em\"");
  
break;
case 58:
    this.$ = newTag("mrow", $$[$0-2] + newMrow($$[$0-1]) + $$[$0]);
  
break;
case 59:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]), "linethickness=\"0\"");
  
break;
case 60:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]), "linethickness=\"0\"");
    this.$ = newTag("mrow", $$[$0-4] + this.$ + $$[$0-2]);
  
break;
case 61:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]));
  
break;
case 62:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]));
    this.$ = newTag("mrow", $$[$0-4] + this.$ + $$[$0-2]);
  
break;
case 63:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]),
                "linethickness=\"0\"");
    this.$ = newTag("mrow", newMo("(") + this.$ + newMo(")"));
  
break;
case 64:
    this.$ = newTag("mfrac", newMrow($$[$0-3]) + newMrow($$[$0-1]),
                "linethickness=\"0\"");
    this.$ = newTag("mrow", $$[$0-4] + this.$ + $$[$0-2]);
    this.$ = newTag("mrow", newMo("(") + this.$ + newMo(")"));
  
break;
case 65: this.$ = newTag("mn", $$[$0]); 
break;
case 66: this.$ = newTag("mtext", $$[$0]); 
break;
case 67: this.$ = newTag("mi", $$[$0]); 
break;
case 68: this.$ = newMo($$[$0], "0em", "0em"); 
break;
case 69: this.$ = newTag("mi", $$[$0]); 
break;
case 70: this.$ = newTag("mn", $$[$0]); 
break;
case 71: this.$ = newMo($$[$0]); 
break;
case 72: this.$ = newMo($$[$0]); 
break;
case 73: this.$ = newMo($$[$0]); 
break;
case 74: this.$ = newTag("mo", $$[$0], "stretchy=\"false\""); 
break;
case 75: this.$ = newTag("mo", $$[$0], "stretchy=\"false\""); 
break;
case 76: this.$ = newTag("mo", $$[$0], "stretchy=\"false\""); 
break;
case 77: this.$ = newTag("ms", $$[$0]); 
break;
case 78:
     this.$ = newTag("ms", $$[$0], "lquote=" + $$[$0-2] + " rquote=" + $$[$0-1]);
  
break;
case 79: this.$ = newTag("mtext", $$[$0]); 
break;
case 80: this.$ = newTag("mtext", $$[$0-1] + $$[$0]); 
break;
case 81: this.$ = newTag("mtext", $$[$0]); 
break;
case 82:
    this.$ = newMo($$[$0], "0em", "thinmathspace");
  
break;
case 83:
    this.$ = newMo($$[$0], "thinmathspace", "thinmathspace");
  
break;
case 84:
    this.$ = newMo($$[$0], "mediummathspace", "mediummathspace");
  
break;
case 85:
    this.$ = newMo($$[$0], "thickmathspace", "thickmathspace");
  
break;
case 86: this.$ = newTag("mfrac", $$[$0-1] + $$[$0]); 
break;
case 87: this.$ = newTag("mroot", $$[$0] + $$[$0-1]); 
break;
case 88: this.$ = newTag("msqrt", $$[$0]); 
break;
case 89:
    this.$ = newTag("mroot", $$[$0] + newMrow($$[$0-2]));
  
break;
case 90: this.$ = newTag("munder", $$[$0] + $$[$0-1]); 
break;
case 91: this.$ = newTag("mover", $$[$0] + $$[$0-1]); 
break;
case 92:
    this.$ = newTag("munderover", $$[$0] + $$[$0-2] + $$[$0-1]); 
break;
case 93:
    this.$ = ($$[$0] === "<mrow/>" ?
          newTag("munder", newMo($$[$0-4]) + newMrow($$[$0-2])) :
          newTag("munderover", newMo($$[$0-4]) + newMrow($$[$0-2]) + $$[$0]));
  
break;
case 94:
    this.$ = newTag("mover", newMo($$[$0-1]) + $$[$0]);
  
break;
case 95: this.$ = newTag("mpadded", $$[$0], "width=\"0em\""); 
break;
case 96:
    this.$ = newTag("mpadded", $$[$0], "width=\"0em\" lspace=\"-100%width\"");
  
break;
case 97:
    this.$ = newTag("mpadded", $$[$0], "width=\"0em\" lspace=\"-50%width\"");
  
break;
case 98: this.$ = newTag("mphantom", $$[$0]); 
break;
case 99:
    this.$ = newTag("mfrac", $$[$0-1] + $$[$0]);
    this.$ = newTag("mstyle", this.$, "displaystyle=\"false\"");
  
break;
case 100:
    this.$ = newTag("mfrac", $$[$0-1] + $$[$0], "linethickness=\"0\"");
    this.$ = newTag("mrow", newMo("(") + this.$ + newMo(")"));
  
break;
case 101:
    this.$ = newTag("mfrac", $$[$0-1] + $$[$0], "linethickness=\"0\"");
    this.$ = newTag("mstyle", this.$, "displaystyle=\"false\"");
    this.$ = newTag("mrow", newMo("(") + this.$ + newMo(")"));
  
break;
case 102:
    this.$ = "<mrow><mo lspace=\"mediummathspace\">(</mo><mo rspace=\"thinmathspace\">mod</mo>" + $$[$0] + "<mo rspace=\"mediummathspace\">)</mo></mrow>";
  
break;
case 103: this.$ = newTag("munder", $$[$0] + newMo("\u23DF")); 
break;
case 104: this.$ = newTag("munder", $$[$0] + newMo("_")); 
break;
case 105: this.$ = newTag("mover", $$[$0] + newMo("\u23DE")); 
break;
case 106:
    this.$ = newTag("mover", $$[$0] + newMo($$[$0-1]));
  
break;
case 107:
    this.$ = newTag("mover", $$[$0] + newTag("mo", $$[$0-1], "stretchy=\"false\""));
  
break;
case 108: this.$ = newTag("menclose", $$[$0], "notation=\"box\""); 
break;
case 109:
    this.$ = newTag("menclose", $$[$0], "notation=\"updiagonalstrike\"");
  
break;
case 110: this.$ = "<mspace width=\"1em\"/>"; 
break;
case 111: this.$ = "<mspace width=\"2em\"/>"; 
break;
case 112: this.$ = "<mspace width=\"negativethinmathspace\"/>"; 
break;
case 113: this.$ = "<mspace width=\"negativemediummathspace\"/>"; 
break;
case 114: this.$ = "<mspace width=\"negativethickmathspace\"/>"; 
break;
case 115: this.$ = "<mspace width=\"thinmathspace\"/>"; 
break;
case 116: this.$ = "<mspace width=\"mediummathspace\"/>"; 
break;
case 117: this.$ = "<mspace width=\"thickmathspace\"/>"; 
break;
case 118:
    this.$ = "<mspace height=\"." + $$[$0-2] + "ex\" depth=\"." + $$[$0-1] + "ex\" " +
                  "width=\"." + $$[$0] + "em\"/>";
  
break;
case 119:
    this.$ = newTag("mpadded", $$[$0],
                "voffset=\"" + $$[$0-3].l + $$[$0-3].u + "\" " +
                "height=\"" + $$[$0-2].l + $$[$0-2].u + "\" " +
                "depth=\"" + $$[$0-1].l + $$[$0-1].u + "\"");
  
break;
case 120:
    this.$ = newTag("mpadded", $$[$0],
                "voffset=\"" + $$[$0-2].l + $$[$0-2].u + "\" " +
                "height=\"" + $$[$0-1].l + $$[$0-1].u + "\" depth=\"" +
                ($$[$0-2].l < 0 ? "+" + (-$$[$0-2].l) + $$[$0-2].u : "depth") + "\"");
  
break;
case 121:
    this.$ = newTag("mpadded", $$[$0],
                "voffset=\"" + $$[$0-1].l + $$[$0-1].u + "\" " +
                ($$[$0-1].l >= 0 ? "height=\"+" + $$[$0-1].l + $$[$0-1].u + "\"" :
                 "height=\"0pt\" depth=\"+" + (-$$[$0-1].l) + $$[$0-1].u + "\""));
  
break;
case 122:
    this.$ = newTag("mstyle", $$[$0], "mathvariant=\"double-struck\"");
  
break;
case 123: this.$ = newTag("mstyle", $$[$0], "mathvariant=\"bold\""); 
break;
case 124: this.$ = newTag("mstyle", $$[$0],
                                     "mathvariant=\"bold-italic\""); 
break;
case 125: this.$ = newTag("mstyle", $$[$0], "mathvariant=\"script\""); 
break;
case 126:
    this.$ = newTag("mstyle", $$[$0], "mathvariant=\"bold-script\"");
  
break;
case 127:
    this.$ = newTag("mstyle", $$[$0], "mathvariant=\"sans-serif\"");
  
break;
case 128:
    this.$ = newTag("mstyle", $$[$0], "mathvariant=\"fraktur\"");
  
break;
case 129: this.$ = newTag("mstyle", $$[$0], "mathvariant=\"italic\""); 
break;
case 130: this.$ = newTag("mstyle", $$[$0], "mathvariant=\"monospace\""); 
break;
case 131: this.$ = newTag("mstyle", $$[$0], "mathvariant=\"normal\""); 
break;
case 132:
    this.$ = newTag("mrow", $$[$0], "href=" + $$[$0-1]);
  
break;
case 133:
    this.$ = newTag("maction",
                $$[$0] + newTag("mtext", $$[$0-1]), "actiontype=\"statusline\"");
  
break;
case 134:
    this.$ = newTag("maction",
                $$[$0] + newTag("mtext", $$[$0-1]), "actiontype=\"tooltip\"");
  
break;
case 135:
    /* Backward compatibility with itex2MML */
    this.$ = newTag("maction", $$[$0-1] + $$[$0], "actiontype=\"toggle\" selection=\"2\"");
  
break;
case 136:
    this.$ = newTag("maction", $$[$0-1], "actiontype=\"toggle\"");
  
break;
case 137:
    this.$ = newTag("mmultiscripts", $$[$0-3] + $$[$0-1]);
  
break;
case 138:
    this.$ = newTag("mmultiscripts", $$[$0-3] + $$[$0-1] + "<mprescripts/>" + $$[$0-5]);
  
break;
case 139:
    this.$ = newTag("mmultiscripts", $$[$0-2] + "<mprescripts/>" + $$[$0-4]);
  
break;
case 140:
    this.$ = newTag("mmultiscripts", $$[$0-3] + $$[$0-1]);
  
break;
case 141:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
  
break;
case 142:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"1.0ex\"");
  
break;
case 143:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mrow", newMo("(") + this.$ + newMo(")"));
  
break;
case 144:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mrow", newMo("[") + this.$ + newMo("]"));
  
break;
case 145:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mrow", newMo("|") + this.$ + newMo("|"));
  
break;
case 146:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mrow", newMo("{") + this.$ + newMo("}"));
  
break;
case 147:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mrow", newMo("\u2016") + this.$ + newMo("\u2016"));
  
break;
case 148:
    this.$ = newTag("mtable", $$[$0-1], "rowspacing=\"0.5ex\"");
    this.$ = newTag("mstyle", this.$, "scriptlevel=\"2\"");
  
break;
case 149:
    this.$ = newTag("mtable", $$[$0-1], "columnalign=\"left left\"");
    this.$ = newTag("mrow", newMo("{") + this.$);
  
break;
case 150:
    this.$ = newTag("mtable", $$[$0-1], "columnalign=\"right left right left right left right left right left\" columnspacing=\"0em\"");
  
break;
case 151:
    this.$ = newTag("mtable", $$[$0-1],
                "rowspacing=\"0.5ex\" " +
                "align=\"" + $$[$0-3] + "\" " +
                "columnalign=\"" + $$[$0-2] + "\"");
  
break;
case 152:
    this.$ = newTag("mtable", $$[$0-1],
                "rowspacing=\"0.5ex\" " +
                "columnalign=\"" + $$[$0-2] + "\"");
  
break;
case 153:
    this.$ = newTag("mtable", $$[$0-1], "columnalign=\"center\" rowspacing=\"0.5ex\"");
  
break;
case 154:
    this.$ = newTag("mtable", $$[$0-1]);
  
break;
case 155:
    this.$ = newTag("mtable", $$[$0-1], $$[$0-3]);
  
break;
case 156:
    this.$ = $$[$0];
  
break;
case 157:
    this.$ = $$[$0-1] + $$[$0];
  
break;
case 158:
    this.$ = newTag("mmultiscripts", $$[$0-1] + $$[$0]);
  
break;
case 159:
    this.$ = newScript(false, $$[$0-4], $$[$0-2], $$[$0]);
  
break;
case 160:
    this.$ = newScript(false, $$[$0-3], $$[$0-1], newMo($$[$0]));
  
break;
case 161:
    this.$ = newScript(false, $$[$0-4], $$[$0], $$[$0-2]);
  
break;
case 162:
    this.$ = newScript(false, $$[$0-2], $$[$0], null);
  
break;
case 163:
    this.$ = newScript(false, $$[$0-2], null, $$[$0]);
  
break;
case 164:
    this.$ = newScript(false, $$[$0-1], null, newMo($$[$0]));
  
break;
case 165: this.$ = $$[$0]; 
break;
case 166:
    this.$ = newScript(true, $$[$0-4], $$[$0-2], $$[$0]);
  
break;
case 167:
    this.$ = newScript(true, $$[$0-4], $$[$0], $$[$0-2]);
  
break;
case 168:
    this.$ = newScript(true, $$[$0-2], $$[$0], null);
  
break;
case 169:
    this.$ = newScript(true, $$[$0-2], null, $$[$0]);
  
break;
case 170: this.$ = $$[$0]; 
break;
case 171: this.$ = newMo($$[$0]); 
break;
case 172: this.$ = newMo($$[$0]); 
break;
case 173: this.$ = newMo($$[$0], "0em", "0em"); 
break;
case 174: this.$ = [$$[$0]]; 
break;
case 175: $$[$0-1].push($$[$0]); this.$ = $$[$0-1]; 
break;
case 176: this.$ = $$[$0]; 
break;
case 177: this.$ = $$[$0]; 
break;
case 178: this.$ = $$[$0-2] + $$[$0]; 
break;
case 179: this.$ = $$[$0] + "<none/>"; 
break;
case 180: this.$ = "<none/>" + $$[$0]; 
break;
case 181: this.$ = "<none/>" + $$[$0]; 
break;
case 182: this.$ = $$[$0]; 
break;
case 183: this.$ = $$[$0-1] + $$[$0] 
break;
case 184: this.$ = "displaystyle=\"true\""; 
break;
case 185: this.$ = "displaystyle=\"false\""; 
break;
case 186: this.$ = "scriptlevel=\"0\""; 
break;
case 187: this.$ = "scriptlevel=\"1\""; 
break;
case 188: this.$ = "scriptlevel=\"2\""; 
break;
case 189: this.$ = "mathcolor=" + $$[$0]; 
break;
case 190: this.$ = "mathbackground=" + $$[$0]; 
break;
case 191: this.$ = [newMrow($$[$0], "mstyle", $$[$0-1])]; 
break;
case 192: this.$ = $$[$0]; 
break;
case 193: this.$ = newTag("mtd", ""); 
break;
case 194:
    this.$ = newMrow($$[$0], "mtd", $$[$0-2]);
  
break;
case 195: this.$ = newMrow($$[$0], "mtd"); 
break;
case 196: this.$ = $$[$0]; 
break;
case 197: this.$ = $$[$0-2] + $$[$0]; 
break;
case 198:
    this.$ = this.$ = newTag("mtr", $$[$0], $$[$0-2]);
  
break;
case 199: this.$ = newTag("mtr", $$[$0]); 
break;
case 200: this.$ = $$[$0]; 
break;
case 201: this.$ = $$[$0-2] + $$[$0] 
break;
case 202:
    this.$ = newMrow($$[$0-1]);
    return this.$;
  
break;
case 203:
    this.$ = "<mrow/>";
    return this.$;
  
break;
}
},
table: [{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:2,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],190:1,191:[1,3]},{1:[3]},{191:[1,112]},{1:[2,203]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:113,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{6:[2,192],8:[1,18],10:[2,192],48:27,49:[1,111],50:[1,39],51:[1,35],53:[2,192],54:15,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],64:[2,192],65:[2,192],66:[2,192],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],140:[2,192],141:[1,97],142:[2,192],143:[1,98],144:[2,192],145:[1,99],146:[2,192],147:[1,100],148:[2,192],149:[1,101],150:[2,192],151:[1,102],152:[2,192],153:[1,103],154:[2,192],155:[1,104],156:[2,192],157:[1,105],158:[2,192],159:[1,106],160:[2,192],161:[1,107],162:[1,108],164:114,167:[1,17],169:16,170:[1,109],171:[1,110],186:[2,192],189:[2,192],191:[2,192]},{8:[2,184],49:[2,184],50:[2,184],51:[2,184],56:[2,184],57:[2,184],58:[2,184],59:[2,184],60:[2,184],61:[2,184],62:[2,184],63:[2,184],67:[2,184],68:[2,184],69:[2,184],70:[2,184],71:[2,184],72:[2,184],73:[2,184],74:[2,184],75:[2,184],76:[2,184],77:[2,184],78:[2,184],79:[2,184],81:[2,184],82:[2,184],83:[2,184],84:[2,184],85:[2,184],86:[2,184],87:[2,184],88:[2,184],89:[2,184],90:[2,184],91:[2,184],92:[2,184],93:[2,184],94:[2,184],95:[2,184],96:[2,184],97:[2,184],98:[2,184],99:[2,184],100:[2,184],101:[2,184],102:[2,184],103:[2,184],104:[2,184],105:[2,184],106:[2,184],107:[2,184],108:[2,184],109:[2,184],110:[2,184],111:[2,184],112:[2,184],113:[2,184],114:[2,184],115:[2,184],116:[2,184],117:[2,184],118:[2,184],119:[2,184],120:[2,184],121:[2,184],122:[2,184],123:[2,184],124:[2,184],125:[2,184],126:[2,184],127:[2,184],128:[2,184],129:[2,184],130:[2,184],131:[2,184],132:[2,184],135:[2,184],137:[2,184],138:[2,184],141:[2,184],143:[2,184],145:[2,184],147:[2,184],149:[2,184],151:[2,184],153:[2,184],155:[2,184],157:[2,184],159:[2,184],161:[2,184],162:[2,184],167:[2,184],170:[2,184],171:[2,184],176:[2,184],177:[2,184],178:[2,184],179:[2,184],180:[2,184],181:[2,184],182:[2,184]},{8:[2,185],49:[2,185],50:[2,185],51:[2,185],56:[2,185],57:[2,185],58:[2,185],59:[2,185],60:[2,185],61:[2,185],62:[2,185],63:[2,185],67:[2,185],68:[2,185],69:[2,185],70:[2,185],71:[2,185],72:[2,185],73:[2,185],74:[2,185],75:[2,185],76:[2,185],77:[2,185],78:[2,185],79:[2,185],81:[2,185],82:[2,185],83:[2,185],84:[2,185],85:[2,185],86:[2,185],87:[2,185],88:[2,185],89:[2,185],90:[2,185],91:[2,185],92:[2,185],93:[2,185],94:[2,185],95:[2,185],96:[2,185],97:[2,185],98:[2,185],99:[2,185],100:[2,185],101:[2,185],102:[2,185],103:[2,185],104:[2,185],105:[2,185],106:[2,185],107:[2,185],108:[2,185],109:[2,185],110:[2,185],111:[2,185],112:[2,185],113:[2,185],114:[2,185],115:[2,185],116:[2,185],117:[2,185],118:[2,185],119:[2,185],120:[2,185],121:[2,185],122:[2,185],123:[2,185],124:[2,185],125:[2,185],126:[2,185],127:[2,185],128:[2,185],129:[2,185],130:[2,185],131:[2,185],132:[2,185],135:[2,185],137:[2,185],138:[2,185],141:[2,185],143:[2,185],145:[2,185],147:[2,185],149:[2,185],151:[2,185],153:[2,185],155:[2,185],157:[2,185],159:[2,185],161:[2,185],162:[2,185],167:[2,185],170:[2,185],171:[2,185],176:[2,185],177:[2,185],178:[2,185],179:[2,185],180:[2,185],181:[2,185],182:[2,185]},{8:[2,186],49:[2,186],50:[2,186],51:[2,186],56:[2,186],57:[2,186],58:[2,186],59:[2,186],60:[2,186],61:[2,186],62:[2,186],63:[2,186],67:[2,186],68:[2,186],69:[2,186],70:[2,186],71:[2,186],72:[2,186],73:[2,186],74:[2,186],75:[2,186],76:[2,186],77:[2,186],78:[2,186],79:[2,186],81:[2,186],82:[2,186],83:[2,186],84:[2,186],85:[2,186],86:[2,186],87:[2,186],88:[2,186],89:[2,186],90:[2,186],91:[2,186],92:[2,186],93:[2,186],94:[2,186],95:[2,186],96:[2,186],97:[2,186],98:[2,186],99:[2,186],100:[2,186],101:[2,186],102:[2,186],103:[2,186],104:[2,186],105:[2,186],106:[2,186],107:[2,186],108:[2,186],109:[2,186],110:[2,186],111:[2,186],112:[2,186],113:[2,186],114:[2,186],115:[2,186],116:[2,186],117:[2,186],118:[2,186],119:[2,186],120:[2,186],121:[2,186],122:[2,186],123:[2,186],124:[2,186],125:[2,186],126:[2,186],127:[2,186],128:[2,186],129:[2,186],130:[2,186],131:[2,186],132:[2,186],135:[2,186],137:[2,186],138:[2,186],141:[2,186],143:[2,186],145:[2,186],147:[2,186],149:[2,186],151:[2,186],153:[2,186],155:[2,186],157:[2,186],159:[2,186],161:[2,186],162:[2,186],167:[2,186],170:[2,186],171:[2,186],176:[2,186],177:[2,186],178:[2,186],179:[2,186],180:[2,186],181:[2,186],182:[2,186]},{8:[2,187],49:[2,187],50:[2,187],51:[2,187],56:[2,187],57:[2,187],58:[2,187],59:[2,187],60:[2,187],61:[2,187],62:[2,187],63:[2,187],67:[2,187],68:[2,187],69:[2,187],70:[2,187],71:[2,187],72:[2,187],73:[2,187],74:[2,187],75:[2,187],76:[2,187],77:[2,187],78:[2,187],79:[2,187],81:[2,187],82:[2,187],83:[2,187],84:[2,187],85:[2,187],86:[2,187],87:[2,187],88:[2,187],89:[2,187],90:[2,187],91:[2,187],92:[2,187],93:[2,187],94:[2,187],95:[2,187],96:[2,187],97:[2,187],98:[2,187],99:[2,187],100:[2,187],101:[2,187],102:[2,187],103:[2,187],104:[2,187],105:[2,187],106:[2,187],107:[2,187],108:[2,187],109:[2,187],110:[2,187],111:[2,187],112:[2,187],113:[2,187],114:[2,187],115:[2,187],116:[2,187],117:[2,187],118:[2,187],119:[2,187],120:[2,187],121:[2,187],122:[2,187],123:[2,187],124:[2,187],125:[2,187],126:[2,187],127:[2,187],128:[2,187],129:[2,187],130:[2,187],131:[2,187],132:[2,187],135:[2,187],137:[2,187],138:[2,187],141:[2,187],143:[2,187],145:[2,187],147:[2,187],149:[2,187],151:[2,187],153:[2,187],155:[2,187],157:[2,187],159:[2,187],161:[2,187],162:[2,187],167:[2,187],170:[2,187],171:[2,187],176:[2,187],177:[2,187],178:[2,187],179:[2,187],180:[2,187],181:[2,187],182:[2,187]},{8:[2,188],49:[2,188],50:[2,188],51:[2,188],56:[2,188],57:[2,188],58:[2,188],59:[2,188],60:[2,188],61:[2,188],62:[2,188],63:[2,188],67:[2,188],68:[2,188],69:[2,188],70:[2,188],71:[2,188],72:[2,188],73:[2,188],74:[2,188],75:[2,188],76:[2,188],77:[2,188],78:[2,188],79:[2,188],81:[2,188],82:[2,188],83:[2,188],84:[2,188],85:[2,188],86:[2,188],87:[2,188],88:[2,188],89:[2,188],90:[2,188],91:[2,188],92:[2,188],93:[2,188],94:[2,188],95:[2,188],96:[2,188],97:[2,188],98:[2,188],99:[2,188],100:[2,188],101:[2,188],102:[2,188],103:[2,188],104:[2,188],105:[2,188],106:[2,188],107:[2,188],108:[2,188],109:[2,188],110:[2,188],111:[2,188],112:[2,188],113:[2,188],114:[2,188],115:[2,188],116:[2,188],117:[2,188],118:[2,188],119:[2,188],120:[2,188],121:[2,188],122:[2,188],123:[2,188],124:[2,188],125:[2,188],126:[2,188],127:[2,188],128:[2,188],129:[2,188],130:[2,188],131:[2,188],132:[2,188],135:[2,188],137:[2,188],138:[2,188],141:[2,188],143:[2,188],145:[2,188],147:[2,188],149:[2,188],151:[2,188],153:[2,188],155:[2,188],157:[2,188],159:[2,188],161:[2,188],162:[2,188],167:[2,188],170:[2,188],171:[2,188],176:[2,188],177:[2,188],178:[2,188],179:[2,188],180:[2,188],181:[2,188],182:[2,188]},{7:116,8:[1,117],14:115},{7:116,8:[1,117],14:118},{6:[2,174],8:[2,174],10:[2,174],49:[2,174],50:[2,174],51:[2,174],53:[2,174],56:[2,174],57:[2,174],58:[2,174],59:[2,174],60:[2,174],61:[2,174],62:[2,174],63:[2,174],64:[2,174],65:[2,174],66:[2,174],67:[2,174],68:[2,174],69:[2,174],70:[2,174],71:[2,174],72:[2,174],73:[2,174],74:[2,174],75:[2,174],76:[2,174],77:[2,174],78:[2,174],79:[2,174],81:[2,174],82:[2,174],83:[2,174],84:[2,174],85:[2,174],86:[2,174],87:[2,174],88:[2,174],89:[2,174],90:[2,174],91:[2,174],92:[2,174],93:[2,174],94:[2,174],95:[2,174],96:[2,174],97:[2,174],98:[2,174],99:[2,174],100:[2,174],101:[2,174],102:[2,174],103:[2,174],104:[2,174],105:[2,174],106:[2,174],107:[2,174],108:[2,174],109:[2,174],110:[2,174],111:[2,174],112:[2,174],113:[2,174],114:[2,174],115:[2,174],116:[2,174],117:[2,174],118:[2,174],119:[2,174],120:[2,174],121:[2,174],122:[2,174],123:[2,174],124:[2,174],125:[2,174],126:[2,174],127:[2,174],128:[2,174],129:[2,174],130:[2,174],131:[2,174],132:[2,174],135:[2,174],137:[2,174],138:[2,174],140:[2,174],141:[2,174],142:[2,174],143:[2,174],144:[2,174],145:[2,174],146:[2,174],147:[2,174],148:[2,174],149:[2,174],150:[2,174],151:[2,174],152:[2,174],153:[2,174],154:[2,174],155:[2,174],156:[2,174],157:[2,174],158:[2,174],159:[2,174],160:[2,174],161:[2,174],162:[2,174],167:[2,174],170:[2,174],171:[2,174],186:[2,174],189:[2,174],191:[2,174]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:119,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,165],8:[2,165],10:[2,165],49:[2,165],50:[2,165],51:[2,165],53:[2,165],56:[2,165],57:[2,165],58:[2,165],59:[2,165],60:[2,165],61:[2,165],62:[2,165],63:[2,165],64:[2,165],65:[2,165],66:[2,165],67:[2,165],68:[2,165],69:[2,165],70:[2,165],71:[2,165],72:[2,165],73:[2,165],74:[2,165],75:[2,165],76:[2,165],77:[2,165],78:[2,165],79:[2,165],81:[2,165],82:[2,165],83:[2,165],84:[2,165],85:[2,165],86:[2,165],87:[2,165],88:[2,165],89:[2,165],90:[2,165],91:[2,165],92:[2,165],93:[2,165],94:[2,165],95:[2,165],96:[2,165],97:[2,165],98:[2,165],99:[2,165],100:[2,165],101:[2,165],102:[2,165],103:[2,165],104:[2,165],105:[2,165],106:[2,165],107:[2,165],108:[2,165],109:[2,165],110:[2,165],111:[2,165],112:[2,165],113:[2,165],114:[2,165],115:[2,165],116:[2,165],117:[2,165],118:[2,165],119:[2,165],120:[2,165],121:[2,165],122:[2,165],123:[2,165],124:[2,165],125:[2,165],126:[2,165],127:[2,165],128:[2,165],129:[2,165],130:[2,165],131:[2,165],132:[2,165],135:[2,165],137:[2,165],138:[2,165],140:[2,165],141:[2,165],142:[2,165],143:[2,165],144:[2,165],145:[2,165],146:[2,165],147:[2,165],148:[2,165],149:[2,165],150:[2,165],151:[2,165],152:[2,165],153:[2,165],154:[2,165],155:[2,165],156:[2,165],157:[2,165],158:[2,165],159:[2,165],160:[2,165],161:[2,165],162:[2,165],165:[1,121],166:[1,122],167:[2,165],168:[1,123],170:[2,165],171:[2,165],186:[2,165],189:[2,165],191:[2,165]},{6:[2,170],8:[2,170],10:[2,170],49:[2,170],50:[2,170],51:[2,170],53:[2,170],56:[2,170],57:[2,170],58:[2,170],59:[2,170],60:[2,170],61:[2,170],62:[2,170],63:[2,170],64:[2,170],65:[2,170],66:[2,170],67:[2,170],68:[2,170],69:[2,170],70:[2,170],71:[2,170],72:[2,170],73:[2,170],74:[2,170],75:[2,170],76:[2,170],77:[2,170],78:[2,170],79:[2,170],81:[2,170],82:[2,170],83:[2,170],84:[2,170],85:[2,170],86:[2,170],87:[2,170],88:[2,170],89:[2,170],90:[2,170],91:[2,170],92:[2,170],93:[2,170],94:[2,170],95:[2,170],96:[2,170],97:[2,170],98:[2,170],99:[2,170],100:[2,170],101:[2,170],102:[2,170],103:[2,170],104:[2,170],105:[2,170],106:[2,170],107:[2,170],108:[2,170],109:[2,170],110:[2,170],111:[2,170],112:[2,170],113:[2,170],114:[2,170],115:[2,170],116:[2,170],117:[2,170],118:[2,170],119:[2,170],120:[2,170],121:[2,170],122:[2,170],123:[2,170],124:[2,170],125:[2,170],126:[2,170],127:[2,170],128:[2,170],129:[2,170],130:[2,170],131:[2,170],132:[2,170],135:[2,170],137:[2,170],138:[2,170],140:[2,170],141:[2,170],142:[2,170],143:[2,170],144:[2,170],145:[2,170],146:[2,170],147:[2,170],148:[2,170],149:[2,170],150:[2,170],151:[2,170],152:[2,170],153:[2,170],154:[2,170],155:[2,170],156:[2,170],157:[2,170],158:[2,170],159:[2,170],160:[2,170],161:[2,170],162:[2,170],165:[1,124],166:[1,125],167:[2,170],170:[2,170],171:[2,170],186:[2,170],189:[2,170],191:[2,170]},{6:[2,171],8:[2,171],10:[2,171],49:[2,171],50:[2,171],51:[2,171],53:[2,171],56:[2,171],57:[2,171],58:[2,171],59:[2,171],60:[2,171],61:[2,171],62:[2,171],63:[2,171],64:[2,171],65:[2,171],66:[2,171],67:[2,171],68:[2,171],69:[2,171],70:[2,171],71:[2,171],72:[2,171],73:[2,171],74:[2,171],75:[2,171],76:[2,171],77:[2,171],78:[2,171],79:[2,171],81:[2,171],82:[2,171],83:[2,171],84:[2,171],85:[2,171],86:[2,171],87:[2,171],88:[2,171],89:[2,171],90:[2,171],91:[2,171],92:[2,171],93:[2,171],94:[2,171],95:[2,171],96:[2,171],97:[2,171],98:[2,171],99:[2,171],100:[2,171],101:[2,171],102:[2,171],103:[2,171],104:[2,171],105:[2,171],106:[2,171],107:[2,171],108:[2,171],109:[2,171],110:[2,171],111:[2,171],112:[2,171],113:[2,171],114:[2,171],115:[2,171],116:[2,171],117:[2,171],118:[2,171],119:[2,171],120:[2,171],121:[2,171],122:[2,171],123:[2,171],124:[2,171],125:[2,171],126:[2,171],127:[2,171],128:[2,171],129:[2,171],130:[2,171],131:[2,171],132:[2,171],135:[2,171],137:[2,171],138:[2,171],140:[2,171],141:[2,171],142:[2,171],143:[2,171],144:[2,171],145:[2,171],146:[2,171],147:[2,171],148:[2,171],149:[2,171],150:[2,171],151:[2,171],152:[2,171],153:[2,171],154:[2,171],155:[2,171],156:[2,171],157:[2,171],158:[2,171],159:[2,171],160:[2,171],161:[2,171],162:[2,171],167:[2,171],170:[2,171],171:[2,171],186:[2,171],189:[2,171],191:[2,171]},{8:[1,18],10:[1,126],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:127,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{50:[1,128]},{50:[1,129]},{50:[1,130]},{50:[1,131]},{50:[1,132]},{50:[1,133]},{50:[1,134]},{50:[1,135]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:136,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{6:[2,65],8:[2,65],10:[2,65],49:[2,65],50:[2,65],51:[2,65],53:[2,65],56:[2,65],57:[2,65],58:[2,65],59:[2,65],60:[2,65],61:[2,65],62:[2,65],63:[2,65],64:[2,65],65:[2,65],66:[2,65],67:[2,65],68:[2,65],69:[2,65],70:[2,65],71:[2,65],72:[2,65],73:[2,65],74:[2,65],75:[2,65],76:[2,65],77:[2,65],78:[2,65],79:[2,65],81:[2,65],82:[2,65],83:[2,65],84:[2,65],85:[2,65],86:[2,65],87:[2,65],88:[2,65],89:[2,65],90:[2,65],91:[2,65],92:[2,65],93:[2,65],94:[2,65],95:[2,65],96:[2,65],97:[2,65],98:[2,65],99:[2,65],100:[2,65],101:[2,65],102:[2,65],103:[2,65],104:[2,65],105:[2,65],106:[2,65],107:[2,65],108:[2,65],109:[2,65],110:[2,65],111:[2,65],112:[2,65],113:[2,65],114:[2,65],115:[2,65],116:[2,65],117:[2,65],118:[2,65],119:[2,65],120:[2,65],121:[2,65],122:[2,65],123:[2,65],124:[2,65],125:[2,65],126:[2,65],127:[2,65],128:[2,65],129:[2,65],130:[2,65],131:[2,65],132:[2,65],134:[2,65],135:[2,65],137:[2,65],138:[2,65],140:[2,65],141:[2,65],142:[2,65],143:[2,65],144:[2,65],145:[2,65],146:[2,65],147:[2,65],148:[2,65],149:[2,65],150:[2,65],151:[2,65],152:[2,65],153:[2,65],154:[2,65],155:[2,65],156:[2,65],157:[2,65],158:[2,65],159:[2,65],160:[2,65],161:[2,65],162:[2,65],165:[2,65],166:[2,65],167:[2,65],168:[2,65],170:[2,65],171:[2,65],186:[2,65],189:[2,65],191:[2,65]},{6:[2,66],8:[2,66],10:[2,66],49:[2,66],50:[2,66],51:[2,66],53:[2,66],56:[2,66],57:[2,66],58:[2,66],59:[2,66],60:[2,66],61:[2,66],62:[2,66],63:[2,66],64:[2,66],65:[2,66],66:[2,66],67:[2,66],68:[2,66],69:[2,66],70:[2,66],71:[2,66],72:[2,66],73:[2,66],74:[2,66],75:[2,66],76:[2,66],77:[2,66],78:[2,66],79:[2,66],81:[2,66],82:[2,66],83:[2,66],84:[2,66],85:[2,66],86:[2,66],87:[2,66],88:[2,66],89:[2,66],90:[2,66],91:[2,66],92:[2,66],93:[2,66],94:[2,66],95:[2,66],96:[2,66],97:[2,66],98:[2,66],99:[2,66],100:[2,66],101:[2,66],102:[2,66],103:[2,66],104:[2,66],105:[2,66],106:[2,66],107:[2,66],108:[2,66],109:[2,66],110:[2,66],111:[2,66],112:[2,66],113:[2,66],114:[2,66],115:[2,66],116:[2,66],117:[2,66],118:[2,66],119:[2,66],120:[2,66],121:[2,66],122:[2,66],123:[2,66],124:[2,66],125:[2,66],126:[2,66],127:[2,66],128:[2,66],129:[2,66],130:[2,66],131:[2,66],132:[2,66],134:[2,66],135:[2,66],137:[2,66],138:[2,66],140:[2,66],141:[2,66],142:[2,66],143:[2,66],144:[2,66],145:[2,66],146:[2,66],147:[2,66],148:[2,66],149:[2,66],150:[2,66],151:[2,66],152:[2,66],153:[2,66],154:[2,66],155:[2,66],156:[2,66],157:[2,66],158:[2,66],159:[2,66],160:[2,66],161:[2,66],162:[2,66],165:[2,66],166:[2,66],167:[2,66],168:[2,66],170:[2,66],171:[2,66],186:[2,66],189:[2,66],191:[2,66]},{6:[2,67],8:[2,67],10:[2,67],49:[2,67],50:[2,67],51:[2,67],53:[2,67],56:[2,67],57:[2,67],58:[2,67],59:[2,67],60:[2,67],61:[2,67],62:[2,67],63:[2,67],64:[2,67],65:[2,67],66:[2,67],67:[2,67],68:[2,67],69:[2,67],70:[2,67],71:[2,67],72:[2,67],73:[2,67],74:[2,67],75:[2,67],76:[2,67],77:[2,67],78:[2,67],79:[2,67],81:[2,67],82:[2,67],83:[2,67],84:[2,67],85:[2,67],86:[2,67],87:[2,67],88:[2,67],89:[2,67],90:[2,67],91:[2,67],92:[2,67],93:[2,67],94:[2,67],95:[2,67],96:[2,67],97:[2,67],98:[2,67],99:[2,67],100:[2,67],101:[2,67],102:[2,67],103:[2,67],104:[2,67],105:[2,67],106:[2,67],107:[2,67],108:[2,67],109:[2,67],110:[2,67],111:[2,67],112:[2,67],113:[2,67],114:[2,67],115:[2,67],116:[2,67],117:[2,67],118:[2,67],119:[2,67],120:[2,67],121:[2,67],122:[2,67],123:[2,67],124:[2,67],125:[2,67],126:[2,67],127:[2,67],128:[2,67],129:[2,67],130:[2,67],131:[2,67],132:[2,67],134:[2,67],135:[2,67],137:[2,67],138:[2,67],140:[2,67],141:[2,67],142:[2,67],143:[2,67],144:[2,67],145:[2,67],146:[2,67],147:[2,67],148:[2,67],149:[2,67],150:[2,67],151:[2,67],152:[2,67],153:[2,67],154:[2,67],155:[2,67],156:[2,67],157:[2,67],158:[2,67],159:[2,67],160:[2,67],161:[2,67],162:[2,67],165:[2,67],166:[2,67],167:[2,67],168:[2,67],170:[2,67],171:[2,67],186:[2,67],189:[2,67],191:[2,67]},{6:[2,68],8:[2,68],10:[2,68],49:[2,68],50:[2,68],51:[2,68],53:[2,68],56:[2,68],57:[2,68],58:[2,68],59:[2,68],60:[2,68],61:[2,68],62:[2,68],63:[2,68],64:[2,68],65:[2,68],66:[2,68],67:[2,68],68:[2,68],69:[2,68],70:[2,68],71:[2,68],72:[2,68],73:[2,68],74:[2,68],75:[2,68],76:[2,68],77:[2,68],78:[2,68],79:[2,68],81:[2,68],82:[2,68],83:[2,68],84:[2,68],85:[2,68],86:[2,68],87:[2,68],88:[2,68],89:[2,68],90:[2,68],91:[2,68],92:[2,68],93:[2,68],94:[2,68],95:[2,68],96:[2,68],97:[2,68],98:[2,68],99:[2,68],100:[2,68],101:[2,68],102:[2,68],103:[2,68],104:[2,68],105:[2,68],106:[2,68],107:[2,68],108:[2,68],109:[2,68],110:[2,68],111:[2,68],112:[2,68],113:[2,68],114:[2,68],115:[2,68],116:[2,68],117:[2,68],118:[2,68],119:[2,68],120:[2,68],121:[2,68],122:[2,68],123:[2,68],124:[2,68],125:[2,68],126:[2,68],127:[2,68],128:[2,68],129:[2,68],130:[2,68],131:[2,68],132:[2,68],134:[2,68],135:[2,68],137:[2,68],138:[2,68],140:[2,68],141:[2,68],142:[2,68],143:[2,68],144:[2,68],145:[2,68],146:[2,68],147:[2,68],148:[2,68],149:[2,68],150:[2,68],151:[2,68],152:[2,68],153:[2,68],154:[2,68],155:[2,68],156:[2,68],157:[2,68],158:[2,68],159:[2,68],160:[2,68],161:[2,68],162:[2,68],165:[2,68],166:[2,68],167:[2,68],168:[2,68],170:[2,68],171:[2,68],186:[2,68],189:[2,68],191:[2,68]},{7:138,8:[1,117],15:137},{7:138,8:[1,117],15:139},{7:138,8:[1,117],15:140},{6:[2,72],8:[2,72],10:[2,72],49:[2,72],50:[2,72],51:[2,72],53:[2,72],56:[2,72],57:[2,72],58:[2,72],59:[2,72],60:[2,72],61:[2,72],62:[2,72],63:[2,72],64:[2,72],65:[2,72],66:[2,72],67:[2,72],68:[2,72],69:[2,72],70:[2,72],71:[2,72],72:[2,72],73:[2,72],74:[2,72],75:[2,72],76:[2,72],77:[2,72],78:[2,72],79:[2,72],81:[2,72],82:[2,72],83:[2,72],84:[2,72],85:[2,72],86:[2,72],87:[2,72],88:[2,72],89:[2,72],90:[2,72],91:[2,72],92:[2,72],93:[2,72],94:[2,72],95:[2,72],96:[2,72],97:[2,72],98:[2,72],99:[2,72],100:[2,72],101:[2,72],102:[2,72],103:[2,72],104:[2,72],105:[2,72],106:[2,72],107:[2,72],108:[2,72],109:[2,72],110:[2,72],111:[2,72],112:[2,72],113:[2,72],114:[2,72],115:[2,72],116:[2,72],117:[2,72],118:[2,72],119:[2,72],120:[2,72],121:[2,72],122:[2,72],123:[2,72],124:[2,72],125:[2,72],126:[2,72],127:[2,72],128:[2,72],129:[2,72],130:[2,72],131:[2,72],132:[2,72],134:[2,72],135:[2,72],137:[2,72],138:[2,72],140:[2,72],141:[2,72],142:[2,72],143:[2,72],144:[2,72],145:[2,72],146:[2,72],147:[2,72],148:[2,72],149:[2,72],150:[2,72],151:[2,72],152:[2,72],153:[2,72],154:[2,72],155:[2,72],156:[2,72],157:[2,72],158:[2,72],159:[2,72],160:[2,72],161:[2,72],162:[2,72],165:[2,72],166:[2,72],167:[2,72],168:[2,72],170:[2,72],171:[2,72],186:[2,72],189:[2,72],191:[2,72]},{6:[2,73],8:[2,73],10:[2,73],49:[2,73],50:[2,73],51:[2,73],53:[2,73],56:[2,73],57:[2,73],58:[2,73],59:[2,73],60:[2,73],61:[2,73],62:[2,73],63:[2,73],64:[2,73],65:[2,73],66:[2,73],67:[2,73],68:[2,73],69:[2,73],70:[2,73],71:[2,73],72:[2,73],73:[2,73],74:[2,73],75:[2,73],76:[2,73],77:[2,73],78:[2,73],79:[2,73],81:[2,73],82:[2,73],83:[2,73],84:[2,73],85:[2,73],86:[2,73],87:[2,73],88:[2,73],89:[2,73],90:[2,73],91:[2,73],92:[2,73],93:[2,73],94:[2,73],95:[2,73],96:[2,73],97:[2,73],98:[2,73],99:[2,73],100:[2,73],101:[2,73],102:[2,73],103:[2,73],104:[2,73],105:[2,73],106:[2,73],107:[2,73],108:[2,73],109:[2,73],110:[2,73],111:[2,73],112:[2,73],113:[2,73],114:[2,73],115:[2,73],116:[2,73],117:[2,73],118:[2,73],119:[2,73],120:[2,73],121:[2,73],122:[2,73],123:[2,73],124:[2,73],125:[2,73],126:[2,73],127:[2,73],128:[2,73],129:[2,73],130:[2,73],131:[2,73],132:[2,73],134:[2,73],135:[2,73],137:[2,73],138:[2,73],140:[2,73],141:[2,73],142:[2,73],143:[2,73],144:[2,73],145:[2,73],146:[2,73],147:[2,73],148:[2,73],149:[2,73],150:[2,73],151:[2,73],152:[2,73],153:[2,73],154:[2,73],155:[2,73],156:[2,73],157:[2,73],158:[2,73],159:[2,73],160:[2,73],161:[2,73],162:[2,73],165:[2,73],166:[2,73],167:[2,73],168:[2,73],170:[2,73],171:[2,73],186:[2,73],189:[2,73],191:[2,73]},{6:[2,74],8:[2,74],10:[2,74],49:[2,74],50:[2,74],51:[2,74],53:[2,74],56:[2,74],57:[2,74],58:[2,74],59:[2,74],60:[2,74],61:[2,74],62:[2,74],63:[2,74],64:[2,74],65:[2,74],66:[2,74],67:[2,74],68:[2,74],69:[2,74],70:[2,74],71:[2,74],72:[2,74],73:[2,74],74:[2,74],75:[2,74],76:[2,74],77:[2,74],78:[2,74],79:[2,74],81:[2,74],82:[2,74],83:[2,74],84:[2,74],85:[2,74],86:[2,74],87:[2,74],88:[2,74],89:[2,74],90:[2,74],91:[2,74],92:[2,74],93:[2,74],94:[2,74],95:[2,74],96:[2,74],97:[2,74],98:[2,74],99:[2,74],100:[2,74],101:[2,74],102:[2,74],103:[2,74],104:[2,74],105:[2,74],106:[2,74],107:[2,74],108:[2,74],109:[2,74],110:[2,74],111:[2,74],112:[2,74],113:[2,74],114:[2,74],115:[2,74],116:[2,74],117:[2,74],118:[2,74],119:[2,74],120:[2,74],121:[2,74],122:[2,74],123:[2,74],124:[2,74],125:[2,74],126:[2,74],127:[2,74],128:[2,74],129:[2,74],130:[2,74],131:[2,74],132:[2,74],134:[2,74],135:[2,74],137:[2,74],138:[2,74],140:[2,74],141:[2,74],142:[2,74],143:[2,74],144:[2,74],145:[2,74],146:[2,74],147:[2,74],148:[2,74],149:[2,74],150:[2,74],151:[2,74],152:[2,74],153:[2,74],154:[2,74],155:[2,74],156:[2,74],157:[2,74],158:[2,74],159:[2,74],160:[2,74],161:[2,74],162:[2,74],165:[2,74],166:[2,74],167:[2,74],168:[2,74],170:[2,74],171:[2,74],186:[2,74],189:[2,74],191:[2,74]},{6:[2,75],8:[2,75],10:[2,75],49:[2,75],50:[2,75],51:[2,75],53:[2,75],56:[2,75],57:[2,75],58:[2,75],59:[2,75],60:[2,75],61:[2,75],62:[2,75],63:[2,75],64:[2,75],65:[2,75],66:[2,75],67:[2,75],68:[2,75],69:[2,75],70:[2,75],71:[2,75],72:[2,75],73:[2,75],74:[2,75],75:[2,75],76:[2,75],77:[2,75],78:[2,75],79:[2,75],81:[2,75],82:[2,75],83:[2,75],84:[2,75],85:[2,75],86:[2,75],87:[2,75],88:[2,75],89:[2,75],90:[2,75],91:[2,75],92:[2,75],93:[2,75],94:[2,75],95:[2,75],96:[2,75],97:[2,75],98:[2,75],99:[2,75],100:[2,75],101:[2,75],102:[2,75],103:[2,75],104:[2,75],105:[2,75],106:[2,75],107:[2,75],108:[2,75],109:[2,75],110:[2,75],111:[2,75],112:[2,75],113:[2,75],114:[2,75],115:[2,75],116:[2,75],117:[2,75],118:[2,75],119:[2,75],120:[2,75],121:[2,75],122:[2,75],123:[2,75],124:[2,75],125:[2,75],126:[2,75],127:[2,75],128:[2,75],129:[2,75],130:[2,75],131:[2,75],132:[2,75],134:[2,75],135:[2,75],137:[2,75],138:[2,75],140:[2,75],141:[2,75],142:[2,75],143:[2,75],144:[2,75],145:[2,75],146:[2,75],147:[2,75],148:[2,75],149:[2,75],150:[2,75],151:[2,75],152:[2,75],153:[2,75],154:[2,75],155:[2,75],156:[2,75],157:[2,75],158:[2,75],159:[2,75],160:[2,75],161:[2,75],162:[2,75],165:[2,75],166:[2,75],167:[2,75],168:[2,75],170:[2,75],171:[2,75],186:[2,75],189:[2,75],191:[2,75]},{6:[2,76],8:[2,76],10:[2,76],49:[2,76],50:[2,76],51:[2,76],53:[2,76],56:[2,76],57:[2,76],58:[2,76],59:[2,76],60:[2,76],61:[2,76],62:[2,76],63:[2,76],64:[2,76],65:[2,76],66:[2,76],67:[2,76],68:[2,76],69:[2,76],70:[2,76],71:[2,76],72:[2,76],73:[2,76],74:[2,76],75:[2,76],76:[2,76],77:[2,76],78:[2,76],79:[2,76],81:[2,76],82:[2,76],83:[2,76],84:[2,76],85:[2,76],86:[2,76],87:[2,76],88:[2,76],89:[2,76],90:[2,76],91:[2,76],92:[2,76],93:[2,76],94:[2,76],95:[2,76],96:[2,76],97:[2,76],98:[2,76],99:[2,76],100:[2,76],101:[2,76],102:[2,76],103:[2,76],104:[2,76],105:[2,76],106:[2,76],107:[2,76],108:[2,76],109:[2,76],110:[2,76],111:[2,76],112:[2,76],113:[2,76],114:[2,76],115:[2,76],116:[2,76],117:[2,76],118:[2,76],119:[2,76],120:[2,76],121:[2,76],122:[2,76],123:[2,76],124:[2,76],125:[2,76],126:[2,76],127:[2,76],128:[2,76],129:[2,76],130:[2,76],131:[2,76],132:[2,76],134:[2,76],135:[2,76],137:[2,76],138:[2,76],140:[2,76],141:[2,76],142:[2,76],143:[2,76],144:[2,76],145:[2,76],146:[2,76],147:[2,76],148:[2,76],149:[2,76],150:[2,76],151:[2,76],152:[2,76],153:[2,76],154:[2,76],155:[2,76],156:[2,76],157:[2,76],158:[2,76],159:[2,76],160:[2,76],161:[2,76],162:[2,76],165:[2,76],166:[2,76],167:[2,76],168:[2,76],170:[2,76],171:[2,76],186:[2,76],189:[2,76],191:[2,76]},{3:143,4:[1,144],7:138,8:[1,117],13:142,15:141},{7:138,8:[1,117],15:145},{80:[1,146]},{6:[2,81],8:[2,81],10:[2,81],49:[2,81],50:[2,81],51:[2,81],53:[2,81],56:[2,81],57:[2,81],58:[2,81],59:[2,81],60:[2,81],61:[2,81],62:[2,81],63:[2,81],64:[2,81],65:[2,81],66:[2,81],67:[2,81],68:[2,81],69:[2,81],70:[2,81],71:[2,81],72:[2,81],73:[2,81],74:[2,81],75:[2,81],76:[2,81],77:[2,81],78:[2,81],79:[2,81],81:[2,81],82:[2,81],83:[2,81],84:[2,81],85:[2,81],86:[2,81],87:[2,81],88:[2,81],89:[2,81],90:[2,81],91:[2,81],92:[2,81],93:[2,81],94:[2,81],95:[2,81],96:[2,81],97:[2,81],98:[2,81],99:[2,81],100:[2,81],101:[2,81],102:[2,81],103:[2,81],104:[2,81],105:[2,81],106:[2,81],107:[2,81],108:[2,81],109:[2,81],110:[2,81],111:[2,81],112:[2,81],113:[2,81],114:[2,81],115:[2,81],116:[2,81],117:[2,81],118:[2,81],119:[2,81],120:[2,81],121:[2,81],122:[2,81],123:[2,81],124:[2,81],125:[2,81],126:[2,81],127:[2,81],128:[2,81],129:[2,81],130:[2,81],131:[2,81],132:[2,81],134:[2,81],135:[2,81],137:[2,81],138:[2,81],140:[2,81],141:[2,81],142:[2,81],143:[2,81],144:[2,81],145:[2,81],146:[2,81],147:[2,81],148:[2,81],149:[2,81],150:[2,81],151:[2,81],152:[2,81],153:[2,81],154:[2,81],155:[2,81],156:[2,81],157:[2,81],158:[2,81],159:[2,81],160:[2,81],161:[2,81],162:[2,81],165:[2,81],166:[2,81],167:[2,81],168:[2,81],170:[2,81],171:[2,81],186:[2,81],189:[2,81],191:[2,81]},{7:147,8:[1,117]},{7:148,8:[1,117]},{7:149,8:[1,117]},{7:150,8:[1,117]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:151,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:152,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{4:[1,154],8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:153,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:155,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:156,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:157,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{4:[1,158],8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:159,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:160,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:161,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:162,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:163,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:164,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:165,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:166,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:167,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:168,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:169,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:170,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:171,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:172,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:173,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:174,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,110],8:[2,110],10:[2,110],49:[2,110],50:[2,110],51:[2,110],53:[2,110],56:[2,110],57:[2,110],58:[2,110],59:[2,110],60:[2,110],61:[2,110],62:[2,110],63:[2,110],64:[2,110],65:[2,110],66:[2,110],67:[2,110],68:[2,110],69:[2,110],70:[2,110],71:[2,110],72:[2,110],73:[2,110],74:[2,110],75:[2,110],76:[2,110],77:[2,110],78:[2,110],79:[2,110],81:[2,110],82:[2,110],83:[2,110],84:[2,110],85:[2,110],86:[2,110],87:[2,110],88:[2,110],89:[2,110],90:[2,110],91:[2,110],92:[2,110],93:[2,110],94:[2,110],95:[2,110],96:[2,110],97:[2,110],98:[2,110],99:[2,110],100:[2,110],101:[2,110],102:[2,110],103:[2,110],104:[2,110],105:[2,110],106:[2,110],107:[2,110],108:[2,110],109:[2,110],110:[2,110],111:[2,110],112:[2,110],113:[2,110],114:[2,110],115:[2,110],116:[2,110],117:[2,110],118:[2,110],119:[2,110],120:[2,110],121:[2,110],122:[2,110],123:[2,110],124:[2,110],125:[2,110],126:[2,110],127:[2,110],128:[2,110],129:[2,110],130:[2,110],131:[2,110],132:[2,110],134:[2,110],135:[2,110],137:[2,110],138:[2,110],140:[2,110],141:[2,110],142:[2,110],143:[2,110],144:[2,110],145:[2,110],146:[2,110],147:[2,110],148:[2,110],149:[2,110],150:[2,110],151:[2,110],152:[2,110],153:[2,110],154:[2,110],155:[2,110],156:[2,110],157:[2,110],158:[2,110],159:[2,110],160:[2,110],161:[2,110],162:[2,110],165:[2,110],166:[2,110],167:[2,110],168:[2,110],170:[2,110],171:[2,110],186:[2,110],189:[2,110],191:[2,110]},{6:[2,111],8:[2,111],10:[2,111],49:[2,111],50:[2,111],51:[2,111],53:[2,111],56:[2,111],57:[2,111],58:[2,111],59:[2,111],60:[2,111],61:[2,111],62:[2,111],63:[2,111],64:[2,111],65:[2,111],66:[2,111],67:[2,111],68:[2,111],69:[2,111],70:[2,111],71:[2,111],72:[2,111],73:[2,111],74:[2,111],75:[2,111],76:[2,111],77:[2,111],78:[2,111],79:[2,111],81:[2,111],82:[2,111],83:[2,111],84:[2,111],85:[2,111],86:[2,111],87:[2,111],88:[2,111],89:[2,111],90:[2,111],91:[2,111],92:[2,111],93:[2,111],94:[2,111],95:[2,111],96:[2,111],97:[2,111],98:[2,111],99:[2,111],100:[2,111],101:[2,111],102:[2,111],103:[2,111],104:[2,111],105:[2,111],106:[2,111],107:[2,111],108:[2,111],109:[2,111],110:[2,111],111:[2,111],112:[2,111],113:[2,111],114:[2,111],115:[2,111],116:[2,111],117:[2,111],118:[2,111],119:[2,111],120:[2,111],121:[2,111],122:[2,111],123:[2,111],124:[2,111],125:[2,111],126:[2,111],127:[2,111],128:[2,111],129:[2,111],130:[2,111],131:[2,111],132:[2,111],134:[2,111],135:[2,111],137:[2,111],138:[2,111],140:[2,111],141:[2,111],142:[2,111],143:[2,111],144:[2,111],145:[2,111],146:[2,111],147:[2,111],148:[2,111],149:[2,111],150:[2,111],151:[2,111],152:[2,111],153:[2,111],154:[2,111],155:[2,111],156:[2,111],157:[2,111],158:[2,111],159:[2,111],160:[2,111],161:[2,111],162:[2,111],165:[2,111],166:[2,111],167:[2,111],168:[2,111],170:[2,111],171:[2,111],186:[2,111],189:[2,111],191:[2,111]},{6:[2,112],8:[2,112],10:[2,112],49:[2,112],50:[2,112],51:[2,112],53:[2,112],56:[2,112],57:[2,112],58:[2,112],59:[2,112],60:[2,112],61:[2,112],62:[2,112],63:[2,112],64:[2,112],65:[2,112],66:[2,112],67:[2,112],68:[2,112],69:[2,112],70:[2,112],71:[2,112],72:[2,112],73:[2,112],74:[2,112],75:[2,112],76:[2,112],77:[2,112],78:[2,112],79:[2,112],81:[2,112],82:[2,112],83:[2,112],84:[2,112],85:[2,112],86:[2,112],87:[2,112],88:[2,112],89:[2,112],90:[2,112],91:[2,112],92:[2,112],93:[2,112],94:[2,112],95:[2,112],96:[2,112],97:[2,112],98:[2,112],99:[2,112],100:[2,112],101:[2,112],102:[2,112],103:[2,112],104:[2,112],105:[2,112],106:[2,112],107:[2,112],108:[2,112],109:[2,112],110:[2,112],111:[2,112],112:[2,112],113:[2,112],114:[2,112],115:[2,112],116:[2,112],117:[2,112],118:[2,112],119:[2,112],120:[2,112],121:[2,112],122:[2,112],123:[2,112],124:[2,112],125:[2,112],126:[2,112],127:[2,112],128:[2,112],129:[2,112],130:[2,112],131:[2,112],132:[2,112],134:[2,112],135:[2,112],137:[2,112],138:[2,112],140:[2,112],141:[2,112],142:[2,112],143:[2,112],144:[2,112],145:[2,112],146:[2,112],147:[2,112],148:[2,112],149:[2,112],150:[2,112],151:[2,112],152:[2,112],153:[2,112],154:[2,112],155:[2,112],156:[2,112],157:[2,112],158:[2,112],159:[2,112],160:[2,112],161:[2,112],162:[2,112],165:[2,112],166:[2,112],167:[2,112],168:[2,112],170:[2,112],171:[2,112],186:[2,112],189:[2,112],191:[2,112]},{6:[2,113],8:[2,113],10:[2,113],49:[2,113],50:[2,113],51:[2,113],53:[2,113],56:[2,113],57:[2,113],58:[2,113],59:[2,113],60:[2,113],61:[2,113],62:[2,113],63:[2,113],64:[2,113],65:[2,113],66:[2,113],67:[2,113],68:[2,113],69:[2,113],70:[2,113],71:[2,113],72:[2,113],73:[2,113],74:[2,113],75:[2,113],76:[2,113],77:[2,113],78:[2,113],79:[2,113],81:[2,113],82:[2,113],83:[2,113],84:[2,113],85:[2,113],86:[2,113],87:[2,113],88:[2,113],89:[2,113],90:[2,113],91:[2,113],92:[2,113],93:[2,113],94:[2,113],95:[2,113],96:[2,113],97:[2,113],98:[2,113],99:[2,113],100:[2,113],101:[2,113],102:[2,113],103:[2,113],104:[2,113],105:[2,113],106:[2,113],107:[2,113],108:[2,113],109:[2,113],110:[2,113],111:[2,113],112:[2,113],113:[2,113],114:[2,113],115:[2,113],116:[2,113],117:[2,113],118:[2,113],119:[2,113],120:[2,113],121:[2,113],122:[2,113],123:[2,113],124:[2,113],125:[2,113],126:[2,113],127:[2,113],128:[2,113],129:[2,113],130:[2,113],131:[2,113],132:[2,113],134:[2,113],135:[2,113],137:[2,113],138:[2,113],140:[2,113],141:[2,113],142:[2,113],143:[2,113],144:[2,113],145:[2,113],146:[2,113],147:[2,113],148:[2,113],149:[2,113],150:[2,113],151:[2,113],152:[2,113],153:[2,113],154:[2,113],155:[2,113],156:[2,113],157:[2,113],158:[2,113],159:[2,113],160:[2,113],161:[2,113],162:[2,113],165:[2,113],166:[2,113],167:[2,113],168:[2,113],170:[2,113],171:[2,113],186:[2,113],189:[2,113],191:[2,113]},{6:[2,114],8:[2,114],10:[2,114],49:[2,114],50:[2,114],51:[2,114],53:[2,114],56:[2,114],57:[2,114],58:[2,114],59:[2,114],60:[2,114],61:[2,114],62:[2,114],63:[2,114],64:[2,114],65:[2,114],66:[2,114],67:[2,114],68:[2,114],69:[2,114],70:[2,114],71:[2,114],72:[2,114],73:[2,114],74:[2,114],75:[2,114],76:[2,114],77:[2,114],78:[2,114],79:[2,114],81:[2,114],82:[2,114],83:[2,114],84:[2,114],85:[2,114],86:[2,114],87:[2,114],88:[2,114],89:[2,114],90:[2,114],91:[2,114],92:[2,114],93:[2,114],94:[2,114],95:[2,114],96:[2,114],97:[2,114],98:[2,114],99:[2,114],100:[2,114],101:[2,114],102:[2,114],103:[2,114],104:[2,114],105:[2,114],106:[2,114],107:[2,114],108:[2,114],109:[2,114],110:[2,114],111:[2,114],112:[2,114],113:[2,114],114:[2,114],115:[2,114],116:[2,114],117:[2,114],118:[2,114],119:[2,114],120:[2,114],121:[2,114],122:[2,114],123:[2,114],124:[2,114],125:[2,114],126:[2,114],127:[2,114],128:[2,114],129:[2,114],130:[2,114],131:[2,114],132:[2,114],134:[2,114],135:[2,114],137:[2,114],138:[2,114],140:[2,114],141:[2,114],142:[2,114],143:[2,114],144:[2,114],145:[2,114],146:[2,114],147:[2,114],148:[2,114],149:[2,114],150:[2,114],151:[2,114],152:[2,114],153:[2,114],154:[2,114],155:[2,114],156:[2,114],157:[2,114],158:[2,114],159:[2,114],160:[2,114],161:[2,114],162:[2,114],165:[2,114],166:[2,114],167:[2,114],168:[2,114],170:[2,114],171:[2,114],186:[2,114],189:[2,114],191:[2,114]},{6:[2,115],8:[2,115],10:[2,115],49:[2,115],50:[2,115],51:[2,115],53:[2,115],56:[2,115],57:[2,115],58:[2,115],59:[2,115],60:[2,115],61:[2,115],62:[2,115],63:[2,115],64:[2,115],65:[2,115],66:[2,115],67:[2,115],68:[2,115],69:[2,115],70:[2,115],71:[2,115],72:[2,115],73:[2,115],74:[2,115],75:[2,115],76:[2,115],77:[2,115],78:[2,115],79:[2,115],81:[2,115],82:[2,115],83:[2,115],84:[2,115],85:[2,115],86:[2,115],87:[2,115],88:[2,115],89:[2,115],90:[2,115],91:[2,115],92:[2,115],93:[2,115],94:[2,115],95:[2,115],96:[2,115],97:[2,115],98:[2,115],99:[2,115],100:[2,115],101:[2,115],102:[2,115],103:[2,115],104:[2,115],105:[2,115],106:[2,115],107:[2,115],108:[2,115],109:[2,115],110:[2,115],111:[2,115],112:[2,115],113:[2,115],114:[2,115],115:[2,115],116:[2,115],117:[2,115],118:[2,115],119:[2,115],120:[2,115],121:[2,115],122:[2,115],123:[2,115],124:[2,115],125:[2,115],126:[2,115],127:[2,115],128:[2,115],129:[2,115],130:[2,115],131:[2,115],132:[2,115],134:[2,115],135:[2,115],137:[2,115],138:[2,115],140:[2,115],141:[2,115],142:[2,115],143:[2,115],144:[2,115],145:[2,115],146:[2,115],147:[2,115],148:[2,115],149:[2,115],150:[2,115],151:[2,115],152:[2,115],153:[2,115],154:[2,115],155:[2,115],156:[2,115],157:[2,115],158:[2,115],159:[2,115],160:[2,115],161:[2,115],162:[2,115],165:[2,115],166:[2,115],167:[2,115],168:[2,115],170:[2,115],171:[2,115],186:[2,115],189:[2,115],191:[2,115]},{6:[2,116],8:[2,116],10:[2,116],49:[2,116],50:[2,116],51:[2,116],53:[2,116],56:[2,116],57:[2,116],58:[2,116],59:[2,116],60:[2,116],61:[2,116],62:[2,116],63:[2,116],64:[2,116],65:[2,116],66:[2,116],67:[2,116],68:[2,116],69:[2,116],70:[2,116],71:[2,116],72:[2,116],73:[2,116],74:[2,116],75:[2,116],76:[2,116],77:[2,116],78:[2,116],79:[2,116],81:[2,116],82:[2,116],83:[2,116],84:[2,116],85:[2,116],86:[2,116],87:[2,116],88:[2,116],89:[2,116],90:[2,116],91:[2,116],92:[2,116],93:[2,116],94:[2,116],95:[2,116],96:[2,116],97:[2,116],98:[2,116],99:[2,116],100:[2,116],101:[2,116],102:[2,116],103:[2,116],104:[2,116],105:[2,116],106:[2,116],107:[2,116],108:[2,116],109:[2,116],110:[2,116],111:[2,116],112:[2,116],113:[2,116],114:[2,116],115:[2,116],116:[2,116],117:[2,116],118:[2,116],119:[2,116],120:[2,116],121:[2,116],122:[2,116],123:[2,116],124:[2,116],125:[2,116],126:[2,116],127:[2,116],128:[2,116],129:[2,116],130:[2,116],131:[2,116],132:[2,116],134:[2,116],135:[2,116],137:[2,116],138:[2,116],140:[2,116],141:[2,116],142:[2,116],143:[2,116],144:[2,116],145:[2,116],146:[2,116],147:[2,116],148:[2,116],149:[2,116],150:[2,116],151:[2,116],152:[2,116],153:[2,116],154:[2,116],155:[2,116],156:[2,116],157:[2,116],158:[2,116],159:[2,116],160:[2,116],161:[2,116],162:[2,116],165:[2,116],166:[2,116],167:[2,116],168:[2,116],170:[2,116],171:[2,116],186:[2,116],189:[2,116],191:[2,116]},{6:[2,117],8:[2,117],10:[2,117],49:[2,117],50:[2,117],51:[2,117],53:[2,117],56:[2,117],57:[2,117],58:[2,117],59:[2,117],60:[2,117],61:[2,117],62:[2,117],63:[2,117],64:[2,117],65:[2,117],66:[2,117],67:[2,117],68:[2,117],69:[2,117],70:[2,117],71:[2,117],72:[2,117],73:[2,117],74:[2,117],75:[2,117],76:[2,117],77:[2,117],78:[2,117],79:[2,117],81:[2,117],82:[2,117],83:[2,117],84:[2,117],85:[2,117],86:[2,117],87:[2,117],88:[2,117],89:[2,117],90:[2,117],91:[2,117],92:[2,117],93:[2,117],94:[2,117],95:[2,117],96:[2,117],97:[2,117],98:[2,117],99:[2,117],100:[2,117],101:[2,117],102:[2,117],103:[2,117],104:[2,117],105:[2,117],106:[2,117],107:[2,117],108:[2,117],109:[2,117],110:[2,117],111:[2,117],112:[2,117],113:[2,117],114:[2,117],115:[2,117],116:[2,117],117:[2,117],118:[2,117],119:[2,117],120:[2,117],121:[2,117],122:[2,117],123:[2,117],124:[2,117],125:[2,117],126:[2,117],127:[2,117],128:[2,117],129:[2,117],130:[2,117],131:[2,117],132:[2,117],134:[2,117],135:[2,117],137:[2,117],138:[2,117],140:[2,117],141:[2,117],142:[2,117],143:[2,117],144:[2,117],145:[2,117],146:[2,117],147:[2,117],148:[2,117],149:[2,117],150:[2,117],151:[2,117],152:[2,117],153:[2,117],154:[2,117],155:[2,117],156:[2,117],157:[2,117],158:[2,117],159:[2,117],160:[2,117],161:[2,117],162:[2,117],165:[2,117],166:[2,117],167:[2,117],168:[2,117],170:[2,117],171:[2,117],186:[2,117],189:[2,117],191:[2,117]},{7:175,8:[1,117]},{8:[1,177],12:176},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:178,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:179,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:180,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:181,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:182,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:183,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:184,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:185,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:186,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:187,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{7:116,8:[1,117],14:188},{7:189,8:[1,117]},{7:190,8:[1,117]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:191,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:193,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],133:192,135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,194]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:195,140:[2,193],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:202,141:[1,97],142:[2,193],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:203,141:[1,97],143:[1,98],144:[2,193],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:204,141:[1,97],143:[1,98],145:[1,99],146:[2,193],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:205,141:[1,97],143:[1,98],145:[1,99],147:[1,100],148:[2,193],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:206,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],150:[2,193],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:207,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],152:[2,193],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:208,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],154:[2,193],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:209,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],156:[2,193],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:210,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],158:[2,193],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{3:213,4:[1,144],7:214,8:[1,117],16:211,17:212},{8:[1,215]},{8:[1,216]},{6:[2,172],8:[2,172],10:[2,172],49:[2,172],50:[2,172],51:[2,172],53:[2,172],56:[2,172],57:[2,172],58:[2,172],59:[2,172],60:[2,172],61:[2,172],62:[2,172],63:[2,172],64:[2,172],65:[2,172],66:[2,172],67:[2,172],68:[2,172],69:[2,172],70:[2,172],71:[2,172],72:[2,172],73:[2,172],74:[2,172],75:[2,172],76:[2,172],77:[2,172],78:[2,172],79:[2,172],81:[2,172],82:[2,172],83:[2,172],84:[2,172],85:[2,172],86:[2,172],87:[2,172],88:[2,172],89:[2,172],90:[2,172],91:[2,172],92:[2,172],93:[2,172],94:[2,172],95:[2,172],96:[2,172],97:[2,172],98:[2,172],99:[2,172],100:[2,172],101:[2,172],102:[2,172],103:[2,172],104:[2,172],105:[2,172],106:[2,172],107:[2,172],108:[2,172],109:[2,172],110:[2,172],111:[2,172],112:[2,172],113:[2,172],114:[2,172],115:[2,172],116:[2,172],117:[2,172],118:[2,172],119:[2,172],120:[2,172],121:[2,172],122:[2,172],123:[2,172],124:[2,172],125:[2,172],126:[2,172],127:[2,172],128:[2,172],129:[2,172],130:[2,172],131:[2,172],132:[2,172],135:[2,172],137:[2,172],138:[2,172],140:[2,172],141:[2,172],142:[2,172],143:[2,172],144:[2,172],145:[2,172],146:[2,172],147:[2,172],148:[2,172],149:[2,172],150:[2,172],151:[2,172],152:[2,172],153:[2,172],154:[2,172],155:[2,172],156:[2,172],157:[2,172],158:[2,172],159:[2,172],160:[2,172],161:[2,172],162:[2,172],165:[2,172],166:[2,172],167:[2,172],170:[2,172],171:[2,172],186:[2,172],189:[2,172],191:[2,172]},{6:[2,173],8:[2,173],10:[2,173],49:[2,173],50:[2,173],51:[2,173],53:[2,173],56:[2,173],57:[2,173],58:[2,173],59:[2,173],60:[2,173],61:[2,173],62:[2,173],63:[2,173],64:[2,173],65:[2,173],66:[2,173],67:[2,173],68:[2,173],69:[2,173],70:[2,173],71:[2,173],72:[2,173],73:[2,173],74:[2,173],75:[2,173],76:[2,173],77:[2,173],78:[2,173],79:[2,173],81:[2,173],82:[2,173],83:[2,173],84:[2,173],85:[2,173],86:[2,173],87:[2,173],88:[2,173],89:[2,173],90:[2,173],91:[2,173],92:[2,173],93:[2,173],94:[2,173],95:[2,173],96:[2,173],97:[2,173],98:[2,173],99:[2,173],100:[2,173],101:[2,173],102:[2,173],103:[2,173],104:[2,173],105:[2,173],106:[2,173],107:[2,173],108:[2,173],109:[2,173],110:[2,173],111:[2,173],112:[2,173],113:[2,173],114:[2,173],115:[2,173],116:[2,173],117:[2,173],118:[2,173],119:[2,173],120:[2,173],121:[2,173],122:[2,173],123:[2,173],124:[2,173],125:[2,173],126:[2,173],127:[2,173],128:[2,173],129:[2,173],130:[2,173],131:[2,173],132:[2,173],135:[2,173],137:[2,173],138:[2,173],140:[2,173],141:[2,173],142:[2,173],143:[2,173],144:[2,173],145:[2,173],146:[2,173],147:[2,173],148:[2,173],149:[2,173],150:[2,173],151:[2,173],152:[2,173],153:[2,173],154:[2,173],155:[2,173],156:[2,173],157:[2,173],158:[2,173],159:[2,173],160:[2,173],161:[2,173],162:[2,173],165:[2,173],166:[2,173],167:[2,173],170:[2,173],171:[2,173],186:[2,173],189:[2,173],191:[2,173]},{50:[1,217],51:[1,218]},{1:[2,202]},{6:[2,191],10:[2,191],53:[2,191],64:[2,191],65:[2,191],66:[2,191],140:[2,191],142:[2,191],144:[2,191],146:[2,191],148:[2,191],150:[2,191],152:[2,191],154:[2,191],156:[2,191],158:[2,191],160:[2,191],186:[2,191],189:[2,191],191:[2,191]},{6:[2,175],8:[2,175],10:[2,175],49:[2,175],50:[2,175],51:[2,175],53:[2,175],56:[2,175],57:[2,175],58:[2,175],59:[2,175],60:[2,175],61:[2,175],62:[2,175],63:[2,175],64:[2,175],65:[2,175],66:[2,175],67:[2,175],68:[2,175],69:[2,175],70:[2,175],71:[2,175],72:[2,175],73:[2,175],74:[2,175],75:[2,175],76:[2,175],77:[2,175],78:[2,175],79:[2,175],81:[2,175],82:[2,175],83:[2,175],84:[2,175],85:[2,175],86:[2,175],87:[2,175],88:[2,175],89:[2,175],90:[2,175],91:[2,175],92:[2,175],93:[2,175],94:[2,175],95:[2,175],96:[2,175],97:[2,175],98:[2,175],99:[2,175],100:[2,175],101:[2,175],102:[2,175],103:[2,175],104:[2,175],105:[2,175],106:[2,175],107:[2,175],108:[2,175],109:[2,175],110:[2,175],111:[2,175],112:[2,175],113:[2,175],114:[2,175],115:[2,175],116:[2,175],117:[2,175],118:[2,175],119:[2,175],120:[2,175],121:[2,175],122:[2,175],123:[2,175],124:[2,175],125:[2,175],126:[2,175],127:[2,175],128:[2,175],129:[2,175],130:[2,175],131:[2,175],132:[2,175],135:[2,175],137:[2,175],138:[2,175],140:[2,175],141:[2,175],142:[2,175],143:[2,175],144:[2,175],145:[2,175],146:[2,175],147:[2,175],148:[2,175],149:[2,175],150:[2,175],151:[2,175],152:[2,175],153:[2,175],154:[2,175],155:[2,175],156:[2,175],157:[2,175],158:[2,175],159:[2,175],160:[2,175],161:[2,175],162:[2,175],167:[2,175],170:[2,175],171:[2,175],186:[2,175],189:[2,175],191:[2,175]},{8:[2,189],49:[2,189],50:[2,189],51:[2,189],56:[2,189],57:[2,189],58:[2,189],59:[2,189],60:[2,189],61:[2,189],62:[2,189],63:[2,189],67:[2,189],68:[2,189],69:[2,189],70:[2,189],71:[2,189],72:[2,189],73:[2,189],74:[2,189],75:[2,189],76:[2,189],77:[2,189],78:[2,189],79:[2,189],81:[2,189],82:[2,189],83:[2,189],84:[2,189],85:[2,189],86:[2,189],87:[2,189],88:[2,189],89:[2,189],90:[2,189],91:[2,189],92:[2,189],93:[2,189],94:[2,189],95:[2,189],96:[2,189],97:[2,189],98:[2,189],99:[2,189],100:[2,189],101:[2,189],102:[2,189],103:[2,189],104:[2,189],105:[2,189],106:[2,189],107:[2,189],108:[2,189],109:[2,189],110:[2,189],111:[2,189],112:[2,189],113:[2,189],114:[2,189],115:[2,189],116:[2,189],117:[2,189],118:[2,189],119:[2,189],120:[2,189],121:[2,189],122:[2,189],123:[2,189],124:[2,189],125:[2,189],126:[2,189],127:[2,189],128:[2,189],129:[2,189],130:[2,189],131:[2,189],132:[2,189],135:[2,189],137:[2,189],138:[2,189],141:[2,189],143:[2,189],145:[2,189],147:[2,189],149:[2,189],151:[2,189],153:[2,189],155:[2,189],157:[2,189],159:[2,189],161:[2,189],162:[2,189],167:[2,189],170:[2,189],171:[2,189],176:[2,189],177:[2,189],178:[2,189],179:[2,189],180:[2,189],181:[2,189],182:[2,189]},{8:[2,6],10:[2,6],19:[2,6],21:[2,6],23:[2,6],25:[2,6],27:[2,6],29:[2,6],31:[2,6],33:[2,6],35:[2,6],37:[2,6],39:[2,6],41:[2,6],49:[2,6],50:[2,6],51:[2,6],56:[2,6],57:[2,6],58:[2,6],59:[2,6],60:[2,6],61:[2,6],62:[2,6],63:[2,6],67:[2,6],68:[2,6],69:[2,6],70:[2,6],71:[2,6],72:[2,6],73:[2,6],74:[2,6],75:[2,6],76:[2,6],77:[2,6],78:[2,6],79:[2,6],81:[2,6],82:[2,6],83:[2,6],84:[2,6],85:[2,6],86:[2,6],87:[2,6],88:[2,6],89:[2,6],90:[2,6],91:[2,6],92:[2,6],93:[2,6],94:[2,6],95:[2,6],96:[2,6],97:[2,6],98:[2,6],99:[2,6],100:[2,6],101:[2,6],102:[2,6],103:[2,6],104:[2,6],105:[2,6],106:[2,6],107:[2,6],108:[2,6],109:[2,6],110:[2,6],111:[2,6],112:[2,6],113:[2,6],114:[2,6],115:[2,6],116:[2,6],117:[2,6],118:[2,6],119:[2,6],120:[2,6],121:[2,6],122:[2,6],123:[2,6],124:[2,6],125:[2,6],126:[2,6],127:[2,6],128:[2,6],129:[2,6],130:[2,6],131:[2,6],132:[2,6],135:[2,6],137:[2,6],138:[2,6],141:[2,6],143:[2,6],145:[2,6],147:[2,6],149:[2,6],151:[2,6],153:[2,6],155:[2,6],157:[2,6],159:[2,6],161:[2,6],162:[2,6],167:[2,6],170:[2,6],171:[2,6],176:[2,6],177:[2,6],178:[2,6],179:[2,6],180:[2,6],181:[2,6],182:[2,6]},{9:[1,219]},{8:[2,190],49:[2,190],50:[2,190],51:[2,190],56:[2,190],57:[2,190],58:[2,190],59:[2,190],60:[2,190],61:[2,190],62:[2,190],63:[2,190],67:[2,190],68:[2,190],69:[2,190],70:[2,190],71:[2,190],72:[2,190],73:[2,190],74:[2,190],75:[2,190],76:[2,190],77:[2,190],78:[2,190],79:[2,190],81:[2,190],82:[2,190],83:[2,190],84:[2,190],85:[2,190],86:[2,190],87:[2,190],88:[2,190],89:[2,190],90:[2,190],91:[2,190],92:[2,190],93:[2,190],94:[2,190],95:[2,190],96:[2,190],97:[2,190],98:[2,190],99:[2,190],100:[2,190],101:[2,190],102:[2,190],103:[2,190],104:[2,190],105:[2,190],106:[2,190],107:[2,190],108:[2,190],109:[2,190],110:[2,190],111:[2,190],112:[2,190],113:[2,190],114:[2,190],115:[2,190],116:[2,190],117:[2,190],118:[2,190],119:[2,190],120:[2,190],121:[2,190],122:[2,190],123:[2,190],124:[2,190],125:[2,190],126:[2,190],127:[2,190],128:[2,190],129:[2,190],130:[2,190],131:[2,190],132:[2,190],135:[2,190],137:[2,190],138:[2,190],141:[2,190],143:[2,190],145:[2,190],147:[2,190],149:[2,190],151:[2,190],153:[2,190],155:[2,190],157:[2,190],159:[2,190],161:[2,190],162:[2,190],167:[2,190],170:[2,190],171:[2,190],176:[2,190],177:[2,190],178:[2,190],179:[2,190],180:[2,190],181:[2,190],182:[2,190]},{8:[1,221],136:220,165:[1,223],166:[1,224],174:222},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:225,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:226,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:227,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,164],8:[2,164],10:[2,164],49:[2,164],50:[2,164],51:[2,164],53:[2,164],56:[2,164],57:[2,164],58:[2,164],59:[2,164],60:[2,164],61:[2,164],62:[2,164],63:[2,164],64:[2,164],65:[2,164],66:[2,164],67:[2,164],68:[2,164],69:[2,164],70:[2,164],71:[2,164],72:[2,164],73:[2,164],74:[2,164],75:[2,164],76:[2,164],77:[2,164],78:[2,164],79:[2,164],81:[2,164],82:[2,164],83:[2,164],84:[2,164],85:[2,164],86:[2,164],87:[2,164],88:[2,164],89:[2,164],90:[2,164],91:[2,164],92:[2,164],93:[2,164],94:[2,164],95:[2,164],96:[2,164],97:[2,164],98:[2,164],99:[2,164],100:[2,164],101:[2,164],102:[2,164],103:[2,164],104:[2,164],105:[2,164],106:[2,164],107:[2,164],108:[2,164],109:[2,164],110:[2,164],111:[2,164],112:[2,164],113:[2,164],114:[2,164],115:[2,164],116:[2,164],117:[2,164],118:[2,164],119:[2,164],120:[2,164],121:[2,164],122:[2,164],123:[2,164],124:[2,164],125:[2,164],126:[2,164],127:[2,164],128:[2,164],129:[2,164],130:[2,164],131:[2,164],132:[2,164],135:[2,164],137:[2,164],138:[2,164],140:[2,164],141:[2,164],142:[2,164],143:[2,164],144:[2,164],145:[2,164],146:[2,164],147:[2,164],148:[2,164],149:[2,164],150:[2,164],151:[2,164],152:[2,164],153:[2,164],154:[2,164],155:[2,164],156:[2,164],157:[2,164],158:[2,164],159:[2,164],160:[2,164],161:[2,164],162:[2,164],167:[2,164],170:[2,164],171:[2,164],186:[2,164],189:[2,164],191:[2,164]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:228,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:229,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,48],8:[2,48],10:[2,48],49:[2,48],50:[2,48],51:[2,48],53:[2,48],56:[2,48],57:[2,48],58:[2,48],59:[2,48],60:[2,48],61:[2,48],62:[2,48],63:[2,48],64:[2,48],65:[2,48],66:[2,48],67:[2,48],68:[2,48],69:[2,48],70:[2,48],71:[2,48],72:[2,48],73:[2,48],74:[2,48],75:[2,48],76:[2,48],77:[2,48],78:[2,48],79:[2,48],81:[2,48],82:[2,48],83:[2,48],84:[2,48],85:[2,48],86:[2,48],87:[2,48],88:[2,48],89:[2,48],90:[2,48],91:[2,48],92:[2,48],93:[2,48],94:[2,48],95:[2,48],96:[2,48],97:[2,48],98:[2,48],99:[2,48],100:[2,48],101:[2,48],102:[2,48],103:[2,48],104:[2,48],105:[2,48],106:[2,48],107:[2,48],108:[2,48],109:[2,48],110:[2,48],111:[2,48],112:[2,48],113:[2,48],114:[2,48],115:[2,48],116:[2,48],117:[2,48],118:[2,48],119:[2,48],120:[2,48],121:[2,48],122:[2,48],123:[2,48],124:[2,48],125:[2,48],126:[2,48],127:[2,48],128:[2,48],129:[2,48],130:[2,48],131:[2,48],132:[2,48],134:[2,48],135:[2,48],137:[2,48],138:[2,48],140:[2,48],141:[2,48],142:[2,48],143:[2,48],144:[2,48],145:[2,48],146:[2,48],147:[2,48],148:[2,48],149:[2,48],150:[2,48],151:[2,48],152:[2,48],153:[2,48],154:[2,48],155:[2,48],156:[2,48],157:[2,48],158:[2,48],159:[2,48],160:[2,48],161:[2,48],162:[2,48],165:[2,48],166:[2,48],167:[2,48],168:[2,48],170:[2,48],171:[2,48],186:[2,48],189:[2,48],191:[2,48]},{10:[1,230],64:[1,231],65:[1,232],66:[1,233]},{6:[2,50],8:[2,50],10:[2,50],49:[2,50],50:[2,50],51:[2,50],53:[2,50],56:[2,50],57:[2,50],58:[2,50],59:[2,50],60:[2,50],61:[2,50],62:[2,50],63:[2,50],64:[2,50],65:[2,50],66:[2,50],67:[2,50],68:[2,50],69:[2,50],70:[2,50],71:[2,50],72:[2,50],73:[2,50],74:[2,50],75:[2,50],76:[2,50],77:[2,50],78:[2,50],79:[2,50],81:[2,50],82:[2,50],83:[2,50],84:[2,50],85:[2,50],86:[2,50],87:[2,50],88:[2,50],89:[2,50],90:[2,50],91:[2,50],92:[2,50],93:[2,50],94:[2,50],95:[2,50],96:[2,50],97:[2,50],98:[2,50],99:[2,50],100:[2,50],101:[2,50],102:[2,50],103:[2,50],104:[2,50],105:[2,50],106:[2,50],107:[2,50],108:[2,50],109:[2,50],110:[2,50],111:[2,50],112:[2,50],113:[2,50],114:[2,50],115:[2,50],116:[2,50],117:[2,50],118:[2,50],119:[2,50],120:[2,50],121:[2,50],122:[2,50],123:[2,50],124:[2,50],125:[2,50],126:[2,50],127:[2,50],128:[2,50],129:[2,50],130:[2,50],131:[2,50],132:[2,50],134:[2,50],135:[2,50],137:[2,50],138:[2,50],140:[2,50],141:[2,50],142:[2,50],143:[2,50],144:[2,50],145:[2,50],146:[2,50],147:[2,50],148:[2,50],149:[2,50],150:[2,50],151:[2,50],152:[2,50],153:[2,50],154:[2,50],155:[2,50],156:[2,50],157:[2,50],158:[2,50],159:[2,50],160:[2,50],161:[2,50],162:[2,50],165:[2,50],166:[2,50],167:[2,50],168:[2,50],170:[2,50],171:[2,50],186:[2,50],189:[2,50],191:[2,50]},{6:[2,51],8:[2,51],10:[2,51],49:[2,51],50:[2,51],51:[2,51],53:[2,51],56:[2,51],57:[2,51],58:[2,51],59:[2,51],60:[2,51],61:[2,51],62:[2,51],63:[2,51],64:[2,51],65:[2,51],66:[2,51],67:[2,51],68:[2,51],69:[2,51],70:[2,51],71:[2,51],72:[2,51],73:[2,51],74:[2,51],75:[2,51],76:[2,51],77:[2,51],78:[2,51],79:[2,51],81:[2,51],82:[2,51],83:[2,51],84:[2,51],85:[2,51],86:[2,51],87:[2,51],88:[2,51],89:[2,51],90:[2,51],91:[2,51],92:[2,51],93:[2,51],94:[2,51],95:[2,51],96:[2,51],97:[2,51],98:[2,51],99:[2,51],100:[2,51],101:[2,51],102:[2,51],103:[2,51],104:[2,51],105:[2,51],106:[2,51],107:[2,51],108:[2,51],109:[2,51],110:[2,51],111:[2,51],112:[2,51],113:[2,51],114:[2,51],115:[2,51],116:[2,51],117:[2,51],118:[2,51],119:[2,51],120:[2,51],121:[2,51],122:[2,51],123:[2,51],124:[2,51],125:[2,51],126:[2,51],127:[2,51],128:[2,51],129:[2,51],130:[2,51],131:[2,51],132:[2,51],134:[2,51],135:[2,51],137:[2,51],138:[2,51],140:[2,51],141:[2,51],142:[2,51],143:[2,51],144:[2,51],145:[2,51],146:[2,51],147:[2,51],148:[2,51],149:[2,51],150:[2,51],151:[2,51],152:[2,51],153:[2,51],154:[2,51],155:[2,51],156:[2,51],157:[2,51],158:[2,51],159:[2,51],160:[2,51],161:[2,51],162:[2,51],165:[2,51],166:[2,51],167:[2,51],168:[2,51],170:[2,51],171:[2,51],186:[2,51],189:[2,51],191:[2,51]},{6:[2,52],8:[2,52],10:[2,52],49:[2,52],50:[2,52],51:[2,52],53:[2,52],56:[2,52],57:[2,52],58:[2,52],59:[2,52],60:[2,52],61:[2,52],62:[2,52],63:[2,52],64:[2,52],65:[2,52],66:[2,52],67:[2,52],68:[2,52],69:[2,52],70:[2,52],71:[2,52],72:[2,52],73:[2,52],74:[2,52],75:[2,52],76:[2,52],77:[2,52],78:[2,52],79:[2,52],81:[2,52],82:[2,52],83:[2,52],84:[2,52],85:[2,52],86:[2,52],87:[2,52],88:[2,52],89:[2,52],90:[2,52],91:[2,52],92:[2,52],93:[2,52],94:[2,52],95:[2,52],96:[2,52],97:[2,52],98:[2,52],99:[2,52],100:[2,52],101:[2,52],102:[2,52],103:[2,52],104:[2,52],105:[2,52],106:[2,52],107:[2,52],108:[2,52],109:[2,52],110:[2,52],111:[2,52],112:[2,52],113:[2,52],114:[2,52],115:[2,52],116:[2,52],117:[2,52],118:[2,52],119:[2,52],120:[2,52],121:[2,52],122:[2,52],123:[2,52],124:[2,52],125:[2,52],126:[2,52],127:[2,52],128:[2,52],129:[2,52],130:[2,52],131:[2,52],132:[2,52],134:[2,52],135:[2,52],137:[2,52],138:[2,52],140:[2,52],141:[2,52],142:[2,52],143:[2,52],144:[2,52],145:[2,52],146:[2,52],147:[2,52],148:[2,52],149:[2,52],150:[2,52],151:[2,52],152:[2,52],153:[2,52],154:[2,52],155:[2,52],156:[2,52],157:[2,52],158:[2,52],159:[2,52],160:[2,52],161:[2,52],162:[2,52],165:[2,52],166:[2,52],167:[2,52],168:[2,52],170:[2,52],171:[2,52],186:[2,52],189:[2,52],191:[2,52]},{6:[2,53],8:[2,53],10:[2,53],49:[2,53],50:[2,53],51:[2,53],53:[2,53],56:[2,53],57:[2,53],58:[2,53],59:[2,53],60:[2,53],61:[2,53],62:[2,53],63:[2,53],64:[2,53],65:[2,53],66:[2,53],67:[2,53],68:[2,53],69:[2,53],70:[2,53],71:[2,53],72:[2,53],73:[2,53],74:[2,53],75:[2,53],76:[2,53],77:[2,53],78:[2,53],79:[2,53],81:[2,53],82:[2,53],83:[2,53],84:[2,53],85:[2,53],86:[2,53],87:[2,53],88:[2,53],89:[2,53],90:[2,53],91:[2,53],92:[2,53],93:[2,53],94:[2,53],95:[2,53],96:[2,53],97:[2,53],98:[2,53],99:[2,53],100:[2,53],101:[2,53],102:[2,53],103:[2,53],104:[2,53],105:[2,53],106:[2,53],107:[2,53],108:[2,53],109:[2,53],110:[2,53],111:[2,53],112:[2,53],113:[2,53],114:[2,53],115:[2,53],116:[2,53],117:[2,53],118:[2,53],119:[2,53],120:[2,53],121:[2,53],122:[2,53],123:[2,53],124:[2,53],125:[2,53],126:[2,53],127:[2,53],128:[2,53],129:[2,53],130:[2,53],131:[2,53],132:[2,53],134:[2,53],135:[2,53],137:[2,53],138:[2,53],140:[2,53],141:[2,53],142:[2,53],143:[2,53],144:[2,53],145:[2,53],146:[2,53],147:[2,53],148:[2,53],149:[2,53],150:[2,53],151:[2,53],152:[2,53],153:[2,53],154:[2,53],155:[2,53],156:[2,53],157:[2,53],158:[2,53],159:[2,53],160:[2,53],161:[2,53],162:[2,53],165:[2,53],166:[2,53],167:[2,53],168:[2,53],170:[2,53],171:[2,53],186:[2,53],189:[2,53],191:[2,53]},{6:[2,54],8:[2,54],10:[2,54],49:[2,54],50:[2,54],51:[2,54],53:[2,54],56:[2,54],57:[2,54],58:[2,54],59:[2,54],60:[2,54],61:[2,54],62:[2,54],63:[2,54],64:[2,54],65:[2,54],66:[2,54],67:[2,54],68:[2,54],69:[2,54],70:[2,54],71:[2,54],72:[2,54],73:[2,54],74:[2,54],75:[2,54],76:[2,54],77:[2,54],78:[2,54],79:[2,54],81:[2,54],82:[2,54],83:[2,54],84:[2,54],85:[2,54],86:[2,54],87:[2,54],88:[2,54],89:[2,54],90:[2,54],91:[2,54],92:[2,54],93:[2,54],94:[2,54],95:[2,54],96:[2,54],97:[2,54],98:[2,54],99:[2,54],100:[2,54],101:[2,54],102:[2,54],103:[2,54],104:[2,54],105:[2,54],106:[2,54],107:[2,54],108:[2,54],109:[2,54],110:[2,54],111:[2,54],112:[2,54],113:[2,54],114:[2,54],115:[2,54],116:[2,54],117:[2,54],118:[2,54],119:[2,54],120:[2,54],121:[2,54],122:[2,54],123:[2,54],124:[2,54],125:[2,54],126:[2,54],127:[2,54],128:[2,54],129:[2,54],130:[2,54],131:[2,54],132:[2,54],134:[2,54],135:[2,54],137:[2,54],138:[2,54],140:[2,54],141:[2,54],142:[2,54],143:[2,54],144:[2,54],145:[2,54],146:[2,54],147:[2,54],148:[2,54],149:[2,54],150:[2,54],151:[2,54],152:[2,54],153:[2,54],154:[2,54],155:[2,54],156:[2,54],157:[2,54],158:[2,54],159:[2,54],160:[2,54],161:[2,54],162:[2,54],165:[2,54],166:[2,54],167:[2,54],168:[2,54],170:[2,54],171:[2,54],186:[2,54],189:[2,54],191:[2,54]},{6:[2,55],8:[2,55],10:[2,55],49:[2,55],50:[2,55],51:[2,55],53:[2,55],56:[2,55],57:[2,55],58:[2,55],59:[2,55],60:[2,55],61:[2,55],62:[2,55],63:[2,55],64:[2,55],65:[2,55],66:[2,55],67:[2,55],68:[2,55],69:[2,55],70:[2,55],71:[2,55],72:[2,55],73:[2,55],74:[2,55],75:[2,55],76:[2,55],77:[2,55],78:[2,55],79:[2,55],81:[2,55],82:[2,55],83:[2,55],84:[2,55],85:[2,55],86:[2,55],87:[2,55],88:[2,55],89:[2,55],90:[2,55],91:[2,55],92:[2,55],93:[2,55],94:[2,55],95:[2,55],96:[2,55],97:[2,55],98:[2,55],99:[2,55],100:[2,55],101:[2,55],102:[2,55],103:[2,55],104:[2,55],105:[2,55],106:[2,55],107:[2,55],108:[2,55],109:[2,55],110:[2,55],111:[2,55],112:[2,55],113:[2,55],114:[2,55],115:[2,55],116:[2,55],117:[2,55],118:[2,55],119:[2,55],120:[2,55],121:[2,55],122:[2,55],123:[2,55],124:[2,55],125:[2,55],126:[2,55],127:[2,55],128:[2,55],129:[2,55],130:[2,55],131:[2,55],132:[2,55],134:[2,55],135:[2,55],137:[2,55],138:[2,55],140:[2,55],141:[2,55],142:[2,55],143:[2,55],144:[2,55],145:[2,55],146:[2,55],147:[2,55],148:[2,55],149:[2,55],150:[2,55],151:[2,55],152:[2,55],153:[2,55],154:[2,55],155:[2,55],156:[2,55],157:[2,55],158:[2,55],159:[2,55],160:[2,55],161:[2,55],162:[2,55],165:[2,55],166:[2,55],167:[2,55],168:[2,55],170:[2,55],171:[2,55],186:[2,55],189:[2,55],191:[2,55]},{6:[2,56],8:[2,56],10:[2,56],49:[2,56],50:[2,56],51:[2,56],53:[2,56],56:[2,56],57:[2,56],58:[2,56],59:[2,56],60:[2,56],61:[2,56],62:[2,56],63:[2,56],64:[2,56],65:[2,56],66:[2,56],67:[2,56],68:[2,56],69:[2,56],70:[2,56],71:[2,56],72:[2,56],73:[2,56],74:[2,56],75:[2,56],76:[2,56],77:[2,56],78:[2,56],79:[2,56],81:[2,56],82:[2,56],83:[2,56],84:[2,56],85:[2,56],86:[2,56],87:[2,56],88:[2,56],89:[2,56],90:[2,56],91:[2,56],92:[2,56],93:[2,56],94:[2,56],95:[2,56],96:[2,56],97:[2,56],98:[2,56],99:[2,56],100:[2,56],101:[2,56],102:[2,56],103:[2,56],104:[2,56],105:[2,56],106:[2,56],107:[2,56],108:[2,56],109:[2,56],110:[2,56],111:[2,56],112:[2,56],113:[2,56],114:[2,56],115:[2,56],116:[2,56],117:[2,56],118:[2,56],119:[2,56],120:[2,56],121:[2,56],122:[2,56],123:[2,56],124:[2,56],125:[2,56],126:[2,56],127:[2,56],128:[2,56],129:[2,56],130:[2,56],131:[2,56],132:[2,56],134:[2,56],135:[2,56],137:[2,56],138:[2,56],140:[2,56],141:[2,56],142:[2,56],143:[2,56],144:[2,56],145:[2,56],146:[2,56],147:[2,56],148:[2,56],149:[2,56],150:[2,56],151:[2,56],152:[2,56],153:[2,56],154:[2,56],155:[2,56],156:[2,56],157:[2,56],158:[2,56],159:[2,56],160:[2,56],161:[2,56],162:[2,56],165:[2,56],166:[2,56],167:[2,56],168:[2,56],170:[2,56],171:[2,56],186:[2,56],189:[2,56],191:[2,56]},{6:[2,57],8:[2,57],10:[2,57],49:[2,57],50:[2,57],51:[2,57],53:[2,57],56:[2,57],57:[2,57],58:[2,57],59:[2,57],60:[2,57],61:[2,57],62:[2,57],63:[2,57],64:[2,57],65:[2,57],66:[2,57],67:[2,57],68:[2,57],69:[2,57],70:[2,57],71:[2,57],72:[2,57],73:[2,57],74:[2,57],75:[2,57],76:[2,57],77:[2,57],78:[2,57],79:[2,57],81:[2,57],82:[2,57],83:[2,57],84:[2,57],85:[2,57],86:[2,57],87:[2,57],88:[2,57],89:[2,57],90:[2,57],91:[2,57],92:[2,57],93:[2,57],94:[2,57],95:[2,57],96:[2,57],97:[2,57],98:[2,57],99:[2,57],100:[2,57],101:[2,57],102:[2,57],103:[2,57],104:[2,57],105:[2,57],106:[2,57],107:[2,57],108:[2,57],109:[2,57],110:[2,57],111:[2,57],112:[2,57],113:[2,57],114:[2,57],115:[2,57],116:[2,57],117:[2,57],118:[2,57],119:[2,57],120:[2,57],121:[2,57],122:[2,57],123:[2,57],124:[2,57],125:[2,57],126:[2,57],127:[2,57],128:[2,57],129:[2,57],130:[2,57],131:[2,57],132:[2,57],134:[2,57],135:[2,57],137:[2,57],138:[2,57],140:[2,57],141:[2,57],142:[2,57],143:[2,57],144:[2,57],145:[2,57],146:[2,57],147:[2,57],148:[2,57],149:[2,57],150:[2,57],151:[2,57],152:[2,57],153:[2,57],154:[2,57],155:[2,57],156:[2,57],157:[2,57],158:[2,57],159:[2,57],160:[2,57],161:[2,57],162:[2,57],165:[2,57],166:[2,57],167:[2,57],168:[2,57],170:[2,57],171:[2,57],186:[2,57],189:[2,57],191:[2,57]},{52:234,53:[1,238],64:[1,235],65:[1,236],66:[1,237]},{6:[2,69],8:[2,69],10:[2,69],49:[2,69],50:[2,69],51:[2,69],53:[2,69],56:[2,69],57:[2,69],58:[2,69],59:[2,69],60:[2,69],61:[2,69],62:[2,69],63:[2,69],64:[2,69],65:[2,69],66:[2,69],67:[2,69],68:[2,69],69:[2,69],70:[2,69],71:[2,69],72:[2,69],73:[2,69],74:[2,69],75:[2,69],76:[2,69],77:[2,69],78:[2,69],79:[2,69],81:[2,69],82:[2,69],83:[2,69],84:[2,69],85:[2,69],86:[2,69],87:[2,69],88:[2,69],89:[2,69],90:[2,69],91:[2,69],92:[2,69],93:[2,69],94:[2,69],95:[2,69],96:[2,69],97:[2,69],98:[2,69],99:[2,69],100:[2,69],101:[2,69],102:[2,69],103:[2,69],104:[2,69],105:[2,69],106:[2,69],107:[2,69],108:[2,69],109:[2,69],110:[2,69],111:[2,69],112:[2,69],113:[2,69],114:[2,69],115:[2,69],116:[2,69],117:[2,69],118:[2,69],119:[2,69],120:[2,69],121:[2,69],122:[2,69],123:[2,69],124:[2,69],125:[2,69],126:[2,69],127:[2,69],128:[2,69],129:[2,69],130:[2,69],131:[2,69],132:[2,69],134:[2,69],135:[2,69],137:[2,69],138:[2,69],140:[2,69],141:[2,69],142:[2,69],143:[2,69],144:[2,69],145:[2,69],146:[2,69],147:[2,69],148:[2,69],149:[2,69],150:[2,69],151:[2,69],152:[2,69],153:[2,69],154:[2,69],155:[2,69],156:[2,69],157:[2,69],158:[2,69],159:[2,69],160:[2,69],161:[2,69],162:[2,69],165:[2,69],166:[2,69],167:[2,69],168:[2,69],170:[2,69],171:[2,69],186:[2,69],189:[2,69],191:[2,69]},{6:[2,7],8:[2,7],10:[2,7],49:[2,7],50:[2,7],51:[2,7],53:[2,7],56:[2,7],57:[2,7],58:[2,7],59:[2,7],60:[2,7],61:[2,7],62:[2,7],63:[2,7],64:[2,7],65:[2,7],66:[2,7],67:[2,7],68:[2,7],69:[2,7],70:[2,7],71:[2,7],72:[2,7],73:[2,7],74:[2,7],75:[2,7],76:[2,7],77:[2,7],78:[2,7],79:[2,7],81:[2,7],82:[2,7],83:[2,7],84:[2,7],85:[2,7],86:[2,7],87:[2,7],88:[2,7],89:[2,7],90:[2,7],91:[2,7],92:[2,7],93:[2,7],94:[2,7],95:[2,7],96:[2,7],97:[2,7],98:[2,7],99:[2,7],100:[2,7],101:[2,7],102:[2,7],103:[2,7],104:[2,7],105:[2,7],106:[2,7],107:[2,7],108:[2,7],109:[2,7],110:[2,7],111:[2,7],112:[2,7],113:[2,7],114:[2,7],115:[2,7],116:[2,7],117:[2,7],118:[2,7],119:[2,7],120:[2,7],121:[2,7],122:[2,7],123:[2,7],124:[2,7],125:[2,7],126:[2,7],127:[2,7],128:[2,7],129:[2,7],130:[2,7],131:[2,7],132:[2,7],134:[2,7],135:[2,7],137:[2,7],138:[2,7],140:[2,7],141:[2,7],142:[2,7],143:[2,7],144:[2,7],145:[2,7],146:[2,7],147:[2,7],148:[2,7],149:[2,7],150:[2,7],151:[2,7],152:[2,7],153:[2,7],154:[2,7],155:[2,7],156:[2,7],157:[2,7],158:[2,7],159:[2,7],160:[2,7],161:[2,7],162:[2,7],165:[2,7],166:[2,7],167:[2,7],168:[2,7],170:[2,7],171:[2,7],186:[2,7],189:[2,7],191:[2,7]},{6:[2,70],8:[2,70],10:[2,70],49:[2,70],50:[2,70],51:[2,70],53:[2,70],56:[2,70],57:[2,70],58:[2,70],59:[2,70],60:[2,70],61:[2,70],62:[2,70],63:[2,70],64:[2,70],65:[2,70],66:[2,70],67:[2,70],68:[2,70],69:[2,70],70:[2,70],71:[2,70],72:[2,70],73:[2,70],74:[2,70],75:[2,70],76:[2,70],77:[2,70],78:[2,70],79:[2,70],81:[2,70],82:[2,70],83:[2,70],84:[2,70],85:[2,70],86:[2,70],87:[2,70],88:[2,70],89:[2,70],90:[2,70],91:[2,70],92:[2,70],93:[2,70],94:[2,70],95:[2,70],96:[2,70],97:[2,70],98:[2,70],99:[2,70],100:[2,70],101:[2,70],102:[2,70],103:[2,70],104:[2,70],105:[2,70],106:[2,70],107:[2,70],108:[2,70],109:[2,70],110:[2,70],111:[2,70],112:[2,70],113:[2,70],114:[2,70],115:[2,70],116:[2,70],117:[2,70],118:[2,70],119:[2,70],120:[2,70],121:[2,70],122:[2,70],123:[2,70],124:[2,70],125:[2,70],126:[2,70],127:[2,70],128:[2,70],129:[2,70],130:[2,70],131:[2,70],132:[2,70],134:[2,70],135:[2,70],137:[2,70],138:[2,70],140:[2,70],141:[2,70],142:[2,70],143:[2,70],144:[2,70],145:[2,70],146:[2,70],147:[2,70],148:[2,70],149:[2,70],150:[2,70],151:[2,70],152:[2,70],153:[2,70],154:[2,70],155:[2,70],156:[2,70],157:[2,70],158:[2,70],159:[2,70],160:[2,70],161:[2,70],162:[2,70],165:[2,70],166:[2,70],167:[2,70],168:[2,70],170:[2,70],171:[2,70],186:[2,70],189:[2,70],191:[2,70]},{6:[2,71],8:[2,71],10:[2,71],49:[2,71],50:[2,71],51:[2,71],53:[2,71],56:[2,71],57:[2,71],58:[2,71],59:[2,71],60:[2,71],61:[2,71],62:[2,71],63:[2,71],64:[2,71],65:[2,71],66:[2,71],67:[2,71],68:[2,71],69:[2,71],70:[2,71],71:[2,71],72:[2,71],73:[2,71],74:[2,71],75:[2,71],76:[2,71],77:[2,71],78:[2,71],79:[2,71],81:[2,71],82:[2,71],83:[2,71],84:[2,71],85:[2,71],86:[2,71],87:[2,71],88:[2,71],89:[2,71],90:[2,71],91:[2,71],92:[2,71],93:[2,71],94:[2,71],95:[2,71],96:[2,71],97:[2,71],98:[2,71],99:[2,71],100:[2,71],101:[2,71],102:[2,71],103:[2,71],104:[2,71],105:[2,71],106:[2,71],107:[2,71],108:[2,71],109:[2,71],110:[2,71],111:[2,71],112:[2,71],113:[2,71],114:[2,71],115:[2,71],116:[2,71],117:[2,71],118:[2,71],119:[2,71],120:[2,71],121:[2,71],122:[2,71],123:[2,71],124:[2,71],125:[2,71],126:[2,71],127:[2,71],128:[2,71],129:[2,71],130:[2,71],131:[2,71],132:[2,71],134:[2,71],135:[2,71],137:[2,71],138:[2,71],140:[2,71],141:[2,71],142:[2,71],143:[2,71],144:[2,71],145:[2,71],146:[2,71],147:[2,71],148:[2,71],149:[2,71],150:[2,71],151:[2,71],152:[2,71],153:[2,71],154:[2,71],155:[2,71],156:[2,71],157:[2,71],158:[2,71],159:[2,71],160:[2,71],161:[2,71],162:[2,71],165:[2,71],166:[2,71],167:[2,71],168:[2,71],170:[2,71],171:[2,71],186:[2,71],189:[2,71],191:[2,71]},{6:[2,77],8:[2,77],10:[2,77],49:[2,77],50:[2,77],51:[2,77],53:[2,77],56:[2,77],57:[2,77],58:[2,77],59:[2,77],60:[2,77],61:[2,77],62:[2,77],63:[2,77],64:[2,77],65:[2,77],66:[2,77],67:[2,77],68:[2,77],69:[2,77],70:[2,77],71:[2,77],72:[2,77],73:[2,77],74:[2,77],75:[2,77],76:[2,77],77:[2,77],78:[2,77],79:[2,77],81:[2,77],82:[2,77],83:[2,77],84:[2,77],85:[2,77],86:[2,77],87:[2,77],88:[2,77],89:[2,77],90:[2,77],91:[2,77],92:[2,77],93:[2,77],94:[2,77],95:[2,77],96:[2,77],97:[2,77],98:[2,77],99:[2,77],100:[2,77],101:[2,77],102:[2,77],103:[2,77],104:[2,77],105:[2,77],106:[2,77],107:[2,77],108:[2,77],109:[2,77],110:[2,77],111:[2,77],112:[2,77],113:[2,77],114:[2,77],115:[2,77],116:[2,77],117:[2,77],118:[2,77],119:[2,77],120:[2,77],121:[2,77],122:[2,77],123:[2,77],124:[2,77],125:[2,77],126:[2,77],127:[2,77],128:[2,77],129:[2,77],130:[2,77],131:[2,77],132:[2,77],134:[2,77],135:[2,77],137:[2,77],138:[2,77],140:[2,77],141:[2,77],142:[2,77],143:[2,77],144:[2,77],145:[2,77],146:[2,77],147:[2,77],148:[2,77],149:[2,77],150:[2,77],151:[2,77],152:[2,77],153:[2,77],154:[2,77],155:[2,77],156:[2,77],157:[2,77],158:[2,77],159:[2,77],160:[2,77],161:[2,77],162:[2,77],165:[2,77],166:[2,77],167:[2,77],168:[2,77],170:[2,77],171:[2,77],186:[2,77],189:[2,77],191:[2,77]},{3:143,4:[1,144],13:239},{4:[2,5],8:[2,5]},{5:[1,240]},{6:[2,79],8:[2,79],10:[2,79],49:[2,79],50:[2,79],51:[2,79],53:[2,79],56:[2,79],57:[2,79],58:[2,79],59:[2,79],60:[2,79],61:[2,79],62:[2,79],63:[2,79],64:[2,79],65:[2,79],66:[2,79],67:[2,79],68:[2,79],69:[2,79],70:[2,79],71:[2,79],72:[2,79],73:[2,79],74:[2,79],75:[2,79],76:[2,79],77:[2,79],78:[2,79],79:[2,79],81:[2,79],82:[2,79],83:[2,79],84:[2,79],85:[2,79],86:[2,79],87:[2,79],88:[2,79],89:[2,79],90:[2,79],91:[2,79],92:[2,79],93:[2,79],94:[2,79],95:[2,79],96:[2,79],97:[2,79],98:[2,79],99:[2,79],100:[2,79],101:[2,79],102:[2,79],103:[2,79],104:[2,79],105:[2,79],106:[2,79],107:[2,79],108:[2,79],109:[2,79],110:[2,79],111:[2,79],112:[2,79],113:[2,79],114:[2,79],115:[2,79],116:[2,79],117:[2,79],118:[2,79],119:[2,79],120:[2,79],121:[2,79],122:[2,79],123:[2,79],124:[2,79],125:[2,79],126:[2,79],127:[2,79],128:[2,79],129:[2,79],130:[2,79],131:[2,79],132:[2,79],134:[2,79],135:[2,79],137:[2,79],138:[2,79],140:[2,79],141:[2,79],142:[2,79],143:[2,79],144:[2,79],145:[2,79],146:[2,79],147:[2,79],148:[2,79],149:[2,79],150:[2,79],151:[2,79],152:[2,79],153:[2,79],154:[2,79],155:[2,79],156:[2,79],157:[2,79],158:[2,79],159:[2,79],160:[2,79],161:[2,79],162:[2,79],165:[2,79],166:[2,79],167:[2,79],168:[2,79],170:[2,79],171:[2,79],186:[2,79],189:[2,79],191:[2,79]},{6:[2,80],8:[2,80],10:[2,80],49:[2,80],50:[2,80],51:[2,80],53:[2,80],56:[2,80],57:[2,80],58:[2,80],59:[2,80],60:[2,80],61:[2,80],62:[2,80],63:[2,80],64:[2,80],65:[2,80],66:[2,80],67:[2,80],68:[2,80],69:[2,80],70:[2,80],71:[2,80],72:[2,80],73:[2,80],74:[2,80],75:[2,80],76:[2,80],77:[2,80],78:[2,80],79:[2,80],81:[2,80],82:[2,80],83:[2,80],84:[2,80],85:[2,80],86:[2,80],87:[2,80],88:[2,80],89:[2,80],90:[2,80],91:[2,80],92:[2,80],93:[2,80],94:[2,80],95:[2,80],96:[2,80],97:[2,80],98:[2,80],99:[2,80],100:[2,80],101:[2,80],102:[2,80],103:[2,80],104:[2,80],105:[2,80],106:[2,80],107:[2,80],108:[2,80],109:[2,80],110:[2,80],111:[2,80],112:[2,80],113:[2,80],114:[2,80],115:[2,80],116:[2,80],117:[2,80],118:[2,80],119:[2,80],120:[2,80],121:[2,80],122:[2,80],123:[2,80],124:[2,80],125:[2,80],126:[2,80],127:[2,80],128:[2,80],129:[2,80],130:[2,80],131:[2,80],132:[2,80],134:[2,80],135:[2,80],137:[2,80],138:[2,80],140:[2,80],141:[2,80],142:[2,80],143:[2,80],144:[2,80],145:[2,80],146:[2,80],147:[2,80],148:[2,80],149:[2,80],150:[2,80],151:[2,80],152:[2,80],153:[2,80],154:[2,80],155:[2,80],156:[2,80],157:[2,80],158:[2,80],159:[2,80],160:[2,80],161:[2,80],162:[2,80],165:[2,80],166:[2,80],167:[2,80],168:[2,80],170:[2,80],171:[2,80],186:[2,80],189:[2,80],191:[2,80]},{6:[2,82],8:[2,82],10:[2,82],49:[2,82],50:[2,82],51:[2,82],53:[2,82],56:[2,82],57:[2,82],58:[2,82],59:[2,82],60:[2,82],61:[2,82],62:[2,82],63:[2,82],64:[2,82],65:[2,82],66:[2,82],67:[2,82],68:[2,82],69:[2,82],70:[2,82],71:[2,82],72:[2,82],73:[2,82],74:[2,82],75:[2,82],76:[2,82],77:[2,82],78:[2,82],79:[2,82],81:[2,82],82:[2,82],83:[2,82],84:[2,82],85:[2,82],86:[2,82],87:[2,82],88:[2,82],89:[2,82],90:[2,82],91:[2,82],92:[2,82],93:[2,82],94:[2,82],95:[2,82],96:[2,82],97:[2,82],98:[2,82],99:[2,82],100:[2,82],101:[2,82],102:[2,82],103:[2,82],104:[2,82],105:[2,82],106:[2,82],107:[2,82],108:[2,82],109:[2,82],110:[2,82],111:[2,82],112:[2,82],113:[2,82],114:[2,82],115:[2,82],116:[2,82],117:[2,82],118:[2,82],119:[2,82],120:[2,82],121:[2,82],122:[2,82],123:[2,82],124:[2,82],125:[2,82],126:[2,82],127:[2,82],128:[2,82],129:[2,82],130:[2,82],131:[2,82],132:[2,82],134:[2,82],135:[2,82],137:[2,82],138:[2,82],140:[2,82],141:[2,82],142:[2,82],143:[2,82],144:[2,82],145:[2,82],146:[2,82],147:[2,82],148:[2,82],149:[2,82],150:[2,82],151:[2,82],152:[2,82],153:[2,82],154:[2,82],155:[2,82],156:[2,82],157:[2,82],158:[2,82],159:[2,82],160:[2,82],161:[2,82],162:[2,82],165:[2,82],166:[2,82],167:[2,82],168:[2,82],170:[2,82],171:[2,82],186:[2,82],189:[2,82],191:[2,82]},{6:[2,83],8:[2,83],10:[2,83],49:[2,83],50:[2,83],51:[2,83],53:[2,83],56:[2,83],57:[2,83],58:[2,83],59:[2,83],60:[2,83],61:[2,83],62:[2,83],63:[2,83],64:[2,83],65:[2,83],66:[2,83],67:[2,83],68:[2,83],69:[2,83],70:[2,83],71:[2,83],72:[2,83],73:[2,83],74:[2,83],75:[2,83],76:[2,83],77:[2,83],78:[2,83],79:[2,83],81:[2,83],82:[2,83],83:[2,83],84:[2,83],85:[2,83],86:[2,83],87:[2,83],88:[2,83],89:[2,83],90:[2,83],91:[2,83],92:[2,83],93:[2,83],94:[2,83],95:[2,83],96:[2,83],97:[2,83],98:[2,83],99:[2,83],100:[2,83],101:[2,83],102:[2,83],103:[2,83],104:[2,83],105:[2,83],106:[2,83],107:[2,83],108:[2,83],109:[2,83],110:[2,83],111:[2,83],112:[2,83],113:[2,83],114:[2,83],115:[2,83],116:[2,83],117:[2,83],118:[2,83],119:[2,83],120:[2,83],121:[2,83],122:[2,83],123:[2,83],124:[2,83],125:[2,83],126:[2,83],127:[2,83],128:[2,83],129:[2,83],130:[2,83],131:[2,83],132:[2,83],134:[2,83],135:[2,83],137:[2,83],138:[2,83],140:[2,83],141:[2,83],142:[2,83],143:[2,83],144:[2,83],145:[2,83],146:[2,83],147:[2,83],148:[2,83],149:[2,83],150:[2,83],151:[2,83],152:[2,83],153:[2,83],154:[2,83],155:[2,83],156:[2,83],157:[2,83],158:[2,83],159:[2,83],160:[2,83],161:[2,83],162:[2,83],165:[2,83],166:[2,83],167:[2,83],168:[2,83],170:[2,83],171:[2,83],186:[2,83],189:[2,83],191:[2,83]},{6:[2,84],8:[2,84],10:[2,84],49:[2,84],50:[2,84],51:[2,84],53:[2,84],56:[2,84],57:[2,84],58:[2,84],59:[2,84],60:[2,84],61:[2,84],62:[2,84],63:[2,84],64:[2,84],65:[2,84],66:[2,84],67:[2,84],68:[2,84],69:[2,84],70:[2,84],71:[2,84],72:[2,84],73:[2,84],74:[2,84],75:[2,84],76:[2,84],77:[2,84],78:[2,84],79:[2,84],81:[2,84],82:[2,84],83:[2,84],84:[2,84],85:[2,84],86:[2,84],87:[2,84],88:[2,84],89:[2,84],90:[2,84],91:[2,84],92:[2,84],93:[2,84],94:[2,84],95:[2,84],96:[2,84],97:[2,84],98:[2,84],99:[2,84],100:[2,84],101:[2,84],102:[2,84],103:[2,84],104:[2,84],105:[2,84],106:[2,84],107:[2,84],108:[2,84],109:[2,84],110:[2,84],111:[2,84],112:[2,84],113:[2,84],114:[2,84],115:[2,84],116:[2,84],117:[2,84],118:[2,84],119:[2,84],120:[2,84],121:[2,84],122:[2,84],123:[2,84],124:[2,84],125:[2,84],126:[2,84],127:[2,84],128:[2,84],129:[2,84],130:[2,84],131:[2,84],132:[2,84],134:[2,84],135:[2,84],137:[2,84],138:[2,84],140:[2,84],141:[2,84],142:[2,84],143:[2,84],144:[2,84],145:[2,84],146:[2,84],147:[2,84],148:[2,84],149:[2,84],150:[2,84],151:[2,84],152:[2,84],153:[2,84],154:[2,84],155:[2,84],156:[2,84],157:[2,84],158:[2,84],159:[2,84],160:[2,84],161:[2,84],162:[2,84],165:[2,84],166:[2,84],167:[2,84],168:[2,84],170:[2,84],171:[2,84],186:[2,84],189:[2,84],191:[2,84]},{6:[2,85],8:[2,85],10:[2,85],49:[2,85],50:[2,85],51:[2,85],53:[2,85],56:[2,85],57:[2,85],58:[2,85],59:[2,85],60:[2,85],61:[2,85],62:[2,85],63:[2,85],64:[2,85],65:[2,85],66:[2,85],67:[2,85],68:[2,85],69:[2,85],70:[2,85],71:[2,85],72:[2,85],73:[2,85],74:[2,85],75:[2,85],76:[2,85],77:[2,85],78:[2,85],79:[2,85],81:[2,85],82:[2,85],83:[2,85],84:[2,85],85:[2,85],86:[2,85],87:[2,85],88:[2,85],89:[2,85],90:[2,85],91:[2,85],92:[2,85],93:[2,85],94:[2,85],95:[2,85],96:[2,85],97:[2,85],98:[2,85],99:[2,85],100:[2,85],101:[2,85],102:[2,85],103:[2,85],104:[2,85],105:[2,85],106:[2,85],107:[2,85],108:[2,85],109:[2,85],110:[2,85],111:[2,85],112:[2,85],113:[2,85],114:[2,85],115:[2,85],116:[2,85],117:[2,85],118:[2,85],119:[2,85],120:[2,85],121:[2,85],122:[2,85],123:[2,85],124:[2,85],125:[2,85],126:[2,85],127:[2,85],128:[2,85],129:[2,85],130:[2,85],131:[2,85],132:[2,85],134:[2,85],135:[2,85],137:[2,85],138:[2,85],140:[2,85],141:[2,85],142:[2,85],143:[2,85],144:[2,85],145:[2,85],146:[2,85],147:[2,85],148:[2,85],149:[2,85],150:[2,85],151:[2,85],152:[2,85],153:[2,85],154:[2,85],155:[2,85],156:[2,85],157:[2,85],158:[2,85],159:[2,85],160:[2,85],161:[2,85],162:[2,85],165:[2,85],166:[2,85],167:[2,85],168:[2,85],170:[2,85],171:[2,85],186:[2,85],189:[2,85],191:[2,85]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:241,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:242,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,88],8:[2,88],10:[2,88],49:[2,88],50:[2,88],51:[2,88],53:[2,88],56:[2,88],57:[2,88],58:[2,88],59:[2,88],60:[2,88],61:[2,88],62:[2,88],63:[2,88],64:[2,88],65:[2,88],66:[2,88],67:[2,88],68:[2,88],69:[2,88],70:[2,88],71:[2,88],72:[2,88],73:[2,88],74:[2,88],75:[2,88],76:[2,88],77:[2,88],78:[2,88],79:[2,88],81:[2,88],82:[2,88],83:[2,88],84:[2,88],85:[2,88],86:[2,88],87:[2,88],88:[2,88],89:[2,88],90:[2,88],91:[2,88],92:[2,88],93:[2,88],94:[2,88],95:[2,88],96:[2,88],97:[2,88],98:[2,88],99:[2,88],100:[2,88],101:[2,88],102:[2,88],103:[2,88],104:[2,88],105:[2,88],106:[2,88],107:[2,88],108:[2,88],109:[2,88],110:[2,88],111:[2,88],112:[2,88],113:[2,88],114:[2,88],115:[2,88],116:[2,88],117:[2,88],118:[2,88],119:[2,88],120:[2,88],121:[2,88],122:[2,88],123:[2,88],124:[2,88],125:[2,88],126:[2,88],127:[2,88],128:[2,88],129:[2,88],130:[2,88],131:[2,88],132:[2,88],134:[2,88],135:[2,88],137:[2,88],138:[2,88],140:[2,88],141:[2,88],142:[2,88],143:[2,88],144:[2,88],145:[2,88],146:[2,88],147:[2,88],148:[2,88],149:[2,88],150:[2,88],151:[2,88],152:[2,88],153:[2,88],154:[2,88],155:[2,88],156:[2,88],157:[2,88],158:[2,88],159:[2,88],160:[2,88],161:[2,88],162:[2,88],165:[2,88],166:[2,88],167:[2,88],168:[2,88],170:[2,88],171:[2,88],186:[2,88],189:[2,88],191:[2,88]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:243,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:244,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:245,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:246,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:247,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{6:[2,94],8:[2,94],10:[2,94],49:[2,94],50:[2,94],51:[2,94],53:[2,94],56:[2,94],57:[2,94],58:[2,94],59:[2,94],60:[2,94],61:[2,94],62:[2,94],63:[2,94],64:[2,94],65:[2,94],66:[2,94],67:[2,94],68:[2,94],69:[2,94],70:[2,94],71:[2,94],72:[2,94],73:[2,94],74:[2,94],75:[2,94],76:[2,94],77:[2,94],78:[2,94],79:[2,94],81:[2,94],82:[2,94],83:[2,94],84:[2,94],85:[2,94],86:[2,94],87:[2,94],88:[2,94],89:[2,94],90:[2,94],91:[2,94],92:[2,94],93:[2,94],94:[2,94],95:[2,94],96:[2,94],97:[2,94],98:[2,94],99:[2,94],100:[2,94],101:[2,94],102:[2,94],103:[2,94],104:[2,94],105:[2,94],106:[2,94],107:[2,94],108:[2,94],109:[2,94],110:[2,94],111:[2,94],112:[2,94],113:[2,94],114:[2,94],115:[2,94],116:[2,94],117:[2,94],118:[2,94],119:[2,94],120:[2,94],121:[2,94],122:[2,94],123:[2,94],124:[2,94],125:[2,94],126:[2,94],127:[2,94],128:[2,94],129:[2,94],130:[2,94],131:[2,94],132:[2,94],134:[2,94],135:[2,94],137:[2,94],138:[2,94],140:[2,94],141:[2,94],142:[2,94],143:[2,94],144:[2,94],145:[2,94],146:[2,94],147:[2,94],148:[2,94],149:[2,94],150:[2,94],151:[2,94],152:[2,94],153:[2,94],154:[2,94],155:[2,94],156:[2,94],157:[2,94],158:[2,94],159:[2,94],160:[2,94],161:[2,94],162:[2,94],165:[2,94],166:[2,94],167:[2,94],168:[2,94],170:[2,94],171:[2,94],186:[2,94],189:[2,94],191:[2,94]},{6:[2,95],8:[2,95],10:[2,95],49:[2,95],50:[2,95],51:[2,95],53:[2,95],56:[2,95],57:[2,95],58:[2,95],59:[2,95],60:[2,95],61:[2,95],62:[2,95],63:[2,95],64:[2,95],65:[2,95],66:[2,95],67:[2,95],68:[2,95],69:[2,95],70:[2,95],71:[2,95],72:[2,95],73:[2,95],74:[2,95],75:[2,95],76:[2,95],77:[2,95],78:[2,95],79:[2,95],81:[2,95],82:[2,95],83:[2,95],84:[2,95],85:[2,95],86:[2,95],87:[2,95],88:[2,95],89:[2,95],90:[2,95],91:[2,95],92:[2,95],93:[2,95],94:[2,95],95:[2,95],96:[2,95],97:[2,95],98:[2,95],99:[2,95],100:[2,95],101:[2,95],102:[2,95],103:[2,95],104:[2,95],105:[2,95],106:[2,95],107:[2,95],108:[2,95],109:[2,95],110:[2,95],111:[2,95],112:[2,95],113:[2,95],114:[2,95],115:[2,95],116:[2,95],117:[2,95],118:[2,95],119:[2,95],120:[2,95],121:[2,95],122:[2,95],123:[2,95],124:[2,95],125:[2,95],126:[2,95],127:[2,95],128:[2,95],129:[2,95],130:[2,95],131:[2,95],132:[2,95],134:[2,95],135:[2,95],137:[2,95],138:[2,95],140:[2,95],141:[2,95],142:[2,95],143:[2,95],144:[2,95],145:[2,95],146:[2,95],147:[2,95],148:[2,95],149:[2,95],150:[2,95],151:[2,95],152:[2,95],153:[2,95],154:[2,95],155:[2,95],156:[2,95],157:[2,95],158:[2,95],159:[2,95],160:[2,95],161:[2,95],162:[2,95],165:[2,95],166:[2,95],167:[2,95],168:[2,95],170:[2,95],171:[2,95],186:[2,95],189:[2,95],191:[2,95]},{6:[2,96],8:[2,96],10:[2,96],49:[2,96],50:[2,96],51:[2,96],53:[2,96],56:[2,96],57:[2,96],58:[2,96],59:[2,96],60:[2,96],61:[2,96],62:[2,96],63:[2,96],64:[2,96],65:[2,96],66:[2,96],67:[2,96],68:[2,96],69:[2,96],70:[2,96],71:[2,96],72:[2,96],73:[2,96],74:[2,96],75:[2,96],76:[2,96],77:[2,96],78:[2,96],79:[2,96],81:[2,96],82:[2,96],83:[2,96],84:[2,96],85:[2,96],86:[2,96],87:[2,96],88:[2,96],89:[2,96],90:[2,96],91:[2,96],92:[2,96],93:[2,96],94:[2,96],95:[2,96],96:[2,96],97:[2,96],98:[2,96],99:[2,96],100:[2,96],101:[2,96],102:[2,96],103:[2,96],104:[2,96],105:[2,96],106:[2,96],107:[2,96],108:[2,96],109:[2,96],110:[2,96],111:[2,96],112:[2,96],113:[2,96],114:[2,96],115:[2,96],116:[2,96],117:[2,96],118:[2,96],119:[2,96],120:[2,96],121:[2,96],122:[2,96],123:[2,96],124:[2,96],125:[2,96],126:[2,96],127:[2,96],128:[2,96],129:[2,96],130:[2,96],131:[2,96],132:[2,96],134:[2,96],135:[2,96],137:[2,96],138:[2,96],140:[2,96],141:[2,96],142:[2,96],143:[2,96],144:[2,96],145:[2,96],146:[2,96],147:[2,96],148:[2,96],149:[2,96],150:[2,96],151:[2,96],152:[2,96],153:[2,96],154:[2,96],155:[2,96],156:[2,96],157:[2,96],158:[2,96],159:[2,96],160:[2,96],161:[2,96],162:[2,96],165:[2,96],166:[2,96],167:[2,96],168:[2,96],170:[2,96],171:[2,96],186:[2,96],189:[2,96],191:[2,96]},{6:[2,97],8:[2,97],10:[2,97],49:[2,97],50:[2,97],51:[2,97],53:[2,97],56:[2,97],57:[2,97],58:[2,97],59:[2,97],60:[2,97],61:[2,97],62:[2,97],63:[2,97],64:[2,97],65:[2,97],66:[2,97],67:[2,97],68:[2,97],69:[2,97],70:[2,97],71:[2,97],72:[2,97],73:[2,97],74:[2,97],75:[2,97],76:[2,97],77:[2,97],78:[2,97],79:[2,97],81:[2,97],82:[2,97],83:[2,97],84:[2,97],85:[2,97],86:[2,97],87:[2,97],88:[2,97],89:[2,97],90:[2,97],91:[2,97],92:[2,97],93:[2,97],94:[2,97],95:[2,97],96:[2,97],97:[2,97],98:[2,97],99:[2,97],100:[2,97],101:[2,97],102:[2,97],103:[2,97],104:[2,97],105:[2,97],106:[2,97],107:[2,97],108:[2,97],109:[2,97],110:[2,97],111:[2,97],112:[2,97],113:[2,97],114:[2,97],115:[2,97],116:[2,97],117:[2,97],118:[2,97],119:[2,97],120:[2,97],121:[2,97],122:[2,97],123:[2,97],124:[2,97],125:[2,97],126:[2,97],127:[2,97],128:[2,97],129:[2,97],130:[2,97],131:[2,97],132:[2,97],134:[2,97],135:[2,97],137:[2,97],138:[2,97],140:[2,97],141:[2,97],142:[2,97],143:[2,97],144:[2,97],145:[2,97],146:[2,97],147:[2,97],148:[2,97],149:[2,97],150:[2,97],151:[2,97],152:[2,97],153:[2,97],154:[2,97],155:[2,97],156:[2,97],157:[2,97],158:[2,97],159:[2,97],160:[2,97],161:[2,97],162:[2,97],165:[2,97],166:[2,97],167:[2,97],168:[2,97],170:[2,97],171:[2,97],186:[2,97],189:[2,97],191:[2,97]},{6:[2,98],8:[2,98],10:[2,98],49:[2,98],50:[2,98],51:[2,98],53:[2,98],56:[2,98],57:[2,98],58:[2,98],59:[2,98],60:[2,98],61:[2,98],62:[2,98],63:[2,98],64:[2,98],65:[2,98],66:[2,98],67:[2,98],68:[2,98],69:[2,98],70:[2,98],71:[2,98],72:[2,98],73:[2,98],74:[2,98],75:[2,98],76:[2,98],77:[2,98],78:[2,98],79:[2,98],81:[2,98],82:[2,98],83:[2,98],84:[2,98],85:[2,98],86:[2,98],87:[2,98],88:[2,98],89:[2,98],90:[2,98],91:[2,98],92:[2,98],93:[2,98],94:[2,98],95:[2,98],96:[2,98],97:[2,98],98:[2,98],99:[2,98],100:[2,98],101:[2,98],102:[2,98],103:[2,98],104:[2,98],105:[2,98],106:[2,98],107:[2,98],108:[2,98],109:[2,98],110:[2,98],111:[2,98],112:[2,98],113:[2,98],114:[2,98],115:[2,98],116:[2,98],117:[2,98],118:[2,98],119:[2,98],120:[2,98],121:[2,98],122:[2,98],123:[2,98],124:[2,98],125:[2,98],126:[2,98],127:[2,98],128:[2,98],129:[2,98],130:[2,98],131:[2,98],132:[2,98],134:[2,98],135:[2,98],137:[2,98],138:[2,98],140:[2,98],141:[2,98],142:[2,98],143:[2,98],144:[2,98],145:[2,98],146:[2,98],147:[2,98],148:[2,98],149:[2,98],150:[2,98],151:[2,98],152:[2,98],153:[2,98],154:[2,98],155:[2,98],156:[2,98],157:[2,98],158:[2,98],159:[2,98],160:[2,98],161:[2,98],162:[2,98],165:[2,98],166:[2,98],167:[2,98],168:[2,98],170:[2,98],171:[2,98],186:[2,98],189:[2,98],191:[2,98]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:248,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:249,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:250,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,102],8:[2,102],10:[2,102],49:[2,102],50:[2,102],51:[2,102],53:[2,102],56:[2,102],57:[2,102],58:[2,102],59:[2,102],60:[2,102],61:[2,102],62:[2,102],63:[2,102],64:[2,102],65:[2,102],66:[2,102],67:[2,102],68:[2,102],69:[2,102],70:[2,102],71:[2,102],72:[2,102],73:[2,102],74:[2,102],75:[2,102],76:[2,102],77:[2,102],78:[2,102],79:[2,102],81:[2,102],82:[2,102],83:[2,102],84:[2,102],85:[2,102],86:[2,102],87:[2,102],88:[2,102],89:[2,102],90:[2,102],91:[2,102],92:[2,102],93:[2,102],94:[2,102],95:[2,102],96:[2,102],97:[2,102],98:[2,102],99:[2,102],100:[2,102],101:[2,102],102:[2,102],103:[2,102],104:[2,102],105:[2,102],106:[2,102],107:[2,102],108:[2,102],109:[2,102],110:[2,102],111:[2,102],112:[2,102],113:[2,102],114:[2,102],115:[2,102],116:[2,102],117:[2,102],118:[2,102],119:[2,102],120:[2,102],121:[2,102],122:[2,102],123:[2,102],124:[2,102],125:[2,102],126:[2,102],127:[2,102],128:[2,102],129:[2,102],130:[2,102],131:[2,102],132:[2,102],134:[2,102],135:[2,102],137:[2,102],138:[2,102],140:[2,102],141:[2,102],142:[2,102],143:[2,102],144:[2,102],145:[2,102],146:[2,102],147:[2,102],148:[2,102],149:[2,102],150:[2,102],151:[2,102],152:[2,102],153:[2,102],154:[2,102],155:[2,102],156:[2,102],157:[2,102],158:[2,102],159:[2,102],160:[2,102],161:[2,102],162:[2,102],165:[2,102],166:[2,102],167:[2,102],168:[2,102],170:[2,102],171:[2,102],186:[2,102],189:[2,102],191:[2,102]},{6:[2,103],8:[2,103],10:[2,103],49:[2,103],50:[2,103],51:[2,103],53:[2,103],56:[2,103],57:[2,103],58:[2,103],59:[2,103],60:[2,103],61:[2,103],62:[2,103],63:[2,103],64:[2,103],65:[2,103],66:[2,103],67:[2,103],68:[2,103],69:[2,103],70:[2,103],71:[2,103],72:[2,103],73:[2,103],74:[2,103],75:[2,103],76:[2,103],77:[2,103],78:[2,103],79:[2,103],81:[2,103],82:[2,103],83:[2,103],84:[2,103],85:[2,103],86:[2,103],87:[2,103],88:[2,103],89:[2,103],90:[2,103],91:[2,103],92:[2,103],93:[2,103],94:[2,103],95:[2,103],96:[2,103],97:[2,103],98:[2,103],99:[2,103],100:[2,103],101:[2,103],102:[2,103],103:[2,103],104:[2,103],105:[2,103],106:[2,103],107:[2,103],108:[2,103],109:[2,103],110:[2,103],111:[2,103],112:[2,103],113:[2,103],114:[2,103],115:[2,103],116:[2,103],117:[2,103],118:[2,103],119:[2,103],120:[2,103],121:[2,103],122:[2,103],123:[2,103],124:[2,103],125:[2,103],126:[2,103],127:[2,103],128:[2,103],129:[2,103],130:[2,103],131:[2,103],132:[2,103],134:[2,103],135:[2,103],137:[2,103],138:[2,103],140:[2,103],141:[2,103],142:[2,103],143:[2,103],144:[2,103],145:[2,103],146:[2,103],147:[2,103],148:[2,103],149:[2,103],150:[2,103],151:[2,103],152:[2,103],153:[2,103],154:[2,103],155:[2,103],156:[2,103],157:[2,103],158:[2,103],159:[2,103],160:[2,103],161:[2,103],162:[2,103],165:[2,103],166:[2,103],167:[2,103],168:[2,103],170:[2,103],171:[2,103],186:[2,103],189:[2,103],191:[2,103]},{6:[2,104],8:[2,104],10:[2,104],49:[2,104],50:[2,104],51:[2,104],53:[2,104],56:[2,104],57:[2,104],58:[2,104],59:[2,104],60:[2,104],61:[2,104],62:[2,104],63:[2,104],64:[2,104],65:[2,104],66:[2,104],67:[2,104],68:[2,104],69:[2,104],70:[2,104],71:[2,104],72:[2,104],73:[2,104],74:[2,104],75:[2,104],76:[2,104],77:[2,104],78:[2,104],79:[2,104],81:[2,104],82:[2,104],83:[2,104],84:[2,104],85:[2,104],86:[2,104],87:[2,104],88:[2,104],89:[2,104],90:[2,104],91:[2,104],92:[2,104],93:[2,104],94:[2,104],95:[2,104],96:[2,104],97:[2,104],98:[2,104],99:[2,104],100:[2,104],101:[2,104],102:[2,104],103:[2,104],104:[2,104],105:[2,104],106:[2,104],107:[2,104],108:[2,104],109:[2,104],110:[2,104],111:[2,104],112:[2,104],113:[2,104],114:[2,104],115:[2,104],116:[2,104],117:[2,104],118:[2,104],119:[2,104],120:[2,104],121:[2,104],122:[2,104],123:[2,104],124:[2,104],125:[2,104],126:[2,104],127:[2,104],128:[2,104],129:[2,104],130:[2,104],131:[2,104],132:[2,104],134:[2,104],135:[2,104],137:[2,104],138:[2,104],140:[2,104],141:[2,104],142:[2,104],143:[2,104],144:[2,104],145:[2,104],146:[2,104],147:[2,104],148:[2,104],149:[2,104],150:[2,104],151:[2,104],152:[2,104],153:[2,104],154:[2,104],155:[2,104],156:[2,104],157:[2,104],158:[2,104],159:[2,104],160:[2,104],161:[2,104],162:[2,104],165:[2,104],166:[2,104],167:[2,104],168:[2,104],170:[2,104],171:[2,104],186:[2,104],189:[2,104],191:[2,104]},{6:[2,105],8:[2,105],10:[2,105],49:[2,105],50:[2,105],51:[2,105],53:[2,105],56:[2,105],57:[2,105],58:[2,105],59:[2,105],60:[2,105],61:[2,105],62:[2,105],63:[2,105],64:[2,105],65:[2,105],66:[2,105],67:[2,105],68:[2,105],69:[2,105],70:[2,105],71:[2,105],72:[2,105],73:[2,105],74:[2,105],75:[2,105],76:[2,105],77:[2,105],78:[2,105],79:[2,105],81:[2,105],82:[2,105],83:[2,105],84:[2,105],85:[2,105],86:[2,105],87:[2,105],88:[2,105],89:[2,105],90:[2,105],91:[2,105],92:[2,105],93:[2,105],94:[2,105],95:[2,105],96:[2,105],97:[2,105],98:[2,105],99:[2,105],100:[2,105],101:[2,105],102:[2,105],103:[2,105],104:[2,105],105:[2,105],106:[2,105],107:[2,105],108:[2,105],109:[2,105],110:[2,105],111:[2,105],112:[2,105],113:[2,105],114:[2,105],115:[2,105],116:[2,105],117:[2,105],118:[2,105],119:[2,105],120:[2,105],121:[2,105],122:[2,105],123:[2,105],124:[2,105],125:[2,105],126:[2,105],127:[2,105],128:[2,105],129:[2,105],130:[2,105],131:[2,105],132:[2,105],134:[2,105],135:[2,105],137:[2,105],138:[2,105],140:[2,105],141:[2,105],142:[2,105],143:[2,105],144:[2,105],145:[2,105],146:[2,105],147:[2,105],148:[2,105],149:[2,105],150:[2,105],151:[2,105],152:[2,105],153:[2,105],154:[2,105],155:[2,105],156:[2,105],157:[2,105],158:[2,105],159:[2,105],160:[2,105],161:[2,105],162:[2,105],165:[2,105],166:[2,105],167:[2,105],168:[2,105],170:[2,105],171:[2,105],186:[2,105],189:[2,105],191:[2,105]},{6:[2,106],8:[2,106],10:[2,106],49:[2,106],50:[2,106],51:[2,106],53:[2,106],56:[2,106],57:[2,106],58:[2,106],59:[2,106],60:[2,106],61:[2,106],62:[2,106],63:[2,106],64:[2,106],65:[2,106],66:[2,106],67:[2,106],68:[2,106],69:[2,106],70:[2,106],71:[2,106],72:[2,106],73:[2,106],74:[2,106],75:[2,106],76:[2,106],77:[2,106],78:[2,106],79:[2,106],81:[2,106],82:[2,106],83:[2,106],84:[2,106],85:[2,106],86:[2,106],87:[2,106],88:[2,106],89:[2,106],90:[2,106],91:[2,106],92:[2,106],93:[2,106],94:[2,106],95:[2,106],96:[2,106],97:[2,106],98:[2,106],99:[2,106],100:[2,106],101:[2,106],102:[2,106],103:[2,106],104:[2,106],105:[2,106],106:[2,106],107:[2,106],108:[2,106],109:[2,106],110:[2,106],111:[2,106],112:[2,106],113:[2,106],114:[2,106],115:[2,106],116:[2,106],117:[2,106],118:[2,106],119:[2,106],120:[2,106],121:[2,106],122:[2,106],123:[2,106],124:[2,106],125:[2,106],126:[2,106],127:[2,106],128:[2,106],129:[2,106],130:[2,106],131:[2,106],132:[2,106],134:[2,106],135:[2,106],137:[2,106],138:[2,106],140:[2,106],141:[2,106],142:[2,106],143:[2,106],144:[2,106],145:[2,106],146:[2,106],147:[2,106],148:[2,106],149:[2,106],150:[2,106],151:[2,106],152:[2,106],153:[2,106],154:[2,106],155:[2,106],156:[2,106],157:[2,106],158:[2,106],159:[2,106],160:[2,106],161:[2,106],162:[2,106],165:[2,106],166:[2,106],167:[2,106],168:[2,106],170:[2,106],171:[2,106],186:[2,106],189:[2,106],191:[2,106]},{6:[2,107],8:[2,107],10:[2,107],49:[2,107],50:[2,107],51:[2,107],53:[2,107],56:[2,107],57:[2,107],58:[2,107],59:[2,107],60:[2,107],61:[2,107],62:[2,107],63:[2,107],64:[2,107],65:[2,107],66:[2,107],67:[2,107],68:[2,107],69:[2,107],70:[2,107],71:[2,107],72:[2,107],73:[2,107],74:[2,107],75:[2,107],76:[2,107],77:[2,107],78:[2,107],79:[2,107],81:[2,107],82:[2,107],83:[2,107],84:[2,107],85:[2,107],86:[2,107],87:[2,107],88:[2,107],89:[2,107],90:[2,107],91:[2,107],92:[2,107],93:[2,107],94:[2,107],95:[2,107],96:[2,107],97:[2,107],98:[2,107],99:[2,107],100:[2,107],101:[2,107],102:[2,107],103:[2,107],104:[2,107],105:[2,107],106:[2,107],107:[2,107],108:[2,107],109:[2,107],110:[2,107],111:[2,107],112:[2,107],113:[2,107],114:[2,107],115:[2,107],116:[2,107],117:[2,107],118:[2,107],119:[2,107],120:[2,107],121:[2,107],122:[2,107],123:[2,107],124:[2,107],125:[2,107],126:[2,107],127:[2,107],128:[2,107],129:[2,107],130:[2,107],131:[2,107],132:[2,107],134:[2,107],135:[2,107],137:[2,107],138:[2,107],140:[2,107],141:[2,107],142:[2,107],143:[2,107],144:[2,107],145:[2,107],146:[2,107],147:[2,107],148:[2,107],149:[2,107],150:[2,107],151:[2,107],152:[2,107],153:[2,107],154:[2,107],155:[2,107],156:[2,107],157:[2,107],158:[2,107],159:[2,107],160:[2,107],161:[2,107],162:[2,107],165:[2,107],166:[2,107],167:[2,107],168:[2,107],170:[2,107],171:[2,107],186:[2,107],189:[2,107],191:[2,107]},{6:[2,108],8:[2,108],10:[2,108],49:[2,108],50:[2,108],51:[2,108],53:[2,108],56:[2,108],57:[2,108],58:[2,108],59:[2,108],60:[2,108],61:[2,108],62:[2,108],63:[2,108],64:[2,108],65:[2,108],66:[2,108],67:[2,108],68:[2,108],69:[2,108],70:[2,108],71:[2,108],72:[2,108],73:[2,108],74:[2,108],75:[2,108],76:[2,108],77:[2,108],78:[2,108],79:[2,108],81:[2,108],82:[2,108],83:[2,108],84:[2,108],85:[2,108],86:[2,108],87:[2,108],88:[2,108],89:[2,108],90:[2,108],91:[2,108],92:[2,108],93:[2,108],94:[2,108],95:[2,108],96:[2,108],97:[2,108],98:[2,108],99:[2,108],100:[2,108],101:[2,108],102:[2,108],103:[2,108],104:[2,108],105:[2,108],106:[2,108],107:[2,108],108:[2,108],109:[2,108],110:[2,108],111:[2,108],112:[2,108],113:[2,108],114:[2,108],115:[2,108],116:[2,108],117:[2,108],118:[2,108],119:[2,108],120:[2,108],121:[2,108],122:[2,108],123:[2,108],124:[2,108],125:[2,108],126:[2,108],127:[2,108],128:[2,108],129:[2,108],130:[2,108],131:[2,108],132:[2,108],134:[2,108],135:[2,108],137:[2,108],138:[2,108],140:[2,108],141:[2,108],142:[2,108],143:[2,108],144:[2,108],145:[2,108],146:[2,108],147:[2,108],148:[2,108],149:[2,108],150:[2,108],151:[2,108],152:[2,108],153:[2,108],154:[2,108],155:[2,108],156:[2,108],157:[2,108],158:[2,108],159:[2,108],160:[2,108],161:[2,108],162:[2,108],165:[2,108],166:[2,108],167:[2,108],168:[2,108],170:[2,108],171:[2,108],186:[2,108],189:[2,108],191:[2,108]},{6:[2,109],8:[2,109],10:[2,109],49:[2,109],50:[2,109],51:[2,109],53:[2,109],56:[2,109],57:[2,109],58:[2,109],59:[2,109],60:[2,109],61:[2,109],62:[2,109],63:[2,109],64:[2,109],65:[2,109],66:[2,109],67:[2,109],68:[2,109],69:[2,109],70:[2,109],71:[2,109],72:[2,109],73:[2,109],74:[2,109],75:[2,109],76:[2,109],77:[2,109],78:[2,109],79:[2,109],81:[2,109],82:[2,109],83:[2,109],84:[2,109],85:[2,109],86:[2,109],87:[2,109],88:[2,109],89:[2,109],90:[2,109],91:[2,109],92:[2,109],93:[2,109],94:[2,109],95:[2,109],96:[2,109],97:[2,109],98:[2,109],99:[2,109],100:[2,109],101:[2,109],102:[2,109],103:[2,109],104:[2,109],105:[2,109],106:[2,109],107:[2,109],108:[2,109],109:[2,109],110:[2,109],111:[2,109],112:[2,109],113:[2,109],114:[2,109],115:[2,109],116:[2,109],117:[2,109],118:[2,109],119:[2,109],120:[2,109],121:[2,109],122:[2,109],123:[2,109],124:[2,109],125:[2,109],126:[2,109],127:[2,109],128:[2,109],129:[2,109],130:[2,109],131:[2,109],132:[2,109],134:[2,109],135:[2,109],137:[2,109],138:[2,109],140:[2,109],141:[2,109],142:[2,109],143:[2,109],144:[2,109],145:[2,109],146:[2,109],147:[2,109],148:[2,109],149:[2,109],150:[2,109],151:[2,109],152:[2,109],153:[2,109],154:[2,109],155:[2,109],156:[2,109],157:[2,109],158:[2,109],159:[2,109],160:[2,109],161:[2,109],162:[2,109],165:[2,109],166:[2,109],167:[2,109],168:[2,109],170:[2,109],171:[2,109],186:[2,109],189:[2,109],191:[2,109]},{7:251,8:[1,117]},{4:[1,254],8:[1,18],11:252,48:27,49:[1,111],50:[1,39],51:[1,35],54:253,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{9:[1,255]},{6:[2,122],8:[2,122],10:[2,122],49:[2,122],50:[2,122],51:[2,122],53:[2,122],56:[2,122],57:[2,122],58:[2,122],59:[2,122],60:[2,122],61:[2,122],62:[2,122],63:[2,122],64:[2,122],65:[2,122],66:[2,122],67:[2,122],68:[2,122],69:[2,122],70:[2,122],71:[2,122],72:[2,122],73:[2,122],74:[2,122],75:[2,122],76:[2,122],77:[2,122],78:[2,122],79:[2,122],81:[2,122],82:[2,122],83:[2,122],84:[2,122],85:[2,122],86:[2,122],87:[2,122],88:[2,122],89:[2,122],90:[2,122],91:[2,122],92:[2,122],93:[2,122],94:[2,122],95:[2,122],96:[2,122],97:[2,122],98:[2,122],99:[2,122],100:[2,122],101:[2,122],102:[2,122],103:[2,122],104:[2,122],105:[2,122],106:[2,122],107:[2,122],108:[2,122],109:[2,122],110:[2,122],111:[2,122],112:[2,122],113:[2,122],114:[2,122],115:[2,122],116:[2,122],117:[2,122],118:[2,122],119:[2,122],120:[2,122],121:[2,122],122:[2,122],123:[2,122],124:[2,122],125:[2,122],126:[2,122],127:[2,122],128:[2,122],129:[2,122],130:[2,122],131:[2,122],132:[2,122],134:[2,122],135:[2,122],137:[2,122],138:[2,122],140:[2,122],141:[2,122],142:[2,122],143:[2,122],144:[2,122],145:[2,122],146:[2,122],147:[2,122],148:[2,122],149:[2,122],150:[2,122],151:[2,122],152:[2,122],153:[2,122],154:[2,122],155:[2,122],156:[2,122],157:[2,122],158:[2,122],159:[2,122],160:[2,122],161:[2,122],162:[2,122],165:[2,122],166:[2,122],167:[2,122],168:[2,122],170:[2,122],171:[2,122],186:[2,122],189:[2,122],191:[2,122]},{6:[2,123],8:[2,123],10:[2,123],49:[2,123],50:[2,123],51:[2,123],53:[2,123],56:[2,123],57:[2,123],58:[2,123],59:[2,123],60:[2,123],61:[2,123],62:[2,123],63:[2,123],64:[2,123],65:[2,123],66:[2,123],67:[2,123],68:[2,123],69:[2,123],70:[2,123],71:[2,123],72:[2,123],73:[2,123],74:[2,123],75:[2,123],76:[2,123],77:[2,123],78:[2,123],79:[2,123],81:[2,123],82:[2,123],83:[2,123],84:[2,123],85:[2,123],86:[2,123],87:[2,123],88:[2,123],89:[2,123],90:[2,123],91:[2,123],92:[2,123],93:[2,123],94:[2,123],95:[2,123],96:[2,123],97:[2,123],98:[2,123],99:[2,123],100:[2,123],101:[2,123],102:[2,123],103:[2,123],104:[2,123],105:[2,123],106:[2,123],107:[2,123],108:[2,123],109:[2,123],110:[2,123],111:[2,123],112:[2,123],113:[2,123],114:[2,123],115:[2,123],116:[2,123],117:[2,123],118:[2,123],119:[2,123],120:[2,123],121:[2,123],122:[2,123],123:[2,123],124:[2,123],125:[2,123],126:[2,123],127:[2,123],128:[2,123],129:[2,123],130:[2,123],131:[2,123],132:[2,123],134:[2,123],135:[2,123],137:[2,123],138:[2,123],140:[2,123],141:[2,123],142:[2,123],143:[2,123],144:[2,123],145:[2,123],146:[2,123],147:[2,123],148:[2,123],149:[2,123],150:[2,123],151:[2,123],152:[2,123],153:[2,123],154:[2,123],155:[2,123],156:[2,123],157:[2,123],158:[2,123],159:[2,123],160:[2,123],161:[2,123],162:[2,123],165:[2,123],166:[2,123],167:[2,123],168:[2,123],170:[2,123],171:[2,123],186:[2,123],189:[2,123],191:[2,123]},{6:[2,124],8:[2,124],10:[2,124],49:[2,124],50:[2,124],51:[2,124],53:[2,124],56:[2,124],57:[2,124],58:[2,124],59:[2,124],60:[2,124],61:[2,124],62:[2,124],63:[2,124],64:[2,124],65:[2,124],66:[2,124],67:[2,124],68:[2,124],69:[2,124],70:[2,124],71:[2,124],72:[2,124],73:[2,124],74:[2,124],75:[2,124],76:[2,124],77:[2,124],78:[2,124],79:[2,124],81:[2,124],82:[2,124],83:[2,124],84:[2,124],85:[2,124],86:[2,124],87:[2,124],88:[2,124],89:[2,124],90:[2,124],91:[2,124],92:[2,124],93:[2,124],94:[2,124],95:[2,124],96:[2,124],97:[2,124],98:[2,124],99:[2,124],100:[2,124],101:[2,124],102:[2,124],103:[2,124],104:[2,124],105:[2,124],106:[2,124],107:[2,124],108:[2,124],109:[2,124],110:[2,124],111:[2,124],112:[2,124],113:[2,124],114:[2,124],115:[2,124],116:[2,124],117:[2,124],118:[2,124],119:[2,124],120:[2,124],121:[2,124],122:[2,124],123:[2,124],124:[2,124],125:[2,124],126:[2,124],127:[2,124],128:[2,124],129:[2,124],130:[2,124],131:[2,124],132:[2,124],134:[2,124],135:[2,124],137:[2,124],138:[2,124],140:[2,124],141:[2,124],142:[2,124],143:[2,124],144:[2,124],145:[2,124],146:[2,124],147:[2,124],148:[2,124],149:[2,124],150:[2,124],151:[2,124],152:[2,124],153:[2,124],154:[2,124],155:[2,124],156:[2,124],157:[2,124],158:[2,124],159:[2,124],160:[2,124],161:[2,124],162:[2,124],165:[2,124],166:[2,124],167:[2,124],168:[2,124],170:[2,124],171:[2,124],186:[2,124],189:[2,124],191:[2,124]},{6:[2,125],8:[2,125],10:[2,125],49:[2,125],50:[2,125],51:[2,125],53:[2,125],56:[2,125],57:[2,125],58:[2,125],59:[2,125],60:[2,125],61:[2,125],62:[2,125],63:[2,125],64:[2,125],65:[2,125],66:[2,125],67:[2,125],68:[2,125],69:[2,125],70:[2,125],71:[2,125],72:[2,125],73:[2,125],74:[2,125],75:[2,125],76:[2,125],77:[2,125],78:[2,125],79:[2,125],81:[2,125],82:[2,125],83:[2,125],84:[2,125],85:[2,125],86:[2,125],87:[2,125],88:[2,125],89:[2,125],90:[2,125],91:[2,125],92:[2,125],93:[2,125],94:[2,125],95:[2,125],96:[2,125],97:[2,125],98:[2,125],99:[2,125],100:[2,125],101:[2,125],102:[2,125],103:[2,125],104:[2,125],105:[2,125],106:[2,125],107:[2,125],108:[2,125],109:[2,125],110:[2,125],111:[2,125],112:[2,125],113:[2,125],114:[2,125],115:[2,125],116:[2,125],117:[2,125],118:[2,125],119:[2,125],120:[2,125],121:[2,125],122:[2,125],123:[2,125],124:[2,125],125:[2,125],126:[2,125],127:[2,125],128:[2,125],129:[2,125],130:[2,125],131:[2,125],132:[2,125],134:[2,125],135:[2,125],137:[2,125],138:[2,125],140:[2,125],141:[2,125],142:[2,125],143:[2,125],144:[2,125],145:[2,125],146:[2,125],147:[2,125],148:[2,125],149:[2,125],150:[2,125],151:[2,125],152:[2,125],153:[2,125],154:[2,125],155:[2,125],156:[2,125],157:[2,125],158:[2,125],159:[2,125],160:[2,125],161:[2,125],162:[2,125],165:[2,125],166:[2,125],167:[2,125],168:[2,125],170:[2,125],171:[2,125],186:[2,125],189:[2,125],191:[2,125]},{6:[2,126],8:[2,126],10:[2,126],49:[2,126],50:[2,126],51:[2,126],53:[2,126],56:[2,126],57:[2,126],58:[2,126],59:[2,126],60:[2,126],61:[2,126],62:[2,126],63:[2,126],64:[2,126],65:[2,126],66:[2,126],67:[2,126],68:[2,126],69:[2,126],70:[2,126],71:[2,126],72:[2,126],73:[2,126],74:[2,126],75:[2,126],76:[2,126],77:[2,126],78:[2,126],79:[2,126],81:[2,126],82:[2,126],83:[2,126],84:[2,126],85:[2,126],86:[2,126],87:[2,126],88:[2,126],89:[2,126],90:[2,126],91:[2,126],92:[2,126],93:[2,126],94:[2,126],95:[2,126],96:[2,126],97:[2,126],98:[2,126],99:[2,126],100:[2,126],101:[2,126],102:[2,126],103:[2,126],104:[2,126],105:[2,126],106:[2,126],107:[2,126],108:[2,126],109:[2,126],110:[2,126],111:[2,126],112:[2,126],113:[2,126],114:[2,126],115:[2,126],116:[2,126],117:[2,126],118:[2,126],119:[2,126],120:[2,126],121:[2,126],122:[2,126],123:[2,126],124:[2,126],125:[2,126],126:[2,126],127:[2,126],128:[2,126],129:[2,126],130:[2,126],131:[2,126],132:[2,126],134:[2,126],135:[2,126],137:[2,126],138:[2,126],140:[2,126],141:[2,126],142:[2,126],143:[2,126],144:[2,126],145:[2,126],146:[2,126],147:[2,126],148:[2,126],149:[2,126],150:[2,126],151:[2,126],152:[2,126],153:[2,126],154:[2,126],155:[2,126],156:[2,126],157:[2,126],158:[2,126],159:[2,126],160:[2,126],161:[2,126],162:[2,126],165:[2,126],166:[2,126],167:[2,126],168:[2,126],170:[2,126],171:[2,126],186:[2,126],189:[2,126],191:[2,126]},{6:[2,127],8:[2,127],10:[2,127],49:[2,127],50:[2,127],51:[2,127],53:[2,127],56:[2,127],57:[2,127],58:[2,127],59:[2,127],60:[2,127],61:[2,127],62:[2,127],63:[2,127],64:[2,127],65:[2,127],66:[2,127],67:[2,127],68:[2,127],69:[2,127],70:[2,127],71:[2,127],72:[2,127],73:[2,127],74:[2,127],75:[2,127],76:[2,127],77:[2,127],78:[2,127],79:[2,127],81:[2,127],82:[2,127],83:[2,127],84:[2,127],85:[2,127],86:[2,127],87:[2,127],88:[2,127],89:[2,127],90:[2,127],91:[2,127],92:[2,127],93:[2,127],94:[2,127],95:[2,127],96:[2,127],97:[2,127],98:[2,127],99:[2,127],100:[2,127],101:[2,127],102:[2,127],103:[2,127],104:[2,127],105:[2,127],106:[2,127],107:[2,127],108:[2,127],109:[2,127],110:[2,127],111:[2,127],112:[2,127],113:[2,127],114:[2,127],115:[2,127],116:[2,127],117:[2,127],118:[2,127],119:[2,127],120:[2,127],121:[2,127],122:[2,127],123:[2,127],124:[2,127],125:[2,127],126:[2,127],127:[2,127],128:[2,127],129:[2,127],130:[2,127],131:[2,127],132:[2,127],134:[2,127],135:[2,127],137:[2,127],138:[2,127],140:[2,127],141:[2,127],142:[2,127],143:[2,127],144:[2,127],145:[2,127],146:[2,127],147:[2,127],148:[2,127],149:[2,127],150:[2,127],151:[2,127],152:[2,127],153:[2,127],154:[2,127],155:[2,127],156:[2,127],157:[2,127],158:[2,127],159:[2,127],160:[2,127],161:[2,127],162:[2,127],165:[2,127],166:[2,127],167:[2,127],168:[2,127],170:[2,127],171:[2,127],186:[2,127],189:[2,127],191:[2,127]},{6:[2,128],8:[2,128],10:[2,128],49:[2,128],50:[2,128],51:[2,128],53:[2,128],56:[2,128],57:[2,128],58:[2,128],59:[2,128],60:[2,128],61:[2,128],62:[2,128],63:[2,128],64:[2,128],65:[2,128],66:[2,128],67:[2,128],68:[2,128],69:[2,128],70:[2,128],71:[2,128],72:[2,128],73:[2,128],74:[2,128],75:[2,128],76:[2,128],77:[2,128],78:[2,128],79:[2,128],81:[2,128],82:[2,128],83:[2,128],84:[2,128],85:[2,128],86:[2,128],87:[2,128],88:[2,128],89:[2,128],90:[2,128],91:[2,128],92:[2,128],93:[2,128],94:[2,128],95:[2,128],96:[2,128],97:[2,128],98:[2,128],99:[2,128],100:[2,128],101:[2,128],102:[2,128],103:[2,128],104:[2,128],105:[2,128],106:[2,128],107:[2,128],108:[2,128],109:[2,128],110:[2,128],111:[2,128],112:[2,128],113:[2,128],114:[2,128],115:[2,128],116:[2,128],117:[2,128],118:[2,128],119:[2,128],120:[2,128],121:[2,128],122:[2,128],123:[2,128],124:[2,128],125:[2,128],126:[2,128],127:[2,128],128:[2,128],129:[2,128],130:[2,128],131:[2,128],132:[2,128],134:[2,128],135:[2,128],137:[2,128],138:[2,128],140:[2,128],141:[2,128],142:[2,128],143:[2,128],144:[2,128],145:[2,128],146:[2,128],147:[2,128],148:[2,128],149:[2,128],150:[2,128],151:[2,128],152:[2,128],153:[2,128],154:[2,128],155:[2,128],156:[2,128],157:[2,128],158:[2,128],159:[2,128],160:[2,128],161:[2,128],162:[2,128],165:[2,128],166:[2,128],167:[2,128],168:[2,128],170:[2,128],171:[2,128],186:[2,128],189:[2,128],191:[2,128]},{6:[2,129],8:[2,129],10:[2,129],49:[2,129],50:[2,129],51:[2,129],53:[2,129],56:[2,129],57:[2,129],58:[2,129],59:[2,129],60:[2,129],61:[2,129],62:[2,129],63:[2,129],64:[2,129],65:[2,129],66:[2,129],67:[2,129],68:[2,129],69:[2,129],70:[2,129],71:[2,129],72:[2,129],73:[2,129],74:[2,129],75:[2,129],76:[2,129],77:[2,129],78:[2,129],79:[2,129],81:[2,129],82:[2,129],83:[2,129],84:[2,129],85:[2,129],86:[2,129],87:[2,129],88:[2,129],89:[2,129],90:[2,129],91:[2,129],92:[2,129],93:[2,129],94:[2,129],95:[2,129],96:[2,129],97:[2,129],98:[2,129],99:[2,129],100:[2,129],101:[2,129],102:[2,129],103:[2,129],104:[2,129],105:[2,129],106:[2,129],107:[2,129],108:[2,129],109:[2,129],110:[2,129],111:[2,129],112:[2,129],113:[2,129],114:[2,129],115:[2,129],116:[2,129],117:[2,129],118:[2,129],119:[2,129],120:[2,129],121:[2,129],122:[2,129],123:[2,129],124:[2,129],125:[2,129],126:[2,129],127:[2,129],128:[2,129],129:[2,129],130:[2,129],131:[2,129],132:[2,129],134:[2,129],135:[2,129],137:[2,129],138:[2,129],140:[2,129],141:[2,129],142:[2,129],143:[2,129],144:[2,129],145:[2,129],146:[2,129],147:[2,129],148:[2,129],149:[2,129],150:[2,129],151:[2,129],152:[2,129],153:[2,129],154:[2,129],155:[2,129],156:[2,129],157:[2,129],158:[2,129],159:[2,129],160:[2,129],161:[2,129],162:[2,129],165:[2,129],166:[2,129],167:[2,129],168:[2,129],170:[2,129],171:[2,129],186:[2,129],189:[2,129],191:[2,129]},{6:[2,130],8:[2,130],10:[2,130],49:[2,130],50:[2,130],51:[2,130],53:[2,130],56:[2,130],57:[2,130],58:[2,130],59:[2,130],60:[2,130],61:[2,130],62:[2,130],63:[2,130],64:[2,130],65:[2,130],66:[2,130],67:[2,130],68:[2,130],69:[2,130],70:[2,130],71:[2,130],72:[2,130],73:[2,130],74:[2,130],75:[2,130],76:[2,130],77:[2,130],78:[2,130],79:[2,130],81:[2,130],82:[2,130],83:[2,130],84:[2,130],85:[2,130],86:[2,130],87:[2,130],88:[2,130],89:[2,130],90:[2,130],91:[2,130],92:[2,130],93:[2,130],94:[2,130],95:[2,130],96:[2,130],97:[2,130],98:[2,130],99:[2,130],100:[2,130],101:[2,130],102:[2,130],103:[2,130],104:[2,130],105:[2,130],106:[2,130],107:[2,130],108:[2,130],109:[2,130],110:[2,130],111:[2,130],112:[2,130],113:[2,130],114:[2,130],115:[2,130],116:[2,130],117:[2,130],118:[2,130],119:[2,130],120:[2,130],121:[2,130],122:[2,130],123:[2,130],124:[2,130],125:[2,130],126:[2,130],127:[2,130],128:[2,130],129:[2,130],130:[2,130],131:[2,130],132:[2,130],134:[2,130],135:[2,130],137:[2,130],138:[2,130],140:[2,130],141:[2,130],142:[2,130],143:[2,130],144:[2,130],145:[2,130],146:[2,130],147:[2,130],148:[2,130],149:[2,130],150:[2,130],151:[2,130],152:[2,130],153:[2,130],154:[2,130],155:[2,130],156:[2,130],157:[2,130],158:[2,130],159:[2,130],160:[2,130],161:[2,130],162:[2,130],165:[2,130],166:[2,130],167:[2,130],168:[2,130],170:[2,130],171:[2,130],186:[2,130],189:[2,130],191:[2,130]},{6:[2,131],8:[2,131],10:[2,131],49:[2,131],50:[2,131],51:[2,131],53:[2,131],56:[2,131],57:[2,131],58:[2,131],59:[2,131],60:[2,131],61:[2,131],62:[2,131],63:[2,131],64:[2,131],65:[2,131],66:[2,131],67:[2,131],68:[2,131],69:[2,131],70:[2,131],71:[2,131],72:[2,131],73:[2,131],74:[2,131],75:[2,131],76:[2,131],77:[2,131],78:[2,131],79:[2,131],81:[2,131],82:[2,131],83:[2,131],84:[2,131],85:[2,131],86:[2,131],87:[2,131],88:[2,131],89:[2,131],90:[2,131],91:[2,131],92:[2,131],93:[2,131],94:[2,131],95:[2,131],96:[2,131],97:[2,131],98:[2,131],99:[2,131],100:[2,131],101:[2,131],102:[2,131],103:[2,131],104:[2,131],105:[2,131],106:[2,131],107:[2,131],108:[2,131],109:[2,131],110:[2,131],111:[2,131],112:[2,131],113:[2,131],114:[2,131],115:[2,131],116:[2,131],117:[2,131],118:[2,131],119:[2,131],120:[2,131],121:[2,131],122:[2,131],123:[2,131],124:[2,131],125:[2,131],126:[2,131],127:[2,131],128:[2,131],129:[2,131],130:[2,131],131:[2,131],132:[2,131],134:[2,131],135:[2,131],137:[2,131],138:[2,131],140:[2,131],141:[2,131],142:[2,131],143:[2,131],144:[2,131],145:[2,131],146:[2,131],147:[2,131],148:[2,131],149:[2,131],150:[2,131],151:[2,131],152:[2,131],153:[2,131],154:[2,131],155:[2,131],156:[2,131],157:[2,131],158:[2,131],159:[2,131],160:[2,131],161:[2,131],162:[2,131],165:[2,131],166:[2,131],167:[2,131],168:[2,131],170:[2,131],171:[2,131],186:[2,131],189:[2,131],191:[2,131]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:256,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:257,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:258,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:259,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:261,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],134:[1,260],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[2,156],49:[2,156],50:[2,156],51:[2,156],56:[2,156],57:[2,156],58:[2,156],59:[2,156],60:[2,156],61:[2,156],62:[2,156],63:[2,156],67:[2,156],68:[2,156],69:[2,156],70:[2,156],71:[2,156],72:[2,156],73:[2,156],74:[2,156],75:[2,156],76:[2,156],77:[2,156],78:[2,156],79:[2,156],81:[2,156],82:[2,156],83:[2,156],84:[2,156],85:[2,156],86:[2,156],87:[2,156],88:[2,156],89:[2,156],90:[2,156],91:[2,156],92:[2,156],93:[2,156],94:[2,156],95:[2,156],96:[2,156],97:[2,156],98:[2,156],99:[2,156],100:[2,156],101:[2,156],102:[2,156],103:[2,156],104:[2,156],105:[2,156],106:[2,156],107:[2,156],108:[2,156],109:[2,156],110:[2,156],111:[2,156],112:[2,156],113:[2,156],114:[2,156],115:[2,156],116:[2,156],117:[2,156],118:[2,156],119:[2,156],120:[2,156],121:[2,156],122:[2,156],123:[2,156],124:[2,156],125:[2,156],126:[2,156],127:[2,156],128:[2,156],129:[2,156],130:[2,156],131:[2,156],132:[2,156],134:[2,156],135:[2,156],137:[2,156],138:[2,156],141:[2,156],143:[2,156],145:[2,156],147:[2,156],149:[2,156],151:[2,156],153:[2,156],155:[2,156],157:[2,156],159:[2,156],161:[2,156],162:[2,156]},{10:[1,263],136:262,165:[1,223],166:[1,224],174:222},{140:[1,264],189:[1,265]},{10:[2,200],140:[2,200],142:[2,200],144:[2,200],146:[2,200],148:[2,200],150:[2,200],152:[2,200],154:[2,200],156:[2,200],158:[2,200],160:[2,200],189:[2,200]},{8:[1,266]},{10:[2,199],140:[2,199],142:[2,199],144:[2,199],146:[2,199],148:[2,199],150:[2,199],152:[2,199],154:[2,199],156:[2,199],158:[2,199],160:[2,199],186:[1,267],189:[2,199]},{10:[2,196],140:[2,196],142:[2,196],144:[2,196],146:[2,196],148:[2,196],150:[2,196],152:[2,196],154:[2,196],156:[2,196],158:[2,196],160:[2,196],186:[2,196],189:[2,196]},{8:[1,268]},{10:[2,195],140:[2,195],142:[2,195],144:[2,195],146:[2,195],148:[2,195],150:[2,195],152:[2,195],154:[2,195],156:[2,195],158:[2,195],160:[2,195],186:[2,195],189:[2,195]},{142:[1,269],189:[1,265]},{144:[1,270],189:[1,265]},{146:[1,271],189:[1,265]},{148:[1,272],189:[1,265]},{150:[1,273],189:[1,265]},{152:[1,274],189:[1,265]},{154:[1,275],189:[1,265]},{156:[1,276],189:[1,265]},{158:[1,277],189:[1,265]},{7:214,8:[1,117],17:278},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:279,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],160:[2,193],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[2,8]},{8:[2,9],49:[2,9],50:[2,9],51:[2,9],56:[2,9],57:[2,9],58:[2,9],59:[2,9],60:[2,9],61:[2,9],62:[2,9],63:[2,9],67:[2,9],68:[2,9],69:[2,9],70:[2,9],71:[2,9],72:[2,9],73:[2,9],74:[2,9],75:[2,9],76:[2,9],77:[2,9],78:[2,9],79:[2,9],81:[2,9],82:[2,9],83:[2,9],84:[2,9],85:[2,9],86:[2,9],87:[2,9],88:[2,9],89:[2,9],90:[2,9],91:[2,9],92:[2,9],93:[2,9],94:[2,9],95:[2,9],96:[2,9],97:[2,9],98:[2,9],99:[2,9],100:[2,9],101:[2,9],102:[2,9],103:[2,9],104:[2,9],105:[2,9],106:[2,9],107:[2,9],108:[2,9],109:[2,9],110:[2,9],111:[2,9],112:[2,9],113:[2,9],114:[2,9],115:[2,9],116:[2,9],117:[2,9],118:[2,9],119:[2,9],120:[2,9],121:[2,9],122:[2,9],123:[2,9],124:[2,9],125:[2,9],126:[2,9],127:[2,9],128:[2,9],129:[2,9],130:[2,9],131:[2,9],132:[2,9],135:[2,9],137:[2,9],138:[2,9],141:[2,9],143:[2,9],145:[2,9],147:[2,9],149:[2,9],151:[2,9],153:[2,9],155:[2,9],157:[2,9],159:[2,9],160:[2,9],161:[2,9],162:[2,9],167:[2,9],170:[2,9],171:[2,9],176:[2,9],177:[2,9],178:[2,9],179:[2,9],180:[2,9],181:[2,9],182:[2,9],184:[2,9],186:[2,9],188:[2,9],189:[2,9]},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:280,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:281,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],163:[1,282],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{8:[2,44],49:[2,44],50:[2,44],51:[2,44],56:[2,44],57:[2,44],58:[2,44],59:[2,44],60:[2,44],61:[2,44],62:[2,44],63:[2,44],67:[2,44],68:[2,44],69:[2,44],70:[2,44],71:[2,44],72:[2,44],73:[2,44],74:[2,44],75:[2,44],76:[2,44],77:[2,44],78:[2,44],79:[2,44],81:[2,44],82:[2,44],83:[2,44],84:[2,44],85:[2,44],86:[2,44],87:[2,44],88:[2,44],89:[2,44],90:[2,44],91:[2,44],92:[2,44],93:[2,44],94:[2,44],95:[2,44],96:[2,44],97:[2,44],98:[2,44],99:[2,44],100:[2,44],101:[2,44],102:[2,44],103:[2,44],104:[2,44],105:[2,44],106:[2,44],107:[2,44],108:[2,44],109:[2,44],110:[2,44],111:[2,44],112:[2,44],113:[2,44],114:[2,44],115:[2,44],116:[2,44],117:[2,44],118:[2,44],119:[2,44],120:[2,44],121:[2,44],122:[2,44],123:[2,44],124:[2,44],125:[2,44],126:[2,44],127:[2,44],128:[2,44],129:[2,44],130:[2,44],131:[2,44],132:[2,44],135:[2,44],137:[2,44],138:[2,44],141:[2,44],143:[2,44],145:[2,44],147:[2,44],149:[2,44],151:[2,44],153:[2,44],155:[2,44],157:[2,44],159:[2,44],161:[2,44],162:[2,44],167:[2,44],170:[2,44],171:[2,44],176:[2,44],177:[2,44],178:[2,44],179:[2,44],180:[2,44],181:[2,44],182:[2,44]},{8:[2,45],49:[2,45],50:[2,45],51:[2,45],56:[2,45],57:[2,45],58:[2,45],59:[2,45],60:[2,45],61:[2,45],62:[2,45],63:[2,45],67:[2,45],68:[2,45],69:[2,45],70:[2,45],71:[2,45],72:[2,45],73:[2,45],74:[2,45],75:[2,45],76:[2,45],77:[2,45],78:[2,45],79:[2,45],81:[2,45],82:[2,45],83:[2,45],84:[2,45],85:[2,45],86:[2,45],87:[2,45],88:[2,45],89:[2,45],90:[2,45],91:[2,45],92:[2,45],93:[2,45],94:[2,45],95:[2,45],96:[2,45],97:[2,45],98:[2,45],99:[2,45],100:[2,45],101:[2,45],102:[2,45],103:[2,45],104:[2,45],105:[2,45],106:[2,45],107:[2,45],108:[2,45],109:[2,45],110:[2,45],111:[2,45],112:[2,45],113:[2,45],114:[2,45],115:[2,45],116:[2,45],117:[2,45],118:[2,45],119:[2,45],120:[2,45],121:[2,45],122:[2,45],123:[2,45],124:[2,45],125:[2,45],126:[2,45],127:[2,45],128:[2,45],129:[2,45],130:[2,45],131:[2,45],132:[2,45],135:[2,45],137:[2,45],138:[2,45],141:[2,45],143:[2,45],145:[2,45],147:[2,45],149:[2,45],151:[2,45],153:[2,45],155:[2,45],157:[2,45],159:[2,45],161:[2,45],162:[2,45],167:[2,45],170:[2,45],171:[2,45],176:[2,45],177:[2,45],178:[2,45],179:[2,45],180:[2,45],181:[2,45],182:[2,45]},{10:[1,283]},{6:[2,158],8:[2,158],10:[2,158],49:[2,158],50:[2,158],51:[2,158],53:[2,158],56:[2,158],57:[2,158],58:[2,158],59:[2,158],60:[2,158],61:[2,158],62:[2,158],63:[2,158],64:[2,158],65:[2,158],66:[2,158],67:[2,158],68:[2,158],69:[2,158],70:[2,158],71:[2,158],72:[2,158],73:[2,158],74:[2,158],75:[2,158],76:[2,158],77:[2,158],78:[2,158],79:[2,158],81:[2,158],82:[2,158],83:[2,158],84:[2,158],85:[2,158],86:[2,158],87:[2,158],88:[2,158],89:[2,158],90:[2,158],91:[2,158],92:[2,158],93:[2,158],94:[2,158],95:[2,158],96:[2,158],97:[2,158],98:[2,158],99:[2,158],100:[2,158],101:[2,158],102:[2,158],103:[2,158],104:[2,158],105:[2,158],106:[2,158],107:[2,158],108:[2,158],109:[2,158],110:[2,158],111:[2,158],112:[2,158],113:[2,158],114:[2,158],115:[2,158],116:[2,158],117:[2,158],118:[2,158],119:[2,158],120:[2,158],121:[2,158],122:[2,158],123:[2,158],124:[2,158],125:[2,158],126:[2,158],127:[2,158],128:[2,158],129:[2,158],130:[2,158],131:[2,158],132:[2,158],135:[2,158],137:[2,158],138:[2,158],140:[2,158],141:[2,158],142:[2,158],143:[2,158],144:[2,158],145:[2,158],146:[2,158],147:[2,158],148:[2,158],149:[2,158],150:[2,158],151:[2,158],152:[2,158],153:[2,158],154:[2,158],155:[2,158],156:[2,158],157:[2,158],158:[2,158],159:[2,158],160:[2,158],161:[2,158],162:[2,158],165:[1,223],166:[1,224],167:[2,158],170:[2,158],171:[2,158],174:284,186:[2,158],189:[2,158],191:[2,158]},{136:285,165:[1,223],166:[1,224],174:222},{6:[2,182],8:[2,182],10:[2,182],49:[2,182],50:[2,182],51:[2,182],53:[2,182],56:[2,182],57:[2,182],58:[2,182],59:[2,182],60:[2,182],61:[2,182],62:[2,182],63:[2,182],64:[2,182],65:[2,182],66:[2,182],67:[2,182],68:[2,182],69:[2,182],70:[2,182],71:[2,182],72:[2,182],73:[2,182],74:[2,182],75:[2,182],76:[2,182],77:[2,182],78:[2,182],79:[2,182],81:[2,182],82:[2,182],83:[2,182],84:[2,182],85:[2,182],86:[2,182],87:[2,182],88:[2,182],89:[2,182],90:[2,182],91:[2,182],92:[2,182],93:[2,182],94:[2,182],95:[2,182],96:[2,182],97:[2,182],98:[2,182],99:[2,182],100:[2,182],101:[2,182],102:[2,182],103:[2,182],104:[2,182],105:[2,182],106:[2,182],107:[2,182],108:[2,182],109:[2,182],110:[2,182],111:[2,182],112:[2,182],113:[2,182],114:[2,182],115:[2,182],116:[2,182],117:[2,182],118:[2,182],119:[2,182],120:[2,182],121:[2,182],122:[2,182],123:[2,182],124:[2,182],125:[2,182],126:[2,182],127:[2,182],128:[2,182],129:[2,182],130:[2,182],131:[2,182],132:[2,182],135:[2,182],137:[2,182],138:[2,182],140:[2,182],141:[2,182],142:[2,182],143:[2,182],144:[2,182],145:[2,182],146:[2,182],147:[2,182],148:[2,182],149:[2,182],150:[2,182],151:[2,182],152:[2,182],153:[2,182],154:[2,182],155:[2,182],156:[2,182],157:[2,182],158:[2,182],159:[2,182],160:[2,182],161:[2,182],162:[2,182],165:[2,182],166:[2,182],167:[2,182],170:[2,182],171:[2,182],186:[2,182],189:[2,182],191:[2,182]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:288,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],166:[1,287],169:289,170:[1,109],171:[1,110],173:286},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:288,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],169:289,170:[1,109],171:[1,110],173:290},{8:[1,221]},{6:[2,162],8:[2,162],10:[2,162],49:[2,162],50:[2,162],51:[2,162],53:[2,162],56:[2,162],57:[2,162],58:[2,162],59:[2,162],60:[2,162],61:[2,162],62:[2,162],63:[2,162],64:[2,162],65:[2,162],66:[2,162],67:[2,162],68:[2,162],69:[2,162],70:[2,162],71:[2,162],72:[2,162],73:[2,162],74:[2,162],75:[2,162],76:[2,162],77:[2,162],78:[2,162],79:[2,162],81:[2,162],82:[2,162],83:[2,162],84:[2,162],85:[2,162],86:[2,162],87:[2,162],88:[2,162],89:[2,162],90:[2,162],91:[2,162],92:[2,162],93:[2,162],94:[2,162],95:[2,162],96:[2,162],97:[2,162],98:[2,162],99:[2,162],100:[2,162],101:[2,162],102:[2,162],103:[2,162],104:[2,162],105:[2,162],106:[2,162],107:[2,162],108:[2,162],109:[2,162],110:[2,162],111:[2,162],112:[2,162],113:[2,162],114:[2,162],115:[2,162],116:[2,162],117:[2,162],118:[2,162],119:[2,162],120:[2,162],121:[2,162],122:[2,162],123:[2,162],124:[2,162],125:[2,162],126:[2,162],127:[2,162],128:[2,162],129:[2,162],130:[2,162],131:[2,162],132:[2,162],135:[2,162],137:[2,162],138:[2,162],140:[2,162],141:[2,162],142:[2,162],143:[2,162],144:[2,162],145:[2,162],146:[2,162],147:[2,162],148:[2,162],149:[2,162],150:[2,162],151:[2,162],152:[2,162],153:[2,162],154:[2,162],155:[2,162],156:[2,162],157:[2,162],158:[2,162],159:[2,162],160:[2,162],161:[2,162],162:[2,162],166:[1,291],167:[1,292],170:[2,162],171:[2,162],186:[2,162],189:[2,162],191:[2,162]},{6:[2,163],8:[2,163],10:[2,163],49:[2,163],50:[2,163],51:[2,163],53:[2,163],56:[2,163],57:[2,163],58:[2,163],59:[2,163],60:[2,163],61:[2,163],62:[2,163],63:[2,163],64:[2,163],65:[2,163],66:[2,163],67:[2,163],68:[2,163],69:[2,163],70:[2,163],71:[2,163],72:[2,163],73:[2,163],74:[2,163],75:[2,163],76:[2,163],77:[2,163],78:[2,163],79:[2,163],81:[2,163],82:[2,163],83:[2,163],84:[2,163],85:[2,163],86:[2,163],87:[2,163],88:[2,163],89:[2,163],90:[2,163],91:[2,163],92:[2,163],93:[2,163],94:[2,163],95:[2,163],96:[2,163],97:[2,163],98:[2,163],99:[2,163],100:[2,163],101:[2,163],102:[2,163],103:[2,163],104:[2,163],105:[2,163],106:[2,163],107:[2,163],108:[2,163],109:[2,163],110:[2,163],111:[2,163],112:[2,163],113:[2,163],114:[2,163],115:[2,163],116:[2,163],117:[2,163],118:[2,163],119:[2,163],120:[2,163],121:[2,163],122:[2,163],123:[2,163],124:[2,163],125:[2,163],126:[2,163],127:[2,163],128:[2,163],129:[2,163],130:[2,163],131:[2,163],132:[2,163],135:[2,163],137:[2,163],138:[2,163],140:[2,163],141:[2,163],142:[2,163],143:[2,163],144:[2,163],145:[2,163],146:[2,163],147:[2,163],148:[2,163],149:[2,163],150:[2,163],151:[2,163],152:[2,163],153:[2,163],154:[2,163],155:[2,163],156:[2,163],157:[2,163],158:[2,163],159:[2,163],160:[2,163],161:[2,163],162:[2,163],165:[1,293],167:[2,163],170:[2,163],171:[2,163],186:[2,163],189:[2,163],191:[2,163]},{6:[2,168],8:[2,168],10:[2,168],49:[2,168],50:[2,168],51:[2,168],53:[2,168],56:[2,168],57:[2,168],58:[2,168],59:[2,168],60:[2,168],61:[2,168],62:[2,168],63:[2,168],64:[2,168],65:[2,168],66:[2,168],67:[2,168],68:[2,168],69:[2,168],70:[2,168],71:[2,168],72:[2,168],73:[2,168],74:[2,168],75:[2,168],76:[2,168],77:[2,168],78:[2,168],79:[2,168],81:[2,168],82:[2,168],83:[2,168],84:[2,168],85:[2,168],86:[2,168],87:[2,168],88:[2,168],89:[2,168],90:[2,168],91:[2,168],92:[2,168],93:[2,168],94:[2,168],95:[2,168],96:[2,168],97:[2,168],98:[2,168],99:[2,168],100:[2,168],101:[2,168],102:[2,168],103:[2,168],104:[2,168],105:[2,168],106:[2,168],107:[2,168],108:[2,168],109:[2,168],110:[2,168],111:[2,168],112:[2,168],113:[2,168],114:[2,168],115:[2,168],116:[2,168],117:[2,168],118:[2,168],119:[2,168],120:[2,168],121:[2,168],122:[2,168],123:[2,168],124:[2,168],125:[2,168],126:[2,168],127:[2,168],128:[2,168],129:[2,168],130:[2,168],131:[2,168],132:[2,168],135:[2,168],137:[2,168],138:[2,168],140:[2,168],141:[2,168],142:[2,168],143:[2,168],144:[2,168],145:[2,168],146:[2,168],147:[2,168],148:[2,168],149:[2,168],150:[2,168],151:[2,168],152:[2,168],153:[2,168],154:[2,168],155:[2,168],156:[2,168],157:[2,168],158:[2,168],159:[2,168],160:[2,168],161:[2,168],162:[2,168],166:[1,294],167:[2,168],170:[2,168],171:[2,168],186:[2,168],189:[2,168],191:[2,168]},{6:[2,169],8:[2,169],10:[2,169],49:[2,169],50:[2,169],51:[2,169],53:[2,169],56:[2,169],57:[2,169],58:[2,169],59:[2,169],60:[2,169],61:[2,169],62:[2,169],63:[2,169],64:[2,169],65:[2,169],66:[2,169],67:[2,169],68:[2,169],69:[2,169],70:[2,169],71:[2,169],72:[2,169],73:[2,169],74:[2,169],75:[2,169],76:[2,169],77:[2,169],78:[2,169],79:[2,169],81:[2,169],82:[2,169],83:[2,169],84:[2,169],85:[2,169],86:[2,169],87:[2,169],88:[2,169],89:[2,169],90:[2,169],91:[2,169],92:[2,169],93:[2,169],94:[2,169],95:[2,169],96:[2,169],97:[2,169],98:[2,169],99:[2,169],100:[2,169],101:[2,169],102:[2,169],103:[2,169],104:[2,169],105:[2,169],106:[2,169],107:[2,169],108:[2,169],109:[2,169],110:[2,169],111:[2,169],112:[2,169],113:[2,169],114:[2,169],115:[2,169],116:[2,169],117:[2,169],118:[2,169],119:[2,169],120:[2,169],121:[2,169],122:[2,169],123:[2,169],124:[2,169],125:[2,169],126:[2,169],127:[2,169],128:[2,169],129:[2,169],130:[2,169],131:[2,169],132:[2,169],135:[2,169],137:[2,169],138:[2,169],140:[2,169],141:[2,169],142:[2,169],143:[2,169],144:[2,169],145:[2,169],146:[2,169],147:[2,169],148:[2,169],149:[2,169],150:[2,169],151:[2,169],152:[2,169],153:[2,169],154:[2,169],155:[2,169],156:[2,169],157:[2,169],158:[2,169],159:[2,169],160:[2,169],161:[2,169],162:[2,169],165:[1,295],167:[2,169],170:[2,169],171:[2,169],186:[2,169],189:[2,169],191:[2,169]},{6:[2,49],8:[2,49],10:[2,49],49:[2,49],50:[2,49],51:[2,49],53:[2,49],56:[2,49],57:[2,49],58:[2,49],59:[2,49],60:[2,49],61:[2,49],62:[2,49],63:[2,49],64:[2,49],65:[2,49],66:[2,49],67:[2,49],68:[2,49],69:[2,49],70:[2,49],71:[2,49],72:[2,49],73:[2,49],74:[2,49],75:[2,49],76:[2,49],77:[2,49],78:[2,49],79:[2,49],81:[2,49],82:[2,49],83:[2,49],84:[2,49],85:[2,49],86:[2,49],87:[2,49],88:[2,49],89:[2,49],90:[2,49],91:[2,49],92:[2,49],93:[2,49],94:[2,49],95:[2,49],96:[2,49],97:[2,49],98:[2,49],99:[2,49],100:[2,49],101:[2,49],102:[2,49],103:[2,49],104:[2,49],105:[2,49],106:[2,49],107:[2,49],108:[2,49],109:[2,49],110:[2,49],111:[2,49],112:[2,49],113:[2,49],114:[2,49],115:[2,49],116:[2,49],117:[2,49],118:[2,49],119:[2,49],120:[2,49],121:[2,49],122:[2,49],123:[2,49],124:[2,49],125:[2,49],126:[2,49],127:[2,49],128:[2,49],129:[2,49],130:[2,49],131:[2,49],132:[2,49],134:[2,49],135:[2,49],137:[2,49],138:[2,49],140:[2,49],141:[2,49],142:[2,49],143:[2,49],144:[2,49],145:[2,49],146:[2,49],147:[2,49],148:[2,49],149:[2,49],150:[2,49],151:[2,49],152:[2,49],153:[2,49],154:[2,49],155:[2,49],156:[2,49],157:[2,49],158:[2,49],159:[2,49],160:[2,49],161:[2,49],162:[2,49],165:[2,49],166:[2,49],167:[2,49],168:[2,49],170:[2,49],171:[2,49],186:[2,49],189:[2,49],191:[2,49]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:296,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:297,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:298,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{6:[2,58],8:[2,58],10:[2,58],49:[2,58],50:[2,58],51:[2,58],53:[2,58],56:[2,58],57:[2,58],58:[2,58],59:[2,58],60:[2,58],61:[2,58],62:[2,58],63:[2,58],64:[2,58],65:[2,58],66:[2,58],67:[2,58],68:[2,58],69:[2,58],70:[2,58],71:[2,58],72:[2,58],73:[2,58],74:[2,58],75:[2,58],76:[2,58],77:[2,58],78:[2,58],79:[2,58],81:[2,58],82:[2,58],83:[2,58],84:[2,58],85:[2,58],86:[2,58],87:[2,58],88:[2,58],89:[2,58],90:[2,58],91:[2,58],92:[2,58],93:[2,58],94:[2,58],95:[2,58],96:[2,58],97:[2,58],98:[2,58],99:[2,58],100:[2,58],101:[2,58],102:[2,58],103:[2,58],104:[2,58],105:[2,58],106:[2,58],107:[2,58],108:[2,58],109:[2,58],110:[2,58],111:[2,58],112:[2,58],113:[2,58],114:[2,58],115:[2,58],116:[2,58],117:[2,58],118:[2,58],119:[2,58],120:[2,58],121:[2,58],122:[2,58],123:[2,58],124:[2,58],125:[2,58],126:[2,58],127:[2,58],128:[2,58],129:[2,58],130:[2,58],131:[2,58],132:[2,58],134:[2,58],135:[2,58],137:[2,58],138:[2,58],140:[2,58],141:[2,58],142:[2,58],143:[2,58],144:[2,58],145:[2,58],146:[2,58],147:[2,58],148:[2,58],149:[2,58],150:[2,58],151:[2,58],152:[2,58],153:[2,58],154:[2,58],155:[2,58],156:[2,58],157:[2,58],158:[2,58],159:[2,58],160:[2,58],161:[2,58],162:[2,58],165:[2,58],166:[2,58],167:[2,58],168:[2,58],170:[2,58],171:[2,58],186:[2,58],189:[2,58],191:[2,58]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:299,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:300,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:301,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{50:[1,302],51:[1,303]},{7:138,8:[1,117],15:304},{6:[1,305]},{6:[2,86],8:[2,86],10:[2,86],49:[2,86],50:[2,86],51:[2,86],53:[2,86],56:[2,86],57:[2,86],58:[2,86],59:[2,86],60:[2,86],61:[2,86],62:[2,86],63:[2,86],64:[2,86],65:[2,86],66:[2,86],67:[2,86],68:[2,86],69:[2,86],70:[2,86],71:[2,86],72:[2,86],73:[2,86],74:[2,86],75:[2,86],76:[2,86],77:[2,86],78:[2,86],79:[2,86],81:[2,86],82:[2,86],83:[2,86],84:[2,86],85:[2,86],86:[2,86],87:[2,86],88:[2,86],89:[2,86],90:[2,86],91:[2,86],92:[2,86],93:[2,86],94:[2,86],95:[2,86],96:[2,86],97:[2,86],98:[2,86],99:[2,86],100:[2,86],101:[2,86],102:[2,86],103:[2,86],104:[2,86],105:[2,86],106:[2,86],107:[2,86],108:[2,86],109:[2,86],110:[2,86],111:[2,86],112:[2,86],113:[2,86],114:[2,86],115:[2,86],116:[2,86],117:[2,86],118:[2,86],119:[2,86],120:[2,86],121:[2,86],122:[2,86],123:[2,86],124:[2,86],125:[2,86],126:[2,86],127:[2,86],128:[2,86],129:[2,86],130:[2,86],131:[2,86],132:[2,86],134:[2,86],135:[2,86],137:[2,86],138:[2,86],140:[2,86],141:[2,86],142:[2,86],143:[2,86],144:[2,86],145:[2,86],146:[2,86],147:[2,86],148:[2,86],149:[2,86],150:[2,86],151:[2,86],152:[2,86],153:[2,86],154:[2,86],155:[2,86],156:[2,86],157:[2,86],158:[2,86],159:[2,86],160:[2,86],161:[2,86],162:[2,86],165:[2,86],166:[2,86],167:[2,86],168:[2,86],170:[2,86],171:[2,86],186:[2,86],189:[2,86],191:[2,86]},{6:[2,87],8:[2,87],10:[2,87],49:[2,87],50:[2,87],51:[2,87],53:[2,87],56:[2,87],57:[2,87],58:[2,87],59:[2,87],60:[2,87],61:[2,87],62:[2,87],63:[2,87],64:[2,87],65:[2,87],66:[2,87],67:[2,87],68:[2,87],69:[2,87],70:[2,87],71:[2,87],72:[2,87],73:[2,87],74:[2,87],75:[2,87],76:[2,87],77:[2,87],78:[2,87],79:[2,87],81:[2,87],82:[2,87],83:[2,87],84:[2,87],85:[2,87],86:[2,87],87:[2,87],88:[2,87],89:[2,87],90:[2,87],91:[2,87],92:[2,87],93:[2,87],94:[2,87],95:[2,87],96:[2,87],97:[2,87],98:[2,87],99:[2,87],100:[2,87],101:[2,87],102:[2,87],103:[2,87],104:[2,87],105:[2,87],106:[2,87],107:[2,87],108:[2,87],109:[2,87],110:[2,87],111:[2,87],112:[2,87],113:[2,87],114:[2,87],115:[2,87],116:[2,87],117:[2,87],118:[2,87],119:[2,87],120:[2,87],121:[2,87],122:[2,87],123:[2,87],124:[2,87],125:[2,87],126:[2,87],127:[2,87],128:[2,87],129:[2,87],130:[2,87],131:[2,87],132:[2,87],134:[2,87],135:[2,87],137:[2,87],138:[2,87],140:[2,87],141:[2,87],142:[2,87],143:[2,87],144:[2,87],145:[2,87],146:[2,87],147:[2,87],148:[2,87],149:[2,87],150:[2,87],151:[2,87],152:[2,87],153:[2,87],154:[2,87],155:[2,87],156:[2,87],157:[2,87],158:[2,87],159:[2,87],160:[2,87],161:[2,87],162:[2,87],165:[2,87],166:[2,87],167:[2,87],168:[2,87],170:[2,87],171:[2,87],186:[2,87],189:[2,87],191:[2,87]},{6:[1,306]},{6:[2,90],8:[2,90],10:[2,90],49:[2,90],50:[2,90],51:[2,90],53:[2,90],56:[2,90],57:[2,90],58:[2,90],59:[2,90],60:[2,90],61:[2,90],62:[2,90],63:[2,90],64:[2,90],65:[2,90],66:[2,90],67:[2,90],68:[2,90],69:[2,90],70:[2,90],71:[2,90],72:[2,90],73:[2,90],74:[2,90],75:[2,90],76:[2,90],77:[2,90],78:[2,90],79:[2,90],81:[2,90],82:[2,90],83:[2,90],84:[2,90],85:[2,90],86:[2,90],87:[2,90],88:[2,90],89:[2,90],90:[2,90],91:[2,90],92:[2,90],93:[2,90],94:[2,90],95:[2,90],96:[2,90],97:[2,90],98:[2,90],99:[2,90],100:[2,90],101:[2,90],102:[2,90],103:[2,90],104:[2,90],105:[2,90],106:[2,90],107:[2,90],108:[2,90],109:[2,90],110:[2,90],111:[2,90],112:[2,90],113:[2,90],114:[2,90],115:[2,90],116:[2,90],117:[2,90],118:[2,90],119:[2,90],120:[2,90],121:[2,90],122:[2,90],123:[2,90],124:[2,90],125:[2,90],126:[2,90],127:[2,90],128:[2,90],129:[2,90],130:[2,90],131:[2,90],132:[2,90],134:[2,90],135:[2,90],137:[2,90],138:[2,90],140:[2,90],141:[2,90],142:[2,90],143:[2,90],144:[2,90],145:[2,90],146:[2,90],147:[2,90],148:[2,90],149:[2,90],150:[2,90],151:[2,90],152:[2,90],153:[2,90],154:[2,90],155:[2,90],156:[2,90],157:[2,90],158:[2,90],159:[2,90],160:[2,90],161:[2,90],162:[2,90],165:[2,90],166:[2,90],167:[2,90],168:[2,90],170:[2,90],171:[2,90],186:[2,90],189:[2,90],191:[2,90]},{6:[2,91],8:[2,91],10:[2,91],49:[2,91],50:[2,91],51:[2,91],53:[2,91],56:[2,91],57:[2,91],58:[2,91],59:[2,91],60:[2,91],61:[2,91],62:[2,91],63:[2,91],64:[2,91],65:[2,91],66:[2,91],67:[2,91],68:[2,91],69:[2,91],70:[2,91],71:[2,91],72:[2,91],73:[2,91],74:[2,91],75:[2,91],76:[2,91],77:[2,91],78:[2,91],79:[2,91],81:[2,91],82:[2,91],83:[2,91],84:[2,91],85:[2,91],86:[2,91],87:[2,91],88:[2,91],89:[2,91],90:[2,91],91:[2,91],92:[2,91],93:[2,91],94:[2,91],95:[2,91],96:[2,91],97:[2,91],98:[2,91],99:[2,91],100:[2,91],101:[2,91],102:[2,91],103:[2,91],104:[2,91],105:[2,91],106:[2,91],107:[2,91],108:[2,91],109:[2,91],110:[2,91],111:[2,91],112:[2,91],113:[2,91],114:[2,91],115:[2,91],116:[2,91],117:[2,91],118:[2,91],119:[2,91],120:[2,91],121:[2,91],122:[2,91],123:[2,91],124:[2,91],125:[2,91],126:[2,91],127:[2,91],128:[2,91],129:[2,91],130:[2,91],131:[2,91],132:[2,91],134:[2,91],135:[2,91],137:[2,91],138:[2,91],140:[2,91],141:[2,91],142:[2,91],143:[2,91],144:[2,91],145:[2,91],146:[2,91],147:[2,91],148:[2,91],149:[2,91],150:[2,91],151:[2,91],152:[2,91],153:[2,91],154:[2,91],155:[2,91],156:[2,91],157:[2,91],158:[2,91],159:[2,91],160:[2,91],161:[2,91],162:[2,91],165:[2,91],166:[2,91],167:[2,91],168:[2,91],170:[2,91],171:[2,91],186:[2,91],189:[2,91],191:[2,91]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:307,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[1,308]},{6:[2,99],8:[2,99],10:[2,99],49:[2,99],50:[2,99],51:[2,99],53:[2,99],56:[2,99],57:[2,99],58:[2,99],59:[2,99],60:[2,99],61:[2,99],62:[2,99],63:[2,99],64:[2,99],65:[2,99],66:[2,99],67:[2,99],68:[2,99],69:[2,99],70:[2,99],71:[2,99],72:[2,99],73:[2,99],74:[2,99],75:[2,99],76:[2,99],77:[2,99],78:[2,99],79:[2,99],81:[2,99],82:[2,99],83:[2,99],84:[2,99],85:[2,99],86:[2,99],87:[2,99],88:[2,99],89:[2,99],90:[2,99],91:[2,99],92:[2,99],93:[2,99],94:[2,99],95:[2,99],96:[2,99],97:[2,99],98:[2,99],99:[2,99],100:[2,99],101:[2,99],102:[2,99],103:[2,99],104:[2,99],105:[2,99],106:[2,99],107:[2,99],108:[2,99],109:[2,99],110:[2,99],111:[2,99],112:[2,99],113:[2,99],114:[2,99],115:[2,99],116:[2,99],117:[2,99],118:[2,99],119:[2,99],120:[2,99],121:[2,99],122:[2,99],123:[2,99],124:[2,99],125:[2,99],126:[2,99],127:[2,99],128:[2,99],129:[2,99],130:[2,99],131:[2,99],132:[2,99],134:[2,99],135:[2,99],137:[2,99],138:[2,99],140:[2,99],141:[2,99],142:[2,99],143:[2,99],144:[2,99],145:[2,99],146:[2,99],147:[2,99],148:[2,99],149:[2,99],150:[2,99],151:[2,99],152:[2,99],153:[2,99],154:[2,99],155:[2,99],156:[2,99],157:[2,99],158:[2,99],159:[2,99],160:[2,99],161:[2,99],162:[2,99],165:[2,99],166:[2,99],167:[2,99],168:[2,99],170:[2,99],171:[2,99],186:[2,99],189:[2,99],191:[2,99]},{6:[2,100],8:[2,100],10:[2,100],49:[2,100],50:[2,100],51:[2,100],53:[2,100],56:[2,100],57:[2,100],58:[2,100],59:[2,100],60:[2,100],61:[2,100],62:[2,100],63:[2,100],64:[2,100],65:[2,100],66:[2,100],67:[2,100],68:[2,100],69:[2,100],70:[2,100],71:[2,100],72:[2,100],73:[2,100],74:[2,100],75:[2,100],76:[2,100],77:[2,100],78:[2,100],79:[2,100],81:[2,100],82:[2,100],83:[2,100],84:[2,100],85:[2,100],86:[2,100],87:[2,100],88:[2,100],89:[2,100],90:[2,100],91:[2,100],92:[2,100],93:[2,100],94:[2,100],95:[2,100],96:[2,100],97:[2,100],98:[2,100],99:[2,100],100:[2,100],101:[2,100],102:[2,100],103:[2,100],104:[2,100],105:[2,100],106:[2,100],107:[2,100],108:[2,100],109:[2,100],110:[2,100],111:[2,100],112:[2,100],113:[2,100],114:[2,100],115:[2,100],116:[2,100],117:[2,100],118:[2,100],119:[2,100],120:[2,100],121:[2,100],122:[2,100],123:[2,100],124:[2,100],125:[2,100],126:[2,100],127:[2,100],128:[2,100],129:[2,100],130:[2,100],131:[2,100],132:[2,100],134:[2,100],135:[2,100],137:[2,100],138:[2,100],140:[2,100],141:[2,100],142:[2,100],143:[2,100],144:[2,100],145:[2,100],146:[2,100],147:[2,100],148:[2,100],149:[2,100],150:[2,100],151:[2,100],152:[2,100],153:[2,100],154:[2,100],155:[2,100],156:[2,100],157:[2,100],158:[2,100],159:[2,100],160:[2,100],161:[2,100],162:[2,100],165:[2,100],166:[2,100],167:[2,100],168:[2,100],170:[2,100],171:[2,100],186:[2,100],189:[2,100],191:[2,100]},{6:[2,101],8:[2,101],10:[2,101],49:[2,101],50:[2,101],51:[2,101],53:[2,101],56:[2,101],57:[2,101],58:[2,101],59:[2,101],60:[2,101],61:[2,101],62:[2,101],63:[2,101],64:[2,101],65:[2,101],66:[2,101],67:[2,101],68:[2,101],69:[2,101],70:[2,101],71:[2,101],72:[2,101],73:[2,101],74:[2,101],75:[2,101],76:[2,101],77:[2,101],78:[2,101],79:[2,101],81:[2,101],82:[2,101],83:[2,101],84:[2,101],85:[2,101],86:[2,101],87:[2,101],88:[2,101],89:[2,101],90:[2,101],91:[2,101],92:[2,101],93:[2,101],94:[2,101],95:[2,101],96:[2,101],97:[2,101],98:[2,101],99:[2,101],100:[2,101],101:[2,101],102:[2,101],103:[2,101],104:[2,101],105:[2,101],106:[2,101],107:[2,101],108:[2,101],109:[2,101],110:[2,101],111:[2,101],112:[2,101],113:[2,101],114:[2,101],115:[2,101],116:[2,101],117:[2,101],118:[2,101],119:[2,101],120:[2,101],121:[2,101],122:[2,101],123:[2,101],124:[2,101],125:[2,101],126:[2,101],127:[2,101],128:[2,101],129:[2,101],130:[2,101],131:[2,101],132:[2,101],134:[2,101],135:[2,101],137:[2,101],138:[2,101],140:[2,101],141:[2,101],142:[2,101],143:[2,101],144:[2,101],145:[2,101],146:[2,101],147:[2,101],148:[2,101],149:[2,101],150:[2,101],151:[2,101],152:[2,101],153:[2,101],154:[2,101],155:[2,101],156:[2,101],157:[2,101],158:[2,101],159:[2,101],160:[2,101],161:[2,101],162:[2,101],165:[2,101],166:[2,101],167:[2,101],168:[2,101],170:[2,101],171:[2,101],186:[2,101],189:[2,101],191:[2,101]},{7:309,8:[1,117]},{4:[1,254],8:[1,18],11:310,48:27,49:[1,111],50:[1,39],51:[1,35],54:311,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,121],8:[2,121],10:[2,121],49:[2,121],50:[2,121],51:[2,121],53:[2,121],56:[2,121],57:[2,121],58:[2,121],59:[2,121],60:[2,121],61:[2,121],62:[2,121],63:[2,121],64:[2,121],65:[2,121],66:[2,121],67:[2,121],68:[2,121],69:[2,121],70:[2,121],71:[2,121],72:[2,121],73:[2,121],74:[2,121],75:[2,121],76:[2,121],77:[2,121],78:[2,121],79:[2,121],81:[2,121],82:[2,121],83:[2,121],84:[2,121],85:[2,121],86:[2,121],87:[2,121],88:[2,121],89:[2,121],90:[2,121],91:[2,121],92:[2,121],93:[2,121],94:[2,121],95:[2,121],96:[2,121],97:[2,121],98:[2,121],99:[2,121],100:[2,121],101:[2,121],102:[2,121],103:[2,121],104:[2,121],105:[2,121],106:[2,121],107:[2,121],108:[2,121],109:[2,121],110:[2,121],111:[2,121],112:[2,121],113:[2,121],114:[2,121],115:[2,121],116:[2,121],117:[2,121],118:[2,121],119:[2,121],120:[2,121],121:[2,121],122:[2,121],123:[2,121],124:[2,121],125:[2,121],126:[2,121],127:[2,121],128:[2,121],129:[2,121],130:[2,121],131:[2,121],132:[2,121],134:[2,121],135:[2,121],137:[2,121],138:[2,121],140:[2,121],141:[2,121],142:[2,121],143:[2,121],144:[2,121],145:[2,121],146:[2,121],147:[2,121],148:[2,121],149:[2,121],150:[2,121],151:[2,121],152:[2,121],153:[2,121],154:[2,121],155:[2,121],156:[2,121],157:[2,121],158:[2,121],159:[2,121],160:[2,121],161:[2,121],162:[2,121],165:[2,121],166:[2,121],167:[2,121],168:[2,121],170:[2,121],171:[2,121],186:[2,121],189:[2,121],191:[2,121]},{5:[1,312]},{10:[1,313]},{6:[2,132],8:[2,132],10:[2,132],49:[2,132],50:[2,132],51:[2,132],53:[2,132],56:[2,132],57:[2,132],58:[2,132],59:[2,132],60:[2,132],61:[2,132],62:[2,132],63:[2,132],64:[2,132],65:[2,132],66:[2,132],67:[2,132],68:[2,132],69:[2,132],70:[2,132],71:[2,132],72:[2,132],73:[2,132],74:[2,132],75:[2,132],76:[2,132],77:[2,132],78:[2,132],79:[2,132],81:[2,132],82:[2,132],83:[2,132],84:[2,132],85:[2,132],86:[2,132],87:[2,132],88:[2,132],89:[2,132],90:[2,132],91:[2,132],92:[2,132],93:[2,132],94:[2,132],95:[2,132],96:[2,132],97:[2,132],98:[2,132],99:[2,132],100:[2,132],101:[2,132],102:[2,132],103:[2,132],104:[2,132],105:[2,132],106:[2,132],107:[2,132],108:[2,132],109:[2,132],110:[2,132],111:[2,132],112:[2,132],113:[2,132],114:[2,132],115:[2,132],116:[2,132],117:[2,132],118:[2,132],119:[2,132],120:[2,132],121:[2,132],122:[2,132],123:[2,132],124:[2,132],125:[2,132],126:[2,132],127:[2,132],128:[2,132],129:[2,132],130:[2,132],131:[2,132],132:[2,132],134:[2,132],135:[2,132],137:[2,132],138:[2,132],140:[2,132],141:[2,132],142:[2,132],143:[2,132],144:[2,132],145:[2,132],146:[2,132],147:[2,132],148:[2,132],149:[2,132],150:[2,132],151:[2,132],152:[2,132],153:[2,132],154:[2,132],155:[2,132],156:[2,132],157:[2,132],158:[2,132],159:[2,132],160:[2,132],161:[2,132],162:[2,132],165:[2,132],166:[2,132],167:[2,132],168:[2,132],170:[2,132],171:[2,132],186:[2,132],189:[2,132],191:[2,132]},{6:[2,133],8:[2,133],10:[2,133],49:[2,133],50:[2,133],51:[2,133],53:[2,133],56:[2,133],57:[2,133],58:[2,133],59:[2,133],60:[2,133],61:[2,133],62:[2,133],63:[2,133],64:[2,133],65:[2,133],66:[2,133],67:[2,133],68:[2,133],69:[2,133],70:[2,133],71:[2,133],72:[2,133],73:[2,133],74:[2,133],75:[2,133],76:[2,133],77:[2,133],78:[2,133],79:[2,133],81:[2,133],82:[2,133],83:[2,133],84:[2,133],85:[2,133],86:[2,133],87:[2,133],88:[2,133],89:[2,133],90:[2,133],91:[2,133],92:[2,133],93:[2,133],94:[2,133],95:[2,133],96:[2,133],97:[2,133],98:[2,133],99:[2,133],100:[2,133],101:[2,133],102:[2,133],103:[2,133],104:[2,133],105:[2,133],106:[2,133],107:[2,133],108:[2,133],109:[2,133],110:[2,133],111:[2,133],112:[2,133],113:[2,133],114:[2,133],115:[2,133],116:[2,133],117:[2,133],118:[2,133],119:[2,133],120:[2,133],121:[2,133],122:[2,133],123:[2,133],124:[2,133],125:[2,133],126:[2,133],127:[2,133],128:[2,133],129:[2,133],130:[2,133],131:[2,133],132:[2,133],134:[2,133],135:[2,133],137:[2,133],138:[2,133],140:[2,133],141:[2,133],142:[2,133],143:[2,133],144:[2,133],145:[2,133],146:[2,133],147:[2,133],148:[2,133],149:[2,133],150:[2,133],151:[2,133],152:[2,133],153:[2,133],154:[2,133],155:[2,133],156:[2,133],157:[2,133],158:[2,133],159:[2,133],160:[2,133],161:[2,133],162:[2,133],165:[2,133],166:[2,133],167:[2,133],168:[2,133],170:[2,133],171:[2,133],186:[2,133],189:[2,133],191:[2,133]},{6:[2,134],8:[2,134],10:[2,134],49:[2,134],50:[2,134],51:[2,134],53:[2,134],56:[2,134],57:[2,134],58:[2,134],59:[2,134],60:[2,134],61:[2,134],62:[2,134],63:[2,134],64:[2,134],65:[2,134],66:[2,134],67:[2,134],68:[2,134],69:[2,134],70:[2,134],71:[2,134],72:[2,134],73:[2,134],74:[2,134],75:[2,134],76:[2,134],77:[2,134],78:[2,134],79:[2,134],81:[2,134],82:[2,134],83:[2,134],84:[2,134],85:[2,134],86:[2,134],87:[2,134],88:[2,134],89:[2,134],90:[2,134],91:[2,134],92:[2,134],93:[2,134],94:[2,134],95:[2,134],96:[2,134],97:[2,134],98:[2,134],99:[2,134],100:[2,134],101:[2,134],102:[2,134],103:[2,134],104:[2,134],105:[2,134],106:[2,134],107:[2,134],108:[2,134],109:[2,134],110:[2,134],111:[2,134],112:[2,134],113:[2,134],114:[2,134],115:[2,134],116:[2,134],117:[2,134],118:[2,134],119:[2,134],120:[2,134],121:[2,134],122:[2,134],123:[2,134],124:[2,134],125:[2,134],126:[2,134],127:[2,134],128:[2,134],129:[2,134],130:[2,134],131:[2,134],132:[2,134],134:[2,134],135:[2,134],137:[2,134],138:[2,134],140:[2,134],141:[2,134],142:[2,134],143:[2,134],144:[2,134],145:[2,134],146:[2,134],147:[2,134],148:[2,134],149:[2,134],150:[2,134],151:[2,134],152:[2,134],153:[2,134],154:[2,134],155:[2,134],156:[2,134],157:[2,134],158:[2,134],159:[2,134],160:[2,134],161:[2,134],162:[2,134],165:[2,134],166:[2,134],167:[2,134],168:[2,134],170:[2,134],171:[2,134],186:[2,134],189:[2,134],191:[2,134]},{6:[2,135],8:[2,135],10:[2,135],49:[2,135],50:[2,135],51:[2,135],53:[2,135],56:[2,135],57:[2,135],58:[2,135],59:[2,135],60:[2,135],61:[2,135],62:[2,135],63:[2,135],64:[2,135],65:[2,135],66:[2,135],67:[2,135],68:[2,135],69:[2,135],70:[2,135],71:[2,135],72:[2,135],73:[2,135],74:[2,135],75:[2,135],76:[2,135],77:[2,135],78:[2,135],79:[2,135],81:[2,135],82:[2,135],83:[2,135],84:[2,135],85:[2,135],86:[2,135],87:[2,135],88:[2,135],89:[2,135],90:[2,135],91:[2,135],92:[2,135],93:[2,135],94:[2,135],95:[2,135],96:[2,135],97:[2,135],98:[2,135],99:[2,135],100:[2,135],101:[2,135],102:[2,135],103:[2,135],104:[2,135],105:[2,135],106:[2,135],107:[2,135],108:[2,135],109:[2,135],110:[2,135],111:[2,135],112:[2,135],113:[2,135],114:[2,135],115:[2,135],116:[2,135],117:[2,135],118:[2,135],119:[2,135],120:[2,135],121:[2,135],122:[2,135],123:[2,135],124:[2,135],125:[2,135],126:[2,135],127:[2,135],128:[2,135],129:[2,135],130:[2,135],131:[2,135],132:[2,135],134:[2,135],135:[2,135],137:[2,135],138:[2,135],140:[2,135],141:[2,135],142:[2,135],143:[2,135],144:[2,135],145:[2,135],146:[2,135],147:[2,135],148:[2,135],149:[2,135],150:[2,135],151:[2,135],152:[2,135],153:[2,135],154:[2,135],155:[2,135],156:[2,135],157:[2,135],158:[2,135],159:[2,135],160:[2,135],161:[2,135],162:[2,135],165:[2,135],166:[2,135],167:[2,135],168:[2,135],170:[2,135],171:[2,135],186:[2,135],189:[2,135],191:[2,135]},{6:[2,136],8:[2,136],10:[2,136],49:[2,136],50:[2,136],51:[2,136],53:[2,136],56:[2,136],57:[2,136],58:[2,136],59:[2,136],60:[2,136],61:[2,136],62:[2,136],63:[2,136],64:[2,136],65:[2,136],66:[2,136],67:[2,136],68:[2,136],69:[2,136],70:[2,136],71:[2,136],72:[2,136],73:[2,136],74:[2,136],75:[2,136],76:[2,136],77:[2,136],78:[2,136],79:[2,136],81:[2,136],82:[2,136],83:[2,136],84:[2,136],85:[2,136],86:[2,136],87:[2,136],88:[2,136],89:[2,136],90:[2,136],91:[2,136],92:[2,136],93:[2,136],94:[2,136],95:[2,136],96:[2,136],97:[2,136],98:[2,136],99:[2,136],100:[2,136],101:[2,136],102:[2,136],103:[2,136],104:[2,136],105:[2,136],106:[2,136],107:[2,136],108:[2,136],109:[2,136],110:[2,136],111:[2,136],112:[2,136],113:[2,136],114:[2,136],115:[2,136],116:[2,136],117:[2,136],118:[2,136],119:[2,136],120:[2,136],121:[2,136],122:[2,136],123:[2,136],124:[2,136],125:[2,136],126:[2,136],127:[2,136],128:[2,136],129:[2,136],130:[2,136],131:[2,136],132:[2,136],134:[2,136],135:[2,136],137:[2,136],138:[2,136],140:[2,136],141:[2,136],142:[2,136],143:[2,136],144:[2,136],145:[2,136],146:[2,136],147:[2,136],148:[2,136],149:[2,136],150:[2,136],151:[2,136],152:[2,136],153:[2,136],154:[2,136],155:[2,136],156:[2,136],157:[2,136],158:[2,136],159:[2,136],160:[2,136],161:[2,136],162:[2,136],165:[2,136],166:[2,136],167:[2,136],168:[2,136],170:[2,136],171:[2,136],186:[2,136],189:[2,136],191:[2,136]},{8:[2,157],49:[2,157],50:[2,157],51:[2,157],56:[2,157],57:[2,157],58:[2,157],59:[2,157],60:[2,157],61:[2,157],62:[2,157],63:[2,157],67:[2,157],68:[2,157],69:[2,157],70:[2,157],71:[2,157],72:[2,157],73:[2,157],74:[2,157],75:[2,157],76:[2,157],77:[2,157],78:[2,157],79:[2,157],81:[2,157],82:[2,157],83:[2,157],84:[2,157],85:[2,157],86:[2,157],87:[2,157],88:[2,157],89:[2,157],90:[2,157],91:[2,157],92:[2,157],93:[2,157],94:[2,157],95:[2,157],96:[2,157],97:[2,157],98:[2,157],99:[2,157],100:[2,157],101:[2,157],102:[2,157],103:[2,157],104:[2,157],105:[2,157],106:[2,157],107:[2,157],108:[2,157],109:[2,157],110:[2,157],111:[2,157],112:[2,157],113:[2,157],114:[2,157],115:[2,157],116:[2,157],117:[2,157],118:[2,157],119:[2,157],120:[2,157],121:[2,157],122:[2,157],123:[2,157],124:[2,157],125:[2,157],126:[2,157],127:[2,157],128:[2,157],129:[2,157],130:[2,157],131:[2,157],132:[2,157],134:[2,157],135:[2,157],137:[2,157],138:[2,157],141:[2,157],143:[2,157],145:[2,157],147:[2,157],149:[2,157],151:[2,157],153:[2,157],155:[2,157],157:[2,157],159:[2,157],161:[2,157],162:[2,157]},{10:[1,314],165:[1,223],166:[1,224],174:284},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:315,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,141],8:[2,141],10:[2,141],49:[2,141],50:[2,141],51:[2,141],53:[2,141],56:[2,141],57:[2,141],58:[2,141],59:[2,141],60:[2,141],61:[2,141],62:[2,141],63:[2,141],64:[2,141],65:[2,141],66:[2,141],67:[2,141],68:[2,141],69:[2,141],70:[2,141],71:[2,141],72:[2,141],73:[2,141],74:[2,141],75:[2,141],76:[2,141],77:[2,141],78:[2,141],79:[2,141],81:[2,141],82:[2,141],83:[2,141],84:[2,141],85:[2,141],86:[2,141],87:[2,141],88:[2,141],89:[2,141],90:[2,141],91:[2,141],92:[2,141],93:[2,141],94:[2,141],95:[2,141],96:[2,141],97:[2,141],98:[2,141],99:[2,141],100:[2,141],101:[2,141],102:[2,141],103:[2,141],104:[2,141],105:[2,141],106:[2,141],107:[2,141],108:[2,141],109:[2,141],110:[2,141],111:[2,141],112:[2,141],113:[2,141],114:[2,141],115:[2,141],116:[2,141],117:[2,141],118:[2,141],119:[2,141],120:[2,141],121:[2,141],122:[2,141],123:[2,141],124:[2,141],125:[2,141],126:[2,141],127:[2,141],128:[2,141],129:[2,141],130:[2,141],131:[2,141],132:[2,141],134:[2,141],135:[2,141],137:[2,141],138:[2,141],140:[2,141],141:[2,141],142:[2,141],143:[2,141],144:[2,141],145:[2,141],146:[2,141],147:[2,141],148:[2,141],149:[2,141],150:[2,141],151:[2,141],152:[2,141],153:[2,141],154:[2,141],155:[2,141],156:[2,141],157:[2,141],158:[2,141],159:[2,141],160:[2,141],161:[2,141],162:[2,141],165:[2,141],166:[2,141],167:[2,141],168:[2,141],170:[2,141],171:[2,141],186:[2,141],189:[2,141],191:[2,141]},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],140:[2,193],141:[1,97],142:[2,193],143:[1,98],144:[2,193],145:[1,99],146:[2,193],147:[1,100],148:[2,193],149:[1,101],150:[2,193],151:[1,102],152:[2,193],153:[1,103],154:[2,193],155:[1,104],156:[2,193],157:[1,105],158:[2,193],159:[1,106],160:[2,193],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:316,188:[1,197],189:[2,193]},{20:319,21:[1,321],22:320,23:[1,322],44:318,47:317},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],140:[2,193],141:[1,97],142:[2,193],143:[1,98],144:[2,193],145:[1,99],146:[2,193],147:[1,100],148:[2,193],149:[1,101],150:[2,193],151:[1,102],152:[2,193],153:[1,103],154:[2,193],155:[1,104],156:[2,193],157:[1,105],158:[2,193],159:[1,106],160:[2,193],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:323,184:[1,200],186:[2,193],189:[2,193]},{20:326,21:[1,321],22:327,23:[1,322],24:328,25:[1,330],26:329,27:[1,331],42:325,43:324},{6:[2,142],8:[2,142],10:[2,142],49:[2,142],50:[2,142],51:[2,142],53:[2,142],56:[2,142],57:[2,142],58:[2,142],59:[2,142],60:[2,142],61:[2,142],62:[2,142],63:[2,142],64:[2,142],65:[2,142],66:[2,142],67:[2,142],68:[2,142],69:[2,142],70:[2,142],71:[2,142],72:[2,142],73:[2,142],74:[2,142],75:[2,142],76:[2,142],77:[2,142],78:[2,142],79:[2,142],81:[2,142],82:[2,142],83:[2,142],84:[2,142],85:[2,142],86:[2,142],87:[2,142],88:[2,142],89:[2,142],90:[2,142],91:[2,142],92:[2,142],93:[2,142],94:[2,142],95:[2,142],96:[2,142],97:[2,142],98:[2,142],99:[2,142],100:[2,142],101:[2,142],102:[2,142],103:[2,142],104:[2,142],105:[2,142],106:[2,142],107:[2,142],108:[2,142],109:[2,142],110:[2,142],111:[2,142],112:[2,142],113:[2,142],114:[2,142],115:[2,142],116:[2,142],117:[2,142],118:[2,142],119:[2,142],120:[2,142],121:[2,142],122:[2,142],123:[2,142],124:[2,142],125:[2,142],126:[2,142],127:[2,142],128:[2,142],129:[2,142],130:[2,142],131:[2,142],132:[2,142],134:[2,142],135:[2,142],137:[2,142],138:[2,142],140:[2,142],141:[2,142],142:[2,142],143:[2,142],144:[2,142],145:[2,142],146:[2,142],147:[2,142],148:[2,142],149:[2,142],150:[2,142],151:[2,142],152:[2,142],153:[2,142],154:[2,142],155:[2,142],156:[2,142],157:[2,142],158:[2,142],159:[2,142],160:[2,142],161:[2,142],162:[2,142],165:[2,142],166:[2,142],167:[2,142],168:[2,142],170:[2,142],171:[2,142],186:[2,142],189:[2,142],191:[2,142]},{6:[2,143],8:[2,143],10:[2,143],49:[2,143],50:[2,143],51:[2,143],53:[2,143],56:[2,143],57:[2,143],58:[2,143],59:[2,143],60:[2,143],61:[2,143],62:[2,143],63:[2,143],64:[2,143],65:[2,143],66:[2,143],67:[2,143],68:[2,143],69:[2,143],70:[2,143],71:[2,143],72:[2,143],73:[2,143],74:[2,143],75:[2,143],76:[2,143],77:[2,143],78:[2,143],79:[2,143],81:[2,143],82:[2,143],83:[2,143],84:[2,143],85:[2,143],86:[2,143],87:[2,143],88:[2,143],89:[2,143],90:[2,143],91:[2,143],92:[2,143],93:[2,143],94:[2,143],95:[2,143],96:[2,143],97:[2,143],98:[2,143],99:[2,143],100:[2,143],101:[2,143],102:[2,143],103:[2,143],104:[2,143],105:[2,143],106:[2,143],107:[2,143],108:[2,143],109:[2,143],110:[2,143],111:[2,143],112:[2,143],113:[2,143],114:[2,143],115:[2,143],116:[2,143],117:[2,143],118:[2,143],119:[2,143],120:[2,143],121:[2,143],122:[2,143],123:[2,143],124:[2,143],125:[2,143],126:[2,143],127:[2,143],128:[2,143],129:[2,143],130:[2,143],131:[2,143],132:[2,143],134:[2,143],135:[2,143],137:[2,143],138:[2,143],140:[2,143],141:[2,143],142:[2,143],143:[2,143],144:[2,143],145:[2,143],146:[2,143],147:[2,143],148:[2,143],149:[2,143],150:[2,143],151:[2,143],152:[2,143],153:[2,143],154:[2,143],155:[2,143],156:[2,143],157:[2,143],158:[2,143],159:[2,143],160:[2,143],161:[2,143],162:[2,143],165:[2,143],166:[2,143],167:[2,143],168:[2,143],170:[2,143],171:[2,143],186:[2,143],189:[2,143],191:[2,143]},{6:[2,144],8:[2,144],10:[2,144],49:[2,144],50:[2,144],51:[2,144],53:[2,144],56:[2,144],57:[2,144],58:[2,144],59:[2,144],60:[2,144],61:[2,144],62:[2,144],63:[2,144],64:[2,144],65:[2,144],66:[2,144],67:[2,144],68:[2,144],69:[2,144],70:[2,144],71:[2,144],72:[2,144],73:[2,144],74:[2,144],75:[2,144],76:[2,144],77:[2,144],78:[2,144],79:[2,144],81:[2,144],82:[2,144],83:[2,144],84:[2,144],85:[2,144],86:[2,144],87:[2,144],88:[2,144],89:[2,144],90:[2,144],91:[2,144],92:[2,144],93:[2,144],94:[2,144],95:[2,144],96:[2,144],97:[2,144],98:[2,144],99:[2,144],100:[2,144],101:[2,144],102:[2,144],103:[2,144],104:[2,144],105:[2,144],106:[2,144],107:[2,144],108:[2,144],109:[2,144],110:[2,144],111:[2,144],112:[2,144],113:[2,144],114:[2,144],115:[2,144],116:[2,144],117:[2,144],118:[2,144],119:[2,144],120:[2,144],121:[2,144],122:[2,144],123:[2,144],124:[2,144],125:[2,144],126:[2,144],127:[2,144],128:[2,144],129:[2,144],130:[2,144],131:[2,144],132:[2,144],134:[2,144],135:[2,144],137:[2,144],138:[2,144],140:[2,144],141:[2,144],142:[2,144],143:[2,144],144:[2,144],145:[2,144],146:[2,144],147:[2,144],148:[2,144],149:[2,144],150:[2,144],151:[2,144],152:[2,144],153:[2,144],154:[2,144],155:[2,144],156:[2,144],157:[2,144],158:[2,144],159:[2,144],160:[2,144],161:[2,144],162:[2,144],165:[2,144],166:[2,144],167:[2,144],168:[2,144],170:[2,144],171:[2,144],186:[2,144],189:[2,144],191:[2,144]},{6:[2,145],8:[2,145],10:[2,145],49:[2,145],50:[2,145],51:[2,145],53:[2,145],56:[2,145],57:[2,145],58:[2,145],59:[2,145],60:[2,145],61:[2,145],62:[2,145],63:[2,145],64:[2,145],65:[2,145],66:[2,145],67:[2,145],68:[2,145],69:[2,145],70:[2,145],71:[2,145],72:[2,145],73:[2,145],74:[2,145],75:[2,145],76:[2,145],77:[2,145],78:[2,145],79:[2,145],81:[2,145],82:[2,145],83:[2,145],84:[2,145],85:[2,145],86:[2,145],87:[2,145],88:[2,145],89:[2,145],90:[2,145],91:[2,145],92:[2,145],93:[2,145],94:[2,145],95:[2,145],96:[2,145],97:[2,145],98:[2,145],99:[2,145],100:[2,145],101:[2,145],102:[2,145],103:[2,145],104:[2,145],105:[2,145],106:[2,145],107:[2,145],108:[2,145],109:[2,145],110:[2,145],111:[2,145],112:[2,145],113:[2,145],114:[2,145],115:[2,145],116:[2,145],117:[2,145],118:[2,145],119:[2,145],120:[2,145],121:[2,145],122:[2,145],123:[2,145],124:[2,145],125:[2,145],126:[2,145],127:[2,145],128:[2,145],129:[2,145],130:[2,145],131:[2,145],132:[2,145],134:[2,145],135:[2,145],137:[2,145],138:[2,145],140:[2,145],141:[2,145],142:[2,145],143:[2,145],144:[2,145],145:[2,145],146:[2,145],147:[2,145],148:[2,145],149:[2,145],150:[2,145],151:[2,145],152:[2,145],153:[2,145],154:[2,145],155:[2,145],156:[2,145],157:[2,145],158:[2,145],159:[2,145],160:[2,145],161:[2,145],162:[2,145],165:[2,145],166:[2,145],167:[2,145],168:[2,145],170:[2,145],171:[2,145],186:[2,145],189:[2,145],191:[2,145]},{6:[2,146],8:[2,146],10:[2,146],49:[2,146],50:[2,146],51:[2,146],53:[2,146],56:[2,146],57:[2,146],58:[2,146],59:[2,146],60:[2,146],61:[2,146],62:[2,146],63:[2,146],64:[2,146],65:[2,146],66:[2,146],67:[2,146],68:[2,146],69:[2,146],70:[2,146],71:[2,146],72:[2,146],73:[2,146],74:[2,146],75:[2,146],76:[2,146],77:[2,146],78:[2,146],79:[2,146],81:[2,146],82:[2,146],83:[2,146],84:[2,146],85:[2,146],86:[2,146],87:[2,146],88:[2,146],89:[2,146],90:[2,146],91:[2,146],92:[2,146],93:[2,146],94:[2,146],95:[2,146],96:[2,146],97:[2,146],98:[2,146],99:[2,146],100:[2,146],101:[2,146],102:[2,146],103:[2,146],104:[2,146],105:[2,146],106:[2,146],107:[2,146],108:[2,146],109:[2,146],110:[2,146],111:[2,146],112:[2,146],113:[2,146],114:[2,146],115:[2,146],116:[2,146],117:[2,146],118:[2,146],119:[2,146],120:[2,146],121:[2,146],122:[2,146],123:[2,146],124:[2,146],125:[2,146],126:[2,146],127:[2,146],128:[2,146],129:[2,146],130:[2,146],131:[2,146],132:[2,146],134:[2,146],135:[2,146],137:[2,146],138:[2,146],140:[2,146],141:[2,146],142:[2,146],143:[2,146],144:[2,146],145:[2,146],146:[2,146],147:[2,146],148:[2,146],149:[2,146],150:[2,146],151:[2,146],152:[2,146],153:[2,146],154:[2,146],155:[2,146],156:[2,146],157:[2,146],158:[2,146],159:[2,146],160:[2,146],161:[2,146],162:[2,146],165:[2,146],166:[2,146],167:[2,146],168:[2,146],170:[2,146],171:[2,146],186:[2,146],189:[2,146],191:[2,146]},{6:[2,147],8:[2,147],10:[2,147],49:[2,147],50:[2,147],51:[2,147],53:[2,147],56:[2,147],57:[2,147],58:[2,147],59:[2,147],60:[2,147],61:[2,147],62:[2,147],63:[2,147],64:[2,147],65:[2,147],66:[2,147],67:[2,147],68:[2,147],69:[2,147],70:[2,147],71:[2,147],72:[2,147],73:[2,147],74:[2,147],75:[2,147],76:[2,147],77:[2,147],78:[2,147],79:[2,147],81:[2,147],82:[2,147],83:[2,147],84:[2,147],85:[2,147],86:[2,147],87:[2,147],88:[2,147],89:[2,147],90:[2,147],91:[2,147],92:[2,147],93:[2,147],94:[2,147],95:[2,147],96:[2,147],97:[2,147],98:[2,147],99:[2,147],100:[2,147],101:[2,147],102:[2,147],103:[2,147],104:[2,147],105:[2,147],106:[2,147],107:[2,147],108:[2,147],109:[2,147],110:[2,147],111:[2,147],112:[2,147],113:[2,147],114:[2,147],115:[2,147],116:[2,147],117:[2,147],118:[2,147],119:[2,147],120:[2,147],121:[2,147],122:[2,147],123:[2,147],124:[2,147],125:[2,147],126:[2,147],127:[2,147],128:[2,147],129:[2,147],130:[2,147],131:[2,147],132:[2,147],134:[2,147],135:[2,147],137:[2,147],138:[2,147],140:[2,147],141:[2,147],142:[2,147],143:[2,147],144:[2,147],145:[2,147],146:[2,147],147:[2,147],148:[2,147],149:[2,147],150:[2,147],151:[2,147],152:[2,147],153:[2,147],154:[2,147],155:[2,147],156:[2,147],157:[2,147],158:[2,147],159:[2,147],160:[2,147],161:[2,147],162:[2,147],165:[2,147],166:[2,147],167:[2,147],168:[2,147],170:[2,147],171:[2,147],186:[2,147],189:[2,147],191:[2,147]},{6:[2,148],8:[2,148],10:[2,148],49:[2,148],50:[2,148],51:[2,148],53:[2,148],56:[2,148],57:[2,148],58:[2,148],59:[2,148],60:[2,148],61:[2,148],62:[2,148],63:[2,148],64:[2,148],65:[2,148],66:[2,148],67:[2,148],68:[2,148],69:[2,148],70:[2,148],71:[2,148],72:[2,148],73:[2,148],74:[2,148],75:[2,148],76:[2,148],77:[2,148],78:[2,148],79:[2,148],81:[2,148],82:[2,148],83:[2,148],84:[2,148],85:[2,148],86:[2,148],87:[2,148],88:[2,148],89:[2,148],90:[2,148],91:[2,148],92:[2,148],93:[2,148],94:[2,148],95:[2,148],96:[2,148],97:[2,148],98:[2,148],99:[2,148],100:[2,148],101:[2,148],102:[2,148],103:[2,148],104:[2,148],105:[2,148],106:[2,148],107:[2,148],108:[2,148],109:[2,148],110:[2,148],111:[2,148],112:[2,148],113:[2,148],114:[2,148],115:[2,148],116:[2,148],117:[2,148],118:[2,148],119:[2,148],120:[2,148],121:[2,148],122:[2,148],123:[2,148],124:[2,148],125:[2,148],126:[2,148],127:[2,148],128:[2,148],129:[2,148],130:[2,148],131:[2,148],132:[2,148],134:[2,148],135:[2,148],137:[2,148],138:[2,148],140:[2,148],141:[2,148],142:[2,148],143:[2,148],144:[2,148],145:[2,148],146:[2,148],147:[2,148],148:[2,148],149:[2,148],150:[2,148],151:[2,148],152:[2,148],153:[2,148],154:[2,148],155:[2,148],156:[2,148],157:[2,148],158:[2,148],159:[2,148],160:[2,148],161:[2,148],162:[2,148],165:[2,148],166:[2,148],167:[2,148],168:[2,148],170:[2,148],171:[2,148],186:[2,148],189:[2,148],191:[2,148]},{6:[2,149],8:[2,149],10:[2,149],49:[2,149],50:[2,149],51:[2,149],53:[2,149],56:[2,149],57:[2,149],58:[2,149],59:[2,149],60:[2,149],61:[2,149],62:[2,149],63:[2,149],64:[2,149],65:[2,149],66:[2,149],67:[2,149],68:[2,149],69:[2,149],70:[2,149],71:[2,149],72:[2,149],73:[2,149],74:[2,149],75:[2,149],76:[2,149],77:[2,149],78:[2,149],79:[2,149],81:[2,149],82:[2,149],83:[2,149],84:[2,149],85:[2,149],86:[2,149],87:[2,149],88:[2,149],89:[2,149],90:[2,149],91:[2,149],92:[2,149],93:[2,149],94:[2,149],95:[2,149],96:[2,149],97:[2,149],98:[2,149],99:[2,149],100:[2,149],101:[2,149],102:[2,149],103:[2,149],104:[2,149],105:[2,149],106:[2,149],107:[2,149],108:[2,149],109:[2,149],110:[2,149],111:[2,149],112:[2,149],113:[2,149],114:[2,149],115:[2,149],116:[2,149],117:[2,149],118:[2,149],119:[2,149],120:[2,149],121:[2,149],122:[2,149],123:[2,149],124:[2,149],125:[2,149],126:[2,149],127:[2,149],128:[2,149],129:[2,149],130:[2,149],131:[2,149],132:[2,149],134:[2,149],135:[2,149],137:[2,149],138:[2,149],140:[2,149],141:[2,149],142:[2,149],143:[2,149],144:[2,149],145:[2,149],146:[2,149],147:[2,149],148:[2,149],149:[2,149],150:[2,149],151:[2,149],152:[2,149],153:[2,149],154:[2,149],155:[2,149],156:[2,149],157:[2,149],158:[2,149],159:[2,149],160:[2,149],161:[2,149],162:[2,149],165:[2,149],166:[2,149],167:[2,149],168:[2,149],170:[2,149],171:[2,149],186:[2,149],189:[2,149],191:[2,149]},{6:[2,150],8:[2,150],10:[2,150],49:[2,150],50:[2,150],51:[2,150],53:[2,150],56:[2,150],57:[2,150],58:[2,150],59:[2,150],60:[2,150],61:[2,150],62:[2,150],63:[2,150],64:[2,150],65:[2,150],66:[2,150],67:[2,150],68:[2,150],69:[2,150],70:[2,150],71:[2,150],72:[2,150],73:[2,150],74:[2,150],75:[2,150],76:[2,150],77:[2,150],78:[2,150],79:[2,150],81:[2,150],82:[2,150],83:[2,150],84:[2,150],85:[2,150],86:[2,150],87:[2,150],88:[2,150],89:[2,150],90:[2,150],91:[2,150],92:[2,150],93:[2,150],94:[2,150],95:[2,150],96:[2,150],97:[2,150],98:[2,150],99:[2,150],100:[2,150],101:[2,150],102:[2,150],103:[2,150],104:[2,150],105:[2,150],106:[2,150],107:[2,150],108:[2,150],109:[2,150],110:[2,150],111:[2,150],112:[2,150],113:[2,150],114:[2,150],115:[2,150],116:[2,150],117:[2,150],118:[2,150],119:[2,150],120:[2,150],121:[2,150],122:[2,150],123:[2,150],124:[2,150],125:[2,150],126:[2,150],127:[2,150],128:[2,150],129:[2,150],130:[2,150],131:[2,150],132:[2,150],134:[2,150],135:[2,150],137:[2,150],138:[2,150],140:[2,150],141:[2,150],142:[2,150],143:[2,150],144:[2,150],145:[2,150],146:[2,150],147:[2,150],148:[2,150],149:[2,150],150:[2,150],151:[2,150],152:[2,150],153:[2,150],154:[2,150],155:[2,150],156:[2,150],157:[2,150],158:[2,150],159:[2,150],160:[2,150],161:[2,150],162:[2,150],165:[2,150],166:[2,150],167:[2,150],168:[2,150],170:[2,150],171:[2,150],186:[2,150],189:[2,150],191:[2,150]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:332,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],160:[2,193],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{160:[1,333],189:[1,265]},{10:[1,334],189:[1,265]},{10:[1,335],189:[1,265]},{8:[1,336]},{6:[2,2],8:[2,2],10:[2,2],19:[2,2],21:[2,2],23:[2,2],25:[2,2],27:[2,2],29:[2,2],31:[2,2],33:[2,2],35:[2,2],37:[2,2],39:[2,2],41:[2,2],49:[2,2],50:[2,2],51:[2,2],53:[2,2],56:[2,2],57:[2,2],58:[2,2],59:[2,2],60:[2,2],61:[2,2],62:[2,2],63:[2,2],64:[2,2],65:[2,2],66:[2,2],67:[2,2],68:[2,2],69:[2,2],70:[2,2],71:[2,2],72:[2,2],73:[2,2],74:[2,2],75:[2,2],76:[2,2],77:[2,2],78:[2,2],79:[2,2],81:[2,2],82:[2,2],83:[2,2],84:[2,2],85:[2,2],86:[2,2],87:[2,2],88:[2,2],89:[2,2],90:[2,2],91:[2,2],92:[2,2],93:[2,2],94:[2,2],95:[2,2],96:[2,2],97:[2,2],98:[2,2],99:[2,2],100:[2,2],101:[2,2],102:[2,2],103:[2,2],104:[2,2],105:[2,2],106:[2,2],107:[2,2],108:[2,2],109:[2,2],110:[2,2],111:[2,2],112:[2,2],113:[2,2],114:[2,2],115:[2,2],116:[2,2],117:[2,2],118:[2,2],119:[2,2],120:[2,2],121:[2,2],122:[2,2],123:[2,2],124:[2,2],125:[2,2],126:[2,2],127:[2,2],128:[2,2],129:[2,2],130:[2,2],131:[2,2],132:[2,2],134:[2,2],135:[2,2],137:[2,2],138:[2,2],140:[2,2],141:[2,2],142:[2,2],143:[2,2],144:[2,2],145:[2,2],146:[2,2],147:[2,2],148:[2,2],149:[2,2],150:[2,2],151:[2,2],152:[2,2],153:[2,2],154:[2,2],155:[2,2],156:[2,2],157:[2,2],158:[2,2],159:[2,2],160:[2,2],161:[2,2],162:[2,2],165:[2,2],166:[2,2],167:[2,2],168:[2,2],170:[2,2],171:[2,2],176:[2,2],177:[2,2],178:[2,2],179:[2,2],180:[2,2],181:[2,2],182:[2,2],184:[2,2],186:[2,2],188:[2,2],189:[2,2],191:[2,2]},{6:[2,183],8:[2,183],10:[2,183],49:[2,183],50:[2,183],51:[2,183],53:[2,183],56:[2,183],57:[2,183],58:[2,183],59:[2,183],60:[2,183],61:[2,183],62:[2,183],63:[2,183],64:[2,183],65:[2,183],66:[2,183],67:[2,183],68:[2,183],69:[2,183],70:[2,183],71:[2,183],72:[2,183],73:[2,183],74:[2,183],75:[2,183],76:[2,183],77:[2,183],78:[2,183],79:[2,183],81:[2,183],82:[2,183],83:[2,183],84:[2,183],85:[2,183],86:[2,183],87:[2,183],88:[2,183],89:[2,183],90:[2,183],91:[2,183],92:[2,183],93:[2,183],94:[2,183],95:[2,183],96:[2,183],97:[2,183],98:[2,183],99:[2,183],100:[2,183],101:[2,183],102:[2,183],103:[2,183],104:[2,183],105:[2,183],106:[2,183],107:[2,183],108:[2,183],109:[2,183],110:[2,183],111:[2,183],112:[2,183],113:[2,183],114:[2,183],115:[2,183],116:[2,183],117:[2,183],118:[2,183],119:[2,183],120:[2,183],121:[2,183],122:[2,183],123:[2,183],124:[2,183],125:[2,183],126:[2,183],127:[2,183],128:[2,183],129:[2,183],130:[2,183],131:[2,183],132:[2,183],135:[2,183],137:[2,183],138:[2,183],140:[2,183],141:[2,183],142:[2,183],143:[2,183],144:[2,183],145:[2,183],146:[2,183],147:[2,183],148:[2,183],149:[2,183],150:[2,183],151:[2,183],152:[2,183],153:[2,183],154:[2,183],155:[2,183],156:[2,183],157:[2,183],158:[2,183],159:[2,183],160:[2,183],161:[2,183],162:[2,183],165:[2,183],166:[2,183],167:[2,183],170:[2,183],171:[2,183],186:[2,183],189:[2,183],191:[2,183]},{10:[1,337],165:[1,223],166:[1,224],174:284},{6:[2,179],8:[2,179],10:[2,179],49:[2,179],50:[2,179],51:[2,179],53:[2,179],56:[2,179],57:[2,179],58:[2,179],59:[2,179],60:[2,179],61:[2,179],62:[2,179],63:[2,179],64:[2,179],65:[2,179],66:[2,179],67:[2,179],68:[2,179],69:[2,179],70:[2,179],71:[2,179],72:[2,179],73:[2,179],74:[2,179],75:[2,179],76:[2,179],77:[2,179],78:[2,179],79:[2,179],81:[2,179],82:[2,179],83:[2,179],84:[2,179],85:[2,179],86:[2,179],87:[2,179],88:[2,179],89:[2,179],90:[2,179],91:[2,179],92:[2,179],93:[2,179],94:[2,179],95:[2,179],96:[2,179],97:[2,179],98:[2,179],99:[2,179],100:[2,179],101:[2,179],102:[2,179],103:[2,179],104:[2,179],105:[2,179],106:[2,179],107:[2,179],108:[2,179],109:[2,179],110:[2,179],111:[2,179],112:[2,179],113:[2,179],114:[2,179],115:[2,179],116:[2,179],117:[2,179],118:[2,179],119:[2,179],120:[2,179],121:[2,179],122:[2,179],123:[2,179],124:[2,179],125:[2,179],126:[2,179],127:[2,179],128:[2,179],129:[2,179],130:[2,179],131:[2,179],132:[2,179],135:[2,179],137:[2,179],138:[2,179],140:[2,179],141:[2,179],142:[2,179],143:[2,179],144:[2,179],145:[2,179],146:[2,179],147:[2,179],148:[2,179],149:[2,179],150:[2,179],151:[2,179],152:[2,179],153:[2,179],154:[2,179],155:[2,179],156:[2,179],157:[2,179],158:[2,179],159:[2,179],160:[2,179],161:[2,179],162:[2,179],165:[2,179],166:[1,338],167:[2,179],170:[2,179],171:[2,179],186:[2,179],189:[2,179],191:[2,179]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:288,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],169:289,170:[1,109],171:[1,110],173:339},{6:[2,176],8:[2,176],10:[2,176],49:[2,176],50:[2,176],51:[2,176],53:[2,176],56:[2,176],57:[2,176],58:[2,176],59:[2,176],60:[2,176],61:[2,176],62:[2,176],63:[2,176],64:[2,176],65:[2,176],66:[2,176],67:[2,176],68:[2,176],69:[2,176],70:[2,176],71:[2,176],72:[2,176],73:[2,176],74:[2,176],75:[2,176],76:[2,176],77:[2,176],78:[2,176],79:[2,176],81:[2,176],82:[2,176],83:[2,176],84:[2,176],85:[2,176],86:[2,176],87:[2,176],88:[2,176],89:[2,176],90:[2,176],91:[2,176],92:[2,176],93:[2,176],94:[2,176],95:[2,176],96:[2,176],97:[2,176],98:[2,176],99:[2,176],100:[2,176],101:[2,176],102:[2,176],103:[2,176],104:[2,176],105:[2,176],106:[2,176],107:[2,176],108:[2,176],109:[2,176],110:[2,176],111:[2,176],112:[2,176],113:[2,176],114:[2,176],115:[2,176],116:[2,176],117:[2,176],118:[2,176],119:[2,176],120:[2,176],121:[2,176],122:[2,176],123:[2,176],124:[2,176],125:[2,176],126:[2,176],127:[2,176],128:[2,176],129:[2,176],130:[2,176],131:[2,176],132:[2,176],135:[2,176],137:[2,176],138:[2,176],140:[2,176],141:[2,176],142:[2,176],143:[2,176],144:[2,176],145:[2,176],146:[2,176],147:[2,176],148:[2,176],149:[2,176],150:[2,176],151:[2,176],152:[2,176],153:[2,176],154:[2,176],155:[2,176],156:[2,176],157:[2,176],158:[2,176],159:[2,176],160:[2,176],161:[2,176],162:[2,176],165:[2,176],166:[2,176],167:[2,176],170:[2,176],171:[2,176],186:[2,176],189:[2,176],191:[2,176]},{6:[2,177],8:[2,177],10:[2,177],49:[2,177],50:[2,177],51:[2,177],53:[2,177],56:[2,177],57:[2,177],58:[2,177],59:[2,177],60:[2,177],61:[2,177],62:[2,177],63:[2,177],64:[2,177],65:[2,177],66:[2,177],67:[2,177],68:[2,177],69:[2,177],70:[2,177],71:[2,177],72:[2,177],73:[2,177],74:[2,177],75:[2,177],76:[2,177],77:[2,177],78:[2,177],79:[2,177],81:[2,177],82:[2,177],83:[2,177],84:[2,177],85:[2,177],86:[2,177],87:[2,177],88:[2,177],89:[2,177],90:[2,177],91:[2,177],92:[2,177],93:[2,177],94:[2,177],95:[2,177],96:[2,177],97:[2,177],98:[2,177],99:[2,177],100:[2,177],101:[2,177],102:[2,177],103:[2,177],104:[2,177],105:[2,177],106:[2,177],107:[2,177],108:[2,177],109:[2,177],110:[2,177],111:[2,177],112:[2,177],113:[2,177],114:[2,177],115:[2,177],116:[2,177],117:[2,177],118:[2,177],119:[2,177],120:[2,177],121:[2,177],122:[2,177],123:[2,177],124:[2,177],125:[2,177],126:[2,177],127:[2,177],128:[2,177],129:[2,177],130:[2,177],131:[2,177],132:[2,177],135:[2,177],137:[2,177],138:[2,177],140:[2,177],141:[2,177],142:[2,177],143:[2,177],144:[2,177],145:[2,177],146:[2,177],147:[2,177],148:[2,177],149:[2,177],150:[2,177],151:[2,177],152:[2,177],153:[2,177],154:[2,177],155:[2,177],156:[2,177],157:[2,177],158:[2,177],159:[2,177],160:[2,177],161:[2,177],162:[2,177],165:[2,177],166:[2,177],167:[2,177],170:[2,177],171:[2,177],186:[2,177],189:[2,177],191:[2,177]},{6:[2,180],8:[2,180],10:[2,180],49:[2,180],50:[2,180],51:[2,180],53:[2,180],56:[2,180],57:[2,180],58:[2,180],59:[2,180],60:[2,180],61:[2,180],62:[2,180],63:[2,180],64:[2,180],65:[2,180],66:[2,180],67:[2,180],68:[2,180],69:[2,180],70:[2,180],71:[2,180],72:[2,180],73:[2,180],74:[2,180],75:[2,180],76:[2,180],77:[2,180],78:[2,180],79:[2,180],81:[2,180],82:[2,180],83:[2,180],84:[2,180],85:[2,180],86:[2,180],87:[2,180],88:[2,180],89:[2,180],90:[2,180],91:[2,180],92:[2,180],93:[2,180],94:[2,180],95:[2,180],96:[2,180],97:[2,180],98:[2,180],99:[2,180],100:[2,180],101:[2,180],102:[2,180],103:[2,180],104:[2,180],105:[2,180],106:[2,180],107:[2,180],108:[2,180],109:[2,180],110:[2,180],111:[2,180],112:[2,180],113:[2,180],114:[2,180],115:[2,180],116:[2,180],117:[2,180],118:[2,180],119:[2,180],120:[2,180],121:[2,180],122:[2,180],123:[2,180],124:[2,180],125:[2,180],126:[2,180],127:[2,180],128:[2,180],129:[2,180],130:[2,180],131:[2,180],132:[2,180],135:[2,180],137:[2,180],138:[2,180],140:[2,180],141:[2,180],142:[2,180],143:[2,180],144:[2,180],145:[2,180],146:[2,180],147:[2,180],148:[2,180],149:[2,180],150:[2,180],151:[2,180],152:[2,180],153:[2,180],154:[2,180],155:[2,180],156:[2,180],157:[2,180],158:[2,180],159:[2,180],160:[2,180],161:[2,180],162:[2,180],165:[2,180],166:[2,180],167:[2,180],170:[2,180],171:[2,180],186:[2,180],189:[2,180],191:[2,180]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:340,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,160],8:[2,160],10:[2,160],49:[2,160],50:[2,160],51:[2,160],53:[2,160],56:[2,160],57:[2,160],58:[2,160],59:[2,160],60:[2,160],61:[2,160],62:[2,160],63:[2,160],64:[2,160],65:[2,160],66:[2,160],67:[2,160],68:[2,160],69:[2,160],70:[2,160],71:[2,160],72:[2,160],73:[2,160],74:[2,160],75:[2,160],76:[2,160],77:[2,160],78:[2,160],79:[2,160],81:[2,160],82:[2,160],83:[2,160],84:[2,160],85:[2,160],86:[2,160],87:[2,160],88:[2,160],89:[2,160],90:[2,160],91:[2,160],92:[2,160],93:[2,160],94:[2,160],95:[2,160],96:[2,160],97:[2,160],98:[2,160],99:[2,160],100:[2,160],101:[2,160],102:[2,160],103:[2,160],104:[2,160],105:[2,160],106:[2,160],107:[2,160],108:[2,160],109:[2,160],110:[2,160],111:[2,160],112:[2,160],113:[2,160],114:[2,160],115:[2,160],116:[2,160],117:[2,160],118:[2,160],119:[2,160],120:[2,160],121:[2,160],122:[2,160],123:[2,160],124:[2,160],125:[2,160],126:[2,160],127:[2,160],128:[2,160],129:[2,160],130:[2,160],131:[2,160],132:[2,160],135:[2,160],137:[2,160],138:[2,160],140:[2,160],141:[2,160],142:[2,160],143:[2,160],144:[2,160],145:[2,160],146:[2,160],147:[2,160],148:[2,160],149:[2,160],150:[2,160],151:[2,160],152:[2,160],153:[2,160],154:[2,160],155:[2,160],156:[2,160],157:[2,160],158:[2,160],159:[2,160],160:[2,160],161:[2,160],162:[2,160],167:[2,160],170:[2,160],171:[2,160],186:[2,160],189:[2,160],191:[2,160]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:341,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:342,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:343,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{10:[1,344]},{10:[1,345]},{10:[1,346]},{52:347,53:[1,238]},{52:348,53:[1,238]},{52:349,53:[1,238]},{6:[2,46],8:[2,46],10:[2,46],49:[2,46],50:[2,46],51:[2,46],53:[2,46],56:[2,46],57:[2,46],58:[2,46],59:[2,46],60:[2,46],61:[2,46],62:[2,46],63:[2,46],64:[2,46],65:[2,46],66:[2,46],67:[2,46],68:[2,46],69:[2,46],70:[2,46],71:[2,46],72:[2,46],73:[2,46],74:[2,46],75:[2,46],76:[2,46],77:[2,46],78:[2,46],79:[2,46],81:[2,46],82:[2,46],83:[2,46],84:[2,46],85:[2,46],86:[2,46],87:[2,46],88:[2,46],89:[2,46],90:[2,46],91:[2,46],92:[2,46],93:[2,46],94:[2,46],95:[2,46],96:[2,46],97:[2,46],98:[2,46],99:[2,46],100:[2,46],101:[2,46],102:[2,46],103:[2,46],104:[2,46],105:[2,46],106:[2,46],107:[2,46],108:[2,46],109:[2,46],110:[2,46],111:[2,46],112:[2,46],113:[2,46],114:[2,46],115:[2,46],116:[2,46],117:[2,46],118:[2,46],119:[2,46],120:[2,46],121:[2,46],122:[2,46],123:[2,46],124:[2,46],125:[2,46],126:[2,46],127:[2,46],128:[2,46],129:[2,46],130:[2,46],131:[2,46],132:[2,46],134:[2,46],135:[2,46],137:[2,46],138:[2,46],140:[2,46],141:[2,46],142:[2,46],143:[2,46],144:[2,46],145:[2,46],146:[2,46],147:[2,46],148:[2,46],149:[2,46],150:[2,46],151:[2,46],152:[2,46],153:[2,46],154:[2,46],155:[2,46],156:[2,46],157:[2,46],158:[2,46],159:[2,46],160:[2,46],161:[2,46],162:[2,46],165:[2,46],166:[2,46],167:[2,46],168:[2,46],170:[2,46],171:[2,46],186:[2,46],189:[2,46],191:[2,46]},{6:[2,47],8:[2,47],10:[2,47],49:[2,47],50:[2,47],51:[2,47],53:[2,47],56:[2,47],57:[2,47],58:[2,47],59:[2,47],60:[2,47],61:[2,47],62:[2,47],63:[2,47],64:[2,47],65:[2,47],66:[2,47],67:[2,47],68:[2,47],69:[2,47],70:[2,47],71:[2,47],72:[2,47],73:[2,47],74:[2,47],75:[2,47],76:[2,47],77:[2,47],78:[2,47],79:[2,47],81:[2,47],82:[2,47],83:[2,47],84:[2,47],85:[2,47],86:[2,47],87:[2,47],88:[2,47],89:[2,47],90:[2,47],91:[2,47],92:[2,47],93:[2,47],94:[2,47],95:[2,47],96:[2,47],97:[2,47],98:[2,47],99:[2,47],100:[2,47],101:[2,47],102:[2,47],103:[2,47],104:[2,47],105:[2,47],106:[2,47],107:[2,47],108:[2,47],109:[2,47],110:[2,47],111:[2,47],112:[2,47],113:[2,47],114:[2,47],115:[2,47],116:[2,47],117:[2,47],118:[2,47],119:[2,47],120:[2,47],121:[2,47],122:[2,47],123:[2,47],124:[2,47],125:[2,47],126:[2,47],127:[2,47],128:[2,47],129:[2,47],130:[2,47],131:[2,47],132:[2,47],134:[2,47],135:[2,47],137:[2,47],138:[2,47],140:[2,47],141:[2,47],142:[2,47],143:[2,47],144:[2,47],145:[2,47],146:[2,47],147:[2,47],148:[2,47],149:[2,47],150:[2,47],151:[2,47],152:[2,47],153:[2,47],154:[2,47],155:[2,47],156:[2,47],157:[2,47],158:[2,47],159:[2,47],160:[2,47],161:[2,47],162:[2,47],165:[2,47],166:[2,47],167:[2,47],168:[2,47],170:[2,47],171:[2,47],186:[2,47],189:[2,47],191:[2,47]},{6:[2,78],8:[2,78],10:[2,78],49:[2,78],50:[2,78],51:[2,78],53:[2,78],56:[2,78],57:[2,78],58:[2,78],59:[2,78],60:[2,78],61:[2,78],62:[2,78],63:[2,78],64:[2,78],65:[2,78],66:[2,78],67:[2,78],68:[2,78],69:[2,78],70:[2,78],71:[2,78],72:[2,78],73:[2,78],74:[2,78],75:[2,78],76:[2,78],77:[2,78],78:[2,78],79:[2,78],81:[2,78],82:[2,78],83:[2,78],84:[2,78],85:[2,78],86:[2,78],87:[2,78],88:[2,78],89:[2,78],90:[2,78],91:[2,78],92:[2,78],93:[2,78],94:[2,78],95:[2,78],96:[2,78],97:[2,78],98:[2,78],99:[2,78],100:[2,78],101:[2,78],102:[2,78],103:[2,78],104:[2,78],105:[2,78],106:[2,78],107:[2,78],108:[2,78],109:[2,78],110:[2,78],111:[2,78],112:[2,78],113:[2,78],114:[2,78],115:[2,78],116:[2,78],117:[2,78],118:[2,78],119:[2,78],120:[2,78],121:[2,78],122:[2,78],123:[2,78],124:[2,78],125:[2,78],126:[2,78],127:[2,78],128:[2,78],129:[2,78],130:[2,78],131:[2,78],132:[2,78],134:[2,78],135:[2,78],137:[2,78],138:[2,78],140:[2,78],141:[2,78],142:[2,78],143:[2,78],144:[2,78],145:[2,78],146:[2,78],147:[2,78],148:[2,78],149:[2,78],150:[2,78],151:[2,78],152:[2,78],153:[2,78],154:[2,78],155:[2,78],156:[2,78],157:[2,78],158:[2,78],159:[2,78],160:[2,78],161:[2,78],162:[2,78],165:[2,78],166:[2,78],167:[2,78],168:[2,78],170:[2,78],171:[2,78],186:[2,78],189:[2,78],191:[2,78]},{4:[2,1],8:[2,1]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:350,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,92],8:[2,92],10:[2,92],49:[2,92],50:[2,92],51:[2,92],53:[2,92],56:[2,92],57:[2,92],58:[2,92],59:[2,92],60:[2,92],61:[2,92],62:[2,92],63:[2,92],64:[2,92],65:[2,92],66:[2,92],67:[2,92],68:[2,92],69:[2,92],70:[2,92],71:[2,92],72:[2,92],73:[2,92],74:[2,92],75:[2,92],76:[2,92],77:[2,92],78:[2,92],79:[2,92],81:[2,92],82:[2,92],83:[2,92],84:[2,92],85:[2,92],86:[2,92],87:[2,92],88:[2,92],89:[2,92],90:[2,92],91:[2,92],92:[2,92],93:[2,92],94:[2,92],95:[2,92],96:[2,92],97:[2,92],98:[2,92],99:[2,92],100:[2,92],101:[2,92],102:[2,92],103:[2,92],104:[2,92],105:[2,92],106:[2,92],107:[2,92],108:[2,92],109:[2,92],110:[2,92],111:[2,92],112:[2,92],113:[2,92],114:[2,92],115:[2,92],116:[2,92],117:[2,92],118:[2,92],119:[2,92],120:[2,92],121:[2,92],122:[2,92],123:[2,92],124:[2,92],125:[2,92],126:[2,92],127:[2,92],128:[2,92],129:[2,92],130:[2,92],131:[2,92],132:[2,92],134:[2,92],135:[2,92],137:[2,92],138:[2,92],140:[2,92],141:[2,92],142:[2,92],143:[2,92],144:[2,92],145:[2,92],146:[2,92],147:[2,92],148:[2,92],149:[2,92],150:[2,92],151:[2,92],152:[2,92],153:[2,92],154:[2,92],155:[2,92],156:[2,92],157:[2,92],158:[2,92],159:[2,92],160:[2,92],161:[2,92],162:[2,92],165:[2,92],166:[2,92],167:[2,92],168:[2,92],170:[2,92],171:[2,92],186:[2,92],189:[2,92],191:[2,92]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:351,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,118],8:[2,118],10:[2,118],49:[2,118],50:[2,118],51:[2,118],53:[2,118],56:[2,118],57:[2,118],58:[2,118],59:[2,118],60:[2,118],61:[2,118],62:[2,118],63:[2,118],64:[2,118],65:[2,118],66:[2,118],67:[2,118],68:[2,118],69:[2,118],70:[2,118],71:[2,118],72:[2,118],73:[2,118],74:[2,118],75:[2,118],76:[2,118],77:[2,118],78:[2,118],79:[2,118],81:[2,118],82:[2,118],83:[2,118],84:[2,118],85:[2,118],86:[2,118],87:[2,118],88:[2,118],89:[2,118],90:[2,118],91:[2,118],92:[2,118],93:[2,118],94:[2,118],95:[2,118],96:[2,118],97:[2,118],98:[2,118],99:[2,118],100:[2,118],101:[2,118],102:[2,118],103:[2,118],104:[2,118],105:[2,118],106:[2,118],107:[2,118],108:[2,118],109:[2,118],110:[2,118],111:[2,118],112:[2,118],113:[2,118],114:[2,118],115:[2,118],116:[2,118],117:[2,118],118:[2,118],119:[2,118],120:[2,118],121:[2,118],122:[2,118],123:[2,118],124:[2,118],125:[2,118],126:[2,118],127:[2,118],128:[2,118],129:[2,118],130:[2,118],131:[2,118],132:[2,118],134:[2,118],135:[2,118],137:[2,118],138:[2,118],140:[2,118],141:[2,118],142:[2,118],143:[2,118],144:[2,118],145:[2,118],146:[2,118],147:[2,118],148:[2,118],149:[2,118],150:[2,118],151:[2,118],152:[2,118],153:[2,118],154:[2,118],155:[2,118],156:[2,118],157:[2,118],158:[2,118],159:[2,118],160:[2,118],161:[2,118],162:[2,118],165:[2,118],166:[2,118],167:[2,118],168:[2,118],170:[2,118],171:[2,118],186:[2,118],189:[2,118],191:[2,118]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:352,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{6:[2,120],8:[2,120],10:[2,120],49:[2,120],50:[2,120],51:[2,120],53:[2,120],56:[2,120],57:[2,120],58:[2,120],59:[2,120],60:[2,120],61:[2,120],62:[2,120],63:[2,120],64:[2,120],65:[2,120],66:[2,120],67:[2,120],68:[2,120],69:[2,120],70:[2,120],71:[2,120],72:[2,120],73:[2,120],74:[2,120],75:[2,120],76:[2,120],77:[2,120],78:[2,120],79:[2,120],81:[2,120],82:[2,120],83:[2,120],84:[2,120],85:[2,120],86:[2,120],87:[2,120],88:[2,120],89:[2,120],90:[2,120],91:[2,120],92:[2,120],93:[2,120],94:[2,120],95:[2,120],96:[2,120],97:[2,120],98:[2,120],99:[2,120],100:[2,120],101:[2,120],102:[2,120],103:[2,120],104:[2,120],105:[2,120],106:[2,120],107:[2,120],108:[2,120],109:[2,120],110:[2,120],111:[2,120],112:[2,120],113:[2,120],114:[2,120],115:[2,120],116:[2,120],117:[2,120],118:[2,120],119:[2,120],120:[2,120],121:[2,120],122:[2,120],123:[2,120],124:[2,120],125:[2,120],126:[2,120],127:[2,120],128:[2,120],129:[2,120],130:[2,120],131:[2,120],132:[2,120],134:[2,120],135:[2,120],137:[2,120],138:[2,120],140:[2,120],141:[2,120],142:[2,120],143:[2,120],144:[2,120],145:[2,120],146:[2,120],147:[2,120],148:[2,120],149:[2,120],150:[2,120],151:[2,120],152:[2,120],153:[2,120],154:[2,120],155:[2,120],156:[2,120],157:[2,120],158:[2,120],159:[2,120],160:[2,120],161:[2,120],162:[2,120],165:[2,120],166:[2,120],167:[2,120],168:[2,120],170:[2,120],171:[2,120],186:[2,120],189:[2,120],191:[2,120]},{6:[1,353]},{4:[2,4],8:[2,4],49:[2,4],50:[2,4],51:[2,4],56:[2,4],57:[2,4],58:[2,4],59:[2,4],60:[2,4],61:[2,4],62:[2,4],63:[2,4],67:[2,4],68:[2,4],69:[2,4],70:[2,4],71:[2,4],72:[2,4],73:[2,4],74:[2,4],75:[2,4],76:[2,4],77:[2,4],78:[2,4],79:[2,4],81:[2,4],82:[2,4],83:[2,4],84:[2,4],85:[2,4],86:[2,4],87:[2,4],88:[2,4],89:[2,4],90:[2,4],91:[2,4],92:[2,4],93:[2,4],94:[2,4],95:[2,4],96:[2,4],97:[2,4],98:[2,4],99:[2,4],100:[2,4],101:[2,4],102:[2,4],103:[2,4],104:[2,4],105:[2,4],106:[2,4],107:[2,4],108:[2,4],109:[2,4],110:[2,4],111:[2,4],112:[2,4],113:[2,4],114:[2,4],115:[2,4],116:[2,4],117:[2,4],118:[2,4],119:[2,4],120:[2,4],121:[2,4],122:[2,4],123:[2,4],124:[2,4],125:[2,4],126:[2,4],127:[2,4],128:[2,4],129:[2,4],130:[2,4],131:[2,4],132:[2,4],135:[2,4],137:[2,4],138:[2,4],141:[2,4],143:[2,4],145:[2,4],147:[2,4],149:[2,4],151:[2,4],153:[2,4],155:[2,4],157:[2,4],159:[2,4],161:[2,4],162:[2,4]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:354,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108]},{8:[1,355]},{10:[2,201],140:[2,201],142:[2,201],144:[2,201],146:[2,201],148:[2,201],150:[2,201],152:[2,201],154:[2,201],156:[2,201],158:[2,201],160:[2,201],189:[2,201]},{10:[1,356],20:319,21:[1,321],22:320,23:[1,322],44:357},{10:[2,42],21:[2,42],23:[2,42]},{10:[2,28],21:[2,28],23:[2,28]},{10:[2,29],21:[2,29],23:[2,29]},{7:116,8:[1,117],14:358},{7:116,8:[1,117],14:359},{10:[2,197],140:[2,197],142:[2,197],144:[2,197],146:[2,197],148:[2,197],150:[2,197],152:[2,197],154:[2,197],156:[2,197],158:[2,197],160:[2,197],186:[2,197],189:[2,197]},{10:[1,360],20:326,21:[1,321],22:327,23:[1,322],24:328,25:[1,330],26:329,27:[1,331],42:361},{10:[2,26],21:[2,26],23:[2,26],25:[2,26],27:[2,26]},{10:[2,22],21:[2,22],23:[2,22],25:[2,22],27:[2,22]},{10:[2,23],21:[2,23],23:[2,23],25:[2,23],27:[2,23]},{10:[2,24],21:[2,24],23:[2,24],25:[2,24],27:[2,24]},{10:[2,25],21:[2,25],23:[2,25],25:[2,25],27:[2,25]},{7:116,8:[1,117],14:362},{7:116,8:[1,117],14:363},{160:[1,364],189:[1,265]},{6:[2,152],8:[2,152],10:[2,152],49:[2,152],50:[2,152],51:[2,152],53:[2,152],56:[2,152],57:[2,152],58:[2,152],59:[2,152],60:[2,152],61:[2,152],62:[2,152],63:[2,152],64:[2,152],65:[2,152],66:[2,152],67:[2,152],68:[2,152],69:[2,152],70:[2,152],71:[2,152],72:[2,152],73:[2,152],74:[2,152],75:[2,152],76:[2,152],77:[2,152],78:[2,152],79:[2,152],81:[2,152],82:[2,152],83:[2,152],84:[2,152],85:[2,152],86:[2,152],87:[2,152],88:[2,152],89:[2,152],90:[2,152],91:[2,152],92:[2,152],93:[2,152],94:[2,152],95:[2,152],96:[2,152],97:[2,152],98:[2,152],99:[2,152],100:[2,152],101:[2,152],102:[2,152],103:[2,152],104:[2,152],105:[2,152],106:[2,152],107:[2,152],108:[2,152],109:[2,152],110:[2,152],111:[2,152],112:[2,152],113:[2,152],114:[2,152],115:[2,152],116:[2,152],117:[2,152],118:[2,152],119:[2,152],120:[2,152],121:[2,152],122:[2,152],123:[2,152],124:[2,152],125:[2,152],126:[2,152],127:[2,152],128:[2,152],129:[2,152],130:[2,152],131:[2,152],132:[2,152],134:[2,152],135:[2,152],137:[2,152],138:[2,152],140:[2,152],141:[2,152],142:[2,152],143:[2,152],144:[2,152],145:[2,152],146:[2,152],147:[2,152],148:[2,152],149:[2,152],150:[2,152],151:[2,152],152:[2,152],153:[2,152],154:[2,152],155:[2,152],156:[2,152],157:[2,152],158:[2,152],159:[2,152],160:[2,152],161:[2,152],162:[2,152],165:[2,152],166:[2,152],167:[2,152],168:[2,152],170:[2,152],171:[2,152],186:[2,152],189:[2,152],191:[2,152]},{6:[2,153],8:[2,153],10:[2,153],49:[2,153],50:[2,153],51:[2,153],53:[2,153],56:[2,153],57:[2,153],58:[2,153],59:[2,153],60:[2,153],61:[2,153],62:[2,153],63:[2,153],64:[2,153],65:[2,153],66:[2,153],67:[2,153],68:[2,153],69:[2,153],70:[2,153],71:[2,153],72:[2,153],73:[2,153],74:[2,153],75:[2,153],76:[2,153],77:[2,153],78:[2,153],79:[2,153],81:[2,153],82:[2,153],83:[2,153],84:[2,153],85:[2,153],86:[2,153],87:[2,153],88:[2,153],89:[2,153],90:[2,153],91:[2,153],92:[2,153],93:[2,153],94:[2,153],95:[2,153],96:[2,153],97:[2,153],98:[2,153],99:[2,153],100:[2,153],101:[2,153],102:[2,153],103:[2,153],104:[2,153],105:[2,153],106:[2,153],107:[2,153],108:[2,153],109:[2,153],110:[2,153],111:[2,153],112:[2,153],113:[2,153],114:[2,153],115:[2,153],116:[2,153],117:[2,153],118:[2,153],119:[2,153],120:[2,153],121:[2,153],122:[2,153],123:[2,153],124:[2,153],125:[2,153],126:[2,153],127:[2,153],128:[2,153],129:[2,153],130:[2,153],131:[2,153],132:[2,153],134:[2,153],135:[2,153],137:[2,153],138:[2,153],140:[2,153],141:[2,153],142:[2,153],143:[2,153],144:[2,153],145:[2,153],146:[2,153],147:[2,153],148:[2,153],149:[2,153],150:[2,153],151:[2,153],152:[2,153],153:[2,153],154:[2,153],155:[2,153],156:[2,153],157:[2,153],158:[2,153],159:[2,153],160:[2,153],161:[2,153],162:[2,153],165:[2,153],166:[2,153],167:[2,153],168:[2,153],170:[2,153],171:[2,153],186:[2,153],189:[2,153],191:[2,153]},{6:[2,154],8:[2,154],10:[2,154],49:[2,154],50:[2,154],51:[2,154],53:[2,154],56:[2,154],57:[2,154],58:[2,154],59:[2,154],60:[2,154],61:[2,154],62:[2,154],63:[2,154],64:[2,154],65:[2,154],66:[2,154],67:[2,154],68:[2,154],69:[2,154],70:[2,154],71:[2,154],72:[2,154],73:[2,154],74:[2,154],75:[2,154],76:[2,154],77:[2,154],78:[2,154],79:[2,154],81:[2,154],82:[2,154],83:[2,154],84:[2,154],85:[2,154],86:[2,154],87:[2,154],88:[2,154],89:[2,154],90:[2,154],91:[2,154],92:[2,154],93:[2,154],94:[2,154],95:[2,154],96:[2,154],97:[2,154],98:[2,154],99:[2,154],100:[2,154],101:[2,154],102:[2,154],103:[2,154],104:[2,154],105:[2,154],106:[2,154],107:[2,154],108:[2,154],109:[2,154],110:[2,154],111:[2,154],112:[2,154],113:[2,154],114:[2,154],115:[2,154],116:[2,154],117:[2,154],118:[2,154],119:[2,154],120:[2,154],121:[2,154],122:[2,154],123:[2,154],124:[2,154],125:[2,154],126:[2,154],127:[2,154],128:[2,154],129:[2,154],130:[2,154],131:[2,154],132:[2,154],134:[2,154],135:[2,154],137:[2,154],138:[2,154],140:[2,154],141:[2,154],142:[2,154],143:[2,154],144:[2,154],145:[2,154],146:[2,154],147:[2,154],148:[2,154],149:[2,154],150:[2,154],151:[2,154],152:[2,154],153:[2,154],154:[2,154],155:[2,154],156:[2,154],157:[2,154],158:[2,154],159:[2,154],160:[2,154],161:[2,154],162:[2,154],165:[2,154],166:[2,154],167:[2,154],168:[2,154],170:[2,154],171:[2,154],186:[2,154],189:[2,154],191:[2,154]},{18:367,19:[1,377],20:368,21:[1,321],22:369,23:[1,322],28:370,29:[1,378],30:371,31:[1,379],32:372,33:[1,380],34:373,35:[1,381],36:374,37:[1,382],38:375,39:[1,383],40:376,41:[1,384],45:366,46:365},{6:[2,137],8:[2,137],10:[2,137],49:[2,137],50:[2,137],51:[2,137],53:[2,137],56:[2,137],57:[2,137],58:[2,137],59:[2,137],60:[2,137],61:[2,137],62:[2,137],63:[2,137],64:[2,137],65:[2,137],66:[2,137],67:[2,137],68:[2,137],69:[2,137],70:[2,137],71:[2,137],72:[2,137],73:[2,137],74:[2,137],75:[2,137],76:[2,137],77:[2,137],78:[2,137],79:[2,137],81:[2,137],82:[2,137],83:[2,137],84:[2,137],85:[2,137],86:[2,137],87:[2,137],88:[2,137],89:[2,137],90:[2,137],91:[2,137],92:[2,137],93:[2,137],94:[2,137],95:[2,137],96:[2,137],97:[2,137],98:[2,137],99:[2,137],100:[2,137],101:[2,137],102:[2,137],103:[2,137],104:[2,137],105:[2,137],106:[2,137],107:[2,137],108:[2,137],109:[2,137],110:[2,137],111:[2,137],112:[2,137],113:[2,137],114:[2,137],115:[2,137],116:[2,137],117:[2,137],118:[2,137],119:[2,137],120:[2,137],121:[2,137],122:[2,137],123:[2,137],124:[2,137],125:[2,137],126:[2,137],127:[2,137],128:[2,137],129:[2,137],130:[2,137],131:[2,137],132:[2,137],134:[2,137],135:[2,137],137:[2,137],138:[2,137],140:[2,137],141:[2,137],142:[2,137],143:[2,137],144:[2,137],145:[2,137],146:[2,137],147:[2,137],148:[2,137],149:[2,137],150:[2,137],151:[2,137],152:[2,137],153:[2,137],154:[2,137],155:[2,137],156:[2,137],157:[2,137],158:[2,137],159:[2,137],160:[2,137],161:[2,137],162:[2,137],165:[2,137],166:[2,137],167:[2,137],168:[2,137],170:[2,137],171:[2,137],186:[2,137],189:[2,137],191:[2,137]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:288,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,120],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],169:289,170:[1,109],171:[1,110],173:385},{6:[2,181],8:[2,181],10:[2,181],49:[2,181],50:[2,181],51:[2,181],53:[2,181],56:[2,181],57:[2,181],58:[2,181],59:[2,181],60:[2,181],61:[2,181],62:[2,181],63:[2,181],64:[2,181],65:[2,181],66:[2,181],67:[2,181],68:[2,181],69:[2,181],70:[2,181],71:[2,181],72:[2,181],73:[2,181],74:[2,181],75:[2,181],76:[2,181],77:[2,181],78:[2,181],79:[2,181],81:[2,181],82:[2,181],83:[2,181],84:[2,181],85:[2,181],86:[2,181],87:[2,181],88:[2,181],89:[2,181],90:[2,181],91:[2,181],92:[2,181],93:[2,181],94:[2,181],95:[2,181],96:[2,181],97:[2,181],98:[2,181],99:[2,181],100:[2,181],101:[2,181],102:[2,181],103:[2,181],104:[2,181],105:[2,181],106:[2,181],107:[2,181],108:[2,181],109:[2,181],110:[2,181],111:[2,181],112:[2,181],113:[2,181],114:[2,181],115:[2,181],116:[2,181],117:[2,181],118:[2,181],119:[2,181],120:[2,181],121:[2,181],122:[2,181],123:[2,181],124:[2,181],125:[2,181],126:[2,181],127:[2,181],128:[2,181],129:[2,181],130:[2,181],131:[2,181],132:[2,181],135:[2,181],137:[2,181],138:[2,181],140:[2,181],141:[2,181],142:[2,181],143:[2,181],144:[2,181],145:[2,181],146:[2,181],147:[2,181],148:[2,181],149:[2,181],150:[2,181],151:[2,181],152:[2,181],153:[2,181],154:[2,181],155:[2,181],156:[2,181],157:[2,181],158:[2,181],159:[2,181],160:[2,181],161:[2,181],162:[2,181],165:[2,181],166:[2,181],167:[2,181],170:[2,181],171:[2,181],186:[2,181],189:[2,181],191:[2,181]},{6:[2,159],8:[2,159],10:[2,159],49:[2,159],50:[2,159],51:[2,159],53:[2,159],56:[2,159],57:[2,159],58:[2,159],59:[2,159],60:[2,159],61:[2,159],62:[2,159],63:[2,159],64:[2,159],65:[2,159],66:[2,159],67:[2,159],68:[2,159],69:[2,159],70:[2,159],71:[2,159],72:[2,159],73:[2,159],74:[2,159],75:[2,159],76:[2,159],77:[2,159],78:[2,159],79:[2,159],81:[2,159],82:[2,159],83:[2,159],84:[2,159],85:[2,159],86:[2,159],87:[2,159],88:[2,159],89:[2,159],90:[2,159],91:[2,159],92:[2,159],93:[2,159],94:[2,159],95:[2,159],96:[2,159],97:[2,159],98:[2,159],99:[2,159],100:[2,159],101:[2,159],102:[2,159],103:[2,159],104:[2,159],105:[2,159],106:[2,159],107:[2,159],108:[2,159],109:[2,159],110:[2,159],111:[2,159],112:[2,159],113:[2,159],114:[2,159],115:[2,159],116:[2,159],117:[2,159],118:[2,159],119:[2,159],120:[2,159],121:[2,159],122:[2,159],123:[2,159],124:[2,159],125:[2,159],126:[2,159],127:[2,159],128:[2,159],129:[2,159],130:[2,159],131:[2,159],132:[2,159],135:[2,159],137:[2,159],138:[2,159],140:[2,159],141:[2,159],142:[2,159],143:[2,159],144:[2,159],145:[2,159],146:[2,159],147:[2,159],148:[2,159],149:[2,159],150:[2,159],151:[2,159],152:[2,159],153:[2,159],154:[2,159],155:[2,159],156:[2,159],157:[2,159],158:[2,159],159:[2,159],160:[2,159],161:[2,159],162:[2,159],167:[2,159],170:[2,159],171:[2,159],186:[2,159],189:[2,159],191:[2,159]},{6:[2,161],8:[2,161],10:[2,161],49:[2,161],50:[2,161],51:[2,161],53:[2,161],56:[2,161],57:[2,161],58:[2,161],59:[2,161],60:[2,161],61:[2,161],62:[2,161],63:[2,161],64:[2,161],65:[2,161],66:[2,161],67:[2,161],68:[2,161],69:[2,161],70:[2,161],71:[2,161],72:[2,161],73:[2,161],74:[2,161],75:[2,161],76:[2,161],77:[2,161],78:[2,161],79:[2,161],81:[2,161],82:[2,161],83:[2,161],84:[2,161],85:[2,161],86:[2,161],87:[2,161],88:[2,161],89:[2,161],90:[2,161],91:[2,161],92:[2,161],93:[2,161],94:[2,161],95:[2,161],96:[2,161],97:[2,161],98:[2,161],99:[2,161],100:[2,161],101:[2,161],102:[2,161],103:[2,161],104:[2,161],105:[2,161],106:[2,161],107:[2,161],108:[2,161],109:[2,161],110:[2,161],111:[2,161],112:[2,161],113:[2,161],114:[2,161],115:[2,161],116:[2,161],117:[2,161],118:[2,161],119:[2,161],120:[2,161],121:[2,161],122:[2,161],123:[2,161],124:[2,161],125:[2,161],126:[2,161],127:[2,161],128:[2,161],129:[2,161],130:[2,161],131:[2,161],132:[2,161],135:[2,161],137:[2,161],138:[2,161],140:[2,161],141:[2,161],142:[2,161],143:[2,161],144:[2,161],145:[2,161],146:[2,161],147:[2,161],148:[2,161],149:[2,161],150:[2,161],151:[2,161],152:[2,161],153:[2,161],154:[2,161],155:[2,161],156:[2,161],157:[2,161],158:[2,161],159:[2,161],160:[2,161],161:[2,161],162:[2,161],167:[2,161],170:[2,161],171:[2,161],186:[2,161],189:[2,161],191:[2,161]},{6:[2,166],8:[2,166],10:[2,166],49:[2,166],50:[2,166],51:[2,166],53:[2,166],56:[2,166],57:[2,166],58:[2,166],59:[2,166],60:[2,166],61:[2,166],62:[2,166],63:[2,166],64:[2,166],65:[2,166],66:[2,166],67:[2,166],68:[2,166],69:[2,166],70:[2,166],71:[2,166],72:[2,166],73:[2,166],74:[2,166],75:[2,166],76:[2,166],77:[2,166],78:[2,166],79:[2,166],81:[2,166],82:[2,166],83:[2,166],84:[2,166],85:[2,166],86:[2,166],87:[2,166],88:[2,166],89:[2,166],90:[2,166],91:[2,166],92:[2,166],93:[2,166],94:[2,166],95:[2,166],96:[2,166],97:[2,166],98:[2,166],99:[2,166],100:[2,166],101:[2,166],102:[2,166],103:[2,166],104:[2,166],105:[2,166],106:[2,166],107:[2,166],108:[2,166],109:[2,166],110:[2,166],111:[2,166],112:[2,166],113:[2,166],114:[2,166],115:[2,166],116:[2,166],117:[2,166],118:[2,166],119:[2,166],120:[2,166],121:[2,166],122:[2,166],123:[2,166],124:[2,166],125:[2,166],126:[2,166],127:[2,166],128:[2,166],129:[2,166],130:[2,166],131:[2,166],132:[2,166],135:[2,166],137:[2,166],138:[2,166],140:[2,166],141:[2,166],142:[2,166],143:[2,166],144:[2,166],145:[2,166],146:[2,166],147:[2,166],148:[2,166],149:[2,166],150:[2,166],151:[2,166],152:[2,166],153:[2,166],154:[2,166],155:[2,166],156:[2,166],157:[2,166],158:[2,166],159:[2,166],160:[2,166],161:[2,166],162:[2,166],167:[2,166],170:[2,166],171:[2,166],186:[2,166],189:[2,166],191:[2,166]},{6:[2,167],8:[2,167],10:[2,167],49:[2,167],50:[2,167],51:[2,167],53:[2,167],56:[2,167],57:[2,167],58:[2,167],59:[2,167],60:[2,167],61:[2,167],62:[2,167],63:[2,167],64:[2,167],65:[2,167],66:[2,167],67:[2,167],68:[2,167],69:[2,167],70:[2,167],71:[2,167],72:[2,167],73:[2,167],74:[2,167],75:[2,167],76:[2,167],77:[2,167],78:[2,167],79:[2,167],81:[2,167],82:[2,167],83:[2,167],84:[2,167],85:[2,167],86:[2,167],87:[2,167],88:[2,167],89:[2,167],90:[2,167],91:[2,167],92:[2,167],93:[2,167],94:[2,167],95:[2,167],96:[2,167],97:[2,167],98:[2,167],99:[2,167],100:[2,167],101:[2,167],102:[2,167],103:[2,167],104:[2,167],105:[2,167],106:[2,167],107:[2,167],108:[2,167],109:[2,167],110:[2,167],111:[2,167],112:[2,167],113:[2,167],114:[2,167],115:[2,167],116:[2,167],117:[2,167],118:[2,167],119:[2,167],120:[2,167],121:[2,167],122:[2,167],123:[2,167],124:[2,167],125:[2,167],126:[2,167],127:[2,167],128:[2,167],129:[2,167],130:[2,167],131:[2,167],132:[2,167],135:[2,167],137:[2,167],138:[2,167],140:[2,167],141:[2,167],142:[2,167],143:[2,167],144:[2,167],145:[2,167],146:[2,167],147:[2,167],148:[2,167],149:[2,167],150:[2,167],151:[2,167],152:[2,167],153:[2,167],154:[2,167],155:[2,167],156:[2,167],157:[2,167],158:[2,167],159:[2,167],160:[2,167],161:[2,167],162:[2,167],167:[2,167],170:[2,167],171:[2,167],186:[2,167],189:[2,167],191:[2,167]},{6:[2,59],8:[2,59],10:[2,59],49:[2,59],50:[2,59],51:[2,59],53:[2,59],56:[2,59],57:[2,59],58:[2,59],59:[2,59],60:[2,59],61:[2,59],62:[2,59],63:[2,59],64:[2,59],65:[2,59],66:[2,59],67:[2,59],68:[2,59],69:[2,59],70:[2,59],71:[2,59],72:[2,59],73:[2,59],74:[2,59],75:[2,59],76:[2,59],77:[2,59],78:[2,59],79:[2,59],81:[2,59],82:[2,59],83:[2,59],84:[2,59],85:[2,59],86:[2,59],87:[2,59],88:[2,59],89:[2,59],90:[2,59],91:[2,59],92:[2,59],93:[2,59],94:[2,59],95:[2,59],96:[2,59],97:[2,59],98:[2,59],99:[2,59],100:[2,59],101:[2,59],102:[2,59],103:[2,59],104:[2,59],105:[2,59],106:[2,59],107:[2,59],108:[2,59],109:[2,59],110:[2,59],111:[2,59],112:[2,59],113:[2,59],114:[2,59],115:[2,59],116:[2,59],117:[2,59],118:[2,59],119:[2,59],120:[2,59],121:[2,59],122:[2,59],123:[2,59],124:[2,59],125:[2,59],126:[2,59],127:[2,59],128:[2,59],129:[2,59],130:[2,59],131:[2,59],132:[2,59],134:[2,59],135:[2,59],137:[2,59],138:[2,59],140:[2,59],141:[2,59],142:[2,59],143:[2,59],144:[2,59],145:[2,59],146:[2,59],147:[2,59],148:[2,59],149:[2,59],150:[2,59],151:[2,59],152:[2,59],153:[2,59],154:[2,59],155:[2,59],156:[2,59],157:[2,59],158:[2,59],159:[2,59],160:[2,59],161:[2,59],162:[2,59],165:[2,59],166:[2,59],167:[2,59],168:[2,59],170:[2,59],171:[2,59],186:[2,59],189:[2,59],191:[2,59]},{6:[2,61],8:[2,61],10:[2,61],49:[2,61],50:[2,61],51:[2,61],53:[2,61],56:[2,61],57:[2,61],58:[2,61],59:[2,61],60:[2,61],61:[2,61],62:[2,61],63:[2,61],64:[2,61],65:[2,61],66:[2,61],67:[2,61],68:[2,61],69:[2,61],70:[2,61],71:[2,61],72:[2,61],73:[2,61],74:[2,61],75:[2,61],76:[2,61],77:[2,61],78:[2,61],79:[2,61],81:[2,61],82:[2,61],83:[2,61],84:[2,61],85:[2,61],86:[2,61],87:[2,61],88:[2,61],89:[2,61],90:[2,61],91:[2,61],92:[2,61],93:[2,61],94:[2,61],95:[2,61],96:[2,61],97:[2,61],98:[2,61],99:[2,61],100:[2,61],101:[2,61],102:[2,61],103:[2,61],104:[2,61],105:[2,61],106:[2,61],107:[2,61],108:[2,61],109:[2,61],110:[2,61],111:[2,61],112:[2,61],113:[2,61],114:[2,61],115:[2,61],116:[2,61],117:[2,61],118:[2,61],119:[2,61],120:[2,61],121:[2,61],122:[2,61],123:[2,61],124:[2,61],125:[2,61],126:[2,61],127:[2,61],128:[2,61],129:[2,61],130:[2,61],131:[2,61],132:[2,61],134:[2,61],135:[2,61],137:[2,61],138:[2,61],140:[2,61],141:[2,61],142:[2,61],143:[2,61],144:[2,61],145:[2,61],146:[2,61],147:[2,61],148:[2,61],149:[2,61],150:[2,61],151:[2,61],152:[2,61],153:[2,61],154:[2,61],155:[2,61],156:[2,61],157:[2,61],158:[2,61],159:[2,61],160:[2,61],161:[2,61],162:[2,61],165:[2,61],166:[2,61],167:[2,61],168:[2,61],170:[2,61],171:[2,61],186:[2,61],189:[2,61],191:[2,61]},{6:[2,63],8:[2,63],10:[2,63],49:[2,63],50:[2,63],51:[2,63],53:[2,63],56:[2,63],57:[2,63],58:[2,63],59:[2,63],60:[2,63],61:[2,63],62:[2,63],63:[2,63],64:[2,63],65:[2,63],66:[2,63],67:[2,63],68:[2,63],69:[2,63],70:[2,63],71:[2,63],72:[2,63],73:[2,63],74:[2,63],75:[2,63],76:[2,63],77:[2,63],78:[2,63],79:[2,63],81:[2,63],82:[2,63],83:[2,63],84:[2,63],85:[2,63],86:[2,63],87:[2,63],88:[2,63],89:[2,63],90:[2,63],91:[2,63],92:[2,63],93:[2,63],94:[2,63],95:[2,63],96:[2,63],97:[2,63],98:[2,63],99:[2,63],100:[2,63],101:[2,63],102:[2,63],103:[2,63],104:[2,63],105:[2,63],106:[2,63],107:[2,63],108:[2,63],109:[2,63],110:[2,63],111:[2,63],112:[2,63],113:[2,63],114:[2,63],115:[2,63],116:[2,63],117:[2,63],118:[2,63],119:[2,63],120:[2,63],121:[2,63],122:[2,63],123:[2,63],124:[2,63],125:[2,63],126:[2,63],127:[2,63],128:[2,63],129:[2,63],130:[2,63],131:[2,63],132:[2,63],134:[2,63],135:[2,63],137:[2,63],138:[2,63],140:[2,63],141:[2,63],142:[2,63],143:[2,63],144:[2,63],145:[2,63],146:[2,63],147:[2,63],148:[2,63],149:[2,63],150:[2,63],151:[2,63],152:[2,63],153:[2,63],154:[2,63],155:[2,63],156:[2,63],157:[2,63],158:[2,63],159:[2,63],160:[2,63],161:[2,63],162:[2,63],165:[2,63],166:[2,63],167:[2,63],168:[2,63],170:[2,63],171:[2,63],186:[2,63],189:[2,63],191:[2,63]},{6:[2,60],8:[2,60],10:[2,60],49:[2,60],50:[2,60],51:[2,60],53:[2,60],56:[2,60],57:[2,60],58:[2,60],59:[2,60],60:[2,60],61:[2,60],62:[2,60],63:[2,60],64:[2,60],65:[2,60],66:[2,60],67:[2,60],68:[2,60],69:[2,60],70:[2,60],71:[2,60],72:[2,60],73:[2,60],74:[2,60],75:[2,60],76:[2,60],77:[2,60],78:[2,60],79:[2,60],81:[2,60],82:[2,60],83:[2,60],84:[2,60],85:[2,60],86:[2,60],87:[2,60],88:[2,60],89:[2,60],90:[2,60],91:[2,60],92:[2,60],93:[2,60],94:[2,60],95:[2,60],96:[2,60],97:[2,60],98:[2,60],99:[2,60],100:[2,60],101:[2,60],102:[2,60],103:[2,60],104:[2,60],105:[2,60],106:[2,60],107:[2,60],108:[2,60],109:[2,60],110:[2,60],111:[2,60],112:[2,60],113:[2,60],114:[2,60],115:[2,60],116:[2,60],117:[2,60],118:[2,60],119:[2,60],120:[2,60],121:[2,60],122:[2,60],123:[2,60],124:[2,60],125:[2,60],126:[2,60],127:[2,60],128:[2,60],129:[2,60],130:[2,60],131:[2,60],132:[2,60],134:[2,60],135:[2,60],137:[2,60],138:[2,60],140:[2,60],141:[2,60],142:[2,60],143:[2,60],144:[2,60],145:[2,60],146:[2,60],147:[2,60],148:[2,60],149:[2,60],150:[2,60],151:[2,60],152:[2,60],153:[2,60],154:[2,60],155:[2,60],156:[2,60],157:[2,60],158:[2,60],159:[2,60],160:[2,60],161:[2,60],162:[2,60],165:[2,60],166:[2,60],167:[2,60],168:[2,60],170:[2,60],171:[2,60],186:[2,60],189:[2,60],191:[2,60]},{6:[2,62],8:[2,62],10:[2,62],49:[2,62],50:[2,62],51:[2,62],53:[2,62],56:[2,62],57:[2,62],58:[2,62],59:[2,62],60:[2,62],61:[2,62],62:[2,62],63:[2,62],64:[2,62],65:[2,62],66:[2,62],67:[2,62],68:[2,62],69:[2,62],70:[2,62],71:[2,62],72:[2,62],73:[2,62],74:[2,62],75:[2,62],76:[2,62],77:[2,62],78:[2,62],79:[2,62],81:[2,62],82:[2,62],83:[2,62],84:[2,62],85:[2,62],86:[2,62],87:[2,62],88:[2,62],89:[2,62],90:[2,62],91:[2,62],92:[2,62],93:[2,62],94:[2,62],95:[2,62],96:[2,62],97:[2,62],98:[2,62],99:[2,62],100:[2,62],101:[2,62],102:[2,62],103:[2,62],104:[2,62],105:[2,62],106:[2,62],107:[2,62],108:[2,62],109:[2,62],110:[2,62],111:[2,62],112:[2,62],113:[2,62],114:[2,62],115:[2,62],116:[2,62],117:[2,62],118:[2,62],119:[2,62],120:[2,62],121:[2,62],122:[2,62],123:[2,62],124:[2,62],125:[2,62],126:[2,62],127:[2,62],128:[2,62],129:[2,62],130:[2,62],131:[2,62],132:[2,62],134:[2,62],135:[2,62],137:[2,62],138:[2,62],140:[2,62],141:[2,62],142:[2,62],143:[2,62],144:[2,62],145:[2,62],146:[2,62],147:[2,62],148:[2,62],149:[2,62],150:[2,62],151:[2,62],152:[2,62],153:[2,62],154:[2,62],155:[2,62],156:[2,62],157:[2,62],158:[2,62],159:[2,62],160:[2,62],161:[2,62],162:[2,62],165:[2,62],166:[2,62],167:[2,62],168:[2,62],170:[2,62],171:[2,62],186:[2,62],189:[2,62],191:[2,62]},{6:[2,64],8:[2,64],10:[2,64],49:[2,64],50:[2,64],51:[2,64],53:[2,64],56:[2,64],57:[2,64],58:[2,64],59:[2,64],60:[2,64],61:[2,64],62:[2,64],63:[2,64],64:[2,64],65:[2,64],66:[2,64],67:[2,64],68:[2,64],69:[2,64],70:[2,64],71:[2,64],72:[2,64],73:[2,64],74:[2,64],75:[2,64],76:[2,64],77:[2,64],78:[2,64],79:[2,64],81:[2,64],82:[2,64],83:[2,64],84:[2,64],85:[2,64],86:[2,64],87:[2,64],88:[2,64],89:[2,64],90:[2,64],91:[2,64],92:[2,64],93:[2,64],94:[2,64],95:[2,64],96:[2,64],97:[2,64],98:[2,64],99:[2,64],100:[2,64],101:[2,64],102:[2,64],103:[2,64],104:[2,64],105:[2,64],106:[2,64],107:[2,64],108:[2,64],109:[2,64],110:[2,64],111:[2,64],112:[2,64],113:[2,64],114:[2,64],115:[2,64],116:[2,64],117:[2,64],118:[2,64],119:[2,64],120:[2,64],121:[2,64],122:[2,64],123:[2,64],124:[2,64],125:[2,64],126:[2,64],127:[2,64],128:[2,64],129:[2,64],130:[2,64],131:[2,64],132:[2,64],134:[2,64],135:[2,64],137:[2,64],138:[2,64],140:[2,64],141:[2,64],142:[2,64],143:[2,64],144:[2,64],145:[2,64],146:[2,64],147:[2,64],148:[2,64],149:[2,64],150:[2,64],151:[2,64],152:[2,64],153:[2,64],154:[2,64],155:[2,64],156:[2,64],157:[2,64],158:[2,64],159:[2,64],160:[2,64],161:[2,64],162:[2,64],165:[2,64],166:[2,64],167:[2,64],168:[2,64],170:[2,64],171:[2,64],186:[2,64],189:[2,64],191:[2,64]},{6:[2,89],8:[2,89],10:[2,89],49:[2,89],50:[2,89],51:[2,89],53:[2,89],56:[2,89],57:[2,89],58:[2,89],59:[2,89],60:[2,89],61:[2,89],62:[2,89],63:[2,89],64:[2,89],65:[2,89],66:[2,89],67:[2,89],68:[2,89],69:[2,89],70:[2,89],71:[2,89],72:[2,89],73:[2,89],74:[2,89],75:[2,89],76:[2,89],77:[2,89],78:[2,89],79:[2,89],81:[2,89],82:[2,89],83:[2,89],84:[2,89],85:[2,89],86:[2,89],87:[2,89],88:[2,89],89:[2,89],90:[2,89],91:[2,89],92:[2,89],93:[2,89],94:[2,89],95:[2,89],96:[2,89],97:[2,89],98:[2,89],99:[2,89],100:[2,89],101:[2,89],102:[2,89],103:[2,89],104:[2,89],105:[2,89],106:[2,89],107:[2,89],108:[2,89],109:[2,89],110:[2,89],111:[2,89],112:[2,89],113:[2,89],114:[2,89],115:[2,89],116:[2,89],117:[2,89],118:[2,89],119:[2,89],120:[2,89],121:[2,89],122:[2,89],123:[2,89],124:[2,89],125:[2,89],126:[2,89],127:[2,89],128:[2,89],129:[2,89],130:[2,89],131:[2,89],132:[2,89],134:[2,89],135:[2,89],137:[2,89],138:[2,89],140:[2,89],141:[2,89],142:[2,89],143:[2,89],144:[2,89],145:[2,89],146:[2,89],147:[2,89],148:[2,89],149:[2,89],150:[2,89],151:[2,89],152:[2,89],153:[2,89],154:[2,89],155:[2,89],156:[2,89],157:[2,89],158:[2,89],159:[2,89],160:[2,89],161:[2,89],162:[2,89],165:[2,89],166:[2,89],167:[2,89],168:[2,89],170:[2,89],171:[2,89],186:[2,89],189:[2,89],191:[2,89]},{6:[2,93],8:[2,93],10:[2,93],49:[2,93],50:[2,93],51:[2,93],53:[2,93],56:[2,93],57:[2,93],58:[2,93],59:[2,93],60:[2,93],61:[2,93],62:[2,93],63:[2,93],64:[2,93],65:[2,93],66:[2,93],67:[2,93],68:[2,93],69:[2,93],70:[2,93],71:[2,93],72:[2,93],73:[2,93],74:[2,93],75:[2,93],76:[2,93],77:[2,93],78:[2,93],79:[2,93],81:[2,93],82:[2,93],83:[2,93],84:[2,93],85:[2,93],86:[2,93],87:[2,93],88:[2,93],89:[2,93],90:[2,93],91:[2,93],92:[2,93],93:[2,93],94:[2,93],95:[2,93],96:[2,93],97:[2,93],98:[2,93],99:[2,93],100:[2,93],101:[2,93],102:[2,93],103:[2,93],104:[2,93],105:[2,93],106:[2,93],107:[2,93],108:[2,93],109:[2,93],110:[2,93],111:[2,93],112:[2,93],113:[2,93],114:[2,93],115:[2,93],116:[2,93],117:[2,93],118:[2,93],119:[2,93],120:[2,93],121:[2,93],122:[2,93],123:[2,93],124:[2,93],125:[2,93],126:[2,93],127:[2,93],128:[2,93],129:[2,93],130:[2,93],131:[2,93],132:[2,93],134:[2,93],135:[2,93],137:[2,93],138:[2,93],140:[2,93],141:[2,93],142:[2,93],143:[2,93],144:[2,93],145:[2,93],146:[2,93],147:[2,93],148:[2,93],149:[2,93],150:[2,93],151:[2,93],152:[2,93],153:[2,93],154:[2,93],155:[2,93],156:[2,93],157:[2,93],158:[2,93],159:[2,93],160:[2,93],161:[2,93],162:[2,93],165:[2,93],166:[2,93],167:[2,93],168:[2,93],170:[2,93],171:[2,93],186:[2,93],189:[2,93],191:[2,93]},{6:[2,119],8:[2,119],10:[2,119],49:[2,119],50:[2,119],51:[2,119],53:[2,119],56:[2,119],57:[2,119],58:[2,119],59:[2,119],60:[2,119],61:[2,119],62:[2,119],63:[2,119],64:[2,119],65:[2,119],66:[2,119],67:[2,119],68:[2,119],69:[2,119],70:[2,119],71:[2,119],72:[2,119],73:[2,119],74:[2,119],75:[2,119],76:[2,119],77:[2,119],78:[2,119],79:[2,119],81:[2,119],82:[2,119],83:[2,119],84:[2,119],85:[2,119],86:[2,119],87:[2,119],88:[2,119],89:[2,119],90:[2,119],91:[2,119],92:[2,119],93:[2,119],94:[2,119],95:[2,119],96:[2,119],97:[2,119],98:[2,119],99:[2,119],100:[2,119],101:[2,119],102:[2,119],103:[2,119],104:[2,119],105:[2,119],106:[2,119],107:[2,119],108:[2,119],109:[2,119],110:[2,119],111:[2,119],112:[2,119],113:[2,119],114:[2,119],115:[2,119],116:[2,119],117:[2,119],118:[2,119],119:[2,119],120:[2,119],121:[2,119],122:[2,119],123:[2,119],124:[2,119],125:[2,119],126:[2,119],127:[2,119],128:[2,119],129:[2,119],130:[2,119],131:[2,119],132:[2,119],134:[2,119],135:[2,119],137:[2,119],138:[2,119],140:[2,119],141:[2,119],142:[2,119],143:[2,119],144:[2,119],145:[2,119],146:[2,119],147:[2,119],148:[2,119],149:[2,119],150:[2,119],151:[2,119],152:[2,119],153:[2,119],154:[2,119],155:[2,119],156:[2,119],157:[2,119],158:[2,119],159:[2,119],160:[2,119],161:[2,119],162:[2,119],165:[2,119],166:[2,119],167:[2,119],168:[2,119],170:[2,119],171:[2,119],186:[2,119],189:[2,119],191:[2,119]},{4:[2,3],8:[2,3],49:[2,3],50:[2,3],51:[2,3],56:[2,3],57:[2,3],58:[2,3],59:[2,3],60:[2,3],61:[2,3],62:[2,3],63:[2,3],67:[2,3],68:[2,3],69:[2,3],70:[2,3],71:[2,3],72:[2,3],73:[2,3],74:[2,3],75:[2,3],76:[2,3],77:[2,3],78:[2,3],79:[2,3],81:[2,3],82:[2,3],83:[2,3],84:[2,3],85:[2,3],86:[2,3],87:[2,3],88:[2,3],89:[2,3],90:[2,3],91:[2,3],92:[2,3],93:[2,3],94:[2,3],95:[2,3],96:[2,3],97:[2,3],98:[2,3],99:[2,3],100:[2,3],101:[2,3],102:[2,3],103:[2,3],104:[2,3],105:[2,3],106:[2,3],107:[2,3],108:[2,3],109:[2,3],110:[2,3],111:[2,3],112:[2,3],113:[2,3],114:[2,3],115:[2,3],116:[2,3],117:[2,3],118:[2,3],119:[2,3],120:[2,3],121:[2,3],122:[2,3],123:[2,3],124:[2,3],125:[2,3],126:[2,3],127:[2,3],128:[2,3],129:[2,3],130:[2,3],131:[2,3],132:[2,3],135:[2,3],137:[2,3],138:[2,3],141:[2,3],143:[2,3],145:[2,3],147:[2,3],149:[2,3],151:[2,3],153:[2,3],155:[2,3],157:[2,3],159:[2,3],161:[2,3],162:[2,3]},{8:[1,386]},{136:387,165:[1,223],166:[1,224],174:222},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],140:[2,193],141:[1,97],142:[2,193],143:[1,98],144:[2,193],145:[1,99],146:[2,193],147:[1,100],148:[2,193],149:[1,101],150:[2,193],151:[1,102],152:[2,193],153:[1,103],154:[2,193],155:[1,104],156:[2,193],157:[1,105],158:[2,193],159:[1,106],160:[2,193],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:388,186:[2,193],189:[2,193]},{10:[2,43],21:[2,43],23:[2,43]},{10:[2,11],19:[2,11],21:[2,11],23:[2,11],25:[2,11],27:[2,11],29:[2,11],31:[2,11],33:[2,11],35:[2,11],37:[2,11],39:[2,11],41:[2,11]},{10:[2,12],19:[2,12],21:[2,12],23:[2,12],25:[2,12],27:[2,12],29:[2,12],31:[2,12],33:[2,12],35:[2,12],37:[2,12],39:[2,12],41:[2,12]},{8:[1,18],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:389,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12]},{10:[2,27],21:[2,27],23:[2,27],25:[2,27],27:[2,27]},{10:[2,13],21:[2,13],23:[2,13],25:[2,13],27:[2,13]},{10:[2,14],21:[2,14],23:[2,14],25:[2,14],27:[2,14]},{6:[2,151],8:[2,151],10:[2,151],49:[2,151],50:[2,151],51:[2,151],53:[2,151],56:[2,151],57:[2,151],58:[2,151],59:[2,151],60:[2,151],61:[2,151],62:[2,151],63:[2,151],64:[2,151],65:[2,151],66:[2,151],67:[2,151],68:[2,151],69:[2,151],70:[2,151],71:[2,151],72:[2,151],73:[2,151],74:[2,151],75:[2,151],76:[2,151],77:[2,151],78:[2,151],79:[2,151],81:[2,151],82:[2,151],83:[2,151],84:[2,151],85:[2,151],86:[2,151],87:[2,151],88:[2,151],89:[2,151],90:[2,151],91:[2,151],92:[2,151],93:[2,151],94:[2,151],95:[2,151],96:[2,151],97:[2,151],98:[2,151],99:[2,151],100:[2,151],101:[2,151],102:[2,151],103:[2,151],104:[2,151],105:[2,151],106:[2,151],107:[2,151],108:[2,151],109:[2,151],110:[2,151],111:[2,151],112:[2,151],113:[2,151],114:[2,151],115:[2,151],116:[2,151],117:[2,151],118:[2,151],119:[2,151],120:[2,151],121:[2,151],122:[2,151],123:[2,151],124:[2,151],125:[2,151],126:[2,151],127:[2,151],128:[2,151],129:[2,151],130:[2,151],131:[2,151],132:[2,151],134:[2,151],135:[2,151],137:[2,151],138:[2,151],140:[2,151],141:[2,151],142:[2,151],143:[2,151],144:[2,151],145:[2,151],146:[2,151],147:[2,151],148:[2,151],149:[2,151],150:[2,151],151:[2,151],152:[2,151],153:[2,151],154:[2,151],155:[2,151],156:[2,151],157:[2,151],158:[2,151],159:[2,151],160:[2,151],161:[2,151],162:[2,151],165:[2,151],166:[2,151],167:[2,151],168:[2,151],170:[2,151],171:[2,151],186:[2,151],189:[2,151],191:[2,151]},{10:[1,390],18:367,19:[1,377],20:368,21:[1,321],22:369,23:[1,322],28:370,29:[1,378],30:371,31:[1,379],32:372,33:[1,380],34:373,35:[1,381],36:374,37:[1,382],38:375,39:[1,383],40:376,41:[1,384],45:391},{10:[2,40],19:[2,40],21:[2,40],23:[2,40],29:[2,40],31:[2,40],33:[2,40],35:[2,40],37:[2,40],39:[2,40],41:[2,40]},{10:[2,30],19:[2,30],21:[2,30],23:[2,30],29:[2,30],31:[2,30],33:[2,30],35:[2,30],37:[2,30],39:[2,30],41:[2,30]},{10:[2,31],19:[2,31],21:[2,31],23:[2,31],29:[2,31],31:[2,31],33:[2,31],35:[2,31],37:[2,31],39:[2,31],41:[2,31]},{10:[2,32],19:[2,32],21:[2,32],23:[2,32],29:[2,32],31:[2,32],33:[2,32],35:[2,32],37:[2,32],39:[2,32],41:[2,32]},{10:[2,33],19:[2,33],21:[2,33],23:[2,33],29:[2,33],31:[2,33],33:[2,33],35:[2,33],37:[2,33],39:[2,33],41:[2,33]},{10:[2,34],19:[2,34],21:[2,34],23:[2,34],29:[2,34],31:[2,34],33:[2,34],35:[2,34],37:[2,34],39:[2,34],41:[2,34]},{10:[2,35],19:[2,35],21:[2,35],23:[2,35],29:[2,35],31:[2,35],33:[2,35],35:[2,35],37:[2,35],39:[2,35],41:[2,35]},{10:[2,36],19:[2,36],21:[2,36],23:[2,36],29:[2,36],31:[2,36],33:[2,36],35:[2,36],37:[2,36],39:[2,36],41:[2,36]},{10:[2,37],19:[2,37],21:[2,37],23:[2,37],29:[2,37],31:[2,37],33:[2,37],35:[2,37],37:[2,37],39:[2,37],41:[2,37]},{10:[2,38],19:[2,38],21:[2,38],23:[2,38],29:[2,38],31:[2,38],33:[2,38],35:[2,38],37:[2,38],39:[2,38],41:[2,38]},{10:[2,39],19:[2,39],21:[2,39],23:[2,39],29:[2,39],31:[2,39],33:[2,39],35:[2,39],37:[2,39],39:[2,39],41:[2,39]},{7:116,8:[1,117],14:392},{7:116,8:[1,117],14:393},{7:116,8:[1,117],14:394},{7:116,8:[1,117],14:395},{7:116,8:[1,117],14:396},{7:116,8:[1,117],14:397},{7:116,8:[1,117],14:398},{7:116,8:[1,117],14:399},{6:[2,178],8:[2,178],10:[2,178],49:[2,178],50:[2,178],51:[2,178],53:[2,178],56:[2,178],57:[2,178],58:[2,178],59:[2,178],60:[2,178],61:[2,178],62:[2,178],63:[2,178],64:[2,178],65:[2,178],66:[2,178],67:[2,178],68:[2,178],69:[2,178],70:[2,178],71:[2,178],72:[2,178],73:[2,178],74:[2,178],75:[2,178],76:[2,178],77:[2,178],78:[2,178],79:[2,178],81:[2,178],82:[2,178],83:[2,178],84:[2,178],85:[2,178],86:[2,178],87:[2,178],88:[2,178],89:[2,178],90:[2,178],91:[2,178],92:[2,178],93:[2,178],94:[2,178],95:[2,178],96:[2,178],97:[2,178],98:[2,178],99:[2,178],100:[2,178],101:[2,178],102:[2,178],103:[2,178],104:[2,178],105:[2,178],106:[2,178],107:[2,178],108:[2,178],109:[2,178],110:[2,178],111:[2,178],112:[2,178],113:[2,178],114:[2,178],115:[2,178],116:[2,178],117:[2,178],118:[2,178],119:[2,178],120:[2,178],121:[2,178],122:[2,178],123:[2,178],124:[2,178],125:[2,178],126:[2,178],127:[2,178],128:[2,178],129:[2,178],130:[2,178],131:[2,178],132:[2,178],135:[2,178],137:[2,178],138:[2,178],140:[2,178],141:[2,178],142:[2,178],143:[2,178],144:[2,178],145:[2,178],146:[2,178],147:[2,178],148:[2,178],149:[2,178],150:[2,178],151:[2,178],152:[2,178],153:[2,178],154:[2,178],155:[2,178],156:[2,178],157:[2,178],158:[2,178],159:[2,178],160:[2,178],161:[2,178],162:[2,178],165:[2,178],166:[2,178],167:[2,178],170:[2,178],171:[2,178],186:[2,178],189:[2,178],191:[2,178]},{10:[1,401],136:400,165:[1,223],166:[1,224],174:222},{10:[1,402],165:[1,223],166:[1,224],174:284},{10:[2,198],140:[2,198],142:[2,198],144:[2,198],146:[2,198],148:[2,198],150:[2,198],152:[2,198],154:[2,198],156:[2,198],158:[2,198],160:[2,198],186:[1,267],189:[2,198]},{10:[2,194],140:[2,194],142:[2,194],144:[2,194],146:[2,194],148:[2,194],150:[2,194],152:[2,194],154:[2,194],156:[2,194],158:[2,194],160:[2,194],186:[2,194],189:[2,194]},{8:[1,18],10:[2,193],48:27,49:[1,111],50:[1,39],51:[1,35],54:15,55:201,56:[1,19],57:[1,20],58:[1,21],59:[1,22],60:[1,23],61:[1,24],62:[1,25],63:[1,26],67:[1,28],68:[1,29],69:[1,30],70:[1,31],71:[1,32],72:[1,33],73:[1,34],74:[1,36],75:[1,37],76:[1,38],77:[1,40],78:[1,41],79:[1,42],81:[1,43],82:[1,44],83:[1,45],84:[1,46],85:[1,47],86:[1,48],87:[1,49],88:[1,50],89:[1,51],90:[1,52],91:[1,53],92:[1,54],93:[1,55],94:[1,56],95:[1,57],96:[1,58],97:[1,59],98:[1,60],99:[1,61],100:[1,62],101:[1,63],102:[1,64],103:[1,65],104:[1,66],105:[1,67],106:[1,68],107:[1,69],108:[1,70],109:[1,71],110:[1,72],111:[1,73],112:[1,74],113:[1,75],114:[1,76],115:[1,77],116:[1,78],117:[1,79],118:[1,80],119:[1,81],120:[1,82],121:[1,83],122:[1,84],123:[1,85],124:[1,86],125:[1,87],126:[1,88],127:[1,89],128:[1,90],129:[1,91],130:[1,92],131:[1,93],132:[1,94],135:[1,14],137:[1,95],138:[1,96],139:403,141:[1,97],143:[1,98],145:[1,99],147:[1,100],149:[1,101],151:[1,102],153:[1,103],155:[1,104],157:[1,105],159:[1,106],161:[1,107],162:[1,108],164:13,167:[1,17],169:16,170:[1,109],171:[1,110],172:5,175:4,176:[1,6],177:[1,7],178:[1,8],179:[1,9],180:[1,10],181:[1,11],182:[1,12],183:199,184:[1,200],185:198,186:[2,193],187:196,188:[1,197],189:[2,193]},{10:[2,41],19:[2,41],21:[2,41],23:[2,41],29:[2,41],31:[2,41],33:[2,41],35:[2,41],37:[2,41],39:[2,41],41:[2,41]},{10:[2,10],19:[2,10],21:[2,10],23:[2,10],29:[2,10],31:[2,10],33:[2,10],35:[2,10],37:[2,10],39:[2,10],41:[2,10]},{10:[2,15],19:[2,15],21:[2,15],23:[2,15],29:[2,15],31:[2,15],33:[2,15],35:[2,15],37:[2,15],39:[2,15],41:[2,15]},{10:[2,16],19:[2,16],21:[2,16],23:[2,16],29:[2,16],31:[2,16],33:[2,16],35:[2,16],37:[2,16],39:[2,16],41:[2,16]},{10:[2,17],19:[2,17],21:[2,17],23:[2,17],29:[2,17],31:[2,17],33:[2,17],35:[2,17],37:[2,17],39:[2,17],41:[2,17]},{10:[2,18],19:[2,18],21:[2,18],23:[2,18],29:[2,18],31:[2,18],33:[2,18],35:[2,18],37:[2,18],39:[2,18],41:[2,18]},{10:[2,19],19:[2,19],21:[2,19],23:[2,19],29:[2,19],31:[2,19],33:[2,19],35:[2,19],37:[2,19],39:[2,19],41:[2,19]},{10:[2,20],19:[2,20],21:[2,20],23:[2,20],29:[2,20],31:[2,20],33:[2,20],35:[2,20],37:[2,20],39:[2,20],41:[2,20]},{10:[2,21],19:[2,21],21:[2,21],23:[2,21],29:[2,21],31:[2,21],33:[2,21],35:[2,21],37:[2,21],39:[2,21],41:[2,21]},{10:[1,404],165:[1,223],166:[1,224],174:284},{6:[2,139],8:[2,139],10:[2,139],49:[2,139],50:[2,139],51:[2,139],53:[2,139],56:[2,139],57:[2,139],58:[2,139],59:[2,139],60:[2,139],61:[2,139],62:[2,139],63:[2,139],64:[2,139],65:[2,139],66:[2,139],67:[2,139],68:[2,139],69:[2,139],70:[2,139],71:[2,139],72:[2,139],73:[2,139],74:[2,139],75:[2,139],76:[2,139],77:[2,139],78:[2,139],79:[2,139],81:[2,139],82:[2,139],83:[2,139],84:[2,139],85:[2,139],86:[2,139],87:[2,139],88:[2,139],89:[2,139],90:[2,139],91:[2,139],92:[2,139],93:[2,139],94:[2,139],95:[2,139],96:[2,139],97:[2,139],98:[2,139],99:[2,139],100:[2,139],101:[2,139],102:[2,139],103:[2,139],104:[2,139],105:[2,139],106:[2,139],107:[2,139],108:[2,139],109:[2,139],110:[2,139],111:[2,139],112:[2,139],113:[2,139],114:[2,139],115:[2,139],116:[2,139],117:[2,139],118:[2,139],119:[2,139],120:[2,139],121:[2,139],122:[2,139],123:[2,139],124:[2,139],125:[2,139],126:[2,139],127:[2,139],128:[2,139],129:[2,139],130:[2,139],131:[2,139],132:[2,139],134:[2,139],135:[2,139],137:[2,139],138:[2,139],140:[2,139],141:[2,139],142:[2,139],143:[2,139],144:[2,139],145:[2,139],146:[2,139],147:[2,139],148:[2,139],149:[2,139],150:[2,139],151:[2,139],152:[2,139],153:[2,139],154:[2,139],155:[2,139],156:[2,139],157:[2,139],158:[2,139],159:[2,139],160:[2,139],161:[2,139],162:[2,139],165:[2,139],166:[2,139],167:[2,139],168:[2,139],170:[2,139],171:[2,139],186:[2,139],189:[2,139],191:[2,139]},{6:[2,140],8:[2,140],10:[2,140],49:[2,140],50:[2,140],51:[2,140],53:[2,140],56:[2,140],57:[2,140],58:[2,140],59:[2,140],60:[2,140],61:[2,140],62:[2,140],63:[2,140],64:[2,140],65:[2,140],66:[2,140],67:[2,140],68:[2,140],69:[2,140],70:[2,140],71:[2,140],72:[2,140],73:[2,140],74:[2,140],75:[2,140],76:[2,140],77:[2,140],78:[2,140],79:[2,140],81:[2,140],82:[2,140],83:[2,140],84:[2,140],85:[2,140],86:[2,140],87:[2,140],88:[2,140],89:[2,140],90:[2,140],91:[2,140],92:[2,140],93:[2,140],94:[2,140],95:[2,140],96:[2,140],97:[2,140],98:[2,140],99:[2,140],100:[2,140],101:[2,140],102:[2,140],103:[2,140],104:[2,140],105:[2,140],106:[2,140],107:[2,140],108:[2,140],109:[2,140],110:[2,140],111:[2,140],112:[2,140],113:[2,140],114:[2,140],115:[2,140],116:[2,140],117:[2,140],118:[2,140],119:[2,140],120:[2,140],121:[2,140],122:[2,140],123:[2,140],124:[2,140],125:[2,140],126:[2,140],127:[2,140],128:[2,140],129:[2,140],130:[2,140],131:[2,140],132:[2,140],134:[2,140],135:[2,140],137:[2,140],138:[2,140],140:[2,140],141:[2,140],142:[2,140],143:[2,140],144:[2,140],145:[2,140],146:[2,140],147:[2,140],148:[2,140],149:[2,140],150:[2,140],151:[2,140],152:[2,140],153:[2,140],154:[2,140],155:[2,140],156:[2,140],157:[2,140],158:[2,140],159:[2,140],160:[2,140],161:[2,140],162:[2,140],165:[2,140],166:[2,140],167:[2,140],168:[2,140],170:[2,140],171:[2,140],186:[2,140],189:[2,140],191:[2,140]},{10:[1,405],189:[1,265]},{6:[2,138],8:[2,138],10:[2,138],49:[2,138],50:[2,138],51:[2,138],53:[2,138],56:[2,138],57:[2,138],58:[2,138],59:[2,138],60:[2,138],61:[2,138],62:[2,138],63:[2,138],64:[2,138],65:[2,138],66:[2,138],67:[2,138],68:[2,138],69:[2,138],70:[2,138],71:[2,138],72:[2,138],73:[2,138],74:[2,138],75:[2,138],76:[2,138],77:[2,138],78:[2,138],79:[2,138],81:[2,138],82:[2,138],83:[2,138],84:[2,138],85:[2,138],86:[2,138],87:[2,138],88:[2,138],89:[2,138],90:[2,138],91:[2,138],92:[2,138],93:[2,138],94:[2,138],95:[2,138],96:[2,138],97:[2,138],98:[2,138],99:[2,138],100:[2,138],101:[2,138],102:[2,138],103:[2,138],104:[2,138],105:[2,138],106:[2,138],107:[2,138],108:[2,138],109:[2,138],110:[2,138],111:[2,138],112:[2,138],113:[2,138],114:[2,138],115:[2,138],116:[2,138],117:[2,138],118:[2,138],119:[2,138],120:[2,138],121:[2,138],122:[2,138],123:[2,138],124:[2,138],125:[2,138],126:[2,138],127:[2,138],128:[2,138],129:[2,138],130:[2,138],131:[2,138],132:[2,138],134:[2,138],135:[2,138],137:[2,138],138:[2,138],140:[2,138],141:[2,138],142:[2,138],143:[2,138],144:[2,138],145:[2,138],146:[2,138],147:[2,138],148:[2,138],149:[2,138],150:[2,138],151:[2,138],152:[2,138],153:[2,138],154:[2,138],155:[2,138],156:[2,138],157:[2,138],158:[2,138],159:[2,138],160:[2,138],161:[2,138],162:[2,138],165:[2,138],166:[2,138],167:[2,138],168:[2,138],170:[2,138],171:[2,138],186:[2,138],189:[2,138],191:[2,138]},{6:[2,155],8:[2,155],10:[2,155],49:[2,155],50:[2,155],51:[2,155],53:[2,155],56:[2,155],57:[2,155],58:[2,155],59:[2,155],60:[2,155],61:[2,155],62:[2,155],63:[2,155],64:[2,155],65:[2,155],66:[2,155],67:[2,155],68:[2,155],69:[2,155],70:[2,155],71:[2,155],72:[2,155],73:[2,155],74:[2,155],75:[2,155],76:[2,155],77:[2,155],78:[2,155],79:[2,155],81:[2,155],82:[2,155],83:[2,155],84:[2,155],85:[2,155],86:[2,155],87:[2,155],88:[2,155],89:[2,155],90:[2,155],91:[2,155],92:[2,155],93:[2,155],94:[2,155],95:[2,155],96:[2,155],97:[2,155],98:[2,155],99:[2,155],100:[2,155],101:[2,155],102:[2,155],103:[2,155],104:[2,155],105:[2,155],106:[2,155],107:[2,155],108:[2,155],109:[2,155],110:[2,155],111:[2,155],112:[2,155],113:[2,155],114:[2,155],115:[2,155],116:[2,155],117:[2,155],118:[2,155],119:[2,155],120:[2,155],121:[2,155],122:[2,155],123:[2,155],124:[2,155],125:[2,155],126:[2,155],127:[2,155],128:[2,155],129:[2,155],130:[2,155],131:[2,155],132:[2,155],134:[2,155],135:[2,155],137:[2,155],138:[2,155],140:[2,155],141:[2,155],142:[2,155],143:[2,155],144:[2,155],145:[2,155],146:[2,155],147:[2,155],148:[2,155],149:[2,155],150:[2,155],151:[2,155],152:[2,155],153:[2,155],154:[2,155],155:[2,155],156:[2,155],157:[2,155],158:[2,155],159:[2,155],160:[2,155],161:[2,155],162:[2,155],165:[2,155],166:[2,155],167:[2,155],168:[2,155],170:[2,155],171:[2,155],186:[2,155],189:[2,155],191:[2,155]}],
defaultActions: {3:[2,203],112:[2,202],213:[2,8]},
parseError: function parseError(str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        throw new Error(str);
    }
},
parse: function parse(input) {
    var self = this, stack = [0], vstack = [null], lstack = [], table = this.table, yytext = '', yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
    var args = lstack.slice.call(arguments, 1);
    this.lexer.setInput(input);
    this.lexer.yy = this.yy;
    this.yy.lexer = this.lexer;
    this.yy.parser = this;
    if (typeof this.lexer.yylloc == 'undefined') {
        this.lexer.yylloc = {};
    }
    var yyloc = this.lexer.yylloc;
    lstack.push(yyloc);
    var ranges = this.lexer.options && this.lexer.options.ranges;
    if (typeof this.yy.parseError === 'function') {
        this.parseError = this.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }
    function popStack(n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }
    function lex() {
        var token;
        token = self.lexer.lex() || EOF;
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }
    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            action = table[state] && table[state][symbol];
        }
                    if (typeof action === 'undefined' || !action.length || !action[0]) {
                var errStr = '';
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push('\'' + this.terminals_[p] + '\'');
                    }
                }
                if (this.lexer.showPosition) {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ':\n' + this.lexer.showPosition() + '\nExpecting ' + expected.join(', ') + ', got \'' + (this.terminals_[symbol] || symbol) + '\'';
                } else {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ': Unexpected ' + (symbol == EOF ? 'end of input' : '\'' + (this.terminals_[symbol] || symbol) + '\'');
                }
                this.parseError(errStr, {
                    text: this.lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: this.lexer.yylineno,
                    loc: yyloc,
                    expected: expected
                });
            }
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: ' + state + ', token: ' + symbol);
        }
        switch (action[0]) {
        case 1:
            stack.push(symbol);
            vstack.push(this.lexer.yytext);
            lstack.push(this.lexer.yylloc);
            stack.push(action[1]);
            symbol = null;
            if (!preErrorSymbol) {
                yyleng = this.lexer.yyleng;
                yytext = this.lexer.yytext;
                yylineno = this.lexer.yylineno;
                yyloc = this.lexer.yylloc;
                if (recovering > 0) {
                    recovering--;
                }
            } else {
                symbol = preErrorSymbol;
                preErrorSymbol = null;
            }
            break;
        case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
                yyval._$.range = [
                    lstack[lstack.length - (len || 1)].range[0],
                    lstack[lstack.length - 1].range[1]
                ];
            }
            r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                this.yy,
                action[1],
                vstack,
                lstack
            ].concat(args));
            if (typeof r !== 'undefined') {
                return r;
            }
            if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
        case 3:
            return true;
        }
    }
    return true;
}};

function escapeText(aString) {
  /* Escape reserved XML characters for use as text nodes. */
  return aString.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}

function escapeQuote(aString) {
  /* Escape the double quote characters for use as attribute. */
  return aString.replace(/"/g, "&#x22;");
}

function parseLength(aString) {
  /* See http://www.w3.org/TR/MathML3/appendixa.html#parsing_length */
  /* FIXME: should namedspaces be accepted too?
    https://github.com/fred-wang/TeXZilla/issues/8 */
  var lengthRegexp = /\s*(-?[0-9]*(?:[0-9]\.?|\.[0-9])[0-9]*)(e[mx]|in|cm|mm|p[xtc]|%)?\s*/, result = lengthRegexp.exec(aString);
  if (result) {
    result = { l: parseFloat(result[1]), u: result[2] };
  }
  return result;
}

function newTag(aTag, aContent, aAttributes) {
  /* Create a new tag with the specified content and attributes. */
  var tag = "<" + aTag;
  if (aAttributes) tag += " " + aAttributes
  tag += ">" + aContent + "</" + aTag + ">";
  return tag;
}

function newMo(aContent, aLeftSpace, aRightSpace) {
  /* Create a new operator */
  var tag = "<mo";
  if (aLeftSpace) tag += " lspace=\"" + aLeftSpace + "\"";
  if (aRightSpace) tag += " rspace=\"" + aRightSpace + "\"";
  tag += ">" + escapeText(aContent) + "</mo>";
  return tag;
}

function newScript(aUnderOver, aBase, aScriptBot, aScriptTop) {
  /* Create a new MathML script element. */
  if (aUnderOver) {
    if (!aScriptBot) {
       return "<mover>" + aBase + aScriptTop + "</mover>";
    }
    if (!aScriptTop) {
       return "<munder>" + aBase + aScriptBot + "</munder>";
    }
    return "<munderover>" + aBase + aScriptBot + aScriptTop + "</munderover>";
  }
  if (!aScriptBot) {
    return "<msup>" + aBase + aScriptTop + "</msup>";
  }
  if (!aScriptTop) {
    return "<msub>" + aBase + aScriptBot + "</msub>";
  }
  return "<msubsup>" + aBase + aScriptBot + aScriptTop + "</msubsup>";
}

/* FIXME: try to restore the operator grouping when compoundTermList does not
   contain any fences.
   https://github.com/fred-wang/TeXZilla/issues/9 */
function newMrow(aList, aTag, aAttributes) {
  var tag;
  if (!aTag) {
    if (aList.length == 1) {
      /* This list only has one element so we just return it. */
      return aList[0];
    }
    aTag = "mrow";
  }
  tag = "<" + aTag;
  if (aAttributes) tag += " " + aAttributes
  tag += ">" + aList.join("") + "</" + aTag + ">";
  return tag;
}

var MathMLNameSpace = "http://www.w3.org/1998/Math/MathML",
    TeXMimeTypes = ["TeX", "LaTeX", "text/x-tex", "text/x-latex",
                    "application/x-tex", "application/x-latex"];

function getTeXSourceInternal(aMathMLElement) {
  var child;
  if (!aMathMLElement ||
      aMathMLElement.namespaceURI !== MathMLNameSpace) {
    return null;
  }

  if (aMathMLElement.tagName === "semantics") {
    // Note: we can't use aMathMLElement.children on WebKit/Blink because of
    // https://bugs.webkit.org/show_bug.cgi?id=109556.
    for (child = aMathMLElement.firstElementChild; child;
         child = child.nextElementSibling) {
      if (child.namespaceURI === MathMLNameSpace &&
          child.localName === "annotation" &&
          TeXMimeTypes.indexOf(child.getAttribute("encoding")) !== -1) {
        return child.textContent;
      }
    }
  } else if (aMathMLElement.childElementCount === 1) {
    return getTeXSourceInternal(aMathMLElement.firstElementChild);
  }

  return null;
}

try {
  // Try to create a DOM Parser object if it exists (e.g. in a Web page,
  // in a chrome script running in a window etc)
  parser.DOMParser = new DOMParser();
} catch (e) {
  // Leave the DOMParser unset.
  parser.DOMParser = null;
}

parser.parseMathMLDocument = function (aString) {
  /* Parse the string into a MathML document and return the <math> root. */
  if (this.DOMParser) {
    return this.DOMParser.
      parseFromString(aString, "application/xml").documentElement;
  }
  throw "TeXZilla.DOMParser has not been set!";
}

parser.getTeXSource = function(aMathMLElement) {
  if (typeof aMathMLElement === "string") {
    aMathMLElement = this.parseMathMLDocument(aMathMLElement);
  }

  return getTeXSourceInternal(aMathMLElement);
}

parser.toMathMLString = function(aTeX, aDisplay, aRTL, aThrowExceptionOnError) {
  var output, mathml;
  /* Parse the TeX source and get the main MathML node. */
  try {
    output = this.parse(aTeX);
  } catch (e) {
    if (aThrowExceptionOnError) {
       throw e;
    }
    output = "<merror><mtext>" + escapeText(e.message) + "</mtext></merror>";
  }

  /* Add the <math> root and attach the TeX annotation. */
  mathml = "<math xmlns=\"" + MathMLNameSpace + "\"";
  if (aDisplay) {
    /* Set the display mode if it is specified. */
    mathml += " display=\"block\""
  }
  if (aRTL) {
    /* Set the RTL mode if specified. */
    mathml += " dir=\"rtl\""
  }
  mathml += "><semantics>" + output;
  mathml += "<annotation encoding=\"TeX\">";
  mathml += escapeText(aTeX);
  mathml += "</annotation></semantics></math>";

  return mathml;
}

parser.toMathML = function(aTeX, aDisplay, aRTL, aThrowExceptionOnError) {
  /* Parse the TeX string into a <math> element. */
  return this.parseMathMLDocument(this.toMathMLString(aTeX, aDisplay, aRTL, aThrowExceptionOnError));
}
/* generated by jison-lex 0.2.1 */
var lexer = (function(){
var lexer = {

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input) {
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len - 1);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function (match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex() {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState(condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {

var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: this.popState(); return "["; 
break;
case 1: this.unput(yy_.yytext); this.popState(); this.popState(); 
break;
case 2: return "TEXTOPTARG"; 
break;
case 3: this.popState(); return "]"; 
break;
case 4:return "{";
break;
case 5:return "TEXTARG";
break;
case 6: this.popState(); return "}"; 
break;
case 7: this.popState(); return "]"; 
break;
case 8:/* skip whitespace */
break;
case 9:return "{";
break;
case 10:return "}";
break;
case 11:return "^";
break;
case 12:return "_";
break;
case 13:return ".";
break;
case 14:return "COLSEP";
break;
case 15:return "ROWSEP"
break;
case 16:return "EOF";
break;
case 17:return "NUM";
break;
case 18: yy_.yytext = "\u0396"; return "A"; 
break;
case 19: yy_.yytext = "\u03B6"; return "A"; 
break;
case 20: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21CC"; return "XARROW"; 
break;
case 21: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21D2"; return "XARROW"; 
break;
case 22: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u2192"; return  "XARROW"; 
break;
case 23: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21A6"; return "XARROW"; 
break;
case 24: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21CB"; return "XARROW"; 
break;
case 25: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21D4"; return "XARROW"; 
break;
case 26: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u2194"; return "XARROW"; 
break;
case 27: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21D0"; return "XARROW"; 
break;
case 28: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u2190"; return "XARROW"; 
break;
case 29: yy_.yytext = "\u039E"; return "A"; 
break;
case 30: yy_.yytext = "\u03BE"; return "A"; 
break;
case 31: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21AA"; return "XARROW"; 
break;
case 32: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); yy_.yytext = "\u21A9"; return "XARROW"; 
break;
case 33: yy_.yytext = "\u2240"; return "OP"; 
break;
case 34: yy_.yytext = "\u2118"; return "A"; 
break;
case 35: yy_.yytext = "\u21C0"; return "ACCENT"; 
break;
case 36: yy_.yytext = "\u02DC"; return "ACCENT"; 
break;
case 37: yy_.yytext = "\u005E"; return "ACCENT"; 
break;
case 38: yy_.yytext = "\u02C7"; return "ACCENT"; 
break;
case 39: yy_.yytext = "\u00AF"; return "ACCENT"; 
break;
case 40: yy_.yytext = "\u2259"; return "OP"; 
break;
case 41: yy_.yytext = "\u22C0"; return "OPM"; 
break;
case 42: yy_.yytext = "\u2227"; return "OP"; 
break;
case 43: yy_.yytext = "\u2980"; return "OPFS"; 
break;
case 44: yy_.yytext = "\u22AA"; return "OP"; 
break;
case 45: yy_.yytext = "\u2230"; return "OP"; 
break;
case 46: yy_.yytext = "\u22D8"; return "OP"; 
break;
case 47: yy_.yytext = "\u22D9"; return "OP"; 
break;
case 48: yy_.yytext = "\u2016"; return "OPFS"; 
break;
case 49: yy_.yytext = "\u007C"; return "OPFS"; 
break;
case 50: yy_.yytext = "\u22BB"; return "OP"; 
break;
case 51: yy_.yytext = "\u22C1"; return "OPM"; 
break;
case 52: yy_.yytext = "\u2228"; return "OP"; 
break;
case 53: yy_.yytext = "\u21C0"; return "ACCENTNS"; 
break;
case 54: yy_.yytext = "\u22EE"; return "OP"; 
break;
case 55: yy_.yytext = "\u22AB"; return "OP"; 
break;
case 56: yy_.yytext = "\u22A9"; return "OP"; 
break;
case 57: yy_.yytext = "\u22A8"; return "OP"; 
break;
case 58: yy_.yytext = "\u22A2"; return "OP"; 
break;
case 59: yy_.yytext = "\u2AEB"; return "OP"; 
break;
case 60: yy_.yytext = "\u22B3"; return "OP"; 
break;
case 61: yy_.yytext = "\u22B2"; return "OP"; 
break;
case 62: yy_.yytext = "\u25B5"; return "OP"; 
break;
case 63: yy_.yytext = "\u03D1"; return "A"; 
break;
case 64: yy_.yytext = "\u228B\uFE00"; return "OP"; 
break;
case 65: yy_.yytext = "\u2ACB\uFE00"; return "OP"; 
break;
case 66: yy_.yytext = "\u228A\uFE00"; return "OP"; 
break;
case 67: yy_.yytext = "\u228A\uFE00"; return "OP"; 
break;
case 68: yy_.yytext = "\u03C2"; return "A"; 
break;
case 69: yy_.yytext = "\u03F1"; return "A"; 
break;
case 70: yy_.yytext = "\u221D"; return "OP"; 
break;
case 71: yy_.yytext = "\u03D6"; return "A"; 
break;
case 72: yy_.yytext = "\u03C6"; return "A"; 
break;
case 73: yy_.yytext = "\u2205"; return "A"; 
break;
case 74: yy_.yytext = "\u03F0"; return "A"; 
break;
case 75: yy_.yytext = "\u03B5"; return "A"; 
break;
case 76: yy_.yytext = "\u290A"; return "OPS"; 
break;
case 77: yy_.yytext = "\u21C8"; return "OPS"; 
break;
case 78: yy_.yytext = "\u22F0"; return "OP"; 
break;
case 79: yy_.yytext = "\u03D2"; return "A"; 
break;
case 80: yy_.yytext = "\u03C5"; return "A"; 
break;
case 81: yy_.yytext = "\u228E"; return "OP"; 
break;
case 82: yy_.yytext = "\u2A1B"; return "OP"; 
break;
case 83: yy_.yytext = "\u21BF"; return "OPS"; 
break;
case 84: yy_.yytext = "\u21BE"; return "OPS"; 
break;
case 85: yy_.yytext = "\u21BF"; return "OPS"; 
break;
case 86: yy_.yytext = "\u21BE"; return "OPS"; 
break;
case 87: yy_.yytext = "\u296E"; return "OPS"; 
break;
case 88: yy_.yytext = "\u21D5"; return "OPS"; 
break;
case 89: yy_.yytext = "\u2195"; return "OPS"; 
break;
case 90: yy_.yytext = "\u2912"; return "OPS"; 
break;
case 91: yy_.yytext = "\u21D1"; return "OPS"; 
break;
case 92: yy_.yytext = "\u2191"; return "OPS"; 
break;
case 93: yy_.yytext = "\u22B5"; return "OP"; 
break;
case 94: yy_.yytext = "\u22B4"; return "OP"; 
break;
case 95: yy_.yytext = "\u22C3"; return "OPM"; 
break;
case 96: yy_.yytext = "\u222A"; return "OP"; 
break;
case 97:return "UNDERSET";
break;
case 98:return "UNDEROVERSET";
break;
case 99:return "UNDERLINE";
break;
case 100:return "UNDERBRACE";
break;
case 101: yy_.yytext = "\u22F0"; return "OP"; 
break;
case 102:return "OP";
break;
case 103:return "OP";
break;
case 104:return "OP";
break;
case 105:return "OP";
break;
case 106:return "OP";
break;
case 107:return "OP";
break;
case 108:return "OP";
break;
case 109:return "OP";
break;
case 110:return "OP";
break;
case 111:return "OP";
break;
case 112:return "OP";
break;
case 113:return "OP";
break;
case 114:return "OP";
break;
case 115:return "OP";
break;
case 116:return "OP";
break;
case 117:return "OP";
break;
case 118:return "OP";
break;
case 119:return "OP";
break;
case 120:return "OP";
break;
case 121:return "OP";
break;
case 122:return "OP";
break;
case 123:return "OP";
break;
case 124:return "OP";
break;
case 125:return "OP";
break;
case 126:return "OP";
break;
case 127:return "OP";
break;
case 128:return "OP";
break;
case 129:return "OP";
break;
case 130:return "OP";
break;
case 131:return "OP";
break;
case 132:return "OP";
break;
case 133:return "OP";
break;
case 134:return "OPFS";
break;
case 135:return "OPFS";
break;
case 136:return "OP";
break;
case 137:return "OP";
break;
case 138:return "OP";
break;
case 139:return "OP";
break;
case 140:return "OP";
break;
case 141:return "OP";
break;
case 142:return "OP";
break;
case 143:return "OP";
break;
case 144:return "OP";
break;
case 145:return "OP";
break;
case 146:return "OP";
break;
case 147:return "OP";
break;
case 148:return "OP";
break;
case 149:return "OP";
break;
case 150:return "OP";
break;
case 151:return "OP";
break;
case 152:return "OP";
break;
case 153:return "OP";
break;
case 154:return "OP";
break;
case 155:return "OP";
break;
case 156:return "OP";
break;
case 157: yy_.yytext = "\u02D8"; return "OP"; 
break;
case 158: yy_.yytext = "\u2916"; return "OP"; 
break;
case 159: yy_.yytext = "\u21A0"; return "OPS"; 
break;
case 160: yy_.yytext = "\u219E"; return "OPS"; 
break;
case 161: yy_.yytext = "\u22A7"; return "OP"; 
break;
case 162: yy_.yytext = "\u222D"; return "OP"; 
break;
case 163: yy_.yytext = "\u22B5"; return "OP"; 
break;
case 164: yy_.yytext = "\u25B9"; return "OP"; 
break;
case 165: yy_.yytext = "\u225C"; return "OP"; 
break;
case 166: yy_.yytext = "\u22B4"; return "OP"; 
break;
case 167: yy_.yytext = "\u25C3"; return "OP"; 
break;
case 168: yy_.yytext = "\u25BF"; return "OP"; 
break;
case 169: yy_.yytext = "\u25B5"; return "OP"; 
break;
case 170: yy_.yytext = "\u292A"; return "OP"; 
break;
case 171: yy_.yytext = "\u2929"; return "OP"; 
break;
case 172: yy_.yytext = "\u22A4"; return "OP"; 
break;
case 173: this.pushState("TEXTARG"); return "TOOLTIP"; 
break;
case 174: yy_.yytext = "\u2927"; return "OP"; 
break;
case 175: return "TOGGLE"; 
break;
case 176: yy_.yytext = "\u2928"; return "OP"; 
break;
case 177: yy_.yytext = "\u2192"; return "OPS"; 
break;
case 178: yy_.yytext = "\u22A0"; return "OP"; 
break;
case 179: yy_.yytext = "\u00D7"; return "OP"; 
break;
case 180: yy_.yytext = "\u224B"; return "OP"; 
break;
case 181: yy_.yytext = "\u02DC"; return "ACCENTNS"; 
break;
case 182:return "THINSPACE";
break;
case 183:return "THICKSPACE";
break;
case 184: yy_.yytext = "\u223C"; return "OP"; 
break;
case 185: yy_.yytext = "\u2248"; return "OP"; 
break;
case 186: yy_.yytext = "\u0398"; return "A"; 
break;
case 187: yy_.yytext = "\u03B8"; return "A"; 
break;
case 188: yy_.yytext = "\u2234"; return "OP"; 
break;
case 189:return "TFRAC";
break;
case 190: yy_.yytext = "\u03D1"; return "A"; 
break;
case 191: yy_.yytext = "\u00D7"; return "OP"; 
break;
case 192: yy_.yytext = "\u02DC"; return "OPS"; 
break;
case 193: yy_.yytext = "\u03F4"; return "A"; 
break;
case 194: yy_.yytext = "\u03B8"; return "A"; 
break;
case 195:return "TEXTSTYLE";
break;
case 196:return "TEXTSIZE";
break;
case 197: yy_.yytext = "\u0027"; return "OP"; 
break;
case 198: yy_.yytext = "\u201D"; return "OPF"; 
break;
case 199: yy_.yytext = "\u201C"; return "OPF"; 
break;
case 200: yy_.yytext = "\u02D9"; return "OP"; 
break;
case 201: yy_.yytext = "\u00BA"; return "OP"; 
break;
case 202: yy_.yytext = "\u00AA"; return "OP"; 
break;
case 203: yy_.yytext = "\u0024"; return "A"; 
break;
case 204: yy_.yytext = "\u00B0"; return "OP"; 
break;
case 205: yy_.yytext = "\u2021"; return "OP"; 
break;
case 206: yy_.yytext = "\u2020"; return "OP"; 
break;
case 207: yy_.yytext = "\u2022"; return "OP"; 
break;
case 208: yy_.yytext = "\u005C"; return "OP"; 
break;
case 209: yy_.yytext = "\u007E"; return "OPS"; 
break;
case 210: yy_.yytext = "\u00AF"; return "OPS"; 
break;
case 211: yy_.yytext = "\u0060"; return "OP"; 
break;
case 212: yy_.yytext = "\u00A8"; return "OP"; 
break;
case 213: yy_.yytext = "\u005E"; return "OPS"; 
break;
case 214: yy_.yytext = "\u02C7"; return "OPS"; 
break;
case 215: yy_.yytext = "\u02D8"; return "OP"; 
break;
case 216: yy_.yytext = "\u00B4"; return "OP"; 
break;
case 217: this.begin("TEXTARG"); return "MTEXT"; 
break;
case 218:return "TENSOR";
break;
case 219:return "TBINOM";
break;
case 220: yy_.yytext = "\u03A4"; return "A"; 
break;
case 221: yy_.yytext = "\u03C4"; return "A"; 
break;
case 222: yy_.yytext = "\u2199"; return "OPS"; 
break;
case 223: yy_.yytext = "\u222F"; return "OP"; 
break;
case 224: yy_.yytext = "\u221A"; return "OPS"; 
break;
case 225: yy_.yytext = "\u2ACC"; return "OP"; 
break;
case 226: yy_.yytext = "\u228B"; return "OP"; 
break;
case 227: yy_.yytext = "\u228B"; return "OP"; 
break;
case 228: yy_.yytext = "\u2AC6"; return "OP"; 
break;
case 229: yy_.yytext = "\u2287"; return "OP"; 
break;
case 230: yy_.yytext = "\u2287"; return "OP"; 
break;
case 231: yy_.yytext = "\u22D1"; return "OP"; 
break;
case 232: yy_.yytext = "\u2283"; return "OP"; 
break;
case 233: yy_.yytext = "\u2211"; return "OPM"; 
break;
case 234: yy_.yytext = "\u227F"; return "OP"; 
break;
case 235: yy_.yytext = "\u22E9"; return "OP"; 
break;
case 236: yy_.yytext = "\u2AB6"; return "OP"; 
break;
case 237: yy_.yytext = "\u2ABA"; return "OP"; 
break;
case 238: yy_.yytext = "\u22E9"; return "OP"; 
break;
case 239: yy_.yytext = "\u2AB0"; return "OP"; 
break;
case 240: yy_.yytext = "\u227D"; return "OP"; 
break;
case 241: yy_.yytext = "\u227D"; return "OP"; 
break;
case 242: yy_.yytext = "\u2AB8"; return "OP"; 
break;
case 243: yy_.yytext = "\u227B"; return "OP"; 
break;
case 244:return "SUBSTACK";
break;
case 245: yy_.yytext = "\u2ACB"; return "OP"; 
break;
case 246: yy_.yytext = "\u228A"; return "OP"; 
break;
case 247: yy_.yytext = "\u228A"; return "OP"; 
break;
case 248: yy_.yytext = "\u2AC5"; return "OP"; 
break;
case 249: yy_.yytext = "\u2286"; return "OP"; 
break;
case 250: yy_.yytext = "\u2286"; return "OP"; 
break;
case 251: yy_.yytext = "\u22D0"; return "OP"; 
break;
case 252: yy_.yytext = "\u2282"; return "OP"; 
break;
case 253: yy_.yytext = "\u03DA"; return "A"; 
break;
case 254: this.pushState("TEXTARG"); return "STATUSLINE"; 
break;
case 255: yy_.yytext = "\u225B"; return "OP"; 
break;
case 256: yy_.yytext = "\u22C6"; return "OP"; 
break;
case 257: yy_.yytext = "\u2A6E"; return "OP"; 
break;
case 258:return "OVERSET";
break;
case 259: yy_.yytext = "\u2AFD"; return "OP"; 
break;
case 260: yy_.yytext = "\u25A1"; return "OP"; 
break;
case 261: yy_.yytext = "\u2292"; return "OP"; 
break;
case 262: yy_.yytext = "\u2290"; return "OP"; 
break;
case 263: yy_.yytext = "\u2291"; return "OP"; 
break;
case 264: yy_.yytext = "\u228F"; return "OP"; 
break;
case 265: this.pushState("OPTARG"); this.pushState("TRYOPTARG"); return "SQRT"; 
break;
case 266: yy_.yytext = "\u2A16"; return "OP"; 
break;
case 267: yy_.yytext = "\u2294"; return "OP"; 
break;
case 268: yy_.yytext = "\u2293"; return "OP"; 
break;
case 269: yy_.yytext = "\u2222"; return "OP"; 
break;
case 270: yy_.yytext = "\u2660"; return "OP"; 
break;
case 271: this.pushState("TEXTARG"); this.pushState("TEXTARG"); this.pushState("TEXTARG"); return "SPACE"; 
break;
case 272: yy_.yytext = "\u2323"; return "OP"; 
break;
case 273: yy_.yytext = "\u2323"; return "OP"; 
break;
case 274: yy_.yytext = "\u2216"; return "OP"; 
break;
case 275: yy_.yytext = "\u2322"; return "OP"; 
break;
case 276:return "SLASH";
break;
case 277: yy_.yytext = "\u27FF"; return "OPS"; 
break;
case 278: yy_.yytext = "\u2243"; return "OP"; 
break;
case 279: yy_.yytext = "\u223C"; return "OP"; 
break;
case 280: yy_.yytext = "\u03A3"; return "A"; 
break;
case 281: yy_.yytext = "\u03C3"; return "A"; 
break;
case 282: yy_.yytext = "\u29E2"; return "OP"; 
break;
case 283: yy_.yytext = "\u2225"; return "OP"; 
break;
case 284: yy_.yytext = "\u2223"; return "OP"; 
break;
case 285: yy_.yytext = "\u266F"; return "OP"; 
break;
case 286: yy_.yytext = "\u2216"; return "OP"; 
break;
case 287: yy_.yytext = "\u292D"; return "OP"; 
break;
case 288: yy_.yytext = "\u2198"; return "OPS"; 
break;
case 289:return "SCRIPTSIZE";
break;
case 290:return "SCRIPTSCRIPTSIZE";
break;
case 291: yy_.yytext = "\u03E0"; return "A"; 
break;
case 292: yy_.yytext = "\u29F4"; return "OP"; 
break;
case 293: yy_.yytext = "\u22CA"; return "OP"; 
break;
case 294: yy_.yytext = "\u21B1"; return "OPS"; 
break;
case 295: yy_.yytext = "\u21DB"; return "OPS"; 
break;
case 296: yy_.yytext = "\u27EB"; return "OPFS"; 
break;
case 297: yy_.yytext = "\u2019"; return "OPF"; 
break;
case 298: this.begin("TEXTARG"); return "ROWSPAN"; 
break;
case 299:return "ROWOPTS";
break;
case 300: this.pushState("TEXTARG"); return "ROWLINES"; 
break;
case 301: this.begin("TEXTARG"); return "ROWALIGN"; 
break;
case 302: yy_.yytext = "\u2970"; return "OP"; 
break;
case 303:return "ROOT";
break;
case 304: yy_.yytext = "\u23B1"; return "OP"; 
break;
case 305: yy_.yytext = "\u2253"; return "OP"; 
break;
case 306: yy_.yytext = "\u2953"; return "OPS"; 
break;
case 307: yy_.yytext = "\u2954"; return "OPS"; 
break;
case 308: yy_.yytext = "\u295C"; return "OPS"; 
break;
case 309: yy_.yytext = "\u294F"; return "OPS"; 
break;
case 310: yy_.yytext = "\u29D0"; return "OP"; 
break;
case 311: yy_.yytext = "\u22CC"; return "OP"; 
break;
case 312: yy_.yytext = "\u295B"; return "OPS"; 
break;
case 313: yy_.yytext = "\u21DD"; return "OPS"; 
break;
case 314: yy_.yytext = "\u219D"; return "OPS"; 
break;
case 315: yy_.yytext = "\u21C9"; return "OPS"; 
break;
case 316: yy_.yytext = "\u21CC"; return "OPS"; 
break;
case 317: yy_.yytext = "\u21C4"; return "OPS"; 
break;
case 318: yy_.yytext = "\u21C0"; return "OPS"; 
break;
case 319: yy_.yytext = "\u21C1"; return "OPS"; 
break;
case 320: yy_.yytext = "\u2955"; return "OPS"; 
break;
case 321: yy_.yytext = "\u295D"; return "OPS"; 
break;
case 322: yy_.yytext = "\u21FE"; return "OPS"; 
break;
case 323: yy_.yytext = "\u21A3"; return "OPS"; 
break;
case 324: yy_.yytext = "\u21D2"; return "OPS"; 
break;
case 325: yy_.yytext = "\u2192"; return "OPS"; 
break;
case 326: yy_.yytext = "\u22BE"; return "OP"; 
break;
case 327: yy_.yytext = "\u221F"; return "OP"; 
break;
case 328:return "RIGHT";
break;
case 329: yy_.yytext = "\u03A1"; return "A"; 
break;
case 330: yy_.yytext = "\u03C1"; return "A"; 
break;
case 331: yy_.yytext = "\u22B3"; return "OP"; 
break;
case 332: yy_.yytext = "\u230B"; return "OPFS"; 
break;
case 333: yy_.yytext = "\u296F"; return "OPS"; 
break;
case 334: yy_.yytext = "\u211C"; return "A"; 
break;
case 335: yy_.yytext = "\u2930"; return "OP"; 
break;
case 336: yy_.yytext = "\u292B"; return "OP"; 
break;
case 337: yy_.yytext = "\u2309"; return "OPFS"; 
break;
case 338: yy_.yytext = "\u005D"; return "OPFS"; 
break;
case 339: yy_.yytext = "\u007D"; return "OPFS"; 
break;
case 340: yy_.yytext = "\u27E9"; return "OPFS"; 
break;
case 341: yy_.yytext = "\u27E9"; return "OPFS"; 
break;
case 342: yy_.yytext = "\u02DA"; return "OP"; 
break;
case 343: yy_.yytext = "\u225F"; return "OP"; 
break;
case 344: yy_.yytext = "\u2A0C"; return "OP"; 
break;
case 345:return "QUAD";
break;
case 346:return "QQUAD";
break;
case 347: yy_.yytext = "\u25AA"; return "OP"; 
break;
case 348: yy_.yytext = "\u03A8"; return "A"; 
break;
case 349: yy_.yytext = "\u03C8"; return "A"; 
break;
case 350: yy_.yytext = "\u221D"; return "OP"; 
break;
case 351: yy_.yytext = "\u220F"; return "OPM"; 
break;
case 352: yy_.yytext = "\u220F"; return "OPM"; 
break;
case 353: yy_.yytext = "\u2032"; return "OPP"; 
break;
case 354: yy_.yytext = "\u227E"; return "OP"; 
break;
case 355: yy_.yytext = "\u22E8"; return "OP"; 
break;
case 356: yy_.yytext = "\u2AB5"; return "OP"; 
break;
case 357: yy_.yytext = "\u2AB9"; return "OP"; 
break;
case 358: yy_.yytext = "\u2AAF"; return "OP"; 
break;
case 359: yy_.yytext = "\u22E8"; return "OP"; 
break;
case 360: yy_.yytext = "\u227C"; return "OP"; 
break;
case 361: yy_.yytext = "\u2AB7"; return "OP"; 
break;
case 362: yy_.yytext = "\u227A"; return "OP"; 
break;
case 363:return "PMOD";
break;
case 364: yy_.yytext = "\u00B1"; return "OP"; 
break;
case 365: yy_.yytext = "\u2A25"; return "OP"; 
break;
case 366: yy_.yytext = "\u229E"; return "OP"; 
break;
case 367: yy_.yytext = "\u22D4"; return "OP"; 
break;
case 368: yy_.yytext = "\u03A0"; return "A"; 
break;
case 369: yy_.yytext = "\u03C0"; return "A"; 
break;
case 370: yy_.yytext = "\u03A6"; return "A"; 
break;
case 371: yy_.yytext = "\u03D5"; return "A"; 
break;
case 372:return "PHANTOM";
break;
case 373: yy_.yytext = "\u2306"; return "OP"; 
break;
case 374: yy_.yytext = "\u2AEB"; return "OP"; 
break;
case 375: yy_.yytext = "\u22A5"; return "OP"; 
break;
case 376: yy_.yytext = "\u2AA3"; return "OP"; 
break;
case 377: yy_.yytext = "\u2202"; return "OP"; 
break;
case 378: yy_.yytext = "\u214B"; return "OP"; 
break;
case 379: yy_.yytext = "\u2225"; return "OP"; 
break;
case 380: this.pushState("TEXTARG"); return "PADDING"; 
break;
case 381:return "OVERSET";
break;
case 382: yy_.yytext = "\u00AF"; return "ACCENT"; 
break;
case 383:return "OVERBRACE";
break;
case 384:return "TEXOVER";
break;
case 385: yy_.yytext = "\u2A34"; return "OP"; 
break;
case 386: yy_.yytext = "\u2297"; return "OP"; 
break;
case 387: yy_.yytext = "\u2298"; return "OP"; 
break;
case 388: yy_.yytext = "\u22B6"; return "OP"; 
break;
case 389:return "OPS";
break;
case 390:return "OPP";
break;
case 391:return "OPM";
break;
case 392: yy_.yytext = "\u2A2D"; return "OP"; 
break;
case 393: yy_.yytext = "\u2295"; return "OP"; 
break;
case 394:return "OPFS";
break;
case 395:return "OPF";
break;
case 396: this.begin("TEXTARG"); return "OPERATORNAME"; 
break;
case 397:return "OP";
break;
case 398: yy_.yytext = "\u2296"; return "OP"; 
break;
case 399: yy_.yytext = "\u2134"; return "A"; 
break;
case 400: yy_.yytext = "\u03A9"; return "A"; 
break;
case 401: yy_.yytext = "\u03C9"; return "A"; 
break;
case 402: yy_.yytext = "\u222E"; return "OP"; 
break;
case 403: yy_.yytext = "\u222F"; return "OP"; 
break;
case 404: yy_.yytext = "\u2230"; return "OP"; 
break;
case 405: yy_.yytext = "\u2299"; return "OP"; 
break;
case 406: yy_.yytext = "\u229D"; return "OP"; 
break;
case 407: yy_.yytext = "\u29B8"; return "OP"; 
break;
case 408: yy_.yytext = "\u2932"; return "OP"; 
break;
case 409: yy_.yytext = "\u2196"; return "OPS"; 
break;
case 410: yy_.yytext = "\u22AF"; return "OP"; 
break;
case 411: yy_.yytext = "\u22AE"; return "OP"; 
break;
case 412: yy_.yytext = "\u22AD"; return "OP"; 
break;
case 413: yy_.yytext = "\u22AC"; return "OP"; 
break;
case 414:return "NUM";
break;
case 415: yy_.yytext = "\u03BD"; return "A"; 
break;
case 416: yy_.yytext = "\u22ED"; return "OP"; 
break;
case 417: yy_.yytext = "\u22EB"; return "OP"; 
break;
case 418: yy_.yytext = "\u22EC"; return "OP"; 
break;
case 419: yy_.yytext = "\u22EA"; return "OP"; 
break;
case 420: yy_.yytext = "\u2289"; return "OP"; 
break;
case 421: yy_.yytext = "\u2289"; return "OP"; 
break;
case 422: yy_.yytext = "\u2285"; return "OP"; 
break;
case 423: yy_.yytext = "\u227F\u0338"; return "OP"; 
break;
case 424: yy_.yytext = "\u2AB0\u0338"; return "OP"; 
break;
case 425: yy_.yytext = "\u2281"; return "OP"; 
break;
case 426: yy_.yytext = "\u2288"; return "OP"; 
break;
case 427: yy_.yytext = "\u2288"; return "OP"; 
break;
case 428: yy_.yytext = "\u2284"; return "OP"; 
break;
case 429: yy_.yytext = "\u2244"; return "OP"; 
break;
case 430: yy_.yytext = "\u2241"; return "OP"; 
break;
case 431: yy_.yytext = "\u2226"; return "OP"; 
break;
case 432: yy_.yytext = "\u2224"; return "OP"; 
break;
case 433: yy_.yytext = "\u21CF"; return "OP"; 
break;
case 434: yy_.yytext = "\u219B"; return "OP"; 
break;
case 435: yy_.yytext = "\u2AAF\u0338"; return "OP"; 
break;
case 436: yy_.yytext = "\u2280"; return "OP"; 
break;
case 437: yy_.yytext = "\u2226"; return "OP"; 
break;
case 438: yy_.yytext = "\u2289"; return "OP"; 
break;
case 439: yy_.yytext = "\u2285"; return "OP"; 
break;
case 440: yy_.yytext = "\u2AB0\u0338"; return "OP"; 
break;
case 441: yy_.yytext = "\u227F\u0338"; return "OP"; 
break;
case 442: yy_.yytext = "\u2281"; return "OP"; 
break;
case 443: yy_.yytext = "\u2288"; return "OP"; 
break;
case 444: yy_.yytext = "\u2284"; return "OP"; 
break;
case 445: yy_.yytext = "\u2290\u0338"; return "OP"; 
break;
case 446: yy_.yytext = "\u228F\u0338"; return "OP"; 
break;
case 447: yy_.yytext = "\u22E3"; return "OP"; 
break;
case 448: yy_.yytext = "\u22E2"; return "OP"; 
break;
case 449: yy_.yytext = "\u2244"; return "OP"; 
break;
case 450: yy_.yytext = "\u2241"; return "OP"; 
break;
case 451: yy_.yytext = "\u29D0\u0338"; return "OP"; 
break;
case 452: yy_.yytext = "\u2AAF\u0338"; return "OP"; 
break;
case 453: yy_.yytext = "\u2280"; return "OP"; 
break;
case 454: yy_.yytext = "\u220C"; return "OP"; 
break;
case 455: yy_.yytext = "\u220C"; return "OP"; 
break;
case 456: yy_.yytext = "\u2AA1\u0338"; return "OP"; 
break;
case 457: yy_.yytext = "\u2AA2\u0338"; return "OP"; 
break;
case 458: yy_.yytext = "\u226A\u0338"; return "OP"; 
break;
case 459: yy_.yytext = "\u2278"; return "OP"; 
break;
case 460: yy_.yytext = "\u2270"; return "OP"; 
break;
case 461: yy_.yytext = "\u29CF\u0338"; return "OP"; 
break;
case 462: yy_.yytext = "\u2270"; return "OP"; 
break;
case 463: yy_.yytext = "\u226D"; return "OP"; 
break;
case 464: yy_.yytext = "\u2209"; return "OP"; 
break;
case 465: yy_.yytext = "\u2209"; return "OP"; 
break;
case 466: yy_.yytext = "\u224F\u0338"; return "OP"; 
break;
case 467: yy_.yytext = "\u224E\u0338"; return "OP"; 
break;
case 468: yy_.yytext = "\u2279"; return "OP"; 
break;
case 469: yy_.yytext = "\u226B\u0338"; return "OP"; 
break;
case 470: yy_.yytext = "\u2271"; return "OP"; 
break;
case 471: yy_.yytext = "\u2271"; return "OP"; 
break;
case 472: yy_.yytext = "\u2262"; return "OP"; 
break;
case 473: yy_.yytext = "\u2242\u0338"; return "OP"; 
break;
case 474: yy_.yytext = "\u2247"; return "OP"; 
break;
case 475: yy_.yytext = "\u2249"; return "OP"; 
break;
case 476: yy_.yytext = "\u226F"; return "OP"; 
break;
case 477: yy_.yytext = "\u226E"; return "OP"; 
break;
case 478: yy_.yytext = "\u2260"; return "OP"; 
break;
case 479: yy_.yytext = "\u2209"; return "OP"; 
break;
case 480: yy_.yytext = "\u2224"; return "OP"; 
break;
case 481: yy_.yytext = "\u226E"; return "OP"; 
break;
case 482: yy_.yytext = "\u2A7D\u0338"; return "OP"; 
break;
case 483: yy_.yytext = "\u2A7D\u0338"; return "OP"; 
break;
case 484: yy_.yytext = "\u2270"; return "OP"; 
break;
case 485: yy_.yytext = "\u21CE"; return "OP"; 
break;
case 486: yy_.yytext = "\u21AE"; return "OP"; 
break;
case 487: yy_.yytext = "\u21CD"; return "OP"; 
break;
case 488: yy_.yytext = "\u219A"; return "OP"; 
break;
case 489: yy_.yytext = "\u220B"; return "OP"; 
break;
case 490: yy_.yytext = "\u226F"; return "OP"; 
break;
case 491: yy_.yytext = "\u2A7E\u0338"; return "OP"; 
break;
case 492: yy_.yytext = "\u2A7E\u0338"; return "OP"; 
break;
case 493: yy_.yytext = "\u2271"; return "OP"; 
break;
case 494: yy_.yytext = "\u2204"; return "OP"; 
break;
case 495: yy_.yytext = "\u2AA1"; return "OP"; 
break;
case 496: yy_.yytext = "\u2AA2"; return "OP"; 
break;
case 497: yy_.yytext = "\u2262"; return "OP"; 
break;
case 498: yy_.yytext = "\u2242\u0338"; return "OP"; 
break;
case 499: yy_.yytext = "\u2260"; return "OP"; 
break;
case 500: yy_.yytext = "\u292E"; return "OP"; 
break;
case 501: yy_.yytext = "\u2931"; return "OP"; 
break;
case 502:return "NEGTHICKSPACE";
break;
case 503:return "NEGSPACE";
break;
case 504:return "NEGMEDSPACE";
break;
case 505: yy_.yytext = "\u00AC"; return "OP"; 
break;
case 506: yy_.yytext = "\u2197"; return "OPS"; 
break;
case 507: yy_.yytext = "\u2260"; return "OP"; 
break;
case 508: yy_.yytext = "\u2247"; return "OP"; 
break;
case 509: yy_.yytext = "\u224E\u0338"; return "OP"; 
break;
case 510: yy_.yytext = "\u224F\u0338"; return "OP"; 
break;
case 511: yy_.yytext = "\u266E"; return "OP"; 
break;
case 512: yy_.yytext = "\u2249"; return "OP"; 
break;
case 513: yy_.yytext = "\u2207"; return "OP"; 
break;
case 514:return "MULTI";
break;
case 515: yy_.yytext = "\u22B8"; return "OP"; 
break;
case 516: yy_.yytext = "\u03BC"; return "A"; 
break;
case 517: this.begin("TEXTARG"); return "MTEXT"; 
break;
case 518: this.pushState("TEXTARG"); this.pushState("TEXTOPTARG"); this.pushState("TRYOPTARG"); this.pushState("TEXTOPTARG"); this.pushState("TRYOPTARG"); return "MS"; 
break;
case 519: yy_.yytext = "\u2213"; return "OP"; 
break;
case 520: yy_.yytext = "\u22A8"; return "OP"; 
break;
case 521: yy_.yytext = "\u22A7"; return "OP"; 
break;
case 522: yy_.yytext = "mod"; return "MO"; 
break;
case 523: this.pushState("TEXTARG"); return "MO"; 
break;
case 524: this.pushState("TEXTARG"); return "MN"; 
break;
case 525: yy_.yytext = "\u2ADB"; return "OP"; 
break;
case 526: yy_.yytext = "\u2A2A"; return "OP"; 
break;
case 527: yy_.yytext = "\u229F"; return "OP"; 
break;
case 528: yy_.yytext = "\u2212"; return "OP"; 
break;
case 529: yy_.yytext = yy_.yytext.slice(1); return "FM"; 
break;
case 530: yy_.yytext = "\u2223"; return "OP"; 
break;
case 531: this.pushState("TEXTARG"); return "MI"; 
break;
case 532:return "MEDSPACE";
break;
case 533: yy_.yytext = "\u2221"; return "OP"; 
break;
case 534: yy_.yytext = "\uD835\uDE89"; return "A"; 
break;
case 535: yy_.yytext = "\uD835\uDEA3"; return "A"; 
break;
case 536: yy_.yytext = "\uD835\uDE88"; return "A"; 
break;
case 537: yy_.yytext = "\uD835\uDEA2"; return "A"; 
break;
case 538: yy_.yytext = "\uD835\uDE87"; return "A"; 
break;
case 539: yy_.yytext = "\uD835\uDEA1"; return "A"; 
break;
case 540: yy_.yytext = "\uD835\uDE86"; return "A"; 
break;
case 541: yy_.yytext = "\uD835\uDEA0"; return "A"; 
break;
case 542: yy_.yytext = "\uD835\uDE85"; return "A"; 
break;
case 543: yy_.yytext = "\uD835\uDE9F"; return "A"; 
break;
case 544: yy_.yytext = "\uD835\uDE84"; return "A"; 
break;
case 545: yy_.yytext = "\uD835\uDE9E"; return "A"; 
break;
case 546: yy_.yytext = "\uD835\uDE83"; return "A"; 
break;
case 547: yy_.yytext = "\uD835\uDE9D"; return "A"; 
break;
case 548: yy_.yytext = "\uD835\uDE82"; return "A"; 
break;
case 549: yy_.yytext = "\uD835\uDE9C"; return "A"; 
break;
case 550: yy_.yytext = "\uD835\uDE81"; return "A"; 
break;
case 551: yy_.yytext = "\uD835\uDE9B"; return "A"; 
break;
case 552: yy_.yytext = "\uD835\uDE80"; return "A"; 
break;
case 553: yy_.yytext = "\uD835\uDE9A"; return "A"; 
break;
case 554: yy_.yytext = "\uD835\uDE7F"; return "A"; 
break;
case 555: yy_.yytext = "\uD835\uDE99"; return "A"; 
break;
case 556: yy_.yytext = "\uD835\uDE7E"; return "A"; 
break;
case 557: yy_.yytext = "\uD835\uDE98"; return "A"; 
break;
case 558: yy_.yytext = "\uD835\uDE7D"; return "A"; 
break;
case 559: yy_.yytext = "\uD835\uDE97"; return "A"; 
break;
case 560: yy_.yytext = "\uD835\uDE7C"; return "A"; 
break;
case 561: yy_.yytext = "\uD835\uDE96"; return "A"; 
break;
case 562: yy_.yytext = "\uD835\uDE7B"; return "A"; 
break;
case 563: yy_.yytext = "\uD835\uDE95"; return "A"; 
break;
case 564: yy_.yytext = "\uD835\uDE7A"; return "A"; 
break;
case 565: yy_.yytext = "\uD835\uDE94"; return "A"; 
break;
case 566: yy_.yytext = "\uD835\uDE79"; return "A"; 
break;
case 567: yy_.yytext = "\uD835\uDE93"; return "A"; 
break;
case 568: yy_.yytext = "\uD835\uDE78"; return "A"; 
break;
case 569: yy_.yytext = "\uD835\uDE92"; return "A"; 
break;
case 570: yy_.yytext = "\uD835\uDE77"; return "A"; 
break;
case 571: yy_.yytext = "\uD835\uDE91"; return "A"; 
break;
case 572: yy_.yytext = "\uD835\uDE76"; return "A"; 
break;
case 573: yy_.yytext = "\uD835\uDE90"; return "A"; 
break;
case 574: yy_.yytext = "\uD835\uDE75"; return "A"; 
break;
case 575: yy_.yytext = "\uD835\uDE8F"; return "A"; 
break;
case 576: yy_.yytext = "\uD835\uDE74"; return "A"; 
break;
case 577: yy_.yytext = "\uD835\uDE8E"; return "A"; 
break;
case 578: yy_.yytext = "\uD835\uDE73"; return "A"; 
break;
case 579: yy_.yytext = "\uD835\uDE8D"; return "A"; 
break;
case 580: yy_.yytext = "\uD835\uDE72"; return "A"; 
break;
case 581: yy_.yytext = "\uD835\uDE8C"; return "A"; 
break;
case 582: yy_.yytext = "\uD835\uDE71"; return "A"; 
break;
case 583: yy_.yytext = "\uD835\uDE8B"; return "A"; 
break;
case 584: yy_.yytext = "\uD835\uDE70"; return "A"; 
break;
case 585: yy_.yytext = "\uD835\uDE8A"; return "A"; 
break;
case 586:return "MATHTT";
break;
case 587: yy_.yytext = "\uD835\uDDB9"; return "A"; 
break;
case 588: yy_.yytext = "\uD835\uDDD3"; return "A"; 
break;
case 589: yy_.yytext = "\uD835\uDDB8"; return "A"; 
break;
case 590: yy_.yytext = "\uD835\uDDD2"; return "A"; 
break;
case 591: yy_.yytext = "\uD835\uDDB7"; return "A"; 
break;
case 592: yy_.yytext = "\uD835\uDDD1"; return "A"; 
break;
case 593: yy_.yytext = "\uD835\uDDB6"; return "A"; 
break;
case 594: yy_.yytext = "\uD835\uDDD0"; return "A"; 
break;
case 595: yy_.yytext = "\uD835\uDDB5"; return "A"; 
break;
case 596: yy_.yytext = "\uD835\uDDCF"; return "A"; 
break;
case 597: yy_.yytext = "\uD835\uDDB4"; return "A"; 
break;
case 598: yy_.yytext = "\uD835\uDDCE"; return "A"; 
break;
case 599: yy_.yytext = "\uD835\uDDB3"; return "A"; 
break;
case 600: yy_.yytext = "\uD835\uDDCD"; return "A"; 
break;
case 601: yy_.yytext = "\uD835\uDE21"; return "A"; 
break;
case 602: yy_.yytext = "\uD835\uDE3B"; return "A"; 
break;
case 603: yy_.yytext = "\uD835\uDE20"; return "A"; 
break;
case 604: yy_.yytext = "\uD835\uDE3A"; return "A"; 
break;
case 605: yy_.yytext = "\uD835\uDE1F"; return "A"; 
break;
case 606: yy_.yytext = "\uD835\uDE39"; return "A"; 
break;
case 607: yy_.yytext = "\uD835\uDE1E"; return "A"; 
break;
case 608: yy_.yytext = "\uD835\uDE38"; return "A"; 
break;
case 609: yy_.yytext = "\uD835\uDE1D"; return "A"; 
break;
case 610: yy_.yytext = "\uD835\uDE37"; return "A"; 
break;
case 611: yy_.yytext = "\uD835\uDE1C"; return "A"; 
break;
case 612: yy_.yytext = "\uD835\uDE36"; return "A"; 
break;
case 613: yy_.yytext = "\uD835\uDE1B"; return "A"; 
break;
case 614: yy_.yytext = "\uD835\uDE35"; return "A"; 
break;
case 615: yy_.yytext = "\uD835\uDE1A"; return "A"; 
break;
case 616: yy_.yytext = "\uD835\uDE34"; return "A"; 
break;
case 617: yy_.yytext = "\uD835\uDE19"; return "A"; 
break;
case 618: yy_.yytext = "\uD835\uDE33"; return "A"; 
break;
case 619: yy_.yytext = "\uD835\uDE18"; return "A"; 
break;
case 620: yy_.yytext = "\uD835\uDE32"; return "A"; 
break;
case 621: yy_.yytext = "\uD835\uDE17"; return "A"; 
break;
case 622: yy_.yytext = "\uD835\uDE31"; return "A"; 
break;
case 623: yy_.yytext = "\uD835\uDE16"; return "A"; 
break;
case 624: yy_.yytext = "\uD835\uDE30"; return "A"; 
break;
case 625: yy_.yytext = "\uD835\uDE15"; return "A"; 
break;
case 626: yy_.yytext = "\uD835\uDE2F"; return "A"; 
break;
case 627: yy_.yytext = "\uD835\uDE14"; return "A"; 
break;
case 628: yy_.yytext = "\uD835\uDE2E"; return "A"; 
break;
case 629: yy_.yytext = "\uD835\uDE13"; return "A"; 
break;
case 630: yy_.yytext = "\uD835\uDE2D"; return "A"; 
break;
case 631: yy_.yytext = "\uD835\uDE12"; return "A"; 
break;
case 632: yy_.yytext = "\uD835\uDE2C"; return "A"; 
break;
case 633: yy_.yytext = "\uD835\uDE11"; return "A"; 
break;
case 634: yy_.yytext = "\uD835\uDE2B"; return "A"; 
break;
case 635: yy_.yytext = "\uD835\uDE10"; return "A"; 
break;
case 636: yy_.yytext = "\uD835\uDE2A"; return "A"; 
break;
case 637: yy_.yytext = "\uD835\uDE0F"; return "A"; 
break;
case 638: yy_.yytext = "\uD835\uDE29"; return "A"; 
break;
case 639: yy_.yytext = "\uD835\uDE0E"; return "A"; 
break;
case 640: yy_.yytext = "\uD835\uDE28"; return "A"; 
break;
case 641: yy_.yytext = "\uD835\uDE0D"; return "A"; 
break;
case 642: yy_.yytext = "\uD835\uDE27"; return "A"; 
break;
case 643: yy_.yytext = "\uD835\uDE0C"; return "A"; 
break;
case 644: yy_.yytext = "\uD835\uDE26"; return "A"; 
break;
case 645: yy_.yytext = "\uD835\uDE0B"; return "A"; 
break;
case 646: yy_.yytext = "\uD835\uDE25"; return "A"; 
break;
case 647: yy_.yytext = "\uD835\uDE0A"; return "A"; 
break;
case 648: yy_.yytext = "\uD835\uDE24"; return "A"; 
break;
case 649: yy_.yytext = "\uD835\uDE09"; return "A"; 
break;
case 650: yy_.yytext = "\uD835\uDE23"; return "A"; 
break;
case 651: yy_.yytext = "\uD835\uDE08"; return "A"; 
break;
case 652: yy_.yytext = "\uD835\uDE22"; return "A"; 
break;
case 653: yy_.yytext = "\uD835\uDDB2"; return "A"; 
break;
case 654: yy_.yytext = "\uD835\uDDCC"; return "A"; 
break;
case 655: yy_.yytext = "\uD835\uDDB1"; return "A"; 
break;
case 656: yy_.yytext = "\uD835\uDDCB"; return "A"; 
break;
case 657: yy_.yytext = "\uD835\uDDB0"; return "A"; 
break;
case 658: yy_.yytext = "\uD835\uDDCA"; return "A"; 
break;
case 659: yy_.yytext = "\uD835\uDDAF"; return "A"; 
break;
case 660: yy_.yytext = "\uD835\uDDC9"; return "A"; 
break;
case 661: yy_.yytext = "\uD835\uDDAE"; return "A"; 
break;
case 662: yy_.yytext = "\uD835\uDDC8"; return "A"; 
break;
case 663: yy_.yytext = "\uD835\uDDAD"; return "A"; 
break;
case 664: yy_.yytext = "\uD835\uDDC7"; return "A"; 
break;
case 665: yy_.yytext = "\uD835\uDDAC"; return "A"; 
break;
case 666: yy_.yytext = "\uD835\uDDC6"; return "A"; 
break;
case 667: yy_.yytext = "\uD835\uDDAB"; return "A"; 
break;
case 668: yy_.yytext = "\uD835\uDDC5"; return "A"; 
break;
case 669: yy_.yytext = "\uD835\uDDAA"; return "A"; 
break;
case 670: yy_.yytext = "\uD835\uDDC4"; return "A"; 
break;
case 671: yy_.yytext = "\uD835\uDDA9"; return "A"; 
break;
case 672: yy_.yytext = "\uD835\uDDC3"; return "A"; 
break;
case 673: yy_.yytext = "\uD835\uDDA8"; return "A"; 
break;
case 674: yy_.yytext = "\uD835\uDDC2"; return "A"; 
break;
case 675: yy_.yytext = "\uD835\uDDA7"; return "A"; 
break;
case 676: yy_.yytext = "\uD835\uDDC1"; return "A"; 
break;
case 677: yy_.yytext = "\uD835\uDDA6"; return "A"; 
break;
case 678: yy_.yytext = "\uD835\uDDC0"; return "A"; 
break;
case 679: yy_.yytext = "\uD835\uDDA5"; return "A"; 
break;
case 680: yy_.yytext = "\uD835\uDDBF"; return "A"; 
break;
case 681: yy_.yytext = "\uD835\uDDA4"; return "A"; 
break;
case 682: yy_.yytext = "\uD835\uDDBE"; return "A"; 
break;
case 683: yy_.yytext = "\uD835\uDDA3"; return "A"; 
break;
case 684: yy_.yytext = "\uD835\uDDBD"; return "A"; 
break;
case 685: yy_.yytext = "\uD835\uDDA2"; return "A"; 
break;
case 686: yy_.yytext = "\uD835\uDDBC"; return "A"; 
break;
case 687: yy_.yytext = "\uD835\uDF5B"; return "A"; 
break;
case 688: yy_.yytext = "\uD835\uDF75"; return "A"; 
break;
case 689: yy_.yytext = "\uD835\uDDED"; return "A"; 
break;
case 690: yy_.yytext = "\uD835\uDE07"; return "A"; 
break;
case 691: yy_.yytext = "\uD835\uDDEC"; return "A"; 
break;
case 692: yy_.yytext = "\uD835\uDE06"; return "A"; 
break;
case 693: yy_.yytext = "\uD835\uDF63"; return "A"; 
break;
case 694: yy_.yytext = "\uD835\uDF7D"; return "A"; 
break;
case 695: yy_.yytext = "\uD835\uDDEB"; return "A"; 
break;
case 696: yy_.yytext = "\uD835\uDE05"; return "A"; 
break;
case 697: yy_.yytext = "\uD835\uDDEA"; return "A"; 
break;
case 698: yy_.yytext = "\uD835\uDE04"; return "A"; 
break;
case 699: yy_.yytext = "\uD835\uDF8B"; return "A"; 
break;
case 700: yy_.yytext = "\uD835\uDF67"; return "A"; 
break;
case 701: yy_.yytext = "\uD835\uDF81"; return "A"; 
break;
case 702: yy_.yytext = "\uD835\uDF8E"; return "A"; 
break;
case 703: yy_.yytext = "\uD835\uDF8F"; return "A"; 
break;
case 704: yy_.yytext = "\uD835\uDF8C"; return "A"; 
break;
case 705: yy_.yytext = "\uD835\uDDE9"; return "A"; 
break;
case 706: yy_.yytext = "\uD835\uDE03"; return "A"; 
break;
case 707: yy_.yytext = "\uD835\uDF6A"; return "A"; 
break;
case 708: yy_.yytext = "\uD835\uDF84"; return "A"; 
break;
case 709: yy_.yytext = "\uD835\uDDE8"; return "A"; 
break;
case 710: yy_.yytext = "\uD835\uDE02"; return "A"; 
break;
case 711: yy_.yytext = "\uD835\uDF5D"; return "A"; 
break;
case 712: yy_.yytext = "\uD835\uDF77"; return "A"; 
break;
case 713: yy_.yytext = "\uD835\uDF69"; return "A"; 
break;
case 714: yy_.yytext = "\uD835\uDF83"; return "A"; 
break;
case 715: yy_.yytext = "\uD835\uDDE7"; return "A"; 
break;
case 716: yy_.yytext = "\uD835\uDE01"; return "A"; 
break;
case 717: yy_.yytext = "\uD835\uDF95"; return "A"; 
break;
case 718: yy_.yytext = "\uD835\uDFAF"; return "A"; 
break;
case 719: yy_.yytext = "\uD835\uDE55"; return "A"; 
break;
case 720: yy_.yytext = "\uD835\uDE6F"; return "A"; 
break;
case 721: yy_.yytext = "\uD835\uDE54"; return "A"; 
break;
case 722: yy_.yytext = "\uD835\uDE6E"; return "A"; 
break;
case 723: yy_.yytext = "\uD835\uDF9D"; return "A"; 
break;
case 724: yy_.yytext = "\uD835\uDFB7"; return "A"; 
break;
case 725: yy_.yytext = "\uD835\uDE53"; return "A"; 
break;
case 726: yy_.yytext = "\uD835\uDE6D"; return "A"; 
break;
case 727: yy_.yytext = "\uD835\uDE52"; return "A"; 
break;
case 728: yy_.yytext = "\uD835\uDE6C"; return "A"; 
break;
case 729: yy_.yytext = "\uD835\uDFC5"; return "A"; 
break;
case 730: yy_.yytext = "\uD835\uDFB1"; return "A"; 
break;
case 731: yy_.yytext = "\uD835\uDFA1"; return "A"; 
break;
case 732: yy_.yytext = "\uD835\uDF97"; return "A"; 
break;
case 733: yy_.yytext = "\uD835\uDFBB"; return "A"; 
break;
case 734: yy_.yytext = "\uD835\uDFC8"; return "A"; 
break;
case 735: yy_.yytext = "\uD835\uDFC9"; return "A"; 
break;
case 736: yy_.yytext = "\uD835\uDFC6"; return "A"; 
break;
case 737: yy_.yytext = "\uD835\uDE51"; return "A"; 
break;
case 738: yy_.yytext = "\uD835\uDE6B"; return "A"; 
break;
case 739: yy_.yytext = "\uD835\uDFA4"; return "A"; 
break;
case 740: yy_.yytext = "\uD835\uDFBE"; return "A"; 
break;
case 741: yy_.yytext = "\uD835\uDE50"; return "A"; 
break;
case 742: yy_.yytext = "\uD835\uDE6A"; return "A"; 
break;
case 743: yy_.yytext = "\uD835\uDFA3"; return "A"; 
break;
case 744: yy_.yytext = "\uD835\uDFBD"; return "A"; 
break;
case 745: yy_.yytext = "\uD835\uDE4F"; return "A"; 
break;
case 746: yy_.yytext = "\uD835\uDE69"; return "A"; 
break;
case 747: yy_.yytext = "\uD835\uDFA2"; return "A"; 
break;
case 748: yy_.yytext = "\uD835\uDFBC"; return "A"; 
break;
case 749: yy_.yytext = "\uD835\uDE4E"; return "A"; 
break;
case 750: yy_.yytext = "\uD835\uDE68"; return "A"; 
break;
case 751: yy_.yytext = "\uD835\uDFBA"; return "A"; 
break;
case 752: yy_.yytext = "\uD835\uDFA0"; return "A"; 
break;
case 753: yy_.yytext = "\uD835\uDE4D"; return "A"; 
break;
case 754: yy_.yytext = "\uD835\uDE67"; return "A"; 
break;
case 755: yy_.yytext = "\uD835\uDE4C"; return "A"; 
break;
case 756: yy_.yytext = "\uD835\uDE66"; return "A"; 
break;
case 757: yy_.yytext = "\uD835\uDFA7"; return "A"; 
break;
case 758: yy_.yytext = "\uD835\uDFC1"; return "A"; 
break;
case 759: yy_.yytext = "\uD835\uDF9F"; return "A"; 
break;
case 760: yy_.yytext = "\uD835\uDFB9"; return "A"; 
break;
case 761: yy_.yytext = "\uD835\uDFBF"; return "A"; 
break;
case 762: yy_.yytext = "\uD835\uDFA5"; return "A"; 
break;
case 763: yy_.yytext = "\uD835\uDFC7"; return "A"; 
break;
case 764: yy_.yytext = "\uD835\uDE4B"; return "A"; 
break;
case 765: yy_.yytext = "\uD835\uDE65"; return "A"; 
break;
case 766: yy_.yytext = "\uD835\uDFC2"; return "A"; 
break;
case 767: yy_.yytext = "\uD835\uDFA8"; return "A"; 
break;
case 768: yy_.yytext = "\uD835\uDE4A"; return "A"; 
break;
case 769: yy_.yytext = "\uD835\uDE64"; return "A"; 
break;
case 770: yy_.yytext = "\uD835\uDFA9"; return "A"; 
break;
case 771: yy_.yytext = "\uD835\uDE49"; return "A"; 
break;
case 772: yy_.yytext = "\uD835\uDE63"; return "A"; 
break;
case 773: yy_.yytext = "\uD835\uDE48"; return "A"; 
break;
case 774: yy_.yytext = "\uD835\uDE62"; return "A"; 
break;
case 775: yy_.yytext = "\uD835\uDFB4"; return "A"; 
break;
case 776: yy_.yytext = "\uD835\uDF9A"; return "A"; 
break;
case 777: yy_.yytext = "\uD835\uDE47"; return "A"; 
break;
case 778: yy_.yytext = "\uD835\uDE61"; return "A"; 
break;
case 779: yy_.yytext = "\uD835\uDFB3"; return "A"; 
break;
case 780: yy_.yytext = "\uD835\uDF99"; return "A"; 
break;
case 781: yy_.yytext = "\uD835\uDE46"; return "A"; 
break;
case 782: yy_.yytext = "\uD835\uDE60"; return "A"; 
break;
case 783: yy_.yytext = "\uD835\uDE45"; return "A"; 
break;
case 784: yy_.yytext = "\uD835\uDE5F"; return "A"; 
break;
case 785: yy_.yytext = "\uD835\uDFB2"; return "A"; 
break;
case 786: yy_.yytext = "\uD835\uDF98"; return "A"; 
break;
case 787: yy_.yytext = "\uD835\uDE44"; return "A"; 
break;
case 788: yy_.yytext = "\uD835\uDE5E"; return "A"; 
break;
case 789: yy_.yytext = "\uD835\uDE43"; return "A"; 
break;
case 790: yy_.yytext = "\uD835\uDE5D"; return "A"; 
break;
case 791: yy_.yytext = "\uD835\uDFAC"; return "A"; 
break;
case 792: yy_.yytext = "\uD835\uDF92"; return "A"; 
break;
case 793: yy_.yytext = "\uD835\uDE42"; return "A"; 
break;
case 794: yy_.yytext = "\uD835\uDE5C"; return "A"; 
break;
case 795: yy_.yytext = "\uD835\uDE41"; return "A"; 
break;
case 796: yy_.yytext = "\uD835\uDE5B"; return "A"; 
break;
case 797: yy_.yytext = "\uD835\uDF96"; return "A"; 
break;
case 798: yy_.yytext = "\uD835\uDFB0"; return "A"; 
break;
case 799: yy_.yytext = "\uD835\uDFAE"; return "A"; 
break;
case 800: yy_.yytext = "\uD835\uDF94"; return "A"; 
break;
case 801: yy_.yytext = "\uD835\uDE40"; return "A"; 
break;
case 802: yy_.yytext = "\uD835\uDE5A"; return "A"; 
break;
case 803: yy_.yytext = "\uD835\uDFAD"; return "A"; 
break;
case 804: yy_.yytext = "\uD835\uDF93"; return "A"; 
break;
case 805: yy_.yytext = "\uD835\uDE3F"; return "A"; 
break;
case 806: yy_.yytext = "\uD835\uDE59"; return "A"; 
break;
case 807: yy_.yytext = "\uD835\uDFA6"; return "A"; 
break;
case 808: yy_.yytext = "\uD835\uDFC0"; return "A"; 
break;
case 809: yy_.yytext = "\uD835\uDE3E"; return "A"; 
break;
case 810: yy_.yytext = "\uD835\uDE58"; return "A"; 
break;
case 811: yy_.yytext = "\uD835\uDF91"; return "A"; 
break;
case 812: yy_.yytext = "\uD835\uDFAB"; return "A"; 
break;
case 813: yy_.yytext = "\uD835\uDE3D"; return "A"; 
break;
case 814: yy_.yytext = "\uD835\uDE57"; return "A"; 
break;
case 815: yy_.yytext = "\uD835\uDF90"; return "A"; 
break;
case 816: yy_.yytext = "\uD835\uDFAA"; return "A"; 
break;
case 817: yy_.yytext = "\uD835\uDE3C"; return "A"; 
break;
case 818: yy_.yytext = "\uD835\uDE56"; return "A"; 
break;
case 819: yy_.yytext = "\uD835\uDF68"; return "A"; 
break;
case 820: yy_.yytext = "\uD835\uDF82"; return "A"; 
break;
case 821: yy_.yytext = "\uD835\uDDE6"; return "A"; 
break;
case 822: yy_.yytext = "\uD835\uDE00"; return "A"; 
break;
case 823: yy_.yytext = "\uD835\uDF80"; return "A"; 
break;
case 824: yy_.yytext = "\uD835\uDF66"; return "A"; 
break;
case 825: yy_.yytext = "\uD835\uDDE5"; return "A"; 
break;
case 826: yy_.yytext = "\uD835\uDDFF"; return "A"; 
break;
case 827: yy_.yytext = "\uD835\uDDE4"; return "A"; 
break;
case 828: yy_.yytext = "\uD835\uDDFE"; return "A"; 
break;
case 829: yy_.yytext = "\uD835\uDF87"; return "A"; 
break;
case 830: yy_.yytext = "\uD835\uDF6D"; return "A"; 
break;
case 831: yy_.yytext = "\uD835\uDF7F"; return "A"; 
break;
case 832: yy_.yytext = "\uD835\uDF65"; return "A"; 
break;
case 833: yy_.yytext = "\uD835\uDF6B"; return "A"; 
break;
case 834: yy_.yytext = "\uD835\uDF8D"; return "A"; 
break;
case 835: yy_.yytext = "\uD835\uDF85"; return "A"; 
break;
case 836: yy_.yytext = "\uD835\uDDE3"; return "A"; 
break;
case 837: yy_.yytext = "\uD835\uDDFD"; return "A"; 
break;
case 838: yy_.yytext = "\uD835\uDF88"; return "A"; 
break;
case 839: yy_.yytext = "\uD835\uDF6E"; return "A"; 
break;
case 840: yy_.yytext = "\uD835\uDDE2"; return "A"; 
break;
case 841: yy_.yytext = "\uD835\uDDFC"; return "A"; 
break;
case 842: yy_.yytext = "\uD835\uDF6F"; return "A"; 
break;
case 843: yy_.yytext = "\uD835\uDDE1"; return "A"; 
break;
case 844: yy_.yytext = "\uD835\uDDFB"; return "A"; 
break;
case 845: yy_.yytext = "\uD835\uDDE0"; return "A"; 
break;
case 846: yy_.yytext = "\uD835\uDDFA"; return "A"; 
break;
case 847: yy_.yytext = "\uD835\uDF7A"; return "A"; 
break;
case 848: yy_.yytext = "\uD835\uDF60"; return "A"; 
break;
case 849: yy_.yytext = "\uD835\uDDDF"; return "A"; 
break;
case 850: yy_.yytext = "\uD835\uDDF9"; return "A"; 
break;
case 851: yy_.yytext = "\uD835\uDF79"; return "A"; 
break;
case 852: yy_.yytext = "\uD835\uDF5F"; return "A"; 
break;
case 853: yy_.yytext = "\uD835\uDDDE"; return "A"; 
break;
case 854: yy_.yytext = "\uD835\uDDF8"; return "A"; 
break;
case 855: yy_.yytext = "\uD835\uDDDD"; return "A"; 
break;
case 856: yy_.yytext = "\uD835\uDDF7"; return "A"; 
break;
case 857: yy_.yytext = "\uD835\uDF78"; return "A"; 
break;
case 858: yy_.yytext = "\uD835\uDF5E"; return "A"; 
break;
case 859: yy_.yytext = "\uD835\uDDDC"; return "A"; 
break;
case 860: yy_.yytext = "\uD835\uDDF6"; return "A"; 
break;
case 861: yy_.yytext = "\uD835\uDDDB"; return "A"; 
break;
case 862: yy_.yytext = "\uD835\uDDF5"; return "A"; 
break;
case 863: yy_.yytext = "\uD835\uDF72"; return "A"; 
break;
case 864: yy_.yytext = "\uD835\uDF58"; return "A"; 
break;
case 865: yy_.yytext = "\uD835\uDDDA"; return "A"; 
break;
case 866: yy_.yytext = "\uD835\uDDF4"; return "A"; 
break;
case 867: yy_.yytext = "\uD835\uDDD9"; return "A"; 
break;
case 868: yy_.yytext = "\uD835\uDDF3"; return "A"; 
break;
case 869: yy_.yytext = "\uD835\uDF76"; return "A"; 
break;
case 870: yy_.yytext = "\uD835\uDF5C"; return "A"; 
break;
case 871: yy_.yytext = "\uD835\uDF5A"; return "A"; 
break;
case 872: yy_.yytext = "\uD835\uDF74"; return "A"; 
break;
case 873: yy_.yytext = "\uD835\uDDD8"; return "A"; 
break;
case 874: yy_.yytext = "\uD835\uDDF2"; return "A"; 
break;
case 875: yy_.yytext = "\uD835\uDF73"; return "A"; 
break;
case 876: yy_.yytext = "\uD835\uDF59"; return "A"; 
break;
case 877: yy_.yytext = "\uD835\uDDD7"; return "A"; 
break;
case 878: yy_.yytext = "\uD835\uDDF1"; return "A"; 
break;
case 879: yy_.yytext = "\uD835\uDF86"; return "A"; 
break;
case 880: yy_.yytext = "\uD835\uDF6C"; return "A"; 
break;
case 881: yy_.yytext = "\uD835\uDDD6"; return "A"; 
break;
case 882: yy_.yytext = "\uD835\uDDF0"; return "A"; 
break;
case 883: yy_.yytext = "\uD835\uDF57"; return "A"; 
break;
case 884: yy_.yytext = "\uD835\uDF71"; return "A"; 
break;
case 885: yy_.yytext = "\uD835\uDDD5"; return "A"; 
break;
case 886: yy_.yytext = "\uD835\uDDEF"; return "A"; 
break;
case 887: yy_.yytext = "\uD835\uDF56"; return "A"; 
break;
case 888: yy_.yytext = "\uD835\uDF70"; return "A"; 
break;
case 889: yy_.yytext = "\uD835\uDDD4"; return "A"; 
break;
case 890: yy_.yytext = "\uD835\uDDEE"; return "A"; 
break;
case 891: yy_.yytext = "\uD835\uDDA1"; return "A"; 
break;
case 892: yy_.yytext = "\uD835\uDDBB"; return "A"; 
break;
case 893: yy_.yytext = "\uD835\uDDA0"; return "A"; 
break;
case 894: yy_.yytext = "\uD835\uDDBA"; return "A"; 
break;
case 895:return "MATHSF";
break;
case 896: yy_.yytext = "\uD835\uDCB5"; return "A"; 
break;
case 897: yy_.yytext = "\uD835\uDCCF"; return "A"; 
break;
case 898: yy_.yytext = "\uD835\uDCB4"; return "A"; 
break;
case 899: yy_.yytext = "\uD835\uDCCE"; return "A"; 
break;
case 900: yy_.yytext = "\uD835\uDCB3"; return "A"; 
break;
case 901: yy_.yytext = "\uD835\uDCCD"; return "A"; 
break;
case 902: yy_.yytext = "\uD835\uDCB2"; return "A"; 
break;
case 903: yy_.yytext = "\uD835\uDCCC"; return "A"; 
break;
case 904: yy_.yytext = "\uD835\uDCB1"; return "A"; 
break;
case 905: yy_.yytext = "\uD835\uDCCB"; return "A"; 
break;
case 906: yy_.yytext = "\uD835\uDCB0"; return "A"; 
break;
case 907: yy_.yytext = "\uD835\uDCCA"; return "A"; 
break;
case 908: yy_.yytext = "\uD835\uDCAF"; return "A"; 
break;
case 909: yy_.yytext = "\uD835\uDCC9"; return "A"; 
break;
case 910: yy_.yytext = "\uD835\uDCAE"; return "A"; 
break;
case 911: yy_.yytext = "\uD835\uDCC8"; return "A"; 
break;
case 912: yy_.yytext = "\u211B"; return "A"; 
break;
case 913: yy_.yytext = "\uD835\uDCC7"; return "A"; 
break;
case 914: yy_.yytext = "\uD835\uDCAC"; return "A"; 
break;
case 915: yy_.yytext = "\uD835\uDCC6"; return "A"; 
break;
case 916: yy_.yytext = "\uD835\uDCAB"; return "A"; 
break;
case 917: yy_.yytext = "\uD835\uDCC5"; return "A"; 
break;
case 918: yy_.yytext = "\uD835\uDCAA"; return "A"; 
break;
case 919: yy_.yytext = "\u2134"; return "A"; 
break;
case 920: yy_.yytext = "\uD835\uDCA9"; return "A"; 
break;
case 921: yy_.yytext = "\uD835\uDCC3"; return "A"; 
break;
case 922: yy_.yytext = "\u2133"; return "A"; 
break;
case 923: yy_.yytext = "\uD835\uDCC2"; return "A"; 
break;
case 924: yy_.yytext = "\u2112"; return "A"; 
break;
case 925: yy_.yytext = "\uD835\uDCC1"; return "A"; 
break;
case 926: yy_.yytext = "\uD835\uDCA6"; return "A"; 
break;
case 927: yy_.yytext = "\uD835\uDCC0"; return "A"; 
break;
case 928: yy_.yytext = "\uD835\uDCA5"; return "A"; 
break;
case 929: yy_.yytext = "\uD835\uDCBF"; return "A"; 
break;
case 930: yy_.yytext = "\u2110"; return "A"; 
break;
case 931: yy_.yytext = "\uD835\uDCBE"; return "A"; 
break;
case 932: yy_.yytext = "\u210B"; return "A"; 
break;
case 933: yy_.yytext = "\uD835\uDCBD"; return "A"; 
break;
case 934: yy_.yytext = "\uD835\uDCA2"; return "A"; 
break;
case 935: yy_.yytext = "\u210A"; return "A"; 
break;
case 936: yy_.yytext = "\u2131"; return "A"; 
break;
case 937: yy_.yytext = "\uD835\uDCBB"; return "A"; 
break;
case 938: yy_.yytext = "\u2130"; return "A"; 
break;
case 939: yy_.yytext = "\u212F"; return "A"; 
break;
case 940: yy_.yytext = "\uD835\uDC9F"; return "A"; 
break;
case 941: yy_.yytext = "\uD835\uDCB9"; return "A"; 
break;
case 942: yy_.yytext = "\uD835\uDC9E"; return "A"; 
break;
case 943: yy_.yytext = "\uD835\uDCB8"; return "A"; 
break;
case 944: yy_.yytext = "\u212C"; return "A"; 
break;
case 945: yy_.yytext = "\uD835\uDCB7"; return "A"; 
break;
case 946: yy_.yytext = "\uD835\uDC9C"; return "A"; 
break;
case 947: yy_.yytext = "\uD835\uDCB6"; return "A"; 
break;
case 948:return "MATHSCR";
break;
case 949:return "MATHRM";
break;
case 950:return "MATHRLAP";
break;
case 951: yy_.yytext = "\u02DA"; return "OP"; 
break;
case 952: this.begin("TEXTARG"); return "MATHREL"; 
break;
case 953: this.pushState("TEXTOPTARG"); this.pushState("TRYOPTARG"); this.pushState("TEXTOPTARG"); this.pushState("TRYOPTARG"); this.pushState("TEXTARG"); return "MATHRAISEBOX"; 
break;
case 954: this.begin("TEXTARG"); return "MATHOP"; 
break;
case 955: yy_.yytext = "\uD835\uDEE7"; return "A"; 
break;
case 956: yy_.yytext = "\uD835\uDF01"; return "A"; 
break;
case 957: yy_.yytext = "\uD835\uDC4D"; return "A"; 
break;
case 958: yy_.yytext = "\uD835\uDC67"; return "A"; 
break;
case 959: yy_.yytext = "\uD835\uDC4C"; return "A"; 
break;
case 960: yy_.yytext = "\uD835\uDC66"; return "A"; 
break;
case 961: yy_.yytext = "\uD835\uDEEF"; return "A"; 
break;
case 962: yy_.yytext = "\uD835\uDF09"; return "A"; 
break;
case 963: yy_.yytext = "\uD835\uDC4B"; return "A"; 
break;
case 964: yy_.yytext = "\uD835\uDC65"; return "A"; 
break;
case 965: yy_.yytext = "\uD835\uDC4A"; return "A"; 
break;
case 966: yy_.yytext = "\uD835\uDC64"; return "A"; 
break;
case 967: yy_.yytext = "\uD835\uDF17"; return "A"; 
break;
case 968: yy_.yytext = "\uD835\uDEF3"; return "A"; 
break;
case 969: yy_.yytext = "\uD835\uDF0D"; return "A"; 
break;
case 970: yy_.yytext = "\uD835\uDF1A"; return "A"; 
break;
case 971: yy_.yytext = "\uD835\uDF1B"; return "A"; 
break;
case 972: yy_.yytext = "\uD835\uDF18"; return "A"; 
break;
case 973: yy_.yytext = "\uD835\uDC49"; return "A"; 
break;
case 974: yy_.yytext = "\uD835\uDC63"; return "A"; 
break;
case 975: yy_.yytext = "\uD835\uDEF6"; return "A"; 
break;
case 976: yy_.yytext = "\uD835\uDF10"; return "A"; 
break;
case 977: yy_.yytext = "\uD835\uDC48"; return "A"; 
break;
case 978: yy_.yytext = "\uD835\uDC62"; return "A"; 
break;
case 979: yy_.yytext = "\uD835\uDEE9"; return "A"; 
break;
case 980: yy_.yytext = "\uD835\uDF03"; return "A"; 
break;
case 981: yy_.yytext = "\uD835\uDEF5"; return "A"; 
break;
case 982: yy_.yytext = "\uD835\uDF0F"; return "A"; 
break;
case 983: yy_.yytext = "\uD835\uDC47"; return "A"; 
break;
case 984: yy_.yytext = "\uD835\uDC61"; return "A"; 
break;
case 985: yy_.yytext = "\uD835\uDEF4"; return "A"; 
break;
case 986: yy_.yytext = "\uD835\uDF0E"; return "A"; 
break;
case 987: yy_.yytext = "\uD835\uDC46"; return "A"; 
break;
case 988: yy_.yytext = "\uD835\uDC60"; return "A"; 
break;
case 989: yy_.yytext = "\uD835\uDEF2"; return "A"; 
break;
case 990: yy_.yytext = "\uD835\uDF0C"; return "A"; 
break;
case 991: yy_.yytext = "\uD835\uDC45"; return "A"; 
break;
case 992: yy_.yytext = "\uD835\uDC5F"; return "A"; 
break;
case 993: yy_.yytext = "\uD835\uDC44"; return "A"; 
break;
case 994: yy_.yytext = "\uD835\uDC5E"; return "A"; 
break;
case 995: yy_.yytext = "\uD835\uDF13"; return "A"; 
break;
case 996: yy_.yytext = "\uD835\uDEF9"; return "A"; 
break;
case 997: yy_.yytext = "\uD835\uDF0B"; return "A"; 
break;
case 998: yy_.yytext = "\uD835\uDEF1"; return "A"; 
break;
case 999: yy_.yytext = "\uD835\uDF11"; return "A"; 
break;
case 1000: yy_.yytext = "\uD835\uDEF7"; return "A"; 
break;
case 1001: yy_.yytext = "\uD835\uDF19"; return "A"; 
break;
case 1002: yy_.yytext = "\uD835\uDC43"; return "A"; 
break;
case 1003: yy_.yytext = "\uD835\uDC5D"; return "A"; 
break;
case 1004: yy_.yytext = "\uD835\uDF14"; return "A"; 
break;
case 1005: yy_.yytext = "\uD835\uDEFA"; return "A"; 
break;
case 1006: yy_.yytext = "\uD835\uDC42"; return "A"; 
break;
case 1007: yy_.yytext = "\uD835\uDC5C"; return "A"; 
break;
case 1008: yy_.yytext = "\uD835\uDEFB"; return "A"; 
break;
case 1009: yy_.yytext = "\uD835\uDC41"; return "A"; 
break;
case 1010: yy_.yytext = "\uD835\uDC5B"; return "A"; 
break;
case 1011: yy_.yytext = "\uD835\uDC40"; return "A"; 
break;
case 1012: yy_.yytext = "\uD835\uDC5A"; return "A"; 
break;
case 1013: yy_.yytext = "\uD835\uDEEC"; return "A"; 
break;
case 1014: yy_.yytext = "\uD835\uDF06"; return "A"; 
break;
case 1015: yy_.yytext = "\uD835\uDC3F"; return "A"; 
break;
case 1016: yy_.yytext = "\uD835\uDC59"; return "A"; 
break;
case 1017: yy_.yytext = "\uD835\uDF05"; return "A"; 
break;
case 1018: yy_.yytext = "\uD835\uDEEB"; return "A"; 
break;
case 1019: yy_.yytext = "\uD835\uDC3E"; return "A"; 
break;
case 1020: yy_.yytext = "\uD835\uDC58"; return "A"; 
break;
case 1021: yy_.yytext = "\uD835\uDC3D"; return "A"; 
break;
case 1022: yy_.yytext = "\uD835\uDC57"; return "A"; 
break;
case 1023: yy_.yytext = "\uD835\uDF04"; return "A"; 
break;
case 1024: yy_.yytext = "\uD835\uDEEA"; return "A"; 
break;
case 1025: yy_.yytext = "\uD835\uDC3C"; return "A"; 
break;
case 1026: yy_.yytext = "\uD835\uDC56"; return "A"; 
break;
case 1027: yy_.yytext = "\uD835\uDC3B"; return "A"; 
break;
case 1028: yy_.yytext = "\uD835\uDEFE"; return "A"; 
break;
case 1029: yy_.yytext = "\uD835\uDEE4"; return "A"; 
break;
case 1030: yy_.yytext = "\uD835\uDC3A"; return "A"; 
break;
case 1031: yy_.yytext = "\uD835\uDC54"; return "A"; 
break;
case 1032: yy_.yytext = "\uD835\uDC39"; return "A"; 
break;
case 1033: yy_.yytext = "\uD835\uDC53"; return "A"; 
break;
case 1034: yy_.yytext = "\uD835\uDEE8"; return "A"; 
break;
case 1035: yy_.yytext = "\uD835\uDF02"; return "A"; 
break;
case 1036: yy_.yytext = "\uD835\uDF00"; return "A"; 
break;
case 1037: yy_.yytext = "\uD835\uDEE6"; return "A"; 
break;
case 1038: yy_.yytext = "\uD835\uDC38"; return "A"; 
break;
case 1039: yy_.yytext = "\uD835\uDC52"; return "A"; 
break;
case 1040: yy_.yytext = "\uD835\uDEE5"; return "A"; 
break;
case 1041: yy_.yytext = "\uD835\uDEFF"; return "A"; 
break;
case 1042: yy_.yytext = "\uD835\uDC37"; return "A"; 
break;
case 1043: yy_.yytext = "\uD835\uDC51"; return "A"; 
break;
case 1044: yy_.yytext = "\uD835\uDEF8"; return "A"; 
break;
case 1045: yy_.yytext = "\uD835\uDF12"; return "A"; 
break;
case 1046: yy_.yytext = "\uD835\uDC36"; return "A"; 
break;
case 1047: yy_.yytext = "\uD835\uDC50"; return "A"; 
break;
case 1048: yy_.yytext = "\uD835\uDEE3"; return "A"; 
break;
case 1049: yy_.yytext = "\uD835\uDEFD"; return "A"; 
break;
case 1050: yy_.yytext = "\uD835\uDC35"; return "A"; 
break;
case 1051: yy_.yytext = "\uD835\uDC4F"; return "A"; 
break;
case 1052: yy_.yytext = "\uD835\uDEE2"; return "A"; 
break;
case 1053: yy_.yytext = "\uD835\uDEFC"; return "A"; 
break;
case 1054: yy_.yytext = "\uD835\uDC34"; return "A"; 
break;
case 1055: yy_.yytext = "\uD835\uDC4E"; return "A"; 
break;
case 1056:return "MATHIT";
break;
case 1057:return "MATHLLAP";
break;
case 1058:return "MATHIT";
break;
case 1059: yy_.yytext = "\u2128"; return "A"; 
break;
case 1060: yy_.yytext = "\uD835\uDD37"; return "A"; 
break;
case 1061: yy_.yytext = "\uD835\uDD1C"; return "A"; 
break;
case 1062: yy_.yytext = "\uD835\uDD36"; return "A"; 
break;
case 1063: yy_.yytext = "\uD835\uDD1B"; return "A"; 
break;
case 1064: yy_.yytext = "\uD835\uDD35"; return "A"; 
break;
case 1065: yy_.yytext = "\uD835\uDD1A"; return "A"; 
break;
case 1066: yy_.yytext = "\uD835\uDD34"; return "A"; 
break;
case 1067: yy_.yytext = "\uD835\uDD19"; return "A"; 
break;
case 1068: yy_.yytext = "\uD835\uDD33"; return "A"; 
break;
case 1069: yy_.yytext = "\uD835\uDD18"; return "A"; 
break;
case 1070: yy_.yytext = "\uD835\uDD32"; return "A"; 
break;
case 1071: yy_.yytext = "\uD835\uDD17"; return "A"; 
break;
case 1072: yy_.yytext = "\uD835\uDD31"; return "A"; 
break;
case 1073: yy_.yytext = "\uD835\uDD16"; return "A"; 
break;
case 1074: yy_.yytext = "\uD835\uDD30"; return "A"; 
break;
case 1075: yy_.yytext = "\u211C"; return "A"; 
break;
case 1076: yy_.yytext = "\uD835\uDD2F"; return "A"; 
break;
case 1077: yy_.yytext = "\uD835\uDD14"; return "A"; 
break;
case 1078: yy_.yytext = "\uD835\uDD2E"; return "A"; 
break;
case 1079: yy_.yytext = "\uD835\uDD13"; return "A"; 
break;
case 1080: yy_.yytext = "\uD835\uDD2D"; return "A"; 
break;
case 1081: yy_.yytext = "\uD835\uDD12"; return "A"; 
break;
case 1082: yy_.yytext = "\uD835\uDD2C"; return "A"; 
break;
case 1083: yy_.yytext = "\uD835\uDD11"; return "A"; 
break;
case 1084: yy_.yytext = "\uD835\uDD2B"; return "A"; 
break;
case 1085: yy_.yytext = "\uD835\uDD10"; return "A"; 
break;
case 1086: yy_.yytext = "\uD835\uDD2A"; return "A"; 
break;
case 1087: yy_.yytext = "\uD835\uDD0F"; return "A"; 
break;
case 1088: yy_.yytext = "\uD835\uDD29"; return "A"; 
break;
case 1089: yy_.yytext = "\uD835\uDD0E"; return "A"; 
break;
case 1090: yy_.yytext = "\uD835\uDD28"; return "A"; 
break;
case 1091: yy_.yytext = "\uD835\uDD0D"; return "A"; 
break;
case 1092: yy_.yytext = "\uD835\uDD27"; return "A"; 
break;
case 1093: yy_.yytext = "\u2111"; return "A"; 
break;
case 1094: yy_.yytext = "\uD835\uDD26"; return "A"; 
break;
case 1095: yy_.yytext = "\u210C"; return "A"; 
break;
case 1096: yy_.yytext = "\uD835\uDD25"; return "A"; 
break;
case 1097: yy_.yytext = "\uD835\uDD0A"; return "A"; 
break;
case 1098: yy_.yytext = "\uD835\uDD24"; return "A"; 
break;
case 1099: yy_.yytext = "\uD835\uDD09"; return "A"; 
break;
case 1100: yy_.yytext = "\uD835\uDD23"; return "A"; 
break;
case 1101: yy_.yytext = "\uD835\uDD08"; return "A"; 
break;
case 1102: yy_.yytext = "\uD835\uDD22"; return "A"; 
break;
case 1103: yy_.yytext = "\uD835\uDD07"; return "A"; 
break;
case 1104: yy_.yytext = "\uD835\uDD21"; return "A"; 
break;
case 1105: yy_.yytext = "\u212D"; return "A"; 
break;
case 1106: yy_.yytext = "\uD835\uDD20"; return "A"; 
break;
case 1107: yy_.yytext = "\uD835\uDD05"; return "A"; 
break;
case 1108: yy_.yytext = "\uD835\uDD1F"; return "A"; 
break;
case 1109: yy_.yytext = "\uD835\uDD04"; return "A"; 
break;
case 1110: yy_.yytext = "\uD835\uDD1E"; return "A"; 
break;
case 1111:return "MATHFRAK";
break;
case 1112:return "MATHFRAK";
break;
case 1113:return "MATHCLAP";
break;
case 1114:return "MATHSCR";
break;
case 1115:return "MATHBSCR";
break;
case 1116: yy_.yytext = "\uD835\uDF21"; return "A"; 
break;
case 1117: yy_.yytext = "\uD835\uDF3B"; return "A"; 
break;
case 1118: yy_.yytext = "\uD835\uDC81"; return "A"; 
break;
case 1119: yy_.yytext = "\uD835\uDC9B"; return "A"; 
break;
case 1120: yy_.yytext = "\uD835\uDC80"; return "A"; 
break;
case 1121: yy_.yytext = "\uD835\uDC9A"; return "A"; 
break;
case 1122: yy_.yytext = "\uD835\uDF29"; return "A"; 
break;
case 1123: yy_.yytext = "\uD835\uDF43"; return "A"; 
break;
case 1124: yy_.yytext = "\uD835\uDC7F"; return "A"; 
break;
case 1125: yy_.yytext = "\uD835\uDC99"; return "A"; 
break;
case 1126: yy_.yytext = "\uD835\uDC7E"; return "A"; 
break;
case 1127: yy_.yytext = "\uD835\uDC98"; return "A"; 
break;
case 1128: yy_.yytext = "\uD835\uDF51"; return "A"; 
break;
case 1129: yy_.yytext = "\uD835\uDF47"; return "A"; 
break;
case 1130: yy_.yytext = "\uD835\uDF54"; return "A"; 
break;
case 1131: yy_.yytext = "\uD835\uDF55"; return "A"; 
break;
case 1132: yy_.yytext = "\uD835\uDF52"; return "A"; 
break;
case 1133: yy_.yytext = "\uD835\uDC7D"; return "A"; 
break;
case 1134: yy_.yytext = "\uD835\uDC97"; return "A"; 
break;
case 1135: yy_.yytext = "\uD835\uDF30"; return "A"; 
break;
case 1136: yy_.yytext = "\uD835\uDF4A"; return "A"; 
break;
case 1137: yy_.yytext = "\uD835\uDC7C"; return "A"; 
break;
case 1138: yy_.yytext = "\uD835\uDC96"; return "A"; 
break;
case 1139: yy_.yytext = "\uD835\uDF2D"; return "A"; 
break;
case 1140: yy_.yytext = "\uD835\uDF23"; return "A"; 
break;
case 1141: yy_.yytext = "\uD835\uDF3D"; return "A"; 
break;
case 1142: yy_.yytext = "\uD835\uDF2F"; return "A"; 
break;
case 1143: yy_.yytext = "\uD835\uDF49"; return "A"; 
break;
case 1144: yy_.yytext = "\uD835\uDC7B"; return "A"; 
break;
case 1145: yy_.yytext = "\uD835\uDC95"; return "A"; 
break;
case 1146: yy_.yytext = "\uD835\uDF2E"; return "A"; 
break;
case 1147: yy_.yytext = "\uD835\uDF48"; return "A"; 
break;
case 1148: yy_.yytext = "\uD835\uDC7A"; return "A"; 
break;
case 1149: yy_.yytext = "\uD835\uDC94"; return "A"; 
break;
case 1150: yy_.yytext = "\uD835\uDF46"; return "A"; 
break;
case 1151: yy_.yytext = "\uD835\uDF2C"; return "A"; 
break;
case 1152: yy_.yytext = "\uD835\uDC79"; return "A"; 
break;
case 1153: yy_.yytext = "\uD835\uDC93"; return "A"; 
break;
case 1154: yy_.yytext = "\uD835\uDC78"; return "A"; 
break;
case 1155: yy_.yytext = "\uD835\uDC92"; return "A"; 
break;
case 1156: yy_.yytext = "\uD835\uDF4D"; return "A"; 
break;
case 1157: yy_.yytext = "\uD835\uDF33"; return "A"; 
break;
case 1158: yy_.yytext = "\uD835\uDF45"; return "A"; 
break;
case 1159: yy_.yytext = "\uD835\uDF2B"; return "A"; 
break;
case 1160: yy_.yytext = "\uD835\uDF4B"; return "A"; 
break;
case 1161: yy_.yytext = "\uD835\uDF31"; return "A"; 
break;
case 1162: yy_.yytext = "\uD835\uDF53"; return "A"; 
break;
case 1163: yy_.yytext = "\uD835\uDC77"; return "A"; 
break;
case 1164: yy_.yytext = "\uD835\uDC91"; return "A"; 
break;
case 1165: yy_.yytext = "\uD835\uDF34"; return "A"; 
break;
case 1166: yy_.yytext = "\uD835\uDF4E"; return "A"; 
break;
case 1167: yy_.yytext = "\uD835\uDC76"; return "A"; 
break;
case 1168: yy_.yytext = "\uD835\uDC90"; return "A"; 
break;
case 1169: yy_.yytext = "\uD835\uDF35"; return "A"; 
break;
case 1170: yy_.yytext = "\uD835\uDC75"; return "A"; 
break;
case 1171: yy_.yytext = "\uD835\uDC8F"; return "A"; 
break;
case 1172: yy_.yytext = "\uD835\uDC74"; return "A"; 
break;
case 1173: yy_.yytext = "\uD835\uDC8E"; return "A"; 
break;
case 1174: yy_.yytext = "\uD835\uDF40"; return "A"; 
break;
case 1175: yy_.yytext = "\uD835\uDF26"; return "A"; 
break;
case 1176: yy_.yytext = "\uD835\uDC73"; return "A"; 
break;
case 1177: yy_.yytext = "\uD835\uDC8D"; return "A"; 
break;
case 1178: yy_.yytext = "\uD835\uDF25"; return "A"; 
break;
case 1179: yy_.yytext = "\uD835\uDF3F"; return "A"; 
break;
case 1180: yy_.yytext = "\uD835\uDC72"; return "A"; 
break;
case 1181: yy_.yytext = "\uD835\uDC8C"; return "A"; 
break;
case 1182: yy_.yytext = "\uD835\uDC71"; return "A"; 
break;
case 1183: yy_.yytext = "\uD835\uDC8B"; return "A"; 
break;
case 1184: yy_.yytext = "\uD835\uDF24"; return "A"; 
break;
case 1185: yy_.yytext = "\uD835\uDF3E"; return "A"; 
break;
case 1186: yy_.yytext = "\uD835\uDC70"; return "A"; 
break;
case 1187: yy_.yytext = "\uD835\uDC8A"; return "A"; 
break;
case 1188: yy_.yytext = "\uD835\uDC6F"; return "A"; 
break;
case 1189: yy_.yytext = "\uD835\uDC89"; return "A"; 
break;
case 1190: yy_.yytext = "\uD835\uDF1E"; return "A"; 
break;
case 1191: yy_.yytext = "\uD835\uDF38"; return "A"; 
break;
case 1192: yy_.yytext = "\uD835\uDC6E"; return "A"; 
break;
case 1193: yy_.yytext = "\uD835\uDC88"; return "A"; 
break;
case 1194: yy_.yytext = "\uD835\uDC6D"; return "A"; 
break;
case 1195: yy_.yytext = "\uD835\uDC87"; return "A"; 
break;
case 1196: yy_.yytext = "\uD835\uDF3C"; return "A"; 
break;
case 1197: yy_.yytext = "\uD835\uDF22"; return "A"; 
break;
case 1198: yy_.yytext = "\uD835\uDF20"; return "A"; 
break;
case 1199: yy_.yytext = "\uD835\uDF3A"; return "A"; 
break;
case 1200: yy_.yytext = "\uD835\uDC6C"; return "A"; 
break;
case 1201: yy_.yytext = "\uD835\uDC86"; return "A"; 
break;
case 1202: yy_.yytext = "\uD835\uDF1F"; return "A"; 
break;
case 1203: yy_.yytext = "\uD835\uDF39"; return "A"; 
break;
case 1204: yy_.yytext = "\uD835\uDC6B"; return "A"; 
break;
case 1205: yy_.yytext = "\uD835\uDC85"; return "A"; 
break;
case 1206: yy_.yytext = "\uD835\uDF4C"; return "A"; 
break;
case 1207: yy_.yytext = "\uD835\uDF32"; return "A"; 
break;
case 1208: yy_.yytext = "\uD835\uDC6A"; return "A"; 
break;
case 1209: yy_.yytext = "\uD835\uDC84"; return "A"; 
break;
case 1210: yy_.yytext = "\uD835\uDF1D"; return "A"; 
break;
case 1211: yy_.yytext = "\uD835\uDF37"; return "A"; 
break;
case 1212: yy_.yytext = "\uD835\uDC69"; return "A"; 
break;
case 1213: yy_.yytext = "\uD835\uDC83"; return "A"; 
break;
case 1214: yy_.yytext = "\uD835\uDF1C"; return "A"; 
break;
case 1215: yy_.yytext = "\uD835\uDF36"; return "A"; 
break;
case 1216: yy_.yytext = "\uD835\uDC68"; return "A"; 
break;
case 1217: yy_.yytext = "\uD835\uDC82"; return "A"; 
break;
case 1218:return "MATHBIT";
break;
case 1219: yy_.yytext = "\u223A"; return "OP"; 
break;
case 1220: this.begin("TEXTARG"); return "MATHBIN"; 
break;
case 1221: yy_.yytext = "\uD835\uDEAD"; return "A"; 
break;
case 1222: yy_.yytext = "\uD835\uDEC7"; return "A"; 
break;
case 1223: yy_.yytext = "\uD835\uDC19"; return "A"; 
break;
case 1224: yy_.yytext = "\uD835\uDC33"; return "A"; 
break;
case 1225: yy_.yytext = "\uD835\uDC18"; return "A"; 
break;
case 1226: yy_.yytext = "\uD835\uDC32"; return "A"; 
break;
case 1227: yy_.yytext = "\uD835\uDEB5"; return "A"; 
break;
case 1228: yy_.yytext = "\uD835\uDECF"; return "A"; 
break;
case 1229: yy_.yytext = "\uD835\uDC17"; return "A"; 
break;
case 1230: yy_.yytext = "\uD835\uDC31"; return "A"; 
break;
case 1231: yy_.yytext = "\uD835\uDC16"; return "A"; 
break;
case 1232: yy_.yytext = "\uD835\uDC30"; return "A"; 
break;
case 1233: yy_.yytext = "\uD835\uDEB9"; return "A"; 
break;
case 1234: yy_.yytext = "\uD835\uDEDD"; return "A"; 
break;
case 1235: yy_.yytext = "\uD835\uDED3"; return "A"; 
break;
case 1236: yy_.yytext = "\uD835\uDEE0"; return "A"; 
break;
case 1237: yy_.yytext = "\uD835\uDEE1"; return "A"; 
break;
case 1238: yy_.yytext = "\uD835\uDEDE"; return "A"; 
break;
case 1239: yy_.yytext = "\uD835\uDC15"; return "A"; 
break;
case 1240: yy_.yytext = "\uD835\uDC2F"; return "A"; 
break;
case 1241: yy_.yytext = "\uD835\uDEBC"; return "A"; 
break;
case 1242: yy_.yytext = "\uD835\uDED6"; return "A"; 
break;
case 1243: yy_.yytext = "\uD835\uDC14"; return "A"; 
break;
case 1244: yy_.yytext = "\uD835\uDC2E"; return "A"; 
break;
case 1245: yy_.yytext = "\uD835\uDEAF"; return "A"; 
break;
case 1246: yy_.yytext = "\uD835\uDEC9"; return "A"; 
break;
case 1247: yy_.yytext = "\uD835\uDEBB"; return "A"; 
break;
case 1248: yy_.yytext = "\uD835\uDED5"; return "A"; 
break;
case 1249: yy_.yytext = "\uD835\uDC13"; return "A"; 
break;
case 1250: yy_.yytext = "\uD835\uDC2D"; return "A"; 
break;
case 1251: yy_.yytext = "\uD835\uDEBA"; return "A"; 
break;
case 1252: yy_.yytext = "\uD835\uDED4"; return "A"; 
break;
case 1253: yy_.yytext = "\uD835\uDC12"; return "A"; 
break;
case 1254: yy_.yytext = "\uD835\uDC2C"; return "A"; 
break;
case 1255: yy_.yytext = "\uD835\uDEB8"; return "A"; 
break;
case 1256: yy_.yytext = "\uD835\uDED2"; return "A"; 
break;
case 1257: yy_.yytext = "\uD835\uDD85"; return "A"; 
break;
case 1258: yy_.yytext = "\uD835\uDD9F"; return "A"; 
break;
case 1259: yy_.yytext = "\uD835\uDD84"; return "A"; 
break;
case 1260: yy_.yytext = "\uD835\uDD9E"; return "A"; 
break;
case 1261: yy_.yytext = "\uD835\uDD83"; return "A"; 
break;
case 1262: yy_.yytext = "\uD835\uDD9D"; return "A"; 
break;
case 1263: yy_.yytext = "\uD835\uDD82"; return "A"; 
break;
case 1264: yy_.yytext = "\uD835\uDD9C"; return "A"; 
break;
case 1265: yy_.yytext = "\uD835\uDD81"; return "A"; 
break;
case 1266: yy_.yytext = "\uD835\uDD9B"; return "A"; 
break;
case 1267: yy_.yytext = "\uD835\uDD80"; return "A"; 
break;
case 1268: yy_.yytext = "\uD835\uDD9A"; return "A"; 
break;
case 1269: yy_.yytext = "\uD835\uDD7F"; return "A"; 
break;
case 1270: yy_.yytext = "\uD835\uDD99"; return "A"; 
break;
case 1271: yy_.yytext = "\uD835\uDD7E"; return "A"; 
break;
case 1272: yy_.yytext = "\uD835\uDD98"; return "A"; 
break;
case 1273: yy_.yytext = "\uD835\uDD7D"; return "A"; 
break;
case 1274: yy_.yytext = "\uD835\uDD97"; return "A"; 
break;
case 1275: yy_.yytext = "\uD835\uDD7C"; return "A"; 
break;
case 1276: yy_.yytext = "\uD835\uDD96"; return "A"; 
break;
case 1277: yy_.yytext = "\uD835\uDD7B"; return "A"; 
break;
case 1278: yy_.yytext = "\uD835\uDD95"; return "A"; 
break;
case 1279: yy_.yytext = "\uD835\uDD7A"; return "A"; 
break;
case 1280: yy_.yytext = "\uD835\uDD94"; return "A"; 
break;
case 1281: yy_.yytext = "\uD835\uDD79"; return "A"; 
break;
case 1282: yy_.yytext = "\uD835\uDD93"; return "A"; 
break;
case 1283: yy_.yytext = "\uD835\uDD78"; return "A"; 
break;
case 1284: yy_.yytext = "\uD835\uDD92"; return "A"; 
break;
case 1285: yy_.yytext = "\uD835\uDD77"; return "A"; 
break;
case 1286: yy_.yytext = "\uD835\uDD91"; return "A"; 
break;
case 1287: yy_.yytext = "\uD835\uDD76"; return "A"; 
break;
case 1288: yy_.yytext = "\uD835\uDD90"; return "A"; 
break;
case 1289: yy_.yytext = "\uD835\uDD75"; return "A"; 
break;
case 1290: yy_.yytext = "\uD835\uDD8F"; return "A"; 
break;
case 1291: yy_.yytext = "\uD835\uDD74"; return "A"; 
break;
case 1292: yy_.yytext = "\uD835\uDD8E"; return "A"; 
break;
case 1293: yy_.yytext = "\uD835\uDD73"; return "A"; 
break;
case 1294: yy_.yytext = "\uD835\uDD8D"; return "A"; 
break;
case 1295: yy_.yytext = "\uD835\uDD72"; return "A"; 
break;
case 1296: yy_.yytext = "\uD835\uDD8C"; return "A"; 
break;
case 1297: yy_.yytext = "\uD835\uDD71"; return "A"; 
break;
case 1298: yy_.yytext = "\uD835\uDD8B"; return "A"; 
break;
case 1299: yy_.yytext = "\uD835\uDD70"; return "A"; 
break;
case 1300: yy_.yytext = "\uD835\uDD8A"; return "A"; 
break;
case 1301: yy_.yytext = "\uD835\uDD6F"; return "A"; 
break;
case 1302: yy_.yytext = "\uD835\uDD89"; return "A"; 
break;
case 1303: yy_.yytext = "\uD835\uDD6E"; return "A"; 
break;
case 1304: yy_.yytext = "\uD835\uDD88"; return "A"; 
break;
case 1305: yy_.yytext = "\uD835\uDD6D"; return "A"; 
break;
case 1306: yy_.yytext = "\uD835\uDD87"; return "A"; 
break;
case 1307: yy_.yytext = "\uD835\uDD6C"; return "A"; 
break;
case 1308: yy_.yytext = "\uD835\uDD86"; return "A"; 
break;
case 1309: yy_.yytext = "\uD835\uDC11"; return "A"; 
break;
case 1310: yy_.yytext = "\uD835\uDC2B"; return "A"; 
break;
case 1311: yy_.yytext = "\uD835\uDC10"; return "A"; 
break;
case 1312: yy_.yytext = "\uD835\uDC2A"; return "A"; 
break;
case 1313: yy_.yytext = "\uD835\uDEBF"; return "A"; 
break;
case 1314: yy_.yytext = "\uD835\uDED9"; return "A"; 
break;
case 1315: yy_.yytext = "\uD835\uDEB7"; return "A"; 
break;
case 1316: yy_.yytext = "\uD835\uDED1"; return "A"; 
break;
case 1317: yy_.yytext = "\uD835\uDEBD"; return "A"; 
break;
case 1318: yy_.yytext = "\uD835\uDEDF"; return "A"; 
break;
case 1319: yy_.yytext = "\uD835\uDED7"; return "A"; 
break;
case 1320: yy_.yytext = "\uD835\uDC0F"; return "A"; 
break;
case 1321: yy_.yytext = "\uD835\uDC29"; return "A"; 
break;
case 1322: yy_.yytext = "\uD835\uDEC0"; return "A"; 
break;
case 1323: yy_.yytext = "\uD835\uDEDA"; return "A"; 
break;
case 1324: yy_.yytext = "\uD835\uDC0E"; return "A"; 
break;
case 1325: yy_.yytext = "\uD835\uDC28"; return "A"; 
break;
case 1326: yy_.yytext = "\uD835\uDEC1"; return "A"; 
break;
case 1327: yy_.yytext = "\uD835\uDC0D"; return "A"; 
break;
case 1328: yy_.yytext = "\uD835\uDC27"; return "A"; 
break;
case 1329: yy_.yytext = "\uD835\uDC0C"; return "A"; 
break;
case 1330: yy_.yytext = "\uD835\uDC26"; return "A"; 
break;
case 1331: yy_.yytext = "\uD835\uDEB2"; return "A"; 
break;
case 1332: yy_.yytext = "\uD835\uDECC"; return "A"; 
break;
case 1333: yy_.yytext = "\uD835\uDC0B"; return "A"; 
break;
case 1334: yy_.yytext = "\uD835\uDC25"; return "A"; 
break;
case 1335: yy_.yytext = "\uD835\uDEB1"; return "A"; 
break;
case 1336: yy_.yytext = "\uD835\uDECB"; return "A"; 
break;
case 1337: yy_.yytext = "\uD835\uDC0A"; return "A"; 
break;
case 1338: yy_.yytext = "\uD835\uDC24"; return "A"; 
break;
case 1339: yy_.yytext = "\uD835\uDC09"; return "A"; 
break;
case 1340: yy_.yytext = "\uD835\uDC23"; return "A"; 
break;
case 1341: yy_.yytext = "\uD835\uDEB0"; return "A"; 
break;
case 1342: yy_.yytext = "\uD835\uDECA"; return "A"; 
break;
case 1343: yy_.yytext = "\uD835\uDC08"; return "A"; 
break;
case 1344: yy_.yytext = "\uD835\uDC22"; return "A"; 
break;
case 1345: yy_.yytext = "\uD835\uDC07"; return "A"; 
break;
case 1346: yy_.yytext = "\uD835\uDC21"; return "A"; 
break;
case 1347: yy_.yytext = "\uD835\uDEAA"; return "A"; 
break;
case 1348: yy_.yytext = "\uD835\uDEC4"; return "A"; 
break;
case 1349: yy_.yytext = "\uD835\uDC06"; return "A"; 
break;
case 1350: yy_.yytext = "\uD835\uDC20"; return "A"; 
break;
case 1351: yy_.yytext = "\uD835\uDC05"; return "A"; 
break;
case 1352: yy_.yytext = "\uD835\uDC1F"; return "A"; 
break;
case 1353: yy_.yytext = "\uD835\uDEC8"; return "A"; 
break;
case 1354: yy_.yytext = "\uD835\uDEAE"; return "A"; 
break;
case 1355: yy_.yytext = "\uD835\uDEC6"; return "A"; 
break;
case 1356: yy_.yytext = "\uD835\uDEAC"; return "A"; 
break;
case 1357: yy_.yytext = "\uD835\uDC04"; return "A"; 
break;
case 1358: yy_.yytext = "\uD835\uDC1E"; return "A"; 
break;
case 1359: yy_.yytext = "\uD835\uDEC5"; return "A"; 
break;
case 1360: yy_.yytext = "\uD835\uDEAB"; return "A"; 
break;
case 1361: yy_.yytext = "\uD835\uDC03"; return "A"; 
break;
case 1362: yy_.yytext = "\uD835\uDC1D"; return "A"; 
break;
case 1363: yy_.yytext = "\uD835\uDEBE"; return "A"; 
break;
case 1364: yy_.yytext = "\uD835\uDED8"; return "A"; 
break;
case 1365: yy_.yytext = "\uD835\uDC02"; return "A"; 
break;
case 1366: yy_.yytext = "\uD835\uDC1C"; return "A"; 
break;
case 1367: yy_.yytext = "\uD835\uDEA9"; return "A"; 
break;
case 1368: yy_.yytext = "\uD835\uDEC3"; return "A"; 
break;
case 1369: yy_.yytext = "\uD835\uDC01"; return "A"; 
break;
case 1370: yy_.yytext = "\uD835\uDC1B"; return "A"; 
break;
case 1371: yy_.yytext = "\uD835\uDEA8"; return "A"; 
break;
case 1372: yy_.yytext = "\uD835\uDEC2"; return "A"; 
break;
case 1373: yy_.yytext = "\uD835\uDC00"; return "A"; 
break;
case 1374: yy_.yytext = "\uD835\uDC1A"; return "A"; 
break;
case 1375:return "MATHBF";
break;
case 1376: yy_.yytext = "\uD835\uDCE9"; return "A"; 
break;
case 1377: yy_.yytext = "\uD835\uDD03"; return "A"; 
break;
case 1378: yy_.yytext = "\uD835\uDCE8"; return "A"; 
break;
case 1379: yy_.yytext = "\uD835\uDD02"; return "A"; 
break;
case 1380: yy_.yytext = "\uD835\uDCE7"; return "A"; 
break;
case 1381: yy_.yytext = "\uD835\uDD01"; return "A"; 
break;
case 1382: yy_.yytext = "\uD835\uDCE6"; return "A"; 
break;
case 1383: yy_.yytext = "\uD835\uDD00"; return "A"; 
break;
case 1384: yy_.yytext = "\uD835\uDCE5"; return "A"; 
break;
case 1385: yy_.yytext = "\uD835\uDCFF"; return "A"; 
break;
case 1386: yy_.yytext = "\uD835\uDCE4"; return "A"; 
break;
case 1387: yy_.yytext = "\uD835\uDCFE"; return "A"; 
break;
case 1388: yy_.yytext = "\uD835\uDCE3"; return "A"; 
break;
case 1389: yy_.yytext = "\uD835\uDCFD"; return "A"; 
break;
case 1390: yy_.yytext = "\uD835\uDCE2"; return "A"; 
break;
case 1391: yy_.yytext = "\uD835\uDCFC"; return "A"; 
break;
case 1392: yy_.yytext = "\uD835\uDCE1"; return "A"; 
break;
case 1393: yy_.yytext = "\uD835\uDCFB"; return "A"; 
break;
case 1394: yy_.yytext = "\uD835\uDCE0"; return "A"; 
break;
case 1395: yy_.yytext = "\uD835\uDCFA"; return "A"; 
break;
case 1396: yy_.yytext = "\uD835\uDCDF"; return "A"; 
break;
case 1397: yy_.yytext = "\uD835\uDCF9"; return "A"; 
break;
case 1398: yy_.yytext = "\uD835\uDCDE"; return "A"; 
break;
case 1399: yy_.yytext = "\uD835\uDCF8"; return "A"; 
break;
case 1400: yy_.yytext = "\uD835\uDCDD"; return "A"; 
break;
case 1401: yy_.yytext = "\uD835\uDCF7"; return "A"; 
break;
case 1402: yy_.yytext = "\uD835\uDCDC"; return "A"; 
break;
case 1403: yy_.yytext = "\uD835\uDCF6"; return "A"; 
break;
case 1404: yy_.yytext = "\uD835\uDCDB"; return "A"; 
break;
case 1405: yy_.yytext = "\uD835\uDCF5"; return "A"; 
break;
case 1406: yy_.yytext = "\uD835\uDCDA"; return "A"; 
break;
case 1407: yy_.yytext = "\uD835\uDCF4"; return "A"; 
break;
case 1408: yy_.yytext = "\uD835\uDCD9"; return "A"; 
break;
case 1409: yy_.yytext = "\uD835\uDCF3"; return "A"; 
break;
case 1410: yy_.yytext = "\uD835\uDCD8"; return "A"; 
break;
case 1411: yy_.yytext = "\uD835\uDCF2"; return "A"; 
break;
case 1412: yy_.yytext = "\uD835\uDCD7"; return "A"; 
break;
case 1413: yy_.yytext = "\uD835\uDCF1"; return "A"; 
break;
case 1414: yy_.yytext = "\uD835\uDCD6"; return "A"; 
break;
case 1415: yy_.yytext = "\uD835\uDCF0"; return "A"; 
break;
case 1416: yy_.yytext = "\uD835\uDCD5"; return "A"; 
break;
case 1417: yy_.yytext = "\uD835\uDCEF"; return "A"; 
break;
case 1418: yy_.yytext = "\uD835\uDCD4"; return "A"; 
break;
case 1419: yy_.yytext = "\uD835\uDCEE"; return "A"; 
break;
case 1420: yy_.yytext = "\uD835\uDCD3"; return "A"; 
break;
case 1421: yy_.yytext = "\uD835\uDCED"; return "A"; 
break;
case 1422: yy_.yytext = "\uD835\uDCD2"; return "A"; 
break;
case 1423: yy_.yytext = "\uD835\uDCEC"; return "A"; 
break;
case 1424: yy_.yytext = "\uD835\uDCD1"; return "A"; 
break;
case 1425: yy_.yytext = "\uD835\uDCEB"; return "A"; 
break;
case 1426: yy_.yytext = "\uD835\uDCD0"; return "A"; 
break;
case 1427: yy_.yytext = "\uD835\uDCEA"; return "A"; 
break;
case 1428:return "MATHBSCR";
break;
case 1429: yy_.yytext = "\u2124"; return "A"; 
break;
case 1430: yy_.yytext = "\uD835\uDD6B"; return "A"; 
break;
case 1431: yy_.yytext = "\uD835\uDD50"; return "A"; 
break;
case 1432: yy_.yytext = "\uD835\uDD6A"; return "A"; 
break;
case 1433: yy_.yytext = "\uD835\uDD4F"; return "A"; 
break;
case 1434: yy_.yytext = "\uD835\uDD69"; return "A"; 
break;
case 1435: yy_.yytext = "\uD835\uDD4E"; return "A"; 
break;
case 1436: yy_.yytext = "\uD835\uDD68"; return "A"; 
break;
case 1437: yy_.yytext = "\uD835\uDD4D"; return "A"; 
break;
case 1438: yy_.yytext = "\uD835\uDD67"; return "A"; 
break;
case 1439: yy_.yytext = "\uD835\uDD4C"; return "A"; 
break;
case 1440: yy_.yytext = "\uD835\uDD66"; return "A"; 
break;
case 1441: yy_.yytext = "\uD835\uDD4B"; return "A"; 
break;
case 1442: yy_.yytext = "\uD835\uDD65"; return "A"; 
break;
case 1443: yy_.yytext = "\uD835\uDD4A"; return "A"; 
break;
case 1444: yy_.yytext = "\uD835\uDD64"; return "A"; 
break;
case 1445: yy_.yytext = "\u211D"; return "A"; 
break;
case 1446: yy_.yytext = "\uD835\uDD63"; return "A"; 
break;
case 1447: yy_.yytext = "\u211A"; return "A"; 
break;
case 1448: yy_.yytext = "\uD835\uDD62"; return "A"; 
break;
case 1449: yy_.yytext = "\u2119"; return "A"; 
break;
case 1450: yy_.yytext = "\uD835\uDD61"; return "A"; 
break;
case 1451: yy_.yytext = "\uD835\uDD46"; return "A"; 
break;
case 1452: yy_.yytext = "\uD835\uDD60"; return "A"; 
break;
case 1453: yy_.yytext = "\u2115"; return "A"; 
break;
case 1454: yy_.yytext = "\uD835\uDD5F"; return "A"; 
break;
case 1455: yy_.yytext = "\uD835\uDD44"; return "A"; 
break;
case 1456: yy_.yytext = "\uD835\uDD5E"; return "A"; 
break;
case 1457: yy_.yytext = "\uD835\uDD43"; return "A"; 
break;
case 1458: yy_.yytext = "\uD835\uDD5D"; return "A"; 
break;
case 1459: yy_.yytext = "\uD835\uDD42"; return "A"; 
break;
case 1460: yy_.yytext = "\uD835\uDD5C"; return "A"; 
break;
case 1461: yy_.yytext = "\uD835\uDD41"; return "A"; 
break;
case 1462: yy_.yytext = "\uD835\uDD5B"; return "A"; 
break;
case 1463: yy_.yytext = "\uD835\uDD40"; return "A"; 
break;
case 1464: yy_.yytext = "\uD835\uDD5A"; return "A"; 
break;
case 1465: yy_.yytext = "\u210D"; return "A"; 
break;
case 1466: yy_.yytext = "\uD835\uDD59"; return "A"; 
break;
case 1467: yy_.yytext = "\uD835\uDD3E"; return "A"; 
break;
case 1468: yy_.yytext = "\uD835\uDD58"; return "A"; 
break;
case 1469: yy_.yytext = "\uD835\uDD3D"; return "A"; 
break;
case 1470: yy_.yytext = "\uD835\uDD57"; return "A"; 
break;
case 1471: yy_.yytext = "\uD835\uDD3C"; return "A"; 
break;
case 1472: yy_.yytext = "\uD835\uDD56"; return "A"; 
break;
case 1473: yy_.yytext = "\uD835\uDD3B"; return "A"; 
break;
case 1474: yy_.yytext = "\uD835\uDD55"; return "A"; 
break;
case 1475: yy_.yytext = "\u2102"; return "A"; 
break;
case 1476: yy_.yytext = "\uD835\uDD54"; return "A"; 
break;
case 1477: yy_.yytext = "\uD835\uDD39"; return "A"; 
break;
case 1478: yy_.yytext = "\uD835\uDD53"; return "A"; 
break;
case 1479: yy_.yytext = "\uD835\uDD38"; return "A"; 
break;
case 1480: yy_.yytext = "\uD835\uDD52"; return "A"; 
break;
case 1481:return "MATHBB";
break;
case 1482: yy_.yytext = "\u2907"; return "OP"; 
break;
case 1483: yy_.yytext = "\u21A6"; return "OPS"; 
break;
case 1484: yy_.yytext = "\u2906"; return "OP"; 
break;
case 1485: yy_.yytext = "\u21A6"; return "OPS"; 
break;
case 1486: yy_.yytext = "\u2268\uFE00"; return "OP"; 
break;
case 1487: yy_.yytext = "\u2268\uFE00"; return "OP"; 
break;
case 1488: yy_.yytext = "\u22C9"; return "OP"; 
break;
case 1489: yy_.yytext = "\u003C"; return "OP"; 
break;
case 1490: yy_.yytext = "\u21B0"; return "OPS"; 
break;
case 1491: yy_.yytext = "\u2018"; return "OPF"; 
break;
case 1492: yy_.yytext = "\u25CA"; return "OP"; 
break;
case 1493: yy_.yytext = "\u2A1C"; return "OP"; 
break;
case 1494: yy_.yytext = "\u21AC"; return "OPS"; 
break;
case 1495: yy_.yytext = "\u21AB"; return "OPS"; 
break;
case 1496: yy_.yytext = "\u27F9"; return "OPS"; 
break;
case 1497: yy_.yytext = "\u27F6"; return "OPS"; 
break;
case 1498: yy_.yytext = "\u27FC"; return "OPS"; 
break;
case 1499: yy_.yytext = "\u27FA"; return "OPS"; 
break;
case 1500: yy_.yytext = "\u27F7"; return "OPS"; 
break;
case 1501: yy_.yytext = "\u27F8"; return "OPS"; 
break;
case 1502: yy_.yytext = "\u27F5"; return "OPS"; 
break;
case 1503: yy_.yytext = "\u22E6"; return "OP"; 
break;
case 1504: yy_.yytext = "\u00AC"; return "OP"; 
break;
case 1505: yy_.yytext = "\u2268"; return "OP"; 
break;
case 1506: yy_.yytext = "\u2A87"; return "OP"; 
break;
case 1507: yy_.yytext = "\u2268"; return "OP"; 
break;
case 1508: yy_.yytext = "\u2A89"; return "OP"; 
break;
case 1509: yy_.yytext = "\u23B0"; return "OP"; 
break;
case 1510: yy_.yytext = "\u22D8"; return "OP"; 
break;
case 1511: yy_.yytext = "\u21DA"; return "OPS"; 
break;
case 1512: yy_.yytext = "\u27EA"; return "OPFS"; 
break;
case 1513: yy_.yytext = "\u226A"; return "OP"; 
break;
case 1514: yy_.yytext = "\u22B2"; return "OP"; 
break;
case 1515: yy_.yytext = "\u230A"; return "OPFS"; 
break;
case 1516: yy_.yytext = "\u2272"; return "OP"; 
break;
case 1517: yy_.yytext = "\u2276"; return "OP"; 
break;
case 1518: yy_.yytext = "\u2272"; return "OP"; 
break;
case 1519: yy_.yytext = "\u2A8B"; return "OP"; 
break;
case 1520: yy_.yytext = "\u22DA"; return "OP"; 
break;
case 1521: yy_.yytext = "\u22DA"; return "OP"; 
break;
case 1522: yy_.yytext = "\u22D6"; return "OP"; 
break;
case 1523: yy_.yytext = "\u2A85"; return "OP"; 
break;
case 1524: yy_.yytext = "\u003C"; return "OP"; 
break;
case 1525: yy_.yytext = "\u2A7D"; return "OP"; 
break;
case 1526: yy_.yytext = "\u2266"; return "OP"; 
break;
case 1527: yy_.yytext = "\u2264"; return "OP"; 
break;
case 1528: yy_.yytext = "\u2952"; return "OPS"; 
break;
case 1529: yy_.yytext = "\u2958"; return "OPS"; 
break;
case 1530: yy_.yytext = "\u2960"; return "OPS"; 
break;
case 1531: yy_.yytext = "\u2951"; return "OPS"; 
break;
case 1532: yy_.yytext = "\u29CF"; return "OP"; 
break;
case 1533: yy_.yytext = "\u22CB"; return "OP"; 
break;
case 1534: yy_.yytext = "\u295A"; return "OPS"; 
break;
case 1535: yy_.yytext = "\u219C"; return "OPS"; 
break;
case 1536: yy_.yytext = "\u294E"; return "OPS"; 
break;
case 1537: yy_.yytext = "\u21AD"; return "OPS"; 
break;
case 1538: yy_.yytext = "\u21CB"; return "OPS"; 
break;
case 1539: yy_.yytext = "\u21FF"; return "OPS"; 
break;
case 1540: yy_.yytext = "\u21C6"; return "OPS"; 
break;
case 1541: yy_.yytext = "\u21D4"; return "OPS"; 
break;
case 1542: yy_.yytext = "\u2194"; return "OPS"; 
break;
case 1543: yy_.yytext = "\u21C7"; return "OPS"; 
break;
case 1544: yy_.yytext = "\u21BC"; return "OPS"; 
break;
case 1545: yy_.yytext = "\u21BD"; return "OPS"; 
break;
case 1546: yy_.yytext = "\u2959"; return "OPS"; 
break;
case 1547: yy_.yytext = "\u2961"; return "OPS"; 
break;
case 1548: yy_.yytext = "\u21FD"; return "OPS"; 
break;
case 1549: yy_.yytext = "\u21A2"; return "OPS"; 
break;
case 1550: yy_.yytext = "\u21D0"; return "OPS"; 
break;
case 1551: yy_.yytext = "\u2190"; return "OPS"; 
break;
case 1552:return "LEFT";
break;
case 1553: yy_.yytext = "\u2264"; return "OP"; 
break;
case 1554: yy_.yytext = "\u2026"; return "OP"; 
break;
case 1555: yy_.yytext = "\u002E"; return "OP"; 
break;
case 1556: yy_.yytext = "\u2308"; return "OPFS"; 
break;
case 1557: yy_.yytext = "\u005B"; return "OPFS"; 
break;
case 1558: yy_.yytext = "\u007B"; return "OPFS"; 
break;
case 1559: yy_.yytext = "\u223E"; return "OP"; 
break;
case 1560: yy_.yytext = "\u27E8"; return "OPFS"; 
break;
case 1561: yy_.yytext = "\u27E8"; return "OPFS"; 
break;
case 1562: yy_.yytext = "\u039B"; return "A"; 
break;
case 1563: yy_.yytext = "\u03BB"; return "A"; 
break;
case 1564: yy_.yytext = "\u223B"; return "OP"; 
break;
case 1565: yy_.yytext = "\u2993"; return "OPFS"; 
break;
case 1566: yy_.yytext = "\u039A"; return "A"; 
break;
case 1567: yy_.yytext = "\u03BA"; return "A"; 
break;
case 1568: yy_.yytext = "\u0237"; return "A"; 
break;
case 1569: this.pushState("TEXTARG"); return "MN"; 
break;
case 1570: yy_.yytext = "\u0399"; return "A"; 
break;
case 1571: yy_.yytext = "\u03B9"; return "A"; 
break;
case 1572: yy_.yytext = "\u214B"; return "OP"; 
break;
case 1573: yy_.yytext = "\u2A18"; return "OP"; 
break;
case 1574: yy_.yytext = "\u2A3D"; return "OP"; 
break;
case 1575: yy_.yytext = "\u2A3C"; return "OP"; 
break;
case 1576: yy_.yytext = "\u222D"; return "OP"; 
break;
case 1577: yy_.yytext = "\u222C"; return "OP"; 
break;
case 1578: yy_.yytext = "\u22C2"; return "OPM"; 
break;
case 1579: yy_.yytext = "\u2229"; return "OP"; 
break;
case 1580: yy_.yytext = "\u2AF4"; return "OP"; 
break;
case 1581: yy_.yytext = "\u22BA"; return "OP"; 
break;
case 1582: yy_.yytext = "\u222B"; return "OP"; 
break;
case 1583: yy_.yytext = "\u2A1A"; return "OP"; 
break;
case 1584: yy_.yytext = "\u2A19"; return "OP"; 
break;
case 1585: yy_.yytext = "\u2A0E"; return "OP"; 
break;
case 1586: yy_.yytext = "\u2A0D"; return "OP"; 
break;
case 1587: yy_.yytext = "\u222B"; return "OP"; 
break;
case 1588: yy_.yytext = "\u221E"; return "NUM"; 
break;
case 1589: yy_.yytext = "\u221E"; return "NUM"; 
break;
case 1590: yy_.yytext = yy_.yytext.slice(1); return "FM"; 
break;
case 1591: yy_.yytext = "\u220A"; return "OP"; 
break;
case 1592: yy_.yytext = "\u2208"; return "OP"; 
break;
case 1593: yy_.yytext = "\u0131"; return "A"; 
break;
case 1594: yy_.yytext = "\u22B7"; return "OP"; 
break;
case 1595: yy_.yytext = "\u2111"; return "A"; 
break;
case 1596: yy_.yytext = "\u222C"; return "OP"; 
break;
case 1597: yy_.yytext = "\u222D"; return "OP"; 
break;
case 1598: yy_.yytext = "\u2A0C"; return "OP"; 
break;
case 1599: yy_.yytext = "\u0131"; return "A"; 
break;
case 1600: yy_.yytext = "\u210F"; return "A"; 
break;
case 1601: this.pushState("TEXTARG"); return "HREF"; 
break;
case 1602: yy_.yytext = "\u21AA"; return "OPS"; 
break;
case 1603: yy_.yytext = "\u21A9"; return "OPS"; 
break;
case 1604: yy_.yytext = "\u223B"; return "OP"; 
break;
case 1605: yy_.yytext = "\u2926"; return "OP"; 
break;
case 1606: yy_.yytext = "\u2925"; return "OP"; 
break;
case 1607: yy_.yytext = "\u22B9"; return "OP"; 
break;
case 1608: yy_.yytext = "\u2661"; return "OP"; 
break;
case 1609: yy_.yytext = "\u210F"; return "A"; 
break;
case 1610: yy_.yytext = "\u005E"; return "ACCENTNS"; 
break;
case 1611: yy_.yytext = "\u02DD"; return "OP"; 
break;
case 1612: yy_.yytext = "\u2269\uFE00"; return "OP"; 
break;
case 1613: yy_.yytext = "\u2269\uFE00"; return "OP"; 
break;
case 1614: yy_.yytext = "\u2273"; return "OP"; 
break;
case 1615: yy_.yytext = "\u2277"; return "OP"; 
break;
case 1616: yy_.yytext = "\u2A8C"; return "OP"; 
break;
case 1617: yy_.yytext = "\u22DB"; return "OP"; 
break;
case 1618: yy_.yytext = "\u22DB"; return "OP"; 
break;
case 1619: yy_.yytext = "\u22D7"; return "OP"; 
break;
case 1620: yy_.yytext = "\u2A86"; return "OP"; 
break;
case 1621: yy_.yytext = "\u003E"; return "OP"; 
break;
case 1622: yy_.yytext = "\u2273"; return "OP"; 
break;
case 1623: yy_.yytext = "\u003E"; return "OP"; 
break;
case 1624: yy_.yytext = "\u22E7"; return "OP"; 
break;
case 1625: yy_.yytext = "\u2269"; return "OP"; 
break;
case 1626: yy_.yytext = "\u2A88"; return "OP"; 
break;
case 1627: yy_.yytext = "\u2269"; return "OP"; 
break;
case 1628: yy_.yytext = "\u2A8A"; return "OP"; 
break;
case 1629: yy_.yytext = "\u2137"; return "A"; 
break;
case 1630: yy_.yytext = "\u22D9"; return "OP"; 
break;
case 1631: yy_.yytext = "\u226B"; return "OP"; 
break;
case 1632: yy_.yytext = "\u2A7E"; return "OP"; 
break;
case 1633: yy_.yytext = "\u2267"; return "OP"; 
break;
case 1634: yy_.yytext = "\u2265"; return "OP"; 
break;
case 1635: yy_.yytext = "\u2265"; return "OP"; 
break;
case 1636: yy_.yytext = "\u0393"; return "A"; 
break;
case 1637: yy_.yytext = "\u03B3"; return "A"; 
break;
case 1638: yy_.yytext = "\u2322"; return "OP"; 
break;
case 1639: this.pushState("TEXTARG"); return "FRAME"; 
break;
case 1640:return "FRAC";
break;
case 1641: yy_.yytext = "\u2ADD"; return "OP"; 
break;
case 1642: yy_.yytext = "\u2ADD\u0338"; return "OP"; 
break;
case 1643: yy_.yytext = "\u22A8"; return "OP"; 
break;
case 1644: yy_.yytext = "\u2200"; return "OP"; 
break;
case 1645: yy_.yytext = "\u266D"; return "OP"; 
break;
case 1646: yy_.yytext = "\u292C"; return "OP"; 
break;
case 1647: yy_.yytext = "\u292F"; return "OP"; 
break;
case 1648: yy_.yytext = "\u25AD"; return "OP"; 
break;
case 1649: yy_.yytext = "\u2252"; return "OP"; 
break;
case 1650: yy_.yytext = "\u2203"; return "OP"; 
break;
case 1651: yy_.yytext = "\u00F0"; return "A"; 
break;
case 1652: yy_.yytext = "\u00F0"; return "A"; 
break;
case 1653: yy_.yytext = "\u0397"; return "A"; 
break;
case 1654: yy_.yytext = "\u03B7"; return "A"; 
break;
case 1655: yy_.yytext = "\u2259"; return "OP"; 
break;
case 1656: yy_.yytext = "\u2261"; return "OP"; 
break;
case 1657: this.pushState("TEXTARG"); return "EQROWS"; 
break;
case 1658: this.pushState("TEXTARG"); return "EQCOLS"; 
break;
case 1659: yy_.yytext = "\u2A75"; return "OP"; 
break;
case 1660: yy_.yytext = "\u2A95"; return "OP"; 
break;
case 1661: yy_.yytext = "\u2A96"; return "OP"; 
break;
case 1662: yy_.yytext = "\u2242"; return "OP"; 
break;
case 1663: yy_.yytext = "\u003D\u2237"; return "OP"; 
break;
case 1664: yy_.yytext = "\u2255"; return "OP"; 
break;
case 1665: yy_.yytext = "\u2212\u2237"; return "OP"; 
break;
case 1666: yy_.yytext = "\u003D\u2237"; return "OP"; 
break;
case 1667: yy_.yytext = "\u2255"; return "OP"; 
break;
case 1668: yy_.yytext = "\u2256"; return "OP"; 
break;
case 1669: yy_.yytext = "\u0395"; return "A"; 
break;
case 1670: yy_.yytext = "\u03F5"; return "A"; 
break;
case 1671: yy_.yytext = "\u03B5"; return "A"; 
break;
case 1672:return "EVVMATRIX";
break;
case 1673:return "EVMATRIX";
break;
case 1674: return "ETOGGLE"; 
break;
case 1675:return "EALIGNED";
break;
case 1676:return "ESMALLMATRIX";
break;
case 1677:return "EPMATRIX";
break;
case 1678:return "EMATRIX";
break;
case 1679:return "EGATHERED";
break;
case 1680:return "ECASES";
break;
case 1681:return "EBBMATRIX";
break;
case 1682:return "EBMATRIX";
break;
case 1683:return "EARRAY";
break;
case 1684:return "EALIGNED";
break;
case 1685: yy_.yytext = "\u2205"; return "A"; 
break;
case 1686: yy_.yytext = "\u2205"; return "A"; 
break;
case 1687: yy_.yytext = "\u25AF"; return "OP"; 
break;
case 1688: yy_.yytext = "\u2A2F"; return "OP"; 
break;
case 1689: yy_.yytext = "\u2A05"; return "OPM"; 
break;
case 1690: yy_.yytext = "\u2980"; return "OPFS"; 
break;
case 1691: yy_.yytext = "\u2AF6"; return "OP"; 
break;
case 1692: yy_.yytext = "\u2A08"; return "OPM"; 
break;
case 1693: yy_.yytext = "\u22E5"; return "OP"; 
break;
case 1694: yy_.yytext = "\u2942"; return "OP"; 
break;
case 1695: yy_.yytext = "\u2944"; return "OP"; 
break;
case 1696: yy_.yytext = "\u201B"; return "OP"; 
break;
case 1697: yy_.yytext = "\u2947"; return "OP"; 
break;
case 1698: yy_.yytext = "\u2A54"; return "OP"; 
break;
case 1699: yy_.yytext = "\u2A5F"; return "OP"; 
break;
case 1700: yy_.yytext = "\u29A0"; return "OP"; 
break;
case 1701: yy_.yytext = "\u29CA"; return "OP"; 
break;
case 1702: yy_.yytext = "\u2A07"; return "OPM"; 
break;
case 1703: yy_.yytext = "\u29CB"; return "OP"; 
break;
case 1704: yy_.yytext = "\u2999"; return "OP"; 
break;
case 1705: yy_.yytext = "\u2A0D"; return "OP"; 
break;
case 1706: yy_.yytext = "\u2A53"; return "OP"; 
break;
case 1707: yy_.yytext = "\u2A04"; return "OPM"; 
break;
case 1708: yy_.yytext = "\u2A06"; return "OPM"; 
break;
case 1709: yy_.yytext = "\u2986"; return "OPFS"; 
break;
case 1710: yy_.yytext = "\u2941"; return "OP"; 
break;
case 1711: yy_.yytext = "\u2A56"; return "OP"; 
break;
case 1712: yy_.yytext = "\u2940"; return "OP"; 
break;
case 1713: yy_.yytext = "\u2113"; return "A"; 
break;
case 1714: yy_.yytext = "\u29DF"; return "OP"; 
break;
case 1715: yy_.yytext = "\u2910"; return "OPS"; 
break;
case 1716: yy_.yytext = "\u22F1"; return "OP"; 
break;
case 1717: yy_.yytext = "\u2957"; return "OPS"; 
break;
case 1718: yy_.yytext = "\u295F"; return "OPS"; 
break;
case 1719: yy_.yytext = "\u2956"; return "OPS"; 
break;
case 1720: yy_.yytext = "\u295E"; return "OPS"; 
break;
case 1721: yy_.yytext = "\u2950"; return "OPS"; 
break;
case 1722: yy_.yytext = "\u21C2"; return "OPS"; 
break;
case 1723: yy_.yytext = "\u21C3"; return "OPS"; 
break;
case 1724: yy_.yytext = "\u21CA"; return "OPS"; 
break;
case 1725: yy_.yytext = "\u21F5"; return "OPS"; 
break;
case 1726: yy_.yytext = "\u2913"; return "OPS"; 
break;
case 1727: yy_.yytext = "\u21D3"; return "OPS"; 
break;
case 1728: yy_.yytext = "\u2193"; return "OPS"; 
break;
case 1729: yy_.yytext = "\u222C"; return "OP"; 
break;
case 1730: yy_.yytext = "\u2306"; return "OP"; 
break;
case 1731: yy_.yytext = "\u2306"; return "OP"; 
break;
case 1732: yy_.yytext = "\u2026"; return "OP"; 
break;
case 1733: yy_.yytext = "\u2214"; return "OP"; 
break;
case 1734: yy_.yytext = "\u2238"; return "OP"; 
break;
case 1735: yy_.yytext = "\u2251"; return "OP"; 
break;
case 1736: yy_.yytext = "\u2251"; return "OP"; 
break;
case 1737: yy_.yytext = "\u2250"; return "OP"; 
break;
case 1738: yy_.yytext = "\u02D9"; return "OP"; 
break;
case 1739: yy_.yytext = "\u02D9"; return "ACCENT"; 
break;
case 1740: yy_.yytext = "\u22C7"; return "OP"; 
break;
case 1741: yy_.yytext = "\u00F7"; return "OP"; 
break;
case 1742:return "DISPLAYSTYLE";
break;
case 1743: yy_.yytext = "\u2A08"; return "OPM"; 
break;
case 1744: yy_.yytext = "\u2605"; return "OP"; 
break;
case 1745: yy_.yytext = "\u2660"; return "OP"; 
break;
case 1746: yy_.yytext = "\u2663"; return "OP"; 
break;
case 1747: yy_.yytext = "\u2758"; return "OP"; 
break;
case 1748: yy_.yytext = "\u25D7"; return "OP"; 
break;
case 1749: yy_.yytext = "\u25C6"; return "OP"; 
break;
case 1750: yy_.yytext = "\u25BC"; return "OP"; 
break;
case 1751: yy_.yytext = "\u25B2"; return "OP"; 
break;
case 1752: yy_.yytext = "\u25A0"; return "OP"; 
break;
case 1753: yy_.yytext = "\u25CF"; return "OP"; 
break;
case 1754: yy_.yytext = "\u03DC"; return "A"; 
break;
case 1755: yy_.yytext = "\u03DD"; return "A"; 
break;
case 1756: yy_.yytext = "\u2662"; return "OP"; 
break;
case 1757: yy_.yytext = "\u22C4"; return "OP"; 
break;
case 1758: yy_.yytext = "\u25CA"; return "OP"; 
break;
case 1759: yy_.yytext = "\u22C4"; return "OP"; 
break;
case 1760: yy_.yytext = "\u00F0"; return "A"; 
break;
case 1761: yy_.yytext = yy_.yytext.slice(1); return "FM"; 
break;
case 1762: yy_.yytext = "\u0394"; return "A"; 
break;
case 1763: yy_.yytext = "\u03B4"; return "A"; 
break;
case 1764: yy_.yytext = "\u2207"; return "OP"; 
break;
case 1765: yy_.yytext = "\u00B0"; return "OP"; 
break;
case 1766: yy_.yytext = "\u290B"; return "OPS"; 
break;
case 1767: yy_.yytext = "\u2A77"; return "OP"; 
break;
case 1768: yy_.yytext = "\u22F1"; return "OP"; 
break;
case 1769: yy_.yytext = "\u0308"; return "ACCENT"; 
break;
case 1770: yy_.yytext = "\u20DB"; return "OP"; 
break;
case 1771: yy_.yytext = "\u20DB"; return "ACCENT"; 
break;
case 1772: yy_.yytext = "\u20DC"; return "OP"; 
break;
case 1773: yy_.yytext = "\u20DC"; return "ACCENT"; 
break;
case 1774: yy_.yytext = "\u2021"; return "OP"; 
break;
case 1775: yy_.yytext = "\u2021"; return "OP"; 
break;
case 1776: yy_.yytext = "\u2237"; return "OP"; 
break;
case 1777: yy_.yytext = "\u21C5"; return "OPS"; 
break;
case 1778: yy_.yytext = "\u290F"; return "OPS"; 
break;
case 1779: yy_.yytext = "\u2AE4"; return "OP"; 
break;
case 1780: yy_.yytext = "\u2AE3"; return "OP"; 
break;
case 1781: yy_.yytext = "\u22A3"; return "OP"; 
break;
case 1782: yy_.yytext = "\u2138"; return "A"; 
break;
case 1783: yy_.yytext = "\u2020"; return "OP"; 
break;
case 1784: yy_.yytext = "\u2020"; return "OP"; 
break;
case 1785: yy_.yytext = "\u0428"; return "A"; 
break;
case 1786: yy_.yytext = "\u21B7"; return "OP"; 
break;
case 1787: yy_.yytext = "\u21B6"; return "OP"; 
break;
case 1788: yy_.yytext = "\u22CF"; return "OP"; 
break;
case 1789: yy_.yytext = "\u22CE"; return "OP"; 
break;
case 1790: yy_.yytext = "\u22DF"; return "OP"; 
break;
case 1791: yy_.yytext = "\u22DE"; return "OP"; 
break;
case 1792: yy_.yytext = "\u228D"; return "OP"; 
break;
case 1793: yy_.yytext = "\u22D3"; return "OP"; 
break;
case 1794: yy_.yytext = "\u222A"; return "OP"; 
break;
case 1795: yy_.yytext = "\u2210"; return "OPM"; 
break;
case 1796: yy_.yytext = "\u2210"; return "OPM"; 
break;
case 1797: yy_.yytext = "\u222E"; return "OP"; 
break;
case 1798: yy_.yytext = "\u2A07"; return "OPM"; 
break;
case 1799: yy_.yytext = "\u222E"; return "OP"; 
break;
case 1800: yy_.yytext = "\u2245"; return "OP"; 
break;
case 1801: yy_.yytext = "\u2201"; return "OP"; 
break;
case 1802: this.begin("TEXTARG"); return "COLSPAN"; 
break;
case 1803: this.pushState("TEXTARG"); return "COLOR"; 
break;
case 1804: yy_.yytext = "\u2237\u223C"; return "OP"; 
break;
case 1805: yy_.yytext = "\u2236\u223C"; return "OP"; 
break;
case 1806: yy_.yytext = "\u2A74"; return "OP"; 
break;
case 1807: yy_.yytext = "\u2254"; return "OP"; 
break;
case 1808: yy_.yytext = "\u2237\u2212"; return "OP"; 
break;
case 1809: yy_.yytext = "\u2254"; return "OP"; 
break;
case 1810: yy_.yytext = "\u2237\u2248"; return "OP"; 
break;
case 1811: yy_.yytext = "\u2236\u2248"; return "OP"; 
break;
case 1812: yy_.yytext = "\u2237"; return "OP"; 
break;
case 1813: yy_.yytext = "\u003A"; return "OP"; 
break;
case 1814: this.pushState("TEXTARG"); return "COLLINES"; 
break;
case 1815: this.pushState("TEXTARG"); return "COLLAYOUT";
break;
case 1816: this.begin("TEXTARG"); return "COLALIGN"; 
break;
case 1817: yy_.yytext = "\u2231"; return "OP"; 
break;
case 1818: yy_.yytext = "\u2663"; return "OP"; 
break;
case 1819: yy_.yytext = "\u00AF"; return "ACCENT"; 
break;
case 1820: yy_.yytext = "\u2A0F"; return "OP"; 
break;
case 1821: yy_.yytext = "\u229D"; return "OP"; 
break;
case 1822: yy_.yytext = "\u229A"; return "OP"; 
break;
case 1823: yy_.yytext = "\u229B"; return "OP"; 
break;
case 1824: yy_.yytext = "\u2941"; return "OP"; 
break;
case 1825: yy_.yytext = "\u21BB"; return "OP"; 
break;
case 1826: yy_.yytext = "\u2940"; return "OP"; 
break;
case 1827: yy_.yytext = "\u21BA"; return "OP"; 
break;
case 1828: yy_.yytext = "\u2257"; return "OP"; 
break;
case 1829: yy_.yytext = "\u2218"; return "OP"; 
break;
case 1830:return "TEXCHOOSE";
break;
case 1831: yy_.yytext = "\u03A7"; return "A"; 
break;
case 1832: yy_.yytext = "\u03C7"; return "A"; 
break;
case 1833: yy_.yytext = "\u02C7"; return "ACCENTNS"; 
break;
case 1834:return "CELLOPTS";
break;
case 1835: yy_.yytext = "\u22EF"; return "OP"; 
break;
case 1836: yy_.yytext = "\u00B7"; return "OP"; 
break;
case 1837: yy_.yytext = "\u22C5"; return "OP"; 
break;
case 1838: yy_.yytext = "\u22D2"; return "OP"; 
break;
case 1839: yy_.yytext = "\u2229"; return "OP"; 
break;
case 1840: yy_.yytext = "\u00B8"; return "OP"; 
break;
case 1841: yy_.yytext = "\u2AAE"; return "OP"; 
break;
case 1842: yy_.yytext = "\u224E"; return "OP"; 
break;
case 1843: yy_.yytext = "\u224F"; return "OP"; 
break;
case 1844: yy_.yytext = "\u2219"; return "OP"; 
break;
case 1845: yy_.yytext = "\u2022"; return "OP"; 
break;
case 1846: yy_.yytext = "\u2A32"; return "OP"; 
break;
case 1847: yy_.yytext = "\u22A0"; return "OP"; 
break;
case 1848: yy_.yytext = "\u229E"; return "OP"; 
break;
case 1849: yy_.yytext = "\u229F"; return "OP"; 
break;
case 1850:return "BOXED";
break;
case 1851: yy_.yytext = "\u22A1"; return "OP"; 
break;
case 1852: yy_.yytext = "\u29C4"; return "OP"; 
break;
case 1853: yy_.yytext = "\u29C7"; return "OP"; 
break;
case 1854: yy_.yytext = "\u29C5"; return "OP"; 
break;
case 1855: yy_.yytext = "\u29C6"; return "OP"; 
break;
case 1856: yy_.yytext = "\u25A1"; return "OP"; 
break;
case 1857: yy_.yytext = "\u22C8"; return "OP"; 
break;
case 1858: yy_.yytext = "\u22A5"; return "OP"; 
break;
case 1859: yy_.yytext = "\u22A5"; return "OP"; 
break;
case 1860:return "MATHBF";
break;
case 1861: yy_.yytext = "\u25B8"; return "OP"; 
break;
case 1862: yy_.yytext = "\u25C2"; return "OP"; 
break;
case 1863: yy_.yytext = "\u25BE"; return "OP"; 
break;
case 1864: yy_.yytext = "\u25B4"; return "OP"; 
break;
case 1865: yy_.yytext = "\u25AA"; return "OP"; 
break;
case 1866: yy_.yytext = "\u25A0"; return "OP"; 
break;
case 1867: yy_.yytext = "\u29EB"; return "OP"; 
break;
case 1868: yy_.yytext = "\u290D"; return "OPS"; 
break;
case 1869:return "BINOM";
break;
case 1870: yy_.yytext = "\u22C0"; return "OPM"; 
break;
case 1871: yy_.yytext = "\u22C1"; return "OPM"; 
break;
case 1872: yy_.yytext = "\u2A04"; return "OPM"; 
break;
case 1873: yy_.yytext = "\u25B3"; return "OP"; 
break;
case 1874: yy_.yytext = "\u25BD"; return "OP"; 
break;
case 1875: yy_.yytext = "\u2A09"; return "OPM"; 
break;
case 1876: yy_.yytext = "\u2605"; return "OP"; 
break;
case 1877: yy_.yytext = "\u2A06"; return "OPM"; 
break;
case 1878: yy_.yytext = "\u2A05"; return "OPM"; 
break;
case 1879:return "BBIG";
break;
case 1880:return "BIG";
break;
case 1881: yy_.yytext = "\u2A02"; return "OPM"; 
break;
case 1882: yy_.yytext = "\u2A01"; return "OPM"; 
break;
case 1883: yy_.yytext = "\u2A00"; return "OPM"; 
break;
case 1884:return "BBIGL";
break;
case 1885:return "BIGL";
break;
case 1886: yy_.yytext = "\u2AFC"; return "OPM"; 
break;
case 1887:return "BBIGG";
break;
case 1888:return "BIGG";
break;
case 1889:return "BBIGGL";
break;
case 1890:return "BIGGL";
break;
case 1891:return "BBIGG";
break;
case 1892:return "BIGG";
break;
case 1893: yy_.yytext = "\u2A03"; return "OPM"; 
break;
case 1894: yy_.yytext = "\u22C3"; return "OPM"; 
break;
case 1895: yy_.yytext = "\u25CB"; return "OP"; 
break;
case 1896: yy_.yytext = "\u22C2"; return "OPM"; 
break;
case 1897:return "BBIG";
break;
case 1898:return "BIG";
break;
case 1899: this.pushState("TEXTARG"); return "BGCOLOR"; 
break;
case 1900: yy_.yytext = "\u226C"; return "OP"; 
break;
case 1901: yy_.yytext = "\u2136"; return "A"; 
break;
case 1902: yy_.yytext = "\u0392"; return "A"; 
break;
case 1903: yy_.yytext = "\u03B2"; return "A"; 
break;
case 1904:return "BVVMATRIX";
break;
case 1905:return "BVMATRIX";
break;
case 1906: return "BTOGGLE"; 
break;
case 1907:return "BALIGNED";
break;
case 1908:return "BSMALLMATRIX";
break;
case 1909:return "BPMATRIX";
break;
case 1910:return "BMATRIX";
break;
case 1911:return "BGATHERED";
break;
case 1912:return "BCASES";
break;
case 1913:return "BBBMATRIX";
break;
case 1914:return "BBMATRIX";
break;
case 1915: this.pushState("TEXTARG"); this.pushState("TEXTOPTARG"); this.pushState("TRYOPTARG"); return "BARRAY"; 
break;
case 1916:return "BALIGNED";
break;
case 1917: yy_.yytext = "\u2235"; return "OP"; 
break;
case 1918: yy_.yytext = "\u213F"; return "A"; 
break;
case 1919: yy_.yytext = "\u2305"; return "OP"; 
break;
case 1920: yy_.yytext = "\u00AF"; return "ACCENTNS"; 
break;
case 1921: yy_.yytext = "\u005C"; return "OP"; 
break;
case 1922: yy_.yytext = "\u22CD"; return "OP"; 
break;
case 1923: yy_.yytext = "\u223D"; return "OP"; 
break;
case 1924: yy_.yytext = "\u2035"; return "OPP"; 
break;
case 1925: yy_.yytext = "\u03F6"; return "OP"; 
break;
case 1926:return "TEXATOP";
break;
case 1927: yy_.yytext = "\u224D"; return "OP"; 
break;
case 1928: yy_.yytext = "\u2217"; return "OP"; 
break;
case 1929: yy_.yytext = "\u002A"; return "OP"; 
break;
case 1930: yy_.yytext = "\u219D"; return "OPS"; 
break;
case 1931: yy_.yytext = "\u219C"; return "OPS"; 
break;
case 1932:return "ARRAYOPTS";
break;
case 1933:return "ARRAY";
break;
case 1934: yy_.yytext = yy_.yytext.slice(1); return "F"; 
break;
case 1935: yy_.yytext = "\u2246"; return "OP"; 
break;
case 1936: yy_.yytext = "\u224A"; return "OP"; 
break;
case 1937: yy_.yytext = "\u2248"; return "OP"; 
break;
case 1938: yy_.yytext = "\u299C"; return "OP"; 
break;
case 1939: yy_.yytext = "\u2220"; return "OP"; 
break;
case 1940: yy_.yytext = "\u2A3F"; return "OP"; 
break;
case 1941: yy_.yytext = "\u0391"; return "A"; 
break;
case 1942: yy_.yytext = "\u03B1"; return "A"; 
break;
case 1943: yy_.yytext = "\u224C"; return "OP"; 
break;
case 1944: this.pushState("TEXTARG"); return "ALIGN"; 
break;
case 1945: yy_.yytext = "\u2135"; return "A"; 
break;
case 1946: yy_.yytext = "\u22F0"; return "OP"; 
break;
case 1947: yy_.yytext = "\u212B"; return "A"; 
break;
case 1948:return "A";
break;
case 1949: yy_.yytext = "\u0025"; return "OP"; 
break;
case 1950: yy_.yytext = "\u0023"; return "OP"; 
break;
case 1951: yy_.yytext = "\u0026"; return "OP"; 
break;
case 1952: yy_.yytext = "\u0024"; return "A"; 
break;
case 1953: yy_.yytext = "\u007D"; return "OPFS"; 
break;
case 1954: yy_.yytext = "\u007B"; return "OPFS"; 
break;
case 1955:return "NEGSPACE";
break;
case 1956:return "MEDSPACE";
break;
case 1957:return "THICKSPACE";
break;
case 1958:return "THINSPACE";
break;
case 1959: yy_.yytext = "\u005F"; return "OPS"; 
break;
case 1960: yy_.yytext = "\u2016"; return "OPFS"; 
break;
case 1961: yy_.yytext = "\u005E"; return "OPS"; 
break;
case 1962: yy_.yytext = "\u0302"; return "OPS"; 
break;
case 1963: yy_.yytext = "\u2057"; return "OPP"; 
break;
case 1964: yy_.yytext = "\u2034"; return "OPP"; 
break;
case 1965: yy_.yytext = "\u2033"; return "OPP"; 
break;
case 1966: yy_.yytext = "\u2032"; return "OPP"; 
break;
case 1967:return "HIGH_SURROGATE";
break;
case 1968:return "LOW_SURROGATE";
break;
case 1969:return "BMP_CHARACTER";
break;
}
},
rules: [/^(?:\s*\[)/,/^(?:.)/,/^(?:([^\\\]]|(\\[\\\]]))+)/,/^(?:\])/,/^(?:\s*\{)/,/^(?:([^\\\}]|(\\[\\\}]))+)/,/^(?:\})/,/^(?:\])/,/^(?:\s+)/,/^(?:\{)/,/^(?:\})/,/^(?:\^)/,/^(?:_)/,/^(?:\.)/,/^(?:&)/,/^(?:\\\\)/,/^(?:$)/,/^(?:[0-9]+(?:\.[0-9]+)?|[\u0660-\u0669]+(?:\u066B[\u0660-\u0669]+)?|(?:\uD835[\uDFCE-\uDFD7])+|(?:\uD835[\uDFCE-\uDFD7])+|(?:\uD835[\uDFD8-\uDFE1])+|(?:\uD835[\uDFE2-\uDFEB])+|(?:\uD835[\uDFEC-\uDFF5])+|(?:\uD835[\uDFF6-\uDFFF])+)/,/^(?:\\Zeta)/,/^(?:\\zeta)/,/^(?:\\xrightleftharpoons)/,/^(?:\\xRightarrow)/,/^(?:\\xrightarrow)/,/^(?:\\xmapsto)/,/^(?:\\xleftrightharpoons)/,/^(?:\\xLeftrightarrow)/,/^(?:\\xleftrightarrow)/,/^(?:\\xLeftarrow)/,/^(?:\\xleftarrow)/,/^(?:\\Xi)/,/^(?:\\xi)/,/^(?:\\xhookrightarrow)/,/^(?:\\xhookleftarrow)/,/^(?:\\wr)/,/^(?:\\wp)/,/^(?:\\widevec)/,/^(?:\\widetilde)/,/^(?:\\widehat)/,/^(?:\\widecheck)/,/^(?:\\widebar)/,/^(?:\\wedgeq)/,/^(?:\\Wedge)/,/^(?:\\wedge)/,/^(?:\\Vvert)/,/^(?:\\Vvdash)/,/^(?:\\volintegral)/,/^(?:\\verymuchless)/,/^(?:\\verymuchgreater)/,/^(?:\\Vert)/,/^(?:\\vert)/,/^(?:\\veebar)/,/^(?:\\Vee)/,/^(?:\\vee)/,/^(?:\\vec)/,/^(?:\\vdots)/,/^(?:\\VDash)/,/^(?:\\Vdash)/,/^(?:\\vDash)/,/^(?:\\vdash)/,/^(?:\\Vbar)/,/^(?:\\vartriangleright)/,/^(?:\\vartriangleleft)/,/^(?:\\vartriangle)/,/^(?:\\vartheta)/,/^(?:\\varsupsetneq)/,/^(?:\\varsubsetneqq)/,/^(?:\\varsubsetneqq)/,/^(?:\\varsubsetneq)/,/^(?:\\varsigma)/,/^(?:\\varrho)/,/^(?:\\varpropto)/,/^(?:\\varpi)/,/^(?:\\varphi)/,/^(?:\\varnothing)/,/^(?:\\varkappa)/,/^(?:\\varepsilon)/,/^(?:\\Uuparrow)/,/^(?:\\upuparrows)/,/^(?:\\upslopeellipsis)/,/^(?:\\Upsilon)/,/^(?:\\upsilon)/,/^(?:\\uplus)/,/^(?:\\upint)/,/^(?:\\upharpoonright)/,/^(?:\\upharpoonright)/,/^(?:\\upharpoonleft)/,/^(?:\\upharpoonleft)/,/^(?:\\UpEquilibrium)/,/^(?:\\Updownarrow)/,/^(?:\\updownarrow)/,/^(?:\\UpArrowBar)/,/^(?:\\Uparrow)/,/^(?:\\uparrow)/,/^(?:\\unrhd)/,/^(?:\\unlhd)/,/^(?:\\Union)/,/^(?:\\union)/,/^(?:\\underset)/,/^(?:\\underoverset)/,/^(?:\\underline)/,/^(?:\\underbrace)/,/^(?:\\udots)/,/^(?:\u2ADD\u0338)/,/^(?:\u2ACB\uFE00)/,/^(?:\u2AB0\u0338)/,/^(?:\u2AAF\u0338)/,/^(?:\u2AA2\u0338)/,/^(?:\u2AA1\u0338)/,/^(?:\u2A7E\u0338)/,/^(?:\u2A7D\u0338)/,/^(?:\u29D0\u0338)/,/^(?:\u29CF\u0338)/,/^(?:\u2290\u0338)/,/^(?:\u228F\u0338)/,/^(?:\u228B\uFE00)/,/^(?:\u228A\uFE00)/,/^(?:\u2283\u20D2)/,/^(?:\u2282\u20D2)/,/^(?:\u227F\u0338)/,/^(?:\u226B\u0338)/,/^(?:\u226A\u0338)/,/^(?:\u2269\uFE00)/,/^(?:\u2268\uFE00)/,/^(?:\u2266\u0338)/,/^(?:\u224F\u0338)/,/^(?:\u224E\u0338)/,/^(?:\u2242\u0338)/,/^(?:\u223D\u0331)/,/^(?:\u2237\u2248)/,/^(?:\u2237\u223C)/,/^(?:\u2237\u2212)/,/^(?:\u2236\u2248)/,/^(?:\u2236\u223C)/,/^(?:\u2212\u2237)/,/^(?:\u007C\u007C\u007C)/,/^(?:\u007C\u007C)/,/^(?:\u003E\u003D)/,/^(?:\u003D\u2237)/,/^(?:\u003D\u2237)/,/^(?:\u003D\u003D)/,/^(?:\u003C\u003E)/,/^(?:\u003C\u003D)/,/^(?:\u003A\u003D)/,/^(?:\u002F\u003D)/,/^(?:\u002F\u002F)/,/^(?:\u002E\u002E\u002E)/,/^(?:\u002E\u002E)/,/^(?:\u002D\u003E)/,/^(?:\u002D\u003D)/,/^(?:\u002D\u002D)/,/^(?:\u002B\u003D)/,/^(?:\u002B\u002B)/,/^(?:\u002A\u003D)/,/^(?:\u002A\u002A)/,/^(?:\u0026\u0026)/,/^(?:\u0021\u003D)/,/^(?:\u0021\u0021)/,/^(?:\\u)/,/^(?:\\twoheadrightarrowtail)/,/^(?:\\twoheadrightarrow)/,/^(?:\\twoheadleftarrow)/,/^(?:\\truestate)/,/^(?:\\tripleintegral)/,/^(?:\\trianglerighteq)/,/^(?:\\triangleright)/,/^(?:\\triangleq)/,/^(?:\\trianglelefteq)/,/^(?:\\triangleleft)/,/^(?:\\triangledown)/,/^(?:\\triangle)/,/^(?:\\towa)/,/^(?:\\tosa)/,/^(?:\\top)/,/^(?:\\tooltip)/,/^(?:\\tona)/,/^(?:\\toggle)/,/^(?:\\toea)/,/^(?:\\to)/,/^(?:\\timesb)/,/^(?:\\times)/,/^(?:\\tildetrpl)/,/^(?:\\tilde)/,/^(?:\\thinspace)/,/^(?:\\thickspace)/,/^(?:\\thicksim)/,/^(?:\\thickapprox)/,/^(?:\\Theta)/,/^(?:\\theta)/,/^(?:\\therefore)/,/^(?:\\tfrac)/,/^(?:\\textvartheta)/,/^(?:\\texttimes)/,/^(?:\\texttildelow)/,/^(?:\\textTheta)/,/^(?:\\texttheta)/,/^(?:\\textstyle)/,/^(?:\\textsize)/,/^(?:\\textquotesingle)/,/^(?:\\textquotedblright)/,/^(?:\\textquotedblleft)/,/^(?:\\textperiodcentered)/,/^(?:\\textordmasculine)/,/^(?:\\textordfeminine)/,/^(?:\\textdollar)/,/^(?:\\textdegree)/,/^(?:\\textdaggerdbl)/,/^(?:\\textdagger)/,/^(?:\\textbullet)/,/^(?:\\textbackslash)/,/^(?:\\textasciitilde)/,/^(?:\\textasciimacron)/,/^(?:\\textasciigrave)/,/^(?:\\textasciidieresis)/,/^(?:\\textasciicircumflex)/,/^(?:\\textasciicaron)/,/^(?:\\textasciibreve)/,/^(?:\\textasciiacute)/,/^(?:\\text)/,/^(?:\\tensor)/,/^(?:\\tbinom)/,/^(?:\\Tau)/,/^(?:\\tau)/,/^(?:\\swarrow)/,/^(?:\\surfintegral)/,/^(?:\\surd)/,/^(?:\\supsetneqq)/,/^(?:\\supsetneqq)/,/^(?:\\supsetneq)/,/^(?:\\supseteqq)/,/^(?:\\supseteqq)/,/^(?:\\supseteq)/,/^(?:\\Supset)/,/^(?:\\supset)/,/^(?:\\sum)/,/^(?:\\succsim)/,/^(?:\\succnsim)/,/^(?:\\succneqq)/,/^(?:\\succnapprox)/,/^(?:\\succnapprox)/,/^(?:\\succeq)/,/^(?:\\succeq)/,/^(?:\\succcurlyeq)/,/^(?:\\succapprox)/,/^(?:\\succ)/,/^(?:\\substack)/,/^(?:\\subsetneqq)/,/^(?:\\subsetneqq)/,/^(?:\\subsetneq)/,/^(?:\\subseteqq)/,/^(?:\\subseteqq)/,/^(?:\\subseteq)/,/^(?:\\Subset)/,/^(?:\\subset)/,/^(?:\\Stigma)/,/^(?:\\statusline)/,/^(?:\\starequal)/,/^(?:\\star)/,/^(?:\\stackrel\{\*\}\{=\})/,/^(?:\\stackrel)/,/^(?:\\sslash)/,/^(?:\\square)/,/^(?:\\sqsupseteq)/,/^(?:\\sqsupset)/,/^(?:\\sqsubseteq)/,/^(?:\\sqsubset)/,/^(?:\\sqrt)/,/^(?:\\sqrint)/,/^(?:\\sqcup)/,/^(?:\\sqcap)/,/^(?:\\sphericalangle)/,/^(?:\\spadesuit)/,/^(?:\\space)/,/^(?:\\smile)/,/^(?:\\smallsmile)/,/^(?:\\smallsetminus)/,/^(?:\\smallfrown)/,/^(?:\\slash)/,/^(?:\\sim\\joinrel\\leadsto)/,/^(?:\\simeq)/,/^(?:\\sim)/,/^(?:\\Sigma)/,/^(?:\\sigma)/,/^(?:\\shuffle)/,/^(?:\\shortparallel)/,/^(?:\\shortmid)/,/^(?:\\sharp)/,/^(?:\\setminus)/,/^(?:\\seovnearrow)/,/^(?:\\searrow)/,/^(?:\\scriptsize)/,/^(?:\\scriptscriptsize)/,/^(?:\\Sampi)/,/^(?:\\RuleDelayed)/,/^(?:\\rtimes)/,/^(?:\\Rsh)/,/^(?:\\Rrightarrow)/,/^(?:\\rrangle)/,/^(?:\\rq)/,/^(?:\\rowspan)/,/^(?:\\rowopts)/,/^(?:\\rowlines)/,/^(?:\\rowalign)/,/^(?:\\RoundImplies)/,/^(?:\\root)/,/^(?:\\rmoustache)/,/^(?:\\risingdotseq)/,/^(?:\\RightVectorBar)/,/^(?:\\RightUpVectorBar)/,/^(?:\\RightUpTeeVector)/,/^(?:\\RightUpDownVector)/,/^(?:\\RightTriangleBar)/,/^(?:\\rightthreetimes)/,/^(?:\\RightTeeVector)/,/^(?:\\rightsquigarrow)/,/^(?:\\rightsquigarrow)/,/^(?:\\rightrightarrows)/,/^(?:\\rightleftharpoons)/,/^(?:\\rightleftarrows)/,/^(?:\\rightharpoonup)/,/^(?:\\rightharpoondown)/,/^(?:\\RightDownVectorBar)/,/^(?:\\RightDownTeeVector)/,/^(?:\\rightarrowtriangle)/,/^(?:\\rightarrowtail)/,/^(?:\\Rightarrow)/,/^(?:\\rightarrow)/,/^(?:\\rightanglearc)/,/^(?:\\rightangle)/,/^(?:\\right)/,/^(?:\\Rho)/,/^(?:\\rho)/,/^(?:\\rhd)/,/^(?:\\rfloor)/,/^(?:\\ReverseUpEquilibrium)/,/^(?:\\Re)/,/^(?:\\rdiagovsearrow)/,/^(?:\\rdiagovfdiag)/,/^(?:\\rceil)/,/^(?:\\rbrack)/,/^(?:\\rbrace)/,/^(?:\\rangle)/,/^(?:\\rang)/,/^(?:\\r\{\})/,/^(?:\\questeq)/,/^(?:\\quadrupleintegral)/,/^(?:\\quad)/,/^(?:\\qquad)/,/^(?:\\qed)/,/^(?:\\Psi)/,/^(?:\\psi)/,/^(?:\\propto)/,/^(?:\\product)/,/^(?:\\prod)/,/^(?:\\prime)/,/^(?:\\precsim)/,/^(?:\\precnsim)/,/^(?:\\precneqq)/,/^(?:\\precnapprox)/,/^(?:\\preceq)/,/^(?:\\precedesnotsimilar)/,/^(?:\\preccurlyeq)/,/^(?:\\precapprox)/,/^(?:\\prec)/,/^(?:\\pmod)/,/^(?:\\pm)/,/^(?:\\plusdot)/,/^(?:\\plusb)/,/^(?:\\pitchfork)/,/^(?:\\Pi)/,/^(?:\\pi)/,/^(?:\\Phi)/,/^(?:\\phi)/,/^(?:\\phantom)/,/^(?:\\perspcorrespond)/,/^(?:\\Perp)/,/^(?:\\perp)/,/^(?:\\partialmeetcontraction)/,/^(?:\\partial)/,/^(?:\\parr)/,/^(?:\\parallel)/,/^(?:\\padding)/,/^(?:\\overset)/,/^(?:\\overline)/,/^(?:\\overbrace)/,/^(?:\\over)/,/^(?:\\Otimes)/,/^(?:\\otimes)/,/^(?:\\oslash)/,/^(?:\\original)/,/^(?:[\u007E\u00AF\u02C6\u02C7\u02C9\u02CD\u02DC\u02F7\u0302\u203E\u2044\u2190-\u2199\u219C-\u21AD\u21AF-\u21B5\u21B9\u21BC-\u21CC\u21D0-\u21DD\u21E0-\u21F0\u21F3\u21F5\u21F6\u21FD-\u21FF\u2215\u221A\u23B4\u23B5\u23DC-\u23E1\u27F0\u27F1\u27F5-\u27FF\u290A-\u2910\u2912\u2913\u2921\u2922\u294E-\u2961\u296E\u296F\u2B45\u2B46])/,/^(?:[\u2032-\u2035\u2057])/,/^(?:[\u220F-\u2211\u22C0-\u22C3\u2A00-\u2A0A\u2A10-\u2A14\u2AFC\u2AFF])/,/^(?:\\Oplus)/,/^(?:\\oplus)/,/^(?:[\u0028\u0029\u005B\u005D\u007C\u2016\u2308-\u230B\u2329\u232A\u2772\u2773\u27E6-\u27EF\u2980\u2983-\u2998\u29FC\u29FD])/,/^(?:[\u2018\u2019\u201C\u201D])/,/^(?:\\operatorname)/,/^(?:[\u0021-\u0023\u002A-\u002D\u002F\u003A-\u0040\u0060\u00A8\u00AA\u00AC\u00B0-\u00B4\u00B7-\u00BA\u00D7\u00F7\u02CA\u02CB\u02D8-\u02DA\u02DD\u0311\u03F6\u201A\u201B\u201E-\u2022\u2026\u2036\u2037\u2043\u2061-\u2064\u20DB\u20DC\u2145\u2146\u214B\u219A\u219B\u21AE\u21B6-\u21B8\u21BA\u21BB\u21CD-\u21CF\u21DE\u21DF\u21F1\u21F2\u21F4\u21F7-\u21FC\u2200-\u2204\u2206-\u220E\u2212-\u2214\u2216-\u2219\u221B-\u221D\u221F-\u22BF\u22C4-\u22FF\u2305\u2306\u2322\u2323\u23B0\u23B1\u25A0\u25A1\u25AA\u25AB\u25AD-\u25B9\u25BC-\u25CF\u25D6\u25D7\u25E6\u2605\u2660-\u2663\u266D-\u266F\u2758\u2900-\u2909\u2911\u2914-\u2920\u2923-\u294D\u2962-\u296D\u2970-\u297F\u2981\u2982\u2999-\u29D9\u29DB-\u29FB\u29FE\u29FF\u2A0B-\u2A0F\u2A15-\u2ADB\u2ADD-\u2AFB\u2AFD\u2AFE])/,/^(?:\\ominus)/,/^(?:\\omicron)/,/^(?:\\Omega)/,/^(?:\\omega)/,/^(?:\\oint)/,/^(?:\\oiint)/,/^(?:\\oiiint)/,/^(?:\\odot)/,/^(?:\\odash)/,/^(?:\\obslash)/,/^(?:\\nwovnearrow)/,/^(?:\\nwarrow)/,/^(?:\\nVDash)/,/^(?:\\nVdash)/,/^(?:\\nvDash)/,/^(?:\\nvdash)/,/^(?:\u221E)/,/^(?:\\nu)/,/^(?:\\ntrianglerighteq)/,/^(?:\\ntriangleright)/,/^(?:\\ntrianglelefteq)/,/^(?:\\ntriangleleft)/,/^(?:\\nsupseteqq)/,/^(?:\\nsupseteq)/,/^(?:\\nsupset)/,/^(?:\\nsuccsim)/,/^(?:\\nsucceq)/,/^(?:\\nsucc)/,/^(?:\\nsubseteqq)/,/^(?:\\nsubseteq)/,/^(?:\\nsubset)/,/^(?:\\nsime)/,/^(?:\\nsim)/,/^(?:\\nshortparallel)/,/^(?:\\nshortmid)/,/^(?:\\nRightarrow)/,/^(?:\\nrightarrow)/,/^(?:\\npreceq)/,/^(?:\\nprec)/,/^(?:\\nparallel)/,/^(?:\\not\\supseteq)/,/^(?:\\not\\supset)/,/^(?:\\not\\succeq)/,/^(?:\\NotSucceedsTilde)/,/^(?:\\not\\succ)/,/^(?:\\not\\subseteq)/,/^(?:\\not\\subset)/,/^(?:\\NotSquareSuperset)/,/^(?:\\NotSquareSubset)/,/^(?:\\not\\sqsupseteq)/,/^(?:\\not\\sqsubseteq)/,/^(?:\\not\\simeq)/,/^(?:\\not\\sim)/,/^(?:\\NotRightTriangleBar)/,/^(?:\\not\\preceq)/,/^(?:\\not\\prec)/,/^(?:\\not\\ni)/,/^(?:\\notni)/,/^(?:\\NotNestedLessLess)/,/^(?:\\NotNestedGreaterGreater)/,/^(?:\\NotLessLess)/,/^(?:\\notlessgreater)/,/^(?:\\not\\leq)/,/^(?:\\NotLeftTriangleBar)/,/^(?:\\not\\le)/,/^(?:\\not\\kern-0\.3em\\times)/,/^(?:\\not\\in)/,/^(?:\\notin)/,/^(?:\\NotHumpEqual)/,/^(?:\\NotHumpDownHump)/,/^(?:\\notgreaterless)/,/^(?:\\NotGreaterGreater)/,/^(?:\\not\\geq)/,/^(?:\\not\\ge)/,/^(?:\\not\\equiv)/,/^(?:\\NotEqualTilde)/,/^(?:\\not\\cong)/,/^(?:\\not\\approx)/,/^(?:\\not>)/,/^(?:\\not<)/,/^(?:\\not)/,/^(?:\\nonit)/,/^(?:\\nmid)/,/^(?:\\nless)/,/^(?:\\nleqslant)/,/^(?:\\nleqq)/,/^(?:\\nleq)/,/^(?:\\nLeftrightarrow)/,/^(?:\\nleftrightarrow)/,/^(?:\\nLeftarrow)/,/^(?:\\nleftarrow)/,/^(?:\\ni)/,/^(?:\\ngtr)/,/^(?:\\ngeqslant)/,/^(?:\\ngeqq)/,/^(?:\\ngeq)/,/^(?:\\nexists)/,/^(?:\\NestedLessLess)/,/^(?:\\NestedGreaterGreater)/,/^(?:\\nequiv)/,/^(?:\\neqsim)/,/^(?:\\neq)/,/^(?:\\neovsearrow)/,/^(?:\\neovnwarrow)/,/^(?:\\negthickspace)/,/^(?:\\negspace)/,/^(?:\\negmedspace)/,/^(?:\\neg)/,/^(?:\\nearrow)/,/^(?:\\ne)/,/^(?:\\ncong)/,/^(?:\\nBumpeq)/,/^(?:\\nbumpeq)/,/^(?:\\natural)/,/^(?:\\napprox)/,/^(?:\\nabla)/,/^(?:\\multiscripts)/,/^(?:\\multimap)/,/^(?:\\mu)/,/^(?:\\mtext)/,/^(?:\\ms)/,/^(?:\\mp)/,/^(?:\\models)/,/^(?:\\models)/,/^(?:\\mod)/,/^(?:\\mo)/,/^(?:\\mn)/,/^(?:\\mlcp)/,/^(?:\\minusdot)/,/^(?:\\minusb)/,/^(?:\\minus)/,/^(?:\\min)/,/^(?:\\mid)/,/^(?:\\mi)/,/^(?:\\medspace)/,/^(?:\\measuredangle)/,/^(?:\\mathtt\{Z\})/,/^(?:\\mathtt\{z\})/,/^(?:\\mathtt\{Y\})/,/^(?:\\mathtt\{y\})/,/^(?:\\mathtt\{X\})/,/^(?:\\mathtt\{x\})/,/^(?:\\mathtt\{W\})/,/^(?:\\mathtt\{w\})/,/^(?:\\mathtt\{V\})/,/^(?:\\mathtt\{v\})/,/^(?:\\mathtt\{U\})/,/^(?:\\mathtt\{u\})/,/^(?:\\mathtt\{T\})/,/^(?:\\mathtt\{t\})/,/^(?:\\mathtt\{S\})/,/^(?:\\mathtt\{s\})/,/^(?:\\mathtt\{R\})/,/^(?:\\mathtt\{r\})/,/^(?:\\mathtt\{Q\})/,/^(?:\\mathtt\{q\})/,/^(?:\\mathtt\{P\})/,/^(?:\\mathtt\{p\})/,/^(?:\\mathtt\{O\})/,/^(?:\\mathtt\{o\})/,/^(?:\\mathtt\{N\})/,/^(?:\\mathtt\{n\})/,/^(?:\\mathtt\{M\})/,/^(?:\\mathtt\{m\})/,/^(?:\\mathtt\{L\})/,/^(?:\\mathtt\{l\})/,/^(?:\\mathtt\{K\})/,/^(?:\\mathtt\{k\})/,/^(?:\\mathtt\{J\})/,/^(?:\\mathtt\{j\})/,/^(?:\\mathtt\{I\})/,/^(?:\\mathtt\{i\})/,/^(?:\\mathtt\{H\})/,/^(?:\\mathtt\{h\})/,/^(?:\\mathtt\{G\})/,/^(?:\\mathtt\{g\})/,/^(?:\\mathtt\{F\})/,/^(?:\\mathtt\{f\})/,/^(?:\\mathtt\{E\})/,/^(?:\\mathtt\{e\})/,/^(?:\\mathtt\{D\})/,/^(?:\\mathtt\{d\})/,/^(?:\\mathtt\{C\})/,/^(?:\\mathtt\{c\})/,/^(?:\\mathtt\{B\})/,/^(?:\\mathtt\{b\})/,/^(?:\\mathtt\{A\})/,/^(?:\\mathtt\{a\})/,/^(?:\\mathtt)/,/^(?:\\mathsf\{Z\})/,/^(?:\\mathsf\{z\})/,/^(?:\\mathsf\{Y\})/,/^(?:\\mathsf\{y\})/,/^(?:\\mathsf\{X\})/,/^(?:\\mathsf\{x\})/,/^(?:\\mathsf\{W\})/,/^(?:\\mathsf\{w\})/,/^(?:\\mathsf\{V\})/,/^(?:\\mathsf\{v\})/,/^(?:\\mathsf\{U\})/,/^(?:\\mathsf\{u\})/,/^(?:\\mathsf\{T\})/,/^(?:\\mathsf\{t\})/,/^(?:\\mathsfsl\{Z\})/,/^(?:\\mathsfsl\{z\})/,/^(?:\\mathsfsl\{Y\})/,/^(?:\\mathsfsl\{y\})/,/^(?:\\mathsfsl\{X\})/,/^(?:\\mathsfsl\{x\})/,/^(?:\\mathsfsl\{W\})/,/^(?:\\mathsfsl\{w\})/,/^(?:\\mathsfsl\{V\})/,/^(?:\\mathsfsl\{v\})/,/^(?:\\mathsfsl\{U\})/,/^(?:\\mathsfsl\{u\})/,/^(?:\\mathsfsl\{T\})/,/^(?:\\mathsfsl\{t\})/,/^(?:\\mathsfsl\{S\})/,/^(?:\\mathsfsl\{s\})/,/^(?:\\mathsfsl\{R\})/,/^(?:\\mathsfsl\{r\})/,/^(?:\\mathsfsl\{Q\})/,/^(?:\\mathsfsl\{q\})/,/^(?:\\mathsfsl\{P\})/,/^(?:\\mathsfsl\{p\})/,/^(?:\\mathsfsl\{O\})/,/^(?:\\mathsfsl\{o\})/,/^(?:\\mathsfsl\{N\})/,/^(?:\\mathsfsl\{n\})/,/^(?:\\mathsfsl\{M\})/,/^(?:\\mathsfsl\{m\})/,/^(?:\\mathsfsl\{L\})/,/^(?:\\mathsfsl\{l\})/,/^(?:\\mathsfsl\{K\})/,/^(?:\\mathsfsl\{k\})/,/^(?:\\mathsfsl\{J\})/,/^(?:\\mathsfsl\{j\})/,/^(?:\\mathsfsl\{I\})/,/^(?:\\mathsfsl\{i\})/,/^(?:\\mathsfsl\{H\})/,/^(?:\\mathsfsl\{h\})/,/^(?:\\mathsfsl\{G\})/,/^(?:\\mathsfsl\{g\})/,/^(?:\\mathsfsl\{F\})/,/^(?:\\mathsfsl\{f\})/,/^(?:\\mathsfsl\{E\})/,/^(?:\\mathsfsl\{e\})/,/^(?:\\mathsfsl\{D\})/,/^(?:\\mathsfsl\{d\})/,/^(?:\\mathsfsl\{C\})/,/^(?:\\mathsfsl\{c\})/,/^(?:\\mathsfsl\{B\})/,/^(?:\\mathsfsl\{b\})/,/^(?:\\mathsfsl\{A\})/,/^(?:\\mathsfsl\{a\})/,/^(?:\\mathsf\{S\})/,/^(?:\\mathsf\{s\})/,/^(?:\\mathsf\{R\})/,/^(?:\\mathsf\{r\})/,/^(?:\\mathsf\{Q\})/,/^(?:\\mathsf\{q\})/,/^(?:\\mathsf\{P\})/,/^(?:\\mathsf\{p\})/,/^(?:\\mathsf\{O\})/,/^(?:\\mathsf\{o\})/,/^(?:\\mathsf\{N\})/,/^(?:\\mathsf\{n\})/,/^(?:\\mathsf\{M\})/,/^(?:\\mathsf\{m\})/,/^(?:\\mathsf\{L\})/,/^(?:\\mathsf\{l\})/,/^(?:\\mathsf\{K\})/,/^(?:\\mathsf\{k\})/,/^(?:\\mathsf\{J\})/,/^(?:\\mathsf\{j\})/,/^(?:\\mathsf\{I\})/,/^(?:\\mathsf\{i\})/,/^(?:\\mathsf\{H\})/,/^(?:\\mathsf\{h\})/,/^(?:\\mathsf\{G\})/,/^(?:\\mathsf\{g\})/,/^(?:\\mathsf\{F\})/,/^(?:\\mathsf\{f\})/,/^(?:\\mathsf\{E\})/,/^(?:\\mathsf\{e\})/,/^(?:\\mathsf\{D\})/,/^(?:\\mathsf\{d\})/,/^(?:\\mathsf\{C\})/,/^(?:\\mathsf\{c\})/,/^(?:\\mathsfbf\{\\Zeta\})/,/^(?:\\mathsfbf\{\\zeta\})/,/^(?:\\mathsfbf\{Z\})/,/^(?:\\mathsfbf\{z\})/,/^(?:\\mathsfbf\{Y\})/,/^(?:\\mathsfbf\{y\})/,/^(?:\\mathsfbf\{\\Xi\})/,/^(?:\\mathsfbf\{\\xi\})/,/^(?:\\mathsfbf\{X\})/,/^(?:\\mathsfbf\{x\})/,/^(?:\\mathsfbf\{W\})/,/^(?:\\mathsfbf\{w\})/,/^(?:\\mathsfbf\{\\vartheta\})/,/^(?:\\mathsfbf\{\\vartheta\})/,/^(?:\\mathsfbf\{\\varsigma\})/,/^(?:\\mathsfbf\{\\varrho\})/,/^(?:\\mathsfbf\{\\varpi\})/,/^(?:\\mathsfbf\{\\varkappa\})/,/^(?:\\mathsfbf\{V\})/,/^(?:\\mathsfbf\{v\})/,/^(?:\\mathsfbf\{\\Upsilon\})/,/^(?:\\mathsfbf\{\\upsilon\})/,/^(?:\\mathsfbf\{U\})/,/^(?:\\mathsfbf\{u\})/,/^(?:\\mathsfbf\{\\Theta\})/,/^(?:\\mathsfbf\{\\theta\})/,/^(?:\\mathsfbf\{\\Tau\})/,/^(?:\\mathsfbf\{\\tau\})/,/^(?:\\mathsfbf\{T\})/,/^(?:\\mathsfbf\{t\})/,/^(?:\\mathsfbfsl\{\\Zeta\})/,/^(?:\\mathsfbfsl\{\\zeta\})/,/^(?:\\mathsfbfsl\{Z\})/,/^(?:\\mathsfbfsl\{z\})/,/^(?:\\mathsfbfsl\{Y\})/,/^(?:\\mathsfbfsl\{y\})/,/^(?:\\mathsfbfsl\{\\Xi\})/,/^(?:\\mathsfbfsl\{\\xi\})/,/^(?:\\mathsfbfsl\{X\})/,/^(?:\\mathsfbfsl\{x\})/,/^(?:\\mathsfbfsl\{W\})/,/^(?:\\mathsfbfsl\{w\})/,/^(?:\\mathsfbfsl\{\\vartheta\})/,/^(?:\\mathsfbfsl\{\\vartheta\})/,/^(?:\\mathsfbfsl\{\\vartheta\})/,/^(?:\\mathsfbfsl\{\\vartheta\})/,/^(?:\\mathsfbfsl\{\\varsigma\})/,/^(?:\\mathsfbfsl\{\\varrho\})/,/^(?:\\mathsfbfsl\{\\varpi\})/,/^(?:\\mathsfbfsl\{\\varkappa\})/,/^(?:\\mathsfbfsl\{V\})/,/^(?:\\mathsfbfsl\{v\})/,/^(?:\\mathsfbfsl\{\\Upsilon\})/,/^(?:\\mathsfbfsl\{\\upsilon\})/,/^(?:\\mathsfbfsl\{U\})/,/^(?:\\mathsfbfsl\{u\})/,/^(?:\\mathsfbfsl\{\\Tau\})/,/^(?:\\mathsfbfsl\{\\tau\})/,/^(?:\\mathsfbfsl\{T\})/,/^(?:\\mathsfbfsl\{t\})/,/^(?:\\mathsfbfsl\{\\Sigma\})/,/^(?:\\mathsfbfsl\{\\sigma\})/,/^(?:\\mathsfbfsl\{S\})/,/^(?:\\mathsfbfsl\{s\})/,/^(?:\\mathsfbfsl\{\\Rho\})/,/^(?:\\mathsfbfsl\{\\Rho\})/,/^(?:\\mathsfbfsl\{R\})/,/^(?:\\mathsfbfsl\{r\})/,/^(?:\\mathsfbfsl\{Q\})/,/^(?:\\mathsfbfsl\{q\})/,/^(?:\\mathsfbfsl\{\\Psi\})/,/^(?:\\mathsfbfsl\{\\psi\})/,/^(?:\\mathsfbfsl\{\\Pi\})/,/^(?:\\mathsfbfsl\{\\pi\})/,/^(?:\\mathsfbfsl\{\\Phi\})/,/^(?:\\mathsfbfsl\{\\Phi\})/,/^(?:\\mathsfbfsl\{\\phi\})/,/^(?:\\mathsfbfsl\{P\})/,/^(?:\\mathsfbfsl\{p\})/,/^(?:\\mathsfbfsl\{\\Omega\})/,/^(?:\\mathsfbfsl\{\\Omega\})/,/^(?:\\mathsfbfsl\{O\})/,/^(?:\\mathsfbfsl\{o\})/,/^(?:\\mathsfbfsl\{\\nabla\})/,/^(?:\\mathsfbfsl\{N\})/,/^(?:\\mathsfbfsl\{n\})/,/^(?:\\mathsfbfsl\{M\})/,/^(?:\\mathsfbfsl\{m\})/,/^(?:\\mathsfbfsl\{\\Lambda\})/,/^(?:\\mathsfbfsl\{\\Lambda\})/,/^(?:\\mathsfbfsl\{L\})/,/^(?:\\mathsfbfsl\{l\})/,/^(?:\\mathsfbfsl\{\\Kappa\})/,/^(?:\\mathsfbfsl\{\\Kappa\})/,/^(?:\\mathsfbfsl\{K\})/,/^(?:\\mathsfbfsl\{k\})/,/^(?:\\mathsfbfsl\{J\})/,/^(?:\\mathsfbfsl\{j\})/,/^(?:\\mathsfbfsl\{\\Iota\})/,/^(?:\\mathsfbfsl\{\\Iota\})/,/^(?:\\mathsfbfsl\{I\})/,/^(?:\\mathsfbfsl\{i\})/,/^(?:\\mathsfbfsl\{H\})/,/^(?:\\mathsfbfsl\{h\})/,/^(?:\\mathsfbfsl\{\\Gamma\})/,/^(?:\\mathsfbfsl\{\\Gamma\})/,/^(?:\\mathsfbfsl\{G\})/,/^(?:\\mathsfbfsl\{g\})/,/^(?:\\mathsfbfsl\{F\})/,/^(?:\\mathsfbfsl\{f\})/,/^(?:\\mathsfbfsl\{\\Eta\})/,/^(?:\\mathsfbfsl\{\\eta\})/,/^(?:\\mathsfbfsl\{\\Epsilon\})/,/^(?:\\mathsfbfsl\{\\Epsilon\})/,/^(?:\\mathsfbfsl\{E\})/,/^(?:\\mathsfbfsl\{e\})/,/^(?:\\mathsfbfsl\{\\Delta\})/,/^(?:\\mathsfbfsl\{\\Delta\})/,/^(?:\\mathsfbfsl\{D\})/,/^(?:\\mathsfbfsl\{d\})/,/^(?:\\mathsfbfsl\{\\Chi\})/,/^(?:\\mathsfbfsl\{\\chi\})/,/^(?:\\mathsfbfsl\{C\})/,/^(?:\\mathsfbfsl\{c\})/,/^(?:\\mathsfbfsl\{\\Beta\})/,/^(?:\\mathsfbfsl\{\\beta\})/,/^(?:\\mathsfbfsl\{B\})/,/^(?:\\mathsfbfsl\{b\})/,/^(?:\\mathsfbfsl\{\\Alpha\})/,/^(?:\\mathsfbfsl\{\\alpha\})/,/^(?:\\mathsfbfsl\{A\})/,/^(?:\\mathsfbfsl\{a\})/,/^(?:\\mathsfbf\{\\Sigma\})/,/^(?:\\mathsfbf\{\\sigma\})/,/^(?:\\mathsfbf\{S\})/,/^(?:\\mathsfbf\{s\})/,/^(?:\\mathsfbf\{\\Rho\})/,/^(?:\\mathsfbf\{\\Rho\})/,/^(?:\\mathsfbf\{R\})/,/^(?:\\mathsfbf\{r\})/,/^(?:\\mathsfbf\{Q\})/,/^(?:\\mathsfbf\{q\})/,/^(?:\\mathsfbf\{\\Psi\})/,/^(?:\\mathsfbf\{\\Psi\})/,/^(?:\\mathsfbf\{\\Pi\})/,/^(?:\\mathsfbf\{\\Pi\})/,/^(?:\\mathsfbf\{\\Phi\})/,/^(?:\\mathsfbf\{\\phi\})/,/^(?:\\mathsfbf\{\\phi\})/,/^(?:\\mathsfbf\{P\})/,/^(?:\\mathsfbf\{p\})/,/^(?:\\mathsfbf\{\\Omega\})/,/^(?:\\mathsfbf\{\\Omega\})/,/^(?:\\mathsfbf\{O\})/,/^(?:\\mathsfbf\{o\})/,/^(?:\\mathsfbf\{\\nabla\})/,/^(?:\\mathsfbf\{N\})/,/^(?:\\mathsfbf\{n\})/,/^(?:\\mathsfbf\{M\})/,/^(?:\\mathsfbf\{m\})/,/^(?:\\mathsfbf\{\\Lambda\})/,/^(?:\\mathsfbf\{\\Lambda\})/,/^(?:\\mathsfbf\{L\})/,/^(?:\\mathsfbf\{l\})/,/^(?:\\mathsfbf\{\\Kappa\})/,/^(?:\\mathsfbf\{\\Kappa\})/,/^(?:\\mathsfbf\{K\})/,/^(?:\\mathsfbf\{k\})/,/^(?:\\mathsfbf\{J\})/,/^(?:\\mathsfbf\{j\})/,/^(?:\\mathsfbf\{\\Iota\})/,/^(?:\\mathsfbf\{\\Iota\})/,/^(?:\\mathsfbf\{I\})/,/^(?:\\mathsfbf\{i\})/,/^(?:\\mathsfbf\{H\})/,/^(?:\\mathsfbf\{h\})/,/^(?:\\mathsfbf\{\\Gamma\})/,/^(?:\\mathsfbf\{\\Gamma\})/,/^(?:\\mathsfbf\{G\})/,/^(?:\\mathsfbf\{g\})/,/^(?:\\mathsfbf\{F\})/,/^(?:\\mathsfbf\{f\})/,/^(?:\\mathsfbf\{\\Eta\})/,/^(?:\\mathsfbf\{\\Eta\})/,/^(?:\\mathsfbf\{\\Epsilon\})/,/^(?:\\mathsfbf\{\\epsilon\})/,/^(?:\\mathsfbf\{E\})/,/^(?:\\mathsfbf\{e\})/,/^(?:\\mathsfbf\{\\Delta\})/,/^(?:\\mathsfbf\{\\Delta\})/,/^(?:\\mathsfbf\{D\})/,/^(?:\\mathsfbf\{d\})/,/^(?:\\mathsfbf\{\\Chi\})/,/^(?:\\mathsfbf\{\\Chi\})/,/^(?:\\mathsfbf\{C\})/,/^(?:\\mathsfbf\{c\})/,/^(?:\\mathsfbf\{\\Beta\})/,/^(?:\\mathsfbf\{\\beta\})/,/^(?:\\mathsfbf\{B\})/,/^(?:\\mathsfbf\{b\})/,/^(?:\\mathsfbf\{\\Alpha\})/,/^(?:\\mathsfbf\{\\alpha\})/,/^(?:\\mathsfbf\{A\})/,/^(?:\\mathsfbf\{a\})/,/^(?:\\mathsf\{B\})/,/^(?:\\mathsf\{b\})/,/^(?:\\mathsf\{A\})/,/^(?:\\mathsf\{a\})/,/^(?:\\mathsf)/,/^(?:\\mathscr\{Z\})/,/^(?:\\mathscr\{z\})/,/^(?:\\mathscr\{Y\})/,/^(?:\\mathscr\{y\})/,/^(?:\\mathscr\{X\})/,/^(?:\\mathscr\{x\})/,/^(?:\\mathscr\{W\})/,/^(?:\\mathscr\{w\})/,/^(?:\\mathscr\{V\})/,/^(?:\\mathscr\{v\})/,/^(?:\\mathscr\{U\})/,/^(?:\\mathscr\{u\})/,/^(?:\\mathscr\{T\})/,/^(?:\\mathscr\{t\})/,/^(?:\\mathscr\{S\})/,/^(?:\\mathscr\{s\})/,/^(?:\\mathscr\{R\})/,/^(?:\\mathscr\{r\})/,/^(?:\\mathscr\{Q\})/,/^(?:\\mathscr\{q\})/,/^(?:\\mathscr\{P\})/,/^(?:\\mathscr\{p\})/,/^(?:\\mathscr\{O\})/,/^(?:\\mathscr\{o\})/,/^(?:\\mathscr\{N\})/,/^(?:\\mathscr\{n\})/,/^(?:\\mathscr\{M\})/,/^(?:\\mathscr\{m\})/,/^(?:\\mathscr\{L\})/,/^(?:\\mathscr\{l\})/,/^(?:\\mathscr\{K\})/,/^(?:\\mathscr\{k\})/,/^(?:\\mathscr\{J\})/,/^(?:\\mathscr\{j\})/,/^(?:\\mathscr\{I\})/,/^(?:\\mathscr\{i\})/,/^(?:\\mathscr\{H\})/,/^(?:\\mathscr\{h\})/,/^(?:\\mathscr\{G\})/,/^(?:\\mathscr\{g\})/,/^(?:\\mathscr\{F\})/,/^(?:\\mathscr\{f\})/,/^(?:\\mathscr\{E\})/,/^(?:\\mathscr\{e\})/,/^(?:\\mathscr\{D\})/,/^(?:\\mathscr\{d\})/,/^(?:\\mathscr\{C\})/,/^(?:\\mathscr\{c\})/,/^(?:\\mathscr\{B\})/,/^(?:\\mathscr\{b\})/,/^(?:\\mathscr\{A\})/,/^(?:\\mathscr\{a\})/,/^(?:\\mathscr)/,/^(?:\\mathrm)/,/^(?:\\mathrlap)/,/^(?:\\mathring\{\})/,/^(?:\\mathrel)/,/^(?:\\mathraisebox)/,/^(?:\\mathop)/,/^(?:\\mathmit\{\\Zeta\})/,/^(?:\\mathmit\{\\zeta\})/,/^(?:\\mathmit\{Z\})/,/^(?:\\mathmit\{z\})/,/^(?:\\mathmit\{Y\})/,/^(?:\\mathmit\{y\})/,/^(?:\\mathmit\{\\Xi\})/,/^(?:\\mathmit\{\\xi\})/,/^(?:\\mathmit\{X\})/,/^(?:\\mathmit\{x\})/,/^(?:\\mathmit\{W\})/,/^(?:\\mathmit\{w\})/,/^(?:\\mathmit\{\\vartheta\})/,/^(?:\\mathmit\{\\vartheta\})/,/^(?:\\mathmit\{\\varsigma\})/,/^(?:\\mathmit\{\\varrho\})/,/^(?:\\mathmit\{\\varpi\})/,/^(?:\\mathmit\{\\varkappa\})/,/^(?:\\mathmit\{V\})/,/^(?:\\mathmit\{v\})/,/^(?:\\mathmit\{\\Upsilon\})/,/^(?:\\mathmit\{\\upsilon\})/,/^(?:\\mathmit\{U\})/,/^(?:\\mathmit\{u\})/,/^(?:\\mathmit\{\\Theta\})/,/^(?:\\mathmit\{\\theta\})/,/^(?:\\mathmit\{\\Tau\})/,/^(?:\\mathmit\{\\tau\})/,/^(?:\\mathmit\{T\})/,/^(?:\\mathmit\{t\})/,/^(?:\\mathmit\{\\Sigma\})/,/^(?:\\mathmit\{\\sigma\})/,/^(?:\\mathmit\{S\})/,/^(?:\\mathmit\{s\})/,/^(?:\\mathmit\{\\Rho\})/,/^(?:\\mathmit\{\\rho\})/,/^(?:\\mathmit\{R\})/,/^(?:\\mathmit\{r\})/,/^(?:\\mathmit\{Q\})/,/^(?:\\mathmit\{q\})/,/^(?:\\mathmit\{\\Psi\})/,/^(?:\\mathmit\{\\Psi\})/,/^(?:\\mathmit\{\\Pi\})/,/^(?:\\mathmit\{\\Pi\})/,/^(?:\\mathmit\{\\Phi\})/,/^(?:\\mathmit\{\\Phi\})/,/^(?:\\mathmit\{\\phi\})/,/^(?:\\mathmit\{P\})/,/^(?:\\mathmit\{p\})/,/^(?:\\mathmit\{\\Omega\})/,/^(?:\\mathmit\{\\Omega\})/,/^(?:\\mathmit\{O\})/,/^(?:\\mathmit\{o\})/,/^(?:\\mathmit\{\\nabla\})/,/^(?:\\mathmit\{N\})/,/^(?:\\mathmit\{n\})/,/^(?:\\mathmit\{M\})/,/^(?:\\mathmit\{m\})/,/^(?:\\mathmit\{\\Lambda\})/,/^(?:\\mathmit\{\\lambda\})/,/^(?:\\mathmit\{L\})/,/^(?:\\mathmit\{l\})/,/^(?:\\mathmit\{\\Kappa\})/,/^(?:\\mathmit\{\\Kappa\})/,/^(?:\\mathmit\{K\})/,/^(?:\\mathmit\{k\})/,/^(?:\\mathmit\{J\})/,/^(?:\\mathmit\{j\})/,/^(?:\\mathmit\{\\Iota\})/,/^(?:\\mathmit\{\\Iota\})/,/^(?:\\mathmit\{I\})/,/^(?:\\mathmit\{i\})/,/^(?:\\mathmit\{H\})/,/^(?:\\mathmit\{\\Gamma\})/,/^(?:\\mathmit\{\\Gamma\})/,/^(?:\\mathmit\{G\})/,/^(?:\\mathmit\{g\})/,/^(?:\\mathmit\{F\})/,/^(?:\\mathmit\{f\})/,/^(?:\\mathmit\{\\Eta\})/,/^(?:\\mathmit\{\\eta\})/,/^(?:\\mathmit\{\\Epsilon\})/,/^(?:\\mathmit\{\\Epsilon\})/,/^(?:\\mathmit\{E\})/,/^(?:\\mathmit\{e\})/,/^(?:\\mathmit\{\\Delta\})/,/^(?:\\mathmit\{\\delta\})/,/^(?:\\mathmit\{D\})/,/^(?:\\mathmit\{d\})/,/^(?:\\mathmit\{\\Chi\})/,/^(?:\\mathmit\{\\chi\})/,/^(?:\\mathmit\{C\})/,/^(?:\\mathmit\{c\})/,/^(?:\\mathmit\{\\Beta\})/,/^(?:\\mathmit\{\\beta\})/,/^(?:\\mathmit\{B\})/,/^(?:\\mathmit\{b\})/,/^(?:\\mathmit\{\\Alpha\})/,/^(?:\\mathmit\{\\alpha\})/,/^(?:\\mathmit\{A\})/,/^(?:\\mathmit\{a\})/,/^(?:\\mathmit)/,/^(?:\\mathllap)/,/^(?:\\mathit)/,/^(?:\\mathfrak\{Z\})/,/^(?:\\mathfrak\{z\})/,/^(?:\\mathfrak\{Y\})/,/^(?:\\mathfrak\{y\})/,/^(?:\\mathfrak\{X\})/,/^(?:\\mathfrak\{x\})/,/^(?:\\mathfrak\{W\})/,/^(?:\\mathfrak\{w\})/,/^(?:\\mathfrak\{V\})/,/^(?:\\mathfrak\{v\})/,/^(?:\\mathfrak\{U\})/,/^(?:\\mathfrak\{u\})/,/^(?:\\mathfrak\{T\})/,/^(?:\\mathfrak\{t\})/,/^(?:\\mathfrak\{S\})/,/^(?:\\mathfrak\{s\})/,/^(?:\\mathfrak\{R\})/,/^(?:\\mathfrak\{r\})/,/^(?:\\mathfrak\{Q\})/,/^(?:\\mathfrak\{q\})/,/^(?:\\mathfrak\{P\})/,/^(?:\\mathfrak\{p\})/,/^(?:\\mathfrak\{O\})/,/^(?:\\mathfrak\{o\})/,/^(?:\\mathfrak\{N\})/,/^(?:\\mathfrak\{n\})/,/^(?:\\mathfrak\{M\})/,/^(?:\\mathfrak\{m\})/,/^(?:\\mathfrak\{L\})/,/^(?:\\mathfrak\{l\})/,/^(?:\\mathfrak\{K\})/,/^(?:\\mathfrak\{k\})/,/^(?:\\mathfrak\{J\})/,/^(?:\\mathfrak\{j\})/,/^(?:\\mathfrak\{I\})/,/^(?:\\mathfrak\{i\})/,/^(?:\\mathfrak\{H\})/,/^(?:\\mathfrak\{h\})/,/^(?:\\mathfrak\{G\})/,/^(?:\\mathfrak\{g\})/,/^(?:\\mathfrak\{F\})/,/^(?:\\mathfrak\{f\})/,/^(?:\\mathfrak\{E\})/,/^(?:\\mathfrak\{e\})/,/^(?:\\mathfrak\{D\})/,/^(?:\\mathfrak\{d\})/,/^(?:\\mathfrak\{C\})/,/^(?:\\mathfrak\{c\})/,/^(?:\\mathfrak\{B\})/,/^(?:\\mathfrak\{b\})/,/^(?:\\mathfrak\{A\})/,/^(?:\\mathfrak\{a\})/,/^(?:\\mathfrak)/,/^(?:\\mathfr)/,/^(?:\\mathclap)/,/^(?:\\mathcal)/,/^(?:\\mathbscr)/,/^(?:\\mathbit\{\\Zeta\})/,/^(?:\\mathbit\{\\zeta\})/,/^(?:\\mathbit\{Z\})/,/^(?:\\mathbit\{z\})/,/^(?:\\mathbit\{Y\})/,/^(?:\\mathbit\{y\})/,/^(?:\\mathbit\{\\Xi\})/,/^(?:\\mathbit\{\\xi\})/,/^(?:\\mathbit\{X\})/,/^(?:\\mathbit\{x\})/,/^(?:\\mathbit\{W\})/,/^(?:\\mathbit\{w\})/,/^(?:\\mathbit\{\\vartheta\})/,/^(?:\\mathbit\{\\varsigma\})/,/^(?:\\mathbit\{\\varrho\})/,/^(?:\\mathbit\{\\varpi\})/,/^(?:\\mathbit\{\\varkappa\})/,/^(?:\\mathbit\{V\})/,/^(?:\\mathbit\{v\})/,/^(?:\\mathbit\{\\Upsilon\})/,/^(?:\\mathbit\{\\upsilon\})/,/^(?:\\mathbit\{U\})/,/^(?:\\mathbit\{u\})/,/^(?:\\mathbit\{\\Theta\})/,/^(?:\\mathbit\{\\Theta\})/,/^(?:\\mathbit\{\\theta\})/,/^(?:\\mathbit\{\\Tau\})/,/^(?:\\mathbit\{\\tau\})/,/^(?:\\mathbit\{T\})/,/^(?:\\mathbit\{t\})/,/^(?:\\mathbit\{\\Sigma\})/,/^(?:\\mathbit\{\\sigma\})/,/^(?:\\mathbit\{S\})/,/^(?:\\mathbit\{s\})/,/^(?:\\mathbit\{\\Rho\})/,/^(?:\\mathbit\{\\Rho\})/,/^(?:\\mathbit\{R\})/,/^(?:\\mathbit\{r\})/,/^(?:\\mathbit\{Q\})/,/^(?:\\mathbit\{q\})/,/^(?:\\mathbit\{\\Psi\})/,/^(?:\\mathbit\{\\Psi\})/,/^(?:\\mathbit\{\\Pi\})/,/^(?:\\mathbit\{\\Pi\})/,/^(?:\\mathbit\{\\Phi\})/,/^(?:\\mathbit\{\\Phi\})/,/^(?:\\mathbit\{\\phi\})/,/^(?:\\mathbit\{P\})/,/^(?:\\mathbit\{p\})/,/^(?:\\mathbit\{\\Omega\})/,/^(?:\\mathbit\{\\omega\})/,/^(?:\\mathbit\{O\})/,/^(?:\\mathbit\{o\})/,/^(?:\\mathbit\{\\nabla\})/,/^(?:\\mathbit\{N\})/,/^(?:\\mathbit\{n\})/,/^(?:\\mathbit\{M\})/,/^(?:\\mathbit\{m\})/,/^(?:\\mathbit\{\\Lambda\})/,/^(?:\\mathbit\{\\Lambda\})/,/^(?:\\mathbit\{L\})/,/^(?:\\mathbit\{l\})/,/^(?:\\mathbit\{\\Kappa\})/,/^(?:\\mathbit\{\\kappa\})/,/^(?:\\mathbit\{K\})/,/^(?:\\mathbit\{k\})/,/^(?:\\mathbit\{J\})/,/^(?:\\mathbit\{j\})/,/^(?:\\mathbit\{\\Iota\})/,/^(?:\\mathbit\{\\iota\})/,/^(?:\\mathbit\{I\})/,/^(?:\\mathbit\{i\})/,/^(?:\\mathbit\{H\})/,/^(?:\\mathbit\{h\})/,/^(?:\\mathbit\{\\Gamma\})/,/^(?:\\mathbit\{\\gamma\})/,/^(?:\\mathbit\{G\})/,/^(?:\\mathbit\{g\})/,/^(?:\\mathbit\{F\})/,/^(?:\\mathbit\{f\})/,/^(?:\\mathbit\{\\Eta\})/,/^(?:\\mathbit\{\\Eta\})/,/^(?:\\mathbit\{\\Epsilon\})/,/^(?:\\mathbit\{\\epsilon\})/,/^(?:\\mathbit\{E\})/,/^(?:\\mathbit\{e\})/,/^(?:\\mathbit\{\\Delta\})/,/^(?:\\mathbit\{\\delta\})/,/^(?:\\mathbit\{D\})/,/^(?:\\mathbit\{d\})/,/^(?:\\mathbit\{\\Chi\})/,/^(?:\\mathbit\{\\Chi\})/,/^(?:\\mathbit\{C\})/,/^(?:\\mathbit\{c\})/,/^(?:\\mathbit\{\\Beta\})/,/^(?:\\mathbit\{\\beta\})/,/^(?:\\mathbit\{B\})/,/^(?:\\mathbit\{b\})/,/^(?:\\mathbit\{\\Alpha\})/,/^(?:\\mathbit\{\\alpha\})/,/^(?:\\mathbit\{A\})/,/^(?:\\mathbit\{a\})/,/^(?:\\mathbit)/,/^(?:\\mathbin\{\{:\}\\!\\!\{-\}\\!\\!\{:\}\})/,/^(?:\\mathbin)/,/^(?:\\mathbf\{\\Zeta\})/,/^(?:\\mathbf\{\\zeta\})/,/^(?:\\mathbf\{Z\})/,/^(?:\\mathbf\{z\})/,/^(?:\\mathbf\{Y\})/,/^(?:\\mathbf\{y\})/,/^(?:\\mathbf\{\\Xi\})/,/^(?:\\mathbf\{\\xi\})/,/^(?:\\mathbf\{X\})/,/^(?:\\mathbf\{x\})/,/^(?:\\mathbf\{W\})/,/^(?:\\mathbf\{w\})/,/^(?:\\mathbf\{\\Vartheta\})/,/^(?:\\mathbf\{\\vartheta\})/,/^(?:\\mathbf\{\\varsigma\})/,/^(?:\\mathbf\{\\varrho\})/,/^(?:\\mathbf\{\\varpi\})/,/^(?:\\mathbf\{\\varkappa\})/,/^(?:\\mathbf\{V\})/,/^(?:\\mathbf\{v\})/,/^(?:\\mathbf\{\\Upsilon\})/,/^(?:\\mathbf\{\\upsilon\})/,/^(?:\\mathbf\{U\})/,/^(?:\\mathbf\{u\})/,/^(?:\\mathbf\{\\Theta\})/,/^(?:\\mathbf\{\\theta\})/,/^(?:\\mathbf\{\\Tau\})/,/^(?:\\mathbf\{\\tau\})/,/^(?:\\mathbf\{T\})/,/^(?:\\mathbf\{t\})/,/^(?:\\mathbf\{\\Sigma\})/,/^(?:\\mathbf\{\\sigma\})/,/^(?:\\mathbf\{S\})/,/^(?:\\mathbf\{s\})/,/^(?:\\mathbf\{\\Rho\})/,/^(?:\\mathbf\{\\rho\})/,/^(?:\\mathbfrak\{Z\})/,/^(?:\\mathbfrak\{z\})/,/^(?:\\mathbfrak\{Y\})/,/^(?:\\mathbfrak\{y\})/,/^(?:\\mathbfrak\{X\})/,/^(?:\\mathbfrak\{x\})/,/^(?:\\mathbfrak\{W\})/,/^(?:\\mathbfrak\{w\})/,/^(?:\\mathbfrak\{V\})/,/^(?:\\mathbfrak\{v\})/,/^(?:\\mathbfrak\{U\})/,/^(?:\\mathbfrak\{u\})/,/^(?:\\mathbfrak\{T\})/,/^(?:\\mathbfrak\{t\})/,/^(?:\\mathbfrak\{S\})/,/^(?:\\mathbfrak\{s\})/,/^(?:\\mathbfrak\{R\})/,/^(?:\\mathbfrak\{r\})/,/^(?:\\mathbfrak\{Q\})/,/^(?:\\mathbfrak\{q\})/,/^(?:\\mathbfrak\{P\})/,/^(?:\\mathbfrak\{p\})/,/^(?:\\mathbfrak\{O\})/,/^(?:\\mathbfrak\{o\})/,/^(?:\\mathbfrak\{N\})/,/^(?:\\mathbfrak\{n\})/,/^(?:\\mathbfrak\{M\})/,/^(?:\\mathbfrak\{m\})/,/^(?:\\mathbfrak\{L\})/,/^(?:\\mathbfrak\{l\})/,/^(?:\\mathbfrak\{K\})/,/^(?:\\mathbfrak\{k\})/,/^(?:\\mathbfrak\{J\})/,/^(?:\\mathbfrak\{j\})/,/^(?:\\mathbfrak\{I\})/,/^(?:\\mathbfrak\{i\})/,/^(?:\\mathbfrak\{H\})/,/^(?:\\mathbfrak\{h\})/,/^(?:\\mathbfrak\{G\})/,/^(?:\\mathbfrak\{g\})/,/^(?:\\mathbfrak\{F\})/,/^(?:\\mathbfrak\{f\})/,/^(?:\\mathbfrak\{E\})/,/^(?:\\mathbfrak\{e\})/,/^(?:\\mathbfrak\{D\})/,/^(?:\\mathbfrak\{d\})/,/^(?:\\mathbfrak\{C\})/,/^(?:\\mathbfrak\{c\})/,/^(?:\\mathbfrak\{B\})/,/^(?:\\mathbfrak\{b\})/,/^(?:\\mathbfrak\{A\})/,/^(?:\\mathbfrak\{a\})/,/^(?:\\mathbf\{R\})/,/^(?:\\mathbf\{r\})/,/^(?:\\mathbf\{Q\})/,/^(?:\\mathbf\{q\})/,/^(?:\\mathbf\{\\Psi\})/,/^(?:\\mathbf\{\\psi\})/,/^(?:\\mathbf\{\\Pi\})/,/^(?:\\mathbf\{\\pi\})/,/^(?:\\mathbf\{\\Phi\})/,/^(?:\\mathbf\{\\phi\})/,/^(?:\\mathbf\{\\phi\})/,/^(?:\\mathbf\{P\})/,/^(?:\\mathbf\{p\})/,/^(?:\\mathbf\{\\Omega\})/,/^(?:\\mathbf\{\\omega\})/,/^(?:\\mathbf\{O\})/,/^(?:\\mathbf\{o\})/,/^(?:\\mathbf\{\\nabla\})/,/^(?:\\mathbf\{N\})/,/^(?:\\mathbf\{n\})/,/^(?:\\mathbf\{M\})/,/^(?:\\mathbf\{m\})/,/^(?:\\mathbf\{\\Lambda\})/,/^(?:\\mathbf\{\\lambda\})/,/^(?:\\mathbf\{L\})/,/^(?:\\mathbf\{l\})/,/^(?:\\mathbf\{\\Kappa\})/,/^(?:\\mathbf\{\\kappa\})/,/^(?:\\mathbf\{K\})/,/^(?:\\mathbf\{k\})/,/^(?:\\mathbf\{J\})/,/^(?:\\mathbf\{j\})/,/^(?:\\mathbf\{\\Iota\})/,/^(?:\\mathbf\{\\iota\})/,/^(?:\\mathbf\{I\})/,/^(?:\\mathbf\{i\})/,/^(?:\\mathbf\{H\})/,/^(?:\\mathbf\{h\})/,/^(?:\\mathbf\{\\Gamma\})/,/^(?:\\mathbf\{\\gamma\})/,/^(?:\\mathbf\{G\})/,/^(?:\\mathbf\{g\})/,/^(?:\\mathbf\{F\})/,/^(?:\\mathbf\{f\})/,/^(?:\\mathbf\{\\Eta\})/,/^(?:\\mathbf\{\\Eta\})/,/^(?:\\mathbf\{\\Epsilon\})/,/^(?:\\mathbf\{\\Epsilon\})/,/^(?:\\mathbf\{E\})/,/^(?:\\mathbf\{e\})/,/^(?:\\mathbf\{\\Delta\})/,/^(?:\\mathbf\{\\Delta\})/,/^(?:\\mathbf\{D\})/,/^(?:\\mathbf\{d\})/,/^(?:\\mathbf\{\\Chi\})/,/^(?:\\mathbf\{\\chi\})/,/^(?:\\mathbf\{C\})/,/^(?:\\mathbf\{c\})/,/^(?:\\mathbf\{\\Beta\})/,/^(?:\\mathbf\{\\beta\})/,/^(?:\\mathbf\{B\})/,/^(?:\\mathbf\{b\})/,/^(?:\\mathbf\{\\Alpha\})/,/^(?:\\mathbf\{\\alpha\})/,/^(?:\\mathbf\{A\})/,/^(?:\\mathbf\{a\})/,/^(?:\\mathbf)/,/^(?:\\mathbcal\{Z\})/,/^(?:\\mathbcal\{z\})/,/^(?:\\mathbcal\{Y\})/,/^(?:\\mathbcal\{y\})/,/^(?:\\mathbcal\{X\})/,/^(?:\\mathbcal\{x\})/,/^(?:\\mathbcal\{W\})/,/^(?:\\mathbcal\{w\})/,/^(?:\\mathbcal\{V\})/,/^(?:\\mathbcal\{v\})/,/^(?:\\mathbcal\{U\})/,/^(?:\\mathbcal\{u\})/,/^(?:\\mathbcal\{T\})/,/^(?:\\mathbcal\{t\})/,/^(?:\\mathbcal\{S\})/,/^(?:\\mathbcal\{s\})/,/^(?:\\mathbcal\{R\})/,/^(?:\\mathbcal\{r\})/,/^(?:\\mathbcal\{Q\})/,/^(?:\\mathbcal\{q\})/,/^(?:\\mathbcal\{P\})/,/^(?:\\mathbcal\{p\})/,/^(?:\\mathbcal\{O\})/,/^(?:\\mathbcal\{o\})/,/^(?:\\mathbcal\{N\})/,/^(?:\\mathbcal\{n\})/,/^(?:\\mathbcal\{M\})/,/^(?:\\mathbcal\{m\})/,/^(?:\\mathbcal\{L\})/,/^(?:\\mathbcal\{l\})/,/^(?:\\mathbcal\{K\})/,/^(?:\\mathbcal\{k\})/,/^(?:\\mathbcal\{J\})/,/^(?:\\mathbcal\{j\})/,/^(?:\\mathbcal\{I\})/,/^(?:\\mathbcal\{i\})/,/^(?:\\mathbcal\{H\})/,/^(?:\\mathbcal\{h\})/,/^(?:\\mathbcal\{G\})/,/^(?:\\mathbcal\{g\})/,/^(?:\\mathbcal\{F\})/,/^(?:\\mathbcal\{f\})/,/^(?:\\mathbcal\{E\})/,/^(?:\\mathbcal\{e\})/,/^(?:\\mathbcal\{D\})/,/^(?:\\mathbcal\{d\})/,/^(?:\\mathbcal\{C\})/,/^(?:\\mathbcal\{c\})/,/^(?:\\mathbcal\{B\})/,/^(?:\\mathbcal\{b\})/,/^(?:\\mathbcal\{A\})/,/^(?:\\mathbcal\{a\})/,/^(?:\\mathbcal)/,/^(?:\\mathbb\{Z\})/,/^(?:\\mathbb\{z\})/,/^(?:\\mathbb\{Y\})/,/^(?:\\mathbb\{y\})/,/^(?:\\mathbb\{X\})/,/^(?:\\mathbb\{x\})/,/^(?:\\mathbb\{W\})/,/^(?:\\mathbb\{w\})/,/^(?:\\mathbb\{V\})/,/^(?:\\mathbb\{v\})/,/^(?:\\mathbb\{U\})/,/^(?:\\mathbb\{u\})/,/^(?:\\mathbb\{T\})/,/^(?:\\mathbb\{t\})/,/^(?:\\mathbb\{S\})/,/^(?:\\mathbb\{s\})/,/^(?:\\mathbb\{R\})/,/^(?:\\mathbb\{r\})/,/^(?:\\mathbb\{Q\})/,/^(?:\\mathbb\{q\})/,/^(?:\\mathbb\{P\})/,/^(?:\\mathbb\{p\})/,/^(?:\\mathbb\{O\})/,/^(?:\\mathbb\{o\})/,/^(?:\\mathbb\{N\})/,/^(?:\\mathbb\{n\})/,/^(?:\\mathbb\{M\})/,/^(?:\\mathbb\{m\})/,/^(?:\\mathbb\{L\})/,/^(?:\\mathbb\{l\})/,/^(?:\\mathbb\{K\})/,/^(?:\\mathbb\{k\})/,/^(?:\\mathbb\{J\})/,/^(?:\\mathbb\{j\})/,/^(?:\\mathbb\{I\})/,/^(?:\\mathbb\{i\})/,/^(?:\\mathbb\{H\})/,/^(?:\\mathbb\{h\})/,/^(?:\\mathbb\{G\})/,/^(?:\\mathbb\{g\})/,/^(?:\\mathbb\{F\})/,/^(?:\\mathbb\{f\})/,/^(?:\\mathbb\{E\})/,/^(?:\\mathbb\{e\})/,/^(?:\\mathbb\{D\})/,/^(?:\\mathbb\{d\})/,/^(?:\\mathbb\{C\})/,/^(?:\\mathbb\{c\})/,/^(?:\\mathbb\{B\})/,/^(?:\\mathbb\{b\})/,/^(?:\\mathbb\{A\})/,/^(?:\\mathbb\{a\})/,/^(?:\\mathbb)/,/^(?:\\Mapsto)/,/^(?:\\mapsto)/,/^(?:\\Mapsfrom)/,/^(?:\\map)/,/^(?:\\lvertneqq)/,/^(?:\\lvertneqq)/,/^(?:\\ltimes)/,/^(?:\\lt)/,/^(?:\\Lsh)/,/^(?:\\lq)/,/^(?:\\lozenge)/,/^(?:\\lowint)/,/^(?:\\looparrowright)/,/^(?:\\looparrowleft)/,/^(?:\\Longrightarrow)/,/^(?:\\longrightarrow)/,/^(?:\\longmapsto)/,/^(?:\\Longleftrightarrow)/,/^(?:\\longleftrightarrow)/,/^(?:\\Longleftarrow)/,/^(?:\\longleftarrow)/,/^(?:\\lnsim)/,/^(?:\\lnot)/,/^(?:\\lneqq)/,/^(?:\\lneq)/,/^(?:\\lneq)/,/^(?:\\lnapprox)/,/^(?:\\lmoustache)/,/^(?:\\lll)/,/^(?:\\Lleftarrow)/,/^(?:\\llangle)/,/^(?:\\ll)/,/^(?:\\lhd)/,/^(?:\\lfloor)/,/^(?:\\lesssim)/,/^(?:\\lessgtr)/,/^(?:\\lessequivlnt)/,/^(?:\\lesseqqgtr)/,/^(?:\\lesseqqgtr)/,/^(?:\\lesseqgtr)/,/^(?:\\lessdot)/,/^(?:\\lessapprox)/,/^(?:\\less)/,/^(?:\\leqslant)/,/^(?:\\leqq)/,/^(?:\\leq)/,/^(?:\\LeftVectorBar)/,/^(?:\\LeftUpVectorBar)/,/^(?:\\LeftUpTeeVector)/,/^(?:\\LeftUpDownVector)/,/^(?:\\LeftTriangleBar)/,/^(?:\\leftthreetimes)/,/^(?:\\LeftTeeVector)/,/^(?:\\leftsquigarrow)/,/^(?:\\LeftRightVector)/,/^(?:\\leftrightsquigarrow)/,/^(?:\\leftrightharpoons)/,/^(?:\\leftrightarrowtria\*)/,/^(?:\\leftrightarrows)/,/^(?:\\Leftrightarrow)/,/^(?:\\leftrightarrow)/,/^(?:\\leftleftarrows)/,/^(?:\\leftharpoonup)/,/^(?:\\leftharpoondown)/,/^(?:\\LeftDownVectorBar)/,/^(?:\\LeftDownTeeVector)/,/^(?:\\leftarrowtriangle)/,/^(?:\\leftarrowtail)/,/^(?:\\Leftarrow)/,/^(?:\\leftarrow)/,/^(?:\\left)/,/^(?:\\le)/,/^(?:\\ldots)/,/^(?:\\ldotp)/,/^(?:\\lceil)/,/^(?:\\lbrack)/,/^(?:\\lbrace)/,/^(?:\\lazysinv)/,/^(?:\\langle)/,/^(?:\\lang)/,/^(?:\\Lambda)/,/^(?:\\lambda)/,/^(?:\\kernelcontraction)/,/^(?:<\\kern-0\.58em\()/,/^(?:\\Kappa)/,/^(?:\\kappa)/,/^(?:\\jmath)/,/^(?:\\itexnum)/,/^(?:\\Iota)/,/^(?:\\iota)/,/^(?:\\invamp)/,/^(?:\\intx)/,/^(?:\\intprodr)/,/^(?:\\intprod)/,/^(?:\\int\\!\\int\\!\\int)/,/^(?:\\int\\!\\int)/,/^(?:\\Intersection)/,/^(?:\\intersection)/,/^(?:\\interleave)/,/^(?:\\intercal)/,/^(?:\\integral)/,/^(?:\\intcup)/,/^(?:\\intcap)/,/^(?:\\intBar)/,/^(?:\\intbar)/,/^(?:\\int)/,/^(?:\\infty)/,/^(?:\\infinity)/,/^(?:\\inf)/,/^(?:\\in)/,/^(?:\\in)/,/^(?:\\imath)/,/^(?:\\image)/,/^(?:\\Im)/,/^(?:\\iint)/,/^(?:\\iiint)/,/^(?:\\iiiint)/,/^(?:\\i)/,/^(?:\\hslash)/,/^(?:\\href)/,/^(?:\\hookrightarrow)/,/^(?:\\hookleftarrow)/,/^(?:\\homothetic)/,/^(?:\\hkswarow)/,/^(?:\\hksearow)/,/^(?:\\hermitconjmatrix)/,/^(?:\\heartsuit)/,/^(?:\\hbar)/,/^(?:\\hat)/,/^(?:\\H\{\})/,/^(?:\\gvertneqq)/,/^(?:\\gvertneqq)/,/^(?:\\gtrsim)/,/^(?:\\gtrless)/,/^(?:\\gtreqqless)/,/^(?:\\gtreqqless)/,/^(?:\\gtreqless)/,/^(?:\\gtrdot)/,/^(?:\\gtrapprox)/,/^(?:\\gt)/,/^(?:\\greaterequivlnt)/,/^(?:\\greater)/,/^(?:\\gnsim)/,/^(?:\\gneqq)/,/^(?:\\gneq)/,/^(?:\\gneq)/,/^(?:\\gnapprox)/,/^(?:\\gimel)/,/^(?:\\ggg)/,/^(?:\\gg)/,/^(?:\\geqslant)/,/^(?:\\geqq)/,/^(?:\\geq)/,/^(?:\\ge)/,/^(?:\\Gamma)/,/^(?:\\gamma)/,/^(?:\\frown)/,/^(?:\\frame)/,/^(?:\\frac)/,/^(?:\\forksnot)/,/^(?:\\forks)/,/^(?:\\forcesextra)/,/^(?:\\forall)/,/^(?:\\flat)/,/^(?:\\fdiagovrdiag)/,/^(?:\\fdiagovnearrow)/,/^(?:\\fbox\{~~\})/,/^(?:\\fallingdotseq)/,/^(?:\\exists)/,/^(?:\\eth)/,/^(?:\\eth)/,/^(?:\\Eta)/,/^(?:\\eta)/,/^(?:\\estimates)/,/^(?:\\equiv)/,/^(?:\\equalrows)/,/^(?:\\equalcols)/,/^(?:\\Equal)/,/^(?:\\eqslantless)/,/^(?:\\eqslantgtr)/,/^(?:\\eqsim)/,/^(?:\\Eqqcolon)/,/^(?:\\eqqcolon)/,/^(?:\\Eqcolon)/,/^(?:\\Eqcolon)/,/^(?:\\eqcolon)/,/^(?:\\eqcirc)/,/^(?:\\Epsilon)/,/^(?:\\epsilon)/,/^(?:\\epsilon)/,/^(?:\\end\{Vmatrix\})/,/^(?:\\end\{vmatrix\})/,/^(?:\\endtoggle)/,/^(?:\\end\{split\})/,/^(?:\\end\{smallmatrix\})/,/^(?:\\end\{pmatrix\})/,/^(?:\\end\{matrix\})/,/^(?:\\end\{gathered\})/,/^(?:\\end\{cases\})/,/^(?:\\end\{Bmatrix\})/,/^(?:\\end\{bmatrix\})/,/^(?:\\end\{array\})/,/^(?:\\end\{aligned\})/,/^(?:\\emptyset)/,/^(?:\\empty)/,/^(?:\\Elzvrecto)/,/^(?:\\ElzTimes)/,/^(?:\\ElzThr)/,/^(?:\\Elztfnc)/,/^(?:\\Elztdcol)/,/^(?:\\ElzSup)/,/^(?:\\Elzsqspne)/,/^(?:\\ElzRlarr)/,/^(?:\\ElzrLarr)/,/^(?:\\Elzreapos)/,/^(?:\\Elzrarrx)/,/^(?:\\ElzOr)/,/^(?:\\Elzminhat)/,/^(?:\\Elzlpargt)/,/^(?:\\ElzLap)/,/^(?:\\ElzInf)/,/^(?:\\Elzdefas)/,/^(?:\\Elzddfnc)/,/^(?:\\ElzCint)/,/^(?:\\ElzAnd)/,/^(?:\\Elxuplus)/,/^(?:\\Elxsqcup)/,/^(?:\\Elroang)/,/^(?:\\Elorarr)/,/^(?:\\ElOr)/,/^(?:\\Elolarr)/,/^(?:\\ell)/,/^(?:\\dualmap)/,/^(?:\\drbkarrow)/,/^(?:\\downslopeellipsis)/,/^(?:\\DownRightVectorBar)/,/^(?:\\DownRightTeeVector)/,/^(?:\\DownLeftVectorBar)/,/^(?:\\DownLeftTeeVector)/,/^(?:\\DownLeftRightVector)/,/^(?:\\downharpoonright)/,/^(?:\\downharpoonleft)/,/^(?:\\downdownarrows)/,/^(?:\\DownArrowUpArrow)/,/^(?:\\DownArrowBar)/,/^(?:\\Downarrow)/,/^(?:\\downarrow)/,/^(?:\\doubleintegral)/,/^(?:\\doublebarwedge)/,/^(?:\\doublebarwedge)/,/^(?:\\dots)/,/^(?:\\dotplus)/,/^(?:\\dotminus)/,/^(?:\\doteqdot)/,/^(?:\\Doteq)/,/^(?:\\doteq)/,/^(?:\\dot\{\})/,/^(?:\\dot)/,/^(?:\\divideontimes)/,/^(?:\\div)/,/^(?:\\displaystyle)/,/^(?:\\disjquant)/,/^(?:\\ding\{72\})/,/^(?:\\ding\{171\})/,/^(?:\\ding\{168\})/,/^(?:\\ding\{120\})/,/^(?:\\ding\{119\})/,/^(?:\\ding\{117\})/,/^(?:\\ding\{116\})/,/^(?:\\ding\{115\})/,/^(?:\\ding\{110\})/,/^(?:\\ding\{108\})/,/^(?:\\Digamma)/,/^(?:\\digamma)/,/^(?:\\diamondsuit)/,/^(?:\\Diamond)/,/^(?:\\diamond)/,/^(?:\\diamond)/,/^(?:\\dh)/,/^(?:\\det|\\gcd|\\liminf|\\limsup|\\lim|\\max|\\Pr|\\sup)/,/^(?:\\Delta)/,/^(?:\\delta)/,/^(?:\\Del)/,/^(?:\\degree)/,/^(?:\\Ddownarrow)/,/^(?:\\ddotseq)/,/^(?:\\ddots)/,/^(?:\\ddot)/,/^(?:\\dddot)/,/^(?:\\dddot)/,/^(?:\\ddddot)/,/^(?:\\ddddot)/,/^(?:\\ddagger)/,/^(?:\\ddag)/,/^(?:\\dblcolon)/,/^(?:\\dblarrowupdown)/,/^(?:\\dbkarow)/,/^(?:\\Dashv)/,/^(?:\\dashV)/,/^(?:\\dashv)/,/^(?:\\daleth)/,/^(?:\\dagger)/,/^(?:\\dag)/,/^(?:\\cyrchar\\CYRSH)/,/^(?:\\curvearrowright)/,/^(?:\\curvearrowleft)/,/^(?:\\curlywedge)/,/^(?:\\curlyvee)/,/^(?:\\curlyeqsucc)/,/^(?:\\curlyeqprec)/,/^(?:\\cupdot)/,/^(?:\\Cup)/,/^(?:\\cup)/,/^(?:\\coproduct)/,/^(?:\\coprod)/,/^(?:\\contourintegral)/,/^(?:\\conjquant)/,/^(?:\\conint)/,/^(?:\\cong)/,/^(?:\\complement)/,/^(?:\\colspan)/,/^(?:\\color)/,/^(?:\\Colonsim)/,/^(?:\\colonsim)/,/^(?:\\Coloneqq)/,/^(?:\\coloneqq)/,/^(?:\\Coloneq)/,/^(?:\\coloneq)/,/^(?:\\Colonapprox)/,/^(?:\\colonapprox)/,/^(?:\\Colon)/,/^(?:\\colon)/,/^(?:\\collines)/,/^(?:\\collayout)/,/^(?:\\colalign)/,/^(?:\\clwintegral)/,/^(?:\\clubsuit)/,/^(?:\\closure)/,/^(?:\\clockoint)/,/^(?:\\circleddash)/,/^(?:\\circledcirc)/,/^(?:\\circledast)/,/^(?:\\circlearrowright)/,/^(?:\\circlearrowright)/,/^(?:\\circlearrowleft)/,/^(?:\\circlearrowleft)/,/^(?:\\circeq)/,/^(?:\\circ)/,/^(?:\\choose)/,/^(?:\\Chi)/,/^(?:\\chi)/,/^(?:\\check)/,/^(?:\\cellopts)/,/^(?:\\cdots)/,/^(?:\\cdotp)/,/^(?:\\cdot)/,/^(?:\\Cap)/,/^(?:\\cap)/,/^(?:\\c\{\})/,/^(?:\\bumpeqq)/,/^(?:\\Bumpeq)/,/^(?:\\bumpeq)/,/^(?:\\bullet)/,/^(?:\\bullet)/,/^(?:\\btimes)/,/^(?:\\boxtimes)/,/^(?:\\boxplus)/,/^(?:\\boxminus)/,/^(?:\\boxed)/,/^(?:\\boxdot)/,/^(?:\\boxdiag)/,/^(?:\\boxcircle)/,/^(?:\\boxbslash)/,/^(?:\\boxast)/,/^(?:\\Box)/,/^(?:\\bowtie)/,/^(?:\\bottom)/,/^(?:\\bot)/,/^(?:\\boldsymbol)/,/^(?:\\blacktriangleright)/,/^(?:\\blacktriangleleft)/,/^(?:\\blacktriangledown)/,/^(?:\\blacktriangle)/,/^(?:\\blacksquare)/,/^(?:\\blacksquare)/,/^(?:\\blacklozenge)/,/^(?:\\bkarow)/,/^(?:\\binom)/,/^(?:\\bigwedge)/,/^(?:\\bigvee)/,/^(?:\\biguplus)/,/^(?:\\bigtriangleup)/,/^(?:\\bigtriangledown)/,/^(?:\\bigtimes)/,/^(?:\\bigstar)/,/^(?:\\bigsqcup)/,/^(?:\\bigsqcap)/,/^(?:\\Bigr)/,/^(?:\\bigr)/,/^(?:\\bigotimes)/,/^(?:\\bigoplus)/,/^(?:\\bigodot)/,/^(?:\\Bigl)/,/^(?:\\bigl)/,/^(?:\\biginterleave)/,/^(?:\\Biggr)/,/^(?:\\biggr)/,/^(?:\\Biggl)/,/^(?:\\biggl)/,/^(?:\\Bigg)/,/^(?:\\bigg)/,/^(?:\\bigcupdot)/,/^(?:\\bigcup)/,/^(?:\\bigcirc)/,/^(?:\\bigcap)/,/^(?:\\Big)/,/^(?:\\big)/,/^(?:\\bgcolor)/,/^(?:\\between)/,/^(?:\\beth)/,/^(?:\\Beta)/,/^(?:\\beta)/,/^(?:\\begin\{Vmatrix\})/,/^(?:\\begin\{vmatrix\})/,/^(?:\\begintoggle)/,/^(?:\\begin\{split\})/,/^(?:\\begin\{smallmatrix\})/,/^(?:\\begin\{pmatrix\})/,/^(?:\\begin\{matrix\})/,/^(?:\\begin\{gathered\})/,/^(?:\\begin\{cases\})/,/^(?:\\begin\{Bmatrix\})/,/^(?:\\begin\{bmatrix\})/,/^(?:\\begin\{array\})/,/^(?:\\begin\{aligned\})/,/^(?:\\because)/,/^(?:\\BbbPi)/,/^(?:\\barwedge)/,/^(?:\\bar)/,/^(?:\\backslash)/,/^(?:\\backsimeq)/,/^(?:\\backsim)/,/^(?:\\backprime)/,/^(?:\\backepsilon)/,/^(?:\\atop)/,/^(?:\\asymp)/,/^(?:\\ast)/,/^(?:\\ast)/,/^(?:\\arrowwaveright)/,/^(?:\\arrowwaveleft)/,/^(?:\\arrayopts)/,/^(?:\\array)/,/^(?:\\arccos|\\arcsin|\\arctan|\\arg|\\cosh|\\cos|\\coth|\\cot|\\csc|\\deg|\\dim|\\exp|\\hom|\\ker|\\lg|\\ln|\\log|\\sec|\\sinh|\\sin|\\tanh|\\tan)/,/^(?:\\approxnotequal)/,/^(?:\\approxeq)/,/^(?:\\approx)/,/^(?:\\Angle)/,/^(?:\\angle)/,/^(?:\\amalg)/,/^(?:\\Alpha)/,/^(?:\\alpha)/,/^(?:\\allequal)/,/^(?:\\align)/,/^(?:\\aleph)/,/^(?:\\adots)/,/^(?:\\AA)/,/^(?:[\u0041-\u005A\u0061-\u007A\u00F0\u0131\u0237\u0391-\u03A1\u03A3\u03A4\u03A6-\u03A9\u03B1-\u03C9\u03D0-\u03D2\u03D5\u03D6\u03DA-\u03DD\u03E0\u03E1\u03F0\u03F1\u03F4\u03F5\u0428\u0608\u0627-\u063A\u2102\u210A-\u210D\u210F-\u2113\u2115\u2118-\u211D\u2124\u2128\u212B-\u212D\u212F-\u2131\u2133-\u2138\u213C\u213D\u213F\u2205]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB\uDEF0\uDEF1]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDFCB])/,/^(?:\\%)/,/^(?:\\#)/,/^(?:\\&)/,/^(?:\\\$)/,/^(?:\\\})/,/^(?:\\\{)/,/^(?:\\!)/,/^(?:\\:)/,/^(?:\\;)/,/^(?:\\,)/,/^(?:\\_)/,/^(?:\\\|)/,/^(?:\\\^\{\})/,/^(?:\\\^)/,/^(?:'''')/,/^(?:''')/,/^(?:'')/,/^(?:')/,/^(?:[\uD800-\uDBFF])/,/^(?:[\uDC00-\uDFFF])/,/^(?:.)/],
conditions: {"OPTARG":{"rules":[7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,1715,1716,1717,1718,1719,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,1851,1852,1853,1854,1855,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969],"inclusive":true},"TRYOPTARG":{"rules":[0,1],"inclusive":false},"TEXTOPTARG":{"rules":[2,3],"inclusive":false},"TEXTARG":{"rules":[4,5,6],"inclusive":false},"INITIAL":{"rules":[8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,1715,1716,1717,1718,1719,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,1851,1852,1853,1854,1855,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969],"inclusive":true}}
};
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
if (typeof require !== "undefined") {

  // FIXME: This tries to work with slimerjs, phantomjs and nodejs. Ideally,
  // we should have a standard commonJS interface.
  // https://github.com/fred-wang/TeXZilla/issues/6

  var exitCommonJS = function (aStatus) {
    if (typeof process !== "undefined") {
      process.exit(aStatus);
    } else if (typeof slimer !== "undefined") {
      slimer.exit(aStatus);
    } else if (typeof phantom !== "undefined") {
      phantom.exit(aStatus);
    }
  };

  var usage = function () {
    // Display the usage information.
    console.log("\nUsage:\n");
    console.log("commonjs TeXZilla.js [help]");
    console.log("  Print this help message.\n");
    console.log("commonjs TeXZilla.js parser aTeX [aDisplay] [aRTL] [aThrowExceptionOnError]");
    console.log("  Print TeXZilla.toMathMLString(aTeX, aDisplay, aRTL, aThrowExceptionOnError)");
    console.log("  The interpretation of arguments and the default values are the same.\n");
    console.log("commonjs TeXZilla.js webserver [port]");
    console.log("  Start a Web server on the specified port (default:3141)");
    console.log("  See the TeXZilla wiki for details.\n");
    console.log("cat input | commonjs TeXZilla.js streamfilter > output");
    console.log("  TODO\n");
    console.log("  where commonjs is slimerjs, nodejs or phantomjs.");
  };

  var setParamValue = function (aParam, aKey, aString) {
    // Set the param value from the string value.
    if (aKey === "tex") {
      aParam[aKey] = aString;
    } else if (aKey === "display" || aKey === "rtl" || aKey === "exception") {
      aParam[aKey] = (aString === "true");
    }
  };

  var getMathMLString = function (aParam) {
    // Call the TeXZilla parser with the specified parameters and
    // return the MathML output.
    return TeXZilla.toMathMLString(aParam.tex, aParam.display,
                                   aParam.rtl, aParam.exception);
  };

  var getParametersFromURL = function (aURL) {
    // Get the param values from the GET URL.
    var param, query, vars, i, pair, key, value;
    param = {};
    query = aURL.split("?")[1];
    if (query) {
      vars = query.split("&");
      for (i = 0; i < vars.length; i++) {
        pair = vars[i].split("=");
        key = decodeURIComponent(pair[0]).toLowerCase();
        value = decodeURIComponent(pair[1]);
        setParamValue(param, key, value);
      }
    }
    return param;
  };

  var getParametersFromPOSTData = function (aPOSTData) {
    // Get the param values from the POST JSON data.
    var param = {}, json = JSON.parse(aPOSTData), key;
    for (key in json) {
      setParamValue(param, key, json[key]);
    }
    return param;
  };

  var getServerResponseFromParam = function (aParam) {
    // Get the JSON data to send back.
    var data = { tex: aParam.tex };
    try {
      data.mathml = getMathMLString(aParam);
      data.exception = null;
    } catch (e) {
      data.exception = e.message;
    }
    return JSON.stringify(data);
  };

  var webserverListener = function (aRequest, aResponse) {
    // Listener for the "webserver" module (phantomjs, slimerjs).
    var param = {}, json = {}, response;
    if (aRequest.method === "GET") {
      param = getParametersFromURL(aRequest.url);
    } else if (aRequest.method === "POST") {
      param = getParametersFromPOSTData(aRequest.post);
    }
    if (param.tex !== undefined) {
      json = getServerResponseFromParam(param);
    }
    response = JSON.stringify(json);
    aResponse.statusCode = 200;
    aResponse.setHeader("Content-Type", "application/json");
    aResponse.write(response);
    aResponse.close();
  };

  var httpListener = function (aRequest, aResponse) {
    // Listener for the "http" module (nodejs).
    var param = {}, json = {}, response, body = "";
    aRequest.setEncoding("utf8");
    aRequest.on("data", function (aChunk) {
      body += aChunk;
    });
    aRequest.on("end", function () {
      aResponse.writeHead(200, {"Content-Type": ""});
      if (aRequest.method === "GET") {
        param = getParametersFromURL(aRequest.url);
      } else if (aRequest.method === "POST") {
        param = getParametersFromPOSTData(body);
      }
      if (param.tex !== undefined) {
        json = getServerResponseFromParam(param);
      }
      response = JSON.stringify(json);
      aResponse.writeHead(200, { "Content-Type": "application/json" });
      aResponse.write(response);
      aResponse.end();
    });
  };
  
  var startWebServer = function (aPort)
  {
    try {
      require("webserver").create().listen(aPort, webserverListener);
    } catch (e) {
      require("http").createServer(httpListener).listen(aPort);
    }
    console.log("Web server started on http://localhost:" + aPort);
  }

  var main = function (aArgs) {
    // Main command line function.
    var param = {};
    if (aArgs.length >= 3 && aArgs[1] === "parser") {
      // Parse the string and print the output.
      setParamValue(param, "tex", aArgs[2]);
      setParamValue(param, "display", aArgs[3]);
      setParamValue(param, "rtl", aArgs[4]);
      setParamValue(param, "exception", aArgs[5]);
      try {
        console.log(getMathMLString(param));
        exitCommonJS(0);
      } catch (e) {
        console.log(e);
        exitCommonJS(1);
      }
    } else if (aArgs.length >= 2 && aArgs[1] === "webserver") {
      // Run a Web server.
      try {
        startWebServer(aArgs.length >= 3 ? parseInt(aArgs[2], 10) : 3141);
      } catch (e) {
        console.log(e);
        exitCommonJS(1);
      }
    } else {
      // FIXME: add a stream filter.
      // https://github.com/fred-wang/TeXZilla/issues/7
      usage();
      exitCommonJS(0);
    }
  };

  if (typeof exports !== "undefined") {
    // Export the public API.
    exports.setDOMParser = function (aDOMParser) {
      TeXZilla.DOMParser = aDOMParser;
    };

    exports.getTeXSource = function () {
      return TeXZilla.getTeXSource.apply(TeXZilla, arguments);
    };

    exports.toMathMLString = function () {
      return TeXZilla.toMathMLString.apply(TeXZilla, arguments);
    };

    exports.toMathML = function () {
      return TeXZilla.toMathML.apply(TeXZilla, arguments);
    };

    exports.main = main;
  }

  if (typeof exports === "undefined" ||
      (typeof module !== "undefined" && require.main === module)) {
    // Process the command line arguments and execute the main program.
    var args;
    if (typeof process !== "undefined") {
      args = process.argv.slice(1);
    } else {
      args = require("system").args;
    }
    main(args);
  }
}
// CKEditor TeXZilla Plugin
// Copyright (C) 2014  Raniere Silva
//
// This Source Code Form is subject to the terms of the
// Mozilla Public License, v. 2.0. If a copy of the MPL was not distributed
// with this file, You can obtain one at http://mozilla.org/MPL/2.0/.

/* global CKEDITOR:false */
/* global TeXZilla:false */

function update_preview() {
    var dialog = CKEDITOR.dialog.getCurrent();

    var preview = document.getElementById("Preview");
    // Clean previous preview
    var previous = preview.childNodes;
    for (var i = 0; i < previous.length; i++) {
        preview.removeChild(previous[i]);
    }

    var mathElement;
    try {
        mathElement = TeXZilla.toMathML(
            dialog.getValueOf("basic", "tex"),
            dialog.getValueOf("basic", "display"),
            dialog.getValueOf("basic", "direction"),
            true);
        dialog.enableButton("ok");
    }
    catch (error) {
        // Disable button if errer
        mathElement = document.createElement("p");
        mathElement.innerHTML = "Error. Please check your (LaTeX) code.";
        dialog.disableButton("ok");
    }

    preview.appendChild(mathElement);
}

CKEDITOR.dialog.add("texzillaDialog", function(editor) {
    return {
        title: "TeXZilla Edit Box",
        minWidth: 300,
        minHeight: 300,
        contents: [{
            id: "basic",
            label: "Basic Settings",
            elements: [{
                id: "tex",
                type: "textarea",
                label: "Please insert your (LaTex) code:",
                setup: function(insertMode, element) {
                    if (!insertMode) {
                        this.setValue(TeXZilla.getTeXSource(element.$));
                    }
                },
                onChange: function() {
                    update_preview();
                }
            }, {
                id: "instruction",
                type: "html",
                html: "<div>(Clicking outside of the textarea updates the preview)</div>"
            }, {
                id: "options",
                type: "html",
                html: "<div><strong>Options:</strong></div>"
            }, {
                id: "display",
                type: "checkbox",
                label: "Display",
                setup: function(insertMode, element) {
                    var display = element.getAttribute("display");
                    if (display === "block") {
                        this.setValue(true);
                    }
                    else {
                        this.setValue(false);
                    }
                },
                onChange: function() {
                    update_preview();
                }
            }, {
                id: "direction",
                type: "checkbox",
                label: "RTL",
                setup: function(insertMode, element) {
                    var direction = element.getAttribute("dir");
                    if (direction === "rtl") {
                        this.setValue(true);
                    }
                    else {
                        this.setValue(false);
                    }
                },
                onChange: function() {
                    update_preview();
                }
            }, {
                id: "preview",
                type: "html",
                label: "Preview",
                // Width of the preview box is based on the minWidth of the dialog window.
                html: "<div><p><strong>Preview</strong>:</p><p id=\"Preview\" style=\"width:250px; overflow:auto;\"></p></div>",
                setup: function(insertMode, element) {
                    var preview = document.getElementById("Preview");
                    // Clean previous preview
                    var previous = preview.childNodes;
                    for (var i = 0; i < previous.length; i++) {
                        preview.removeChild(previous[i]);
                    }
                    if (!insertMode) {
                        preview.appendChild(element.$.cloneNode(true));
                    }
                }
            }]
        }],
        onShow: function() {
            var selection = editor.getSelection();
            var element = selection.getStartElement();
            // Try to locate a `math` or `body` tag.
            while (element.getName() !== "math" &&
                element.getName() !== "body") {
                element = element.getParent();
            }
            if (!element || element.getName() !== "math") {
                this.insertMode = true;
            }
            else {
                this.insertMode = false;
                this.mathRoot = element;
            }
            // invoke the setup functions for the element
            this.setupContent(this.insertMode, element);
        },
        onOk: function() {
            var dialog = this;

            // This is the better way to insert the MathML, although we got
            //
            //     TypeError: element.getName is not a function
            //
            // when using it.
            //
            // var mathElement = TeXZilla.toMathML(
            //     dialog.getValueOf("basic", "tex"));

            // This is a hack found at
            // http://stackoverflow.com/a/17339275/1802726.
            var math = TeXZilla.toMathMLString(
                dialog.getValueOf("basic", "tex"),
                dialog.getValueOf("basic", "display"),
                dialog.getValueOf("basic", "direction"),
                true);
            var mathElement = CKEDITOR.dom.element.createFromHtml(math,
                editor.document);

            if (!this.insertMode) {
                // Remove old equation
                this.mathRoot.$.parentNode.removeChild(this.mathRoot.$);
            }
            editor.insertElement(mathElement);
        }
    };
});
