<p align="center" class="mb-2">
<img class="not-gallery-item" height="48" src="https://ppoffice.github.io/hexo-theme-icarus/img/logo.svg">
<br> A simple, delicate, and modern theme for the static site generator Hexo.
<br>
<a href="https://ppoffice.github.io/hexo-theme-icarus/">Preview</a> |
<a href="https://ppoffice.github.io/hexo-theme-icarus/categories/">Documentation</a> |
<a href="https://github.com/ppoffice/hexo-theme-icarus/discussions">Discuss on GitHub</a>
<br>
</p>

![](https://ppoffice.github.io/hexo-theme-icarus/gallery/preview.png?1 "Icarus Preview")

## :cd: Installation

```shell
$ npm install hexo-theme-icarus
$ hexo config theme icarus
```

Please refer to [Getting Started with Icarus](https://ppoffice.github.io/hexo-theme-icarus/uncategorized/getting-started-with-icarus/) 
for more details.

## :gift: Features

### Cyberpunk Theme Variant

Tap into the future cyber world with the newly added Cyberpunk theme variant.
Inspired by [Cyberpunk 2077](https://www.cyberpunk.net).

![Icarus Cyberpunk](https://ppoffice.github.io/hexo-theme-icarus/gallery/screenshots/cyberpunk.png "Icarus Cyberpunk")

### Extensive Plugin Support

Icarus includes plentiful search, comment, sharing and other plugins out of the box that makes your
blog feature-rich and powerful.

**[Comment](https://ppoffice.github.io/hexo-theme-icarus/categories/Plugins/Comment/)**

Changyan &middot; Disqus &middot; DisqusJS &middot; Facebook &middot; Gitalk &middot; Gitment &middot;
Isso &middot; LiveRe &middot; Utterance &middot; Valine

**[Donate Button](https://ppoffice.github.io/hexo-theme-icarus/categories/Plugins/Donation/)**

Afdian.net &middot; Alipay &middot; Buy me a coffee &middot; Patreon &middot; Paypal &middot; Wecat

**[Search](https://ppoffice.github.io/hexo-theme-icarus/categories/Plugins/Search/)**

Algolia &middot; Baidu &middot; Google CSE &middot; Insight

**[Share](https://ppoffice.github.io/hexo-theme-icarus/categories/Plugins/Share/)**

AddThis &middot; AddToAny &middot; Baidu Share &middot; Share.js &middot; ShareThis

**[Widgets](https://ppoffice.github.io/hexo-theme-icarus/categories/Widgets/)**

Google Adsense &middot; Archives &middot; Categories &middot; External Site Links &middot; 
Recent Posts &middot; Google Feedburner &middot; Tags &middot; Table of Contents

**[Analytics](https://ppoffice.github.io/hexo-theme-icarus/Plugins/Analytics/icarus-user-guide-web-analytics-plugins/)**

Baidu Statistics &middot; Bing Webmaster &middot; BuSuanZi Web Counter &middot; CNZZ Statistics &middot;
Google Analytics &middot; Hotjar &middot; StatCounter &middot; Twitter Conversion Tracking

**[Other Plugins](https://ppoffice.github.io/hexo-theme-icarus/categories/Plugins/)**

Cookie Consent &middot; LightGallery &middot; Justified Gallery &middot; KaTeX &middot; MathJax &middot;
Oudated Browser &middot; Page Loading Animations

### Colorful Code Highlight

Icarus directly import stylesheets from the [highlight.js](https://highlightjs.org/) package and makes more than
90 code highlight themes available to you.

<table>
    <tr>
        <th>Atom One Light</th>
        <th>Monokai</th>
        <th>Kimbie Dark</th>
    </tr>
    <tr>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/code-highlight/atom-one-light.png?2"></td>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/code-highlight/monokai.png?2"></td>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/code-highlight/kimbie-dark.png?2"></td>
    </tr>
</table>

### Flexible Theme Configuration

Icarus allows you to configure your site on a per-page or per-layout basis.

<div>
<table>
    <tr>
        <th>_config.yml</th>
        <th>post.md</th>
        <th>_config.page.yml</th>
    </tr>
    <tr>
        <td>
<pre>widgets:
  - type: profile
    position: left
  - type: recent_posts
    position: right</pre>
        </td>
        <td>
<pre>widgets:
  - type: profile
    position: left
  - type: recent_posts
    position: left</pre>
        </td>
        <td>
<pre>widgets: null
 
 
 
</pre>
        </td>
    </tr>
    <tr>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/screenshots/default-config.png"></td>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/screenshots/post-config.png"></td>
        <td><img width="266" src="https://ppoffice.github.io/hexo-theme-icarus/gallery/screenshots/layout-config.png"></td>
    </tr>
</table>
</div>

### Responsive Layout

Give your audiences best viewing experience with Icarus's mobile-friendly responsive layout.

![Responsive Layout](https://ppoffice.github.io/hexo-theme-icarus/gallery/responsive.png)

## :hammer: Development

This project is built with

- [Hexo](https://hexo.io/)
- [Inferno.js](https://infernojs.org/)
- [Stylus](https://stylus-lang.com/)
- [Bulma](https://bulma.io/)

Please refer to the [documentation](https://ppoffice.github.io/hexo-theme-icarus/categories/) and 
[contributing guide](https://github.com/ppoffice/hexo-theme-icarus/blob/master/CONTRIBUTING.md) for implementation details.

## :tada: Contribute

If you feel like to help us build a better Icarus, you can

:black_nib: [Submit a tutorial](https://github.com/ppoffice/hexo-theme-icarus/new/site/source/_posts) |
:earth_asia: [Add a translation](https://github.com/ppoffice/hexo-theme-icarus/tree/master/languages) |
:triangular_flag_on_post: [Report a bug](https://github.com/ppoffice/hexo-theme-icarus/issues/new) |
:electric_plug: [Suggest a new feature](https://github.com/ppoffice/hexo-theme-icarus/pulls)

## :memo: License

This project is licensed under the MIT License - see the [LICENSE](https://github.com/ppoffice/hexo-theme-icarus/blob/master/LICENSE) file for details.
