#![allow(clippy::all)]
#[derive(Debug, serde::Deserialize, Clone, Copy, PartialEq, Eq, Hash, clap :: ValueEnum)]
pub enum License {
    #[value(name = "CNRI-Python-GPL-Compatible")]
    CNRIPythonGPLCompatible,
    #[value(name = "HP-1986")]
    HPOneNineEightSix,
    #[value(name = "EUPL-1.1")]
    EUPLOneDotOne,
    #[value(name = "Cube")]
    Cube,
    #[value(name = "CNRI-Jython")]
    CNRIJython,
    #[value(name = "Artistic-1.0")]
    ArtisticOneDotZero,
    #[value(name = "LGPL-3.0")]
    LGPLThreeDotZero,
    #[value(name = "HPND-merchantability-variant")]
    HPNDMerchantabilityVariant,
    #[value(name = "IJG")]
    IJG,
    #[value(name = "CC-BY-SA-3.0-AT")]
    CCBYSAThreeDotZeroAT,
    #[value(name = "Dotseqn")]
    Dotseqn,
    #[value(name = "HPND-Netrek")]
    HPNDNetrek,
    #[value(name = "JPNIC")]
    JPNIC,
    #[value(name = "MPL-1.1")]
    MPLOneDotOne,
    #[value(name = "SGI-B-1.0")]
    SGIBOneDotZero,
    #[value(name = "Artistic-1.0-Perl")]
    ArtisticOneDotZeroPerl,
    #[value(name = "copyleft-next-0.3.0")]
    CopyleftNextZeroDotThreeDotZero,
    #[value(name = "fwlw")]
    Fwlw,
    #[value(name = "CC-BY-3.0-DE")]
    CCBYThreeDotZeroDE,
    #[value(name = "OLDAP-2.0.1")]
    OLDAPTwoDotZeroDotOne,
    #[value(name = "xpp")]
    Xpp,
    #[value(name = "DocBook-Schema")]
    DocBookSchema,
    #[value(name = "CERN-OHL-P-2.0")]
    CERNOHLPTwoDotZero,
    #[value(name = "GLWTPL")]
    GLWTPL,
    #[value(name = "CPAL-1.0")]
    CPALOneDotZero,
    #[value(name = "W3C-20150513")]
    WThreeCTwoZeroOneFiveZeroFiveOneThree,
    #[value(name = "CC-BY-NC-ND-4.0")]
    CCBYNCNDFourDotZero,
    #[value(name = "Sendmail")]
    Sendmail,
    #[value(name = "softSurfer")]
    SoftSurfer,
    #[value(name = "CAL-1.0-Combined-Work-Exception")]
    CALOneDotZeroCombinedWorkException,
    #[value(name = "Imlib2")]
    ImlibTwo,
    #[value(name = "CECILL-2.0")]
    CECILLTwoDotZero,
    #[value(name = "HPND-sell-regexpr")]
    HPNDSellRegexpr,
    #[value(name = "ADSL")]
    ADSL,
    #[value(name = "TrustedQSL")]
    TrustedQsl,
    #[value(name = "Parity-7.0.0")]
    ParitySevenDotZeroDotZero,
    #[value(name = "MakeIndex")]
    MakeIndex,
    #[value(name = "OML")]
    OML,
    #[value(name = "LiLiQ-Rplus-1.1")]
    LiLiQRplusOneDotOne,
    #[value(name = "SPL-1.0")]
    SPLOneDotZero,
    #[value(name = "DOC")]
    DOC,
    #[value(name = "NTP-0")]
    NTPZero,
    #[value(name = "GFDL-1.3-or-later")]
    GFDLOneDotThreeOrLater,
    #[value(name = "NASA-1.3")]
    NASAOneDotThree,
    #[value(name = "LGPL-2.1")]
    LGPLTwoDotOne,
    #[value(name = "ulem")]
    Ulem,
    #[value(name = "GFDL-1.3-invariants-only")]
    GFDLOneDotThreeInvariantsOnly,
    #[value(name = "HPND-sell-variant-MIT-disclaimer-rev")]
    HPNDSellVariantMITDisclaimerRev,
    #[value(name = "FSFULLRWD")]
    FSFULLRWD,
    #[value(name = "AGPL-3.0")]
    AGPLThreeDotZero,
    #[value(name = "LGPL-2.0-or-later")]
    LGPLTwoDotZeroOrLater,
    #[value(name = "AML-glslang")]
    AMLGlslang,
    #[value(name = "OpenVision")]
    OpenVision,
    #[value(name = "bzip2-1.0.6")]
    BzipTwoOneDotZeroDotSix,
    #[value(name = "GFDL-1.2")]
    GFDLOneDotTwo,
    #[value(name = "Linux-man-pages-1-para")]
    LinuxManPagesOnePara,
    #[value(name = "OSL-2.1")]
    OSLTwoDotOne,
    #[value(name = "Crossword")]
    Crossword,
    #[value(name = "Unicode-3.0")]
    UnicodeThreeDotZero,
    #[value(name = "BSD-4-Clause")]
    BSDFourClause,
    #[value(name = "SSLeay-standalone")]
    SsLeayStandalone,
    #[value(name = "SGP4")]
    SgpFour,
    #[value(name = "SHL-0.51")]
    SHLZeroDotFiveOne,
    #[value(name = "HPND-Intel")]
    HPNDIntel,
    #[value(name = "LiLiQ-R-1.1")]
    LiLiQROneDotOne,
    #[value(name = "APSL-1.0")]
    APSLOneDotZero,
    #[value(name = "COIL-1.0")]
    COILOneDotZero,
    #[value(name = "Vim")]
    Vim,
    #[value(name = "snprintf")]
    Snprintf,
    #[value(name = "Adobe-2006")]
    AdobeTwoZeroZeroSix,
    #[value(name = "CPOL-1.02")]
    CPOLOneDotZeroTwo,
    #[value(name = "MIT-0")]
    MITZero,
    #[value(name = "BSD-3-Clause-Clear")]
    BSDThreeClauseClear,
    #[value(name = "Ferguson-Twofish")]
    FergusonTwofish,
    #[value(name = "OSL-3.0")]
    OSLThreeDotZero,
    #[value(name = "TAPR-OHL-1.0")]
    TAPROHLOneDotZero,
    #[value(name = "python-ldap")]
    PythonLdap,
    #[value(name = "SimPL-2.0")]
    SimPlTwoDotZero,
    #[value(name = "VOSTROM")]
    VOSTROM,
    #[value(name = "SSH-OpenSSH")]
    SSHOpenSsh,
    #[value(name = "Linux-man-pages-copyleft-var")]
    LinuxManPagesCopyleftVar,
    #[value(name = "MPEG-SSG")]
    MPEGSSG,
    #[value(name = "NIST-PD")]
    NISTPD,
    #[value(name = "YPL-1.0")]
    YPLOneDotZero,
    #[value(name = "XSkat")]
    XSkat,
    #[value(name = "LAL-1.3")]
    LALOneDotThree,
    #[value(name = "BSD-3-Clause-acpica")]
    BSDThreeClauseAcpica,
    #[value(name = "GFDL-1.3-only")]
    GFDLOneDotThreeOnly,
    #[value(name = "Entessa")]
    Entessa,
    #[value(name = "Latex2e-translated-notice")]
    LatexTwoeTranslatedNotice,
    #[value(name = "LOOP")]
    LOOP,
    #[value(name = "Wsuipa")]
    Wsuipa,
    #[value(name = "Spencer-86")]
    SpencerEightSix,
    #[value(name = "OGL-UK-3.0")]
    OGLUKThreeDotZero,
    #[value(name = "Hippocratic-2.1")]
    HippocraticTwoDotOne,
    #[value(name = "GPL-3.0-only")]
    GPLThreeDotZeroOnly,
    #[value(name = "Furuseth")]
    Furuseth,
    #[value(name = "OGL-UK-2.0")]
    OGLUKTwoDotZero,
    #[value(name = "LiLiQ-P-1.1")]
    LiLiQPOneDotOne,
    #[value(name = "Barr")]
    Barr,
    #[value(name = "HPND-UC")]
    HPNDUC,
    #[value(name = "MS-PL")]
    MSPL,
    #[value(name = "BSD-4-Clause-UC")]
    BSDFourClauseUC,
    #[value(name = "AGPL-1.0-or-later")]
    AGPLOneDotZeroOrLater,
    #[value(name = "NLPL")]
    NLPL,
    #[value(name = "AMD-newlib")]
    AMDNewlib,
    #[value(name = "OLDAP-2.8")]
    OLDAPTwoDotEight,
    #[value(name = "GFDL-1.3")]
    GFDLOneDotThree,
    #[value(name = "Knuth-CTAN")]
    KnuthCTAN,
    #[value(name = "HaskellReport")]
    HaskellReport,
    #[value(name = "OSL-2.0")]
    OSLTwoDotZero,
    #[value(name = "MIT-Wu")]
    MITWu,
    #[value(name = "AAL")]
    AAL,
    #[value(name = "AFL-1.1")]
    AFLOneDotOne,
    #[value(name = "Arphic-1999")]
    ArphicOneNineNineNine,
    #[value(name = "GPL-1.0")]
    GPLOneDotZero,
    #[value(name = "ErlPL-1.1")]
    ErlPlOneDotOne,
    #[value(name = "Linux-man-pages-copyleft-2-para")]
    LinuxManPagesCopyleftTwoPara,
    #[value(name = "Nokia")]
    Nokia,
    #[value(name = "MIT-Click")]
    MITClick,
    #[value(name = "McPhee-slideshow")]
    McPheeSlideshow,
    #[value(name = "APSL-1.1")]
    APSLOneDotOne,
    #[value(name = "OLDAP-2.2.2")]
    OLDAPTwoDotTwoDotTwo,
    #[value(name = "LGPL-3.0-only")]
    LGPLThreeDotZeroOnly,
    #[value(name = "CC-BY-SA-4.0")]
    CCBYSAFourDotZero,
    #[value(name = "MIT-Festival")]
    MITFestival,
    #[value(name = "RPL-1.5")]
    RPLOneDotFive,
    #[value(name = "0BSD")]
    ZeroBsd,
    #[value(name = "HPND-doc")]
    HPNDDoc,
    #[value(name = "ClArtistic")]
    ClArtistic,
    #[value(name = "TCP-wrappers")]
    TCPWrappers,
    #[value(name = "generic-xts")]
    GenericXts,
    #[value(name = "ISC-Veillard")]
    ISCVeillard,
    #[value(name = "Rdisc")]
    Rdisc,
    #[value(name = "ODbL-1.0")]
    ODbLOneDotZero,
    #[value(name = "Plexus")]
    Plexus,
    #[value(name = "Boehm-GC-without-fee")]
    BoehmGCWithoutFee,
    #[value(name = "Inner-Net-2.0")]
    InnerNetTwoDotZero,
    #[value(name = "YPL-1.1")]
    YPLOneDotOne,
    #[value(name = "LAL-1.2")]
    LALOneDotTwo,
    #[value(name = "ANTLR-PD")]
    ANTLRPD,
    #[value(name = "UCAR")]
    UCAR,
    #[value(name = "GFDL-1.2-only")]
    GFDLOneDotTwoOnly,
    #[value(name = "Zlib")]
    Zlib,
    #[value(name = "EUPL-1.0")]
    EUPLOneDotZero,
    #[value(name = "Gutmann")]
    Gutmann,
    #[value(name = "InnoSetup")]
    InnoSetup,
    #[value(name = "Mackerras-3-Clause-acknowledgment")]
    MackerrasThreeClauseAcknowledgment,
    #[value(name = "LPL-1.0")]
    LPLOneDotZero,
    #[value(name = "SGI-B-1.1")]
    SGIBOneDotOne,
    #[value(name = "MPL-1.0")]
    MPLOneDotZero,
    #[value(name = "D-FSL-1.0")]
    DFSLOneDotZero,
    #[value(name = "copyleft-next-0.3.1")]
    CopyleftNextZeroDotThreeDotOne,
    #[value(name = "Saxpath")]
    Saxpath,
    #[value(name = "OAR")]
    OAR,
    #[value(name = "OPUBL-1.0")]
    OPUBLOneDotZero,
    #[value(name = "TCL")]
    TCL,
    #[value(name = "EFL-2.0")]
    EFLTwoDotZero,
    #[value(name = "Aladdin")]
    Aladdin,
    #[value(name = "GPL-2.0-with-classpath-exception")]
    GPLTwoDotZeroWithClasspathException,
    #[value(name = "ThirdEye")]
    ThirdEye,
    #[value(name = "MIPS")]
    MIPS,
    #[value(name = "RPSL-1.0")]
    RPSLOneDotZero,
    #[value(name = "MIT-CMU")]
    MITCMU,
    #[value(name = "FreeBSD-DOC")]
    FreeBsdDOC,
    #[value(name = "CAL-1.0")]
    CALOneDotZero,
    #[value(name = "Zimbra-1.4")]
    ZimbraOneDotFour,
    #[value(name = "BUSL-1.1")]
    BUSLOneDotOne,
    #[value(name = "psutils")]
    Psutils,
    #[value(name = "CECILL-2.1")]
    CECILLTwoDotOne,
    #[value(name = "Zeeff")]
    Zeeff,
    #[value(name = "Mup")]
    Mup,
    #[value(name = "GFDL-1.2-no-invariants-or-later")]
    GFDLOneDotTwoNoInvariantsOrLater,
    #[value(name = "GPL-3.0-with-autoconf-exception")]
    GPLThreeDotZeroWithAutoconfException,
    #[value(name = "RPL-1.1")]
    RPLOneDotOne,
    #[value(name = "Adobe-Glyph")]
    AdobeGlyph,
    #[value(name = "BSD-3-Clause-flex")]
    BSDThreeClauseFlex,
    #[value(name = "CC-BY-NC-4.0")]
    CCBYNCFourDotZero,
    #[value(name = "MS-RL")]
    MSRL,
    #[value(name = "BSD-3-Clause-No-Nuclear-License")]
    BSDThreeClauseNoNuclearLicense,
    #[value(name = "IPA")]
    IPA,
    #[value(name = "LGPL-2.0")]
    LGPLTwoDotZero,
    #[value(name = "NetCDF")]
    NetCdf,
    #[value(name = "ECL-1.0")]
    ECLOneDotZero,
    #[value(name = "BSD-2-Clause")]
    BSDTwoClause,
    #[value(name = "SAX-PD")]
    SAXPD,
    #[value(name = "PSF-2.0")]
    PSFTwoDotZero,
    #[value(name = "Naumen")]
    Naumen,
    #[value(name = "AMDPLPA")]
    AMDPLPA,
    #[value(name = "Leptonica")]
    Leptonica,
    #[value(name = "StandardML-NJ")]
    StandardMlNJ,
    #[value(name = "AGPL-3.0-only")]
    AGPLThreeDotZeroOnly,
    #[value(name = "FSFAP-no-warranty-disclaimer")]
    FSFAPNoWarrantyDisclaimer,
    #[value(name = "OLDAP-2.7")]
    OLDAPTwoDotSeven,
    #[value(name = "BSD-3-Clause-Open-MPI")]
    BSDThreeClauseOpenMPI,
    #[value(name = "BSD-2-Clause-Darwin")]
    BSDTwoClauseDarwin,
    #[value(name = "CERN-OHL-1.2")]
    CERNOHLOneDotTwo,
    #[value(name = "SchemeReport")]
    SchemeReport,
    #[value(name = "Community-Spec-1.0")]
    CommunitySpecOneDotZero,
    #[value(name = "CC-BY-NC-ND-3.0-IGO")]
    CCBYNCNDThreeDotZeroIGO,
    #[value(name = "Kazlib")]
    Kazlib,
    #[value(name = "OSET-PL-2.1")]
    OSETPLTwoDotOne,
    #[value(name = "AdaCore-doc")]
    AdaCoreDoc,
    #[value(name = "CC-BY-SA-3.0")]
    CCBYSAThreeDotZero,
    #[value(name = "Eurosym")]
    Eurosym,
    #[value(name = "APL-1.0")]
    APLOneDotZero,
    #[value(name = "CDLA-Permissive-2.0")]
    CDLAPermissiveTwoDotZero,
    #[value(name = "OGC-1.0")]
    OGCOneDotZero,
    #[value(name = "Libpng")]
    Libpng,
    #[value(name = "SWL")]
    SWL,
    #[value(name = "mplus")]
    Mplus,
    #[value(name = "CC-BY-1.0")]
    CCBYOneDotZero,
    #[value(name = "OFFIS")]
    OFFIS,
    #[value(name = "SMPPL")]
    SMPPL,
    #[value(name = "JSON")]
    JSON,
    #[value(name = "GPL-1.0-or-later")]
    GPLOneDotZeroOrLater,
    #[value(name = "O-UDA-1.0")]
    OUDAOneDotZero,
    #[value(name = "MulanPSL-1.0")]
    MulanPslOneDotZero,
    #[value(name = "NAIST-2003")]
    NAISTTwoZeroZeroThree,
    #[value(name = "CC-BY-3.0-IGO")]
    CCBYThreeDotZeroIGO,
    #[value(name = "SMAIL-GPL")]
    SMAILGPL,
    #[value(name = "SCEA")]
    SCEA,
    #[value(name = "CC-BY-NC-2.5")]
    CCBYNCTwoDotFive,
    #[value(name = "check-cvs")]
    CheckCvs,
    #[value(name = "GPL-3.0-with-GCC-exception")]
    GPLThreeDotZeroWithGCCException,
    #[value(name = "Xfig")]
    Xfig,
    #[value(name = "LPPL-1.0")]
    LPPLOneDotZero,
    #[value(name = "CC-BY-NC-3.0")]
    CCBYNCThreeDotZero,
    #[value(name = "SISSL-1.2")]
    SISSLOneDotTwo,
    #[value(name = "Glulxe")]
    Glulxe,
    #[value(name = "Sendmail-8.23")]
    SendmailEightDotTwoThree,
    #[value(name = "X11")]
    XOneOne,
    #[value(name = "OLDAP-1.4")]
    OLDAPOneDotFour,
    #[value(name = "FTL")]
    FTL,
    #[value(name = "CryptoSwift")]
    CryptoSwift,
    #[value(name = "DocBook-Stylesheet")]
    DocBookStylesheet,
    #[value(name = "Bitstream-Vera")]
    BitstreamVera,
    #[value(name = "Xnet")]
    Xnet,
    #[value(name = "OLDAP-2.3")]
    OLDAPTwoDotThree,
    #[value(name = "BlueOak-1.0.0")]
    BlueOakOneDotZeroDotZero,
    #[value(name = "Zend-2.0")]
    ZendTwoDotZero,
    #[value(name = "Soundex")]
    Soundex,
    #[value(name = "CC-BY-NC-ND-2.0")]
    CCBYNCNDTwoDotZero,
    #[value(name = "TTYP0")]
    TtypZero,
    #[value(name = "Apache-1.0")]
    ApacheOneDotZero,
    #[value(name = "BSD-Systemics")]
    BSDSystemics,
    #[value(name = "magaz")]
    Magaz,
    #[value(name = "FDK-AAC")]
    FDKAAC,
    #[value(name = "CC-BY-SA-2.5")]
    CCBYSATwoDotFive,
    #[value(name = "xlock")]
    Xlock,
    #[value(name = "XFree86-1.1")]
    XFreeEightSixOneDotOne,
    #[value(name = "Zed")]
    Zed,
    #[value(name = "PolyForm-Noncommercial-1.0.0")]
    PolyFormNoncommercialOneDotZeroDotZero,
    #[value(name = "ZPL-2.0")]
    ZPLTwoDotZero,
    #[value(name = "NGPL")]
    NGPL,
    #[value(name = "CC-BY-ND-1.0")]
    CCBYNDOneDotZero,
    #[value(name = "LGPL-2.1-only")]
    LGPLTwoDotOneOnly,
    #[value(name = "libpng-2.0")]
    LibpngTwoDotZero,
    #[value(name = "Net-SNMP")]
    NetSNMP,
    #[value(name = "HPND-sell-variant")]
    HPNDSellVariant,
    #[value(name = "TU-Berlin-2.0")]
    TUBerlinTwoDotZero,
    #[value(name = "Ruby-pty")]
    RubyPty,
    #[value(name = "HPND-INRIA-IMAG")]
    HPNDINRIAIMAG,
    #[value(name = "LPPL-1.1")]
    LPPLOneDotOne,
    #[value(name = "GFDL-1.2-no-invariants-only")]
    GFDLOneDotTwoNoInvariantsOnly,
    #[value(name = "HPND-sell-MIT-disclaimer-xserver")]
    HPNDSellMITDisclaimerXserver,
    #[value(name = "MMIXware")]
    MmiXware,
    #[value(name = "EPL-2.0")]
    EPLTwoDotZero,
    #[value(name = "NCSA")]
    NCSA,
    #[value(name = "BSD-3-Clause-No-Military-License")]
    BSDThreeClauseNoMilitaryLicense,
    #[value(name = "GPL-2.0-only")]
    GPLTwoDotZeroOnly,
    #[value(name = "MIT-testregex")]
    MITTestregex,
    #[value(name = "NCGL-UK-2.0")]
    NCGLUKTwoDotZero,
    #[value(name = "OLDAP-2.2")]
    OLDAPTwoDotTwo,
    #[value(name = "CDLA-Sharing-1.0")]
    CDLASharingOneDotZero,
    #[value(name = "CC-BY-NC-ND-3.0")]
    CCBYNCNDThreeDotZero,
    #[value(name = "HP-1989")]
    HPOneNineEightNine,
    #[value(name = "Bahyph")]
    Bahyph,
    #[value(name = "3D-Slicer-1.0")]
    ThreeDSlicerOneDotZero,
    #[value(name = "Apache-1.1")]
    ApacheOneDotOne,
    #[value(name = "Multics")]
    Multics,
    #[value(name = "UPL-1.0")]
    UPLOneDotZero,
    #[value(name = "Nunit")]
    Nunit,
    #[value(name = "TPL-1.0")]
    TPLOneDotZero,
    #[value(name = "FBM")]
    FBM,
    #[value(name = "blessing")]
    Blessing,
    #[value(name = "Unicode-DFS-2016")]
    UnicodeDFSTwoZeroOneSix,
    #[value(name = "Jam")]
    Jam,
    #[value(name = "DocBook-DTD")]
    DocBookDTD,
    #[value(name = "MPL-2.0-no-copyleft-exception")]
    MPLTwoDotZeroNoCopyleftException,
    #[value(name = "BSD-3-Clause-No-Nuclear-License-2014")]
    BSDThreeClauseNoNuclearLicenseTwoZeroOneFour,
    #[value(name = "Interbase-1.0")]
    InterbaseOneDotZero,
    #[value(name = "BSD-3-Clause-LBNL")]
    BSDThreeClauseLBNL,
    #[value(name = "LGPL-2.0-only")]
    LGPLTwoDotZeroOnly,
    #[value(name = "Newsletr")]
    Newsletr,
    #[value(name = "ZPL-2.1")]
    ZPLTwoDotOne,
    #[value(name = "Sleepycat")]
    Sleepycat,
    #[value(name = "CC-BY-NC-2.0")]
    CCBYNCTwoDotZero,
    #[value(name = "X11-swapped")]
    XOneOneSwapped,
    #[value(name = "Latex2e")]
    LatexTwoe,
    #[value(name = "Caldera")]
    Caldera,
    #[value(name = "GD")]
    GD,
    #[value(name = "Frameworx-1.0")]
    FrameworxOneDotZero,
    #[value(name = "Qhull")]
    Qhull,
    #[value(name = "metamail")]
    Metamail,
    #[value(name = "CUA-OPL-1.0")]
    CUAOPLOneDotZero,
    #[value(name = "CC-BY-3.0-NL")]
    CCBYThreeDotZeroNL,
    #[value(name = "Giftware")]
    Giftware,
    #[value(name = "PADL")]
    PADL,
    #[value(name = "BSD-Source-Code")]
    BSDSourceCode,
    #[value(name = "Caldera-no-preamble")]
    CalderaNoPreamble,
    #[value(name = "OLDAP-2.6")]
    OLDAPTwoDotSix,
    #[value(name = "Adobe-Display-PostScript")]
    AdobeDisplayPostScript,
    #[value(name = "Cronyx")]
    Cronyx,
    #[value(name = "LPPL-1.3a")]
    LPPLOneDotThreea,
    #[value(name = "psfrag")]
    Psfrag,
    #[value(name = "CC0-1.0")]
    CcZeroOneDotZero,
    #[value(name = "Martin-Birgmeier")]
    MartinBirgmeier,
    #[value(name = "MIT-Modern-Variant")]
    MITModernVariant,
    #[value(name = "Spencer-99")]
    SpencerNineNine,
    #[value(name = "OLDAP-1.1")]
    OLDAPOneDotOne,
    #[value(name = "FSFAP")]
    FSFAP,
    #[value(name = "GFDL-1.1-only")]
    GFDLOneDotOneOnly,
    #[value(name = "Unlicense")]
    Unlicense,
    #[value(name = "CC-BY-SA-2.0")]
    CCBYSATwoDotZero,
    #[value(name = "MIT-feh")]
    MITFeh,
    #[value(name = "FSFUL")]
    FSFUL,
    #[value(name = "NPOSL-3.0")]
    NPOSLThreeDotZero,
    #[value(name = "Afmparse")]
    Afmparse,
    #[value(name = "CC-BY-NC-ND-2.5")]
    CCBYNCNDTwoDotFive,
    #[value(name = "TTWL")]
    TTWL,
    #[value(name = "BSD-3-Clause")]
    BSDThreeClause,
    #[value(name = "HPND-Markus-Kuhn")]
    HPNDMarkusKuhn,
    #[value(name = "PolyForm-Small-Business-1.0.0")]
    PolyFormSmallBusinessOneDotZeroDotZero,
    #[value(name = "DL-DE-BY-2.0")]
    DLDEBYTwoDotZero,
    #[value(name = "BSD-Inferno-Nettverk")]
    BSDInfernoNettverk,
    #[value(name = "NLOD-1.0")]
    NLODOneDotZero,
    #[value(name = "CC-BY-NC-SA-1.0")]
    CCBYNCSAOneDotZero,
    #[value(name = "CC-BY-3.0-US")]
    CCBYThreeDotZeroUS,
    #[value(name = "OGTSL")]
    OGTSL,
    #[value(name = "Python-2.0.1")]
    PythonTwoDotZeroDotOne,
    #[value(name = "OFL-1.1-RFN")]
    OFLOneDotOneRFN,
    #[value(name = "JasPer-2.0")]
    JasPerTwoDotZero,
    #[value(name = "GPL-2.0-or-later")]
    GPLTwoDotZeroOrLater,
    #[value(name = "ASWF-Digital-Assets-1.0")]
    ASWFDigitalAssetsOneDotZero,
    #[value(name = "LPPL-1.2")]
    LPPLOneDotTwo,
    #[value(name = "NIST-Software")]
    NISTSoftware,
    #[value(name = "W3C")]
    WThreeC,
    #[value(name = "GFDL-1.1-no-invariants-or-later")]
    GFDLOneDotOneNoInvariantsOrLater,
    #[value(name = "Python-2.0")]
    PythonTwoDotZero,
    #[value(name = "threeparttable")]
    Threeparttable,
    #[value(name = "HPND-export2-US")]
    HPNDExportTwoUS,
    #[value(name = "ANTLR-PD-fallback")]
    ANTLRPDFallback,
    #[value(name = "TMate")]
    TMate,
    #[value(name = "OPL-1.0")]
    OPLOneDotZero,
    #[value(name = "OpenPBS-2.3")]
    OpenPbsTwoDotThree,
    #[value(name = "NPL-1.0")]
    NPLOneDotZero,
    #[value(name = "any-OSI")]
    AnyOSI,
    #[value(name = "OGDL-Taiwan-1.0")]
    OGDLTaiwanOneDotZero,
    #[value(name = "dvipdfm")]
    Dvipdfm,
    #[value(name = "hdparm")]
    Hdparm,
    #[value(name = "CC-BY-3.0")]
    CCBYThreeDotZero,
    #[value(name = "mailprio")]
    Mailprio,
    #[value(name = "CC-BY-NC-SA-2.0-DE")]
    CCBYNCSATwoDotZeroDE,
    #[value(name = "SugarCRM-1.1.3")]
    SugarCrmOneDotOneDotThree,
    #[value(name = "Sun-PPP")]
    SunPPP,
    #[value(name = "Brian-Gladman-2-Clause")]
    BrianGladmanTwoClause,
    #[value(name = "LGPL-2.1+")]
    LGPLTwoDotOnePlus,
    #[value(name = "App-s2p")]
    AppSTwop,
    #[value(name = "BSD-2-Clause-FreeBSD")]
    BSDTwoClauseFreeBsd,
    #[value(name = "Symlinks")]
    Symlinks,
    #[value(name = "OLDAP-2.1")]
    OLDAPTwoDotOne,
    #[value(name = "NCBI-PD")]
    NCBIPD,
    #[value(name = "BSD-3-Clause-HP")]
    BSDThreeClauseHP,
    #[value(name = "ICU")]
    ICU,
    #[value(name = "SGI-OpenGL")]
    SGIOpenGl,
    #[value(name = "MIT-Khronos-old")]
    MITKhronosOld,
    #[value(name = "CC-BY-SA-1.0")]
    CCBYSAOneDotZero,
    #[value(name = "CECILL-C")]
    CECILLC,
    #[value(name = "gtkbook")]
    Gtkbook,
    #[value(name = "Widget-Workshop")]
    WidgetWorkshop,
    #[value(name = "CC-SA-1.0")]
    CCSAOneDotZero,
    #[value(name = "LGPL-2.0+")]
    LGPLTwoDotZeroPlus,
    #[value(name = "BSD-Protection")]
    BSDProtection,
    #[value(name = "Noweb")]
    Noweb,
    #[value(name = "Unicode-DFS-2015")]
    UnicodeDFSTwoZeroOneFive,
    #[value(name = "Boehm-GC")]
    BoehmGC,
    #[value(name = "curl")]
    Curl,
    #[value(name = "HPND-MIT-disclaimer")]
    HPNDMITDisclaimer,
    #[value(name = "CC-PDDC")]
    CCPDDC,
    #[value(name = "CC-BY-NC-SA-2.0")]
    CCBYNCSATwoDotZero,
    #[value(name = "NLOD-2.0")]
    NLODTwoDotZero,
    #[value(name = "wxWindows")]
    WxWindows,
    #[value(name = "EPICS")]
    EPICS,
    #[value(name = "HPND-export-US-modify")]
    HPNDExportUSModify,
    #[value(name = "BSD-Advertising-Acknowledgement")]
    BSDAdvertisingAcknowledgement,
    #[value(name = "OFL-1.1-no-RFN")]
    OFLOneDotOneNoRFN,
    #[value(name = "CC-BY-ND-2.5")]
    CCBYNDTwoDotFive,
    #[value(name = "VSL-1.0")]
    VSLOneDotZero,
    #[value(name = "bcrypt-Solar-Designer")]
    BcryptSolarDesigner,
    #[value(name = "SISSL")]
    SISSL,
    #[value(name = "TU-Berlin-1.0")]
    TUBerlinOneDotZero,
    #[value(name = "Parity-6.0.0")]
    ParitySixDotZeroDotZero,
    #[value(name = "SNIA")]
    SNIA,
    #[value(name = "SAX-PD-2.0")]
    SAXPDTwoDotZero,
    #[value(name = "xinetd")]
    Xinetd,
    #[value(name = "TermReadKey")]
    TermReadKey,
    #[value(name = "GPL-3.0-or-later")]
    GPLThreeDotZeroOrLater,
    #[value(name = "HPND-Fenneberg-Livingston")]
    HPNDFennebergLivingston,
    #[value(name = "CC-BY-ND-3.0")]
    CCBYNDThreeDotZero,
    #[value(name = "RHeCos-1.1")]
    RHeCosOneDotOne,
    #[value(name = "MIT-open-group")]
    MITOpenGroup,
    #[value(name = "NBPL-1.0")]
    NBPLOneDotZero,
    #[value(name = "OPL-UK-3.0")]
    OPLUKThreeDotZero,
    #[value(name = "EPL-1.0")]
    EPLOneDotZero,
    #[value(name = "ODC-By-1.0")]
    ODCByOneDotZero,
    #[value(name = "SSPL-1.0")]
    SSPLOneDotZero,
    #[value(name = "MTLL")]
    MTLL,
    #[value(name = "OLDAP-2.5")]
    OLDAPTwoDotFive,
    #[value(name = "PPL")]
    PPL,
    #[value(name = "TOSL")]
    TOSL,
    #[value(name = "Game-Programming-Gems")]
    GameProgrammingGems,
    #[value(name = "OLDAP-1.2")]
    OLDAPOneDotTwo,
    #[value(name = "CC-BY-2.5")]
    CCBYTwoDotFive,
    #[value(name = "CrystalStacker")]
    CrystalStacker,
    #[value(name = "OpenSSL-standalone")]
    OpenSslStandalone,
    #[value(name = "Clips")]
    Clips,
    #[value(name = "CC-BY-SA-3.0-DE")]
    CCBYSAThreeDotZeroDE,
    #[value(name = "OCLC-2.0")]
    OCLCTwoDotZero,
    #[value(name = "cve-tou")]
    CveTou,
    #[value(name = "LZMA-SDK-9.22")]
    LZMASDKNineDotTwoTwo,
    #[value(name = "BSD-3-Clause-Sun")]
    BSDThreeClauseSun,
    #[value(name = "CC-BY-3.0-AT")]
    CCBYThreeDotZeroAT,
    #[value(name = "CC-BY-NC-1.0")]
    CCBYNCOneDotZero,
    #[value(name = "Intel-ACPI")]
    IntelACPI,
    #[value(name = "ZPL-1.1")]
    ZPLOneDotOne,
    #[value(name = "BSD-4.3RENO")]
    BSDFourDotThreeReno,
    #[value(name = "NICTA-1.0")]
    NICTAOneDotZero,
    #[value(name = "CC-BY-ND-3.0-DE")]
    CCBYNDThreeDotZeroDE,
    #[value(name = "BSD-3-Clause-Attribution")]
    BSDThreeClauseAttribution,
    #[value(name = "IBM-pibs")]
    IBMPibs,
    #[value(name = "Info-ZIP")]
    InfoZIP,
    #[value(name = "HIDAPI")]
    HIDAPI,
    #[value(name = "BSL-1.0")]
    BSLOneDotZero,
    #[value(name = "dtoa")]
    Dtoa,
    #[value(name = "etalab-2.0")]
    EtalabTwoDotZero,
    #[value(name = "HPND-Pbmplus")]
    HPNDPbmplus,
    #[value(name = "Bitstream-Charter")]
    BitstreamCharter,
    #[value(name = "PostgreSQL")]
    PostgreSql,
    #[value(name = "CERN-OHL-1.1")]
    CERNOHLOneDotOne,
    #[value(name = "HPND-export-US-acknowledgement")]
    HPNDExportUSAcknowledgement,
    #[value(name = "GPL-3.0+")]
    GPLThreeDotZeroPlus,
    #[value(name = "OLDAP-2.4")]
    OLDAPTwoDotFour,
    #[value(name = "OLDAP-1.3")]
    OLDAPOneDotThree,
    #[value(name = "OLFL-1.3")]
    OLFLOneDotThree,
    #[value(name = "LPPL-1.3c")]
    LPPLOneDotThreec,
    #[value(name = "CC-BY-NC-ND-1.0")]
    CCBYNCNDOneDotZero,
    #[value(name = "CC-BY-SA-2.1-JP")]
    CCBYSATwoDotOneJP,
    #[value(name = "GPL-1.0-only")]
    GPLOneDotZeroOnly,
    #[value(name = "LGPL-2.1-or-later")]
    LGPLTwoDotOneOrLater,
    #[value(name = "Apache-2.0")]
    ApacheTwoDotZero,
    #[value(name = "CERN-OHL-S-2.0")]
    CERNOHLSTwoDotZero,
    #[value(name = "NIST-PD-fallback")]
    NISTPDFallback,
    #[value(name = "radvd")]
    Radvd,
    #[value(name = "FSFULLR")]
    FSFULLR,
    #[value(name = "CMU-Mach-nodoc")]
    CMUMachNodoc,
    #[value(name = "OCCT-PL")]
    OCCTPL,
    #[value(name = "MITNFA")]
    MITNFA,
    #[value(name = "CC-PDM-1.0")]
    CCPDMOneDotZero,
    #[value(name = "CC-BY-3.0-AU")]
    CCBYThreeDotZeroAU,
    #[value(name = "gSOAP-1.3b")]
    GSoapOneDotThreeb,
    #[value(name = "CC-BY-ND-2.0")]
    CCBYNDTwoDotZero,
    #[value(name = "DocBook-XML")]
    DocBookXML,
    #[value(name = "checkmk")]
    Checkmk,
    #[value(name = "Linux-OpenIB")]
    LinuxOpenIb,
    #[value(name = "CC-BY-NC-SA-2.5")]
    CCBYNCSATwoDotFive,
    #[value(name = "CC-BY-NC-ND-3.0-DE")]
    CCBYNCNDThreeDotZeroDE,
    #[value(name = "ASWF-Digital-Assets-1.1")]
    ASWFDigitalAssetsOneDotOne,
    #[value(name = "PHP-3.01")]
    PHPThreeDotZeroOne,
    #[value(name = "CC-BY-NC-SA-3.0")]
    CCBYNCSAThreeDotZero,
    #[value(name = "libselinux-1.0")]
    LibselinuxOneDotZero,
    #[value(name = "JPL-image")]
    JPLImage,
    #[value(name = "NPL-1.1")]
    NPLOneDotOne,
    #[value(name = "any-OSI-perl-modules")]
    AnyOSIPerlModules,
    #[value(name = "libutil-David-Nugent")]
    LibutilDavidNugent,
    #[value(name = "GFDL-1.2-or-later")]
    GFDLOneDotTwoOrLater,
    #[value(name = "CDLA-Permissive-1.0")]
    CDLAPermissiveOneDotZero,
    #[value(name = "HPND-Kevlin-Henney")]
    HPNDKevlinHenney,
    #[value(name = "CMU-Mach")]
    CMUMach,
    #[value(name = "CC-BY-NC-SA-3.0-DE")]
    CCBYNCSAThreeDotZeroDE,
    #[value(name = "OLDAP-2.0")]
    OLDAPTwoDotZero,
    #[value(name = "BSD-2-Clause-first-lines")]
    BSDTwoClauseFirstLines,
    #[value(name = "GPL-1.0+")]
    GPLOneDotZeroPlus,
    #[value(name = "CECILL-B")]
    CECILLB,
    #[value(name = "Graphics-Gems")]
    GraphicsGems,
    #[value(name = "GFDL-1.3-invariants-or-later")]
    GFDLOneDotThreeInvariantsOrLater,
    #[value(name = "Xdebug-1.03")]
    XdebugOneDotZeroThree,
    #[value(name = "swrule")]
    Swrule,
    #[value(name = "pkgconf")]
    Pkgconf,
    #[value(name = "OpenSSL")]
    OpenSsl,
    #[value(name = "CC-BY-2.0")]
    CCBYTwoDotZero,
    #[value(name = "QPL-1.0")]
    QPLOneDotZero,
    #[value(name = "DSDP")]
    DSDP,
    #[value(name = "Intel")]
    Intel,
    #[value(name = "CC-BY-NC-SA-3.0-IGO")]
    CCBYNCSAThreeDotZeroIGO,
    #[value(name = "Pixar")]
    Pixar,
    #[value(name = "xkeyboard-config-Zinoviev")]
    XkeyboardConfigZinoviev,
    #[value(name = "BSD-2-Clause-Views")]
    BSDTwoClauseViews,
    #[value(name = "CNRI-Python")]
    CNRIPython,
    #[value(name = "MulanPSL-2.0")]
    MulanPslTwoDotZero,
    #[value(name = "eGenix")]
    EGenix,
    #[value(name = "Glide")]
    Glide,
    #[value(name = "LPL-1.02")]
    LPLOneDotZeroTwo,
    #[value(name = "Xerox")]
    Xerox,
    #[value(name = "xzoom")]
    Xzoom,
    #[value(name = "MS-LPL")]
    MSLPL,
    #[value(name = "DRL-1.1")]
    DRLOneDotOne,
    #[value(name = "Spencer-94")]
    SpencerNineFour,
    #[value(name = "Brian-Gladman-3-Clause")]
    BrianGladmanThreeClause,
    #[value(name = "CDL-1.0")]
    CDLOneDotZero,
    #[value(name = "UCL-1.0")]
    UCLOneDotZero,
    #[value(name = "Adobe-Utopia")]
    AdobeUtopia,
    #[value(name = "libtiff")]
    Libtiff,
    #[value(name = "MPL-2.0")]
    MPLTwoDotZero,
    #[value(name = "UMich-Merit")]
    UMichMerit,
    #[value(name = "man2html")]
    ManTwohtml,
    #[value(name = "GFDL-1.3-no-invariants-or-later")]
    GFDLOneDotThreeNoInvariantsOrLater,
    #[value(name = "NOSL")]
    NOSL,
    #[value(name = "AMPAS")]
    AMPAS,
    #[value(name = "Elastic-2.0")]
    ElasticTwoDotZero,
    #[value(name = "BSD-2-Clause-Patent")]
    BSDTwoClausePatent,
    #[value(name = "GFDL-1.2-invariants-or-later")]
    GFDLOneDotTwoInvariantsOrLater,
    #[value(name = "mpich2")]
    MpichTwo,
    #[value(name = "WTFPL")]
    WTFPL,
    #[value(name = "AFL-1.2")]
    AFLOneDotTwo,
    #[value(name = "EUDatagrid")]
    EuDatagrid,
    #[value(name = "Artistic-1.0-cl8")]
    ArtisticOneDotZeroClEight,
    #[value(name = "NTP")]
    NTP,
    #[value(name = "TGPPL-1.0")]
    TGPPLOneDotZero,
    #[value(name = "APSL-1.2")]
    APSLOneDotTwo,
    #[value(name = "EFL-1.0")]
    EFLOneDotZero,
    #[value(name = "CERN-OHL-W-2.0")]
    CERNOHLWTwoDotZero,
    #[value(name = "Ruby")]
    Ruby,
    #[value(name = "Condor-1.1")]
    CondorOneDotOne,
    #[value(name = "GFDL-1.1-or-later")]
    GFDLOneDotOneOrLater,
    #[value(name = "CECILL-1.1")]
    CECILLOneDotOne,
    #[value(name = "OLDAP-2.2.1")]
    OLDAPTwoDotTwoDotOne,
    #[value(name = "OFL-1.0-no-RFN")]
    OFLOneDotZeroNoRFN,
    #[value(name = "AGPL-1.0-only")]
    AGPLOneDotZeroOnly,
    #[value(name = "HTMLTIDY")]
    HTMLTIDY,
    #[value(name = "BSD-Source-beginning-file")]
    BSDSourceBeginningFile,
    #[value(name = "Zimbra-1.3")]
    ZimbraOneDotThree,
    #[value(name = "SHL-0.5")]
    SHLZeroDotFive,
    #[value(name = "BitTorrent-1.0")]
    BitTorrentOneDotZero,
    #[value(name = "Kastrup")]
    Kastrup,
    #[value(name = "Sendmail-Open-Source-1.1")]
    SendmailOpenSourceOneDotOne,
    #[value(name = "Baekmuk")]
    Baekmuk,
    #[value(name = "Sun-PPP-2000")]
    SunPPPTwoZeroZeroZero,
    #[value(name = "PHP-3.0")]
    PHPThreeDotZero,
    #[value(name = "ECL-2.0")]
    ECLTwoDotZero,
    #[value(name = "OGL-UK-1.0")]
    OGLUKOneDotZero,
    #[value(name = "HPND-export-US")]
    HPNDExportUS,
    #[value(name = "ssh-keyscan")]
    SshKeyscan,
    #[value(name = "CDDL-1.0")]
    CDDLOneDotZero,
    #[value(name = "Borceux")]
    Borceux,
    #[value(name = "mpi-permissive")]
    MpiPermissive,
    #[value(name = "OFL-1.0")]
    OFLOneDotZero,
    #[value(name = "Ubuntu-font-1.0")]
    UbuntuFontOneDotZero,
    #[value(name = "BSD-Attribution-HPND-disclaimer")]
    BSDAttributionHPNDDisclaimer,
    #[value(name = "APAFML")]
    APAFML,
    #[value(name = "CFITSIO")]
    CFITSIO,
    #[value(name = "Cornell-Lossless-JPEG")]
    CornellLosslessJPEG,
    #[value(name = "eCos-2.0")]
    ECosTwoDotZero,
    #[value(name = "OSL-1.0")]
    OSLOneDotZero,
    #[value(name = "AML")]
    AML,
    #[value(name = "GPL-2.0")]
    GPLTwoDotZero,
    #[value(name = "AFL-2.1")]
    AFLTwoDotOne,
    #[value(name = "GPL-2.0-with-autoconf-exception")]
    GPLTwoDotZeroWithAutoconfException,
    #[value(name = "wwl")]
    Wwl,
    #[value(name = "Motosoto")]
    Motosoto,
    #[value(name = "w3m")]
    WThreem,
    #[value(name = "iMatix")]
    IMatix,
    #[value(name = "CC-BY-SA-3.0-IGO")]
    CCBYSAThreeDotZeroIGO,
    #[value(name = "SunPro")]
    SunPro,
    #[value(name = "OGL-Canada-2.0")]
    OGLCanadaTwoDotZero,
    #[value(name = "MirOS")]
    MirOs,
    #[value(name = "LPD-document")]
    LPDDocument,
    #[value(name = "HPND-doc-sell")]
    HPNDDocSell,
    #[value(name = "AFL-3.0")]
    AFLThreeDotZero,
    #[value(name = "TPDL")]
    TPDL,
    #[value(name = "NCL")]
    NCL,
    #[value(name = "BSD-Systemics-W3Works")]
    BSDSystemicsWThreeWorks,
    #[value(name = "pnmstitch")]
    Pnmstitch,
    #[value(name = "GFDL-1.1-no-invariants-only")]
    GFDLOneDotOneNoInvariantsOnly,
    #[value(name = "CC-BY-SA-2.0-UK")]
    CCBYSATwoDotZeroUK,
    #[value(name = "GFDL-1.1-invariants-only")]
    GFDLOneDotOneInvariantsOnly,
    #[value(name = "GPL-2.0-with-font-exception")]
    GPLTwoDotZeroWithFontException,
    #[value(name = "CC-BY-NC-SA-4.0")]
    CCBYNCSAFourDotZero,
    #[value(name = "HPND-sell-variant-MIT-disclaimer")]
    HPNDSellVariantMITDisclaimer,
    #[value(name = "Abstyles")]
    Abstyles,
    #[value(name = "Catharon")]
    Catharon,
    #[value(name = "AGPL-1.0")]
    AGPLOneDotZero,
    #[value(name = "LGPL-3.0+")]
    LGPLThreeDotZeroPlus,
    #[value(name = "HPND-UC-export-US")]
    HPNDUCExportUS,
    #[value(name = "CDDL-1.1")]
    CDDLOneDotOne,
    #[value(name = "OFL-1.1")]
    OFLOneDotOne,
    #[value(name = "IPL-1.0")]
    IPLOneDotZero,
    #[value(name = "EUPL-1.2")]
    EUPLOneDotTwo,
    #[value(name = "UnixCrypt")]
    UnixCrypt,
    #[value(name = "RSCPL")]
    RSCPL,
    #[value(name = "Linux-man-pages-copyleft")]
    LinuxManPagesCopyleft,
    #[value(name = "SSH-short")]
    SSHShort,
    #[value(name = "OFL-1.0-RFN")]
    OFLOneDotZeroRFN,
    #[value(name = "Mackerras-3-Clause")]
    MackerrasThreeClause,
    #[value(name = "OSL-1.1")]
    OSLOneDotOne,
    #[value(name = "IJG-short")]
    IJGShort,
    #[value(name = "AFL-2.0")]
    AFLTwoDotZero,
    #[value(name = "GFDL-1.2-invariants-only")]
    GFDLOneDotTwoInvariantsOnly,
    #[value(name = "APSL-2.0")]
    APSLTwoDotZero,
    #[value(name = "W3C-19980720")]
    WThreeCOneNineNineEightZeroSevenTwoZero,
    #[value(name = "TORQUE-1.1")]
    TORQUEOneDotOne,
    #[value(name = "zlib-acknowledgement")]
    ZlibAcknowledgement,
    #[value(name = "Unicode-TOU")]
    UnicodeTOU,
    #[value(name = "URT-RLE")]
    URTRLE,
    #[value(name = "GPL-3.0")]
    GPLThreeDotZero,
    #[value(name = "Fair")]
    Fair,
    #[value(name = "SL")]
    SL,
    #[value(name = "CC-BY-4.0")]
    CCBYFourDotZero,
    #[value(name = "RSA-MD")]
    RSAMD,
    #[value(name = "HPND")]
    HPND,
    #[value(name = "Beerware")]
    Beerware,
    #[value(name = "Watcom-1.0")]
    WatcomOneDotZero,
    #[value(name = "diffmark")]
    Diffmark,
    #[value(name = "IEC-Code-Components-EULA")]
    IECCodeComponentsEULA,
    #[value(name = "BSD-3-Clause-Modification")]
    BSDThreeClauseModification,
    #[value(name = "GPL-2.0-with-GCC-exception")]
    GPLTwoDotZeroWithGCCException,
    #[value(name = "GCR-docs")]
    GCRDocs,
    #[value(name = "BSD-3-Clause-No-Nuclear-Warranty")]
    BSDThreeClauseNoNuclearWarranty,
    #[value(name = "CC-BY-NC-3.0-DE")]
    CCBYNCThreeDotZeroDE,
    #[value(name = "PDDL-1.0")]
    PDDLOneDotZero,
    #[value(name = "DRL-1.0")]
    DRLOneDotZero,
    #[value(name = "Artistic-2.0")]
    ArtisticTwoDotZero,
    #[value(name = "CC-BY-NC-SA-2.0-FR")]
    CCBYNCSATwoDotZeroFR,
    #[value(name = "SGI-B-2.0")]
    SGIBTwoDotZero,
    #[value(name = "CC-BY-NC-SA-2.0-UK")]
    CCBYNCSATwoDotZeroUK,
    #[value(name = "GFDL-1.1")]
    GFDLOneDotOne,
    #[value(name = "LGPLLR")]
    LGPLLR,
    #[value(name = "CC-BY-2.5-AU")]
    CCBYTwoDotFiveAU,
    #[value(name = "BSD-1-Clause")]
    BSDOneClause,
    #[value(name = "GFDL-1.1-invariants-or-later")]
    GFDLOneDotOneInvariantsOrLater,
    #[value(name = "bzip2-1.0.5")]
    BzipTwoOneDotZeroDotFive,
    #[value(name = "GPL-2.0+")]
    GPLTwoDotZeroPlus,
    #[value(name = "GPL-2.0-with-bison-exception")]
    GPLTwoDotZeroWithBisonException,
    #[value(name = "GFDL-1.3-no-invariants-only")]
    GFDLOneDotThreeNoInvariantsOnly,
    #[value(name = "SMLNJ")]
    SMLNJ,
    #[value(name = "GL2PS")]
    GlTwoPs,
    #[value(name = "CPL-1.0")]
    CPLOneDotZero,
    #[value(name = "DL-DE-ZERO-2.0")]
    DLDEZEROTwoDotZero,
    #[value(name = "MIT")]
    MIT,
    #[value(name = "Minpack")]
    Minpack,
    #[value(name = "MIT-enna")]
    MITEnna,
    #[value(name = "QPL-1.0-INRIA-2004")]
    QPLOneDotZeroINRIATwoZeroZeroFour,
    #[value(name = "MIT-advertising")]
    MITAdvertising,
    #[value(name = "ImageMagick")]
    ImageMagick,
    #[value(name = "HPND-DEC")]
    HPNDDEC,
    #[value(name = "CECILL-1.0")]
    CECILLOneDotZero,
    #[value(name = "Lucida-Bitmap-Fonts")]
    LucidaBitmapFonts,
    #[value(name = "lsof")]
    Lsof,
    #[value(name = "FreeImage")]
    FreeImage,
    #[value(name = "BSD-4.3TAHOE")]
    BSDFourDotThreeTahoe,
    #[value(name = "BSD-2-Clause-NetBSD")]
    BSDTwoClauseNetBsd,
    #[value(name = "NRL")]
    NRL,
    #[value(name = "X11-distribute-modifications-variant")]
    XOneOneDistributeModificationsVariant,
    #[value(name = "LZMA-SDK-9.11-to-9.20")]
    LZMASDKNineDotOneOneToNineDotTwoZero,
    #[value(name = "ISC")]
    ISC,
    #[value(name = "BSD-4-Clause-Shortened")]
    BSDFourClauseShortened,
    #[value(name = "LGPL-3.0-or-later")]
    LGPLThreeDotZeroOrLater,
    #[value(name = "BitTorrent-1.1")]
    BitTorrentOneDotOne,
    #[value(name = "gnuplot")]
    Gnuplot,
    #[value(name = "DEC-3-Clause")]
    DECThreeClause,
    #[value(name = "CC-BY-ND-4.0")]
    CCBYNDFourDotZero,
    #[value(name = "AGPL-3.0-or-later")]
    AGPLThreeDotZeroOrLater,
    #[value(name = "C-UDA-1.0")]
    CUDAOneDotZero,
    #[value(name = "CATOSL-1.1")]
    CATOSLOneDotOne,
}
#[derive(Debug, Clone, PartialEq, Eq)]
pub struct ParseLicenseError;
impl std::fmt::Display for ParseLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "Provided string does not match any known license filename"
        )
    }
}
impl std::error::Error for ParseLicenseError {}
impl License {
    #[doc = r#" Returns the original filename of the license (e.g., "Apache-2.0.md")."#]
    pub fn spdx_id(&self) -> &'static str {
        match self {
            Self::CNRIPythonGPLCompatible => "CNRI-Python-GPL-Compatible",
            Self::HPOneNineEightSix => "HP-1986",
            Self::EUPLOneDotOne => "EUPL-1.1",
            Self::Cube => "Cube",
            Self::CNRIJython => "CNRI-Jython",
            Self::ArtisticOneDotZero => "Artistic-1.0",
            Self::LGPLThreeDotZero => "LGPL-3.0",
            Self::HPNDMerchantabilityVariant => "HPND-merchantability-variant",
            Self::IJG => "IJG",
            Self::CCBYSAThreeDotZeroAT => "CC-BY-SA-3.0-AT",
            Self::Dotseqn => "Dotseqn",
            Self::HPNDNetrek => "HPND-Netrek",
            Self::JPNIC => "JPNIC",
            Self::MPLOneDotOne => "MPL-1.1",
            Self::SGIBOneDotZero => "SGI-B-1.0",
            Self::ArtisticOneDotZeroPerl => "Artistic-1.0-Perl",
            Self::CopyleftNextZeroDotThreeDotZero => "copyleft-next-0.3.0",
            Self::Fwlw => "fwlw",
            Self::CCBYThreeDotZeroDE => "CC-BY-3.0-DE",
            Self::OLDAPTwoDotZeroDotOne => "OLDAP-2.0.1",
            Self::Xpp => "xpp",
            Self::DocBookSchema => "DocBook-Schema",
            Self::CERNOHLPTwoDotZero => "CERN-OHL-P-2.0",
            Self::GLWTPL => "GLWTPL",
            Self::CPALOneDotZero => "CPAL-1.0",
            Self::WThreeCTwoZeroOneFiveZeroFiveOneThree => "W3C-20150513",
            Self::CCBYNCNDFourDotZero => "CC-BY-NC-ND-4.0",
            Self::Sendmail => "Sendmail",
            Self::SoftSurfer => "softSurfer",
            Self::CALOneDotZeroCombinedWorkException => "CAL-1.0-Combined-Work-Exception",
            Self::ImlibTwo => "Imlib2",
            Self::CECILLTwoDotZero => "CECILL-2.0",
            Self::HPNDSellRegexpr => "HPND-sell-regexpr",
            Self::ADSL => "ADSL",
            Self::TrustedQsl => "TrustedQSL",
            Self::ParitySevenDotZeroDotZero => "Parity-7.0.0",
            Self::MakeIndex => "MakeIndex",
            Self::OML => "OML",
            Self::LiLiQRplusOneDotOne => "LiLiQ-Rplus-1.1",
            Self::SPLOneDotZero => "SPL-1.0",
            Self::DOC => "DOC",
            Self::NTPZero => "NTP-0",
            Self::GFDLOneDotThreeOrLater => "GFDL-1.3-or-later",
            Self::NASAOneDotThree => "NASA-1.3",
            Self::LGPLTwoDotOne => "LGPL-2.1",
            Self::Ulem => "ulem",
            Self::GFDLOneDotThreeInvariantsOnly => "GFDL-1.3-invariants-only",
            Self::HPNDSellVariantMITDisclaimerRev => "HPND-sell-variant-MIT-disclaimer-rev",
            Self::FSFULLRWD => "FSFULLRWD",
            Self::AGPLThreeDotZero => "AGPL-3.0",
            Self::LGPLTwoDotZeroOrLater => "LGPL-2.0-or-later",
            Self::AMLGlslang => "AML-glslang",
            Self::OpenVision => "OpenVision",
            Self::BzipTwoOneDotZeroDotSix => "bzip2-1.0.6",
            Self::GFDLOneDotTwo => "GFDL-1.2",
            Self::LinuxManPagesOnePara => "Linux-man-pages-1-para",
            Self::OSLTwoDotOne => "OSL-2.1",
            Self::Crossword => "Crossword",
            Self::UnicodeThreeDotZero => "Unicode-3.0",
            Self::BSDFourClause => "BSD-4-Clause",
            Self::SsLeayStandalone => "SSLeay-standalone",
            Self::SgpFour => "SGP4",
            Self::SHLZeroDotFiveOne => "SHL-0.51",
            Self::HPNDIntel => "HPND-Intel",
            Self::LiLiQROneDotOne => "LiLiQ-R-1.1",
            Self::APSLOneDotZero => "APSL-1.0",
            Self::COILOneDotZero => "COIL-1.0",
            Self::Vim => "Vim",
            Self::Snprintf => "snprintf",
            Self::AdobeTwoZeroZeroSix => "Adobe-2006",
            Self::CPOLOneDotZeroTwo => "CPOL-1.02",
            Self::MITZero => "MIT-0",
            Self::BSDThreeClauseClear => "BSD-3-Clause-Clear",
            Self::FergusonTwofish => "Ferguson-Twofish",
            Self::OSLThreeDotZero => "OSL-3.0",
            Self::TAPROHLOneDotZero => "TAPR-OHL-1.0",
            Self::PythonLdap => "python-ldap",
            Self::SimPlTwoDotZero => "SimPL-2.0",
            Self::VOSTROM => "VOSTROM",
            Self::SSHOpenSsh => "SSH-OpenSSH",
            Self::LinuxManPagesCopyleftVar => "Linux-man-pages-copyleft-var",
            Self::MPEGSSG => "MPEG-SSG",
            Self::NISTPD => "NIST-PD",
            Self::YPLOneDotZero => "YPL-1.0",
            Self::XSkat => "XSkat",
            Self::LALOneDotThree => "LAL-1.3",
            Self::BSDThreeClauseAcpica => "BSD-3-Clause-acpica",
            Self::GFDLOneDotThreeOnly => "GFDL-1.3-only",
            Self::Entessa => "Entessa",
            Self::LatexTwoeTranslatedNotice => "Latex2e-translated-notice",
            Self::LOOP => "LOOP",
            Self::Wsuipa => "Wsuipa",
            Self::SpencerEightSix => "Spencer-86",
            Self::OGLUKThreeDotZero => "OGL-UK-3.0",
            Self::HippocraticTwoDotOne => "Hippocratic-2.1",
            Self::GPLThreeDotZeroOnly => "GPL-3.0-only",
            Self::Furuseth => "Furuseth",
            Self::OGLUKTwoDotZero => "OGL-UK-2.0",
            Self::LiLiQPOneDotOne => "LiLiQ-P-1.1",
            Self::Barr => "Barr",
            Self::HPNDUC => "HPND-UC",
            Self::MSPL => "MS-PL",
            Self::BSDFourClauseUC => "BSD-4-Clause-UC",
            Self::AGPLOneDotZeroOrLater => "AGPL-1.0-or-later",
            Self::NLPL => "NLPL",
            Self::AMDNewlib => "AMD-newlib",
            Self::OLDAPTwoDotEight => "OLDAP-2.8",
            Self::GFDLOneDotThree => "GFDL-1.3",
            Self::KnuthCTAN => "Knuth-CTAN",
            Self::HaskellReport => "HaskellReport",
            Self::OSLTwoDotZero => "OSL-2.0",
            Self::MITWu => "MIT-Wu",
            Self::AAL => "AAL",
            Self::AFLOneDotOne => "AFL-1.1",
            Self::ArphicOneNineNineNine => "Arphic-1999",
            Self::GPLOneDotZero => "GPL-1.0",
            Self::ErlPlOneDotOne => "ErlPL-1.1",
            Self::LinuxManPagesCopyleftTwoPara => "Linux-man-pages-copyleft-2-para",
            Self::Nokia => "Nokia",
            Self::MITClick => "MIT-Click",
            Self::McPheeSlideshow => "McPhee-slideshow",
            Self::APSLOneDotOne => "APSL-1.1",
            Self::OLDAPTwoDotTwoDotTwo => "OLDAP-2.2.2",
            Self::LGPLThreeDotZeroOnly => "LGPL-3.0-only",
            Self::CCBYSAFourDotZero => "CC-BY-SA-4.0",
            Self::MITFestival => "MIT-Festival",
            Self::RPLOneDotFive => "RPL-1.5",
            Self::ZeroBsd => "0BSD",
            Self::HPNDDoc => "HPND-doc",
            Self::ClArtistic => "ClArtistic",
            Self::TCPWrappers => "TCP-wrappers",
            Self::GenericXts => "generic-xts",
            Self::ISCVeillard => "ISC-Veillard",
            Self::Rdisc => "Rdisc",
            Self::ODbLOneDotZero => "ODbL-1.0",
            Self::Plexus => "Plexus",
            Self::BoehmGCWithoutFee => "Boehm-GC-without-fee",
            Self::InnerNetTwoDotZero => "Inner-Net-2.0",
            Self::YPLOneDotOne => "YPL-1.1",
            Self::LALOneDotTwo => "LAL-1.2",
            Self::ANTLRPD => "ANTLR-PD",
            Self::UCAR => "UCAR",
            Self::GFDLOneDotTwoOnly => "GFDL-1.2-only",
            Self::Zlib => "Zlib",
            Self::EUPLOneDotZero => "EUPL-1.0",
            Self::Gutmann => "Gutmann",
            Self::InnoSetup => "InnoSetup",
            Self::MackerrasThreeClauseAcknowledgment => "Mackerras-3-Clause-acknowledgment",
            Self::LPLOneDotZero => "LPL-1.0",
            Self::SGIBOneDotOne => "SGI-B-1.1",
            Self::MPLOneDotZero => "MPL-1.0",
            Self::DFSLOneDotZero => "D-FSL-1.0",
            Self::CopyleftNextZeroDotThreeDotOne => "copyleft-next-0.3.1",
            Self::Saxpath => "Saxpath",
            Self::OAR => "OAR",
            Self::OPUBLOneDotZero => "OPUBL-1.0",
            Self::TCL => "TCL",
            Self::EFLTwoDotZero => "EFL-2.0",
            Self::Aladdin => "Aladdin",
            Self::GPLTwoDotZeroWithClasspathException => "GPL-2.0-with-classpath-exception",
            Self::ThirdEye => "ThirdEye",
            Self::MIPS => "MIPS",
            Self::RPSLOneDotZero => "RPSL-1.0",
            Self::MITCMU => "MIT-CMU",
            Self::FreeBsdDOC => "FreeBSD-DOC",
            Self::CALOneDotZero => "CAL-1.0",
            Self::ZimbraOneDotFour => "Zimbra-1.4",
            Self::BUSLOneDotOne => "BUSL-1.1",
            Self::Psutils => "psutils",
            Self::CECILLTwoDotOne => "CECILL-2.1",
            Self::Zeeff => "Zeeff",
            Self::Mup => "Mup",
            Self::GFDLOneDotTwoNoInvariantsOrLater => "GFDL-1.2-no-invariants-or-later",
            Self::GPLThreeDotZeroWithAutoconfException => "GPL-3.0-with-autoconf-exception",
            Self::RPLOneDotOne => "RPL-1.1",
            Self::AdobeGlyph => "Adobe-Glyph",
            Self::BSDThreeClauseFlex => "BSD-3-Clause-flex",
            Self::CCBYNCFourDotZero => "CC-BY-NC-4.0",
            Self::MSRL => "MS-RL",
            Self::BSDThreeClauseNoNuclearLicense => "BSD-3-Clause-No-Nuclear-License",
            Self::IPA => "IPA",
            Self::LGPLTwoDotZero => "LGPL-2.0",
            Self::NetCdf => "NetCDF",
            Self::ECLOneDotZero => "ECL-1.0",
            Self::BSDTwoClause => "BSD-2-Clause",
            Self::SAXPD => "SAX-PD",
            Self::PSFTwoDotZero => "PSF-2.0",
            Self::Naumen => "Naumen",
            Self::AMDPLPA => "AMDPLPA",
            Self::Leptonica => "Leptonica",
            Self::StandardMlNJ => "StandardML-NJ",
            Self::AGPLThreeDotZeroOnly => "AGPL-3.0-only",
            Self::FSFAPNoWarrantyDisclaimer => "FSFAP-no-warranty-disclaimer",
            Self::OLDAPTwoDotSeven => "OLDAP-2.7",
            Self::BSDThreeClauseOpenMPI => "BSD-3-Clause-Open-MPI",
            Self::BSDTwoClauseDarwin => "BSD-2-Clause-Darwin",
            Self::CERNOHLOneDotTwo => "CERN-OHL-1.2",
            Self::SchemeReport => "SchemeReport",
            Self::CommunitySpecOneDotZero => "Community-Spec-1.0",
            Self::CCBYNCNDThreeDotZeroIGO => "CC-BY-NC-ND-3.0-IGO",
            Self::Kazlib => "Kazlib",
            Self::OSETPLTwoDotOne => "OSET-PL-2.1",
            Self::AdaCoreDoc => "AdaCore-doc",
            Self::CCBYSAThreeDotZero => "CC-BY-SA-3.0",
            Self::Eurosym => "Eurosym",
            Self::APLOneDotZero => "APL-1.0",
            Self::CDLAPermissiveTwoDotZero => "CDLA-Permissive-2.0",
            Self::OGCOneDotZero => "OGC-1.0",
            Self::Libpng => "Libpng",
            Self::SWL => "SWL",
            Self::Mplus => "mplus",
            Self::CCBYOneDotZero => "CC-BY-1.0",
            Self::OFFIS => "OFFIS",
            Self::SMPPL => "SMPPL",
            Self::JSON => "JSON",
            Self::GPLOneDotZeroOrLater => "GPL-1.0-or-later",
            Self::OUDAOneDotZero => "O-UDA-1.0",
            Self::MulanPslOneDotZero => "MulanPSL-1.0",
            Self::NAISTTwoZeroZeroThree => "NAIST-2003",
            Self::CCBYThreeDotZeroIGO => "CC-BY-3.0-IGO",
            Self::SMAILGPL => "SMAIL-GPL",
            Self::SCEA => "SCEA",
            Self::CCBYNCTwoDotFive => "CC-BY-NC-2.5",
            Self::CheckCvs => "check-cvs",
            Self::GPLThreeDotZeroWithGCCException => "GPL-3.0-with-GCC-exception",
            Self::Xfig => "Xfig",
            Self::LPPLOneDotZero => "LPPL-1.0",
            Self::CCBYNCThreeDotZero => "CC-BY-NC-3.0",
            Self::SISSLOneDotTwo => "SISSL-1.2",
            Self::Glulxe => "Glulxe",
            Self::SendmailEightDotTwoThree => "Sendmail-8.23",
            Self::XOneOne => "X11",
            Self::OLDAPOneDotFour => "OLDAP-1.4",
            Self::FTL => "FTL",
            Self::CryptoSwift => "CryptoSwift",
            Self::DocBookStylesheet => "DocBook-Stylesheet",
            Self::BitstreamVera => "Bitstream-Vera",
            Self::Xnet => "Xnet",
            Self::OLDAPTwoDotThree => "OLDAP-2.3",
            Self::BlueOakOneDotZeroDotZero => "BlueOak-1.0.0",
            Self::ZendTwoDotZero => "Zend-2.0",
            Self::Soundex => "Soundex",
            Self::CCBYNCNDTwoDotZero => "CC-BY-NC-ND-2.0",
            Self::TtypZero => "TTYP0",
            Self::ApacheOneDotZero => "Apache-1.0",
            Self::BSDSystemics => "BSD-Systemics",
            Self::Magaz => "magaz",
            Self::FDKAAC => "FDK-AAC",
            Self::CCBYSATwoDotFive => "CC-BY-SA-2.5",
            Self::Xlock => "xlock",
            Self::XFreeEightSixOneDotOne => "XFree86-1.1",
            Self::Zed => "Zed",
            Self::PolyFormNoncommercialOneDotZeroDotZero => "PolyForm-Noncommercial-1.0.0",
            Self::ZPLTwoDotZero => "ZPL-2.0",
            Self::NGPL => "NGPL",
            Self::CCBYNDOneDotZero => "CC-BY-ND-1.0",
            Self::LGPLTwoDotOneOnly => "LGPL-2.1-only",
            Self::LibpngTwoDotZero => "libpng-2.0",
            Self::NetSNMP => "Net-SNMP",
            Self::HPNDSellVariant => "HPND-sell-variant",
            Self::TUBerlinTwoDotZero => "TU-Berlin-2.0",
            Self::RubyPty => "Ruby-pty",
            Self::HPNDINRIAIMAG => "HPND-INRIA-IMAG",
            Self::LPPLOneDotOne => "LPPL-1.1",
            Self::GFDLOneDotTwoNoInvariantsOnly => "GFDL-1.2-no-invariants-only",
            Self::HPNDSellMITDisclaimerXserver => "HPND-sell-MIT-disclaimer-xserver",
            Self::MmiXware => "MMIXware",
            Self::EPLTwoDotZero => "EPL-2.0",
            Self::NCSA => "NCSA",
            Self::BSDThreeClauseNoMilitaryLicense => "BSD-3-Clause-No-Military-License",
            Self::GPLTwoDotZeroOnly => "GPL-2.0-only",
            Self::MITTestregex => "MIT-testregex",
            Self::NCGLUKTwoDotZero => "NCGL-UK-2.0",
            Self::OLDAPTwoDotTwo => "OLDAP-2.2",
            Self::CDLASharingOneDotZero => "CDLA-Sharing-1.0",
            Self::CCBYNCNDThreeDotZero => "CC-BY-NC-ND-3.0",
            Self::HPOneNineEightNine => "HP-1989",
            Self::Bahyph => "Bahyph",
            Self::ThreeDSlicerOneDotZero => "3D-Slicer-1.0",
            Self::ApacheOneDotOne => "Apache-1.1",
            Self::Multics => "Multics",
            Self::UPLOneDotZero => "UPL-1.0",
            Self::Nunit => "Nunit",
            Self::TPLOneDotZero => "TPL-1.0",
            Self::FBM => "FBM",
            Self::Blessing => "blessing",
            Self::UnicodeDFSTwoZeroOneSix => "Unicode-DFS-2016",
            Self::Jam => "Jam",
            Self::DocBookDTD => "DocBook-DTD",
            Self::MPLTwoDotZeroNoCopyleftException => "MPL-2.0-no-copyleft-exception",
            Self::BSDThreeClauseNoNuclearLicenseTwoZeroOneFour => {
                "BSD-3-Clause-No-Nuclear-License-2014"
            }
            Self::InterbaseOneDotZero => "Interbase-1.0",
            Self::BSDThreeClauseLBNL => "BSD-3-Clause-LBNL",
            Self::LGPLTwoDotZeroOnly => "LGPL-2.0-only",
            Self::Newsletr => "Newsletr",
            Self::ZPLTwoDotOne => "ZPL-2.1",
            Self::Sleepycat => "Sleepycat",
            Self::CCBYNCTwoDotZero => "CC-BY-NC-2.0",
            Self::XOneOneSwapped => "X11-swapped",
            Self::LatexTwoe => "Latex2e",
            Self::Caldera => "Caldera",
            Self::GD => "GD",
            Self::FrameworxOneDotZero => "Frameworx-1.0",
            Self::Qhull => "Qhull",
            Self::Metamail => "metamail",
            Self::CUAOPLOneDotZero => "CUA-OPL-1.0",
            Self::CCBYThreeDotZeroNL => "CC-BY-3.0-NL",
            Self::Giftware => "Giftware",
            Self::PADL => "PADL",
            Self::BSDSourceCode => "BSD-Source-Code",
            Self::CalderaNoPreamble => "Caldera-no-preamble",
            Self::OLDAPTwoDotSix => "OLDAP-2.6",
            Self::AdobeDisplayPostScript => "Adobe-Display-PostScript",
            Self::Cronyx => "Cronyx",
            Self::LPPLOneDotThreea => "LPPL-1.3a",
            Self::Psfrag => "psfrag",
            Self::CcZeroOneDotZero => "CC0-1.0",
            Self::MartinBirgmeier => "Martin-Birgmeier",
            Self::MITModernVariant => "MIT-Modern-Variant",
            Self::SpencerNineNine => "Spencer-99",
            Self::OLDAPOneDotOne => "OLDAP-1.1",
            Self::FSFAP => "FSFAP",
            Self::GFDLOneDotOneOnly => "GFDL-1.1-only",
            Self::Unlicense => "Unlicense",
            Self::CCBYSATwoDotZero => "CC-BY-SA-2.0",
            Self::MITFeh => "MIT-feh",
            Self::FSFUL => "FSFUL",
            Self::NPOSLThreeDotZero => "NPOSL-3.0",
            Self::Afmparse => "Afmparse",
            Self::CCBYNCNDTwoDotFive => "CC-BY-NC-ND-2.5",
            Self::TTWL => "TTWL",
            Self::BSDThreeClause => "BSD-3-Clause",
            Self::HPNDMarkusKuhn => "HPND-Markus-Kuhn",
            Self::PolyFormSmallBusinessOneDotZeroDotZero => "PolyForm-Small-Business-1.0.0",
            Self::DLDEBYTwoDotZero => "DL-DE-BY-2.0",
            Self::BSDInfernoNettverk => "BSD-Inferno-Nettverk",
            Self::NLODOneDotZero => "NLOD-1.0",
            Self::CCBYNCSAOneDotZero => "CC-BY-NC-SA-1.0",
            Self::CCBYThreeDotZeroUS => "CC-BY-3.0-US",
            Self::OGTSL => "OGTSL",
            Self::PythonTwoDotZeroDotOne => "Python-2.0.1",
            Self::OFLOneDotOneRFN => "OFL-1.1-RFN",
            Self::JasPerTwoDotZero => "JasPer-2.0",
            Self::GPLTwoDotZeroOrLater => "GPL-2.0-or-later",
            Self::ASWFDigitalAssetsOneDotZero => "ASWF-Digital-Assets-1.0",
            Self::LPPLOneDotTwo => "LPPL-1.2",
            Self::NISTSoftware => "NIST-Software",
            Self::WThreeC => "W3C",
            Self::GFDLOneDotOneNoInvariantsOrLater => "GFDL-1.1-no-invariants-or-later",
            Self::PythonTwoDotZero => "Python-2.0",
            Self::Threeparttable => "threeparttable",
            Self::HPNDExportTwoUS => "HPND-export2-US",
            Self::ANTLRPDFallback => "ANTLR-PD-fallback",
            Self::TMate => "TMate",
            Self::OPLOneDotZero => "OPL-1.0",
            Self::OpenPbsTwoDotThree => "OpenPBS-2.3",
            Self::NPLOneDotZero => "NPL-1.0",
            Self::AnyOSI => "any-OSI",
            Self::OGDLTaiwanOneDotZero => "OGDL-Taiwan-1.0",
            Self::Dvipdfm => "dvipdfm",
            Self::Hdparm => "hdparm",
            Self::CCBYThreeDotZero => "CC-BY-3.0",
            Self::Mailprio => "mailprio",
            Self::CCBYNCSATwoDotZeroDE => "CC-BY-NC-SA-2.0-DE",
            Self::SugarCrmOneDotOneDotThree => "SugarCRM-1.1.3",
            Self::SunPPP => "Sun-PPP",
            Self::BrianGladmanTwoClause => "Brian-Gladman-2-Clause",
            Self::LGPLTwoDotOnePlus => "LGPL-2.1+",
            Self::AppSTwop => "App-s2p",
            Self::BSDTwoClauseFreeBsd => "BSD-2-Clause-FreeBSD",
            Self::Symlinks => "Symlinks",
            Self::OLDAPTwoDotOne => "OLDAP-2.1",
            Self::NCBIPD => "NCBI-PD",
            Self::BSDThreeClauseHP => "BSD-3-Clause-HP",
            Self::ICU => "ICU",
            Self::SGIOpenGl => "SGI-OpenGL",
            Self::MITKhronosOld => "MIT-Khronos-old",
            Self::CCBYSAOneDotZero => "CC-BY-SA-1.0",
            Self::CECILLC => "CECILL-C",
            Self::Gtkbook => "gtkbook",
            Self::WidgetWorkshop => "Widget-Workshop",
            Self::CCSAOneDotZero => "CC-SA-1.0",
            Self::LGPLTwoDotZeroPlus => "LGPL-2.0+",
            Self::BSDProtection => "BSD-Protection",
            Self::Noweb => "Noweb",
            Self::UnicodeDFSTwoZeroOneFive => "Unicode-DFS-2015",
            Self::BoehmGC => "Boehm-GC",
            Self::Curl => "curl",
            Self::HPNDMITDisclaimer => "HPND-MIT-disclaimer",
            Self::CCPDDC => "CC-PDDC",
            Self::CCBYNCSATwoDotZero => "CC-BY-NC-SA-2.0",
            Self::NLODTwoDotZero => "NLOD-2.0",
            Self::WxWindows => "wxWindows",
            Self::EPICS => "EPICS",
            Self::HPNDExportUSModify => "HPND-export-US-modify",
            Self::BSDAdvertisingAcknowledgement => "BSD-Advertising-Acknowledgement",
            Self::OFLOneDotOneNoRFN => "OFL-1.1-no-RFN",
            Self::CCBYNDTwoDotFive => "CC-BY-ND-2.5",
            Self::VSLOneDotZero => "VSL-1.0",
            Self::BcryptSolarDesigner => "bcrypt-Solar-Designer",
            Self::SISSL => "SISSL",
            Self::TUBerlinOneDotZero => "TU-Berlin-1.0",
            Self::ParitySixDotZeroDotZero => "Parity-6.0.0",
            Self::SNIA => "SNIA",
            Self::SAXPDTwoDotZero => "SAX-PD-2.0",
            Self::Xinetd => "xinetd",
            Self::TermReadKey => "TermReadKey",
            Self::GPLThreeDotZeroOrLater => "GPL-3.0-or-later",
            Self::HPNDFennebergLivingston => "HPND-Fenneberg-Livingston",
            Self::CCBYNDThreeDotZero => "CC-BY-ND-3.0",
            Self::RHeCosOneDotOne => "RHeCos-1.1",
            Self::MITOpenGroup => "MIT-open-group",
            Self::NBPLOneDotZero => "NBPL-1.0",
            Self::OPLUKThreeDotZero => "OPL-UK-3.0",
            Self::EPLOneDotZero => "EPL-1.0",
            Self::ODCByOneDotZero => "ODC-By-1.0",
            Self::SSPLOneDotZero => "SSPL-1.0",
            Self::MTLL => "MTLL",
            Self::OLDAPTwoDotFive => "OLDAP-2.5",
            Self::PPL => "PPL",
            Self::TOSL => "TOSL",
            Self::GameProgrammingGems => "Game-Programming-Gems",
            Self::OLDAPOneDotTwo => "OLDAP-1.2",
            Self::CCBYTwoDotFive => "CC-BY-2.5",
            Self::CrystalStacker => "CrystalStacker",
            Self::OpenSslStandalone => "OpenSSL-standalone",
            Self::Clips => "Clips",
            Self::CCBYSAThreeDotZeroDE => "CC-BY-SA-3.0-DE",
            Self::OCLCTwoDotZero => "OCLC-2.0",
            Self::CveTou => "cve-tou",
            Self::LZMASDKNineDotTwoTwo => "LZMA-SDK-9.22",
            Self::BSDThreeClauseSun => "BSD-3-Clause-Sun",
            Self::CCBYThreeDotZeroAT => "CC-BY-3.0-AT",
            Self::CCBYNCOneDotZero => "CC-BY-NC-1.0",
            Self::IntelACPI => "Intel-ACPI",
            Self::ZPLOneDotOne => "ZPL-1.1",
            Self::BSDFourDotThreeReno => "BSD-4.3RENO",
            Self::NICTAOneDotZero => "NICTA-1.0",
            Self::CCBYNDThreeDotZeroDE => "CC-BY-ND-3.0-DE",
            Self::BSDThreeClauseAttribution => "BSD-3-Clause-Attribution",
            Self::IBMPibs => "IBM-pibs",
            Self::InfoZIP => "Info-ZIP",
            Self::HIDAPI => "HIDAPI",
            Self::BSLOneDotZero => "BSL-1.0",
            Self::Dtoa => "dtoa",
            Self::EtalabTwoDotZero => "etalab-2.0",
            Self::HPNDPbmplus => "HPND-Pbmplus",
            Self::BitstreamCharter => "Bitstream-Charter",
            Self::PostgreSql => "PostgreSQL",
            Self::CERNOHLOneDotOne => "CERN-OHL-1.1",
            Self::HPNDExportUSAcknowledgement => "HPND-export-US-acknowledgement",
            Self::GPLThreeDotZeroPlus => "GPL-3.0+",
            Self::OLDAPTwoDotFour => "OLDAP-2.4",
            Self::OLDAPOneDotThree => "OLDAP-1.3",
            Self::OLFLOneDotThree => "OLFL-1.3",
            Self::LPPLOneDotThreec => "LPPL-1.3c",
            Self::CCBYNCNDOneDotZero => "CC-BY-NC-ND-1.0",
            Self::CCBYSATwoDotOneJP => "CC-BY-SA-2.1-JP",
            Self::GPLOneDotZeroOnly => "GPL-1.0-only",
            Self::LGPLTwoDotOneOrLater => "LGPL-2.1-or-later",
            Self::ApacheTwoDotZero => "Apache-2.0",
            Self::CERNOHLSTwoDotZero => "CERN-OHL-S-2.0",
            Self::NISTPDFallback => "NIST-PD-fallback",
            Self::Radvd => "radvd",
            Self::FSFULLR => "FSFULLR",
            Self::CMUMachNodoc => "CMU-Mach-nodoc",
            Self::OCCTPL => "OCCT-PL",
            Self::MITNFA => "MITNFA",
            Self::CCPDMOneDotZero => "CC-PDM-1.0",
            Self::CCBYThreeDotZeroAU => "CC-BY-3.0-AU",
            Self::GSoapOneDotThreeb => "gSOAP-1.3b",
            Self::CCBYNDTwoDotZero => "CC-BY-ND-2.0",
            Self::DocBookXML => "DocBook-XML",
            Self::Checkmk => "checkmk",
            Self::LinuxOpenIb => "Linux-OpenIB",
            Self::CCBYNCSATwoDotFive => "CC-BY-NC-SA-2.5",
            Self::CCBYNCNDThreeDotZeroDE => "CC-BY-NC-ND-3.0-DE",
            Self::ASWFDigitalAssetsOneDotOne => "ASWF-Digital-Assets-1.1",
            Self::PHPThreeDotZeroOne => "PHP-3.01",
            Self::CCBYNCSAThreeDotZero => "CC-BY-NC-SA-3.0",
            Self::LibselinuxOneDotZero => "libselinux-1.0",
            Self::JPLImage => "JPL-image",
            Self::NPLOneDotOne => "NPL-1.1",
            Self::AnyOSIPerlModules => "any-OSI-perl-modules",
            Self::LibutilDavidNugent => "libutil-David-Nugent",
            Self::GFDLOneDotTwoOrLater => "GFDL-1.2-or-later",
            Self::CDLAPermissiveOneDotZero => "CDLA-Permissive-1.0",
            Self::HPNDKevlinHenney => "HPND-Kevlin-Henney",
            Self::CMUMach => "CMU-Mach",
            Self::CCBYNCSAThreeDotZeroDE => "CC-BY-NC-SA-3.0-DE",
            Self::OLDAPTwoDotZero => "OLDAP-2.0",
            Self::BSDTwoClauseFirstLines => "BSD-2-Clause-first-lines",
            Self::GPLOneDotZeroPlus => "GPL-1.0+",
            Self::CECILLB => "CECILL-B",
            Self::GraphicsGems => "Graphics-Gems",
            Self::GFDLOneDotThreeInvariantsOrLater => "GFDL-1.3-invariants-or-later",
            Self::XdebugOneDotZeroThree => "Xdebug-1.03",
            Self::Swrule => "swrule",
            Self::Pkgconf => "pkgconf",
            Self::OpenSsl => "OpenSSL",
            Self::CCBYTwoDotZero => "CC-BY-2.0",
            Self::QPLOneDotZero => "QPL-1.0",
            Self::DSDP => "DSDP",
            Self::Intel => "Intel",
            Self::CCBYNCSAThreeDotZeroIGO => "CC-BY-NC-SA-3.0-IGO",
            Self::Pixar => "Pixar",
            Self::XkeyboardConfigZinoviev => "xkeyboard-config-Zinoviev",
            Self::BSDTwoClauseViews => "BSD-2-Clause-Views",
            Self::CNRIPython => "CNRI-Python",
            Self::MulanPslTwoDotZero => "MulanPSL-2.0",
            Self::EGenix => "eGenix",
            Self::Glide => "Glide",
            Self::LPLOneDotZeroTwo => "LPL-1.02",
            Self::Xerox => "Xerox",
            Self::Xzoom => "xzoom",
            Self::MSLPL => "MS-LPL",
            Self::DRLOneDotOne => "DRL-1.1",
            Self::SpencerNineFour => "Spencer-94",
            Self::BrianGladmanThreeClause => "Brian-Gladman-3-Clause",
            Self::CDLOneDotZero => "CDL-1.0",
            Self::UCLOneDotZero => "UCL-1.0",
            Self::AdobeUtopia => "Adobe-Utopia",
            Self::Libtiff => "libtiff",
            Self::MPLTwoDotZero => "MPL-2.0",
            Self::UMichMerit => "UMich-Merit",
            Self::ManTwohtml => "man2html",
            Self::GFDLOneDotThreeNoInvariantsOrLater => "GFDL-1.3-no-invariants-or-later",
            Self::NOSL => "NOSL",
            Self::AMPAS => "AMPAS",
            Self::ElasticTwoDotZero => "Elastic-2.0",
            Self::BSDTwoClausePatent => "BSD-2-Clause-Patent",
            Self::GFDLOneDotTwoInvariantsOrLater => "GFDL-1.2-invariants-or-later",
            Self::MpichTwo => "mpich2",
            Self::WTFPL => "WTFPL",
            Self::AFLOneDotTwo => "AFL-1.2",
            Self::EuDatagrid => "EUDatagrid",
            Self::ArtisticOneDotZeroClEight => "Artistic-1.0-cl8",
            Self::NTP => "NTP",
            Self::TGPPLOneDotZero => "TGPPL-1.0",
            Self::APSLOneDotTwo => "APSL-1.2",
            Self::EFLOneDotZero => "EFL-1.0",
            Self::CERNOHLWTwoDotZero => "CERN-OHL-W-2.0",
            Self::Ruby => "Ruby",
            Self::CondorOneDotOne => "Condor-1.1",
            Self::GFDLOneDotOneOrLater => "GFDL-1.1-or-later",
            Self::CECILLOneDotOne => "CECILL-1.1",
            Self::OLDAPTwoDotTwoDotOne => "OLDAP-2.2.1",
            Self::OFLOneDotZeroNoRFN => "OFL-1.0-no-RFN",
            Self::AGPLOneDotZeroOnly => "AGPL-1.0-only",
            Self::HTMLTIDY => "HTMLTIDY",
            Self::BSDSourceBeginningFile => "BSD-Source-beginning-file",
            Self::ZimbraOneDotThree => "Zimbra-1.3",
            Self::SHLZeroDotFive => "SHL-0.5",
            Self::BitTorrentOneDotZero => "BitTorrent-1.0",
            Self::Kastrup => "Kastrup",
            Self::SendmailOpenSourceOneDotOne => "Sendmail-Open-Source-1.1",
            Self::Baekmuk => "Baekmuk",
            Self::SunPPPTwoZeroZeroZero => "Sun-PPP-2000",
            Self::PHPThreeDotZero => "PHP-3.0",
            Self::ECLTwoDotZero => "ECL-2.0",
            Self::OGLUKOneDotZero => "OGL-UK-1.0",
            Self::HPNDExportUS => "HPND-export-US",
            Self::SshKeyscan => "ssh-keyscan",
            Self::CDDLOneDotZero => "CDDL-1.0",
            Self::Borceux => "Borceux",
            Self::MpiPermissive => "mpi-permissive",
            Self::OFLOneDotZero => "OFL-1.0",
            Self::UbuntuFontOneDotZero => "Ubuntu-font-1.0",
            Self::BSDAttributionHPNDDisclaimer => "BSD-Attribution-HPND-disclaimer",
            Self::APAFML => "APAFML",
            Self::CFITSIO => "CFITSIO",
            Self::CornellLosslessJPEG => "Cornell-Lossless-JPEG",
            Self::ECosTwoDotZero => "eCos-2.0",
            Self::OSLOneDotZero => "OSL-1.0",
            Self::AML => "AML",
            Self::GPLTwoDotZero => "GPL-2.0",
            Self::AFLTwoDotOne => "AFL-2.1",
            Self::GPLTwoDotZeroWithAutoconfException => "GPL-2.0-with-autoconf-exception",
            Self::Wwl => "wwl",
            Self::Motosoto => "Motosoto",
            Self::WThreem => "w3m",
            Self::IMatix => "iMatix",
            Self::CCBYSAThreeDotZeroIGO => "CC-BY-SA-3.0-IGO",
            Self::SunPro => "SunPro",
            Self::OGLCanadaTwoDotZero => "OGL-Canada-2.0",
            Self::MirOs => "MirOS",
            Self::LPDDocument => "LPD-document",
            Self::HPNDDocSell => "HPND-doc-sell",
            Self::AFLThreeDotZero => "AFL-3.0",
            Self::TPDL => "TPDL",
            Self::NCL => "NCL",
            Self::BSDSystemicsWThreeWorks => "BSD-Systemics-W3Works",
            Self::Pnmstitch => "pnmstitch",
            Self::GFDLOneDotOneNoInvariantsOnly => "GFDL-1.1-no-invariants-only",
            Self::CCBYSATwoDotZeroUK => "CC-BY-SA-2.0-UK",
            Self::GFDLOneDotOneInvariantsOnly => "GFDL-1.1-invariants-only",
            Self::GPLTwoDotZeroWithFontException => "GPL-2.0-with-font-exception",
            Self::CCBYNCSAFourDotZero => "CC-BY-NC-SA-4.0",
            Self::HPNDSellVariantMITDisclaimer => "HPND-sell-variant-MIT-disclaimer",
            Self::Abstyles => "Abstyles",
            Self::Catharon => "Catharon",
            Self::AGPLOneDotZero => "AGPL-1.0",
            Self::LGPLThreeDotZeroPlus => "LGPL-3.0+",
            Self::HPNDUCExportUS => "HPND-UC-export-US",
            Self::CDDLOneDotOne => "CDDL-1.1",
            Self::OFLOneDotOne => "OFL-1.1",
            Self::IPLOneDotZero => "IPL-1.0",
            Self::EUPLOneDotTwo => "EUPL-1.2",
            Self::UnixCrypt => "UnixCrypt",
            Self::RSCPL => "RSCPL",
            Self::LinuxManPagesCopyleft => "Linux-man-pages-copyleft",
            Self::SSHShort => "SSH-short",
            Self::OFLOneDotZeroRFN => "OFL-1.0-RFN",
            Self::MackerrasThreeClause => "Mackerras-3-Clause",
            Self::OSLOneDotOne => "OSL-1.1",
            Self::IJGShort => "IJG-short",
            Self::AFLTwoDotZero => "AFL-2.0",
            Self::GFDLOneDotTwoInvariantsOnly => "GFDL-1.2-invariants-only",
            Self::APSLTwoDotZero => "APSL-2.0",
            Self::WThreeCOneNineNineEightZeroSevenTwoZero => "W3C-19980720",
            Self::TORQUEOneDotOne => "TORQUE-1.1",
            Self::ZlibAcknowledgement => "zlib-acknowledgement",
            Self::UnicodeTOU => "Unicode-TOU",
            Self::URTRLE => "URT-RLE",
            Self::GPLThreeDotZero => "GPL-3.0",
            Self::Fair => "Fair",
            Self::SL => "SL",
            Self::CCBYFourDotZero => "CC-BY-4.0",
            Self::RSAMD => "RSA-MD",
            Self::HPND => "HPND",
            Self::Beerware => "Beerware",
            Self::WatcomOneDotZero => "Watcom-1.0",
            Self::Diffmark => "diffmark",
            Self::IECCodeComponentsEULA => "IEC-Code-Components-EULA",
            Self::BSDThreeClauseModification => "BSD-3-Clause-Modification",
            Self::GPLTwoDotZeroWithGCCException => "GPL-2.0-with-GCC-exception",
            Self::GCRDocs => "GCR-docs",
            Self::BSDThreeClauseNoNuclearWarranty => "BSD-3-Clause-No-Nuclear-Warranty",
            Self::CCBYNCThreeDotZeroDE => "CC-BY-NC-3.0-DE",
            Self::PDDLOneDotZero => "PDDL-1.0",
            Self::DRLOneDotZero => "DRL-1.0",
            Self::ArtisticTwoDotZero => "Artistic-2.0",
            Self::CCBYNCSATwoDotZeroFR => "CC-BY-NC-SA-2.0-FR",
            Self::SGIBTwoDotZero => "SGI-B-2.0",
            Self::CCBYNCSATwoDotZeroUK => "CC-BY-NC-SA-2.0-UK",
            Self::GFDLOneDotOne => "GFDL-1.1",
            Self::LGPLLR => "LGPLLR",
            Self::CCBYTwoDotFiveAU => "CC-BY-2.5-AU",
            Self::BSDOneClause => "BSD-1-Clause",
            Self::GFDLOneDotOneInvariantsOrLater => "GFDL-1.1-invariants-or-later",
            Self::BzipTwoOneDotZeroDotFive => "bzip2-1.0.5",
            Self::GPLTwoDotZeroPlus => "GPL-2.0+",
            Self::GPLTwoDotZeroWithBisonException => "GPL-2.0-with-bison-exception",
            Self::GFDLOneDotThreeNoInvariantsOnly => "GFDL-1.3-no-invariants-only",
            Self::SMLNJ => "SMLNJ",
            Self::GlTwoPs => "GL2PS",
            Self::CPLOneDotZero => "CPL-1.0",
            Self::DLDEZEROTwoDotZero => "DL-DE-ZERO-2.0",
            Self::MIT => "MIT",
            Self::Minpack => "Minpack",
            Self::MITEnna => "MIT-enna",
            Self::QPLOneDotZeroINRIATwoZeroZeroFour => "QPL-1.0-INRIA-2004",
            Self::MITAdvertising => "MIT-advertising",
            Self::ImageMagick => "ImageMagick",
            Self::HPNDDEC => "HPND-DEC",
            Self::CECILLOneDotZero => "CECILL-1.0",
            Self::LucidaBitmapFonts => "Lucida-Bitmap-Fonts",
            Self::Lsof => "lsof",
            Self::FreeImage => "FreeImage",
            Self::BSDFourDotThreeTahoe => "BSD-4.3TAHOE",
            Self::BSDTwoClauseNetBsd => "BSD-2-Clause-NetBSD",
            Self::NRL => "NRL",
            Self::XOneOneDistributeModificationsVariant => "X11-distribute-modifications-variant",
            Self::LZMASDKNineDotOneOneToNineDotTwoZero => "LZMA-SDK-9.11-to-9.20",
            Self::ISC => "ISC",
            Self::BSDFourClauseShortened => "BSD-4-Clause-Shortened",
            Self::LGPLThreeDotZeroOrLater => "LGPL-3.0-or-later",
            Self::BitTorrentOneDotOne => "BitTorrent-1.1",
            Self::Gnuplot => "gnuplot",
            Self::DECThreeClause => "DEC-3-Clause",
            Self::CCBYNDFourDotZero => "CC-BY-ND-4.0",
            Self::AGPLThreeDotZeroOrLater => "AGPL-3.0-or-later",
            Self::CUDAOneDotZero => "C-UDA-1.0",
            Self::CATOSLOneDotOne => "CATOSL-1.1",
        }
    }
    // #[doc = r" Returns true if the license is OSI approved (based on the build-time list)."]
    // pub fn is_osi_approved(&self) -> bool {
    //     match self {
    //         Self::CNRIPythonGPLCompatible => false,
    //         Self::HPOneNineEightSix => false,
    //         Self::EUPLOneDotOne => true,
    //         Self::Cube => false,
    //         Self::CNRIJython => false,
    //         Self::ArtisticOneDotZero => true,
    //         Self::LGPLThreeDotZero => true,
    //         Self::HPNDMerchantabilityVariant => false,
    //         Self::IJG => false,
    //         Self::CCBYSAThreeDotZeroAT => false,
    //         Self::Dotseqn => false,
    //         Self::HPNDNetrek => false,
    //         Self::JPNIC => false,
    //         Self::MPLOneDotOne => true,
    //         Self::SGIBOneDotZero => false,
    //         Self::ArtisticOneDotZeroPerl => true,
    //         Self::CopyleftNextZeroDotThreeDotZero => false,
    //         Self::Fwlw => false,
    //         Self::CCBYThreeDotZeroDE => false,
    //         Self::OLDAPTwoDotZeroDotOne => false,
    //         Self::Xpp => false,
    //         Self::DocBookSchema => false,
    //         Self::CERNOHLPTwoDotZero => true,
    //         Self::GLWTPL => false,
    //         Self::CPALOneDotZero => true,
    //         Self::WThreeCTwoZeroOneFiveZeroFiveOneThree => true,
    //         Self::CCBYNCNDFourDotZero => false,
    //         Self::Sendmail => false,
    //         Self::SoftSurfer => false,
    //         Self::CALOneDotZeroCombinedWorkException => true,
    //         Self::ImlibTwo => false,
    //         Self::CECILLTwoDotZero => false,
    //         Self::HPNDSellRegexpr => false,
    //         Self::ADSL => false,
    //         Self::TrustedQsl => false,
    //         Self::ParitySevenDotZeroDotZero => false,
    //         Self::MakeIndex => false,
    //         Self::OML => false,
    //         Self::LiLiQRplusOneDotOne => true,
    //         Self::SPLOneDotZero => true,
    //         Self::DOC => false,
    //         Self::NTPZero => false,
    //         Self::GFDLOneDotThreeOrLater => false,
    //         Self::NASAOneDotThree => true,
    //         Self::LGPLTwoDotOne => true,
    //         Self::Ulem => false,
    //         Self::GFDLOneDotThreeInvariantsOnly => false,
    //         Self::HPNDSellVariantMITDisclaimerRev => false,
    //         Self::FSFULLRWD => false,
    //         Self::AGPLThreeDotZero => true,
    //         Self::LGPLTwoDotZeroOrLater => true,
    //         Self::AMLGlslang => false,
    //         Self::OpenVision => false,
    //         Self::BzipTwoOneDotZeroDotSix => false,
    //         Self::GFDLOneDotTwo => false,
    //         Self::LinuxManPagesOnePara => false,
    //         Self::OSLTwoDotOne => true,
    //         Self::Crossword => false,
    //         Self::UnicodeThreeDotZero => true,
    //         Self::BSDFourClause => false,
    //         Self::SsLeayStandalone => false,
    //         Self::SgpFour => false,
    //         Self::SHLZeroDotFiveOne => false,
    //         Self::HPNDIntel => false,
    //         Self::LiLiQROneDotOne => true,
    //         Self::APSLOneDotZero => true,
    //         Self::COILOneDotZero => false,
    //         Self::Vim => false,
    //         Self::Snprintf => false,
    //         Self::AdobeTwoZeroZeroSix => false,
    //         Self::CPOLOneDotZeroTwo => false,
    //         Self::MITZero => true,
    //         Self::BSDThreeClauseClear => false,
    //         Self::FergusonTwofish => false,
    //         Self::OSLThreeDotZero => true,
    //         Self::TAPROHLOneDotZero => false,
    //         Self::PythonLdap => false,
    //         Self::SimPlTwoDotZero => true,
    //         Self::VOSTROM => false,
    //         Self::SSHOpenSsh => false,
    //         Self::LinuxManPagesCopyleftVar => false,
    //         Self::MPEGSSG => false,
    //         Self::NISTPD => false,
    //         Self::YPLOneDotZero => false,
    //         Self::XSkat => false,
    //         Self::LALOneDotThree => false,
    //         Self::BSDThreeClauseAcpica => false,
    //         Self::GFDLOneDotThreeOnly => false,
    //         Self::Entessa => true,
    //         Self::LatexTwoeTranslatedNotice => false,
    //         Self::LOOP => false,
    //         Self::Wsuipa => false,
    //         Self::SpencerEightSix => false,
    //         Self::OGLUKThreeDotZero => false,
    //         Self::HippocraticTwoDotOne => false,
    //         Self::GPLThreeDotZeroOnly => true,
    //         Self::Furuseth => false,
    //         Self::OGLUKTwoDotZero => false,
    //         Self::LiLiQPOneDotOne => true,
    //         Self::Barr => false,
    //         Self::HPNDUC => false,
    //         Self::MSPL => true,
    //         Self::BSDFourClauseUC => false,
    //         Self::AGPLOneDotZeroOrLater => false,
    //         Self::NLPL => false,
    //         Self::AMDNewlib => false,
    //         Self::OLDAPTwoDotEight => true,
    //         Self::GFDLOneDotThree => false,
    //         Self::KnuthCTAN => false,
    //         Self::HaskellReport => false,
    //         Self::OSLTwoDotZero => true,
    //         Self::MITWu => false,
    //         Self::AAL => true,
    //         Self::AFLOneDotOne => true,
    //         Self::ArphicOneNineNineNine => false,
    //         Self::GPLOneDotZero => false,
    //         Self::ErlPlOneDotOne => false,
    //         Self::LinuxManPagesCopyleftTwoPara => false,
    //         Self::Nokia => true,
    //         Self::MITClick => false,
    //         Self::McPheeSlideshow => false,
    //         Self::APSLOneDotOne => true,
    //         Self::OLDAPTwoDotTwoDotTwo => false,
    //         Self::LGPLThreeDotZeroOnly => true,
    //         Self::CCBYSAFourDotZero => false,
    //         Self::MITFestival => false,
    //         Self::RPLOneDotFive => true,
    //         Self::ZeroBsd => true,
    //         Self::HPNDDoc => false,
    //         Self::ClArtistic => false,
    //         Self::TCPWrappers => false,
    //         Self::GenericXts => false,
    //         Self::ISCVeillard => false,
    //         Self::Rdisc => false,
    //         Self::ODbLOneDotZero => false,
    //         Self::Plexus => false,
    //         Self::BoehmGCWithoutFee => false,
    //         Self::InnerNetTwoDotZero => false,
    //         Self::YPLOneDotOne => false,
    //         Self::LALOneDotTwo => false,
    //         Self::ANTLRPD => false,
    //         Self::UCAR => false,
    //         Self::GFDLOneDotTwoOnly => false,
    //         Self::Zlib => true,
    //         Self::EUPLOneDotZero => false,
    //         Self::Gutmann => false,
    //         Self::InnoSetup => false,
    //         Self::MackerrasThreeClauseAcknowledgment => false,
    //         Self::LPLOneDotZero => true,
    //         Self::SGIBOneDotOne => false,
    //         Self::MPLOneDotZero => true,
    //         Self::DFSLOneDotZero => false,
    //         Self::CopyleftNextZeroDotThreeDotOne => false,
    //         Self::Saxpath => false,
    //         Self::OAR => false,
    //         Self::OPUBLOneDotZero => false,
    //         Self::TCL => false,
    //         Self::EFLTwoDotZero => true,
    //         Self::Aladdin => false,
    //         Self::GPLTwoDotZeroWithClasspathException => false,
    //         Self::ThirdEye => false,
    //         Self::MIPS => false,
    //         Self::RPSLOneDotZero => true,
    //         Self::MITCMU => false,
    //         Self::FreeBsdDOC => false,
    //         Self::CALOneDotZero => true,
    //         Self::ZimbraOneDotFour => false,
    //         Self::BUSLOneDotOne => false,
    //         Self::Psutils => false,
    //         Self::CECILLTwoDotOne => true,
    //         Self::Zeeff => false,
    //         Self::Mup => false,
    //         Self::GFDLOneDotTwoNoInvariantsOrLater => false,
    //         Self::GPLThreeDotZeroWithAutoconfException => false,
    //         Self::RPLOneDotOne => true,
    //         Self::AdobeGlyph => false,
    //         Self::BSDThreeClauseFlex => false,
    //         Self::CCBYNCFourDotZero => false,
    //         Self::MSRL => true,
    //         Self::BSDThreeClauseNoNuclearLicense => false,
    //         Self::IPA => true,
    //         Self::LGPLTwoDotZero => true,
    //         Self::NetCdf => false,
    //         Self::ECLOneDotZero => true,
    //         Self::BSDTwoClause => true,
    //         Self::SAXPD => false,
    //         Self::PSFTwoDotZero => false,
    //         Self::Naumen => true,
    //         Self::AMDPLPA => false,
    //         Self::Leptonica => false,
    //         Self::StandardMlNJ => false,
    //         Self::AGPLThreeDotZeroOnly => true,
    //         Self::FSFAPNoWarrantyDisclaimer => false,
    //         Self::OLDAPTwoDotSeven => false,
    //         Self::BSDThreeClauseOpenMPI => false,
    //         Self::BSDTwoClauseDarwin => false,
    //         Self::CERNOHLOneDotTwo => false,
    //         Self::SchemeReport => false,
    //         Self::CommunitySpecOneDotZero => false,
    //         Self::CCBYNCNDThreeDotZeroIGO => false,
    //         Self::Kazlib => false,
    //         Self::OSETPLTwoDotOne => true,
    //         Self::AdaCoreDoc => false,
    //         Self::CCBYSAThreeDotZero => false,
    //         Self::Eurosym => false,
    //         Self::APLOneDotZero => true,
    //         Self::CDLAPermissiveTwoDotZero => false,
    //         Self::OGCOneDotZero => false,
    //         Self::Libpng => false,
    //         Self::SWL => false,
    //         Self::Mplus => false,
    //         Self::CCBYOneDotZero => false,
    //         Self::OFFIS => false,
    //         Self::SMPPL => false,
    //         Self::JSON => false,
    //         Self::GPLOneDotZeroOrLater => false,
    //         Self::OUDAOneDotZero => false,
    //         Self::MulanPslOneDotZero => false,
    //         Self::NAISTTwoZeroZeroThree => false,
    //         Self::CCBYThreeDotZeroIGO => false,
    //         Self::SMAILGPL => false,
    //         Self::SCEA => false,
    //         Self::CCBYNCTwoDotFive => false,
    //         Self::CheckCvs => false,
    //         Self::GPLThreeDotZeroWithGCCException => true,
    //         Self::Xfig => false,
    //         Self::LPPLOneDotZero => false,
    //         Self::CCBYNCThreeDotZero => false,
    //         Self::SISSLOneDotTwo => false,
    //         Self::Glulxe => false,
    //         Self::SendmailEightDotTwoThree => false,
    //         Self::XOneOne => false,
    //         Self::OLDAPOneDotFour => false,
    //         Self::FTL => false,
    //         Self::CryptoSwift => false,
    //         Self::DocBookStylesheet => false,
    //         Self::BitstreamVera => false,
    //         Self::Xnet => true,
    //         Self::OLDAPTwoDotThree => false,
    //         Self::BlueOakOneDotZeroDotZero => true,
    //         Self::ZendTwoDotZero => false,
    //         Self::Soundex => false,
    //         Self::CCBYNCNDTwoDotZero => false,
    //         Self::TtypZero => false,
    //         Self::ApacheOneDotZero => false,
    //         Self::BSDSystemics => false,
    //         Self::Magaz => false,
    //         Self::FDKAAC => false,
    //         Self::CCBYSATwoDotFive => false,
    //         Self::Xlock => false,
    //         Self::XFreeEightSixOneDotOne => false,
    //         Self::Zed => false,
    //         Self::PolyFormNoncommercialOneDotZeroDotZero => false,
    //         Self::ZPLTwoDotZero => true,
    //         Self::NGPL => true,
    //         Self::CCBYNDOneDotZero => false,
    //         Self::LGPLTwoDotOneOnly => true,
    //         Self::LibpngTwoDotZero => false,
    //         Self::NetSNMP => false,
    //         Self::HPNDSellVariant => false,
    //         Self::TUBerlinTwoDotZero => false,
    //         Self::RubyPty => false,
    //         Self::HPNDINRIAIMAG => false,
    //         Self::LPPLOneDotOne => false,
    //         Self::GFDLOneDotTwoNoInvariantsOnly => false,
    //         Self::HPNDSellMITDisclaimerXserver => false,
    //         Self::MmiXware => false,
    //         Self::EPLTwoDotZero => true,
    //         Self::NCSA => true,
    //         Self::BSDThreeClauseNoMilitaryLicense => false,
    //         Self::GPLTwoDotZeroOnly => true,
    //         Self::MITTestregex => false,
    //         Self::NCGLUKTwoDotZero => false,
    //         Self::OLDAPTwoDotTwo => false,
    //         Self::CDLASharingOneDotZero => false,
    //         Self::CCBYNCNDThreeDotZero => false,
    //         Self::HPOneNineEightNine => false,
    //         Self::Bahyph => false,
    //         Self::ThreeDSlicerOneDotZero => false,
    //         Self::ApacheOneDotOne => true,
    //         Self::Multics => true,
    //         Self::UPLOneDotZero => true,
    //         Self::Nunit => false,
    //         Self::TPLOneDotZero => false,
    //         Self::FBM => false,
    //         Self::Blessing => false,
    //         Self::UnicodeDFSTwoZeroOneSix => true,
    //         Self::Jam => true,
    //         Self::DocBookDTD => false,
    //         Self::MPLTwoDotZeroNoCopyleftException => true,
    //         Self::BSDThreeClauseNoNuclearLicenseTwoZeroOneFour => false,
    //         Self::InterbaseOneDotZero => false,
    //         Self::BSDThreeClauseLBNL => true,
    //         Self::LGPLTwoDotZeroOnly => true,
    //         Self::Newsletr => false,
    //         Self::ZPLTwoDotOne => true,
    //         Self::Sleepycat => true,
    //         Self::CCBYNCTwoDotZero => false,
    //         Self::XOneOneSwapped => false,
    //         Self::LatexTwoe => false,
    //         Self::Caldera => false,
    //         Self::GD => false,
    //         Self::FrameworxOneDotZero => true,
    //         Self::Qhull => false,
    //         Self::Metamail => false,
    //         Self::CUAOPLOneDotZero => true,
    //         Self::CCBYThreeDotZeroNL => false,
    //         Self::Giftware => false,
    //         Self::PADL => false,
    //         Self::BSDSourceCode => false,
    //         Self::CalderaNoPreamble => false,
    //         Self::OLDAPTwoDotSix => false,
    //         Self::AdobeDisplayPostScript => false,
    //         Self::Cronyx => false,
    //         Self::LPPLOneDotThreea => false,
    //         Self::Psfrag => false,
    //         Self::CcZeroOneDotZero => false,
    //         Self::MartinBirgmeier => false,
    //         Self::MITModernVariant => true,
    //         Self::SpencerNineNine => false,
    //         Self::OLDAPOneDotOne => false,
    //         Self::FSFAP => false,
    //         Self::GFDLOneDotOneOnly => false,
    //         Self::Unlicense => true,
    //         Self::CCBYSATwoDotZero => false,
    //         Self::MITFeh => false,
    //         Self::FSFUL => false,
    //         Self::NPOSLThreeDotZero => true,
    //         Self::Afmparse => false,
    //         Self::CCBYNCNDTwoDotFive => false,
    //         Self::TTWL => false,
    //         Self::BSDThreeClause => true,
    //         Self::HPNDMarkusKuhn => false,
    //         Self::PolyFormSmallBusinessOneDotZeroDotZero => false,
    //         Self::DLDEBYTwoDotZero => false,
    //         Self::BSDInfernoNettverk => false,
    //         Self::NLODOneDotZero => false,
    //         Self::CCBYNCSAOneDotZero => false,
    //         Self::CCBYThreeDotZeroUS => false,
    //         Self::OGTSL => true,
    //         Self::PythonTwoDotZeroDotOne => false,
    //         Self::OFLOneDotOneRFN => true,
    //         Self::JasPerTwoDotZero => false,
    //         Self::GPLTwoDotZeroOrLater => true,
    //         Self::ASWFDigitalAssetsOneDotZero => false,
    //         Self::LPPLOneDotTwo => false,
    //         Self::NISTSoftware => false,
    //         Self::WThreeC => true,
    //         Self::GFDLOneDotOneNoInvariantsOrLater => false,
    //         Self::PythonTwoDotZero => true,
    //         Self::Threeparttable => false,
    //         Self::HPNDExportTwoUS => false,
    //         Self::ANTLRPDFallback => false,
    //         Self::TMate => false,
    //         Self::OPLOneDotZero => false,
    //         Self::OpenPbsTwoDotThree => false,
    //         Self::NPLOneDotZero => false,
    //         Self::AnyOSI => false,
    //         Self::OGDLTaiwanOneDotZero => false,
    //         Self::Dvipdfm => false,
    //         Self::Hdparm => false,
    //         Self::CCBYThreeDotZero => false,
    //         Self::Mailprio => false,
    //         Self::CCBYNCSATwoDotZeroDE => false,
    //         Self::SugarCrmOneDotOneDotThree => false,
    //         Self::SunPPP => false,
    //         Self::BrianGladmanTwoClause => false,
    //         Self::LGPLTwoDotOnePlus => true,
    //         Self::AppSTwop => false,
    //         Self::BSDTwoClauseFreeBsd => false,
    //         Self::Symlinks => false,
    //         Self::OLDAPTwoDotOne => false,
    //         Self::NCBIPD => false,
    //         Self::BSDThreeClauseHP => false,
    //         Self::ICU => true,
    //         Self::SGIOpenGl => false,
    //         Self::MITKhronosOld => false,
    //         Self::CCBYSAOneDotZero => false,
    //         Self::CECILLC => false,
    //         Self::Gtkbook => false,
    //         Self::WidgetWorkshop => false,
    //         Self::CCSAOneDotZero => false,
    //         Self::LGPLTwoDotZeroPlus => true,
    //         Self::BSDProtection => false,
    //         Self::Noweb => false,
    //         Self::UnicodeDFSTwoZeroOneFive => false,
    //         Self::BoehmGC => false,
    //         Self::Curl => false,
    //         Self::HPNDMITDisclaimer => false,
    //         Self::CCPDDC => false,
    //         Self::CCBYNCSATwoDotZero => false,
    //         Self::NLODTwoDotZero => false,
    //         Self::WxWindows => true,
    //         Self::EPICS => false,
    //         Self::HPNDExportUSModify => false,
    //         Self::BSDAdvertisingAcknowledgement => false,
    //         Self::OFLOneDotOneNoRFN => true,
    //         Self::CCBYNDTwoDotFive => false,
    //         Self::VSLOneDotZero => true,
    //         Self::BcryptSolarDesigner => false,
    //         Self::SISSL => true,
    //         Self::TUBerlinOneDotZero => false,
    //         Self::ParitySixDotZeroDotZero => false,
    //         Self::SNIA => false,
    //         Self::SAXPDTwoDotZero => false,
    //         Self::Xinetd => false,
    //         Self::TermReadKey => false,
    //         Self::GPLThreeDotZeroOrLater => true,
    //         Self::HPNDFennebergLivingston => false,
    //         Self::CCBYNDThreeDotZero => false,
    //         Self::RHeCosOneDotOne => false,
    //         Self::MITOpenGroup => false,
    //         Self::NBPLOneDotZero => false,
    //         Self::OPLUKThreeDotZero => false,
    //         Self::EPLOneDotZero => true,
    //         Self::ODCByOneDotZero => false,
    //         Self::SSPLOneDotZero => false,
    //         Self::MTLL => false,
    //         Self::OLDAPTwoDotFive => false,
    //         Self::PPL => false,
    //         Self::TOSL => false,
    //         Self::GameProgrammingGems => false,
    //         Self::OLDAPOneDotTwo => false,
    //         Self::CCBYTwoDotFive => false,
    //         Self::CrystalStacker => false,
    //         Self::OpenSslStandalone => false,
    //         Self::Clips => false,
    //         Self::CCBYSAThreeDotZeroDE => false,
    //         Self::OCLCTwoDotZero => true,
    //         Self::CveTou => false,
    //         Self::LZMASDKNineDotTwoTwo => false,
    //         Self::BSDThreeClauseSun => false,
    //         Self::CCBYThreeDotZeroAT => false,
    //         Self::CCBYNCOneDotZero => false,
    //         Self::IntelACPI => false,
    //         Self::ZPLOneDotOne => false,
    //         Self::BSDFourDotThreeReno => false,
    //         Self::NICTAOneDotZero => false,
    //         Self::CCBYNDThreeDotZeroDE => false,
    //         Self::BSDThreeClauseAttribution => false,
    //         Self::IBMPibs => false,
    //         Self::InfoZIP => false,
    //         Self::HIDAPI => false,
    //         Self::BSLOneDotZero => true,
    //         Self::Dtoa => false,
    //         Self::EtalabTwoDotZero => false,
    //         Self::HPNDPbmplus => false,
    //         Self::BitstreamCharter => false,
    //         Self::PostgreSql => true,
    //         Self::CERNOHLOneDotOne => false,
    //         Self::HPNDExportUSAcknowledgement => false,
    //         Self::GPLThreeDotZeroPlus => true,
    //         Self::OLDAPTwoDotFour => false,
    //         Self::OLDAPOneDotThree => false,
    //         Self::OLFLOneDotThree => true,
    //         Self::LPPLOneDotThreec => true,
    //         Self::CCBYNCNDOneDotZero => false,
    //         Self::CCBYSATwoDotOneJP => false,
    //         Self::GPLOneDotZeroOnly => false,
    //         Self::LGPLTwoDotOneOrLater => true,
    //         Self::ApacheTwoDotZero => true,
    //         Self::CERNOHLSTwoDotZero => true,
    //         Self::NISTPDFallback => false,
    //         Self::Radvd => false,
    //         Self::FSFULLR => false,
    //         Self::CMUMachNodoc => false,
    //         Self::OCCTPL => false,
    //         Self::MITNFA => false,
    //         Self::CCPDMOneDotZero => false,
    //         Self::CCBYThreeDotZeroAU => false,
    //         Self::GSoapOneDotThreeb => false,
    //         Self::CCBYNDTwoDotZero => false,
    //         Self::DocBookXML => false,
    //         Self::Checkmk => false,
    //         Self::LinuxOpenIb => false,
    //         Self::CCBYNCSATwoDotFive => false,
    //         Self::CCBYNCNDThreeDotZeroDE => false,
    //         Self::ASWFDigitalAssetsOneDotOne => false,
    //         Self::PHPThreeDotZeroOne => true,
    //         Self::CCBYNCSAThreeDotZero => false,
    //         Self::LibselinuxOneDotZero => false,
    //         Self::JPLImage => false,
    //         Self::NPLOneDotOne => false,
    //         Self::AnyOSIPerlModules => false,
    //         Self::LibutilDavidNugent => false,
    //         Self::GFDLOneDotTwoOrLater => false,
    //         Self::CDLAPermissiveOneDotZero => false,
    //         Self::HPNDKevlinHenney => false,
    //         Self::CMUMach => false,
    //         Self::CCBYNCSAThreeDotZeroDE => false,
    //         Self::OLDAPTwoDotZero => false,
    //         Self::BSDTwoClauseFirstLines => false,
    //         Self::GPLOneDotZeroPlus => false,
    //         Self::CECILLB => false,
    //         Self::GraphicsGems => false,
    //         Self::GFDLOneDotThreeInvariantsOrLater => false,
    //         Self::XdebugOneDotZeroThree => false,
    //         Self::Swrule => false,
    //         Self::Pkgconf => false,
    //         Self::OpenSsl => false,
    //         Self::CCBYTwoDotZero => false,
    //         Self::QPLOneDotZero => true,
    //         Self::DSDP => false,
    //         Self::Intel => true,
    //         Self::CCBYNCSAThreeDotZeroIGO => false,
    //         Self::Pixar => false,
    //         Self::XkeyboardConfigZinoviev => false,
    //         Self::BSDTwoClauseViews => false,
    //         Self::CNRIPython => true,
    //         Self::MulanPslTwoDotZero => true,
    //         Self::EGenix => false,
    //         Self::Glide => false,
    //         Self::LPLOneDotZeroTwo => true,
    //         Self::Xerox => false,
    //         Self::Xzoom => false,
    //         Self::MSLPL => false,
    //         Self::DRLOneDotOne => false,
    //         Self::SpencerNineFour => false,
    //         Self::BrianGladmanThreeClause => false,
    //         Self::CDLOneDotZero => false,
    //         Self::UCLOneDotZero => true,
    //         Self::AdobeUtopia => false,
    //         Self::Libtiff => false,
    //         Self::MPLTwoDotZero => true,
    //         Self::UMichMerit => false,
    //         Self::ManTwohtml => false,
    //         Self::GFDLOneDotThreeNoInvariantsOrLater => false,
    //         Self::NOSL => false,
    //         Self::AMPAS => false,
    //         Self::ElasticTwoDotZero => false,
    //         Self::BSDTwoClausePatent => true,
    //         Self::GFDLOneDotTwoInvariantsOrLater => false,
    //         Self::MpichTwo => false,
    //         Self::WTFPL => false,
    //         Self::AFLOneDotTwo => true,
    //         Self::EuDatagrid => true,
    //         Self::ArtisticOneDotZeroClEight => true,
    //         Self::NTP => true,
    //         Self::TGPPLOneDotZero => false,
    //         Self::APSLOneDotTwo => true,
    //         Self::EFLOneDotZero => true,
    //         Self::CERNOHLWTwoDotZero => true,
    //         Self::Ruby => false,
    //         Self::CondorOneDotOne => false,
    //         Self::GFDLOneDotOneOrLater => false,
    //         Self::CECILLOneDotOne => false,
    //         Self::OLDAPTwoDotTwoDotOne => false,
    //         Self::OFLOneDotZeroNoRFN => false,
    //         Self::AGPLOneDotZeroOnly => false,
    //         Self::HTMLTIDY => false,
    //         Self::BSDSourceBeginningFile => false,
    //         Self::ZimbraOneDotThree => false,
    //         Self::SHLZeroDotFive => false,
    //         Self::BitTorrentOneDotZero => false,
    //         Self::Kastrup => false,
    //         Self::SendmailOpenSourceOneDotOne => false,
    //         Self::Baekmuk => false,
    //         Self::SunPPPTwoZeroZeroZero => false,
    //         Self::PHPThreeDotZero => true,
    //         Self::ECLTwoDotZero => true,
    //         Self::OGLUKOneDotZero => false,
    //         Self::HPNDExportUS => false,
    //         Self::SshKeyscan => false,
    //         Self::CDDLOneDotZero => true,
    //         Self::Borceux => false,
    //         Self::MpiPermissive => false,
    //         Self::OFLOneDotZero => false,
    //         Self::UbuntuFontOneDotZero => false,
    //         Self::BSDAttributionHPNDDisclaimer => false,
    //         Self::APAFML => false,
    //         Self::CFITSIO => false,
    //         Self::CornellLosslessJPEG => false,
    //         Self::ECosTwoDotZero => false,
    //         Self::OSLOneDotZero => true,
    //         Self::AML => false,
    //         Self::GPLTwoDotZero => true,
    //         Self::AFLTwoDotOne => true,
    //         Self::GPLTwoDotZeroWithAutoconfException => false,
    //         Self::Wwl => false,
    //         Self::Motosoto => true,
    //         Self::WThreem => false,
    //         Self::IMatix => false,
    //         Self::CCBYSAThreeDotZeroIGO => false,
    //         Self::SunPro => false,
    //         Self::OGLCanadaTwoDotZero => false,
    //         Self::MirOs => true,
    //         Self::LPDDocument => false,
    //         Self::HPNDDocSell => false,
    //         Self::AFLThreeDotZero => true,
    //         Self::TPDL => false,
    //         Self::NCL => false,
    //         Self::BSDSystemicsWThreeWorks => false,
    //         Self::Pnmstitch => false,
    //         Self::GFDLOneDotOneNoInvariantsOnly => false,
    //         Self::CCBYSATwoDotZeroUK => false,
    //         Self::GFDLOneDotOneInvariantsOnly => false,
    //         Self::GPLTwoDotZeroWithFontException => false,
    //         Self::CCBYNCSAFourDotZero => false,
    //         Self::HPNDSellVariantMITDisclaimer => false,
    //         Self::Abstyles => false,
    //         Self::Catharon => false,
    //         Self::AGPLOneDotZero => false,
    //         Self::LGPLThreeDotZeroPlus => true,
    //         Self::HPNDUCExportUS => false,
    //         Self::CDDLOneDotOne => false,
    //         Self::OFLOneDotOne => true,
    //         Self::IPLOneDotZero => true,
    //         Self::EUPLOneDotTwo => true,
    //         Self::UnixCrypt => false,
    //         Self::RSCPL => true,
    //         Self::LinuxManPagesCopyleft => false,
    //         Self::SSHShort => false,
    //         Self::OFLOneDotZeroRFN => false,
    //         Self::MackerrasThreeClause => false,
    //         Self::OSLOneDotOne => false,
    //         Self::IJGShort => false,
    //         Self::AFLTwoDotZero => true,
    //         Self::GFDLOneDotTwoInvariantsOnly => false,
    //         Self::APSLTwoDotZero => true,
    //         Self::WThreeCOneNineNineEightZeroSevenTwoZero => false,
    //         Self::TORQUEOneDotOne => false,
    //         Self::ZlibAcknowledgement => false,
    //         Self::UnicodeTOU => false,
    //         Self::URTRLE => false,
    //         Self::GPLThreeDotZero => true,
    //         Self::Fair => true,
    //         Self::SL => false,
    //         Self::CCBYFourDotZero => false,
    //         Self::RSAMD => false,
    //         Self::HPND => true,
    //         Self::Beerware => false,
    //         Self::WatcomOneDotZero => true,
    //         Self::Diffmark => false,
    //         Self::IECCodeComponentsEULA => false,
    //         Self::BSDThreeClauseModification => false,
    //         Self::GPLTwoDotZeroWithGCCException => false,
    //         Self::GCRDocs => false,
    //         Self::BSDThreeClauseNoNuclearWarranty => false,
    //         Self::CCBYNCThreeDotZeroDE => false,
    //         Self::PDDLOneDotZero => false,
    //         Self::DRLOneDotZero => false,
    //         Self::ArtisticTwoDotZero => true,
    //         Self::CCBYNCSATwoDotZeroFR => false,
    //         Self::SGIBTwoDotZero => false,
    //         Self::CCBYNCSATwoDotZeroUK => false,
    //         Self::GFDLOneDotOne => false,
    //         Self::LGPLLR => false,
    //         Self::CCBYTwoDotFiveAU => false,
    //         Self::BSDOneClause => true,
    //         Self::GFDLOneDotOneInvariantsOrLater => false,
    //         Self::BzipTwoOneDotZeroDotFive => false,
    //         Self::GPLTwoDotZeroPlus => true,
    //         Self::GPLTwoDotZeroWithBisonException => false,
    //         Self::GFDLOneDotThreeNoInvariantsOnly => false,
    //         Self::SMLNJ => false,
    //         Self::GlTwoPs => false,
    //         Self::CPLOneDotZero => true,
    //         Self::DLDEZEROTwoDotZero => false,
    //         Self::MIT => true,
    //         Self::Minpack => false,
    //         Self::MITEnna => false,
    //         Self::QPLOneDotZeroINRIATwoZeroZeroFour => false,
    //         Self::MITAdvertising => false,
    //         Self::ImageMagick => false,
    //         Self::HPNDDEC => false,
    //         Self::CECILLOneDotZero => false,
    //         Self::LucidaBitmapFonts => false,
    //         Self::Lsof => false,
    //         Self::FreeImage => false,
    //         Self::BSDFourDotThreeTahoe => false,
    //         Self::BSDTwoClauseNetBsd => false,
    //         Self::NRL => false,
    //         Self::XOneOneDistributeModificationsVariant => false,
    //         Self::LZMASDKNineDotOneOneToNineDotTwoZero => false,
    //         Self::ISC => true,
    //         Self::BSDFourClauseShortened => false,
    //         Self::LGPLThreeDotZeroOrLater => true,
    //         Self::BitTorrentOneDotOne => false,
    //         Self::Gnuplot => false,
    //         Self::DECThreeClause => false,
    //         Self::CCBYNDFourDotZero => false,
    //         Self::AGPLThreeDotZeroOrLater => true,
    //         Self::CUDAOneDotZero => false,
    //         Self::CATOSLOneDotOne => true,
    //     }
    // }
    // #[doc = r" Returns an iterator over all available license variants."]
    // pub fn iter() -> impl Iterator<Item = Self> {
    //     [
    //         Self::CNRIPythonGPLCompatible,
    //         Self::HPOneNineEightSix,
    //         Self::EUPLOneDotOne,
    //         Self::Cube,
    //         Self::CNRIJython,
    //         Self::ArtisticOneDotZero,
    //         Self::LGPLThreeDotZero,
    //         Self::HPNDMerchantabilityVariant,
    //         Self::IJG,
    //         Self::CCBYSAThreeDotZeroAT,
    //         Self::Dotseqn,
    //         Self::HPNDNetrek,
    //         Self::JPNIC,
    //         Self::MPLOneDotOne,
    //         Self::SGIBOneDotZero,
    //         Self::ArtisticOneDotZeroPerl,
    //         Self::CopyleftNextZeroDotThreeDotZero,
    //         Self::Fwlw,
    //         Self::CCBYThreeDotZeroDE,
    //         Self::OLDAPTwoDotZeroDotOne,
    //         Self::Xpp,
    //         Self::DocBookSchema,
    //         Self::CERNOHLPTwoDotZero,
    //         Self::GLWTPL,
    //         Self::CPALOneDotZero,
    //         Self::WThreeCTwoZeroOneFiveZeroFiveOneThree,
    //         Self::CCBYNCNDFourDotZero,
    //         Self::Sendmail,
    //         Self::SoftSurfer,
    //         Self::CALOneDotZeroCombinedWorkException,
    //         Self::ImlibTwo,
    //         Self::CECILLTwoDotZero,
    //         Self::HPNDSellRegexpr,
    //         Self::ADSL,
    //         Self::TrustedQsl,
    //         Self::ParitySevenDotZeroDotZero,
    //         Self::MakeIndex,
    //         Self::OML,
    //         Self::LiLiQRplusOneDotOne,
    //         Self::SPLOneDotZero,
    //         Self::DOC,
    //         Self::NTPZero,
    //         Self::GFDLOneDotThreeOrLater,
    //         Self::NASAOneDotThree,
    //         Self::LGPLTwoDotOne,
    //         Self::Ulem,
    //         Self::GFDLOneDotThreeInvariantsOnly,
    //         Self::HPNDSellVariantMITDisclaimerRev,
    //         Self::FSFULLRWD,
    //         Self::AGPLThreeDotZero,
    //         Self::LGPLTwoDotZeroOrLater,
    //         Self::AMLGlslang,
    //         Self::OpenVision,
    //         Self::BzipTwoOneDotZeroDotSix,
    //         Self::GFDLOneDotTwo,
    //         Self::LinuxManPagesOnePara,
    //         Self::OSLTwoDotOne,
    //         Self::Crossword,
    //         Self::UnicodeThreeDotZero,
    //         Self::BSDFourClause,
    //         Self::SsLeayStandalone,
    //         Self::SgpFour,
    //         Self::SHLZeroDotFiveOne,
    //         Self::HPNDIntel,
    //         Self::LiLiQROneDotOne,
    //         Self::APSLOneDotZero,
    //         Self::COILOneDotZero,
    //         Self::Vim,
    //         Self::Snprintf,
    //         Self::AdobeTwoZeroZeroSix,
    //         Self::CPOLOneDotZeroTwo,
    //         Self::MITZero,
    //         Self::BSDThreeClauseClear,
    //         Self::FergusonTwofish,
    //         Self::OSLThreeDotZero,
    //         Self::TAPROHLOneDotZero,
    //         Self::PythonLdap,
    //         Self::SimPlTwoDotZero,
    //         Self::VOSTROM,
    //         Self::SSHOpenSsh,
    //         Self::LinuxManPagesCopyleftVar,
    //         Self::MPEGSSG,
    //         Self::NISTPD,
    //         Self::YPLOneDotZero,
    //         Self::XSkat,
    //         Self::LALOneDotThree,
    //         Self::BSDThreeClauseAcpica,
    //         Self::GFDLOneDotThreeOnly,
    //         Self::Entessa,
    //         Self::LatexTwoeTranslatedNotice,
    //         Self::LOOP,
    //         Self::Wsuipa,
    //         Self::SpencerEightSix,
    //         Self::OGLUKThreeDotZero,
    //         Self::HippocraticTwoDotOne,
    //         Self::GPLThreeDotZeroOnly,
    //         Self::Furuseth,
    //         Self::OGLUKTwoDotZero,
    //         Self::LiLiQPOneDotOne,
    //         Self::Barr,
    //         Self::HPNDUC,
    //         Self::MSPL,
    //         Self::BSDFourClauseUC,
    //         Self::AGPLOneDotZeroOrLater,
    //         Self::NLPL,
    //         Self::AMDNewlib,
    //         Self::OLDAPTwoDotEight,
    //         Self::GFDLOneDotThree,
    //         Self::KnuthCTAN,
    //         Self::HaskellReport,
    //         Self::OSLTwoDotZero,
    //         Self::MITWu,
    //         Self::AAL,
    //         Self::AFLOneDotOne,
    //         Self::ArphicOneNineNineNine,
    //         Self::GPLOneDotZero,
    //         Self::ErlPlOneDotOne,
    //         Self::LinuxManPagesCopyleftTwoPara,
    //         Self::Nokia,
    //         Self::MITClick,
    //         Self::McPheeSlideshow,
    //         Self::APSLOneDotOne,
    //         Self::OLDAPTwoDotTwoDotTwo,
    //         Self::LGPLThreeDotZeroOnly,
    //         Self::CCBYSAFourDotZero,
    //         Self::MITFestival,
    //         Self::RPLOneDotFive,
    //         Self::ZeroBsd,
    //         Self::HPNDDoc,
    //         Self::ClArtistic,
    //         Self::TCPWrappers,
    //         Self::GenericXts,
    //         Self::ISCVeillard,
    //         Self::Rdisc,
    //         Self::ODbLOneDotZero,
    //         Self::Plexus,
    //         Self::BoehmGCWithoutFee,
    //         Self::InnerNetTwoDotZero,
    //         Self::YPLOneDotOne,
    //         Self::LALOneDotTwo,
    //         Self::ANTLRPD,
    //         Self::UCAR,
    //         Self::GFDLOneDotTwoOnly,
    //         Self::Zlib,
    //         Self::EUPLOneDotZero,
    //         Self::Gutmann,
    //         Self::InnoSetup,
    //         Self::MackerrasThreeClauseAcknowledgment,
    //         Self::LPLOneDotZero,
    //         Self::SGIBOneDotOne,
    //         Self::MPLOneDotZero,
    //         Self::DFSLOneDotZero,
    //         Self::CopyleftNextZeroDotThreeDotOne,
    //         Self::Saxpath,
    //         Self::OAR,
    //         Self::OPUBLOneDotZero,
    //         Self::TCL,
    //         Self::EFLTwoDotZero,
    //         Self::Aladdin,
    //         Self::GPLTwoDotZeroWithClasspathException,
    //         Self::ThirdEye,
    //         Self::MIPS,
    //         Self::RPSLOneDotZero,
    //         Self::MITCMU,
    //         Self::FreeBsdDOC,
    //         Self::CALOneDotZero,
    //         Self::ZimbraOneDotFour,
    //         Self::BUSLOneDotOne,
    //         Self::Psutils,
    //         Self::CECILLTwoDotOne,
    //         Self::Zeeff,
    //         Self::Mup,
    //         Self::GFDLOneDotTwoNoInvariantsOrLater,
    //         Self::GPLThreeDotZeroWithAutoconfException,
    //         Self::RPLOneDotOne,
    //         Self::AdobeGlyph,
    //         Self::BSDThreeClauseFlex,
    //         Self::CCBYNCFourDotZero,
    //         Self::MSRL,
    //         Self::BSDThreeClauseNoNuclearLicense,
    //         Self::IPA,
    //         Self::LGPLTwoDotZero,
    //         Self::NetCdf,
    //         Self::ECLOneDotZero,
    //         Self::BSDTwoClause,
    //         Self::SAXPD,
    //         Self::PSFTwoDotZero,
    //         Self::Naumen,
    //         Self::AMDPLPA,
    //         Self::Leptonica,
    //         Self::StandardMlNJ,
    //         Self::AGPLThreeDotZeroOnly,
    //         Self::FSFAPNoWarrantyDisclaimer,
    //         Self::OLDAPTwoDotSeven,
    //         Self::BSDThreeClauseOpenMPI,
    //         Self::BSDTwoClauseDarwin,
    //         Self::CERNOHLOneDotTwo,
    //         Self::SchemeReport,
    //         Self::CommunitySpecOneDotZero,
    //         Self::CCBYNCNDThreeDotZeroIGO,
    //         Self::Kazlib,
    //         Self::OSETPLTwoDotOne,
    //         Self::AdaCoreDoc,
    //         Self::CCBYSAThreeDotZero,
    //         Self::Eurosym,
    //         Self::APLOneDotZero,
    //         Self::CDLAPermissiveTwoDotZero,
    //         Self::OGCOneDotZero,
    //         Self::Libpng,
    //         Self::SWL,
    //         Self::Mplus,
    //         Self::CCBYOneDotZero,
    //         Self::OFFIS,
    //         Self::SMPPL,
    //         Self::JSON,
    //         Self::GPLOneDotZeroOrLater,
    //         Self::OUDAOneDotZero,
    //         Self::MulanPslOneDotZero,
    //         Self::NAISTTwoZeroZeroThree,
    //         Self::CCBYThreeDotZeroIGO,
    //         Self::SMAILGPL,
    //         Self::SCEA,
    //         Self::CCBYNCTwoDotFive,
    //         Self::CheckCvs,
    //         Self::GPLThreeDotZeroWithGCCException,
    //         Self::Xfig,
    //         Self::LPPLOneDotZero,
    //         Self::CCBYNCThreeDotZero,
    //         Self::SISSLOneDotTwo,
    //         Self::Glulxe,
    //         Self::SendmailEightDotTwoThree,
    //         Self::XOneOne,
    //         Self::OLDAPOneDotFour,
    //         Self::FTL,
    //         Self::CryptoSwift,
    //         Self::DocBookStylesheet,
    //         Self::BitstreamVera,
    //         Self::Xnet,
    //         Self::OLDAPTwoDotThree,
    //         Self::BlueOakOneDotZeroDotZero,
    //         Self::ZendTwoDotZero,
    //         Self::Soundex,
    //         Self::CCBYNCNDTwoDotZero,
    //         Self::TtypZero,
    //         Self::ApacheOneDotZero,
    //         Self::BSDSystemics,
    //         Self::Magaz,
    //         Self::FDKAAC,
    //         Self::CCBYSATwoDotFive,
    //         Self::Xlock,
    //         Self::XFreeEightSixOneDotOne,
    //         Self::Zed,
    //         Self::PolyFormNoncommercialOneDotZeroDotZero,
    //         Self::ZPLTwoDotZero,
    //         Self::NGPL,
    //         Self::CCBYNDOneDotZero,
    //         Self::LGPLTwoDotOneOnly,
    //         Self::LibpngTwoDotZero,
    //         Self::NetSNMP,
    //         Self::HPNDSellVariant,
    //         Self::TUBerlinTwoDotZero,
    //         Self::RubyPty,
    //         Self::HPNDINRIAIMAG,
    //         Self::LPPLOneDotOne,
    //         Self::GFDLOneDotTwoNoInvariantsOnly,
    //         Self::HPNDSellMITDisclaimerXserver,
    //         Self::MmiXware,
    //         Self::EPLTwoDotZero,
    //         Self::NCSA,
    //         Self::BSDThreeClauseNoMilitaryLicense,
    //         Self::GPLTwoDotZeroOnly,
    //         Self::MITTestregex,
    //         Self::NCGLUKTwoDotZero,
    //         Self::OLDAPTwoDotTwo,
    //         Self::CDLASharingOneDotZero,
    //         Self::CCBYNCNDThreeDotZero,
    //         Self::HPOneNineEightNine,
    //         Self::Bahyph,
    //         Self::ThreeDSlicerOneDotZero,
    //         Self::ApacheOneDotOne,
    //         Self::Multics,
    //         Self::UPLOneDotZero,
    //         Self::Nunit,
    //         Self::TPLOneDotZero,
    //         Self::FBM,
    //         Self::Blessing,
    //         Self::UnicodeDFSTwoZeroOneSix,
    //         Self::Jam,
    //         Self::DocBookDTD,
    //         Self::MPLTwoDotZeroNoCopyleftException,
    //         Self::BSDThreeClauseNoNuclearLicenseTwoZeroOneFour,
    //         Self::InterbaseOneDotZero,
    //         Self::BSDThreeClauseLBNL,
    //         Self::LGPLTwoDotZeroOnly,
    //         Self::Newsletr,
    //         Self::ZPLTwoDotOne,
    //         Self::Sleepycat,
    //         Self::CCBYNCTwoDotZero,
    //         Self::XOneOneSwapped,
    //         Self::LatexTwoe,
    //         Self::Caldera,
    //         Self::GD,
    //         Self::FrameworxOneDotZero,
    //         Self::Qhull,
    //         Self::Metamail,
    //         Self::CUAOPLOneDotZero,
    //         Self::CCBYThreeDotZeroNL,
    //         Self::Giftware,
    //         Self::PADL,
    //         Self::BSDSourceCode,
    //         Self::CalderaNoPreamble,
    //         Self::OLDAPTwoDotSix,
    //         Self::AdobeDisplayPostScript,
    //         Self::Cronyx,
    //         Self::LPPLOneDotThreea,
    //         Self::Psfrag,
    //         Self::CcZeroOneDotZero,
    //         Self::MartinBirgmeier,
    //         Self::MITModernVariant,
    //         Self::SpencerNineNine,
    //         Self::OLDAPOneDotOne,
    //         Self::FSFAP,
    //         Self::GFDLOneDotOneOnly,
    //         Self::Unlicense,
    //         Self::CCBYSATwoDotZero,
    //         Self::MITFeh,
    //         Self::FSFUL,
    //         Self::NPOSLThreeDotZero,
    //         Self::Afmparse,
    //         Self::CCBYNCNDTwoDotFive,
    //         Self::TTWL,
    //         Self::BSDThreeClause,
    //         Self::HPNDMarkusKuhn,
    //         Self::PolyFormSmallBusinessOneDotZeroDotZero,
    //         Self::DLDEBYTwoDotZero,
    //         Self::BSDInfernoNettverk,
    //         Self::NLODOneDotZero,
    //         Self::CCBYNCSAOneDotZero,
    //         Self::CCBYThreeDotZeroUS,
    //         Self::OGTSL,
    //         Self::PythonTwoDotZeroDotOne,
    //         Self::OFLOneDotOneRFN,
    //         Self::JasPerTwoDotZero,
    //         Self::GPLTwoDotZeroOrLater,
    //         Self::ASWFDigitalAssetsOneDotZero,
    //         Self::LPPLOneDotTwo,
    //         Self::NISTSoftware,
    //         Self::WThreeC,
    //         Self::GFDLOneDotOneNoInvariantsOrLater,
    //         Self::PythonTwoDotZero,
    //         Self::Threeparttable,
    //         Self::HPNDExportTwoUS,
    //         Self::ANTLRPDFallback,
    //         Self::TMate,
    //         Self::OPLOneDotZero,
    //         Self::OpenPbsTwoDotThree,
    //         Self::NPLOneDotZero,
    //         Self::AnyOSI,
    //         Self::OGDLTaiwanOneDotZero,
    //         Self::Dvipdfm,
    //         Self::Hdparm,
    //         Self::CCBYThreeDotZero,
    //         Self::Mailprio,
    //         Self::CCBYNCSATwoDotZeroDE,
    //         Self::SugarCrmOneDotOneDotThree,
    //         Self::SunPPP,
    //         Self::BrianGladmanTwoClause,
    //         Self::LGPLTwoDotOnePlus,
    //         Self::AppSTwop,
    //         Self::BSDTwoClauseFreeBsd,
    //         Self::Symlinks,
    //         Self::OLDAPTwoDotOne,
    //         Self::NCBIPD,
    //         Self::BSDThreeClauseHP,
    //         Self::ICU,
    //         Self::SGIOpenGl,
    //         Self::MITKhronosOld,
    //         Self::CCBYSAOneDotZero,
    //         Self::CECILLC,
    //         Self::Gtkbook,
    //         Self::WidgetWorkshop,
    //         Self::CCSAOneDotZero,
    //         Self::LGPLTwoDotZeroPlus,
    //         Self::BSDProtection,
    //         Self::Noweb,
    //         Self::UnicodeDFSTwoZeroOneFive,
    //         Self::BoehmGC,
    //         Self::Curl,
    //         Self::HPNDMITDisclaimer,
    //         Self::CCPDDC,
    //         Self::CCBYNCSATwoDotZero,
    //         Self::NLODTwoDotZero,
    //         Self::WxWindows,
    //         Self::EPICS,
    //         Self::HPNDExportUSModify,
    //         Self::BSDAdvertisingAcknowledgement,
    //         Self::OFLOneDotOneNoRFN,
    //         Self::CCBYNDTwoDotFive,
    //         Self::VSLOneDotZero,
    //         Self::BcryptSolarDesigner,
    //         Self::SISSL,
    //         Self::TUBerlinOneDotZero,
    //         Self::ParitySixDotZeroDotZero,
    //         Self::SNIA,
    //         Self::SAXPDTwoDotZero,
    //         Self::Xinetd,
    //         Self::TermReadKey,
    //         Self::GPLThreeDotZeroOrLater,
    //         Self::HPNDFennebergLivingston,
    //         Self::CCBYNDThreeDotZero,
    //         Self::RHeCosOneDotOne,
    //         Self::MITOpenGroup,
    //         Self::NBPLOneDotZero,
    //         Self::OPLUKThreeDotZero,
    //         Self::EPLOneDotZero,
    //         Self::ODCByOneDotZero,
    //         Self::SSPLOneDotZero,
    //         Self::MTLL,
    //         Self::OLDAPTwoDotFive,
    //         Self::PPL,
    //         Self::TOSL,
    //         Self::GameProgrammingGems,
    //         Self::OLDAPOneDotTwo,
    //         Self::CCBYTwoDotFive,
    //         Self::CrystalStacker,
    //         Self::OpenSslStandalone,
    //         Self::Clips,
    //         Self::CCBYSAThreeDotZeroDE,
    //         Self::OCLCTwoDotZero,
    //         Self::CveTou,
    //         Self::LZMASDKNineDotTwoTwo,
    //         Self::BSDThreeClauseSun,
    //         Self::CCBYThreeDotZeroAT,
    //         Self::CCBYNCOneDotZero,
    //         Self::IntelACPI,
    //         Self::ZPLOneDotOne,
    //         Self::BSDFourDotThreeReno,
    //         Self::NICTAOneDotZero,
    //         Self::CCBYNDThreeDotZeroDE,
    //         Self::BSDThreeClauseAttribution,
    //         Self::IBMPibs,
    //         Self::InfoZIP,
    //         Self::HIDAPI,
    //         Self::BSLOneDotZero,
    //         Self::Dtoa,
    //         Self::EtalabTwoDotZero,
    //         Self::HPNDPbmplus,
    //         Self::BitstreamCharter,
    //         Self::PostgreSql,
    //         Self::CERNOHLOneDotOne,
    //         Self::HPNDExportUSAcknowledgement,
    //         Self::GPLThreeDotZeroPlus,
    //         Self::OLDAPTwoDotFour,
    //         Self::OLDAPOneDotThree,
    //         Self::OLFLOneDotThree,
    //         Self::LPPLOneDotThreec,
    //         Self::CCBYNCNDOneDotZero,
    //         Self::CCBYSATwoDotOneJP,
    //         Self::GPLOneDotZeroOnly,
    //         Self::LGPLTwoDotOneOrLater,
    //         Self::ApacheTwoDotZero,
    //         Self::CERNOHLSTwoDotZero,
    //         Self::NISTPDFallback,
    //         Self::Radvd,
    //         Self::FSFULLR,
    //         Self::CMUMachNodoc,
    //         Self::OCCTPL,
    //         Self::MITNFA,
    //         Self::CCPDMOneDotZero,
    //         Self::CCBYThreeDotZeroAU,
    //         Self::GSoapOneDotThreeb,
    //         Self::CCBYNDTwoDotZero,
    //         Self::DocBookXML,
    //         Self::Checkmk,
    //         Self::LinuxOpenIb,
    //         Self::CCBYNCSATwoDotFive,
    //         Self::CCBYNCNDThreeDotZeroDE,
    //         Self::ASWFDigitalAssetsOneDotOne,
    //         Self::PHPThreeDotZeroOne,
    //         Self::CCBYNCSAThreeDotZero,
    //         Self::LibselinuxOneDotZero,
    //         Self::JPLImage,
    //         Self::NPLOneDotOne,
    //         Self::AnyOSIPerlModules,
    //         Self::LibutilDavidNugent,
    //         Self::GFDLOneDotTwoOrLater,
    //         Self::CDLAPermissiveOneDotZero,
    //         Self::HPNDKevlinHenney,
    //         Self::CMUMach,
    //         Self::CCBYNCSAThreeDotZeroDE,
    //         Self::OLDAPTwoDotZero,
    //         Self::BSDTwoClauseFirstLines,
    //         Self::GPLOneDotZeroPlus,
    //         Self::CECILLB,
    //         Self::GraphicsGems,
    //         Self::GFDLOneDotThreeInvariantsOrLater,
    //         Self::XdebugOneDotZeroThree,
    //         Self::Swrule,
    //         Self::Pkgconf,
    //         Self::OpenSsl,
    //         Self::CCBYTwoDotZero,
    //         Self::QPLOneDotZero,
    //         Self::DSDP,
    //         Self::Intel,
    //         Self::CCBYNCSAThreeDotZeroIGO,
    //         Self::Pixar,
    //         Self::XkeyboardConfigZinoviev,
    //         Self::BSDTwoClauseViews,
    //         Self::CNRIPython,
    //         Self::MulanPslTwoDotZero,
    //         Self::EGenix,
    //         Self::Glide,
    //         Self::LPLOneDotZeroTwo,
    //         Self::Xerox,
    //         Self::Xzoom,
    //         Self::MSLPL,
    //         Self::DRLOneDotOne,
    //         Self::SpencerNineFour,
    //         Self::BrianGladmanThreeClause,
    //         Self::CDLOneDotZero,
    //         Self::UCLOneDotZero,
    //         Self::AdobeUtopia,
    //         Self::Libtiff,
    //         Self::MPLTwoDotZero,
    //         Self::UMichMerit,
    //         Self::ManTwohtml,
    //         Self::GFDLOneDotThreeNoInvariantsOrLater,
    //         Self::NOSL,
    //         Self::AMPAS,
    //         Self::ElasticTwoDotZero,
    //         Self::BSDTwoClausePatent,
    //         Self::GFDLOneDotTwoInvariantsOrLater,
    //         Self::MpichTwo,
    //         Self::WTFPL,
    //         Self::AFLOneDotTwo,
    //         Self::EuDatagrid,
    //         Self::ArtisticOneDotZeroClEight,
    //         Self::NTP,
    //         Self::TGPPLOneDotZero,
    //         Self::APSLOneDotTwo,
    //         Self::EFLOneDotZero,
    //         Self::CERNOHLWTwoDotZero,
    //         Self::Ruby,
    //         Self::CondorOneDotOne,
    //         Self::GFDLOneDotOneOrLater,
    //         Self::CECILLOneDotOne,
    //         Self::OLDAPTwoDotTwoDotOne,
    //         Self::OFLOneDotZeroNoRFN,
    //         Self::AGPLOneDotZeroOnly,
    //         Self::HTMLTIDY,
    //         Self::BSDSourceBeginningFile,
    //         Self::ZimbraOneDotThree,
    //         Self::SHLZeroDotFive,
    //         Self::BitTorrentOneDotZero,
    //         Self::Kastrup,
    //         Self::SendmailOpenSourceOneDotOne,
    //         Self::Baekmuk,
    //         Self::SunPPPTwoZeroZeroZero,
    //         Self::PHPThreeDotZero,
    //         Self::ECLTwoDotZero,
    //         Self::OGLUKOneDotZero,
    //         Self::HPNDExportUS,
    //         Self::SshKeyscan,
    //         Self::CDDLOneDotZero,
    //         Self::Borceux,
    //         Self::MpiPermissive,
    //         Self::OFLOneDotZero,
    //         Self::UbuntuFontOneDotZero,
    //         Self::BSDAttributionHPNDDisclaimer,
    //         Self::APAFML,
    //         Self::CFITSIO,
    //         Self::CornellLosslessJPEG,
    //         Self::ECosTwoDotZero,
    //         Self::OSLOneDotZero,
    //         Self::AML,
    //         Self::GPLTwoDotZero,
    //         Self::AFLTwoDotOne,
    //         Self::GPLTwoDotZeroWithAutoconfException,
    //         Self::Wwl,
    //         Self::Motosoto,
    //         Self::WThreem,
    //         Self::IMatix,
    //         Self::CCBYSAThreeDotZeroIGO,
    //         Self::SunPro,
    //         Self::OGLCanadaTwoDotZero,
    //         Self::MirOs,
    //         Self::LPDDocument,
    //         Self::HPNDDocSell,
    //         Self::AFLThreeDotZero,
    //         Self::TPDL,
    //         Self::NCL,
    //         Self::BSDSystemicsWThreeWorks,
    //         Self::Pnmstitch,
    //         Self::GFDLOneDotOneNoInvariantsOnly,
    //         Self::CCBYSATwoDotZeroUK,
    //         Self::GFDLOneDotOneInvariantsOnly,
    //         Self::GPLTwoDotZeroWithFontException,
    //         Self::CCBYNCSAFourDotZero,
    //         Self::HPNDSellVariantMITDisclaimer,
    //         Self::Abstyles,
    //         Self::Catharon,
    //         Self::AGPLOneDotZero,
    //         Self::LGPLThreeDotZeroPlus,
    //         Self::HPNDUCExportUS,
    //         Self::CDDLOneDotOne,
    //         Self::OFLOneDotOne,
    //         Self::IPLOneDotZero,
    //         Self::EUPLOneDotTwo,
    //         Self::UnixCrypt,
    //         Self::RSCPL,
    //         Self::LinuxManPagesCopyleft,
    //         Self::SSHShort,
    //         Self::OFLOneDotZeroRFN,
    //         Self::MackerrasThreeClause,
    //         Self::OSLOneDotOne,
    //         Self::IJGShort,
    //         Self::AFLTwoDotZero,
    //         Self::GFDLOneDotTwoInvariantsOnly,
    //         Self::APSLTwoDotZero,
    //         Self::WThreeCOneNineNineEightZeroSevenTwoZero,
    //         Self::TORQUEOneDotOne,
    //         Self::ZlibAcknowledgement,
    //         Self::UnicodeTOU,
    //         Self::URTRLE,
    //         Self::GPLThreeDotZero,
    //         Self::Fair,
    //         Self::SL,
    //         Self::CCBYFourDotZero,
    //         Self::RSAMD,
    //         Self::HPND,
    //         Self::Beerware,
    //         Self::WatcomOneDotZero,
    //         Self::Diffmark,
    //         Self::IECCodeComponentsEULA,
    //         Self::BSDThreeClauseModification,
    //         Self::GPLTwoDotZeroWithGCCException,
    //         Self::GCRDocs,
    //         Self::BSDThreeClauseNoNuclearWarranty,
    //         Self::CCBYNCThreeDotZeroDE,
    //         Self::PDDLOneDotZero,
    //         Self::DRLOneDotZero,
    //         Self::ArtisticTwoDotZero,
    //         Self::CCBYNCSATwoDotZeroFR,
    //         Self::SGIBTwoDotZero,
    //         Self::CCBYNCSATwoDotZeroUK,
    //         Self::GFDLOneDotOne,
    //         Self::LGPLLR,
    //         Self::CCBYTwoDotFiveAU,
    //         Self::BSDOneClause,
    //         Self::GFDLOneDotOneInvariantsOrLater,
    //         Self::BzipTwoOneDotZeroDotFive,
    //         Self::GPLTwoDotZeroPlus,
    //         Self::GPLTwoDotZeroWithBisonException,
    //         Self::GFDLOneDotThreeNoInvariantsOnly,
    //         Self::SMLNJ,
    //         Self::GlTwoPs,
    //         Self::CPLOneDotZero,
    //         Self::DLDEZEROTwoDotZero,
    //         Self::MIT,
    //         Self::Minpack,
    //         Self::MITEnna,
    //         Self::QPLOneDotZeroINRIATwoZeroZeroFour,
    //         Self::MITAdvertising,
    //         Self::ImageMagick,
    //         Self::HPNDDEC,
    //         Self::CECILLOneDotZero,
    //         Self::LucidaBitmapFonts,
    //         Self::Lsof,
    //         Self::FreeImage,
    //         Self::BSDFourDotThreeTahoe,
    //         Self::BSDTwoClauseNetBsd,
    //         Self::NRL,
    //         Self::XOneOneDistributeModificationsVariant,
    //         Self::LZMASDKNineDotOneOneToNineDotTwoZero,
    //         Self::ISC,
    //         Self::BSDFourClauseShortened,
    //         Self::LGPLThreeDotZeroOrLater,
    //         Self::BitTorrentOneDotOne,
    //         Self::Gnuplot,
    //         Self::DECThreeClause,
    //         Self::CCBYNDFourDotZero,
    //         Self::AGPLThreeDotZeroOrLater,
    //         Self::CUDAOneDotZero,
    //         Self::CATOSLOneDotOne,
    //     ]
    //     .iter()
    //     .copied()
    // }
}
impl std::fmt::Display for License {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.spdx_id())
    }
}
impl std::str::FromStr for License {
    type Err = ParseLicenseError;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "CNRI-Python-GPL-Compatible" => Ok(Self::CNRIPythonGPLCompatible),
            "HP-1986" => Ok(Self::HPOneNineEightSix),
            "EUPL-1.1" => Ok(Self::EUPLOneDotOne),
            "Cube" => Ok(Self::Cube),
            "CNRI-Jython" => Ok(Self::CNRIJython),
            "Artistic-1.0" => Ok(Self::ArtisticOneDotZero),
            "LGPL-3.0" => Ok(Self::LGPLThreeDotZero),
            "HPND-merchantability-variant" => Ok(Self::HPNDMerchantabilityVariant),
            "IJG" => Ok(Self::IJG),
            "CC-BY-SA-3.0-AT" => Ok(Self::CCBYSAThreeDotZeroAT),
            "Dotseqn" => Ok(Self::Dotseqn),
            "HPND-Netrek" => Ok(Self::HPNDNetrek),
            "JPNIC" => Ok(Self::JPNIC),
            "MPL-1.1" => Ok(Self::MPLOneDotOne),
            "SGI-B-1.0" => Ok(Self::SGIBOneDotZero),
            "Artistic-1.0-Perl" => Ok(Self::ArtisticOneDotZeroPerl),
            "copyleft-next-0.3.0" => Ok(Self::CopyleftNextZeroDotThreeDotZero),
            "fwlw" => Ok(Self::Fwlw),
            "CC-BY-3.0-DE" => Ok(Self::CCBYThreeDotZeroDE),
            "OLDAP-2.0.1" => Ok(Self::OLDAPTwoDotZeroDotOne),
            "xpp" => Ok(Self::Xpp),
            "DocBook-Schema" => Ok(Self::DocBookSchema),
            "CERN-OHL-P-2.0" => Ok(Self::CERNOHLPTwoDotZero),
            "GLWTPL" => Ok(Self::GLWTPL),
            "CPAL-1.0" => Ok(Self::CPALOneDotZero),
            "W3C-20150513" => Ok(Self::WThreeCTwoZeroOneFiveZeroFiveOneThree),
            "CC-BY-NC-ND-4.0" => Ok(Self::CCBYNCNDFourDotZero),
            "Sendmail" => Ok(Self::Sendmail),
            "softSurfer" => Ok(Self::SoftSurfer),
            "CAL-1.0-Combined-Work-Exception" => Ok(Self::CALOneDotZeroCombinedWorkException),
            "Imlib2" => Ok(Self::ImlibTwo),
            "CECILL-2.0" => Ok(Self::CECILLTwoDotZero),
            "HPND-sell-regexpr" => Ok(Self::HPNDSellRegexpr),
            "ADSL" => Ok(Self::ADSL),
            "TrustedQSL" => Ok(Self::TrustedQsl),
            "Parity-7.0.0" => Ok(Self::ParitySevenDotZeroDotZero),
            "MakeIndex" => Ok(Self::MakeIndex),
            "OML" => Ok(Self::OML),
            "LiLiQ-Rplus-1.1" => Ok(Self::LiLiQRplusOneDotOne),
            "SPL-1.0" => Ok(Self::SPLOneDotZero),
            "DOC" => Ok(Self::DOC),
            "NTP-0" => Ok(Self::NTPZero),
            "GFDL-1.3-or-later" => Ok(Self::GFDLOneDotThreeOrLater),
            "NASA-1.3" => Ok(Self::NASAOneDotThree),
            "LGPL-2.1" => Ok(Self::LGPLTwoDotOne),
            "ulem" => Ok(Self::Ulem),
            "GFDL-1.3-invariants-only" => Ok(Self::GFDLOneDotThreeInvariantsOnly),
            "HPND-sell-variant-MIT-disclaimer-rev" => Ok(Self::HPNDSellVariantMITDisclaimerRev),
            "FSFULLRWD" => Ok(Self::FSFULLRWD),
            "AGPL-3.0" => Ok(Self::AGPLThreeDotZero),
            "LGPL-2.0-or-later" => Ok(Self::LGPLTwoDotZeroOrLater),
            "AML-glslang" => Ok(Self::AMLGlslang),
            "OpenVision" => Ok(Self::OpenVision),
            "bzip2-1.0.6" => Ok(Self::BzipTwoOneDotZeroDotSix),
            "GFDL-1.2" => Ok(Self::GFDLOneDotTwo),
            "Linux-man-pages-1-para" => Ok(Self::LinuxManPagesOnePara),
            "OSL-2.1" => Ok(Self::OSLTwoDotOne),
            "Crossword" => Ok(Self::Crossword),
            "Unicode-3.0" => Ok(Self::UnicodeThreeDotZero),
            "BSD-4-Clause" => Ok(Self::BSDFourClause),
            "SSLeay-standalone" => Ok(Self::SsLeayStandalone),
            "SGP4" => Ok(Self::SgpFour),
            "SHL-0.51" => Ok(Self::SHLZeroDotFiveOne),
            "HPND-Intel" => Ok(Self::HPNDIntel),
            "LiLiQ-R-1.1" => Ok(Self::LiLiQROneDotOne),
            "APSL-1.0" => Ok(Self::APSLOneDotZero),
            "COIL-1.0" => Ok(Self::COILOneDotZero),
            "Vim" => Ok(Self::Vim),
            "snprintf" => Ok(Self::Snprintf),
            "Adobe-2006" => Ok(Self::AdobeTwoZeroZeroSix),
            "CPOL-1.02" => Ok(Self::CPOLOneDotZeroTwo),
            "MIT-0" => Ok(Self::MITZero),
            "BSD-3-Clause-Clear" => Ok(Self::BSDThreeClauseClear),
            "Ferguson-Twofish" => Ok(Self::FergusonTwofish),
            "OSL-3.0" => Ok(Self::OSLThreeDotZero),
            "TAPR-OHL-1.0" => Ok(Self::TAPROHLOneDotZero),
            "python-ldap" => Ok(Self::PythonLdap),
            "SimPL-2.0" => Ok(Self::SimPlTwoDotZero),
            "VOSTROM" => Ok(Self::VOSTROM),
            "SSH-OpenSSH" => Ok(Self::SSHOpenSsh),
            "Linux-man-pages-copyleft-var" => Ok(Self::LinuxManPagesCopyleftVar),
            "MPEG-SSG" => Ok(Self::MPEGSSG),
            "NIST-PD" => Ok(Self::NISTPD),
            "YPL-1.0" => Ok(Self::YPLOneDotZero),
            "XSkat" => Ok(Self::XSkat),
            "LAL-1.3" => Ok(Self::LALOneDotThree),
            "BSD-3-Clause-acpica" => Ok(Self::BSDThreeClauseAcpica),
            "GFDL-1.3-only" => Ok(Self::GFDLOneDotThreeOnly),
            "Entessa" => Ok(Self::Entessa),
            "Latex2e-translated-notice" => Ok(Self::LatexTwoeTranslatedNotice),
            "LOOP" => Ok(Self::LOOP),
            "Wsuipa" => Ok(Self::Wsuipa),
            "Spencer-86" => Ok(Self::SpencerEightSix),
            "OGL-UK-3.0" => Ok(Self::OGLUKThreeDotZero),
            "Hippocratic-2.1" => Ok(Self::HippocraticTwoDotOne),
            "GPL-3.0-only" => Ok(Self::GPLThreeDotZeroOnly),
            "Furuseth" => Ok(Self::Furuseth),
            "OGL-UK-2.0" => Ok(Self::OGLUKTwoDotZero),
            "LiLiQ-P-1.1" => Ok(Self::LiLiQPOneDotOne),
            "Barr" => Ok(Self::Barr),
            "HPND-UC" => Ok(Self::HPNDUC),
            "MS-PL" => Ok(Self::MSPL),
            "BSD-4-Clause-UC" => Ok(Self::BSDFourClauseUC),
            "AGPL-1.0-or-later" => Ok(Self::AGPLOneDotZeroOrLater),
            "NLPL" => Ok(Self::NLPL),
            "AMD-newlib" => Ok(Self::AMDNewlib),
            "OLDAP-2.8" => Ok(Self::OLDAPTwoDotEight),
            "GFDL-1.3" => Ok(Self::GFDLOneDotThree),
            "Knuth-CTAN" => Ok(Self::KnuthCTAN),
            "HaskellReport" => Ok(Self::HaskellReport),
            "OSL-2.0" => Ok(Self::OSLTwoDotZero),
            "MIT-Wu" => Ok(Self::MITWu),
            "AAL" => Ok(Self::AAL),
            "AFL-1.1" => Ok(Self::AFLOneDotOne),
            "Arphic-1999" => Ok(Self::ArphicOneNineNineNine),
            "GPL-1.0" => Ok(Self::GPLOneDotZero),
            "ErlPL-1.1" => Ok(Self::ErlPlOneDotOne),
            "Linux-man-pages-copyleft-2-para" => Ok(Self::LinuxManPagesCopyleftTwoPara),
            "Nokia" => Ok(Self::Nokia),
            "MIT-Click" => Ok(Self::MITClick),
            "McPhee-slideshow" => Ok(Self::McPheeSlideshow),
            "APSL-1.1" => Ok(Self::APSLOneDotOne),
            "OLDAP-2.2.2" => Ok(Self::OLDAPTwoDotTwoDotTwo),
            "LGPL-3.0-only" => Ok(Self::LGPLThreeDotZeroOnly),
            "CC-BY-SA-4.0" => Ok(Self::CCBYSAFourDotZero),
            "MIT-Festival" => Ok(Self::MITFestival),
            "RPL-1.5" => Ok(Self::RPLOneDotFive),
            "0BSD" => Ok(Self::ZeroBsd),
            "HPND-doc" => Ok(Self::HPNDDoc),
            "ClArtistic" => Ok(Self::ClArtistic),
            "TCP-wrappers" => Ok(Self::TCPWrappers),
            "generic-xts" => Ok(Self::GenericXts),
            "ISC-Veillard" => Ok(Self::ISCVeillard),
            "Rdisc" => Ok(Self::Rdisc),
            "ODbL-1.0" => Ok(Self::ODbLOneDotZero),
            "Plexus" => Ok(Self::Plexus),
            "Boehm-GC-without-fee" => Ok(Self::BoehmGCWithoutFee),
            "Inner-Net-2.0" => Ok(Self::InnerNetTwoDotZero),
            "YPL-1.1" => Ok(Self::YPLOneDotOne),
            "LAL-1.2" => Ok(Self::LALOneDotTwo),
            "ANTLR-PD" => Ok(Self::ANTLRPD),
            "UCAR" => Ok(Self::UCAR),
            "GFDL-1.2-only" => Ok(Self::GFDLOneDotTwoOnly),
            "Zlib" => Ok(Self::Zlib),
            "EUPL-1.0" => Ok(Self::EUPLOneDotZero),
            "Gutmann" => Ok(Self::Gutmann),
            "InnoSetup" => Ok(Self::InnoSetup),
            "Mackerras-3-Clause-acknowledgment" => Ok(Self::MackerrasThreeClauseAcknowledgment),
            "LPL-1.0" => Ok(Self::LPLOneDotZero),
            "SGI-B-1.1" => Ok(Self::SGIBOneDotOne),
            "MPL-1.0" => Ok(Self::MPLOneDotZero),
            "D-FSL-1.0" => Ok(Self::DFSLOneDotZero),
            "copyleft-next-0.3.1" => Ok(Self::CopyleftNextZeroDotThreeDotOne),
            "Saxpath" => Ok(Self::Saxpath),
            "OAR" => Ok(Self::OAR),
            "OPUBL-1.0" => Ok(Self::OPUBLOneDotZero),
            "TCL" => Ok(Self::TCL),
            "EFL-2.0" => Ok(Self::EFLTwoDotZero),
            "Aladdin" => Ok(Self::Aladdin),
            "GPL-2.0-with-classpath-exception" => Ok(Self::GPLTwoDotZeroWithClasspathException),
            "ThirdEye" => Ok(Self::ThirdEye),
            "MIPS" => Ok(Self::MIPS),
            "RPSL-1.0" => Ok(Self::RPSLOneDotZero),
            "MIT-CMU" => Ok(Self::MITCMU),
            "FreeBSD-DOC" => Ok(Self::FreeBsdDOC),
            "CAL-1.0" => Ok(Self::CALOneDotZero),
            "Zimbra-1.4" => Ok(Self::ZimbraOneDotFour),
            "BUSL-1.1" => Ok(Self::BUSLOneDotOne),
            "psutils" => Ok(Self::Psutils),
            "CECILL-2.1" => Ok(Self::CECILLTwoDotOne),
            "Zeeff" => Ok(Self::Zeeff),
            "Mup" => Ok(Self::Mup),
            "GFDL-1.2-no-invariants-or-later" => Ok(Self::GFDLOneDotTwoNoInvariantsOrLater),
            "GPL-3.0-with-autoconf-exception" => Ok(Self::GPLThreeDotZeroWithAutoconfException),
            "RPL-1.1" => Ok(Self::RPLOneDotOne),
            "Adobe-Glyph" => Ok(Self::AdobeGlyph),
            "BSD-3-Clause-flex" => Ok(Self::BSDThreeClauseFlex),
            "CC-BY-NC-4.0" => Ok(Self::CCBYNCFourDotZero),
            "MS-RL" => Ok(Self::MSRL),
            "BSD-3-Clause-No-Nuclear-License" => Ok(Self::BSDThreeClauseNoNuclearLicense),
            "IPA" => Ok(Self::IPA),
            "LGPL-2.0" => Ok(Self::LGPLTwoDotZero),
            "NetCDF" => Ok(Self::NetCdf),
            "ECL-1.0" => Ok(Self::ECLOneDotZero),
            "BSD-2-Clause" => Ok(Self::BSDTwoClause),
            "SAX-PD" => Ok(Self::SAXPD),
            "PSF-2.0" => Ok(Self::PSFTwoDotZero),
            "Naumen" => Ok(Self::Naumen),
            "AMDPLPA" => Ok(Self::AMDPLPA),
            "Leptonica" => Ok(Self::Leptonica),
            "StandardML-NJ" => Ok(Self::StandardMlNJ),
            "AGPL-3.0-only" => Ok(Self::AGPLThreeDotZeroOnly),
            "FSFAP-no-warranty-disclaimer" => Ok(Self::FSFAPNoWarrantyDisclaimer),
            "OLDAP-2.7" => Ok(Self::OLDAPTwoDotSeven),
            "BSD-3-Clause-Open-MPI" => Ok(Self::BSDThreeClauseOpenMPI),
            "BSD-2-Clause-Darwin" => Ok(Self::BSDTwoClauseDarwin),
            "CERN-OHL-1.2" => Ok(Self::CERNOHLOneDotTwo),
            "SchemeReport" => Ok(Self::SchemeReport),
            "Community-Spec-1.0" => Ok(Self::CommunitySpecOneDotZero),
            "CC-BY-NC-ND-3.0-IGO" => Ok(Self::CCBYNCNDThreeDotZeroIGO),
            "Kazlib" => Ok(Self::Kazlib),
            "OSET-PL-2.1" => Ok(Self::OSETPLTwoDotOne),
            "AdaCore-doc" => Ok(Self::AdaCoreDoc),
            "CC-BY-SA-3.0" => Ok(Self::CCBYSAThreeDotZero),
            "Eurosym" => Ok(Self::Eurosym),
            "APL-1.0" => Ok(Self::APLOneDotZero),
            "CDLA-Permissive-2.0" => Ok(Self::CDLAPermissiveTwoDotZero),
            "OGC-1.0" => Ok(Self::OGCOneDotZero),
            "Libpng" => Ok(Self::Libpng),
            "SWL" => Ok(Self::SWL),
            "mplus" => Ok(Self::Mplus),
            "CC-BY-1.0" => Ok(Self::CCBYOneDotZero),
            "OFFIS" => Ok(Self::OFFIS),
            "SMPPL" => Ok(Self::SMPPL),
            "JSON" => Ok(Self::JSON),
            "GPL-1.0-or-later" => Ok(Self::GPLOneDotZeroOrLater),
            "O-UDA-1.0" => Ok(Self::OUDAOneDotZero),
            "MulanPSL-1.0" => Ok(Self::MulanPslOneDotZero),
            "NAIST-2003" => Ok(Self::NAISTTwoZeroZeroThree),
            "CC-BY-3.0-IGO" => Ok(Self::CCBYThreeDotZeroIGO),
            "SMAIL-GPL" => Ok(Self::SMAILGPL),
            "SCEA" => Ok(Self::SCEA),
            "CC-BY-NC-2.5" => Ok(Self::CCBYNCTwoDotFive),
            "check-cvs" => Ok(Self::CheckCvs),
            "GPL-3.0-with-GCC-exception" => Ok(Self::GPLThreeDotZeroWithGCCException),
            "Xfig" => Ok(Self::Xfig),
            "LPPL-1.0" => Ok(Self::LPPLOneDotZero),
            "CC-BY-NC-3.0" => Ok(Self::CCBYNCThreeDotZero),
            "SISSL-1.2" => Ok(Self::SISSLOneDotTwo),
            "Glulxe" => Ok(Self::Glulxe),
            "Sendmail-8.23" => Ok(Self::SendmailEightDotTwoThree),
            "X11" => Ok(Self::XOneOne),
            "OLDAP-1.4" => Ok(Self::OLDAPOneDotFour),
            "FTL" => Ok(Self::FTL),
            "CryptoSwift" => Ok(Self::CryptoSwift),
            "DocBook-Stylesheet" => Ok(Self::DocBookStylesheet),
            "Bitstream-Vera" => Ok(Self::BitstreamVera),
            "Xnet" => Ok(Self::Xnet),
            "OLDAP-2.3" => Ok(Self::OLDAPTwoDotThree),
            "BlueOak-1.0.0" => Ok(Self::BlueOakOneDotZeroDotZero),
            "Zend-2.0" => Ok(Self::ZendTwoDotZero),
            "Soundex" => Ok(Self::Soundex),
            "CC-BY-NC-ND-2.0" => Ok(Self::CCBYNCNDTwoDotZero),
            "TTYP0" => Ok(Self::TtypZero),
            "Apache-1.0" => Ok(Self::ApacheOneDotZero),
            "BSD-Systemics" => Ok(Self::BSDSystemics),
            "magaz" => Ok(Self::Magaz),
            "FDK-AAC" => Ok(Self::FDKAAC),
            "CC-BY-SA-2.5" => Ok(Self::CCBYSATwoDotFive),
            "xlock" => Ok(Self::Xlock),
            "XFree86-1.1" => Ok(Self::XFreeEightSixOneDotOne),
            "Zed" => Ok(Self::Zed),
            "PolyForm-Noncommercial-1.0.0" => Ok(Self::PolyFormNoncommercialOneDotZeroDotZero),
            "ZPL-2.0" => Ok(Self::ZPLTwoDotZero),
            "NGPL" => Ok(Self::NGPL),
            "CC-BY-ND-1.0" => Ok(Self::CCBYNDOneDotZero),
            "LGPL-2.1-only" => Ok(Self::LGPLTwoDotOneOnly),
            "libpng-2.0" => Ok(Self::LibpngTwoDotZero),
            "Net-SNMP" => Ok(Self::NetSNMP),
            "HPND-sell-variant" => Ok(Self::HPNDSellVariant),
            "TU-Berlin-2.0" => Ok(Self::TUBerlinTwoDotZero),
            "Ruby-pty" => Ok(Self::RubyPty),
            "HPND-INRIA-IMAG" => Ok(Self::HPNDINRIAIMAG),
            "LPPL-1.1" => Ok(Self::LPPLOneDotOne),
            "GFDL-1.2-no-invariants-only" => Ok(Self::GFDLOneDotTwoNoInvariantsOnly),
            "HPND-sell-MIT-disclaimer-xserver" => Ok(Self::HPNDSellMITDisclaimerXserver),
            "MMIXware" => Ok(Self::MmiXware),
            "EPL-2.0" => Ok(Self::EPLTwoDotZero),
            "NCSA" => Ok(Self::NCSA),
            "BSD-3-Clause-No-Military-License" => Ok(Self::BSDThreeClauseNoMilitaryLicense),
            "GPL-2.0-only" => Ok(Self::GPLTwoDotZeroOnly),
            "MIT-testregex" => Ok(Self::MITTestregex),
            "NCGL-UK-2.0" => Ok(Self::NCGLUKTwoDotZero),
            "OLDAP-2.2" => Ok(Self::OLDAPTwoDotTwo),
            "CDLA-Sharing-1.0" => Ok(Self::CDLASharingOneDotZero),
            "CC-BY-NC-ND-3.0" => Ok(Self::CCBYNCNDThreeDotZero),
            "HP-1989" => Ok(Self::HPOneNineEightNine),
            "Bahyph" => Ok(Self::Bahyph),
            "3D-Slicer-1.0" => Ok(Self::ThreeDSlicerOneDotZero),
            "Apache-1.1" => Ok(Self::ApacheOneDotOne),
            "Multics" => Ok(Self::Multics),
            "UPL-1.0" => Ok(Self::UPLOneDotZero),
            "Nunit" => Ok(Self::Nunit),
            "TPL-1.0" => Ok(Self::TPLOneDotZero),
            "FBM" => Ok(Self::FBM),
            "blessing" => Ok(Self::Blessing),
            "Unicode-DFS-2016" => Ok(Self::UnicodeDFSTwoZeroOneSix),
            "Jam" => Ok(Self::Jam),
            "DocBook-DTD" => Ok(Self::DocBookDTD),
            "MPL-2.0-no-copyleft-exception" => Ok(Self::MPLTwoDotZeroNoCopyleftException),
            "BSD-3-Clause-No-Nuclear-License-2014" => {
                Ok(Self::BSDThreeClauseNoNuclearLicenseTwoZeroOneFour)
            }
            "Interbase-1.0" => Ok(Self::InterbaseOneDotZero),
            "BSD-3-Clause-LBNL" => Ok(Self::BSDThreeClauseLBNL),
            "LGPL-2.0-only" => Ok(Self::LGPLTwoDotZeroOnly),
            "Newsletr" => Ok(Self::Newsletr),
            "ZPL-2.1" => Ok(Self::ZPLTwoDotOne),
            "Sleepycat" => Ok(Self::Sleepycat),
            "CC-BY-NC-2.0" => Ok(Self::CCBYNCTwoDotZero),
            "X11-swapped" => Ok(Self::XOneOneSwapped),
            "Latex2e" => Ok(Self::LatexTwoe),
            "Caldera" => Ok(Self::Caldera),
            "GD" => Ok(Self::GD),
            "Frameworx-1.0" => Ok(Self::FrameworxOneDotZero),
            "Qhull" => Ok(Self::Qhull),
            "metamail" => Ok(Self::Metamail),
            "CUA-OPL-1.0" => Ok(Self::CUAOPLOneDotZero),
            "CC-BY-3.0-NL" => Ok(Self::CCBYThreeDotZeroNL),
            "Giftware" => Ok(Self::Giftware),
            "PADL" => Ok(Self::PADL),
            "BSD-Source-Code" => Ok(Self::BSDSourceCode),
            "Caldera-no-preamble" => Ok(Self::CalderaNoPreamble),
            "OLDAP-2.6" => Ok(Self::OLDAPTwoDotSix),
            "Adobe-Display-PostScript" => Ok(Self::AdobeDisplayPostScript),
            "Cronyx" => Ok(Self::Cronyx),
            "LPPL-1.3a" => Ok(Self::LPPLOneDotThreea),
            "psfrag" => Ok(Self::Psfrag),
            "CC0-1.0" => Ok(Self::CcZeroOneDotZero),
            "Martin-Birgmeier" => Ok(Self::MartinBirgmeier),
            "MIT-Modern-Variant" => Ok(Self::MITModernVariant),
            "Spencer-99" => Ok(Self::SpencerNineNine),
            "OLDAP-1.1" => Ok(Self::OLDAPOneDotOne),
            "FSFAP" => Ok(Self::FSFAP),
            "GFDL-1.1-only" => Ok(Self::GFDLOneDotOneOnly),
            "Unlicense" => Ok(Self::Unlicense),
            "CC-BY-SA-2.0" => Ok(Self::CCBYSATwoDotZero),
            "MIT-feh" => Ok(Self::MITFeh),
            "FSFUL" => Ok(Self::FSFUL),
            "NPOSL-3.0" => Ok(Self::NPOSLThreeDotZero),
            "Afmparse" => Ok(Self::Afmparse),
            "CC-BY-NC-ND-2.5" => Ok(Self::CCBYNCNDTwoDotFive),
            "TTWL" => Ok(Self::TTWL),
            "BSD-3-Clause" => Ok(Self::BSDThreeClause),
            "HPND-Markus-Kuhn" => Ok(Self::HPNDMarkusKuhn),
            "PolyForm-Small-Business-1.0.0" => Ok(Self::PolyFormSmallBusinessOneDotZeroDotZero),
            "DL-DE-BY-2.0" => Ok(Self::DLDEBYTwoDotZero),
            "BSD-Inferno-Nettverk" => Ok(Self::BSDInfernoNettverk),
            "NLOD-1.0" => Ok(Self::NLODOneDotZero),
            "CC-BY-NC-SA-1.0" => Ok(Self::CCBYNCSAOneDotZero),
            "CC-BY-3.0-US" => Ok(Self::CCBYThreeDotZeroUS),
            "OGTSL" => Ok(Self::OGTSL),
            "Python-2.0.1" => Ok(Self::PythonTwoDotZeroDotOne),
            "OFL-1.1-RFN" => Ok(Self::OFLOneDotOneRFN),
            "JasPer-2.0" => Ok(Self::JasPerTwoDotZero),
            "GPL-2.0-or-later" => Ok(Self::GPLTwoDotZeroOrLater),
            "ASWF-Digital-Assets-1.0" => Ok(Self::ASWFDigitalAssetsOneDotZero),
            "LPPL-1.2" => Ok(Self::LPPLOneDotTwo),
            "NIST-Software" => Ok(Self::NISTSoftware),
            "W3C" => Ok(Self::WThreeC),
            "GFDL-1.1-no-invariants-or-later" => Ok(Self::GFDLOneDotOneNoInvariantsOrLater),
            "Python-2.0" => Ok(Self::PythonTwoDotZero),
            "threeparttable" => Ok(Self::Threeparttable),
            "HPND-export2-US" => Ok(Self::HPNDExportTwoUS),
            "ANTLR-PD-fallback" => Ok(Self::ANTLRPDFallback),
            "TMate" => Ok(Self::TMate),
            "OPL-1.0" => Ok(Self::OPLOneDotZero),
            "OpenPBS-2.3" => Ok(Self::OpenPbsTwoDotThree),
            "NPL-1.0" => Ok(Self::NPLOneDotZero),
            "any-OSI" => Ok(Self::AnyOSI),
            "OGDL-Taiwan-1.0" => Ok(Self::OGDLTaiwanOneDotZero),
            "dvipdfm" => Ok(Self::Dvipdfm),
            "hdparm" => Ok(Self::Hdparm),
            "CC-BY-3.0" => Ok(Self::CCBYThreeDotZero),
            "mailprio" => Ok(Self::Mailprio),
            "CC-BY-NC-SA-2.0-DE" => Ok(Self::CCBYNCSATwoDotZeroDE),
            "SugarCRM-1.1.3" => Ok(Self::SugarCrmOneDotOneDotThree),
            "Sun-PPP" => Ok(Self::SunPPP),
            "Brian-Gladman-2-Clause" => Ok(Self::BrianGladmanTwoClause),
            "LGPL-2.1+" => Ok(Self::LGPLTwoDotOnePlus),
            "App-s2p" => Ok(Self::AppSTwop),
            "BSD-2-Clause-FreeBSD" => Ok(Self::BSDTwoClauseFreeBsd),
            "Symlinks" => Ok(Self::Symlinks),
            "OLDAP-2.1" => Ok(Self::OLDAPTwoDotOne),
            "NCBI-PD" => Ok(Self::NCBIPD),
            "BSD-3-Clause-HP" => Ok(Self::BSDThreeClauseHP),
            "ICU" => Ok(Self::ICU),
            "SGI-OpenGL" => Ok(Self::SGIOpenGl),
            "MIT-Khronos-old" => Ok(Self::MITKhronosOld),
            "CC-BY-SA-1.0" => Ok(Self::CCBYSAOneDotZero),
            "CECILL-C" => Ok(Self::CECILLC),
            "gtkbook" => Ok(Self::Gtkbook),
            "Widget-Workshop" => Ok(Self::WidgetWorkshop),
            "CC-SA-1.0" => Ok(Self::CCSAOneDotZero),
            "LGPL-2.0+" => Ok(Self::LGPLTwoDotZeroPlus),
            "BSD-Protection" => Ok(Self::BSDProtection),
            "Noweb" => Ok(Self::Noweb),
            "Unicode-DFS-2015" => Ok(Self::UnicodeDFSTwoZeroOneFive),
            "Boehm-GC" => Ok(Self::BoehmGC),
            "curl" => Ok(Self::Curl),
            "HPND-MIT-disclaimer" => Ok(Self::HPNDMITDisclaimer),
            "CC-PDDC" => Ok(Self::CCPDDC),
            "CC-BY-NC-SA-2.0" => Ok(Self::CCBYNCSATwoDotZero),
            "NLOD-2.0" => Ok(Self::NLODTwoDotZero),
            "wxWindows" => Ok(Self::WxWindows),
            "EPICS" => Ok(Self::EPICS),
            "HPND-export-US-modify" => Ok(Self::HPNDExportUSModify),
            "BSD-Advertising-Acknowledgement" => Ok(Self::BSDAdvertisingAcknowledgement),
            "OFL-1.1-no-RFN" => Ok(Self::OFLOneDotOneNoRFN),
            "CC-BY-ND-2.5" => Ok(Self::CCBYNDTwoDotFive),
            "VSL-1.0" => Ok(Self::VSLOneDotZero),
            "bcrypt-Solar-Designer" => Ok(Self::BcryptSolarDesigner),
            "SISSL" => Ok(Self::SISSL),
            "TU-Berlin-1.0" => Ok(Self::TUBerlinOneDotZero),
            "Parity-6.0.0" => Ok(Self::ParitySixDotZeroDotZero),
            "SNIA" => Ok(Self::SNIA),
            "SAX-PD-2.0" => Ok(Self::SAXPDTwoDotZero),
            "xinetd" => Ok(Self::Xinetd),
            "TermReadKey" => Ok(Self::TermReadKey),
            "GPL-3.0-or-later" => Ok(Self::GPLThreeDotZeroOrLater),
            "HPND-Fenneberg-Livingston" => Ok(Self::HPNDFennebergLivingston),
            "CC-BY-ND-3.0" => Ok(Self::CCBYNDThreeDotZero),
            "RHeCos-1.1" => Ok(Self::RHeCosOneDotOne),
            "MIT-open-group" => Ok(Self::MITOpenGroup),
            "NBPL-1.0" => Ok(Self::NBPLOneDotZero),
            "OPL-UK-3.0" => Ok(Self::OPLUKThreeDotZero),
            "EPL-1.0" => Ok(Self::EPLOneDotZero),
            "ODC-By-1.0" => Ok(Self::ODCByOneDotZero),
            "SSPL-1.0" => Ok(Self::SSPLOneDotZero),
            "MTLL" => Ok(Self::MTLL),
            "OLDAP-2.5" => Ok(Self::OLDAPTwoDotFive),
            "PPL" => Ok(Self::PPL),
            "TOSL" => Ok(Self::TOSL),
            "Game-Programming-Gems" => Ok(Self::GameProgrammingGems),
            "OLDAP-1.2" => Ok(Self::OLDAPOneDotTwo),
            "CC-BY-2.5" => Ok(Self::CCBYTwoDotFive),
            "CrystalStacker" => Ok(Self::CrystalStacker),
            "OpenSSL-standalone" => Ok(Self::OpenSslStandalone),
            "Clips" => Ok(Self::Clips),
            "CC-BY-SA-3.0-DE" => Ok(Self::CCBYSAThreeDotZeroDE),
            "OCLC-2.0" => Ok(Self::OCLCTwoDotZero),
            "cve-tou" => Ok(Self::CveTou),
            "LZMA-SDK-9.22" => Ok(Self::LZMASDKNineDotTwoTwo),
            "BSD-3-Clause-Sun" => Ok(Self::BSDThreeClauseSun),
            "CC-BY-3.0-AT" => Ok(Self::CCBYThreeDotZeroAT),
            "CC-BY-NC-1.0" => Ok(Self::CCBYNCOneDotZero),
            "Intel-ACPI" => Ok(Self::IntelACPI),
            "ZPL-1.1" => Ok(Self::ZPLOneDotOne),
            "BSD-4.3RENO" => Ok(Self::BSDFourDotThreeReno),
            "NICTA-1.0" => Ok(Self::NICTAOneDotZero),
            "CC-BY-ND-3.0-DE" => Ok(Self::CCBYNDThreeDotZeroDE),
            "BSD-3-Clause-Attribution" => Ok(Self::BSDThreeClauseAttribution),
            "IBM-pibs" => Ok(Self::IBMPibs),
            "Info-ZIP" => Ok(Self::InfoZIP),
            "HIDAPI" => Ok(Self::HIDAPI),
            "BSL-1.0" => Ok(Self::BSLOneDotZero),
            "dtoa" => Ok(Self::Dtoa),
            "etalab-2.0" => Ok(Self::EtalabTwoDotZero),
            "HPND-Pbmplus" => Ok(Self::HPNDPbmplus),
            "Bitstream-Charter" => Ok(Self::BitstreamCharter),
            "PostgreSQL" => Ok(Self::PostgreSql),
            "CERN-OHL-1.1" => Ok(Self::CERNOHLOneDotOne),
            "HPND-export-US-acknowledgement" => Ok(Self::HPNDExportUSAcknowledgement),
            "GPL-3.0+" => Ok(Self::GPLThreeDotZeroPlus),
            "OLDAP-2.4" => Ok(Self::OLDAPTwoDotFour),
            "OLDAP-1.3" => Ok(Self::OLDAPOneDotThree),
            "OLFL-1.3" => Ok(Self::OLFLOneDotThree),
            "LPPL-1.3c" => Ok(Self::LPPLOneDotThreec),
            "CC-BY-NC-ND-1.0" => Ok(Self::CCBYNCNDOneDotZero),
            "CC-BY-SA-2.1-JP" => Ok(Self::CCBYSATwoDotOneJP),
            "GPL-1.0-only" => Ok(Self::GPLOneDotZeroOnly),
            "LGPL-2.1-or-later" => Ok(Self::LGPLTwoDotOneOrLater),
            "Apache-2.0" => Ok(Self::ApacheTwoDotZero),
            "CERN-OHL-S-2.0" => Ok(Self::CERNOHLSTwoDotZero),
            "NIST-PD-fallback" => Ok(Self::NISTPDFallback),
            "radvd" => Ok(Self::Radvd),
            "FSFULLR" => Ok(Self::FSFULLR),
            "CMU-Mach-nodoc" => Ok(Self::CMUMachNodoc),
            "OCCT-PL" => Ok(Self::OCCTPL),
            "MITNFA" => Ok(Self::MITNFA),
            "CC-PDM-1.0" => Ok(Self::CCPDMOneDotZero),
            "CC-BY-3.0-AU" => Ok(Self::CCBYThreeDotZeroAU),
            "gSOAP-1.3b" => Ok(Self::GSoapOneDotThreeb),
            "CC-BY-ND-2.0" => Ok(Self::CCBYNDTwoDotZero),
            "DocBook-XML" => Ok(Self::DocBookXML),
            "checkmk" => Ok(Self::Checkmk),
            "Linux-OpenIB" => Ok(Self::LinuxOpenIb),
            "CC-BY-NC-SA-2.5" => Ok(Self::CCBYNCSATwoDotFive),
            "CC-BY-NC-ND-3.0-DE" => Ok(Self::CCBYNCNDThreeDotZeroDE),
            "ASWF-Digital-Assets-1.1" => Ok(Self::ASWFDigitalAssetsOneDotOne),
            "PHP-3.01" => Ok(Self::PHPThreeDotZeroOne),
            "CC-BY-NC-SA-3.0" => Ok(Self::CCBYNCSAThreeDotZero),
            "libselinux-1.0" => Ok(Self::LibselinuxOneDotZero),
            "JPL-image" => Ok(Self::JPLImage),
            "NPL-1.1" => Ok(Self::NPLOneDotOne),
            "any-OSI-perl-modules" => Ok(Self::AnyOSIPerlModules),
            "libutil-David-Nugent" => Ok(Self::LibutilDavidNugent),
            "GFDL-1.2-or-later" => Ok(Self::GFDLOneDotTwoOrLater),
            "CDLA-Permissive-1.0" => Ok(Self::CDLAPermissiveOneDotZero),
            "HPND-Kevlin-Henney" => Ok(Self::HPNDKevlinHenney),
            "CMU-Mach" => Ok(Self::CMUMach),
            "CC-BY-NC-SA-3.0-DE" => Ok(Self::CCBYNCSAThreeDotZeroDE),
            "OLDAP-2.0" => Ok(Self::OLDAPTwoDotZero),
            "BSD-2-Clause-first-lines" => Ok(Self::BSDTwoClauseFirstLines),
            "GPL-1.0+" => Ok(Self::GPLOneDotZeroPlus),
            "CECILL-B" => Ok(Self::CECILLB),
            "Graphics-Gems" => Ok(Self::GraphicsGems),
            "GFDL-1.3-invariants-or-later" => Ok(Self::GFDLOneDotThreeInvariantsOrLater),
            "Xdebug-1.03" => Ok(Self::XdebugOneDotZeroThree),
            "swrule" => Ok(Self::Swrule),
            "pkgconf" => Ok(Self::Pkgconf),
            "OpenSSL" => Ok(Self::OpenSsl),
            "CC-BY-2.0" => Ok(Self::CCBYTwoDotZero),
            "QPL-1.0" => Ok(Self::QPLOneDotZero),
            "DSDP" => Ok(Self::DSDP),
            "Intel" => Ok(Self::Intel),
            "CC-BY-NC-SA-3.0-IGO" => Ok(Self::CCBYNCSAThreeDotZeroIGO),
            "Pixar" => Ok(Self::Pixar),
            "xkeyboard-config-Zinoviev" => Ok(Self::XkeyboardConfigZinoviev),
            "BSD-2-Clause-Views" => Ok(Self::BSDTwoClauseViews),
            "CNRI-Python" => Ok(Self::CNRIPython),
            "MulanPSL-2.0" => Ok(Self::MulanPslTwoDotZero),
            "eGenix" => Ok(Self::EGenix),
            "Glide" => Ok(Self::Glide),
            "LPL-1.02" => Ok(Self::LPLOneDotZeroTwo),
            "Xerox" => Ok(Self::Xerox),
            "xzoom" => Ok(Self::Xzoom),
            "MS-LPL" => Ok(Self::MSLPL),
            "DRL-1.1" => Ok(Self::DRLOneDotOne),
            "Spencer-94" => Ok(Self::SpencerNineFour),
            "Brian-Gladman-3-Clause" => Ok(Self::BrianGladmanThreeClause),
            "CDL-1.0" => Ok(Self::CDLOneDotZero),
            "UCL-1.0" => Ok(Self::UCLOneDotZero),
            "Adobe-Utopia" => Ok(Self::AdobeUtopia),
            "libtiff" => Ok(Self::Libtiff),
            "MPL-2.0" => Ok(Self::MPLTwoDotZero),
            "UMich-Merit" => Ok(Self::UMichMerit),
            "man2html" => Ok(Self::ManTwohtml),
            "GFDL-1.3-no-invariants-or-later" => Ok(Self::GFDLOneDotThreeNoInvariantsOrLater),
            "NOSL" => Ok(Self::NOSL),
            "AMPAS" => Ok(Self::AMPAS),
            "Elastic-2.0" => Ok(Self::ElasticTwoDotZero),
            "BSD-2-Clause-Patent" => Ok(Self::BSDTwoClausePatent),
            "GFDL-1.2-invariants-or-later" => Ok(Self::GFDLOneDotTwoInvariantsOrLater),
            "mpich2" => Ok(Self::MpichTwo),
            "WTFPL" => Ok(Self::WTFPL),
            "AFL-1.2" => Ok(Self::AFLOneDotTwo),
            "EUDatagrid" => Ok(Self::EuDatagrid),
            "Artistic-1.0-cl8" => Ok(Self::ArtisticOneDotZeroClEight),
            "NTP" => Ok(Self::NTP),
            "TGPPL-1.0" => Ok(Self::TGPPLOneDotZero),
            "APSL-1.2" => Ok(Self::APSLOneDotTwo),
            "EFL-1.0" => Ok(Self::EFLOneDotZero),
            "CERN-OHL-W-2.0" => Ok(Self::CERNOHLWTwoDotZero),
            "Ruby" => Ok(Self::Ruby),
            "Condor-1.1" => Ok(Self::CondorOneDotOne),
            "GFDL-1.1-or-later" => Ok(Self::GFDLOneDotOneOrLater),
            "CECILL-1.1" => Ok(Self::CECILLOneDotOne),
            "OLDAP-2.2.1" => Ok(Self::OLDAPTwoDotTwoDotOne),
            "OFL-1.0-no-RFN" => Ok(Self::OFLOneDotZeroNoRFN),
            "AGPL-1.0-only" => Ok(Self::AGPLOneDotZeroOnly),
            "HTMLTIDY" => Ok(Self::HTMLTIDY),
            "BSD-Source-beginning-file" => Ok(Self::BSDSourceBeginningFile),
            "Zimbra-1.3" => Ok(Self::ZimbraOneDotThree),
            "SHL-0.5" => Ok(Self::SHLZeroDotFive),
            "BitTorrent-1.0" => Ok(Self::BitTorrentOneDotZero),
            "Kastrup" => Ok(Self::Kastrup),
            "Sendmail-Open-Source-1.1" => Ok(Self::SendmailOpenSourceOneDotOne),
            "Baekmuk" => Ok(Self::Baekmuk),
            "Sun-PPP-2000" => Ok(Self::SunPPPTwoZeroZeroZero),
            "PHP-3.0" => Ok(Self::PHPThreeDotZero),
            "ECL-2.0" => Ok(Self::ECLTwoDotZero),
            "OGL-UK-1.0" => Ok(Self::OGLUKOneDotZero),
            "HPND-export-US" => Ok(Self::HPNDExportUS),
            "ssh-keyscan" => Ok(Self::SshKeyscan),
            "CDDL-1.0" => Ok(Self::CDDLOneDotZero),
            "Borceux" => Ok(Self::Borceux),
            "mpi-permissive" => Ok(Self::MpiPermissive),
            "OFL-1.0" => Ok(Self::OFLOneDotZero),
            "Ubuntu-font-1.0" => Ok(Self::UbuntuFontOneDotZero),
            "BSD-Attribution-HPND-disclaimer" => Ok(Self::BSDAttributionHPNDDisclaimer),
            "APAFML" => Ok(Self::APAFML),
            "CFITSIO" => Ok(Self::CFITSIO),
            "Cornell-Lossless-JPEG" => Ok(Self::CornellLosslessJPEG),
            "eCos-2.0" => Ok(Self::ECosTwoDotZero),
            "OSL-1.0" => Ok(Self::OSLOneDotZero),
            "AML" => Ok(Self::AML),
            "GPL-2.0" => Ok(Self::GPLTwoDotZero),
            "AFL-2.1" => Ok(Self::AFLTwoDotOne),
            "GPL-2.0-with-autoconf-exception" => Ok(Self::GPLTwoDotZeroWithAutoconfException),
            "wwl" => Ok(Self::Wwl),
            "Motosoto" => Ok(Self::Motosoto),
            "w3m" => Ok(Self::WThreem),
            "iMatix" => Ok(Self::IMatix),
            "CC-BY-SA-3.0-IGO" => Ok(Self::CCBYSAThreeDotZeroIGO),
            "SunPro" => Ok(Self::SunPro),
            "OGL-Canada-2.0" => Ok(Self::OGLCanadaTwoDotZero),
            "MirOS" => Ok(Self::MirOs),
            "LPD-document" => Ok(Self::LPDDocument),
            "HPND-doc-sell" => Ok(Self::HPNDDocSell),
            "AFL-3.0" => Ok(Self::AFLThreeDotZero),
            "TPDL" => Ok(Self::TPDL),
            "NCL" => Ok(Self::NCL),
            "BSD-Systemics-W3Works" => Ok(Self::BSDSystemicsWThreeWorks),
            "pnmstitch" => Ok(Self::Pnmstitch),
            "GFDL-1.1-no-invariants-only" => Ok(Self::GFDLOneDotOneNoInvariantsOnly),
            "CC-BY-SA-2.0-UK" => Ok(Self::CCBYSATwoDotZeroUK),
            "GFDL-1.1-invariants-only" => Ok(Self::GFDLOneDotOneInvariantsOnly),
            "GPL-2.0-with-font-exception" => Ok(Self::GPLTwoDotZeroWithFontException),
            "CC-BY-NC-SA-4.0" => Ok(Self::CCBYNCSAFourDotZero),
            "HPND-sell-variant-MIT-disclaimer" => Ok(Self::HPNDSellVariantMITDisclaimer),
            "Abstyles" => Ok(Self::Abstyles),
            "Catharon" => Ok(Self::Catharon),
            "AGPL-1.0" => Ok(Self::AGPLOneDotZero),
            "LGPL-3.0+" => Ok(Self::LGPLThreeDotZeroPlus),
            "HPND-UC-export-US" => Ok(Self::HPNDUCExportUS),
            "CDDL-1.1" => Ok(Self::CDDLOneDotOne),
            "OFL-1.1" => Ok(Self::OFLOneDotOne),
            "IPL-1.0" => Ok(Self::IPLOneDotZero),
            "EUPL-1.2" => Ok(Self::EUPLOneDotTwo),
            "UnixCrypt" => Ok(Self::UnixCrypt),
            "RSCPL" => Ok(Self::RSCPL),
            "Linux-man-pages-copyleft" => Ok(Self::LinuxManPagesCopyleft),
            "SSH-short" => Ok(Self::SSHShort),
            "OFL-1.0-RFN" => Ok(Self::OFLOneDotZeroRFN),
            "Mackerras-3-Clause" => Ok(Self::MackerrasThreeClause),
            "OSL-1.1" => Ok(Self::OSLOneDotOne),
            "IJG-short" => Ok(Self::IJGShort),
            "AFL-2.0" => Ok(Self::AFLTwoDotZero),
            "GFDL-1.2-invariants-only" => Ok(Self::GFDLOneDotTwoInvariantsOnly),
            "APSL-2.0" => Ok(Self::APSLTwoDotZero),
            "W3C-19980720" => Ok(Self::WThreeCOneNineNineEightZeroSevenTwoZero),
            "TORQUE-1.1" => Ok(Self::TORQUEOneDotOne),
            "zlib-acknowledgement" => Ok(Self::ZlibAcknowledgement),
            "Unicode-TOU" => Ok(Self::UnicodeTOU),
            "URT-RLE" => Ok(Self::URTRLE),
            "GPL-3.0" => Ok(Self::GPLThreeDotZero),
            "Fair" => Ok(Self::Fair),
            "SL" => Ok(Self::SL),
            "CC-BY-4.0" => Ok(Self::CCBYFourDotZero),
            "RSA-MD" => Ok(Self::RSAMD),
            "HPND" => Ok(Self::HPND),
            "Beerware" => Ok(Self::Beerware),
            "Watcom-1.0" => Ok(Self::WatcomOneDotZero),
            "diffmark" => Ok(Self::Diffmark),
            "IEC-Code-Components-EULA" => Ok(Self::IECCodeComponentsEULA),
            "BSD-3-Clause-Modification" => Ok(Self::BSDThreeClauseModification),
            "GPL-2.0-with-GCC-exception" => Ok(Self::GPLTwoDotZeroWithGCCException),
            "GCR-docs" => Ok(Self::GCRDocs),
            "BSD-3-Clause-No-Nuclear-Warranty" => Ok(Self::BSDThreeClauseNoNuclearWarranty),
            "CC-BY-NC-3.0-DE" => Ok(Self::CCBYNCThreeDotZeroDE),
            "PDDL-1.0" => Ok(Self::PDDLOneDotZero),
            "DRL-1.0" => Ok(Self::DRLOneDotZero),
            "Artistic-2.0" => Ok(Self::ArtisticTwoDotZero),
            "CC-BY-NC-SA-2.0-FR" => Ok(Self::CCBYNCSATwoDotZeroFR),
            "SGI-B-2.0" => Ok(Self::SGIBTwoDotZero),
            "CC-BY-NC-SA-2.0-UK" => Ok(Self::CCBYNCSATwoDotZeroUK),
            "GFDL-1.1" => Ok(Self::GFDLOneDotOne),
            "LGPLLR" => Ok(Self::LGPLLR),
            "CC-BY-2.5-AU" => Ok(Self::CCBYTwoDotFiveAU),
            "BSD-1-Clause" => Ok(Self::BSDOneClause),
            "GFDL-1.1-invariants-or-later" => Ok(Self::GFDLOneDotOneInvariantsOrLater),
            "bzip2-1.0.5" => Ok(Self::BzipTwoOneDotZeroDotFive),
            "GPL-2.0+" => Ok(Self::GPLTwoDotZeroPlus),
            "GPL-2.0-with-bison-exception" => Ok(Self::GPLTwoDotZeroWithBisonException),
            "GFDL-1.3-no-invariants-only" => Ok(Self::GFDLOneDotThreeNoInvariantsOnly),
            "SMLNJ" => Ok(Self::SMLNJ),
            "GL2PS" => Ok(Self::GlTwoPs),
            "CPL-1.0" => Ok(Self::CPLOneDotZero),
            "DL-DE-ZERO-2.0" => Ok(Self::DLDEZEROTwoDotZero),
            "MIT" => Ok(Self::MIT),
            "Minpack" => Ok(Self::Minpack),
            "MIT-enna" => Ok(Self::MITEnna),
            "QPL-1.0-INRIA-2004" => Ok(Self::QPLOneDotZeroINRIATwoZeroZeroFour),
            "MIT-advertising" => Ok(Self::MITAdvertising),
            "ImageMagick" => Ok(Self::ImageMagick),
            "HPND-DEC" => Ok(Self::HPNDDEC),
            "CECILL-1.0" => Ok(Self::CECILLOneDotZero),
            "Lucida-Bitmap-Fonts" => Ok(Self::LucidaBitmapFonts),
            "lsof" => Ok(Self::Lsof),
            "FreeImage" => Ok(Self::FreeImage),
            "BSD-4.3TAHOE" => Ok(Self::BSDFourDotThreeTahoe),
            "BSD-2-Clause-NetBSD" => Ok(Self::BSDTwoClauseNetBsd),
            "NRL" => Ok(Self::NRL),
            "X11-distribute-modifications-variant" => {
                Ok(Self::XOneOneDistributeModificationsVariant)
            }
            "LZMA-SDK-9.11-to-9.20" => Ok(Self::LZMASDKNineDotOneOneToNineDotTwoZero),
            "ISC" => Ok(Self::ISC),
            "BSD-4-Clause-Shortened" => Ok(Self::BSDFourClauseShortened),
            "LGPL-3.0-or-later" => Ok(Self::LGPLThreeDotZeroOrLater),
            "BitTorrent-1.1" => Ok(Self::BitTorrentOneDotOne),
            "gnuplot" => Ok(Self::Gnuplot),
            "DEC-3-Clause" => Ok(Self::DECThreeClause),
            "CC-BY-ND-4.0" => Ok(Self::CCBYNDFourDotZero),
            "AGPL-3.0-or-later" => Ok(Self::AGPLThreeDotZeroOrLater),
            "C-UDA-1.0" => Ok(Self::CUDAOneDotZero),
            "CATOSL-1.1" => Ok(Self::CATOSLOneDotOne),
            _ => Err(ParseLicenseError),
        }
    }
}
