// ThreeSVG.js r33 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,c){var d,e,f,g,i,h;if(c==0)d=e=f=0;else{g=Math.floor(a*6);i=a*6-g;a=c*(1-b);h=c*(1-b*i);b=c*(1-b*(1-i));switch(g){case 1:d=h;e=c;f=a;break;case 2:d=a;e=c;f=b;break;case 3:d=a;e=h;f=c;break;case 4:d=b;e=a;f=c;break;case 5:d=c;e=a;f=h;break;case 6:case 0:d=c;e=b;f=a}}this.r=d;this.g=e;this.b=f;if(this.autoUpdate){this.updateHex();
this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.set(c*a.z-d*a.y,d*a.x-b*a.z,b*a.y-c*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,c,d=a.objects,e=[];a=0;for(b=d.length;a<b;a++){c=d[a];c instanceof THREE.Mesh&&(e=e.concat(this.intersectObject(c)))}e.sort(function(f,g){return f.distance-g.distance});return e},intersectObject:function(a){function b(t,j,H,p){p=p.clone().subSelf(j);H=H.clone().subSelf(j);var y=t.clone().subSelf(j);t=p.dot(p);j=p.dot(H);p=p.dot(y);var C=H.dot(H);H=H.dot(y);y=1/(t*C-j*j);C=(C*p-j*H)*y;t=(t*H-j*p)*y;return C>0&&t>0&&C+t<1}var c,d,e,f,g,i,h,k,n,m,
l,o=a.geometry,q=o.vertices,s=[];c=0;for(d=o.faces.length;c<d;c++){e=o.faces[c];m=this.origin.clone();l=this.direction.clone();h=a.matrixWorld;f=h.multiplyVector3(q[e.a].position.clone());g=h.multiplyVector3(q[e.b].position.clone());i=h.multiplyVector3(q[e.c].position.clone());h=e instanceof THREE.Face4?h.multiplyVector3(q[e.d].position.clone()):null;k=a.matrixRotationWorld.multiplyVector3(e.normal.clone());n=l.dot(k);if(n<0){k=k.dot((new THREE.Vector3).sub(f,m))/n;m=m.addSelf(l.multiplyScalar(k));
if(e instanceof THREE.Face3){if(b(m,f,g,i)){e={distance:this.origin.distanceTo(m),point:m,face:e,object:a};s.push(e)}}else if(e instanceof THREE.Face4&&(b(m,f,g,h)||b(m,g,i,h))){e={distance:this.origin.distanceTo(m),point:m,face:e,object:a};s.push(e)}}}return s}};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(h,k,n,m){i=!1;b=h;c=k;d=n;e=m;a()};this.addPoint=function(h,k){if(i){i=!1;b=h;c=k;d=h;e=k}else{b=b<h?b:h;c=c<k?c:k;d=d>h?d:h;e=e>k?e:k}a()};
this.add3Points=function(h,k,n,m,l,o){if(i){i=!1;b=h<n?h<l?h:l:n<l?n:l;c=k<m?k<o?k:o:m<o?m:o;d=h>n?h>l?h:l:n>l?n:l;e=k>m?k>o?k:o:m>o?m:o}else{b=h<n?h<l?h<b?h:b:l<b?l:b:n<l?n<b?n:b:l<b?l:b;c=k<m?k<o?k<c?k:c:o<c?o:c:m<o?m<c?m:c:o<c?o:c;d=h>n?h>l?h>d?h:d:l>d?l:d:n>l?n>d?n:d:l>d?l:d;e=k>m?k>o?k>e?k:e:o>e?o:e:m>o?m>e?m:e:o>e?o:e}a()};this.addRectangle=function(h){if(i){i=!1;b=h.getLeft();c=h.getTop();d=h.getRight();e=h.getBottom()}else{b=b<h.getLeft()?b:h.getLeft();c=c<h.getTop()?c:h.getTop();d=d>h.getRight()?
d:h.getRight();e=e>h.getBottom()?e:h.getBottom()}a()};this.inflate=function(h){b-=h;c-=h;d+=h;e+=h;a()};this.minSelf=function(h){b=b>h.getLeft()?b:h.getLeft();c=c>h.getTop()?c:h.getTop();d=d<h.getRight()?d:h.getRight();e=e<h.getBottom()?e:h.getBottom();a()};this.instersects=function(h){return Math.min(d,h.getRight())-Math.max(b,h.getLeft())>=0&&Math.min(e,h.getBottom())-Math.max(c,h.getTop())>=0};this.empty=function(){i=!0;e=d=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,f,g,i,h,k,n,m,l,o,q,s){this.set(a||1,b||0,c||0,d||0,e||0,f||1,g||0,i||0,h||0,k||0,n||1,m||0,l||0,o||0,q||0,s||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,f,g,i,h,k,n,m,l,o,q,s){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=g;this.n24=i;this.n31=h;this.n32=k;this.n33=n;this.n34=m;this.n41=l;this.n42=o;this.n43=q;this.n44=s;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__tmpVec1,
e=THREE.Matrix4.__tmpVec2,f=THREE.Matrix4.__tmpVec3;f.sub(a,b).normalize();d.cross(c,f).normalize();e.cross(f,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n14=a.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n24=a.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;this.n34=a.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*
b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector3OnlyZ:function(a){var b=a.x,c=a.y;a=a.z;return(this.n31*b+this.n32*c+this.n33*a+this.n34)*(1/(this.n41*b+this.n42*c+this.n43*a+this.n44))},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},crossVector:function(a){var b=new THREE.Vector4;
b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,i=a.n22,h=a.n23,k=a.n24,n=a.n31,m=a.n32,l=a.n33,o=a.n34,q=a.n41,s=a.n42,t=a.n43,j=a.n44,H=b.n11,p=b.n12,y=b.n13,C=b.n14,L=b.n21,z=b.n22,v=b.n23,I=b.n24,E=b.n31,K=b.n32,J=b.n33,u=b.n34;this.n11=c*
H+d*L+e*E;this.n12=c*p+d*z+e*K;this.n13=c*y+d*v+e*J;this.n14=c*C+d*I+e*u+f;this.n21=g*H+i*L+h*E;this.n22=g*p+i*z+h*K;this.n23=g*y+i*v+h*J;this.n24=g*C+i*I+h*u+k;this.n31=n*H+m*L+l*E;this.n32=n*p+m*z+l*K;this.n33=n*y+m*v+l*J;this.n34=n*C+m*I+l*u+o;this.n41=q*H+s*L+t*E;this.n42=q*p+s*z+t*K;this.n43=q*y+s*v+t*J;this.n44=q*C+s*I+t*u+j;return this},multiplyToArray:function(a,b,c){var d=a.n11,e=a.n12,f=a.n13,g=a.n14,i=a.n21,h=a.n22,k=a.n23,n=a.n24,m=a.n31,l=a.n32,o=a.n33,q=a.n34,s=a.n41,t=a.n42,j=a.n43;
a=a.n44;var H=b.n11,p=b.n12,y=b.n13,C=b.n14,L=b.n21,z=b.n22,v=b.n23,I=b.n24,E=b.n31,K=b.n32,J=b.n33,u=b.n34,D=b.n41,S=b.n42,x=b.n43;b=b.n44;this.n11=d*H+e*L+f*E+g*D;this.n12=d*p+e*z+f*K+g*S;this.n13=d*y+e*v+f*J+g*x;this.n14=d*C+e*I+f*u+g*b;this.n21=i*H+h*L+k*E+n*D;this.n22=i*p+h*z+k*K+n*S;this.n23=i*y+h*v+k*J+n*x;this.n24=i*C+h*I+k*u+n*b;this.n31=m*H+l*L+o*E+q*D;this.n32=m*p+l*z+o*K+q*S;this.n33=m*y+l*v+o*J+q*x;this.n34=m*C+l*I+o*u+q*b;this.n41=s*H+t*L+j*E+a*D;this.n42=s*p+t*z+j*K+a*S;this.n43=s*
y+t*v+j*J+a*x;this.n44=s*C+t*I+j*u+a*b;c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){var b=this.n11,c=this.n12,d=this.n13,e=this.n14,f=this.n21,g=this.n22,i=this.n23,h=this.n24,k=this.n31,n=this.n32,m=this.n33,l=this.n34,o=this.n41,q=this.n42,s=this.n43,t=this.n44,j=a.n11,H=a.n21,
p=a.n31,y=a.n12,C=a.n22,L=a.n32,z=a.n13,v=a.n23,I=a.n33,E=a.n14,K=a.n24;a=a.n34;this.n11=b*j+c*H+d*p;this.n12=b*y+c*C+d*L;this.n13=b*z+c*v+d*I;this.n14=b*E+c*K+d*a+e;this.n21=f*j+g*H+i*p;this.n22=f*y+g*C+i*L;this.n23=f*z+g*v+i*I;this.n24=f*E+g*K+i*a+h;this.n31=k*j+n*H+m*p;this.n32=k*y+n*C+m*L;this.n33=k*z+n*v+m*I;this.n34=k*E+n*K+m*a+l;this.n41=o*j+q*H+s*p;this.n42=o*y+q*C+s*L;this.n43=o*z+q*v+s*I;this.n44=o*E+q*K+s*a+t;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=
a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,g=this.n23,i=this.n24,h=this.n31,k=this.n32,n=this.n33,m=this.n34,l=this.n41,o=this.n42,q=this.n43,s=this.n44;return d*g*k*l-c*i*k*l-d*f*n*l+b*i*n*l+c*f*m*l-b*g*m*l-d*g*h*o+c*i*h*o+d*e*n*o-a*i*n*o-c*e*m*o+a*g*m*o+d*f*h*q-b*i*h*q-d*e*k*q+a*i*k*q+b*e*
m*q-a*f*m*q-c*f*h*s+b*g*h*s+c*e*k*s-a*g*k*s-b*e*n*s+a*f*n*s},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;
a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flattenToArray(this.flat);return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=
this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,
b,-a,0,0,a,b,0,0,0,0,1);return this},setRotY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,i=a.z,h=e*f,k=e*g;this.set(h*f+c,h*g-d*i,h*i+d*g,0,h*g+d*i,k*g+c,k*i-d*f,0,h*i-d*g,k*i+d*f,e*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;
this.n34=a.z;return this},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z;a=Math.cos(b);b=Math.sin(b);var e=Math.cos(c);c=Math.sin(c);var f=Math.cos(d);d=Math.sin(d);var g=a*c,i=b*c;this.n11=e*f;this.n12=-e*d;this.n13=c;this.n21=i*f+a*d;this.n22=-i*d+a*f;this.n23=-b*e;this.n31=-g*f+b*d;this.n32=g*d+b*f;this.n33=a*e},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,g=c+c,i=d+d;a=b*f;var h=b*g;b*=i;var k=c*g;c*=i;d*=i;f*=e;g*=e;e*=i;this.n11=1-(k+d);this.n12=h-e;this.n13=
b+g;this.n21=h+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-g;this.n32=c+f;this.n33=1-(a+k)},scale:function(a){var b=a.x,c=a.y;a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this}};THREE.Matrix4.translationMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setTranslation(a,b,c);return d};THREE.Matrix4.scaleMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setScale(a,b,c);return d};
THREE.Matrix4.rotationXMatrix=function(a){var b=new THREE.Matrix4;b.setRotX(a);return b};THREE.Matrix4.rotationYMatrix=function(a){var b=new THREE.Matrix4;b.setRotY(a);return b};THREE.Matrix4.rotationZMatrix=function(a){var b=new THREE.Matrix4;b.setRotZ(a);return b};THREE.Matrix4.rotationAxisAngleMatrix=function(a,b){var c=new THREE.Matrix4;c.setRotAxis(a,b);return c};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,i=a.n22,h=a.n23,k=a.n24,n=a.n31,m=a.n32,l=a.n33,o=a.n34,q=a.n41,s=a.n42,t=a.n43,j=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=h*o*s-k*l*s+k*m*t-i*o*t-h*m*j+i*l*j;b.n12=f*l*s-e*o*s-f*m*t+d*o*t+e*m*j-d*l*j;b.n13=e*k*s-f*h*s+f*i*t-d*k*t-e*i*j+d*h*j;b.n14=f*h*m-e*k*m-f*i*l+d*k*l+e*i*o-d*h*o;b.n21=k*l*q-h*o*q-k*n*t+g*o*t+h*n*j-g*l*j;b.n22=e*o*q-f*l*q+f*n*t-c*o*t-e*n*j+c*l*j;b.n23=f*h*q-e*k*q-f*g*t+c*k*t+e*g*j-c*h*j;
b.n24=e*k*n-f*h*n+f*g*l-c*k*l-e*g*o+c*h*o;b.n31=i*o*q-k*m*q+k*n*s-g*o*s-i*n*j+g*m*j;b.n32=f*m*q-d*o*q-f*n*s+c*o*s+d*n*j-c*m*j;b.n33=e*k*q-f*i*q+f*g*s-c*k*s-d*g*j+c*i*j;b.n34=f*i*n-d*k*n-f*g*m+c*k*m+d*g*o-c*i*o;b.n41=h*m*q-i*l*q-h*n*s+g*l*s+i*n*t-g*m*t;b.n42=d*l*q-e*m*q+e*n*s-c*l*s-d*n*t+c*m*t;b.n43=e*i*q-d*h*q-e*g*s+c*h*s+d*g*t-c*i*t;b.n44=d*h*n-e*i*n+e*g*m-c*h*m-d*g*l+c*i*l;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,h=-a.n32*a.n11+a.n31*a.n12,k=a.n23*a.n12-a.n22*a.n13,n=-a.n23*a.n11+a.n21*a.n13,m=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*g+a.n31*k;if(a==0)throw"matrix not invertible";a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*g;c[4]=a*i;c[5]=a*h;c[6]=a*k;c[7]=a*n;c[8]=a*m;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var g;g=new THREE.Matrix4;g.n11=2*e/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*e/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(f+e)/(f-e);g.n34=-2*f*e/(f-e);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var e;a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var g,i,h,k;g=new THREE.Matrix4;i=b-a;h=c-d;k=f-e;g.n11=2/i;g.n12=0;g.n13=0;g.n14=-((b+a)/i);g.n21=0;g.n22=2/h;g.n23=0;g.n24=-((c+d)/h);g.n31=0;g.n32=0;g.n33=-2/k;g.n34=-((f+e)/k);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__tmpVec1=new THREE.Vector3;THREE.Matrix4.__tmpVec2=new THREE.Vector3;THREE.Matrix4.__tmpVec3=new THREE.Vector3;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.parent=undefined;this.children=[];this.position=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixNeedsUpdate=!0;this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;
this.visible=!0};
THREE.Object3D.prototype={addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b instanceof THREE.Scene===!1&&b!==undefined;)b=b.parent;b!==undefined&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);
if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}return!0},update:function(a,b,c){if(this.visible){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);b=1/this.scale.x;a=1/this.scale.y;var d=1/this.scale.z;this.matrixRotationWorld.n11=this.matrixWorld.n11*b;this.matrixRotationWorld.n21=
this.matrixWorld.n21*b;this.matrixRotationWorld.n31=this.matrixWorld.n31*b;this.matrixRotationWorld.n12=this.matrixWorld.n12*a;this.matrixRotationWorld.n22=this.matrixWorld.n22*a;this.matrixRotationWorld.n32=this.matrixWorld.n32*a;this.matrixRotationWorld.n13=this.matrixWorld.n13*d;this.matrixRotationWorld.n23=this.matrixWorld.n23*d;this.matrixRotationWorld.n33=this.matrixWorld.n33*d;this.matrixNeedsUpdate=!1;b=!0}a=0;for(d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}}};
THREE.Object3DCounter={value:0};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b;a=Math.cos(d);d=Math.sin(d);b=Math.cos(-e);e=Math.sin(-e);var f=Math.cos(c);c=Math.sin(c);var g=a*b,i=d*e;this.w=g*f-i*c;this.x=g*c+i*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,i=a.z;a=a.w;this.x=b*a+e*f+c*i-d*g;this.y=c*a+e*g+d*f-b*i;this.z=d*a+e*i+b*g-c*f;this.w=e*a-b*f-c*g-d*i;return this},
multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,i=this.z,h=this.w,k=h*c+g*e-i*d,n=h*d+i*c-f*e,m=h*e+f*d-g*c;c=-f*c-g*d-i*e;b.x=k*h+c*-f+n*-i-m*-g;b.y=n*h+c*-g+m*-f-k*-i;b.z=m*h+c*-i+k*-g-n*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var f=Math.acos(e),g=Math.sqrt(1-e*e);if(Math.abs(g)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}e=Math.sin((1-d)*f)/g;d=Math.sin(d*f)/g;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};
THREE.Vertex=function(a,b){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=b||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=!0};
THREE.Face3=function(a,b,c,d,e){this.a=a;this.b=b;this.c=c;this.centroid=new THREE.Vector3;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.materials=e instanceof Array?e:[e]};THREE.Face4=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.d=d;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=f instanceof Array?f:[f]};
THREE.UV=function(a,b){this.set(a||0,b||0)};THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.faces=[];this.uvs=[];this.uvs2=[];this.colors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,c,d,e,f,g,i=new THREE.Vector3,h=new THREE.Vector3;d=0;for(e=this.vertices.length;d<e;d++){f=this.vertices[d];f.normal.set(0,0,0)}d=0;for(e=this.faces.length;d<e;d++){f=this.faces[d];if(a&&f.vertexNormals.length){i.set(0,0,0);b=0;for(c=f.normal.length;b<c;b++)i.addSelf(f.vertexNormals[b]);i.divideScalar(3)}else{b=this.vertices[f.a];c=this.vertices[f.b];g=this.vertices[f.c];i.sub(g.position,
c.position);h.sub(b.position,c.position);i.crossSelf(h)}i.isZero()||i.normalize();f.normal.copy(i)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,
new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<
b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeTangents:function(){function a(u,D,S,x,N,F,A){f=u.vertices[D].position;g=u.vertices[S].position;i=u.vertices[x].position;h=e[N];k=e[F];n=e[A];m=g.x-f.x;l=i.x-f.x;o=g.y-f.y;q=i.y-f.y;
s=g.z-f.z;t=i.z-f.z;j=k.u-h.u;H=n.u-h.u;p=k.v-h.v;y=n.v-h.v;C=1/(j*y-H*p);v.set((y*m-p*l)*C,(y*o-p*q)*C,(y*s-p*t)*C);I.set((j*l-H*m)*C,(j*q-H*o)*C,(j*t-H*s)*C);L[D].addSelf(v);L[S].addSelf(v);L[x].addSelf(v);z[D].addSelf(I);z[S].addSelf(I);z[x].addSelf(I)}var b,c,d,e,f,g,i,h,k,n,m,l,o,q,s,t,j,H,p,y,C,L=[],z=[],v=new THREE.Vector3,I=new THREE.Vector3,E=new THREE.Vector3,K=new THREE.Vector3,J=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++){L[b]=new THREE.Vector3;z[b]=new THREE.Vector3}b=0;
for(c=this.faces.length;b<c;b++){d=this.faces[b];e=this.uvs[b];if(d instanceof THREE.Face3){a(this,d.a,d.b,d.c,0,1,2);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2])}else if(d instanceof THREE.Face4){a(this,d.a,d.b,d.c,0,1,2);a(this,d.a,d.b,d.d,0,1,3);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2]);
this.vertices[d.d].normal.copy(d.vertexNormals[3])}}b=0;for(c=this.vertices.length;b<c;b++){J.copy(this.vertices[b].normal);d=L[b];E.copy(d);E.subSelf(J.multiplyScalar(J.dot(d))).normalize();K.cross(this.vertices[b].normal,d);d=K.dot(z[b]);d=d<0?-1:1;this.vertices[b].tangent.set(E.x,E.y,E.z,d)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],
z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>
this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(n){var m=[];b=0;for(c=n.length;b<c;b++)n[b]==undefined?m.push("undefined"):m.push(n[b].id);return m.join("_")}var b,c,d,e,f,g,i,h,k={};d=0;for(e=this.faces.length;d<e;d++){f=this.faces[d];
g=f.materials;i=a(g);k[i]==undefined&&(k[i]={hash:i,counter:0});h=k[i].hash+"_"+k[i].counter;this.geometryChunks[h]==undefined&&(this.geometryChunks[h]={faces:[],materials:g,vertices:0});f=f instanceof THREE.Face3?3:4;if(this.geometryChunks[h].vertices+f>65535){k[i].counter+=1;h=k[i].hash+"_"+k[i].counter;this.geometryChunks[h]==undefined&&(this.geometryChunks[h]={faces:[],materials:g,vertices:0})}this.geometryChunks[h].faces.push(d);this.geometryChunks[h].vertices+=f}}};THREE.GeometryIdCounter=0;
THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.up=new THREE.Vector3(0,1,0);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.tmpVec=new THREE.Vector3;this.translateX=function(f,g){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(f);this.tmpVec.crossSelf(this.up);if(g)this.tmpVec.y=0;this.position.addSelf(this.tmpVec);
this.target.position.addSelf(this.tmpVec)};this.translateZ=function(f,g){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(f);if(g)this.tmpVec.y=0;this.position.subSelf(this.tmpVec);this.target.position.subSelf(this.tmpVec)};this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,
this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.FlatShading=0;THREE.SmoothShading=1;
THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.BillboardBlending=3;THREE.ReverseSubtractiveBlending=4;THREE.MaterialCounter={value:0};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==
undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==
undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==
undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};THREE.ParticleCircleMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var e;c=this.sources.length;for(a=0;a<c;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)e=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)e="audio/ogg";else b.indexOf(".wav")!==-1&&(e="audio/wav");if(this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Scene=function(){THREE.Object3D.call(this);this.objects=[];this.lights=[];this.sounds=[];this.fog=null;this.matrixAutoUpdate=!1};
THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else a instanceof THREE.Camera||a instanceof THREE.Bone||this.objects.indexOf(a)===-1&&this.objects.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};
THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);b!==-1&&this.objects.splice(b,1)}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(z,v){return v.z-z.z}function b(z,v){var I=0,E=1,K=z.z+z.w,J=v.z+v.w,u=-z.z+z.w,D=-v.z+v.w;if(K>=0&&J>=0&&u>=0&&D>=0)return!0;else if(K<0&&J<0||u<0&&D<0)return!1;else{if(K<0)I=Math.max(I,K/(K-J));else J<0&&(E=Math.min(E,K/(K-J)));if(u<0)I=Math.max(I,u/(u-D));else D<0&&(E=Math.min(E,u/(u-D)));if(E<I)return!1;else{z.lerpSelf(v,I);v.lerpSelf(z,1-E);return!0}}}var c,d,e=[],f,g,i,h=[],k,n,m=[],l,o,q=[],s=new THREE.Vector4,t=new THREE.Vector4,j=new THREE.Matrix4,H=new THREE.Matrix4,
p=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],y=new THREE.Vector4,C=new THREE.Vector4,L;this.projectObjects=function(z,v,I){v=[];var E,K,J;d=0;K=z.objects;z=0;for(E=K.length;z<E;z++){J=K[z];var u;if(!(u=!J.visible))if(u=J instanceof THREE.Mesh){a:{u=void 0;for(var D=J.matrixWorld,S=-J.geometry.boundingSphere.radius*Math.max(J.scale.x,Math.max(J.scale.y,J.scale.z)),x=0;x<6;x++){u=p[x].x*D.n14+p[x].y*D.n24+p[x].z*D.n34+p[x].w;if(u<=S){u=
!1;break a}}u=!0}u=!u}if(!u){c=e[d]=e[d]||new THREE.RenderableObject;s.copy(J.position);j.multiplyVector3(s);c.object=J;c.z=s.z;v.push(c);d++}}I&&v.sort(a);return v};this.projectScene=function(z,v,I){var E=[],K=v.near,J=v.far,u,D,S,x,N,F,A,O,Q,B,w,M,P,r,G,R;i=n=o=0;v.matrixAutoUpdate&&v.update();j.multiply(v.projectionMatrix,v.matrixWorldInverse);p[0].set(j.n41-j.n11,j.n42-j.n12,j.n43-j.n13,j.n44-j.n14);p[1].set(j.n41+j.n11,j.n42+j.n12,j.n43+j.n13,j.n44+j.n14);p[2].set(j.n41+j.n21,j.n42+j.n22,j.n43+
j.n23,j.n44+j.n24);p[3].set(j.n41-j.n21,j.n42-j.n22,j.n43-j.n23,j.n44-j.n24);p[4].set(j.n41-j.n31,j.n42-j.n32,j.n43-j.n33,j.n44-j.n34);p[5].set(j.n41+j.n31,j.n42+j.n32,j.n43+j.n33,j.n44+j.n34);for(u=0;u<6;u++){F=p[u];F.divideScalar(Math.sqrt(F.x*F.x+F.y*F.y+F.z*F.z))}z.update(undefined,!1,v);F=this.projectObjects(z,v,!0);z=0;for(u=F.length;z<u;z++){A=F[z].object;if(A.visible){O=A.matrixWorld;w=A.matrixRotationWorld;Q=A.materials;B=A.overdraw;if(A instanceof THREE.Mesh){M=A.geometry;P=M.vertices;D=
0;for(S=P.length;D<S;D++){r=P[D];r.positionWorld.copy(r.position);O.multiplyVector3(r.positionWorld);x=r.positionScreen;x.copy(r.positionWorld);j.multiplyVector4(x);x.x/=x.w;x.y/=x.w;r.__visible=x.z>K&&x.z<J}M=M.faces;D=0;for(S=M.length;D<S;D++){r=M[D];if(r instanceof THREE.Face3){x=P[r.a];N=P[r.b];G=P[r.c];if(x.__visible&&N.__visible&&G.__visible&&(A.doubleSided||A.flipSided!=(G.positionScreen.x-x.positionScreen.x)*(N.positionScreen.y-x.positionScreen.y)-(G.positionScreen.y-x.positionScreen.y)*(N.positionScreen.x-
x.positionScreen.x)<0)){f=h[i]=h[i]||new THREE.RenderableFace3;f.v1.positionWorld.copy(x.positionWorld);f.v2.positionWorld.copy(N.positionWorld);f.v3.positionWorld.copy(G.positionWorld);f.v1.positionScreen.copy(x.positionScreen);f.v2.positionScreen.copy(N.positionScreen);f.v3.positionScreen.copy(G.positionScreen);f.normalWorld.copy(r.normal);w.multiplyVector3(f.normalWorld);f.centroidWorld.copy(r.centroid);O.multiplyVector3(f.centroidWorld);f.centroidScreen.copy(f.centroidWorld);j.multiplyVector3(f.centroidScreen);
G=r.vertexNormals;L=f.vertexNormalsWorld;x=0;for(N=G.length;x<N;x++){R=L[x]=L[x]||new THREE.Vector3;R.copy(G[x]);w.multiplyVector3(R)}f.z=f.centroidScreen.z;f.meshMaterials=Q;f.faceMaterials=r.materials;f.overdraw=B;if(A.geometry.uvs[D]){f.uvs[0]=A.geometry.uvs[D][0];f.uvs[1]=A.geometry.uvs[D][1];f.uvs[2]=A.geometry.uvs[D][2]}E.push(f);i++}}else if(r instanceof THREE.Face4){x=P[r.a];N=P[r.b];G=P[r.c];R=P[r.d];if(x.__visible&&N.__visible&&G.__visible&&R.__visible&&(A.doubleSided||A.flipSided!=((R.positionScreen.x-
x.positionScreen.x)*(N.positionScreen.y-x.positionScreen.y)-(R.positionScreen.y-x.positionScreen.y)*(N.positionScreen.x-x.positionScreen.x)<0||(N.positionScreen.x-G.positionScreen.x)*(R.positionScreen.y-G.positionScreen.y)-(N.positionScreen.y-G.positionScreen.y)*(R.positionScreen.x-G.positionScreen.x)<0))){f=h[i]=h[i]||new THREE.RenderableFace3;f.v1.positionWorld.copy(x.positionWorld);f.v2.positionWorld.copy(N.positionWorld);f.v3.positionWorld.copy(R.positionWorld);f.v1.positionScreen.copy(x.positionScreen);
f.v2.positionScreen.copy(N.positionScreen);f.v3.positionScreen.copy(R.positionScreen);f.normalWorld.copy(r.normal);w.multiplyVector3(f.normalWorld);f.centroidWorld.copy(r.centroid);O.multiplyVector3(f.centroidWorld);f.centroidScreen.copy(f.centroidWorld);j.multiplyVector3(f.centroidScreen);f.z=f.centroidScreen.z;f.meshMaterials=Q;f.faceMaterials=r.materials;f.overdraw=B;if(A.geometry.uvs[D]){f.uvs[0]=A.geometry.uvs[D][0];f.uvs[1]=A.geometry.uvs[D][1];f.uvs[2]=A.geometry.uvs[D][3]}E.push(f);i++;g=
h[i]=h[i]||new THREE.RenderableFace3;g.v1.positionWorld.copy(N.positionWorld);g.v2.positionWorld.copy(G.positionWorld);g.v3.positionWorld.copy(R.positionWorld);g.v1.positionScreen.copy(N.positionScreen);g.v2.positionScreen.copy(G.positionScreen);g.v3.positionScreen.copy(R.positionScreen);g.normalWorld.copy(f.normalWorld);g.centroidWorld.copy(f.centroidWorld);g.centroidScreen.copy(f.centroidScreen);g.z=g.centroidScreen.z;g.meshMaterials=Q;g.faceMaterials=r.materials;g.overdraw=B;if(A.geometry.uvs[D]){g.uvs[0]=
A.geometry.uvs[D][1];g.uvs[1]=A.geometry.uvs[D][2];g.uvs[2]=A.geometry.uvs[D][3]}E.push(g);i++}}}}else if(A instanceof THREE.Line){H.multiply(j,O);P=A.geometry.vertices;r=P[0];r.positionScreen.copy(r.position);H.multiplyVector4(r.positionScreen);D=1;for(S=P.length;D<S;D++){x=P[D];x.positionScreen.copy(x.position);H.multiplyVector4(x.positionScreen);N=P[D-1];y.copy(x.positionScreen);C.copy(N.positionScreen);if(b(y,C)){y.multiplyScalar(1/y.w);C.multiplyScalar(1/C.w);k=m[n]=m[n]||new THREE.RenderableLine;
k.v1.positionScreen.copy(y);k.v2.positionScreen.copy(C);k.z=Math.max(y.z,C.z);k.materials=A.materials;E.push(k);n++}}}else if(A instanceof THREE.Particle){t.set(A.position.x,A.position.y,A.position.z,1);j.multiplyVector4(t);t.z/=t.w;if(t.z>0&&t.z<1){l=q[o]=q[o]||new THREE.RenderableParticle;l.x=t.x/t.w;l.y=t.y/t.w;l.z=t.z;l.rotation=A.rotation.z;l.scale.x=A.scale.x*Math.abs(l.x-(t.x+v.projectionMatrix.n11)/(t.w+v.projectionMatrix.n14));l.scale.y=A.scale.y*Math.abs(l.y-(t.y+v.projectionMatrix.n22)/
(t.w+v.projectionMatrix.n24));l.materials=A.materials;E.push(l);o++}}}}I&&E.sort(a);return E};this.unprojectVector=function(z,v){var I=v.matrixWorld.clone();I.multiplySelf(THREE.Matrix4.makeInvert(v.projectionMatrix));I.multiplyVector3(z);return z}};
THREE.SVGRenderer=function(){function a(F,A,O){var Q,B,w,M;Q=0;for(B=F.lights.length;Q<B;Q++){w=F.lights[Q];if(w instanceof THREE.DirectionalLight){M=A.normalWorld.dot(w.position)*w.intensity;if(M>0){O.r+=w.color.r*M;O.g+=w.color.g*M;O.b+=w.color.b*M}}else if(w instanceof THREE.PointLight){I.sub(w.position,A.centroidWorld);I.normalize();M=A.normalWorld.dot(I)*w.intensity;if(M>0){O.r+=w.color.r*M;O.g+=w.color.g*M;O.b+=w.color.b*M}}}}function b(F,A,O,Q,B,w){u=d(D++);u.setAttribute("d","M "+F.positionScreen.x+
" "+F.positionScreen.y+" L "+A.positionScreen.x+" "+A.positionScreen.y+" L "+O.positionScreen.x+","+O.positionScreen.y+"z");if(B instanceof THREE.MeshBasicMaterial)p.__styleString=B.color.__styleString;else if(B instanceof THREE.MeshLambertMaterial)if(H){y.r=C.r;y.g=C.g;y.b=C.b;a(w,Q,y);p.r=B.color.r*y.r;p.g=B.color.g*y.g;p.b=B.color.b*y.b;p.updateStyleString()}else p.__styleString=B.color.__styleString;else if(B instanceof THREE.MeshDepthMaterial){v=1-B.__2near/(B.__farPlusNear-Q.z*B.__farMinusNear);
p.setRGB(v,v,v)}else B instanceof THREE.MeshNormalMaterial&&p.setRGB(e(Q.normalWorld.x),e(Q.normalWorld.y),e(Q.normalWorld.z));B.wireframe?u.setAttribute("style","fill: none; stroke: "+p.__styleString+"; stroke-width: "+B.wireframeLinewidth+"; stroke-opacity: "+B.opacity+"; stroke-linecap: "+B.wireframeLinecap+"; stroke-linejoin: "+B.wireframeLinejoin):u.setAttribute("style","fill: "+p.__styleString+"; fill-opacity: "+B.opacity);i.appendChild(u)}function c(F,A,O,Q,B,w,M){u=d(D++);u.setAttribute("d",
"M "+F.positionScreen.x+" "+F.positionScreen.y+" L "+A.positionScreen.x+" "+A.positionScreen.y+" L "+O.positionScreen.x+","+O.positionScreen.y+" L "+Q.positionScreen.x+","+Q.positionScreen.y+"z");if(w instanceof THREE.MeshBasicMaterial)p.__styleString=w.color.__styleString;else if(w instanceof THREE.MeshLambertMaterial)if(H){y.r=C.r;y.g=C.g;y.b=C.b;a(M,B,y);p.r=w.color.r*y.r;p.g=w.color.g*y.g;p.b=w.color.b*y.b;p.updateStyleString()}else p.__styleString=w.color.__styleString;else if(w instanceof THREE.MeshDepthMaterial){v=
1-w.__2near/(w.__farPlusNear-B.z*w.__farMinusNear);p.setRGB(v,v,v)}else w instanceof THREE.MeshNormalMaterial&&p.setRGB(e(B.normalWorld.x),e(B.normalWorld.y),e(B.normalWorld.z));w.wireframe?u.setAttribute("style","fill: none; stroke: "+p.__styleString+"; stroke-width: "+w.wireframeLinewidth+"; stroke-opacity: "+w.opacity+"; stroke-linecap: "+w.wireframeLinecap+"; stroke-linejoin: "+w.wireframeLinejoin):u.setAttribute("style","fill: "+p.__styleString+"; fill-opacity: "+w.opacity);i.appendChild(u)}
function d(F){if(E[F]==null){E[F]=document.createElementNS("http://www.w3.org/2000/svg","path");N==0&&E[F].setAttribute("shape-rendering","crispEdges")}return E[F]}function e(F){return F<0?Math.min((1+F)*0.5,0.5):0.5+Math.min(F*0.5,0.5)}var f=null,g=new THREE.Projector,i=document.createElementNS("http://www.w3.org/2000/svg","svg"),h,k,n,m,l,o,q,s,t=new THREE.Rectangle,j=new THREE.Rectangle,H=!1,p=new THREE.Color(16777215),y=new THREE.Color(16777215),C=new THREE.Color(0),L=new THREE.Color(0),z=new THREE.Color(0),
v,I=new THREE.Vector3,E=[],K=[],J=[],u,D,S,x,N=1;this.domElement=i;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setQuality=function(F){switch(F){case "high":N=1;break;case "low":N=0}};this.setSize=function(F,A){h=F;k=A;n=h/2;m=k/2;i.setAttribute("viewBox",-n+" "+-m+" "+h+" "+k);i.setAttribute("width",h);i.setAttribute("height",k);t.set(-n,-m,n,m)};this.clear=function(){for(;i.childNodes.length>0;)i.removeChild(i.childNodes[0])};this.render=function(F,A){var O,Q,B,w,M,P,r,G;this.autoClear&&
this.clear();f=g.projectScene(F,A,this.sortElements);x=S=D=0;if(H=F.lights.length>0){r=F.lights;C.setRGB(0,0,0);L.setRGB(0,0,0);z.setRGB(0,0,0);O=0;for(Q=r.length;O<Q;O++){B=r[O];w=B.color;if(B instanceof THREE.AmbientLight){C.r+=w.r;C.g+=w.g;C.b+=w.b}else if(B instanceof THREE.DirectionalLight){L.r+=w.r;L.g+=w.g;L.b+=w.b}else if(B instanceof THREE.PointLight){z.r+=w.r;z.g+=w.g;z.b+=w.b}}}O=0;for(Q=f.length;O<Q;O++){r=f[O];j.empty();if(r instanceof THREE.RenderableParticle){l=r;l.x*=n;l.y*=-m;B=0;
for(w=r.materials.length;B<w;B++)if(G=r.materials[B]){M=l;P=r;var R=S++;if(K[R]==null){K[R]=document.createElementNS("http://www.w3.org/2000/svg","circle");N==0&&K[R].setAttribute("shape-rendering","crispEdges")}u=K[R];u.setAttribute("cx",M.x);u.setAttribute("cy",M.y);u.setAttribute("r",P.scale.x*n);if(G instanceof THREE.ParticleCircleMaterial){if(H){y.r=C.r+L.r+z.r;y.g=C.g+L.g+z.g;y.b=C.b+L.b+z.b;p.r=G.color.r*y.r;p.g=G.color.g*y.g;p.b=G.color.b*y.b;p.updateStyleString()}else p=G.color;u.setAttribute("style",
"fill: "+p.__styleString)}i.appendChild(u)}}else if(r instanceof THREE.RenderableLine){l=r.v1;o=r.v2;l.positionScreen.x*=n;l.positionScreen.y*=-m;o.positionScreen.x*=n;o.positionScreen.y*=-m;j.addPoint(l.positionScreen.x,l.positionScreen.y);j.addPoint(o.positionScreen.x,o.positionScreen.y);if(t.instersects(j)){B=0;for(w=r.materials.length;B<w;)if(G=r.materials[B++]){M=l;P=o;R=x++;if(J[R]==null){J[R]=document.createElementNS("http://www.w3.org/2000/svg","line");N==0&&J[R].setAttribute("shape-rendering",
"crispEdges")}u=J[R];u.setAttribute("x1",M.positionScreen.x);u.setAttribute("y1",M.positionScreen.y);u.setAttribute("x2",P.positionScreen.x);u.setAttribute("y2",P.positionScreen.y);if(G instanceof THREE.LineBasicMaterial){p.__styleString=G.color.__styleString;u.setAttribute("style","fill: none; stroke: "+p.__styleString+"; stroke-width: "+G.linewidth+"; stroke-opacity: "+G.opacity+"; stroke-linecap: "+G.linecap+"; stroke-linejoin: "+G.linejoin);i.appendChild(u)}}}}else if(r instanceof THREE.RenderableFace3){l=
r.v1;o=r.v2;q=r.v3;l.positionScreen.x*=n;l.positionScreen.y*=-m;o.positionScreen.x*=n;o.positionScreen.y*=-m;q.positionScreen.x*=n;q.positionScreen.y*=-m;j.addPoint(l.positionScreen.x,l.positionScreen.y);j.addPoint(o.positionScreen.x,o.positionScreen.y);j.addPoint(q.positionScreen.x,q.positionScreen.y);if(t.instersects(j)){B=0;for(w=r.meshMaterials.length;B<w;){G=r.meshMaterials[B++];if(G instanceof THREE.MeshFaceMaterial){M=0;for(P=r.faceMaterials.length;M<P;)(G=r.faceMaterials[M++])&&b(l,o,q,r,
G,F)}else G&&b(l,o,q,r,G,F)}}}else if(r instanceof THREE.RenderableFace4){l=r.v1;o=r.v2;q=r.v3;s=r.v4;l.positionScreen.x*=n;l.positionScreen.y*=-m;o.positionScreen.x*=n;o.positionScreen.y*=-m;q.positionScreen.x*=n;q.positionScreen.y*=-m;s.positionScreen.x*=n;s.positionScreen.y*=-m;j.addPoint(l.positionScreen.x,l.positionScreen.y);j.addPoint(o.positionScreen.x,o.positionScreen.y);j.addPoint(q.positionScreen.x,q.positionScreen.y);j.addPoint(s.positionScreen.x,s.positionScreen.y);if(t.instersects(j)){B=
0;for(w=r.meshMaterials.length;B<w;){G=r.meshMaterials[B++];if(G instanceof THREE.MeshFaceMaterial){M=0;for(P=r.faceMaterials.length;M<P;)(G=r.faceMaterials[M++])&&c(l,o,q,s,r,G,F)}else G&&c(l,o,q,s,r,G,F)}}}}}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(undefined,!1,b);c=a.sounds;var d,e=c.length;for(d=0;d<e;d++){a=c[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
