three.js
========

#### Javascript 3D Engine ####

The aim of this project is to create a lightweight 3D engine with a very low level of abstraction — in other words, for dummies. The engine can render using &lt;canvas&gt;, &lt;svg&gt; and WebGL.

[API Reference](https://github.com/mrdoob/three.js/wiki/r34-API-Reference) — be aware that the API may change from revision to revision breaking backwards compatibility.

More? [#three.js on irc.freenode.net](http://webchat.freenode.net/?channels=three.js)

### Examples ###


#### WebGL (Context 3D) ####

[![video](http://mrdoob.github.com/three.js/assets/examples/40_video.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_video.html)
[![dof](http://mrdoob.github.com/three.js/assets/examples/39_dof.png)](http://mrdoob.github.com/three.js/examples/webgl_postprocessing_dof.html)
[![ribbon](http://mrdoob.github.com/three.js/assets/examples/38_ribbon.png)](http://mrdoob.github.com/three.js/examples/webgl_ribbons.html)
[![vertexcolors](http://mrdoob.github.com/three.js/assets/examples/37_vertexcolors.png)](http://mrdoob.github.com/three.js/examples/webgl_geometry_colors.html)
[![particles](http://mrdoob.github.com/three.js/assets/examples/36_particles.png)](http://mrdoob.github.com/three.js/examples/webgl_particles_billboards_colors.html)
[![lines](http://mrdoob.github.com/three.js/assets/examples/35_lines.png)](http://mrdoob.github.com/three.js/examples/webgl_lines_colors.html)
[![shader](http://mrdoob.github.com/three.js/assets/examples/34_shader.png)](http://mrdoob.github.com/three.js/examples/webgl_shader.html)
[![materials_normalmap2](http://mrdoob.github.com/three.js/assets/examples/33_materials_normalmap2.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_normalmap2.html)
[![materials_grass](http://mrdoob.github.com/three.js/assets/examples/32_materials_grass.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_grass.html)
[![materials_normalmap](http://mrdoob.github.com/three.js/assets/examples/31_materials_normalmap.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_normalmap.html)
[![geometry_terrain_gl](http://mrdoob.github.com/three.js/assets/examples/30_geometry_terrain_gl.png)](http://mrdoob.github.com/three.js/examples/webgl_geometry_terrain.html)
[![geometry_minecraft](http://mrdoob.github.com/three.js/assets/examples/29_geometry_minecraft.png)](http://mrdoob.github.com/three.js/examples/webgl_geometry_minecraft_ao.html)
[![materials_shader_fresnel](http://mrdoob.github.com/three.js/assets/examples/28_materials_shaders_fresnel.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_shaders_fresnel.html)
[![materials_cars](http://mrdoob.github.com/three.js/assets/examples/25_materials_cars.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cars.html)
[![materials_cubemap_refraction](http://mrdoob.github.com/three.js/assets/examples/18_materials_cubemap_refraction.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cubemap_refraction.html)
[![materials_cubemap_balls_reflection](http://mrdoob.github.com/three.js/assets/examples/15_materials_cubemap_balls_reflection.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cubemap_balls_reflection.html)
[![materials_cubemap_balls_refraction](http://mrdoob.github.com/three.js/assets/examples/16_materials_cubemap_balls_refraction.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cubemap_balls_refraction.html)
[![materials_cubemap_escher](http://mrdoob.github.com/three.js/assets/examples/17_materials_cubemap_escher.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cubemap_escher.html)
[![materials_cubemap](http://mrdoob.github.com/three.js/assets/examples/14_materials_cubemap.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_cubemap.html)
[![materials_gl](http://mrdoob.github.com/three.js/assets/examples/20_materials_gl.png)](http://mrdoob.github.com/three.js/examples/webgl_materials.html)
[![materials_shaders](http://mrdoob.github.com/three.js/assets/examples/23_materials_shaders.png)](http://mrdoob.github.com/three.js/examples/webgl_materials_shaders.html)
[![large_mesh](http://mrdoob.github.com/three.js/assets/examples/12_large_mesh.png)](http://mrdoob.github.com/three.js/examples/webgl_geometry_large_mesh.html)


#### Canvas (Context 2D) ####

[![materials_reflection](http://mrdoob.github.com/three.js/assets/examples/27_materials_reflection.png)](http://mrdoob.github.com/three.js/examples/canvas_materials_reflection.html)
[![materials](http://mrdoob.github.com/three.js/assets/examples/13_materials.png)](http://mrdoob.github.com/three.js/examples/canvas_materials.html)
[![materials_depth](http://mrdoob.github.com/three.js/assets/examples/19_materials_depth.png)](http://mrdoob.github.com/three.js/examples/canvas_materials_depth.html)
[![materials_normal](http://mrdoob.github.com/three.js/assets/examples/22_materials_normal.png)](http://mrdoob.github.com/three.js/examples/canvas_materials_normal.html)
[![lights_pointlights](http://mrdoob.github.com/three.js/assets/examples/09_walthead.png)](http://mrdoob.github.com/three.js/examples/canvas_lights_pointlights.html)
[![interactive_cubes](http://mrdoob.github.com/three.js/assets/examples/11_interactive.png)](http://mrdoob.github.com/three.js/examples/canvas_interactive_cubes.html)
[![camera_ortographic](http://mrdoob.github.com/three.js/assets/examples/10_orthographic.png)](http://mrdoob.github.com/three.js/examples/canvas_camera_orthographic.html)
[![geometry_birds](http://mrdoob.github.com/three.js/assets/examples/08_birds.png)](http://mrdoob.github.com/three.js/examples/canvas_geometry_birds.html)
[![geometry_earth](http://mrdoob.github.com/three.js/assets/examples/07_earth.png)](http://mrdoob.github.com/three.js/examples/canvas_geometry_earth.html)
[![geometry_terrain](http://mrdoob.github.com/three.js/assets/examples/06_terrain.png)](http://mrdoob.github.com/three.js/examples/canvas_geometry_terrain.html)
[![materials_video](http://mrdoob.github.com/three.js/assets/examples/24_materials_video.png)](http://mrdoob.github.com/three.js/examples/canvas_materials_video.html)
[![geometry_panorama](http://mrdoob.github.com/three.js/assets/examples/04_vr.png)](http://mrdoob.github.com/three.js/examples/canvas_geometry_panorama.html)
[![geometry_cube](http://mrdoob.github.com/three.js/assets/examples/03_cube.png)](http://mrdoob.github.com/three.js/examples/canvas_geometry_cube.html)
[![particles_sprites](http://mrdoob.github.com/three.js/assets/examples/26_particles_sprites.png)](http://mrdoob.github.com/three.js/examples/canvas_particles_sprites.html)
[![particles_random](http://mrdoob.github.com/three.js/assets/examples/02_random.png)](http://mrdoob.github.com/three.js/examples/canvas_particles_random.html)
[![particles_wave](http://mrdoob.github.com/three.js/assets/examples/01_waves.png)](http://mrdoob.github.com/three.js/examples/canvas_particles_waves.html)
[![particles_floor](http://mrdoob.github.com/three.js/assets/examples/00_floor.png)](http://mrdoob.github.com/three.js/examples/canvas_particles_floor.html)


### Featured projects ###

[![FastKat](http://mrdoob.github.com/three.js/assets/projects/12_fastkat.png)](http://www.omiod.com/games/fastkat.php)
[![Sculpt](http://mrdoob.github.com/three.js/assets/projects/11_sculpt.png)](http://antimatter15.com/wp/2010/11/digital-sculpting-with-three-js/)
[![Voxels](http://mrdoob.github.com/three.js/assets/projects/10_voxels.png)](http://mrdoob.com/projects/voxels/)
[![The Wilderness Downtown](http://mrdoob.github.com/three.js/assets/projects/09_arcadefire.png)](http://thewildernessdowntown.com/)
[![CloudSCAD](http://mrdoob.github.com/three.js/assets/projects/08_cloudscad.png)](http://cloudscad.com/stl_viewer/)
[![Or so they say...](http://mrdoob.github.com/three.js/assets/projects/07_orsotheysay.png)](http://xplsv.com/prods/demos/xplsv_orsotheysay/)
[![Rat](http://mrdoob.github.com/three.js/assets/projects/06_rat.png)](http://tech.lab212.org/2010/07/export-textured-models-from-blender2-5-to-three-js/)
[![Failure](http://mrdoob.github.com/three.js/assets/projects/05_failure.png)](http://www.is-real.net/experiments/three/failure/)
[![Space Cannon 3D](http://mrdoob.github.com/three.js/assets/projects/02_spacecannon.png)](http://labs.brian-stoner.com/spacecannon/)
[![Alocasia](http://mrdoob.github.com/three.js/assets/projects/04_alocasia.png)](http://arithmetric.com/projects/alocasia/)
[![DDD](http://mrdoob.github.com/three.js/assets/projects/01_ddd.png)](http://the389.com/works/three/)
[![jsflowfield4d](http://mrdoob.github.com/three.js/assets/projects/00_jsflowfield4d.png)](http://test.sjeiti.com/jsflowfield4d/)
[![spikeball](http://mrdoob.github.com/three.js/assets/projects/03_spikeball.png)](http://kile.stravaganza.org/lab/js/spikeball/)

### Usage ###

Download the [minified library](http://mrdoob.github.com/three.js/build/Three.js) and include it in your html.

	<script src="js/Three.js"></script>

This code creates a camera, then creates a scene object, adds a bunch of random particles in it, creates a &lt;canvas&gt; renderer and adds its viewport in the document.body element.

	<script>

		var camera, scene, renderer;

		init();
		animate();

		function init() {

			camera = new THREE.Camera( 75, window.innerWidth / window.innerHeight, 1, 10000 );
			camera.position.z = 1000;

			scene = new THREE.Scene();

			for ( var i = 0; i < 1000; i ++ ) {

				var particle = new THREE.Particle( new THREE.ParticleCircleMaterial( { color: Math.random() * 0xffffff } ) );
				particle.position.x = Math.random() * 2000 - 1000;
				particle.position.y = Math.random() * 2000 - 1000;
				particle.position.z = Math.random() * 2000 - 1000;
				particle.scale.x = particle.scale.y = Math.random() * 10 + 5;
				scene.addObject( particle );

			}

			renderer = new THREE.CanvasRenderer();
			renderer.setSize( window.innerWidth, window.innerHeight );

			document.body.appendChild( renderer.domElement );

		}

		function animate() {

			// Include examples/js/RequestAnimationFrame.js for cross-browser compatibility.
			requestAnimationFrame( animate );
			render();

		}

		function render() {

			renderer.render( scene, camera );

		}

	</script>


### Change Log ###

2011 03 02 - **r34** (186.045 KB, gzip: 45.953 KB)

* Now using camera.matrixWorldInverse instead of camera.matrixWorld for projecting. ([empaempa](http://github.com/empaempa) and [mrdoob](http://github.com/mrdoob))
* Camel cased properties and object json format (**Re-exporting of models required**) ([alteredq](http://github.com/alteredq))
* Added `QuakeCamera` for easy fly-bys ([alteredq](http://github.com/alteredq))
* Added `LOD` example ([alteredq](http://github.com/alteredq))


2011 02 26 - **r33** (184.483 KB, gzip: 45.580 KB)

* Changed build setup (**build/Three.js now also include extras**) ([mrdoob](http://github.com/mrdoob))
* Added `ParticleSystem` object to `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* Added `Line` support to `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* Added vertex colors support to `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* Added `Ribbon` object. ([alteredq](http://github.com/alteredq))
* Added updateable textures support to `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* Added `Sound` object and `SoundRenderer`. ([empaempa](http://github.com/empaempa))
* `LOD`, `Bone`, `SkinnedMesh` objects and hierarchy being developed. ([empaempa](http://github.com/empaempa))
* Added hierarchies examples ([mrdoob](http://github.com/mrdoob))


2010 12 31 - **r32** (89.301 KB, gzip: 21.351 KB)

* `Scene` now supports `Fog` and `FogExp2`. `WebGLRenderer` only right now. ([alteredq](http://github.com/alteredq))
* Added `setClearColor( hex, opacity )` to `WebGLRenderer` and `CanvasRenderer` ([alteredq](http://github.com/alteredq) & [mrdoob](http://github.com/mrdoob))
* `WebGLRenderer` shader system refactored improving performance. ([alteredq](http://github.com/alteredq))
* `Projector` now does frustum culling of all the objects using their sphereBoundingBox. (thx [errynp](https://github.com/errynp))
* `material` property changed to `materials` globaly.


2010 12 06 - **r31** (79.479 KB, gzip: 18.788 KB)

* Minor Materials API change (mappings). ([alteredq](http://github.com/alteredq) & [mrdoob](http://github.com/mrdoob))
* Added Filters to `WebGLRenderer`
* `python build.py --includes` generates includes string


2010 11 30 - **r30** (77.809 KB, gzip: 18.336 KB)

* Reflection and Refraction materials support in `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* `SmoothShading` support on `CanvasRenderer`/`MeshLambertMaterial`
* `MeshShaderMaterial` for `WebGLRenderer` ([alteredq](http://github.com/alteredq))
* Removed `RenderableFace4` from `Projector`/`CanvasRenderer` (maybe just temporary).
* Added extras folder with `GeometryUtils`, `ImageUtils`, `SceneUtils` and `ShaderUtils` ([alteredq](http://github.com/alteredq) & [mrdoob](http://github.com/mrdoob))
* Blender 2.5x Slim now the default exporter (old exporter removed).


2010 11 17 - **r29** (69.563 KB)

* **New materials API** Still work in progress, but mostly there. ([alteredq](http://github.com/alteredq) & [mrdoob](http://github.com/mrdoob))
* Line clipping in `CanvasRenderer` ([julianwa](http://github.com/julianwa))
* Refactored `CanvasRenderer` and `SVGRenderer`. ([mrdoob](http://github.com/mrdoob))
* Switched to Closure compiler.


2010 11 04 - **r28** (62.802 KB)

* `Loader` class allows load geometry asynchronously at runtime. ([alteredq](http://github.com/alteredq))
* `MeshPhongMaterial` working with `WebGLRenderer`. ([alteredq](http://github.com/alteredq))
* Support for *huge* objects. Max 500k polys and counting. ([alteredq](http://github.com/alteredq))
* `Projector.unprojectVector` and `Ray` class to check intersections with faces (based on [mindlapse](https://github.com/mindlapse) work)
* Fixed `Projector` z-sorting (not as jumpy anymore).
* Fixed Orthographic projection (was y-inverted).
* Hmmm.. lib file size starting to get too big...


2010 10 28 - **r25** (54.480 KB)

* `WebGLRenderer` now up to date with other renderers! ([alteredq](http://github.com/alteredq))
* .obj to .js python converter ([alteredq](http://github.com/alteredq))
* Blender 2.54 exporter
* Added `MeshFaceMaterial` (multipass per face)
* Reworked `CanvasRenderer` and `SVGRenderer` material handling


2010 10 06 - **r18** (44.420 KB)

* Added `PointLight`
* `CanvasRenderer` and `SVGRenderer` basic lighting support (ColorStroke/ColorFill only)
* `Renderer` > `Projector`. `CanvasRenderer`, `SVGRenderer` and `DOMRenderer` do not extend anymore
* Added `computeCentroids` method to `Geometry`


2010 09 17 - **r17** (39.487 KB)

* Added `Light`, `AmbientLight` and `DirectionalLight` ([philogb](http://github.com/philogb))
* `WebGLRenderer` basic lighting support ([philogb](http://github.com/philogb))
* Memory optimisations


2010 08 21 - **r16** (35.592 KB)

* Workaround for Opera bug (clearRect not working with context with negative scale)
* Additional `Matrix4` and `Vector3` methods


2010 07 23 - **r15** (32.440 KB)

* Using new object `UV` instead of `Vector2` where it should be used
* Added `Mesh.flipSided` boolean (false by default)
* `CanvasRenderer` was handling UVs at 1,1 as bitmapWidth, bitmapHeight (instead of bitmapWidth - 1, bitmapHeight - 1)
* `ParticleBitmapMaterial.offset` added
* Fixed gap when rendering `Face4` with `MeshBitmapUVMappingMaterial`


2010 07 17 - **r14** (32.144 KB)

* Refactored `CanvasRenderer` (more duplicated code, but easier to handle)
* `Face4` now supports `MeshBitmapUVMappingMaterial`
* Changed order of `*StrokeMaterial` parameters. Now it's `color`, `opacity`, `lineWidth`.
* `BitmapUVMappingMaterial` > `MeshBitmapUVMappingMaterial`
* `ColorFillMaterial` > `MeshColorFillMaterial`
* `ColorStrokeMaterial` > `MeshColorStrokeMaterial`
* `FaceColorFillMaterial` > `MeshFaceColorFillMaterial`
* `FaceColorStrokeMaterial` > `MeshFaceColorStrokeMaterial`
* `ColorStrokeMaterial` > `LineColorMaterial`
* `Rectangle.instersects` returned false with rectangles with 0px witdh or height


2010 07 12 - **r13** (29.492 KB)

* Added `ParticleCircleMaterial` and `ParticleBitmapMaterial`
* `Particle` now use `ParticleCircleMaterial` instead of `ColorFillMaterial`
* `Particle.size` > `Particle.scale.x` and `Particle.scale.y`
* `Particle.rotation.z` for rotating the particle
* `SVGRenderer` currently out of sync


2010 07 07 - **r12** (28.494 KB)

* First version of the `WebGLRenderer` (`ColorFillMaterial` and `FaceColorFillMaterial` by now)
* `Matrix4.lookAt` fix (`CanvasRenderer` and `SVGRenderer` now handle the -Y)
* `Color` now using 0-1 floats instead of 0-255 integers


2010 07 03 - **r11** (23.541 KB)

* Blender 2.5 exporter (utils/export_threejs.py) now exports UV and normals (Thx [kikko](http://github.com/kikko))
* `Scene.add` > `Scene.addObject`
* Enabled `Scene.removeObject`


2010 06 22 - **r10** (23.959 KB)

* Changed Camera system. (Thx [Paul Brunt](http://github.com/supereggbert))
* `Object3D.overdraw = true` to enable CanvasRenderer screen space point expansion hack.


2010 06 20 - **r9** (23.753 KB)

* JSLinted.
* `autoClear` property for renderers.
* Removed SVG rgba() workaround for WebKit. (WebKit now supports it)
* Fixed matrix bug. (transformed objects outside the x axis would get infinitely tall :S)


2010 06 06 - **r8** (23.496 KB)

* Moved UVs to `Geometry`.
* `CanvasRenderer` expands screen space points (workaround for antialias gaps).
* `CanvasRenderer` supports `BitmapUVMappingMaterial`.


2010 06 05 - **r7** (22.387 KB)

* Added Line Object.
* Workaround for WebKit not supporting rgba() in SVG yet.
* No need to call updateMatrix(). Use .autoUpdateMatrix = false if needed. (Thx [Gregory Athons](http://github.com/gregmax17)).


2010 05 17 - **r6** (21.003 KB)

* 2d clipping on `CanvasRenderer` and `SVGRenderer`
* `clearRect` optimisations on `CanvasRenderer`


2010 05 16 - **r5** (19.026 KB)

* Removed Class.js dependency
* Added `THREE` namespace
* `Camera.x` -> `Camera.position.x`
* `Camera.target.x` > `Camera.target.position.x`
* `ColorMaterial` > `ColorFillMaterial`
* `FaceColorMaterial` > `FaceColorFillMaterial`
* Materials are now multipass (use array)
* Added `ColorStrokeMaterial` and `FaceColorStrokeMaterial`
* `geometry.faces.a` are now indexes instead of references


2010 04 26 - **r4** (16.274 KB)

* `SVGRenderer` Particle rendering
* `CanvasRenderer` uses `context.setTransform` to avoid extra calculations


2010 04 24 - **r3** (16.392 KB)

* Fixed incorrect rotation matrix transforms
* Added `Plane` and `Cube` primitives


2010 04 24 - **r2** (15.724 KB)

* Improved `Color` handling


2010 04 24 - **r1** (15.25 KB)

* First alpha release
