// ThreeCanvas.js r47 - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"RequestCancelAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),f=Math.max(0,16-(c-a)),g=window.setTimeout(function(){b(c+f)},f);a=c+f;return g};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),f=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x===this.x&&a.y===this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);
this.y=Math.asin(a.n13);1.0E-5<Math.abs(b)?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){j.sub(c,a);q=j.dot(b);x=p.add(a,k.copy(b).multiplyScalar(q));return v=c.distanceTo(x)}function d(a,b,c,d){j.sub(d,b);p.sub(c,b);k.sub(a,b);I=j.dot(j);G=j.dot(p);w=j.dot(k);H=p.dot(p);A=p.dot(k);F=1/(I*H-G*G);r=(H*w-G*A)*F;s=(I*A-G*w)*F;return 0<=r&&0<=s&&1>r+s}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectScene=function(a){return this.intersectObjects(a.children)};this.intersectObjects=function(a){var b,c,d=[];for(b=0,
c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d};var e=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,i=new THREE.Vector3,m=new THREE.Vector3,h=new THREE.Vector3,l=new THREE.Vector3,o=new THREE.Vector3,n=new THREE.Vector3;this.intersectObject=function(a){for(var b,k=[],j=0,p=a.children.length;j<p;j++)Array.prototype.push.apply(k,this.intersectObject(a.children[j]));if(a instanceof THREE.Particle){j=
c(this.origin,this.direction,a.matrixWorld.getPosition());if(j>a.scale.x)return[];b={distance:j,point:a.position,face:null,object:a};k.push(b)}else if(a instanceof THREE.Mesh){j=c(this.origin,this.direction,a.matrixWorld.getPosition());p=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(j>a.geometry.boundingSphere.radius*Math.max(p.x,Math.max(p.y,p.z)))return k;var q,r,s=a.geometry,E=s.vertices,t;a.matrixRotationWorld.extractRotation(a.matrixWorld);
for(j=0,p=s.faces.length;j<p;j++)if(b=s.faces[j],m.copy(this.origin),h.copy(this.direction),t=a.matrixWorld,l=t.multiplyVector3(l.copy(b.centroid)).subSelf(m),o=a.matrixRotationWorld.multiplyVector3(o.copy(b.normal)),q=h.dot(o),!(1.0E-4>Math.abs(q))&&(r=o.dot(l)/q,!(0>r)&&(a.doubleSided||(a.flipSided?0<q:0>q))))if(n.add(m,h.multiplyScalar(r)),b instanceof THREE.Face3)e=t.multiplyVector3(e.copy(E[b.a].position)),f=t.multiplyVector3(f.copy(E[b.b].position)),g=t.multiplyVector3(g.copy(E[b.c].position)),
d(n,e,f,g)&&(b={distance:m.distanceTo(n),point:n.clone(),face:b,object:a},k.push(b));else if(b instanceof THREE.Face4&&(e=t.multiplyVector3(e.copy(E[b.a].position)),f=t.multiplyVector3(f.copy(E[b.b].position)),g=t.multiplyVector3(g.copy(E[b.c].position)),i=t.multiplyVector3(i.copy(E[b.d].position)),d(n,e,f,i)||d(n,f,g,i)))b={distance:m.distanceTo(n),point:n.clone(),face:b,object:a},k.push(b)}return k};var j=new THREE.Vector3,p=new THREE.Vector3,k=new THREE.Vector3,q,x,v,I,G,w,H,A,F,r,s};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,l,o){i=!1;b=f;c=g;d=l;e=o;a()};this.addPoint=function(f,g){i?(i=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,l,o,n,j){i?(i=!1,b=f<l?f<n?f:n:l<n?l:n,c=g<o?g<j?g:j:o<j?o:j,d=f>l?f>n?f:n:l>n?l:n,e=g>o?g>j?g:j:o>j?o:j):(b=f<l?f<n?f<b?f:b:n<b?n:b:l<n?l<b?l:b:n<b?n:b,c=g<o?g<j?g<c?g:c:j<c?j:c:o<j?o<c?o:c:j<c?j:c,d=f>l?f>n?f>d?f:d:n>d?n:d:l>n?l>d?l:d:n>d?n:d,e=g>o?g>j?g>e?g:e:j>e?j:e:o>j?o>e?o:e:j>e?j:e);a()};this.addRectangle=function(f){i?(i=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){i=!0;e=d=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,f,g,i,m,h,l,o,n,j,p,k){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==f?f:1,g||0,i||0,m||0,h||0,void 0!==l?l:1,o||0,n||0,j||0,p||0,void 0!==k?k:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,i,m,h,l,o,n,j,p,k){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=g;this.n24=i;this.n31=m;this.n32=h;this.n33=l;this.n34=o;this.n41=n;this.n42=j;this.n43=p;this.n44=k;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;f.sub(a,b).normalize();if(0===f.length())f.z=1;d.cross(c,f).normalize();0===d.length()&&(f.x+=1.0E-4,d.cross(c,f).normalize());e.cross(f,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,i=a.n22,m=a.n23,h=a.n24,l=a.n31,o=a.n32,n=a.n33,j=a.n34,p=a.n41,k=a.n42,q=a.n43,
x=a.n44,v=b.n11,I=b.n12,G=b.n13,w=b.n14,H=b.n21,A=b.n22,F=b.n23,r=b.n24,s=b.n31,D=b.n32,J=b.n33,Z=b.n34,ca=b.n41,N=b.n42,P=b.n43,S=b.n44;this.n11=c*v+d*H+e*s+f*ca;this.n12=c*I+d*A+e*D+f*N;this.n13=c*G+d*F+e*J+f*P;this.n14=c*w+d*r+e*Z+f*S;this.n21=g*v+i*H+m*s+h*ca;this.n22=g*I+i*A+m*D+h*N;this.n23=g*G+i*F+m*J+h*P;this.n24=g*w+i*r+m*Z+h*S;this.n31=l*v+o*H+n*s+j*ca;this.n32=l*I+o*A+n*D+j*N;this.n33=l*G+o*F+n*J+j*P;this.n34=l*w+o*r+n*Z+j*S;this.n41=p*v+k*H+q*s+x*ca;this.n42=p*I+k*A+q*D+x*N;this.n43=p*
G+k*F+q*J+x*P;this.n44=p*w+k*r+q*Z+x*S;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=
a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*
c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*
a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,g=this.n23,i=this.n24,m=this.n31,h=this.n32,l=this.n33,o=this.n34,n=this.n41,j=this.n42,p=this.n43,k=this.n44;return d*g*h*n-c*i*h*n-d*f*l*n+b*i*l*n+c*f*o*n-b*g*o*n-d*g*m*j+c*i*m*j+d*e*l*j-a*i*l*j-c*e*o*j+a*g*o*j+d*f*m*p-b*i*m*p-d*e*h*p+a*i*h*p+b*e*o*p-a*f*o*p-c*f*m*k+b*g*m*k+c*e*h*k-a*g*h*k-b*e*l*k+a*f*l*k},transpose:function(){var a;
a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;
a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;
a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},
setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},
setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,i=a.z,m=e*f,h=e*g;this.set(m*f+c,m*g-d*i,m*i+d*g,0,m*g+d*i,h*g+c,h*i-d*f,0,m*i-d*g,h*i+d*f,e*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,
this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,f=a.n21,g=a.n22,i=a.n23,m=a.n24,h=a.n31,l=a.n32,o=a.n33,n=a.n34,j=a.n41,p=a.n42,k=a.n43,q=a.n44;this.n11=i*n*p-m*o*p+m*l*k-g*n*k-i*l*q+g*o*q;this.n12=e*o*p-d*n*p-e*l*k+c*n*k+d*l*q-c*o*q;this.n13=d*m*p-e*i*p+e*g*k-c*m*k-d*g*q+c*i*q;this.n14=e*i*l-d*m*l-e*g*o+c*m*o+d*g*n-c*i*n;this.n21=m*o*j-i*n*j-m*h*k+f*n*k+i*h*q-f*o*q;this.n22=d*n*j-e*o*j+
e*h*k-b*n*k-d*h*q+b*o*q;this.n23=e*i*j-d*m*j-e*f*k+b*m*k+d*f*q-b*i*q;this.n24=d*m*h-e*i*h+e*f*o-b*m*o-d*f*n+b*i*n;this.n31=g*n*j-m*l*j+m*h*p-f*n*p-g*h*q+f*l*q;this.n32=e*l*j-c*n*j-e*h*p+b*n*p+c*h*q-b*l*q;this.n33=c*m*j-e*g*j+e*f*p-b*m*p-c*f*q+b*g*q;this.n34=e*g*h-c*m*h-e*f*l+b*m*l+c*f*n-b*g*n;this.n41=i*l*j-g*o*j-i*h*p+f*o*p+g*h*k-f*l*k;this.n42=c*o*j-d*l*j+d*h*p-b*o*p-c*h*k+b*l*k;this.n43=d*g*j-c*i*j-d*f*p+b*i*p+c*f*k-b*g*k;this.n44=c*i*h-d*g*h+d*f*l-b*i*l-c*f*o+b*g*o;this.multiplyScalar(1/a.determinant());
return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),i=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var m=g*i,h=g*e,l=d*i,o=d*e;this.n11=m+o*c;this.n12=l*c-h;this.n13=f*d;this.n21=f*e;this.n22=f*i;this.n23=-c;this.n31=h*c-l;this.n32=o+m*c;this.n33=f*g;break;case "ZXY":m=g*i;h=g*e;l=d*i;o=d*e;this.n11=m-o*c;this.n12=-f*e;this.n13=l+h*c;this.n21=h+l*c;this.n22=f*i;this.n23=o-m*c;this.n31=-f*d;this.n32=c;this.n33=f*g;break;case "ZYX":m=
f*i;h=f*e;l=c*i;o=c*e;this.n11=g*i;this.n12=l*d-h;this.n13=m*d+o;this.n21=g*e;this.n22=o*d+m;this.n23=h*d-l;this.n31=-d;this.n32=c*g;this.n33=f*g;break;case "YZX":m=f*g;h=f*d;l=c*g;o=c*d;this.n11=g*i;this.n12=o-m*e;this.n13=l*e+h;this.n21=e;this.n22=f*i;this.n23=-c*i;this.n31=-d*i;this.n32=h*e+l;this.n33=m-o*e;break;case "XZY":m=f*g;h=f*d;l=c*g;o=c*d;this.n11=g*i;this.n12=-e;this.n13=d*i;this.n21=m*e+o;this.n22=f*i;this.n23=h*e-l;this.n31=l*e-h;this.n32=c*i;this.n33=o*e+m;break;default:m=f*i,h=f*
e,l=c*i,o=c*e,this.n11=g*i,this.n12=-g*e,this.n13=d,this.n21=h+l*d,this.n22=m-o*d,this.n23=-c*g,this.n31=o-m*d,this.n32=l+h*d,this.n33=f*g}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,g=c+c,i=d+d,a=b*f,m=b*g,b=b*i,h=c*g,c=c*i,d=d*i,f=e*f,g=e*g,e=e*i;this.n11=1-(h+d);this.n12=m-e;this.n13=b+g;this.n21=m+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-g;this.n32=c+f;this.n33=1-(a+h);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=
a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);f.set(this.n13,
this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=f.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;
return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===
a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,f=Math.sqrt(c*c+d*d+e*e),c=c/f,d=d/f,e=e/f,f=c*c,g=d*d,i=e*e,m=Math.cos(b),h=Math.sin(b),l=1-m,o=c*d*l,n=c*e*l,l=d*e*l,c=c*h,j=d*h,h=e*h,e=f+(1-f)*m,f=o+h,d=n-j,o=o-h,g=g+(1-g)*m,h=l+c,n=n+j,l=l-c,i=i+(1-i)*m,m=this.n11,c=this.n21,j=this.n31,p=this.n41,k=this.n12,q=this.n22,x=this.n32,v=this.n42,I=this.n13,G=this.n23,w=this.n33,H=this.n43;this.n11=e*m+f*k+d*I;this.n21=e*c+f*q+d*G;this.n31=e*j+f*x+d*w;this.n41=e*p+f*v+d*H;this.n12=o*m+g*k+h*I;this.n22=
o*c+g*q+h*G;this.n32=o*j+g*x+h*w;this.n42=o*p+g*v+h*H;this.n13=n*m+l*k+i*I;this.n23=n*c+l*q+i*G;this.n33=n*j+l*x+i*w;this.n43=n*p+l*v+i*H;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,f=this.n13,g=this.n23,i=this.n33,m=this.n43,h=Math.cos(a),a=Math.sin(a);this.n12=h*b+a*f;this.n22=h*c+a*g;this.n32=h*d+a*i;this.n42=h*e+a*m;this.n13=h*f-a*b;this.n23=h*g-a*c;this.n33=h*i-a*d;this.n43=h*m-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,
f=this.n13,g=this.n23,i=this.n33,m=this.n43,h=Math.cos(a),a=Math.sin(a);this.n11=h*b-a*f;this.n21=h*c-a*g;this.n31=h*d-a*i;this.n41=h*e-a*m;this.n13=h*f+a*b;this.n23=h*g+a*c;this.n33=h*i+a*d;this.n43=h*m+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n12,g=this.n22,i=this.n32,m=this.n42,h=Math.cos(a),a=Math.sin(a);this.n11=h*b+a*f;this.n21=h*c+a*g;this.n31=h*d+a*i;this.n41=h*e+a*m;this.n12=h*f-a*b;this.n22=h*g-a*c;this.n32=h*i-a*d;this.n42=h*m-a*e;return this},
translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,m=-a.n32*a.n11+a.n31*a.n12,h=a.n23*a.n12-a.n22*a.n13,l=-a.n23*a.n11+a.n21*a.n13,o=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*g+a.n31*h;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*g;c[4]=a*i;c[5]=a*m;c[6]=a*h;c[7]=a*l;c[8]=a*o;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var g;g=new THREE.Matrix4;g.n11=2*e/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*e/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(f+e)/(f-e);g.n34=-2*f*e/(f-e);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var g,i,m,h;g=new THREE.Matrix4;i=b-a;m=c-d;h=f-e;g.n11=2/i;g.n12=0;g.n13=0;g.n14=-((b+a)/i);g.n21=0;g.n22=2/m;g.n23=0;g.n24=-((c+d)/m);g.n31=0;g.n32=0;g.n33=-2/h;g.n34=-((f+e)/h);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.name="";this.id=THREE.Object3DCount++;this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(-1===
this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.addObject(a)}},remove:function(a){var b=this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===
a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=g[f]=g[f]||new THREE.RenderableObject;f++;return a}function b(){var a=h[m]=h[m]||new THREE.RenderableVertex;m++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,i=-b.z+b.w;if(0<=e&&0<=f&&0<=g&&0<=i)return!0;if(0>e&&0>f||0>g&&0>i)return!1;0>e?c=Math.max(c,e/(e-f)):0>f&&(d=Math.min(d,e/(e-f)));0>g?c=Math.max(c,g/(g-i)):0>i&&(d=Math.min(d,g/(g-i)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,f,g=[],i,m,h=[],l,o,n=[],j,p=[],k,q,x=[],v,I,G=[],w={objects:[],sprites:[],lights:[],elements:[]},H=new THREE.Vector3,A=new THREE.Vector4,F=new THREE.Matrix4,r=new THREE.Matrix4,s=new THREE.Frustum,D=new THREE.Vector4,J=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);F.multiply(b.projectionMatrix,b.matrixWorldInverse);F.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);F.multiply(b.matrixWorld,
b.projectionMatrixInverse);F.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;w.objects.length=0;w.sprites.length=0;w.lights.length=0;var g=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||s.contains(b))?(F.multiplyVector3(H.copy(b.position)),e=a(),e.object=
b,e.z=H.z,w.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(F.multiplyVector3(H.copy(b.position)),e=a(),e.object=b,e.z=H.z,w.sprites.push(e)):b instanceof THREE.Light&&w.lights.push(b);for(var c=0,d=b.children.length;c<d;c++)g(b.children[c])}};g(b);d&&w.objects.sort(c);return w};this.projectScene=function(a,e,f){var g=e.near,H=e.far,T,E,t,Q,y,O,M,V,K,u,C,z,B,L,ka,ea;I=q=j=o=0;w.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);F.multiply(e.projectionMatrix,e.matrixWorldInverse);s.setFromMatrix(F);w=this.projectGraph(a,!1);for(a=0,T=w.objects.length;a<T;a++)if(K=w.objects[a].object,u=K.matrixWorld,z=K.material,m=0,K instanceof THREE.Mesh){C=K.geometry;B=K.geometry.materials;Q=C.vertices;L=C.faces;ka=C.faceVertexUvs;C=K.matrixRotationWorld.extractRotation(u);for(E=0,t=Q.length;E<t;E++)i=b(),i.positionWorld.copy(Q[E].position),u.multiplyVector3(i.positionWorld),
i.positionScreen.copy(i.positionWorld),F.multiplyVector4(i.positionScreen),i.positionScreen.x/=i.positionScreen.w,i.positionScreen.y/=i.positionScreen.w,i.visible=i.positionScreen.z>g&&i.positionScreen.z<H;for(Q=0,E=L.length;Q<E;Q++){t=L[Q];if(t instanceof THREE.Face3)if(y=h[t.a],O=h[t.b],M=h[t.c],y.visible&&O.visible&&M.visible&&(K.doubleSided||K.flipSided!=0>(M.positionScreen.x-y.positionScreen.x)*(O.positionScreen.y-y.positionScreen.y)-(M.positionScreen.y-y.positionScreen.y)*(O.positionScreen.x-
y.positionScreen.x)))V=n[o]=n[o]||new THREE.RenderableFace3,o++,l=V,l.v1.copy(y),l.v2.copy(O),l.v3.copy(M);else continue;else if(t instanceof THREE.Face4)if(y=h[t.a],O=h[t.b],M=h[t.c],V=h[t.d],y.visible&&O.visible&&M.visible&&V.visible&&(K.doubleSided||K.flipSided!=(0>(V.positionScreen.x-y.positionScreen.x)*(O.positionScreen.y-y.positionScreen.y)-(V.positionScreen.y-y.positionScreen.y)*(O.positionScreen.x-y.positionScreen.x)||0>(O.positionScreen.x-M.positionScreen.x)*(V.positionScreen.y-M.positionScreen.y)-
(O.positionScreen.y-M.positionScreen.y)*(V.positionScreen.x-M.positionScreen.x))))ea=p[j]=p[j]||new THREE.RenderableFace4,j++,l=ea,l.v1.copy(y),l.v2.copy(O),l.v3.copy(M),l.v4.copy(V);else continue;l.normalWorld.copy(t.normal);C.multiplyVector3(l.normalWorld);l.centroidWorld.copy(t.centroid);u.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);F.multiplyVector3(l.centroidScreen);M=t.vertexNormals;for(y=0,O=M.length;y<O;y++)V=l.vertexNormalsWorld[y],V.copy(M[y]),C.multiplyVector3(V);
for(y=0,O=ka.length;y<O;y++)if(ea=ka[y][Q])for(M=0,V=ea.length;M<V;M++)l.uvs[y][M]=ea[M];l.material=z;l.faceMaterial=null!==t.materialIndex?B[t.materialIndex]:null;l.z=l.centroidScreen.z;w.elements.push(l)}}else if(K instanceof THREE.Line){r.multiply(F,u);Q=K.geometry.vertices;y=b();y.positionScreen.copy(Q[0].position);r.multiplyVector4(y.positionScreen);for(E=1,t=Q.length;E<t;E++)if(y=b(),y.positionScreen.copy(Q[E].position),r.multiplyVector4(y.positionScreen),O=h[m-2],D.copy(y.positionScreen),J.copy(O.positionScreen),
d(D,J))D.multiplyScalar(1/D.w),J.multiplyScalar(1/J.w),K=x[q]=x[q]||new THREE.RenderableLine,q++,k=K,k.v1.positionScreen.copy(D),k.v2.positionScreen.copy(J),k.z=Math.max(D.z,J.z),k.material=z,w.elements.push(k)}for(a=0,T=w.sprites.length;a<T;a++)if(K=w.sprites[a].object,u=K.matrixWorld,K instanceof THREE.Particle&&(A.set(u.n14,u.n24,u.n34,1),F.multiplyVector4(A),A.z/=A.w,0<A.z&&1>A.z))g=G[I]=G[I]||new THREE.RenderableParticle,I++,v=g,v.x=A.x/A.w,v.y=A.y/A.w,v.z=A.z,v.rotation=K.rotation.z,v.scale.x=
K.scale.x*Math.abs(v.x-(A.x+e.projectionMatrix.n11)/(A.w+e.projectionMatrix.n14)),v.scale.y=K.scale.y*Math.abs(v.y-(A.y+e.projectionMatrix.n22)/(A.w+e.projectionMatrix.n24)),v.material=K.material,w.elements.push(v);f&&w.elements.sort(c);return w}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,void 0!==d?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),g=a*b,i=d*e;this.w=g*f-i*c;this.x=g*c+i*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,i=a.z,a=a.w;this.x=b*a+e*f+c*i-d*g;this.y=c*a+e*g+d*f-b*i;this.z=d*a+e*i+b*g-c*f;this.w=e*a-b*f-c*g-d*i;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,i=this.z,m=this.w,h=m*c+g*e-i*d,l=m*d+i*c-f*e,o=m*e+f*d-g*c,c=-f*
c-g*d-i*e;b.x=h*m+c*-f+l*-i-o*-g;b.y=l*m+c*-g+o*-f-h*-i;b.z=o*m+c*-i+h*-g-l*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var f=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var f=0,g=e.vertexNormals.length;f<g;f++)b.multiplyVector3(e.vertexNormals[f]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;for(a=0,b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,
b,c,d,e,f,g=new THREE.Vector3,i=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d=this.vertices[c.a],e=this.vertices[c.b],f=this.vertices[c.c],g.sub(f.position,e.position),i.sub(d.position,e.position),g.crossSelf(i),g.isZero()||g.normalize(),c.normal.copy(g)},computeVertexNormals:function(){var a,b,c,d;if(void 0===this.__tmpVertices){d=this.__tmpVertices=Array(this.vertices.length);for(a=0,b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)if(c=
this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;for(a=0,b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),
d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));for(a=0,b=this.vertices.length;a<b;a++)d[a].normalize();for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,
b,c,d,e,f,F){i=a.vertices[b].position;m=a.vertices[c].position;h=a.vertices[d].position;l=g[e];o=g[f];n=g[F];j=m.x-i.x;p=h.x-i.x;k=m.y-i.y;q=h.y-i.y;x=m.z-i.z;v=h.z-i.z;I=o.u-l.u;G=n.u-l.u;w=o.v-l.v;H=n.v-l.v;A=1/(I*H-G*w);D.set((H*j-w*p)*A,(H*k-w*q)*A,(H*x-w*v)*A);J.set((I*p-G*j)*A,(I*q-G*k)*A,(I*v-G*x)*A);r[b].addSelf(D);r[c].addSelf(D);r[d].addSelf(D);s[b].addSelf(J);s[c].addSelf(J);s[d].addSelf(J)}var b,c,d,e,f,g,i,m,h,l,o,n,j,p,k,q,x,v,I,G,w,H,A,F,r=[],s=[],D=new THREE.Vector3,J=new THREE.Vector3,
Z=new THREE.Vector3,ca=new THREE.Vector3,N=new THREE.Vector3;for(b=0,c=this.vertices.length;b<c;b++)r[b]=new THREE.Vector3,s[b]=new THREE.Vector3;for(b=0,c=this.faces.length;b<c;b++)f=this.faces[b],g=this.faceVertexUvs[0][b],f instanceof THREE.Face3?a(this,f.a,f.b,f.c,0,1,2):f instanceof THREE.Face4&&(a(this,f.a,f.b,f.c,0,1,2),a(this,f.a,f.b,f.d,0,1,3));var P=["a","b","c","d"];for(b=0,c=this.faces.length;b<c;b++){f=this.faces[b];for(d=0;d<f.vertexNormals.length;d++)N.copy(f.vertexNormals[d]),e=f[P[d]],
F=r[e],Z.copy(F),Z.subSelf(N.multiplyScalar(N.dot(F))).normalize(),ca.cross(f.vertexNormals[d],F),e=ca.dot(s[e]),e=0>e?-1:1,f.vertexTangents[d]=new THREE.Vector4(Z.x,Z.y,Z.z,e)}this.hasTangents=!0},computeBoundingBox:function(){if(0<this.vertices.length){var a;a=this.vertices[0].position;this.boundingBox?(this.boundingBox.min.copy(a),this.boundingBox.max.copy(a)):this.boundingBox={min:a.clone(),max:a.clone()};for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<e;d++){a=
this.vertices[d].position;if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}},computeBoundingSphere:function(){for(var a,b=0,c=0,d=this.vertices.length;c<d;c++)a=this.vertices[c].position.length(),a>b&&(b=a);this.boundingSphere={radius:b}},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,4),f,g;for(f=0,g=this.vertices.length;f<g;f++)d=this.vertices[f].position,d=[Math.round(d.x*e),Math.round(d.y*e),Math.round(d.z*
e)].join("_"),void 0===a[d]?(a[d]=f,b.push(this.vertices[f]),c[f]=b.length-1):c[f]=c[a[d]];for(f=0,g=this.faces.length;f<g;f++)if(a=this.faces[f],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Camera=function(){if(arguments.length)return console.warn("DEPRECATED: Camera() is now PerspectiveCamera() or OrthographicCamera()."),new THREE.PerspectiveCamera(arguments[0],arguments[1],arguments[2],arguments[3]);THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;
THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;
THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:43.25)/(2*a));this.fov*=180/Math.PI;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.onlyShadow=this.castShadow=!1;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=this.shadowCamera=this.shadowMapSize=
this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){a=a||{};this.name="";this.id=THREE.MaterialCount++;this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.wrapAround=void 0!==a.wrapAround?a.wrapAround:!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;
this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:
"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=void 0!==a.specular?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=void 0!==a.shininess?a.shininess:30;this.metal=void 0!==a.metal?a.metal:!1;this.perPixel=void 0!==a.perPixel?a.perPixel:!1;this.wrapAround=void 0!==a.wrapAround?a.wrapAround:
!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:
!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.program=void 0!==a.program?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,f,g,i){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;this.format=void 0!==g?g:THREE.RGBAFormat;this.type=void 0!==i?i:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;if(b instanceof Array)console.warn("DEPRECATED: Mesh material can no longer be an Array. Using material at index 0..."),this.material=b[0];if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};
for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.addObject=function(a){if(a instanceof THREE.Light)-1===this.lights.indexOf(a)&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.objects.indexOf(a)){this.objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.addObject(a.children[b])};
THREE.Scene.prototype.removeObject=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);-1!==b&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),-1!==b&&(this.objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.removeObject(a.children[b])};
THREE.CanvasRenderer=function(a){function b(a){if(v!=a)k.globalAlpha=v=a}function c(a){if(I!=a){switch(a){case THREE.NormalBlending:k.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:k.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:k.globalCompositeOperation="darker"}I=a}}function d(a){if(G!=a)k.strokeStyle=G=a}function e(a){if(w!=a)k.fillStyle=w=a}var a=a||{},f=this,g,i,m,h=new THREE.Projector,l=void 0!==a.canvas?a.canvas:document.createElement("canvas"),
o,n,j,p,k=l.getContext("2d"),q=new THREE.Color(0),x=0,v=1,I=0,G=null,w=null,H=null,A=null,F=null,r,s,D,J,Z=new THREE.RenderableVertex,ca=new THREE.RenderableVertex,N,P,S,T,E,t,Q,y,O,M,V,K,u=new THREE.Color,C=new THREE.Color,z=new THREE.Color,B=new THREE.Color,L=new THREE.Color,ka=[],ea=[],fa,ga,da,$,Ba,Ca,Da,Ea,Fa,Ga,la=new THREE.Rectangle,Y=new THREE.Rectangle,X=new THREE.Rectangle,xa=!1,W=new THREE.Color,ma=new THREE.Color,na=new THREE.Color,R=new THREE.Vector3,ra,sa,ya,aa,ta,ua,a=16;ra=document.createElement("canvas");
ra.width=ra.height=2;sa=ra.getContext("2d");sa.fillStyle="rgba(0,0,0,1)";sa.fillRect(0,0,2,2);ya=sa.getImageData(0,0,2,2);aa=ya.data;ta=document.createElement("canvas");ta.width=ta.height=a;ua=ta.getContext("2d");ua.translate(-a/2,-a/2);ua.scale(a,a);a--;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.info={render:{vertices:0,faces:0}};this.setSize=function(a,b){o=a;n=b;j=Math.floor(o/2);p=Math.floor(n/2);l.width=o;l.height=n;la.set(-j,-p,j,p);Y.set(-j,-p,j,p);v=1;I=0;
F=A=H=w=G=null};this.setClearColor=function(a,b){q.copy(a);x=b;Y.set(-j,-p,j,p)};this.setClearColorHex=function(a,b){q.setHex(a);x=b;Y.set(-j,-p,j,p)};this.clear=function(){k.setTransform(1,0,0,-1,j,p);Y.isEmpty()||(Y.minSelf(la),Y.inflate(2),1>x&&k.clearRect(Math.floor(Y.getX()),Math.floor(Y.getY()),Math.floor(Y.getWidth()),Math.floor(Y.getHeight())),0<x&&(c(THREE.NormalBlending),b(1),e("rgba("+Math.floor(255*q.r)+","+Math.floor(255*q.g)+","+Math.floor(255*q.b)+","+x+")"),k.fillRect(Math.floor(Y.getX()),
Math.floor(Y.getY()),Math.floor(Y.getWidth()),Math.floor(Y.getHeight()))),Y.empty())};this.render=function(a,l){function o(a){var b,c,d,e;W.setRGB(0,0,0);ma.setRGB(0,0,0);na.setRGB(0,0,0);for(b=0,c=a.length;b<c;b++)d=a[b],e=d.color,d instanceof THREE.AmbientLight?(W.r+=e.r,W.g+=e.g,W.b+=e.b):d instanceof THREE.DirectionalLight?(ma.r+=e.r,ma.g+=e.g,ma.b+=e.b):d instanceof THREE.PointLight&&(na.r+=e.r,na.g+=e.g,na.b+=e.b)}function n(a,b,c,d){var e,f,g,i,l,k;for(e=0,f=a.length;e<f;e++)g=a[e],i=g.color,
g instanceof THREE.DirectionalLight?(l=g.matrixWorld.getPosition(),k=c.dot(l),0>=k||(k*=g.intensity,d.r+=i.r*k,d.g+=i.g*k,d.b+=i.b*k)):g instanceof THREE.PointLight&&(l=g.matrixWorld.getPosition(),k=c.dot(R.sub(l,b).normalize()),0>=k||(k*=0==g.distance?1:1-Math.min(b.distanceTo(l)/g.distance,1),0!=k&&(k*=g.intensity,d.r+=i.r*k,d.g+=i.g*k,d.b+=i.b*k)))}function q(a,f,g){b(g.opacity);c(g.blending);var i,l,h,m,za,o;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)m=g.map.image,za=m.width>>1,o=m.height>>
1,g=f.scale.x*j,h=f.scale.y*p,i=g*za,l=h*o,X.set(a.x-i,a.y-l,a.x+i,a.y+l),la.intersects(X)&&(k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(g,-h),k.translate(-za,-o),k.drawImage(m,0,0),k.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(i=f.scale.x*j,l=f.scale.y*p,X.set(a.x-i,a.y-l,a.x+i,a.y+l),la.intersects(X)&&(d(g.color.getContextStyle()),e(g.color.getContextStyle()),k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(i,l),g.program(k),k.restore()))}function w(a,
e,f,g){b(g.opacity);c(g.blending);k.beginPath();k.moveTo(a.positionScreen.x,a.positionScreen.y);k.lineTo(e.positionScreen.x,e.positionScreen.y);k.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(H!=a)k.lineWidth=H=a;a=g.linecap;if(A!=a)k.lineCap=A=a;a=g.linejoin;if(F!=a)k.lineJoin=F=a;d(g.color.getContextStyle());k.stroke();X.inflate(2*g.linewidth)}}function v(a,d,e,g,i,k,h,j){f.info.render.vertices+=3;f.info.render.faces++;b(j.opacity);c(j.blending);N=a.positionScreen.x;P=a.positionScreen.y;
S=d.positionScreen.x;T=d.positionScreen.y;E=e.positionScreen.x;t=e.positionScreen.y;x(N,P,S,T,E,t);if(j instanceof THREE.MeshBasicMaterial)if(j.map)j.map.mapping instanceof THREE.UVMapping&&($=h.uvs[0],Aa(N,P,S,T,E,t,$[g].u,$[g].v,$[i].u,$[i].v,$[k].u,$[k].v,j.map));else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=l.matrixWorldInverse,R.copy(h.vertexNormalsWorld[g]),Ba=0.5*(R.x*a.n11+R.y*a.n12+R.z*a.n13)+0.5,Ca=0.5*-(R.x*a.n21+R.y*a.n22+R.z*a.n23)+0.5,R.copy(h.vertexNormalsWorld[i]),
Da=0.5*(R.x*a.n11+R.y*a.n12+R.z*a.n13)+0.5,Ea=0.5*-(R.x*a.n21+R.y*a.n22+R.z*a.n23)+0.5,R.copy(h.vertexNormalsWorld[k]),Fa=0.5*(R.x*a.n11+R.y*a.n12+R.z*a.n13)+0.5,Ga=0.5*-(R.x*a.n21+R.y*a.n22+R.z*a.n23)+0.5,Aa(N,P,S,T,E,t,Ba,Ca,Da,Ea,Fa,Ga,j.envMap)}else j.wireframe?ia(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshLambertMaterial)j.map&&!j.wireframe&&(j.map.mapping instanceof THREE.UVMapping&&($=h.uvs[0],Aa(N,P,S,T,E,t,$[g].u,$[g].v,
$[i].u,$[i].v,$[k].u,$[k].v,j.map)),c(THREE.SubtractiveBlending)),xa?!j.wireframe&&j.shading==THREE.SmoothShading&&3==h.vertexNormalsWorld.length?(C.r=z.r=B.r=W.r,C.g=z.g=B.g=W.g,C.b=z.b=B.b=W.b,n(m,h.v1.positionWorld,h.vertexNormalsWorld[0],C),n(m,h.v2.positionWorld,h.vertexNormalsWorld[1],z),n(m,h.v3.positionWorld,h.vertexNormalsWorld[2],B),C.r=Math.max(0,Math.min(j.color.r*C.r,1)),C.g=Math.max(0,Math.min(j.color.g*C.g,1)),C.b=Math.max(0,Math.min(j.color.b*C.b,1)),z.r=Math.max(0,Math.min(j.color.r*
z.r,1)),z.g=Math.max(0,Math.min(j.color.g*z.g,1)),z.b=Math.max(0,Math.min(j.color.b*z.b,1)),B.r=Math.max(0,Math.min(j.color.r*B.r,1)),B.g=Math.max(0,Math.min(j.color.g*B.g,1)),B.b=Math.max(0,Math.min(j.color.b*B.b,1)),L.r=0.5*(z.r+B.r),L.g=0.5*(z.g+B.g),L.b=0.5*(z.b+B.b),da=va(C,z,B,L),pa(N,P,S,T,E,t,0,0,1,0,0,1,da)):(u.r=W.r,u.g=W.g,u.b=W.b,n(m,h.centroidWorld,h.normalWorld,u),u.r=Math.max(0,Math.min(j.color.r*u.r,1)),u.g=Math.max(0,Math.min(j.color.g*u.g,1)),u.b=Math.max(0,Math.min(j.color.b*u.b,
1)),j.wireframe?ia(u,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(u)):j.wireframe?ia(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshDepthMaterial)fa=l.near,ga=l.far,C.r=C.g=C.b=1-oa(a.positionScreen.z,fa,ga),z.r=z.g=z.b=1-oa(d.positionScreen.z,fa,ga),B.r=B.g=B.b=1-oa(e.positionScreen.z,fa,ga),L.r=0.5*(z.r+B.r),L.g=0.5*(z.g+B.g),L.b=0.5*(z.b+B.b),da=va(C,z,B,L),pa(N,P,S,T,E,t,0,0,1,0,0,1,da);else if(j instanceof THREE.MeshNormalMaterial)u.r=
qa(h.normalWorld.x),u.g=qa(h.normalWorld.y),u.b=qa(h.normalWorld.z),j.wireframe?ia(u,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(u)}function I(a,d,e,g,i,j,k,h,o){f.info.render.vertices+=4;f.info.render.faces++;b(h.opacity);c(h.blending);if(h.map||h.envMap)v(a,d,g,0,1,3,k,h,o),v(i,e,j,1,2,3,k,h,o);else if(N=a.positionScreen.x,P=a.positionScreen.y,S=d.positionScreen.x,T=d.positionScreen.y,E=e.positionScreen.x,t=e.positionScreen.y,Q=g.positionScreen.x,y=g.positionScreen.y,O=i.positionScreen.x,
M=i.positionScreen.y,V=j.positionScreen.x,K=j.positionScreen.y,h instanceof THREE.MeshBasicMaterial)G(N,P,S,T,E,t,Q,y),h.wireframe?ia(h.color,h.wireframeLinewidth,h.wireframeLinecap,h.wireframeLinejoin):ha(h.color);else if(h instanceof THREE.MeshLambertMaterial)xa?!h.wireframe&&h.shading==THREE.SmoothShading&&4==k.vertexNormalsWorld.length?(C.r=z.r=B.r=L.r=W.r,C.g=z.g=B.g=L.g=W.g,C.b=z.b=B.b=L.b=W.b,n(m,k.v1.positionWorld,k.vertexNormalsWorld[0],C),n(m,k.v2.positionWorld,k.vertexNormalsWorld[1],z),
n(m,k.v4.positionWorld,k.vertexNormalsWorld[3],B),n(m,k.v3.positionWorld,k.vertexNormalsWorld[2],L),C.r=Math.max(0,Math.min(h.color.r*C.r,1)),C.g=Math.max(0,Math.min(h.color.g*C.g,1)),C.b=Math.max(0,Math.min(h.color.b*C.b,1)),z.r=Math.max(0,Math.min(h.color.r*z.r,1)),z.g=Math.max(0,Math.min(h.color.g*z.g,1)),z.b=Math.max(0,Math.min(h.color.b*z.b,1)),B.r=Math.max(0,Math.min(h.color.r*B.r,1)),B.g=Math.max(0,Math.min(h.color.g*B.g,1)),B.b=Math.max(0,Math.min(h.color.b*B.b,1)),L.r=Math.max(0,Math.min(h.color.r*
L.r,1)),L.g=Math.max(0,Math.min(h.color.g*L.g,1)),L.b=Math.max(0,Math.min(h.color.b*L.b,1)),da=va(C,z,B,L),x(N,P,S,T,Q,y),pa(N,P,S,T,Q,y,0,0,1,0,0,1,da),x(O,M,E,t,V,K),pa(O,M,E,t,V,K,1,0,1,1,0,1,da)):(u.r=W.r,u.g=W.g,u.b=W.b,n(m,k.centroidWorld,k.normalWorld,u),u.r=Math.max(0,Math.min(h.color.r*u.r,1)),u.g=Math.max(0,Math.min(h.color.g*u.g,1)),u.b=Math.max(0,Math.min(h.color.b*u.b,1)),G(N,P,S,T,E,t,Q,y),h.wireframe?ia(u,h.wireframeLinewidth,h.wireframeLinecap,h.wireframeLinejoin):ha(u)):(G(N,P,S,
T,E,t,Q,y),h.wireframe?ia(h.color,h.wireframeLinewidth,h.wireframeLinecap,h.wireframeLinejoin):ha(h.color));else if(h instanceof THREE.MeshNormalMaterial)u.r=qa(k.normalWorld.x),u.g=qa(k.normalWorld.y),u.b=qa(k.normalWorld.z),G(N,P,S,T,E,t,Q,y),h.wireframe?ia(u,h.wireframeLinewidth,h.wireframeLinecap,h.wireframeLinejoin):ha(u);else if(h instanceof THREE.MeshDepthMaterial)fa=l.near,ga=l.far,C.r=C.g=C.b=1-oa(a.positionScreen.z,fa,ga),z.r=z.g=z.b=1-oa(d.positionScreen.z,fa,ga),B.r=B.g=B.b=1-oa(g.positionScreen.z,
fa,ga),L.r=L.g=L.b=1-oa(e.positionScreen.z,fa,ga),da=va(C,z,B,L),x(N,P,S,T,Q,y),pa(N,P,S,T,Q,y,0,0,1,0,0,1,da),x(O,M,E,t,V,K),pa(O,M,E,t,V,K,1,0,1,1,0,1,da)}function x(a,b,c,d,e,f){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(a,b);k.closePath()}function G(a,b,c,d,e,f,g,h){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(g,h);k.lineTo(a,b);k.closePath()}function ia(a,b,c,e){if(H!=b)k.lineWidth=H=b;if(A!=c)k.lineCap=A=c;if(F!=e)k.lineJoin=F=e;d(a.getContextStyle());
k.stroke();X.inflate(2*b)}function ha(a){e(a.getContextStyle());k.fill()}function Aa(a,b,c,d,f,g,h,i,j,l,m,o,n){if(0!=n.image.width){if(!0==n.needsUpdate||void 0==ka[n.id]){var p=n.wrapS==THREE.RepeatWrapping,q=n.wrapT==THREE.RepeatWrapping;ka[n.id]=k.createPattern(n.image,p&&q?"repeat":p&&!q?"repeat-x":!p&&q?"repeat-y":"no-repeat");n.needsUpdate=!1}e(ka[n.id]);var p=n.offset.x/n.repeat.x,q=n.offset.y/n.repeat.y,r=n.image.width*n.repeat.x,s=n.image.height*n.repeat.y,h=(h+p)*r,i=(i+q)*s,c=c-a,d=d-
b,f=f-a,g=g-b,j=(j+p)*r-h,l=(l+q)*s-i,m=(m+p)*r-h,o=(o+q)*s-i,p=j*o-m*l;if(0==p){if(void 0===ea[n.id])b=document.createElement("canvas"),b.width=n.image.width,b.height=n.image.height,b=b.getContext("2d"),b.drawImage(n.image,0,0),ea[n.id]=b.getImageData(0,0,n.image.width,n.image.height).data;b=ea[n.id];h=4*(Math.floor(h)+Math.floor(i)*n.image.width);u.setRGB(b[h]/255,b[h+1]/255,b[h+2]/255);ha(u)}else p=1/p,n=(o*c-l*f)*p,l=(o*d-l*g)*p,c=(j*f-m*c)*p,d=(j*g-m*d)*p,a=a-n*h-c*i,h=b-l*h-d*i,k.save(),k.transform(n,
l,c,d,a,h),k.fill(),k.restore()}}function pa(a,b,c,d,e,f,g,h,i,j,l,m,n){var o,p;o=n.width-1;p=n.height-1;g*=o;h*=p;c-=a;d-=b;e-=a;f-=b;i=i*o-g;j=j*p-h;l=l*o-g;m=m*p-h;p=1/(i*m-l*j);o=(m*c-j*e)*p;j=(m*d-j*f)*p;c=(i*e-l*c)*p;d=(i*f-l*d)*p;a=a-o*g-c*h;b=b-j*g-d*h;k.save();k.transform(o,j,c,d,a,b);k.clip();k.drawImage(n,0,0);k.restore()}function va(a,b,c,d){var e=~~(255*a.r),f=~~(255*a.g),a=~~(255*a.b),g=~~(255*b.r),h=~~(255*b.g),b=~~(255*b.b),i=~~(255*c.r),j=~~(255*c.g),c=~~(255*c.b),k=~~(255*d.r),l=
~~(255*d.g),d=~~(255*d.b);aa[0]=0>e?0:255<e?255:e;aa[1]=0>f?0:255<f?255:f;aa[2]=0>a?0:255<a?255:a;aa[4]=0>g?0:255<g?255:g;aa[5]=0>h?0:255<h?255:h;aa[6]=0>b?0:255<b?255:b;aa[8]=0>i?0:255<i?255:i;aa[9]=0>j?0:255<j?255:j;aa[10]=0>c?0:255<c?255:c;aa[12]=0>k?0:255<k?255:k;aa[13]=0>l?0:255<l?255:l;aa[14]=0>d?0:255<d?255:d;sa.putImageData(ya,0,0);ua.drawImage(ra,0,0);return ta}function oa(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function qa(a){a=0.5*(a+1);return 0>a?0:1<a?1:a}function ja(a,b){var c=b.x-a.x,
d=b.y-a.y,e=c*c+d*d;0!=e&&(e=1/Math.sqrt(e),c*=e,d*=e,b.x+=c,b.y+=d,a.x-=c,a.y-=d)}var wa,Ha,U,ba;this.autoClear?this.clear():k.setTransform(1,0,0,-1,j,p);f.info.render.vertices=0;f.info.render.faces=0;g=h.projectScene(a,l,this.sortElements);i=g.elements;m=g.lights;(xa=0<m.length)&&o(m);for(wa=0,Ha=i.length;wa<Ha;wa++)if(U=i[wa],ba=U.material,ba=ba instanceof THREE.MeshFaceMaterial?U.faceMaterial:ba,!(null==ba||0==ba.opacity)){X.empty();if(U instanceof THREE.RenderableParticle)r=U,r.x*=j,r.y*=p,q(r,
U,ba,a);else if(U instanceof THREE.RenderableLine)r=U.v1,s=U.v2,r.positionScreen.x*=j,r.positionScreen.y*=p,s.positionScreen.x*=j,s.positionScreen.y*=p,X.addPoint(r.positionScreen.x,r.positionScreen.y),X.addPoint(s.positionScreen.x,s.positionScreen.y),la.intersects(X)&&w(r,s,U,ba,a);else if(U instanceof THREE.RenderableFace3)r=U.v1,s=U.v2,D=U.v3,r.positionScreen.x*=j,r.positionScreen.y*=p,s.positionScreen.x*=j,s.positionScreen.y*=p,D.positionScreen.x*=j,D.positionScreen.y*=p,ba.overdraw&&(ja(r.positionScreen,
s.positionScreen),ja(s.positionScreen,D.positionScreen),ja(D.positionScreen,r.positionScreen)),X.add3Points(r.positionScreen.x,r.positionScreen.y,s.positionScreen.x,s.positionScreen.y,D.positionScreen.x,D.positionScreen.y),la.intersects(X)&&v(r,s,D,0,1,2,U,ba,a);else if(U instanceof THREE.RenderableFace4)r=U.v1,s=U.v2,D=U.v3,J=U.v4,r.positionScreen.x*=j,r.positionScreen.y*=p,s.positionScreen.x*=j,s.positionScreen.y*=p,D.positionScreen.x*=j,D.positionScreen.y*=p,J.positionScreen.x*=j,J.positionScreen.y*=
p,Z.positionScreen.copy(s.positionScreen),ca.positionScreen.copy(J.positionScreen),ba.overdraw&&(ja(r.positionScreen,s.positionScreen),ja(s.positionScreen,J.positionScreen),ja(J.positionScreen,r.positionScreen),ja(D.positionScreen,Z.positionScreen),ja(D.positionScreen,ca.positionScreen)),X.addPoint(r.positionScreen.x,r.positionScreen.y),X.addPoint(s.positionScreen.x,s.positionScreen.y),X.addPoint(D.positionScreen.x,D.positionScreen.y),X.addPoint(J.positionScreen.x,J.positionScreen.y),la.intersects(X)&&
I(r,s,D,J,Z,ca,U,ba,a);Y.addRectangle(X)}k.setTransform(1,0,0,1,0,0)}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
THREE.ImageUtils={crossOrigin:"",loadTexture:function(a,b,c){var d=new Image,e=new THREE.Texture(d,b);d.onload=function(){e.needsUpdate=!0;c&&c(this)};d.crossOrigin=this.crossOrigin;d.src=a;return e},loadTextureCube:function(a,b,c){var d,e=[],f=new THREE.Texture(e,b);e.loadCount=0;for(b=0,d=a.length;b<d;++b)e[b]=new Image,e[b].onload=function(){e.loadCount+=1;if(6===e.loadCount)f.needsUpdate=!0;c&&c(this)},e[b].crossOrigin="",e[b].src=a[b];return f},getNormalMap:function(a,b){var c=function(a){var b=
Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]},b=b|1,d=a.width,e=a.height,f=document.createElement("canvas");f.width=d;f.height=e;var g=f.getContext("2d");g.drawImage(a,0,0);for(var i=g.getImageData(0,0,d,e).data,m=g.createImageData(d,e),h=m.data,l=0;l<d;l++)for(var o=1;o<e;o++){var n=0>o-1?e-1:o-1,j=(o+1)%e,p=0>l-1?d-1:l-1,k=(l+1)%d,q=[],x=[0,0,i[4*(o*d+l)]/255*b];q.push([-1,0,i[4*(o*d+p)]/255*b]);q.push([-1,-1,i[4*(n*d+p)]/255*b]);q.push([0,-1,i[4*(n*d+l)]/255*b]);q.push([1,
-1,i[4*(n*d+k)]/255*b]);q.push([1,0,i[4*(o*d+k)]/255*b]);q.push([1,1,i[4*(j*d+k)]/255*b]);q.push([0,1,i[4*(j*d+l)]/255*b]);q.push([-1,1,i[4*(j*d+p)]/255*b]);n=[];p=q.length;for(j=0;j<p;j++){var k=q[j],v=q[(j+1)%p],k=[k[0]-x[0],k[1]-x[1],k[2]-x[2]],v=[v[0]-x[0],v[1]-x[1],v[2]-x[2]];n.push(c([k[1]*v[2]-k[2]*v[1],k[2]*v[0]-k[0]*v[2],k[0]*v[1]-k[1]*v[0]]))}q=[0,0,0];for(j=0;j<n.length;j++)q[0]+=n[j][0],q[1]+=n[j][1],q[2]+=n[j][2];q[0]/=n.length;q[1]/=n.length;q[2]/=n.length;x=4*(o*d+l);h[x]=255*((q[0]+
1)/2)|0;h[x+1]=255*(q[1]+0.5)|0;h[x+2]=255*q[2]|0;h[x+3]=255}g.putImageData(m,0,0);return f}};
