// ThreeWebGL.js r46 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var e,f,g;if(c===0)this.r=this.g=this.b=0;else switch(e=Math.floor(a*6),f=a*6-e,a=c*(1-b),g=c*(1-
b*f),b=c*(1-b*(1-f)),e){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+
Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x===this.x&&a.y===this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,e=this.z;this.x=c*a.z-e*a.y;this.y=e*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);
this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(a,b,c,e){this.x=a||0;this.y=b||0;this.z=c||0;this.w=e!==void 0?e:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,e){this.x=a;this.y=b;this.z=c;this.w=e;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};
THREE.Ray=function(a,b){function c(a,b,c){p.sub(c,a);y=p.dot(b);if(y<=0)return null;I=A.add(a,r.copy(b).multiplyScalar(y));return R=c.distanceTo(I)}function e(a,b,c,e){p.sub(e,b);A.sub(c,b);r.sub(a,b);va=p.dot(p);ha=p.dot(A);ja=p.dot(r);ga=A.dot(A);L=A.dot(r);S=1/(va*ga-ha*ha);F=(ga*ja-ha*L)*S;N=(va*L-ha*ja)*S;return F>=0&&N>=0&&F+N<1}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectScene=function(a){return this.intersectObjects(a.children)};this.intersectObjects=
function(a){var b,c,e=[];b=0;for(c=a.length;b<c;b++)Array.prototype.push.apply(e,this.intersectObject(a[b]));e.sort(function(a,b){return a.distance-b.distance});return e};var f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,a=new THREE.Vector3,b=new THREE.Vector3,n=new THREE.Vector3,k=new THREE.Vector3,l=new THREE.Vector3;this.intersectObject=function(r){for(var p,y=[],A=0,oa=r.children.length;A<oa;A++)Array.prototype.push.apply(y,this.intersectObject(r.children[A]));
if(r instanceof THREE.Particle){A=c(this.origin,this.direction,r.matrixWorld.getPosition());if(A===null||A>r.scale.x)return[];p={distance:A,point:r.position,face:null,object:r};y.push(p)}else if(r instanceof THREE.Mesh){A=c(this.origin,this.direction,r.matrixWorld.getPosition());if(A===null||A>r.geometry.boundingSphere.radius*Math.max(r.scale.x,Math.max(r.scale.y,r.scale.z)))return y;var I,R=r.geometry,Q=R.vertices,L;r.matrixRotationWorld.extractRotation(r.matrixWorld);A=0;for(oa=R.faces.length;A<
oa;A++)if(p=R.faces[A],a.copy(this.origin),b.copy(this.direction),L=r.matrixWorld,n=L.multiplyVector3(n.copy(p.centroid)).subSelf(a),I=n.dot(b),!(I<=0)&&(f=L.multiplyVector3(f.copy(Q[p.a].position)),g=L.multiplyVector3(g.copy(Q[p.b].position)),h=L.multiplyVector3(h.copy(Q[p.c].position)),p instanceof THREE.Face4&&(i=L.multiplyVector3(i.copy(Q[p.d].position))),k=r.matrixRotationWorld.multiplyVector3(k.copy(p.normal)),I=b.dot(k),r.doubleSided||(r.flipSided?I>0:I<0)))if(I=k.dot(n.sub(f,a))/I,l.add(a,
b.multiplyScalar(I)),p instanceof THREE.Face3)e(l,f,g,h)&&(p={distance:a.distanceTo(l),point:l.clone(),face:p,object:r},y.push(p));else if(p instanceof THREE.Face4&&(e(l,f,g,i)||e(l,g,h,i)))p={distance:a.distanceTo(l),point:l.clone(),face:p,object:r},y.push(p)}return y};var p=new THREE.Vector3,A=new THREE.Vector3,r=new THREE.Vector3,y,I,R,va,ha,ja,ga,L,S,F,N};
THREE.Rectangle=function(){function a(){g=e-b;h=f-c}var b,c,e,f,g,h,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return e};this.getBottom=function(){return f};this.set=function(g,h,l,p){i=!1;b=g;c=h;e=l;f=p;a()};this.addPoint=function(g,h){i?(i=!1,b=g,c=h,e=g,f=h):(b=b<g?b:g,c=c<h?c:h,e=e>g?e:g,f=f>h?f:h);a()};this.add3Points=
function(g,h,l,p,A,r){i?(i=!1,b=g<l?g<A?g:A:l<A?l:A,c=h<p?h<r?h:r:p<r?p:r,e=g>l?g>A?g:A:l>A?l:A,f=h>p?h>r?h:r:p>r?p:r):(b=g<l?g<A?g<b?g:b:A<b?A:b:l<A?l<b?l:b:A<b?A:b,c=h<p?h<r?h<c?h:c:r<c?r:c:p<r?p<c?p:c:r<c?r:c,e=g>l?g>A?g>e?g:e:A>e?A:e:l>A?l>e?l:e:A>e?A:e,f=h>p?h>r?h>f?h:f:r>f?r:f:p>r?p>f?p:f:r>f?r:f);a()};this.addRectangle=function(g){i?(i=!1,b=g.getLeft(),c=g.getTop(),e=g.getRight(),f=g.getBottom()):(b=b<g.getLeft()?b:g.getLeft(),c=c<g.getTop()?c:g.getTop(),e=e>g.getRight()?e:g.getRight(),f=f>
g.getBottom()?f:g.getBottom());a()};this.inflate=function(g){b-=g;c-=g;e+=g;f+=g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();e=e<g.getRight()?e:g.getRight();f=f<g.getBottom()?f:g.getBottom();a()};this.intersects=function(a){return Math.min(e,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(f,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){i=!0;f=e=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,e,f){return e+(a-b)*(f-e)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,e,f,g,h,i,n,k,l,p,A,r,y,I){this.set(a!==void 0?a:1,b||0,c||0,e||0,f||0,g!==void 0?g:1,h||0,i||0,n||0,k||0,l!==void 0?l:1,p||0,A||0,r||0,y||0,I!==void 0?I:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,e,f,g,h,i,n,k,l,p,A,r,y,I){this.n11=a;this.n12=b;this.n13=c;this.n14=e;this.n21=f;this.n22=g;this.n23=h;this.n24=i;this.n31=n;this.n32=k;this.n33=l;this.n34=p;this.n41=A;this.n42=r;this.n43=y;this.n44=I;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var e=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;e.cross(c,g).normalize();e.length()===0&&(g.x+=1.0E-4,e.cross(c,g).normalize());f.cross(g,e).normalize();this.n11=e.x;this.n12=f.x;this.n13=g.x;this.n21=e.y;this.n22=f.y;this.n23=g.y;this.n31=e.z;this.n32=f.z;this.n33=g.z;return this},multiply:function(a,b){var c=a.n11,e=a.n12,f=a.n13,g=a.n14,h=a.n21,i=a.n22,n=a.n23,k=a.n24,l=a.n31,p=a.n32,A=a.n33,r=a.n34,y=a.n41,I=a.n42,R=a.n43,
va=a.n44,ha=b.n11,ja=b.n12,ga=b.n13,L=b.n14,S=b.n21,F=b.n22,N=b.n23,ca=b.n24,M=b.n31,W=b.n32,la=b.n33,oa=b.n34,ra=b.n41,wa=b.n42,Q=b.n43,sa=b.n44;this.n11=c*ha+e*S+f*M+g*ra;this.n12=c*ja+e*F+f*W+g*wa;this.n13=c*ga+e*N+f*la+g*Q;this.n14=c*L+e*ca+f*oa+g*sa;this.n21=h*ha+i*S+n*M+k*ra;this.n22=h*ja+i*F+n*W+k*wa;this.n23=h*ga+i*N+n*la+k*Q;this.n24=h*L+i*ca+n*oa+k*sa;this.n31=l*ha+p*S+A*M+r*ra;this.n32=l*ja+p*F+A*W+r*wa;this.n33=l*ga+p*N+A*la+r*Q;this.n34=l*L+p*ca+A*oa+r*sa;this.n41=y*ha+I*S+R*M+va*ra;
this.n42=y*ja+I*F+R*W+va*wa;this.n43=y*ga+I*N+R*la+va*Q;this.n44=y*L+I*ca+R*oa+va*sa;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=
a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,e=a.z,f=1/(this.n41*b+this.n42*c+this.n43*e+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*e+this.n14)*f;a.y=(this.n21*b+this.n22*c+this.n23*e+this.n24)*f;a.z=(this.n31*b+this.n32*c+this.n33*e+this.n34)*f;return a},multiplyVector4:function(a){var b=a.x,c=a.y,e=a.z,f=a.w;a.x=this.n11*b+this.n12*
c+this.n13*e+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*e+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*e+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*e+this.n44*f;return a},rotateAxis:function(a){var b=a.x,c=a.y,e=a.z;a.x=b*this.n11+c*this.n12+e*this.n13;a.y=b*this.n21+c*this.n22+e*this.n23;a.z=b*this.n31+c*this.n32+e*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*
a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,e=this.n14,f=this.n21,g=this.n22,h=this.n23,i=this.n24,n=this.n31,k=this.n32,l=this.n33,p=this.n34,A=this.n41,r=this.n42,y=this.n43,I=this.n44;return e*h*k*A-c*i*k*A-e*g*l*A+b*i*l*A+c*g*p*A-b*h*p*A-e*h*n*r+c*i*n*r+e*f*l*r-a*i*l*r-c*f*p*r+a*h*p*r+e*g*n*y-b*i*n*y-e*f*k*y+a*i*k*y+b*f*p*y-a*g*p*y-c*
g*n*I+b*h*n*I+c*f*k*I-a*h*k*I-b*f*l*I+a*g*l*I},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;
a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},
flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=
this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),
a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),e=Math.sin(b),f=1-c,g=a.x,h=a.y,i=a.z,n=f*g,k=f*h;this.set(n*g+c,n*h-e*i,n*i+e*h,0,n*h+e*i,k*h+c,k*i-e*g,0,n*i-e*h,k*i+e*g,f*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,this.n21,
this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,e=a.n13,f=a.n14,g=a.n21,h=a.n22,i=a.n23,n=a.n24,k=a.n31,l=a.n32,p=a.n33,A=a.n34,r=a.n41,y=a.n42,I=a.n43,R=a.n44;this.n11=i*A*y-n*p*y+n*l*I-h*A*I-i*l*R+h*p*R;this.n12=f*p*y-e*A*y-f*l*I+c*A*I+e*l*R-c*p*R;this.n13=e*n*y-f*i*y+f*h*I-c*n*I-e*h*R+c*i*R;this.n14=f*i*l-e*n*l-f*h*p+c*n*p+e*h*A-
c*i*A;this.n21=n*p*r-i*A*r-n*k*I+g*A*I+i*k*R-g*p*R;this.n22=e*A*r-f*p*r+f*k*I-b*A*I-e*k*R+b*p*R;this.n23=f*i*r-e*n*r-f*g*I+b*n*I+e*g*R-b*i*R;this.n24=e*n*k-f*i*k+f*g*p-b*n*p-e*g*A+b*i*A;this.n31=h*A*r-n*l*r+n*k*y-g*A*y-h*k*R+g*l*R;this.n32=f*l*r-c*A*r-f*k*y+b*A*y+c*k*R-b*l*R;this.n33=e*n*r-f*h*r+f*g*y-b*n*y-c*g*R+b*h*R;this.n34=f*h*k-c*n*k-f*g*l+b*n*l+c*g*A-b*h*A;this.n41=i*l*r-h*p*r-i*k*y+g*p*y+h*k*I-g*l*I;this.n42=c*p*r-e*l*r+e*k*y-b*p*y-c*k*I+b*l*I;this.n43=e*h*r-c*i*r-e*g*y+b*i*y+c*g*I-b*h*I;
this.n44=c*i*k-e*h*k+e*g*l-b*i*l-c*g*p+b*h*p;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=a.x,e=a.y,f=a.z,g=Math.cos(c),c=Math.sin(c),h=Math.cos(e),e=Math.sin(e),i=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var n=h*i,k=h*f,l=e*i,p=e*f;this.n11=n+p*c;this.n12=l*c-k;this.n13=g*e;this.n21=g*f;this.n22=g*i;this.n23=-c;this.n31=k*c-l;this.n32=p+n*c;this.n33=g*h;break;case "ZXY":n=h*i;k=h*f;l=e*i;p=e*f;this.n11=n-p*c;this.n12=-g*f;this.n13=l+k*c;this.n21=
k+l*c;this.n22=g*i;this.n23=p-n*c;this.n31=-g*e;this.n32=c;this.n33=g*h;break;case "ZYX":n=g*i;k=g*f;l=c*i;p=c*f;this.n11=h*i;this.n12=l*e-k;this.n13=n*e+p;this.n21=h*f;this.n22=p*e+n;this.n23=k*e-l;this.n31=-e;this.n32=c*h;this.n33=g*h;break;case "YZX":n=g*h;k=g*e;l=c*h;p=c*e;this.n11=h*i;this.n12=p-n*f;this.n13=l*f+k;this.n21=f;this.n22=g*i;this.n23=-c*i;this.n31=-e*i;this.n32=k*f+l;this.n33=n-p*f;break;case "XZY":n=g*h;k=g*e;l=c*h;p=c*e;this.n11=h*i;this.n12=-f;this.n13=e*i;this.n21=n*f+p;this.n22=
g*i;this.n23=k*f-l;this.n31=l*f-k;this.n32=c*i;this.n33=p*f+n;break;default:n=g*i,k=g*f,l=c*i,p=c*f,this.n11=h*i,this.n12=-h*f,this.n13=e,this.n21=k+l*e,this.n22=n-p*e,this.n23=-c*h,this.n31=p-n*e,this.n32=l+k*e,this.n33=g*h}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,e=a.z,f=a.w,g=b+b,h=c+c,i=e+e,a=b*g,n=b*h;b*=i;var k=c*h;c*=i;e*=i;g*=f;h*=f;f*=i;this.n11=1-(k+e);this.n12=n-f;this.n13=b+h;this.n21=n+f;this.n22=1-(a+e);this.n23=c-g;this.n31=b-h;this.n32=c+g;this.n33=1-(a+k);
return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var e=THREE.Matrix4.__m1,f=THREE.Matrix4.__m2;e.identity();e.setRotationFromQuaternion(b);f.setScale(c.x,c.y,c.z);this.multiply(e,f);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var e=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;
e.set(this.n11,this.n21,this.n31);f.set(this.n12,this.n22,this.n32);g.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=e.length();c.y=f.length();c.z=g.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;e=THREE.Matrix4.__m1;e.copy(this);e.n11/=c.x;e.n21/=c.x;e.n31/=c.x;e.n12/=c.y;e.n22/=c.y;e.n32/=c.y;e.n13/=c.z;e.n23/=c.z;e.n33/=c.z;b.setFromRotationMatrix(e);return[a,
b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),e=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*e;this.n22=a.n22*e;this.n32=a.n32*e;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,e=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,n=-a.n32*a.n11+a.n31*a.n12,k=a.n23*a.n12-a.n22*a.n13,l=-a.n23*a.n11+a.n21*a.n13,p=a.n22*a.n11-a.n21*a.n12,a=a.n11*e+a.n21*h+a.n31*k;a===0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*e;c[1]=a*f;c[2]=a*g;c[3]=a*h;c[4]=a*i;c[5]=a*n;c[6]=a*k;c[7]=a*l;c[8]=a*p;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,e,f,g){var h;h=new THREE.Matrix4;h.n11=2*f/(b-a);h.n12=0;h.n13=(b+a)/(b-a);h.n14=0;h.n21=0;h.n22=2*f/(e-c);h.n23=(e+c)/(e-c);h.n24=0;h.n31=0;h.n32=0;h.n33=-(g+f)/(g-f);h.n34=-2*g*f/(g-f);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,b,c,e){var f,a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,e)};
THREE.Matrix4.makeOrtho=function(a,b,c,e,f,g){var h,i,n,k;h=new THREE.Matrix4;i=b-a;n=c-e;k=g-f;h.n11=2/i;h.n12=0;h.n13=0;h.n14=-((b+a)/i);h.n21=0;h.n22=2/n;h.n23=0;h.n24=-((c+e)/n);h.n31=0;h.n32=0;h.n33=-2/k;h.n34=-((g+f)/k);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.name="";this.id=THREE.Object3DCount++;this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addObject(a)}},remove:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=void 0;this.children.splice(b,1);for(b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.removeObject(a)}},getChildByName:function(a,b){var c,e,f;c=0;for(e=this.children.length;c<e;c++){f=this.children[c];if(f.name===a)return f;
if(b&&(f=f.getChildByName(a,b),f!==void 0))return f}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=h[g]=h[g]||new THREE.RenderableObject;g++;return a}function b(){var a=k[n]=k[n]||new THREE.RenderableVertex;n++;return a}function c(a,b){return b.z-a.z}function e(a,b){var c=0,e=1,g=a.z+a.w,f=b.z+b.w,h=-a.z+a.w,i=-b.z+b.w;return g>=0&&f>=0&&h>=0&&i>=0?!0:g<0&&f<0||h<0&&i<0?!1:(g<0?c=Math.max(c,g/(g-f)):f<0&&(e=Math.min(e,g/(g-f))),h<0?c=Math.max(c,h/(h-i)):i<0&&(e=Math.min(e,h/(h-i))),e<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-e),!0))}var f,g,h=[],i,n,k=[],
l,p,A=[],r,y=[],I,R,va=[],ha,ja,ga=[],L={objects:[],sprites:[],lights:[],elements:[]},S=new THREE.Vector3,F=new THREE.Vector4,N=new THREE.Matrix4,ca=new THREE.Matrix4,M=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],W=new THREE.Vector4,la=new THREE.Vector4;this.computeFrustum=function(a){M[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);M[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);M[2].set(a.n41+a.n21,a.n42+a.n22,
a.n43+a.n23,a.n44+a.n24);M[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);M[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);M[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;a<6;a++){var b=M[a];b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))}};this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);N.multiply(b.projectionMatrix,b.matrixWorldInverse);N.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);
N.multiply(b.matrixWorld,b.projectionMatrixInverse);N.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,e){g=0;L.objects.length=0;L.sprites.length=0;L.lights.length=0;var h=function(b){if(b.visible!==!1){var c;if(c=b instanceof THREE.Mesh||b instanceof THREE.Line)if(!(c=b.frustumCulled===!1))a:{for(var e=b.matrixWorld,
g=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),i=0;i<6;i++)if(c=M[i].x*e.n14+M[i].y*e.n24+M[i].z*e.n34+M[i].w,c<=g){c=!1;break a}c=!0}c?(N.multiplyVector3(S.copy(b.position)),f=a(),f.object=b,f.z=S.z,L.objects.push(f)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(N.multiplyVector3(S.copy(b.position)),f=a(),f.object=b,f.z=S.z,L.sprites.push(f)):b instanceof THREE.Light&&L.lights.push(b);c=0;for(e=b.children.length;c<e;c++)h(b.children[c])}};h(b);e&&
L.objects.sort(c);return L};this.projectScene=function(a,g,f){var h=g.near,S=g.far,M,pa,ma,na,J,O,Y,G,d,ta,xa,Ca,Aa,ya,Fa,za;ja=R=r=p=0;L.elements.length=0;g.parent===void 0&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),a.add(g));a.updateMatrixWorld();g.matrixWorldInverse.getInverse(g.matrixWorld);N.multiply(g.projectionMatrix,g.matrixWorldInverse);this.computeFrustum(N);L=this.projectGraph(a,!1);a=0;for(M=L.objects.length;a<M;a++)if(d=L.objects[a].object,ta=d.matrixWorld,
Ca=d.material,n=0,d instanceof THREE.Mesh){xa=d.geometry;Aa=d.geometry.materials;na=xa.vertices;ya=xa.faces;Fa=xa.faceVertexUvs;xa=d.matrixRotationWorld.extractRotation(ta);pa=0;for(ma=na.length;pa<ma;pa++)i=b(),i.positionWorld.copy(na[pa].position),ta.multiplyVector3(i.positionWorld),i.positionScreen.copy(i.positionWorld),N.multiplyVector4(i.positionScreen),i.positionScreen.x/=i.positionScreen.w,i.positionScreen.y/=i.positionScreen.w,i.visible=i.positionScreen.z>h&&i.positionScreen.z<S;na=0;for(pa=
ya.length;na<pa;na++){ma=ya[na];if(ma instanceof THREE.Face3)if(J=k[ma.a],O=k[ma.b],Y=k[ma.c],J.visible&&O.visible&&Y.visible&&(d.doubleSided||d.flipSided!=(Y.positionScreen.x-J.positionScreen.x)*(O.positionScreen.y-J.positionScreen.y)-(Y.positionScreen.y-J.positionScreen.y)*(O.positionScreen.x-J.positionScreen.x)<0))G=A[p]=A[p]||new THREE.RenderableFace3,p++,l=G,l.v1.copy(J),l.v2.copy(O),l.v3.copy(Y);else continue;else if(ma instanceof THREE.Face4)if(J=k[ma.a],O=k[ma.b],Y=k[ma.c],G=k[ma.d],J.visible&&
O.visible&&Y.visible&&G.visible&&(d.doubleSided||d.flipSided!=((G.positionScreen.x-J.positionScreen.x)*(O.positionScreen.y-J.positionScreen.y)-(G.positionScreen.y-J.positionScreen.y)*(O.positionScreen.x-J.positionScreen.x)<0||(O.positionScreen.x-Y.positionScreen.x)*(G.positionScreen.y-Y.positionScreen.y)-(O.positionScreen.y-Y.positionScreen.y)*(G.positionScreen.x-Y.positionScreen.x)<0)))za=y[r]=y[r]||new THREE.RenderableFace4,r++,l=za,l.v1.copy(J),l.v2.copy(O),l.v3.copy(Y),l.v4.copy(G);else continue;
l.normalWorld.copy(ma.normal);xa.multiplyVector3(l.normalWorld);l.centroidWorld.copy(ma.centroid);ta.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);N.multiplyVector3(l.centroidScreen);Y=ma.vertexNormals;J=0;for(O=Y.length;J<O;J++)G=l.vertexNormalsWorld[J],G.copy(Y[J]),xa.multiplyVector3(G);J=0;for(O=Fa.length;J<O;J++)if(za=Fa[J][na]){Y=0;for(G=za.length;Y<G;Y++)l.uvs[J][Y]=za[Y]}l.material=Ca;l.faceMaterial=ma.materialIndex!==null?Aa[ma.materialIndex]:null;l.z=l.centroidScreen.z;
L.elements.push(l)}}else if(d instanceof THREE.Line){ca.multiply(N,ta);na=d.geometry.vertices;J=b();J.positionScreen.copy(na[0].position);ca.multiplyVector4(J.positionScreen);pa=1;for(ma=na.length;pa<ma;pa++)if(J=b(),J.positionScreen.copy(na[pa].position),ca.multiplyVector4(J.positionScreen),O=k[n-2],W.copy(J.positionScreen),la.copy(O.positionScreen),e(W,la))W.multiplyScalar(1/W.w),la.multiplyScalar(1/la.w),d=va[R]=va[R]||new THREE.RenderableLine,R++,I=d,I.v1.positionScreen.copy(W),I.v2.positionScreen.copy(la),
I.z=Math.max(W.z,la.z),I.material=Ca,L.elements.push(I)}a=0;for(M=L.sprites.length;a<M;a++)if(d=L.sprites[a].object,ta=d.matrixWorld,d instanceof THREE.Particle&&(F.set(ta.n14,ta.n24,ta.n34,1),N.multiplyVector4(F),F.z/=F.w,F.z>0&&F.z<1))h=ga[ja]=ga[ja]||new THREE.RenderableParticle,ja++,ha=h,ha.x=F.x/F.w,ha.y=F.y/F.w,ha.z=F.z,ha.rotation=d.rotation.z,ha.scale.x=d.scale.x*Math.abs(ha.x-(F.x+g.projectionMatrix.n11)/(F.w+g.projectionMatrix.n14)),ha.scale.y=d.scale.y*Math.abs(ha.y-(F.y+g.projectionMatrix.n22)/
(F.w+g.projectionMatrix.n24)),ha.material=d.material,L.elements.push(ha);f&&L.elements.sort(c);return L}};THREE.Quaternion=function(a,b,c,e){this.set(a||0,b||0,c||0,e!==void 0?e:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,e){this.x=a;this.y=b;this.z=c;this.w=e;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,e=a.y*b,f=a.z*b,a=Math.cos(e),e=Math.sin(e),b=Math.cos(-f),f=Math.sin(-f),g=Math.cos(c),c=Math.sin(c),h=a*b,i=e*f;this.w=h*g-i*c;this.x=h*c+i*g;this.y=e*b*g+a*f*c;this.z=a*f*g-e*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,e=Math.sin(c);
this.x=a.x*e;this.y=a.y*e;this.z=a.z*e;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=a.n32-a.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=a.n13-a.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.n21-a.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a===0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,e=this.z,f=this.w,g=a.x,h=a.y,i=a.z,a=a.w;this.x=b*a+f*g+c*i-e*h;this.y=c*a+f*h+e*g-b*i;this.z=e*a+f*i+b*h-c*g;this.w=f*a-b*g-c*h-e*i;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,e=a.y,f=a.z,g=this.x,h=this.y,i=this.z,n=this.w,k=n*c+h*f-i*e,l=n*e+i*c-g*f,p=n*f+g*e-h*c,c=-g*
c-h*e-i*f;b.x=k*n+c*-g+l*-i-p*-h;b.y=l*n+c*-h+p*-g-k*-i;b.z=p*n+c*-i+k*-h-l*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,e){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;f<0?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,f=-f):c.copy(b);if(Math.abs(f)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(f),f=Math.sqrt(1-f*f);if(Math.abs(f)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-e)*g)/f;e=Math.sin(e*g)/f;c.w=a.w*b+c.w*e;c.x=a.x*b+c.x*e;c.y=a.y*b+c.y*e;c.z=a.z*b+c.z*e;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,e,f,g){this.a=a;this.b=b;this.c=c;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,e,f,g,h){this.a=a;this.b=b;this.c=c;this.d=e;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materialIndex=h;this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,e=this.vertices.length;c<e;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(e=this.faces.length;c<e;c++){var f=this.faces[c];b.multiplyVector3(f.normal);for(var g=0,h=f.vertexNormals.length;g<h;g++)b.multiplyVector3(f.vertexNormals[g]);a.multiplyVector3(f.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,
b,c,e,f,g,h=new THREE.Vector3,i=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],e=this.vertices[c.a],f=this.vertices[c.b],g=this.vertices[c.c],h.sub(g.position,f.position),i.sub(e.position,f.position),h.crossSelf(i),h.isZero()||h.normalize(),c.normal.copy(h)},computeVertexNormals:function(){var a,b,c,e;if(this.__tmpVertices===void 0){e=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)e[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=
this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{e=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)e[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(e[c.a].addSelf(c.normal),e[c.b].addSelf(c.normal),e[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(e[c.a].addSelf(c.normal),
e[c.b].addSelf(c.normal),e[c.c].addSelf(c.normal),e[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)e[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(e[c.a]),c.vertexNormals[1].copy(e[c.b]),c.vertexNormals[2].copy(e[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(e[c.a]),c.vertexNormals[1].copy(e[c.b]),c.vertexNormals[2].copy(e[c.c]),c.vertexNormals[3].copy(e[c.d]))},computeTangents:function(){function a(a,
b,c,e,g,f,N){i=a.vertices[b].position;n=a.vertices[c].position;k=a.vertices[e].position;l=h[g];p=h[f];A=h[N];r=n.x-i.x;y=k.x-i.x;I=n.y-i.y;R=k.y-i.y;va=n.z-i.z;ha=k.z-i.z;ja=p.u-l.u;ga=A.u-l.u;L=p.v-l.v;S=A.v-l.v;F=1/(ja*S-ga*L);W.set((S*r-L*y)*F,(S*I-L*R)*F,(S*va-L*ha)*F);la.set((ja*y-ga*r)*F,(ja*R-ga*I)*F,(ja*ha-ga*va)*F);ca[b].addSelf(W);ca[c].addSelf(W);ca[e].addSelf(W);M[b].addSelf(la);M[c].addSelf(la);M[e].addSelf(la)}var b,c,e,f,g,h,i,n,k,l,p,A,r,y,I,R,va,ha,ja,ga,L,S,F,N,ca=[],M=[],W=new THREE.Vector3,
la=new THREE.Vector3,oa=new THREE.Vector3,ra=new THREE.Vector3,wa=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)ca[b]=new THREE.Vector3,M[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],h=this.faceVertexUvs[0][b],g instanceof THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var Q=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(e=0;e<g.vertexNormals.length;e++)wa.copy(g.vertexNormals[e]),
f=g[Q[e]],N=ca[f],oa.copy(N),oa.subSelf(wa.multiplyScalar(wa.dot(N))).normalize(),ra.cross(g.vertexNormals[e],N),f=ra.dot(M[f]),f=f<0?-1:1,g.vertexTangents[e]=new THREE.Vector4(oa.x,oa.y,oa.z,f)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<
c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=
0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},mergeVertices:function(){var a={},b=[],c=[],e,f=Math.pow(10,4),g,h;g=0;for(h=this.vertices.length;g<h;g++)e=this.vertices[g].position,e=[Math.round(e.x*f),Math.round(e.y*f),Math.round(e.z*f)].join("_"),a[e]===void 0?(a[e]=g,b.push(this.vertices[g]),c[g]=b.length-1):c[g]=c[a[e]];g=0;for(h=this.faces.length;g<h;g++)if(a=this.faces[g],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=
c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Spline=function(a){function b(a,b,c,e,g,f,h){a=(c-a)*0.5;e=(e-b)*0.5;return(2*(b-c)+a+e)*h+(-3*(b-c)-2*a-e)*f+a*g+b}this.points=a;var c=[],e={x:0,y:0,z:0},f,g,h,i,n,k,l,p,A;this.initFromArray=function(a){this.points=[];for(var b=0;b<a.length;b++)this.points[b]={x:a[b][0],y:a[b][1],z:a[b][2]}};this.getPoint=function(a){f=(this.points.length-1)*a;g=Math.floor(f);h=f-g;c[0]=g===0?g:g-1;c[1]=g;c[2]=g>this.points.length-2?g:g+1;c[3]=g>this.points.length-3?g:g+2;k=this.points[c[0]];l=this.points[c[1]];
p=this.points[c[2]];A=this.points[c[3]];i=h*h;n=h*i;e.x=b(k.x,l.x,p.x,A.x,h,i,n);e.y=b(k.y,l.y,p.y,A.y,h,i,n);e.z=b(k.z,l.z,p.z,A.z,h,i,n);return e};this.getControlPointsArray=function(){var a,b,c=this.points.length,e=[];for(a=0;a<c;a++)b=this.points[a],e[a]=[b.x,b.y,b.z];return e};this.getLength=function(a){var b,c,e,g=b=b=0,f=new THREE.Vector3,h=new THREE.Vector3,i=[],l=0;i[0]=0;a||(a=100);c=this.points.length*a;f.copy(this.points[0]);for(a=1;a<c;a++)b=a/c,e=this.getPoint(b),h.copy(e),l+=h.distanceTo(f),
f.copy(e),b*=this.points.length-1,b=Math.floor(b),b!=g&&(i[b]=l,g=b);i[i.length]=l;return{chunks:i,total:l}};this.reparametrizeByArcLength=function(a){var b,c,e,g,f,h,i=[],l=new THREE.Vector3,p=this.getLength();i.push(l.copy(this.points[0]).clone());for(b=1;b<this.points.length;b++){c=p.chunks[b]-p.chunks[b-1];h=Math.ceil(a*c/p.total);g=(b-1)/(this.points.length-1);f=b/(this.points.length-1);for(c=1;c<h-1;c++)e=g+c*(1/h)*(f-g),e=this.getPoint(e),i.push(l.copy(e).clone());i.push(l.copy(this.points[b]).clone())}this.points=
i}};THREE.Edge=function(a,b,c,e){this.vertices=[a,b];this.vertexIndices=[c,e];this.faces=[];this.faceIndices=[]};THREE.Camera=function(){if(arguments.length)return console.warn("DEPRECATED: Camera() is now PerspectiveCamera() or OrthographicCamera()."),new THREE.PerspectiveCamera(arguments[0],arguments[1],arguments[2],arguments[3]);THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};
THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,e,f,g){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=e;this.near=f!==void 0?f:0.1;this.far=g!==void 0?g:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;
THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,e){THREE.Camera.call(this);this.fov=a!==void 0?a:50;this.aspect=b!==void 0?b:1;this.near=c!==void 0?c:0.1;this.far=e!==void 0?e:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;
THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((b!==void 0?b:43.25)/(a*2));this.fov*=180/Math.PI;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,e,f,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=e;this.width=f;this.height=g;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,e=a*c,a=Math.abs(a*b-e),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(e+this.x*a/this.fullWidth,e+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.PointLight.prototype=new THREE.Light;
THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.SpotLight=function(a,b,c,e){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0;this.castShadow=e!==void 0?e:!1};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(a){this.name="";this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0;this.overdraw=a.overdraw!==void 0?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=
a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=
a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.metal=a.metal!==void 0?a.metal:!1;this.perPixel=a.perPixel!==void 0?a.perPixel:!1;this.map=a.map!==void 0?a.map:null;this.lightMap=
a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=
a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){console.warn("DEPRECATED: MeshShaderMaterial() is now ShaderMaterial().");return new THREE.ShaderMaterial(a)};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ShaderMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.fragmentShader=a.fragmentShader!==void 0?a.fragmentShader:"void main() {}";this.vertexShader=a.vertexShader!==void 0?a.vertexShader:"void main() {}";this.uniforms=a.uniforms!==void 0?a.uniforms:{};this.attributes=a.attributes;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.fog=a.fog!==
void 0?a.fog:!1;this.lights=a.lights!==void 0?a.lights:!1;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.ShaderMaterial.prototype=new THREE.Material;THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.Texture=function(a,b,c,e,f,g){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=e!==void 0?e:THREE.ClampToEdgeWrapping;this.magFilter=f!==void 0?f:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1;this.onUpdate=null};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,e,f,g,h,i,n){THREE.Texture.call(this,null,f,g,h,i,n);this.image={data:a,width:b,height:c};this.format=e!==void 0?e:THREE.RGBAFormat};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.data.slice(0),this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.sortParticles=!1};
THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.type=c!==void 0?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;if(b instanceof Array)console.warn("DEPRECATED: Mesh material can no longer be an Array. Using material at index 0..."),this.material=b[0];if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};
for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,e=this.children.length;for(c=0;c<e;c++)this.children[c].update(this.skinMatrix,b)};
THREE.SkinnedMesh=function(a,b){THREE.Mesh.call(this,a,b);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,e,f,g,h,i;if(this.geometry.bones!==void 0){for(c=0;c<this.geometry.bones.length;c++)f=this.geometry.bones[c],g=f.pos,h=f.rotq,i=f.scl,e=this.addBone(),e.name=f.name,e.position.set(g[0],g[1],g[2]),e.quaternion.set(h[0],h[1],h[2],h[3]),e.useQuaternion=!0,i!==void 0?e.scale.set(i[0],i[1],i[2]):e.scale.set(1,1,1);for(c=0;c<this.bones.length;c++)f=this.geometry.bones[c],
e=this.bones[c],f.parent===-1?this.add(e):this.bones[f.parent].add(e);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;THREE.SkinnedMesh.prototype.addBone=function(a){a===void 0&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1;for(var a=0,b=this.children.length;a<b;a++){var c=this.children[a];c instanceof THREE.Bone?c.update(this.identityMatrix,!1):c.updateMatrixWorld(!0)}for(var b=this.bones.length,c=this.bones,e=this.boneMatrices,a=0;a<b;a++)c[a].skinMatrix.flattenToArrayOffset(e,
a*16)};
THREE.SkinnedMesh.prototype.pose=function(){this.updateMatrixWorld(!0);for(var a,b=[],c=0;c<this.bones.length;c++){a=this.bones[c];var e=new THREE.Matrix4;e.getInverse(a.skinMatrix);b.push(e);a.skinMatrix.flattenToArrayOffset(this.boneMatrices,c*16)}if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];for(a=0;a<this.geometry.skinIndices.length;a++){var c=this.geometry.vertices[a].position,f=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y,e=
new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(b[f].multiplyVector3(e));e=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(b[g].multiplyVector3(e));this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y!==1&&(c=(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y))*0.5,this.geometry.skinWeights[a].x+=c,this.geometry.skinWeights[a].y+=c)}}};THREE.Ribbon=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.addLevel=function(a,b){b===void 0&&(b=0);for(var b=Math.abs(b),c=0;c<this.LODs.length;c++)if(b<this.LODs[c].visibleAtDistance)break;this.LODs.splice(c,0,{visibleAtDistance:b,object3D:a});this.add(a)};
THREE.LOD.prototype.update=function(a){if(this.LODs.length>1){a.matrixWorldInverse.getInverse(a.matrixWorld);a=a.matrixWorldInverse;a=-(a.n31*this.position.x+a.n32*this.position.y+a.n33*this.position.z+a.n34);this.LODs[0].object3D.visible=!0;for(var b=1;b<this.LODs.length;b++)if(a>=this.LODs[b].visibleAtDistance)this.LODs[b-1].object3D.visible=!1,this.LODs[b].object3D.visible=!0;else break;for(;b<this.LODs.length;b++)this.LODs[b].object3D.visible=!1}};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map instanceof THREE.Texture?a.map:THREE.ImageUtils.loadTexture(a.map);this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.useScreenCoordinates=a.useScreenCoordinates!==void 0?a.useScreenCoordinates:!0;this.mergeWith3D=a.mergeWith3D!==void 0?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=a.affectedByDistance!==void 0?a.affectedByDistance:
!this.useScreenCoordinates;this.scaleByViewport=a.scaleByViewport!==void 0?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.addObject=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);b!==-1&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.addObject(a.children[b])};
THREE.Scene.prototype.removeObject=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),b!==-1&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.removeObject(a.children[b])};
THREE.Fog=function(a,b,c){this.color=new THREE.Color(a);this.near=b!==void 0?b:1;this.far=c!==void 0?c:1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=b!==void 0?b:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform float flipEnvMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\nif ( combine == 1 ) {\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity );\n} else {\ngl_FragColor.xyz = gl_FragColor.xyz * cubeColor.xyz;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( map, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_lambert_pars_vertex:"uniform vec3 ambient;\nuniform vec3 diffuse;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#endif",
lights_lambert_vertex:"vLightWeighting = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n}\n#endif\nvLightWeighting = vLightWeighting * diffuse + ambient * ambientLightColor;",
lights_phong_pars_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",lights_phong_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#endif",
lights_phong_pars_fragment:"uniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n#ifdef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#else\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",
lights_phong_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse  = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n#ifdef PHONG_PER_PIXEL\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz + vViewPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#else\nvec3 lVector = normalize( vPointLight[ i ].xyz );\nfloat lDistance = vPointLight[ i ].w;\n#endif\nvec3 pointHalfVector = normalize( lVector + viewPosition );\nfloat pointDistance = lDistance;\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointDiffuseWeight = max( dot( normal, lVector ), 0.0 );\nfloat pointSpecularWeight = pow( pointDotNormalHalf, shininess );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( lVector, pointHalfVector ), 5.0 );\npointSpecular += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * pointDistance;\n#else\npointSpecular += specular * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * pointDistance;\n#endif\npointDiffuse  += diffuse * pointLightColor[ i ] * pointDiffuseWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse  = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = pow( dirDotNormalHalf, shininess );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( dirVector, dirHalfVector ), 5.0 );\ndirSpecular += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#else\ndirSpecular += specular * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#endif\ndirDiffuse  += diffuse * directionalLightColor[ i ] * dirDiffuseWeight;\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\n#ifdef METAL\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient + totalSpecular );\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient ) + totalSpecular;\n#endif",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n#ifdef GAMMA_INPUT\nvColor = color * color;\n#else\nvColor = color;\n#endif\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform float shadowDarkness;\nuniform float shadowBias;\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_SOFT\nconst float xPixelOffset = 1.0 / SHADOWMAP_WIDTH;\nconst float yPixelOffset = 1.0 / SHADOWMAP_HEIGHT;\n#endif\nvec3 shadowColor = vec3( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nshadowCoord.z += shadowBias;\nif ( shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0 ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nfor ( float y = -1.25; y <= 1.25; y += 1.25 )\nfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\nvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < shadowCoord.z )\nshadow += 1.0;\n}\nshadow /= 9.0;\nshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness * shadow ) );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < shadowCoord.z )\nshadowColor = shadowColor * vec3( shadowDarkness );\n#endif\n}\n}\n#ifdef GAMMA_OUTPUT\nshadowColor *= shadowColor;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif",linear_to_gamma_fragment:"#ifdef GAMMA_OUTPUT\ngl_FragColor.xyz = sqrt( gl_FragColor.xyz );\n#endif"};
THREE.UniformsUtils={merge:function(a){var b,c,e,f={};for(b=0;b<a.length;b++)for(c in e=this.clone(a[b]),e)f[c]=e[c];return f},clone:function(a){var b,c,e,f={};for(b in a)for(c in f[b]={},a[b])e=a[b][c],f[b][c]=e instanceof THREE.Color||e instanceof THREE.Vector2||e instanceof THREE.Vector3||e instanceof THREE.Vector4||e instanceof THREE.Matrix4||e instanceof THREE.Texture?e.clone():e instanceof Array?e.slice():e;return f}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},flipEnvMap:{type:"f",value:-1},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",
value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:6,texture:[]},shadowMatrix:{type:"m4v",value:[]},shadowBias:{type:"f",value:0.0039},shadowDarkness:{type:"f",value:0.2}}};
THREE.ShaderLib={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"},
depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}"},normal:{uniforms:{opacity:{type:"f",value:1}},
vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}",fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),vertexShader:[THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)}}]),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_lambert_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",
THREE.ShaderChunk.lights_lambert_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",
THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor.xyz = gl_FragColor.xyz * vLightWeighting;",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",
value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),vertexShader:["varying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_phong_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;\nvec3 transformedNormal = normalMatrix * normal;\nvNormal = transformedNormal;",THREE.ShaderChunk.lights_phong_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,
"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_phong_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,
THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_phong_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,
THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,
THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},depthRGBA:{uniforms:{},vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,"}"].join("\n"),fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}"}};
THREE.WebGLRenderer=function(a){function b(a,b){var c=a.vertices.length,e=b.material;if(e.attributes){if(a.__webglCustomAttributesList===void 0)a.__webglCustomAttributesList=[];for(var g in e.attributes){var f=e.attributes[g];if(!f.__webglInitialized||f.createUniqueBuffers){f.__webglInitialized=!0;var z=1;f.type==="v2"?z=2:f.type==="v3"?z=3:f.type==="v4"?z=4:f.type==="c"&&(z=3);f.size=z;f.array=new Float32Array(c*z);f.buffer=d.createBuffer();f.buffer.belongsToAttribute=g;f.needsUpdate=!0}a.__webglCustomAttributesList.push(f)}}}
function c(a,b){if(a.material&&!(a.material instanceof THREE.MeshFaceMaterial))return a.material;else if(b.materialIndex>=0)return a.geometry.materials[b.materialIndex]}function e(a){if(a instanceof THREE.MeshBasicMaterial&&!a.envMap||a instanceof THREE.MeshDepthMaterial)return!1;return a&&a.shading!==void 0&&a.shading===THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading}function f(a){if(a.vertexColors)return a.vertexColors;return!1}function g(a){if(a.map||a.lightMap||a instanceof THREE.ShaderMaterial)return!0;
return!1}function h(a,b,c){var e,g,f,z,m=a.vertices;z=m.length;var h=a.colors,i=h.length,s=a.__vertexArray,w=a.__colorArray,j=a.__sortArray,q=a.__dirtyVertices,l=a.__dirtyColors,p=a.__webglCustomAttributesList;if(c.sortParticles){Ba.multiplySelf(c.matrixWorld);for(e=0;e<z;e++)g=m[e].position,Da.copy(g),Ba.multiplyVector3(Da),j[e]=[Da.z,e];j.sort(function(a,b){return b[0]-a[0]});for(e=0;e<z;e++)g=m[j[e][1]].position,f=e*3,s[f]=g.x,s[f+1]=g.y,s[f+2]=g.z;for(e=0;e<i;e++)f=e*3,g=h[j[e][1]],w[f]=g.r,w[f+
1]=g.g,w[f+2]=g.b;if(p){h=0;for(i=p.length;h<i;h++)if(m=p[h],m.boundTo===void 0||m.boundTo==="vertices")if(f=0,g=m.value.length,m.size===1)for(e=0;e<g;e++)z=j[e][1],m.array[e]=m.value[z];else if(m.size===2)for(e=0;e<g;e++)z=j[e][1],z=m.value[z],m.array[f]=z.x,m.array[f+1]=z.y,f+=2;else if(m.size===3)if(m.type==="c")for(e=0;e<g;e++)z=j[e][1],z=m.value[z],m.array[f]=z.r,m.array[f+1]=z.g,m.array[f+2]=z.b,f+=3;else for(e=0;e<g;e++)z=j[e][1],z=m.value[z],m.array[f]=z.x,m.array[f+1]=z.y,m.array[f+2]=z.z,
f+=3;else if(m.size===4)for(e=0;e<g;e++)z=j[e][1],z=m.value[z],m.array[f]=z.x,m.array[f+1]=z.y,m.array[f+2]=z.z,m.array[f+3]=z.w,f+=4}}else{if(q)for(e=0;e<z;e++)g=m[e].position,f=e*3,s[f]=g.x,s[f+1]=g.y,s[f+2]=g.z;if(l)for(e=0;e<i;e++)g=h[e],f=e*3,w[f]=g.r,w[f+1]=g.g,w[f+2]=g.b;if(p){h=0;for(i=p.length;h<i;h++)if(m=p[h],m.needsUpdate&&(m.boundTo===void 0||m.boundTo==="vertices"))if(g=m.value.length,f=0,m.size===1)for(e=0;e<g;e++)m.array[e]=m.value[e];else if(m.size===2)for(e=0;e<g;e++)z=m.value[e],
m.array[f]=z.x,m.array[f+1]=z.y,f+=2;else if(m.size===3)if(m.type==="c")for(e=0;e<g;e++)z=m.value[e],m.array[f]=z.r,m.array[f+1]=z.g,m.array[f+2]=z.b,f+=3;else for(e=0;e<g;e++)z=m.value[e],m.array[f]=z.x,m.array[f+1]=z.y,m.array[f+2]=z.z,f+=3;else if(m.size===4)for(e=0;e<g;e++)z=m.value[e],m.array[f]=z.x,m.array[f+1]=z.y,m.array[f+2]=z.z,m.array[f+3]=z.w,f+=4}}if(q||c.sortParticles)d.bindBuffer(d.ARRAY_BUFFER,a.__webglVertexBuffer),d.bufferData(d.ARRAY_BUFFER,s,b);if(l||c.sortParticles)d.bindBuffer(d.ARRAY_BUFFER,
a.__webglColorBuffer),d.bufferData(d.ARRAY_BUFFER,w,b);if(p){h=0;for(i=p.length;h<i;h++)if(m=p[h],m.needsUpdate||c.sortParticles)d.bindBuffer(d.ARRAY_BUFFER,m.buffer),d.bufferData(d.ARRAY_BUFFER,m.array,b)}}function i(a,b,c){if(!a.__webglVertexBuffer)a.__webglVertexBuffer=d.createBuffer();if(!a.__webglNormalBuffer)a.__webglNormalBuffer=d.createBuffer();a.hasPos&&(d.bindBuffer(d.ARRAY_BUFFER,a.__webglVertexBuffer),d.bufferData(d.ARRAY_BUFFER,a.positionArray,d.DYNAMIC_DRAW),d.enableVertexAttribArray(b.attributes.position),
d.vertexAttribPointer(b.attributes.position,3,d.FLOAT,!1,0,0));if(a.hasNormal){d.bindBuffer(d.ARRAY_BUFFER,a.__webglNormalBuffer);if(c===THREE.FlatShading){var e,f,g,h,m,u,i,s,w,j,q=a.count*3;for(j=0;j<q;j+=9)c=a.normalArray,e=c[j],f=c[j+1],g=c[j+2],h=c[j+3],u=c[j+4],s=c[j+5],m=c[j+6],i=c[j+7],w=c[j+8],e=(e+h+m)/3,f=(f+u+i)/3,g=(g+s+w)/3,c[j]=e,c[j+1]=f,c[j+2]=g,c[j+3]=e,c[j+4]=f,c[j+5]=g,c[j+6]=e,c[j+7]=f,c[j+8]=g}d.bufferData(d.ARRAY_BUFFER,a.normalArray,d.DYNAMIC_DRAW);d.enableVertexAttribArray(b.attributes.normal);
d.vertexAttribPointer(b.attributes.normal,3,d.FLOAT,!1,0,0)}d.drawArrays(d.TRIANGLES,0,a.count);a.count=0}function n(a,b,c,e,f,g){if(e.opacity!==0){var h,m,c=ja(a,b,c,e,g),b=c.attributes,a=!1,c=f.id*16777215+c.id*2+(e.wireframe?1:0);c!==ya&&(ya=c,a=!0);if(!e.morphTargets&&b.position>=0)a&&(d.bindBuffer(d.ARRAY_BUFFER,f.__webglVertexBuffer),d.vertexAttribPointer(b.position,3,d.FLOAT,!1,0,0));else if(g.morphTargetBase){c=e.program.attributes;g.morphTargetBase!==-1?(d.bindBuffer(d.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[g.morphTargetBase]),
d.vertexAttribPointer(c.position,3,d.FLOAT,!1,0,0)):c.position>=0&&(d.bindBuffer(d.ARRAY_BUFFER,f.__webglVertexBuffer),d.vertexAttribPointer(c.position,3,d.FLOAT,!1,0,0));if(g.morphTargetForcedOrder.length){h=0;var u=g.morphTargetForcedOrder;for(m=g.morphTargetInfluences;h<e.numSupportedMorphTargets&&h<u.length;)d.bindBuffer(d.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[u[h]]),d.vertexAttribPointer(c["morphTarget"+h],3,d.FLOAT,!1,0,0),g.__webglMorphTargetInfluences[h]=m[u[h]],h++}else{var u=[],i=-1,
s=0;m=g.morphTargetInfluences;var w,j=m.length;h=0;for(g.morphTargetBase!==-1&&(u[g.morphTargetBase]=!0);h<e.numSupportedMorphTargets;){for(w=0;w<j;w++)!u[w]&&m[w]>i&&(s=w,i=m[s]);d.bindBuffer(d.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[s]);d.vertexAttribPointer(c["morphTarget"+h],3,d.FLOAT,!1,0,0);g.__webglMorphTargetInfluences[h]=i;u[s]=1;i=-1;h++}}e.program.uniforms.morphTargetInfluences!==null&&d.uniform1fv(e.program.uniforms.morphTargetInfluences,g.__webglMorphTargetInfluences)}if(a){if(f.__webglCustomAttributesList){h=
0;for(m=f.__webglCustomAttributesList.length;h<m;h++)c=f.__webglCustomAttributesList[h],b[c.buffer.belongsToAttribute]>=0&&(d.bindBuffer(d.ARRAY_BUFFER,c.buffer),d.vertexAttribPointer(b[c.buffer.belongsToAttribute],c.size,d.FLOAT,!1,0,0))}b.color>=0&&(d.bindBuffer(d.ARRAY_BUFFER,f.__webglColorBuffer),d.vertexAttribPointer(b.color,3,d.FLOAT,!1,0,0));b.normal>=0&&(d.bindBuffer(d.ARRAY_BUFFER,f.__webglNormalBuffer),d.vertexAttribPointer(b.normal,3,d.FLOAT,!1,0,0));b.tangent>=0&&(d.bindBuffer(d.ARRAY_BUFFER,
f.__webglTangentBuffer),d.vertexAttribPointer(b.tangent,4,d.FLOAT,!1,0,0));b.uv>=0&&(f.__webglUVBuffer?(d.bindBuffer(d.ARRAY_BUFFER,f.__webglUVBuffer),d.vertexAttribPointer(b.uv,2,d.FLOAT,!1,0,0),d.enableVertexAttribArray(b.uv)):d.disableVertexAttribArray(b.uv));b.uv2>=0&&(f.__webglUV2Buffer?(d.bindBuffer(d.ARRAY_BUFFER,f.__webglUV2Buffer),d.vertexAttribPointer(b.uv2,2,d.FLOAT,!1,0,0),d.enableVertexAttribArray(b.uv2)):d.disableVertexAttribArray(b.uv2));e.skinning&&b.skinVertexA>=0&&b.skinVertexB>=
0&&b.skinIndex>=0&&b.skinWeight>=0&&(d.bindBuffer(d.ARRAY_BUFFER,f.__webglSkinVertexABuffer),d.vertexAttribPointer(b.skinVertexA,4,d.FLOAT,!1,0,0),d.bindBuffer(d.ARRAY_BUFFER,f.__webglSkinVertexBBuffer),d.vertexAttribPointer(b.skinVertexB,4,d.FLOAT,!1,0,0),d.bindBuffer(d.ARRAY_BUFFER,f.__webglSkinIndicesBuffer),d.vertexAttribPointer(b.skinIndex,4,d.FLOAT,!1,0,0),d.bindBuffer(d.ARRAY_BUFFER,f.__webglSkinWeightsBuffer),d.vertexAttribPointer(b.skinWeight,4,d.FLOAT,!1,0,0))}g instanceof THREE.Mesh?(e.wireframe?
(e=e.wireframeLinewidth,e!==Ia&&(d.lineWidth(e),Ia=e),a&&d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,f.__webglLineBuffer),d.drawElements(d.LINES,f.__webglLineCount,d.UNSIGNED_SHORT,0)):(a&&d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,f.__webglFaceBuffer),d.drawElements(d.TRIANGLES,f.__webglFaceCount,d.UNSIGNED_SHORT,0)),G.info.render.calls++,G.info.render.vertices+=f.__webglFaceCount,G.info.render.faces+=f.__webglFaceCount/3):g instanceof THREE.Line?(g=g.type===THREE.LineStrip?d.LINE_STRIP:d.LINES,e=e.linewidth,e!==
Ia&&(d.lineWidth(e),Ia=e),d.drawArrays(g,0,f.__webglLineCount),G.info.render.calls++):g instanceof THREE.ParticleSystem?(d.drawArrays(d.POINTS,0,f.__webglParticleCount),G.info.render.calls++):g instanceof THREE.Ribbon&&(d.drawArrays(d.TRIANGLE_STRIP,0,f.__webglVertexCount),G.info.render.calls++)}}function k(a){qa[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);qa[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);qa[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);qa[3].set(a.n41-
a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);qa[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);qa[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(var b,a=0;a<6;a++)b=qa[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))}function l(a){for(var b=a.matrixWorld,d=-a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)),c=0;c<6;c++)if(a=qa[c].x*b.n14+qa[c].y*b.n24+qa[c].z*b.n34+qa[c].w,a<=d)return!1;return!0}function p(a,b){return b.z-a.z}function A(a){var b,
c,e,f,g,h,m,u,p=0,s=a.lights;ua||(ua=new THREE.PerspectiveCamera(G.shadowCameraFov,G.shadowMapWidth/G.shadowMapHeight,G.shadowCameraNear,G.shadowCameraFar));b=0;for(c=s.length;b<c;b++)if(u=s[b],u.castShadow&&u instanceof THREE.SpotLight){Aa=-1;G.shadowMap[p]||(G.shadowMap[p]=new THREE.WebGLRenderTarget(G.shadowMapWidth,G.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat}),Ja[p]=new THREE.Matrix4);e=G.shadowMap[p];f=Ja[p];ua.position.copy(u.position);
ua.lookAt(u.target.position);ua.parent==null&&(console.warn("Camera is not on the Scene. Adding it..."),a.add(ua),this.autoUpdateScene&&a.updateMatrixWorld());ua.matrixWorldInverse.getInverse(ua.matrixWorld);f.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);f.multiplySelf(ua.projectionMatrix);f.multiplySelf(ua.matrixWorldInverse);ua.matrixWorldInverse.flattenToArray(Ka);ua.projectionMatrix.flattenToArray(La);Ba.multiply(ua.projectionMatrix,ua.matrixWorldInverse);k(Ba);ra(e);d.clearColor(1,1,1,1);
G.clear();d.clearColor(J.r,J.g,J.b,O);f=a.__webglObjects.length;for(e=0;e<f;e++)if(h=a.__webglObjects[e],u=h.object,h.render=!1,u.visible&&u.castShadow&&(!(u instanceof THREE.Mesh)||!u.frustumCulled||l(u)))u.matrixWorld.flattenToArray(u._objectMatrixArray),ga(u,ua,!1),h.render=!0;S(!0);ca(THREE.NormalBlending);for(e=0;e<f;e++)if(h=a.__webglObjects[e],h.render)u=h.object,h=h.buffer,L(u),m=u.customDepthMaterial?u.customDepthMaterial:u.geometry.morphTargets.length?Ma:Ga,n(ua,s,null,m,h,u);f=a.__webglObjectsImmediate.length;
for(e=0;e<f;e++)h=a.__webglObjectsImmediate[e],u=h.object,u.visible&&u.castShadow&&(u.matrixAutoUpdate&&u.matrixWorld.flattenToArray(u._objectMatrixArray),ya=-1,ga(u,ua,!1),L(u),g=ja(ua,s,null,Ga,u),u.immediateRenderCallback?u.immediateRenderCallback(g,d,qa):u.render(function(a){i(a,g,Ga.shading)}));p++}}function r(a,b,d,c,e,f,g,h){var u,i,s,w;b?(i=a.length-1,w=b=-1):(i=0,b=a.length,w=1);for(var j=i;j!==b;j+=w)if(u=a[j],u.render){i=u.object;s=u.buffer;if(h)u=h;else{u=u[d];if(!u)continue;g&&ca(u.blending);
S(u.depthTest);F(u.depthWrite);N(u.polygonOffset,u.polygonOffsetFactor,u.polygonOffsetUnits)}L(i);n(c,e,f,u,s,i)}}function y(a,b,c,e,f,g,h){for(var m,u,p,s,w=0,j=a.length;w<j;w++)if(m=a[w],u=m.object,u.visible){ya=-1;if(h)p=h;else{p=m[b];if(!p)continue;g&&ca(p.blending);S(p.depthTest);F(p.depthWrite);N(p.polygonOffset,p.polygonOffsetFactor,p.polygonOffsetUnits)}L(u);s=ja(c,e,f,p,u);u.immediateRenderCallback?u.immediateRenderCallback(s,d,qa):u.render(function(a){i(a,s,p.shading)})}}function I(a,b,
d){a.push({buffer:b,object:d,opaque:null,transparent:null})}function R(a){for(var b in a.attributes)if(a.attributes[b].needsUpdate)return!0;return!1}function va(a){for(var b in a.attributes)a.attributes[b].needsUpdate=!1}function ha(a,b){for(var d=a.length-1;d>=0;d--)a[d].object===b&&a.splice(d,1)}function ja(a,b,c,e,f){e.program||G.initMaterial(e,b,c,f);if(e.morphTargets&&!f.__webglMorphTargetInfluences){f.__webglMorphTargetInfluences=new Float32Array(G.maxMorphTargets);for(var g=0,h=G.maxMorphTargets;g<
h;g++)f.__webglMorphTargetInfluences[g]=0}var m=!1,g=e.program,h=g.uniforms,u=e.uniforms;g!==xa&&(d.useProgram(g),xa=g,m=!0);if(e.id!==Aa)Aa=e.id,m=!0;if(m){d.uniformMatrix4fv(h.projectionMatrix,!1,La);if(c&&e.fog)if(u.fogColor.value=c.color,c instanceof THREE.Fog)u.fogNear.value=c.near,u.fogFar.value=c.far;else if(c instanceof THREE.FogExp2)u.fogDensity.value=c.density;if(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e.lights){for(var i,s,w=0,j=0,q=0,p,l,n,k=Sa,r=
k.directional.colors,A=k.directional.positions,v=k.point.colors,B=k.point.positions,I=k.point.distances,x=0,y=0,c=i=n=0,m=b.length;c<m;c++)if(i=b[c],s=i.color,p=i.position,l=i.intensity,n=i.distance,i instanceof THREE.AmbientLight)G.gammaInput?(w+=s.r*s.r,j+=s.g*s.g,q+=s.b*s.b):(w+=s.r,j+=s.g,q+=s.b);else if(i instanceof THREE.DirectionalLight)n=x*3,G.gammaInput?(r[n]=s.r*s.r*l*l,r[n+1]=s.g*s.g*l*l,r[n+2]=s.b*s.b*l*l):(r[n]=s.r*l,r[n+1]=s.g*l,r[n+2]=s.b*l),A[n]=p.x,A[n+1]=p.y,A[n+2]=p.z,x+=1;else if(i instanceof
THREE.SpotLight)n=x*3,G.gammaInput?(r[n]=s.r*s.r*l*l,r[n+1]=s.g*s.g*l*l,r[n+2]=s.b*s.b*l*l):(r[n]=s.r*l,r[n+1]=s.g*l,r[n+2]=s.b*l),s=1/p.length(),A[n]=p.x*s,A[n+1]=p.y*s,A[n+2]=p.z*s,x+=1;else if(i instanceof THREE.PointLight)i=y*3,G.gammaInput?(v[i]=s.r*s.r*l*l,v[i+1]=s.g*s.g*l*l,v[i+2]=s.b*s.b*l*l):(v[i]=s.r*l,v[i+1]=s.g*l,v[i+2]=s.b*l),B[i]=p.x,B[i+1]=p.y,B[i+2]=p.z,I[y]=n,y+=1;c=x*3;for(m=r.length;c<m;c++)r[c]=0;c=y*3;for(m=v.length;c<m;c++)v[c]=0;k.point.length=y;k.directional.length=x;k.ambient[0]=
w;k.ambient[1]=j;k.ambient[2]=q;b=Sa;u.ambientLightColor.value=b.ambient;u.directionalLightColor.value=b.directional.colors;u.directionalLightDirection.value=b.directional.positions;u.pointLightColor.value=b.point.colors;u.pointLightPosition.value=b.point.positions;u.pointLightDistance.value=b.point.distances}if(e instanceof THREE.MeshBasicMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshPhongMaterial)u.opacity.value=e.opacity,G.gammaInput?u.diffuse.value.copyGammaToLinear(e.color):
u.diffuse.value=e.color,(u.map.texture=e.map)&&u.offsetRepeat.value.set(e.map.offset.x,e.map.offset.y,e.map.repeat.x,e.map.repeat.y),u.lightMap.texture=e.lightMap,u.envMap.texture=e.envMap,u.flipEnvMap.value=e.envMap instanceof THREE.WebGLRenderTargetCube?1:-1,u.reflectivity.value=e.reflectivity,u.refractionRatio.value=e.refractionRatio,u.combine.value=e.combine,u.useRefract.value=e.envMap&&e.envMap.mapping instanceof THREE.CubeRefractionMapping;if(e instanceof THREE.LineBasicMaterial)u.diffuse.value=
e.color,u.opacity.value=e.opacity;else if(e instanceof THREE.ParticleBasicMaterial)u.psColor.value=e.color,u.opacity.value=e.opacity,u.size.value=e.size,u.scale.value=sa.height/2,u.map.texture=e.map;else if(e instanceof THREE.MeshPhongMaterial)u.shininess.value=e.shininess,G.gammaInput?(u.ambient.value.copyGammaToLinear(e.ambient),u.specular.value.copyGammaToLinear(e.specular)):(u.ambient.value=e.ambient,u.specular.value=e.specular);else if(e instanceof THREE.MeshLambertMaterial)G.gammaInput?u.ambient.value.copyGammaToLinear(e.ambient):
u.ambient.value=e.ambient;else if(e instanceof THREE.MeshDepthMaterial)u.mNear.value=a.near,u.mFar.value=a.far,u.opacity.value=e.opacity;else if(e instanceof THREE.MeshNormalMaterial)u.opacity.value=e.opacity;if(f.receiveShadow&&!e._shadowPass&&u.shadowMatrix){for(b=0;b<Ja.length;b++)u.shadowMatrix.value[b]=Ja[b],u.shadowMap.texture[b]=G.shadowMap[b];u.shadowDarkness.value=G.shadowMapDarkness;u.shadowBias.value=G.shadowMapBias}b=e.uniformsList;u=0;for(c=b.length;u<c;u++)if(j=g.uniforms[b[u][1]])if(w=
b[u][0],q=w.type,m=w.value,q==="i")d.uniform1i(j,m);else if(q==="f")d.uniform1f(j,m);else if(q==="v2")d.uniform2f(j,m.x,m.y);else if(q==="v3")d.uniform3f(j,m.x,m.y,m.z);else if(q==="v4")d.uniform4f(j,m.x,m.y,m.z,m.w);else if(q==="c")d.uniform3f(j,m.r,m.g,m.b);else if(q==="fv1")d.uniform1fv(j,m);else if(q==="fv")d.uniform3fv(j,m);else if(q==="v3v"){if(!w._array)w._array=new Float32Array(3*m.length);q=0;for(p=m.length;q<p;q++)k=q*3,w._array[k]=m[q].x,w._array[k+1]=m[q].y,w._array[k+2]=m[q].z;d.uniform3fv(j,
w._array)}else if(q==="m4"){if(!w._array)w._array=new Float32Array(16);m.flattenToArray(w._array);d.uniformMatrix4fv(j,!1,w._array)}else if(q==="m4v"){if(!w._array)w._array=new Float32Array(16*m.length);q=0;for(p=m.length;q<p;q++)m[q].flattenToArrayOffset(w._array,q*16);d.uniformMatrix4fv(j,!1,w._array)}else if(q==="t"){if(d.uniform1i(j,m),j=w.texture)if(j.image instanceof Array&&j.image.length===6){if(w=j,w.image.length===6)if(w.needsUpdate){if(!w.image.__webglTextureCube)w.image.__webglTextureCube=
d.createTexture();d.activeTexture(d.TEXTURE0+m);d.bindTexture(d.TEXTURE_CUBE_MAP,w.image.__webglTextureCube);m=W(d.TEXTURE_CUBE_MAP,w,w.image[0]);for(j=0;j<6;j++)d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+j,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,w.image[j]);m&&d.generateMipmap(d.TEXTURE_CUBE_MAP);w.needsUpdate=!1}else d.activeTexture(d.TEXTURE0+m),d.bindTexture(d.TEXTURE_CUBE_MAP,w.image.__webglTextureCube)}else j instanceof THREE.WebGLRenderTargetCube?(w=j,d.activeTexture(d.TEXTURE0+m),d.bindTexture(d.TEXTURE_CUBE_MAP,
w.__webglTexture)):la(j,m)}else if(q==="tv"){if(!w._array){w._array=[];q=0;for(p=w.texture.length;q<p;q++)w._array[q]=m+q}d.uniform1iv(j,w._array);q=0;for(p=w.texture.length;q<p;q++)(j=w.texture[q])&&la(j,w._array[q])}(e instanceof THREE.ShaderMaterial||e instanceof THREE.MeshPhongMaterial||e.envMap)&&h.cameraPosition!==null&&d.uniform3f(h.cameraPosition,a.position.x,a.position.y,a.position.z);(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.ShaderMaterial||
e.skinning)&&h.viewMatrix!==null&&d.uniformMatrix4fv(h.viewMatrix,!1,Ka);e.skinning&&(d.uniformMatrix4fv(h.cameraInverseMatrix,!1,Ka),d.uniformMatrix4fv(h.boneGlobalMatrices,!1,f.boneMatrices))}d.uniformMatrix4fv(h.modelViewMatrix,!1,f._modelViewMatrixArray);h.normalMatrix&&d.uniformMatrix3fv(h.normalMatrix,!1,f._normalMatrixArray);(e instanceof THREE.ShaderMaterial||e.envMap||e.skinning||f.receiveShadow)&&h.objectMatrix!==null&&d.uniformMatrix4fv(h.objectMatrix,!1,f._objectMatrixArray);return g}
function ga(a,b,c){a._modelViewMatrix.multiplyToArray(b.matrixWorldInverse,a.matrixWorld,a._modelViewMatrixArray);c&&THREE.Matrix4.makeInvert3x3(a._modelViewMatrix).transposeIntoArray(a._normalMatrixArray)}function L(a){if(za!==a.doubleSided)a.doubleSided?d.disable(d.CULL_FACE):d.enable(d.CULL_FACE),za=a.doubleSided;if(Ta!==a.flipSided)a.flipSided?d.frontFace(d.CW):d.frontFace(d.CCW),Ta=a.flipSided}function S(a){Na!==a&&(a?d.enable(d.DEPTH_TEST):d.disable(d.DEPTH_TEST),Na=a)}function F(a){Oa!==a&&
(d.depthMask(a),Oa=a)}function N(a,b,c){Ua!==a&&(a?d.enable(d.POLYGON_OFFSET_FILL):d.disable(d.POLYGON_OFFSET_FILL),Ua=a);if(a&&(Va!==b||Wa!==c))d.polygonOffset(b,c),Va=b,Wa=c}function ca(a){if(a!==Pa){switch(a){case THREE.AdditiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.SRC_ALPHA,d.ONE);break;case THREE.SubtractiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ZERO,d.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ZERO,d.SRC_COLOR);break;
default:d.blendEquationSeparate(d.FUNC_ADD,d.FUNC_ADD),d.blendFuncSeparate(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA,d.ONE,d.ONE_MINUS_SRC_ALPHA)}Pa=a}}function M(a,b){var c;a==="fragment"?c=d.createShader(d.FRAGMENT_SHADER):a==="vertex"&&(c=d.createShader(d.VERTEX_SHADER));d.shaderSource(c,b);d.compileShader(c);if(!d.getShaderParameter(c,d.COMPILE_STATUS))return console.error(d.getShaderInfoLog(c)),console.error(b),null;return c}function W(a,b,c){return(c.width&c.width-1)===0&&(c.height&c.height-1)===0?
(d.texParameteri(a,d.TEXTURE_WRAP_S,Q(b.wrapS)),d.texParameteri(a,d.TEXTURE_WRAP_T,Q(b.wrapT)),d.texParameteri(a,d.TEXTURE_MAG_FILTER,Q(b.magFilter)),d.texParameteri(a,d.TEXTURE_MIN_FILTER,Q(b.minFilter)),!0):(d.texParameteri(a,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE),d.texParameteri(a,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE),d.texParameteri(a,d.TEXTURE_MAG_FILTER,wa(b.magFilter)),d.texParameteri(a,d.TEXTURE_MIN_FILTER,wa(b.minFilter)),!1)}function la(a,b){if(a.needsUpdate){if(!a.__webglInit)a.__webglInit=!0,a.__webglTexture=
d.createTexture(),G.info.memory.textures++;d.activeTexture(d.TEXTURE0+b);d.bindTexture(d.TEXTURE_2D,a.__webglTexture);var c=W(d.TEXTURE_2D,a,a.image);a instanceof THREE.DataTexture?d.texImage2D(d.TEXTURE_2D,0,Q(a.format),a.image.width,a.image.height,0,Q(a.format),d.UNSIGNED_BYTE,a.image.data):d.texImage2D(d.TEXTURE_2D,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,a.image);c&&d.generateMipmap(d.TEXTURE_2D);a.needsUpdate=!1;if(a.onUpdated)a.onUpdated()}else d.activeTexture(d.TEXTURE0+b),d.bindTexture(d.TEXTURE_2D,
a.__webglTexture)}function oa(a,b){d.bindRenderbuffer(d.RENDERBUFFER,a);b.depthBuffer&&!b.stencilBuffer?(d.renderbufferStorage(d.RENDERBUFFER,d.DEPTH_COMPONENT16,b.width,b.height),d.framebufferRenderbuffer(d.FRAMEBUFFER,d.DEPTH_ATTACHMENT,d.RENDERBUFFER,a)):b.depthBuffer&&b.stencilBuffer?(d.renderbufferStorage(d.RENDERBUFFER,d.DEPTH_STENCIL,b.width,b.height),d.framebufferRenderbuffer(d.FRAMEBUFFER,d.DEPTH_STENCIL_ATTACHMENT,d.RENDERBUFFER,a)):d.renderbufferStorage(d.RENDERBUFFER,d.RGBA4,b.width,b.height)}
function ra(a){var b=a instanceof THREE.WebGLRenderTargetCube;if(a&&!a.__webglFramebuffer){if(a.depthBuffer===void 0)a.depthBuffer=!0;if(a.stencilBuffer===void 0)a.stencilBuffer=!0;a.__webglTexture=d.createTexture();if(b){a.__webglFramebuffer=[];a.__webglRenderbuffer=[];d.bindTexture(d.TEXTURE_CUBE_MAP,a.__webglTexture);W(d.TEXTURE_CUBE_MAP,a,a);for(var c=0;c<6;c++){a.__webglFramebuffer[c]=d.createFramebuffer();a.__webglRenderbuffer[c]=d.createRenderbuffer();d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+
c,0,Q(a.format),a.width,a.height,0,Q(a.format),Q(a.type),null);var e=a,f=d.TEXTURE_CUBE_MAP_POSITIVE_X+c;d.bindFramebuffer(d.FRAMEBUFFER,a.__webglFramebuffer[c]);d.framebufferTexture2D(d.FRAMEBUFFER,d.COLOR_ATTACHMENT0,f,e.__webglTexture,0);oa(a.__webglRenderbuffer[c],a)}}else a.__webglFramebuffer=d.createFramebuffer(),a.__webglRenderbuffer=d.createRenderbuffer(),d.bindTexture(d.TEXTURE_2D,a.__webglTexture),W(d.TEXTURE_2D,a,a),d.texImage2D(d.TEXTURE_2D,0,Q(a.format),a.width,a.height,0,Q(a.format),
Q(a.type),null),c=d.TEXTURE_2D,d.bindFramebuffer(d.FRAMEBUFFER,a.__webglFramebuffer),d.framebufferTexture2D(d.FRAMEBUFFER,d.COLOR_ATTACHMENT0,c,a.__webglTexture,0),oa(a.__webglRenderbuffer,a);b?d.bindTexture(d.TEXTURE_CUBE_MAP,null):d.bindTexture(d.TEXTURE_2D,null);d.bindRenderbuffer(d.RENDERBUFFER,null);d.bindFramebuffer(d.FRAMEBUFFER,null)}a?(b=b?a.__webglFramebuffer[a.activeCubeFace]:a.__webglFramebuffer,c=a.width,a=a.height,f=e=0):(b=null,c=Ha,a=Ea,e=Qa,f=Ra);b!==Ca&&(d.bindFramebuffer(d.FRAMEBUFFER,
b),d.viewport(e,f,c,a),Ca=b)}function wa(a){switch(a){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return d.NEAREST;default:return d.LINEAR}}function Q(a){switch(a){case THREE.RepeatWrapping:return d.REPEAT;case THREE.ClampToEdgeWrapping:return d.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return d.MIRRORED_REPEAT;case THREE.NearestFilter:return d.NEAREST;case THREE.NearestMipMapNearestFilter:return d.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return d.NEAREST_MIPMAP_LINEAR;
case THREE.LinearFilter:return d.LINEAR;case THREE.LinearMipMapNearestFilter:return d.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return d.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return d.BYTE;case THREE.UnsignedByteType:return d.UNSIGNED_BYTE;case THREE.ShortType:return d.SHORT;case THREE.UnsignedShortType:return d.UNSIGNED_SHORT;case THREE.IntType:return d.INT;case THREE.UnsignedShortType:return d.UNSIGNED_INT;case THREE.FloatType:return d.FLOAT;case THREE.AlphaFormat:return d.ALPHA;
case THREE.RGBFormat:return d.RGB;case THREE.RGBAFormat:return d.RGBA;case THREE.LuminanceFormat:return d.LUMINANCE;case THREE.LuminanceAlphaFormat:return d.LUMINANCE_ALPHA}return 0}var a=a||{},sa=a.canvas!==void 0?a.canvas:document.createElement("canvas"),Za=a.precision!==void 0?a.precision:"highp",pa=a.antialias!==void 0?a.antialias:!1,ma=a.stencil!==void 0?a.stencil:!0,na=a.preserveDrawingBuffer!==void 0?a.preserveDrawingBuffer:!1,J=a.clearColor!==void 0?new THREE.Color(a.clearColor):new THREE.Color(0),
O=a.clearAlpha!==void 0?a.clearAlpha:0,Y=a.maxLights!==void 0?a.maxLights:4;this.domElement=sa;this.context=null;this.autoUpdateScene=this.autoUpdateObjects=this.sortObjects=this.autoClearStencil=this.autoClearDepth=this.autoClearColor=this.autoClear=!0;this.physicallyBasedShading=this.gammaOutput=this.gammaInput=!1;this.shadowMapBias=0.0039;this.shadowMapDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCameraNear=1;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowMap=
[];this.shadowMapEnabled=!1;this.shadowMapSoft=this.shadowMapAutoUpdate=!0;this.maxMorphTargets=8;this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0}};var G=this,d,ta=[],xa=null,Ca=null,Aa=-1,ya=null,Fa=0,za=null,Ta=null,Pa=null,Na=null,Oa=null,Ua=null,Va=null,Wa=null,Ia=null,Qa=0,Ra=0,Ha=0,Ea=0,qa=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Ba=new THREE.Matrix4,La=new Float32Array(16),Ka=new Float32Array(16),
Da=new THREE.Vector4,Sa={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},ua,Ja=[],Ga,Ma,B={},Xa=!1;d=function(){var a;try{if(!(a=sa.getContext("experimental-webgl",{antialias:pa,stencil:ma,preserveDrawingBuffer:na})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+a.getParameter(a.VERSION)+" | "+a.getParameter(a.VENDOR)+" | "+a.getParameter(a.RENDERER)+" | "+a.getParameter(a.SHADING_LANGUAGE_VERSION))}catch(b){console.error(b)}return a}();
d.clearColor(0,0,0,1);d.clearDepth(1);d.clearStencil(0);d.enable(d.DEPTH_TEST);d.depthFunc(d.LEQUAL);d.frontFace(d.CCW);d.cullFace(d.BACK);d.enable(d.CULL_FACE);d.enable(d.BLEND);d.blendEquation(d.FUNC_ADD);d.blendFunc(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA);d.clearColor(J.r,J.g,J.b,O);(function(){B.vertices=new Float32Array(16);B.faces=new Uint16Array(6);var a=0;B.vertices[a++]=-1;B.vertices[a++]=-1;B.vertices[a++]=0;B.vertices[a++]=1;B.vertices[a++]=1;B.vertices[a++]=-1;B.vertices[a++]=1;B.vertices[a++]=
1;B.vertices[a++]=1;B.vertices[a++]=1;B.vertices[a++]=1;B.vertices[a++]=0;B.vertices[a++]=-1;B.vertices[a++]=1;B.vertices[a++]=0;a=B.vertices[a++]=0;B.faces[a++]=0;B.faces[a++]=1;B.faces[a++]=2;B.faces[a++]=0;B.faces[a++]=2;B.faces[a++]=3;B.vertexBuffer=d.createBuffer();B.elementBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,B.vertexBuffer);d.bufferData(d.ARRAY_BUFFER,B.vertices,d.STATIC_DRAW);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,B.elementBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,B.faces,d.STATIC_DRAW);
B.program=d.createProgram();d.attachShader(B.program,M("fragment",THREE.ShaderLib.sprite.fragmentShader));d.attachShader(B.program,M("vertex",THREE.ShaderLib.sprite.vertexShader));d.linkProgram(B.program);B.attributes={};B.uniforms={};B.attributes.position=d.getAttribLocation(B.program,"position");B.attributes.uv=d.getAttribLocation(B.program,"uv");B.uniforms.uvOffset=d.getUniformLocation(B.program,"uvOffset");B.uniforms.uvScale=d.getUniformLocation(B.program,"uvScale");B.uniforms.rotation=d.getUniformLocation(B.program,
"rotation");B.uniforms.scale=d.getUniformLocation(B.program,"scale");B.uniforms.alignment=d.getUniformLocation(B.program,"alignment");B.uniforms.color=d.getUniformLocation(B.program,"color");B.uniforms.map=d.getUniformLocation(B.program,"map");B.uniforms.opacity=d.getUniformLocation(B.program,"opacity");B.uniforms.useScreenCoordinates=d.getUniformLocation(B.program,"useScreenCoordinates");B.uniforms.affectedByDistance=d.getUniformLocation(B.program,"affectedByDistance");B.uniforms.screenPosition=
d.getUniformLocation(B.program,"screenPosition");B.uniforms.modelViewMatrix=d.getUniformLocation(B.program,"modelViewMatrix");B.uniforms.projectionMatrix=d.getUniformLocation(B.program,"projectionMatrix")})();(function(){var a=THREE.ShaderLib.depthRGBA,b=THREE.UniformsUtils.clone(a.uniforms);Ga=new THREE.ShaderMaterial({fragmentShader:a.fragmentShader,vertexShader:a.vertexShader,uniforms:b});Ma=new THREE.ShaderMaterial({fragmentShader:a.fragmentShader,vertexShader:a.vertexShader,uniforms:b,morphTargets:!0});
Ga._shadowPass=!0;Ma._shadowPass=!0})();this.context=d;var Ya=d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0;this.getContext=function(){return d};this.supportsVertexTextures=function(){return Ya};this.setSize=function(a,b){sa.width=a;sa.height=b;this.setViewport(0,0,sa.width,sa.height)};this.setViewport=function(a,b,c,e){Qa=a;Ra=b;Ha=c;Ea=e;d.viewport(Qa,Ra,Ha,Ea)};this.setScissor=function(a,b,c,e){d.scissor(a,b,c,e)};this.enableScissorTest=function(a){a?d.enable(d.SCISSOR_TEST):d.disable(d.SCISSOR_TEST)};
this.setClearColorHex=function(a,b){J.setHex(a);O=b;d.clearColor(J.r,J.g,J.b,O)};this.setClearColor=function(a,b){J.copy(a);O=b;d.clearColor(J.r,J.g,J.b,O)};this.getClearColor=function(){return J};this.getClearAlpha=function(){return O};this.clear=function(a,b,c){var e=0;if(a===void 0||a)e|=d.COLOR_BUFFER_BIT;if(b===void 0||b)e|=d.DEPTH_BUFFER_BIT;if(c===void 0||c)e|=d.STENCIL_BUFFER_BIT;d.clear(e)};this.clearTarget=function(a,b,c,d){ra(a);this.clear(b,c,d)};this.deallocateObject=function(a){if(a.__webglInit)if(a.__webglInit=
!1,delete a._modelViewMatrix,delete a._normalMatrixArray,delete a._modelViewMatrixArray,delete a._objectMatrixArray,a instanceof THREE.Mesh)for(var b in a.geometry.geometryGroups){var c=a.geometry.geometryGroups[b];d.deleteBuffer(c.__webglVertexBuffer);d.deleteBuffer(c.__webglNormalBuffer);d.deleteBuffer(c.__webglTangentBuffer);d.deleteBuffer(c.__webglColorBuffer);d.deleteBuffer(c.__webglUVBuffer);d.deleteBuffer(c.__webglUV2Buffer);d.deleteBuffer(c.__webglSkinVertexABuffer);d.deleteBuffer(c.__webglSkinVertexBBuffer);
d.deleteBuffer(c.__webglSkinIndicesBuffer);d.deleteBuffer(c.__webglSkinWeightsBuffer);d.deleteBuffer(c.__webglFaceBuffer);d.deleteBuffer(c.__webglLineBuffer);if(c.numMorphTargets)for(var e=0,f=c.numMorphTargets;e<f;e++)d.deleteBuffer(c.__webglMorphTargetsBuffers[e]);if(c.__webglCustomAttributesList)for(e in e=void 0,c.__webglCustomAttributesList)d.deleteBuffer(c.__webglCustomAttributesList[e].buffer);G.info.memory.geometries--}else if(a instanceof THREE.Ribbon)a=a.geometry,d.deleteBuffer(a.__webglVertexBuffer),
d.deleteBuffer(a.__webglColorBuffer),G.info.memory.geometries--;else if(a instanceof THREE.Line)a=a.geometry,d.deleteBuffer(a.__webglVertexBuffer),d.deleteBuffer(a.__webglColorBuffer),G.info.memory.geometries--;else if(a instanceof THREE.ParticleSystem)a=a.geometry,d.deleteBuffer(a.__webglVertexBuffer),d.deleteBuffer(a.__webglColorBuffer),G.info.memory.geometries--};this.deallocateTexture=function(a){if(a.__webglInit)a.__webglInit=!1,d.deleteTexture(a.__webglTexture),G.info.memory.textures--};this.updateShadowMap=
function(a,b){A(a,b)};this.render=function(a,b,c,e){var f,g,h,m,i=a.lights,n=a.fog;Aa=-1;this.autoUpdateObjects&&this.initWebGLObjects(a);b.parent===void 0&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),a.add(b));this.autoUpdateScene&&a.updateMatrixWorld();this.shadowMapEnabled&&this.shadowMapAutoUpdate&&A(a,b);G.info.render.calls=0;G.info.render.vertices=0;G.info.render.faces=0;b.matrixWorldInverse.getInverse(b.matrixWorld);b.matrixWorldInverse.flattenToArray(Ka);
b.projectionMatrix.flattenToArray(La);Ba.multiply(b.projectionMatrix,b.matrixWorldInverse);k(Ba);ra(c);(this.autoClear||e)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil);m=a.__webglObjects;e=0;for(f=m.length;e<f;e++)if(g=m[e],h=g.object,g.render=!1,h.visible&&(!(h instanceof THREE.Mesh)||!h.frustumCulled||l(h))){h.matrixWorld.flattenToArray(h._objectMatrixArray);ga(h,b,!0);var s=g,w=s.object,j=s.buffer,q=void 0,q=q=void 0,q=w.material;if(q instanceof THREE.MeshFaceMaterial){if(q=
j.materialIndex,q>=0)q=w.geometry.materials[q],q.transparent?(s.transparent=q,s.opaque=null):(s.opaque=q,s.transparent=null)}else if(q)q.transparent?(s.transparent=q,s.opaque=null):(s.opaque=q,s.transparent=null);g.render=!0;if(this.sortObjects)h.renderDepth?g.z=h.renderDepth:(Da.copy(h.position),Ba.multiplyVector3(Da),g.z=Da.z)}this.sortObjects&&m.sort(p);m=a.__webglObjectsImmediate;e=0;for(f=m.length;e<f;e++)if(g=m[e],h=g.object,h.visible)h.matrixAutoUpdate&&h.matrixWorld.flattenToArray(h._objectMatrixArray),
ga(h,b,!0),h=g.object.material,h.transparent?(g.transparent=h,g.opaque=null):(g.opaque=h,g.transparent=null);a.overrideMaterial?(ca(a.overrideMaterial.blending),S(a.overrideMaterial.depthTest),F(a.overrideMaterial.depthWrite),N(a.overrideMaterial.polygonOffset,a.overrideMaterial.polygonOffsetFactor,a.overrideMaterial.polygonOffsetUnits),r(a.__webglObjects,!1,"",b,i,n,!0,a.overrideMaterial),y(a.__webglObjectsImmediate,"",b,i,n,!1,a.overrideMaterial)):(ca(THREE.NormalBlending),r(a.__webglObjects,!0,
"opaque",b,i,n,!1),y(a.__webglObjectsImmediate,"opaque",b,i,n,!1),r(a.__webglObjects,!1,"transparent",b,i,n,!0),y(a.__webglObjectsImmediate,"transparent",b,i,n,!0));if(a.__webglSprites.length){h=B.attributes;i=B.uniforms;n=Ea/Ha;e=[];f=Ha*0.5;m=Ea*0.5;g=!0;d.useProgram(B.program);xa=B.program;ya=Na=Pa=-1;Xa||(d.enableVertexAttribArray(B.attributes.position),d.enableVertexAttribArray(B.attributes.uv),Xa=!0);d.disable(d.CULL_FACE);d.enable(d.BLEND);d.depthMask(!0);d.bindBuffer(d.ARRAY_BUFFER,B.vertexBuffer);
d.vertexAttribPointer(h.position,2,d.FLOAT,!1,16,0);d.vertexAttribPointer(h.uv,2,d.FLOAT,!1,16,8);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,B.elementBuffer);d.uniformMatrix4fv(i.projectionMatrix,!1,La);d.activeTexture(d.TEXTURE0);d.uniform1i(i.map,0);h=0;for(s=a.__webglSprites.length;h<s;h++)if(w=a.__webglSprites[h],w.visible&&w.opacity!==0)w.useScreenCoordinates?w.z=-w.position.z:(w._modelViewMatrix.multiplyToArray(b.matrixWorldInverse,w.matrixWorld,w._modelViewMatrixArray),w.z=-w._modelViewMatrix.n34);
a.__webglSprites.sort(p);h=0;for(s=a.__webglSprites.length;h<s;h++)w=a.__webglSprites[h],w.visible&&w.opacity!==0&&w.map&&w.map.image&&w.map.image.width&&(w.useScreenCoordinates?(d.uniform1i(i.useScreenCoordinates,1),d.uniform3f(i.screenPosition,(w.position.x-f)/f,(m-w.position.y)/m,Math.max(0,Math.min(1,w.position.z)))):(d.uniform1i(i.useScreenCoordinates,0),d.uniform1i(i.affectedByDistance,w.affectedByDistance?1:0),d.uniformMatrix4fv(i.modelViewMatrix,!1,w._modelViewMatrixArray)),b=w.map.image.width/
(w.scaleByViewport?Ea:1),e[0]=b*n*w.scale.x,e[1]=b*w.scale.y,d.uniform2f(i.uvScale,w.uvScale.x,w.uvScale.y),d.uniform2f(i.uvOffset,w.uvOffset.x,w.uvOffset.y),d.uniform2f(i.alignment,w.alignment.x,w.alignment.y),d.uniform1f(i.opacity,w.opacity),d.uniform3f(i.color,w.color.r,w.color.g,w.color.b),d.uniform1f(i.rotation,w.rotation),d.uniform2fv(i.scale,e),w.mergeWith3D&&!g?(d.enable(d.DEPTH_TEST),g=!0):!w.mergeWith3D&&g&&(d.disable(d.DEPTH_TEST),g=!1),ca(w.blending),la(w.map,0),d.drawElements(d.TRIANGLES,
6,d.UNSIGNED_SHORT,0));d.enable(d.CULL_FACE);d.enable(d.DEPTH_TEST);d.depthMask(Oa)}c&&c.minFilter!==THREE.NearestFilter&&c.minFilter!==THREE.LinearFilter&&(c instanceof THREE.WebGLRenderTargetCube?(d.bindTexture(d.TEXTURE_CUBE_MAP,c.__webglTexture),d.generateMipmap(d.TEXTURE_CUBE_MAP),d.bindTexture(d.TEXTURE_CUBE_MAP,null)):(d.bindTexture(d.TEXTURE_2D,c.__webglTexture),d.generateMipmap(d.TEXTURE_2D),d.bindTexture(d.TEXTURE_2D,null)))};this.initWebGLObjects=function(a){if(!a.__webglObjects)a.__webglObjects=
[],a.__webglObjectsImmediate=[],a.__webglSprites=[];for(;a.__objectsAdded.length;){var i=a.__objectsAdded[0],p=a,l=void 0,n=void 0,k=void 0;if(!i.__webglInit)if(i.__webglInit=!0,i._modelViewMatrix=new THREE.Matrix4,i._normalMatrixArray=new Float32Array(9),i._modelViewMatrixArray=new Float32Array(16),i._objectMatrixArray=new Float32Array(16),i.matrixWorld.flattenToArray(i._objectMatrixArray),i instanceof THREE.Mesh){n=i.geometry;if(n.geometryGroups===void 0){var k=n,z=void 0,m=void 0,u=void 0,r=void 0,
s=void 0,w=void 0,j=void 0,q={},A=k.morphTargets.length;k.geometryGroups={};z=0;for(m=k.faces.length;z<m;z++)u=k.faces[z],r=u.materialIndex,w=r!==void 0?r:-1,q[w]===void 0&&(q[w]={hash:w,counter:0}),j=q[w].hash+"_"+q[w].counter,k.geometryGroups[j]===void 0&&(k.geometryGroups[j]={faces3:[],faces4:[],materialIndex:r,vertices:0,numMorphTargets:A}),s=u instanceof THREE.Face3?3:4,k.geometryGroups[j].vertices+s>65535&&(q[w].counter+=1,j=q[w].hash+"_"+q[w].counter,k.geometryGroups[j]===void 0&&(k.geometryGroups[j]=
{faces3:[],faces4:[],materialIndex:r,vertices:0,numMorphTargets:A})),u instanceof THREE.Face3?k.geometryGroups[j].faces3.push(z):k.geometryGroups[j].faces4.push(z),k.geometryGroups[j].vertices+=s;k.geometryGroupsList=[];z=void 0;for(z in k.geometryGroups)k.geometryGroups[z].id=Fa++,k.geometryGroupsList.push(k.geometryGroups[z])}for(l in n.geometryGroups)if(k=n.geometryGroups[l],!k.__webglVertexBuffer){z=k;z.__webglVertexBuffer=d.createBuffer();z.__webglNormalBuffer=d.createBuffer();z.__webglTangentBuffer=
d.createBuffer();z.__webglColorBuffer=d.createBuffer();z.__webglUVBuffer=d.createBuffer();z.__webglUV2Buffer=d.createBuffer();z.__webglSkinVertexABuffer=d.createBuffer();z.__webglSkinVertexBBuffer=d.createBuffer();z.__webglSkinIndicesBuffer=d.createBuffer();z.__webglSkinWeightsBuffer=d.createBuffer();z.__webglFaceBuffer=d.createBuffer();z.__webglLineBuffer=d.createBuffer();if(z.numMorphTargets){u=m=void 0;z.__webglMorphTargetsBuffers=[];m=0;for(u=z.numMorphTargets;m<u;m++)z.__webglMorphTargetsBuffers.push(d.createBuffer())}G.info.memory.geometries++;
r=i;s=r.geometry;m=k.faces3;w=k.faces4;z=m.length*3+w.length*4;u=m.length*1+w.length*2;w=m.length*3+w.length*4;m=c(r,k);j=g(m);q=e(m);A=f(m);k.__vertexArray=new Float32Array(z*3);if(q)k.__normalArray=new Float32Array(z*3);if(s.hasTangents)k.__tangentArray=new Float32Array(z*4);if(A)k.__colorArray=new Float32Array(z*3);if(j){if(s.faceUvs.length>0||s.faceVertexUvs.length>0)k.__uvArray=new Float32Array(z*2);if(s.faceUvs.length>1||s.faceVertexUvs.length>1)k.__uv2Array=new Float32Array(z*2)}if(r.geometry.skinWeights.length&&
r.geometry.skinIndices.length)k.__skinVertexAArray=new Float32Array(z*4),k.__skinVertexBArray=new Float32Array(z*4),k.__skinIndexArray=new Float32Array(z*4),k.__skinWeightArray=new Float32Array(z*4);k.__faceArray=new Uint16Array(u*3);k.__lineArray=new Uint16Array(w*2);if(k.numMorphTargets){k.__morphTargetsArrays=[];r=0;for(s=k.numMorphTargets;r<s;r++)k.__morphTargetsArrays.push(new Float32Array(z*3))}k.__webglFaceCount=u*3;k.__webglLineCount=w*2;if(m.attributes){if(k.__webglCustomAttributesList===
void 0)k.__webglCustomAttributesList=[];u=void 0;for(u in m.attributes){var r=m.attributes[u],s={},B;for(B in r)s[B]=r[B];if(!s.__webglInitialized||s.createUniqueBuffers)s.__webglInitialized=!0,w=1,s.type==="v2"?w=2:s.type==="v3"?w=3:s.type==="v4"?w=4:s.type==="c"&&(w=3),s.size=w,s.array=new Float32Array(z*w),s.buffer=d.createBuffer(),s.buffer.belongsToAttribute=u,r.needsUpdate=!0,s.__original=r;k.__webglCustomAttributesList.push(s)}}k.__inittedArrays=!0;n.__dirtyVertices=!0;n.__dirtyMorphTargets=
!0;n.__dirtyElements=!0;n.__dirtyUvs=!0;n.__dirtyNormals=!0;n.__dirtyTangents=!0;n.__dirtyColors=!0}}else if(i instanceof THREE.Ribbon){if(n=i.geometry,!n.__webglVertexBuffer)k=n,k.__webglVertexBuffer=d.createBuffer(),k.__webglColorBuffer=d.createBuffer(),G.info.memory.geometries++,k=n,z=k.vertices.length,k.__vertexArray=new Float32Array(z*3),k.__colorArray=new Float32Array(z*3),k.__webglVertexCount=z,n.__dirtyVertices=!0,n.__dirtyColors=!0}else if(i instanceof THREE.Line){if(n=i.geometry,!n.__webglVertexBuffer)k=
n,k.__webglVertexBuffer=d.createBuffer(),k.__webglColorBuffer=d.createBuffer(),G.info.memory.geometries++,k=n,z=i,m=k.vertices.length,k.__vertexArray=new Float32Array(m*3),k.__colorArray=new Float32Array(m*3),k.__webglLineCount=m,b(k,z),n.__dirtyVertices=!0,n.__dirtyColors=!0}else if(i instanceof THREE.ParticleSystem&&(n=i.geometry,!n.__webglVertexBuffer))k=n,k.__webglVertexBuffer=d.createBuffer(),k.__webglColorBuffer=d.createBuffer(),G.info.geometries++,k=n,z=i,m=k.vertices.length,k.__vertexArray=
new Float32Array(m*3),k.__colorArray=new Float32Array(m*3),k.__sortArray=[],k.__webglParticleCount=m,b(k,z),n.__dirtyVertices=!0,n.__dirtyColors=!0;if(!i.__webglActive){if(i instanceof THREE.Mesh)for(l in n=i.geometry,n.geometryGroups)k=n.geometryGroups[l],I(p.__webglObjects,k,i);else i instanceof THREE.Ribbon||i instanceof THREE.Line||i instanceof THREE.ParticleSystem?(n=i.geometry,I(p.__webglObjects,n,i)):THREE.MarchingCubes!==void 0&&i instanceof THREE.MarchingCubes||i.immediateRenderCallback?
p.__webglObjectsImmediate.push({object:i,opaque:null,transparent:null}):i instanceof THREE.Sprite&&p.__webglSprites.push(i);i.__webglActive=!0}a.__objectsAdded.splice(0,1)}for(;a.__objectsRemoved.length;){i=a.__objectsRemoved[0];p=a;if(i instanceof THREE.Mesh||i instanceof THREE.ParticleSystem||i instanceof THREE.Ribbon||i instanceof THREE.Line)ha(p.__webglObjects,i);else if(i instanceof THREE.Sprite){p=p.__webglSprites;l=i;for(n=p.length-1;n>=0;n--)p[n]===l&&p.splice(n,1)}else(i instanceof THREE.MarchingCubes||
i.immediateRenderCallback)&&ha(p.__webglObjectsImmediate,i);i.__webglActive=!1;a.__objectsRemoved.splice(0,1)}i=0;for(p=a.__webglObjects.length;i<p;i++)if(B=a.__webglObjects[i].object,l=B.geometry,n=u=m=void 0,B instanceof THREE.Mesh){k=0;for(z=l.geometryGroupsList.length;k<z;k++)if(m=l.geometryGroupsList[k],n=c(B,m),u=n.attributes&&R(n),l.__dirtyVertices||l.__dirtyMorphTargets||l.__dirtyElements||l.__dirtyUvs||l.__dirtyNormals||l.__dirtyColors||l.__dirtyTangents||u){var y=B,u=d.DYNAMIC_DRAW,r=!l.dynamic,
j=n;if(m.__inittedArrays){var s=e(j),w=f(j),J=g(j),L=s===THREE.SmoothShading,F=q=j=void 0,v=void 0,$=void 0,M=void 0,x=void 0,ba=void 0,N=void 0,S=F=void 0,C=void 0,D=void 0,E=void 0,aa=v=void 0,da=void 0,ka=void 0,T=v=N=void 0,U=void 0,O=E=D=C=x=void 0,H=v=E=D=C=O=E=D=C=O=E=D=C=void 0,K=void 0,Q=M=void 0,Y=void 0,X=void 0,ja=void 0,ea=void 0,ga=S=X=K=0,ca=0,W=H=F=0,P=x=aa=0,t=0,fa=void 0,P=m.__vertexArray,Y=m.__uvArray,t=m.__uv2Array,Q=m.__normalArray,$=m.__tangentArray,da=m.__colorArray,T=m.__skinVertexAArray,
U=m.__skinVertexBArray,ba=m.__skinIndexArray,ia=m.__skinWeightArray,O=m.__morphTargetsArrays,A=m.__webglCustomAttributesList,o=void 0,o=m.__faceArray,fa=m.__lineArray,ka=y.geometry,ma=ka.__dirtyElements,la=ka.__dirtyUvs,M=ka.__dirtyNormals,N=ka.__dirtyTangents,ua=ka.__dirtyColors,ja=ka.__dirtyMorphTargets,ea=ka.vertices,y=m.faces3,V=m.faces4,Z=ka.faces,oa=ka.faceVertexUvs[0],ta=ka.faceVertexUvs[1],na=ka.skinVerticesA,qa=ka.skinVerticesB,sa=ka.skinIndices,pa=ka.skinWeights,ra=ka.morphTargets;if(ka.__dirtyVertices){j=
0;for(q=y.length;j<q;j++)v=Z[y[j]],C=ea[v.a].position,D=ea[v.b].position,E=ea[v.c].position,P[X]=C.x,P[X+1]=C.y,P[X+2]=C.z,P[X+3]=D.x,P[X+4]=D.y,P[X+5]=D.z,P[X+6]=E.x,P[X+7]=E.y,P[X+8]=E.z,X+=9;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],C=ea[v.a].position,D=ea[v.b].position,E=ea[v.c].position,v=ea[v.d].position,P[X]=C.x,P[X+1]=C.y,P[X+2]=C.z,P[X+3]=D.x,P[X+4]=D.y,P[X+5]=D.z,P[X+6]=E.x,P[X+7]=E.y,P[X+8]=E.z,P[X+9]=v.x,P[X+10]=v.y,P[X+11]=v.z,X+=12;d.bindBuffer(d.ARRAY_BUFFER,m.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,
P,u)}if(ja){X=0;for(ja=ra.length;X<ja;X++){j=P=0;for(q=y.length;j<q;j++)v=Z[y[j]],C=ra[X].vertices[v.a].position,D=ra[X].vertices[v.b].position,E=ra[X].vertices[v.c].position,ea=O[X],ea[P]=C.x,ea[P+1]=C.y,ea[P+2]=C.z,ea[P+3]=D.x,ea[P+4]=D.y,ea[P+5]=D.z,ea[P+6]=E.x,ea[P+7]=E.y,ea[P+8]=E.z,P+=9;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],C=ra[X].vertices[v.a].position,D=ra[X].vertices[v.b].position,E=ra[X].vertices[v.c].position,v=ra[X].vertices[v.d].position,ea=O[X],ea[P]=C.x,ea[P+1]=C.y,ea[P+2]=C.z,ea[P+
3]=D.x,ea[P+4]=D.y,ea[P+5]=D.z,ea[P+6]=E.x,ea[P+7]=E.y,ea[P+8]=E.z,ea[P+9]=v.x,ea[P+10]=v.y,ea[P+11]=v.z,P+=12;d.bindBuffer(d.ARRAY_BUFFER,m.__webglMorphTargetsBuffers[X]);d.bufferData(d.ARRAY_BUFFER,O[X],u)}}if(pa.length){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],C=pa[v.a],D=pa[v.b],E=pa[v.c],ia[x]=C.x,ia[x+1]=C.y,ia[x+2]=C.z,ia[x+3]=C.w,ia[x+4]=D.x,ia[x+5]=D.y,ia[x+6]=D.z,ia[x+7]=D.w,ia[x+8]=E.x,ia[x+9]=E.y,ia[x+10]=E.z,ia[x+11]=E.w,C=sa[v.a],D=sa[v.b],E=sa[v.c],ba[x]=C.x,ba[x+1]=C.y,ba[x+2]=C.z,ba[x+
3]=C.w,ba[x+4]=D.x,ba[x+5]=D.y,ba[x+6]=D.z,ba[x+7]=D.w,ba[x+8]=E.x,ba[x+9]=E.y,ba[x+10]=E.z,ba[x+11]=E.w,C=na[v.a],D=na[v.b],E=na[v.c],T[x]=C.x,T[x+1]=C.y,T[x+2]=C.z,T[x+3]=1,T[x+4]=D.x,T[x+5]=D.y,T[x+6]=D.z,T[x+7]=1,T[x+8]=E.x,T[x+9]=E.y,T[x+10]=E.z,T[x+11]=1,C=qa[v.a],D=qa[v.b],E=qa[v.c],U[x]=C.x,U[x+1]=C.y,U[x+2]=C.z,U[x+3]=1,U[x+4]=D.x,U[x+5]=D.y,U[x+6]=D.z,U[x+7]=1,U[x+8]=E.x,U[x+9]=E.y,U[x+10]=E.z,U[x+11]=1,x+=12;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],C=pa[v.a],D=pa[v.b],E=pa[v.c],O=pa[v.d],ia[x]=
C.x,ia[x+1]=C.y,ia[x+2]=C.z,ia[x+3]=C.w,ia[x+4]=D.x,ia[x+5]=D.y,ia[x+6]=D.z,ia[x+7]=D.w,ia[x+8]=E.x,ia[x+9]=E.y,ia[x+10]=E.z,ia[x+11]=E.w,ia[x+12]=O.x,ia[x+13]=O.y,ia[x+14]=O.z,ia[x+15]=O.w,C=sa[v.a],D=sa[v.b],E=sa[v.c],O=sa[v.d],ba[x]=C.x,ba[x+1]=C.y,ba[x+2]=C.z,ba[x+3]=C.w,ba[x+4]=D.x,ba[x+5]=D.y,ba[x+6]=D.z,ba[x+7]=D.w,ba[x+8]=E.x,ba[x+9]=E.y,ba[x+10]=E.z,ba[x+11]=E.w,ba[x+12]=O.x,ba[x+13]=O.y,ba[x+14]=O.z,ba[x+15]=O.w,C=na[v.a],D=na[v.b],E=na[v.c],O=na[v.d],T[x]=C.x,T[x+1]=C.y,T[x+2]=C.z,T[x+
3]=1,T[x+4]=D.x,T[x+5]=D.y,T[x+6]=D.z,T[x+7]=1,T[x+8]=E.x,T[x+9]=E.y,T[x+10]=E.z,T[x+11]=1,T[x+12]=O.x,T[x+13]=O.y,T[x+14]=O.z,T[x+15]=1,C=qa[v.a],D=qa[v.b],E=qa[v.c],v=qa[v.d],U[x]=C.x,U[x+1]=C.y,U[x+2]=C.z,U[x+3]=1,U[x+4]=D.x,U[x+5]=D.y,U[x+6]=D.z,U[x+7]=1,U[x+8]=E.x,U[x+9]=E.y,U[x+10]=E.z,U[x+11]=1,U[x+12]=v.x,U[x+13]=v.y,U[x+14]=v.z,U[x+15]=1,x+=16;x>0&&(d.bindBuffer(d.ARRAY_BUFFER,m.__webglSkinVertexABuffer),d.bufferData(d.ARRAY_BUFFER,T,u),d.bindBuffer(d.ARRAY_BUFFER,m.__webglSkinVertexBBuffer),
d.bufferData(d.ARRAY_BUFFER,U,u),d.bindBuffer(d.ARRAY_BUFFER,m.__webglSkinIndicesBuffer),d.bufferData(d.ARRAY_BUFFER,ba,u),d.bindBuffer(d.ARRAY_BUFFER,m.__webglSkinWeightsBuffer),d.bufferData(d.ARRAY_BUFFER,ia,u))}if(ua&&w){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],x=v.vertexColors,ba=v.color,x.length===3&&w===THREE.VertexColors?(v=x[0],T=x[1],U=x[2]):U=T=v=ba,da[aa]=v.r,da[aa+1]=v.g,da[aa+2]=v.b,da[aa+3]=T.r,da[aa+4]=T.g,da[aa+5]=T.b,da[aa+6]=U.r,da[aa+7]=U.g,da[aa+8]=U.b,aa+=9;j=0;for(q=V.length;j<q;j++)v=
Z[V[j]],x=v.vertexColors,ba=v.color,x.length===4&&w===THREE.VertexColors?(v=x[0],T=x[1],U=x[2],x=x[3]):x=U=T=v=ba,da[aa]=v.r,da[aa+1]=v.g,da[aa+2]=v.b,da[aa+3]=T.r,da[aa+4]=T.g,da[aa+5]=T.b,da[aa+6]=U.r,da[aa+7]=U.g,da[aa+8]=U.b,da[aa+9]=x.r,da[aa+10]=x.g,da[aa+11]=x.b,aa+=12;aa>0&&(d.bindBuffer(d.ARRAY_BUFFER,m.__webglColorBuffer),d.bufferData(d.ARRAY_BUFFER,da,u))}if(N&&ka.hasTangents){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],N=v.vertexTangents,aa=N[0],da=N[1],ka=N[2],$[H]=aa.x,$[H+1]=aa.y,$[H+2]=aa.z,
$[H+3]=aa.w,$[H+4]=da.x,$[H+5]=da.y,$[H+6]=da.z,$[H+7]=da.w,$[H+8]=ka.x,$[H+9]=ka.y,$[H+10]=ka.z,$[H+11]=ka.w,H+=12;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],N=v.vertexTangents,aa=N[0],da=N[1],ka=N[2],N=N[3],$[H]=aa.x,$[H+1]=aa.y,$[H+2]=aa.z,$[H+3]=aa.w,$[H+4]=da.x,$[H+5]=da.y,$[H+6]=da.z,$[H+7]=da.w,$[H+8]=ka.x,$[H+9]=ka.y,$[H+10]=ka.z,$[H+11]=ka.w,$[H+12]=N.x,$[H+13]=N.y,$[H+14]=N.z,$[H+15]=N.w,H+=16;d.bindBuffer(d.ARRAY_BUFFER,m.__webglTangentBuffer);d.bufferData(d.ARRAY_BUFFER,$,u)}if(M&&s){j=0;for(q=
y.length;j<q;j++)if(v=Z[y[j]],$=v.vertexNormals,M=v.normal,$.length===3&&L)for(H=0;H<3;H++)M=$[H],Q[F]=M.x,Q[F+1]=M.y,Q[F+2]=M.z,F+=3;else for(H=0;H<3;H++)Q[F]=M.x,Q[F+1]=M.y,Q[F+2]=M.z,F+=3;j=0;for(q=V.length;j<q;j++)if(v=Z[V[j]],$=v.vertexNormals,M=v.normal,$.length===4&&L)for(H=0;H<4;H++)M=$[H],Q[F]=M.x,Q[F+1]=M.y,Q[F+2]=M.z,F+=3;else for(H=0;H<4;H++)Q[F]=M.x,Q[F+1]=M.y,Q[F+2]=M.z,F+=3;d.bindBuffer(d.ARRAY_BUFFER,m.__webglNormalBuffer);d.bufferData(d.ARRAY_BUFFER,Q,u)}if(la&&oa&&J){j=0;for(q=y.length;j<
q;j++)if(F=y[j],F=oa[F],F!==void 0)for(H=0;H<3;H++)Q=F[H],Y[S]=Q.u,Y[S+1]=Q.v,S+=2;j=0;for(q=V.length;j<q;j++)if(F=V[j],F=oa[F],F!==void 0)for(H=0;H<4;H++)Q=F[H],Y[S]=Q.u,Y[S+1]=Q.v,S+=2;S>0&&(d.bindBuffer(d.ARRAY_BUFFER,m.__webglUVBuffer),d.bufferData(d.ARRAY_BUFFER,Y,u))}if(la&&ta&&J){j=0;for(q=y.length;j<q;j++)if(F=y[j],S=ta[F],S!==void 0)for(H=0;H<3;H++)Y=S[H],t[ga]=Y.u,t[ga+1]=Y.v,ga+=2;j=0;for(q=V.length;j<q;j++)if(F=V[j],S=ta[F],S!==void 0)for(H=0;H<4;H++)Y=S[H],t[ga]=Y.u,t[ga+1]=Y.v,ga+=2;
ga>0&&(d.bindBuffer(d.ARRAY_BUFFER,m.__webglUV2Buffer),d.bufferData(d.ARRAY_BUFFER,t,u))}if(ma){j=0;for(q=y.length;j<q;j++)o[ca]=K,o[ca+1]=K+1,o[ca+2]=K+2,ca+=3,fa[W]=K,fa[W+1]=K+1,fa[W+2]=K,fa[W+3]=K+2,fa[W+4]=K+1,fa[W+5]=K+2,W+=6,K+=3;j=0;for(q=V.length;j<q;j++)o[ca]=K,o[ca+1]=K+1,o[ca+2]=K+3,o[ca+3]=K+1,o[ca+4]=K+2,o[ca+5]=K+3,ca+=6,fa[W]=K,fa[W+1]=K+1,fa[W+2]=K,fa[W+3]=K+3,fa[W+4]=K+1,fa[W+5]=K+2,fa[W+6]=K+2,fa[W+7]=K+3,W+=8,K+=4;d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,m.__webglFaceBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,
o,u);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,m.__webglLineBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,fa,u)}if(A){H=0;for(K=A.length;H<K;H++)if(o=A[H],o.__original.needsUpdate){t=0;if(o.size===1)if(o.boundTo===void 0||o.boundTo==="vertices"){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],o.array[t]=o.value[v.a],o.array[t+1]=o.value[v.b],o.array[t+2]=o.value[v.c],t+=3;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],o.array[t]=o.value[v.a],o.array[t+1]=o.value[v.b],o.array[t+2]=o.value[v.c],o.array[t+3]=o.value[v.d],t+=4}else{if(o.boundTo===
"faces"){j=0;for(q=y.length;j<q;j++)fa=o.value[y[j]],o.array[t]=fa,o.array[t+1]=fa,o.array[t+2]=fa,t+=3;j=0;for(q=V.length;j<q;j++)fa=o.value[V[j]],o.array[t]=fa,o.array[t+1]=fa,o.array[t+2]=fa,o.array[t+3]=fa,t+=4}}else if(o.size===2)if(o.boundTo===void 0||o.boundTo==="vertices"){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],C=o.value[v.a],D=o.value[v.b],E=o.value[v.c],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=D.x,o.array[t+3]=D.y,o.array[t+4]=E.x,o.array[t+5]=E.y,t+=6;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],
C=o.value[v.a],D=o.value[v.b],E=o.value[v.c],v=o.value[v.d],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=D.x,o.array[t+3]=D.y,o.array[t+4]=E.x,o.array[t+5]=E.y,o.array[t+6]=v.x,o.array[t+7]=v.y,t+=8}else{if(o.boundTo==="faces"){j=0;for(q=y.length;j<q;j++)E=D=C=fa=o.value[y[j]],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=D.x,o.array[t+3]=D.y,o.array[t+4]=E.x,o.array[t+5]=E.y,t+=6;j=0;for(q=V.length;j<q;j++)v=E=D=C=fa=o.value[V[j]],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=D.x,o.array[t+3]=D.y,
o.array[t+4]=E.x,o.array[t+5]=E.y,o.array[t+6]=v.x,o.array[t+7]=v.y,t+=8}}else if(o.size===3)if(s=o.type==="c"?["r","g","b"]:["x","y","z"],o.boundTo===void 0||o.boundTo==="vertices"){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],C=o.value[v.a],D=o.value[v.b],E=o.value[v.c],o.array[t]=C[s[0]],o.array[t+1]=C[s[1]],o.array[t+2]=C[s[2]],o.array[t+3]=D[s[0]],o.array[t+4]=D[s[1]],o.array[t+5]=D[s[2]],o.array[t+6]=E[s[0]],o.array[t+7]=E[s[1]],o.array[t+8]=E[s[2]],t+=9;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],C=o.value[v.a],
D=o.value[v.b],E=o.value[v.c],v=o.value[v.d],o.array[t]=C[s[0]],o.array[t+1]=C[s[1]],o.array[t+2]=C[s[2]],o.array[t+3]=D[s[0]],o.array[t+4]=D[s[1]],o.array[t+5]=D[s[2]],o.array[t+6]=E[s[0]],o.array[t+7]=E[s[1]],o.array[t+8]=E[s[2]],o.array[t+9]=v[s[0]],o.array[t+10]=v[s[1]],o.array[t+11]=v[s[2]],t+=12}else{if(o.boundTo==="faces"){j=0;for(q=y.length;j<q;j++)E=D=C=fa=o.value[y[j]],o.array[t]=C[s[0]],o.array[t+1]=C[s[1]],o.array[t+2]=C[s[2]],o.array[t+3]=D[s[0]],o.array[t+4]=D[s[1]],o.array[t+5]=D[s[2]],
o.array[t+6]=E[s[0]],o.array[t+7]=E[s[1]],o.array[t+8]=E[s[2]],t+=9;j=0;for(q=V.length;j<q;j++)v=E=D=C=fa=o.value[V[j]],o.array[t]=C[s[0]],o.array[t+1]=C[s[1]],o.array[t+2]=C[s[2]],o.array[t+3]=D[s[0]],o.array[t+4]=D[s[1]],o.array[t+5]=D[s[2]],o.array[t+6]=E[s[0]],o.array[t+7]=E[s[1]],o.array[t+8]=E[s[2]],o.array[t+9]=v[s[0]],o.array[t+10]=v[s[1]],o.array[t+11]=v[s[2]],t+=12}}else if(o.size===4)if(o.boundTo===void 0||o.boundTo==="vertices"){j=0;for(q=y.length;j<q;j++)v=Z[y[j]],C=o.value[v.a],D=o.value[v.b],
E=o.value[v.c],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=C.z,o.array[t+3]=C.w,o.array[t+4]=D.x,o.array[t+5]=D.y,o.array[t+6]=D.z,o.array[t+7]=D.w,o.array[t+8]=E.x,o.array[t+9]=E.y,o.array[t+10]=E.z,o.array[t+11]=E.w,t+=12;j=0;for(q=V.length;j<q;j++)v=Z[V[j]],C=o.value[v.a],D=o.value[v.b],E=o.value[v.c],v=o.value[v.d],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=C.z,o.array[t+3]=C.w,o.array[t+4]=D.x,o.array[t+5]=D.y,o.array[t+6]=D.z,o.array[t+7]=D.w,o.array[t+8]=E.x,o.array[t+9]=E.y,o.array[t+10]=
E.z,o.array[t+11]=E.w,o.array[t+12]=v.x,o.array[t+13]=v.y,o.array[t+14]=v.z,o.array[t+15]=v.w,t+=16}else if(o.boundTo==="faces"){j=0;for(q=y.length;j<q;j++)E=D=C=fa=o.value[y[j]],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=C.z,o.array[t+3]=C.w,o.array[t+4]=D.x,o.array[t+5]=D.y,o.array[t+6]=D.z,o.array[t+7]=D.w,o.array[t+8]=E.x,o.array[t+9]=E.y,o.array[t+10]=E.z,o.array[t+11]=E.w,t+=12;j=0;for(q=V.length;j<q;j++)v=E=D=C=fa=o.value[V[j]],o.array[t]=C.x,o.array[t+1]=C.y,o.array[t+2]=C.z,o.array[t+3]=
C.w,o.array[t+4]=D.x,o.array[t+5]=D.y,o.array[t+6]=D.z,o.array[t+7]=D.w,o.array[t+8]=E.x,o.array[t+9]=E.y,o.array[t+10]=E.z,o.array[t+11]=E.w,o.array[t+12]=v.x,o.array[t+13]=v.y,o.array[t+14]=v.z,o.array[t+15]=v.w,t+=16}d.bindBuffer(d.ARRAY_BUFFER,o.buffer);d.bufferData(d.ARRAY_BUFFER,o.array,u)}}r&&(delete m.__inittedArrays,delete m.__colorArray,delete m.__normalArray,delete m.__tangentArray,delete m.__uvArray,delete m.__uv2Array,delete m.__faceArray,delete m.__vertexArray,delete m.__lineArray,delete m.__skinVertexAArray,
delete m.__skinVertexBArray,delete m.__skinIndexArray,delete m.__skinWeightArray)}}l.__dirtyVertices=!1;l.__dirtyMorphTargets=!1;l.__dirtyElements=!1;l.__dirtyUvs=!1;l.__dirtyNormals=!1;l.__dirtyColors=!1;l.__dirtyTangents=!1;n.attributes&&va(n)}else if(B instanceof THREE.Ribbon){if(l.__dirtyVertices||l.__dirtyColors){n=l;B=d.DYNAMIC_DRAW;s=k=s=r=r=void 0;w=n.vertices;z=n.colors;j=w.length;m=z.length;q=n.__vertexArray;u=n.__colorArray;A=n.__dirtyColors;if(n.__dirtyVertices){for(r=0;r<j;r++)s=w[r].position,
k=r*3,q[k]=s.x,q[k+1]=s.y,q[k+2]=s.z;d.bindBuffer(d.ARRAY_BUFFER,n.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,q,B)}if(A){for(r=0;r<m;r++)s=z[r],k=r*3,u[k]=s.r,u[k+1]=s.g,u[k+2]=s.b;d.bindBuffer(d.ARRAY_BUFFER,n.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,u,B)}}l.__dirtyVertices=!1;l.__dirtyColors=!1}else if(B instanceof THREE.Line){n=c(B,m);u=n.attributes&&R(n);if(l.__dirtyVertices||l.__dirtyColors||u){B=l;k=d.DYNAMIC_DRAW;j=z=L=w=J=void 0;w=B.vertices;m=B.colors;j=w.length;u=m.length;q=
B.__vertexArray;r=B.__colorArray;A=B.__dirtyColors;s=B.__webglCustomAttributesList;K=Z=V=y=L=J=void 0;if(B.__dirtyVertices){for(J=0;J<j;J++)L=w[J].position,z=J*3,q[z]=L.x,q[z+1]=L.y,q[z+2]=L.z;d.bindBuffer(d.ARRAY_BUFFER,B.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,q,k)}if(A){for(w=0;w<u;w++)j=m[w],z=w*3,r[z]=j.r,r[z+1]=j.g,r[z+2]=j.b;d.bindBuffer(d.ARRAY_BUFFER,B.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,r,k)}if(s){J=0;for(L=s.length;J<L;J++)if(K=s[J],K.needsUpdate&&(K.boundTo===void 0||
K.boundTo==="vertices")){z=0;V=K.value.length;if(K.size===1)for(y=0;y<V;y++)K.array[y]=K.value[y];else if(K.size===2)for(y=0;y<V;y++)Z=K.value[y],K.array[z]=Z.x,K.array[z+1]=Z.y,z+=2;else if(K.size===3)if(K.type==="c")for(y=0;y<V;y++)Z=K.value[y],K.array[z]=Z.r,K.array[z+1]=Z.g,K.array[z+2]=Z.b,z+=3;else for(y=0;y<V;y++)Z=K.value[y],K.array[z]=Z.x,K.array[z+1]=Z.y,K.array[z+2]=Z.z,z+=3;else if(K.size===4)for(y=0;y<V;y++)Z=K.value[y],K.array[z]=Z.x,K.array[z+1]=Z.y,K.array[z+2]=Z.z,K.array[z+3]=Z.w,
z+=4;d.bindBuffer(d.ARRAY_BUFFER,K.buffer);d.bufferData(d.ARRAY_BUFFER,K.array,k)}}}l.__dirtyVertices=!1;l.__dirtyColors=!1;n.attributes&&va(n)}else if(B instanceof THREE.ParticleSystem)n=c(B,m),u=n.attributes&&R(n),(l.__dirtyVertices||l.__dirtyColors||B.sortParticles||u)&&h(l,d.DYNAMIC_DRAW,B),l.__dirtyVertices=!1,l.__dirtyColors=!1,n.attributes&&va(n)};this.initMaterial=function(a,b,c,e){var f,g,h,i;a instanceof THREE.MeshDepthMaterial?i="depth":a instanceof THREE.MeshNormalMaterial?i="normal":
a instanceof THREE.MeshBasicMaterial?i="basic":a instanceof THREE.MeshLambertMaterial?i="lambert":a instanceof THREE.MeshPhongMaterial?i="phong":a instanceof THREE.LineBasicMaterial?i="basic":a instanceof THREE.ParticleBasicMaterial&&(i="particle_basic");if(i){var k=THREE.ShaderLib[i];a.uniforms=THREE.UniformsUtils.clone(k.uniforms);a.vertexShader=k.vertexShader;a.fragmentShader=k.fragmentShader}var l,n,p;l=p=k=0;for(n=b.length;l<n;l++)h=b[l],h instanceof THREE.SpotLight&&p++,h instanceof THREE.DirectionalLight&&
p++,h instanceof THREE.PointLight&&k++;k+p<=Y?l=p:(l=Math.ceil(Y*p/(k+p)),k=Y-l);h={directional:l,point:k};k=p=0;for(l=b.length;k<l;k++)n=b[k],n instanceof THREE.SpotLight&&n.castShadow&&p++;var j=50;if(e!==void 0&&e instanceof THREE.SkinnedMesh)j=e.bones.length;var q;a:{l=a.fragmentShader;n=a.vertexShader;var k=a.uniforms,b=a.attributes,c={map:!!a.map,envMap:!!a.envMap,lightMap:!!a.lightMap,vertexColors:a.vertexColors,fog:c,useFog:a.fog,sizeAttenuation:a.sizeAttenuation,skinning:a.skinning,morphTargets:a.morphTargets,
maxMorphTargets:this.maxMorphTargets,maxDirLights:h.directional,maxPointLights:h.point,maxBones:j,shadowMapEnabled:this.shadowMapEnabled&&e.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapWidth:this.shadowMapWidth,shadowMapHeight:this.shadowMapHeight,maxShadows:p,alphaTest:a.alphaTest,metal:a.metal,perPixel:a.perPixel},r,e=[];i?e.push(i):(e.push(l),e.push(n));for(r in c)e.push(r),e.push(c[r]);i=e.join();r=0;for(e=ta.length;r<e;r++)if(ta[r].code===i){q=ta[r].program;break a}r=d.createProgram();
e=[Ya?"#define VERTEX_TEXTURES":"",G.gammaInput?"#define GAMMA_INPUT":"",G.gammaOutput?"#define GAMMA_OUTPUT":"",G.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,"#define MAX_BONES "+c.maxBones,c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.skinning?"#define USE_SKINNING":"",
c.morphTargets?"#define USE_MORPHTARGETS":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
h=["#ifdef GL_ES","precision "+Za+" float;","#endif","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,c.alphaTest?"#define ALPHATEST "+c.alphaTest:"",G.gammaInput?"#define GAMMA_INPUT":"",G.gammaOutput?"#define GAMMA_OUTPUT":"",G.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"",c.useFog&&c.fog?"#define USE_FOG":"",c.useFog&&c.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":
"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.metal?"#define METAL":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.shadowMapSoft?"#define SHADOWMAP_WIDTH "+c.shadowMapWidth.toFixed(1):"",c.shadowMapSoft?"#define SHADOWMAP_HEIGHT "+c.shadowMapHeight.toFixed(1):"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");d.attachShader(r,M("fragment",h+l));d.attachShader(r,
M("vertex",e+n));d.linkProgram(r);d.getProgramParameter(r,d.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+d.getProgramParameter(r,d.VALIDATE_STATUS)+", gl error ["+d.getError()+"]");r.uniforms={};r.attributes={};var y,e=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(y in k)e.push(y);y=e;e=0;for(k=y.length;e<k;e++)l=y[e],r.uniforms[l]=d.getUniformLocation(r,
l);e=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(y=0;y<c.maxMorphTargets;y++)e.push("morphTarget"+y);for(q in b)e.push(q);q=e;y=0;for(b=q.length;y<b;y++)c=q[y],r.attributes[c]=d.getAttribLocation(r,c);r.id=ta.length;ta.push({program:r,code:i});G.info.memory.programs=ta.length;q=r}a.program=q;q=a.program.attributes;q.position>=0&&d.enableVertexAttribArray(q.position);q.color>=0&&d.enableVertexAttribArray(q.color);q.normal>=0&&d.enableVertexAttribArray(q.normal);
q.tangent>=0&&d.enableVertexAttribArray(q.tangent);a.skinning&&q.skinVertexA>=0&&q.skinVertexB>=0&&q.skinIndex>=0&&q.skinWeight>=0&&(d.enableVertexAttribArray(q.skinVertexA),d.enableVertexAttribArray(q.skinVertexB),d.enableVertexAttribArray(q.skinIndex),d.enableVertexAttribArray(q.skinWeight));if(a.attributes)for(g in a.attributes)q[g]!==void 0&&q[g]>=0&&d.enableVertexAttribArray(q[g]);if(a.morphTargets)for(g=a.numSupportedMorphTargets=0;g<this.maxMorphTargets;g++)y="morphTarget"+g,q[y]>=0&&(d.enableVertexAttribArray(q[y]),
a.numSupportedMorphTargets++);a.uniformsList=[];for(f in a.uniforms)a.uniformsList.push([a.uniforms[f],f])};this.setFaceCulling=function(a,b){a?(!b||b==="ccw"?d.frontFace(d.CCW):d.frontFace(d.CW),a==="back"?d.cullFace(d.BACK):a==="front"?d.cullFace(d.FRONT):d.cullFace(d.FRONT_AND_BACK),d.enable(d.CULL_FACE)):d.disable(d.CULL_FACE)}};
THREE.WebGLRenderTarget=function(a,b,c){this.width=a;this.height=b;c=c||{};this.wrapS=c.wrapS!==void 0?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=c.wrapT!==void 0?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=c.magFilter!==void 0?c.magFilter:THREE.LinearFilter;this.minFilter=c.minFilter!==void 0?c.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=c.format!==void 0?c.format:THREE.RGBAFormat;this.type=c.type!==void 0?c.type:
THREE.UnsignedByteType;this.depthBuffer=c.depthBuffer!==void 0?c.depthBuffer:!0;this.stencilBuffer=c.stencilBuffer!==void 0?c.stencilBuffer:!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var a=new THREE.WebGLRenderTarget(this.width,this.height);a.wrapS=this.wrapS;a.wrapT=this.wrapT;a.magFilter=this.magFilter;a.minFilter=this.minFilter;a.offset.copy(this.offset);a.repeat.copy(this.repeat);a.format=this.format;a.type=this.type;a.depthBuffer=this.depthBuffer;a.stencilBuffer=this.stencilBuffer;return a};THREE.WebGLRenderTargetCube=function(a,b,c){THREE.WebGLRenderTarget.call(this,a,b,c);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;
