// ThreeExtras.js r46 - http://github.com/mrdoob/three.js
THREE.ColorUtils={adjustHSV:function(a,c,b,d){var g=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(a,g);g.h=THREE.Math.clamp(g.h+c,0,1);g.s=THREE.Math.clamp(g.s+b,0,1);g.v=THREE.Math.clamp(g.v+d,0,1);a.setHSV(g.h,g.s,g.v)},rgbToHsv:function(a,c){var b=a.r,d=a.g,g=a.b,f=Math.max(Math.max(b,d),g),e=Math.min(Math.min(b,d),g);if(e===f)e=b=0;else{var h=f-e,e=h/f,b=b===f?(d-g)/h:d===f?2+(g-b)/h:4+(b-d)/h;b/=6;b<0&&(b+=1);b>1&&(b-=1)}c===void 0&&(c={h:0,s:0,v:0});c.h=b;c.s=e;c.v=f;return c}};
THREE.ColorUtils.__hsv={h:0,s:0,v:0};
THREE.GeometryUtils={merge:function(a,c){for(var b,d,g=a.vertices.length,f=c instanceof THREE.Mesh?c.geometry:c,e=a.vertices,h=f.vertices,i=a.faces,k=f.faces,j=a.faceVertexUvs[0],q=f.faceVertexUvs[0],o={},n=0;n<a.materials.length;n++)o[a.materials[n].id]=n;if(c instanceof THREE.Mesh)c.matrixAutoUpdate&&c.updateMatrix(),b=c.matrix,d=new THREE.Matrix4,d.extractRotation(b,c.scale);for(var n=0,s=h.length;n<s;n++){var m=new THREE.Vertex(h[n].position.clone());b&&b.multiplyVector3(m.position);e.push(m)}n=
0;for(s=k.length;n<s;n++){var e=k[n],p,l,r=e.vertexNormals,t=e.vertexColors;e instanceof THREE.Face3?p=new THREE.Face3(e.a+g,e.b+g,e.c+g):e instanceof THREE.Face4&&(p=new THREE.Face4(e.a+g,e.b+g,e.c+g,e.d+g));p.normal.copy(e.normal);d&&d.multiplyVector3(p.normal);h=0;for(m=r.length;h<m;h++)l=r[h].clone(),d&&d.multiplyVector3(l),p.vertexNormals.push(l);p.color.copy(e.color);h=0;for(m=t.length;h<m;h++)l=t[h],p.vertexColors.push(l.clone());if(e.materialIndex!==void 0){h=f.materials[e.materialIndex];
m=o[h.id];if(m===void 0)m=a.materials.length,a.materials.push(h);p.materialIndex=m}p.centroid.copy(e.centroid);b&&b.multiplyVector3(p.centroid);i.push(p)}n=0;for(s=q.length;n<s;n++){b=q[n];d=[];h=0;for(m=b.length;h<m;h++)d.push(new THREE.UV(b[h].u,b[h].v));j.push(d)}},clone:function(a){var c=new THREE.Geometry,b,d=a.vertices,g=a.faces,f=a.faceVertexUvs[0];if(a.materials)c.materials=a.materials.slice();a=0;for(b=d.length;a<b;a++){var e=new THREE.Vertex(d[a].position.clone());c.vertices.push(e)}a=0;
for(b=g.length;a<b;a++){var h=g[a],i,k,j=h.vertexNormals,q=h.vertexColors;h instanceof THREE.Face3?i=new THREE.Face3(h.a,h.b,h.c):h instanceof THREE.Face4&&(i=new THREE.Face4(h.a,h.b,h.c,h.d));i.normal.copy(h.normal);d=0;for(e=j.length;d<e;d++)k=j[d],i.vertexNormals.push(k.clone());i.color.copy(h.color);d=0;for(e=q.length;d<e;d++)k=q[d],i.vertexColors.push(k.clone());i.materialIndex=h.materialIndex;i.centroid.copy(h.centroid);c.faces.push(i)}a=0;for(b=f.length;a<b;a++){g=f[a];i=[];d=0;for(e=g.length;d<
e;d++)i.push(new THREE.UV(g[d].u,g[d].v));c.faceVertexUvs[0].push(i)}return c},randomPointInTriangle:function(a,c,b){var d,g,f,e=new THREE.Vector3,h=THREE.GeometryUtils.__v1;d=THREE.GeometryUtils.random();g=THREE.GeometryUtils.random();d+g>1&&(d=1-d,g=1-g);f=1-d-g;e.copy(a);e.multiplyScalar(d);h.copy(c);h.multiplyScalar(g);e.addSelf(h);h.copy(b);h.multiplyScalar(f);e.addSelf(h);return e},randomPointInFace:function(a,c,b){var d,g,f;if(a instanceof THREE.Face3)return d=c.vertices[a.a].position,g=c.vertices[a.b].position,
f=c.vertices[a.c].position,THREE.GeometryUtils.randomPointInTriangle(d,g,f);else if(a instanceof THREE.Face4){d=c.vertices[a.a].position;g=c.vertices[a.b].position;f=c.vertices[a.c].position;var c=c.vertices[a.d].position,e;b?a._area1&&a._area2?(b=a._area1,e=a._area2):(b=THREE.GeometryUtils.triangleArea(d,g,c),e=THREE.GeometryUtils.triangleArea(g,f,c),a._area1=b,a._area2=e):(b=THREE.GeometryUtils.triangleArea(d,g,c),e=THREE.GeometryUtils.triangleArea(g,f,c));return THREE.GeometryUtils.random()*(b+
e)<b?THREE.GeometryUtils.randomPointInTriangle(d,g,c):THREE.GeometryUtils.randomPointInTriangle(g,f,c)}},randomPointsInGeometry:function(a,c){function b(a){function b(d,c){if(c<d)return d;var e=d+Math.floor((c-d)/2);return k[e]>a?b(d,e-1):k[e]<a?b(e+1,c):e}return b(0,k.length-1)}var d,g,f=a.faces,e=a.vertices,h=f.length,i=0,k=[],j,q,o,n;for(g=0;g<h;g++){d=f[g];if(d instanceof THREE.Face3)j=e[d.a].position,q=e[d.b].position,o=e[d.c].position,d._area=THREE.GeometryUtils.triangleArea(j,q,o);else if(d instanceof
THREE.Face4)j=e[d.a].position,q=e[d.b].position,o=e[d.c].position,n=e[d.d].position,d._area1=THREE.GeometryUtils.triangleArea(j,q,n),d._area2=THREE.GeometryUtils.triangleArea(q,o,n),d._area=d._area1+d._area2;i+=d._area;k[g]=i}d=[];e={};for(g=0;g<c;g++)h=THREE.GeometryUtils.random()*i,h=b(h),d[g]=THREE.GeometryUtils.randomPointInFace(f[h],a,!0),e[h]?e[h]+=1:e[h]=1;return d},triangleArea:function(a,c,b){var d,g=THREE.GeometryUtils.__v1;g.sub(a,c);d=g.length();g.sub(a,b);a=g.length();g.sub(c,b);b=g.length();
c=0.5*(d+a+b);return Math.sqrt(c*(c-d)*(c-a)*(c-b))},center:function(a){a.computeBoundingBox();var c=new THREE.Matrix4;c.setTranslation(-0.5*(a.boundingBox.x[1]+a.boundingBox.x[0]),-0.5*(a.boundingBox.y[1]+a.boundingBox.y[0]),-0.5*(a.boundingBox.z[1]+a.boundingBox.z[0]));a.applyMatrix(c);a.computeBoundingBox()}};THREE.GeometryUtils.random=THREE.Math.random16;THREE.GeometryUtils.__v1=new THREE.Vector3;
THREE.ImageUtils={loadTexture:function(a,c,b){var d=new Image,g=new THREE.Texture(d,c);d.onload=function(){g.needsUpdate=!0;b&&b(this)};d.crossOrigin="";d.src=a;return g},loadTextureCube:function(a,c,b){var d,g=[],f=new THREE.Texture(g,c),c=g.loadCount=0;for(d=a.length;c<d;++c)g[c]=new Image,g[c].onload=function(){g.loadCount+=1;if(g.loadCount===6)f.needsUpdate=!0;b&&b(this)},g[c].crossOrigin="",g[c].src=a[c];return f},getNormalMap:function(a,c){var b=function(a){var b=Math.sqrt(a[0]*a[0]+a[1]*a[1]+
a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]};c|=1;var d=a.width,g=a.height,f=document.createElement("canvas");f.width=d;f.height=g;var e=f.getContext("2d");e.drawImage(a,0,0);for(var h=e.getImageData(0,0,d,g).data,i=e.createImageData(d,g),k=i.data,j=0;j<d;j++)for(var q=1;q<g;q++){var o=q-1<0?g-1:q-1,n=(q+1)%g,s=j-1<0?d-1:j-1,m=(j+1)%d,p=[],l=[0,0,h[(q*d+j)*4]/255*c];p.push([-1,0,h[(q*d+s)*4]/255*c]);p.push([-1,-1,h[(o*d+s)*4]/255*c]);p.push([0,-1,h[(o*d+j)*4]/255*c]);p.push([1,-1,h[(o*d+m)*4]/255*c]);
p.push([1,0,h[(q*d+m)*4]/255*c]);p.push([1,1,h[(n*d+m)*4]/255*c]);p.push([0,1,h[(n*d+j)*4]/255*c]);p.push([-1,1,h[(n*d+s)*4]/255*c]);o=[];s=p.length;for(n=0;n<s;n++){var m=p[n],r=p[(n+1)%s],m=[m[0]-l[0],m[1]-l[1],m[2]-l[2]],r=[r[0]-l[0],r[1]-l[1],r[2]-l[2]];o.push(b([m[1]*r[2]-m[2]*r[1],m[2]*r[0]-m[0]*r[2],m[0]*r[1]-m[1]*r[0]]))}p=[0,0,0];for(n=0;n<o.length;n++)p[0]+=o[n][0],p[1]+=o[n][1],p[2]+=o[n][2];p[0]/=o.length;p[1]/=o.length;p[2]/=o.length;l=(q*d+j)*4;k[l]=(p[0]+1)/2*255|0;k[l+1]=(p[1]+0.5)*
255|0;k[l+2]=p[2]*255|0;k[l+3]=255}e.putImageData(i,0,0);return f}};
THREE.SceneUtils={showHierarchy:function(a,c){THREE.SceneUtils.traverseHierarchy(a,function(a){a.visible=c})},traverseHierarchy:function(a,c){var b,d,g=a.children.length;for(d=0;d<g;d++)b=a.children[d],c(b),THREE.SceneUtils.traverseHierarchy(b,c)},createMultiMaterialObject:function(a,c){var b,d=c.length,g=new THREE.Object3D;for(b=0;b<d;b++){var f=new THREE.Mesh(a,c[b]);g.add(f)}return g},cloneObject:function(a){var c;a instanceof THREE.MorphAnimMesh?(c=new THREE.MorphAnimMesh(a.geometry,a.material),
c.duration=a.duration,c.mirroredLoop=a.mirroredLoop,c.time=a.time,c.lastKeyframe=a.lastKeyframe,c.currentKeyframe=a.currentKeyframe,c.direction=a.direction,c.directionBackwards=a.directionBackwards):a instanceof THREE.SkinnedMesh?c=new THREE.SkinnedMesh(a.geometry,a.material):a instanceof THREE.Mesh?c=new THREE.Mesh(a.geometry,a.material):a instanceof THREE.Line?c=new THREE.Line(a.geometry,a.material,a.type):a instanceof THREE.Ribbon?c=new THREE.Ribbon(a.geometry,a.material):a instanceof THREE.ParticleSystem?
(c=new THREE.ParticleSystem(a.geometry,a.material),c.sortParticles=a.sortParticles):a instanceof THREE.Particle?c=new THREE.Particle(a.material):a instanceof THREE.Sprite?(c=new THREE.Sprite({}),c.color.copy(a.color),c.map=a.map,c.blending=a.blending,c.useScreenCoordinates=a.useScreenCoordinates,c.mergeWith3D=a.mergeWith3D,c.affectedByDistance=a.affectedByDistance,c.scaleByViewport=a.scaleByViewport,c.alignment=a.alignment,c.rotation3d.copy(a.rotation3d),c.rotation=a.rotation,c.opacity=a.opacity,
c.uvOffset.copy(a.uvOffset),c.uvScale.copy(a.uvScale)):a instanceof THREE.LOD?c=new THREE.LOD:a instanceof THREE.MarchingCubes?(c=new THREE.MarchingCubes(a.resolution,a.material),c.field.set(a.field),c.isolation=a.isolation):a instanceof THREE.Object3D&&(c=new THREE.Object3D);c.parent=a.parent;c.up.copy(a.up);c.position.copy(a.position);c.rotation instanceof THREE.Vector3&&c.rotation.copy(a.rotation);c.eulerOrder=a.eulerOrder;c.scale.copy(a.scale);c.dynamic=a.dynamic;c.doubleSided=a.doubleSided;c.flipSided=
a.flipSided;c.renderDepth=a.renderDepth;c.rotationAutoUpdate=a.rotationAutoUpdate;c.matrix.copy(a.matrix);c.matrixWorld.copy(a.matrixWorld);c.matrixRotationWorld.copy(a.matrixRotationWorld);c.matrixAutoUpdate=a.matrixAutoUpdate;c.matrixWorldNeedsUpdate=a.matrixWorldNeedsUpdate;c.quaternion.copy(a.quaternion);c.useQuaternion=a.useQuaternion;c.boundRadius=a.boundRadius;c.boundRadiusScale=a.boundRadiusScale;c.visible=a.visible;c.castShadow=a.castShadow;c.receiveShadow=a.receiveShadow;c.frustumCulled=
a.frustumCulled;for(var b=0;b<a.children.length;b++){var d=THREE.SceneUtils.cloneObject(a.children[b]);c.children[b]=d;d.parent=c}if(a instanceof THREE.LOD)for(b=0;b<a.LODs.length;b++)c.LODs[b]={visibleAtDistance:a.LODs[b].visibleAtDistance,object3D:c.children[b]};return c}};
if(THREE.WebGLRenderer)THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},enableReflection:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tCube:{type:"t",value:1,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},tDisplacement:{type:"t",value:5,texture:null},uNormalScale:{type:"f",
value:1},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1},uReflectivity:{type:"f",value:0.5},uOffset:{type:"v2",value:new THREE.Vector2(0,0)},uRepeat:{type:"v2",value:new THREE.Vector2(1,1)}}]),fragmentShader:["uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform bool enableReflection;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform samplerCube tCube;\nuniform float uNormalScale;\nuniform float uReflectivity;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3( 1.0 ), uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\nif( enableAO )\ngl_FragColor.xyz = gl_FragColor.xyz * texture2D( tAO, vUv ).xyz;\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointDiffuse += pointDistance * pointLightColor[ i ] * uDiffuseColor * pointDiffuseWeight;\npointSpecular += pointDistance * pointLightColor[ i ] * uSpecularColor * pointSpecularWeight * pointDiffuseWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirDiffuse += directionalLightColor[ i ] * uDiffuseColor * dirDiffuseWeight;\ndirSpecular += directionalLightColor[ i ] * uSpecularColor * dirSpecularWeight * dirDiffuseWeight;\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * uAmbientColor) + totalSpecular;\nif ( enableReflection ) {\nvec3 wPos = cameraPosition - vViewPosition;\nvec3 vReflect = reflect( normalize( wPos ), normal );\nvec4 cubeColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, uReflectivity );\n}",
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["attribute vec4 tangent;\nuniform vec2 uOffset;\nuniform vec2 uRepeat;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvViewPosition = -mvPosition.xyz;\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv * uRepeat + uOffset;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},cube:{uniforms:{tCube:{type:"t",value:1,texture:null},tFlip:{type:"f",value:-1}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( tFlip * wPos.x, wPos.yz ) );\n}"}}};
THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(){console.log("Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(a){return this.getPoint(this.getUtoTmapping(a))};THREE.Curve.prototype.getPoints=function(a){a||(a=5);var c,b=[];for(c=0;c<=a;c++)b.push(this.getPoint(c/a));return b};THREE.Curve.prototype.getSpacedPoints=function(a){a||(a=5);var c,b=[];for(c=0;c<=a;c++)b.push(this.getPointAt(c/a));return b};
THREE.Curve.prototype.getLength=function(){var a=this.getLengths();return a[a.length-1]};THREE.Curve.prototype.getLengths=function(a){a||(a=200);if(this.cacheArcLengths&&this.cacheArcLengths.length==a+1)return this.cacheArcLengths;var c=[],b,d=this.getPoint(0),g,f=0;c.push(0);for(g=1;g<=a;g++)b=this.getPoint(g/a),f+=b.distanceTo(d),c.push(f),d=b;return this.cacheArcLengths=c};
THREE.Curve.prototype.getUtoTmapping=function(a,c){var b=this.getLengths(),d=0,g=b.length,f;f=c?c:a*b[g-1];for(var e=0,h=g-1,i;e<=h;)if(d=Math.floor(e+(h-e)/2),i=b[d]-f,i<0)e=d+1;else if(i>0)h=d-1;else{h=d;break}d=h;if(b[d]==f)return d/(g-1);e=b[d];return b=(d+(f-e)/(b[d+1]-e))/(g-1)};THREE.Curve.prototype.getNormalVector=function(a){a=this.getTangent(a);return new THREE.Vector2(-a.y,a.x)};
THREE.Curve.prototype.getTangent=function(a){var c=a-1.0E-4;a+=1.0E-4;c<0&&(c=0);a>1&&(a=1);c=this.getPoint(c);a=this.getPoint(a);return c.clone().subSelf(a).normalize()};THREE.Curve.prototype.getTangentAt=function(a){return this.getTangent(this.getUtoTmapping(a))};THREE.LineCurve=function(a,c){a instanceof THREE.Vector2?(this.v1=a,this.v2=c):THREE.LineCurve.oldConstructor.apply(this,arguments)};
THREE.LineCurve.oldConstructor=function(a,c,b,d){this.constructor(new THREE.Vector2(a,c),new THREE.Vector2(b,d))};THREE.LineCurve.prototype=new THREE.Curve;THREE.LineCurve.prototype.constructor=THREE.LineCurve;THREE.LineCurve.prototype.getPoint=function(a){var c=new THREE.Vector2;c.sub(this.v2,this.v1);c.multiplyScalar(a).addSelf(this.v1);return c};THREE.LineCurve.prototype.getPointAt=function(a){return this.getPoint(a)};
THREE.LineCurve.prototype.getTangent=function(){var a=new THREE.Vector2;a.sub(this.v2,this.v1);a.normalize();return a};THREE.QuadraticBezierCurve=function(a,c,b){if(!(c instanceof THREE.Vector2))var d=Array.prototype.slice.call(arguments),a=new THREE.Vector2(d[0],d[1]),c=new THREE.Vector2(d[2],d[3]),b=new THREE.Vector2(d[4],d[5]);this.v0=a;this.v1=c;this.v2=b};THREE.QuadraticBezierCurve.prototype=new THREE.Curve;THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(a){var c;c=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);return new THREE.Vector2(c,a)};THREE.QuadraticBezierCurve.prototype.getTangent=function(a){var c;c=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.y,this.v1.y,this.v2.y);c=new THREE.Vector2(c,a);c.normalize();return c};
THREE.CubicBezierCurve=function(a,c,b,d){if(!(c instanceof THREE.Vector2))var g=Array.prototype.slice.call(arguments),a=new THREE.Vector2(g[0],g[1]),c=new THREE.Vector2(g[2],g[3]),b=new THREE.Vector2(g[4],g[5]),d=new THREE.Vector2(g[6],g[7]);this.v0=a;this.v1=c;this.v2=b;this.v3=d};THREE.CubicBezierCurve.prototype=new THREE.Curve;THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;
THREE.CubicBezierCurve.prototype.getPoint=function(a){var c;c=THREE.Shape.Utils.b3(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Shape.Utils.b3(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(c,a)};THREE.CubicBezierCurve.prototype.getTangent=function(a){var c;c=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);c=new THREE.Vector2(c,a);c.normalize();return c};
THREE.SplineCurve=function(a){this.points=a==void 0?[]:a};THREE.SplineCurve.prototype=new THREE.Curve;THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(a){var c=new THREE.Vector2,b=[],d=this.points,g;g=(d.length-1)*a;a=Math.floor(g);g-=a;b[0]=a==0?a:a-1;b[1]=a;b[2]=a>d.length-2?a:a+1;b[3]=a>d.length-3?a:a+2;c.x=THREE.Curve.Utils.interpolate(d[b[0]].x,d[b[1]].x,d[b[2]].x,d[b[3]].x,g);c.y=THREE.Curve.Utils.interpolate(d[b[0]].y,d[b[1]].y,d[b[2]].y,d[b[3]].y,g);return c};THREE.ArcCurve=function(a,c,b,d,g,f){this.aX=a;this.aY=c;this.aRadius=b;this.aStartAngle=d;this.aEndAngle=g;this.aClockwise=f};
THREE.ArcCurve.prototype=new THREE.Curve;THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.ArcCurve.prototype.getPoint=function(a){var c=this.aEndAngle-this.aStartAngle;this.aClockwise||(a=1-a);a=this.aStartAngle+a*c;return new THREE.Vector2(this.aX+this.aRadius*Math.cos(a),this.aY+this.aRadius*Math.sin(a))};
THREE.Curve.Utils={tangentQuadraticBezier:function(a,c,b,d){return 2*(1-a)*(b-c)+2*a*(d-b)},tangentCubicBezier:function(a,c,b,d,g){return-3*c*(1-a)*(1-a)+3*b*(1-a)*(1-a)-6*a*b*(1-a)+6*a*d*(1-a)-3*a*a*d+3*a*a*g},tangentSpline:function(a){return 6*a*a-6*a+(3*a*a-4*a+1)+(-6*a*a+6*a)+(3*a*a-2*a)},interpolate:function(a,c,b,d,g){var a=(b-a)*0.5,d=(d-c)*0.5,f=g*g;return(2*c-2*b+a+d)*g*f+(-3*c+3*b-2*a-d)*f+a*g+c}};
THREE.Curve.create=function(a,c){a.prototype=new THREE.Curve;a.prototype.constructor=a;a.prototype.getPoint=c;return a};THREE.LineCurve3=THREE.Curve.create(function(a,c){this.v1=a;this.v2=c},function(a){var c=new THREE.Vector3;c.sub(this.v2,this.v1);c.multiplyScalar(a);c.addSelf(this.v1);return c});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(a,c,b){this.v0=a;this.v1=c;this.v2=b},function(a){var c,b;c=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);b=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);a=THREE.Shape.Utils.b2(a,this.v0.z,this.v1.z,this.v2.z);return new THREE.Vector3(c,b,a)});
THREE.CubicBezierCurve3=THREE.Curve.create(function(a,c,b,d){this.v0=a;this.v1=c;this.v2=b;this.v3=d},function(a){var c,b;c=THREE.Shape.Utils.b3(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);b=THREE.Shape.Utils.b3(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);a=THREE.Shape.Utils.b3(a,this.v0.z,this.v1.z,this.v2.z,this.v3.z);return new THREE.Vector3(c,b,a)});
THREE.SplineCurve3=THREE.Curve.create(function(a){this.points=a==void 0?[]:a},function(a){var c=new THREE.Vector3,b=[],d=this.points,g;g=(d.length-1)*a;a=Math.floor(g);g-=a;b[0]=a==0?a:a-1;b[1]=a;b[2]=a>d.length-2?a:a+1;b[3]=a>d.length-3?a:a+2;c.x=THREE.Curve.Utils.interpolate(d[b[0]].x,d[b[1]].x,d[b[2]].x,d[b[3]].x,g);c.y=THREE.Curve.Utils.interpolate(d[b[0]].y,d[b[1]].y,d[b[2]].y,d[b[3]].y,g);c.z=THREE.Curve.Utils.interpolate(d[b[0]].z,d[b[1]].z,d[b[2]].z,d[b[3]].z,g);return c});
THREE.CurvePath=function(){this.curves=[];this.bends=[]};THREE.CurvePath.prototype=new THREE.Curve;THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(a){this.curves.push(a)};THREE.CurvePath.prototype.checkConnection=function(){};THREE.CurvePath.prototype.closePath=function(){};
THREE.CurvePath.prototype.getPoint=function(a){for(var c=a*this.getLength(),b=this.getCurveLengths(),a=0;a<b.length;){if(b[a]>=c)return c=b[a]-c,a=this.curves[a],c=1-c/a.getLength(),a.getPointAt(c);a++}return null};THREE.CurvePath.prototype.getLength=function(){var a=this.getCurveLengths();return a[a.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length)return this.cacheLengths;var a=[],c=0,b,d=this.curves.length;for(b=0;b<d;b++)c+=this.curves[b].getLength(),a.push(c);return this.cacheLengths=a};
THREE.CurvePath.prototype.getBoundingBox=function(){var a=this.getPoints(),c,b,d,g;c=b=Number.NEGATIVE_INFINITY;d=g=Number.POSITIVE_INFINITY;var f,e,h,i;i=new THREE.Vector2;e=0;for(h=a.length;e<h;e++){f=a[e];if(f.x>c)c=f.x;else if(f.x<d)d=f.x;if(f.y>b)b=f.y;else if(f.y<b)g=f.y;i.addSelf(f.x,f.y)}return{minX:d,minY:g,maxX:c,maxY:b,centroid:i.divideScalar(h)}};THREE.CurvePath.prototype.createPointsGeometry=function(a){return this.createGeometry(this.getPoints(a,!0))};
THREE.CurvePath.prototype.createSpacedPointsGeometry=function(a){return this.createGeometry(this.getSpacedPoints(a,!0))};THREE.CurvePath.prototype.createGeometry=function(a){for(var c=new THREE.Geometry,b=0;b<a.length;b++)c.vertices.push(new THREE.Vertex(new THREE.Vector3(a[b].x,a[b].y,0)));return c};THREE.CurvePath.prototype.addWrapPath=function(a){this.bends.push(a)};
THREE.CurvePath.prototype.getTransformedPoints=function(a,c){var b=this.getPoints(a),d,g;if(!c)c=this.bends;d=0;for(g=c.length;d<g;d++)b=this.getWrapPoints(b,c[d]);return b};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(a,c){var b=this.getSpacedPoints(a),d,g;if(!c)c=this.bends;d=0;for(g=c.length;d<g;d++)b=this.getWrapPoints(b,c[d]);return b};
THREE.CurvePath.prototype.getWrapPoints=function(a,c){var b=this.getBoundingBox(),d,g,f,e,h,i;d=0;for(g=a.length;d<g;d++)f=a[d],e=f.x,h=f.y,i=e/b.maxX,i=c.getUtoTmapping(i,e),e=c.getPoint(i),h=c.getNormalVector(i).multiplyScalar(h),f.x=e.x+h.x,f.y=e.y+h.y;return a};THREE.Path=function(a){THREE.CurvePath.call(this);this.actions=[];a&&this.fromPoints(a)};THREE.Path.prototype=new THREE.CurvePath;THREE.Path.prototype.constructor=THREE.Path;
THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc"};THREE.Path.prototype.fromPoints=function(a){this.moveTo(a[0].x,a[0].y);var c,b=a.length;for(c=1;c<b;c++)this.lineTo(a[c].x,a[c].y)};THREE.Path.prototype.moveTo=function(){var a=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:a})};
THREE.Path.prototype.lineTo=function(a,c){var b=Array.prototype.slice.call(arguments),d=this.actions[this.actions.length-1].args;this.curves.push(new THREE.LineCurve(new THREE.Vector2(d[d.length-2],d[d.length-1]),new THREE.Vector2(a,c)));this.actions.push({action:THREE.PathActions.LINE_TO,args:b})};
THREE.Path.prototype.quadraticCurveTo=function(a,c,b,d){var g=Array.prototype.slice.call(arguments),f=this.actions[this.actions.length-1].args;this.curves.push(new THREE.QuadraticBezierCurve(new THREE.Vector2(f[f.length-2],f[f.length-1]),new THREE.Vector2(a,c),new THREE.Vector2(b,d)));this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:g})};
THREE.Path.prototype.bezierCurveTo=function(a,c,b,d,g,f){var e=Array.prototype.slice.call(arguments),h=this.actions[this.actions.length-1].args;this.curves.push(new THREE.CubicBezierCurve(new THREE.Vector2(h[h.length-2],h[h.length-1]),new THREE.Vector2(a,c),new THREE.Vector2(b,d),new THREE.Vector2(g,f)));this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:e})};
THREE.Path.prototype.splineThru=function(a){var c=Array.prototype.slice.call(arguments),b=this.actions[this.actions.length-1].args,b=[new THREE.Vector2(b[b.length-2],b[b.length-1])];Array.prototype.push.apply(b,a);this.curves.push(new THREE.SplineCurve(b));this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:c})};
THREE.Path.prototype.arc=function(a,c,b,d,g,f){var e=Array.prototype.slice.call(arguments);this.curves.push(new THREE.ArcCurve(a,c,b,d,g,f));this.actions.push({action:THREE.PathActions.ARC,args:e})};THREE.Path.prototype.getSpacedPoints=function(a){a||(a=40);for(var c=[],b=0;b<a;b++)c.push(this.getPoint(b/a));return c};
THREE.Path.prototype.getPoints=function(a,c){var a=a||12,b=[],d,g,f,e,h,i,k,j,q,o,n,s,m;d=0;for(g=this.actions.length;d<g;d++)switch(f=this.actions[d],e=f.action,f=f.args,e){case THREE.PathActions.LINE_TO:b.push(new THREE.Vector2(f[0],f[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:h=f[2];i=f[3];q=f[0];o=f[1];b.length>0?(e=b[b.length-1],n=e.x,s=e.y):(e=this.actions[d-1].args,n=e[e.length-2],s=e[e.length-1]);for(e=1;e<=a;e++)m=e/a,f=THREE.Shape.Utils.b2(m,n,q,h),m=THREE.Shape.Utils.b2(m,s,o,
i),b.push(new THREE.Vector2(f,m));break;case THREE.PathActions.BEZIER_CURVE_TO:h=f[4];i=f[5];q=f[0];o=f[1];k=f[2];j=f[3];b.length>0?(e=b[b.length-1],n=e.x,s=e.y):(e=this.actions[d-1].args,n=e[e.length-2],s=e[e.length-1]);for(e=1;e<=a;e++)m=e/a,f=THREE.Shape.Utils.b3(m,n,q,k,h),m=THREE.Shape.Utils.b3(m,s,o,j,i),b.push(new THREE.Vector2(f,m));break;case THREE.PathActions.CSPLINE_THRU:e=this.actions[d-1].args;e=[new THREE.Vector2(e[e.length-2],e[e.length-1])];m=a*f[0].length;e=e.concat(f[0]);f=new THREE.SplineCurve(e);
for(e=1;e<=m;e++)b.push(f.getPointAt(e/m));break;case THREE.PathActions.ARC:e=this.actions[d-1].args;h=f[0];i=f[1];k=f[2];q=f[3];m=f[4];o=!!f[5];j=e[e.length-2];n=e[e.length-1];e.length==0&&(j=n=0);s=m-q;var p=a*2;for(e=1;e<=p;e++)m=e/p,o||(m=1-m),m=q+m*s,f=j+h+k*Math.cos(m),m=n+i+k*Math.sin(m),b.push(new THREE.Vector2(f,m))}c&&b.push(b[0]);return b};THREE.Path.prototype.transform=function(a,c){this.getBoundingBox();return this.getWrapPoints(this.getPoints(c),a)};
THREE.Path.prototype.nltransform=function(a,c,b,d,g,f){var e=this.getPoints(),h,i,k,j,q;h=0;for(i=e.length;h<i;h++)k=e[h],j=k.x,q=k.y,k.x=a*j+c*q+b,k.y=d*q+g*j+f;return e};
THREE.Path.prototype.debug=function(a){var c=this.getBoundingBox();a||(a=document.createElement("canvas"),a.setAttribute("width",c.maxX+100),a.setAttribute("height",c.maxY+100),document.body.appendChild(a));c=a.getContext("2d");c.fillStyle="white";c.fillRect(0,0,a.width,a.height);c.strokeStyle="black";c.beginPath();var b,d,g,a=0;for(b=this.actions.length;a<b;a++)d=this.actions[a],g=d.args,d=d.action,d!=THREE.PathActions.CSPLINE_THRU&&c[d].apply(c,g);c.stroke();c.closePath();c.strokeStyle="red";d=
this.getPoints();a=0;for(b=d.length;a<b;a++)g=d[a],c.beginPath(),c.arc(g.x,g.y,1.5,0,Math.PI*2,!1),c.stroke(),c.closePath()};
THREE.Path.prototype.toShapes=function(){var a,c,b,d,g=[],f=new THREE.Path;a=0;for(c=this.actions.length;a<c;a++)b=this.actions[a],d=b.args,b=b.action,b==THREE.PathActions.MOVE_TO&&f.actions.length!=0&&(g.push(f),f=new THREE.Path),f[b].apply(f,d);f.actions.length!=0&&g.push(f);if(g.length==0)return[];var e,f=[];if(THREE.Shape.Utils.isClockWise(g[0].getPoints())){a=0;for(c=g.length;a<c;a++)d=g[a],THREE.Shape.Utils.isClockWise(d.getPoints())?(e&&f.push(e),e=new THREE.Shape,e.actions=d.actions,e.curves=
d.curves):e.holes.push(d);f.push(e)}else{e=new THREE.Shape;a=0;for(c=g.length;a<c;a++)d=g[a],THREE.Shape.Utils.isClockWise(d.getPoints())?(e.actions=d.actions,e.curves=d.curves,f.push(e),e=new THREE.Shape):e.holes.push(d)}return f};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=new THREE.Path;THREE.Shape.prototype.constructor=THREE.Path;THREE.Shape.prototype.extrude=function(a){return new THREE.ExtrudeGeometry(this,a)};
THREE.Shape.prototype.getPointsHoles=function(a){var c,b=this.holes.length,d=[];for(c=0;c<b;c++)d[c]=this.holes[c].getTransformedPoints(a,this.bends);return d};THREE.Shape.prototype.getSpacedPointsHoles=function(a){var c,b=this.holes.length,d=[];for(c=0;c<b;c++)d[c]=this.holes[c].getTransformedSpacedPoints(a,this.bends);return d};THREE.Shape.prototype.extractAllPoints=function(a){return{shape:this.getTransformedPoints(a),holes:this.getPointsHoles(a)}};
THREE.Shape.prototype.extractAllSpacedPoints=function(a){return{shape:this.getTransformedSpacedPoints(a),holes:this.getSpacedPointsHoles(a)}};
THREE.Shape.Utils={removeHoles:function(a,c){var b=a.concat(),d=b.concat(),g,f,e,h,i,k,j,q,o,n,s=[];for(i=0;i<c.length;i++){k=c[i];Array.prototype.push.apply(d,k);f=Number.POSITIVE_INFINITY;for(g=0;g<k.length;g++){o=k[g];n=[];for(q=0;q<b.length;q++)j=b[q],j=o.distanceToSquared(j),n.push(j),j<f&&(f=j,e=g,h=q)}g=h-1>=0?h-1:b.length-1;f=e-1>=0?e-1:k.length-1;var m=[k[e],b[h],b[g]];q=THREE.FontUtils.Triangulate.area(m);var p=[k[e],k[f],b[h]];o=THREE.FontUtils.Triangulate.area(p);n=h;j=e;h+=1;e+=-1;h<
0&&(h+=b.length);h%=b.length;e<0&&(e+=k.length);e%=k.length;g=h-1>=0?h-1:b.length-1;f=e-1>=0?e-1:k.length-1;m=[k[e],b[h],b[g]];m=THREE.FontUtils.Triangulate.area(m);p=[k[e],k[f],b[h]];p=THREE.FontUtils.Triangulate.area(p);q+o>m+p&&(h=n,e=j,h<0&&(h+=b.length),h%=b.length,e<0&&(e+=k.length),e%=k.length,g=h-1>=0?h-1:b.length-1,f=e-1>=0?e-1:k.length-1);q=b.slice(0,h);o=b.slice(h);n=k.slice(e);j=k.slice(0,e);f=[k[e],k[f],b[h]];s.push([k[e],b[h],b[g]]);s.push(f);b=q.concat(n).concat(j).concat(o)}return{shape:b,
isolatedPts:s,allpoints:d}},triangulateShape:function(a,c){var b=THREE.Shape.Utils.removeHoles(a,c),d=b.allpoints,g=b.isolatedPts,b=THREE.FontUtils.Triangulate(b.shape,!1),f,e,h,i,k={};f=0;for(e=d.length;f<e;f++)i=d[f].x+":"+d[f].y,k[i]!==void 0&&console.log("Duplicate point",i),k[i]=f;f=0;for(e=b.length;f<e;f++){h=b[f];for(d=0;d<3;d++)i=h[d].x+":"+h[d].y,i=k[i],i!==void 0&&(h[d]=i)}f=0;for(e=g.length;f<e;f++){h=g[f];for(d=0;d<3;d++)i=h[d].x+":"+h[d].y,i=k[i],i!==void 0&&(h[d]=i)}return b.concat(g)},
isClockWise:function(a){return THREE.FontUtils.Triangulate.area(a)<0},b2p0:function(a,c){var b=1-a;return b*b*c},b2p1:function(a,c){return 2*(1-a)*a*c},b2p2:function(a,c){return a*a*c},b2:function(a,c,b,d){return this.b2p0(a,c)+this.b2p1(a,b)+this.b2p2(a,d)},b3p0:function(a,c){var b=1-a;return b*b*b*c},b3p1:function(a,c){var b=1-a;return 3*b*b*a*c},b3p2:function(a,c){return 3*(1-a)*a*a*c},b3p3:function(a,c){return a*a*a*c},b3:function(a,c,b,d,g){return this.b3p0(a,c)+this.b3p1(a,b)+this.b3p2(a,d)+
this.b3p3(a,g)}};THREE.TextPath=function(a,c){THREE.Path.call(this);this.parameters=c||{};this.set(a)};THREE.TextPath.prototype.set=function(a,c){this.text=a;var c=c||this.parameters,b=c.curveSegments!==void 0?c.curveSegments:4,d=c.font!==void 0?c.font:"helvetiker",g=c.weight!==void 0?c.weight:"normal",f=c.style!==void 0?c.style:"normal";THREE.FontUtils.size=c.size!==void 0?c.size:100;THREE.FontUtils.divisions=b;THREE.FontUtils.face=d;THREE.FontUtils.weight=g;THREE.FontUtils.style=f};
THREE.TextPath.prototype.toShapes=function(){for(var a=THREE.FontUtils.drawText(this.text).paths,c=[],b=0,d=a.length;b<d;b++)Array.prototype.push.apply(c,a[b].toShapes());return c};
THREE.AnimationHandler=function(){var a=[],c={},b={update:function(b){for(var d=0;d<a.length;d++)a[d].update(b)},addToUpdate:function(b){a.indexOf(b)===-1&&a.push(b)},removeFromUpdate:function(b){b=a.indexOf(b);b!==-1&&a.splice(b,1)},add:function(a){c[a.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+a.name+" already exists in library. Overwriting.");c[a.name]=a;if(a.initialized!==!0){for(var b=0;b<a.hierarchy.length;b++){for(var d=0;d<a.hierarchy[b].keys.length;d++){if(a.hierarchy[b].keys[d].time<
0)a.hierarchy[b].keys[d].time=0;if(a.hierarchy[b].keys[d].rot!==void 0&&!(a.hierarchy[b].keys[d].rot instanceof THREE.Quaternion)){var h=a.hierarchy[b].keys[d].rot;a.hierarchy[b].keys[d].rot=new THREE.Quaternion(h[0],h[1],h[2],h[3])}}if(a.hierarchy[b].keys[0].morphTargets!==void 0){h={};for(d=0;d<a.hierarchy[b].keys.length;d++)for(var i=0;i<a.hierarchy[b].keys[d].morphTargets.length;i++){var k=a.hierarchy[b].keys[d].morphTargets[i];h[k]=-1}a.hierarchy[b].usedMorphTargets=h;for(d=0;d<a.hierarchy[b].keys.length;d++){var j=
{};for(k in h){for(i=0;i<a.hierarchy[b].keys[d].morphTargets.length;i++)if(a.hierarchy[b].keys[d].morphTargets[i]===k){j[k]=a.hierarchy[b].keys[d].morphTargetsInfluences[i];break}i===a.hierarchy[b].keys[d].morphTargets.length&&(j[k]=0)}a.hierarchy[b].keys[d].morphTargetsInfluences=j}}for(d=1;d<a.hierarchy[b].keys.length;d++)a.hierarchy[b].keys[d].time===a.hierarchy[b].keys[d-1].time&&(a.hierarchy[b].keys.splice(d,1),d--);for(d=1;d<a.hierarchy[b].keys.length;d++)a.hierarchy[b].keys[d].index=d}d=parseInt(a.length*
a.fps,10);a.JIT={};a.JIT.hierarchy=[];for(b=0;b<a.hierarchy.length;b++)a.JIT.hierarchy.push(Array(d));a.initialized=!0}},get:function(a){if(typeof a==="string")return c[a]?c[a]:(console.log("THREE.AnimationHandler.get: Couldn't find animation "+a),null)},parse:function(a){var b=[];if(a instanceof THREE.SkinnedMesh)for(var c=0;c<a.bones.length;c++)b.push(a.bones[c]);else d(a,b);return b}},d=function(a,b){b.push(a);for(var c=0;c<a.children.length;c++)d(a.children[c],b)};b.LINEAR=0;b.CATMULLROM=1;b.CATMULLROM_FORWARD=
2;return b}();THREE.Animation=function(a,c,b,d){this.root=a;this.data=THREE.AnimationHandler.get(c);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=b!==void 0?b:THREE.AnimationHandler.LINEAR;this.JITCompile=d!==void 0?d:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,c){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==void 0?a:!0;this.currentTime=c!==void 0?c:0;var b,d=this.hierarchy.length,g;for(b=0;b<d;b++){g=this.hierarchy[b];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)g.useQuaternion=!0;g.matrixAutoUpdate=!0;if(g.animationCache===void 0)g.animationCache={},g.animationCache.prevKey={pos:0,rot:0,scl:0},g.animationCache.nextKey={pos:0,rot:0,scl:0},g.animationCache.originalMatrix=g instanceof
THREE.Bone?g.skinMatrix:g.matrix;var f=g.animationCache.prevKey;g=g.animationCache.nextKey;f.pos=this.data.hierarchy[b].keys[0];f.rot=this.data.hierarchy[b].keys[0];f.scl=this.data.hierarchy[b].keys[0];g.pos=this.getNextKeyWith("pos",b,1);g.rot=this.getNextKeyWith("rot",b,1);g.scl=this.getNextKeyWith("scl",b,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==void 0)this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix:this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix,delete this.hierarchy[a].animationCache};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var c=["pos","rot","scl"],b,d,g,f,e,h,i,k,j=this.data.JIT.hierarchy,q,o;this.currentTime+=a*this.timeScale;o=this.currentTime;q=this.currentTime%=this.data.length;k=parseInt(Math.min(q*this.data.fps,this.data.length*this.data.fps),10);for(var n=0,s=this.hierarchy.length;n<s;n++)if(a=this.hierarchy[n],i=a.animationCache,this.JITCompile&&j[n][k]!==void 0)a instanceof THREE.Bone?(a.skinMatrix=j[n][k],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=
!1):(a.matrix=j[n][k],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)a instanceof THREE.Bone?a.skinMatrix=a.animationCache.originalMatrix:a.matrix=a.animationCache.originalMatrix;for(var m=0;m<3;m++){b=c[m];e=i.prevKey[b];h=i.nextKey[b];if(h.time<=o){if(q<o)if(this.loop){e=this.data.hierarchy[n].keys[0];for(h=this.getNextKeyWith(b,n,1);h.time<q;)e=h,h=this.getNextKeyWith(b,n,h.index+1)}else{this.stop();return}else{do e=h,h=this.getNextKeyWith(b,n,h.index+1);while(h.time<
q)}i.prevKey[b]=e;i.nextKey[b]=h}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;d=(q-e.time)/(h.time-e.time);g=e[b];f=h[b];if(d<0||d>1)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+d+" on bone "+n),d=d<0?0:1;if(b==="pos")if(b=a.position,this.interpolationType===THREE.AnimationHandler.LINEAR)b.x=g[0]+(f[0]-g[0])*d,b.y=g[1]+(f[1]-g[1])*d,b.z=g[2]+(f[2]-g[2])*d;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",n,e.index-1).pos,this.points[1]=g,this.points[2]=f,this.points[3]=this.getNextKeyWith("pos",n,h.index+1).pos,d=d*0.33+0.33,g=this.interpolateCatmullRom(this.points,d),b.x=g[0],b.y=g[1],b.z=g[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)d=this.interpolateCatmullRom(this.points,d*1.01),this.target.set(d[0],d[1],d[2]),this.target.subSelf(b),this.target.y=0,this.target.normalize(),d=Math.atan2(this.target.x,this.target.z),a.rotation.set(0,d,0)}else if(b===
"rot")THREE.Quaternion.slerp(g,f,a.quaternion,d);else if(b==="scl")b=a.scale,b.x=g[0]+(f[0]-g[0])*d,b.y=g[1]+(f[1]-g[1])*d,b.z=g[2]+(f[2]-g[2])*d}}if(this.JITCompile&&j[0][k]===void 0){this.hierarchy[0].update(null,!0);for(n=0;n<this.hierarchy.length;n++)j[n][k]=this.hierarchy[n]instanceof THREE.Bone?this.hierarchy[n].skinMatrix.clone():this.hierarchy[n].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,c){var b=[],d=[],g,f,e,h,i,k;g=(a.length-1)*c;f=Math.floor(g);g-=f;b[0]=f===0?f:f-1;b[1]=f;b[2]=f>a.length-2?f:f+1;b[3]=f>a.length-3?f:f+2;f=a[b[0]];h=a[b[1]];i=a[b[2]];k=a[b[3]];b=g*g;e=g*b;d[0]=this.interpolate(f[0],h[0],i[0],k[0],g,b,e);d[1]=this.interpolate(f[1],h[1],i[1],k[1],g,b,e);d[2]=this.interpolate(f[2],h[2],i[2],k[2],g,b,e);return d};
THREE.Animation.prototype.interpolate=function(a,c,b,d,g,f,e){a=(b-a)*0.5;d=(d-c)*0.5;return(2*(c-b)+a+d)*e+(-3*(c-b)-2*a-d)*f+a*g+c};THREE.Animation.prototype.getNextKeyWith=function(a,c,b){var d=this.data.hierarchy[c].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b=b<d.length-1?b:d.length-1:b%=d.length;b<d.length;b++)if(d[b][a]!==void 0)return d[b];return this.data.hierarchy[c].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,c,b){for(var d=this.data.hierarchy[c].keys,b=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b>0?b:0:b>=0?b:b+d.length;b>=0;b--)if(d[b][a]!==void 0)return d[b];return this.data.hierarchy[c].keys[d.length-1]};
THREE.CubeCamera=function(a,c,b,d){this.heightOffset=b;this.position=new THREE.Vector3(0,b,0);this.cameraPX=new THREE.PerspectiveCamera(90,1,a,c);this.cameraNX=new THREE.PerspectiveCamera(90,1,a,c);this.cameraPY=new THREE.PerspectiveCamera(90,1,a,c);this.cameraNY=new THREE.PerspectiveCamera(90,1,a,c);this.cameraPZ=new THREE.PerspectiveCamera(90,1,a,c);this.cameraNZ=new THREE.PerspectiveCamera(90,1,a,c);this.cameraPX.position=this.position;this.cameraNX.position=this.position;this.cameraPY.position=
this.position;this.cameraNY.position=this.position;this.cameraPZ.position=this.position;this.cameraNZ.position=this.position;this.cameraPX.up.set(0,-1,0);this.cameraNX.up.set(0,-1,0);this.cameraPY.up.set(0,0,1);this.cameraNY.up.set(0,0,-1);this.cameraPZ.up.set(0,-1,0);this.cameraNZ.up.set(0,-1,0);this.targetPX=new THREE.Vector3(0,0,0);this.targetNX=new THREE.Vector3(0,0,0);this.targetPY=new THREE.Vector3(0,0,0);this.targetNY=new THREE.Vector3(0,0,0);this.targetPZ=new THREE.Vector3(0,0,0);this.targetNZ=
new THREE.Vector3(0,0,0);this.renderTarget=new THREE.WebGLRenderTargetCube(d,d,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter});this.updatePosition=function(a){this.position.copy(a);this.position.y+=this.heightOffset;this.targetPX.copy(this.position);this.targetNX.copy(this.position);this.targetPY.copy(this.position);this.targetNY.copy(this.position);this.targetPZ.copy(this.position);this.targetNZ.copy(this.position);this.targetPX.x+=1;this.targetNX.x-=1;this.targetPY.y+=
1;this.targetNY.y-=1;this.targetPZ.z+=1;this.targetNZ.z-=1;this.cameraPX.lookAt(this.targetPX);this.cameraNX.lookAt(this.targetNX);this.cameraPY.lookAt(this.targetPY);this.cameraNY.lookAt(this.targetNY);this.cameraPZ.lookAt(this.targetPZ);this.cameraNZ.lookAt(this.targetNZ)};this.updateCubeMap=function(a,b){var d=this.renderTarget;d.activeCubeFace=0;a.render(b,this.cameraPX,d);d.activeCubeFace=1;a.render(b,this.cameraNX,d);d.activeCubeFace=2;a.render(b,this.cameraPY,d);d.activeCubeFace=3;a.render(b,
this.cameraNY,d);d.activeCubeFace=4;a.render(b,this.cameraPZ,d);d.activeCubeFace=5;a.render(b,this.cameraNZ,d)}};THREE.FirstPersonCamera=function(){console.warn("DEPRECATED: FirstPersonCamera() is FirstPersonControls().")};THREE.PathCamera=function(){console.warn("DEPRECATED: PathCamera() is PathControls().")};THREE.FlyCamera=function(){console.warn("DEPRECATED: FlyCamera() is FlyControls().")};THREE.RollCamera=function(){console.warn("DEPRECATED: RollCamera() is RollControls().")};
THREE.TrackballCamera=function(){console.warn("DEPRECATED: TrackballCamera() is TrackballControls().")};THREE.CombinedCamera=function(a,c,b,d,g,f,e){THREE.Camera.call(this);this.fov=b;this.left=-a/2;this.right=a/2;this.top=c/2;this.bottom=-c/2;this.cameraO=new THREE.OrthographicCamera(a/-2,a/2,c/2,c/-2,f,e);this.cameraP=new THREE.PerspectiveCamera(b,a/c,d,g);this.zoom=1;this.toPerspective()};THREE.CombinedCamera.prototype=new THREE.Camera;THREE.CombinedCamera.prototype.constructor=THREE.CoolCamera;
THREE.CombinedCamera.prototype.toPerspective=function(){this.near=this.cameraP.near;this.far=this.cameraP.far;this.cameraP.fov=this.fov/this.zoom;this.cameraP.updateProjectionMatrix();this.projectionMatrix=this.cameraP.projectionMatrix;this.inPersepectiveMode=!0;this.inOrthographicMode=!1};
THREE.CombinedCamera.prototype.toOrthographic=function(){var a=Math.tan(this.fov/2)*((this.cameraP.near+this.cameraP.far)/2),c=2*a*this.cameraP.aspect/2;a/=this.zoom;c/=this.zoom;this.cameraO.left=-c;this.cameraO.right=c;this.cameraO.top=a;this.cameraO.bottom=-a;this.cameraO.updateProjectionMatrix();this.near=this.cameraO.near;this.far=this.cameraO.far;this.projectionMatrix=this.cameraO.projectionMatrix;this.inPersepectiveMode=!1;this.inOrthographicMode=!0};
THREE.CombinedCamera.prototype.setFov=function(a){this.fov=a;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};THREE.CombinedCamera.prototype.setLens=function(a,c){c||(c=43.25);var b=2*Math.atan(c/(a*2));b*=180/Math.PI;this.setFov(b);return b};THREE.CombinedCamera.prototype.setZoom=function(a){this.zoom=a;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};
THREE.CombinedCamera.prototype.toFrontView=function(){this.rotation.x=0;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toBackView=function(){this.rotation.x=0;this.rotation.y=Math.PI;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toLeftView=function(){this.rotation.x=0;this.rotation.y=-Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=!1};
THREE.CombinedCamera.prototype.toRightView=function(){this.rotation.x=0;this.rotation.y=Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toTopView=function(){this.rotation.x=-Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toBottomView=function(){this.rotation.x=Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};
THREE.FirstPersonControls=function(a,c){function b(a,b){return function(){b.apply(a,arguments)}}this.object=a;this.target=new THREE.Vector3(0,0,0);this.domElement=c!==void 0?c:document;this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=Math.PI;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=
0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.domElement===document?(this.viewHalfX=window.innerWidth/2,this.viewHalfY=window.innerHeight/2):(this.viewHalfX=this.domElement.offsetWidth/2,this.viewHalfY=this.domElement.offsetHeight/2,this.domElement.setAttribute("tabindex",-1));this.onMouseDown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=
!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(a){this.domElement===document?(this.mouseX=a.pageX-this.viewHalfX,this.mouseY=a.pageY-this.viewHalfY):(this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX,this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY)};this.onKeyDown=
function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 82:this.moveUp=!0;break;case 70:this.moveDown=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1;break;case 82:this.moveUp=
!1;break;case 70:this.moveDown=!1}};this.update=function(a){var b=0;if(!this.freeze){if(this.heightSpeed){var c=THREE.Math.clamp(this.object.position.y,this.heightMin,this.heightMax)-this.heightMin;this.autoSpeedFactor=a*c*this.heightCoef}else this.autoSpeedFactor=0;b=a*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.object.translateZ(-(b+this.autoSpeedFactor));this.moveBackward&&this.object.translateZ(b);this.moveLeft&&this.object.translateX(-b);this.moveRight&&
this.object.translateX(b);this.moveUp&&this.object.translateY(b);this.moveDown&&this.object.translateY(-b);c=a*this.lookSpeed;this.activeLook||(c=0);this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;a=this.target;b=this.object.position;a.x=b.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=b.y+100*Math.cos(this.phi);a.z=b.z+100*Math.sin(this.phi)*Math.sin(this.theta)}a=
1;this.constrainVertical&&(a=Math.PI/(this.verticalMax-this.verticalMin));this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c*a);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=THREE.Math.mapLinear(this.phi,0,Math.PI,this.verticalMin,this.verticalMax);a=this.target;b=this.object.position;a.x=b.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=b.y+100*Math.cos(this.phi);a.z=b.z+100*Math.sin(this.phi)*
Math.sin(this.theta);this.object.lookAt(a)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",b(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",b(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",b(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",b(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",b(this,this.onKeyUp),!1)};
THREE.PathControls=function(a,c){function b(a){if((a*=2)<1)return 0.5*a*a;return-0.5*(--a*(a-2)-1)}function d(a,b){return function(){b.apply(a,arguments)}}function g(a,b,d,c){var e={name:d,fps:0.6,length:c,hierarchy:[]},f,g=b.getControlPointsArray(),h=b.getLength(),p=g.length,l=0;f=p-1;b={parent:-1,keys:[]};b.keys[0]={time:0,pos:g[0],rot:[0,0,0,1],scl:[1,1,1]};b.keys[f]={time:c,pos:g[f],rot:[0,0,0,1],scl:[1,1,1]};for(f=1;f<p-1;f++)l=c*h.chunks[f]/h.total,b.keys[f]={time:l,pos:g[f]};e.hierarchy[0]=
b;THREE.AnimationHandler.add(e);return new THREE.Animation(a,d,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function f(a,b){var d,c,e=new THREE.Geometry;for(d=0;d<a.points.length*b;d++)c=d/(a.points.length*b),c=a.getPoint(c),e.vertices[d]=new THREE.Vertex(new THREE.Vector3(c.x,c.y,c.z));return e}this.object=a;this.domElement=c!==void 0?c:document;this.id="PathControls"+THREE.PathControlsIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=
new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.horizontalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.target=new THREE.Object3D;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.domElement===document?(this.viewHalfX=window.innerWidth/2,this.viewHalfY=window.innerHeight/2):(this.viewHalfX=
this.domElement.offsetWidth/2,this.viewHalfY=this.domElement.offsetHeight/2,this.domElement.setAttribute("tabindex",-1));var e=Math.PI*2,h=Math.PI/180;this.update=function(a){var d;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed*a);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed*a);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;a=this.phi%e;this.phi=a>=0?a:a+e;d=this.verticalAngleMap.srcRange;
a=this.verticalAngleMap.dstRange;d=THREE.Math.mapLinear(this.phi,d[0],d[1],a[0],a[1]);var c=a[1]-a[0];this.phi=b((d-a[0])/c)*c+a[0];d=this.horizontalAngleMap.srcRange;a=this.horizontalAngleMap.dstRange;d=THREE.Math.mapLinear(this.theta,d[0],d[1],a[0],a[1]);c=a[1]-a[0];this.theta=b((d-a[0])/c)*c+a[0];a=this.target.position;a.x=100*Math.sin(this.phi)*Math.cos(this.theta);a.y=100*Math.cos(this.phi);a.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.object.lookAt(this.target.position)};this.onMouseMove=
function(a){this.domElement===document?(this.mouseX=a.pageX-this.viewHalfX,this.mouseY=a.pageY-this.viewHalfY):(this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX,this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY)};this.init=function(){this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),b=new THREE.MeshLambertMaterial({color:65280}),
c=new THREE.CubeGeometry(10,10,20),e=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(c,a);a=new THREE.Mesh(e,b);a.position.set(0,10,0);this.animation=g(this.animationParent,this.spline,this.id,this.duration);this.animationParent.add(this.object);this.animationParent.add(this.target);this.animationParent.add(a)}else this.animation=g(this.animationParent,this.spline,this.id,this.duration),this.animationParent.add(this.target),this.animationParent.add(this.object);if(this.createDebugPath){var a=
this.debugPath,b=this.spline,e=f(b,10),c=f(b,10),h=new THREE.LineBasicMaterial({color:16711680,linewidth:3}),e=new THREE.Line(e,h),c=new THREE.ParticleSystem(c,new THREE.ParticleBasicMaterial({color:16755200,size:3}));e.scale.set(1,1,1);a.add(e);c.scale.set(1,1,1);a.add(c);for(var e=new THREE.SphereGeometry(1,16,8),h=new THREE.MeshBasicMaterial({color:65280}),n=0;n<b.points.length;n++)c=new THREE.Mesh(e,h),c.position.copy(b.points[n]),a.add(c)}this.domElement.addEventListener("mousemove",d(this,this.onMouseMove),
!1)}};THREE.PathControlsIdCounter=0;
THREE.FlyControls=function(a,c){function b(a,b){return function(){b.apply(a,arguments)}}this.object=a;this.domElement=c!==void 0?c:document;c&&this.domElement.setAttribute("tabindex",-1);this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.object.useQuaternion=!0;this.tmpQuaternion=new THREE.Quaternion;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,
0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=
1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=
0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.object.moveForward=
!0;break;case 2:this.object.moveBackward=!0}};this.mousemove=function(a){if(!this.dragToLook||this.mouseStatus>0){var b=this.getContainerDimensions(),c=b.size[0]/2,e=b.size[1]/2;this.moveState.yawLeft=-(a.pageX-b.offset[0]-c)/c;this.moveState.pitchDown=(a.pageY-b.offset[1]-e)/e;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(a.button){case 0:this.moveForward=
!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(a){var b=a*this.movementSpeed;a*=this.rollSpeed;this.object.translateX(this.moveVector.x*b);this.object.translateY(this.moveVector.y*b);this.object.translateZ(this.moveVector.z*b);this.tmpQuaternion.set(this.rotationVector.x*a,this.rotationVector.y*a,this.rotationVector.z*a,1).normalize();this.object.quaternion.multiplySelf(this.tmpQuaternion);this.object.matrix.setPosition(this.object.position);this.object.matrix.setRotationFromQuaternion(this.object.quaternion);
this.object.matrixWorldNeedsUpdate=!0};this.updateMovementVector=function(){var a=this.moveState.forward||this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=
-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",b(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",b(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",b(this,
this.mouseup),!1);this.domElement.addEventListener("keydown",b(this,this.keydown),!1);this.domElement.addEventListener("keyup",b(this,this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};
THREE.RollControls=function(a,c){this.object=a;this.domElement=c!==void 0?c:document;this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.object.matrixAutoUpdate=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;var b=new THREE.Vector3,d=new THREE.Vector3,g=new THREE.Vector3,f=new THREE.Matrix4,e=!1,h=1,i=0,k=0,j=0,q=0,o=0,n=window.innerWidth/2,s=window.innerHeight/2;this.update=function(a){if(this.mouseLook){var c=a*this.lookSpeed;
this.rotateHorizontally(c*q);this.rotateVertically(c*o)}c=a*this.movementSpeed;this.object.translateZ(-c*(i>0||this.autoForward&&!(i<0)?1:i));this.object.translateX(c*k);this.object.translateY(c*j);e&&(this.roll+=this.rollSpeed*a*h);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();g.copy(this.forward);d.set(0,1,0);b.cross(d,
g).normalize();d.cross(g,b).normalize();this.object.matrix.n11=b.x;this.object.matrix.n12=d.x;this.object.matrix.n13=g.x;this.object.matrix.n21=b.y;this.object.matrix.n22=d.y;this.object.matrix.n23=g.y;this.object.matrix.n31=b.z;this.object.matrix.n32=d.z;this.object.matrix.n33=g.z;f.identity();f.n11=Math.cos(this.roll);f.n12=-Math.sin(this.roll);f.n21=Math.sin(this.roll);f.n22=Math.cos(this.roll);this.object.matrix.multiplySelf(f);this.object.matrixWorldNeedsUpdate=!0;this.object.matrix.n14=this.object.position.x;
this.object.matrix.n24=this.object.position.y;this.object.matrix.n34=this.object.position.z};this.translateX=function(a){this.object.position.x+=this.object.matrix.n11*a;this.object.position.y+=this.object.matrix.n21*a;this.object.position.z+=this.object.matrix.n31*a};this.translateY=function(a){this.object.position.x+=this.object.matrix.n12*a;this.object.position.y+=this.object.matrix.n22*a;this.object.position.z+=this.object.matrix.n32*a};this.translateZ=function(a){this.object.position.x-=this.object.matrix.n13*
a;this.object.position.y-=this.object.matrix.n23*a;this.object.position.z-=this.object.matrix.n33*a};this.rotateHorizontally=function(a){b.set(this.object.matrix.n11,this.object.matrix.n21,this.object.matrix.n31);b.multiplyScalar(a);this.forward.subSelf(b);this.forward.normalize()};this.rotateVertically=function(a){d.set(this.object.matrix.n12,this.object.matrix.n22,this.object.matrix.n32);d.multiplyScalar(a);this.forward.addSelf(d);this.forward.normalize()};this.domElement.addEventListener("contextmenu",
function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",function(a){q=(a.clientX-n)/window.innerWidth;o=(a.clientY-s)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=1;break;case 2:i=-1}},!1);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=0;break;case 2:i=0}},!1);this.domElement.addEventListener("keydown",
function(a){switch(a.keyCode){case 38:case 87:i=1;break;case 37:case 65:k=-1;break;case 40:case 83:i=-1;break;case 39:case 68:k=1;break;case 81:e=!0;h=1;break;case 69:e=!0;h=-1;break;case 82:j=1;break;case 70:j=-1}},!1);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:i=0;break;case 37:case 65:k=0;break;case 40:case 83:i=0;break;case 39:case 68:k=0;break;case 81:e=!1;break;case 69:e=!1;break;case 82:j=0;break;case 70:j=0}},!1)};
THREE.TrackballControls=function(a,c){var b=this,d={NONE:-1,ROTATE:0,ZOOM:1,PAN:2};this.object=a;this.domElement=c!==void 0?c:document;this.enabled=!0;this.screen={width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=(this.screen.width+this.screen.height)/4;this.rotateSpeed=1;this.zoomSpeed=1.2;this.panSpeed=0.3;this.staticMoving=this.noPan=this.noZoom=this.noRotate=!1;this.dynamicDampingFactor=0.2;this.minDistance=0;this.maxDistance=Infinity;this.keys=[65,83,68];
this.target=new THREE.Vector3(0,0,0);var g=!1,f=d.NONE,e=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,k=new THREE.Vector2,j=new THREE.Vector2,q=new THREE.Vector2,o=new THREE.Vector2;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.getMouseOnScreen=function(a,c){return new THREE.Vector2((a-b.screen.offsetLeft)/b.radius*0.5,(c-b.screen.offsetTop)/b.radius*0.5)};this.getMouseProjectionOnBall=function(a,c){var d=new THREE.Vector3((a-b.screen.width*0.5-
b.screen.offsetLeft)/b.radius,(b.screen.height*0.5+b.screen.offsetTop-c)/b.radius,0),f=d.length();f>1?d.normalize():d.z=Math.sqrt(1-f*f);e.copy(b.object.position).subSelf(b.target);f=b.object.up.clone().setLength(d.y);f.addSelf(b.object.up.clone().crossSelf(e).setLength(d.x));f.addSelf(e.setLength(d.z));return f};this.rotateCamera=function(){var a=Math.acos(h.dot(i)/h.length()/i.length());if(a){var c=(new THREE.Vector3).cross(h,i).normalize(),d=new THREE.Quaternion;a*=b.rotateSpeed;d.setFromAxisAngle(c,
-a);d.multiplyVector3(e);d.multiplyVector3(b.object.up);d.multiplyVector3(i);b.staticMoving?h=i:(d.setFromAxisAngle(c,a*(b.dynamicDampingFactor-1)),d.multiplyVector3(h))}};this.zoomCamera=function(){var a=1+(j.y-k.y)*b.zoomSpeed;a!==1&&a>0&&(e.multiplyScalar(a),b.staticMoving?k=j:k.y+=(j.y-k.y)*this.dynamicDampingFactor)};this.panCamera=function(){var a=o.clone().subSelf(q);if(a.lengthSq()){a.multiplyScalar(e.length()*b.panSpeed);var c=e.clone().crossSelf(b.object.up).setLength(a.x);c.addSelf(b.object.up.clone().setLength(a.y));
b.object.position.addSelf(c);b.target.addSelf(c);b.staticMoving?q=o:q.addSelf(a.sub(o,q).multiplyScalar(b.dynamicDampingFactor))}};this.checkDistances=function(){if(!b.noZoom||!b.noPan)b.object.position.lengthSq()>b.maxDistance*b.maxDistance&&b.object.position.setLength(b.maxDistance),e.lengthSq()<b.minDistance*b.minDistance&&b.object.position.add(b.target,e.setLength(b.minDistance))};this.update=function(){e.copy(b.object.position).subSelf(this.target);b.noRotate||b.rotateCamera();b.noZoom||b.zoomCamera();
b.noPan||b.panCamera();b.object.position.add(b.target,e);b.checkDistances();b.object.lookAt(b.target)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",function(a){b.enabled&&(g&&(h=i=b.getMouseProjectionOnBall(a.clientX,a.clientY),k=j=b.getMouseOnScreen(a.clientX,a.clientY),q=o=b.getMouseOnScreen(a.clientX,a.clientY),g=!1),f!==d.NONE&&(f===d.ROTATE&&!b.noRotate?i=b.getMouseProjectionOnBall(a.clientX,a.clientY):f===d.ZOOM&&
!b.noZoom?j=b.getMouseOnScreen(a.clientX,a.clientY):f===d.PAN&&!b.noPan&&(o=b.getMouseOnScreen(a.clientX,a.clientY))))},!1);this.domElement.addEventListener("mousedown",function(a){if(b.enabled&&(a.preventDefault(),a.stopPropagation(),f===d.NONE))f=a.button,f===d.ROTATE&&!b.noRotate?h=i=b.getMouseProjectionOnBall(a.clientX,a.clientY):f===d.ZOOM&&!b.noZoom?k=j=b.getMouseOnScreen(a.clientX,a.clientY):this.noPan||(q=o=b.getMouseOnScreen(a.clientX,a.clientY))},!1);this.domElement.addEventListener("mouseup",
function(a){if(b.enabled)a.preventDefault(),a.stopPropagation(),f=d.NONE},!1);window.addEventListener("keydown",function(a){if(b.enabled&&f===d.NONE){if(a.keyCode===b.keys[d.ROTATE]&&!b.noRotate)f=d.ROTATE;else if(a.keyCode===b.keys[d.ZOOM]&&!b.noZoom)f=d.ZOOM;else if(a.keyCode===b.keys[d.PAN]&&!b.noPan)f=d.PAN;f!==d.NONE&&(g=!0)}},!1);window.addEventListener("keyup",function(){if(b.enabled&&f!==d.NONE)f=d.NONE},!1)};
THREE.CubeGeometry=function(a,c,b,d,g,f,e,h){function i(a,b,c,e,h,i,j,n){var m,o=d||1,l=g||1,p=h/2,q=i/2,s=k.vertices.length;if(a==="x"&&b==="y"||a==="y"&&b==="x")m="z";else if(a==="x"&&b==="z"||a==="z"&&b==="x")m="y",l=f||1;else if(a==="z"&&b==="y"||a==="y"&&b==="z")m="x",o=f||1;var r=o+1,t=l+1,L=h/o,H=i/l,M=new THREE.Vector3;M[m]=j>0?1:-1;for(h=0;h<t;h++)for(i=0;i<r;i++){var J=new THREE.Vector3;J[a]=(i*L-p)*c;J[b]=(h*H-q)*e;J[m]=j;k.vertices.push(new THREE.Vertex(J))}for(h=0;h<l;h++)for(i=0;i<o;i++)a=
new THREE.Face4(i+r*h+s,i+r*(h+1)+s,i+1+r*(h+1)+s,i+1+r*h+s),a.normal.copy(M),a.vertexNormals.push(M.clone(),M.clone(),M.clone(),M.clone()),a.materialIndex=n,k.faces.push(a),k.faceVertexUvs[0].push([new THREE.UV(i/o,h/l),new THREE.UV(i/o,(h+1)/l),new THREE.UV((i+1)/o,(h+1)/l),new THREE.UV((i+1)/o,h/l)])}THREE.Geometry.call(this);var k=this,j=a/2,q=c/2,o=b/2,n,s,m,p,l,r;if(e!==void 0){if(e instanceof Array)this.materials=e;else{this.materials=[];for(n=0;n<6;n++)this.materials.push(e)}n=0;p=1;s=2;l=
3;m=4;r=5}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(h!=void 0)for(var t in h)this.sides[t]!=void 0&&(this.sides[t]=h[t]);this.sides.px&&i("z","y",-1,-1,b,c,j,n);this.sides.nx&&i("z","y",1,-1,b,c,-j,p);this.sides.py&&i("x","z",1,1,a,b,q,s);this.sides.ny&&i("x","z",1,-1,a,b,-q,l);this.sides.pz&&i("x","y",1,-1,a,c,o,m);this.sides.nz&&i("x","y",-1,-1,a,c,-o,r);this.computeCentroids();this.mergeVertices()};THREE.CubeGeometry.prototype=new THREE.Geometry;
THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(a,c,b,d,g,f){THREE.Geometry.call(this);var a=a!=null?a:20,c=c!=null?c:20,b=b||100,e=b/2,d=d||8,g=g||1,h,i,k=[],j=[];for(i=0;i<=g;i++){var q=[],o=[],n=i/g,s=n*(c-a)+a;for(h=0;h<=d;h++){var m=h/d;this.vertices.push(new THREE.Vertex(new THREE.Vector3(s*Math.sin(m*Math.PI*2),-n*b+e,s*Math.cos(m*Math.PI*2))));q.push(this.vertices.length-1);o.push(new THREE.UV(m,n))}k.push(q);j.push(o)}for(i=0;i<g;i++)for(h=0;h<d;h++){var b=k[i][h],q=k[i+1][h],o=k[i+1][h+1],n=k[i][h+1],s=
this.vertices[b].position.clone().setY(0).normalize(),m=this.vertices[q].position.clone().setY(0).normalize(),p=this.vertices[o].position.clone().setY(0).normalize(),l=this.vertices[n].position.clone().setY(0).normalize(),r=j[i][h].clone(),t=j[i+1][h].clone(),w=j[i+1][h+1].clone(),z=j[i][h+1].clone();this.faces.push(new THREE.Face4(b,q,o,n,[s,m,p,l]));this.faceVertexUvs[0].push([r,t,w,z])}if(!f&&a>0){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,e,0)));for(h=0;h<d;h++)b=k[0][h],q=k[0][h+
1],o=this.vertices.length-1,s=new THREE.Vector3(0,1,0),m=new THREE.Vector3(0,1,0),p=new THREE.Vector3(0,1,0),r=j[0][h].clone(),t=j[0][h+1].clone(),w=new THREE.UV(t.u,0),this.faces.push(new THREE.Face3(b,q,o,[s,m,p])),this.faceVertexUvs[0].push([r,t,w])}if(!f&&c>0){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,-e,0)));for(h=0;h<d;h++)b=k[i][h+1],q=k[i][h],o=this.vertices.length-1,s=new THREE.Vector3(0,-1,0),m=new THREE.Vector3(0,-1,0),p=new THREE.Vector3(0,-1,0),r=j[i][h+1].clone(),t=j[i][h].clone(),
w=new THREE.UV(t.u,1),this.faces.push(new THREE.Face3(b,q,o,[s,m,p])),this.faceVertexUvs[0].push([r,t,w])}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.ExtrudeGeometry=function(a,c){if(typeof a!=="undefined"){THREE.Geometry.call(this);var a=a instanceof Array?a:[a],b,d=a.length,g;this.shapebb=a[d-1].getBoundingBox();for(b=0;b<d;b++)g=a[b],this.addShape(g,c);this.computeCentroids();this.computeFaceNormals()}};THREE.ExtrudeGeometry.prototype=new THREE.Geometry;THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;
THREE.ExtrudeGeometry.prototype.addShape=function(a,c){function b(a,b,c){b||console.log("die");return b.clone().multiplyScalar(c).addSelf(a)}function d(a,b,c){var d=THREE.ExtrudeGeometry.__v1,e=THREE.ExtrudeGeometry.__v2,f=THREE.ExtrudeGeometry.__v3,g=THREE.ExtrudeGeometry.__v4,h=THREE.ExtrudeGeometry.__v5,i=THREE.ExtrudeGeometry.__v6;d.set(a.x-b.x,a.y-b.y);e.set(a.x-c.x,a.y-c.y);d=d.normalize();e=e.normalize();f.set(-d.y,d.x);g.set(e.y,-e.x);h.copy(a).addSelf(f);i.copy(a).addSelf(g);if(h.equals(i))return g.clone();
h.copy(b).addSelf(f);i.copy(c).addSelf(g);f=d.dot(g);g=i.subSelf(h).dot(g);f===0&&(console.log("Either infinite or no solutions!"),g===0?console.log("Its finite solutions."):console.log("Too bad, no solutions."));g/=f;if(g<0)return b=Math.atan2(b.y-a.y,b.x-a.x),a=Math.atan2(c.y-a.y,c.x-a.x),b>a&&(a+=Math.PI*2),a=(b+a)/2,new THREE.Vector2(-Math.cos(a),-Math.sin(a));return d.multiplyScalar(g).addSelf(h).subSelf(a).clone()}function g(a){for(u=a.length;--u>=0;){J=u;N=u-1;N<0&&(N=a.length-1);for(var b=
0,c=n+j*2,b=0;b<c;b++){var d=K*b,e=K*(b+1),f=Q+J+d,g=Q+J+e,k=f,d=Q+N+d,e=Q+N+e,m=g;k+=F;d+=F;e+=F;m+=F;A.faces.push(new THREE.Face4(k,d,e,m,null,null,w));w&&(k=b/c,d=(b+1)/c,e=h+i*2,f=(A.vertices[f].position.z+i)/e,g=(A.vertices[g].position.z+i)/e,A.faceVertexUvs[0].push([new THREE.UV(f,k),new THREE.UV(g,k),new THREE.UV(g,d),new THREE.UV(f,d)]))}}}function f(a,b,c){A.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}function e(a,b,c){a+=F;b+=F;c+=F;A.faces.push(new THREE.Face3(a,b,c,null,
null,t));if(t){var d=z.maxY,e=z.maxX,f=A.vertices[b].position.x,b=A.vertices[b].position.y,g=A.vertices[c].position.x,c=A.vertices[c].position.y;A.faceVertexUvs[0].push([new THREE.UV(A.vertices[a].position.x/e,A.vertices[a].position.y/d),new THREE.UV(f/e,b/d),new THREE.UV(g/e,c/d)])}}var h=c.amount!==void 0?c.amount:100,i=c.bevelThickness!==void 0?c.bevelThickness:6,k=c.bevelSize!==void 0?c.bevelSize:i-2,j=c.bevelSegments!==void 0?c.bevelSegments:3,q=c.bevelEnabled!==void 0?c.bevelEnabled:!0,o=c.curveSegments!==
void 0?c.curveSegments:12,n=c.steps!==void 0?c.steps:1,s=c.bendPath,m=c.extrudePath,p,l=!1,r=c.useSpacedPoints!==void 0?c.useSpacedPoints:!1,t=c.material,w=c.extrudeMaterial,z=this.shapebb;if(m)p=m.getPoints(o),n=p.length,l=!0,q=!1;q||(k=i=j=0);var v,x,y,A=this,F=this.vertices.length;s&&a.addWrapPath(s);o=r?a.extractAllSpacedPoints(o):a.extractAllPoints(o);s=o.shape;o=o.holes;if(m=!THREE.Shape.Utils.isClockWise(s)){s=s.reverse();x=0;for(y=o.length;x<y;x++)v=o[x],THREE.Shape.Utils.isClockWise(v)&&
(o[x]=v.reverse());m=!1}m=THREE.Shape.Utils.triangulateShape(s,o);r=s;x=0;for(y=o.length;x<y;x++)v=o[x],s=s.concat(v);var u,D,B,G,I,E,K=s.length,O=m.length,C=[];u=0;D=r.length;J=D-1;for(N=u+1;u<D;u++,J++,N++)J===D&&(J=0),N===D&&(N=0),C[u]=d(r[u],r[J],r[N]);var L=[],H,M=C.concat();x=0;for(y=o.length;x<y;x++){v=o[x];H=[];u=0;D=v.length;J=D-1;for(N=u+1;u<D;u++,J++,N++)J===D&&(J=0),N===D&&(N=0),H[u]=d(v[u],v[J],v[N]);L.push(H);M=M.concat(H)}for(B=0;B<j;B++){G=B/j;I=i*(1-G);G=k*Math.sin(G*Math.PI/2);u=
0;for(D=r.length;u<D;u++)E=b(r[u],C[u],G),f(E.x,E.y,-I);x=0;for(y=o.length;x<y;x++){v=o[x];H=L[x];u=0;for(D=v.length;u<D;u++)E=b(v[u],H[u],G),f(E.x,E.y,-I)}}G=k;for(u=0;u<K;u++)E=q?b(s[u],M[u],G):s[u],l?f(E.x,E.y+p[0].y,p[0].x):f(E.x,E.y,0);for(B=1;B<=n;B++)for(u=0;u<K;u++)E=q?b(s[u],M[u],G):s[u],l?f(E.x,E.y+p[B-1].y,p[B-1].x):f(E.x,E.y,h/n*B);for(B=j-1;B>=0;B--){G=B/j;I=i*(1-G);G=k*Math.sin(G*Math.PI/2);u=0;for(D=r.length;u<D;u++)E=b(r[u],C[u],G),f(E.x,E.y,h+I);x=0;for(y=o.length;x<y;x++){v=o[x];
H=L[x];u=0;for(D=v.length;u<D;u++)E=b(v[u],H[u],G),l?f(E.x,E.y+p[n-1].y,p[n-1].x+I):f(E.x,E.y,h+I)}}if(q){q=K*0;for(u=0;u<O;u++)k=m[u],e(k[2]+q,k[1]+q,k[0]+q);q=K*(n+j*2);for(u=0;u<O;u++)k=m[u],e(k[0]+q,k[1]+q,k[2]+q)}else{for(u=0;u<O;u++)k=m[u],e(k[2],k[1],k[0]);for(u=0;u<O;u++)k=m[u],e(k[0]+K*n,k[1]+K*n,k[2]+K*n)}var J,N,Q=0;g(r);Q+=r.length;x=0;for(y=o.length;x<y;x++)v=o[x],g(v),Q+=v.length};THREE.ExtrudeGeometry.__v1=new THREE.Vector2;THREE.ExtrudeGeometry.__v2=new THREE.Vector2;
THREE.ExtrudeGeometry.__v3=new THREE.Vector2;THREE.ExtrudeGeometry.__v4=new THREE.Vector2;THREE.ExtrudeGeometry.__v5=new THREE.Vector2;THREE.ExtrudeGeometry.__v6=new THREE.Vector2;
THREE.IcosahedronGeometry=function(a){function c(a,b,c){var d=Math.sqrt(a*a+b*b+c*c);return g.vertices.push(new THREE.Vertex(new THREE.Vector3(a/d,b/d,c/d)))-1}function b(a,b,c,d){var e=g.vertices[a].position,f=g.vertices[b].position,h=g.vertices[c].position,a=new THREE.Face3(a,b,c);a.vertexNormals.push(e.clone().normalize(),f.clone().normalize(),h.clone().normalize());d.faces.push(a);d.faceVertexUvs[0].push([new THREE.UV(1-(Math.atan2(e.z,e.x)+Math.PI)%Math.PI/Math.PI*0.5,0.5-e.y/2),new THREE.UV(1-
(Math.atan2(f.z,f.x)+Math.PI)%Math.PI/Math.PI*0.5,0.5-f.y/2),new THREE.UV(1-(Math.atan2(h.z,h.x)+Math.PI)%Math.PI/Math.PI*0.5,0.5-h.y/2)])}function d(a,b){var d=g.vertices[a].position,e=g.vertices[b].position;return c((d.x+e.x)/2,(d.y+e.y)/2,(d.z+e.z)/2)}var g=this,f=new THREE.Geometry;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;c(-1,a,0);c(1,a,0);c(-1,-a,0);c(1,-a,0);c(0,-1,a);c(0,1,a);c(0,-1,-a);c(0,1,-a);c(a,0,-1);c(a,0,1);c(-a,0,-1);c(-a,0,1);b(0,11,5,f);b(0,5,1,f);b(0,
1,7,f);b(0,7,10,f);b(0,10,11,f);b(1,5,9,f);b(5,11,4,f);b(11,10,2,f);b(10,7,6,f);b(7,1,8,f);b(3,9,4,f);b(3,4,2,f);b(3,2,6,f);b(3,6,8,f);b(3,8,9,f);b(4,9,5,f);b(2,4,11,f);b(6,2,10,f);b(8,6,7,f);b(9,8,1,f);for(var e=0;e<this.subdivisions;e++){var a=new THREE.Geometry,h;for(h in f.faces){var i=d(f.faces[h].a,f.faces[h].b),k=d(f.faces[h].b,f.faces[h].c),j=d(f.faces[h].c,f.faces[h].a);b(f.faces[h].a,i,j,a);b(f.faces[h].b,k,i,a);b(f.faces[h].c,j,k,a);b(i,k,j,a)}f.faces=a.faces;f.faceVertexUvs[0]=a.faceVertexUvs[0]}g.faces=
f.faces;g.faceVertexUvs[0]=f.faceVertexUvs[0];this.computeCentroids();this.computeFaceNormals()};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;
THREE.LatheGeometry=function(a,c,b){THREE.Geometry.call(this);this.steps=c||12;this.angle=b||2*Math.PI;for(var c=this.angle/this.steps,b=[],d=[],g=[],f=[],e=(new THREE.Matrix4).setRotationZ(c),h=0;h<a.length;h++)this.vertices.push(new THREE.Vertex(a[h])),b[h]=a[h].clone(),d[h]=this.vertices.length-1;for(var i=0;i<=this.angle+0.001;i+=c){for(h=0;h<b.length;h++)i<this.angle?(b[h]=e.multiplyVector3(b[h].clone()),this.vertices.push(new THREE.Vertex(b[h])),g[h]=this.vertices.length-1):g=f;i==0&&(f=d);
for(h=0;h<d.length-1;h++)this.faces.push(new THREE.Face4(g[h],g[h+1],d[h+1],d[h])),this.faceVertexUvs[0].push([new THREE.UV(1-i/this.angle,h/a.length),new THREE.UV(1-i/this.angle,(h+1)/a.length),new THREE.UV(1-(i-c)/this.angle,(h+1)/a.length),new THREE.UV(1-(i-c)/this.angle,h/a.length)]);d=g;g=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.OctahedronGeometry=function(a,c){function b(b){var c=b.clone().normalize(),c=new THREE.Vertex(c.clone().multiplyScalar(a));c.index=e.vertices.push(c)-1;c.uv=new THREE.UV(Math.atan2(b.z,-b.x)/2/Math.PI+0.5,Math.atan2(-b.y,Math.sqrt(b.x*b.x+b.z*b.z))/Math.PI+0.5);return c}function d(a,b,c,h){h<1?(h=new THREE.Face3(a.index,b.index,c.index,[a.position,b.position,c.position]),h.centroid.addSelf(a.position).addSelf(b.position).addSelf(c.position).divideScalar(3),h.normal=h.centroid.clone().normalize(),
e.faces.push(h),h=Math.atan2(h.centroid.z,-h.centroid.x),e.faceVertexUvs[0].push([f(a.uv,a.position,h),f(b.uv,b.position,h),f(c.uv,c.position,h)])):(h-=1,d(a,g(a,b),g(a,c),h),d(g(a,b),b,g(b,c),h),d(g(a,c),g(b,c),c,h),d(g(a,b),g(b,c),g(a,c),h))}function g(a,c){h[a.index]||(h[a.index]=[]);h[c.index]||(h[c.index]=[]);var d=h[a.index][c.index];d===void 0&&(h[a.index][c.index]=h[c.index][a.index]=d=b((new THREE.Vector3).add(a.position,c.position).divideScalar(2)));return d}function f(a,b,c){c<0&&a.u===
1&&(a=new THREE.UV(a.u-1,a.v));b.x===0&&b.z===0&&(a=new THREE.UV(c/2/Math.PI+0.5,a.v));return a}THREE.Geometry.call(this);var c=c||0,e=this;b(new THREE.Vector3(1,0,0));b(new THREE.Vector3(-1,0,0));b(new THREE.Vector3(0,1,0));b(new THREE.Vector3(0,-1,0));b(new THREE.Vector3(0,0,1));b(new THREE.Vector3(0,0,-1));var h=[],i=this.vertices;d(i[0],i[2],i[4],c);d(i[0],i[4],i[3],c);d(i[0],i[3],i[5],c);d(i[0],i[5],i[2],c);d(i[1],i[2],i[5],c);d(i[1],i[5],i[3],c);d(i[1],i[3],i[4],c);d(i[1],i[4],i[2],c);this.boundingSphere=
{radius:a}};THREE.OctahedronGeometry.prototype=new THREE.Geometry;THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry;
THREE.PlaneGeometry=function(a,c,b,d){THREE.Geometry.call(this);for(var g=a/2,f=c/2,b=b||1,d=d||1,e=b+1,h=d+1,i=a/b,k=c/d,j=new THREE.Vector3(0,0,1),a=0;a<h;a++)for(c=0;c<e;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*i-g,-(a*k-f),0)));for(a=0;a<d;a++)for(c=0;c<b;c++)g=new THREE.Face4(c+e*a,c+e*(a+1),c+1+e*(a+1),c+1+e*a),g.normal.copy(j),g.vertexNormals.push(j.clone(),j.clone(),j.clone(),j.clone()),this.faces.push(g),this.faceVertexUvs[0].push([new THREE.UV(c/b,a/d),new THREE.UV(c/
b,(a+1)/d),new THREE.UV((c+1)/b,(a+1)/d),new THREE.UV((c+1)/b,a/d)]);this.computeCentroids()};THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(a,c,b,d,g,f,e){THREE.Geometry.call(this);var a=a||50,c=Math.max(3,Math.floor(c)||8),b=Math.max(2,Math.floor(b)||6),d=d!=void 0?d:0,g=g!=void 0?g:Math.PI*2,f=f!=void 0?f:0,e=e!=void 0?e:Math.PI,h,i,k=[],j=[];for(i=0;i<=b;i++){var q=[],o=[];for(h=0;h<=c;h++){var n=h/c,s=i/b;this.vertices.push(new THREE.Vertex(new THREE.Vector3(-a*Math.cos(d+n*g)*Math.sin(f+s*e),a*Math.cos(f+s*e),a*Math.sin(d+n*g)*Math.sin(f+s*e))));q.push(this.vertices.length-1);o.push(new THREE.UV(n,s))}k.push(q);
j.push(o)}for(i=0;i<b;i++)for(h=0;h<c;h++){var d=k[i][h+1],g=k[i][h],f=k[i+1][h],e=k[i+1][h+1],q=this.vertices[d].position.clone().normalize(),o=this.vertices[g].position.clone().normalize(),n=this.vertices[f].position.clone().normalize(),s=this.vertices[e].position.clone().normalize(),m=j[i][h+1].clone(),p=j[i][h].clone(),l=j[i+1][h].clone(),r=j[i+1][h+1].clone();Math.abs(this.vertices[d].position.y)==a?(this.faces.push(new THREE.Face3(d,f,e,[q,n,s])),this.faceVertexUvs[0].push([m,l,r])):Math.abs(this.vertices[f].position.y)==
a?(this.faces.push(new THREE.Face3(d,g,f,[q,o,n])),this.faceVertexUvs[0].push([m,p,l])):(this.faces.push(new THREE.Face4(d,g,f,e,[q,o,n,s])),this.faceVertexUvs[0].push([m,p,l,r]))}this.computeCentroids();this.computeFaceNormals();this.boundingSphere={radius:a}};THREE.SphereGeometry.prototype=new THREE.Geometry;THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.TextGeometry=function(a,c){var b=(new THREE.TextPath(a,c)).toShapes();c.amount=c.height!==void 0?c.height:50;if(c.bevelThickness===void 0)c.bevelThickness=10;if(c.bevelSize===void 0)c.bevelSize=8;if(c.bevelEnabled===void 0)c.bevelEnabled=!1;if(c.bend){var d=b[b.length-1].getBoundingBox().maxX;c.bendPath=new THREE.QuadraticBezierCurve(new THREE.Vector2(0,0),new THREE.Vector2(d/2,120),new THREE.Vector2(d,0))}THREE.ExtrudeGeometry.call(this,b,c)};THREE.TextGeometry.prototype=new THREE.ExtrudeGeometry;
THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},loadFace:function(a){var c=a.familyName.toLowerCase();this.faces[c]=this.faces[c]||{};this.faces[c][a.cssFontWeight]=this.faces[c][a.cssFontWeight]||{};this.faces[c][a.cssFontWeight][a.cssFontStyle]=a;return this.faces[c][a.cssFontWeight][a.cssFontStyle]=a},drawText:function(a){for(var c=this.getFace(),b=this.size/c.resolution,d=
0,g=String(a).split(""),f=g.length,e=[],a=0;a<f;a++){var h=new THREE.Path,h=this.extractGlyphPoints(g[a],c,b,d,h);d+=h.offset;e.push(h.path)}return{paths:e,offset:d/2}},extractGlyphPoints:function(a,c,b,d,g){var f=[],e,h,i,k,j,q,o,n,s,m,p,l=c.glyphs[a]||c.glyphs["?"];if(l){if(l.o){c=l._cachedOutline||(l._cachedOutline=l.o.split(" "));k=c.length;for(a=0;a<k;)switch(i=c[a++],i){case "m":i=c[a++]*b+d;j=c[a++]*b;f.push(new THREE.Vector2(i,j));g.moveTo(i,j);break;case "l":i=c[a++]*b+d;j=c[a++]*b;f.push(new THREE.Vector2(i,
j));g.lineTo(i,j);break;case "q":i=c[a++]*b+d;j=c[a++]*b;n=c[a++]*b+d;s=c[a++]*b;g.quadraticCurveTo(n,s,i,j);if(e=f[f.length-1]){q=e.x;o=e.y;e=1;for(h=this.divisions;e<=h;e++){var r=e/h,t=THREE.Shape.Utils.b2(r,q,n,i),r=THREE.Shape.Utils.b2(r,o,s,j);f.push(new THREE.Vector2(t,r))}}break;case "b":if(i=c[a++]*b+d,j=c[a++]*b,n=c[a++]*b+d,s=c[a++]*-b,m=c[a++]*b+d,p=c[a++]*-b,g.bezierCurveTo(i,j,n,s,m,p),e=f[f.length-1]){q=e.x;o=e.y;e=1;for(h=this.divisions;e<=h;e++)r=e/h,t=THREE.Shape.Utils.b3(r,q,n,
m,i),r=THREE.Shape.Utils.b3(r,o,s,p,j),f.push(new THREE.Vector2(t,r))}}}return{offset:l.ha*b,points:f,path:g}}}};
(function(a){var c=function(a){for(var c=a.length,g=0,f=c-1,e=0;e<c;f=e++)g+=a[f].x*a[e].y-a[e].x*a[f].y;return g*0.5};a.Triangulate=function(a,d){var g=a.length;if(g<3)return null;var f=[],e=[],h=[],i,k,j;if(c(a)>0)for(k=0;k<g;k++)e[k]=k;else for(k=0;k<g;k++)e[k]=g-1-k;var q=2*g;for(k=g-1;g>2;){if(q--<=0){console.log("Warning, unable to triangulate polygon!");if(d)return h;return f}i=k;g<=i&&(i=0);k=i+1;g<=k&&(k=0);j=k+1;g<=j&&(j=0);var o;a:{o=a;var n=i,s=k,m=j,p=g,l=e,r=void 0,t=void 0,w=void 0,
z=void 0,v=void 0,x=void 0,y=void 0,A=void 0,F=void 0,t=o[l[n]].x,w=o[l[n]].y,z=o[l[s]].x,v=o[l[s]].y,x=o[l[m]].x,y=o[l[m]].y;if(1.0E-10>(z-t)*(y-w)-(v-w)*(x-t))o=!1;else{for(r=0;r<p;r++)if(!(r==n||r==s||r==m)){var A=o[l[r]].x,F=o[l[r]].y,u=void 0,D=void 0,B=void 0,G=void 0,I=void 0,E=void 0,K=void 0,O=void 0,C=void 0,L=void 0,H=void 0,M=void 0,u=B=I=void 0,u=x-z,D=y-v,B=t-x,G=w-y,I=z-t,E=v-w,K=A-t,O=F-w,C=A-z,L=F-v,H=A-x,M=F-y,u=u*L-D*C,I=I*O-E*K,B=B*M-G*H;if(u>=0&&B>=0&&I>=0){o=!1;break a}}o=!0}}if(o){f.push([a[e[i]],
a[e[k]],a[e[j]]]);h.push([e[i],e[k],e[j]]);i=k;for(j=k+1;j<g;i++,j++)e[i]=e[j];g--;q=2*g}}if(d)return h;return f};a.Triangulate.area=c;return a})(THREE.FontUtils);self._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(a,c,b,d,g){THREE.Geometry.call(this);this.radius=a||100;this.tube=c||40;this.segmentsR=b||8;this.segmentsT=d||6;this.arc=g||Math.PI*2;g=new THREE.Vector3;a=[];c=[];for(b=0;b<=this.segmentsR;b++)for(d=0;d<=this.segmentsT;d++){var f=d/this.segmentsT*this.arc,e=b/this.segmentsR*Math.PI*2;g.x=this.radius*Math.cos(f);g.y=this.radius*Math.sin(f);var h=new THREE.Vector3;h.x=(this.radius+this.tube*Math.cos(e))*Math.cos(f);h.y=(this.radius+this.tube*Math.cos(e))*Math.sin(f);h.z=
this.tube*Math.sin(e);this.vertices.push(new THREE.Vertex(h));a.push(new THREE.UV(d/this.segmentsT,1-b/this.segmentsR));c.push(h.clone().subSelf(g).normalize())}for(b=1;b<=this.segmentsR;b++)for(d=1;d<=this.segmentsT;d++){var g=(this.segmentsT+1)*b+d-1,f=(this.segmentsT+1)*(b-1)+d-1,e=(this.segmentsT+1)*(b-1)+d,h=(this.segmentsT+1)*b+d,i=new THREE.Face4(g,f,e,h,[c[g],c[f],c[e],c[h]]);i.normal.addSelf(c[g]);i.normal.addSelf(c[f]);i.normal.addSelf(c[e]);i.normal.addSelf(c[h]);i.normal.normalize();this.faces.push(i);
this.faceVertexUvs[0].push([a[g].clone(),a[f].clone(),a[e].clone(),a[h].clone()])}this.computeCentroids()};THREE.TorusGeometry.prototype=new THREE.Geometry;THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(a,c,b,d,g,f,e){function h(a,b,c,d,e,f){b=c/d*a;c=Math.cos(b);return new THREE.Vector3(e*(2+c)*0.5*Math.cos(a),e*(2+c)*Math.sin(a)*0.5,f*e*Math.sin(b)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=c||40;this.segmentsR=b||64;this.segmentsT=d||8;this.p=g||2;this.q=f||3;this.heightScale=e||1;this.grid=Array(this.segmentsR);b=new THREE.Vector3;d=new THREE.Vector3;f=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(c=0;c<
this.segmentsT;++c){var i=a/this.segmentsR*2*this.p*Math.PI,e=c/this.segmentsT*2*Math.PI,g=h(i,e,this.q,this.p,this.radius,this.heightScale),i=h(i+0.01,e,this.q,this.p,this.radius,this.heightScale);b.x=i.x-g.x;b.y=i.y-g.y;b.z=i.z-g.z;d.x=i.x+g.x;d.y=i.y+g.y;d.z=i.z+g.z;f.cross(b,d);d.cross(f,b);f.normalize();d.normalize();i=-this.tube*Math.cos(e);e=this.tube*Math.sin(e);g.x+=i*d.x+e*f.x;g.y+=i*d.y+e*f.y;g.z+=i*d.z+e*f.z;this.grid[a][c]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(g.x,g.y,
g.z)))-1}}for(a=0;a<this.segmentsR;++a)for(c=0;c<this.segmentsT;++c){var d=(a+1)%this.segmentsR,f=(c+1)%this.segmentsT,g=this.grid[a][c],b=this.grid[d][c],d=this.grid[d][f],f=this.grid[a][f],e=new THREE.UV(a/this.segmentsR,c/this.segmentsT),i=new THREE.UV((a+1)/this.segmentsR,c/this.segmentsT),k=new THREE.UV((a+1)/this.segmentsR,(c+1)/this.segmentsT),j=new THREE.UV(a/this.segmentsR,(c+1)/this.segmentsT);this.faces.push(new THREE.Face4(g,b,d,f));this.faceVertexUvs[0].push([e,i,k,j])}this.computeCentroids();
this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;THREE.SubdivisionModifier=function(a){this.subdivisions=a===void 0?1:a;this.useOldVertexColors=!1;this.supportUVs=!0};THREE.SubdivisionModifier.prototype.constructor=THREE.SubdivisionModifier;THREE.SubdivisionModifier.prototype.modify=function(a){for(var c=this.subdivisions;c-- >0;)this.smooth(a)};
THREE.SubdivisionModifier.prototype.smooth=function(a){function c(a,b,c,d,h,i){var j=new THREE.Face4(a,b,c,d,null,h.color,h.material);if(e.useOldVertexColors){j.vertexColors=[];for(var k,n,m,l=0;l<4;l++){m=i[l];k=new THREE.Color;k.setRGB(0,0,0);for(var p=0;p<m.length;p++)n=h.vertexColors[m[p]-1],k.r+=n.r,k.g+=n.g,k.b+=n.b;k.r/=m.length;k.g/=m.length;k.b/=m.length;j.vertexColors[l]=k}}g.push(j);(!e.supportUVs||o.length!=0)&&f.push([o[a],o[b],o[c],o[d]])}function b(a,b){return Math.min(a,b)+"_"+Math.max(a,
b)}var d=[],g=[],f=[],e=this,h=a.vertices,d=a.faces,i=h.concat(),k=[],j={},q={},o=[],n,s,m,p,l,r=a.faceVertexUvs[0];n=0;for(s=r.length;n<s;n++){m=0;for(p=r[n].length;m<p;m++)l=d[n]["abcd".charAt(m)],o[l]||(o[l]=r[n][m])}var t;n=0;for(s=d.length;n<s;n++)if(l=d[n],k.push(l.centroid),i.push(new THREE.Vertex(l.centroid)),e.supportUVs&&o.length!=0){t=new THREE.UV;if(l instanceof THREE.Face3)t.u=o[l.a].u+o[l.b].u+o[l.c].u,t.v=o[l.a].v+o[l.b].v+o[l.c].v,t.u/=3,t.v/=3;else if(l instanceof THREE.Face4)t.u=
o[l.a].u+o[l.b].u+o[l.c].u+o[l.d].u,t.v=o[l.a].v+o[l.b].v+o[l.c].v+o[l.d].v,t.u/=4,t.v/=4;o.push(t)}s=function(a){function c(a,b,d){a[b]===void 0&&(a[b]=[]);a[b].push(d)}var d,e,f,g,h={};d=0;for(e=a.faces.length;d<e;d++)f=a.faces[d],f instanceof THREE.Face3?(g=b(f.a,f.b),c(h,g,d),g=b(f.b,f.c),c(h,g,d),g=b(f.c,f.a),c(h,g,d)):f instanceof THREE.Face4&&(g=b(f.a,f.b),c(h,g,d),g=b(f.b,f.c),c(h,g,d),g=b(f.c,f.d),c(h,g,d),g=b(f.d,f.a),c(h,g,d));return h}(a);var w=0,r=h.length,z,v,x={},y={},A=function(a,
b){x[a]===void 0&&(x[a]=[]);x[a].push(b)},F=function(a,b){y[a]===void 0&&(y[a]={});y[a][b]=null};for(n in s){t=s[n];z=n.split("_");v=z[0];z=z[1];A(v,[v,z]);A(z,[v,z]);m=0;for(p=t.length;m<p;m++)l=t[m],F(v,l,n),F(z,l,n);t.length<2&&(q[n]=!0)}for(n in s)if(t=s[n],l=t[0],t=t[1],z=n.split("_"),v=z[0],z=z[1],p=new THREE.Vector3,q[n]?(p.addSelf(h[v].position),p.addSelf(h[z].position),p.multiplyScalar(0.5)):(p.addSelf(k[l]),p.addSelf(k[t]),p.addSelf(h[v].position),p.addSelf(h[z].position),p.multiplyScalar(0.25)),
j[n]=r+d.length+w,i.push(new THREE.Vertex(p)),w++,e.supportUVs&&o.length!=0)t=new THREE.UV,t.u=o[v].u+o[z].u,t.v=o[v].v+o[z].v,t.u/=2,t.v/=2,o.push(t);var u,D;z=["123","12","2","23"];p=["123","23","3","31"];var A=["123","31","1","12"],F=["1234","12","2","23"],B=["1234","23","3","34"],G=["1234","34","4","41"],I=["1234","41","1","12"];n=0;for(s=k.length;n<s;n++)l=d[n],t=r+n,l instanceof THREE.Face3?(w=b(l.a,l.b),v=b(l.b,l.c),u=b(l.c,l.a),c(t,j[w],l.b,j[v],l,z),c(t,j[v],l.c,j[u],l,p),c(t,j[u],l.a,j[w],
l,A)):l instanceof THREE.Face4?(w=b(l.a,l.b),v=b(l.b,l.c),u=b(l.c,l.d),D=b(l.d,l.a),c(t,j[w],l.b,j[v],l,F),c(t,j[v],l.c,j[u],l,B),c(t,j[u],l.d,j[D],l,G),c(t,j[D],l.a,j[w],l,I)):console.log("face should be a face!",l);d=i;i=new THREE.Vector3;j=new THREE.Vector3;n=0;for(s=h.length;n<s;n++)if(x[n]!==void 0){i.set(0,0,0);j.set(0,0,0);l=new THREE.Vector3(0,0,0);t=0;for(m in y[n])i.addSelf(k[m]),t++;w=0;r=x[n].length;for(m=0;m<r;m++)q[b(x[n][m][0],x[n][m][1])]&&w++;if(w!=2){i.divideScalar(t);for(m=0;m<
r;m++)t=x[n][m],t=h[t[0]].position.clone().addSelf(h[t[1]].position).divideScalar(2),j.addSelf(t);j.divideScalar(r);l.addSelf(h[n].position);l.multiplyScalar(r-3);l.addSelf(i);l.addSelf(j.multiplyScalar(2));l.divideScalar(r);d[n].position=l}}a.vertices=d;a.faces=g;a.faceVertexUvs[0]=f;delete a.__tmpVertices;a.computeCentroids();a.computeFaceNormals();a.computeVertexNormals()};
THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={constructor:THREE.Loader,addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var c="Loaded ";c+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/
1E3).toFixed(2)+" KB";this.statusDomElement.innerHTML=c},extractUrlbase:function(a){a=a.split("/");a.pop();return a.length<1?"":a.join("/")+"/"},initMaterials:function(a,c,b){a.materials=[];for(var d=0;d<c.length;++d)a.materials[d]=THREE.Loader.prototype.createMaterial(c[d],b)},hasNormals:function(a){var c,b,d=a.materials.length;for(b=0;b<d;b++)if(c=a.materials[b],c instanceof THREE.ShaderMaterial)return!0;return!1},createMaterial:function(a,c){function b(a){a=Math.log(a)/Math.LN2;return Math.floor(a)==
a}function d(a,c){var d=new Image;d.onload=function(){if(!b(this.width)||!b(this.height)){var c=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),d=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));a.image.width=c;a.image.height=d;a.image.getContext("2d").drawImage(this,0,0,c,d)}else a.image=this;a.needsUpdate=!0};d.src=c}function g(a,b,e,f,g,h){var i=document.createElement("canvas");a[b]=new THREE.Texture(i);a[b].sourceFile=e;if(f){a[b].repeat.set(f[0],f[1]);if(f[0]!=1)a[b].wrapS=THREE.RepeatWrapping;
if(f[1]!=1)a[b].wrapT=THREE.RepeatWrapping}g&&a[b].offset.set(g[0],g[1]);if(h){f={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(f[h[0]]!==void 0)a[b].wrapS=f[h[0]];if(f[h[1]]!==void 0)a[b].wrapT=f[h[1]]}d(a[b],c+"/"+e)}function f(a){return(a[0]*255<<16)+(a[1]*255<<8)+a[2]*255}var e,h,i;h="MeshLambertMaterial";e={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};a.shading&&(a.shading=="Phong"?h="MeshPhongMaterial":a.shading=="Basic"&&(h="MeshBasicMaterial"));
if(a.blending)if(a.blending=="Additive")e.blending=THREE.AdditiveBlending;else if(a.blending=="Subtractive")e.blending=THREE.SubtractiveBlending;else if(a.blending=="Multiply")e.blending=THREE.MultiplyBlending;if(a.transparent!==void 0||a.opacity<1)e.transparent=a.transparent;if(a.depthTest!==void 0)e.depthTest=a.depthTest;if(a.vertexColors!==void 0)if(a.vertexColors=="face")e.vertexColors=THREE.FaceColors;else if(a.vertexColors)e.vertexColors=THREE.VertexColors;if(a.colorDiffuse)e.color=f(a.colorDiffuse);
else if(a.DbgColor)e.color=a.DbgColor;if(a.colorSpecular)e.specular=f(a.colorSpecular);if(a.colorAmbient)e.ambient=f(a.colorAmbient);if(a.transparency)e.opacity=a.transparency;if(a.specularCoef)e.shininess=a.specularCoef;a.mapDiffuse&&c&&g(e,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&c&&g(e,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&c&&g(e,"normalMap",a.mapNormal,a.mapNormalRepeat,a.mapNormalOffset,a.mapNormalWrap);
a.mapSpecular&&c&&g(e,"specularMap",a.mapSpecular,a.mapSpecularRepeat,a.mapSpecularOffset,a.mapSpecularWrap);if(a.mapNormal){var k=THREE.ShaderUtils.lib.normal,j=THREE.UniformsUtils.clone(k.uniforms),q=e.color;h=e.specular;i=e.ambient;var o=e.shininess;j.tNormal.texture=e.normalMap;if(a.mapNormalFactor)j.uNormalScale.value=a.mapNormalFactor;if(e.map)j.tDiffuse.texture=e.map,j.enableDiffuse.value=!0;if(e.specularMap)j.tSpecular.texture=e.specularMap,j.enableSpecular.value=!0;if(e.lightMap)j.tAO.texture=
e.lightMap,j.enableAO.value=!0;j.uDiffuseColor.value.setHex(q);j.uSpecularColor.value.setHex(h);j.uAmbientColor.value.setHex(i);j.uShininess.value=o;if(e.opacity)j.uOpacity.value=e.opacity;e=new THREE.ShaderMaterial({fragmentShader:k.fragmentShader,vertexShader:k.vertexShader,uniforms:j,lights:!0,fog:!0})}else e=new THREE[h](e);return e}};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;
THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;THREE.BinaryLoader.prototype.load=function(a,c,b,d){if(a instanceof Object)console.warn("DEPRECATED: BinaryLoader( parameters ) is now BinaryLoader( url, callback, texturePath, binaryPath )."),d=a,a=d.model,c=d.callback,b=d.texture_path,d=d.bin_path;var b=b?b:this.extractUrlbase(a),d=d?d:this.extractUrlbase(a),g=this.showProgress?THREE.Loader.prototype.updateProgress:null;this.onLoadStart();this.loadAjaxJSON(this,a,c,b,d,g)};
THREE.BinaryLoader.prototype.loadAjaxJSON=function(a,c,b,d,g,f){var e=new XMLHttpRequest;e.onreadystatechange=function(){if(e.readyState==4)if(e.status==200||e.status==0)try{var h=JSON.parse(e.responseText);h.metadata===void 0||h.metadata.formatVersion===void 0||h.metadata.formatVersion!==3?console.error("Deprecated file format."):a.loadAjaxBuffers(h,b,g,d,f)}catch(i){console.error(i),console.warn("DEPRECATED: ["+c+"] seems to be using old model format")}else console.error("Couldn't load ["+c+"] ["+
e.status+"]")};e.open("GET",c,!0);e.overrideMimeType("text/plain; charset=x-user-defined");e.setRequestHeader("Content-Type","text/plain");e.send(null)};
THREE.BinaryLoader.prototype.loadAjaxBuffers=function(a,c,b,d,g){var f=new XMLHttpRequest,e=b+"/"+a.buffers,h=0;f.onreadystatechange=function(){f.readyState==4?f.status==200||f.status==0?THREE.BinaryLoader.prototype.createBinModel(f.response,c,d,a.materials):console.error("Couldn't load ["+e+"] ["+f.status+"]"):f.readyState==3?g&&(h==0&&(h=f.getResponseHeader("Content-Length")),g({total:h,loaded:f.responseText.length})):f.readyState==2&&(h=f.getResponseHeader("Content-Length"))};f.open("GET",e,!0);
f.responseType="arraybuffer";f.send(null)};
THREE.BinaryLoader.prototype.createBinModel=function(a,c,b,d){var g=function(b){function c(a){return a%4?4-a%4:0}function g(a,b){return(new Uint8Array(a,b,1))[0]}function i(a,b){return(new Uint32Array(a,b,1))[0]}function k(b,c){var d,e,f,g,h,i,j,k,l=new Uint32Array(a,c,3*b);for(d=0;d<b;d++){e=l[d*3];f=l[d*3+1];g=l[d*3+2];h=t[e*2];e=t[e*2+1];i=t[f*2];j=t[f*2+1];f=t[g*2];k=t[g*2+1];g=m.faceVertexUvs[0];var n=[];n.push(new THREE.UV(h,e));n.push(new THREE.UV(i,j));n.push(new THREE.UV(f,k));g.push(n)}}
function j(b,c){var d,e,f,g,h,i,j,k,l,n,o=new Uint32Array(a,c,4*b);for(d=0;d<b;d++){e=o[d*4];f=o[d*4+1];g=o[d*4+2];h=o[d*4+3];i=t[e*2];e=t[e*2+1];j=t[f*2];l=t[f*2+1];k=t[g*2];n=t[g*2+1];g=t[h*2];f=t[h*2+1];h=m.faceVertexUvs[0];var p=[];p.push(new THREE.UV(i,e));p.push(new THREE.UV(j,l));p.push(new THREE.UV(k,n));p.push(new THREE.UV(g,f));h.push(p)}}function q(b,c,d){for(var e,f,g,h,c=new Uint32Array(a,c,3*b),i=new Uint16Array(a,d,b),d=0;d<b;d++)e=c[d*3],f=c[d*3+1],g=c[d*3+2],h=i[d],m.faces.push(new THREE.Face3(e,
f,g,null,null,h))}function o(b,c,d){for(var e,f,g,h,i,c=new Uint32Array(a,c,4*b),j=new Uint16Array(a,d,b),d=0;d<b;d++)e=c[d*4],f=c[d*4+1],g=c[d*4+2],h=c[d*4+3],i=j[d],m.faces.push(new THREE.Face4(e,f,g,h,null,null,i))}function n(b,c,d,e){for(var f,g,h,i,j,k,l,c=new Uint32Array(a,c,3*b),d=new Uint32Array(a,d,3*b),n=new Uint16Array(a,e,b),e=0;e<b;e++){f=c[e*3];g=c[e*3+1];h=c[e*3+2];j=d[e*3];k=d[e*3+1];l=d[e*3+2];i=n[e];var o=r[k*3],p=r[k*3+1];k=r[k*3+2];var q=r[l*3],s=r[l*3+1];l=r[l*3+2];m.faces.push(new THREE.Face3(f,
g,h,[new THREE.Vector3(r[j*3],r[j*3+1],r[j*3+2]),new THREE.Vector3(o,p,k),new THREE.Vector3(q,s,l)],null,i))}}function s(b,c,d,e){for(var f,g,h,i,j,k,l,n,o,c=new Uint32Array(a,c,4*b),d=new Uint32Array(a,d,4*b),p=new Uint16Array(a,e,b),e=0;e<b;e++){f=c[e*4];g=c[e*4+1];h=c[e*4+2];i=c[e*4+3];k=d[e*4];l=d[e*4+1];n=d[e*4+2];o=d[e*4+3];j=p[e];var q=r[l*3],s=r[l*3+1];l=r[l*3+2];var t=r[n*3],v=r[n*3+1];n=r[n*3+2];var w=r[o*3],x=r[o*3+1];o=r[o*3+2];m.faces.push(new THREE.Face4(f,g,h,i,[new THREE.Vector3(r[k*
3],r[k*3+1],r[k*3+2]),new THREE.Vector3(q,s,l),new THREE.Vector3(t,v,n),new THREE.Vector3(w,x,o)],null,j))}}var m=this,p=0,l,r=[],t=[],w,z,v,x,y,A;THREE.Geometry.call(this);THREE.Loader.prototype.initMaterials(m,d,b);l={signature:function(a,b,c){for(var a=new Uint8Array(a,b,c),d="",e=0;e<c;e++)d+=String.fromCharCode(a[b+e]);return d}(a,p,12),header_bytes:g(a,p+12),vertex_coordinate_bytes:g(a,p+13),normal_coordinate_bytes:g(a,p+14),uv_coordinate_bytes:g(a,p+15),vertex_index_bytes:g(a,p+16),normal_index_bytes:g(a,
p+17),uv_index_bytes:g(a,p+18),material_index_bytes:g(a,p+19),nvertices:i(a,p+20),nnormals:i(a,p+20+4),nuvs:i(a,p+20+8),ntri_flat:i(a,p+20+12),ntri_smooth:i(a,p+20+16),ntri_flat_uv:i(a,p+20+20),ntri_smooth_uv:i(a,p+20+24),nquad_flat:i(a,p+20+28),nquad_smooth:i(a,p+20+32),nquad_flat_uv:i(a,p+20+36),nquad_smooth_uv:i(a,p+20+40)};l.signature!=="Three.js 003"&&console.warn("DEPRECATED: binary model seems to be using old format");p+=l.header_bytes;b=l.vertex_index_bytes*3+l.material_index_bytes;A=l.vertex_index_bytes*
4+l.material_index_bytes;w=l.ntri_flat*b;z=l.ntri_smooth*(b+l.normal_index_bytes*3);v=l.ntri_flat_uv*(b+l.uv_index_bytes*3);x=l.ntri_smooth_uv*(b+l.normal_index_bytes*3+l.uv_index_bytes*3);y=l.nquad_flat*A;b=l.nquad_smooth*(A+l.normal_index_bytes*4);A=l.nquad_flat_uv*(A+l.uv_index_bytes*4);p+=function(b){var c=l.nvertices,b=new Float32Array(a,b,c*3),d,e,f,g;for(d=0;d<c;d++)e=b[d*3],f=b[d*3+1],g=b[d*3+2],m.vertices.push(new THREE.Vertex(new THREE.Vector3(e,f,g)));return c*3*Float32Array.BYTES_PER_ELEMENT}(p);
p+=function(b){var c=l.nnormals;if(c){var b=new Int8Array(a,b,c*3),d,e,f,g;for(d=0;d<c;d++)e=b[d*3],f=b[d*3+1],g=b[d*3+2],r.push(e/127,f/127,g/127)}return c*3*Int8Array.BYTES_PER_ELEMENT}(p);p+=c(l.nnormals*3);p+=function(b){var c=l.nuvs;if(c){var b=new Float32Array(a,b,c*2),d,e,f;for(d=0;d<c;d++)e=b[d*2],f=b[d*2+1],t.push(e,f)}return c*2*Float32Array.BYTES_PER_ELEMENT}(p);w=p+w+c(l.ntri_flat*2);z=w+z+c(l.ntri_smooth*2);v=z+v+c(l.ntri_flat_uv*2);x=v+x+c(l.ntri_smooth_uv*2);y=x+y+c(l.nquad_flat*2);
b=y+b+c(l.nquad_smooth*2);A=b+A+c(l.nquad_flat_uv*2);(function(a){var b=l.ntri_flat_uv;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*3;q(b,a,c+b*Uint32Array.BYTES_PER_ELEMENT*3);k(b,c)}})(z);(function(a){var b=l.ntri_smooth_uv;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*3,d=c+b*Uint32Array.BYTES_PER_ELEMENT*3;n(b,a,c,d+b*Uint32Array.BYTES_PER_ELEMENT*3);k(b,d)}})(v);(function(a){var b=l.nquad_flat_uv;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*4;o(b,a,c+b*Uint32Array.BYTES_PER_ELEMENT*4);j(b,
c)}})(b);(function(a){var b=l.nquad_smooth_uv;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*4,d=c+b*Uint32Array.BYTES_PER_ELEMENT*4;s(b,a,c,d+b*Uint32Array.BYTES_PER_ELEMENT*4);j(b,d)}})(A);(function(a){var b=l.ntri_flat;b&&q(b,a,a+b*Uint32Array.BYTES_PER_ELEMENT*3)})(p);(function(a){var b=l.ntri_smooth;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*3;n(b,a,c,c+b*Uint32Array.BYTES_PER_ELEMENT*3)}})(w);(function(a){var b=l.nquad_flat;b&&o(b,a,a+b*Uint32Array.BYTES_PER_ELEMENT*4)})(x);(function(a){var b=
l.nquad_smooth;if(b){var c=a+b*Uint32Array.BYTES_PER_ELEMENT*4;s(b,a,c,c+b*Uint32Array.BYTES_PER_ELEMENT*4)}})(y);this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};g.prototype=new THREE.Geometry;g.prototype.constructor=g;c(new g(b))};
THREE.ColladaLoader=function(){function a(a,d,g){P=a;d=d||ca;g!==void 0&&(a=g.split("/"),a.pop(),da=a.length<1?"":a.join("/")+"/");Z=c("//dae:library_images/dae:image",e,"image");$=c("//dae:library_materials/dae:material",y,"material");aa=c("//dae:library_effects/dae:effect",B,"effect");S=c("//dae:library_geometries/dae:geometry",p,"geometry");R=c("//dae:library_controllers/dae:controller",h,"controller");U=c("//dae:library_animations/dae:animation",I,"animation");ba=c(".//dae:library_visual_scenes/dae:visual_scene",
j,"visual_scene");W=[];X=[];(a=P.evaluate(".//dae:scene/dae:instance_visual_scene",P,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())?(a=a.getAttribute("url").replace(/^#/,""),T=ba[a]):T=null;Y=new THREE.Object3D;for(a=0;a<T.nodes.length;a++)Y.add(f(T.nodes[a]));b();for(var i in U);i={scene:Y,morphs:W,skins:X,dae:{images:Z,materials:$,effects:aa,geometries:S,controllers:R,animations:U,visualScenes:ba,scene:T}};d&&d(i);return i}function c(a,b,c){for(var a=P.evaluate(a,P,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,
null),d={},e=a.iterateNext(),f=0;e;){e=(new b).parse(e);if(e.id.length==0)e.id=c+f++;d[e.id]=e;e=a.iterateNext()}return d}function b(){var a=1E6,b=-a,c=0,d;for(d in U)for(var e=U[d],f=0;f<e.sampler.length;f++){var g=e.sampler[f];g.create();a=Math.min(a,g.startTime);b=Math.max(b,g.endTime);c=Math.max(c,g.input.length)}return{start:a,end:b,frames:c}}function d(a,b,c,e){a.world=a.world||new THREE.Matrix4;a.world.copy(a.matrix);if(a.channels&&a.channels.length){var f=a.channels[0].sampler.output[c];f instanceof
THREE.Matrix4&&a.world.copy(f)}e&&a.world.multiply(e,a.world);b.push(a);for(e=0;e<a.nodes.length;e++)d(a.nodes[e],b,c,a.world)}function g(a,c,e){var f=R[c.url];if(!f||!f.skin)console.log("ColladaLoader: Could not find skin controller.");else if(!c.skeleton||!c.skeleton.length)console.log("ColladaLoader: Could not find the skeleton for the skin. ");else{var g=b(),c=T.getChildById(c.skeleton[0],!0)||T.getChildBySid(c.skeleton[0],!0),h,i,j,k,l=new THREE.Vector3,n;for(h=0;h<a.vertices.length;h++)f.skin.bindShapeMatrix.multiplyVector3(a.vertices[h].position);
for(e=0;e<g.frames;e++){var m=[],o=[];for(h=0;h<a.vertices.length;h++)o.push(new THREE.Vertex(new THREE.Vector3));d(c,m,e);h=m;i=f.skin;for(k=0;k<h.length;k++)if(j=h[k],n=-1,j.type=="JOINT"){for(var p=0;p<i.joints.length;p++)if(j.sid==i.joints[p]){n=p;break}if(n>=0){p=i.invBindMatrices[n];j.invBindMatrix=p;j.skinningMatrix=new THREE.Matrix4;j.skinningMatrix.multiply(j.world,p);j.weights=[];for(p=0;p<i.weights.length;p++)for(var q=0;q<i.weights[p].length;q++){var r=i.weights[p][q];r.joint==n&&j.weights.push(r)}}else throw"ColladaLoader: Could not find joint '"+
j.sid+"'.";}for(h=0;h<m.length;h++)if(m[h].type=="JOINT")for(i=0;i<m[h].weights.length;i++)j=m[h].weights[i],k=j.index,j=j.weight,n=a.vertices[k],k=o[k],l.x=n.position.x,l.y=n.position.y,l.z=n.position.z,m[h].skinningMatrix.multiplyVector3(l),k.position.x+=l.x*j,k.position.y+=l.y*j,k.position.z+=l.z*j;a.morphTargets.push({name:"target_"+e,vertices:o})}}}function f(a){var b=new THREE.Object3D,c,d,e,h;for(e=0;e<a.controllers.length;e++){var i=R[a.controllers[e].url];switch(i.type){case "skin":if(S[i.skin.source]){var j=
new m;j.url=i.skin.source;j.instance_material=a.controllers[e].instance_material;a.geometries.push(j);c=a.controllers[e]}else if(R[i.skin.source]&&(d=i=R[i.skin.source],i.morph&&S[i.morph.source]))j=new m,j.url=i.morph.source,j.instance_material=a.controllers[e].instance_material,a.geometries.push(j);break;case "morph":if(S[i.morph.source])j=new m,j.url=i.morph.source,j.instance_material=a.controllers[e].instance_material,a.geometries.push(j),d=a.controllers[e];console.log("ColladaLoader: Morph-controller partially supported.")}}for(e=
0;e<a.geometries.length;e++){var i=a.geometries[e],j=i.instance_material,i=S[i.url],k={},l=0,o;if(i&&i.mesh&&i.mesh.primitives){if(b.name.length==0)b.name=i.id;if(j)for(h=0;h<j.length;h++){o=j[h];var p=aa[$[o.target].instance_effect.url].shader;p.material.opacity=!p.material.opacity?1:p.material.opacity;o=k[o.symbol]=p.material;l++}j=o||new THREE.MeshLambertMaterial({color:14540253,shading:THREE.FlatShading});i=i.mesh.geometry3js;if(l>1){j=new THREE.MeshFaceMaterial;for(h=0;h<i.faces.length;h++)l=
i.faces[h],l.materials=[k[l.daeMaterial]]}if(c!==void 0)g(i,c),j.morphTargets=!0,j=new THREE.SkinnedMesh(i,j),j.skeleton=c.skeleton,j.skinController=R[c.url],j.skinInstanceController=c,j.name="skin_"+X.length,X.push(j);else if(d!==void 0){h=i;k=d instanceof n?R[d.url]:d;if(!k||!k.morph)console.log("could not find morph controller!");else{k=k.morph;for(l=0;l<k.targets.length;l++)if(p=S[k.targets[l]],p.mesh&&p.mesh.primitives&&p.mesh.primitives.length)p=p.mesh.primitives[0].geometry,p.vertices.length===
h.vertices.length&&h.morphTargets.push({name:"target_1",vertices:p.vertices});h.morphTargets.push({name:"target_Z",vertices:h.vertices})}j.morphTargets=!0;j=new THREE.Mesh(i,j);j.name="morph_"+W.length;W.push(j)}else j=new THREE.Mesh(i,j);a.geometries.length>1?b.add(j):b=j}}b.name=a.id||"";a.matrix.decompose(b.position,b.rotation,b.scale);for(e=0;e<a.nodes.length;e++)b.add(f(a.nodes[e],a));return b}function e(){this.init_from=this.id=""}function h(){this.type=this.name=this.id="";this.morph=this.skin=
null}function i(){this.weights=this.targets=this.source=this.method=null}function k(){this.source="";this.bindShapeMatrix=null;this.invBindMatrices=[];this.joints=[];this.weights=[]}function j(){this.name=this.id="";this.nodes=[];this.scene=new THREE.Object3D}function q(){this.sid=this.name=this.id="";this.nodes=[];this.controllers=[];this.transforms=[];this.geometries=[];this.channels=[];this.matrix=new THREE.Matrix4}function o(){this.type=this.sid="";this.data=[];this.matrix=new THREE.Matrix4}function n(){this.url=
"";this.skeleton=[];this.instance_material=[]}function s(){this.target=this.symbol=""}function m(){this.url="";this.instance_material=[]}function p(){this.id="";this.mesh=null}function l(a){this.geometry=a.id;this.primitives=[];this.geometry3js=this.vertices=null}function r(){}function t(){this.material="";this.count=0;this.inputs=[];this.vcount=null;this.p=[];this.geometry=new THREE.Geometry}function w(){this.source="";this.stride=this.count=0;this.params=[]}function z(){this.input={}}function v(){this.semantic=
"";this.offset=0;this.source="";this.set=0}function x(a){this.id=a;this.type=null}function y(){this.name=this.id="";this.instance_effect=null}function A(){this.color=new THREE.Color(0);this.color.setRGB(Math.random(),Math.random(),Math.random());this.color.a=1;this.texcoord=this.texture=null}function F(a,b){this.type=a;this.effect=b;this.material=null}function u(a){this.effect=a;this.format=this.init_from=null}function D(a){this.effect=a;this.mipfilter=this.magfilter=this.minfilter=this.wrap_t=this.wrap_s=
this.source=null}function B(){this.name=this.id="";this.sampler=this.surface=this.shader=null}function G(){this.url=""}function I(){this.name=this.id="";this.source={};this.sampler=[];this.channel=[]}function E(a){this.animation=a;this.target=this.source="";this.member=this.arrIndices=this.arrSyntax=this.dotSyntax=this.sid=null}function K(a){this.id="";this.animation=a;this.inputs=[];this.endTime=this.startTime=this.interpolation=this.output=this.input=null;this.duration=0}function O(a){var b=a.getAttribute("id");
if(V[b]!=void 0)return V[b];V[b]=(new x(b)).parse(a);return V[b]}function C(a){if(a=="dae")return"http://www.collada.org/2005/11/COLLADASchema";return null}function L(a){for(var a=M(a).split(/\s+/),b=[],c=0;c<a.length;c++)b.push(parseFloat(a[c]));return b}function H(a){for(var a=M(a).split(/\s+/),b=[],c=0;c<a.length;c++)b.push(parseInt(a[c],10));return b}function M(a){return a.replace(/^\s+/,"").replace(/\s+$/,"")}function J(a,b,c){return a.hasAttribute(b)?parseInt(a.getAttribute(b),10):c}function N(a,
b){if(a===void 0){for(var c="0.";c.length<b+2;)c+="0";return c}b=b||2;c=a.toString().split(".");for(c[1]=c.length>1?c[1].substr(0,b):"0";c[1].length<b;)c[1]+="0";return c.join(".")}function Q(a,b){var c="";c+=N(a.x,b)+",";c+=N(a.y,b)+",";c+=N(a.z,b);return c}var P=null,Y=null,T,ca=null,V={},Z={},U={},R={},S={},$={},aa={},ba,da,W,X,ea=THREE.SmoothShading;e.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeName=="init_from")this.init_from=
c.textContent}return this};h.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");this.type="none";for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "skin":this.skin=(new k).parse(c);this.type=c.nodeName;break;case "morph":this.morph=(new i).parse(c),this.type=c.nodeName}}return this};i.prototype.parse=function(a){var b={},c=[],d;this.method=a.getAttribute("method");this.source=a.getAttribute("source").replace(/^#/,"");for(d=
0;d<a.childNodes.length;d++){var e=a.childNodes[d];if(e.nodeType==1)switch(e.nodeName){case "source":e=(new x).parse(e);b[e.id]=e;break;case "targets":c=this.parseInputs(e);break;default:console.log(e.nodeName)}}for(d=0;d<c.length;d++)switch(a=c[d],e=b[a.source],a.semantic){case "MORPH_TARGET":this.targets=e.read();break;case "MORPH_WEIGHT":this.weights=e.read()}return this};i.prototype.parseInputs=function(a){for(var b=[],c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(d.nodeType==1)switch(d.nodeName){case "input":b.push((new v).parse(d))}}return b};
k.prototype.parse=function(a){var b={},c,d;this.source=a.getAttribute("source").replace(/^#/,"");this.invBindMatrices=[];this.joints=[];this.weights=[];for(var e=0;e<a.childNodes.length;e++){var f=a.childNodes[e];if(f.nodeType==1)switch(f.nodeName){case "bind_shape_matrix":f=L(f.textContent);this.bindShapeMatrix=new THREE.Matrix4;this.bindShapeMatrix.set(f[0],f[1],f[2],f[3],f[4],f[5],f[6],f[7],f[8],f[9],f[10],f[11],f[12],f[13],f[14],f[15]);break;case "source":f=(new x).parse(f);b[f.id]=f;break;case "joints":c=
f;break;case "vertex_weights":d=f;break;default:console.log(f.nodeName)}}this.parseJoints(c,b);this.parseWeights(d,b);return this};k.prototype.parseJoints=function(a,b){for(var c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(d.nodeType==1)switch(d.nodeName){case "input":var d=(new v).parse(d),e=b[d.source];if(d.semantic=="JOINT")this.joints=e.read();else if(d.semantic=="INV_BIND_MATRIX")this.invBindMatrices=e.read()}}};k.prototype.parseWeights=function(a,b){for(var c,d,e=[],f=0;f<a.childNodes.length;f++){var g=
a.childNodes[f];if(g.nodeType==1)switch(g.nodeName){case "input":e.push((new v).parse(g));break;case "v":c=H(g.textContent);break;case "vcount":d=H(g.textContent)}}for(f=g=0;f<d.length;f++){for(var h=d[f],i=[],j=0;j<h;j++){for(var k={},l=0;l<e.length;l++){var n=e[l],m=c[g+n.offset];switch(n.semantic){case "JOINT":k.joint=m;break;case "WEIGHT":k.weight=b[n.source].data[m]}}i.push(k);g+=e.length}for(j=0;j<i.length;j++)i[j].index=f;this.weights.push(i)}};j.prototype.getChildById=function(a,b){for(var c=
0;c<this.nodes.length;c++){var d=this.nodes[c].getChildById(a,b);if(d)return d}return null};j.prototype.getChildBySid=function(a,b){for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildBySid(a,b);if(d)return d}return null};j.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");this.nodes=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "node":this.nodes.push((new q).parse(c))}}return this};q.prototype.getChannelForTransform=
function(a){for(var b=0;b<this.channels.length;b++){var c=this.channels[b],d=c.target.split("/");d.shift();var e=d.shift(),f=e.indexOf(".")>=0,g=e.indexOf("(")>=0,h;if(f)d=e.split("."),e=d.shift(),d.shift();else if(g){h=e.split("(");e=h.shift();for(d=0;d<h.length;d++)h[d]=parseInt(h[d].replace(/\)/,""))}if(e==a)return c.info={sid:e,dotSyntax:f,arrSyntax:g,arrIndices:h},c}return null};q.prototype.getChildById=function(a,b){if(this.id==a)return this;if(b)for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildById(a,
b);if(d)return d}return null};q.prototype.getChildBySid=function(a,b){if(this.sid==a)return this;if(b)for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildBySid(a,b);if(d)return d}return null};q.prototype.getTransformBySid=function(a){for(var b=0;b<this.transforms.length;b++)if(this.transforms[b].sid==a)return this.transforms[b];return null};q.prototype.parse=function(a){var b;this.id=a.getAttribute("id");this.sid=a.getAttribute("sid");this.name=a.getAttribute("name");this.type=a.getAttribute("type");
this.type=this.type=="JOINT"?this.type:"NODE";this.nodes=[];this.transforms=[];this.geometries=[];this.controllers=[];this.matrix=new THREE.Matrix4;for(var c=0;c<a.childNodes.length;c++)if(b=a.childNodes[c],b.nodeType==1)switch(b.nodeName){case "node":this.nodes.push((new q).parse(b));break;case "instance_camera":break;case "instance_controller":this.controllers.push((new n).parse(b));break;case "instance_geometry":this.geometries.push((new m).parse(b));break;case "instance_light":break;case "instance_node":b=
b.getAttribute("url").replace(/^#/,"");(b=P.evaluate(".//dae:library_nodes//dae:node[@id='"+b+"']",P,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())&&this.nodes.push((new q).parse(b));break;case "rotate":case "translate":case "scale":case "matrix":case "lookat":case "skew":this.transforms.push((new o).parse(b));break;case "extra":break;default:console.log(b.nodeName)}a=[];c=1E6;b=-1E6;for(var d in U)for(var e=U[d],f=0;f<e.channel.length;f++){var g=e.channel[f],h=e.sampler[f];d=g.target.split("/")[0];
if(d==this.id)h.create(),g.sampler=h,c=Math.min(c,h.startTime),b=Math.max(b,h.endTime),a.push(g)}if(a.length)this.startTime=c,this.endTime=b;if((this.channels=a)&&this.channels.length){d=1E7;for(a=0;a<this.channels.length;a++){c=this.channels[a].sampler;for(b=0;b<c.input.length-1;b++)d=Math.min(d,c.input[b+1]-c.input[b])}c=[];for(a=this.startTime;a<this.endTime;a+=d){b=a;for(var e={},i=f=void 0,f=0;f<this.channels.length;f++)i=this.channels[f],e[i.sid]=i;g=new THREE.Matrix4;for(f=0;f<this.transforms.length;f++)if(h=
this.transforms[f],i=e[h.sid],i!==void 0){for(var j=i.sampler,k,i=0;i<j.input.length-1;i++)if(j.input[i+1]>b){k=j.output[i];break}g=k!==void 0?k instanceof THREE.Matrix4?g.multiply(g,k):g.multiply(g,h.matrix):g.multiply(g,h.matrix)}else g=g.multiply(g,h.matrix);b=g;c.push({time:a,pos:[b.n14,b.n24,b.n34],rotq:[0,0,0,1],scl:[1,1,1]})}this.keys=c}this.updateMatrix();return this};q.prototype.updateMatrix=function(){this.matrix.identity();for(var a=0;a<this.transforms.length;a++)this.matrix.multiply(this.matrix,
this.transforms[a].matrix)};o.prototype.parse=function(a){this.sid=a.getAttribute("sid");this.type=a.nodeName;this.data=L(a.textContent);this.updateMatrix();return this};o.prototype.updateMatrix=function(){var a=0;this.matrix.identity();switch(this.type){case "matrix":this.matrix.set(this.data[0],this.data[1],this.data[2],this.data[3],this.data[4],this.data[5],this.data[6],this.data[7],this.data[8],this.data[9],this.data[10],this.data[11],this.data[12],this.data[13],this.data[14],this.data[15]);break;
case "translate":this.matrix.setTranslation(this.data[0],this.data[1],this.data[2]);break;case "rotate":a=this.data[3]*(Math.PI/180);this.matrix.setRotationAxis(new THREE.Vector3(this.data[0],this.data[1],this.data[2]),a);break;case "scale":this.matrix.setScale(this.data[0],this.data[1],this.data[2])}return this.matrix};n.prototype.parse=function(a){this.url=a.getAttribute("url").replace(/^#/,"");this.skeleton=[];this.instance_material=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];
if(c.nodeType==1)switch(c.nodeName){case "skeleton":this.skeleton.push(c.textContent.replace(/^#/,""));break;case "bind_material":if(c=P.evaluate(".//dae:instance_material",c,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(var d=c.iterateNext();d;)this.instance_material.push((new s).parse(d)),d=c.iterateNext()}}return this};s.prototype.parse=function(a){this.symbol=a.getAttribute("symbol");this.target=a.getAttribute("target").replace(/^#/,"");return this};m.prototype.parse=function(a){this.url=
a.getAttribute("url").replace(/^#/,"");this.instance_material=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1&&c.nodeName=="bind_material"){if(a=P.evaluate(".//dae:instance_material",c,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(b=a.iterateNext();b;)this.instance_material.push((new s).parse(b)),b=a.iterateNext();break}}return this};p.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "mesh":this.mesh=
(new l(this)).parse(c)}}return this};l.prototype.parse=function(a){function b(a,c){var d=Q(a.position);e[d]===void 0&&(e[d]={v:a,index:c});return e[d]}this.primitives=[];var c;for(c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];switch(d.nodeName){case "source":O(d);break;case "vertices":this.vertices=(new z).parse(d);break;case "triangles":this.primitives.push((new t).parse(d));break;case "polygons":console.warn("polygon holes not yet supported!");case "polylist":this.primitives.push((new r).parse(d))}}var e=
{};this.geometry3js=new THREE.Geometry;d=V[this.vertices.input.POSITION.source].data;for(a=c=0;c<d.length;c+=3,a++){var f=new THREE.Vertex(new THREE.Vector3(d[c],d[c+1],d[c+2]));b(f,a);this.geometry3js.vertices.push(f)}for(c=0;c<this.primitives.length;c++)a=this.primitives[c],a.setVertices(this.vertices),this.handlePrimitive(a,this.geometry3js,e);this.geometry3js.computeCentroids();this.geometry3js.computeFaceNormals();this.geometry3js.computeVertexNormals();this.geometry3js.computeBoundingBox();
return this};l.prototype.handlePrimitive=function(a,b,c){var d=0,e,f,g=a.p,h=a.inputs,i,j,k,l,n=0,m=3,o=[];for(e=0;e<h.length;e++)switch(i=h[e],i.semantic){case "TEXCOORD":o.push(i.set)}for(;d<g.length;){var p=[],q=[],r={},s=[];a.vcount&&(m=a.vcount[n++]);for(e=0;e<m;e++)for(f=0;f<h.length;f++)switch(i=h[f],l=V[i.source],j=g[d+e*h.length+i.offset],k=l.accessor.params.length,k*=j,i.semantic){case "VERTEX":i=Q(b.vertices[j].position);p.push(c[i].index);break;case "NORMAL":q.push(new THREE.Vector3(l.data[k],
l.data[k+1],l.data[k+2]));break;case "TEXCOORD":r[i.set]===void 0&&(r[i.set]=[]);r[i.set].push(new THREE.UV(l.data[k],l.data[k+1]));break;case "COLOR":s.push((new THREE.Color).setRGB(l.data[k],l.data[k+1],l.data[k+2]))}var t;m==3?t=new THREE.Face3(p[0],p[1],p[2],[q[0],q[1],q[2]],s.length?s:new THREE.Color):m==4&&(t=new THREE.Face4(p[0],p[1],p[2],p[3],[q[0],q[1],q[2],q[3]],s.length?s:new THREE.Color));t.daeMaterial=a.material;b.faces.push(t);for(f=0;f<o.length;f++)e=r[o[f]],b.faceVertexUvs[f].push([e[0],
e[1],e[2]]);d+=h.length*m}};r.prototype=new t;r.prototype.constructor=r;t.prototype.setVertices=function(a){for(var b=0;b<this.inputs.length;b++)if(this.inputs[b].source==a.id)this.inputs[b].source=a.input.POSITION.source};t.prototype.parse=function(a){this.inputs=[];this.material=a.getAttribute("material");this.count=J(a,"count",0);for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "input":this.inputs.push((new v).parse(a.childNodes[b]));break;case "vcount":this.vcount=
H(c.textContent);break;case "p":this.p=H(c.textContent)}}return this};w.prototype.parse=function(a){this.params=[];this.source=a.getAttribute("source");this.count=J(a,"count",0);this.stride=J(a,"stride",0);for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeName=="param"){var d={};d.name=c.getAttribute("name");d.type=c.getAttribute("type");this.params.push(d)}}return this};z.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++)if(a.childNodes[b].nodeName==
"input"){var c=(new v).parse(a.childNodes[b]);this.input[c.semantic]=c}return this};v.prototype.parse=function(a){this.semantic=a.getAttribute("semantic");this.source=a.getAttribute("source").replace(/^#/,"");this.set=J(a,"set",-1);this.offset=J(a,"offset",0);if(this.semantic=="TEXCOORD"&&this.set<0)this.set=0;return this};x.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "bool_array":for(var d=M(c.textContent).split(/\s+/),
e=[],f=0;f<d.length;f++)e.push(d[f]=="true"||d[f]=="1"?!0:!1);this.data=e;this.type=c.nodeName;break;case "float_array":this.data=L(c.textContent);this.type=c.nodeName;break;case "int_array":this.data=H(c.textContent);this.type=c.nodeName;break;case "IDREF_array":case "Name_array":this.data=M(c.textContent).split(/\s+/);this.type=c.nodeName;break;case "technique_common":for(d=0;d<c.childNodes.length;d++)if(c.childNodes[d].nodeName=="accessor"){this.accessor=(new w).parse(c.childNodes[d]);break}}}return this};
x.prototype.read=function(){var a=[],b=this.accessor.params[0];switch(b.type){case "IDREF":case "Name":case "name":case "float":return this.data;case "float4x4":for(b=0;b<this.data.length;b+=16){var c=this.data.slice(b,b+16),d=new THREE.Matrix4;d.set(c[0],c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12],c[13],c[14],c[15]);a.push(d)}break;default:console.log("ColladaLoader: Source: Read dont know how to read "+b.type+".")}return a};y.prototype.parse=function(a){this.id=a.getAttribute("id");
this.name=a.getAttribute("name");for(var b=0;b<a.childNodes.length;b++)if(a.childNodes[b].nodeName=="instance_effect"){this.instance_effect=(new G).parse(a.childNodes[b]);break}return this};A.prototype.isColor=function(){return this.texture==null};A.prototype.isTexture=function(){return this.texture!=null};A.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "color":c=L(c.textContent);this.color=new THREE.Color(0);this.color.setRGB(c[0],
c[1],c[2]);this.color.a=c[3];break;case "texture":this.texture=c.getAttribute("texture"),this.texcoord=c.getAttribute("texcoord")}}return this};F.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "ambient":case "emission":case "diffuse":case "specular":case "transparent":this[c.nodeName]=(new A).parse(c);break;case "shininess":case "reflectivity":case "transparency":var d;d=P.evaluate(".//dae:float",c,C,XPathResult.ORDERED_NODE_ITERATOR_TYPE,
null);for(var e=d.iterateNext(),f=[];e;)f.push(e),e=d.iterateNext();d=f;d.length>0&&(this[c.nodeName]=parseFloat(d[0].textContent))}}this.create();return this};F.prototype.create=function(){var a={},b=this.transparency!==void 0&&this.transparency<1,c;for(c in this)switch(c){case "ambient":case "emission":case "diffuse":case "specular":var d=this[c];if(d instanceof A)if(d.isTexture()){if(this.effect.sampler&&this.effect.surface&&this.effect.sampler.source==this.effect.surface.sid&&(d=Z[this.effect.surface.init_from]))a.map=
THREE.ImageUtils.loadTexture(da+d.init_from),a.map.wrapS=THREE.RepeatWrapping,a.map.wrapT=THREE.RepeatWrapping,a.map.repeat.x=1,a.map.repeat.y=-1}else c=="diffuse"?a.color=d.color.getHex():b||(a[c]=d.color.getHex());break;case "shininess":case "reflectivity":a[c]=this[c];break;case "transparency":if(b)a.transparent=!0,a.opacity=this[c],b=!0}a.shading=ea;return this.material=new THREE.MeshLambertMaterial(a)};u.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];
if(c.nodeType==1)switch(c.nodeName){case "init_from":this.init_from=c.textContent;break;case "format":this.format=c.textContent;break;default:console.log("unhandled Surface prop: "+c.nodeName)}}return this};D.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "source":this.source=c.textContent;break;case "minfilter":this.minfilter=c.textContent;break;case "magfilter":this.magfilter=c.textContent;break;case "mipfilter":this.mipfilter=
c.textContent;break;case "wrap_s":this.wrap_s=c.textContent;break;case "wrap_t":this.wrap_t=c.textContent;break;default:console.log("unhandled Sampler2D prop: "+c.nodeName)}}return this};B.prototype.create=function(){if(this.shader==null)return null};B.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");this.shader=null;for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "profile_COMMON":this.parseTechnique(this.parseProfileCOMMON(c))}}return this};
B.prototype.parseNewparam=function(a){for(var b=a.getAttribute("sid"),c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(d.nodeType==1)switch(d.nodeName){case "surface":this.surface=(new u(this)).parse(d);this.surface.sid=b;break;case "sampler2D":this.sampler=(new D(this)).parse(d);this.sampler.sid=b;break;case "extra":break;default:console.log(d.nodeName)}}};B.prototype.parseProfileCOMMON=function(a){for(var b,c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(d.nodeType==1)switch(d.nodeName){case "profile_COMMON":this.parseProfileCOMMON(d);
break;case "technique":b=d;break;case "newparam":this.parseNewparam(d);break;case "extra":break;default:console.log(d.nodeName)}}return b};B.prototype.parseTechnique=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "lambert":case "blinn":case "phong":this.shader=(new F(c.nodeName,this)).parse(c)}}};G.prototype.parse=function(a){this.url=a.getAttribute("url").replace(/^#/,"");return this};I.prototype.parse=function(a){this.id=a.getAttribute("id");
this.name=a.getAttribute("name");this.source={};for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "source":c=(new x).parse(c);this.source[c.id]=c;break;case "sampler":this.sampler.push((new K(this)).parse(c));break;case "channel":this.channel.push((new E(this)).parse(c))}}return this};E.prototype.parse=function(a){this.source=a.getAttribute("source").replace(/^#/,"");this.target=a.getAttribute("target");var b=this.target.split("/");b.shift();var a=
b.shift(),c=a.indexOf(".")>=0,d=a.indexOf("(")>=0,e,f;if(c)b=a.split("."),a=b.shift(),f=b.shift();else if(d){e=a.split("(");a=e.shift();for(b=0;b<e.length;b++)e[b]=parseInt(e[b].replace(/\)/,""))}this.sid=a;this.dotSyntax=c;this.arrSyntax=d;this.arrIndices=e;this.member=f;return this};K.prototype.parse=function(a){this.id=a.getAttribute("id");this.inputs=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(c.nodeType==1)switch(c.nodeName){case "input":this.inputs.push((new v).parse(c))}}return this};
K.prototype.create=function(){for(var a=0;a<this.inputs.length;a++){var b=this.inputs[a],c=this.animation.source[b.source];switch(b.semantic){case "INPUT":this.input=c.read();break;case "OUTPUT":this.output=c.read();break;case "INTERPOLATION":this.interpolation=c.read();break;case "IN_TANGENT":break;case "OUT_TANGENT":break;default:console.log(b.semantic)}}this.duration=this.endTime=this.startTime=0;if(this.input.length){this.startTime=1E8;this.endTime=-1E8;for(a=0;a<this.input.length;a++)this.startTime=
Math.min(this.startTime,this.input[a]),this.endTime=Math.max(this.endTime,this.input[a]);this.duration=this.endTime-this.startTime}};return{load:function(b,c){if(document.implementation&&document.implementation.createDocument){document.implementation.createDocument("http://www.collada.org/2005/11/COLLADASchema","COLLADA",null);b+="?rnd="+Math.random();var d=new XMLHttpRequest;d.overrideMimeType&&d.overrideMimeType("text/xml");d.onreadystatechange=function(){if(d.readyState==4&&(d.status==0||d.status==
200))ca=c,a(d.responseXML,void 0,b)};d.open("GET",b,!0);d.send(null)}else alert("Don't know how to parse XML!")},parse:a,setPreferredShading:function(a){ea=a},applySkin:g,geometries:S}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(a,c,b){if(a instanceof Object)console.warn("DEPRECATED: JSONLoader( parameters ) is now JSONLoader( url, callback, texturePath )."),b=a,a=b.model,c=b.callback,b=b.texture_path;b=b?b:this.extractUrlbase(a);this.onLoadStart();this.loadAjaxJSON(this,a,c,b)};
THREE.JSONLoader.prototype.loadAjaxJSON=function(a,c,b,d,g){var f=new XMLHttpRequest,e=0;f.onreadystatechange=function(){if(f.readyState==4)if(f.status==200||f.status==0)try{var h=JSON.parse(f.responseText);a.createModel(h,b,d);a.onLoadComplete()}catch(i){console.error(i),console.warn("DEPRECATED: ["+c+"] seems to be using old model format")}else console.error("Couldn't load ["+c+"] ["+f.status+"]");else f.readyState==3?g&&(e==0&&(e=f.getResponseHeader("Content-Length")),g({total:e,loaded:f.responseText.length})):
f.readyState==2&&(e=f.getResponseHeader("Content-Length"))};f.open("GET",c,!0);f.overrideMimeType("text/plain; charset=x-user-defined");f.setRequestHeader("Content-Type","text/plain");f.send(null)};
THREE.JSONLoader.prototype.createModel=function(a,c,b){var d=new THREE.Geometry,g=a.scale!==void 0?1/a.scale:1;this.initMaterials(d,a.materials,b);(function(b){if(a.metadata===void 0||a.metadata.formatVersion===void 0||a.metadata.formatVersion!==3)console.error("Deprecated file format.");else{var c,g,i,k,j,q,o,n,s,m,p,l,r,t,w=a.faces;q=a.vertices;var z=a.normals,v=a.colors,x=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&x++;for(c=0;c<x;c++)d.faceUvs[c]=[],d.faceVertexUvs[c]=[];k=0;for(j=q.length;k<
j;)o=new THREE.Vertex,o.position.x=q[k++]*b,o.position.y=q[k++]*b,o.position.z=q[k++]*b,d.vertices.push(o);k=0;for(j=w.length;k<j;){b=w[k++];q=b&1;i=b&2;c=b&4;g=b&8;n=b&16;o=b&32;m=b&64;b&=128;q?(p=new THREE.Face4,p.a=w[k++],p.b=w[k++],p.c=w[k++],p.d=w[k++],q=4):(p=new THREE.Face3,p.a=w[k++],p.b=w[k++],p.c=w[k++],q=3);if(i)i=w[k++],p.materialIndex=i;i=d.faces.length;if(c)for(c=0;c<x;c++)l=a.uvs[c],s=w[k++],t=l[s*2],s=l[s*2+1],d.faceUvs[c][i]=new THREE.UV(t,s);if(g)for(c=0;c<x;c++){l=a.uvs[c];r=[];
for(g=0;g<q;g++)s=w[k++],t=l[s*2],s=l[s*2+1],r[g]=new THREE.UV(t,s);d.faceVertexUvs[c][i]=r}if(n)n=w[k++]*3,g=new THREE.Vector3,g.x=z[n++],g.y=z[n++],g.z=z[n],p.normal=g;if(o)for(c=0;c<q;c++)n=w[k++]*3,g=new THREE.Vector3,g.x=z[n++],g.y=z[n++],g.z=z[n],p.vertexNormals.push(g);if(m)o=w[k++],o=new THREE.Color(v[o]),p.color=o;if(b)for(c=0;c<q;c++)o=w[k++],o=new THREE.Color(v[o]),p.vertexColors.push(o);d.faces.push(p)}}})(g);(function(){var b,c,g,i;if(a.skinWeights){b=0;for(c=a.skinWeights.length;b<c;b+=
2)g=a.skinWeights[b],i=a.skinWeights[b+1],d.skinWeights.push(new THREE.Vector4(g,i,0,0))}if(a.skinIndices){b=0;for(c=a.skinIndices.length;b<c;b+=2)g=a.skinIndices[b],i=a.skinIndices[b+1],d.skinIndices.push(new THREE.Vector4(g,i,0,0))}d.bones=a.bones;d.animation=a.animation})();(function(b){if(a.morphTargets!==void 0){var c,g,i,k,j,q,o,n,s;c=0;for(g=a.morphTargets.length;c<g;c++){d.morphTargets[c]={};d.morphTargets[c].name=a.morphTargets[c].name;d.morphTargets[c].vertices=[];n=d.morphTargets[c].vertices;
s=a.morphTargets[c].vertices;i=0;for(k=s.length;i<k;i+=3)j=s[i]*b,q=s[i+1]*b,o=s[i+2]*b,n.push(new THREE.Vertex(new THREE.Vector3(j,q,o)))}}if(a.morphColors!==void 0){c=0;for(g=a.morphColors.length;c<g;c++){d.morphColors[c]={};d.morphColors[c].name=a.morphColors[c].name;d.morphColors[c].colors=[];k=d.morphColors[c].colors;j=a.morphColors[c].colors;b=0;for(i=j.length;b<i;b+=3)q=new THREE.Color(16755200),q.setRGB(j[b],j[b+1],j[b+2]),k.push(q)}}})(g);d.computeCentroids();d.computeFaceNormals();this.hasNormals(d)&&
d.computeTangents();c(d)};THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};THREE.SceneLoader.prototype.constructor=THREE.SceneLoader;
THREE.SceneLoader.prototype.load=function(a,c){var b=this,d=new XMLHttpRequest;d.onreadystatechange=function(){if(d.readyState==4)if(d.status==200||d.status==0)try{var g=JSON.parse(d.responseText);g.metadata===void 0||g.metadata.formatVersion===void 0||g.metadata.formatVersion!==3?console.error("Deprecated file format."):b.createScene(g,c,a)}catch(f){console.error(f),console.warn("DEPRECATED: ["+a+"] seems to be using old model format")}else console.error("Couldn't load ["+a+"] ["+d.status+"]")};
d.open("GET",a,!0);d.overrideMimeType("text/plain; charset=x-user-defined");d.setRequestHeader("Content-Type","text/plain");d.send(null)};
THREE.SceneLoader.prototype.createScene=function(a,c,b){function d(a,b){return b=="relativeToHTML"?a:k+"/"+a}function g(){var a;for(o in B.objects)if(!C.objects[o])if(l=B.objects[o],l.geometry!==void 0){if(A=C.geometries[l.geometry]){a=!1;for(H=0;H<l.materials.length;H++)D=C.materials[l.materials[H]],a=D instanceof THREE.ShaderMaterial;a&&A.computeTangents();w=l.position;z=l.rotation;v=l.quaternion;x=l.scale;v=0;D.length==0&&(D=new THREE.MeshFaceMaterial);D.length>1&&(D=new THREE.MeshFaceMaterial);
a=new THREE.Mesh(A,D);a.name=o;a.position.set(w[0],w[1],w[2]);v?(a.quaternion.set(v[0],v[1],v[2],v[3]),a.useQuaternion=!0):a.rotation.set(z[0],z[1],z[2]);a.scale.set(x[0],x[1],x[2]);a.visible=l.visible;C.scene.add(a);C.objects[o]=a;if(l.meshCollider){var b=THREE.CollisionUtils.MeshColliderWBox(a);C.scene.collisions.colliders.push(b)}if(l.castsShadow)b=new THREE.ShadowVolume(A),C.scene.add(b),b.position=a.position,b.rotation=a.rotation,b.scale=a.scale;l.trigger&&l.trigger.toLowerCase()!="none"&&(b=
{type:l.trigger,object:l},C.triggers[a.name]=b)}}else w=l.position,z=l.rotation,v=l.quaternion,x=l.scale,v=0,a=new THREE.Object3D,a.name=o,a.position.set(w[0],w[1],w[2]),v?(a.quaternion.set(v[0],v[1],v[2],v[3]),a.useQuaternion=!0):a.rotation.set(z[0],z[1],z[2]),a.scale.set(x[0],x[1],x[2]),a.visible=l.visible!==void 0?l.visible:!1,C.scene.add(a),C.objects[o]=a,C.empties[o]=a,l.trigger&&l.trigger.toLowerCase()!="none"&&(b={type:l.trigger,object:l},C.triggers[a.name]=b)}function f(a){return function(b){C.geometries[a]=
b;g();I-=1;i.onLoadComplete();h()}}function e(a){return function(b){C.geometries[a]=b}}function h(){i.callbackProgress({totalModels:K,totalTextures:O,loadedModels:K-I,loadedTextures:O-E},C);i.onLoadProgress();I==0&&E==0&&c(C)}var i=this,k=THREE.Loader.prototype.extractUrlbase(b),j,q,o,n,s,m,p,l,r,t,w,z,v,x,y,A,F,u,D,B,G,I,E,K,O,C;B=a;b=new THREE.BinaryLoader;G=new THREE.JSONLoader;E=I=0;C={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},
empties:{}};a=!1;for(o in B.objects)if(l=B.objects[o],l.meshCollider){a=!0;break}if(a)C.scene.collisions=new THREE.CollisionSystem;if(B.transform){a=B.transform.position;r=B.transform.rotation;var L=B.transform.scale;a&&C.scene.position.set(a[0],a[1],a[2]);r&&C.scene.rotation.set(r[0],r[1],r[2]);L&&C.scene.scale.set(L[0],L[1],L[2]);(a||r||L)&&C.scene.updateMatrix()}a=function(){E-=1;h();i.onLoadComplete()};for(s in B.cameras)r=B.cameras[s],r.type=="perspective"?F=new THREE.PerspectiveCamera(r.fov,
r.aspect,r.near,r.far):r.type=="ortho"&&(F=new THREE.OrthographicCamera(r.left,r.right,r.top,r.bottom,r.near,r.far)),w=r.position,r=r.target,F.position.set(w[0],w[1],w[2]),F.target=new THREE.Vector3(r[0],r[1],r[2]),C.cameras[s]=F;for(n in B.lights)r=B.lights[n],s=r.color!==void 0?r.color:16777215,F=r.intensity!==void 0?r.intensity:1,r.type=="directional"?(w=r.direction,t=new THREE.DirectionalLight(s,F),t.position.set(w[0],w[1],w[2]),t.position.normalize()):r.type=="point"?(w=r.position,t=r.distance,
t=new THREE.PointLight(s,F,t),t.position.set(w[0],w[1],w[2])):r.type=="ambient"&&(t=new THREE.AmbientLight(s)),C.scene.add(t),C.lights[n]=t;for(m in B.fogs)n=B.fogs[m],n.type=="linear"?u=new THREE.Fog(0,n.near,n.far):n.type=="exp2"&&(u=new THREE.FogExp2(0,n.density)),r=n.color,u.color.setRGB(r[0],r[1],r[2]),C.fogs[m]=u;if(C.cameras&&B.defaults.camera)C.currentCamera=C.cameras[B.defaults.camera];if(C.fogs&&B.defaults.fog)C.scene.fog=C.fogs[B.defaults.fog];r=B.defaults.bgcolor;C.bgColor=new THREE.Color;
C.bgColor.setRGB(r[0],r[1],r[2]);C.bgColorAlpha=B.defaults.bgalpha;for(j in B.geometries)if(m=B.geometries[j],m.type=="bin_mesh"||m.type=="ascii_mesh")I+=1,i.onLoadStart();K=I;for(j in B.geometries)m=B.geometries[j],m.type=="cube"?(A=new THREE.CubeGeometry(m.width,m.height,m.depth,m.segmentsWidth,m.segmentsHeight,m.segmentsDepth,null,m.flipped,m.sides),C.geometries[j]=A):m.type=="plane"?(A=new THREE.PlaneGeometry(m.width,m.height,m.segmentsWidth,m.segmentsHeight),C.geometries[j]=A):m.type=="sphere"?
(A=new THREE.SphereGeometry(m.radius,m.segmentsWidth,m.segmentsHeight),C.geometries[j]=A):m.type=="cylinder"?(A=new THREE.CylinderGeometry(m.topRad,m.botRad,m.height,m.radSegs,m.heightSegs),C.geometries[j]=A):m.type=="torus"?(A=new THREE.TorusGeometry(m.radius,m.tube,m.segmentsR,m.segmentsT),C.geometries[j]=A):m.type=="icosahedron"?(A=new THREE.IcosahedronGeometry(m.subdivisions),C.geometries[j]=A):m.type=="bin_mesh"?b.load(d(m.url,B.urlBaseType),f(j)):m.type=="ascii_mesh"?G.load(d(m.url,B.urlBaseType),
f(j)):m.type=="embedded_mesh"&&(m=B.embeds[m.id])&&G.createModel(m,e(j),"");for(p in B.textures)if(j=B.textures[p],j.url instanceof Array){E+=j.url.length;for(m=0;m<j.url.length;m++)i.onLoadStart()}else E+=1,i.onLoadStart();O=E;for(p in B.textures){j=B.textures[p];if(j.mapping!=void 0&&THREE[j.mapping]!=void 0)j.mapping=new THREE[j.mapping];if(j.url instanceof Array){m=[];for(var H=0;H<j.url.length;H++)m[H]=d(j.url[H],B.urlBaseType);m=THREE.ImageUtils.loadTextureCube(m,j.mapping,a)}else{m=THREE.ImageUtils.loadTexture(d(j.url,
B.urlBaseType),j.mapping,a);if(THREE[j.minFilter]!=void 0)m.minFilter=THREE[j.minFilter];if(THREE[j.magFilter]!=void 0)m.magFilter=THREE[j.magFilter];if(j.repeat){m.repeat.set(j.repeat[0],j.repeat[1]);if(j.repeat[0]!=1)m.wrapS=THREE.RepeatWrapping;if(j.repeat[1]!=1)m.wrapT=THREE.RepeatWrapping}j.offset&&m.offset.set(j.offset[0],j.offset[1]);if(j.wrap){u={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(u[j.wrap[0]]!==void 0)m.wrapS=u[j.wrap[0]];if(u[j.wrap[1]]!==void 0)m.wrapT=
u[j.wrap[1]]}}C.textures[p]=m}for(q in B.materials){p=B.materials[q];for(y in p.parameters)if(y=="envMap"||y=="map"||y=="lightMap")p.parameters[y]=C.textures[p.parameters[y]];else if(y=="shading")p.parameters[y]=p.parameters[y]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(y=="blending")p.parameters[y]=THREE[p.parameters[y]]?THREE[p.parameters[y]]:THREE.NormalBlending;else if(y=="combine")p.parameters[y]=p.parameters[y]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(y==
"vertexColors")if(p.parameters[y]=="face")p.parameters[y]=THREE.FaceColors;else if(p.parameters[y])p.parameters[y]=THREE.VertexColors;if(p.parameters.opacity!==void 0&&p.parameters.opacity<1)p.parameters.transparent=!0;if(p.parameters.normalMap){j=THREE.ShaderUtils.lib.normal;a=THREE.UniformsUtils.clone(j.uniforms);m=p.parameters.color;u=p.parameters.specular;b=p.parameters.ambient;G=p.parameters.shininess;a.tNormal.texture=C.textures[p.parameters.normalMap];if(p.parameters.normalMapFactor)a.uNormalScale.value=
p.parameters.normalMapFactor;if(p.parameters.map)a.tDiffuse.texture=p.parameters.map,a.enableDiffuse.value=!0;if(p.parameters.lightMap)a.tAO.texture=p.parameters.lightMap,a.enableAO.value=!0;if(p.parameters.specularMap)a.tSpecular.texture=C.textures[p.parameters.specularMap],a.enableSpecular.value=!0;a.uDiffuseColor.value.setHex(m);a.uSpecularColor.value.setHex(u);a.uAmbientColor.value.setHex(b);a.uShininess.value=G;if(p.parameters.opacity)a.uOpacity.value=p.parameters.opacity;p=new THREE.ShaderMaterial({fragmentShader:j.fragmentShader,
vertexShader:j.vertexShader,uniforms:a,lights:!0,fog:!0})}else p=new THREE[p.type](p.parameters);C.materials[q]=p}g();i.callbackSync(C);h()};THREE.UTF8Loader=function(){};THREE.UTF8Loader.prototype=new THREE.UTF8Loader;THREE.UTF8Loader.prototype.constructor=THREE.UTF8Loader;
THREE.UTF8Loader.prototype.load=function(a,c,b){if(a instanceof Object)console.warn("DEPRECATED: UTF8Loader( parameters ) is now UTF8Loader( url, callback, metaData )."),b=a,a=b.model,c=b.callback,b={scale:b.scale,offsetX:b.offsetX,offsetY:b.offsetY,offsetZ:b.offsetZ};var d=new XMLHttpRequest,g=b.scale!==void 0?b.scale:1,f=b.offsetX!==void 0?b.offsetX:0,e=b.offsetY!==void 0?b.offsetY:0,h=b.offsetZ!==void 0?b.offsetZ:0;d.onreadystatechange=function(){d.readyState==4?d.status==200||d.status==0?THREE.UTF8Loader.prototype.createModel(d.responseText,
c,g,f,e,h):alert("Couldn't load ["+a+"] ["+d.status+"]"):d.readyState!=3&&d.readyState==2&&d.getResponseHeader("Content-Length")};d.open("GET",a,!0);d.send(null)};THREE.UTF8Loader.prototype.decompressMesh=function(a){var c=a.charCodeAt(0);c>=57344&&(c-=2048);c++;for(var b=new Float32Array(8*c),d=1,g=0;g<8;g++){for(var f=0,e=0;e<c;++e){var h=a.charCodeAt(e+d);f+=h>>1^-(h&1);b[8*e+g]=f}d+=c}c=a.length-d;f=new Uint16Array(c);for(g=e=0;g<c;g++)h=a.charCodeAt(g+d),f[g]=e-h,h==0&&e++;return[b,f]};
THREE.UTF8Loader.prototype.createModel=function(a,c,b,d,g,f){var e=function(){var c=this;c.materials=[];THREE.Geometry.call(this);var e=THREE.UTF8Loader.prototype.decompressMesh(a),k=[],j=[];(function(a,e,i){for(var j,k,p,l=a.length;i<l;i+=e)j=a[i],k=a[i+1],p=a[i+2],j=j/16383*b,k=k/16383*b,p=p/16383*b,j+=d,k+=g,p+=f,c.vertices.push(new THREE.Vertex(new THREE.Vector3(j,k,p)))})(e[0],8,0);(function(a,b,c){for(var d,e,f=a.length;c<f;c+=b)d=a[c],e=a[c+1],d/=1023,e/=1023,j.push(d,1-e)})(e[0],8,3);(function(a,
b,c){for(var d,e,f,g=a.length;c<g;c+=b)d=a[c],e=a[c+1],f=a[c+2],d=(d-512)/511,e=(e-512)/511,f=(f-512)/511,k.push(d,e,f)})(e[0],8,5);(function(a){var b,d,e,f,g,i,r,t,w,z=a.length;for(b=0;b<z;b+=3){d=a[b];e=a[b+1];f=a[b+2];g=c;t=d;w=e;i=f;r=d;var v=e,x=f,y=g.materials[0],A=k[v*3],F=k[v*3+1],v=k[v*3+2],u=k[x*3],D=k[x*3+1],x=k[x*3+2];r=new THREE.Vector3(k[r*3],k[r*3+1],k[r*3+2]);v=new THREE.Vector3(A,F,v);x=new THREE.Vector3(u,D,x);g.faces.push(new THREE.Face3(t,w,i,[r,v,x],null,y));g=j[d*2];d=j[d*2+
1];i=j[e*2];r=j[e*2+1];t=j[f*2];w=j[f*2+1];f=c.faceVertexUvs[0];e=i;i=r;r=[];r.push(new THREE.UV(g,d));r.push(new THREE.UV(e,i));r.push(new THREE.UV(t,w));f.push(r)}})(e[1]);this.computeCentroids();this.computeFaceNormals()};e.prototype=new THREE.Geometry;e.prototype.constructor=e;c(new e)};
THREE.Axes=function(){THREE.Object3D.call(this);var a=new THREE.Geometry;a.vertices.push(new THREE.Vertex);a.vertices.push(new THREE.Vertex(new THREE.Vector3(0,100,0)));var c=new THREE.CylinderGeometry(0,5,25,5,1),b=new THREE.Line(a,new THREE.LineBasicMaterial({color:16711680}));b.rotation.z=-Math.PI/2;this.add(b);b=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:16711680}));b.position.x=100;b.rotation.z=-Math.PI/2;this.add(b);b=new THREE.Line(a,new THREE.LineBasicMaterial({color:65280}));this.add(b);
b=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:65280}));b.position.y=100;this.add(b);b=new THREE.Line(a,new THREE.LineBasicMaterial({color:255}));b.rotation.x=Math.PI/2;this.add(b);b=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:255}));b.position.z=100;b.rotation.x=Math.PI/2;this.add(b)};THREE.Axes.prototype=new THREE.Object3D;THREE.Axes.prototype.constructor=THREE.Axes;
THREE.MarchingCubes=function(a,c){THREE.Object3D.call(this);this.material=c;this.init=function(a){this.resolution=a;this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=0;this.hasNormal=
this.hasPos=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(a,c,g){return a+(c-a)*g};this.VIntX=function(a,c,g,f,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;c[f]=h+e*this.delta;c[f+1]=i;c[f+2]=k;g[f]=this.lerp(j[a],j[a+3],e);g[f+1]=this.lerp(j[a+1],j[a+4],e);g[f+2]=this.lerp(j[a+2],j[a+5],e)};this.VIntY=function(a,c,g,f,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;c[f]=h;c[f+1]=i+e*this.delta;c[f+2]=k;c=a+this.yd*
3;g[f]=this.lerp(j[a],j[c],e);g[f+1]=this.lerp(j[a+1],j[c+1],e);g[f+2]=this.lerp(j[a+2],j[c+2],e)};this.VIntZ=function(a,c,g,f,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;c[f]=h;c[f+1]=i;c[f+2]=k+e*this.delta;c=a+this.zd*3;g[f]=this.lerp(j[a],j[c],e);g[f+1]=this.lerp(j[a+1],j[c+1],e);g[f+2]=this.lerp(j[a+2],j[c+2],e)};this.compNorm=function(a){var c=a*3;this.normal_cache[c]===0&&(this.normal_cache[c]=this.field[a-1]-this.field[a+1],this.normal_cache[c+1]=this.field[a-this.yd]-this.field[a+this.yd],
this.normal_cache[c+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,c,g,f,e,h){var i=f+1,k=f+this.yd,j=f+this.zd,q=i+this.yd,o=i+this.zd,n=f+this.yd+this.zd,s=i+this.yd+this.zd,m=0,p=this.field[f],l=this.field[i],r=this.field[k],t=this.field[q],w=this.field[j],z=this.field[o],v=this.field[n],x=this.field[s];p<e&&(m|=1);l<e&&(m|=2);r<e&&(m|=8);t<e&&(m|=4);w<e&&(m|=16);z<e&&(m|=32);v<e&&(m|=128);x<e&&(m|=64);var y=THREE.edgeTable[m];if(y===0)return 0;var A=this.delta,F=a+
A,u=c+A,A=g+A;y&1&&(this.compNorm(f),this.compNorm(i),this.VIntX(f*3,this.vlist,this.nlist,0,e,a,c,g,p,l));y&2&&(this.compNorm(i),this.compNorm(q),this.VIntY(i*3,this.vlist,this.nlist,3,e,F,c,g,l,t));y&4&&(this.compNorm(k),this.compNorm(q),this.VIntX(k*3,this.vlist,this.nlist,6,e,a,u,g,r,t));y&8&&(this.compNorm(f),this.compNorm(k),this.VIntY(f*3,this.vlist,this.nlist,9,e,a,c,g,p,r));y&16&&(this.compNorm(j),this.compNorm(o),this.VIntX(j*3,this.vlist,this.nlist,12,e,a,c,A,w,z));y&32&&(this.compNorm(o),
this.compNorm(s),this.VIntY(o*3,this.vlist,this.nlist,15,e,F,c,A,z,x));y&64&&(this.compNorm(n),this.compNorm(s),this.VIntX(n*3,this.vlist,this.nlist,18,e,a,u,A,v,x));y&128&&(this.compNorm(j),this.compNorm(n),this.VIntY(j*3,this.vlist,this.nlist,21,e,a,c,A,w,v));y&256&&(this.compNorm(f),this.compNorm(j),this.VIntZ(f*3,this.vlist,this.nlist,24,e,a,c,g,p,w));y&512&&(this.compNorm(i),this.compNorm(o),this.VIntZ(i*3,this.vlist,this.nlist,27,e,F,c,g,l,z));y&1024&&(this.compNorm(q),this.compNorm(s),this.VIntZ(q*
3,this.vlist,this.nlist,30,e,F,u,g,t,x));y&2048&&(this.compNorm(k),this.compNorm(n),this.VIntZ(k*3,this.vlist,this.nlist,33,e,a,u,g,r,v));m<<=4;for(e=f=0;THREE.triTable[m+e]!=-1;)a=m+e,c=a+1,g=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[c],3*THREE.triTable[g],h),e+=3,f++;return f};this.posnormtriv=function(a,c,g,f,e,h){var i=this.count*3;this.positionArray[i]=a[g];this.positionArray[i+1]=a[g+1];this.positionArray[i+2]=a[g+2];this.positionArray[i+3]=a[f];this.positionArray[i+
4]=a[f+1];this.positionArray[i+5]=a[f+2];this.positionArray[i+6]=a[e];this.positionArray[i+7]=a[e+1];this.positionArray[i+8]=a[e+2];this.normalArray[i]=c[g];this.normalArray[i+1]=c[g+1];this.normalArray[i+2]=c[g+2];this.normalArray[i+3]=c[f];this.normalArray[i+4]=c[f+1];this.normalArray[i+5]=c[f+2];this.normalArray[i+6]=c[e];this.normalArray[i+7]=c[e+1];this.normalArray[i+8]=c[e+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&h(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(this.count!==0){for(var c=this.count*3;c<this.positionArray.length;c++)this.positionArray[c]=0;a(this)}};this.addBall=function(a,c,g,f,e){var h=this.size*Math.sqrt(f/e),i=g*this.size,k=c*this.size,j=a*this.size,q=Math.floor(i-h);q<1&&(q=1);i=Math.floor(i+h);i>this.size-1&&(i=this.size-1);var o=Math.floor(k-h);o<1&&(o=1);k=Math.floor(k+h);k>this.size-1&&(k=this.size-1);var n=Math.floor(j-h);n<1&&(n=1);h=Math.floor(j+h);h>this.size-1&&(h=this.size-
1);for(var s,m,p,l,r,t;q<i;q++){j=this.size2*q;m=q/this.size-g;r=m*m;for(m=o;m<k;m++){p=j+this.size*m;s=m/this.size-c;t=s*s;for(s=n;s<h;s++)l=s/this.size-a,l=f/(1.0E-6+l*l+t+r)-e,l>0&&(this.field[p+s]+=l)}}};this.addPlaneX=function(a,c){var g,f,e,h,i,k=this.size,j=this.yd,q=this.zd,o=this.field,n=k*Math.sqrt(a/c);n>k&&(n=k);for(g=0;g<n;g++)if(f=g/k,f*=f,h=a/(1.0E-4+f)-c,h>0)for(f=0;f<k;f++){i=g+f*j;for(e=0;e<k;e++)o[q*e+i]+=h}};this.addPlaneY=function(a,c){var g,f,e,h,i,k,j=this.size,q=this.yd,o=
this.zd,n=this.field,s=j*Math.sqrt(a/c);s>j&&(s=j);for(f=0;f<s;f++)if(g=f/j,g*=g,h=a/(1.0E-4+g)-c,h>0){i=f*q;for(g=0;g<j;g++){k=i+g;for(e=0;e<j;e++)n[o*e+k]+=h}}};this.addPlaneZ=function(a,c){var g,f,e,h,i,k,j=this.size,q=this.yd,o=this.zd,n=this.field,s=j*Math.sqrt(a/c);s>j&&(s=j);for(e=0;e<s;e++)if(g=e/j,g*=g,h=a/(1.0E-4+g)-c,h>0){i=o*e;for(f=0;f<j;f++){k=i+f*q;for(g=0;g<j;g++)n[k+g]+=h}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[a*3]=0,this.field[a]=0};this.render=
function(a){this.begin();var c,g,f,e,h,i,k,j,q,o=this.size-2;for(e=1;e<o;e++){q=this.size2*e;k=(e-this.halfsize)/this.halfsize;for(f=1;f<o;f++){j=q+this.size*f;i=(f-this.halfsize)/this.halfsize;for(g=1;g<o;g++)h=(g-this.halfsize)/this.halfsize,c=j+g,this.polygonize(h,i,k,c,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,c=new THREE.Geometry,g=[];this.render(function(f){var e,h,i,k,j,q,o,n;for(e=0;e<f.count;e++)o=e*3,j=o+1,n=o+2,h=f.positionArray[o],i=f.positionArray[j],k=
f.positionArray[n],q=new THREE.Vector3(h,i,k),h=f.normalArray[o],i=f.normalArray[j],k=f.normalArray[n],o=new THREE.Vector3(h,i,k),o.normalize(),j=new THREE.Vertex(q),c.vertices.push(j),g.push(o);q=f.count/3;for(e=0;e<q;e++)o=(a+e)*3,j=o+1,n=o+2,h=g[o],i=g[j],k=g[n],o=new THREE.Face3(o,j,n,[h,i,k]),c.faces.push(o);a+=q;f.count=0});return c};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
if(THREE.WebGLRenderer)THREE.AnaglyphWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoUpdateScene=!1;var c=this,b=this.setSize,d=this.render,g=new THREE.PerspectiveCamera,f=new THREE.PerspectiveCamera,e=new THREE.Matrix4,h=new THREE.Matrix4,i,k,j,q;g.matrixAutoUpdate=f.matrixAutoUpdate=!1;var a={minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat},o=new THREE.WebGLRenderTarget(512,512,a),n=new THREE.WebGLRenderTarget(512,512,a),s=new THREE.PerspectiveCamera(53,
1,1,1E4);s.position.z=2;var a=new THREE.ShaderMaterial({uniforms:{mapLeft:{type:"t",value:0,texture:o},mapRight:{type:"t",value:1,texture:n}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D mapLeft;\nuniform sampler2D mapRight;\nvarying vec2 vUv;\nvoid main() {\nvec4 colorL, colorR;\nvec2 uv = vUv;\ncolorL = texture2D( mapLeft, uv );\ncolorR = texture2D( mapRight, uv );\ngl_FragColor = vec4( colorL.g * 0.7 + colorL.b * 0.3, colorR.g, colorR.b, colorL.a + colorR.a ) * 1.1;\n}"}),
m=new THREE.Scene;m.add(new THREE.Mesh(new THREE.PlaneGeometry(2,2),a));m.add(s);this.setSize=function(a,d){b.call(c,a,d);o.width=a;o.height=d;n.width=a;n.height=d};this.render=function(a,b){a.updateMatrixWorld();if(i!==b.aspect||k!==b.near||j!==b.far||q!==b.fov){i=b.aspect;k=b.near;j=b.far;q=b.fov;var r=b.projectionMatrix.clone(),t=125/30*0.5,w=t*k/125,z=k*Math.tan(q*Math.PI/360),v;e.n14=t;h.n14=-t;t=-z*i+w;v=z*i+w;r.n11=2*k/(v-t);r.n13=(v+t)/(v-t);g.projectionMatrix.copy(r);t=-z*i-w;v=z*i-w;r.n11=
2*k/(v-t);r.n13=(v+t)/(v-t);f.projectionMatrix.copy(r)}g.matrixWorld.copy(b.matrixWorld).multiplySelf(h);g.position.copy(b.position);g.near=b.near;g.far=b.far;d.call(c,a,g,o,!0);f.matrixWorld.copy(b.matrixWorld).multiplySelf(e);f.position.copy(b.position);f.near=b.near;f.far=b.far;d.call(c,a,f,n,!0);m.updateMatrixWorld();d.call(c,m,s)}};
if(THREE.WebGLRenderer)THREE.CrosseyedWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoClear=!1;var c=this,b=this.setSize,d=this.render,g,f,e=new THREE.PerspectiveCamera;e.target=new THREE.Vector3(0,0,0);var h=new THREE.PerspectiveCamera;h.target=new THREE.Vector3(0,0,0);c.separation=10;if(a&&a.separation!==void 0)c.separation=a.separation;this.setSize=function(a,d){b.call(c,a,d);g=a/2;f=d};this.render=function(a,b){this.clear();e.fov=b.fov;e.aspect=0.5*b.aspect;e.near=b.near;e.far=
b.far;e.updateProjectionMatrix();e.position.copy(b.position);e.target.copy(b.target);e.translateX(c.separation);e.lookAt(e.target);h.projectionMatrix=e.projectionMatrix;h.position.copy(b.position);h.target.copy(b.target);h.translateX(-c.separation);h.lookAt(h.target);this.setViewport(0,0,g,f);d.call(c,a,e);this.setViewport(g,0,g,f);d.call(c,a,h,!1)}};
