// ThreeCanvas.js r45 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,f,e;if(c==0)this.r=this.g=this.b=0;else switch(d=Math.floor(a*6),f=a*6-d,a=c*(1-b),e=c*(1-b*f),b=c*(1-b*(1-f)),d){case 1:this.r=e;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=e;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=
c;this.g=a;this.b=e;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);
Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d;d=c.clone().subSelf(a).dot(b);if(d<=0)return null;a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),
c=c.clone().subSelf(b),f=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(f),e=c.dot(c),c=c.dot(f),f=1/(a*e-b*b),e=(e*d-b*c)*f,a=(a*c-b*d)*f;return e>0&&a>0&&e+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,
Math.max(a.scale.y,a.scale.z)))return[];var f,e,g,h,l,k,o,i,n,j,r=a.geometry,s=r.vertices,w=[],d=0;for(f=r.faces.length;d<f;d++)if(e=r.faces[d],n=this.origin.clone(),j=this.direction.clone(),k=a.matrixWorld,g=k.multiplyVector3(e.centroid.clone()).subSelf(n),i=g.dot(j),!(i<=0)&&(g=k.multiplyVector3(s[e.a].position.clone()),h=k.multiplyVector3(s[e.b].position.clone()),l=k.multiplyVector3(s[e.c].position.clone()),k=e instanceof THREE.Face4?k.multiplyVector3(s[e.d].position.clone()):null,o=a.matrixRotationWorld.multiplyVector3(e.normal.clone()),
i=j.dot(o),a.doubleSided||(a.flipSided?i>0:i<0)))if(i=o.dot((new THREE.Vector3).sub(g,n))/i,n=n.addSelf(j.multiplyScalar(i)),e instanceof THREE.Face3)c(n,g,h,l)&&(e={distance:this.origin.distanceTo(n),point:n,face:e,object:a},w.push(e));else if(e instanceof THREE.Face4&&(c(n,g,h,k)||c(n,h,l,k)))e={distance:this.origin.distanceTo(n),point:n,face:e,object:a},w.push(e);w.sort(function(a,b){return a.distance-b.distance});return w}else return[]}};
THREE.Rectangle=function(){function a(){e=d-b;g=f-c}var b,c,d,f,e,g,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return e};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(e,g,o,i){h=!1;b=e;c=g;d=o;f=i;a()};this.addPoint=function(e,g){h?(h=!1,b=e,c=g,d=e,f=g):(b=b<e?b:e,c=c<g?c:g,d=d>e?d:e,f=f>g?f:g);a()};this.add3Points=
function(e,g,o,i,n,j){h?(h=!1,b=e<o?e<n?e:n:o<n?o:n,c=g<i?g<j?g:j:i<j?i:j,d=e>o?e>n?e:n:o>n?o:n,f=g>i?g>j?g:j:i>j?i:j):(b=e<o?e<n?e<b?e:b:n<b?n:b:o<n?o<b?o:b:n<b?n:b,c=g<i?g<j?g<c?g:c:j<c?j:c:i<j?i<c?i:c:j<c?j:c,d=e>o?e>n?e>d?e:d:n>d?n:d:o>n?o>d?o:d:n>d?n:d,f=g>i?g>j?g>f?g:f:j>f?j:f:i>j?i>f?i:f:j>f?j:f);a()};this.addRectangle=function(e){h?(h=!1,b=e.getLeft(),c=e.getTop(),d=e.getRight(),f=e.getBottom()):(b=b<e.getLeft()?b:e.getLeft(),c=c<e.getTop()?c:e.getTop(),d=d>e.getRight()?d:e.getRight(),f=f>
e.getBottom()?f:e.getBottom());a()};this.inflate=function(e){b-=e;c-=e;d+=e;f+=e;a()};this.minSelf=function(e){b=b>e.getLeft()?b:e.getLeft();c=c>e.getTop()?c:e.getTop();d=d<e.getRight()?d:e.getRight();f=f<e.getBottom()?f:e.getBottom();a()};this.intersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(f,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;f=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,f,e,g,h,l,k,o,i,n,j,r,s){this.set(a!==void 0?a:1,b||0,c||0,d||0,f||0,e!==void 0?e:1,g||0,h||0,l||0,k||0,o!==void 0?o:1,i||0,n||0,j||0,r||0,s!==void 0?s:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,f,e,g,h,l,k,o,i,n,j,r,s){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=f;this.n22=e;this.n23=g;this.n24=h;this.n31=l;this.n32=k;this.n33=o;this.n34=i;this.n41=n;this.n42=j;this.n43=r;this.n44=s;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,e=THREE.Matrix4.__v3;e.sub(a,b).normalize();if(e.length()===0)e.z=1;d.cross(c,e).normalize();d.length()===0&&(e.x+=1.0E-4,d.cross(c,e).normalize());f.cross(e,d).normalize();this.n11=d.x;this.n12=f.x;this.n13=e.x;this.n21=d.y;this.n22=f.y;this.n23=e.y;this.n31=d.z;this.n32=f.z;this.n33=e.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,f=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*f;
a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*f;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*f;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,f=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*f;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+
c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,f=a.n13,e=a.n14,g=a.n21,h=a.n22,l=a.n23,k=a.n24,o=a.n31,i=a.n32,n=a.n33,j=a.n34,r=a.n41,s=a.n42,w=a.n43,u=a.n44,M=b.n11,R=b.n12,
B=b.n13,N=b.n14,O=b.n21,t=b.n22,m=b.n23,C=b.n24,D=b.n31,T=b.n32,U=b.n33,F=b.n34,K=b.n41,I=b.n42,J=b.n43,P=b.n44;this.n11=c*M+d*O+f*D+e*K;this.n12=c*R+d*t+f*T+e*I;this.n13=c*B+d*m+f*U+e*J;this.n14=c*N+d*C+f*F+e*P;this.n21=g*M+h*O+l*D+k*K;this.n22=g*R+h*t+l*T+k*I;this.n23=g*B+h*m+l*U+k*J;this.n24=g*N+h*C+l*F+k*P;this.n31=o*M+i*O+n*D+j*K;this.n32=o*R+i*t+n*T+j*I;this.n33=o*B+i*m+n*U+j*J;this.n34=o*N+i*C+n*F+j*P;this.n41=r*M+s*O+w*D+u*K;this.n42=r*R+s*t+w*T+u*I;this.n43=r*B+s*m+w*U+u*J;this.n44=r*N+s*
C+w*F+u*P;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=
a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,f=this.n21,e=this.n22,g=this.n23,h=this.n24,l=this.n31,k=this.n32,o=this.n33,i=this.n34,n=this.n41,j=this.n42,r=this.n43,s=this.n44;return d*g*k*n-c*h*k*n-d*e*o*n+b*h*o*n+c*e*i*n-b*g*i*n-d*g*l*j+c*h*l*j+d*f*o*j-a*h*o*j-c*f*i*j+a*g*i*j+d*e*l*r-b*h*l*r-d*f*k*r+a*h*k*r+b*f*i*r-a*e*i*r-c*e*l*s+b*g*l*s+c*f*k*s-a*g*k*s-b*f*o*s+a*e*o*s},
transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;
a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;
a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;
a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),f=1-c,e=a.x,g=a.y,h=a.z,l=f*e,k=f*g;this.set(l*e+c,l*g-d*h,l*h+d*g,0,l*g+d*h,k*g+c,k*h-d*e,0,l*h-d*g,k*h+d*e,f*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,f=a.z,e=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),h=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var l=
g*h,k=g*f,o=d*h,i=d*f;this.n11=l+i*c;this.n12=o*c-k;this.n13=e*d;this.n21=e*f;this.n22=e*h;this.n23=-c;this.n31=k*c-o;this.n32=i+l*c;this.n33=e*g;break;case "ZXY":l=g*h;k=g*f;o=d*h;i=d*f;this.n11=l-i*c;this.n12=-e*f;this.n13=o+k*c;this.n21=k+o*c;this.n22=e*h;this.n23=i-l*c;this.n31=-e*d;this.n32=c;this.n33=e*g;break;case "ZYX":l=e*h;k=e*f;o=c*h;i=c*f;this.n11=g*h;this.n12=o*d-k;this.n13=l*d+i;this.n21=g*f;this.n22=i*d+l;this.n23=k*d-o;this.n31=-d;this.n32=c*g;this.n33=e*g;break;case "YZX":l=e*g;k=
e*d;o=c*g;i=c*d;this.n11=g*h;this.n12=i-l*f;this.n13=o*f+k;this.n21=f;this.n22=e*h;this.n23=-c*h;this.n31=-d*h;this.n32=k*f+o;this.n33=l-i*f;break;case "XZY":l=e*g;k=e*d;o=c*g;i=c*d;this.n11=g*h;this.n12=-f;this.n13=d*h;this.n21=l*f+i;this.n22=e*h;this.n23=k*f-o;this.n31=o*f-k;this.n32=c*h;this.n33=i*f+l;break;default:l=e*h,k=e*f,o=c*h,i=c*f,this.n11=g*h,this.n12=-g*f,this.n13=d,this.n21=k+o*d,this.n22=l-i*d,this.n23=-c*g,this.n31=i-l*d,this.n32=o+k*d,this.n33=e*g}return this},setRotationFromQuaternion:function(a){var b=
a.x,c=a.y,d=a.z,f=a.w,e=b+b,g=c+c,h=d+d,a=b*e,l=b*g;b*=h;var k=c*g;c*=h;d*=h;e*=f;g*=f;f*=h;this.n11=1-(k+d);this.n12=l-f;this.n13=b+g;this.n21=l+f;this.n22=1-(a+d);this.n23=c-e;this.n31=b-g;this.n32=c+e;this.n33=1-(a+k);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,f=THREE.Matrix4.__m2;
d.identity();d.setRotationFromQuaternion(b);f.setScale(c.x,c.y,c.z);this.multiply(d,f);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,e=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);f.set(this.n12,this.n22,this.n32);e.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();
c.y=f.length();c.z=e.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,f=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*f;this.n23=
a.n23*f;this.n33=a.n33*f}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,f=a.n13,e=a.n14,g=a.n21,h=a.n22,l=a.n23,k=a.n24,o=a.n31,i=a.n32,n=a.n33,j=a.n34,r=a.n41,s=a.n42,w=a.n43,u=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=l*j*s-k*n*s+k*i*w-h*j*w-l*i*u+h*n*u;b.n12=e*n*s-f*j*s-e*i*w+d*j*w+f*i*u-d*n*u;b.n13=f*k*s-e*l*s+e*h*w-d*k*w-f*h*u+d*l*u;b.n14=e*l*i-f*k*i-e*h*n+d*k*n+f*h*j-d*l*j;b.n21=k*n*r-l*j*r-k*o*w+g*j*w+l*o*u-g*n*u;b.n22=f*j*r-e*n*r+e*o*w-c*j*w-f*o*u+c*n*u;b.n23=e*l*r-f*k*r-e*g*w+c*k*w+f*g*u-c*l*u;b.n24=
f*k*o-e*l*o+e*g*n-c*k*n-f*g*j+c*l*j;b.n31=h*j*r-k*i*r+k*o*s-g*j*s-h*o*u+g*i*u;b.n32=e*i*r-d*j*r-e*o*s+c*j*s+d*o*u-c*i*u;b.n33=f*k*r-e*h*r+e*g*s-c*k*s-d*g*u+c*h*u;b.n34=e*h*o-d*k*o-e*g*i+c*k*i+d*g*j-c*h*j;b.n41=l*i*r-h*n*r-l*o*s+g*n*s+h*o*w-g*i*w;b.n42=d*n*r-f*i*r+f*o*s-c*n*s-d*o*w+c*i*w;b.n43=f*h*r-d*l*r-f*g*s+c*l*s+d*g*w-c*h*w;b.n44=d*l*o-f*h*o+f*g*i-c*l*i-d*g*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,e=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,l=-a.n32*a.n11+a.n31*a.n12,k=a.n23*a.n12-a.n22*a.n13,o=-a.n23*a.n11+a.n21*a.n13,i=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*g+a.n31*k;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*f;c[2]=a*e;c[3]=a*g;c[4]=a*h;c[5]=a*l;c[6]=a*k;c[7]=a*o;c[8]=a*i;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,f,e){var g;g=new THREE.Matrix4;g.n11=2*f/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*f/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(e+f)/(e-f);g.n34=-2*e*f/(e-f);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var f,a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,f,e){var g,h,l,k;g=new THREE.Matrix4;h=b-a;l=c-d;k=e-f;g.n11=2/h;g.n12=0;g.n13=0;g.n14=-((b+a)/h);g.n21=0;g.n22=2/l;g.n23=0;g.n24=-((c+d)/l);g.n31=0;g.n32=0;g.n33=-2/k;g.n34=-((e+f)/k);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.name="";this.id=THREE.Object3DCount++;this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},remove:function(a){var b=this,c=this.children.indexOf(a);if(c!==-1){a.parent=void 0;for(this.children.splice(c,1);b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.removeChildRecurse(a)}},getChildByName:function(a,b){var c,d,f;c=0;for(d=this.children.length;c<d;c++){f=this.children[c];if(f.name===
a)return f;if(b&&(f=f.getChildByName(a,b),f!==void 0))return f}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)},addChild:function(a){console.warn("DEPRECATED: Object3D.addChild() is now Object3D.add().");this.add(a)},removeChild:function(a){console.warn("DEPRECATED: Object3D.removeChild() is now Object3D.remove().");
this.remove(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=l[h]=l[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,f,e=[],g,h,l=[],k,o,i=[],n,j=[],r,s,w=[],u,M,R=[],B=[],N=[],O=new THREE.Vector4,t=new THREE.Vector4,
m=new THREE.Matrix4,C=new THREE.Matrix4,D=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],T=new THREE.Vector4,U=new THREE.Vector4;this.projectVector=function(a,b){m.multiply(b.projectionMatrix,b.matrixWorldInverse);m.multiplyVector3(a);return a};this.unprojectVector=function(a,b){m.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));m.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,
a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectObjects=function(a,c,g){var h,j;f=B.length=0;h=a.objects;a=0;for(c=h.length;a<c;a++){j=h[a];var i;if(!(i=!j.visible))if(i=j instanceof THREE.Mesh)if(i=j.frustumCulled){a:{i=void 0;for(var k=j.matrixWorld,l=-j.geometry.boundingSphere.radius*Math.max(j.scale.x,Math.max(j.scale.y,j.scale.z)),n=0;n<6;n++)if(i=D[n].x*k.n14+D[n].y*k.n24+D[n].z*k.n34+D[n].w,i<=l){i=!1;break a}i=!0}i=
!i}if(!i)i=e[f]=e[f]||new THREE.RenderableObject,f++,d=i,O.copy(j.position),m.multiplyVector3(O),d.object=j,d.z=O.z,B.push(d)}g&&B.sort(b);return B};this.projectScene=function(d,e,f){var J=e.near,P=e.far,Q,V,E,B,y,L,H,z,x,q,v,G,O,ea,Z,ba,W;M=s=n=o=N.length=0;e.matrixAutoUpdate&&e.update(void 0,!0);d.update(void 0,!1,e);m.multiply(e.projectionMatrix,e.matrixWorldInverse);D[0].set(m.n41-m.n11,m.n42-m.n12,m.n43-m.n13,m.n44-m.n14);D[1].set(m.n41+m.n11,m.n42+m.n12,m.n43+m.n13,m.n44+m.n14);D[2].set(m.n41+
m.n21,m.n42+m.n22,m.n43+m.n23,m.n44+m.n24);D[3].set(m.n41-m.n21,m.n42-m.n22,m.n43-m.n23,m.n44-m.n24);D[4].set(m.n41-m.n31,m.n42-m.n32,m.n43-m.n33,m.n44-m.n34);D[5].set(m.n41+m.n31,m.n42+m.n32,m.n43+m.n33,m.n44+m.n34);for(Q=0;Q<6;Q++)x=D[Q],x.divideScalar(Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z));x=this.projectObjects(d,e,!0);d=0;for(Q=x.length;d<Q;d++)if(q=x[d].object,q.visible)if(v=q.matrixWorld,G=q.matrixRotationWorld,O=q.materials,ea=q.overdraw,h=0,q instanceof THREE.Mesh){Z=q.geometry;B=Z.vertices;
ba=Z.faces;Z=Z.faceVertexUvs;V=0;for(E=B.length;V<E;V++)g=a(),g.positionWorld.copy(B[V].position),v.multiplyVector3(g.positionWorld),g.positionScreen.copy(g.positionWorld),m.multiplyVector4(g.positionScreen),g.positionScreen.x/=g.positionScreen.w,g.positionScreen.y/=g.positionScreen.w,g.visible=g.positionScreen.z>J&&g.positionScreen.z<P;B=0;for(V=ba.length;B<V;B++){E=ba[B];if(E instanceof THREE.Face3)if(y=l[E.a],L=l[E.b],H=l[E.c],y.visible&&L.visible&&H.visible&&(q.doubleSided||q.flipSided!=(H.positionScreen.x-
y.positionScreen.x)*(L.positionScreen.y-y.positionScreen.y)-(H.positionScreen.y-y.positionScreen.y)*(L.positionScreen.x-y.positionScreen.x)<0))z=i[o]=i[o]||new THREE.RenderableFace3,o++,k=z,k.v1.copy(y),k.v2.copy(L),k.v3.copy(H);else continue;else if(E instanceof THREE.Face4)if(y=l[E.a],L=l[E.b],H=l[E.c],z=l[E.d],y.visible&&L.visible&&H.visible&&z.visible&&(q.doubleSided||q.flipSided!=((z.positionScreen.x-y.positionScreen.x)*(L.positionScreen.y-y.positionScreen.y)-(z.positionScreen.y-y.positionScreen.y)*
(L.positionScreen.x-y.positionScreen.x)<0||(L.positionScreen.x-H.positionScreen.x)*(z.positionScreen.y-H.positionScreen.y)-(L.positionScreen.y-H.positionScreen.y)*(z.positionScreen.x-H.positionScreen.x)<0)))W=j[n]=j[n]||new THREE.RenderableFace4,n++,k=W,k.v1.copy(y),k.v2.copy(L),k.v3.copy(H),k.v4.copy(z);else continue;k.normalWorld.copy(E.normal);G.multiplyVector3(k.normalWorld);k.centroidWorld.copy(E.centroid);v.multiplyVector3(k.centroidWorld);k.centroidScreen.copy(k.centroidWorld);m.multiplyVector3(k.centroidScreen);
H=E.vertexNormals;y=0;for(L=H.length;y<L;y++)z=k.vertexNormalsWorld[y],z.copy(H[y]),G.multiplyVector3(z);y=0;for(L=Z.length;y<L;y++)if(W=Z[y][B]){H=0;for(z=W.length;H<z;H++)k.uvs[y][H]=W[H]}k.meshMaterials=O;k.faceMaterials=E.materials;k.overdraw=ea;k.z=k.centroidScreen.z;N.push(k)}}else if(q instanceof THREE.Line){C.multiply(m,v);B=q.geometry.vertices;y=a();y.positionScreen.copy(B[0].position);C.multiplyVector4(y.positionScreen);V=1;for(E=B.length;V<E;V++)if(y=a(),y.positionScreen.copy(B[V].position),
C.multiplyVector4(y.positionScreen),L=l[h-2],T.copy(y.positionScreen),U.copy(L.positionScreen),c(T,U))T.multiplyScalar(1/T.w),U.multiplyScalar(1/U.w),v=w[s]=w[s]||new THREE.RenderableLine,s++,r=v,r.v1.positionScreen.copy(T),r.v2.positionScreen.copy(U),r.z=Math.max(T.z,U.z),r.materials=q.materials,N.push(r)}else if(q instanceof THREE.Particle&&(t.set(q.matrixWorld.n14,q.matrixWorld.n24,q.matrixWorld.n34,1),m.multiplyVector4(t),t.z/=t.w,t.z>0&&t.z<1))v=R[M]=R[M]||new THREE.RenderableParticle,M++,u=
v,u.x=t.x/t.w,u.y=t.y/t.w,u.z=t.z,u.rotation=q.rotation.z,u.scale.x=q.scale.x*Math.abs(u.x-(t.x+e.projectionMatrix.n11)/(t.w+e.projectionMatrix.n14)),u.scale.y=q.scale.y*Math.abs(u.y-(t.y+e.projectionMatrix.n22)/(t.w+e.projectionMatrix.n24)),u.materials=q.materials,N.push(u);f&&N.sort(b);return N}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-f),f=Math.sin(-f),e=Math.cos(c),c=Math.sin(c),g=a*b,h=d*f;this.w=g*e-h*c;this.x=g*c+h*e;this.y=d*b*e+a*f*c;this.z=a*f*e-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=a.n32-a.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=a.n13-a.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.n21-a.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,f=this.w,e=a.x,g=a.y,h=a.z,a=a.w;this.x=b*a+f*e+c*h-d*g;this.y=c*a+f*g+d*e-b*h;this.z=d*a+f*h+b*g-c*e;this.w=f*a-b*e-c*g-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,e=this.x,g=this.y,h=this.z,l=this.w,k=l*c+g*f-h*d,o=l*d+h*c-e*f,i=l*f+e*d-g*c,c=-e*
c-g*d-h*f;b.x=k*l+c*-e+o*-h-i*-g;b.y=o*l+c*-g+i*-e-k*-h;b.z=i*l+c*-h+k*-g-o*-e;return b}};THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(f)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var e=Math.acos(f),g=Math.sqrt(1-f*f);if(Math.abs(g)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;f=Math.sin((1-d)*e)/g;d=Math.sin(d*e)/g;c.w=a.w*f+b.w*d;c.x=a.x*f+b.x*d;c.y=a.y*f+b.y*d;c.z=a.z*f+b.z*d;return c};
THREE.Vertex=function(a){this.position=a||new THREE.Vector3};THREE.Face3=function(a,b,c,d,f,e){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materials=e instanceof Array?e:[e];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,f,e,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var f=this.faces[c];b.multiplyVector3(f.normal);for(var e=0,g=f.vertexNormals.length;e<g;e++)b.multiplyVector3(f.vertexNormals[e]);a.multiplyVector3(f.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,
c,d,f,e,g,h=new THREE.Vector3,l=new THREE.Vector3;d=0;for(f=this.faces.length;d<f;d++){e=this.faces[d];if(a&&e.vertexNormals.length){h.set(0,0,0);b=0;for(c=e.vertexNormals.length;b<c;b++)h.addSelf(e.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[e.a],c=this.vertices[e.b],g=this.vertices[e.c],h.sub(g.position,c.position),l.sub(b.position,c.position),h.crossSelf(l);h.isZero()||h.normalize();e.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=
Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof
THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,e,f,m){h=a.vertices[b].position;l=a.vertices[c].position;k=a.vertices[d].position;o=g[e];i=g[f];n=g[m];j=l.x-h.x;r=k.x-h.x;s=l.y-h.y;w=k.y-h.y;u=l.z-h.z;M=k.z-h.z;R=i.u-o.u;B=n.u-o.u;N=i.v-o.v;O=n.v-o.v;t=1/(R*O-B*N);T.set((O*j-N*r)*t,(O*s-N*w)*t,(O*u-N*M)*t);U.set((R*r-B*j)*t,(R*w-B*s)*t,(R*M-B*u)*t);C[b].addSelf(T);C[c].addSelf(T);C[d].addSelf(T);D[b].addSelf(U);
D[c].addSelf(U);D[d].addSelf(U)}var b,c,d,f,e,g,h,l,k,o,i,n,j,r,s,w,u,M,R,B,N,O,t,m,C=[],D=[],T=new THREE.Vector3,U=new THREE.Vector3,F=new THREE.Vector3,K=new THREE.Vector3,I=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)C[b]=new THREE.Vector3,D[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)e=this.faces[b],g=this.faceVertexUvs[0][b],e instanceof THREE.Face3?a(this,e.a,e.b,e.c,0,1,2):e instanceof THREE.Face4&&(a(this,e.a,e.b,e.c,0,1,2),a(this,e.a,e.b,e.d,0,1,3));var J=["a","b",
"c","d"];b=0;for(c=this.faces.length;b<c;b++){e=this.faces[b];for(d=0;d<e.vertexNormals.length;d++)I.copy(e.vertexNormals[d]),f=e[J[d]],m=C[f],F.copy(m),F.subSelf(I.multiplyScalar(I.dot(m))).normalize(),K.cross(e.vertexNormals[d],m),f=K.dot(D[f]),f=f<0?-1:1,e.vertexTangents[d]=new THREE.Vector4(F.x,F.y,F.z,f)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,
this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=
a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},mergeVertices:function(){var a={},b=[],c=[],d,f=Math.pow(10,4),e,g;e=0;for(g=this.vertices.length;e<g;e++)d=this.vertices[e].position,d=[Math.round(d.x*f),Math.round(d.y*f),Math.round(d.z*f)].join("_"),a[d]===void 0?(a[d]=e,b.push(this.vertices[e]),
c[e]=b.length-1):c[e]=c[a[d]];e=0;for(g=this.faces.length;e<g;e++){a=this.faces[e];if(a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d]}this.vertices=b}};THREE.GeometryCount=0;
THREE.Camera=function(){if(arguments.length)return console.warn("DEPRECATED: Camera() is now PerspectiveCamera() or OrthographicCamera()."),new THREE.PerspectiveCamera(arguments[0],arguments[1],arguments[2],arguments[3]);THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)};
THREE.Camera.prototype.update=function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};
THREE.OrthographicCamera=function(a,b,c,d,f,e){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=f!==void 0?f:0.1;this.far=e!==void 0?e:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};
THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=a!==void 0?a:50;this.aspect=b!==void 0?b:1;this.near=c!==void 0?c:0.1;this.far=d!==void 0?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((b!==void 0?b:43.25)/(a*2));this.fov*=180/Math.PI;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,f,e){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=f;this.height=e;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.PointLight.prototype=new THREE.Light;
THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.name="";this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?
a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?
a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=
a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,f,e){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=f!==void 0?f:THREE.LinearFilter;this.minFilter=e!==void 0?e:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};
THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<f;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<f;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.fog=null;this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;
THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.add=function(a){this.supr.add.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);b!==-1&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};THREE.Scene.prototype.remove=function(a){this.supr.remove.call(this,a);this.removeChildRecurse(a)};
THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),b!==-1&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addChild=function(a){console.warn("DEPRECATED: Scene.addChild() is now Scene.add().");this.add(a)};THREE.Scene.prototype.addObject=function(a){console.warn("DEPRECATED: Scene.addObject() is now Scene.add().");this.add(a)};THREE.Scene.prototype.addLight=function(a){console.warn("DEPRECATED: Scene.addLight() is now Scene.add().");this.add(a)};THREE.Scene.prototype.removeChild=function(a){console.warn("DEPRECATED: Scene.removeChild() is now Scene.remove().");this.remove(a)};
THREE.Scene.prototype.removeObject=function(a){console.warn("DEPRECATED: Scene.removeObject() is now Scene.remove().");this.remove(a)};THREE.Scene.prototype.removeLight=function(a){console.warn("DEPRECATED: Scene.removeLight() is now Scene.remove().");this.remove(a)};
THREE.CanvasRenderer=function(a){function b(a){if(w!=a)j.globalAlpha=w=a}function c(a){if(u!=a){switch(a){case THREE.NormalBlending:j.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:j.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:j.globalCompositeOperation="darker"}u=a}}function d(a){if(M!=a)j.strokeStyle=M=a}function f(a){if(R!=a)j.fillStyle=R=a}var e=this,g=null,h=new THREE.Projector,a=a||{},l=a.canvas!==void 0?a.canvas:document.createElement("canvas"),
k,o,i,n,j=l.getContext("2d"),r=new THREE.Color(0),s=0,w=1,u=0,M=null,R=null,B=null,N=null,O=null,t,m,C,D,T=new THREE.RenderableVertex,U=new THREE.RenderableVertex,F,K,I,J,P,Q,V,E,pa,y,L,H,z=new THREE.Color(0),x=new THREE.Color(0),q=new THREE.Color(0),v=new THREE.Color(0),G=new THREE.Color(0),za=[],ea,Z,ba,W,Da,Ea,Fa,Ga,Ha,Ia,ka=new THREE.Rectangle,$=new THREE.Rectangle,Y=new THREE.Rectangle,Aa=!1,ca=new THREE.Color,aa=new THREE.Color,ta=new THREE.Color,ua=new THREE.Color,S=new THREE.Vector3,qa,ra,
Ba,da,sa,va,a=16;qa=document.createElement("canvas");qa.width=qa.height=2;ra=qa.getContext("2d");ra.fillStyle="rgba(0,0,0,1)";ra.fillRect(0,0,2,2);Ba=ra.getImageData(0,0,2,2);da=Ba.data;sa=document.createElement("canvas");sa.width=sa.height=a;va=sa.getContext("2d");va.translate(-a/2,-a/2);va.scale(a,a);a--;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.info={render:{vertices:0,faces:0}};this.setSize=function(a,b){k=a;o=b;i=Math.floor(k/2);n=Math.floor(o/2);l.width=k;l.height=
o;ka.set(-i,-n,i,n);$.set(-i,-n,i,n);w=1;u=0;O=N=B=R=M=null};this.setClearColor=function(a,b){r.copy(a);s=b;$.set(-i,-n,i,n)};this.setClearColorHex=function(a,b){r.setHex(a);s=b;$.set(-i,-n,i,n)};this.clear=function(){j.setTransform(1,0,0,-1,i,n);$.isEmpty()||($.minSelf(ka),$.inflate(2),s<1&&j.clearRect(Math.floor($.getX()),Math.floor($.getY()),Math.floor($.getWidth()),Math.floor($.getHeight())),s>0&&(c(THREE.NormalBlending),b(1),f("rgba("+Math.floor(r.r*255)+","+Math.floor(r.g*255)+","+Math.floor(r.b*
255)+","+s+")"),j.fillRect(Math.floor($.getX()),Math.floor($.getY()),Math.floor($.getWidth()),Math.floor($.getHeight()))),$.empty())};this.render=function(a,k){function l(a){var b,c,d,e=a.lights;aa.setRGB(0,0,0);ta.setRGB(0,0,0);ua.setRGB(0,0,0);a=0;for(b=e.length;a<b;a++)c=e[a],d=c.color,c instanceof THREE.AmbientLight?(aa.r+=d.r,aa.g+=d.g,aa.b+=d.b):c instanceof THREE.DirectionalLight?(ta.r+=d.r,ta.g+=d.g,ta.b+=d.b):c instanceof THREE.PointLight&&(ua.r+=d.r,ua.g+=d.g,ua.b+=d.b)}function o(a,b,c,
d){var e,f,g,h,j=a.lights,a=0;for(e=j.length;a<e;a++)f=j[a],g=f.color,f instanceof THREE.DirectionalLight?(h=c.dot(f.position),h<=0||(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)):f instanceof THREE.PointLight&&(h=c.dot(S.sub(f.position,b).normalize()),h<=0||(h*=f.distance==0?1:1-Math.min(b.distanceTo(f.position)/f.distance,1),h!=0&&(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)))}function r(a,e,g){b(g.opacity);c(g.blending);var h,k,l,o,p,m;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)o=
g.map.image,p=o.width>>1,m=o.height>>1,g=e.scale.x*i,l=e.scale.y*n,h=g*p,k=l*m,Y.set(a.x-h,a.y-k,a.x+h,a.y+k),ka.intersects(Y)&&(j.save(),j.translate(a.x,a.y),j.rotate(-e.rotation),j.scale(g,-l),j.translate(-p,-m),j.drawImage(o,0,0),j.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=e.scale.x*i,k=e.scale.y*n,Y.set(a.x-h,a.y-k,a.x+h,a.y+k),ka.intersects(Y)&&(d(g.color.getContextStyle()),f(g.color.getContextStyle()),j.save(),j.translate(a.x,a.y),j.rotate(-e.rotation),j.scale(h,k),g.program(j),
j.restore()))}function s(a,e,f,g){b(g.opacity);c(g.blending);j.beginPath();j.moveTo(a.positionScreen.x,a.positionScreen.y);j.lineTo(e.positionScreen.x,e.positionScreen.y);j.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(B!=a)j.lineWidth=B=a;a=g.linecap;if(N!=a)j.lineCap=N=a;a=g.linejoin;if(O!=a)j.lineJoin=O=a;d(g.color.getContextStyle());j.stroke();Y.inflate(g.linewidth*2)}}function u(a,d,f,g,h,j,i,p,l){e.info.render.vertices+=3;e.info.render.faces++;b(p.opacity);c(p.blending);
F=a.positionScreen.x;K=a.positionScreen.y;I=d.positionScreen.x;J=d.positionScreen.y;P=f.positionScreen.x;Q=f.positionScreen.y;M(F,K,I,J,P,Q);if(p instanceof THREE.MeshBasicMaterial)if(p.map)p.map.mapping instanceof THREE.UVMapping&&(W=i.uvs[0],Ca(F,K,I,J,P,Q,W[g].u,W[g].v,W[h].u,W[h].v,W[j].u,W[j].v,p.map));else if(p.envMap){if(p.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=k.matrixWorldInverse,S.copy(i.vertexNormalsWorld[0]),Da=(S.x*a.n11+S.y*a.n12+S.z*a.n13)*0.5+0.5,Ea=-(S.x*a.n21+
S.y*a.n22+S.z*a.n23)*0.5+0.5,S.copy(i.vertexNormalsWorld[1]),Fa=(S.x*a.n11+S.y*a.n12+S.z*a.n13)*0.5+0.5,Ga=-(S.x*a.n21+S.y*a.n22+S.z*a.n23)*0.5+0.5,S.copy(i.vertexNormalsWorld[2]),Ha=(S.x*a.n11+S.y*a.n12+S.z*a.n13)*0.5+0.5,Ia=-(S.x*a.n21+S.y*a.n22+S.z*a.n23)*0.5+0.5,Ca(F,K,I,J,P,Q,Da,Ea,Fa,Ga,Ha,Ia,p.envMap)}else p.wireframe?ga(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(p.color);else if(p instanceof THREE.MeshLambertMaterial)p.map&&!p.wireframe&&(p.map.mapping instanceof
THREE.UVMapping&&(W=i.uvs[0],Ca(F,K,I,J,P,Q,W[g].u,W[g].v,W[h].u,W[h].v,W[j].u,W[j].v,p.map)),c(THREE.SubtractiveBlending)),Aa?!p.wireframe&&p.shading==THREE.SmoothShading&&i.vertexNormalsWorld.length==3?(x.r=q.r=v.r=aa.r,x.g=q.g=v.g=aa.g,x.b=q.b=v.b=aa.b,o(l,i.v1.positionWorld,i.vertexNormalsWorld[0],x),o(l,i.v2.positionWorld,i.vertexNormalsWorld[1],q),o(l,i.v3.positionWorld,i.vertexNormalsWorld[2],v),x.r=Math.max(0,Math.min(p.color.r*x.r,1)),x.g=Math.max(0,Math.min(p.color.g*x.g,1)),x.b=Math.max(0,
Math.min(p.color.b*x.b,1)),q.r=Math.max(0,Math.min(p.color.r*q.r,1)),q.g=Math.max(0,Math.min(p.color.g*q.g,1)),q.b=Math.max(0,Math.min(p.color.b*q.b,1)),v.r=Math.max(0,Math.min(p.color.r*v.r,1)),v.g=Math.max(0,Math.min(p.color.g*v.g,1)),v.b=Math.max(0,Math.min(p.color.b*v.b,1)),G.r=(q.r+v.r)*0.5,G.g=(q.g+v.g)*0.5,G.b=(q.b+v.b)*0.5,ba=wa(x,q,v,G),ma(F,K,I,J,P,Q,0,0,1,0,0,1,ba)):(ca.r=aa.r,ca.g=aa.g,ca.b=aa.b,o(l,i.centroidWorld,i.normalWorld,ca),z.r=Math.max(0,Math.min(p.color.r*ca.r,1)),z.g=Math.max(0,
Math.min(p.color.g*ca.g,1)),z.b=Math.max(0,Math.min(p.color.b*ca.b,1)),p.wireframe?ga(z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(z)):p.wireframe?ga(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(p.color);else if(p instanceof THREE.MeshDepthMaterial)ea=k.near,Z=k.far,x.r=x.g=x.b=1-la(a.positionScreen.z,ea,Z),q.r=q.g=q.b=1-la(d.positionScreen.z,ea,Z),v.r=v.g=v.b=1-la(f.positionScreen.z,ea,Z),G.r=(q.r+v.r)*0.5,G.g=(q.g+v.g)*0.5,G.b=(q.b+v.b)*0.5,ba=wa(x,
q,v,G),ma(F,K,I,J,P,Q,0,0,1,0,0,1,ba);else if(p instanceof THREE.MeshNormalMaterial)z.r=na(i.normalWorld.x),z.g=na(i.normalWorld.y),z.b=na(i.normalWorld.z),p.wireframe?ga(z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(z)}function w(a,d,f,g,h,j,i,p,l){e.info.render.vertices+=4;e.info.render.faces++;b(p.opacity);c(p.blending);if(p.map||p.envMap)u(a,d,g,0,1,3,i,p,l),u(h,f,j,1,2,3,i,p,l);else if(F=a.positionScreen.x,K=a.positionScreen.y,I=d.positionScreen.x,J=d.positionScreen.y,P=f.positionScreen.x,
Q=f.positionScreen.y,V=g.positionScreen.x,E=g.positionScreen.y,pa=h.positionScreen.x,y=h.positionScreen.y,L=j.positionScreen.x,H=j.positionScreen.y,p instanceof THREE.MeshBasicMaterial)R(F,K,I,J,P,Q,V,E),p.wireframe?ga(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(p.color);else if(p instanceof THREE.MeshLambertMaterial)Aa?!p.wireframe&&p.shading==THREE.SmoothShading&&i.vertexNormalsWorld.length==4?(x.r=q.r=v.r=G.r=aa.r,x.g=q.g=v.g=G.g=aa.g,x.b=q.b=v.b=G.b=aa.b,o(l,i.v1.positionWorld,
i.vertexNormalsWorld[0],x),o(l,i.v2.positionWorld,i.vertexNormalsWorld[1],q),o(l,i.v4.positionWorld,i.vertexNormalsWorld[3],v),o(l,i.v3.positionWorld,i.vertexNormalsWorld[2],G),x.r=Math.max(0,Math.min(p.color.r*x.r,1)),x.g=Math.max(0,Math.min(p.color.g*x.g,1)),x.b=Math.max(0,Math.min(p.color.b*x.b,1)),q.r=Math.max(0,Math.min(p.color.r*q.r,1)),q.g=Math.max(0,Math.min(p.color.g*q.g,1)),q.b=Math.max(0,Math.min(p.color.b*q.b,1)),v.r=Math.max(0,Math.min(p.color.r*v.r,1)),v.g=Math.max(0,Math.min(p.color.g*
v.g,1)),v.b=Math.max(0,Math.min(p.color.b*v.b,1)),G.r=Math.max(0,Math.min(p.color.r*G.r,1)),G.g=Math.max(0,Math.min(p.color.g*G.g,1)),G.b=Math.max(0,Math.min(p.color.b*G.b,1)),ba=wa(x,q,v,G),M(F,K,I,J,V,E),ma(F,K,I,J,V,E,0,0,1,0,0,1,ba),M(pa,y,P,Q,L,H),ma(pa,y,P,Q,L,H,1,0,1,1,0,1,ba)):(ca.r=aa.r,ca.g=aa.g,ca.b=aa.b,o(l,i.centroidWorld,i.normalWorld,ca),z.r=Math.max(0,Math.min(p.color.r*ca.r,1)),z.g=Math.max(0,Math.min(p.color.g*ca.g,1)),z.b=Math.max(0,Math.min(p.color.b*ca.b,1)),R(F,K,I,J,P,Q,V,E),
p.wireframe?ga(z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(z)):(R(F,K,I,J,P,Q,V,E),p.wireframe?ga(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(p.color));else if(p instanceof THREE.MeshNormalMaterial)z.r=na(i.normalWorld.x),z.g=na(i.normalWorld.y),z.b=na(i.normalWorld.z),R(F,K,I,J,P,Q,V,E),p.wireframe?ga(z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):ha(z);else if(p instanceof THREE.MeshDepthMaterial)ea=k.near,Z=k.far,x.r=x.g=x.b=1-la(a.positionScreen.z,
ea,Z),q.r=q.g=q.b=1-la(d.positionScreen.z,ea,Z),v.r=v.g=v.b=1-la(g.positionScreen.z,ea,Z),G.r=G.g=G.b=1-la(f.positionScreen.z,ea,Z),ba=wa(x,q,v,G),M(F,K,I,J,V,E),ma(F,K,I,J,V,E,0,0,1,0,0,1,ba),M(pa,y,P,Q,L,H),ma(pa,y,P,Q,L,H,1,0,1,1,0,1,ba)}function M(a,b,c,d,e,f){j.beginPath();j.moveTo(a,b);j.lineTo(c,d);j.lineTo(e,f);j.lineTo(a,b);j.closePath()}function R(a,b,c,d,e,f,g,h){j.beginPath();j.moveTo(a,b);j.lineTo(c,d);j.lineTo(e,f);j.lineTo(g,h);j.lineTo(a,b);j.closePath()}function ga(a,b,c,e){if(B!=
b)j.lineWidth=B=b;if(N!=c)j.lineCap=N=c;if(O!=e)j.lineJoin=O=e;d(a.getContextStyle());j.stroke();Y.inflate(b*2)}function ha(a){f(a.getContextStyle());j.fill()}function Ca(a,b,c,d,e,g,h,i,k,l,o,n,m){if(m.image.width!=0){if(m.needsUpdate==!0||za[m.id]==void 0){var q=m.wrapS==THREE.RepeatWrapping,r=m.wrapT==THREE.RepeatWrapping;za[m.id]=j.createPattern(m.image,q&&r?"repeat":q&&!r?"repeat-x":!q&&r?"repeat-y":"no-repeat");m.needsUpdate=!1}f(za[m.id]);var q=m.offset.x/m.repeat.x,r=m.offset.y/m.repeat.y,
s=(m.image.width-1)*m.repeat.x,m=(m.image.height-1)*m.repeat.y,h=(h+q)*s,i=(i+r)*m,k=(k+q)*s,l=(l+r)*m,o=(o+q)*s,n=(n+r)*m;c-=a;d-=b;e-=a;g-=b;k-=h;l-=i;o-=h;n-=i;q=1/(k*n-o*l);m=(n*c-l*e)*q;l=(n*d-l*g)*q;c=(k*e-o*c)*q;d=(k*g-o*d)*q;a=a-m*h-c*i;b=b-l*h-d*i;j.save();j.transform(m,l,c,d,a,b);j.fill();j.restore()}}function ma(a,b,c,d,e,f,g,h,i,k,l,m,o){var n,q;n=o.width-1;q=o.height-1;g*=n;h*=q;i*=n;k*=q;l*=n;m*=q;c-=a;d-=b;e-=a;f-=b;i-=g;k-=h;l-=g;m-=h;q=1/(i*m-l*k);n=(m*c-k*e)*q;k=(m*d-k*f)*q;c=(i*
e-l*c)*q;d=(i*f-l*d)*q;a=a-n*g-c*h;b=b-k*g-d*h;j.save();j.transform(n,k,c,d,a,b);j.clip();j.drawImage(o,0,0);j.restore()}function wa(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);da[0]=e<0?0:e>255?255:e;da[1]=f<0?0:f>255?255:f;da[2]=a<0?0:a>255?255:a;da[4]=g<0?0:g>255?255:g;da[5]=h<0?0:h>255?255:h;da[6]=b<0?0:b>255?255:b;da[8]=i<0?0:i>255?255:i;da[9]=j<0?0:j>255?255:
j;da[10]=c<0?0:c>255?255:c;da[12]=k<0?0:k>255?255:k;da[13]=l<0?0:l>255?255:l;da[14]=d<0?0:d>255?255:d;ra.putImageData(Ba,0,0);va.drawImage(qa,0,0);return sa}function la(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function na(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ia(a,b){var c=b.x-a.x,d=b.y-a.y,e=c*c+d*d;e!=0&&(e=1/Math.sqrt(e),c*=e,d*=e,b.x+=c,b.y+=d,a.x-=c,a.y-=d)}var xa,Ja,A,fa,ja,oa,ya,X;this.autoClear?this.clear():j.setTransform(1,0,0,-1,i,n);e.info.render.vertices=0;e.info.render.faces=0;
g=h.projectScene(a,k,this.sortElements);(Aa=a.lights.length>0)&&l(a);xa=0;for(Ja=g.length;xa<Ja;xa++){A=g[xa];Y.empty();if(A instanceof THREE.RenderableParticle){t=A;t.x*=i;t.y*=n;fa=0;for(ja=A.materials.length;fa<ja;)X=A.materials[fa++],X.opacity!=0&&r(t,A,X,a)}else if(A instanceof THREE.RenderableLine){if(t=A.v1,m=A.v2,t.positionScreen.x*=i,t.positionScreen.y*=n,m.positionScreen.x*=i,m.positionScreen.y*=n,Y.addPoint(t.positionScreen.x,t.positionScreen.y),Y.addPoint(m.positionScreen.x,m.positionScreen.y),
ka.intersects(Y)){fa=0;for(ja=A.materials.length;fa<ja;)X=A.materials[fa++],X.opacity!=0&&s(t,m,A,X,a)}}else if(A instanceof THREE.RenderableFace3){if(t=A.v1,m=A.v2,C=A.v3,t.positionScreen.x*=i,t.positionScreen.y*=n,m.positionScreen.x*=i,m.positionScreen.y*=n,C.positionScreen.x*=i,C.positionScreen.y*=n,A.overdraw&&(ia(t.positionScreen,m.positionScreen),ia(m.positionScreen,C.positionScreen),ia(C.positionScreen,t.positionScreen)),Y.add3Points(t.positionScreen.x,t.positionScreen.y,m.positionScreen.x,
m.positionScreen.y,C.positionScreen.x,C.positionScreen.y),ka.intersects(Y)){fa=0;for(ja=A.meshMaterials.length;fa<ja;)if(X=A.meshMaterials[fa++],X instanceof THREE.MeshFaceMaterial){oa=0;for(ya=A.faceMaterials.length;oa<ya;)(X=A.faceMaterials[oa++])&&X.opacity!=0&&u(t,m,C,0,1,2,A,X,a)}else X.opacity!=0&&u(t,m,C,0,1,2,A,X,a)}}else if(A instanceof THREE.RenderableFace4&&(t=A.v1,m=A.v2,C=A.v3,D=A.v4,t.positionScreen.x*=i,t.positionScreen.y*=n,m.positionScreen.x*=i,m.positionScreen.y*=n,C.positionScreen.x*=
i,C.positionScreen.y*=n,D.positionScreen.x*=i,D.positionScreen.y*=n,T.positionScreen.copy(m.positionScreen),U.positionScreen.copy(D.positionScreen),A.overdraw&&(ia(t.positionScreen,m.positionScreen),ia(m.positionScreen,D.positionScreen),ia(D.positionScreen,t.positionScreen),ia(C.positionScreen,T.positionScreen),ia(C.positionScreen,U.positionScreen)),Y.addPoint(t.positionScreen.x,t.positionScreen.y),Y.addPoint(m.positionScreen.x,m.positionScreen.y),Y.addPoint(C.positionScreen.x,C.positionScreen.y),
Y.addPoint(D.positionScreen.x,D.positionScreen.y),ka.intersects(Y))){fa=0;for(ja=A.meshMaterials.length;fa<ja;)if(X=A.meshMaterials[fa++],X instanceof THREE.MeshFaceMaterial){oa=0;for(ya=A.faceMaterials.length;oa<ya;)(X=A.faceMaterials[oa++])&&X.opacity!=0&&w(t,m,C,D,T,U,A,X,a)}else X.opacity!=0&&w(t,m,C,D,T,U,A,X,a)}$.addRectangle(Y)}j.setTransform(1,0,0,1,0,0)}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};
THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
