// ThreeExtras.js r42 - http://github.com/mrdoob/three.js
THREE.ColorUtils={adjustHSV:function(a,c,b,f){var e=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(a,e);e.h=THREE.ColorUtils.clamp(e.h+c,0,1);e.s=THREE.ColorUtils.clamp(e.s+b,0,1);e.v=THREE.ColorUtils.clamp(e.v+f,0,1);a.setHSV(e.h,e.s,e.v)},rgbToHsv:function(a,c){var b=a.r,f=a.g,e=a.b,h=Math.max(Math.max(b,f),e),g=Math.min(Math.min(b,f),e);if(g==h)g=b=0;else{var k=h-g,g=k/h,b=b==h?(f-e)/k:f==h?2+(e-b)/k:4+(b-f)/k;b/=6;b<0&&(b+=1);b>1&&(b-=1)}c===void 0&&(c={h:0,s:0,v:0});c.h=b;c.s=g;c.v=h;return c},
clamp:function(a,c,b){return a<c?c:a>b?b:a}};THREE.ColorUtils.__hsv={h:0,s:0,v:0};
var GeometryUtils={merge:function(a,c){var b=c instanceof THREE.Mesh,f=a.vertices.length,e=b?c.geometry:c,h=a.vertices,g=e.vertices,k=a.faces,j=e.faces,m=a.faceVertexUvs[0],e=e.faceVertexUvs[0];b&&c.matrixAutoUpdate&&c.updateMatrix();for(var l=0,n=g.length;l<n;l++){var o=new THREE.Vertex(g[l].position.clone());b&&c.matrix.multiplyVector3(o.position);h.push(o)}l=0;for(n=j.length;l<n;l++){var g=j[l],p,u,v=g.vertexNormals,o=g.vertexColors;g instanceof THREE.Face3?p=new THREE.Face3(g.a+f,g.b+f,g.c+f):
g instanceof THREE.Face4&&(p=new THREE.Face4(g.a+f,g.b+f,g.c+f,g.d+f));p.normal.copy(g.normal);b=0;for(h=v.length;b<h;b++)u=v[b],p.vertexNormals.push(u.clone());p.color.copy(g.color);b=0;for(h=o.length;b<h;b++)u=o[b],p.vertexColors.push(u.clone());p.materials=g.materials.slice();p.centroid.copy(g.centroid);k.push(p)}l=0;for(n=e.length;l<n;l++){f=e[l];k=[];b=0;for(h=f.length;b<h;b++)k.push(new THREE.UV(f[b].u,f[b].v));m.push(k)}}};
THREE.ImageUtils={loadTexture:function(a,c,b){var f=new Image,e=new THREE.Texture(f,c);f.onload=function(){e.needsUpdate=!0;b&&b(this)};f.src=a;return e},loadTextureCube:function(a,c,b){var f,e=[],h=new THREE.Texture(e,c),c=e.loadCount=0;for(f=a.length;c<f;++c)e[c]=new Image,e[c].onload=function(){e.loadCount+=1;if(e.loadCount==6)h.needsUpdate=!0;b&&b(this)},e[c].src=a[c];return h}};
THREE.SceneUtils={showHierarchy:function(a,c){THREE.SceneUtils.traverseHierarchy(a,function(a){a.visible=c})},traverseHierarchy:function(a,c){var b,f,e=a.children.length;for(f=0;f<e;f++)b=a.children[f],c(b),THREE.SceneUtils.traverseHierarchy(b,c)}};
if(THREE.WebGLRenderer)THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.lights,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:5,texture:null},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",
value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1}}]),fragmentShader:"uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvoid main() {\ngl_FragColor = vec4( 1.0 );\nvec4 mColor = vec4( uDiffuseColor, uOpacity );\nvec4 mSpecular = vec4( uSpecularColor, uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\nif( enableAO )\ngl_FragColor = gl_FragColor * texture2D( tAO, vUv );\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointTotal  = vec4( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + vViewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointTotal  += pointDistance * vec4( pointLightColor[ i ], 1.0 ) * ( mColor * pointDiffuseWeight + mSpecular * pointSpecularWeight * pointDiffuseWeight );\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirTotal  = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirTotal  += vec4( directionalLightColor[ i ], 1.0 ) * ( mColor * dirDiffuseWeight + mSpecular * dirSpecularWeight * dirDiffuseWeight );\n}\n#endif\nvec4 totalLight = vec4( ambientLightColor * uAmbientColor, uOpacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirTotal;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointTotal;\n#endif\ngl_FragColor = gl_FragColor * totalLight;\n}",
vertexShader:"attribute vec4 tangent;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var c,b,f,e,h=2*Math.ceil(a*3)+1;h>25&&(h=25);e=(h-1)*0.5;b=Array(h);for(c=f=0;c<h;++c)b[c]=Math.exp(-((c-e)*(c-e))/(2*a*a)),f+=b[c];for(c=0;c<h;++c)b[c]/=f;return b}};
THREE.AnimationHandler=function(){var a=[],c={},b={update:function(b){for(var c=0;c<a.length;c++)a[c].update(b)},addToUpdate:function(b){a.indexOf(b)===-1&&a.push(b)},removeFromUpdate:function(b){b=a.indexOf(b);b!==-1&&a.splice(b,1)},add:function(a){c[a.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+a.name+" already exists in library. Overwriting.");c[a.name]=a;if(a.initialized!==!0){for(var b=0;b<a.hierarchy.length;b++){for(var g=0;g<a.hierarchy[b].keys.length;g++){if(a.hierarchy[b].keys[g].time<
0)a.hierarchy[b].keys[g].time=0;if(a.hierarchy[b].keys[g].rot!==void 0&&!(a.hierarchy[b].keys[g].rot instanceof THREE.Quaternion)){var f=a.hierarchy[b].keys[g].rot;a.hierarchy[b].keys[g].rot=new THREE.Quaternion(f[0],f[1],f[2],f[3])}}if(a.hierarchy[b].keys[0].morphTargets!==void 0){f={};for(g=0;g<a.hierarchy[b].keys.length;g++)for(var j=0;j<a.hierarchy[b].keys[g].morphTargets.length;j++){var m=a.hierarchy[b].keys[g].morphTargets[j];f[m]=-1}a.hierarchy[b].usedMorphTargets=f;for(g=0;g<a.hierarchy[b].keys.length;g++){var l=
{};for(m in f){for(j=0;j<a.hierarchy[b].keys[g].morphTargets.length;j++)if(a.hierarchy[b].keys[g].morphTargets[j]===m){l[m]=a.hierarchy[b].keys[g].morphTargetsInfluences[j];break}j===a.hierarchy[b].keys[g].morphTargets.length&&(l[m]=0)}a.hierarchy[b].keys[g].morphTargetsInfluences=l}}for(g=1;g<a.hierarchy[b].keys.length;g++)a.hierarchy[b].keys[g].time===a.hierarchy[b].keys[g-1].time&&(a.hierarchy[b].keys.splice(g,1),g--);for(g=1;g<a.hierarchy[b].keys.length;g++)a.hierarchy[b].keys[g].index=g}g=parseInt(a.length*
a.fps,10);a.JIT={};a.JIT.hierarchy=[];for(b=0;b<a.hierarchy.length;b++)a.JIT.hierarchy.push(Array(g));a.initialized=!0}},get:function(a){if(typeof a==="string")return c[a]?c[a]:(console.log("THREE.AnimationHandler.get: Couldn't find animation "+a),null)},parse:function(a){var b=[];if(a instanceof THREE.SkinnedMesh)for(var c=0;c<a.bones.length;c++)b.push(a.bones[c]);else f(a,b);return b}},f=function(a,b){b.push(a);for(var c=0;c<a.children.length;c++)f(a.children[c],b)};b.LINEAR=0;b.CATMULLROM=1;b.CATMULLROM_FORWARD=
2;return b}();THREE.Animation=function(a,c,b,f){this.root=a;this.data=THREE.AnimationHandler.get(c);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=b!==void 0?b:THREE.AnimationHandler.LINEAR;this.JITCompile=f!==void 0?f:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,c){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==void 0?a:!0;this.currentTime=c!==void 0?c:0;var b,f=this.hierarchy.length,e;for(b=0;b<f;b++){e=this.hierarchy[b];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)e.useQuaternion=!0;e.matrixAutoUpdate=!0;if(e.animationCache===void 0)e.animationCache={},e.animationCache.prevKey={pos:0,rot:0,scl:0},e.animationCache.nextKey={pos:0,rot:0,scl:0},e.animationCache.originalMatrix=e instanceof
THREE.Bone?e.skinMatrix:e.matrix;var h=e.animationCache.prevKey;e=e.animationCache.nextKey;h.pos=this.data.hierarchy[b].keys[0];h.rot=this.data.hierarchy[b].keys[0];h.scl=this.data.hierarchy[b].keys[0];e.pos=this.getNextKeyWith("pos",b,1);e.rot=this.getNextKeyWith("rot",b,1);e.scl=this.getNextKeyWith("scl",b,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==void 0)this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix:this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix,delete this.hierarchy[a].animationCache};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var c=["pos","rot","scl"],b,f,e,h,g,k,j,m,l=this.data.JIT.hierarchy,n,o;this.currentTime+=a*this.timeScale;o=this.currentTime;n=this.currentTime%=this.data.length;m=parseInt(Math.min(n*this.data.fps,this.data.length*this.data.fps),10);for(var p=0,u=this.hierarchy.length;p<u;p++)if(a=this.hierarchy[p],j=a.animationCache,this.JITCompile&&l[p][m]!==void 0)a instanceof THREE.Bone?(a.skinMatrix=l[p][m],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=
!1):(a.matrix=l[p][m],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)a instanceof THREE.Bone?a.skinMatrix=a.animationCache.originalMatrix:a.matrix=a.animationCache.originalMatrix;for(var v=0;v<3;v++){b=c[v];g=j.prevKey[b];k=j.nextKey[b];if(k.time<=o){if(n<o)if(this.loop){g=this.data.hierarchy[p].keys[0];for(k=this.getNextKeyWith(b,p,1);k.time<n;)g=k,k=this.getNextKeyWith(b,p,k.index+1)}else{this.stop();return}else{do g=k,k=this.getNextKeyWith(b,p,k.index+1);while(k.time<
n)}j.prevKey[b]=g;j.nextKey[b]=k}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;f=(n-g.time)/(k.time-g.time);e=g[b];h=k[b];if(f<0||f>1)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+f+" on bone "+p),f=f<0?0:1;if(b==="pos")if(b=a.position,this.interpolationType===THREE.AnimationHandler.LINEAR)b.x=e[0]+(h[0]-e[0])*f,b.y=e[1]+(h[1]-e[1])*f,b.z=e[2]+(h[2]-e[2])*f;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",p,g.index-1).pos,this.points[1]=e,this.points[2]=h,this.points[3]=this.getNextKeyWith("pos",p,k.index+1).pos,f=f*0.33+0.33,e=this.interpolateCatmullRom(this.points,f),b.x=e[0],b.y=e[1],b.z=e[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)f=this.interpolateCatmullRom(this.points,f*1.01),this.target.set(f[0],f[1],f[2]),this.target.subSelf(b),this.target.y=0,this.target.normalize(),f=Math.atan2(this.target.x,this.target.z),a.rotation.set(0,f,0)}else if(b===
"rot")THREE.Quaternion.slerp(e,h,a.quaternion,f);else if(b==="scl")b=a.scale,b.x=e[0]+(h[0]-e[0])*f,b.y=e[1]+(h[1]-e[1])*f,b.z=e[2]+(h[2]-e[2])*f}}if(this.JITCompile&&l[0][m]===void 0){this.hierarchy[0].update(void 0,!0);for(p=0;p<this.hierarchy.length;p++)l[p][m]=this.hierarchy[p]instanceof THREE.Bone?this.hierarchy[p].skinMatrix.clone():this.hierarchy[p].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,c){var b=[],f=[],e,h,g,k,j,m;e=(a.length-1)*c;h=Math.floor(e);e-=h;b[0]=h==0?h:h-1;b[1]=h;b[2]=h>a.length-2?h:h+1;b[3]=h>a.length-3?h:h+2;h=a[b[0]];k=a[b[1]];j=a[b[2]];m=a[b[3]];b=e*e;g=e*b;f[0]=this.interpolate(h[0],k[0],j[0],m[0],e,b,g);f[1]=this.interpolate(h[1],k[1],j[1],m[1],e,b,g);f[2]=this.interpolate(h[2],k[2],j[2],m[2],e,b,g);return f};
THREE.Animation.prototype.interpolate=function(a,c,b,f,e,h,g){a=(b-a)*0.5;f=(f-c)*0.5;return(2*(c-b)+a+f)*g+(-3*(c-b)-2*a-f)*h+a*e+c};THREE.Animation.prototype.getNextKeyWith=function(a,c,b){var f=this.data.hierarchy[c].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b=b<f.length-1?b:f.length-1:b%=f.length;b<f.length;b++)if(f[b][a]!==void 0)return f[b];return this.data.hierarchy[c].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,c,b){for(var f=this.data.hierarchy[c].keys,b=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b>0?b:0:b>=0?b:b+f.length;b>=0;b--)if(f[b][a]!==void 0)return f[b];return this.data.hierarchy[c].keys[f.length-1]};
THREE.FirstPersonCamera=function(a){function c(a,c){return function(){c.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;this.lastUpdate=(new Date).getTime();this.tdiff=0;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=
a.movementSpeed;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.noFly!==void 0)this.noFly=a.noFly;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.autoForward!==void 0)this.autoForward=a.autoForward;if(a.activeLook!==void 0)this.activeLook=a.activeLook;if(a.heightSpeed!==void 0)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==void 0)this.heightCoef=a.heightCoef;if(a.heightMin!==void 0)this.heightMin=a.heightMin;if(a.heightMax!==void 0)this.heightMax=a.heightMax;if(a.constrainVertical!==
void 0)this.constrainVertical=a.constrainVertical;if(a.verticalMin!==void 0)this.verticalMin=a.verticalMin;if(a.verticalMax!==void 0)this.verticalMax=a.verticalMax;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(a){a.preventDefault();
a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(a){this.mouseX=a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.onKeyDown=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){var a=(new Date).getTime();this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;if(!this.freeze){this.autoSpeedFactor=
this.heightSpeed?this.tdiff*((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;var c=this.tdiff*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.translateZ(-(c+this.autoSpeedFactor));this.moveBackward&&this.translateZ(c);this.moveLeft&&this.translateX(-c);this.moveRight&&this.translateX(c);c=this.tdiff*this.lookSpeed;this.activeLook||(c=0);this.lon+=this.mouseX*c;this.lookVertical&&
(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var a=this.target.position,e=this.position;a.x=e.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=e.y+100*Math.cos(this.phi);a.z=e.z+100*Math.sin(this.phi)*Math.sin(this.theta)}this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=
(this.phi-0)*(this.verticalMax-this.verticalMin)/3.14+this.verticalMin;a=this.target.position;e=this.position;a.x=e.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=e.y+100*Math.cos(this.phi);a.z=e.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),
!1);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",c(this,this.onKeyUp),!1)};THREE.FirstPersonCamera.prototype=new THREE.Camera;THREE.FirstPersonCamera.prototype.constructor=THREE.FirstPersonCamera;THREE.FirstPersonCamera.prototype.supr=THREE.Camera.prototype;
THREE.FirstPersonCamera.prototype.translate=function(a,c){this.matrix.rotateAxis(c);if(this.noFly)c.y=0;this.position.addSelf(c.multiplyScalar(a));this.target.position.addSelf(c.multiplyScalar(a))};
THREE.PathCamera=function(a){function c(a,b,c,f){var g={name:c,fps:0.6,length:f,hierarchy:[]},h,e=b.getControlPointsArray(),k=b.getLength(),j=e.length,w=0;h=j-1;b={parent:-1,keys:[]};b.keys[0]={time:0,pos:e[0],rot:[0,0,0,1],scl:[1,1,1]};b.keys[h]={time:f,pos:e[h],rot:[0,0,0,1],scl:[1,1,1]};for(h=1;h<j-1;h++)w=f*k.chunks[h]/k.total,b.keys[h]={time:w,pos:e[h]};g.hierarchy[0]=b;THREE.AnimationHandler.add(g);return new THREE.Animation(a,c,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function b(a,b){var c,
f,g=new THREE.Geometry;for(c=0;c<a.points.length*b;c++)f=c/(a.points.length*b),f=a.getPoint(f),g.vertices[c]=new THREE.Vertex(new THREE.Vector3(f.x,f.y,f.z));return g}function f(a,c){var f=b(c,10),g=b(c,10),h=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(f,h);particleObj=new THREE.ParticleSystem(g,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);a.addChild(lineObj);particleObj.scale.set(1,1,1);a.addChild(particleObj);g=new THREE.SphereGeometry(1,
16,8);h=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<c.points.length;i++)f=new THREE.Mesh(g,h),f.position.copy(c.points[i]),f.updateMatrix(),a.addChild(f)}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=
this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(a){if(a.duration!==void 0)this.duration=a.duration*1E3;if(a.waypoints!==void 0)this.waypoints=a.waypoints;if(a.useConstantSpeed!==void 0)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==void 0)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==void 0)this.createDebugPath=a.createDebugPath;if(a.createDebugDummy!==
void 0)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==void 0)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==void 0)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==void 0)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=
window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var e=Math.PI*2,h=Math.PI/180;this.update=function(a,b,c){var f,g;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;f=this.phi%e;this.phi=f>=0?f:f+e;f=this.verticalAngleMap.srcRange;g=this.verticalAngleMap.dstRange;var k=g[1]-g[0];this.phi=
TWEEN.Easing.Quadratic.EaseInOut(((this.phi-f[0])*(g[1]-g[0])/(f[1]-f[0])+g[0]-g[0])/k)*k+g[0];f=this.horizontalAngleMap.srcRange;g=this.horizontalAngleMap.dstRange;k=g[1]-g[0];this.theta=TWEEN.Easing.Quadratic.EaseInOut(((this.theta-f[0])*(g[1]-g[0])/(f[1]-f[0])+g[0]-g[0])/k)*k+g[0];f=this.target.position;f.x=100*Math.sin(this.phi)*Math.cos(this.theta);f.y=100*Math.cos(this.phi);f.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,a,b,c)};this.onMouseMove=function(a){this.mouseX=
a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),g=new THREE.MeshLambertMaterial({color:65280}),k=new THREE.CubeGeometry(10,10,20),j=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(k,a);a=new THREE.Mesh(j,g);a.position.set(0,10,0);this.animation=
c(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else this.animation=c(this.animationParent,this.spline,this.id,this.duration),this.animationParent.addChild(this.target),this.animationParent.addChild(this);this.createDebugPath&&f(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(a,b){return function(){b.apply(a,arguments)}}(this,this.onMouseMove),
!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.FlyCamera=function(a){function c(a,c){return function(){c.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.tmpQuaternion=new THREE.Quaternion;this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.domElement=document;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=a.movementSpeed;if(a.rollSpeed!==void 0)this.rollSpeed=a.rollSpeed;if(a.dragToLook!==void 0)this.dragToLook=a.dragToLook;if(a.autoForward!==void 0)this.autoForward=
a.autoForward;if(a.domElement!==void 0)this.domElement=a.domElement}this.useTarget=!1;this.useQuaternion=!0;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.lastUpdate=-1;this.tdiff=0;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=
0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};
this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;
case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.mousemove=function(a){if(!this.dragToLook||this.mouseStatus>0){var c=this.getContainerDimensions(),e=c.size[0]/2,h=c.size[1]/2;this.moveState.yawLeft=-(a.clientX-c.offset[0]-e)/e;this.moveState.pitchDown=(a.clientY-
c.offset[1]-h)/h;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;var a=this.tdiff*this.movementSpeed,c=this.tdiff*
this.rollSpeed;this.translateX(this.moveVector.x*a);this.translateY(this.moveVector.y*a);this.translateZ(this.moveVector.z*a);this.tmpQuaternion.set(this.rotationVector.x*c,this.rotationVector.y*c,this.rotationVector.z*c,1).normalize();this.quaternion.multiplySelf(this.tmpQuaternion);this.matrix.setPosition(this.position);this.matrix.setRotationFromQuaternion(this.quaternion);this.matrixWorldNeedsUpdate=!0;this.supr.update.call(this)};this.updateMovementVector=function(){var a=this.moveState.forward||
this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=
document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",c(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",c(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",c(this,this.mouseup),!1);window.addEventListener("keydown",c(this,this.keydown),!1);window.addEventListener("keyup",c(this,
this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};THREE.FlyCamera.prototype=new THREE.Camera;THREE.FlyCamera.prototype.constructor=THREE.FlyCamera;THREE.FlyCamera.prototype.supr=THREE.Camera.prototype;
THREE.RollCamera=function(a,c,b,f){THREE.Camera.call(this,a,c,b,f);this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.domElement=document;this.matrixAutoUpdate=this.useTarget=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;this.lastUpdate=-1;this.delta=0;var e=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Vector3,k=new THREE.Matrix4,j=!1,m=1,l=0,n=0,o=0,p=0,u=0,v=window.innerWidth/2,x=window.innerHeight/2;this.update=
function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.delta=(a-this.lastUpdate)/1E3;this.lastUpdate=a;this.mouseLook&&(a=this.delta*this.lookSpeed,this.rotateHorizontally(a*p),this.rotateVertically(a*u));a=this.delta*this.movementSpeed;this.translateZ(a*(l>0||this.autoForward&&!(l<0)?1:l));this.translateX(a*n);this.translateY(a*o);j&&(this.roll+=this.rollSpeed*this.delta*m);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();
else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();g.copy(this.forward);h.set(0,1,0);e.cross(h,g).normalize();h.cross(g,e).normalize();this.matrix.n11=e.x;this.matrix.n12=h.x;this.matrix.n13=g.x;this.matrix.n21=e.y;this.matrix.n22=h.y;this.matrix.n23=g.y;this.matrix.n31=e.z;this.matrix.n32=h.z;this.matrix.n33=g.z;k.identity();k.n11=Math.cos(this.roll);k.n12=-Math.sin(this.roll);k.n21=Math.sin(this.roll);k.n22=Math.cos(this.roll);this.matrix.multiplySelf(k);
this.matrixWorldNeedsUpdate=!0;this.matrix.n14=this.position.x;this.matrix.n24=this.position.y;this.matrix.n34=this.position.z;this.supr.update.call(this)};this.translateX=function(a){this.position.x+=this.matrix.n11*a;this.position.y+=this.matrix.n21*a;this.position.z+=this.matrix.n31*a};this.translateY=function(a){this.position.x+=this.matrix.n12*a;this.position.y+=this.matrix.n22*a;this.position.z+=this.matrix.n32*a};this.translateZ=function(a){this.position.x-=this.matrix.n13*a;this.position.y-=
this.matrix.n23*a;this.position.z-=this.matrix.n33*a};this.rotateHorizontally=function(a){e.set(this.matrix.n11,this.matrix.n21,this.matrix.n31);e.multiplyScalar(a);this.forward.subSelf(e);this.forward.normalize()};this.rotateVertically=function(a){h.set(this.matrix.n12,this.matrix.n22,this.matrix.n32);h.multiplyScalar(a);this.forward.addSelf(h);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
function(a){p=(a.clientX-v)/window.innerWidth;u=(a.clientY-x)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:l=1;break;case 2:l=-1}},!1);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:l=0;break;case 2:l=0}},!1);this.domElement.addEventListener("keydown",function(a){switch(a.keyCode){case 38:case 87:l=1;break;case 37:case 65:n=-1;break;
case 40:case 83:l=-1;break;case 39:case 68:n=1;break;case 81:j=!0;m=1;break;case 69:j=!0;m=-1;break;case 82:o=1;break;case 70:o=-1}},!1);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:l=0;break;case 37:case 65:n=0;break;case 40:case 83:l=0;break;case 39:case 68:n=0;break;case 81:j=!1;break;case 69:j=!1;break;case 82:o=0;break;case 70:o=0}},!1)};THREE.RollCamera.prototype=new THREE.Camera;THREE.RollCamera.prototype.constructor=THREE.RollCamera;
THREE.RollCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera=function(a){function c(a,b){return function(){b.apply(a,arguments)}}a=a||{};THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.domElement=a.domElement||document;this.screen=a.screen||{width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=a.radius||(this.screen.width+this.screen.height)/4;this.rotateSpeed=a.rotateSpeed||1;this.zoomSpeed=a.zoomSpeed||1.2;this.panSpeed=a.panSpeed||0.3;this.noZoom=a.noZoom||!1;this.noPan=a.noPan||
!1;this.staticMoving=a.staticMoving||!1;this.dynamicDampingFactor=a.dynamicDampingFactor||0.2;this.minDistance=a.minDistance||0;this.maxDistance=a.maxDistance||Infinity;this.keys=a.keys||[65,83,68];this.useTarget=!0;var b=!1,f=this.STATE.NONE,e=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Vector3,k=new THREE.Vector2,j=new THREE.Vector2,m=new THREE.Vector2,l=new THREE.Vector2;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.getMouseOnScreen=function(a,b){return new THREE.Vector2((a-
this.screen.offsetLeft)/this.radius*0.5,(b-this.screen.offsetTop)/this.radius*0.5)};this.getMouseProjectionOnBall=function(a,b){var c=new THREE.Vector3((a-this.screen.width*0.5-this.screen.offsetLeft)/this.radius,(this.screen.height*0.5+this.screen.offsetTop-b)/this.radius,0),g=c.length();g>1?c.normalize():c.z=Math.sqrt(1-g*g);e=this.position.clone().subSelf(this.target.position);g=this.up.clone().setLength(c.y);g.addSelf(this.up.clone().crossSelf(e).setLength(c.x));g.addSelf(e.setLength(c.z));return g};
this.rotateCamera=function(){var a=Math.acos(h.dot(g)/h.length()/g.length());if(a){var b=(new THREE.Vector3).cross(h,g).normalize(),c=new THREE.Quaternion;a*=this.rotateSpeed;c.setFromAxisAngle(b,-a);c.multiplyVector3(e);c.multiplyVector3(this.up);c.multiplyVector3(g);this.staticMoving?h=g:(c.setFromAxisAngle(b,a*(this.dynamicDampingFactor-1)),c.multiplyVector3(h))}};this.zoomCamera=function(){var a=1+(j.y-k.y)*this.zoomSpeed;a!==1&&a>0&&(e.multiplyScalar(a),this.staticMoving?k=j:k.y+=(j.y-k.y)*this.dynamicDampingFactor)};
this.panCamera=function(){var a=l.clone().subSelf(m);if(a.lengthSq()){a.multiplyScalar(e.length()*this.panSpeed);var b=e.clone().crossSelf(this.up).setLength(a.x);b.addSelf(this.up.clone().setLength(a.y));this.position.addSelf(b);this.target.position.addSelf(b);this.staticMoving?m=l:m.addSelf(a.sub(l,m).multiplyScalar(this.dynamicDampingFactor))}};this.checkDistances=function(){if(!this.noZoom||!this.noPan)this.position.lengthSq()>this.maxDistance*this.maxDistance&&this.position.setLength(this.maxDistance),
e.lengthSq()<this.minDistance*this.minDistance&&this.position.add(this.target.position,e.setLength(this.minDistance))};this.update=function(a,b,c){e=this.position.clone().subSelf(this.target.position);this.rotateCamera();this.noZoom||this.zoomCamera();this.noPan||this.panCamera();this.position.add(this.target.position,e);this.checkDistances();this.supr.update.call(this,a,b,c)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
c(this,function(a){b&&(h=g=this.getMouseProjectionOnBall(a.clientX,a.clientY),k=j=this.getMouseOnScreen(a.clientX,a.clientY),m=l=this.getMouseOnScreen(a.clientX,a.clientY),b=!1);f!==this.STATE.NONE&&(f===this.STATE.ROTATE?g=this.getMouseProjectionOnBall(a.clientX,a.clientY):f===this.STATE.ZOOM&&!this.noZoom?j=this.getMouseOnScreen(a.clientX,a.clientY):f===this.STATE.PAN&&!this.noPan&&(l=this.getMouseOnScreen(a.clientX,a.clientY)))}),!1);this.domElement.addEventListener("mousedown",c(this,function(a){a.preventDefault();
a.stopPropagation();if(f===this.STATE.NONE)f=a.button,f===this.STATE.ROTATE?h=g=this.getMouseProjectionOnBall(a.clientX,a.clientY):f===this.STATE.ZOOM&&!this.noZoom?k=j=this.getMouseOnScreen(a.clientX,a.clientY):this.noPan||(m=l=this.getMouseOnScreen(a.clientX,a.clientY))}),!1);this.domElement.addEventListener("mouseup",c(this,function(a){a.preventDefault();a.stopPropagation();f=this.STATE.NONE}),!1);window.addEventListener("keydown",c(this,function(a){if(f===this.STATE.NONE){if(a.keyCode===this.keys[this.STATE.ROTATE])f=
this.STATE.ROTATE;else if(a.keyCode===this.keys[this.STATE.ZOOM]&&!this.noZoom)f=this.STATE.ZOOM;else if(a.keyCode===this.keys[this.STATE.PAN]&&!this.noPan)f=this.STATE.PAN;f!==this.STATE.NONE&&(b=!0)}}),!1);window.addEventListener("keyup",c(this,function(){if(f!==this.STATE.NONE)f=this.STATE.NONE}),!1)};THREE.TrackballCamera.prototype=new THREE.Camera;THREE.TrackballCamera.prototype.constructor=THREE.TrackballCamera;THREE.TrackballCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera.prototype.STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2};THREE.QuakeCamera=THREE.FirstPersonCamera;
THREE.CubeGeometry=function(a,c,b,f,e,h,g,k,j){function m(a,b,c,g,k,j,m,n){var p,o,u=f||1,v=e||1,C=k/2,J=j/2,L=l.vertices.length;if(a=="x"&&b=="y"||a=="y"&&b=="x")p="z";else if(a=="x"&&b=="z"||a=="z"&&b=="x")p="y",v=h||1;else if(a=="z"&&b=="y"||a=="y"&&b=="z")p="x",u=h||1;var H=u+1,N=v+1;k/=u;var O=j/v;for(o=0;o<N;o++)for(j=0;j<H;j++){var B=new THREE.Vector3;B[a]=(j*k-C)*c;B[b]=(o*O-J)*g;B[p]=m;l.vertices.push(new THREE.Vertex(B))}for(o=0;o<v;o++)for(j=0;j<u;j++)l.faces.push(new THREE.Face4(j+H*o+
L,j+H*(o+1)+L,j+1+H*(o+1)+L,j+1+H*o+L,null,null,n)),l.faceVertexUvs[0].push([new THREE.UV(j/u,o/v),new THREE.UV(j/u,(o+1)/v),new THREE.UV((j+1)/u,(o+1)/v),new THREE.UV((j+1)/u,o/v)])}THREE.Geometry.call(this);var l=this,n=a/2,o=c/2,p=b/2,k=k?-1:1;if(g!==void 0)if(g instanceof Array)this.materials=g;else{this.materials=[];for(var u=0;u<6;u++)this.materials.push([g])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(j!=void 0)for(var v in j)this.sides[v]!=void 0&&(this.sides[v]=
j[v]);this.sides.px&&m("z","y",1*k,-1,b,c,-n,this.materials[0]);this.sides.nx&&m("z","y",-1*k,-1,b,c,n,this.materials[1]);this.sides.py&&m("x","z",1*k,1,a,b,o,this.materials[2]);this.sides.ny&&m("x","z",1*k,-1,a,b,-o,this.materials[3]);this.sides.pz&&m("x","y",1*k,-1,a,c,p,this.materials[4]);this.sides.nz&&m("x","y",-1*k,-1,a,c,-p,this.materials[5]);(function(){for(var a=[],b=[],c=0,g=l.vertices.length;c<g;c++){for(var f=l.vertices[c],h=!1,e=0,k=a.length;e<k;e++){var j=a[e];if(f.position.x==j.position.x&&
f.position.y==j.position.y&&f.position.z==j.position.z){b[c]=e;h=!0;break}}if(!h)b[c]=a.length,a.push(new THREE.Vertex(f.position.clone()))}c=0;for(g=l.faces.length;c<g;c++)f=l.faces[c],f.a=b[f.a],f.b=b[f.b],f.c=b[f.c],f.d=b[f.d];l.vertices=a})();this.computeCentroids();this.computeFaceNormals()};THREE.CubeGeometry.prototype=new THREE.Geometry;THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(a,c,b,f,e,h){function g(a,b,c){k.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}THREE.Geometry.call(this);var k=this,j,m=Math.PI*2,l=f/2;for(j=0;j<a;j++)g(Math.sin(m*j/a)*c,Math.cos(m*j/a)*c,-l);for(j=0;j<a;j++)g(Math.sin(m*j/a)*b,Math.cos(m*j/a)*b,l);for(j=0;j<a;j++)k.faces.push(new THREE.Face4(j,j+a,a+(j+1)%a,(j+1)%a));if(b>0){g(0,0,-l-(h||0));for(j=a;j<a+a/2;j++)k.faces.push(new THREE.Face4(2*a,(2*j-2*a)%a,(2*j-2*a+1)%a,(2*j-2*a+2)%a))}if(c>0){g(0,0,l+
(e||0));for(j=a+a/2;j<2*a;j++)k.faces.push(new THREE.Face4(2*a+1,(2*j-2*a+2)%a+a,(2*j-2*a+1)%a+a,(2*j-2*a)%a+a))}j=0;for(a=this.faces.length;j<a;j++){var c=[],b=this.faces[j],e=this.vertices[b.a],h=this.vertices[b.b],l=this.vertices[b.c],n=this.vertices[b.d];c.push(new THREE.UV(0.5+Math.atan2(e.position.x,e.position.y)/m,0.5+e.position.z/f));c.push(new THREE.UV(0.5+Math.atan2(h.position.x,h.position.y)/m,0.5+h.position.z/f));c.push(new THREE.UV(0.5+Math.atan2(l.position.x,l.position.y)/m,0.5+l.position.z/
f));b instanceof THREE.Face4&&c.push(new THREE.UV(0.5+Math.atan2(n.position.x,n.position.y)/m,0.5+n.position.z/f));this.faceVertexUvs[0].push(c)}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.IcosahedronGeometry=function(a){function c(a,b,c){var g=Math.sqrt(a*a+b*b+c*c);return e.vertices.push(new THREE.Vertex(new THREE.Vector3(a/g,b/g,c/g)))-1}function b(a,b,c,g){g.faces.push(new THREE.Face3(a,b,c))}function f(a,b){var g=e.vertices[a].position,f=e.vertices[b].position;return c((g.x+f.x)/2,(g.y+f.y)/2,(g.z+f.z)/2)}var e=this,h=new THREE.Geometry,g;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;c(-1,a,0);c(1,a,0);c(-1,-a,0);c(1,-a,0);c(0,-1,a);c(0,1,a);c(0,-1,
-a);c(0,1,-a);c(a,0,-1);c(a,0,1);c(-a,0,-1);c(-a,0,1);b(0,11,5,h);b(0,5,1,h);b(0,1,7,h);b(0,7,10,h);b(0,10,11,h);b(1,5,9,h);b(5,11,4,h);b(11,10,2,h);b(10,7,6,h);b(7,1,8,h);b(3,9,4,h);b(3,4,2,h);b(3,2,6,h);b(3,6,8,h);b(3,8,9,h);b(4,9,5,h);b(2,4,11,h);b(6,2,10,h);b(8,6,7,h);b(9,8,1,h);for(a=0;a<this.subdivisions;a++){g=new THREE.Geometry;for(var k in h.faces){var j=f(h.faces[k].a,h.faces[k].b),m=f(h.faces[k].b,h.faces[k].c),l=f(h.faces[k].c,h.faces[k].a);b(h.faces[k].a,j,l,g);b(h.faces[k].b,m,j,g);
b(h.faces[k].c,l,m,g);b(j,m,l,g)}h.faces=g.faces}e.faces=h.faces;delete h;delete g;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;
THREE.LatheGeometry=function(a,c,b){THREE.Geometry.call(this);this.steps=c||12;this.angle=b||2*Math.PI;for(var c=this.angle/this.steps,b=[],f=[],e=[],h=[],g=(new THREE.Matrix4).setRotationZ(c),k=0;k<a.length;k++)this.vertices.push(new THREE.Vertex(a[k])),b[k]=a[k].clone(),f[k]=this.vertices.length-1;for(var j=0;j<=this.angle+0.001;j+=c){for(k=0;k<b.length;k++)j<this.angle?(b[k]=g.multiplyVector3(b[k].clone()),this.vertices.push(new THREE.Vertex(b[k])),e[k]=this.vertices.length-1):e=h;j==0&&(h=f);
for(k=0;k<f.length-1;k++)this.faces.push(new THREE.Face4(e[k],e[k+1],f[k+1],f[k])),this.faceVertexUvs[0].push([new THREE.UV(1-j/this.angle,k/a.length),new THREE.UV(1-j/this.angle,(k+1)/a.length),new THREE.UV(1-(j-c)/this.angle,(k+1)/a.length),new THREE.UV(1-(j-c)/this.angle,k/a.length)]);f=e;e=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(a,c,b,f){THREE.Geometry.call(this);var e,h=a/2,g=c/2,b=b||1,f=f||1,k=b+1,j=f+1;a/=b;var m=c/f;for(e=0;e<j;e++)for(c=0;c<k;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*a-h,-(e*m-g),0)));for(e=0;e<f;e++)for(c=0;c<b;c++)this.faces.push(new THREE.Face4(c+k*e,c+k*(e+1),c+1+k*(e+1),c+1+k*e)),this.faceVertexUvs[0].push([new THREE.UV(c/b,e/f),new THREE.UV(c/b,(e+1)/f),new THREE.UV((c+1)/b,(e+1)/f),new THREE.UV((c+1)/b,e/f)]);this.computeCentroids();this.computeFaceNormals()};
THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(a,c,b){THREE.Geometry.call(this);for(var a=a||50,f,e=Math.PI,h=Math.max(3,c||8),g=Math.max(2,b||6),c=[],b=0;b<g+1;b++){f=b/g;var k=a*Math.cos(f*e),j=a*Math.sin(f*e),m=[],l=0;for(f=0;f<h;f++){var n=2*f/h,o=j*Math.sin(n*e),n=j*Math.cos(n*e);(b==0||b==g)&&f>0||(l=this.vertices.push(new THREE.Vertex(new THREE.Vector3(n,k,o)))-1);m.push(l)}c.push(m)}for(var p,u,v,e=c.length,b=0;b<e;b++)if(h=c[b].length,b>0)for(f=0;f<h;f++){m=f==h-1;g=c[b][m?0:f+1];k=c[b][m?h-1:f];j=c[b-1][m?
h-1:f];m=c[b-1][m?0:f+1];o=b/(e-1);p=(b-1)/(e-1);u=(f+1)/h;var n=f/h,l=new THREE.UV(1-u,o),o=new THREE.UV(1-n,o),n=new THREE.UV(1-n,p),x=new THREE.UV(1-u,p);b<c.length-1&&(p=this.vertices[g].position.clone(),u=this.vertices[k].position.clone(),v=this.vertices[j].position.clone(),p.normalize(),u.normalize(),v.normalize(),this.faces.push(new THREE.Face3(g,k,j,[new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(u.x,u.y,u.z),new THREE.Vector3(v.x,v.y,v.z)])),this.faceVertexUvs[0].push([l,o,n]));b>1&&(p=
this.vertices[g].position.clone(),u=this.vertices[j].position.clone(),v=this.vertices[m].position.clone(),p.normalize(),u.normalize(),v.normalize(),this.faces.push(new THREE.Face3(g,j,m,[new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(u.x,u.y,u.z),new THREE.Vector3(v.x,v.y,v.z)])),this.faceVertexUvs[0].push([l,n,x]))}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};THREE.SphereGeometry.prototype=new THREE.Geometry;
THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;THREE.TextGeometry=function(a,c){THREE.Geometry.call(this);this.parameters=c||{};this.set(a)};THREE.TextGeometry.prototype=new THREE.Geometry;THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.TextGeometry.prototype.set=function(a,c){function b(a,b,c){u.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}function f(a,b,c,g){u.faces.push(new THREE.Face4(a,b,c,g))}this.text=a;var c=c||this.parameters,e=c.height!==void 0?c.height:50,h=c.curveSegments!==void 0?c.curveSegments:4,g=c.font!==void 0?c.font:"helvetiker",k=c.weight!==void 0?c.weight:"normal",j=c.style!==void 0?c.style:"normal",m=c.bezelThickness!==void 0?c.bezelThickness:10,l=c.bezelSize!==void 0?c.bezelSize:8,n=c.bezelEnabled!==
void 0?c.bezelEnabled:!1;THREE.FontUtils.size=c.size!==void 0?c.size:100;THREE.FontUtils.divisions=h;THREE.FontUtils.face=g;THREE.FontUtils.weight=k;THREE.FontUtils.style=j;THREE.FontUtils.bezelSize=l;var k=THREE.FontUtils.drawText(a),h=k.points,o=k.faces,g=k.contour,p=k.bezel,u=this;u.vertices=[];u.faces=[];for(var v,j=h.length,x=o.length,l=p.length,k=0;k<j;k++)v=h[k],b(v.x,v.y,0);for(k=0;k<j;k++)v=h[k],b(v.x,v.y,e);if(n){for(k=0;k<l;k++)v=p[k],b(v.x,v.y,m);for(k=0;k<l;k++)v=p[k],b(v.x,v.y,e-m)}for(k=
0;k<x;k++)e=o[k],u.faces.push(new THREE.Face3(e[2],e[1],e[0]));for(k=0;k<x;k++)e=o[k],u.faces.push(new THREE.Face3(e[0]+j,e[1]+j,e[2]+j));var y;if(n)for(k=p.length;--k>0;){if(y){if(y.equals(g[k])){y=null;continue}}else y=g[k];m=j*2+k;o=m-1;f(m,o,o+l,m+l);for(n=0;n<j;n++)if(h[n].equals(g[k]))break;for(e=0;e<j;e++)if(h[e].equals(g[k-1]))break;f(n,e,o,m);f(m+l,o+l,e+j,n+j)}else for(k=g.length;--k>0;){if(y){if(y.equals(g[k])){y=null;continue}}else y=g[k];for(n=0;n<j;n++)if(h[n].equals(g[k]))break;for(e=
0;e<j;e++)if(h[e].equals(g[k-1]))break;f(n,e,e+j,n+j)}this.computeCentroids();this.computeFaceNormals()};
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},loadFace:function(a){var c=a.familyName.toLowerCase();this.faces[c]=this.faces[c]||{};this.faces[c][a.cssFontWeight]=this.faces[c][a.cssFontWeight]||{};this.faces[c][a.cssFontWeight][a.cssFontStyle]=a;return this.faces[c][a.cssFontWeight][a.cssFontStyle]=a},extractPoints:function(a,c){if(a.length<3)return console.log("not valid polygon"),
{points:a,faces:[]};for(var b,f,e,h,g,k=[],j=0;j<c.length;j++){g=c[j];h=[];for(b=0;b<g.length;b++)f=g[b],h.push(f.x+","+f.y);var m;b=h.slice(1).indexOf(h[0]);var l=this.Triangulate.area(g.slice(0,b+1))<0;f=[];for(b=-1;b<h.length;){m=b+1;b=h[m];b=h.slice(m+1).indexOf(b)+m;if(b<=m)break;var n=g.slice(m,b+1);l?this.Triangulate.area(n)<0?(m>0&&k.push({shape:e,holes:f}),e=n,f=[]):f.push(n):this.Triangulate.area(n)<0?(k.push({shape:n,holes:f}),f=[]):f.push(n);b++}l&&k.push({shape:e,holes:f})}var o,p,u,
v,x,y;h=[];for(g=0;g<k.length;g++){j=k[g];e=j.shape;f=j.holes;for(m=0;m<f.length;m++){l=f[m];u=Number.POSITIVE_INFINITY;for(n=0;n<l.length;n++){x=l[n];for(b=0;b<e.length;b++)v=e[b],v=x.distanceTo(v),v<u&&(u=v,o=n,p=b)}b=p-1>=0?p-1:e.length-1;var n=o-1>=0?o-1:l.length-1,w=[];w.push(l[o]);w.push(e[p]);w.push(e[b]);u=this.Triangulate.area(w);var t=[];t.push(l[o]);t.push(l[n]);t.push(e[p]);x=this.Triangulate.area(t);v=p;y=o;p+=1;o+=-1;p<0&&(p+=e.length);p%=e.length;o<0&&(o+=l.length);o%=e.length;b=p-
1>=0?p-1:e.length-1;n=o-1>=0?o-1:l.length-1;w=[];w.push(l[o]);w.push(e[p]);w.push(e[b]);w=this.Triangulate.area(w);t=[];t.push(l[o]);t.push(l[n]);t.push(e[p]);t=this.Triangulate.area(t);u+x>w+t&&(p=v,o=y,p<0&&(p+=e.length),p%=e.length,o<0&&(o+=l.length),o%=e.length,b=p-1>=0?p-1:e.length-1,n=o-1>=0?o-1:l.length-1);u=e.slice(0,p);x=e.slice(p);v=l.slice(o);y=l.slice(0,o);h.push(l[o]);h.push(e[p]);h.push(e[b]);h.push(l[o]);h.push(l[n]);h.push(e[p]);e=u.concat(v).concat(y).concat(x)}j.shape=e}o=[];p=[];
for(g=m=0;g<k.length;g++){j=k[g];e=j.shape;o=o.concat(e);l=THREE.FontUtils.Triangulate(e,!0);for(f=0;f<l.length;f++)j=l[f],j[0]+=m,j[1]+=m,j[2]+=m;p=p.concat(l);m+=e.length}var z;for(f=0;f<h.length/3;f++){j=[];for(k=0;k<3;k++){g=!1;for(e=0;e<o.length&&!g;e++)z=f*3+k,o[e].equals(h[z])&&(j.push(e),g=!0);g||(o.push(h[z]),j.push(o.length-1),console.log("not found"))}p.push(j)}return{points:o,faces:p}},drawText:function(a){var c=[],b=[],f,e=this.getFace(),h=this.size/e.resolution,g=0;f=String(a).split("");
for(var k=f.length,a=0;a<k;a++){var j=this.extractGlyphPoints(f[a],e,h,g);g+=j.offset;c.push(j.points);b=b.concat(j.points)}a=g/2;for(f=0;f<b.length;f++)b[f].x-=a;c=this.extractPoints(b,c);c.contour=b;e=[];h=[];f=[];for(var g=[],k=new THREE.Vector2,m,a=b.length;--a>=0;){if(m){if(m.equals(b[a])){m=null;j=this.Triangulate.area(f)>0;g.push(j);h.push(k.divideScalar(f.length));f=[];k=new THREE.Vector2;continue}}else m=b[a];k.addSelf(b[a]);f.push(b[a])}a=b.length;f=0;for(var l;--a>=0;)j=b[a],k=h[f],j=j.clone().subSelf(k),
l=this.bezelSize/j.length(),g[f]?l+=1:l=1-l,l=j.multiplyScalar(l).addSelf(k),e.unshift(l),m?m.equals(b[a])&&(m=null,f++):m=b[a];c.bezel=e;return c},b2p0:function(a,c){var b=1-a;return b*b*c},b2p1:function(a,c){return 2*(1-a)*a*c},b2p2:function(a,c){return a*a*c},b2:function(a,c,b,f){return this.b2p0(a,c)+this.b2p1(a,b)+this.b2p2(a,f)},b3p0:function(a,c){var b=1-a;return b*b*b*c},b3p1:function(a,c){var b=1-a;return 3*b*b*a*c},b3p2:function(a,c){return 3*(1-a)*a*a*c},b3p3:function(a,c){return a*a*a*
c},b3:function(a,c,b,f,e){return this.b3p0(a,c)+this.b3p1(a,b)+this.b3p2(a,f)+this.b3p3(a,e)},extractGlyphPoints:function(a,c,b,f){var e=[],h,g,k,j,m,l,n,o,p,u,v=c.glyphs[a]||c.glyphs[ctxt.options.fallbackCharacter];if(v){if(v.o){c=v._cachedOutline||(v._cachedOutline=v.o.split(" "));k=c.length;for(a=0;a<k;)switch(g=c[a++],g){case "m":g=c[a++]*b+f;j=c[a++]*b;e.push(new THREE.Vector2(g,j));break;case "l":g=c[a++]*b+f;j=c[a++]*b;e.push(new THREE.Vector2(g,j));break;case "q":g=c[a++]*b+f;j=c[a++]*b;n=
c[a++]*b+f;o=c[a++]*b;if(h=e[e.length-1]){m=h.x;l=h.y;h=1;for(divisions=this.divisions;h<=divisions;h++){var x=h/divisions,y=THREE.FontUtils.b2(x,m,n,g),x=THREE.FontUtils.b2(x,l,o,j);e.push(new THREE.Vector2(y,x))}}break;case "b":if(g=c[a++]*b+f,j=c[a++]*b,n=c[a++]*b+f,o=c[a++]*-b,p=c[a++]*b+f,u=c[a++]*-b,h=e[e.length-1]){m=h.x;l=h.y;h=1;for(divisions=this.divisions;h<=divisions;h++)x=h/divisions,y=THREE.FontUtils.b3(x,m,n,p,g),x=THREE.FontUtils.b3(x,l,o,u,j),e.push(new THREE.Vector2(y,x))}}}return{offset:v.ha*
b,points:e}}}};
(function(a){var c=function(a){for(var c=a.length,e=0,h=c-1,g=0;g<c;h=g++)e+=a[h].x*a[g].y-a[g].x*a[h].y;return e*0.5};a.Triangulate=function(a,f){var e=a.length;if(e<3)return null;var h=[],g=[],k=[],j,m,l;if(c(a)>0)for(m=0;m<e;m++)g[m]=m;else for(m=0;m<e;m++)g[m]=e-1-m;var n=2*e;for(m=e-1;e>2;){if(n--<=0){console.log("Warning, unable to triangulate polygon!");if(f)return k;return h}j=m;e<=j&&(j=0);m=j+1;e<=m&&(m=0);l=m+1;e<=l&&(l=0);var o;a:{o=a;var p=j,u=m,v=l,x=e,y=g,w=void 0,t=void 0,z=void 0,
A=void 0,E=void 0,F=void 0,G=void 0,D=void 0,K=void 0,t=o[y[p]].x,z=o[y[p]].y,A=o[y[u]].x,E=o[y[u]].y,F=o[y[v]].x,G=o[y[v]].y;if(1.0E-10>(A-t)*(G-z)-(E-z)*(F-t))o=!1;else{for(w=0;w<x;w++)if(!(w==p||w==u||w==v)){var D=o[y[w]].x,K=o[y[w]].y,I=void 0,C=void 0,J=void 0,L=void 0,H=void 0,N=void 0,O=void 0,B=void 0,P=void 0,M=void 0,R=void 0,S=void 0,I=J=H=void 0,I=F-A,C=G-E,J=t-F,L=z-G,H=A-t,N=E-z,O=D-t,B=K-z,P=D-A,M=K-E,R=D-F,S=K-G,I=I*M-C*P,H=H*B-N*O,J=J*S-L*R;if(I>=0&&J>=0&&H>=0){o=!1;break a}}o=!0}}if(o){n=
g[j];o=g[m];p=g[l];h.push(a[n]);h.push(a[o]);h.push(a[p]);k.push([g[j],g[m],g[l]]);j=m;for(l=m+1;l<e;j++,l++)g[j]=g[l];e--;n=2*e}}if(f)return k;return h};a.Triangulate.area=c;return a})(THREE.FontUtils);window._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(a,c,b,f){THREE.Geometry.call(this);this.radius=a||100;this.tube=c||40;this.segmentsR=b||8;this.segmentsT=f||6;a=[];for(c=0;c<=this.segmentsR;++c)for(b=0;b<=this.segmentsT;++b){var f=b/this.segmentsT*2*Math.PI,e=c/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(e))*Math.cos(f),(this.radius+this.tube*Math.cos(e))*Math.sin(f),this.tube*Math.sin(e))));a.push([b/this.segmentsT,1-c/this.segmentsR])}for(c=1;c<=this.segmentsR;++c)for(b=
1;b<=this.segmentsT;++b){var f=(this.segmentsT+1)*c+b,e=(this.segmentsT+1)*c+b-1,h=(this.segmentsT+1)*(c-1)+b-1,g=(this.segmentsT+1)*(c-1)+b;this.faces.push(new THREE.Face4(f,e,h,g));this.faceVertexUvs[0].push([new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[h][0],a[h][1]),new THREE.UV(a[g][0],a[g][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusGeometry.prototype=new THREE.Geometry;
THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(a,c,b,f,e,h,g){function k(a,b,c,g,f,h){b=c/g*a;c=Math.cos(b);return new THREE.Vector3(f*(2+c)*0.5*Math.cos(a),f*(2+c)*Math.sin(a)*0.5,h*f*Math.sin(b)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=c||40;this.segmentsR=b||64;this.segmentsT=f||8;this.p=e||2;this.q=h||3;this.heightScale=g||1;this.grid=Array(this.segmentsR);b=new THREE.Vector3;f=new THREE.Vector3;h=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(c=0;c<
this.segmentsT;++c){var j=a/this.segmentsR*2*this.p*Math.PI,g=c/this.segmentsT*2*Math.PI,e=k(j,g,this.q,this.p,this.radius,this.heightScale),j=k(j+0.01,g,this.q,this.p,this.radius,this.heightScale);b.x=j.x-e.x;b.y=j.y-e.y;b.z=j.z-e.z;f.x=j.x+e.x;f.y=j.y+e.y;f.z=j.z+e.z;h.cross(b,f);f.cross(h,b);h.normalize();f.normalize();j=-this.tube*Math.cos(g);g=this.tube*Math.sin(g);e.x+=j*f.x+g*h.x;e.y+=j*f.y+g*h.y;e.z+=j*f.z+g*h.z;this.grid[a][c]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(e.x,e.y,
e.z)))-1}}for(a=0;a<this.segmentsR;++a)for(c=0;c<this.segmentsT;++c){var f=(a+1)%this.segmentsR,h=(c+1)%this.segmentsT,e=this.grid[a][c],b=this.grid[f][c],f=this.grid[f][h],h=this.grid[a][h],g=new THREE.UV(a/this.segmentsR,c/this.segmentsT),j=new THREE.UV((a+1)/this.segmentsR,c/this.segmentsT),m=new THREE.UV((a+1)/this.segmentsR,(c+1)/this.segmentsT),l=new THREE.UV(a/this.segmentsR,(c+1)/this.segmentsT);this.faces.push(new THREE.Face4(e,b,f,h));this.faceVertexUvs[0].push([g,j,m,l])}this.computeCentroids();
this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var c="Loaded ";c+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=c},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")},init_materials:function(a,c,b){a.materials=[];for(var f=0;f<c.length;++f)a.materials[f]=[THREE.Loader.prototype.createMaterial(c[f],b)]},hasNormals:function(a){var c,b,f=a.materials.length;for(b=0;b<f;b++)if(c=a.materials[b][0],c instanceof THREE.MeshShaderMaterial)return!0;return!1},createMaterial:function(a,c){function b(a){a=Math.log(a)/Math.LN2;return Math.floor(a)==a}function f(a,c){var g=
new Image;g.onload=function(){if(!b(this.width)||!b(this.height)){var c=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),g=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));a.image.width=c;a.image.height=g;a.image.getContext("2d").drawImage(this,0,0,c,g)}else a.image=this;a.needsUpdate=!0};g.src=c}function e(a,b,g,h,e,k){var j=document.createElement("canvas");a[b]=new THREE.Texture(j);a[b].sourceFile=g;if(h){a[b].repeat.set(h[0],h[1]);if(h[0]!=1)a[b].wrapS=THREE.RepeatWrapping;if(h[1]!=
1)a[b].wrapT=THREE.RepeatWrapping}e&&a[b].offset.set(e[0],e[1]);if(k){h={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(h[k[0]]!==void 0)a[b].wrapS=h[k[0]];if(h[k[1]]!==void 0)a[b].wrapT=h[k[1]]}f(a[b],c+"/"+g)}function h(a){return(a[0]*255<<16)+(a[1]*255<<8)+a[2]*255}var g,k,j;k="MeshLambertMaterial";g={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};a.shading&&(a.shading=="Phong"?k="MeshPhongMaterial":a.shading=="Basic"&&(k="MeshBasicMaterial"));
if(a.blending)if(a.blending=="Additive")g.blending=THREE.AdditiveBlending;else if(a.blending=="Subtractive")g.blending=THREE.SubtractiveBlending;else if(a.blending=="Multiply")g.blending=THREE.MultiplyBlending;if(a.transparent!==void 0||a.opacity<1)g.transparent=a.transparent;if(a.depthTest!==void 0)g.depthTest=a.depthTest;if(a.vertexColors!==void 0)if(a.vertexColors=="face")g.vertexColors=THREE.FaceColors;else if(a.vertexColors)g.vertexColors=THREE.VertexColors;if(a.colorDiffuse)g.color=h(a.colorDiffuse);
else if(a.DbgColor)g.color=a.DbgColor;if(a.colorSpecular)g.specular=h(a.colorSpecular);if(a.colorAmbient)g.ambient=h(a.colorAmbient);if(a.transparency)g.opacity=a.transparency;if(a.specularCoef)g.shininess=a.specularCoef;a.mapDiffuse&&c&&e(g,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&c&&e(g,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&c&&e(g,"normalMap",a.mapNormal,a.mapNormalRepeat,a.mapNormalOffset,a.mapNormalWrap);
if(a.mapNormal){var m=THREE.ShaderUtils.lib.normal,l=THREE.UniformsUtils.clone(m.uniforms),n=g.color;k=g.specular;j=g.ambient;var o=g.shininess;l.tNormal.texture=g.normalMap;if(a.mapNormalFactor)l.uNormalScale.value=a.mapNormalFactor;if(g.map)l.tDiffuse.texture=g.map,l.enableDiffuse.value=!0;l.enableAO.value=!1;l.enableSpecular.value=!1;l.uDiffuseColor.value.setHex(n);l.uSpecularColor.value.setHex(k);l.uAmbientColor.value.setHex(j);l.uShininess.value=o;if(g.opacity)l.uOpacity.value=g.opacity;g=new THREE.MeshShaderMaterial({fragmentShader:m.fragmentShader,
vertexShader:m.vertexShader,uniforms:l,lights:!0})}else g=new THREE[k](g);return g}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(a){var c=this,b=a.model,f=a.callback,e=a.texture_path?a.texture_path:this.extractUrlbase(b),a=new Worker(b);a.onmessage=function(a){c.createModel(a.data,f,e);c.onLoadComplete()};this.onLoadStart();a.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(a,c,b){var f=new THREE.Geometry,e=a.scale!==void 0?1/a.scale:1;this.init_materials(f,a.materials,b);(function(b){if(a.version===void 0||a.version!=2)console.error("Deprecated file format.");else{var c,e,j,m,l,n,o,p,u,v,x,y,w,t,z=a.faces;n=a.vertices;var A=a.normals,E=a.colors,F=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&F++;for(c=0;c<F;c++)f.faceUvs[c]=[],f.faceVertexUvs[c]=[];m=0;for(l=n.length;m<l;)o=new THREE.Vertex,o.position.x=n[m++]*b,o.position.y=
n[m++]*b,o.position.z=n[m++]*b,f.vertices.push(o);m=0;for(l=z.length;m<l;){b=z[m++];n=b&1;j=b&2;c=b&4;e=b&8;p=b&16;o=b&32;v=b&64;b&=128;n?(x=new THREE.Face4,x.a=z[m++],x.b=z[m++],x.c=z[m++],x.d=z[m++],n=4):(x=new THREE.Face3,x.a=z[m++],x.b=z[m++],x.c=z[m++],n=3);if(j)j=z[m++],x.materials=f.materials[j];j=f.faces.length;if(c)for(c=0;c<F;c++)y=a.uvs[c],u=z[m++],t=y[u*2],u=y[u*2+1],f.faceUvs[c][j]=new THREE.UV(t,u);if(e)for(c=0;c<F;c++){y=a.uvs[c];w=[];for(e=0;e<n;e++)u=z[m++],t=y[u*2],u=y[u*2+1],w[e]=
new THREE.UV(t,u);f.faceVertexUvs[c][j]=w}if(p)p=z[m++]*3,e=new THREE.Vector3,e.x=A[p++],e.y=A[p++],e.z=A[p],x.normal=e;if(o)for(c=0;c<n;c++)p=z[m++]*3,e=new THREE.Vector3,e.x=A[p++],e.y=A[p++],e.z=A[p],x.vertexNormals.push(e);if(v)o=z[m++],o=new THREE.Color(E[o]),x.color=o;if(b)for(c=0;c<n;c++)o=z[m++],o=new THREE.Color(E[o]),x.vertexColors.push(o);f.faces.push(x)}}})(e);(function(){var b,c,e,j;if(a.skinWeights){b=0;for(c=a.skinWeights.length;b<c;b+=2)e=a.skinWeights[b],j=a.skinWeights[b+1],f.skinWeights.push(new THREE.Vector4(e,
j,0,0))}if(a.skinIndices){b=0;for(c=a.skinIndices.length;b<c;b+=2)e=a.skinIndices[b],j=a.skinIndices[b+1],f.skinIndices.push(new THREE.Vector4(e,j,0,0))}f.bones=a.bones;f.animation=a.animation})();(function(b){if(a.morphTargets!==void 0){var c,e,j,m,l,n,o,p,u;c=0;for(e=a.morphTargets.length;c<e;c++){f.morphTargets[c]={};f.morphTargets[c].name=a.morphTargets[c].name;f.morphTargets[c].vertices=[];p=f.morphTargets[c].vertices;u=a.morphTargets[c].vertices;j=0;for(m=u.length;j<m;j+=3)l=u[j]*b,n=u[j+1]*
b,o=u[j+2]*b,p.push(new THREE.Vertex(new THREE.Vector3(l,n,o)))}}if(a.morphColors!==void 0){c=0;for(e=a.morphColors.length;c<e;c++){f.morphColors[c]={};f.morphColors[c].name=a.morphColors[c].name;f.morphColors[c].colors=[];m=f.morphColors[c].colors;l=a.morphColors[c].colors;b=0;for(j=l.length;b<j;b+=3)n=new THREE.Color(16755200),n.setRGB(l[b],l[b+1],l[b+2]),m.push(n)}}})(e);(function(){if(a.edges!==void 0){var b,c,e;for(b=0;b<a.edges.length;b+=2)c=a.edges[b],e=a.edges[b+1],f.edges.push(new THREE.Edge(f.vertices[c],
f.vertices[e],c,e))}})();f.computeCentroids();f.computeFaceNormals();this.hasNormals(f)&&f.computeTangents();c(f)};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(a){var c=a.model,b=a.callback,f=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(c),e=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(c),a=(new Date).getTime(),c=new Worker(c),h=this.showProgress?THREE.Loader.prototype.updateProgress:null;c.onmessage=function(a){THREE.BinaryLoader.prototype.loadAjaxBuffers(a.data.buffers,a.data.materials,b,e,f,h)};c.onerror=function(a){alert("worker.onerror: "+a.message+"\n"+a.data);a.preventDefault()};
c.postMessage(a)},loadAjaxBuffers:function(a,c,b,f,e,h){var g=new XMLHttpRequest,k=f+"/"+a,j=0;g.onreadystatechange=function(){g.readyState==4?g.status==200||g.status==0?THREE.BinaryLoader.prototype.createBinModel(g.responseText,b,e,c):alert("Couldn't load ["+k+"] ["+g.status+"]"):g.readyState==3?h&&(j==0&&(j=g.getResponseHeader("Content-Length")),h({total:j,loaded:g.responseText.length})):g.readyState==2&&(j=g.getResponseHeader("Content-Length"))};g.open("GET",k,!0);g.overrideMimeType("text/plain; charset=x-user-defined");
g.setRequestHeader("Content-Type","text/plain");g.send(null)},createBinModel:function(a,c,b,f){var e=function(b){function c(a,b){var e=l(a,b),f=l(a,b+1),g=l(a,b+2),h=l(a,b+3),j=(h<<1&255|g>>7)-127;e|=(g&127)<<16|f<<8;if(e==0&&j==-127)return 0;return(1-2*(h>>7))*(1+e*Math.pow(2,-23))*Math.pow(2,j)}function e(a,b){var c=l(a,b),f=l(a,b+1),g=l(a,b+2);return(l(a,b+3)<<24)+(g<<16)+(f<<8)+c}function j(a,b){var c=l(a,b);return(l(a,b+1)<<8)+c}function m(a,b){var c=l(a,b);return c>127?c-256:c}function l(a,
b){return a.charCodeAt(b)&255}function n(b){var c,f,g;c=e(a,b);f=e(a,b+E);g=e(a,b+F);b=j(a,b+G);THREE.BinaryLoader.prototype.f3(y,c,f,g,b)}function o(b){var c,f,g,h,m,l;c=e(a,b);f=e(a,b+E);g=e(a,b+F);h=j(a,b+G);m=e(a,b+D);l=e(a,b+K);b=e(a,b+I);THREE.BinaryLoader.prototype.f3n(y,z,c,f,g,h,m,l,b)}function p(b){var c,f,g,h;c=e(a,b);f=e(a,b+C);g=e(a,b+J);h=e(a,b+L);b=j(a,b+H);THREE.BinaryLoader.prototype.f4(y,c,f,g,h,b)}function u(b){var c,f,g,h,m,l,n,o;c=e(a,b);f=e(a,b+C);g=e(a,b+J);h=e(a,b+L);m=j(a,
b+H);l=e(a,b+N);n=e(a,b+O);o=e(a,b+B);b=e(a,b+P);THREE.BinaryLoader.prototype.f4n(y,z,c,f,g,h,m,l,n,o,b)}function v(b){var c,f;c=e(a,b);f=e(a,b+M);b=e(a,b+R);THREE.BinaryLoader.prototype.uv3(y.faceVertexUvs[0],A[c*2],A[c*2+1],A[f*2],A[f*2+1],A[b*2],A[b*2+1])}function x(b){var c,f,g;c=e(a,b);f=e(a,b+S);g=e(a,b+Y);b=e(a,b+Z);THREE.BinaryLoader.prototype.uv4(y.faceVertexUvs[0],A[c*2],A[c*2+1],A[f*2],A[f*2+1],A[g*2],A[g*2+1],A[b*2],A[b*2+1])}var y=this,w=0,t,z=[],A=[],E,F,G,D,K,I,C,J,L,H,N,O,B,P,M,R,
S,Y,Z,T,U,V,W,X,Q;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(y,f,b);t={signature:a.substr(w,8),header_bytes:l(a,w+8),vertex_coordinate_bytes:l(a,w+9),normal_coordinate_bytes:l(a,w+10),uv_coordinate_bytes:l(a,w+11),vertex_index_bytes:l(a,w+12),normal_index_bytes:l(a,w+13),uv_index_bytes:l(a,w+14),material_index_bytes:l(a,w+15),nvertices:e(a,w+16),nnormals:e(a,w+16+4),nuvs:e(a,w+16+8),ntri_flat:e(a,w+16+12),ntri_smooth:e(a,w+16+16),ntri_flat_uv:e(a,w+16+20),ntri_smooth_uv:e(a,w+
16+24),nquad_flat:e(a,w+16+28),nquad_smooth:e(a,w+16+32),nquad_flat_uv:e(a,w+16+36),nquad_smooth_uv:e(a,w+16+40)};w+=t.header_bytes;E=t.vertex_index_bytes;F=t.vertex_index_bytes*2;G=t.vertex_index_bytes*3;D=t.vertex_index_bytes*3+t.material_index_bytes;K=t.vertex_index_bytes*3+t.material_index_bytes+t.normal_index_bytes;I=t.vertex_index_bytes*3+t.material_index_bytes+t.normal_index_bytes*2;C=t.vertex_index_bytes;J=t.vertex_index_bytes*2;L=t.vertex_index_bytes*3;H=t.vertex_index_bytes*4;N=t.vertex_index_bytes*
4+t.material_index_bytes;O=t.vertex_index_bytes*4+t.material_index_bytes+t.normal_index_bytes;B=t.vertex_index_bytes*4+t.material_index_bytes+t.normal_index_bytes*2;P=t.vertex_index_bytes*4+t.material_index_bytes+t.normal_index_bytes*3;M=t.uv_index_bytes;R=t.uv_index_bytes*2;S=t.uv_index_bytes;Y=t.uv_index_bytes*2;Z=t.uv_index_bytes*3;b=t.vertex_index_bytes*3+t.material_index_bytes;Q=t.vertex_index_bytes*4+t.material_index_bytes;T=t.ntri_flat*b;U=t.ntri_smooth*(b+t.normal_index_bytes*3);V=t.ntri_flat_uv*
(b+t.uv_index_bytes*3);W=t.ntri_smooth_uv*(b+t.normal_index_bytes*3+t.uv_index_bytes*3);X=t.nquad_flat*Q;b=t.nquad_smooth*(Q+t.normal_index_bytes*4);Q=t.nquad_flat_uv*(Q+t.uv_index_bytes*4);w+=function(b){for(var f,e,h,j=t.vertex_coordinate_bytes*3,k=b+t.nvertices*j;b<k;b+=j)f=c(a,b),e=c(a,b+t.vertex_coordinate_bytes),h=c(a,b+t.vertex_coordinate_bytes*2),THREE.BinaryLoader.prototype.v(y,f,e,h);return t.nvertices*j}(w);w+=function(b){for(var c,f,e,g=t.normal_coordinate_bytes*3,h=b+t.nnormals*g;b<h;b+=
g)c=m(a,b),f=m(a,b+t.normal_coordinate_bytes),e=m(a,b+t.normal_coordinate_bytes*2),z.push(c/127,f/127,e/127);return t.nnormals*g}(w);w+=function(b){for(var f,e,h=t.uv_coordinate_bytes*2,j=b+t.nuvs*h;b<j;b+=h)f=c(a,b),e=c(a,b+t.uv_coordinate_bytes),A.push(f,e);return t.nuvs*h}(w);T=w+T;U=T+U;V=U+V;W=V+W;X=W+X;b=X+b;Q=b+Q;(function(a){var b,c=t.vertex_index_bytes*3+t.material_index_bytes,f=c+t.uv_index_bytes*3,e=a+t.ntri_flat_uv*f;for(b=a;b<e;b+=f)n(b),v(b+c);return e-a})(U);(function(a){var b,c=t.vertex_index_bytes*
3+t.material_index_bytes+t.normal_index_bytes*3,f=c+t.uv_index_bytes*3,e=a+t.ntri_smooth_uv*f;for(b=a;b<e;b+=f)o(b),v(b+c);return e-a})(V);(function(a){var b,c=t.vertex_index_bytes*4+t.material_index_bytes,f=c+t.uv_index_bytes*4,e=a+t.nquad_flat_uv*f;for(b=a;b<e;b+=f)p(b),x(b+c);return e-a})(b);(function(a){var b,c=t.vertex_index_bytes*4+t.material_index_bytes+t.normal_index_bytes*4,f=c+t.uv_index_bytes*4,e=a+t.nquad_smooth_uv*f;for(b=a;b<e;b+=f)u(b),x(b+c);return e-a})(Q);(function(a){var b,c=t.vertex_index_bytes*
3+t.material_index_bytes,f=a+t.ntri_flat*c;for(b=a;b<f;b+=c)n(b);return f-a})(w);(function(a){var b,c=t.vertex_index_bytes*3+t.material_index_bytes+t.normal_index_bytes*3,f=a+t.ntri_smooth*c;for(b=a;b<f;b+=c)o(b);return f-a})(T);(function(a){var b,c=t.vertex_index_bytes*4+t.material_index_bytes,f=a+t.nquad_flat*c;for(b=a;b<f;b+=c)p(b);return f-a})(W);(function(a){var b,c=t.vertex_index_bytes*4+t.material_index_bytes+t.normal_index_bytes*4,f=a+t.nquad_smooth*c;for(b=a;b<f;b+=c)u(b);return f-a})(X);
this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};e.prototype=new THREE.Geometry;e.prototype.constructor=e;c(new e(b))},v:function(a,c,b,f){a.vertices.push(new THREE.Vertex(new THREE.Vector3(c,b,f)))},f3:function(a,c,b,f,e){a.faces.push(new THREE.Face3(c,b,f,null,null,a.materials[e]))},f4:function(a,c,b,f,e,h){a.faces.push(new THREE.Face4(c,b,f,e,null,null,a.materials[h]))},f3n:function(a,c,b,f,e,h,g,k,j){var h=a.materials[h],m=c[k*
3],l=c[k*3+1],k=c[k*3+2],n=c[j*3],o=c[j*3+1],j=c[j*3+2];a.faces.push(new THREE.Face3(b,f,e,[new THREE.Vector3(c[g*3],c[g*3+1],c[g*3+2]),new THREE.Vector3(m,l,k),new THREE.Vector3(n,o,j)],null,h))},f4n:function(a,c,b,f,e,h,g,k,j,m,l){var g=a.materials[g],n=c[j*3],o=c[j*3+1],j=c[j*3+2],p=c[m*3],u=c[m*3+1],m=c[m*3+2],v=c[l*3],x=c[l*3+1],l=c[l*3+2];a.faces.push(new THREE.Face4(b,f,e,h,[new THREE.Vector3(c[k*3],c[k*3+1],c[k*3+2]),new THREE.Vector3(n,o,j),new THREE.Vector3(p,u,m),new THREE.Vector3(v,x,
l)],null,g))},uv3:function(a,c,b,f,e,h,g){var k=[];k.push(new THREE.UV(c,b));k.push(new THREE.UV(f,e));k.push(new THREE.UV(h,g));a.push(k)},uv4:function(a,c,b,f,e,h,g,k,j){var m=[];m.push(new THREE.UV(c,b));m.push(new THREE.UV(f,e));m.push(new THREE.UV(h,g));m.push(new THREE.UV(k,j));a.push(m)}};THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};
THREE.SceneLoader.prototype={load:function(a,c){var b=this,f=new Worker(a);f.postMessage(0);var e=THREE.Loader.prototype.extractUrlbase(a);f.onmessage=function(a){function f(a,b){return b=="relativeToHTML"?a:e+"/"+a}function k(){for(p in C.objects)if(!B.objects[p])if(w=C.objects[p],w.geometry!==void 0){if(E=B.geometries[w.geometry]){var a=!1;K=[];for(M=0;M<w.materials.length;M++)K[M]=B.materials[w.materials[M]],a=K[M]instanceof THREE.MeshShaderMaterial;a&&E.computeTangents();t=w.position;r=w.rotation;
q=w.quaternion;s=w.scale;q=0;K.length==0&&(K[0]=new THREE.MeshFaceMaterial);K.length>1&&(K=[new THREE.MeshFaceMaterial]);object=new THREE.Mesh(E,K);object.name=p;object.position.set(t[0],t[1],t[2]);q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=w.visible;B.scene.addObject(object);B.objects[p]=object;w.meshCollider&&(a=THREE.CollisionUtils.MeshColliderWBox(object),B.scene.collisions.colliders.push(a));
if(w.castsShadow)a=new THREE.ShadowVolume(E),B.scene.addChild(a),a.position=object.position,a.rotation=object.rotation,a.scale=object.scale;w.trigger&&w.trigger.toLowerCase()!="none"&&(a={type:w.trigger,object:w},B.triggers[object.name]=a)}}else t=w.position,r=w.rotation,q=w.quaternion,s=w.scale,q=0,object=new THREE.Object3D,object.name=p,object.position.set(t[0],t[1],t[2]),q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]),object.scale.set(s[0],
s[1],s[2]),object.visible=w.visible!==void 0?w.visible:!1,B.scene.addObject(object),B.objects[p]=object,B.empties[p]=object,w.trigger&&w.trigger.toLowerCase()!="none"&&(a={type:w.trigger,object:w},B.triggers[object.name]=a)}function j(a){return function(c){B.geometries[a]=c;k();L-=1;b.onLoadComplete();l()}}function m(a){return function(b){B.geometries[a]=b}}function l(){b.callbackProgress({totalModels:N,totalTextures:O,loadedModels:N-L,loadedTextures:O-H},B);b.onLoadProgress();L==0&&H==0&&c(B)}var n,
o,p,u,v,x,y,w,t,z,A,E,F,G,D,K,I,C,J,L,H,N,O,B;C=a.data;D=new THREE.BinaryLoader;J=new THREE.JSONLoader;H=L=0;B={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};a=!1;for(p in C.objects)if(w=C.objects[p],w.meshCollider){a=!0;break}if(a)B.scene.collisions=new THREE.CollisionSystem;if(C.transform){a=C.transform.position;z=C.transform.rotation;var P=C.transform.scale;a&&B.scene.position.set(a[0],a[1],a[2]);z&&B.scene.rotation.set(z[0],
z[1],z[2]);P&&B.scene.scale.set(P[0],P[1],P[2]);(a||z||P)&&B.scene.updateMatrix()}a=function(){H-=1;l();b.onLoadComplete()};for(v in C.cameras){z=C.cameras[v];if(z.type=="perspective")F=new THREE.Camera(z.fov,z.aspect,z.near,z.far);else if(z.type=="ortho")F=new THREE.Camera,F.projectionMatrix=THREE.Matrix4.makeOrtho(z.left,z.right,z.top,z.bottom,z.near,z.far);t=z.position;z=z.target;F.position.set(t[0],t[1],t[2]);F.target.position.set(z[0],z[1],z[2]);B.cameras[v]=F}for(u in C.lights)v=C.lights[u],
F=v.color!==void 0?v.color:16777215,z=v.intensity!==void 0?v.intensity:1,v.type=="directional"?(t=v.direction,I=new THREE.DirectionalLight(F,z),I.position.set(t[0],t[1],t[2]),I.position.normalize()):v.type=="point"?(t=v.position,d=v.distance,I=new THREE.PointLight(F,z,d),I.position.set(t[0],t[1],t[2])):v.type=="ambient"&&(I=new THREE.AmbientLight(F)),B.scene.addLight(I),B.lights[u]=I;for(x in C.fogs)u=C.fogs[x],u.type=="linear"?G=new THREE.Fog(0,u.near,u.far):u.type=="exp2"&&(G=new THREE.FogExp2(0,
u.density)),z=u.color,G.color.setRGB(z[0],z[1],z[2]),B.fogs[x]=G;if(B.cameras&&C.defaults.camera)B.currentCamera=B.cameras[C.defaults.camera];if(B.fogs&&C.defaults.fog)B.scene.fog=B.fogs[C.defaults.fog];z=C.defaults.bgcolor;B.bgColor=new THREE.Color;B.bgColor.setRGB(z[0],z[1],z[2]);B.bgColorAlpha=C.defaults.bgalpha;for(n in C.geometries)if(x=C.geometries[n],x.type=="bin_mesh"||x.type=="ascii_mesh")L+=1,b.onLoadStart();N=L;for(n in C.geometries)x=C.geometries[n],x.type=="cube"?(E=new THREE.CubeGeometry(x.width,
x.height,x.depth,x.segmentsWidth,x.segmentsHeight,x.segmentsDepth,null,x.flipped,x.sides),B.geometries[n]=E):x.type=="plane"?(E=new THREE.PlaneGeometry(x.width,x.height,x.segmentsWidth,x.segmentsHeight),B.geometries[n]=E):x.type=="sphere"?(E=new THREE.SphereGeometry(x.radius,x.segmentsWidth,x.segmentsHeight),B.geometries[n]=E):x.type=="cylinder"?(E=new THREE.CylinderGeometry(x.numSegs,x.topRad,x.botRad,x.height,x.topOffset,x.botOffset),B.geometries[n]=E):x.type=="torus"?(E=new THREE.TorusGeometry(x.radius,
x.tube,x.segmentsR,x.segmentsT),B.geometries[n]=E):x.type=="icosahedron"?(E=new THREE.IcosahedronGeometry(x.subdivisions),B.geometries[n]=E):x.type=="bin_mesh"?D.load({model:f(x.url,C.urlBaseType),callback:j(n)}):x.type=="ascii_mesh"?J.load({model:f(x.url,C.urlBaseType),callback:j(n)}):x.type=="embedded_mesh"&&(x=C.embeds[x.id])&&J.createModel(x,m(n),"");for(y in C.textures)if(n=C.textures[y],n.url instanceof Array){H+=n.url.length;for(D=0;D<n.url.length;D++)b.onLoadStart()}else H+=1,b.onLoadStart();
O=H;for(y in C.textures){n=C.textures[y];if(n.mapping!=void 0&&THREE[n.mapping]!=void 0)n.mapping=new THREE[n.mapping];if(n.url instanceof Array){D=[];for(var M=0;M<n.url.length;M++)D[M]=f(n.url[M],C.urlBaseType);D=THREE.ImageUtils.loadTextureCube(D,n.mapping,a)}else{D=THREE.ImageUtils.loadTexture(f(n.url,C.urlBaseType),n.mapping,a);if(THREE[n.minFilter]!=void 0)D.minFilter=THREE[n.minFilter];if(THREE[n.magFilter]!=void 0)D.magFilter=THREE[n.magFilter];if(n.repeat){D.repeat.set(n.repeat[0],n.repeat[1]);
if(n.repeat[0]!=1)D.wrapS=THREE.RepeatWrapping;if(n.repeat[1]!=1)D.wrapT=THREE.RepeatWrapping}n.offset&&D.offset.set(n.offset[0],n.offset[1]);if(n.wrap){J={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(J[n.wrap[0]]!==void 0)D.wrapS=J[n.wrap[0]];if(J[n.wrap[1]]!==void 0)D.wrapT=J[n.wrap[1]]}}B.textures[y]=D}for(o in C.materials){y=C.materials[o];for(A in y.parameters)if(A=="envMap"||A=="map"||A=="lightMap")y.parameters[A]=B.textures[y.parameters[A]];else if(A=="shading")y.parameters[A]=
y.parameters[A]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(A=="blending")y.parameters[A]=THREE[y.parameters[A]]?THREE[y.parameters[A]]:THREE.NormalBlending;else if(A=="combine")y.parameters[A]=y.parameters[A]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(A=="vertexColors")if(y.parameters[A]=="face")y.parameters[A]=THREE.FaceColors;else if(y.parameters[A])y.parameters[A]=THREE.VertexColors;if(y.parameters.opacity!==void 0&&y.parameters.opacity<1)y.parameters.transparent=
!0;if(y.parameters.normalMap){n=THREE.ShaderUtils.lib.normal;a=THREE.UniformsUtils.clone(n.uniforms);D=y.parameters.color;J=y.parameters.specular;x=y.parameters.ambient;G=y.parameters.shininess;a.tNormal.texture=B.textures[y.parameters.normalMap];if(y.parameters.normalMapFactor)a.uNormalScale.value=y.parameters.normalMapFactor;if(y.parameters.map)a.tDiffuse.texture=y.parameters.map,a.enableDiffuse.value=!0;a.enableAO.value=!1;a.enableSpecular.value=!1;a.uDiffuseColor.value.setHex(D);a.uSpecularColor.value.setHex(J);
a.uAmbientColor.value.setHex(x);a.uShininess.value=G;if(y.parameters.opacity)a.uOpacity.value=y.parameters.opacity;y=new THREE.MeshShaderMaterial({fragmentShader:n.fragmentShader,vertexShader:n.vertexShader,uniforms:a,lights:!0})}else y=new THREE[y.type](y.parameters);B.materials[o]=y}k();b.callbackSync(B)}}};
THREE.MarchingCubes=function(a,c){THREE.Object3D.call(this);this.materials=c instanceof Array?c:[c];this.init=function(a){this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasNormal=this.hasPos=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(a,c,e){return a+(c-a)*e};this.VIntX=function(a,c,e,h,g,k,j,m,l,n){g=(g-l)/(n-l);l=this.normal_cache;c[h]=k+g*this.delta;c[h+1]=j;c[h+2]=m;e[h]=this.lerp(l[a],l[a+3],g);e[h+1]=this.lerp(l[a+1],l[a+4],g);e[h+2]=this.lerp(l[a+2],l[a+5],g)};this.VIntY=function(a,c,e,h,g,k,j,m,l,n){g=(g-l)/(n-l);l=this.normal_cache;c[h]=k;c[h+1]=j+g*this.delta;c[h+
2]=m;c=a+this.yd*3;e[h]=this.lerp(l[a],l[c],g);e[h+1]=this.lerp(l[a+1],l[c+1],g);e[h+2]=this.lerp(l[a+2],l[c+2],g)};this.VIntZ=function(a,c,e,h,g,k,j,m,l,n){g=(g-l)/(n-l);l=this.normal_cache;c[h]=k;c[h+1]=j;c[h+2]=m+g*this.delta;c=a+this.zd*3;e[h]=this.lerp(l[a],l[c],g);e[h+1]=this.lerp(l[a+1],l[c+1],g);e[h+2]=this.lerp(l[a+2],l[c+2],g)};this.compNorm=function(a){var c=a*3;this.normal_cache[c]==0&&(this.normal_cache[c]=this.field[a-1]-this.field[a+1],this.normal_cache[c+1]=this.field[a-this.yd]-this.field[a+
this.yd],this.normal_cache[c+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,c,e,h,g,k){var j=h+1,m=h+this.yd,l=h+this.zd,n=j+this.yd,o=j+this.zd,p=h+this.yd+this.zd,u=j+this.yd+this.zd,v=0,x=this.field[h],y=this.field[j],w=this.field[m],t=this.field[n],z=this.field[l],A=this.field[o],E=this.field[p],F=this.field[u];x<g&&(v|=1);y<g&&(v|=2);w<g&&(v|=8);t<g&&(v|=4);z<g&&(v|=16);A<g&&(v|=32);E<g&&(v|=128);F<g&&(v|=64);var G=THREE.edgeTable[v];if(G==0)return 0;var D=this.delta,
K=a+D,I=c+D,D=e+D;G&1&&(this.compNorm(h),this.compNorm(j),this.VIntX(h*3,this.vlist,this.nlist,0,g,a,c,e,x,y));G&2&&(this.compNorm(j),this.compNorm(n),this.VIntY(j*3,this.vlist,this.nlist,3,g,K,c,e,y,t));G&4&&(this.compNorm(m),this.compNorm(n),this.VIntX(m*3,this.vlist,this.nlist,6,g,a,I,e,w,t));G&8&&(this.compNorm(h),this.compNorm(m),this.VIntY(h*3,this.vlist,this.nlist,9,g,a,c,e,x,w));G&16&&(this.compNorm(l),this.compNorm(o),this.VIntX(l*3,this.vlist,this.nlist,12,g,a,c,D,z,A));G&32&&(this.compNorm(o),
this.compNorm(u),this.VIntY(o*3,this.vlist,this.nlist,15,g,K,c,D,A,F));G&64&&(this.compNorm(p),this.compNorm(u),this.VIntX(p*3,this.vlist,this.nlist,18,g,a,I,D,E,F));G&128&&(this.compNorm(l),this.compNorm(p),this.VIntY(l*3,this.vlist,this.nlist,21,g,a,c,D,z,E));G&256&&(this.compNorm(h),this.compNorm(l),this.VIntZ(h*3,this.vlist,this.nlist,24,g,a,c,e,x,z));G&512&&(this.compNorm(j),this.compNorm(o),this.VIntZ(j*3,this.vlist,this.nlist,27,g,K,c,e,y,A));G&1024&&(this.compNorm(n),this.compNorm(u),this.VIntZ(n*
3,this.vlist,this.nlist,30,g,K,I,e,t,F));G&2048&&(this.compNorm(m),this.compNorm(p),this.VIntZ(m*3,this.vlist,this.nlist,33,g,a,I,e,w,E));v<<=4;for(g=h=0;THREE.triTable[v+g]!=-1;)a=v+g,c=a+1,e=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[c],3*THREE.triTable[e],k),g+=3,h++;return h};this.posnormtriv=function(a,c,e,h,g,k){var j=this.count*3;this.positionArray[j]=a[e];this.positionArray[j+1]=a[e+1];this.positionArray[j+2]=a[e+2];this.positionArray[j+3]=a[h];this.positionArray[j+
4]=a[h+1];this.positionArray[j+5]=a[h+2];this.positionArray[j+6]=a[g];this.positionArray[j+7]=a[g+1];this.positionArray[j+8]=a[g+2];this.normalArray[j]=c[e];this.normalArray[j+1]=c[e+1];this.normalArray[j+2]=c[e+2];this.normalArray[j+3]=c[h];this.normalArray[j+4]=c[h+1];this.normalArray[j+5]=c[h+2];this.normalArray[j+6]=c[g];this.normalArray[j+7]=c[g+1];this.normalArray[j+8]=c[g+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&k(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(this.count!=0){for(var c=this.count*3;c<this.positionArray.length;c++)this.positionArray[c]=0;a(this)}};this.addBall=function(a,c,e,h,g){var k=this.size*Math.sqrt(h/g),j=e*this.size,m=c*this.size,l=a*this.size,n=Math.floor(j-k);n<1&&(n=1);j=Math.floor(j+k);j>this.size-1&&(j=this.size-1);var o=Math.floor(m-k);o<1&&(o=1);m=Math.floor(m+k);m>this.size-1&&(m=this.size-1);var p=Math.floor(l-k);p<1&&(p=1);k=Math.floor(l+k);k>this.size-1&&(k=this.size-
1);for(var u,v,x,y,w,t;n<j;n++){l=this.size2*n;v=n/this.size-e;w=v*v;for(v=o;v<m;v++){x=l+this.size*v;u=v/this.size-c;t=u*u;for(u=p;u<k;u++)y=u/this.size-a,y=h/(1.0E-6+y*y+t+w)-g,y>0&&(this.field[x+u]+=y)}}};this.addPlaneX=function(a,c){var e,h,g,k,j,m=this.size,l=this.yd,n=this.zd,o=this.field,p=m*Math.sqrt(a/c);p>m&&(p=m);for(e=0;e<p;e++)if(h=e/m,h*=h,k=a/(1.0E-4+h)-c,k>0)for(h=0;h<m;h++){j=e+h*l;for(g=0;g<m;g++)o[n*g+j]+=k}};this.addPlaneY=function(a,c){var e,h,g,k,j,m,l=this.size,n=this.yd,o=
this.zd,p=this.field,u=l*Math.sqrt(a/c);u>l&&(u=l);for(h=0;h<u;h++)if(e=h/l,e*=e,k=a/(1.0E-4+e)-c,k>0){j=h*n;for(e=0;e<l;e++){m=j+e;for(g=0;g<l;g++)p[o*g+m]+=k}}};this.addPlaneZ=function(a,c){var e,h,g,k,j,m;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(a/c);dist>size&&(dist=size);for(g=0;g<dist;g++)if(e=g/size,e*=e,k=a/(1.0E-4+e)-c,k>0){j=zd*g;for(h=0;h<size;h++){m=j+h*yd;for(e=0;e<size;e++)field[m+e]+=k}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[a*
3]=0,this.field[a]=0};this.render=function(a){this.begin();var c,e,h,g,k,j,m,l,n,o=this.size-2;for(g=1;g<o;g++){n=this.size2*g;m=(g-this.halfsize)/this.halfsize;for(h=1;h<o;h++){l=n+this.size*h;j=(h-this.halfsize)/this.halfsize;for(e=1;e<o;e++)k=(e-this.halfsize)/this.halfsize,c=l+e,this.polygonize(k,j,m,c,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,c=new THREE.Geometry,e=[];this.render(function(h){var g,k,j,m,l,n,o,p;for(g=0;g<h.count;g++)o=g*3,l=o+1,p=o+2,k=h.positionArray[o],
j=h.positionArray[l],m=h.positionArray[p],n=new THREE.Vector3(k,j,m),k=h.normalArray[o],j=h.normalArray[l],m=h.normalArray[p],o=new THREE.Vector3(k,j,m),o.normalize(),l=new THREE.Vertex(n),c.vertices.push(l),e.push(o);nfaces=h.count/3;for(g=0;g<nfaces;g++)o=(a+g)*3,l=o+1,p=o+2,n=e[o],k=e[l],j=e[p],o=new THREE.Face3(o,l,p,[n,k,j]),c.faces.push(o);a+=nfaces;h.count=0});return c};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.Trident=function(a){function c(c){return new THREE.Mesh(new THREE.CylinderGeometry(30,0.1,a.length/20,a.length/5),new THREE.MeshBasicMaterial({color:c}))}function b(a,c){var b=new THREE.Geometry;b.vertices=[new THREE.Vertex,new THREE.Vertex(a)];return new THREE.Line(b,new THREE.LineBasicMaterial({color:c}))}THREE.Object3D.call(this);var f=Math.PI/2,e,a=a||THREE.Trident.defaultParams;if(a!==THREE.Trident.defaultParams)for(e in THREE.Trident.defaultParams)a.hasOwnProperty(e)||(a[e]=THREE.Trident.defaultParams[e]);
this.scale=new THREE.Vector3(a.scale,a.scale,a.scale);this.addChild(b(new THREE.Vector3(a.length,0,0),a.xAxisColor));this.addChild(b(new THREE.Vector3(0,a.length,0),a.yAxisColor));this.addChild(b(new THREE.Vector3(0,0,a.length),a.zAxisColor));if(a.showArrows)e=c(a.xAxisColor),e.rotation.y=-f,e.position.x=a.length,this.addChild(e),e=c(a.yAxisColor),e.rotation.x=f,e.position.y=a.length,this.addChild(e),e=c(a.zAxisColor),e.rotation.y=Math.PI,e.position.z=a.length,this.addChild(e)};
THREE.Trident.prototype=new THREE.Object3D;THREE.Trident.prototype.constructor=THREE.Trident;THREE.Trident.defaultParams={xAxisColor:16711680,yAxisColor:65280,zAxisColor:255,showArrows:!0,length:100,scale:1};THREE.PlaneCollider=function(a,c){this.point=a;this.normal=c};THREE.SphereCollider=function(a,c){this.center=a;this.radius=c;this.radiusSq=c*c};THREE.BoxCollider=function(a,c){this.min=a;this.max=c;this.dynamic=!0;this.normal=new THREE.Vector3};
THREE.MeshCollider=function(a,c){this.mesh=a;this.box=c;this.numFaces=this.mesh.geometry.faces.length;this.normal=new THREE.Vector3};THREE.CollisionSystem=function(){this.collisionNormal=new THREE.Vector3;this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;THREE.CollisionSystem.prototype.merge=function(a){this.colliders=this.colliders.concat(a.colliders);this.hits=this.hits.concat(a.hits)};
THREE.CollisionSystem.prototype.rayCastAll=function(a){a.direction.normalize();this.hits.length=0;var c,b,f,e,h=0;c=0;for(b=this.colliders.length;c<b;c++)if(e=this.colliders[c],f=this.rayCast(a,e),f<Number.MAX_VALUE)e.distance=f,f>h?this.hits.push(e):this.hits.unshift(e),h=f;return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(a){var c=this.rayCastAll(a);if(c.length==0)return null;for(var b=0;c[b]instanceof THREE.MeshCollider;){var f=this.rayMesh(a,c[b]);if(f.dist<Number.MAX_VALUE){c[b].distance=f.dist;c[b].faceIndex=f.faceIndex;break}b++}if(b>c.length)return null;return c[b]};
THREE.CollisionSystem.prototype.rayCast=function(a,c){if(c instanceof THREE.PlaneCollider)return this.rayPlane(a,c);else if(c instanceof THREE.SphereCollider)return this.raySphere(a,c);else if(c instanceof THREE.BoxCollider)return this.rayBox(a,c);else if(c instanceof THREE.MeshCollider&&c.box)return this.rayBox(a,c.box)};
THREE.CollisionSystem.prototype.rayMesh=function(a,c){for(var b=this.makeRayLocal(a,c.mesh),f=Number.MAX_VALUE,e,h=0;h<c.numFaces;h++){var g=c.mesh.geometry.faces[h],k=c.mesh.geometry.vertices[g.a].position,j=c.mesh.geometry.vertices[g.b].position,m=c.mesh.geometry.vertices[g.c].position,l=g instanceof THREE.Face4?c.mesh.geometry.vertices[g.d].position:null;g instanceof THREE.Face3?(g=this.rayTriangle(b,k,j,m,f,this.collisionNormal,c.mesh),g<f&&(f=g,e=h,c.normal.copy(this.collisionNormal),c.normal.normalize())):
g instanceof THREE.Face4&&(g=this.rayTriangle(b,k,j,l,f,this.collisionNormal,c.mesh),g<f&&(f=g,e=h,c.normal.copy(this.collisionNormal),c.normal.normalize()),g=this.rayTriangle(b,j,m,l,f,this.collisionNormal,c.mesh),g<f&&(f=g,e=h,c.normal.copy(this.collisionNormal),c.normal.normalize()))}return{dist:f,faceIndex:e}};
THREE.CollisionSystem.prototype.rayTriangle=function(a,c,b,f,e,h,g){var k=THREE.CollisionSystem.__v1,j=THREE.CollisionSystem.__v2;h.set(0,0,0);k.sub(b,c);j.sub(f,b);h.cross(k,j);k=h.dot(a.direction);if(!(k<0))if(g.doubleSided||g.flipSided)h.multiplyScalar(-1),k*=-1;else return Number.MAX_VALUE;g=h.dot(c)-h.dot(a.origin);if(!(g<=0))return Number.MAX_VALUE;if(!(g>=k*e))return Number.MAX_VALUE;g/=k;k=THREE.CollisionSystem.__v3;k.copy(a.direction);k.multiplyScalar(g);k.addSelf(a.origin);Math.abs(h.x)>
Math.abs(h.y)?Math.abs(h.x)>Math.abs(h.z)?(a=k.y-c.y,h=b.y-c.y,e=f.y-c.y,k=k.z-c.z,b=b.z-c.z,f=f.z-c.z):(a=k.x-c.x,h=b.x-c.x,e=f.x-c.x,k=k.y-c.y,b=b.y-c.y,f=f.y-c.y):Math.abs(h.y)>Math.abs(h.z)?(a=k.x-c.x,h=b.x-c.x,e=f.x-c.x,k=k.z-c.z,b=b.z-c.z,f=f.z-c.z):(a=k.x-c.x,h=b.x-c.x,e=f.x-c.x,k=k.y-c.y,b=b.y-c.y,f=f.y-c.y);c=h*f-b*e;if(c==0)return Number.MAX_VALUE;c=1/c;f=(a*f-k*e)*c;if(!(f>=0))return Number.MAX_VALUE;c*=h*k-b*a;if(!(c>=0))return Number.MAX_VALUE;if(!(1-f-c>=0))return Number.MAX_VALUE;return g};
THREE.CollisionSystem.prototype.makeRayLocal=function(a,c){var b=THREE.CollisionSystem.__m;THREE.Matrix4.makeInvert(c.matrixWorld,b);var f=THREE.CollisionSystem.__r;f.origin.copy(a.origin);f.direction.copy(a.direction);b.multiplyVector3(f.origin);b.rotateAxis(f.direction);f.direction.normalize();return f};
THREE.CollisionSystem.prototype.rayBox=function(a,c){var b;c.dynamic&&c.mesh&&c.mesh.matrixWorld?b=this.makeRayLocal(a,c.mesh):(b=THREE.CollisionSystem.__r,b.origin.copy(a.origin),b.direction.copy(a.direction));var f=0,e=0,h=0,g=0,k=0,j=0,m=!0;b.origin.x<c.min.x?(f=c.min.x-b.origin.x,f/=b.direction.x,m=!1,g=-1):b.origin.x>c.max.x&&(f=c.max.x-b.origin.x,f/=b.direction.x,m=!1,g=1);b.origin.y<c.min.y?(e=c.min.y-b.origin.y,e/=b.direction.y,m=!1,k=-1):b.origin.y>c.max.y&&(e=c.max.y-b.origin.y,e/=b.direction.y,
m=!1,k=1);b.origin.z<c.min.z?(h=c.min.z-b.origin.z,h/=b.direction.z,m=!1,j=-1):b.origin.z>c.max.z&&(h=c.max.z-b.origin.z,h/=b.direction.z,m=!1,j=1);if(m)return-1;m=0;e>f&&(m=1,f=e);h>f&&(m=2,f=h);switch(m){case 0:k=b.origin.y+b.direction.y*f;if(k<c.min.y||k>c.max.y)return Number.MAX_VALUE;b=b.origin.z+b.direction.z*f;if(b<c.min.z||b>c.max.z)return Number.MAX_VALUE;c.normal.set(g,0,0);break;case 1:g=b.origin.x+b.direction.x*f;if(g<c.min.x||g>c.max.x)return Number.MAX_VALUE;b=b.origin.z+b.direction.z*
f;if(b<c.min.z||b>c.max.z)return Number.MAX_VALUE;c.normal.set(0,k,0);break;case 2:g=b.origin.x+b.direction.x*f;if(g<c.min.x||g>c.max.x)return Number.MAX_VALUE;k=b.origin.y+b.direction.y*f;if(k<c.min.y||k>c.max.y)return Number.MAX_VALUE;c.normal.set(0,0,j)}return f};THREE.CollisionSystem.prototype.rayPlane=function(a,c){var b=a.direction.dot(c.normal),f=c.point.dot(c.normal);if(b<0)b=(f-a.origin.dot(c.normal))/b;else return Number.MAX_VALUE;return b>0?b:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(a,c){var b=c.center.clone().subSelf(a.origin);if(b.lengthSq<c.radiusSq)return-1;var f=b.dot(a.direction.clone());if(f<=0)return Number.MAX_VALUE;b=c.radiusSq-(b.lengthSq()-f*f);if(b>=0)return Math.abs(f)-Math.sqrt(b);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionSystem.__nr=new THREE.Vector3;THREE.CollisionSystem.__m=new THREE.Matrix4;
THREE.CollisionSystem.__r=new THREE.Ray;THREE.CollisionUtils={};THREE.CollisionUtils.MeshOBB=function(a){a.geometry.computeBoundingBox();var c=a.geometry.boundingBox,b=new THREE.Vector3(c.x[0],c.y[0],c.z[0]),c=new THREE.Vector3(c.x[1],c.y[1],c.z[1]),b=new THREE.BoxCollider(b,c);b.mesh=a;return b};THREE.CollisionUtils.MeshAABB=function(a){var c=THREE.CollisionUtils.MeshOBB(a);c.min.addSelf(a.position);c.max.addSelf(a.position);c.dynamic=!1;return c};
THREE.CollisionUtils.MeshColliderWBox=function(a){return new THREE.MeshCollider(a,THREE.CollisionUtils.MeshOBB(a))};
if(THREE.WebGLRenderer)THREE.AnaglyphWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);var c=this,b=this.setSize,f=this.render,e=new THREE.Camera,h=new THREE.Camera,g=new THREE.Matrix4,k=new THREE.Matrix4,j,m,l;e.useTarget=h.useTarget=!1;e.matrixAutoUpdate=h.matrixAutoUpdate=!1;var a={minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat},n=new THREE.WebGLRenderTarget(512,512,a),o=new THREE.WebGLRenderTarget(512,512,a),p=new THREE.Camera(53,1,1,1E4);p.position.z=
2;_material=new THREE.MeshShaderMaterial({uniforms:{mapLeft:{type:"t",value:0,texture:n},mapRight:{type:"t",value:1,texture:o}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D mapLeft;\nuniform sampler2D mapRight;\nvarying vec2 vUv;\nvoid main() {\nvec4 colorL, colorR;\nvec2 uv = vUv;\ncolorL = texture2D( mapLeft, uv );\ncolorR = texture2D( mapRight, uv );\ngl_FragColor = vec4( colorL.g * 0.7 + colorL.b * 0.3, colorR.g, colorR.b, colorL.a + colorR.a ) * 1.1;\n}"});
var u=new THREE.Scene;u.addObject(new THREE.Mesh(new THREE.PlaneGeometry(2,2),_material));this.setSize=function(a,e){b.call(c,a,e);n.width=a;n.height=e;o.width=a;o.height=e};this.render=function(a,b){b.update(null,!0);if(j!==b.aspect||m!==b.near||l!==b.fov){j=b.aspect;m=b.near;l=b.fov;var y=b.projectionMatrix.clone(),w=125/30*0.5,t=w*m/125,z=m*Math.tan(l*Math.PI/360),A;g.n14=w;k.n14=-w;w=-z*j+t;A=z*j+t;y.n11=2*m/(A-w);y.n13=(A+w)/(A-w);e.projectionMatrix=y.clone();w=-z*j-t;A=z*j-t;y.n11=2*m/(A-w);
y.n13=(A+w)/(A-w);h.projectionMatrix=y.clone()}e.matrix=b.matrixWorld.clone().multiplySelf(k);e.update(null,!0);e.position.copy(b.position);e.near=m;e.far=b.far;f.call(c,a,e,n,!0);h.matrix=b.matrixWorld.clone().multiplySelf(g);h.update(null,!0);h.position.copy(b.position);h.near=m;h.far=b.far;f.call(c,a,h,o,!0);f.call(c,u,p)}};
if(THREE.WebGLRenderer)THREE.CrosseyedWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoClear=!1;var c=this,b=this.setSize,f=this.render,e,h,g=new THREE.Camera,k=new THREE.Camera;c.separation=10;if(a&&a.separation!==void 0)c.separation=a.separation;(new THREE.Camera(53,window.innerWidth/2/window.innerHeight,1,1E4)).position.z=-10;this.setSize=function(a,f){b.call(c,a,f);e=a/2;h=f};this.render=function(a,b){this.clear();g.fov=b.fov;g.aspect=0.5*b.aspect;g.near=b.near;g.far=b.far;
g.updateProjectionMatrix();g.position.copy(b.position);g.target.position.copy(b.target.position);g.translateX(c.separation);k.projectionMatrix=g.projectionMatrix;k.position.copy(b.position);k.target.position.copy(b.target.position);k.translateX(-c.separation);this.setViewport(0,0,e,h);f.call(c,a,g);this.setViewport(e,0,e,h);f.call(c,a,k,!1)}};
