// ThreeSVG.js r42 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex},setHex:function(a){this.hex=~~a&16777215;this.updateRGB()},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;this.updateHex()},setHSV:function(a,b,c){var d,e,g,f,h,k;if(c==0)d=e=g=0;else switch(f=Math.floor(a*6),h=a*6-f,a=c*(1-b),k=c*(1-b*h),b=c*(1-b*(1-h)),f){case 1:d=k;e=c;g=a;break;case 2:d=a;e=c;g=b;break;case 3:d=a;e=k;g=c;break;case 4:d=b;e=a;g=c;break;case 5:d=c;e=a;g=k;break;case 6:case 0:d=c,e=b,g=a}this.setRGB(d,
e,g)},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},divideScalar:function(a){a?
(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
unit:function(){return this.normalize()},equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){return this.divide(this,a)},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*
a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*
a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};
THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){return this.set(a.x,a.y,a.z,a.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d,c=c.matrixWorld.getPosition();d=c.clone().subSelf(a).dot(b);a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),c=c.clone().subSelf(b),
e=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(e),f=c.dot(c),c=c.dot(e),e=1/(a*f-b*b),f=(f*d-b*c)*e,a=(a*c-b*d)*e;return f>0&&a>0&&f+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a);if(!d||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a);if(!d||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)))return[];var e,g,f,h,k,l,i,j,n,o,p=a.geometry,
q=p.vertices,t=[],d=0;for(e=p.faces.length;d<e;d++)if(g=p.faces[d],n=this.origin.clone(),o=this.direction.clone(),l=a.matrixWorld,f=l.multiplyVector3(q[g.a].position.clone()),h=l.multiplyVector3(q[g.b].position.clone()),k=l.multiplyVector3(q[g.c].position.clone()),l=g instanceof THREE.Face4?l.multiplyVector3(q[g.d].position.clone()):null,i=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),j=o.dot(i),a.doubleSided||(a.flipSided?j>0:j<0))if(i=i.dot((new THREE.Vector3).sub(f,n))/j,n=n.addSelf(o.multiplyScalar(i)),
g instanceof THREE.Face3)c(n,f,h,k)&&(g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},t.push(g));else if(g instanceof THREE.Face4&&(c(n,f,h,l)||c(n,h,k,l)))g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},t.push(g);return t}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;f=e-c}var b,c,d,e,g,f,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,i,j){h=!1;b=f;c=g;d=i;e=j;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,i,j,n,o){h?(h=!1,b=f<i?f<n?f:n:i<n?i:n,c=g<j?g<o?g:o:j<o?j:o,d=f>i?f>n?f:n:i>n?i:n,e=g>j?g>o?g:o:j>o?j:o):(b=f<i?f<n?f<b?f:b:n<b?n:b:i<n?i<b?i:b:n<b?n:b,c=g<j?g<o?g<c?g:c:o<c?o:c:j<o?j<c?j:c:o<c?o:c,d=f>i?f>n?f>d?f:d:n>d?n:d:i>n?i>d?i:d:n>d?n:d,e=g>j?g>o?g>e?g:e:o>e?o:e:j>o?j>e?j:e:o>e?o:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.instersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(e,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,g,f,h,k,l,i,j,n,o,p,q){this.set(a||1,b||0,c||0,d||0,e||0,g||1,f||0,h||0,k||0,l||0,i||1,j||0,n||0,o||0,p||0,q||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,g,f,h,k,l,i,j,n,o,p,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=g;this.n23=f;this.n24=h;this.n31=k;this.n32=l;this.n33=i;this.n34=j;this.n41=n;this.n42=o;this.n43=p;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__v1,
e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());e.cross(g,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*
d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,k=a.n23,l=a.n24,i=a.n31,j=a.n32,n=a.n33,o=a.n34,p=a.n41,q=a.n42,t=a.n43,u=a.n44,G=b.n11,z=b.n12,E=b.n13,r=b.n14,m=b.n21,A=b.n22,
B=b.n23,C=b.n24,v=b.n31,M=b.n32,F=b.n33,K=b.n34,x=b.n41,N=b.n42,P=b.n43,J=b.n44;this.n11=c*G+d*m+e*v+g*x;this.n12=c*z+d*A+e*M+g*N;this.n13=c*E+d*B+e*F+g*P;this.n14=c*r+d*C+e*K+g*J;this.n21=f*G+h*m+k*v+l*x;this.n22=f*z+h*A+k*M+l*N;this.n23=f*E+h*B+k*F+l*P;this.n24=f*r+h*C+k*K+l*J;this.n31=i*G+j*m+n*v+o*x;this.n32=i*z+j*A+n*M+o*N;this.n33=i*E+j*B+n*F+o*P;this.n34=i*r+j*C+n*K+o*J;this.n41=p*G+q*m+t*v+u*x;this.n42=p*z+q*A+t*M+u*N;this.n43=p*E+q*B+t*F+u*P;this.n44=p*r+q*C+t*K+u*J;return this},multiplyToArray:function(a,
b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=
a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,g=this.n22,f=this.n23,h=this.n24,k=this.n31,l=this.n32,i=this.n33,j=this.n34,n=this.n41,o=this.n42,p=this.n43,q=this.n44;return d*f*l*n-c*h*l*n-d*g*i*n+b*h*i*n+c*g*j*n-b*f*j*n-d*f*k*o+c*h*k*o+d*e*i*o-a*h*i*o-c*e*j*o+a*f*j*o+d*g*k*p-b*h*k*p-d*e*l*p+a*h*l*p+b*e*j*p-a*g*j*p-c*g*k*q+b*f*k*q+c*e*l*q-a*f*l*q-b*e*i*q+a*g*i*q},transpose:function(){var a;a=this.n21;this.n21=
this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=
this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=
this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,
b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,
b){var c=Math.cos(b),d=Math.sin(b),e=1-c,g=a.x,f=a.y,h=a.z,k=e*g,l=e*f;this.set(k*g+c,k*f-d*h,k*h+d*f,0,k*f+d*h,l*f+c,l*h-d*g,0,k*h-d*f,l*h+d*g,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);
return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,g=Math.cos(c),c=Math.sin(c),f=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var k=f*h,l=f*e,i=d*h,j=d*e;this.n11=k+j*c;this.n12=
i*c-l;this.n13=g*d;this.n21=g*e;this.n22=g*h;this.n23=-c;this.n31=l*c-i;this.n32=j+k*c;this.n33=g*f;break;case "ZXY":k=f*h;l=f*e;i=d*h;j=d*e;this.n11=k-j*c;this.n12=-g*e;this.n13=i+l*c;this.n21=l+i*c;this.n22=g*h;this.n23=j-k*c;this.n31=-g*d;this.n32=c;this.n33=g*f;break;case "ZYX":k=g*h;l=g*e;i=c*h;j=c*e;this.n11=f*h;this.n12=i*d-l;this.n13=k*d+j;this.n21=f*e;this.n22=j*d+k;this.n23=l*d-i;this.n31=-d;this.n32=c*f;this.n33=g*f;break;case "YZX":k=g*f;l=g*d;i=c*f;j=c*d;this.n11=f*h;this.n12=j-k*e;this.n13=
i*e+l;this.n21=e;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=l*e+i;this.n33=k-j*e;break;case "XZY":k=g*f;l=g*d;i=c*f;j=c*d;this.n11=f*h;this.n12=-e;this.n13=d*h;this.n21=k*e+j;this.n22=g*h;this.n23=l*e-i;this.n31=i*e-l;this.n32=c*h;this.n33=j*e+k;break;default:k=g*h,l=g*e,i=c*h,j=c*e,this.n11=f*h,this.n12=-f*e,this.n13=d,this.n21=l+i*d,this.n22=k-j*d,this.n23=-c*f,this.n31=j-k*d,this.n32=i+l*d,this.n33=g*f}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,g=b+b,
f=c+c,h=d+d,a=b*g,k=b*f;b*=h;var l=c*f;c*=h;d*=h;g*=e;f*=e;e*=h;this.n11=1-(l+d);this.n12=k-e;this.n13=b+f;this.n21=k+e;this.n22=1-(a+d);this.n23=c-g;this.n31=b-f;this.n32=c+g;this.n33=1-(a+l);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,
b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,k=a.n23,l=a.n24,i=a.n31,j=a.n32,n=a.n33,o=a.n34,p=a.n41,q=a.n42,t=a.n43,u=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=k*o*q-l*n*q+l*j*t-h*o*t-k*j*u+h*n*u;b.n12=g*n*q-e*o*q-g*j*t+d*o*t+e*j*u-d*n*u;b.n13=e*l*q-g*k*q+g*h*t-d*l*t-e*h*u+d*k*u;b.n14=g*k*j-e*l*j-g*h*n+d*l*n+e*h*o-d*k*o;b.n21=l*n*p-k*o*p-l*i*t+f*o*t+k*i*u-f*n*u;b.n22=e*o*p-g*n*p+g*i*t-c*o*t-e*i*u+c*n*u;b.n23=g*k*p-e*l*p-g*f*t+c*l*t+e*f*u-c*k*u;b.n24=
e*l*i-g*k*i+g*f*n-c*l*n-e*f*o+c*k*o;b.n31=h*o*p-l*j*p+l*i*q-f*o*q-h*i*u+f*j*u;b.n32=g*j*p-d*o*p-g*i*q+c*o*q+d*i*u-c*j*u;b.n33=e*l*p-g*h*p+g*f*q-c*l*q-d*f*u+c*h*u;b.n34=g*h*i-d*l*i-g*f*j+c*l*j+d*f*o-c*h*o;b.n41=k*j*p-h*n*p-k*i*q+f*n*q+h*i*t-f*j*t;b.n42=d*n*p-e*j*p+e*i*q-c*n*q-d*i*t+c*j*t;b.n43=e*h*p-d*k*p-e*f*q+c*k*q+d*f*t-c*h*t;b.n44=d*k*i-e*h*i+e*f*j-c*k*j-d*f*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,k=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,i=-a.n23*a.n11+a.n21*a.n13,j=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*f+a.n31*l;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*g;c[3]=a*f;c[4]=a*h;c[5]=a*k;c[6]=a*l;c[7]=a*i;c[8]=a*j;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,g){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(g+e)/(g-e);f.n34=-2*g*e/(g-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,g){var f,h,k,l;f=new THREE.Matrix4;h=b-a;k=c-d;l=g-e;f.n11=2/h;f.n12=0;f.n13=0;f.n14=-((b+a)/h);f.n21=0;f.n22=2/k;f.n23=0;f.n24=-((c+d)/k);f.n31=0;f.n32=0;f.n33=-2/l;f.n34=-((g+e)/l);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1)a.parent=void 0,this.children.splice(b,1)},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a)return e;if(b&&(e=e.getChildByName(a,b),e!==void 0))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),g=Math.cos(c),c=Math.sin(c),f=a*b,h=d*e;this.w=f*g-h*c;this.x=f*c+h*g;this.y=d*b*g+a*e*c;this.z=a*e*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*
d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},
multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,g=a.x,f=a.y,h=a.z,a=a.w;this.x=b*a+e*g+c*h-d*f;this.y=c*a+e*f+d*g-b*h;this.z=d*a+e*h+b*f-c*g;this.w=e*a-b*g-c*f-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,g=this.x,f=this.y,h=this.z,k=this.w,l=k*c+f*e-h*d,i=
k*d+h*c-g*e,j=k*e+g*d-f*c,c=-g*c-f*d-h*e;b.x=l*k+c*-g+i*-h-j*-f;b.y=i*k+c*-f+j*-g-l*-h;b.z=j*k+c*-h+l*-f-i*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;e=Math.sin((1-d)*g)/f;d=Math.sin(d*g)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,g,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),
c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,c,d,e,g,f,h=new THREE.Vector3,k=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],f=this.vertices[g.c],h.sub(f.position,c.position),k.sub(b.position,c.position),h.crossSelf(k);h.isZero()||
h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,e,g,D){h=a.vertices[b].position;k=a.vertices[c].position;l=a.vertices[d].position;i=f[e];j=f[g];n=f[D];o=k.x-h.x;p=l.x-h.x;q=k.y-h.y;t=l.y-h.y;u=k.z-h.z;G=l.z-h.z;z=j.u-i.u;E=n.u-i.u;r=j.v-i.v;m=n.v-i.v;A=1/(z*m-E*r);M.set((m*o-r*p)*
A,(m*q-r*t)*A,(m*u-r*G)*A);F.set((z*p-E*o)*A,(z*t-E*q)*A,(z*G-E*u)*A);C[b].addSelf(M);C[c].addSelf(M);C[d].addSelf(M);v[b].addSelf(F);v[c].addSelf(F);v[d].addSelf(F)}var b,c,d,e,g,f,h,k,l,i,j,n,o,p,q,t,u,G,z,E,r,m,A,B,C=[],v=[],M=new THREE.Vector3,F=new THREE.Vector3,K=new THREE.Vector3,x=new THREE.Vector3,N=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)C[b]=new THREE.Vector3,v[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],f=this.faceVertexUvs[0][b],g instanceof
THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var P=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)N.copy(g.vertexNormals[d]),e=g[P[d]],B=C[e],K.copy(B),K.subSelf(N.multiplyScalar(N.dot(B))).normalize(),x.cross(g.vertexNormals[d],B),e=x.dot(v[e]),e=e<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(K.x,K.y,K.z,e)}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===
void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,e,g,f,h={};c=0;for(d=this.faces.length;c<d;c++)f=this.faces[c],f instanceof THREE.Face3?(e=a(f.a,f.b),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.a,f.c),b(h,e,c)):f instanceof THREE.Face4&&(e=a(f.b,f.d),b(h,e,c),e=a(f.a,f.b),b(h,e,c),e=a(f.a,f.d),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.c,f.d),b(h,e,c));c=0;for(d=this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];g=f.vertexIndices[1];
f.faceIndices=h[a(e,g)].array;for(e=0;e<f.faceIndices.length;e++)g=f.faceIndices[e],f.faces.push(this.faces[g])}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,e,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==void 0?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCounter.value++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:
0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==
void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var a=k[h]=k[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,f=a.z+a.w,e=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return f>=0&&e>=0&&g>=0&&h>=0?!0:f<0&&e<0||g<0&&h<0?!1:(f<0?c=Math.max(c,f/(f-e)):e<0&&(d=Math.min(d,f/(f-e))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,e,g=[],f,h,k=[],l,i,j=[],n,o=[],p,q,t=[],u,G,z=[],E=new THREE.Vector4,r=new THREE.Vector4,
m=new THREE.Matrix4,A=new THREE.Matrix4,B=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],C=new THREE.Vector4,v=new THREE.Vector4;this.projectVector=function(a,b){m.multiply(b.projectionMatrix,b.matrixWorldInverse);m.multiplyVector3(a);return a};this.unprojectVector=function(a,b){m.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));m.multiplyVector3(a);return a};this.projectObjects=function(a,c,f){var c=[],h,l,k;e=0;l=
a.objects;a=0;for(h=l.length;a<h;a++){k=l[a];var i;if(!(i=!k.visible))if(i=k instanceof THREE.Mesh){a:{i=void 0;for(var j=k.matrixWorld,n=-k.geometry.boundingSphere.radius*Math.max(k.scale.x,Math.max(k.scale.y,k.scale.z)),o=0;o<6;o++)if(i=B[o].x*j.n14+B[o].y*j.n24+B[o].z*j.n34+B[o].w,i<=n){i=!1;break a}i=!0}i=!i}if(!i)i=g[e]=g[e]||new THREE.RenderableObject,e++,d=i,E.copy(k.position),m.multiplyVector3(E),d.object=k,d.z=E.z,c.push(d)}f&&c.sort(b);return c};this.projectScene=function(d,e,g){var x=[],
E=e.near,P=e.far,J,R,H,O,y,I,D,L,Q,s,w,U,W,X,S,V,T;G=q=n=i=0;e.matrixAutoUpdate&&e.update(void 0,!0);d.update(void 0,!1,e);m.multiply(e.projectionMatrix,e.matrixWorldInverse);B[0].set(m.n41-m.n11,m.n42-m.n12,m.n43-m.n13,m.n44-m.n14);B[1].set(m.n41+m.n11,m.n42+m.n12,m.n43+m.n13,m.n44+m.n14);B[2].set(m.n41+m.n21,m.n42+m.n22,m.n43+m.n23,m.n44+m.n24);B[3].set(m.n41-m.n21,m.n42-m.n22,m.n43-m.n23,m.n44-m.n24);B[4].set(m.n41-m.n31,m.n42-m.n32,m.n43-m.n33,m.n44-m.n34);B[5].set(m.n41+m.n31,m.n42+m.n32,m.n43+
m.n33,m.n44+m.n34);for(J=0;J<6;J++)Q=B[J],Q.divideScalar(Math.sqrt(Q.x*Q.x+Q.y*Q.y+Q.z*Q.z));Q=this.projectObjects(d,e,!0);d=0;for(J=Q.length;d<J;d++)if(s=Q[d].object,s.visible)if(w=s.matrixWorld,U=s.matrixRotationWorld,W=s.materials,X=s.overdraw,h=0,s instanceof THREE.Mesh){S=s.geometry;O=S.vertices;V=S.faces;S=S.faceVertexUvs;R=0;for(H=O.length;R<H;R++)f=a(),f.positionWorld.copy(O[R].position),w.multiplyVector3(f.positionWorld),f.positionScreen.copy(f.positionWorld),m.multiplyVector4(f.positionScreen),
f.positionScreen.x/=f.positionScreen.w,f.positionScreen.y/=f.positionScreen.w,f.visible=f.positionScreen.z>E&&f.positionScreen.z<P;O=0;for(R=V.length;O<R;O++){H=V[O];if(H instanceof THREE.Face3)if(y=k[H.a],I=k[H.b],D=k[H.c],y.visible&&I.visible&&D.visible&&(s.doubleSided||s.flipSided!=(D.positionScreen.x-y.positionScreen.x)*(I.positionScreen.y-y.positionScreen.y)-(D.positionScreen.y-y.positionScreen.y)*(I.positionScreen.x-y.positionScreen.x)<0))L=j[i]=j[i]||new THREE.RenderableFace3,i++,l=L,l.v1.copy(y),
l.v2.copy(I),l.v3.copy(D);else continue;else if(H instanceof THREE.Face4)if(y=k[H.a],I=k[H.b],D=k[H.c],L=k[H.d],y.visible&&I.visible&&D.visible&&L.visible&&(s.doubleSided||s.flipSided!=((L.positionScreen.x-y.positionScreen.x)*(I.positionScreen.y-y.positionScreen.y)-(L.positionScreen.y-y.positionScreen.y)*(I.positionScreen.x-y.positionScreen.x)<0||(I.positionScreen.x-D.positionScreen.x)*(L.positionScreen.y-D.positionScreen.y)-(I.positionScreen.y-D.positionScreen.y)*(L.positionScreen.x-D.positionScreen.x)<
0)))T=o[n]=o[n]||new THREE.RenderableFace4,n++,l=T,l.v1.copy(y),l.v2.copy(I),l.v3.copy(D),l.v4.copy(L);else continue;l.normalWorld.copy(H.normal);U.multiplyVector3(l.normalWorld);l.centroidWorld.copy(H.centroid);w.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);m.multiplyVector3(l.centroidScreen);D=H.vertexNormals;y=0;for(I=D.length;y<I;y++)L=l.vertexNormalsWorld[y],L.copy(D[y]),U.multiplyVector3(L);y=0;for(I=S.length;y<I;y++)if(T=S[y][O]){D=0;for(L=T.length;D<L;D++)l.uvs[y][D]=
T[D]}l.meshMaterials=W;l.faceMaterials=H.materials;l.overdraw=X;l.z=l.centroidScreen.z;x.push(l)}}else if(s instanceof THREE.Line){A.multiply(m,w);O=s.geometry.vertices;y=a();y.positionScreen.copy(O[0].position);A.multiplyVector4(y.positionScreen);R=1;for(H=O.length;R<H;R++)if(y=a(),y.positionScreen.copy(O[R].position),A.multiplyVector4(y.positionScreen),I=k[h-2],C.copy(y.positionScreen),v.copy(I.positionScreen),c(C,v))C.multiplyScalar(1/C.w),v.multiplyScalar(1/v.w),w=t[q]=t[q]||new THREE.RenderableLine,
q++,p=w,p.v1.positionScreen.copy(C),p.v2.positionScreen.copy(v),p.z=Math.max(C.z,v.z),p.materials=s.materials,x.push(p)}else if(s instanceof THREE.Particle&&(r.set(s.matrixWorld.n14,s.matrixWorld.n24,s.matrixWorld.n34,1),m.multiplyVector4(r),r.z/=r.w,r.z>0&&r.z<1))w=z[G]=z[G]||new THREE.RenderableParticle,G++,u=w,u.x=r.x/r.w,u.y=r.y/r.w,u.z=r.z,u.rotation=s.rotation.z,u.scale.x=s.scale.x*Math.abs(u.x-(r.x+e.projectionMatrix.n11)/(r.w+e.projectionMatrix.n14)),u.scale.y=s.scale.y*Math.abs(u.y-(r.y+
e.projectionMatrix.n22)/(r.w+e.projectionMatrix.n24)),u.materials=s.materials,x.push(u);g&&x.sort(b);return x}};
THREE.SVGRenderer=function(){function a(a,b,c){var d,e,f,g;d=0;for(e=a.lights.length;d<e;d++)f=a.lights[d],f instanceof THREE.DirectionalLight?(g=b.normalWorld.dot(f.position)*f.intensity,g>0&&(c.r+=f.color.r*g,c.g+=f.color.g*g,c.b+=f.color.b*g)):f instanceof THREE.PointLight&&(M.sub(f.position,b.centroidWorld),M.normalize(),g=b.normalWorld.dot(M)*f.intensity,g>0&&(c.r+=f.color.r*g,c.g+=f.color.g*g,c.b+=f.color.b*g))}function b(b,c,h,k,i,j){f.data.vertices+=3;f.data.faces++;x=d(N++);x.setAttribute("d",
"M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+h.positionScreen.x+","+h.positionScreen.y+"z");i instanceof THREE.MeshBasicMaterial?r.hex=i.color.hex:i instanceof THREE.MeshLambertMaterial?E?(m.r=A.r,m.g=A.g,m.b=A.b,a(j,k,m),r.r=Math.max(0,Math.min(i.color.r*m.r,1)),r.g=Math.max(0,Math.min(i.color.g*m.g,1)),r.b=Math.max(0,Math.min(i.color.b*m.b,1)),r.updateHex()):r.hex=i.color.hex:i instanceof THREE.MeshDepthMaterial?(v=1-i.__2near/(i.__farPlusNear-
k.z*i.__farMinusNear),r.setRGB(v,v,v)):i instanceof THREE.MeshNormalMaterial&&r.setRGB(e(k.normalWorld.x),e(k.normalWorld.y),e(k.normalWorld.z));i.wireframe?x.setAttribute("style","fill: none; stroke: #"+g(r.hex.toString(16))+"; stroke-width: "+i.wireframeLinewidth+"; stroke-opacity: "+i.opacity+"; stroke-linecap: "+i.wireframeLinecap+"; stroke-linejoin: "+i.wireframeLinejoin):x.setAttribute("style","fill: #"+g(r.hex.toString(16))+"; fill-opacity: "+i.opacity);l.appendChild(x)}function c(b,c,h,i,
k,j,n){f.data.vertices+=4;f.data.faces++;x=d(N++);x.setAttribute("d","M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+h.positionScreen.x+","+h.positionScreen.y+" L "+i.positionScreen.x+","+i.positionScreen.y+"z");j instanceof THREE.MeshBasicMaterial?r.hex=j.color.hex:j instanceof THREE.MeshLambertMaterial?E?(m.r=A.r,m.g=A.g,m.b=A.b,a(n,k,m),r.r=Math.max(0,Math.min(j.color.r*m.r,1)),r.g=Math.max(0,Math.min(j.color.g*m.g,1)),r.b=Math.max(0,Math.min(j.color.b*
m.b,1)),r.updateHex()):r.hex=j.color.hex:j instanceof THREE.MeshDepthMaterial?(v=1-j.__2near/(j.__farPlusNear-k.z*j.__farMinusNear),r.setRGB(v,v,v)):j instanceof THREE.MeshNormalMaterial&&r.setRGB(e(k.normalWorld.x),e(k.normalWorld.y),e(k.normalWorld.z));j.wireframe?x.setAttribute("style","fill: none; stroke: #"+g(r.hex.toString(16))+"; stroke-width: "+j.wireframeLinewidth+"; stroke-opacity: "+j.opacity+"; stroke-linecap: "+j.wireframeLinecap+"; stroke-linejoin: "+j.wireframeLinejoin):x.setAttribute("style",
"fill: #"+g(r.hex.toString(16))+"; fill-opacity: "+j.opacity);l.appendChild(x)}function d(a){F[a]==null&&(F[a]=document.createElementNS("http://www.w3.org/2000/svg","path"),J==0&&F[a].setAttribute("shape-rendering","crispEdges"));return F[a]}function e(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function g(a){for(;a.length<6;)a="0"+a;return a}var f=this,h=null,k=new THREE.Projector,l=document.createElementNS("http://www.w3.org/2000/svg","svg"),i,j,n,o,p,q,t,u,G=new THREE.Rectangle,z=new THREE.Rectangle,E=
!1,r=new THREE.Color(16777215),m=new THREE.Color(16777215),A=new THREE.Color(0),B=new THREE.Color(0),C=new THREE.Color(0),v,M=new THREE.Vector3,F=[],K=[],x,N,P,J=1;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setQuality=function(a){switch(a){case "high":J=1;break;case "low":J=0}};this.setSize=function(a,b){i=a;j=b;n=i/2;o=j/2;l.setAttribute("viewBox",-n+" "+-o+" "+i+" "+j);l.setAttribute("width",i);l.setAttribute("height",j);G.set(-n,-o,
n,o)};this.clear=function(){for(;l.childNodes.length>0;)l.removeChild(l.childNodes[0])};this.render=function(a,d){var e,i,j,m,r,v,s,w;this.autoClear&&this.clear();f.data.vertices=0;f.data.faces=0;h=k.projectScene(a,d,this.sortElements);P=N=0;if(E=a.lights.length>0){s=a.lights;A.setRGB(0,0,0);B.setRGB(0,0,0);C.setRGB(0,0,0);e=0;for(i=s.length;e<i;e++)j=s[e],m=j.color,j instanceof THREE.AmbientLight?(A.r+=m.r,A.g+=m.g,A.b+=m.b):j instanceof THREE.DirectionalLight?(B.r+=m.r,B.g+=m.g,B.b+=m.b):j instanceof
THREE.PointLight&&(C.r+=m.r,C.g+=m.g,C.b+=m.b)}e=0;for(i=h.length;e<i;e++)if(s=h[e],z.empty(),s instanceof THREE.RenderableParticle){p=s;p.x*=n;p.y*=-o;j=0;for(m=s.materials.length;j<m;)j++}else if(s instanceof THREE.RenderableLine){if(p=s.v1,q=s.v2,p.positionScreen.x*=n,p.positionScreen.y*=-o,q.positionScreen.x*=n,q.positionScreen.y*=-o,z.addPoint(p.positionScreen.x,p.positionScreen.y),z.addPoint(q.positionScreen.x,q.positionScreen.y),G.instersects(z)){j=0;for(m=s.materials.length;j<m;)if((w=s.materials[j++])&&
w.opacity!=0){r=p;v=q;var F=P++;K[F]==null&&(K[F]=document.createElementNS("http://www.w3.org/2000/svg","line"),J==0&&K[F].setAttribute("shape-rendering","crispEdges"));x=K[F];x.setAttribute("x1",r.positionScreen.x);x.setAttribute("y1",r.positionScreen.y);x.setAttribute("x2",v.positionScreen.x);x.setAttribute("y2",v.positionScreen.y);w instanceof THREE.LineBasicMaterial&&(x.setAttribute("style","fill: none; stroke: ##"+g(w.color.hex.toString(16))+"; stroke-width: "+w.linewidth+"; stroke-opacity: "+
w.opacity+"; stroke-linecap: "+w.linecap+"; stroke-linejoin: "+w.linejoin),l.appendChild(x))}}}else if(s instanceof THREE.RenderableFace3){if(p=s.v1,q=s.v2,t=s.v3,p.positionScreen.x*=n,p.positionScreen.y*=-o,q.positionScreen.x*=n,q.positionScreen.y*=-o,t.positionScreen.x*=n,t.positionScreen.y*=-o,z.addPoint(p.positionScreen.x,p.positionScreen.y),z.addPoint(q.positionScreen.x,q.positionScreen.y),z.addPoint(t.positionScreen.x,t.positionScreen.y),G.instersects(z)){j=0;for(m=s.meshMaterials.length;j<
m;)if(w=s.meshMaterials[j++],w instanceof THREE.MeshFaceMaterial){r=0;for(v=s.faceMaterials.length;r<v;)(w=s.faceMaterials[r++])&&w.opacity!=0&&b(p,q,t,s,w,a)}else w&&w.opacity!=0&&b(p,q,t,s,w,a)}}else if(s instanceof THREE.RenderableFace4&&(p=s.v1,q=s.v2,t=s.v3,u=s.v4,p.positionScreen.x*=n,p.positionScreen.y*=-o,q.positionScreen.x*=n,q.positionScreen.y*=-o,t.positionScreen.x*=n,t.positionScreen.y*=-o,u.positionScreen.x*=n,u.positionScreen.y*=-o,z.addPoint(p.positionScreen.x,p.positionScreen.y),z.addPoint(q.positionScreen.x,
q.positionScreen.y),z.addPoint(t.positionScreen.x,t.positionScreen.y),z.addPoint(u.positionScreen.x,u.positionScreen.y),G.instersects(z))){j=0;for(m=s.meshMaterials.length;j<m;)if(w=s.meshMaterials[j++],w instanceof THREE.MeshFaceMaterial){r=0;for(v=s.faceMaterials.length;r<v;)(w=s.faceMaterials[r++])&&w.opacity!=0&&c(p,q,t,u,s,w,a)}else w&&w.opacity!=0&&c(p,q,t,u,s,w,a)}}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};
THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
