// ThreeExtras.js r40 - http://github.com/mrdoob/three.js
THREE.AnimationHandler=function(){var a=[],d={},b={};b.update=function(c){for(var f=0;f<a.length;f++)a[f].update(c)};b.addToUpdate=function(c){a.indexOf(c)===-1&&a.push(c)};b.removeFromUpdate=function(c){c=a.indexOf(c);c!==-1&&a.splice(c,1)};b.add=function(c){d[c.name]!==undefined&&console.log("THREE.AnimationHandler.add: Warning! "+c.name+" already exists in library. Overwriting.");d[c.name]=c;if(c.initialized!==!0){for(var f=0;f<c.hierarchy.length;f++){for(var g=0;g<c.hierarchy[f].keys.length;g++){if(c.hierarchy[f].keys[g].time<
0)c.hierarchy[f].keys[g].time=0;if(c.hierarchy[f].keys[g].rot!==undefined&&!(c.hierarchy[f].keys[g].rot instanceof THREE.Quaternion)){var h=c.hierarchy[f].keys[g].rot;c.hierarchy[f].keys[g].rot=new THREE.Quaternion(h[0],h[1],h[2],h[3])}}if(c.hierarchy[f].keys[0].morphTargets!==undefined){h={};for(g=0;g<c.hierarchy[f].keys.length;g++)for(var j=0;j<c.hierarchy[f].keys[g].morphTargets.length;j++){var l=c.hierarchy[f].keys[g].morphTargets[j];h[l]=-1}c.hierarchy[f].usedMorphTargets=h;for(g=0;g<c.hierarchy[f].keys.length;g++){var k=
{};for(l in h){for(j=0;j<c.hierarchy[f].keys[g].morphTargets.length;j++)if(c.hierarchy[f].keys[g].morphTargets[j]===l){k[l]=c.hierarchy[f].keys[g].morphTargetsInfluences[j];break}j===c.hierarchy[f].keys[g].morphTargets.length&&(k[l]=0)}c.hierarchy[f].keys[g].morphTargetsInfluences=k}}for(g=1;g<c.hierarchy[f].keys.length;g++)if(c.hierarchy[f].keys[g].time===c.hierarchy[f].keys[g-1].time){c.hierarchy[f].keys.splice(g,1);g--}for(g=1;g<c.hierarchy[f].keys.length;g++)c.hierarchy[f].keys[g].index=g}g=parseInt(c.length*
c.fps,10);c.JIT={};c.JIT.hierarchy=[];for(f=0;f<c.hierarchy.length;f++)c.JIT.hierarchy.push(Array(g));c.initialized=!0}};b.get=function(c){if(typeof c==="string")if(d[c])return d[c];else{console.log("THREE.AnimationHandler.get: Couldn't find animation "+c);return null}};b.parse=function(c){var f=[];if(c instanceof THREE.SkinnedMesh)for(var g=0;g<c.bones.length;g++)f.push(c.bones[g]);else e(c,f);return f};var e=function(c,f){f.push(c);for(var g=0;g<c.children.length;g++)e(c.children[g],f)};b.LINEAR=
0;b.CATMULLROM=1;b.CATMULLROM_FORWARD=2;return b}();THREE.Animation=function(a,d,b,e){this.root=a;this.data=THREE.AnimationHandler.get(d);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.isPaused=!0;this.loop=!0;this.interpolationType=b!==undefined?b:THREE.AnimationHandler.LINEAR;this.JITCompile=e!==undefined?e:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,d){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==undefined?a:!0;this.currentTime=d!==undefined?d:0;var b,e=this.hierarchy.length,c;for(b=0;b<e;b++){c=this.hierarchy[b];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)c.useQuaternion=!0;c.matrixAutoUpdate=!0;if(c.animationCache===undefined){c.animationCache={};c.animationCache.prevKey={pos:0,rot:0,scl:0};c.animationCache.nextKey={pos:0,rot:0,scl:0};c.animationCache.originalMatrix=
c instanceof THREE.Bone?c.skinMatrix:c.matrix}var f=c.animationCache.prevKey;c=c.animationCache.nextKey;f.pos=this.data.hierarchy[b].keys[0];f.rot=this.data.hierarchy[b].keys[0];f.scl=this.data.hierarchy[b].keys[0];c.pos=this.getNextKeyWith("pos",b,1);c.rot=this.getNextKeyWith("rot",b,1);c.scl=this.getNextKeyWith("scl",b,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPlaying=!1;this.isPaused=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==undefined){if(this.hierarchy[a]instanceof THREE.Bone)this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix;else this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix;delete this.hierarchy[a].animationCache}};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var d=["pos","rot","scl"],b,e,c,f,g,h,j,l,k=this.data.JIT.hierarchy,m,p;this.currentTime+=a*this.timeScale;p=this.currentTime;m=this.currentTime%=this.data.length;l=parseInt(Math.min(m*this.data.fps,this.data.length*this.data.fps),10);for(var o=0,y=this.hierarchy.length;o<y;o++){a=this.hierarchy[o];j=a.animationCache;if(this.JITCompile&&k[o][l]!==undefined)if(a instanceof THREE.Bone){a.skinMatrix=k[o][l];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=
!1}else{a.matrix=k[o][l];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=!0}else{if(this.JITCompile)if(a instanceof THREE.Bone)a.skinMatrix=a.animationCache.originalMatrix;else a.matrix=a.animationCache.originalMatrix;for(var x=0;x<3;x++){b=d[x];g=j.prevKey[b];h=j.nextKey[b];if(h.time<=p){if(m<p)if(this.loop){g=this.data.hierarchy[o].keys[0];for(h=this.getNextKeyWith(b,o,1);h.time<m;){g=h;h=this.getNextKeyWith(b,o,h.index+1)}}else{this.stop();return}else{do{g=h;h=this.getNextKeyWith(b,o,h.index+1)}while(h.time<
m)}j.prevKey[b]=g;j.nextKey[b]=h}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;e=(m-g.time)/(h.time-g.time);c=g[b];f=h[b];if(e<0||e>1){console.log("THREE.Animation.update: Warning! Scale out of bounds:"+e+" on bone "+o);e=e<0?0:1}if(b==="pos"){b=a.position;if(this.interpolationType===THREE.AnimationHandler.LINEAR){b.x=c[0]+(f[0]-c[0])*e;b.y=c[1]+(f[1]-c[1])*e;b.z=c[2]+(f[2]-c[2])*e}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){this.points[0]=
this.getPrevKeyWith("pos",o,g.index-1).pos;this.points[1]=c;this.points[2]=f;this.points[3]=this.getNextKeyWith("pos",o,h.index+1).pos;e=e*0.33+0.33;c=this.interpolateCatmullRom(this.points,e);b.x=c[0];b.y=c[1];b.z=c[2];if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){e=this.interpolateCatmullRom(this.points,e*1.01);this.target.set(e[0],e[1],e[2]);this.target.subSelf(b);this.target.y=0;this.target.normalize();e=Math.atan2(this.target.x,this.target.z);a.rotation.set(0,e,0)}}}else if(b===
"rot")THREE.Quaternion.slerp(c,f,a.quaternion,e);else if(b==="scl"){b=a.scale;b.x=c[0]+(f[0]-c[0])*e;b.y=c[1]+(f[1]-c[1])*e;b.z=c[2]+(f[2]-c[2])*e}}}}if(this.JITCompile&&k[0][l]===undefined){this.hierarchy[0].update(undefined,!0);for(o=0;o<this.hierarchy.length;o++)k[o][l]=this.hierarchy[o]instanceof THREE.Bone?this.hierarchy[o].skinMatrix.clone():this.hierarchy[o].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,d){var b=[],e=[],c,f,g,h,j,l;c=(a.length-1)*d;f=Math.floor(c);c-=f;b[0]=f==0?f:f-1;b[1]=f;b[2]=f>a.length-2?f:f+1;b[3]=f>a.length-3?f:f+2;f=a[b[0]];h=a[b[1]];j=a[b[2]];l=a[b[3]];b=c*c;g=c*b;e[0]=this.interpolate(f[0],h[0],j[0],l[0],c,b,g);e[1]=this.interpolate(f[1],h[1],j[1],l[1],c,b,g);e[2]=this.interpolate(f[2],h[2],j[2],l[2],c,b,g);return e};
THREE.Animation.prototype.interpolate=function(a,d,b,e,c,f,g){a=(b-a)*0.5;e=(e-d)*0.5;return(2*(d-b)+a+e)*g+(-3*(d-b)-2*a-e)*f+a*c+d};THREE.Animation.prototype.getNextKeyWith=function(a,d,b){var e=this.data.hierarchy[d].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)b=b<e.length-1?b:e.length-1;else b%=e.length;for(;b<e.length;b++)if(e[b][a]!==undefined)return e[b];return this.data.hierarchy[d].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,d,b){var e=this.data.hierarchy[d].keys;for(b=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b>0?b:0:b>=0?b:b+e.length;b>=0;b--)if(e[b][a]!==undefined)return e[b];return this.data.hierarchy[d].keys[e.length-1]};
var GeometryUtils={merge:function(a,d){var b=d instanceof THREE.Mesh,e=a.vertices.length,c=b?d.geometry:d,f=a.vertices,g=c.vertices,h=a.faces,j=c.faces,l=a.faceVertexUvs[0];c=c.faceVertexUvs[0];b&&d.matrixAutoUpdate&&d.updateMatrix();for(var k=0,m=g.length;k<m;k++){var p=new THREE.Vertex(g[k].position.clone());b&&d.matrix.multiplyVector3(p.position);f.push(p)}k=0;for(m=j.length;k<m;k++){g=j[k];var o,y,x=g.vertexNormals;p=g.vertexColors;if(g instanceof THREE.Face3)o=new THREE.Face3(g.a+e,g.b+e,g.c+
e);else g instanceof THREE.Face4&&(o=new THREE.Face4(g.a+e,g.b+e,g.c+e,g.d+e));o.normal.copy(g.normal);b=0;for(f=x.length;b<f;b++){y=x[b];o.vertexNormals.push(y.clone())}o.color.copy(g.color);b=0;for(f=p.length;b<f;b++){y=p[b];o.vertexColors.push(y.clone())}o.materials=g.materials.slice();o.centroid.copy(g.centroid);h.push(o)}k=0;for(m=c.length;k<m;k++){e=c[k];h=[];b=0;for(f=e.length;b<f;b++)h.push(new THREE.UV(e[b].u,e[b].v));l.push(h)}}};
THREE.ImageUtils={loadTexture:function(a,d,b){var e=new Image,c=new THREE.Texture(e,d);e.onload=function(){c.needsUpdate=!0;b&&b(this)};e.src=a;return c},loadTextureCube:function(a,d,b){var e,c=[],f=new THREE.Texture(c,d);d=c.loadCount=0;for(e=a.length;d<e;++d){c[d]=new Image;c[d].onload=function(){c.loadCount+=1;if(c.loadCount==6)f.needsUpdate=!0;b&&b(this)};c[d].src=a[d]}return f}};
THREE.SceneUtils={addMesh:function(a,d,b,e,c,f,g,h,j,l){d=new THREE.Mesh(d,l);d.scale.x=d.scale.y=d.scale.z=b;d.position.x=e;d.position.y=c;d.position.z=f;d.rotation.x=g;d.rotation.y=h;d.rotation.z=j;a.addObject(d);return d},addPanoramaCubeWebGL:function(a,d,b){var e=THREE.ShaderUtils.lib.cube;e.uniforms.tCube.texture=b;b=new THREE.MeshShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:e.uniforms});d=new THREE.Mesh(new THREE.Cube(d,d,d,1,1,1,null,!0),b);a.addObject(d);
return d},addPanoramaCube:function(a,d,b){var e=[];e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[4])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));d=new THREE.Mesh(new THREE.Cube(d,d,d,1,1,e,!0),
new THREE.MeshFaceMaterial);a.addObject(d);return d},addPanoramaCubePlanes:function(a,d,b){var e=d/2;d=new THREE.Plane(d,d);var c=Math.PI,f=Math.PI/2;THREE.SceneUtils.addMesh(a,d,1,0,0,-e,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));THREE.SceneUtils.addMesh(a,d,1,-e,0,0,0,f,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));THREE.SceneUtils.addMesh(a,d,1,e,0,0,0,-f,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));THREE.SceneUtils.addMesh(a,d,1,0,e,0,f,
0,c,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));THREE.SceneUtils.addMesh(a,d,1,0,-e,0,-f,0,c,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}))},showHierarchy:function(a,d){THREE.SceneUtils.traverseHierarchy(a,function(b){b.visible=d})},traverseHierarchy:function(a,d){var b,e,c=a.children.length;for(e=0;e<c;e++){b=a.children[e];d(b);THREE.SceneUtils.traverseHierarchy(b,d)}}};
THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:5,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",
value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 specularTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight * pointDiffuseWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight * dirDiffuseWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var d,b,e,c,f=2*Math.ceil(a*3)+1;f>25&&(f=25);c=(f-1)*0.5;b=Array(f);for(d=e=0;d<f;++d){b[d]=Math.exp(-((d-c)*(d-c))/(2*a*a));e+=b[d]}for(d=0;d<f;++d)b[d]/=e;return b}};
THREE.QuakeCamera=function(a){function d(b,e){return function(){e.apply(b,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;this.lastUpdate=(new Date).getTime();this.tdiff=0;if(a){if(a.movementSpeed!==undefined)this.movementSpeed=
a.movementSpeed;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.noFly!==undefined)this.noFly=a.noFly;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.autoForward!==undefined)this.autoForward=a.autoForward;if(a.activeLook!==undefined)this.activeLook=a.activeLook;if(a.heightSpeed!==undefined)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==undefined)this.heightCoef=a.heightCoef;if(a.heightMin!==undefined)this.heightMin=a.heightMin;if(a.heightMax!==undefined)this.heightMax=
a.heightMax;if(a.constrainVertical!==undefined)this.constrainVertical=a.constrainVertical;if(a.verticalMin!==undefined)this.verticalMin=a.verticalMin;if(a.verticalMax!==undefined)this.verticalMax=a.verticalMax;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.moveForward=!1;this.moveBackward=!1;this.moveLeft=!1;this.moveRight=!1;this.freeze=!1;this.mouseDragOn=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=
window.innerHeight/2;this.onMouseDown=function(b){b.preventDefault();b.stopPropagation();if(this.activeLook)switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(b){b.preventDefault();b.stopPropagation();if(this.activeLook)switch(b.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(b){this.mouseX=b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.onKeyDown=
function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){var b=(new Date).getTime();this.tdiff=(b-this.lastUpdate)/
1E3;this.lastUpdate=b;if(!this.freeze){this.autoSpeedFactor=this.heightSpeed?this.tdiff*((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;var e=this.tdiff*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.translateZ(-(e+this.autoSpeedFactor));this.moveBackward&&this.translateZ(e);this.moveLeft&&this.translateX(-e);this.moveRight&&this.translateX(e);e=this.tdiff*this.lookSpeed;
this.activeLook||(e=0);this.lon+=this.mouseX*e;this.lookVertical&&(this.lat-=this.mouseY*e);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;b=this.target.position;var c=this.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta)}this.lon+=this.mouseX*e;this.lookVertical&&(this.lat-=this.mouseY*e);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=
(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=(this.phi-0)*(this.verticalMax-this.verticalMin)/3.14+this.verticalMin;b=this.target.position;c=this.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},!1);this.domElement.addEventListener("mousemove",d(this,
this.onMouseMove),!1);this.domElement.addEventListener("mousedown",d(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",d(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",d(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",d(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;
THREE.QuakeCamera.prototype.translate=function(a,d){this.matrix.rotateAxis(d);if(this.noFly)d.y=0;this.position.addSelf(d.multiplyScalar(a));this.target.position.addSelf(d.multiplyScalar(a))};
THREE.PathCamera=function(a){function d(l,k,m,p){var o={name:m,fps:0.6,length:p,hierarchy:[]},y,x=k.getControlPointsArray(),v=k.getLength(),u=x.length,z=0;y=u-1;k={parent:-1,keys:[]};k.keys[0]={time:0,pos:x[0],rot:[0,0,0,1],scl:[1,1,1]};k.keys[y]={time:p,pos:x[y],rot:[0,0,0,1],scl:[1,1,1]};for(y=1;y<u-1;y++){z=p*v.chunks[y]/v.total;k.keys[y]={time:z,pos:x[y]}}o.hierarchy[0]=k;THREE.AnimationHandler.add(o);return new THREE.Animation(l,m,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function b(l,k){var m,
p,o=new THREE.Geometry;for(m=0;m<l.points.length*k;m++){p=m/(l.points.length*k);p=l.getPoint(p);o.vertices[m]=new THREE.Vertex(new THREE.Vector3(p.x,p.y,p.z))}return o}function e(l,k){var m=b(k,10),p=b(k,10),o=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(m,o);particleObj=new THREE.ParticleSystem(p,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);l.addChild(lineObj);particleObj.scale.set(1,1,1);l.addChild(particleObj);p=new THREE.Sphere(1,
16,8);o=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<k.points.length;i++){m=new THREE.Mesh(p,o);m.position.copy(k.points[i]);m.updateMatrix();l.addChild(m)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookVertical=
!0;this.lookHorizontal=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(a){if(a.duration!==undefined)this.duration=a.duration*1E3;if(a.waypoints!==undefined)this.waypoints=a.waypoints;if(a.useConstantSpeed!==undefined)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==undefined)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==undefined)this.createDebugPath=a.createDebugPath;
if(a.createDebugDummy!==undefined)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==undefined)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==undefined)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==undefined)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=
this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var c=Math.PI*2,f=Math.PI/180;this.update=function(l,k,m){var p,o;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*f;this.theta=this.lon*f;p=this.phi%c;this.phi=p>=0?p:p+c;p=this.verticalAngleMap.srcRange;o=this.verticalAngleMap.dstRange;
this.phi=(this.phi-p[0])*(o[1]-o[0])/(p[1]-p[0])+o[0];p=this.horizontalAngleMap.srcRange;o=this.horizontalAngleMap.dstRange;this.theta=(this.theta-p[0])*(o[1]-o[0])/(p[1]-p[0])+o[0];p=this.target.position;p.x=100*Math.sin(this.phi)*Math.cos(this.theta);p.y=100*Math.cos(this.phi);p.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,l,k,m)};this.onMouseMove=function(l){this.mouseX=l.clientX-this.windowHalfX;this.mouseY=l.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);
this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){a=new THREE.MeshLambertMaterial({color:30719});var g=new THREE.MeshLambertMaterial({color:65280}),h=new THREE.Cube(10,10,20),j=new THREE.Cube(2,2,10);this.animationParent=new THREE.Mesh(h,a);a=new THREE.Mesh(j,g);a.position.set(0,10,0);this.animation=d(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else{this.animation=
d(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this.target);this.animationParent.addChild(this)}this.createDebugPath&&e(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(l,k){return function(){k.apply(l,arguments)}}(this,this.onMouseMove),!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.FlyCamera=function(a){function d(b,e){return function(){e.apply(b,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.tmpQuaternion=new THREE.Quaternion;this.movementSpeed=1;this.rollSpeed=0.005;this.dragToLook=!1;this.autoForward=!1;this.domElement=document;if(a){if(a.movementSpeed!==undefined)this.movementSpeed=a.movementSpeed;if(a.rollSpeed!==undefined)this.rollSpeed=a.rollSpeed;if(a.dragToLook!==undefined)this.dragToLook=a.dragToLook;if(a.autoForward!==undefined)this.autoForward=
a.autoForward;if(a.domElement!==undefined)this.domElement=a.domElement}this.useTarget=!1;this.useQuaternion=!0;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.lastUpdate=-1;this.tdiff=0;this.handleEvent=function(b){if(typeof this[b.type]=="function")this[b.type](b)};this.keydown=function(b){if(!b.altKey){switch(b.keyCode){case 16:this.movementSpeedMultiplier=
0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};
this.keyup=function(b){switch(b.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;
case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(b){b.preventDefault();b.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.mousemove=function(b){if(!this.dragToLook||this.mouseStatus>0){var e=this.getContainerDimensions(),c=e.size[0]/2,f=e.size[1]/2;this.moveState.yawLeft=-(b.clientX-e.offset[0]-c)/c;this.moveState.pitchDown=(b.clientY-
e.offset[1]-f)/f;this.updateRotationVector()}};this.mouseup=function(b){b.preventDefault();b.stopPropagation();if(this.dragToLook){this.mouseStatus--;this.moveState.yawLeft=this.moveState.pitchDown=0}else switch(b.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(){var b=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=b;this.tdiff=(b-this.lastUpdate)/1E3;this.lastUpdate=b;b=this.tdiff*this.movementSpeed;var e=this.tdiff*
this.rollSpeed;this.translateX(this.moveVector.x*b);this.translateY(this.moveVector.y*b);this.translateZ(this.moveVector.z*b);this.tmpQuaternion.set(this.rotationVector.x*e,this.rotationVector.y*e,this.rotationVector.z*e,1).normalize();this.quaternion.multiplySelf(this.tmpQuaternion);this.matrix.setPosition(this.position);this.matrix.setRotationFromQuaternion(this.quaternion);this.matrixWorldNeedsUpdate=!0;this.supr.update.call(this)};this.updateMovementVector=function(){var b=this.moveState.forward||
this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-b+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=
document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",d(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",d(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",d(this,this.mouseup),!1);window.addEventListener("keydown",d(this,this.keydown),!1);window.addEventListener("keyup",d(this,
this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};THREE.FlyCamera.prototype=new THREE.Camera;THREE.FlyCamera.prototype.constructor=THREE.FlyCamera;THREE.FlyCamera.prototype.supr=THREE.Camera.prototype;
THREE.RollCamera=function(a,d,b,e){THREE.Camera.call(this,a,d,b,e);this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.domElement=document;this.useTarget=!1;this.matrixAutoUpdate=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;this.lastUpdate=-1;this.delta=0;var c=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Matrix4,j=!1,l=1,k=0,m=0,p=0,o=0,y=0,x=window.innerWidth/2,v=window.innerHeight/2;this.update=
function(){var u=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=u;this.delta=(u-this.lastUpdate)/1E3;this.lastUpdate=u;if(this.mouseLook){u=this.delta*this.lookSpeed;this.rotateHorizontally(u*o);this.rotateVertically(u*y)}u=this.delta*this.movementSpeed;this.translateZ(u*(k>0||this.autoForward&&!(k<0)?1:k));this.translateX(u*m);this.translateY(u*p);j&&(this.roll+=this.rollSpeed*this.delta*l);if(this.forward.y>this.constrainVertical[1]){this.forward.y=this.constrainVertical[1];this.forward.normalize()}else if(this.forward.y<
this.constrainVertical[0]){this.forward.y=this.constrainVertical[0];this.forward.normalize()}g.copy(this.forward);f.set(0,1,0);c.cross(f,g).normalize();f.cross(g,c).normalize();this.matrix.n11=c.x;this.matrix.n12=f.x;this.matrix.n13=g.x;this.matrix.n21=c.y;this.matrix.n22=f.y;this.matrix.n23=g.y;this.matrix.n31=c.z;this.matrix.n32=f.z;this.matrix.n33=g.z;h.identity();h.n11=Math.cos(this.roll);h.n12=-Math.sin(this.roll);h.n21=Math.sin(this.roll);h.n22=Math.cos(this.roll);this.matrix.multiplySelf(h);
this.matrixWorldNeedsUpdate=!0;this.matrix.n14=this.position.x;this.matrix.n24=this.position.y;this.matrix.n34=this.position.z;this.supr.update.call(this)};this.translateX=function(u){this.position.x+=this.matrix.n11*u;this.position.y+=this.matrix.n21*u;this.position.z+=this.matrix.n31*u};this.translateY=function(u){this.position.x+=this.matrix.n12*u;this.position.y+=this.matrix.n22*u;this.position.z+=this.matrix.n32*u};this.translateZ=function(u){this.position.x-=this.matrix.n13*u;this.position.y-=
this.matrix.n23*u;this.position.z-=this.matrix.n33*u};this.rotateHorizontally=function(u){c.set(this.matrix.n11,this.matrix.n21,this.matrix.n31);c.multiplyScalar(u);this.forward.subSelf(c);this.forward.normalize()};this.rotateVertically=function(u){f.set(this.matrix.n12,this.matrix.n22,this.matrix.n32);f.multiplyScalar(u);this.forward.addSelf(f);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(u){u.preventDefault()},!1);this.domElement.addEventListener("mousemove",
function(u){o=(u.clientX-x)/window.innerWidth;y=(u.clientY-v)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(u){u.preventDefault();u.stopPropagation();switch(u.button){case 0:k=1;break;case 2:k=-1}},!1);this.domElement.addEventListener("mouseup",function(u){u.preventDefault();u.stopPropagation();switch(u.button){case 0:k=0;break;case 2:k=0}},!1);this.domElement.addEventListener("keydown",function(u){switch(u.keyCode){case 38:case 87:k=1;break;case 37:case 65:m=-1;break;
case 40:case 83:k=-1;break;case 39:case 68:m=1;break;case 81:j=!0;l=1;break;case 69:j=!0;l=-1;break;case 82:p=1;break;case 70:p=-1}},!1);this.domElement.addEventListener("keyup",function(u){switch(u.keyCode){case 38:case 87:k=0;break;case 37:case 65:m=0;break;case 40:case 83:k=0;break;case 39:case 68:m=0;break;case 81:j=!1;break;case 69:j=!1;break;case 82:p=0;break;case 70:p=0}},!1)};THREE.RollCamera.prototype=new THREE.Camera;THREE.RollCamera.prototype.constructor=THREE.RollCamera;
THREE.RollCamera.prototype.supr=THREE.Camera.prototype;
THREE.Cube=function(a,d,b,e,c,f,g,h,j){function l(v,u,z,n,A,B,G,K){var J,H,D=e||1,L=c||1,R=A/2,O=B/2,S=k.vertices.length;if(v=="x"&&u=="y"||v=="y"&&u=="x")J="z";else if(v=="x"&&u=="z"||v=="z"&&u=="x"){J="y";L=f||1}else if(v=="z"&&u=="y"||v=="y"&&u=="z"){J="x";D=f||1}var P=D+1,F=L+1;A/=D;var M=B/L;for(H=0;H<F;H++)for(B=0;B<P;B++){var Q=new THREE.Vector3;Q[v]=(B*A-R)*z;Q[u]=(H*M-O)*n;Q[J]=G;k.vertices.push(new THREE.Vertex(Q))}for(H=0;H<L;H++)for(B=0;B<D;B++){k.faces.push(new THREE.Face4(B+P*H+S,B+
P*(H+1)+S,B+1+P*(H+1)+S,B+1+P*H+S,null,null,K));k.faceVertexUvs[0].push([new THREE.UV(B/D,H/L),new THREE.UV(B/D,(H+1)/L),new THREE.UV((B+1)/D,(H+1)/L),new THREE.UV((B+1)/D,H/L)])}}THREE.Geometry.call(this);var k=this,m=a/2,p=d/2,o=b/2;h=h?-1:1;if(g!==undefined)if(g instanceof Array)this.materials=g;else{this.materials=[];for(var y=0;y<6;y++)this.materials.push([g])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(j!=undefined)for(var x in j)this.sides[x]!=undefined&&(this.sides[x]=
j[x]);this.sides.px&&l("z","y",1*h,-1,b,d,-m,this.materials[0]);this.sides.nx&&l("z","y",-1*h,-1,b,d,m,this.materials[1]);this.sides.py&&l("x","z",1*h,1,a,b,p,this.materials[2]);this.sides.ny&&l("x","z",1*h,-1,a,b,-p,this.materials[3]);this.sides.pz&&l("x","y",1*h,-1,a,d,o,this.materials[4]);this.sides.nz&&l("x","y",-1*h,-1,a,d,-o,this.materials[5]);(function(){for(var v=[],u=[],z=0,n=k.vertices.length;z<n;z++){for(var A=k.vertices[z],B=!1,G=0,K=v.length;G<K;G++){var J=v[G];if(A.position.x==J.position.x&&
A.position.y==J.position.y&&A.position.z==J.position.z){u[z]=G;B=!0;break}}if(!B){u[z]=v.length;v.push(new THREE.Vertex(A.position.clone()))}}z=0;for(n=k.faces.length;z<n;z++){A=k.faces[z];A.a=u[A.a];A.b=u[A.b];A.c=u[A.c];A.d=u[A.d]}k.vertices=v})();this.computeCentroids();this.computeFaceNormals()};THREE.Cube.prototype=new THREE.Geometry;THREE.Cube.prototype.constructor=THREE.Cube;
THREE.Cylinder=function(a,d,b,e,c,f){function g(p,o,y){h.vertices.push(new THREE.Vertex(new THREE.Vector3(p,o,y)))}THREE.Geometry.call(this);var h=this,j,l=Math.PI*2,k=e/2;for(j=0;j<a;j++)g(Math.sin(l*j/a)*d,Math.cos(l*j/a)*d,-k);for(j=0;j<a;j++)g(Math.sin(l*j/a)*b,Math.cos(l*j/a)*b,k);for(j=0;j<a;j++)h.faces.push(new THREE.Face4(j,j+a,a+(j+1)%a,(j+1)%a));if(b>0){g(0,0,-k-(f||0));for(j=a;j<a+a/2;j++)h.faces.push(new THREE.Face4(2*a,(2*j-2*a)%a,(2*j-2*a+1)%a,(2*j-2*a+2)%a))}if(d>0){g(0,0,k+(c||0));
for(j=a+a/2;j<2*a;j++)h.faces.push(new THREE.Face4(2*a+1,(2*j-2*a+2)%a+a,(2*j-2*a+1)%a+a,(2*j-2*a)%a+a))}j=0;for(a=this.faces.length;j<a;j++){d=[];b=this.faces[j];c=this.vertices[b.a];f=this.vertices[b.b];k=this.vertices[b.c];var m=this.vertices[b.d];d.push(new THREE.UV(0.5+Math.atan2(c.position.x,c.position.y)/l,0.5+c.position.z/e));d.push(new THREE.UV(0.5+Math.atan2(f.position.x,f.position.y)/l,0.5+f.position.z/e));d.push(new THREE.UV(0.5+Math.atan2(k.position.x,k.position.y)/l,0.5+k.position.z/
e));b instanceof THREE.Face4&&d.push(new THREE.UV(0.5+Math.atan2(m.position.x,m.position.y)/l,0.5+m.position.z/e));this.faceVertexUvs[0].push(d)}this.computeCentroids();this.computeFaceNormals()};THREE.Cylinder.prototype=new THREE.Geometry;THREE.Cylinder.prototype.constructor=THREE.Cylinder;
THREE.Icosahedron=function(a){function d(m,p,o){var y=Math.sqrt(m*m+p*p+o*o);return c.vertices.push(new THREE.Vertex(new THREE.Vector3(m/y,p/y,o/y)))-1}function b(m,p,o,y){y.faces.push(new THREE.Face3(m,p,o))}function e(m,p){var o=c.vertices[m].position,y=c.vertices[p].position;return d((o.x+y.x)/2,(o.y+y.y)/2,(o.z+y.z)/2)}var c=this,f=new THREE.Geometry,g;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;d(-1,a,0);d(1,a,0);d(-1,-a,0);d(1,-a,0);d(0,-1,a);d(0,1,a);d(0,-1,-a);d(0,
1,-a);d(a,0,-1);d(a,0,1);d(-a,0,-1);d(-a,0,1);b(0,11,5,f);b(0,5,1,f);b(0,1,7,f);b(0,7,10,f);b(0,10,11,f);b(1,5,9,f);b(5,11,4,f);b(11,10,2,f);b(10,7,6,f);b(7,1,8,f);b(3,9,4,f);b(3,4,2,f);b(3,2,6,f);b(3,6,8,f);b(3,8,9,f);b(4,9,5,f);b(2,4,11,f);b(6,2,10,f);b(8,6,7,f);b(9,8,1,f);for(a=0;a<this.subdivisions;a++){g=new THREE.Geometry;for(var h in f.faces){var j=e(f.faces[h].a,f.faces[h].b),l=e(f.faces[h].b,f.faces[h].c),k=e(f.faces[h].c,f.faces[h].a);b(f.faces[h].a,j,k,g);b(f.faces[h].b,l,j,g);b(f.faces[h].c,
k,l,g);b(j,l,k,g)}f.faces=g.faces}c.faces=f.faces;delete f;delete g;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Icosahedron.prototype=new THREE.Geometry;THREE.Icosahedron.prototype.constructor=THREE.Icosahedron;
THREE.Lathe=function(a,d,b){THREE.Geometry.call(this);this.steps=d||12;this.angle=b||2*Math.PI;d=this.angle/this.steps;b=[];for(var e=[],c=[],f=[],g=(new THREE.Matrix4).setRotationZ(d),h=0;h<a.length;h++){this.vertices.push(new THREE.Vertex(a[h]));b[h]=a[h].clone();e[h]=this.vertices.length-1}for(var j=0;j<=this.angle+0.001;j+=d){for(h=0;h<b.length;h++)if(j<this.angle){b[h]=g.multiplyVector3(b[h].clone());this.vertices.push(new THREE.Vertex(b[h]));c[h]=this.vertices.length-1}else c=f;j==0&&(f=e);
for(h=0;h<e.length-1;h++){this.faces.push(new THREE.Face4(c[h],c[h+1],e[h+1],e[h]));this.faceVertexUvs[0].push([new THREE.UV(1-j/this.angle,h/a.length),new THREE.UV(1-j/this.angle,(h+1)/a.length),new THREE.UV(1-(j-d)/this.angle,(h+1)/a.length),new THREE.UV(1-(j-d)/this.angle,h/a.length)])}e=c;c=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Lathe.prototype=new THREE.Geometry;THREE.Lathe.prototype.constructor=THREE.Lathe;
THREE.Plane=function(a,d,b,e){THREE.Geometry.call(this);var c,f=a/2,g=d/2;b=b||1;e=e||1;var h=b+1,j=e+1;a/=b;var l=d/e;for(c=0;c<j;c++)for(d=0;d<h;d++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(d*a-f,-(c*l-g),0)));for(c=0;c<e;c++)for(d=0;d<b;d++){this.faces.push(new THREE.Face4(d+h*c,d+h*(c+1),d+1+h*(c+1),d+1+h*c));this.faceVertexUvs[0].push([new THREE.UV(d/b,c/e),new THREE.UV(d/b,(c+1)/e),new THREE.UV((d+1)/b,(c+1)/e),new THREE.UV((d+1)/b,c/e)])}this.computeCentroids();this.computeFaceNormals()};
THREE.Plane.prototype=new THREE.Geometry;THREE.Plane.prototype.constructor=THREE.Plane;
THREE.Sphere=function(a,d,b){THREE.Geometry.call(this);var e,c=Math.PI,f=Math.max(3,d||8),g=Math.max(2,b||6);d=[];for(b=0;b<g+1;b++){e=b/g;var h=a*Math.cos(e*c),j=a*Math.sin(e*c),l=[],k=0;for(e=0;e<f;e++){var m=2*e/f,p=j*Math.sin(m*c);m=j*Math.cos(m*c);(b==0||b==g)&&e>0||(k=this.vertices.push(new THREE.Vertex(new THREE.Vector3(m,h,p)))-1);l.push(k)}d.push(l)}var o,y,x;c=d.length;for(b=0;b<c;b++){f=d[b].length;if(b>0)for(e=0;e<f;e++){l=e==f-1;g=d[b][l?0:e+1];h=d[b][l?f-1:e];j=d[b-1][l?f-1:e];l=d[b-
1][l?0:e+1];p=b/(c-1);o=(b-1)/(c-1);y=(e+1)/f;m=e/f;k=new THREE.UV(1-y,p);p=new THREE.UV(1-m,p);m=new THREE.UV(1-m,o);var v=new THREE.UV(1-y,o);if(b<d.length-1){o=this.vertices[g].position.clone();y=this.vertices[h].position.clone();x=this.vertices[j].position.clone();o.normalize();y.normalize();x.normalize();this.faces.push(new THREE.Face3(g,h,j,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(x.x,x.y,x.z)]));this.faceVertexUvs[0].push([k,p,m])}if(b>1){o=this.vertices[g].position.clone();
y=this.vertices[j].position.clone();x=this.vertices[l].position.clone();o.normalize();y.normalize();x.normalize();this.faces.push(new THREE.Face3(g,j,l,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(x.x,x.y,x.z)]));this.faceVertexUvs[0].push([k,m,v])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};THREE.Sphere.prototype=new THREE.Geometry;THREE.Sphere.prototype.constructor=THREE.Sphere;
THREE.Torus=function(a,d,b,e){THREE.Geometry.call(this);this.radius=a||100;this.tube=d||40;this.segmentsR=b||8;this.segmentsT=e||6;a=[];for(d=0;d<=this.segmentsR;++d)for(b=0;b<=this.segmentsT;++b){e=b/this.segmentsT*2*Math.PI;var c=d/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(c))*Math.cos(e),(this.radius+this.tube*Math.cos(c))*Math.sin(e),this.tube*Math.sin(c))));a.push([b/this.segmentsT,1-d/this.segmentsR])}for(d=1;d<=this.segmentsR;++d)for(b=
1;b<=this.segmentsT;++b){e=(this.segmentsT+1)*d+b;c=(this.segmentsT+1)*d+b-1;var f=(this.segmentsT+1)*(d-1)+b-1,g=(this.segmentsT+1)*(d-1)+b;this.faces.push(new THREE.Face4(e,c,f,g));this.faceVertexUvs[0].push([new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[c][0],a[c][1]),new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[g][0],a[g][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Torus.prototype=new THREE.Geometry;THREE.Torus.prototype.constructor=THREE.Torus;
THREE.TorusKnot=function(a,d,b,e,c,f,g){function h(m,p,o,y,x,v){p=o/y*m;o=Math.cos(p);return new THREE.Vector3(x*(2+o)*0.5*Math.cos(m),x*(2+o)*Math.sin(m)*0.5,v*x*Math.sin(p)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=d||40;this.segmentsR=b||64;this.segmentsT=e||8;this.p=c||2;this.q=f||3;this.heightScale=g||1;this.grid=Array(this.segmentsR);b=new THREE.Vector3;e=new THREE.Vector3;f=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(d=0;d<this.segmentsT;++d){var j=
a/this.segmentsR*2*this.p*Math.PI;g=d/this.segmentsT*2*Math.PI;c=h(j,g,this.q,this.p,this.radius,this.heightScale);j=h(j+0.01,g,this.q,this.p,this.radius,this.heightScale);b.x=j.x-c.x;b.y=j.y-c.y;b.z=j.z-c.z;e.x=j.x+c.x;e.y=j.y+c.y;e.z=j.z+c.z;f.cross(b,e);e.cross(f,b);f.normalize();e.normalize();j=-this.tube*Math.cos(g);g=this.tube*Math.sin(g);c.x+=j*e.x+g*f.x;c.y+=j*e.y+g*f.y;c.z+=j*e.z+g*f.z;this.grid[a][d]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(c.x,c.y,c.z)))-1}}for(a=0;a<this.segmentsR;++a)for(d=
0;d<this.segmentsT;++d){e=(a+1)%this.segmentsR;f=(d+1)%this.segmentsT;c=this.grid[a][d];b=this.grid[e][d];e=this.grid[e][f];f=this.grid[a][f];g=new THREE.UV(a/this.segmentsR,d/this.segmentsT);j=new THREE.UV((a+1)/this.segmentsR,d/this.segmentsT);var l=new THREE.UV((a+1)/this.segmentsR,(d+1)/this.segmentsT),k=new THREE.UV(a/this.segmentsR,(d+1)/this.segmentsT);this.faces.push(new THREE.Face4(c,b,e,f));this.faceVertexUvs[0].push([g,j,l,k])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};
THREE.TorusKnot.prototype=new THREE.Geometry;THREE.TorusKnot.prototype.constructor=THREE.TorusKnot;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var d="Loaded ";d+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=d},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")},init_materials:function(a,d,b){a.materials=[];for(var e=0;e<d.length;++e)a.materials[e]=[THREE.Loader.prototype.createMaterial(d[e],b)]},createMaterial:function(a,d){function b(h){h=Math.log(h)/Math.LN2;return Math.floor(h)==h}function e(h,j){var l=new Image;l.onload=function(){if(!b(this.width)||!b(this.height)){var k=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),m=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));h.image.width=k;h.image.height=m;h.image.getContext("2d").drawImage(this,0,0,k,m)}else h.image=this;h.needsUpdate=!0};l.src=j}var c,f,g;c="MeshLambertMaterial";f={color:15658734,opacity:1,map:null,lightMap:null,wireframe:a.wireframe};if(a.shading)if(a.shading=="Phong")c="MeshPhongMaterial";else a.shading=="Basic"&&(c="MeshBasicMaterial");if(a.blending)if(a.blending=="Additive")f.blending=THREE.AdditiveBlending;else if(a.blending=="Subtractive")f.blending=THREE.SubtractiveBlending;else if(a.blending==
"Multiply")f.blending=THREE.MultiplyBlending;if(a.transparent!==undefined||a.opacity<1)f.transparent=a.transparent;if(a.depthTest!==undefined)f.depthTest=a.depthTest;if(a.vertexColors!==undefined)if(a.vertexColors=="face")f.vertexColors=THREE.FaceColors;else if(a.vertexColors)f.vertexColors=THREE.VertexColors;if(a.mapDiffuse&&d){g=document.createElement("canvas");f.map=new THREE.Texture(g);f.map.sourceFile=a.mapDiffuse;e(f.map,d+"/"+a.mapDiffuse)}else if(a.colorDiffuse){g=(a.colorDiffuse[0]*255<<
16)+(a.colorDiffuse[1]*255<<8)+a.colorDiffuse[2]*255;f.color=g;f.opacity=a.transparency}else if(a.DbgColor)f.color=a.DbgColor;if(a.mapLightmap&&d){g=document.createElement("canvas");f.lightMap=new THREE.Texture(g);f.lightMap.sourceFile=a.mapLightmap;e(f.lightMap,d+"/"+a.mapLightmap)}return new THREE[c](f)}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(a){var d=this,b=a.model,e=a.callback,c=a.texture_path?a.texture_path:this.extractUrlbase(b);a=new Worker(b);a.onmessage=function(f){d.createModel(f.data,e,c);d.onLoadComplete()};this.onLoadStart();a.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(a,d,b){var e=new THREE.Geometry;this.init_materials(e,a.materials,b);(function(){if(a.version===undefined||a.version!=2)console.error("Deprecated file format.");else{var c,f,g,h,j,l,k,m,p,o,y,x,v,u,z,n=a.faces;o=a.vertices;var A=a.normals,B=a.colors;l=a.scale!==undefined?a.scale:1;var G=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&G++;for(c=0;c<G;c++){e.faceUvs[c]=[];e.faceVertexUvs[c]=[]}h=0;for(j=o.length;h<j;){k=new THREE.Vertex;k.position.x=o[h++]/
l;k.position.y=o[h++]/l;k.position.z=o[h++]/l;e.vertices.push(k)}h=0;for(j=n.length;h<j;){o=n[h++];l=o&1;g=o&2;c=o&4;f=o&8;m=o&16;k=o&32;y=o&64;o&=128;if(l){x=new THREE.Face4;x.a=n[h++];x.b=n[h++];x.c=n[h++];x.d=n[h++];l=4}else{x=new THREE.Face3;x.a=n[h++];x.b=n[h++];x.c=n[h++];l=3}if(g){g=n[h++];x.materials=e.materials[g]}g=e.faces.length;if(c)for(c=0;c<G;c++){v=a.uvs[c];p=n[h++];z=v[p*2];p=v[p*2+1];e.faceUvs[c][g]=new THREE.UV(z,p)}if(f)for(c=0;c<G;c++){v=a.uvs[c];u=[];for(f=0;f<l;f++){p=n[h++];
z=v[p*2];p=v[p*2+1];u[f]=new THREE.UV(z,p)}e.faceVertexUvs[c][g]=u}if(m){m=n[h++]*3;f=new THREE.Vector3;f.x=A[m++];f.y=A[m++];f.z=A[m];x.normal=f}if(k)for(c=0;c<l;c++){m=n[h++]*3;f=new THREE.Vector3;f.x=A[m++];f.y=A[m++];f.z=A[m];x.vertexNormals.push(f)}if(y){k=n[h++];k=new THREE.Color(B[k]);x.color=k}if(o)for(c=0;c<l;c++){k=n[h++];k=new THREE.Color(B[k]);x.vertexColors.push(k)}e.faces.push(x)}}})();(function(){var c,f,g,h;if(a.skinWeights){c=0;for(f=a.skinWeights.length;c<f;c+=2){g=a.skinWeights[c];
h=a.skinWeights[c+1];e.skinWeights.push(new THREE.Vector4(g,h,0,0))}}if(a.skinIndices){c=0;for(f=a.skinIndices.length;c<f;c+=2){g=a.skinIndices[c];h=a.skinIndices[c+1];e.skinIndices.push(new THREE.Vector4(g,h,0,0))}}e.bones=a.bones;e.animation=a.animation})();(function(){if(a.morphTargets!==undefined){var c,f,g,h,j,l;c=0;for(f=a.morphTargets.length;c<f;c++){e.morphTargets[c]={};e.morphTargets[c].name=a.morphTargets[c].name;e.morphTargets[c].vertices=[];j=e.morphTargets[c].vertices;l=a.morphTargets[c].vertices;
g=0;for(h=l.length;g<h;g+=3)j.push(new THREE.Vertex(new THREE.Vector3(l[g],l[g+1],l[g+2])))}}if(a.morphColors!==undefined){var k;c=0;for(f=a.morphColors.length;c<f;c++){e.morphColors[c]={};e.morphColors[c].name=a.morphColors[c].name;e.morphColors[c].colors=[];j=e.morphColors[c].colors;l=a.morphColors[c].colors;g=0;for(h=l.length;g<h;g+=3){k=new THREE.Color(16755200);k.setRGB(l[g],l[g+1],l[g+2]);j.push(k)}}}})();(function(){if(a.edges!==undefined){var c,f,g;for(c=0;c<a.edges.length;c+=2){f=a.edges[c];
g=a.edges[c+1];e.edges.push(new THREE.Edge(e.vertices[f],e.vertices[g],f,g))}}})();e.computeCentroids();e.computeFaceNormals();e.computeEdgeFaces();d(e)};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(a){var d=a.model,b=a.callback,e=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(d),c=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(d);a=(new Date).getTime();d=new Worker(d);var f=this.showProgress?THREE.Loader.prototype.updateProgress:null;d.onmessage=function(g){THREE.BinaryLoader.prototype.loadAjaxBuffers(g.data.buffers,g.data.materials,b,c,e,f)};d.onerror=function(g){alert("worker.onerror: "+g.message+"\n"+g.data);g.preventDefault()};
d.postMessage(a)},loadAjaxBuffers:function(a,d,b,e,c,f){var g=new XMLHttpRequest,h=e+"/"+a,j=0;g.onreadystatechange=function(){if(g.readyState==4)g.status==200||g.status==0?THREE.BinaryLoader.prototype.createBinModel(g.responseText,b,c,d):alert("Couldn't load ["+h+"] ["+g.status+"]");else if(g.readyState==3){if(f){j==0&&(j=g.getResponseHeader("Content-Length"));f({total:j,loaded:g.responseText.length})}}else g.readyState==2&&(j=g.getResponseHeader("Content-Length"))};g.open("GET",h,!0);g.overrideMimeType("text/plain; charset=x-user-defined");
g.setRequestHeader("Content-Type","text/plain");g.send(null)},createBinModel:function(a,d,b,e){var c=function(f){function g(t,w){var C=k(t,w),E=k(t,w+1),I=k(t,w+2),T=k(t,w+3),V=(T<<1&255|I>>7)-127;C|=(I&127)<<16|E<<8;if(C==0&&V==-127)return 0;return(1-2*(T>>7))*(1+C*Math.pow(2,-23))*Math.pow(2,V)}function h(t,w){var C=k(t,w),E=k(t,w+1),I=k(t,w+2);return(k(t,w+3)<<24)+(I<<16)+(E<<8)+C}function j(t,w){var C=k(t,w);return(k(t,w+1)<<8)+C}function l(t,w){var C=k(t,w);return C>127?C-256:C}function k(t,
w){return t.charCodeAt(w)&255}function m(t){var w,C,E;w=h(a,t);C=h(a,t+G);E=h(a,t+K);t=j(a,t+J);THREE.BinaryLoader.prototype.f3(u,w,C,E,t)}function p(t){var w,C,E,I,T,V;w=h(a,t);C=h(a,t+G);E=h(a,t+K);I=j(a,t+J);T=h(a,t+H);V=h(a,t+D);t=h(a,t+L);THREE.BinaryLoader.prototype.f3n(u,A,w,C,E,I,T,V,t)}function o(t){var w,C,E,I;w=h(a,t);C=h(a,t+R);E=h(a,t+O);I=h(a,t+S);t=j(a,t+P);THREE.BinaryLoader.prototype.f4(u,w,C,E,I,t)}function y(t){var w,C,E,I,T,V,ca,da;w=h(a,t);C=h(a,t+R);E=h(a,t+O);I=h(a,t+S);T=j(a,
t+P);V=h(a,t+F);ca=h(a,t+M);da=h(a,t+Q);t=h(a,t+U);THREE.BinaryLoader.prototype.f4n(u,A,w,C,E,I,T,V,ca,da,t)}function x(t){var w,C;w=h(a,t);C=h(a,t+N);t=h(a,t+W);THREE.BinaryLoader.prototype.uv3(u.faceVertexUvs[0],B[w*2],B[w*2+1],B[C*2],B[C*2+1],B[t*2],B[t*2+1])}function v(t){var w,C,E;w=h(a,t);C=h(a,t+ea);E=h(a,t+fa);t=h(a,t+ga);THREE.BinaryLoader.prototype.uv4(u.faceVertexUvs[0],B[w*2],B[w*2+1],B[C*2],B[C*2+1],B[E*2],B[E*2+1],B[t*2],B[t*2+1])}var u=this,z=0,n,A=[],B=[],G,K,J,H,D,L,R,O,S,P,F,M,Q,
U,N,W,ea,fa,ga,Y,Z,$,aa,ba,X;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(u,e,f);n={signature:a.substr(z,8),header_bytes:k(a,z+8),vertex_coordinate_bytes:k(a,z+9),normal_coordinate_bytes:k(a,z+10),uv_coordinate_bytes:k(a,z+11),vertex_index_bytes:k(a,z+12),normal_index_bytes:k(a,z+13),uv_index_bytes:k(a,z+14),material_index_bytes:k(a,z+15),nvertices:h(a,z+16),nnormals:h(a,z+16+4),nuvs:h(a,z+16+8),ntri_flat:h(a,z+16+12),ntri_smooth:h(a,z+16+16),ntri_flat_uv:h(a,z+16+20),ntri_smooth_uv:h(a,
z+16+24),nquad_flat:h(a,z+16+28),nquad_smooth:h(a,z+16+32),nquad_flat_uv:h(a,z+16+36),nquad_smooth_uv:h(a,z+16+40)};z+=n.header_bytes;G=n.vertex_index_bytes;K=n.vertex_index_bytes*2;J=n.vertex_index_bytes*3;H=n.vertex_index_bytes*3+n.material_index_bytes;D=n.vertex_index_bytes*3+n.material_index_bytes+n.normal_index_bytes;L=n.vertex_index_bytes*3+n.material_index_bytes+n.normal_index_bytes*2;R=n.vertex_index_bytes;O=n.vertex_index_bytes*2;S=n.vertex_index_bytes*3;P=n.vertex_index_bytes*4;F=n.vertex_index_bytes*
4+n.material_index_bytes;M=n.vertex_index_bytes*4+n.material_index_bytes+n.normal_index_bytes;Q=n.vertex_index_bytes*4+n.material_index_bytes+n.normal_index_bytes*2;U=n.vertex_index_bytes*4+n.material_index_bytes+n.normal_index_bytes*3;N=n.uv_index_bytes;W=n.uv_index_bytes*2;ea=n.uv_index_bytes;fa=n.uv_index_bytes*2;ga=n.uv_index_bytes*3;f=n.vertex_index_bytes*3+n.material_index_bytes;X=n.vertex_index_bytes*4+n.material_index_bytes;Y=n.ntri_flat*f;Z=n.ntri_smooth*(f+n.normal_index_bytes*3);$=n.ntri_flat_uv*
(f+n.uv_index_bytes*3);aa=n.ntri_smooth_uv*(f+n.normal_index_bytes*3+n.uv_index_bytes*3);ba=n.nquad_flat*X;f=n.nquad_smooth*(X+n.normal_index_bytes*4);X=n.nquad_flat_uv*(X+n.uv_index_bytes*4);z+=function(t){for(var w,C,E,I=n.vertex_coordinate_bytes*3,T=t+n.nvertices*I;t<T;t+=I){w=g(a,t);C=g(a,t+n.vertex_coordinate_bytes);E=g(a,t+n.vertex_coordinate_bytes*2);THREE.BinaryLoader.prototype.v(u,w,C,E)}return n.nvertices*I}(z);z+=function(t){for(var w,C,E,I=n.normal_coordinate_bytes*3,T=t+n.nnormals*I;t<
T;t+=I){w=l(a,t);C=l(a,t+n.normal_coordinate_bytes);E=l(a,t+n.normal_coordinate_bytes*2);A.push(w/127,C/127,E/127)}return n.nnormals*I}(z);z+=function(t){for(var w,C,E=n.uv_coordinate_bytes*2,I=t+n.nuvs*E;t<I;t+=E){w=g(a,t);C=g(a,t+n.uv_coordinate_bytes);B.push(w,C)}return n.nuvs*E}(z);Y=z+Y;Z=Y+Z;$=Z+$;aa=$+aa;ba=aa+ba;f=ba+f;X=f+X;(function(t){var w,C=n.vertex_index_bytes*3+n.material_index_bytes,E=C+n.uv_index_bytes*3,I=t+n.ntri_flat_uv*E;for(w=t;w<I;w+=E){m(w);x(w+C)}return I-t})(Z);(function(t){var w,
C=n.vertex_index_bytes*3+n.material_index_bytes+n.normal_index_bytes*3,E=C+n.uv_index_bytes*3,I=t+n.ntri_smooth_uv*E;for(w=t;w<I;w+=E){p(w);x(w+C)}return I-t})($);(function(t){var w,C=n.vertex_index_bytes*4+n.material_index_bytes,E=C+n.uv_index_bytes*4,I=t+n.nquad_flat_uv*E;for(w=t;w<I;w+=E){o(w);v(w+C)}return I-t})(f);(function(t){var w,C=n.vertex_index_bytes*4+n.material_index_bytes+n.normal_index_bytes*4,E=C+n.uv_index_bytes*4,I=t+n.nquad_smooth_uv*E;for(w=t;w<I;w+=E){y(w);v(w+C)}return I-t})(X);
(function(t){var w,C=n.vertex_index_bytes*3+n.material_index_bytes,E=t+n.ntri_flat*C;for(w=t;w<E;w+=C)m(w);return E-t})(z);(function(t){var w,C=n.vertex_index_bytes*3+n.material_index_bytes+n.normal_index_bytes*3,E=t+n.ntri_smooth*C;for(w=t;w<E;w+=C)p(w);return E-t})(Y);(function(t){var w,C=n.vertex_index_bytes*4+n.material_index_bytes,E=t+n.nquad_flat*C;for(w=t;w<E;w+=C)o(w);return E-t})(aa);(function(t){var w,C=n.vertex_index_bytes*4+n.material_index_bytes+n.normal_index_bytes*4,E=t+n.nquad_smooth*
C;for(w=t;w<E;w+=C)y(w);return E-t})(ba);this.computeCentroids();this.computeFaceNormals()};c.prototype=new THREE.Geometry;c.prototype.constructor=c;d(new c(b))},v:function(a,d,b,e){a.vertices.push(new THREE.Vertex(new THREE.Vector3(d,b,e)))},f3:function(a,d,b,e,c){a.faces.push(new THREE.Face3(d,b,e,null,null,a.materials[c]))},f4:function(a,d,b,e,c,f){a.faces.push(new THREE.Face4(d,b,e,c,null,null,a.materials[f]))},f3n:function(a,d,b,e,c,f,g,h,j){f=a.materials[f];var l=d[h*3],k=d[h*3+1];h=d[h*3+2];
var m=d[j*3],p=d[j*3+1];j=d[j*3+2];a.faces.push(new THREE.Face3(b,e,c,[new THREE.Vector3(d[g*3],d[g*3+1],d[g*3+2]),new THREE.Vector3(l,k,h),new THREE.Vector3(m,p,j)],null,f))},f4n:function(a,d,b,e,c,f,g,h,j,l,k){g=a.materials[g];var m=d[j*3],p=d[j*3+1];j=d[j*3+2];var o=d[l*3],y=d[l*3+1];l=d[l*3+2];var x=d[k*3],v=d[k*3+1];k=d[k*3+2];a.faces.push(new THREE.Face4(b,e,c,f,[new THREE.Vector3(d[h*3],d[h*3+1],d[h*3+2]),new THREE.Vector3(m,p,j),new THREE.Vector3(o,y,l),new THREE.Vector3(x,v,k)],null,g))},
uv3:function(a,d,b,e,c,f,g){var h=[];h.push(new THREE.UV(d,b));h.push(new THREE.UV(e,c));h.push(new THREE.UV(f,g));a.push(h)},uv4:function(a,d,b,e,c,f,g,h,j){var l=[];l.push(new THREE.UV(d,b));l.push(new THREE.UV(e,c));l.push(new THREE.UV(f,g));l.push(new THREE.UV(h,j));a.push(l)}};THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};
THREE.SceneLoader.prototype={load:function(a,d){var b=this,e=new Worker(a);e.postMessage(0);var c=THREE.Loader.prototype.extractUrlbase(a);e.onmessage=function(f){function g(N,W){return W=="relativeToHTML"?N:c+"/"+N}function h(){for(o in D.objects)if(!F.objects[o]){z=D.objects[o];if(z.geometry!==undefined){if(G=F.geometries[z.geometry]){H=[];for(U=0;U<z.materials.length;U++)H[U]=F.materials[z.materials[U]];n=z.position;r=z.rotation;q=z.quaternion;s=z.scale;q=0;H.length==0&&(H[0]=new THREE.MeshFaceMaterial);
H.length>1&&(H=[new THREE.MeshFaceMaterial]);object=new THREE.Mesh(G,H);object.name=o;object.position.set(n[0],n[1],n[2]);if(q){object.quaternion.set(q[0],q[1],q[2],q[3]);object.useQuaternion=!0}else object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=z.visible;F.scene.addObject(object);F.objects[o]=object;if(z.meshCollider){var N=THREE.CollisionUtils.MeshColliderWBox(object);F.scene.collisions.colliders.push(N)}if(z.castsShadow){N=new THREE.ShadowVolume(G);F.scene.addChild(N);
N.position=object.position;N.rotation=object.rotation;N.scale=object.scale}z.trigger&&z.trigger.toLowerCase()!="none"&&(F.triggers[object.name]={type:z.trigger,object:z})}}else{n=z.position;r=z.rotation;q=z.quaternion;s=z.scale;q=0;object=new THREE.Object3D;object.name=o;object.position.set(n[0],n[1],n[2]);if(q){object.quaternion.set(q[0],q[1],q[2],q[3]);object.useQuaternion=!0}else object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=z.visible!==undefined?z.visible:
!1;F.scene.addObject(object);F.objects[o]=object;F.empties[o]=object}}}function j(N){return function(W){F.geometries[N]=W;h();R-=1;b.onLoadComplete();k()}}function l(N){return function(W){F.geometries[N]=W}}function k(){b.callbackProgress({totalModels:S,totalTextures:P,loadedModels:S-R,loadedTextures:P-O},F);b.onLoadProgress();R==0&&O==0&&d(F)}var m,p,o,y,x,v,u,z,n,A,B,G,K,J,H,D,L,R,O,S,P,F;D=f.data;f=new THREE.BinaryLoader;L=new THREE.JSONLoader;O=R=0;F={scene:new THREE.Scene,geometries:{},materials:{},
textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};var M=!1;for(o in D.objects){z=D.objects[o];if(z.meshCollider){M=!0;break}}if(M)F.scene.collisions=new THREE.CollisionSystem;if(D.transform){M=D.transform.position;A=D.transform.rotation;var Q=D.transform.scale;M&&F.scene.position.set(M[0],M[1],M[2]);A&&F.scene.rotation.set(A[0],A[1],A[2]);Q&&F.scene.scale.set(Q[0],Q[1],Q[2]);(M||A||Q)&&F.scene.updateMatrix()}M=function(){O-=1;k();b.onLoadComplete()};for(x in D.cameras){A=
D.cameras[x];if(A.type=="perspective")K=new THREE.Camera(A.fov,A.aspect,A.near,A.far);else if(A.type=="ortho"){K=new THREE.Camera;K.projectionMatrix=THREE.Matrix4.makeOrtho(A.left,A.right,A.top,A.bottom,A.near,A.far)}n=A.position;A=A.target;K.position.set(n[0],n[1],n[2]);K.target.position.set(A[0],A[1],A[2]);F.cameras[x]=K}for(y in D.lights){x=D.lights[y];K=x.color!==undefined?x.color:16777215;A=x.intensity!==undefined?x.intensity:1;if(x.type=="directional"){n=x.direction;light=new THREE.DirectionalLight(K,
A);light.position.set(n[0],n[1],n[2]);light.position.normalize()}else if(x.type=="point"){n=x.position;light=new THREE.PointLight(K,A);light.position.set(n[0],n[1],n[2])}F.scene.addLight(light);F.lights[y]=light}for(v in D.fogs){y=D.fogs[v];if(y.type=="linear")J=new THREE.Fog(0,y.near,y.far);else y.type=="exp2"&&(J=new THREE.FogExp2(0,y.density));A=y.color;J.color.setRGB(A[0],A[1],A[2]);F.fogs[v]=J}if(F.cameras&&D.defaults.camera)F.currentCamera=F.cameras[D.defaults.camera];if(F.fogs&&D.defaults.fog)F.scene.fog=
F.fogs[D.defaults.fog];A=D.defaults.bgcolor;F.bgColor=new THREE.Color;F.bgColor.setRGB(A[0],A[1],A[2]);F.bgColorAlpha=D.defaults.bgalpha;for(m in D.geometries){v=D.geometries[m];if(v.type=="bin_mesh"||v.type=="ascii_mesh"){R+=1;b.onLoadStart()}}S=R;for(m in D.geometries){v=D.geometries[m];if(v.type=="cube"){G=new THREE.Cube(v.width,v.height,v.depth,v.segmentsWidth,v.segmentsHeight,v.segmentsDepth,null,v.flipped,v.sides);F.geometries[m]=G}else if(v.type=="plane"){G=new THREE.Plane(v.width,v.height,
v.segmentsWidth,v.segmentsHeight);F.geometries[m]=G}else if(v.type=="sphere"){G=new THREE.Sphere(v.radius,v.segmentsWidth,v.segmentsHeight);F.geometries[m]=G}else if(v.type=="cylinder"){G=new THREE.Cylinder(v.numSegs,v.topRad,v.botRad,v.height,v.topOffset,v.botOffset);F.geometries[m]=G}else if(v.type=="torus"){G=new THREE.Torus(v.radius,v.tube,v.segmentsR,v.segmentsT);F.geometries[m]=G}else if(v.type=="icosahedron"){G=new THREE.Icosahedron(v.subdivisions);F.geometries[m]=G}else if(v.type=="bin_mesh")f.load({model:g(v.url,
D.urlBaseType),callback:j(m)});else if(v.type=="ascii_mesh")L.load({model:g(v.url,D.urlBaseType),callback:j(m)});else if(v.type=="embedded_mesh")(v=D.embeds[v.id])&&L.createModel(v,l(m),"")}for(u in D.textures){m=D.textures[u];if(m.url instanceof Array){O+=m.url.length;for(f=0;f<m.url.length;f++)b.onLoadStart()}else{O+=1;b.onLoadStart()}}P=O;for(u in D.textures){m=D.textures[u];if(m.mapping!=undefined&&THREE[m.mapping]!=undefined)m.mapping=new THREE[m.mapping];if(m.url instanceof Array){f=[];for(var U=
0;U<m.url.length;U++)f[U]=g(m.url[U],D.urlBaseType);f=THREE.ImageUtils.loadTextureCube(f,m.mapping,M)}else{f=THREE.ImageUtils.loadTexture(g(m.url,D.urlBaseType),m.mapping,M);if(THREE[m.minFilter]!=undefined)f.minFilter=THREE[m.minFilter];if(THREE[m.magFilter]!=undefined)f.magFilter=THREE[m.magFilter]}F.textures[u]=f}for(p in D.materials){u=D.materials[p];for(B in u.parameters)if(B=="envMap"||B=="map"||B=="lightMap")u.parameters[B]=F.textures[u.parameters[B]];else if(B=="shading")u.parameters[B]=u.parameters[B]==
"flat"?THREE.FlatShading:THREE.SmoothShading;else if(B=="blending")u.parameters[B]=THREE[u.parameters[B]]?THREE[u.parameters[B]]:THREE.NormalBlending;else if(B=="combine")u.parameters[B]=u.parameters[B]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(B=="vertexColors")if(u.parameters[B]=="face")u.parameters[B]=THREE.FaceColors;else if(u.parameters[B])u.parameters[B]=THREE.VertexColors;if(u.parameters.opacity!==undefined&&u.parameters.opacity<1)u.parameters.transparent=!0;u=new THREE[u.type](u.parameters);
F.materials[p]=u}h();b.callbackSync(F)}}};
THREE.MarchingCubes=function(a,d){THREE.Object3D.call(this);this.materials=d instanceof Array?d:[d];this.init=function(b){this.isolation=80;this.size=b;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(b,e,c){return b+(e-b)*c};this.VIntX=function(b,e,c,f,g,h,j,l,k,m){g=(g-k)/(m-k);k=this.normal_cache;e[f]=h+g*this.delta;e[f+1]=j;e[f+2]=l;c[f]=this.lerp(k[b],k[b+3],g);c[f+1]=this.lerp(k[b+1],k[b+4],g);c[f+2]=this.lerp(k[b+2],k[b+5],g)};this.VIntY=function(b,e,c,f,g,h,j,l,k,m){g=(g-k)/(m-k);k=this.normal_cache;e[f]=h;e[f+1]=j+g*this.delta;e[f+
2]=l;e=b+this.yd*3;c[f]=this.lerp(k[b],k[e],g);c[f+1]=this.lerp(k[b+1],k[e+1],g);c[f+2]=this.lerp(k[b+2],k[e+2],g)};this.VIntZ=function(b,e,c,f,g,h,j,l,k,m){g=(g-k)/(m-k);k=this.normal_cache;e[f]=h;e[f+1]=j;e[f+2]=l+g*this.delta;e=b+this.zd*3;c[f]=this.lerp(k[b],k[e],g);c[f+1]=this.lerp(k[b+1],k[e+1],g);c[f+2]=this.lerp(k[b+2],k[e+2],g)};this.compNorm=function(b){var e=b*3;if(this.normal_cache[e]==0){this.normal_cache[e]=this.field[b-1]-this.field[b+1];this.normal_cache[e+1]=this.field[b-this.yd]-
this.field[b+this.yd];this.normal_cache[e+2]=this.field[b-this.zd]-this.field[b+this.zd]}};this.polygonize=function(b,e,c,f,g,h){var j=f+1,l=f+this.yd,k=f+this.zd,m=j+this.yd,p=j+this.zd,o=f+this.yd+this.zd,y=j+this.yd+this.zd,x=0,v=this.field[f],u=this.field[j],z=this.field[l],n=this.field[m],A=this.field[k],B=this.field[p],G=this.field[o],K=this.field[y];v<g&&(x|=1);u<g&&(x|=2);z<g&&(x|=8);n<g&&(x|=4);A<g&&(x|=16);B<g&&(x|=32);G<g&&(x|=128);K<g&&(x|=64);var J=THREE.edgeTable[x];if(J==0)return 0;
var H=this.delta,D=b+H,L=e+H;H=c+H;if(J&1){this.compNorm(f);this.compNorm(j);this.VIntX(f*3,this.vlist,this.nlist,0,g,b,e,c,v,u)}if(J&2){this.compNorm(j);this.compNorm(m);this.VIntY(j*3,this.vlist,this.nlist,3,g,D,e,c,u,n)}if(J&4){this.compNorm(l);this.compNorm(m);this.VIntX(l*3,this.vlist,this.nlist,6,g,b,L,c,z,n)}if(J&8){this.compNorm(f);this.compNorm(l);this.VIntY(f*3,this.vlist,this.nlist,9,g,b,e,c,v,z)}if(J&16){this.compNorm(k);this.compNorm(p);this.VIntX(k*3,this.vlist,this.nlist,12,g,b,e,H,
A,B)}if(J&32){this.compNorm(p);this.compNorm(y);this.VIntY(p*3,this.vlist,this.nlist,15,g,D,e,H,B,K)}if(J&64){this.compNorm(o);this.compNorm(y);this.VIntX(o*3,this.vlist,this.nlist,18,g,b,L,H,G,K)}if(J&128){this.compNorm(k);this.compNorm(o);this.VIntY(k*3,this.vlist,this.nlist,21,g,b,e,H,A,G)}if(J&256){this.compNorm(f);this.compNorm(k);this.VIntZ(f*3,this.vlist,this.nlist,24,g,b,e,c,v,A)}if(J&512){this.compNorm(j);this.compNorm(p);this.VIntZ(j*3,this.vlist,this.nlist,27,g,D,e,c,u,B)}if(J&1024){this.compNorm(m);
this.compNorm(y);this.VIntZ(m*3,this.vlist,this.nlist,30,g,D,L,c,n,K)}if(J&2048){this.compNorm(l);this.compNorm(o);this.VIntZ(l*3,this.vlist,this.nlist,33,g,b,L,c,z,G)}x<<=4;for(g=f=0;THREE.triTable[x+g]!=-1;){b=x+g;e=b+1;c=b+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[b],3*THREE.triTable[e],3*THREE.triTable[c],h);g+=3;f++}return f};this.posnormtriv=function(b,e,c,f,g,h){var j=this.count*3;this.positionArray[j]=b[c];this.positionArray[j+1]=b[c+1];this.positionArray[j+2]=b[c+2];this.positionArray[j+
3]=b[f];this.positionArray[j+4]=b[f+1];this.positionArray[j+5]=b[f+2];this.positionArray[j+6]=b[g];this.positionArray[j+7]=b[g+1];this.positionArray[j+8]=b[g+2];this.normalArray[j]=e[c];this.normalArray[j+1]=e[c+1];this.normalArray[j+2]=e[c+2];this.normalArray[j+3]=e[f];this.normalArray[j+4]=e[f+1];this.normalArray[j+5]=e[f+2];this.normalArray[j+6]=e[g];this.normalArray[j+7]=e[g+1];this.normalArray[j+8]=e[g+2];this.hasPos=!0;this.hasNormal=!0;this.count+=3;this.count>=this.maxCount-3&&h(this)};this.begin=
function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(b){if(this.count!=0){for(var e=this.count*3;e<this.positionArray.length;e++)this.positionArray[e]=0;b(this)}};this.addBall=function(b,e,c,f,g){var h=this.size*Math.sqrt(f/g),j=c*this.size,l=e*this.size,k=b*this.size,m=Math.floor(j-h);m<1&&(m=1);j=Math.floor(j+h);j>this.size-1&&(j=this.size-1);var p=Math.floor(l-h);p<1&&(p=1);l=Math.floor(l+h);l>this.size-1&&(l=this.size-1);var o=Math.floor(k-h);o<1&&(o=1);h=Math.floor(k+h);
h>this.size-1&&(h=this.size-1);for(var y,x,v,u,z,n;m<j;m++){k=this.size2*m;x=m/this.size-c;z=x*x;for(x=p;x<l;x++){v=k+this.size*x;y=x/this.size-e;n=y*y;for(y=o;y<h;y++){u=y/this.size-b;u=f/(1.0E-6+u*u+n+z)-g;u>0&&(this.field[v+y]+=u)}}}};this.addPlaneX=function(b,e){var c,f,g,h,j,l=this.size,k=this.yd,m=this.zd,p=this.field,o=l*Math.sqrt(b/e);o>l&&(o=l);for(c=0;c<o;c++){f=c/l;f*=f;h=b/(1.0E-4+f)-e;if(h>0)for(f=0;f<l;f++){j=c+f*k;for(g=0;g<l;g++)p[m*g+j]+=h}}};this.addPlaneY=function(b,e){var c,f,
g,h,j,l,k=this.size,m=this.yd,p=this.zd,o=this.field,y=k*Math.sqrt(b/e);y>k&&(y=k);for(f=0;f<y;f++){c=f/k;c*=c;h=b/(1.0E-4+c)-e;if(h>0){j=f*m;for(c=0;c<k;c++){l=j+c;for(g=0;g<k;g++)o[p*g+l]+=h}}}};this.addPlaneZ=function(b,e){var c,f,g,h,j,l;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(b/e);dist>size&&(dist=size);for(g=0;g<dist;g++){c=g/size;c*=c;h=b/(1.0E-4+c)-e;if(h>0){j=zd*g;for(f=0;f<size;f++){l=j+f*yd;for(c=0;c<size;c++)field[l+c]+=h}}}};this.reset=function(){var b;
for(b=0;b<this.size3;b++){this.normal_cache[b*3]=0;this.field[b]=0}};this.render=function(b){this.begin();var e,c,f,g,h,j,l,k,m,p=this.size-2;for(g=1;g<p;g++){m=this.size2*g;l=(g-this.halfsize)/this.halfsize;for(f=1;f<p;f++){k=m+this.size*f;j=(f-this.halfsize)/this.halfsize;for(c=1;c<p;c++){h=(c-this.halfsize)/this.halfsize;e=k+c;this.polygonize(h,j,l,e,this.isolation,b)}}}this.end(b)};this.generateGeometry=function(){var b=0,e=new THREE.Geometry,c=[];this.render(function(f){var g,h,j,l,k,m,p,o;for(g=
0;g<f.count;g++){p=g*3;k=p+1;o=p+2;h=f.positionArray[p];j=f.positionArray[k];l=f.positionArray[o];m=new THREE.Vector3(h,j,l);h=f.normalArray[p];j=f.normalArray[k];l=f.normalArray[o];p=new THREE.Vector3(h,j,l);p.normalize();k=new THREE.Vertex(m);e.vertices.push(k);c.push(p)}nfaces=f.count/3;for(g=0;g<nfaces;g++){p=(b+g)*3;k=p+1;o=p+2;m=c[p];h=c[k];j=c[o];p=new THREE.Face3(p,k,o,[m,h,j]);e.faces.push(p)}b+=nfaces;f.count=0});return e};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;
THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.Trident=function(a){function d(f){return new THREE.Mesh(new THREE.Cylinder(30,0.1,a.length/20,a.length/5),new THREE.MeshBasicMaterial({color:f}))}function b(f,g){var h=new THREE.Geometry;h.vertices=[new THREE.Vertex,new THREE.Vertex(f)];return new THREE.Line(h,new THREE.LineBasicMaterial({color:g}))}THREE.Object3D.call(this);var e=Math.PI/2,c;a=a||THREE.Trident.defaultParams;if(a!==THREE.Trident.defaultParams)for(c in THREE.Trident.defaultParams)a.hasOwnProperty(c)||(a[c]=THREE.Trident.defaultParams[c]);
this.scale=new THREE.Vector3(a.scale,a.scale,a.scale);this.addChild(b(new THREE.Vector3(a.length,0,0),a.xAxisColor));this.addChild(b(new THREE.Vector3(0,a.length,0),a.yAxisColor));this.addChild(b(new THREE.Vector3(0,0,a.length),a.zAxisColor));if(a.showArrows){c=d(a.xAxisColor);c.rotation.y=-e;c.position.x=a.length;this.addChild(c);c=d(a.yAxisColor);c.rotation.x=e;c.position.y=a.length;this.addChild(c);c=d(a.zAxisColor);c.rotation.y=Math.PI;c.position.z=a.length;this.addChild(c)}};
THREE.Trident.prototype=new THREE.Object3D;THREE.Trident.prototype.constructor=THREE.Trident;THREE.Trident.defaultParams={xAxisColor:16711680,yAxisColor:65280,zAxisColor:255,showArrows:!0,length:100,scale:1};THREE.PlaneCollider=function(a,d){this.point=a;this.normal=d};THREE.SphereCollider=function(a,d){this.center=a;this.radius=d;this.radiusSq=d*d};THREE.BoxCollider=function(a,d){this.min=a;this.max=d;this.dynamic=!0;this.normal=new THREE.Vector3};
THREE.MeshCollider=function(a,d,b,e){this.vertices=a;this.faces=d;this.normals=b;this.box=e;this.numFaces=this.faces.length;this.normal=new THREE.Vector3};THREE.CollisionSystem=function(){this.collisionNormal=new THREE.Vector3;this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;THREE.CollisionSystem.prototype.merge=function(a){this.colliders=this.colliders.concat(a.colliders);this.hits=this.hits.concat(a.hits)};
THREE.CollisionSystem.prototype.rayCastAll=function(a){a.direction.normalize();this.hits.length=0;var d,b,e,c,f=0;d=0;for(b=this.colliders.length;d<b;d++){c=this.colliders[d];e=this.rayCast(a,c);if(e<Number.MAX_VALUE){c.distance=e;e>f?this.hits.push(c):this.hits.unshift(c);f=e}}return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(a){var d=this.rayCastAll(a);if(d.length==0)return null;for(var b=0;d[b]instanceof THREE.MeshCollider;){var e=this.rayMesh(a,d[b]);if(e<Number.MAX_VALUE){d[b].distance=e;break}b++}if(b>d.length)return null;return d[b]};
THREE.CollisionSystem.prototype.rayCast=function(a,d){if(d instanceof THREE.PlaneCollider)return this.rayPlane(a,d);else if(d instanceof THREE.SphereCollider)return this.raySphere(a,d);else if(d instanceof THREE.BoxCollider)return this.rayBox(a,d);else if(d instanceof THREE.MeshCollider&&d.box)return this.rayBox(a,d.box)};
THREE.CollisionSystem.prototype.rayMesh=function(a,d){for(var b=this.makeRayLocal(a,d.mesh),e=Number.MAX_VALUE,c=0;c<d.numFaces/3;c++){var f=c*3;f=this.rayTriangle(b,d.vertices[d.faces[f+0]],d.vertices[d.faces[f+1]],d.vertices[d.faces[f+2]],e,this.collisionNormal);if(f<e){e=f;d.normal.copy(this.collisionNormal);d.normal.normalize()}}return e};
THREE.CollisionSystem.prototype.rayTriangle=function(a,d,b,e,c,f){var g=THREE.CollisionSystem.__v1,h=THREE.CollisionSystem.__v2;f.set(0,0,0);g.sub(b,d);h.sub(e,b);f.cross(g,h);h=f.dot(a.direction);if(!(h<0))return Number.MAX_VALUE;g=f.dot(d)-f.dot(a.origin);if(!(g<=0))return Number.MAX_VALUE;if(!(g>=h*c))return Number.MAX_VALUE;g/=h;h=THREE.CollisionSystem.__v3;h.copy(a.direction);h.multiplyScalar(g);h.addSelf(a.origin);if(Math.abs(f.x)>Math.abs(f.y))if(Math.abs(f.x)>Math.abs(f.z)){a=h.y-d.y;f=b.y-
d.y;c=e.y-d.y;h=h.z-d.z;b=b.z-d.z;e=e.z-d.z}else{a=h.x-d.x;f=b.x-d.x;c=e.x-d.x;h=h.y-d.y;b=b.y-d.y;e=e.y-d.y}else if(Math.abs(f.y)>Math.abs(f.z)){a=h.x-d.x;f=b.x-d.x;c=e.x-d.x;h=h.z-d.z;b=b.z-d.z;e=e.z-d.z}else{a=h.x-d.x;f=b.x-d.x;c=e.x-d.x;h=h.y-d.y;b=b.y-d.y;e=e.y-d.y}d=f*e-b*c;if(d==0)return Number.MAX_VALUE;d=1/d;e=(a*e-h*c)*d;if(!(e>=0))return Number.MAX_VALUE;d*=f*h-b*a;if(!(d>=0))return Number.MAX_VALUE;if(!(1-e-d>=0))return Number.MAX_VALUE;return g};
THREE.CollisionSystem.prototype.makeRayLocal=function(a,d){var b=THREE.CollisionSystem.__m;THREE.Matrix4.makeInvert(d.matrixWorld,b);var e=THREE.CollisionSystem.__r;e.origin.copy(a.origin);e.direction.copy(a.direction);b.multiplyVector3(e.origin);b.rotateAxis(e.direction);e.direction.normalize();return e};
THREE.CollisionSystem.prototype.rayBox=function(a,d){var b;if(d.dynamic&&d.mesh&&d.mesh.matrixWorld)b=this.makeRayLocal(a,d.mesh);else{b=THREE.CollisionSystem.__r;b.origin.copy(a.origin);b.direction.copy(a.direction)}var e=0,c=0,f=0,g=0,h=0,j=0,l=!0;if(b.origin.x<d.min.x){e=d.min.x-b.origin.x;e/=b.direction.x;l=!1;g=-1}else if(b.origin.x>d.max.x){e=d.max.x-b.origin.x;e/=b.direction.x;l=!1;g=1}if(b.origin.y<d.min.y){c=d.min.y-b.origin.y;c/=b.direction.y;l=!1;h=-1}else if(b.origin.y>d.max.y){c=d.max.y-
b.origin.y;c/=b.direction.y;l=!1;h=1}if(b.origin.z<d.min.z){f=d.min.z-b.origin.z;f/=b.direction.z;l=!1;j=-1}else if(b.origin.z>d.max.z){f=d.max.z-b.origin.z;f/=b.direction.z;l=!1;j=1}if(l)return-1;l=0;if(c>e){l=1;e=c}if(f>e){l=2;e=f}switch(l){case 0:h=b.origin.y+b.direction.y*e;if(h<d.min.y||h>d.max.y)return Number.MAX_VALUE;b=b.origin.z+b.direction.z*e;if(b<d.min.z||b>d.max.z)return Number.MAX_VALUE;d.normal.set(g,0,0);break;case 1:g=b.origin.x+b.direction.x*e;if(g<d.min.x||g>d.max.x)return Number.MAX_VALUE;
b=b.origin.z+b.direction.z*e;if(b<d.min.z||b>d.max.z)return Number.MAX_VALUE;d.normal.set(0,h,0);break;case 2:g=b.origin.x+b.direction.x*e;if(g<d.min.x||g>d.max.x)return Number.MAX_VALUE;h=b.origin.y+b.direction.y*e;if(h<d.min.y||h>d.max.y)return Number.MAX_VALUE;d.normal.set(0,0,j)}return e};THREE.CollisionSystem.prototype.rayPlane=function(a,d){var b=a.direction.dot(d.normal),e=d.point.dot(d.normal);if(b<0)b=(e-a.origin.dot(d.normal))/b;else return Number.MAX_VALUE;return b>0?b:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(a,d){var b=d.center.clone().subSelf(a.origin);if(b.lengthSq<d.radiusSq)return-1;var e=b.dot(a.direction.clone());if(e<=0)return Number.MAX_VALUE;b=d.radiusSq-(b.lengthSq()-e*e);if(b>=0)return Math.abs(e)-Math.sqrt(b);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionSystem.__nr=new THREE.Vector3;THREE.CollisionSystem.__m=new THREE.Matrix4;
THREE.CollisionSystem.__r=new THREE.Ray;THREE.CollisionUtils={};THREE.CollisionUtils.MeshOBB=function(a){a.geometry.computeBoundingBox();var d=a.geometry.boundingBox,b=new THREE.Vector3(d.x[0],d.y[0],d.z[0]);d=new THREE.Vector3(d.x[1],d.y[1],d.z[1]);b=new THREE.BoxCollider(b,d);b.mesh=a;return b};THREE.CollisionUtils.MeshAABB=function(a){var d=THREE.CollisionUtils.MeshOBB(a);d.min.addSelf(a.position);d.max.addSelf(a.position);d.dynamic=!1;return d};
THREE.CollisionUtils.MeshColliderWBox=function(a){for(var d=a.geometry.vertices,b=d.length,e=a.geometry.faces,c=e.length,f=[],g=[],h=[],j=0;j<b;j++)f.push(new THREE.Vector3(d[j].position.x,d[j].position.y,d[j].position.z));for(j=0;j<c;j++){g.push(e[j].a,e[j].b,e[j].c);h.push(new THREE.Vector3(e[j].normal.x,e[j].normal.y,e[j].normal.z))}d=new THREE.MeshCollider(f,g,h,THREE.CollisionUtils.MeshOBB(a));d.mesh=a;return d};
