// ThreeCanvas.js r40 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex;this.__styleString=a.__styleString},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,c){this.h=a;this.s=b;this.v=c;var d,e,h,f,k,g;if(c==0)d=e=h=0;else{f=Math.floor(a*6);k=a*6-f;a=c*(1-b);g=c*(1-b*k);b=c*(1-b*(1-k));switch(f){case 1:d=g;e=c;h=a;break;case 2:d=a;e=c;h=b;break;case 3:d=a;e=g;h=c;break;case 4:d=b;e=
a;h=c;break;case 5:d=c;e=a;h=g;break;case 6:case 0:d=c;e=b;h=a}}this.r=d;this.g=e;this.b=h;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},updateHSV:function(){this.v=this.s=this.h=0;var a=Math.max(Math.max(this.r,this.g),this.b),b=Math.min(Math.min(this.r,this.g),this.b),c;if(b==a)b=c=0;else{c=a-b;b=c/a;c=this.r==a?(this.g-this.b)/c:this.g==a?2+(this.b-this.r)/c:4+(this.r-this.g)/c;c/=6;c<0&&(c+=1);c>1&&(c-=1)}this.h=c;this.s=b;this.v=a},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();
this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.set(c*a.z-d*a.y,d*a.x-b*a.z,b*a.y-c*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);if(Math.abs(b)>1.0E-5){this.x=Math.atan2(-a.n23/b,a.n33/b);this.z=Math.atan2(-a.n12/b,a.n11/b)}else{this.x=0;this.z=Math.atan2(a.n21,a.n22)}},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<
1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,c,d=a.objects,e=[];a=0;for(b=d.length;a<b;a++){c=d[a];c instanceof THREE.Mesh&&(e=e.concat(this.intersectObject(c)))}e.sort(function(h,f){return h.distance-f.distance});return e},intersectObject:function(a){function b(D,z,T,U){U=U.clone().subSelf(z);T=T.clone().subSelf(z);var X=D.clone().subSelf(z);D=U.dot(U);z=U.dot(T);U=U.dot(X);var s=T.dot(T);T=T.dot(X);X=1/(D*s-z*z);s=(s*U-z*T)*X;D=(D*T-z*U)*X;return s>0&&D>0&&s+D<1}var c,d,e,h,f,k,g,i,n,j,
p,r=a.geometry,y=r.vertices,A=[];c=0;for(d=r.faces.length;c<d;c++){e=r.faces[c];j=this.origin.clone();p=this.direction.clone();g=a.matrixWorld;h=g.multiplyVector3(y[e.a].position.clone());f=g.multiplyVector3(y[e.b].position.clone());k=g.multiplyVector3(y[e.c].position.clone());g=e instanceof THREE.Face4?g.multiplyVector3(y[e.d].position.clone()):null;i=a.matrixRotationWorld.multiplyVector3(e.normal.clone());n=p.dot(i);if(a.doubleSided||(a.flipSided?n>0:n<0)){i=i.dot((new THREE.Vector3).sub(h,j))/
n;j=j.addSelf(p.multiplyScalar(i));if(e instanceof THREE.Face3){if(b(j,h,f,k)){e={distance:this.origin.distanceTo(j),point:j,face:e,object:a};A.push(e)}}else if(e instanceof THREE.Face4&&(b(j,h,f,g)||b(j,f,k,g))){e={distance:this.origin.distanceTo(j),point:j,face:e,object:a};A.push(e)}}}return A}};
THREE.Rectangle=function(){function a(){h=d-b;f=e-c}var b,c,d,e,h,f,k=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return h};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(g,i,n,j){k=!1;b=g;c=i;d=n;e=j;a()};this.addPoint=function(g,i){if(k){k=!1;b=g;c=i;d=g;e=i}else{b=b<g?b:g;c=c<i?c:i;d=d>g?d:g;e=e>i?e:i}a()};
this.add3Points=function(g,i,n,j,p,r){if(k){k=!1;b=g<n?g<p?g:p:n<p?n:p;c=i<j?i<r?i:r:j<r?j:r;d=g>n?g>p?g:p:n>p?n:p;e=i>j?i>r?i:r:j>r?j:r}else{b=g<n?g<p?g<b?g:b:p<b?p:b:n<p?n<b?n:b:p<b?p:b;c=i<j?i<r?i<c?i:c:r<c?r:c:j<r?j<c?j:c:r<c?r:c;d=g>n?g>p?g>d?g:d:p>d?p:d:n>p?n>d?n:d:p>d?p:d;e=i>j?i>r?i>e?i:e:r>e?r:e:j>r?j>e?j:e:r>e?r:e}a()};this.addRectangle=function(g){if(k){k=!1;b=g.getLeft();c=g.getTop();d=g.getRight();e=g.getBottom()}else{b=b<g.getLeft()?b:g.getLeft();c=c<g.getTop()?c:g.getTop();d=d>g.getRight()?
d:g.getRight();e=e>g.getBottom()?e:g.getBottom()}a()};this.inflate=function(g){b-=g;c-=g;d+=g;e+=g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();d=d<g.getRight()?d:g.getRight();e=e<g.getBottom()?e:g.getBottom();a()};this.instersects=function(g){return Math.min(d,g.getRight())-Math.max(b,g.getLeft())>=0&&Math.min(e,g.getBottom())-Math.max(c,g.getTop())>=0};this.empty=function(){k=!0;e=d=c=b=0;a()};this.isEmpty=function(){return k}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,h,f,k,g,i,n,j,p,r,y,A){this.set(a||1,b||0,c||0,d||0,e||0,h||1,f||0,k||0,g||0,i||0,n||1,j||0,p||0,r||0,y||0,A||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,h,f,k,g,i,n,j,p,r,y,A){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=h;this.n23=f;this.n24=k;this.n31=g;this.n32=i;this.n33=n;this.n34=j;this.n41=p;this.n42=r;this.n43=y;this.n44=A;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__v1,
e=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(a,b).normalize();if(h.length()===0)h.z=1;d.cross(c,h).normalize();if(d.length()===0){h.x+=1.0E-4;d.cross(c,h).normalize()}e.cross(h,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=h.x;this.n21=d.y;this.n22=e.y;this.n23=h.y;this.n31=d.z;this.n32=e.z;this.n33=h.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*
d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,h=a.n14,f=a.n21,k=a.n22,g=a.n23,i=a.n24,n=a.n31,j=a.n32,p=a.n33,r=a.n34,y=a.n41,A=a.n42,D=a.n43,z=a.n44,T=b.n11,U=b.n12,X=b.n13,s=b.n14,o=b.n21,L=b.n22,
R=b.n23,aa=b.n24,ba=b.n31,w=b.n32,u=b.n33,H=b.n34;this.n11=c*T+d*o+e*ba;this.n12=c*U+d*L+e*w;this.n13=c*X+d*R+e*u;this.n14=c*s+d*aa+e*H+h;this.n21=f*T+k*o+g*ba;this.n22=f*U+k*L+g*w;this.n23=f*X+k*R+g*u;this.n24=f*s+k*aa+g*H+i;this.n31=n*T+j*o+p*ba;this.n32=n*U+j*L+p*w;this.n33=n*X+j*R+p*u;this.n34=n*s+j*aa+p*H+r;this.n41=y*T+A*o+D*ba;this.n42=y*U+A*L+D*w;this.n43=y*X+A*R+D*u;this.n44=y*s+A*aa+D*H+z;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;
c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=
this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,h=this.n22,f=this.n23,k=this.n24,g=this.n31,i=this.n32,n=this.n33,j=this.n34,p=this.n41,r=this.n42,y=this.n43,A=this.n44;return d*f*i*p-c*k*i*p-d*h*n*p+b*k*n*p+c*h*j*p-b*f*j*p-d*f*g*r+c*k*g*r+d*e*n*r-a*k*n*r-c*e*j*r+a*f*j*r+d*h*g*y-b*k*g*y-d*e*i*y+a*k*i*y+b*e*j*y-a*h*j*y-c*h*g*A+b*f*g*A+c*e*i*A-a*f*i*A-b*e*n*A+a*h*n*A},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=
this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;
this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=
this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,
b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,h=a.x,f=a.y,k=a.z,g=e*h,i=e*f;this.set(g*
h+c,g*f-d*k,g*k+d*f,0,g*f+d*k,i*f+c,i*k-d*h,0,g*k-d*f,i*k+d*h,e*k*k+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;
this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z;a=Math.cos(b);b=Math.sin(b);var e=Math.cos(c);c=Math.sin(c);var h=Math.cos(d);d=Math.sin(d);var f=a*c,k=b*c;this.n11=e*h;this.n12=-e*d;this.n13=c;this.n21=k*h+a*d;this.n22=-k*d+a*h;this.n23=-b*e;this.n31=-f*h+b*d;this.n32=f*d+b*h;this.n33=a*e;return this},
setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,h=b+b,f=c+c,k=d+d;a=b*h;var g=b*f;b*=k;var i=c*f;c*=k;d*=k;h*=e;f*=e;e*=k;this.n11=1-(i+d);this.n12=g-e;this.n13=b+f;this.n21=g+e;this.n22=1-(a+d);this.n23=c-h;this.n31=b-f;this.n32=c+h;this.n33=1-(a+i);return this},scale:function(a){var b=a.x,c=a.y;a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=
a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,h=a.n14,f=a.n21,k=a.n22,g=a.n23,i=a.n24,n=a.n31,j=a.n32,p=a.n33,r=a.n34,y=a.n41,A=a.n42,D=a.n43,z=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=g*r*A-i*p*A+i*j*D-k*r*D-g*j*z+k*p*z;b.n12=h*p*A-e*r*A-h*j*D+d*r*D+e*j*z-d*p*z;b.n13=e*i*A-h*g*A+h*k*D-d*i*D-e*k*z+d*g*z;b.n14=h*g*j-e*i*j-h*k*p+d*i*p+e*k*r-d*g*r;b.n21=i*p*y-g*r*y-i*n*D+f*r*D+g*n*z-f*p*z;b.n22=e*r*y-h*p*y+h*n*D-c*r*D-e*n*z+c*p*z;b.n23=h*g*y-e*i*y-h*f*D+c*i*D+e*f*z-c*g*z;
b.n24=e*i*n-h*g*n+h*f*p-c*i*p-e*f*r+c*g*r;b.n31=k*r*y-i*j*y+i*n*A-f*r*A-k*n*z+f*j*z;b.n32=h*j*y-d*r*y-h*n*A+c*r*A+d*n*z-c*j*z;b.n33=e*i*y-h*k*y+h*f*A-c*i*A-d*f*z+c*k*z;b.n34=h*k*n-d*i*n-h*f*j+c*i*j+d*f*r-c*k*r;b.n41=g*j*y-k*p*y-g*n*A+f*p*A+k*n*D-f*j*D;b.n42=d*p*y-e*j*y+e*n*A-c*p*A-d*n*D+c*j*D;b.n43=e*k*y-d*g*y-e*f*A+c*g*A+d*f*D-c*k*D;b.n44=d*g*n-e*k*n+e*f*j-c*g*j-d*f*p+c*k*p;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,h=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,k=a.n33*a.n11-a.n31*a.n13,g=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,n=-a.n23*a.n11+a.n21*a.n13,j=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*f+a.n31*i;if(a==0)throw"matrix not invertible";a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*h;c[3]=a*f;c[4]=a*k;c[5]=a*g;c[6]=a*i;c[7]=a*n;c[8]=a*j;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,h){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(h+e)/(h-e);f.n34=-2*h*e/(h-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e;a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,h){var f,k,g,i;f=new THREE.Matrix4;k=b-a;g=c-d;i=h-e;f.n11=2/k;f.n12=0;f.n13=0;f.n14=-((b+a)/k);f.n21=0;f.n22=2/g;f.n23=0;f.n24=-((c+d)/g);f.n31=0;f.n32=0;f.n33=-2/i;f.n34=-((h+e)/i);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=undefined;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixAutoUpdate=!0;this.matrixWorldNeedsUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=
!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==undefined;)b=b.parent;b!==undefined&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a)return e;if(b){e=e.getChildByName(a,b);if(e!==undefined)return e}}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale);this.matrixWorldNeedsUpdate=!1;b=!0}a=0;for(var d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b;a=Math.cos(d);d=Math.sin(d);b=Math.cos(-e);e=Math.sin(-e);var h=Math.cos(c);c=Math.sin(c);var f=a*b,k=d*e;this.w=f*h-k*c;this.x=f*c+k*h;this.y=d*b*h+a*e*c;this.z=a*e*h-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=
a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},
multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,h=a.x,f=a.y,k=a.z;a=a.w;this.x=b*a+e*h+c*k-d*f;this.y=c*a+e*f+d*h-b*k;this.z=d*a+e*k+b*f-c*h;this.w=e*a-b*h-c*f-d*k;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,h=this.x,f=this.y,k=this.z,g=this.w,i=g*c+f*e-k*d,n=
g*d+k*c-h*e,j=g*e+h*d-f*c;c=-h*c-f*d-k*e;b.x=i*g+c*-h+n*-k-j*-f;b.y=n*g+c*-f+j*-h-i*-k;b.z=j*g+c*-k+i*-f-n*-h;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var h=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}e=Math.sin((1-d)*h)/f;d=Math.sin(d*h)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,h){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,h,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,c,d,e,h,f,k=new THREE.Vector3,g=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){h=this.faces[d];if(a&&h.vertexNormals.length){k.set(0,0,0);b=0;for(c=h.vertexNormals.length;b<c;b++)k.addSelf(h.vertexNormals[b]);k.divideScalar(3)}else{b=this.vertices[h.a];c=this.vertices[h.b];f=this.vertices[h.c];k.sub(f.position,c.position);g.sub(b.position,c.position);k.crossSelf(g)}k.isZero()||
k.normalize();h.normal.copy(k)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);
c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeTangents:function(){function a(E,O,S,V,F,Y,B){k=E.vertices[O].position;g=E.vertices[S].position;i=E.vertices[V].position;n=f[F];j=f[Y];p=f[B];r=g.x-k.x;y=i.x-k.x;A=g.y-k.y;D=i.y-k.y;z=g.z-k.z;T=i.z-k.z;U=j.u-n.u;X=p.u-n.u;s=j.v-n.v;o=p.v-n.v;L=1/(U*o-X*s);w.set((o*
r-s*y)*L,(o*A-s*D)*L,(o*z-s*T)*L);u.set((U*y-X*r)*L,(U*D-X*A)*L,(U*T-X*z)*L);aa[O].addSelf(w);aa[S].addSelf(w);aa[V].addSelf(w);ba[O].addSelf(u);ba[S].addSelf(u);ba[V].addSelf(u)}var b,c,d,e,h,f,k,g,i,n,j,p,r,y,A,D,z,T,U,X,s,o,L,R,aa=[],ba=[],w=new THREE.Vector3,u=new THREE.Vector3,H=new THREE.Vector3,M=new THREE.Vector3,P=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++){aa[b]=new THREE.Vector3;ba[b]=new THREE.Vector3}b=0;for(c=this.faces.length;b<c;b++){h=this.faces[b];f=this.faceVertexUvs[0][b];
if(h instanceof THREE.Face3)a(this,h.a,h.b,h.c,0,1,2);else if(h instanceof THREE.Face4){a(this,h.a,h.b,h.c,0,1,2);a(this,h.a,h.b,h.d,0,1,3)}}var I=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){h=this.faces[b];for(d=0;d<h.vertexNormals.length;d++){P.copy(h.vertexNormals[d]);e=h[I[d]];R=aa[e];H.copy(R);H.subSelf(P.multiplyScalar(P.dot(R))).normalize();M.cross(h.vertexNormals[d],R);e=M.dot(ba[e]);e=e<0?-1:1;h.vertexTangents[d]=new THREE.Vector4(H.x,H.y,H.z,e)}}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(g,i){return Math.min(g,
i)+"_"+Math.max(g,i)}function b(g,i,n){if(g[i]===undefined){g[i]={set:{},array:[]};g[i].set[n]=1;g[i].array.push(n)}else if(g[i].set[n]===undefined){g[i].set[n]=1;g[i].array.push(n)}}var c,d,e,h,f,k={};c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];if(f instanceof THREE.Face3){e=a(f.a,f.b);b(k,e,c);e=a(f.b,f.c);b(k,e,c);e=a(f.a,f.c);b(k,e,c)}else if(f instanceof THREE.Face4){e=a(f.b,f.d);b(k,e,c);e=a(f.a,f.b);b(k,e,c);e=a(f.a,f.d);b(k,e,c);e=a(f.b,f.c);b(k,e,c);e=a(f.c,f.d);b(k,e,c)}}c=0;for(d=
this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];h=f.vertexIndices[1];f.faceIndices=k[a(e,h)].array;for(e=0;e<f.faceIndices.length;e++){h=f.faceIndices[e];f.faces.push(this.faces[h])}}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};
THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a));this.target.position.addSelf(b.multiplyScalar(a))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);this.matrix.setPosition(this.position);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&this.updateMatrix();if(b||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=
!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==undefined?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.Material=function(a){this.id=THREE.MaterialCounter.value++;a=a||{};this.opacity=a.opacity!==undefined?a.opacity:1;this.transparent=a.transparent!==undefined?a.transparent:!1;this.blending=a.blending!==undefined?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==undefined?a.depthTest:!0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;
THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==undefined?a.linewidth:1;this.linecap=a.linecap!==undefined?a.linecap:"round";this.linejoin=a.linejoin!==undefined?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=
a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?
a.morphTargets:!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=
a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?
a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==undefined?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==undefined?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==undefined?a.shininess:30;this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?
a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=
a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.size=a.size!==undefined?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==undefined?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==undefined?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,h){this.image=a;this.mapping=b!==undefined?b:new THREE.UVMapping;this.wrapS=c!==undefined?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==undefined?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==undefined?e:THREE.LinearFilter;this.minFilter=h!==undefined?h:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};
THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;
THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++){this.morphTargetInfluences.push(0);this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==undefined)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;b=!0}var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var e;c=this.sources.length;for(a=0;a<c;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)e=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)e="audio/ogg";else b.indexOf(".wav")!==-1&&(e="audio/wav");if(this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;b=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a)}for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);if(b!==-1){this.objects.splice(b,1);this.__objectsRemoved.push(a)}}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var w=g[k]=g[k]||new THREE.RenderableVertex;k++;return w}function b(w,u){return u.z-w.z}function c(w,u){var H=0,M=1,P=w.z+w.w,I=u.z+u.w,E=-w.z+w.w,O=-u.z+u.w;if(P>=0&&I>=0&&E>=0&&O>=0)return!0;else if(P<0&&I<0||E<0&&O<0)return!1;else{if(P<0)H=Math.max(H,P/(P-I));else I<0&&(M=Math.min(M,P/(P-I)));if(E<0)H=Math.max(H,E/(E-O));else O<0&&(M=Math.min(M,E/(E-O)));if(M<H)return!1;else{w.lerpSelf(u,H);u.lerpSelf(w,1-M);return!0}}}var d,e,h=[],f,k,g=[],i,n,j=[],p,r=
[],y,A,D=[],z,T,U=[],X=new THREE.Vector4,s=new THREE.Vector4,o=new THREE.Matrix4,L=new THREE.Matrix4,R=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],aa=new THREE.Vector4,ba=new THREE.Vector4;this.projectVector=function(w,u){o.multiply(u.projectionMatrix,u.matrixWorldInverse);o.multiplyVector3(w);return w};this.unprojectVector=function(w,u){o.multiply(u.matrixWorld,THREE.Matrix4.makeInvert(u.projectionMatrix));o.multiplyVector3(w);return w};
this.projectObjects=function(w,u,H){u=[];var M,P,I;e=0;P=w.objects;w=0;for(M=P.length;w<M;w++){I=P[w];var E;if(!(E=!I.visible))if(E=I instanceof THREE.Mesh){a:{E=void 0;for(var O=I.matrixWorld,S=-I.geometry.boundingSphere.radius*Math.max(I.scale.x,Math.max(I.scale.y,I.scale.z)),V=0;V<6;V++){E=R[V].x*O.n14+R[V].y*O.n24+R[V].z*O.n34+R[V].w;if(E<=S){E=!1;break a}}E=!0}E=!E}if(!E){E=h[e]=h[e]||new THREE.RenderableObject;e++;d=E;X.copy(I.position);o.multiplyVector3(X);d.object=I;d.z=X.z;u.push(d)}}H&&
u.sort(b);return u};this.projectScene=function(w,u,H){var M=[],P=u.near,I=u.far,E,O,S,V,F,Y,B,Q,K,C,Z,ia,ma,ja,ca,Da,wa;T=A=p=n=0;u.matrixAutoUpdate&&u.update(undefined,!0);w.update(undefined,!1,u);o.multiply(u.projectionMatrix,u.matrixWorldInverse);R[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);R[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);R[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);R[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);R[4].set(o.n41-o.n31,
o.n42-o.n32,o.n43-o.n33,o.n44-o.n34);R[5].set(o.n41+o.n31,o.n42+o.n32,o.n43+o.n33,o.n44+o.n34);for(E=0;E<6;E++){K=R[E];K.divideScalar(Math.sqrt(K.x*K.x+K.y*K.y+K.z*K.z))}K=this.projectObjects(w,u,!0);w=0;for(E=K.length;w<E;w++){C=K[w].object;if(C.visible){Z=C.matrixWorld;ia=C.matrixRotationWorld;ma=C.materials;ja=C.overdraw;k=0;if(C instanceof THREE.Mesh){ca=C.geometry;V=ca.vertices;Da=ca.faces;ca=ca.faceVertexUvs;O=0;for(S=V.length;O<S;O++){f=a();f.positionWorld.copy(V[O].position);Z.multiplyVector3(f.positionWorld);
f.positionScreen.copy(f.positionWorld);o.multiplyVector4(f.positionScreen);f.positionScreen.x/=f.positionScreen.w;f.positionScreen.y/=f.positionScreen.w;f.visible=f.positionScreen.z>P&&f.positionScreen.z<I}V=0;for(O=Da.length;V<O;V++){S=Da[V];if(S instanceof THREE.Face3){F=g[S.a];Y=g[S.b];B=g[S.c];if(F.visible&&Y.visible&&B.visible&&(C.doubleSided||C.flipSided!=(B.positionScreen.x-F.positionScreen.x)*(Y.positionScreen.y-F.positionScreen.y)-(B.positionScreen.y-F.positionScreen.y)*(Y.positionScreen.x-
F.positionScreen.x)<0)){Q=j[n]=j[n]||new THREE.RenderableFace3;n++;i=Q;i.v1.copy(F);i.v2.copy(Y);i.v3.copy(B)}else continue}else if(S instanceof THREE.Face4){F=g[S.a];Y=g[S.b];B=g[S.c];Q=g[S.d];if(F.visible&&Y.visible&&B.visible&&Q.visible&&(C.doubleSided||C.flipSided!=((Q.positionScreen.x-F.positionScreen.x)*(Y.positionScreen.y-F.positionScreen.y)-(Q.positionScreen.y-F.positionScreen.y)*(Y.positionScreen.x-F.positionScreen.x)<0||(Y.positionScreen.x-B.positionScreen.x)*(Q.positionScreen.y-B.positionScreen.y)-
(Y.positionScreen.y-B.positionScreen.y)*(Q.positionScreen.x-B.positionScreen.x)<0))){wa=r[p]=r[p]||new THREE.RenderableFace4;p++;i=wa;i.v1.copy(F);i.v2.copy(Y);i.v3.copy(B);i.v4.copy(Q)}else continue}i.normalWorld.copy(S.normal);ia.multiplyVector3(i.normalWorld);i.centroidWorld.copy(S.centroid);Z.multiplyVector3(i.centroidWorld);i.centroidScreen.copy(i.centroidWorld);o.multiplyVector3(i.centroidScreen);B=S.vertexNormals;F=0;for(Y=B.length;F<Y;F++){Q=i.vertexNormalsWorld[F];Q.copy(B[F]);ia.multiplyVector3(Q)}F=
0;for(Y=ca.length;F<Y;F++)if(wa=ca[F][V]){B=0;for(Q=wa.length;B<Q;B++)i.uvs[F][B]=wa[B]}i.meshMaterials=ma;i.faceMaterials=S.materials;i.overdraw=ja;i.z=i.centroidScreen.z;M.push(i)}}else if(C instanceof THREE.Line){L.multiply(o,Z);V=C.geometry.vertices;F=a();F.positionScreen.copy(V[0].position);L.multiplyVector4(F.positionScreen);O=1;for(S=V.length;O<S;O++){F=a();F.positionScreen.copy(V[O].position);L.multiplyVector4(F.positionScreen);Y=g[k-2];aa.copy(F.positionScreen);ba.copy(Y.positionScreen);
if(c(aa,ba)){aa.multiplyScalar(1/aa.w);ba.multiplyScalar(1/ba.w);Z=D[A]=D[A]||new THREE.RenderableLine;A++;y=Z;y.v1.positionScreen.copy(aa);y.v2.positionScreen.copy(ba);y.z=Math.max(aa.z,ba.z);y.materials=C.materials;M.push(y)}}}else if(C instanceof THREE.Particle){s.set(C.matrixWorld.n14,C.matrixWorld.n24,C.matrixWorld.n34,1);o.multiplyVector4(s);s.z/=s.w;if(s.z>0&&s.z<1){Z=U[T]=U[T]||new THREE.RenderableParticle;T++;z=Z;z.x=s.x/s.w;z.y=s.y/s.w;z.z=s.z;z.rotation=C.rotation.z;z.scale.x=C.scale.x*
Math.abs(z.x-(s.x+u.projectionMatrix.n11)/(s.w+u.projectionMatrix.n14));z.scale.y=C.scale.y*Math.abs(z.y-(s.y+u.projectionMatrix.n22)/(s.w+u.projectionMatrix.n24));z.materials=C.materials;M.push(z)}}}}H&&M.sort(b);return M}};
THREE.CanvasRenderer=function(){function a($){if(y!=$)j.globalAlpha=y=$}function b($){if(A!=$){switch($){case THREE.NormalBlending:j.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:j.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:j.globalCompositeOperation="darker"}A=$}}function c($){if(D!=$)j.strokeStyle=D=$}var d=this,e=null,h=new THREE.Projector,f=document.createElement("canvas"),k,g,i,n,j=f.getContext("2d"),p=new THREE.Color(0),r=0,y=1,A=0,D=null,
z=null,T=null,U=null,X=null,s,o,L,R,aa=new THREE.RenderableVertex,ba=new THREE.RenderableVertex,w,u,H,M,P,I,E,O,S,V,F,Y,B=new THREE.Color,Q=new THREE.Color,K=new THREE.Color,C=new THREE.Color,Z=new THREE.Color,ia,ma,ja,ca,Da,wa,Wa,Xa,Ya,Za,Ba=new THREE.Rectangle,ka=new THREE.Rectangle,fa=new THREE.Rectangle,Ua=!1,ha=new THREE.Color,ga=new THREE.Color,Ma=new THREE.Color,Na=new THREE.Color,da=new THREE.Vector3,Ha,Ia,Va,la,Ja,Oa,Ea=16;Ha=document.createElement("canvas");Ha.width=Ha.height=2;Ia=Ha.getContext("2d");
Ia.fillStyle="rgba(0,0,0,1)";Ia.fillRect(0,0,2,2);Va=Ia.getImageData(0,0,2,2);la=Va.data;Ja=document.createElement("canvas");Ja.width=Ja.height=Ea;Oa=Ja.getContext("2d");Oa.translate(-Ea/2,-Ea/2);Oa.scale(Ea,Ea);Ea--;this.domElement=f;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.data={vertices:0,faces:0};this.setSize=function($,na){k=$;g=na;i=k/2;n=g/2;f.width=k;f.height=g;Ba.set(-i,-n,i,n);y=1;A=0;X=U=T=z=D=null};this.setClearColor=function($,na){p=$;r=na};this.setClearColorHex=
function($,na){p.setHex($);r=na};this.clear=function(){j.setTransform(1,0,0,-1,i,n);if(!ka.isEmpty()){ka.inflate(1);ka.minSelf(Ba);if(p.hex==0&&r==0)j.clearRect(ka.getX(),ka.getY(),ka.getWidth(),ka.getHeight());else{b(THREE.NormalBlending);a(1);j.fillStyle="rgba("+Math.floor(p.r*255)+","+Math.floor(p.g*255)+","+Math.floor(p.b*255)+","+r+")";j.fillRect(ka.getX(),ka.getY(),ka.getWidth(),ka.getHeight())}ka.empty()}};this.render=function($,na){function bb(m){var x,t,q,J=m.lights;ga.setRGB(0,0,0);Ma.setRGB(0,
0,0);Na.setRGB(0,0,0);m=0;for(x=J.length;m<x;m++){t=J[m];q=t.color;if(t instanceof THREE.AmbientLight){ga.r+=q.r;ga.g+=q.g;ga.b+=q.b}else if(t instanceof THREE.DirectionalLight){Ma.r+=q.r;Ma.g+=q.g;Ma.b+=q.b}else if(t instanceof THREE.PointLight){Na.r+=q.r;Na.g+=q.g;Na.b+=q.b}}}function ra(m,x,t,q){var J,G,v,l,W=m.lights;m=0;for(J=W.length;m<J;m++){G=W[m];v=G.color;if(G instanceof THREE.DirectionalLight){l=t.dot(G.position);if(!(l<=0)){l*=G.intensity;q.r+=v.r*l;q.g+=v.g*l;q.b+=v.b*l}}else if(G instanceof
THREE.PointLight){l=t.dot(da.sub(G.position,x).normalize());if(!(l<=0)){l*=G.distance==0?1:1-Math.min(x.distanceTo(G.position)/G.distance,1);if(l!=0){l*=G.intensity;q.r+=v.r*l;q.g+=v.g*l;q.b+=v.b*l}}}}}function cb(m,x,t){a(t.opacity);b(t.blending);var q,J,G,v,l,W;if(t instanceof THREE.ParticleBasicMaterial){if(t.map){v=t.map.image;l=v.width>>1;W=v.height>>1;t=x.scale.x*i;G=x.scale.y*n;q=t*l;J=G*W;fa.set(m.x-q,m.y-J,m.x+q,m.y+J);if(Ba.instersects(fa)){j.save();j.translate(m.x,m.y);j.rotate(-x.rotation);
j.scale(t,-G);j.translate(-l,-W);j.drawImage(v,0,0);j.restore()}}}else if(t instanceof THREE.ParticleCanvasMaterial){q=x.scale.x*i;J=x.scale.y*n;fa.set(m.x-q,m.y-J,m.x+q,m.y+J);if(Ba.instersects(fa)){c(t.color.__styleString);G=t.color.__styleString;if(z!=G)j.fillStyle=z=G;j.save();j.translate(m.x,m.y);j.rotate(-x.rotation);j.scale(q,J);t.program(j);j.restore()}}}function db(m,x,t,q){a(q.opacity);b(q.blending);j.beginPath();j.moveTo(m.positionScreen.x,m.positionScreen.y);j.lineTo(x.positionScreen.x,
x.positionScreen.y);j.closePath();if(q instanceof THREE.LineBasicMaterial){B.__styleString=q.color.__styleString;m=q.linewidth;if(T!=m)j.lineWidth=T=m;m=q.linecap;if(U!=m)j.lineCap=U=m;m=q.linejoin;if(X!=m)j.lineJoin=X=m;c(B.__styleString);j.stroke();fa.inflate(q.linewidth*2)}}function Pa(m,x,t,q,J,G,v,l,W){d.data.vertices+=3;d.data.faces++;a(l.opacity);b(l.blending);w=m.positionScreen.x;u=m.positionScreen.y;H=x.positionScreen.x;M=x.positionScreen.y;P=t.positionScreen.x;I=t.positionScreen.y;Ka(w,
u,H,M,P,I);if(l instanceof THREE.MeshBasicMaterial)if(l.map){if(l.map.mapping instanceof THREE.UVMapping){ca=v.uvs[0];sa(w,u,H,M,P,I,l.map.image,ca[q].u,ca[q].v,ca[J].u,ca[J].v,ca[G].u,ca[G].v)}}else if(l.envMap){if(l.envMap.mapping instanceof THREE.SphericalReflectionMapping){m=na.matrixWorldInverse;da.copy(v.vertexNormalsWorld[0]);Da=(da.x*m.n11+da.y*m.n12+da.z*m.n13)*0.5+0.5;wa=-(da.x*m.n21+da.y*m.n22+da.z*m.n23)*0.5+0.5;da.copy(v.vertexNormalsWorld[1]);Wa=(da.x*m.n11+da.y*m.n12+da.z*m.n13)*0.5+
0.5;Xa=-(da.x*m.n21+da.y*m.n22+da.z*m.n23)*0.5+0.5;da.copy(v.vertexNormalsWorld[2]);Ya=(da.x*m.n11+da.y*m.n12+da.z*m.n13)*0.5+0.5;Za=-(da.x*m.n21+da.y*m.n22+da.z*m.n23)*0.5+0.5;sa(w,u,H,M,P,I,l.envMap.image,Da,wa,Wa,Xa,Ya,Za)}}else l.wireframe?xa(l.color.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(l.color.__styleString);else if(l instanceof THREE.MeshLambertMaterial){if(l.map&&!l.wireframe){if(l.map.mapping instanceof THREE.UVMapping){ca=v.uvs[0];sa(w,u,H,M,P,I,l.map.image,
ca[q].u,ca[q].v,ca[J].u,ca[J].v,ca[G].u,ca[G].v)}b(THREE.SubtractiveBlending)}if(Ua)if(!l.wireframe&&l.shading==THREE.SmoothShading&&v.vertexNormalsWorld.length==3){Q.r=K.r=C.r=ga.r;Q.g=K.g=C.g=ga.g;Q.b=K.b=C.b=ga.b;ra(W,v.v1.positionWorld,v.vertexNormalsWorld[0],Q);ra(W,v.v2.positionWorld,v.vertexNormalsWorld[1],K);ra(W,v.v3.positionWorld,v.vertexNormalsWorld[2],C);Z.r=(K.r+C.r)*0.5;Z.g=(K.g+C.g)*0.5;Z.b=(K.b+C.b)*0.5;ja=Qa(Q,K,C,Z);sa(w,u,H,M,P,I,ja,0,0,1,0,0,1)}else{ha.r=ga.r;ha.g=ga.g;ha.b=ga.b;
ra(W,v.centroidWorld,v.normalWorld,ha);B.r=l.color.r*ha.r;B.g=l.color.g*ha.g;B.b=l.color.b*ha.b;B.updateStyleString();l.wireframe?xa(B.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(B.__styleString)}else l.wireframe?xa(l.color.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(l.color.__styleString)}else if(l instanceof THREE.MeshDepthMaterial){ia=na.near;ma=na.far;Q.r=Q.g=Q.b=1-Ca(m.positionScreen.z,ia,ma);K.r=K.g=K.b=1-Ca(x.positionScreen.z,
ia,ma);C.r=C.g=C.b=1-Ca(t.positionScreen.z,ia,ma);Z.r=(K.r+C.r)*0.5;Z.g=(K.g+C.g)*0.5;Z.b=(K.b+C.b)*0.5;ja=Qa(Q,K,C,Z);sa(w,u,H,M,P,I,ja,0,0,1,0,0,1)}else if(l instanceof THREE.MeshNormalMaterial){B.r=Fa(v.normalWorld.x);B.g=Fa(v.normalWorld.y);B.b=Fa(v.normalWorld.z);B.updateStyleString();l.wireframe?xa(B.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(B.__styleString)}}function $a(m,x,t,q,J,G,v,l,W){d.data.vertices+=4;d.data.faces++;a(l.opacity);b(l.blending);if(l.map||
l.envMap){Pa(m,x,q,0,1,3,v,l,W);Pa(J,t,G,1,2,3,v,l,W)}else{w=m.positionScreen.x;u=m.positionScreen.y;H=x.positionScreen.x;M=x.positionScreen.y;P=t.positionScreen.x;I=t.positionScreen.y;E=q.positionScreen.x;O=q.positionScreen.y;S=J.positionScreen.x;V=J.positionScreen.y;F=G.positionScreen.x;Y=G.positionScreen.y;if(l instanceof THREE.MeshBasicMaterial){Ra(w,u,H,M,P,I,E,O);l.wireframe?xa(l.color.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(l.color.__styleString)}else if(l instanceof
THREE.MeshLambertMaterial)if(Ua)if(!l.wireframe&&l.shading==THREE.SmoothShading&&v.vertexNormalsWorld.length==4){Q.r=K.r=C.r=Z.r=ga.r;Q.g=K.g=C.g=Z.g=ga.g;Q.b=K.b=C.b=Z.b=ga.b;ra(W,v.v1.positionWorld,v.vertexNormalsWorld[0],Q);ra(W,v.v2.positionWorld,v.vertexNormalsWorld[1],K);ra(W,v.v4.positionWorld,v.vertexNormalsWorld[3],C);ra(W,v.v3.positionWorld,v.vertexNormalsWorld[2],Z);ja=Qa(Q,K,C,Z);Ka(w,u,H,M,E,O);sa(w,u,H,M,E,O,ja,0,0,1,0,0,1);Ka(S,V,P,I,F,Y);sa(S,V,P,I,F,Y,ja,1,0,1,1,0,1)}else{ha.r=ga.r;
ha.g=ga.g;ha.b=ga.b;ra(W,v.centroidWorld,v.normalWorld,ha);B.r=l.color.r*ha.r;B.g=l.color.g*ha.g;B.b=l.color.b*ha.b;B.updateStyleString();Ra(w,u,H,M,P,I,E,O);l.wireframe?xa(B.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(B.__styleString)}else{Ra(w,u,H,M,P,I,E,O);l.wireframe?xa(l.color.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(l.color.__styleString)}else if(l instanceof THREE.MeshNormalMaterial){B.r=Fa(v.normalWorld.x);B.g=Fa(v.normalWorld.y);
B.b=Fa(v.normalWorld.z);B.updateStyleString();Ra(w,u,H,M,P,I,E,O);l.wireframe?xa(B.__styleString,l.wireframeLinewidth,l.wireframeLinecap,l.wireframeLinejoin):ya(B.__styleString)}else if(l instanceof THREE.MeshDepthMaterial){ia=na.near;ma=na.far;Q.r=Q.g=Q.b=1-Ca(m.positionScreen.z,ia,ma);K.r=K.g=K.b=1-Ca(x.positionScreen.z,ia,ma);C.r=C.g=C.b=1-Ca(q.positionScreen.z,ia,ma);Z.r=Z.g=Z.b=1-Ca(t.positionScreen.z,ia,ma);ja=Qa(Q,K,C,Z);Ka(w,u,H,M,E,O);sa(w,u,H,M,E,O,ja,0,0,1,0,0,1);Ka(S,V,P,I,F,Y);sa(S,V,
P,I,F,Y,ja,1,0,1,1,0,1)}}}function Ka(m,x,t,q,J,G){j.beginPath();j.moveTo(m,x);j.lineTo(t,q);j.lineTo(J,G);j.lineTo(m,x);j.closePath()}function Ra(m,x,t,q,J,G,v,l){j.beginPath();j.moveTo(m,x);j.lineTo(t,q);j.lineTo(J,G);j.lineTo(v,l);j.lineTo(m,x);j.closePath()}function xa(m,x,t,q){if(T!=x)j.lineWidth=T=x;if(U!=t)j.lineCap=U=t;if(X!=q)j.lineJoin=X=q;c(m);j.stroke();fa.inflate(x*2)}function ya(m){if(z!=m)j.fillStyle=z=m;j.fill()}function sa(m,x,t,q,J,G,v,l,W,ta,oa,ua,La){var qa,va;qa=v.width-1;va=
v.height-1;l*=qa;W*=va;ta*=qa;oa*=va;ua*=qa;La*=va;t-=m;q-=x;J-=m;G-=x;ta-=l;oa-=W;ua-=l;La-=W;qa=ta*La-ua*oa;if(qa!=0){va=1/qa;qa=(La*t-oa*J)*va;oa=(La*q-oa*G)*va;t=(ta*J-ua*t)*va;q=(ta*G-ua*q)*va;m=m-qa*l-t*W;x=x-oa*l-q*W;j.save();j.transform(qa,oa,t,q,m,x);j.clip();j.drawImage(v,0,0);j.restore()}}function Qa(m,x,t,q){var J=~~(m.r*255),G=~~(m.g*255);m=~~(m.b*255);var v=~~(x.r*255),l=~~(x.g*255);x=~~(x.b*255);var W=~~(t.r*255),ta=~~(t.g*255);t=~~(t.b*255);var oa=~~(q.r*255),ua=~~(q.g*255);q=~~(q.b*
255);la[0]=J<0?0:J>255?255:J;la[1]=G<0?0:G>255?255:G;la[2]=m<0?0:m>255?255:m;la[4]=v<0?0:v>255?255:v;la[5]=l<0?0:l>255?255:l;la[6]=x<0?0:x>255?255:x;la[8]=W<0?0:W>255?255:W;la[9]=ta<0?0:ta>255?255:ta;la[10]=t<0?0:t>255?255:t;la[12]=oa<0?0:oa>255?255:oa;la[13]=ua<0?0:ua>255?255:ua;la[14]=q<0?0:q>255?255:q;Ia.putImageData(Va,0,0);Oa.drawImage(Ha,0,0);return Ja}function Ca(m,x,t){m=(m-x)/(t-x);return m*m*(3-2*m)}function Fa(m){m=(m+1)*0.5;return m<0?0:m>1?1:m}function za(m,x){var t=x.x-m.x,q=x.y-m.y,
J=1/Math.sqrt(t*t+q*q);t*=J;q*=J;x.x+=t;x.y+=q;m.x-=t;m.y-=q}var Sa,ab,N,pa,Aa,Ga,Ta,ea;this.autoClear?this.clear():j.setTransform(1,0,0,-1,i,n);d.data.vertices=0;d.data.faces=0;e=h.projectScene($,na,this.sortElements);(Ua=$.lights.length>0)&&bb($);Sa=0;for(ab=e.length;Sa<ab;Sa++){N=e[Sa];fa.empty();if(N instanceof THREE.RenderableParticle){s=N;s.x*=i;s.y*=n;pa=0;for(Aa=N.materials.length;pa<Aa;){ea=N.materials[pa++];ea.opacity!=0&&cb(s,N,ea,$)}}else if(N instanceof THREE.RenderableLine){s=N.v1;o=
N.v2;s.positionScreen.x*=i;s.positionScreen.y*=n;o.positionScreen.x*=i;o.positionScreen.y*=n;fa.addPoint(s.positionScreen.x,s.positionScreen.y);fa.addPoint(o.positionScreen.x,o.positionScreen.y);if(Ba.instersects(fa)){pa=0;for(Aa=N.materials.length;pa<Aa;){ea=N.materials[pa++];ea.opacity!=0&&db(s,o,N,ea,$)}}}else if(N instanceof THREE.RenderableFace3){s=N.v1;o=N.v2;L=N.v3;s.positionScreen.x*=i;s.positionScreen.y*=n;o.positionScreen.x*=i;o.positionScreen.y*=n;L.positionScreen.x*=i;L.positionScreen.y*=
n;if(N.overdraw){za(s.positionScreen,o.positionScreen);za(o.positionScreen,L.positionScreen);za(L.positionScreen,s.positionScreen)}fa.add3Points(s.positionScreen.x,s.positionScreen.y,o.positionScreen.x,o.positionScreen.y,L.positionScreen.x,L.positionScreen.y);if(Ba.instersects(fa)){pa=0;for(Aa=N.meshMaterials.length;pa<Aa;){ea=N.meshMaterials[pa++];if(ea instanceof THREE.MeshFaceMaterial){Ga=0;for(Ta=N.faceMaterials.length;Ga<Ta;)(ea=N.faceMaterials[Ga++])&&ea.opacity!=0&&Pa(s,o,L,0,1,2,N,ea,$)}else ea.opacity!=
0&&Pa(s,o,L,0,1,2,N,ea,$)}}}else if(N instanceof THREE.RenderableFace4){s=N.v1;o=N.v2;L=N.v3;R=N.v4;s.positionScreen.x*=i;s.positionScreen.y*=n;o.positionScreen.x*=i;o.positionScreen.y*=n;L.positionScreen.x*=i;L.positionScreen.y*=n;R.positionScreen.x*=i;R.positionScreen.y*=n;aa.positionScreen.copy(o.positionScreen);ba.positionScreen.copy(R.positionScreen);if(N.overdraw){za(s.positionScreen,o.positionScreen);za(o.positionScreen,R.positionScreen);za(R.positionScreen,s.positionScreen);za(L.positionScreen,
aa.positionScreen);za(L.positionScreen,ba.positionScreen)}fa.addPoint(s.positionScreen.x,s.positionScreen.y);fa.addPoint(o.positionScreen.x,o.positionScreen.y);fa.addPoint(L.positionScreen.x,L.positionScreen.y);fa.addPoint(R.positionScreen.x,R.positionScreen.y);if(Ba.instersects(fa)){pa=0;for(Aa=N.meshMaterials.length;pa<Aa;){ea=N.meshMaterials[pa++];if(ea instanceof THREE.MeshFaceMaterial){Ga=0;for(Ta=N.faceMaterials.length;Ga<Ta;)(ea=N.faceMaterials[Ga++])&&ea.opacity!=0&&$a(s,o,L,R,aa,ba,N,ea,
$)}else ea.opacity!=0&&$a(s,o,L,R,aa,ba,N,ea,$)}}}ka.addRectangle(fa)}j.setTransform(1,0,0,1,0,0)}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(undefined,!1,b);c=a.sounds;var d,e=c.length;for(d=0;d<e;d++){a=c[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
