import type { NextPage } from 'next'
import Head from 'next/head'
import { Editor } from '@bytemd/react'
import pluginGfm from '@bytemd/plugin-gfm'
import styles from '../styles/Home.module.css'
import { useMemo, useState } from 'react'

const Home: NextPage = () => {
  const [value, setValue] = useState('')
  const plugins = useMemo(() => [pluginGfm()], [])

  return (
    <div className={styles.container}>
      <Head>
        <title>Create Next App</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      {/* <Viewer value="abc" /> */}

      <Editor
        value={value}
        plugins={plugins}
        uploadImages={async (files) => {
          // upload images here
          return [
            {
              url: 'https://picsum.photos/200/300',
            },
          ]
        }}
        onChange={(v) => {
          setValue(v)
        }}
      />
    </div>
  )
}

export default Home
