# Contributing to OCamlFormat

## Reporting Issues

If you encounter a problem when using ocamlformat or if you have any questions, please open a [GitHub issue](https://github.com/ocaml-ppx/ocamlformat/issues/).

- [ ] Check first if your issue has already been [reported](https://github.com/ocaml-ppx/ocamlformat/issues/).
- [ ] Include the version of ocamlformat you are using (`ocamlformat --version`).
- [ ] Include a (preferably short) source file which demonstrates the issue.
- [ ] Describe the expected and actual behavior.

## Pull Requests

We actively welcome pull requests.

1. Fork the repository and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. Ensure the test suite passes.
4. If you haven't already, complete the Contributor License Agreement ("CLA").

Prior to investing a large amount of time into significant or invasive changes, or those that affect the output, it is likely more efficient to first open an issue for discussion and planning.

## Contributor License Agreement ("CLA")

In order to accept your pull request, we need you to submit a CLA. You only need to do this once to work on any of Facebook's open source projects. Complete your CLA here: <https://code.facebook.com/cla>. If you have any questions, please drop us a line at cla@fb.com.

## License

By contributing to OCamlFormat, you agree that your contributions will be licensed under the LICENSE file in the root directory of this source tree.
