# pdf

This directory contains the script and related resources to generate a PDF copy of tldr pages.

## Preview

![aa](https://user-images.githubusercontent.com/29029116/35637791-4e42af80-06db-11e8-8b8e-42ce6c905ff4.jpg)
![bb](https://user-images.githubusercontent.com/29029116/35637798-51e3784a-06db-11e8-9576-6e57ef5c5c20.jpg)
![cc](https://user-images.githubusercontent.com/29029116/35637801-54449fce-06db-11e8-93f7-d90cdc34044b.jpg)

## Highlights

- No LaTeX dependencies for generating the PDF.

- 3 available color-schemes- *Basic*, *Solarized Light* and *Solarized Dark*. More can be added easily through CSS.


## Requirements

The PDF is generated by first converting the markdown files to HTML, and then rendering those HTML files as PDF. It depends on the following libraries:

#### Python-Markdown

    pip3 install markdown
    
#### WeasyPrint

    pip3 install WeasyPrint
    
Make sure OS specific dependencies for WeasyPrint are installed by following the instructions [here](http://weasyprint.readthedocs.io/en/latest/install.html).

## Usage

Generating the PDF is as simple as running

    python3 render.py <path-to-pages-directory> -c <color-scheme>
    
Complete information about the arguments can be viewed by running 

    python3 render.py --help

The color-schemes that can be specified are

* `solarized-light`
* `solarized-dark`

    

