# git submodule

> Inspects, updates and manages submodules.
> Homepage: <https://git-scm.com/docs/git-submodule>.

- Install a repository's specified submodules:

`git submodule update --init --recursive`

- Add a git repository as a submodule:

`git submodule add {{repository_url}}`

- Add a git repository as a submodule at the specified directory:

`git submodule add {{repository_url}} {{path/to/directory}}`

- Update every submodule to its latest commit:

`git submodule foreach git pull`
